<?php
/*
Copyright (c) 2007-2011 The web2Project Development Team <w2p-developers@web2project.net>
Copyright (c) 2003-2007 The dotProject Development Team <core-developers@dotproject.net>
Copyright [2011] -  Srgio Fernandes Reinert de Lima - INPI 11802-5
Este arquivo  parte do programa gpweb
O gpweb  um software livre; voc pode redistribu-lo e/ou modific-lo dentro dos termos da Licena Pblica Geral GNU como publicada pela Fundao do Software Livre (FSF); na verso 2 da Licena.
Este programa  distribudo na esperana que possa ser  til, mas SEM NENHUMA GARANTIA; sem uma garantia implcita de ADEQUAO a qualquer  MERCADO ou APLICAO EM PARTICULAR. Veja a Licena Pblica Geral GNU/GPL em portugus para maiores detalhes.
Voc deve ter recebido uma cpia da Licena Pblica Geral GNU, sob o ttulo "licena GPL 2.odt", junto com este programa, se no, acesse o Portal do Software Pblico Brasileiro no endereo www.softwarepublico.gov.br ou escreva para a Fundao do Software Livre(FSF) Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301, USA
*/


global $checar_existe;

header("Content-Type: text/html; charset=ISO-8859-1", true);

if (!ini_get('safe_mode')){
  @set_time_limit(0);
  @ignore_user_abort(true);
	}

require_once '../base.php';

if (is_file('../config.php')) require_once '../config.php';
if (!isset($config['militar'])) require_once 'config-dist.php';

include_once 'checar_atualizar.php';
require_once BASE_DIR.'/estilo/rondon/funcao_grafica.php';
require_once BASE_DIR.'/incluir/funcoes_principais.php';


$tipoCia = (isset($_REQUEST['tipoCia']) ? instalacao_getParametro($_REQUEST, 'tipoCia', null)  : $config['militar']);
$militar=$tipoCia;

checarDBMultiplo($config);

$profissional=file_exists(BASE_DIR.'/modulos/projetos/tarefa_cache.class_pro.php');

if ($_REQUEST['modo'] == 'instalar' && checarAtualizacao($config) == 'atualizar') die ('Checagem de Segurana: O gpweb aparentemente j est configurado.Configurao cancelada! ');
$baseUrl = ( isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] != 'off') ? 'https://' : 'http://';
$baseUrl .= isset($_SERVER['HTTP_HOST']) ? $_SERVER['HTTP_HOST'] : getenv('HTTP_HOST');
$baseUrl .= isset($_SERVER['SCRIPT_NAME']) ? dirname(dirname(previnirXSS($_SERVER['SCRIPT_NAME']))) : dirname(dirname(getenv('SCRIPT_NAME')));
require_once BASE_DIR.'/codigo/instalacao.inc.php';
$msgBD = '';
$msgCArquivo = 'No Criado';
$erroBD = false;
$erroCArquivo = false;

$atualizacao = instalacao_getParametro($_REQUEST, 'modo', 'atualizar');

if (!$atualizacao){
  $dbdrop = instalacao_getParametro($_REQUEST, 'dbdrop', false);
  $fazer_bd =instalacao_getParametro($_REQUEST, 'fazer_bd', null);
  $fazer_bd_cfg = instalacao_getParametro($_REQUEST, 'fazer_bd_cfg', null);
  $fazer_cfg = instalacao_getParametro($_REQUEST, 'fazer_cfg', null);
  $tipoBd = trim(instalacao_getParametro( $_REQUEST, 'tipoBd', 'mysql'));
  $hospedadoBd = trim(instalacao_getParametro( $_REQUEST, 'hospedadoBd', ''));
  $nomeBd = trim(instalacao_getParametro( $_REQUEST, 'nomeBd', ''));
  $prefixoBd = trim(instalacao_getParametro( $_REQUEST, 'prefixoBd', ''));
  $usuarioBd = trim( instalacao_getParametro( $_REQUEST, 'usuarioBd', 'root'));
  $senhaBd = trim(instalacao_getParametro( $_REQUEST, 'senhaBd', ''));
  $persistenteBd = instalacao_getParametro($_REQUEST, 'persistenteBd', false);
  $exemplo = instalacao_getParametro($_REQUEST, 'exemplo', false);
  $treino = instalacao_getParametro($_REQUEST, 'treino', false);
  $areas = instalacao_getParametro($_REQUEST, 'areas', false);
  $restrito = instalacao_getParametro($_REQUEST, 'restrito', false);
  $bronze = instalacao_getParametro($_REQUEST, 'bronze', false);
  $tem_data_limite = instalacao_getParametro($_REQUEST, 'tem_data_limite', false);
  $data = instalacao_getParametro($_REQUEST, 'data', false);

  $config = array('tipoBd' => $tipoBd, 'hospedadoBd' => $hospedadoBd, 'nomeBd' => $nomeBd, 'prefixoBd' => $prefixoBd, 'usuarioBd' => $usuarioBd, 'senhaBd' => $senhaBd, 'persistenteBd' => $persistenteBd);
	}
else{
  $hospedadoBd=$config['hospedadoBd'];
  $usuarioBd=$config['usuarioBd'];
  $senhaBd=$config['senhaBd'];
  $nomeBd=$config['nomeBd'];
  $tipoBd=$config['tipoBd'];
  $fazer_bd=1;
  $fazer_bd_cfg=0;
  $fazer_cfg=0;
  $exemplo=0;
  $treino=0;
  $areas=0;
  $restrito=0;
  $bronze=0;
	}

$caminhoVersao = array('1.0.0');

require_once( BASE_DIR.'/lib/adodb/adodb.inc.php');
@include_once BASE_DIR.'/incluir/versao.php';
$bd = NewADOConnection(get_nome_driver_database($tipoBd));
if(!empty($bd)) {
  $dbc = $bd->Connect($hospedadoBd,$usuarioBd,$senhaBd);
  if ($dbc) $bd_existente = $bd->SelectDB($nomeBd);
	}
else $dbc = false;
$bd->Execute('SET NAMES latin1;');
$bd->Execute('SET CHARACTER SET latin1;');
$bd->Execute('SET character_set_connection latin1;');
//no usa ANSI mode
$bd->Execute("SET sql_mode := ''");
$versao_atual = $_versao_maior.'.'.$_versao_menor.'.'.$_versao_revisao;

$localidade_tipo_caract='iso-8859-1';

if (!$checar_existe){

echo '<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">';
echo '<head>';
echo '<meta name="Description" content="gpweb Default Style" />';
echo '<meta http-equiv="Content-Type" content="text/html;charset=iso-8859-1" />';
echo '<title>'.(isset($config['gpweb']) ? $config['gpweb'] : 'gpweb').'</title>';
echo '<link rel="stylesheet" type="text/css" href="../estilo/rondon/estilo_'.(isset($config['estilo_css']) ? $config['estilo_css'] : 'metro').'.css" media="all" />';
echo '<style type="text/css" media="all">@import "../estilo/rondon/estilo_'.(isset($config['estilo_css']) ? $config['estilo_css'] : 'metro').'.css";</style>';
echo '<link rel="shortcut icon" href="../estilo/rondon/imagens/organizacao/'.(isset($config['militar']) && $config['militar']==11 ? 11 : 10).'/favicon.ico" type="image/ico" />';
echo '<script type="text/javascript" src="../lib/mootools/mootools.js"></script>';
echo '</head>';
}

echo '<body>';

echo '<table width="100%" cellspacing=0 cellpadding=0 border=0><tr><td align=center>'.dica('Site do Sistema', 'Clique para entrar no site oficial do Sistema.').'<a href="http://www.sistemagpweb.com" target="_blank"><img border=0 alt="gpweb" src="../estilo/rondon/imagens/organizacao/'.(isset($config['militar']) && $config['militar']==11 ? 11 : 10).'/gpweb_logo.png"/></a>'.dicaF().'</td></tr><tr><td>&nbsp;</td></tr></table>';
echo '<table width="95%" cellspacing=0 cellpadding=0 border=0 align="center"><tr><td colspan="2">'.estiloTopoCaixa('100%','../').'</td></tr><tr><td>';
echo '<table cellspacing="6" cellpadding="3" border=0 class="std" align="center" width="100%">';
echo '<tr><td><h1>Instalao do '.(isset($config['gpweb']) ? $config['gpweb'] : 'gpweb').'</h1></td></tr>';
echo '<tr class="title"><td>Progresso:</td></tr>';
echo '<tr><td><pre>';
if (($fazer_bd || $fazer_bd_cfg)) {
	if($dbc){
		if (!$atualizacao){
			msg('Excluindo a base de dados anterior, caso exista.');
			$bd->Execute('DROP DATABASE IF EXISTS `'.$nomeBd.'`');
			$bd_existente = false;
			msg('Criando uma nova base de dados');
			$bd->Execute('CREATE DATABASE `'.$nomeBd.'` DEFAULT CHARACTER SET latin1 DEFAULT COLLATE latin1_swedish_ci');
			$erroBd = $bd->ErrorNo();
			if ($erroBd != 0 && $erroBd != 1007) {
				$erroBD = true;
				$msgBD .= 'Um erro no Banco de Dados ocorreu. Base de dados no foi criada! Os parmetros para a base de dados provavelmente esto incorretos.<br>'.$bd->ErrorMsg().'<br>';
				}
			}
		$bd->Execute('USE `'.$nomeBd .'`');
		$erros = array();
		if (!$atualizacao){
			msg('Instalando a base de dados');
			$nomeArquivoSQL = BASE_DIR.'/instalacao/sql/gpweb_'.$tipoBd.'.sql';
			$lstErros = instalacao_carregarSQL($nomeArquivoSQL);
			if(is_array($lstErros) && count($lstErros)) $erros[] = array('arquivo' => $nomeArquivoSQL, 'erros' => $lstErros);
		
			if ($profissional){
				$nomeArquivoSQL = BASE_DIR.'/instalacao/sql/gpweb_'.$tipoBd.'_pro.sql';
				$lstErros = instalacao_carregarSQL($nomeArquivoSQL);
				if(is_array($lstErros) && count($lstErros)) $erros[] = array('arquivo' => $nomeArquivoSQL, 'erros' => $lstErros);
				}
			
			$nomeArquivoSQL = BASE_DIR.'/instalacao/sql/gpweb_dados_basicos.sql';
			$lstErros = instalacao_carregarSQL($nomeArquivoSQL);
			if(is_array($lstErros) && count($lstErros)) $erros[] = array('arquivo' => $nomeArquivoSQL, 'erros' => $lstErros);
			
			if ($profissional){
				$nomeArquivoSQL = BASE_DIR.'/instalacao/sql/gpweb_dados_basicos_pro.sql';
				$lstErros = instalacao_carregarSQL($nomeArquivoSQL);
				if(is_array($lstErros) && count($lstErros)) $erros[] = array('arquivo' => $nomeArquivoSQL, 'erros' => $lstErros);
				}
		
			executar_php(BASE_DIR.'/instalacao/sql/gpweb_'.$tipoBd.'.php');
			if ($profissional) executar_php(BASE_DIR.'/instalacao/sql/gpweb_'.$tipoBd.'_pro.php');
		
			if ($exemplo) {
				msg('Instalando os dados de exemplo');
				$nomeArquivoSQL = BASE_DIR.'/instalacao/sql/gpweb_exemplo.sql';
				$lstErros = instalacao_carregarSQL($nomeArquivoSQL);
				if(is_array($lstErros) && count($lstErros)) $erros[] = array('arquivo' => $nomeArquivoSQL, 'erros' => $lstErros);
				
		
				if ($profissional){
					$nomeArquivoSQL = BASE_DIR.'/instalacao/sql/gpweb_exemplo_pro.sql';
					$lstErros = instalacao_carregarSQL($nomeArquivoSQL);
					if(is_array($lstErros) && count($lstErros)) $erros[] = array('arquivo' => $nomeArquivoSQL, 'erros' => $lstErros);
					}
				}
		
			if ($treino) {
				msg('Instalando os dados para treino');
				$nomeArquivoSQL = BASE_DIR.'/instalacao/sql/gpweb_treino.sql';
				$lstErros = instalacao_carregarSQL($nomeArquivoSQL);
				if(is_array($lstErros) && count($lstErros)) $erros[] = array('arquivo' => $nomeArquivoSQL, 'erros' => $lstErros);
				}
			
			if ($restrito) {
				msg('Configurando restries');
				$nomeArquivoSQL = BASE_DIR.'/instalacao/sql/gpweb_restricao.sql';
				$lstErros = instalacao_carregarSQL($nomeArquivoSQL);
				if(is_array($lstErros) && count($lstErros)) $erros[] = array('arquivo' => $nomeArquivoSQL, 'erros' => $lstErros);
				}	
			
			if ($areas) {
				msg('Instalando a base geogrfica de estados e municpios');
				$nomeArquivoSQL = BASE_DIR.'/instalacao/sql/gpweb_estados.sql';
				$lstErros = instalacao_carregarSQL($nomeArquivoSQL);
				if(is_array($lstErros) && count($lstErros)) $erros[] = array('arquivo' => $nomeArquivoSQL, 'erros' => $lstErros);
				
				$nomeArquivoSQL = BASE_DIR.'/instalacao/sql/gpweb_municipios.sql';
				$lstErros = instalacao_carregarSQL($nomeArquivoSQL);
				if(is_array($lstErros) && count($lstErros)) $erros[] = array('arquivo' => $nomeArquivoSQL, 'erros' => $lstErros);
				}
			
			msg('Configurando para a organizao selecionada');
			
			$nomeArquivoSQL = BASE_DIR.'/instalacao/sql/configurar_'.$tipoCia.'.sql';
			$lstErros = instalacao_carregarSQL($nomeArquivoSQL);
			if(is_array($lstErros) && count($lstErros)) $erros[] = array('arquivo' => $nomeArquivoSQL, 'erros' => $lstErros);
			
			}
		else{
			require_once '../base.php';
			require_once BASE_DIR.'/config.php';
			if (!isset($GLOBALS['OS_WIN'])) $GLOBALS['OS_WIN'] = (stristr(PHP_OS, 'WIN') !== false);
			require_once BASE_DIR.'/incluir/db_adodb.php';
			require_once BASE_DIR.'/classes/BDConsulta.class.php';
			
			msg('Atualizando os dados');
			//checar quantas verses do BD exiem para atualizar
			
			while ($atualizacao < $versao_bd) {
				++$atualizacao;
				
				$nomeArquivoSQL = BASE_DIR.'/instalacao/sql/atualizar_bd_'.$tipoBd.'_'.$atualizacao.'.sql';
				$lstErros = instalacao_carregarSQL($nomeArquivoSQL);
				if(is_array($lstErros) && count($lstErros)) $erros[] = array('arquivo' => $nomeArquivoSQL, 'erros' => $lstErros);
				
				$nomeArquivoSQL = BASE_DIR.'/instalacao/sql/atualizar_bd_'.$tipoBd.'_'.$atualizacao.'_livre.sql';;
				if(!$profissional && file_exists($nomeArquivoSQL)){
					$lstErros = instalacao_carregarSQL($nomeArquivoSQL);
				 	if(is_array($lstErros) && count($lstErros)) $erros[] = array('arquivo' => $nomeArquivoSQL, 'erros' => $lstErros);
					}
				
				if ($profissional){
				  $nomeArquivoSQL = BASE_DIR.'/instalacao/sql/atualizar_bd_'.$tipoBd.'_'.$atualizacao.'_pro.sql';
				  $lstErros = instalacao_carregarSQL($nomeArquivoSQL);
				 	if(is_array($lstErros) && count($lstErros)) $erros[] = array('arquivo' => $nomeArquivoSQL, 'erros' => $lstErros);
					}
				
				executar_php(BASE_DIR.'/instalacao/sql/atualizar_bd_'.$tipoBd.'_'.$atualizacao.'.php');
				if ($profissional) executar_php(BASE_DIR.'/instalacao/sql/atualizar_bd_'.$tipoBd.'_'.$atualizacao.'_pro.php');
				}
			}
		if (is_array($erros) && count($erros)){
			$msgBD = 'Configurao da Base de Dados incompleta - os seguintes erros ocorreram:<br>';
			foreach($erros as $errosArquivo){
				$msgBD .= '<div style="padding: 10px;">Arquivo: '.$errosArquivo['arquivo'];
				$msgBD .= '<ul>';
				foreach($errosArquivo['erros'] as $erro) $msgBD .= '<li>Comando No.: '.$erro['linha'].' - '.$erro['cmd'].'<br/>'.$erro['msg'].'</li>';
				$msgBD .= '</ul>';
				$msgBD .= '</div>';
				}
			}
		else $msgBD = 'Base de Dados configurada com sucesso<br>';
		}
	else {
		$msgBD = 'No criado';
		if (!$dbc) {
			$erroBD=1;
			$msgBD .= '<br/>Nenhuma conexo ao Banco de Dados disponvel! ' .($bd ? $bd->ErrorMsg() : '');
			}
		}
	}

if ($fazer_bd_cfg || $fazer_cfg){
	msg('Criando arquivo de configurao');
	$arq_config = '<?php '."\n";
	$arq_config .= '/******** Configurao do Banco de Dados MySQL ********/ '. "\n";
	$arq_config .= '$config[\'tipoBd\'] = \''.$tipoBd.'\';'."\n";
	$arq_config .= '$config[\'hospedadoBd\'] = \''.$hospedadoBd.'\';'."\n";
	$arq_config .= '$config[\'nomeBd\'] = \''.$nomeBd.'\';'."\n";
	$arq_config .= '$config[\'prefixoBd\'] = \''.$prefixoBd.'\';'."\n";
	$arq_config .= '$config[\'usuarioBd\'] = \''.$usuarioBd.'\';'."\n";
	$arq_config .= '$config[\'senhaBd\'] = \''.$senhaBd.'\';'."\n";
	$arq_config .= '$config[\'persistenteBd\'] = '.($persistenteBd ? 'true' : 'false').";\n";
	$arq_config .= '$config[\'militar\'] = '.$tipoCia.';'."\n";
	if ($exemplo) $arq_config .= '$config[\'exemplo\'] = 1;'."\n";
	if ($restrito) $arq_config .= '$config[\'restrito\'] = 1;'."\n";
	if ($treino) $arq_config .= '$config[\'treino\'] = 1;'."\n";
	if ($bronze) $arq_config .= '$config[\'bronze\'] = 1;'."\n";
	if ($tem_data_limite) $arq_config .= '$config[\'data_limite\'] = \''.$data.'\';'."\n";
	$arq_config .= '?>';
	$arq_config = trim($arq_config);
	if ($fazer_cfg || $fazer_bd_cfg){
		if ((is_writable('../config.php')  || ! is_file('../config.php') ) && ($fp = fopen('../config.php', 'w'))){
			fputs( $fp, $arq_config, strlen($arq_config));
			fclose( $fp );
			$msgCArquivo = 'Arquivo de Configurao criado com sucesso'."\n";
			}
		else{
			$erroCArquivo = true;
			$msgCArquivo = 'Arquivo de Configurao no pode ser criado'."\n";
			}
		}
	}
echo '</pre></td></tr>';
echo '</table></td></tr>';
echo '<tr><td>'.estiloFundoCaixa('100%','../').'</td></tr></table>';
echo '<table width="95%" cellspacing=0 cellpadding=0 border=0 align="center"><tr><td>'.estiloTopoCaixa('100%','../').'</td></tr><tr><td>';
echo '<table cellspacing="6" cellpadding="3" border=0 class="std" align="center" width="100%">';
if ($fazer_bd || $fazer_bd_cfg) echo '<tr><td class="title" valign="top" width="440" align="right">Resultado da '.($atualizacao ? 'atualizao' : 'instalao').' da base de dados:</td><td align="left"><b style="color:'.($erroBD ? 'red' : 'green').'">'.$msgBD.'</b>'.($erroBD ? '<br />Por favor entenda que erros relacionados a indices quebrados durante atualizao so <b>normais</b> e no indicam um problema.' : '').'</td></tr>';
if ($fazer_bd_cfg || $fazer_cfg) echo '<tr><td class="title" align="right">Resultado da criao do arquivo de configurao:</td><td align="left"><b style="color:'.($erroCArquivo ? 'red' : 'green').'">'.$msgCArquivo.'</b></td></tr>';
if( ( $fazer_cfg || $fazer_bd_cfg ) && $erroCArquivo ) {
  echo '<tr><td  align="left" colspan="2">O seguinte contedo dever ir para gpweb'
       . ( file_exists( '../modulos/projetos/tarefa_cache.class_pro.php' ) ? '/server' : '' )
       . '/<b>config.php</b>.<br/>Crie este arquivo manualmente e cole as linhas de baixo  mo. Exclua todas as linhas em branco aps \'?>\' e salve. Este arquivo dever poder ser lido pelo Servidor Web.</td></tr>';
  echo '<tr><td align="center" colspan="2"><textarea class="botao" name="hospedadoBd" cols="100" rows="20" title="Contedo de config.php para criao manual." />'
       . "<?php\r" . var_export($config, true). ";\r?>"
       . '</textarea></td></tr>';
	}
echo '<tr><td  align="center" colspan="2"><br/><b><span id="" title="Login::Clique neste link para ir diretamente  tela inicial de login do '.(isset($config['gpweb']) ? $config['gpweb'] : 'gpweb').'."><a href="../'.(file_exists('../modulos/projetos/tarefa_cache.class_pro.php') ?'../':'').'index.php">Login e configurar as opes do '.(isset($config['gpweb']) ? $config['gpweb'] : 'gpweb').'</a></span></b></td></tr>';
if (!$atualizacao) echo '<tr><td  align="center" colspan="2"><p>O login do Administrador foi configurado para <b>admin</b> com a senha <b>123456</b>. Sugerimos mudar esta senha aps efetuar seu primeiro login.</p></td></tr>';

if ($exemplo) echo '<tr><td align="center" colspan="2"><p>Todos os usurios do banco de dados exemplo tambm esto configurados com a senha <b>123456</b>.</p></td></tr>';
echo '</table></td></tr>';
echo '<tr><td>'.estiloFundoCaixa('100%','../').'</td></tr></table>';
echo '<script type="text/javascript">window.addEvent(\'domready\', function(){var as = []; $$(\'span\').each(function(span){if (span.getAttribute(\'title\')) as.push(span);});new Tips(as), {	}});</script>';
echo '</body></html>';


function rrmdir($dir) {
    if (is_dir($dir)) {
        $objects = scandir($dir);
        foreach ($objects as $object) {
            if ($object != "." && $object != "..") {
                if (filetype($dir."/".$object) == "dir") rrmdir($dir."/".$object);
                else unlink($dir."/".$object);
            }
        }
        reset($objects);
        rmdir($dir);
    }
}
?>
