SET FOREIGN_KEY_CHECKS=0;
UPDATE versao SET versao_codigo='8.0.24'; 
UPDATE versao SET ultima_atualizacao_bd='2012-06-03'; 
UPDATE versao SET ultima_atualizacao_codigo='2012-06-03'; 
UPDATE versao SET versao_bd=107;

CREATE TABLE folha_ponto (
  folha_ponto_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  folha_ponto_usuario INTEGER(100)UNSIGNED DEFAULT NULL,
  folha_ponto_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  folha_ponto_evento INTEGER(100) UNSIGNED DEFAULT NULL,
  folha_ponto_inicio DATETIME,
  folha_ponto_fim DATETIME,
  folha_ponto_duracao DECIMAL(20,3) UNSIGNED DEFAULT 0,
  folha_ponto_aprovou INTEGER(100)UNSIGNED DEFAULT NULL,
	folha_ponto_data DATETIME,
  PRIMARY KEY (folha_ponto_id),
  KEY folha_ponto_usuario (folha_ponto_usuario),
  KEY folha_ponto_tarefa (folha_ponto_tarefa),
  KEY folha_ponto_evento (folha_ponto_evento),
  KEY folha_ponto_aprovou (folha_ponto_aprovou),
  CONSTRAINT folha_ponto_fk1 FOREIGN KEY (folha_ponto_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT folha_ponto_fk2 FOREIGN KEY (folha_ponto_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT folha_ponto_fk3 FOREIGN KEY (folha_ponto_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT folha_ponto_fk4 FOREIGN KEY (folha_ponto_aprovou) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB;


CREATE TABLE folha_ponto_gasto (
  folha_ponto_gasto_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  folha_ponto_gasto_folha INTEGER(100) UNSIGNED DEFAULT NULL,
  folha_ponto_gasto_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  folha_ponto_gasto_tipo INTEGER(100) UNSIGNED DEFAULT '1',
  folha_ponto_gasto_nome VARCHAR(255) DEFAULT NULL,
  folha_ponto_gasto_data DATETIME DEFAULT NULL,
  folha_ponto_gasto_quantidade DECIMAL(20,3) UNSIGNED DEFAULT 0,
  folha_ponto_gasto_gasto DECIMAL(20,3) UNSIGNED DEFAULT 0,
  folha_ponto_gasto_percentagem TINYINT(4) DEFAULT '0',
  folha_ponto_gasto_descricao TEXT,
  folha_ponto_gasto_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  folha_ponto_gasto_nd VARCHAR(11) DEFAULT NULL,
  folha_ponto_gasto_categoria_economica VARCHAR(1) DEFAULT NULL,
  folha_ponto_gasto_grupo_despesa VARCHAR(1) DEFAULT NULL,
  folha_ponto_gasto_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  folha_ponto_gasto_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	folha_ponto_gasto_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
  folha_ponto_gasto_data_limite DATE DEFAULT NULL,
  PRIMARY KEY (folha_ponto_gasto_id),
  KEY folha_ponto_gasto_folha (folha_ponto_gasto_folha),
  KEY folha_ponto_gasto_usuario_inicio (folha_ponto_gasto_usuario),
  KEY folha_ponto_gasto_ordem (folha_ponto_gasto_ordem),
  KEY folha_ponto_gasto_data_inicio (folha_ponto_gasto_data),
  KEY folha_ponto_gasto_nome (folha_ponto_gasto_nome),
  CONSTRAINT folha_ponto_gasto_fk FOREIGN KEY (folha_ponto_gasto_folha) REFERENCES folha_ponto (folha_ponto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT folha_ponto_gasto_fk1 FOREIGN KEY (folha_ponto_gasto_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB;

ALTER TABLE contatos ADD COLUMN contato_hora_custo DECIMAL(20,3) UNSIGNED DEFAULT 0;

ALTER TABLE evento_usuarios ADD COLUMN duracao DECIMAL(20,3) UNSIGNED DEFAULT 0;
ALTER TABLE evento_usuarios ADD COLUMN percentual INTEGER(3) UNSIGNED DEFAULT 100;


ALTER TABLE expediente ADD COLUMN projeto_id INTEGER(100) UNSIGNED DEFAULT NULL;
ALTER TABLE expediente ADD KEY projeto_id (projeto_id);
ALTER TABLE expediente ADD CONSTRAINT expediente_fk3 FOREIGN KEY (projeto_id) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE;


DELETE FROM artefatos_tipo WHERE artefato_tipo_id=17;
INSERT INTO artefatos_tipo (artefato_tipo_id, artefato_tipo_nome, artefato_tipo_civil, artefato_tipo_descricao, artefato_tipo_imagem, artefato_tipo_campos) VALUES 
  (17,'Termo de Abertura do Projeto (TAP)','cnj','','',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);