SET FOREIGN_KEY_CHECKS=0;
UPDATE versao SET versao_codigo='8.1.0'; 
UPDATE versao SET ultima_atualizacao_bd='2012-11-14'; 
UPDATE versao SET ultima_atualizacao_codigo='2012-11-14'; 
UPDATE versao SET versao_bd=129; 

ALTER TABLE sessoes DROP PRIMARY KEY;
ALTER TABLE sessoes ADD KEY sessao_id (sessao_id);

DROP TABLE IF EXISTS pratica_indicador_nos_marcadores;

CREATE TABLE pratica_indicador_nos_marcadores (
  pratica_indicador_id INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_marcador_id INTEGER(100) UNSIGNED DEFAULT NULL,
  ano INTEGER(4) DEFAULT NULL,
  uuid VARCHAR(36) DEFAULT NULL,
  KEY pratica_indicador_id (pratica_indicador_id),
  KEY pratica_marcador_id (pratica_marcador_id),
  CONSTRAINT pratica_indicador_nos_marcadores_fk FOREIGN KEY (pratica_indicador_id) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT pratica_indicador_nos_marcadores_fk2 FOREIGN KEY (pratica_marcador_id) REFERENCES pratica_marcador (pratica_marcador_id) ON DELETE CASCADE ON UPDATE CASCADE
 )ENGINE=InnoDB;


ALTER TABLE praticas DROP COLUMN pratica_oque;
ALTER TABLE praticas DROP COLUMN pratica_onde;
ALTER TABLE praticas DROP COLUMN pratica_quando;
ALTER TABLE praticas DROP COLUMN pratica_como;
ALTER TABLE praticas DROP COLUMN pratica_porque;
ALTER TABLE praticas DROP COLUMN pratica_quanto;
ALTER TABLE praticas DROP COLUMN pratica_quem;
ALTER TABLE praticas DROP COLUMN pratica_descricao;


ALTER TABLE pratica_indicador DROP COLUMN pratica_indicador_quando;
ALTER TABLE pratica_indicador DROP COLUMN pratica_indicador_oque;
ALTER TABLE pratica_indicador DROP COLUMN pratica_indicador_como;
ALTER TABLE pratica_indicador DROP COLUMN pratica_indicador_onde;
ALTER TABLE pratica_indicador DROP COLUMN pratica_indicador_quanto;
ALTER TABLE pratica_indicador DROP COLUMN pratica_indicador_porque;
ALTER TABLE pratica_indicador DROP COLUMN pratica_indicador_quem;
ALTER TABLE pratica_indicador DROP COLUMN pratica_indicador_melhorias;
ALTER TABLE pratica_indicador DROP COLUMN pratica_indicador_referencial;
ALTER TABLE pratica_indicador DROP COLUMN pratica_indicador_relevante;
ALTER TABLE pratica_indicador DROP COLUMN pratica_indicador_justificativa_relevante;
ALTER TABLE pratica_indicador DROP COLUMN pratica_indicador_lider;
ALTER TABLE pratica_indicador DROP COLUMN pratica_indicador_justificativa_lider;
ALTER TABLE pratica_indicador DROP COLUMN pratica_indicador_excelencia;
ALTER TABLE pratica_indicador DROP COLUMN pratica_indicador_justificativa_excelencia;
ALTER TABLE pratica_indicador DROP COLUMN pratica_indicador_atendimento;
ALTER TABLE pratica_indicador DROP COLUMN pratica_indicador_justificativa_atendimento;
ALTER TABLE pratica_indicador DROP COLUMN pratica_indicador_estrategico;
ALTER TABLE pratica_indicador DROP COLUMN pratica_indicador_justificativa_estrategico;
ALTER TABLE pratica_indicador DROP COLUMN pratica_indicador_descricao;


DROP TABLE IF EXISTS indicador_lacuna;

CREATE TABLE indicador_lacuna (
  indicador_lacuna_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  indicador_lacuna_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  indicador_lacuna_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  indicador_lacuna_nome VARCHAR(255) DEFAULT NULL,
  indicador_lacuna_ativo TINYINT(1) DEFAULT 1,
  indicador_lacuna_acesso INTEGER(4) DEFAULT 0,
  indicador_lacuna_cor VARCHAR(6) DEFAULT 'FFFFFF',
  indicador_lacuna_resultado TINYINT(1) DEFAULT 0,
  indicador_lacuna_descricao TEXT,
  PRIMARY KEY (indicador_lacuna_id),
  KEY indicador_lacuna_responsavel (indicador_lacuna_responsavel),
  KEY indicador_lacuna_cia (indicador_lacuna_cia),
  CONSTRAINT indicador_lacuna_fk FOREIGN KEY (indicador_lacuna_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT indicador_lacuna_fk2 FOREIGN KEY (indicador_lacuna_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE  
)ENGINE=InnoDB;



DROP TABLE IF EXISTS indicador_lacuna_nos_marcadores;

CREATE TABLE indicador_lacuna_nos_marcadores (
  indicador_lacuna_id INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_marcador_id INTEGER(100) UNSIGNED DEFAULT NULL,
  ano INTEGER(4) DEFAULT NULL,
  uuid VARCHAR(36) DEFAULT NULL,
  KEY indicador_lacuna_id (indicador_lacuna_id),
  KEY pratica_marcador_id (pratica_marcador_id),
  CONSTRAINT indicador_lacuna_nos_marcadores_fk FOREIGN KEY (indicador_lacuna_id) REFERENCES indicador_lacuna (indicador_lacuna_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT indicador_lacuna_nos_marcadores_fk2 FOREIGN KEY (pratica_marcador_id) REFERENCES pratica_marcador (pratica_marcador_id) ON DELETE CASCADE ON UPDATE CASCADE
 )ENGINE=InnoDB;
 
 
DROP TABLE IF EXISTS indicador_lacuna_depts;

CREATE TABLE indicador_lacuna_depts (
  indicador_lacuna_id INTEGER(100) UNSIGNED DEFAULT NULL,
  dept_id INTEGER(100) UNSIGNED DEFAULT NULL,
  KEY indicador_lacuna_id (indicador_lacuna_id),
  KEY dept_id (dept_id),
  CONSTRAINT indicador_lacuna_depts_fk1 FOREIGN KEY (dept_id) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT indicador_lacuna_depts_fk FOREIGN KEY (indicador_lacuna_id) REFERENCES indicador_lacuna (indicador_lacuna_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB;


DROP TABLE IF EXISTS indicador_lacuna_usuarios;

CREATE TABLE indicador_lacuna_usuarios (
  indicador_lacuna_id INTEGER(100) UNSIGNED DEFAULT NULL,
  usuario_id INTEGER(100) UNSIGNED DEFAULT NULL,
  KEY indicador_lacuna_id (indicador_lacuna_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT indicador_lacuna_usuarios_fk1 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT indicador_lacuna_usuarios_fk FOREIGN KEY (indicador_lacuna_id) REFERENCES indicador_lacuna (indicador_lacuna_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB; 


DELETE FROM pratica_marcador;
/*FNQ 250*/  
INSERT INTO pratica_marcador (pratica_marcador_id, pratica_marcador_item, pratica_marcador_letra, pratica_marcador_texto, pratica_marcador_extra) VALUES 
	(1,98,'a','Como so atualizados os valores e os princpios organizacionais necessrios  promoo da excelncia e  criao de valor para todas as partes interessadas?','<ul><li>Apresentar os valores e os princpios organizacionais.</li></ul>'),
	(2,98,'b','Como os valores e os princpios organizacionais so comunicados  fora de trabalho e, quando pertinente, s demais partes interessadas?',NULL),
	(3,98,'c','Como a organizao trata as questes ticas nos relacionamentos internos e externos?','<ul><li>Citar os cdigos de conduta emitidos.</li></ul>'),
	(4,98,'d','Como as principais decises so tomadas, comunicadas e implementadas?',NULL),
	(5,98,'e','Como a Direo exerce a liderana e interage com as partes interessadas?',NULL),
	(6,98,'f','Como so estabelecidos os principais padres de trabalho para os processos gerenciais e verificado seu cumprimento?',NULL),
	(7,98,'g','Como os processos gerenciais so melhorados por meio do aprendizado?','<ul><li>Destacar a forma de conhecer as boas prticas de gesto de outras organizaes.</li></ul>'),
	(8,98,'h','Como a Direo analisa o desempenho operacional e estratgico da organizao?','<ul><li>Destacar as formas de utilizao de referenciais comparativos e necessidades das partes interessadas.</li></ul>'),
	(9,99,'a','Como so definidas as estratgias da organizao, considerando-se os ambientes externo e interno?','<ul><li>Apresentar as principais estratgias da organizao.</li></ul>'),
	(10,99,'b','Como so definidos os indicadores para a avaliao da implementao das estratgias, estabelecimento das metas e definio dos respectivos planos de ao?','<ul><li>Destacar de que forma as necessidades das partes interessadas e os referenciais comparativos so utilizados para definio de metas.</li><li>Apresentar os principais indicadores, suas metas e as principais aes planejadas ou projetos para implementao das estratgias.</li></ul>'),
	(11,99,'c','Como so comunicadas as estratgias, as metas e os planos de ao s pessoas da fora de trabalho e para as demais partes interessadas, quando pertinentes?',NULL),
	(12,99,'d','Como  realizado o monitoramento da implementao dos planos de ao?',NULL),
	(13,100,'a','Como so definidos os clientes-alvo?',NULL),
	(14,100,'b','Como as necessidades e expectativas dos clientes-alvo so identificadas, analisadas e utilizadas para a definio e melhoria dos processos da organizao?','<ul><li>Citar os principais canais de relacionamento utilizados</li></ul>'),
	(15,100,'c','Como os produtos e marcas da organizao so divulgados?',NULL),
	(16,100,'d','Como so tratadas as solicitaes, reclamaes ou sugestes, formais ou informais, dos clientes visando a assegurar que sejam pronta e eficazmente atendidas ou solucionadas?',NULL),
	(17,100,'e','Como  avaliada a satisfao dos clientes?','<ul><li>Destacar como essas informaes so utilizadas para promover aes de melhoria. </li></ul>'),
	(18,101,'a','Como so tratados os impactos sociais e ambientais negativos de produtos, processos e instalaes?',NULL),
	(19,101,'b','Como so identificados e analisados os requisitos legais, regulamentares e contratuais aplicveis  organizao relativos a questes socioambientais?','<ul><li>Destacar de que forma so tratadas as pendncias ou eventuais sanes.</li></ul>'),
	(20,101,'c','Como a organizao seleciona e promove de forma voluntria aes para minimizao de consumo de recursos renovveis, de conservao de recursos no renovveis, reciclagem ou reutilizao de materiais?','<ul><li>Citar as principais aes implementadas.</li></ul>'),
	(21,101,'d','Como so selecionados, desenvolvidos ou apoiado os projetos sociais?','<ul><li>Citar os principais projetos sociais.</li></ul>'),
	(22,102,'a','Como os sistemas de informao so definidos, considerando-se as necessidades de informaes para apoiar as operaes dirias e a tomada de deciso em todos os nveis e reas da organizao?','<ul><li>Citar os principais sistemas de informao e sua finalidade.</li></ul>'),
	(23,102,'b','Como a segurana das informaes  garantida?','<ul><li>Destacar os mtodos utilizados para assegurar a atualizao, a confidencialidade, a integridade e a disponibilidade das informaes.</li></ul>'),
	(24,102,'c','Como so compartilhados e retidos os conhecimentos geradores de diferenciais para a organizao?',NULL),
	(25,103,'a','Como a organizao do trabalho  definida e implementada?','<ul><li> Destacar a participao das pessoas na melhoria dos processos e na busca de inovaes.</li></ul>'),
	(26,103,'b','Como as pessoas so selecionadas, interna e externamente, e contratadas?','<ul><li>Destacar a forma de integrar as pessoas recm-contratadas, visando prepar-las para o pleno exerccio de suas funes.</li></ul>'),
	(27,103,'c','Como so identificadas as necessidades de capacitao e desenvolvimento das pessoas visando ao xito das estratgias e a formao da cultura da excelncia?','<ul><li>Apresentar os principais programas de capacitao e de desenvolvimento oferecidos.</li></ul>'),
	(28,103,'d','Como so identificados os perigos e tratados os riscos relacionados  sade ocupacional e  segurana?',NULL),
	(29,103,'e','Como a satisfao das pessoas  avaliada?',NULL),
	(30,104,'a','Como so determinados os requisitos dos processos principais do negcio e dos processos de apoio, considerando as necessidades e as expectativas dos clientes e demais partes interessadas?','<ul><li>Apresentar os principais requisitos a serem atendidos e os respectivos indicadores de desempenho.</li></ul>'),
	(31,104,'b','Como  assegurado o atendimento dos requisitos, dos processos principais do negcio e dos processos de apoio.',NULL),
	(32,104,'c','Como a organizao analisa e melhora os processos principais do negcio e os processos de apoio?','<ul><li>Destacar as formas utilizadas para conhecer caractersticas dos processos principais do negcio e processos de apoio de outras organizaes, para estabelecer as prprias melhorias.</li><li>Apresentar as principais melhorias implantadas nos processos.</li></ul>'),
	(33,104,'d','Como os fornecedores so selecionados e avaliados?','<ul><li>Destacar as formas de envolvimento e comprometimento com os princpios organizacionais, incluindo os relativos  sade e  segurana.</li></ul>'),
	(34,104,'e','Como  elaborado e controlado o oramento e mantido o fluxo financeiro equilibrado?',NULL),
	(35,105,'a','Apresentar os resultados relativos  gesto econmico-financeira.',NULL),
	(36,105,'b','Apresentar os resultados relativos aos clientes e aos mercados.','<ul><li>Estratificar por grupos de clientes ou tipos de produtos.</li></ul>'),
	(37,105,'c','Apresentar os resultados relativos  sociedade.',NULL),
	(38,105,'d','Apresentar os resultados relativos s pessoas.',NULL),
	(39,105,'e','Apresentar os resultados relativos ao produto e  gesto dos processos principais do negcio e dos processos de apoio.',NULL),
	(40,105,'f','Apresentar os resultados relativos aos fornecedores.',NULL);
	  
   
 /*FNQ 500*/  
INSERT INTO pratica_marcador (pratica_marcador_id, pratica_marcador_item, pratica_marcador_letra, pratica_marcador_texto, pratica_marcador_extra) VALUES  
	(100,49,'a','Como so atualizados os valores e os princpios organizacionais necessrios  promoo da excelncia e  criao de valor para todas as partes interessadas?','<ul><li>Apresentar os valores e os princpios organizacionais.</li></ul>'),
	(101,49,'b','Como a organizao trata as questes ticas nos relacionamentos internos e externos?','<ul><li>Citar os cdigos de conduta emitidos, incluindo os que contm regras de conduta para os integrantes da administrao.</li><li>Apresentar os canais de comunicao colocados  disposio da fora de trabalho, da sociedade e demais partes interessadas para receber denncias.</li><li>Destacar a forma de preveno de desvios de conduta envolvendo a organizao.</li></ul>'),
	(102,49,'c','Como so identificados, classificados e tratados os riscos empresariais mais significativos que possam afetar o negcio?','<ul><li>Apresentar os principais riscos empresariais identificados.</li></ul>'),
	(103,49,'d','Como as principais decises so tomadas, comunicadas e implementadas?',NULL),
	(104,49,'e','Como a Direo presta conta das suas aes e resultados alcanados a quem a elegeu, nomeou ou designou? ',NULL),
	(105,50,'a','Como a direo exerce a liderana e interage com as partes interessadas, identificando suas expectativas e buscando o alinhamento de interesses?','<ul><li>Destacar as principais formas de mobilizao da fora de trabalho e de busca de apoio das demais partes interessadas para o xito das estratgias.</li></ul>'),
	(106,50,'b','Como os valores e os princpios organizacionais so comunicados  fora de trabalho e, quando pertinente, s demais partes interessadas?','<ul><li>Destacar de que forma  assegurado o entendimento dos Valores e dos ?princpios organizacionais pela fora de trabalho.</li></ul>'),
	(107,50,'c','Como so avaliadas e desenvolvidas, nos lderes, as competncias necessrias para o exerccio da liderana?','<ul><li>Destacar a forma utilizada para identificar e preparar novos lderes.</li><li>Apresentar as principais competncias desejadas para os lderes da ? organizao.</li></ul>'),
	(108,50,'d','Como so estabelecidos os principais padres de trabalho para os processos gerenciais e verificado o seu cumprimento? ','<ul><li>Destacar a forma de implementar as aes corretivas quando necessrio.</li></ul>'),
	(109,50,'e','Como os processos gerenciais so melhorados por meio do aprendizado?','<ul><li>Destacar as formas utilizadas para conhecer boas prticas de gesto ?de organizaes de referncia para apoiar o aprendizado, informando os critrios de seleo das organizaes de referncia, e as formas de obteno e de utilizao das informaes.</li></ul>'),
	(110,51,'a','Como so identificadas as necessidades de informaes comparativas para analisar o desempenho operacional e estratgico da organizao?','<ul><li>Apresentar os critrios utilizados para determinar quais so os resultados ? mais importantes a serem comparados.</li><li>Apresentar os critrios utilizados para identificar as organizaes ?consideradas como referenciais comparativos pertinentes, indicando as principais formas de obteno dessas informaes e respectivas fontes.</li></ul>'),
	(111,51,'b','Como a Direo analisa o desempenho operacional e estratgico da organizao?','<ul><li>Destacar a forma de utilizao das variveis do ambiente interno e externo para contextualizar a anlise e tomada de deciso;</li><li>Destacar as formas de utilizao, na avaliao do desempenho, de ? referenciais comparativos e principais requisitos de partes interessadas</li></ul>'),
	(112,51,'c','Como as decises decorrentes da anlise do desempenho da organizao so comunicadas  fora de trabalho, em todos os nveis da organizao e a outras partes interessadas, quando pertinente?',NULL),
	(113,51,'d','Como  acompanhada a implementao das decises decorrentes da anlise do desempenho da organizao? ',NULL),
	(114,52,'a','Como  realizada a anlise do ambiente externo? ',NULL),
	(115,52,'b','Como  realizada a anlise do ambiente interno?',NULL),
	(116,52,'c','Como so avaliadas as alternativas decorrentes das anlises dos ambientes e definidas as estratgias da organizao?','<ul><li>Apresentar as estratgias e reas envolvidas.</li><li>Destacar de que forma os riscos empresariais, partes interessadas e a ?sustentabilidade so considerados neste processo.</li></ul>'),
	(117,53,'a','Como so definidos os indicadores para a avaliao da implementao das estratgias, estabelecidas as metas de curto e longo prazos; e definidos os respectivos planos de ao?','<ul><li>Destacar de que forma os referenciais comparativos e os requisitos de ?partes interessadas so utilizados para definio de metas.</li><li>Apresentar os principais indicadores, suas metas e as principais aes ?planejadas ou projetos para a implementao das estratgias.</li></ul>'),
	(118,53,'b','Como os recursos so alocados para assegurar a implementao dos planos de ao?','<ul><li>Apresentar os principais recursos alocados.</li></ul>'),
	(119,53,'c','Como so comunicadas as estratgias, as metas e os planos de ao para as pessoas da fora de trabalho e para as demais partes interessadas, quando pertinente?',NULL),
	(120,53,'d','Como  realizado o monitoramento da implementao dos planos de ao? ',NULL),
	(121,54,'a','Como o mercado  segmentado?','<ul><li>Apresentar os critrios adotados para segmentao.</li><li>Destacar a forma de definio dos clientes-alvo nesses segmentos, considerando-se, inclusive, os clientes da concorrncia, quando existirem, e os clientes e mercados potenciais.</li></ul>'),
	(122,54,'b','Como as necessidades e expectativas dos clientes-alvo so identificadas, analisadas e utilizadas para definio e melhoria dos processos da organizao?',NULL),
	(123,54,'c','Como os produtos e marcas da organizao so divulgados aos clientes e ao mercado de forma a criar credibilidade, confiana e imagem positiva? ',NULL),
	(124,54,'d','Como  avaliada a imagem da organizao perante os clientes e mercados?','<ul><li>Apresentar os atributos definidos pela organizao para caracterizar sua imagem.</li></ul>'),
	(125,55,'a','Como so definidos e divulgados para os clientes os canais de relacionamento, considerando-se a segmentao do mercado?','<ul><li>Apresentar os principais canais de relacionamento utilizados.</li></ul>'),
	(126,55,'b','Como so tratadas as solicitaes, reclamaes ou sugestes, formais ou informais, dos clientes visando assegurar que sejam pronta e eficazmente atendidas ou solucionadas?',NULL),
	(127,55,'c','Como  realizado o acompanhamento das transaes com novos clientes e com novos produtos entregues? ',NULL),
	(128,55,'d','Como so avaliadas a satisfao e a insatisfao dos clientes e essas informaes so utilizadas para promover aes de melhoria? ',NULL),
	(129,56,'a','Como so identificados os aspectos e tratados os impactos sociais e ambientais negativos de seus produtos, processos e instalaes?',NULL),
	(130,56,'b','Como os impactos sociais e ambientais dos produtos, processos e instalaes e outras informaes relativas  responsabilidade socioambiental consideradas relevantes so comunicados  sociedade, incluindo as comunidades potencialmente impactadas?',NULL),
	(131,56,'c','Como so identificados e analisados os requisitos legais, regulamentares e contratuais aplicveis  organizao e implementadas aes de melhoria visando ao seu pleno atendimento?','<ul><li>Destacar de que forma so tratadas as pendncias ou eventuais sanes.</li></ul>'),
	(132,56,'d','Como a organizao seleciona e promove de forma voluntria aes com vistas ao desenvolvimento sustentvel?','<ul><li>Citar as principais aes promovidas.</li><li>Destacar de que forma as pessoas da fora de trabalho so ? conscientizadas e envolvidas nas questes relativas  responsabilidade socioambiental.</li></ul>'),
	(133,57,'a','Como as necessidades e as expectativas de desenvolvimento da sociedade, incluindo comunidades vizinhas s instalaes da organizao, so identificadas, analisadas e utilizadas para a definio e a melhoria da sua atuao social? ',NULL),
	(134,57,'b','Como a organizao direciona esforos para o fortalecimento da sociedade, incluindo as comunidades vizinhas, executando ou apoiando projetos voltados para o desenvolvimento nacional, regional, local ou setorial?','<ul><li>Citar os principais projetos implementados ou apoiados.</li><li>Destacar de que forma a organizao estimula e envolve a fora de ? trabalho e seus parceiros na implementao e apoio aos seus projetos sociais.</li></ul>'),
	(135,58,'a','Como so identificadas as necessidades de informaes para apoiar as operaes dirias e a tomada de deciso em todos os nveis e reas da organizao? ',NULL),
	(136,58,'b','Como so definidos os sistemas de informao visando a atender as necessidades identificadas?','<ul><li>Citar os principais sistemas de informao em uso e sua finalidade.</li></ul>'),
	(137,58,'c','Como a infraestrutura para a disponibilizao das informaes aos usurios, internos e externos  organizao,  compatibilizada com o crescimento do negcio e da demanda por informaes?',NULL),
	(138,58,'d','Como a segurana das informaes  garantida?','<ul><li>Destacar os mtodos utilizados para garantir a atualizao, confidencialidade, integridade e disponibilidade das informaes.</li></ul>'),
	(139,60,'a','Como so identificados os ativos intangveis da organizao?','<ul><li>Apresentar os principais ativos intangveis.</li></ul>'),
	(140,60,'b','Como os principais ativos intangveis so desenvolvidos e protegidos?',NULL),
	(141,60,'c','Como so compartilhados e retidos os conhecimentos da organizao?','<ul><li>Destacar as formas utilizadas para atrair e reter pessoas consideradas ?chave para os negcios atuais e potenciais da organizao.</li></ul>'),
	(142,61,'a','Como a organizao do trabalho  elaborada e implementada, visando ao alto desempenho?','<ul><li>Destacar a participao das pessoas na melhoria dos processos e na ? busca de inovaes.</li></ul>'),
	(143,61,'b','Como as pessoas so selecionadas, interna e externamente, e contratadas?','<ul><li>Destacar de que forma a organizao estimula a incluso de minorias e assegura a no discriminao e a igualdade de oportunidades para todas as pessoas.</li><li>Destacar a forma de integrar as pessoas recm contratadas, visando ? prepar-las para o pleno exerccio de suas funes.</li></ul>'),
	(144,61,'c','Como o desempenho das pessoas e das equipes  avaliado de forma a estimular o desenvolvimento profissional das mesmas?',NULL),
	(145,61,'d','Como a remunerao, o reconhecimento e os incentivos estimulam o alcance das metas?',NULL),
		(146,62,'a','Como so identificadas as necessidades de capacitao e desenvolvimento das pessoas visando ao xito das estratgicas, a formao da cultura da excelncia e a melhoria do desempenho individual?',NULL),
	(147,62,'b','Como  concebida a forma de realizao dos programas de capacitao e de desenvolvimento, considerando as necessidades da organizao e das pessoas?','<ul><li>Citar os principais programas, o pblico alcanado, destacando aqueles ?relacionados a formao da cultura da excelncia.</li></ul>'),
	(148,62,'c','Como a eficcia dos programas de capacitao e de desenvolvimento  avaliada?',NULL),
	(149,63,'a','Como so identificados os perigos e tratados os riscos relacionados  sade ocupacional e  segurana?',NULL),
	(150,63,'b','Como as necessidades e expectativas das pessoas da fora de trabalho so identificadas, analisadas e utilizadas para o desenvolvimento de polticas e programas de pessoal e de benefcios a elas oferecidos?',NULL),
	(151,63,'c','Como o bem-estar, a satisfao e o comprometimento das pessoas so avaliados e desenvolvidos?','<ul><li>Apresentar os principais benefcios oferecidos s pessoas na organizao.</li></ul>'),
	(152,63,'d','Como a organizao colabora para a melhoria da qualidade de vida das pessoas fora do ambiente de trabalho?','<ul><li>Citar as principais aes desenvolvidas.</li></ul>'),
	(153,64,'a','Como so determinados os requisitos aplicveis aos produtos e aos processos principais do negcio e aos processos de apoio, considerando-se as necessidades e as expectativas dos clientes e de outras partes interessadas? ','<ul><li>Apresentar os principais requisitos a serem atendidos e os respectivos indicadores de desempenho. </li></ul>'),
	(154,64,'b','Como so projetados os processos principais do negcio e os processos de apoio, visando ao atendimento ou a superao de requisitos estabelecidos? ','<ul><li>Destacar as formas de desenvolvimento de novos produtos.</li></ul>'),
	(155,64,'c','Como  assegurado o atendimento dos requisitos aplicveis aos produtos, processos principais do negcio e os processos de apoio?','<ul><li>Destacar a forma de tratamento das eventuais no-conformidades identificadas e implementao das aes corretivas. </li></ul>'),
	(156,64,'d','Como a organizao analisa e melhora os produtos e os processos principais do negcio e os processos de apoio?','<ul><li>Destacar as formas utilizadas para conhecer caractersticas de produtos, processos principais do negcio e processos de apoio de outras organizaes, utilizados para a prpria melhoria.</li><li>Apresentar as principais melhorias e inovaes implantadas nos produtos e processos.</li></ul>'),
	(157,65,'a','Como os fornecedores so qualificados e selecionados?','<ul><li>Destacar os principais critrios utilizados.</li></ul>'),
	(158,65,'b','Como os fornecedores so avaliados e prontamente informados sobre seu desempenho?','<ul><li>Apresentar os indicadores utilizados para monitorar o seu desempenho.</li><li>Apresentar os canais de relacionamento com fornecedores.</li></ul>'),
	(159,65,'c','Como os fornecedores que atuam diretamente nos processos da organizao so envolvidos e comprometidos com os valores e os princpios organizacionais, incluindo os relativos  responsabilidade socioambiental e  sade e segurana?',NULL),
	(160,66,'a','Como a organizao gerencia os aspectos que causam impacto na sustentabilidade econmica do negcio?','<ul><li>Apresentar os indicadores controlados, incluindo aqueles relativos aos grupos de estrutura, liquidez, atividade e rentabilidade.</li></ul>'),
	(161,66,'b','Como a organizao assegura os recursos financeiros necessrios para atender s necessidades operacionais?',NULL),
	(162,66,'c','Como a organizao define os recursos financeiros e avalia os investimentos necessrios visando a dar suporte as estratgias e planos de ao? ','<ul><li>Apresentar os critrios utilizados para definir a forma de captao? apropriada. </li></ul>'),
	(163,66,'d','Como  elaborado e controlado o oramento, visando assegurar o atendimento dos nveis esperados de desempenho financeiro? ',NULL),
	(164,67,'a','Apresentar os resultados relativos  gesto econmico-financeira.',NULL),
	(165,68,'a','Apresentar os resultados relativos aos clientes e aos mercados.','<ul><li>Estratificar por grupos de clientes, segmentos de mercado ou tipos de produtos. </li></ul>'),
	(166,69,'a','Apresentar os resultados relativos  responsabilidade socioambiental e ao desenvolvimento social.',NULL),
	(167,70,'a','Apresentar os resultados relativos ao sistema de trabalho,  capacitao e desenvolvimento e  qualidade de vida.','<ul><li>Estratificar os resultados por grupos de pessoas da fora de trabalho ou funes na organizao ou por instalaes.</li></ul>'),
	(168,71,'a','Apresentar os resultados relativos ao produto e  gesto dos processos principais do negcio e dos processos de apoio, e de processos de gesto transversais no pertinentes aos demais itens.',NULL),
	(169,72,'a','Apresentar os resultados dos principais indicadores relativos aos produtos adquiridos e  gesto de fornecedores.','<ul><li>Estratificar os resultados por grupos de fornecedores ou tipos de produtos fornecidos.</li></ul>');

   
 /*FNQ 1000*/  
INSERT INTO pratica_marcador (pratica_marcador_id, pratica_marcador_item, pratica_marcador_letra, pratica_marcador_texto, pratica_marcador_extra) VALUES    
	(200,145,'a','Como a organizao assegura a equidade entre scios, mantenedores ou instituidores e protege os direitos das partes interessadas?','<ul><li>Citar os mtodos utilizados para controlar os atos da Direo.</li></ul>'),
	(201,145,'b','Como so estabelecidos e atualizados os valores e princpios organizacionais necessrios  promoo da excelncia,  criao de valor para todas as partes interessadas e ao desenvolvimento sustentvel?','<ul><li>Apresentar os valores e os princpios organizacionais.</li></ul>'),
	(202,145,'c','Como a organizao estabelece regras de conduta para os integrantes da sua administrao e para a fora de trabalho e trata as questes ticas, buscando assegurar um relacionamento tico interno e com concorrentes e outras partes interessadas?','<ul><li>Citar os cdigos de conduta emitidos;</li><li>Apresentar os canais de comunicao colocados  disposio da fora de trabalho, da sociedade e das demais partes interessadas para receber reclamaes, denncias e sugestes;</li><li>Destacar a forma de preveno de desvios de conduta envolvendo a organizao;</li><li>Destacar a forma de tratamento dada s manifestaes referentes s questes ticas.</li></ul>'),
	(203,145,'d','Como so identificados, classificados, analisados e tratados os riscos empresariais mais significativos, que possam afetar a imagem e a capacidade da organizao de alcanar os objetivos estratgicos e do negcio?','<ul><li>Apresentar os principais riscos empresariais assumidos pela organizao, incluindo os riscos associados s parcerias, diante das incertezas inerentes ao negcio e s estratgias.</li></ul>'),
	(204,145,'e','Como as principais decises so tomadas, comunicadas e implementadas para assegurar a transparncia e levando em considerao o envolvimento dos principais interessados nos temas tratados?','<ul><li>Destacar o papel dos integrantes da administrao, inclusive no que se refere  aprovao das estratgias e dos objetivos da organizao e do seu modelo de negcio.</li></ul>'),
	(205,145,'f','Como os fatos relevantes so prontamente comunicados  sociedade e s demais partes interessadas?','<ul><li>Destacar os critrios utilizados para determinar que tipo de fato deve ser considerado relevante para ser comunicado.</li></ul>'),
	(206,145,'g','Como a Direo presta contas das suas aes e resultados alcanados a quem a elegeu, nomeou ou designou?','<ul><li>Destacar a forma utilizada para assegurar a autenticidade e suficincia das informaes relativas  prestao de contas.</li><ul>'),
	(207,146,'a','Como a direo exerce a liderana e interage com as partes interessadas, identificando suas expectativas e buscando o alinhamento de interesses?','<ul><li>Destacar as principais formas de mobilizao da fora de trabalho e de busca de apoio das demais partes interessadas para o xito das estratgias, a construo de parcerias e o alcance sustentado dos objetivos da organizao.</li></ul>'),
	(208,146,'b','Como so identificadas e desenvolvidas as mudanas culturais necessrias para a internalizao dos valores e princpios organizacionais e para o xito das estratgias?','<ul><li>Destacar de que forma  respeitada a diversidade de ideias no desenvolvimento da cultura organizacional.</li></ul>'),
	(209,146,'c','Como os valores e os princpios organizacionais so comunicados  fora de trabalho e, quando pertinente, s demais partes interessadas?','<ul><li>Destacar de que forma  assegurado o entendimento dos valores e dos princpios organizacionais.</li></ul>'),
	(210,146,'d','Como so avaliadas e desenvolvidas nos lderes as competncias necessrias para o exerccio da liderana?','<ul><li>Apresentar as principais competncias desejadas para os lderes da organizao;</li><li>Destacar a forma utilizada para identificar e preparar sucessores para os lderes atuais e novos lderes.</li></ul>'),
	(211,146,'e','Como so estabelecidos os principais padres de trabalho para os processos gerenciais e como  verificado o seu cumprimento?','<ul><li>Destacar a forma de implementar as aes corretivas, quando necessrio.</li></ul>'),
	(212,146,'f','Como os processos gerenciais so refinados por meio do aprendizado e da inovao?','<ul><li>Destacar as formas utilizadas para estimular o aprendizado.</li></ul>'),
	(213,146,'g','Como so investigadas as boas prticas de gesto de organizaes de referncia para apoiar o aprendizado?','<ul><li>Destacar os critrios de seleo das organizaes de referncia e as formas de obteno e utilizao dessas informaes.</li></ul>'),
	(214,147,'a','Como so identificadas as necessidades de informaes comparativas para analisar o desempenho operacional e estratgico da organizao?','<ul><li>Apresentar os critrios utilizados para determinar quais so os resultados mais importantes a serem comparados</li><li>Apresentar os critrios utilizados para definir a pertinncia de referenciais comparativos utilizados pela organizao, indicando as principais formas de obteno dessas informaes.</li></ul>'),
	(215,147,'b','Como a Direo avalia o desempenho operacional e estratgico da organizao, visando ao desenvolvimento sustentvel?','<ul><li>Destacar as tcnicas utilizadas para agregao e anlise dos resultados, incluindo a forma de utilizao das variveis do ambiente interno e externo para contextualizar a anlise e a tomada de decises;</li><li>Destacar as formas de utilizao, na avaliao do desempenho, de metas, referenciais comparativos e principais requisitos de partes interessadas.</li></ul>'),
	(216,147,'c','Como as decises decorrentes da anlise do desempenho da organizao so comunicadas  fora de trabalho, em todos os nveis da organizao, e a outras partes interessadas, quando pertinente?',NULL),
	(217,147,'d','Como  acompanhada a implementao das decises decorrentes da anlise do desempenho da organizao?',NULL),
	(218,148,'a','Como  analisado o macroambiente e como so identificadas e analisadas as caractersticas do setor de atuao da organizao e suas tendncias?','<ul><li>Citar as principais informaes utilizadas e as respectivas fontes.</li></ul>'),
	(219,148,'b','Como  analisado o mercado de atuao da organizao e suas tendncias?','<ul><li>Citar as principais informaes utilizadas e as respectivas fontes.</li></ul>'),
	(220,148,'c','Como  analisado o ambiente interno da organizao?','<ul><li>Destacar de que forma as competncias essenciais e os ativos intangveis da organizao so considerados nessa anlise.</li></ul>'),
	(221,148,'d','Como so avaliadas as alternativas decorrentes das anlises dos ambientes e definidas as estratgias da organizao?','<ul><li>Destacar de que forma a organizao considera os riscos empresariais nesse processo e insere o desenvolvimento sustentvel na sua estratgia;</li><li>Apresentar as principais estratgias e objetivos da organizao.</li></ul>'),
	(222,148,'e','Como  avaliado o modelo de negcio em consonncia com a definio das estratgias, visando  potencializao de seu xito?','<ul><li>Destacar de que forma  considerada a entrada e a sada em negcios e mercados, o desenvolvimento de novas linhas de produtos ou sua retirada do mercado, o estabelecimento de parcerias e a reorganizao dos processos principais do negcio e processos de apoio.</li></ul>'),
	(223,149,'a','Como so definidos os indicadores para a avaliao da implementao das estratgias; estabelecidas as metas de curto e longo prazo; e definidos os respectivos planos de ao?','<ul><li>Destacar de que forma os referenciais comparativos e os requisitos de partes interessadas so utilizados para a definio de metas;</li><li>Apresentar os principais indicadores, suas metas e as principais aes planejadas ou projetos para a implementao das estratgias.</li></ul>'),
	(224,149,'b','Como as metas e os planos de ao so desdobrados nas reas responsveis pelos processos principais do negcio e processos de apoio, assegurando a coerncia das metas e dos planos resultantes com as estratgias e tambm entre si e mantendo o alinhamento entre os indicadores utilizados na avaliao do desempenho estratgico e aqueles utilizados na avaliao do desempenho operacional?','<ul><li>Destacar de que forma os planos de ao so desdobrados para os parceiros, quando aplicvel.</li></ul>'),
	(225,149,'c','Como os recursos so alocados para assegurar a implementao dos principais planos de ao?',NULL),
	(226,149,'d','Como so comunicadas as estratgias, as metas e os planos de ao para as pessoas da fora de trabalho e para as demais partes interessadas, quando pertinentes?',NULL),
	(227,149,'e','Como  realizado o monitoramento da implementao dos planos de ao?',NULL),
	(228,150,'a','Como o mercado  segmentado?','<ul><li>Apresentar os critrios adotados para segmentao.</li></ul>'),
	(229,150,'b','Como so definidos os clientes-alvo nesses segmentos, considerando-se, inclusive, os clientes da concorrncia, quando existirem, e os clientes e mercados potenciais?','<ul><li>Apresentar os critrios adotados para definio de clientes-alvo.</li></ul>'),
	(230,150,'c','Como as necessidades e as expectativas dos clientes, atuais e potenciais, e de ex-clientes e de usurios so identificadas, analisadas e utilizadas para definio, melhoria dos produtos e processos da organizao?','<ul><li>Citar os mtodos utilizados para determinar a importncia relativa das necessidades e expectativas identificadas.</li></ul>'),
	(231,150,'d','Como as marcas, os produtos, incluindo os cuidados necessrios ao seu uso e os riscos envolvidos, e tambm as aes de melhoria da organizao so divulgados para os clientes e para o mercado de forma a criar credibilidade, confiana e imagem positiva?','<ul><li>Destacar de que forma so assegurados a clareza, a autenticidade e o contedo adequado das mensagens divulgadas.</li></ul>'),
	(232,150,'e','Como so identificados e avaliados os nveis de conhecimento dos clientes e mercados a respeito das marcas e dos produtos da organizao?',NULL),
	(233,150,'f','Como  avaliada a imagem da organizao perante os clientes e mercados?','<ul><li>Apresentar os atributos definidos pela organizao para caracterizar sua imagem.</li></ul>'),
	(234,151,'a','Como so definidos e divulgados para os clientes os canais de relacionamento, considerando-se a segmentao do mercado e o agrupamento de clientes utilizado?','<ul><li>Apresentar os principais canais de relacionamento utilizados.</li></ul>'),
	(235,151,'b','Como so tratadas as solicitaes, reclamaes ou sugestes, formais ou informais, dos clientes, visando assegurar que sejam pronta e eficazmente atendidas ou solucionadas?','<ul><li>Destacar o modo utilizado para informar aos clientes o resultado da anlise dessas manifestaes e as respectivas aes implementadas, e para repassar essas informaes a outras reas da organizao e, quando aplicvel, aos parceiros.</li></ul>'),
	(236,151,'c','Como as transaes com os clientes so acompanhadas, de forma a permitir  organizao gerar solues rpidas e eficazes, evitar problemas de relacionamento e atender s expectativas dos clientes?','<ul><li>Destacar de que forma  realizado o acompanhamento das transaes recentes com novos clientes e novos produtos entregues.</li></ul>'),
	(237,151,'d','Como so avaliadas a satisfao, a fidelidade e a insatisfao dos clientes, inclusive em relao aos clientes dos concorrentes ou, quando no houver concorrncia, de outras organizaes de referncia?',NULL),
	(238,151,'e','Como as informaes obtidas dos clientes so analisadas e utilizadas para intensificar a sua satisfao, torn-los fiis, incentiv-los a que recomendem os produtos da organizao e desenvolver processos e produtos?',NULL),
	(239,151,'f','Como so identificadas e desenvolvidas parcerias com clientes, distribuidores e revendedores visando  manuteno ou ao aumento da competitividade da organizao?',NULL),
	(240,152,'a','Como a organizao identifica os aspectos e trata os impactos sociais e ambientais negativos de seus produtos, processos e instalaes, desde o projeto at a disposio final, sobre os quais tenha influncia?','<ul><li>Citar as principais aes e metas para eliminar, minimizar ou compensar os impactos sociais e ambientais negativos, incluindo o tratamento dado aos passivos sociais e ambientais.</li></ul>'),
	(241,152,'b','Como a organizao mantm-se preparada para prevenir acidentes e responder s eventuais situaes de emergncia, visando prevenir ou mitigar os seus impactos adversos na sociedade, incluindo aqueles em comunidades potencialmente impactadas?','<ul><li>Destacar de que forma os acidentes, incidentes e ensaios de situaes de emergncia so analisados, investigados e documentados.</li></ul>'),
	(242,152,'c','Como os impactos sociais e ambientais dos produtos, processos e instalaes, assim como as polticas, as aes e os resultados relativos  responsabilidade socioambiental so comunicados  sociedade, incluindo as comunidades potencialmente impactadas?','<ul><li>Apresentar os critrios adotados para definir as informaes que devem ser divulgadas e os canais utilizados.</li></ul>'),
	(243,152,'d','Como so identificados e analisados os requisitos legais, regulamentares e contratuais aplicveis a questes socioambientais e implementadas aes de melhoria visando ao seu pleno atendimento?','<ul><li>Destacar de que maneira so tratadas as pendncias ou eventuais sanes.</li></ul>'),
	(244,152,'e','Como  propiciada a acessibilidade aos produtos e instalaes da organizao?',NULL),
	(245,152,'f','Como a organizao seleciona e promove, de forma voluntria, aes com vista ao desenvolvimento sustentvel?','<ul><li>Destacar a forma de desenvolver parcerias, conscientizar e envolver as partes interessadas na implementao ou apoio s suas aes e projetos ambientais;</li><li>Citar as principais aes implementadas como modo de contribuio para a soluo dos grandes temas mundiais e para a preservao ou recuperao de ecossistemas;</li><li>Citar as aes efetuadas para a minimizao do consumo de recursos renovveis, a conservao de recursos no renovveis na sua forma original, a reciclagem e a reutilizao de materiais.</li></ul>'),
	(246,153,'a','Como as necessidades e as expectativas da sociedade, incluindo comunidades vizinhas s instalaes da organizao, so identificadas, analisadas e utilizadas para a definio e a melhoria da sua atuao social?',NULL),
	(247,153,'b','Como a organizao direciona esforos para o fortalecimento da sociedade, incluindo comunidades vizinhas, executando ou apoiando projetos voltados para o desenvolvimento nacional, regional, local ou setorial?','<ul><li>Apresentar os critrios estabelecidos para a seleo, acompanhamento e avaliao do xito desses projetos sociais;</li><li>Citar os principais projetos implementados ou apoiados;</li><li>Destacar de que maneira so desenvolvidas parcerias e envolvidas as partes interessadas na implementao de projetos sociais.</li></ul>'),
	(248,153,'c','Como  avaliado o grau de satisfao da sociedade, incluindo comunidades vizinhas, em relao  organizao?',NULL),
	(249,153,'d','Como as informaes obtidas da sociedade, incluindo comunidades vizinhas, so analisadas e utilizadas para intensificar a sua satisfao e para aperfeioar ou desenvolver projetos sociais?',NULL),
	(250,153,'e','Como a organizao avalia e zela por sua imagem perante a sociedade, incluindo comunidades vizinhas?',NULL),
	(251,154,'a','Como so identificadas as necessidades de informaes e de seu tratamento para apoiar as operaes dirias, acompanhar o progresso dos planos de ao e subsidiar a tomada de decises em todos os nveis e reas da organizao?',NULL),
	(252,154,'b','Como so definidos, desenvolvidos, implantados e melhorados os principais sistemas de informao, visando atender s necessidades identificadas?','<ul><li>Citar os principais sistemas de informao em uso e a sua finalidade.</li></ul>'),
	(253,154,'c','Como a tecnologia de informao  analisada e utilizada para alavancar o negcio e promover a integrao da organizao com as partes interessadas?','<ul><li>Destacar de que forma  assegurada a atualizao tecnolgica dos sistemas desenvolvidos;</li><li>Citar as principais solues adotadas que visam  integrao das informaes e dos sistemas.</li></ul>'),
	(254,154,'d','Como a infraestrutura para a disponibilizao das informaes aos usurios, internos e externos  organizao,  compatibilizada com o crescimento do negcio e da demanda por informaes?','<ul><li>Destacar de que forma  avaliada a satisfao dos usurios dos servios de informao.</li></ul>'),
	(255,154,'e','Como a segurana das informaes  garantida?','<ul><li>Destacar os mtodos utilizados para assegurar a atualizao, a confidencialidade, a integridade e a disponibilidade das informaes.</li></ul>'),
	(256,155,'a','Como so identificados os ativos intangveis que mais agregam valor ao negcio, gerando um diferencial competitivo para a organizao?','<ul><li>Apresentar os critrios utilizados para a identificao e os principais ativos intangveis identificados;</li><li>Citar os mtodos utilizados para avaliao dos ativos intangveis identificados.</li></ul>'),
	(257,155,'b','Como os principais ativos intangveis so desenvolvidos e protegidos?',NULL),
	(258,155,'c','Como so identificados e desenvolvidos os conhecimentos que sustentam a implementao das estratgias e as operaes?','<ul><li>Destacar as formas para a criao de um ambiente favorvel  gerao de conhecimento.</li></ul>'),
	(259,155,'d','Como so compartilhados e retidos os conhecimentos da organizao?','<ul><li>Destacar as formas utilizadas para armazenar e acessar os conhecimentos retidos e para atrair e reter pessoas e parceiros considerados chave para os negcios atuais e potenciais da organizao.</li></ul>'),
	(260,156,'a','Como a organizao do trabalho  definida em alinhamento com o modelo de negcio e com os processos, visando ao alto desempenho e  inovao?','<ul><li>Destacar de que forma a organizao do trabalho estimula a resposta rpida e o aprendizado organizacional;</li><li>Destacar a autonomia dos diversos nveis da fora de trabalho para definir, gerir e melhorar os processos da organizao e para buscar inovaes;</li><li>Destacar de que forma se estimulam a cooperao e a comunicao eficaz entre as pessoas e entre as equipes, inclusive considerando-se pessoas de diferentes localidades e reas;</li><li>Destacar a forma utilizada para dimensionar o quadro de pessoal e o critrio utilizado para definir as atividades terceirizadas, quando existirem.</li></ul>'),
	(261,156,'b','Como as pessoas so selecionadas, interna e externamente, e contratadas em consonncia com as estratgias e as necessidades do modelo de negcio da organizao?','<ul><li>Destacar de que forma a organizao estimula a incluso de minorias e assegura a no discriminao e a igualdade de oportunidades para todas as pessoas.</li></ul>'),
	(262,156,'c','Como as pessoas recm-contratadas so integradas  cultura organizacional, visando prepar-las para o pleno exerccio das suas funes?',NULL),
	(263,156,'d','Como o desempenho das pessoas e das equipes  avaliado de modo a estimular a obteno de metas de alto desempenho, a cultura da excelncia e o desenvolvimento profissional das mesmas?',NULL),
	(264,156,'e','Como a remunerao, o reconhecimento e os incentivos estimulam o alcance de metas de alto desempenho e a cultura da excelncia?',NULL),
	(265,157,'a','Como so identificadas as necessidades de capacitao e desenvolvimento das pessoas, visando ao xito de estratgias,  formao da cultura da excelncia e  melhoria do desempenho individual?','<ul><li>Destacar as formas de participao dos lderes e das prprias pessoas a serem capacitadas e desenvolvidas na identificao das necessidades.</li></ul>'),
	(266,157,'b','Como  concebida a forma de realizao dos programas de capacitao e de desenvolvimento, considerando-se as necessidades da organizao e das pessoas?','<ul><li>Citar os principais programas, o pblico alcanado, destacando aqueles relacionados  formao da cultura da excelncia.</li></ul>'),
	(267,157,'c','Como a eficcia dos programas de capacitao  avaliada em relao ao alcance dos objetivos estratgicos e operacionais da organizao?',NULL),
	(268,157,'d','Como a organizao promove o desenvolvimento integral das pessoas como indivduos, cidados e profissionais?','<ul><li>Citar os mtodos de orientao ou aconselhamento, empregabilidade e desenvolvimento de carreira.</li></ul>'),
	(269,158,'a','Como so identificados os perigos e tratados os riscos relacionados  sade ocupacional e  segurana?','<ul><li>Citar os principais programas e as metas para eliminar ou minimizar esses riscos.</li></ul>'),
	(270,158,'b','Como as necessidades e expectativas das pessoas da fora de trabalho e do mercado de trabalho so identificadas, analisadas e utilizadas para o desenvolvimento de polticas e programas de pessoal e dos benefcios a elas oferecidos?','<ul><li>Apresentar, de forma comparativa com o mercado de trabalho, os principais benefcios oferecidos s pessoas na organizao.</li></ul>'),
	(271,158,'c','Como o bem-estar, a satisfao e o comprometimento das pessoas so avaliados e desenvolvidos?','<ul><li>Destacar de que forma so tratados, com a participao de lderes dos diversos nveis, os fatores identificados na avaliao que afetam o bem-estar, a satisfao e o comprometimento das pessoas.</li></ul>'),
	(272,158,'d','Como  mantido um clima organizacional favorvel  criatividade,  inovao,  excelncia no desempenho e ao desenvolvimento profissional das pessoas e das equipes?','<ul><li>Destacar as formas utilizadas para mobilizar as pessoas para a explorao de ideias criativas em busca de inovaes.</li></ul>'),
	(273,158,'e','Como a organizao colabora para a melhoria da qualidade de vida das pessoas fora do ambiente de trabalho?','<ul><li>Citar as principais aes desenvolvidas.</li></ul>'),
	(274,159,'a','Como so determinados os requisitos aplicveis aos produtos e aos processos principais do negcio e aos de apoio, considerando-se as necessidades e as expectativas dos clientes, e sua importncia relativa, e de outras partes interessadas?','<ul><li>Apresentar os principais requisitos a serem atendidos e os respectivos indicadores de desempenho.</li></ul>'),
	(275,159,'b','Como so desenvolvidos novos produtos visando ao atendimento ou  superao de requisitos estabelecidos?','<ul><li>Citar as metodologias de projeto empregadas.</li></ul>'),
	(276,159,'c','Como so projetados os processos principais do negcio e os processos de apoio, visando ao atendimento ou  superao de requisitos estabelecidos?','<ul><li>Citar as metodologias de projeto empregadas, considerando-se os diferentes tipos de processos.</li></ul>'),
	(277,159,'d','Como  avaliado o potencial de ideias criativas converterem-se em inovaes e em produtos e processos?',NULL),
	(278,159,'e','Como  assegurado o atendimento dos requisitos aplicveis aos processos principais do negcio e processos de apoio?','<ul><li>Citar os mtodos de padronizao e controle, incluindo de autogerenciamento das operaes;</li><li>Destacar a forma de tratamento de eventuais no-conformidades identificadas e de implementao das aes corretivas.</li></ul>'),
	(279,159,'f','Como a organizao analisa e melhora os produtos e os processos principais do negcio e os processos de apoio?','<ul><li>Citar os mtodos utilizados para reduzir a variabilidade e aumentar a confiabilidade e a ecoeficincia, exemplificando melhorias.</li></ul>'),
	(280,159,'g','Como so investigadas as caractersticas de produtos e de processos principais do negcio e de processos de apoio de concorrentes ou de outras organizaes de referncia para melhorar os prprios?','<ul><li>Destacar os critrios de seleo das organizaes de referncia e as formas de obteno e utilizao dessas informaes, exemplificando o seu uso.</li></ul>'),
	(281,160,'a','Como a organizao desenvolve a sua cadeia de suprimentos imediata e nela identifica potenciais fornecedores e parceiros visando assegurar a continuidade de fornecimento no longo prazo, melhorar o desempenho, promover o desenvolvimento sustentvel da prpria cadeia e agregar valor ao negcio?','<ul><li>Destacar as formas de estmulo ao desenvolvimento dos fornecedores locais e a atuao para erradicar o trabalho infantil, degradante ou forado, na cadeia de suprimentos.</li></ul>'),
	(282,160,'b','Como as necessidades e expectativas dos fornecedores so identificadas, analisadas e utilizadas para a definio e a melhoria das polticas e dos programas relativos aos fornecedores?','<ul><li>Apresentar os principais canais de relacionamento com os fornecedores.</li></ul>'),
	(283,160,'c','Como os fornecedores so qualificados e selecionados?','<ul><li>Destacar os principais critrios utilizados, incluindo os para estabelecimento de parcerias.</li></ul>'),
	(284,160,'d','Como  assegurado o atendimento aos requisitos da organizao por parte dos fornecedores?','<ul><li>Destacar as formas de monitoramento dos recebimentos, pronta comunicao e tratamento de eventuais no-conformidades e de avaliao de fornecedores;</li><li>Apresentar os principais requisitos de fornecimento a serem atendidos pelos fornecedores e os respectivos indicadores de desempenho.</li></ul>'),
	(285,160,'e','Como a organizao estimula a melhoria e a inovao nos processos e produtos dos fornecedores?','<ul><li>Destacar de que forma os fornecedores so envolvidos e estimulados a melhorar e procurar solues inovadoras, exemplificando melhorias ou inovaes;</li><li>Destacar de que forma  buscada a otimizao dos custos associados ao fornecimento.</li></ul>'),
	(286,160,'f','Como os fornecedores que atuam diretamente nos processos da organizao so envolvidos e comprometidos com os valores e princpios organizacionais, incluindo os relativos  responsabilidade socioambiental e  sade e segurana?',NULL),
	(287,161,'a','Como so determinados os requisitos de desempenho econmico- financeiro da organizao e monitorados os aspectos que causam impacto na sustentabilidade econmica do negcio?','<ul><li>Citar o papel dos scios, mantenedores ou instituidores e da administrao na definio dos nveis esperados de desempenho econmico-financeiro;</li><li>Apresentar os indicadores controlados, incluindo aqueles relativos aos grupos de: estrutura, liquidez, atividade e rentabilidade.</li></ul>'),
	(288,161,'b','Como a organizao assegura os recursos financeiros necessrios para atender s necessidades operacionais?','<ul><li>Apresentar os critrios usados para captao de recursos, concesso de crditos e controle de recebimentos, de modo a manter equilibrado o fluxo financeiro.</li></ul>'),
	(289,161,'c','Como a organizao define os recursos financeiros e avalia os investimentos necessrios visando a dar suporte para as estratgias e planos de ao?','<ul><li>Apresentar os critrios utilizados para definir a forma de captao apropriada.</li></ul>'),
	(290,161,'d','Como so quantificados e monitorados os riscos financeiros da organizao?','<ul><li>Destacar o modo de tratamento dos riscos financeiros mais significativos que possam vir a afetar as demonstraes financeiras.</li></ul>'),
	(291,161,'e','Como  elaborado e controlado o oramento visando assegurar o atendimento dos nveis esperados de desempenho financeiro?','<ul><li>Destacar a maneira utilizada para assegurar o alinhamento entre o oramento e as estratgias e objetivos da organizao</li></ul>'),
	(292,162,'a','Apresentar os resultados dos principais indicadores relativos  gesto econmico-financeira, classificando-os segundo os grupos de: estrutura, liquidez, atividade e rentabilidade. Estratificar os resultados por unidades ou filiais, quando aplicveis.','<ul><li>Incluir os nveis de desempenho associados aos principais requisitos de partes interessadas, assim como os referenciais comparativos pertinentes;</li><li>Explicar, resumidamente, os resultados apresentados, esclarecendo eventuais tendncias adversas, nveis de desempenho abaixo do esperado pelas partes interessadas e comparaes desfavorveis.</li></ul>'),
	(293,163,'a','Apresentar os resultados dos principais indicadores relativos aos clientes e aos mercados, incluindo os referentes  imagem da organizao. Estratificar por grupos de clientes, segmentos de mercado ou tipos de produtos, quando aplicveis.','<ul><li>Incluir os nveis de desempenho associados aos principais requisitos de partes interessadas, assim como os nveis de desempenho de concorrentes ou outros referenciais comparativos pertinentes;</li><li>Explicar, resumidamente, os resultados apresentados, esclarecendo eventuais tendncias adversas, nveis de desempenho abaixo do esperado pelas partes interessadas e comparaes desfavorveis.</li></ul>'),
	(294,164,'a','Apresentar os resultados dos principais indicadores relativos  sociedade, incluindo os relativos  responsabilidade socioambiental e ao desenvolvimento social. Estratificar os resultados por instalaes ou por comunidades, quando aplicvel.','<ul><li>Incluir os nveis de desempenho associados aos principais requisitos de partes interessadas, assim como os referenciais comparativos pertinentes.</li><li>Explicar, resumidamente, os resultados apresentados, esclarecendo eventuais tendncias adversas, nveis de desempenho abaixo do esperado pelas partes interessadas e comparaes desfavorveis.</li></ul>'),
	(295,165,'a','Apresentar os resultados dos principais indicadores relativos s pessoas, incluindo os relativos aos sistemas de trabalho,  capacitao e desenvolvimento e  qualidade de vida e os de liderana de pessoas e de promoo da cultura da excelncia. Estratificar os resultados por grupos de pessoas da fora de trabalho, funes na organizao e, quando aplicvel, por instalaes.','<ul><li>Incluir os nveis de desempenho associados aos principais requisitos de partes interessadas, assim como os referenciais comparativos pertinentes;</li><li>Explicar, resumidamente, os resultados apresentados, esclarecendo eventuais tendncias adversas, nveis de desempenho abaixo do esperado pelas partes interessadas e comparaes desfavorveis.</li></ul>'),
	(296,166,'a','Apresentar os resultados dos indicadores relativos aos produtos, de processos principais do negcio e processos de apoio e de processos de gesto transversais no pertinentes aos demais itens.','<ul><li>Incluir os nveis de desempenho associados aos principais requisitos de partes interessadas, assim como os referenciais comparativos pertinentes.</li><li>Explicar, resumidamente, os resultados apresentados, esclarecendo eventuais tendncias adversas, nveis de desempenho abaixo do esperado pelas partes interessadas e comparaes desfavorveis.</li></ul>'),
	(297,167,'a','Apresentar os resultados dos principais indicadores relativos aos produtos recebidos dos fornecedores e  gesto de fornecedores. Estratificar os resultados por grupos de fornecedores ou tipos de produtos adquiridos, quando aplicveis.','<ul><li>Incluir os nveis de desempenho associados aos principais requisitos de partes interessadas, assim como os referenciais comparativos pertinentes;</li><li>Explicar, resumidamente, os resultados apresentados, esclarecendo eventuais tendncias adversas, nveis de desempenho abaixo do esperado pelas partes interessadas e comparaes desfavorveis. </li></ul>');


 /*PQGF 250*/  
INSERT INTO pratica_marcador (pratica_marcador_id, pratica_marcador_item, pratica_marcador_letra, pratica_marcador_texto, pratica_marcador_extra) VALUES   
	(300,106,'a','Como a Alta Administrao exerce a liderana, interagindo e promovendo o comprometimento com todas as partes interessadas?',NULL),
	(301,106,'b','Como as principais decises so tomadas, comunicadas e implementadas pela Alta Administrao?',NULL),
	(302,106,'c','Como os Princpios e Valores da Administrao Pblica, as Diretrizes do Governo e os Princpios Organizacionais so internalizados e disseminados na organizao?',NULL),
	(303,106,'d','Como a Alta Administrao conduz a implementao do sistema de gesto da organizao, visando assegurar o atendimento das necessidades e expectativas de todas as partes interessadas?',NULL),
	(304,106,'e','Como  analisado criticamente o desempenho por meio de indicadores e acompanhada a implementao das decises decorrentes desta anlise?',NULL),
	(305,106,'f','Como so avaliados e melhorados as prticas de gesto e os respectivos padres?',NULL),
	(306,107,'a','Como so definidas as estratgias da organizao considerando-se as necessidades das partes interessadas, as demandas do governo e as informaes internas?','<ul><li>Apresentar as principais estratgias.</li></ul>'),
	(307,107,'b','Como so definidos os indicadores para a avaliao da implementao das estratgias, estabelecidas as metas de curto e longo prazos e definidos os respectivos planos de ao?','<ul><li>Destacar os principais indicadores, metas e planos de ao.</li></ul>'),
	(308,107,'c','Como os recursos so alocados para assegurar a implementao dos planos de ao?','<ul><li>Apresentar os principais recursos alocados.</li></ul>'),
	(309,107,'d','Como so comunicadas as estratgias, metas e os planos de ao para as pessoas da fora de trabalho e para as demais partes interessadas, quando pertinente?',NULL),
	(310,107,'e','Como  realizado o monitoramento da implementao dos planos de ao?',NULL),
	(311,108,'a','Como as necessidades e expectativas dos cidados-usurios so identificadas, analisadas e utilizadas para definio e melhoria dos produtos, servios e processos da organizao?',NULL),
	(312,108,'b','Como os produtos e servios, padres de atendimento e as aes de melhoria da organizao so divulgados aos cidados e  sociedade?',NULL),
	(313,108,'c','Como so tratadas as reclamaes e sugestes, formais e informais dos cidados-usurios, visando assegurar que sejam pronta e eficazmente atendidas e solucionadas?',NULL),
	(314,108,'d','Como  avaliada a satisfao dos cidados-usurios em relao aos seus produtos ou servios?',NULL),
	(315,109,'a','Como so identificados os aspectos e tratados os impactos sociais e ambientais adversos decorrentes da atuao da organizao?',null),
	(316,109,'b','Como a organizao estimula e envolve a fora de trabalho e seus parceiros nas questes relativas  responsabilidade socioambiental?',null),
	(317,109,'c','Como a organizao orienta e estimula a sociedade a exercer o controle social?',null),
	(318,109,'d','Como a organizao estimula o exerccio da responsabilidade social da fora de trabalho, no cumprimento de seu papel de agente pblico, e o comportamento tico em todos os nveis?',NULL),
	(319,109,'e','Como a organizao identifica as necessidades da sociedade em relao ao seu setor de atuao e as transforma em requisitos para a formulao e execuo de polticas pblicas, quando pertinente?',NULL),
	(320,110,'a','Como so identificadas as necessidades, definidos e implantados os sistemas de informaes para apoiar as operaes dirias e a tomada de deciso em todos os nveis e reas da organizao?',NULL),
	(321,110,'b','Como a segurana das informaes  tratada para assegurar sua atualizao, confidencialidade, integridade e disponibilidade?',NULL),
	(322,110,'c','Como a organizao estabelece e mantm a memria administrativa?',NULL),
	(323,110,'d','Como so utilizadas outras organizaes como um referencial comparativo pertinente?',NULL),
	(324,110,'e','Como o conhecimento  desenvolvido, protegido e compartilhado na organizao?',NULL),
	(325,111,'a','Como a organizao do trabalho  definida e implementada?','<ul><li>Citar o grau de autonomia dos diversos nveis de pessoas da fora de trabalho para definir, gerir e melhorar os processos organizacionais.</li></ul>'),
	(326,111,'b','Como o desempenho das pessoas e das equipes  gerenciado, de forma a estimular a busca por melhores resultados?',NULL),
	(327,111,'c','Como as necessidades de capacitao e desenvolvimento so identificadas considerando as estratgias e as necessidades das pessoas?',NULL),
	(328,111,'d','Como  concebida a forma de realizao dos programas de capacitao e de desenvolvimento, considerando as necessidades identificadas?',NULL),
	(329,111,'e','Como so identificados os perigos e tratados os riscos relacionados  sade ocupacional, segurana e ergonomia?',NULL),
	(330,111,'f','Como so identificados e tratados os fatores que afetam o bem-estar, a satisfao e a motivao das pessoas e mantido um clima organizacional favorvel?','<ul><li>Apresentar os fatores identificados.</li><li>Citar as principais aes desenvolvidas.</li></ul>'),
	(331,111,'g','Como a satisfao das pessoas  avaliada?',NULL),
	(332,112,'a','Como os processos finalsticos e os processos de apoio so projetados, visando ao cumprimento dos requisitos aplicveis?','<ul><li>Apresentar os requisitos a serem atendidos e os respectivos indicadores de desempenho.</li></ul>'),
	(333,112,'b','Como os processos finalsticos e os processos de apoio so controlados, visando assegurar o atendimento dos requisitos aplicveis?',NULL),
	(334,112,'c','Como os processos finalsticos e os processos de apoio so analisados e melhorados?','<ul><li>Destacar as formas utilizadas para incorporar melhores prticas.</li><li>Apresentar as principais melhorias implantadas nos processos, pelo menos, nos ltimos dois anos.</li></ul>'),
	(335,112,'d','Como os fornecedores so selecionados?','<ul><li>Destacar os critrios utilizados.</li></ul>'),
	(336,112,'e','Como os fornecedores so avaliados e prontamente informados sobre seu desempenho?',NULL),
	(337,112,'f','Como  elaborado e gerenciado o oramento?',NULL),
	(338,113,'a','Apresentar os resultados relativos aos cidados-usurios',NULL),
	(339,114,'b','Apresentar os resultados relativos  sociedade',NULL),
	(340,115,'c','Apresentar os resultados oramentrios e financeiros',NULL),
	(341,116,'d','Apresentar os resultados relativos s pessoas',NULL),
	(342,117,'e','Apresentar os resultados relativos aos processos de suprimento',NULL),
	(343,118,'f','Apresentar os resultados dos processos finalsticos e de apoio',NULL);


  /*PQGF 500*/  
INSERT INTO pratica_marcador (pratica_marcador_id, pratica_marcador_item, pratica_marcador_letra, pratica_marcador_texto, pratica_marcador_extra) VALUES 
	(400,73,'a','Como os princpios e valores da administrao pblica e as diretrizes de governo so disseminados e internalizados na organizao?',NULL),
	(401,73,'b','Como as principais decises so tomadas, comunicadas e implementadas pela Alta Administrao assegurando a transparncia e o envolvimento de todas as partes interessadas?',NULL),
	(402,73,'c','Como so identificados e tratados os riscos organizacionais mais significativos que possam afetar o desempenho?','<ul><li>Apresentar os principais riscos organizacionais identificados.</li></ul>'),
	(403,73,'d','Como a Alta Administrao presta conta de seus atos e resultados alcanados para a sociedade e rgos de controle?',NULL),
	(404,74,'a','Como a alta administrao, estabelecendo um exemplo a ser seguido, atua pessoalmente para: buscar novas oportunidades para a organizao e promover o comprometimento com todas as partes interessadas?',NULL),
	(405,74,'b','Como so estabelecidos e atualizados os valores e os princpios organizacionais necessrios  criao de valor para todas as partes interessadas?','<ul><li>Apresentar os valores e os princpios organizacionais.</li><li>Apresentar as formas de disseminao e internalizao na fora de trabalho dos valores e das diretrizes organizacionais.</li></ul>'),
	(406,74,'c','Como  incentivado o comprometimento de todos com a cultura da excelncia?','<ul><li>Destacar as principais aes empreendidas para promover a excelncia na organizao.</li></ul>'),
	(407,74,'d','Como as habilidades de liderana so definidas, identificadas e desenvolvidas nos lderes?','<ul><li>Destacar como as pessoas com potencial de liderana so identificadas.</li></ul>'),
	(408,74,'e','Como so estabelecidos os principais padres de trabalho que orientam a execuo adequada das prticas de gesto da organizao e os mtodos para verificar o seu cumprimento?','<ul><li>Destacar como so garantidos os recursos para melhoria da infraestrutura de trabalho.</li></ul>'),
	(409,74,'f','Como  estimulado o aprendizado organizacional?',NULL),
	(410,75,'a','Como so analisadas as necessidades de informaes comparativas para avaliar o desempenho da organizao?','<ul><li>Destacar os critrios utilizados para determinar quais so os resultados mais significativos a serem comparados.</li><li>Apresentar os tipos de informaes utilizadas para comparar o desempenho e avaliar o cumprimento dos nveis de desempenho esperados pelas partes interessadas.</li></ul>'),
	(411,75,'b','Como  analisado o desempenho estratgico e operacional, considerando as informaes comparativas e do ambiente interno e externo?',NULL),
	(412,75,'c','Como so avaliados o xito das estratgias e o alcance dos respectivos objetivos da organizao a partir das concluses da anlise do seu desempenho?',NULL),
	(413,75,'d','Como as decises decorrentes da anlise do desempenho da organizao so comunicadas  fora de trabalho e a outras partes interessadas, quando pertinente?',NULL),
	(414,75,'e','Como  acompanhada a implementao das decises decorrentes da anlise do desempenho da organizao?',NULL),
	(415,76,'a','Como  o processo de formulao das polticas pblicas, quando pertinente?','<ul><li>Destacar como a organizao identifica o universo institucional e os atores envolvidos nas polticas pblicas das quais participa como formuladora e/ou executora, quando pertinente.</li></ul>'),
	(416,76,'b','Como  o processo de formulao das estratgias da organizao?','<ul><li>Apresentar as principais etapas e as reas envolvidas no processo.</li></ul>'),
	(417,76,'c','Como os aspectos relativos ao ambiente externo so considerados no processo de formulao das estratgias?','<ul><li>Destacar os aspectos considerados.</li><li>Destacar como a organizao se relaciona com outros rgos e entidades para estabelecer parcerias com vistas a melhor cumprir sua misso institucional.</li></ul>'),
	(418,76,'d','Como  realizada a anlise do ambiente interno da organizao?',NULL),
	(419,76,'e','Como so avaliadas e selecionadas as estratgias da organizao?','<ul><li>Destacar as principais estratgias selecionadas.</li><li>Destacar o alinhamento das estratgias com o PPA, a LDO e a LOA, quando pertinente.</li></ul>'),
	(420,76,'f','Como as reas da organizao so envolvidas no processo de formulao das estratgias?',NULL),
	(421,76,'g','Como as estratgias so comunicadas s partes interessadas pertinentes para o estabelecimento de compromissos mtuos?',NULL),
	(422,77,'a','Como so definidos os indicadores para a avaliao da operacionalizao das estratgias, estabelecidas as metas de curto e longo prazo e definidos os respectivos planos de ao?','<ul><li>Apresentar os principais indicadores, metas e planos de ao.</li><li>Destacar o envolvimento da fora de trabalho na elaborao dos planos de ao.</li></ul>'),
	(423,77,'b','Como as metas e os planos de ao so desdobrados para as reas da organizao, assegurando a coerncia com as estratgias selecionadas e a consistncia entre os respectivos planos?',NULL),
	(424,77,'c','Como os diferentes recursos financeiros e no-financeiros so alocados para assegurar a implementao dos planos de ao?',NULL),
	(425,77,'d','Como so comunicadas as metas, os indicadores e os planos de ao para a fora de trabalho e, quando pertinente, para as demais partes interessadas?',NULL),
	(426,77,'e','Como  realizado o monitoramento da implementao dos planos de ao?',NULL),
	(427,78,'a','Como a organizao identifica os seus cidados-usurios e como eles so classificados por tipos ou grupos?','<ul><li>Destacar como so identificados os cidados-usurios atuais e potenciais.</li><li>Destacar os critrios utilizados para agrupar seus cidados-usurios.</li></ul>'),
	(428,78,'b','Como as necessidades e expectativas dos cidados-usurios, atuais e potenciais, so identificadas, analisadas e compreendidas e utilizadas para definio e melhoria dos produtos, servios e processos da organizao?','<ul><li>Descrever as metodologias utilizadas para determinar a importncia relativa das necessidades e expectativas identificadas.</li></ul>'),
	(429,78,'c','Como os produtos e servios, padres de atendimento e as aes de melhoria da organizao so divulgados aos cidados e  sociedade de forma a criar credibilidade, confiana e imagem positiva?','<ul><li>Destacar os mtodos utilizados para assegurar a clareza, a autenticidade e o contedo adequado das mensagens divulgadas.</li></ul>'),
	(430,78,'d','Como so identificados e avaliados os nveis de conhecimento do universo potencial de cidados-usurios sobre a organizao, seus servios, produtos e aes?',NULL),
	(431,78,'e','Como  avaliada a imagem da organizao perante os cidados-usurios?','<ul><li>Apresentar os atributos definidos pela organizao para caracterizar sua imagem.</li><li>Destacar os principais indicadores utilizados para medir a imagem da organizao e o conhecimento dos seus servios, produtos e aes perante os seus usurios.</li></ul>'),
	(432,78,'f','Como  avaliado o atendimento ao universo potencial dos cidados-usurios identificados?','<ul><li>Destacar os principais indicadores utilizados e as aes decorrentes.</li></ul>'),
	(433,79,'a','Como so definidos e divulgados aos cidados-usurios os principais canais de acesso para solicitarem informaes ou esclarecimentos sobre os servios e produtos ou comunicarem suas sugestes ou reclamaes?','<ul><li>Destacar os principais canais de acesso disponibilizados aos cidados-usurios.</li></ul>'),
	(434,79,'b','Como so tratadas as reclamaes e sugestes, formais e informais dos cidados-usurios, visando assegurar a resposta rpida e eficaz e o seu aproveitamento por toda a organizao?','<ul><li>Destacar as principais aes decorrentes e como elas so informadas aos cidados-usurios e repassadas s demais reas da organizao.</li></ul>'),
	(435,79,'c','Como os servios e os produtos, recentemente prestados ou entregues, so acompanhados junto aos cidados-usurios para permitir  organizao gerar solues rpidas e eficazes, evitar problemas de relacionamento e atender as expectativas dos cidados-usurios?',NULL),
	(436,79,'d','Como a organizao avalia a satisfao e a insatisfao dos cidados-usurios em relao aos seus produtos ou servios e aos da concorrncia, quando pertinente?',NULL),
	(437,79,'e','Como as informaes obtidas dos cidados-usurios so utilizadas para melhorar o seu nvel de satisfao?','<ul><li>Destacar as principais aes implementadas.</li></ul>'),
	(438,80,'a','Como a organizao identifica os aspectos e trata os impactos sociais e ambientais de seus produtos, servios, processos e instalaes, desde o projeto at a disposio final, sobre os quais tenha influncia?','<ul><li>Descrever as principais aes e metas para eliminar, minimizar ou compensar os impactos sociais e ambientais negativos, incluindo o tratamento de passivos sociais e ambientais.</li><li>Citar os planos existentes para enfrentar eventuais situaes de emergncia visando a reduo das consequncias negativas.</li></ul>'),
	(439,80,'b','Como os impactos sociais e ambientais dos servios, produtos, processos e instalaes assim como as respectivas polticas, aes e resultados so comunicados  sociedade?','<ul><li>Destacar os critrios adotados para selecionar e priorizar as informaes divulgadas e os canais adotados.</li></ul>'),
	(440,80,'c','Como so tratadas as pendncias ou eventuais sanes referentes aos requisitos legais, regulamentares, ticos ou contratuais, relatando as atualmente existentes?',NULL),
	(441,80,'d','Como a organizao promove aes que envolvam a conservao de recursos no-renovveis, a preservao dos ecossistemas e otimizao do uso de recursos renovveis?',NULL),
	(442,80,'e','Como a fora de trabalho, fornecedores e demais partes interessadas so conscientizadas e envolvidas nas questes relativas  responsabilidade socioambiental?',NULL),
	(443,80,'f','Como a organizao direciona esforos para o fortalecimento da sociedade executando ou apoiando projetos sociais ou projetos voltados para o desenvolvimento nacional, regional, local ou setorial, quando pertinente?','<ul><li>Apresentar os critrios estabelecidos para a seleo dos projetos a serem implementados ou apoiados e citar os principais projetos em execuo e implementados.</li><li>Apresentar os principais indicadores de controle da execuo e de impactos dos projetos sociais.</li></ul>'),
	(444,81,'a','Como a organizao divulga oficialmente os seus atos e informaes sobre seus planos, programas e projetos?','<ul><li>Destacar os mtodos utilizados para assegurar que as informaes sejam entendidas e interpretadas.</li></ul>'),
	(445,81,'b','Como a organizao torna pblico e democratiza o acesso s suas informaes relativas  execuo fsica, oramentria, financeira e  gesto?',NULL),
	(446,81,'c','Como a organizao orienta e estimula a sociedade a participar no controle dos seus resultados institucionais?','<ul><li>Destacar os mecanismos de relacionamento disponibilizados  sociedade para o exerccio do controle social.</li></ul>'),
	(447,81,'d','Como a organizao estimula o exerccio da responsabilidade social da fora de trabalho, no cumprimento de seu papel de agente pblico, e o comportamento tico em todos os nveis?','<ul><li>Destacar os padres ticos de conduta estabelecidos.</li></ul>'),
	(448,81,'e','Como a organizao disponibiliza canais de comunicao para receber eventuais denncias de violao da tica e atua para minimizar esses acontecimentos e seus efeitos?',NULL),
	(449,82,'a','Como a organizao identifica as necessidades da sociedade em relao ao seu setor de atuao e as transforma em requisitos para a formulao e na execuo das polticas pblicas, quando pertinente?','<ul><li>Destacar como so previstos os impactos decorrentes da implementao das polticas pblicas.</li></ul>'),
	(450,82,'b','Como a organizao contribui na formulao ou atua na execuo das polticas pblicas do seu setor?','<ul><li>Apresentar as principais polticas pblicas onde a organizao atua.</li><li>Destacar o nvel de atuao e os principais atores envolvidos.</li><li>Destacar como assegura a participao da sociedade.</li></ul>'),
	(451,82,'c','Como a organizao divulga as polticas pblicas e seus respectivos objetivos para a sociedade?','<ul><li>Destacar os principais canais de comunicao utilizados.</li></ul>'),
	(452,82,'d','Como a organizao monitora e avalia a execuo das polticas pblicas em seu nvel de atuao?','<ul><li>Destacar os indicadores de impacto e demais indicadores utilizados e seu relacionamento com os requisitos estabelecidos.</li></ul>'),
	(453,82,'e','Como a organizao avalia a satisfao da sociedade e demais partes interessadas com a implementao das polticas pblicas, em seu nvel de atuao?',NULL),
	(454,83,'a','Como so identificados, definidos, desenvolvidos, implantados e atualizados os principais sistemas de informao, visando atender s necessidades identificadas da organizao e dos usurios?','<ul><li>Destacar os principais sistemas de informao em uso e sua finalidade.</li></ul>'),
	(455,83,'b','Como  estabelecida e mantida a memria administrativa da organizao?','<ul><li>Destacar os principais tipos de registro e seus principais usos.</li></ul>'),
	(456,83,'c','Como a informao  utilizada para apoiar o cumprimento da misso institucional e promover a integrao da organizao com seus cidados-usurios, sociedade, fornecedores e parceiros?',NULL),
	(457,83,'d','Como as informaes necessrias so colocadas  disposio dos pblicos internos e externos  organizao, incluindo cidados-usurios, fornecedores e parceiros?',NULL),
	(458,83,'e','Como  gerenciada a segurana das informaes?','<ul><li>Destacar os mtodos utilizados para garantir a atualizao, confidencialidade, integridade, preservao e disponibilidade das informaes.</li></ul>'),
	(459,84,'a','Como so identificadas as organizaes consideradas como um referencial comparativo pertinente?','<ul><li>Destacar os critrios utilizados para definir a pertinncia das organizaes para efeito de comparao; e apresentar as principais organizaes identificadas.</li></ul>'),
	(460,84,'b','Como so identificadas as fontes, obtidas e mantidas atualizadas as informaes comparativas?','<ul><li>Destacar os critrios utilizados para determinar o mtodo mais apropriado de coleta, considerando as fontes das informaes comparativas identificadas.</li></ul>'),
	(461,84,'c','Como as informaes obtidas so utilizadas para melhorar o conhecimento dos processos organizacionais, estabelecer metas ousadas e promover melhorias no desempenho da organizao?','<ul><li>Citar as principais aes de melhoria implantadas como decorrncia da utilizao das informaes comparativas.</li></ul>'),
	(462,85,'a','Como o conhecimento  desenvolvido e compartilhado na organizao?','<ul><li>Descrever as prticas existentes para identificao, tratamento e compartilhamento do conhecimento considerado relevante para a organizao</li><li>Descrever os mtodos para identificar, desenvolver e incorporar novas tecnologias.</li></ul>'),
	(463,85,'b','Como o conhecimento  mantido e protegido?','<ul><li>Descrever, inclusive, os mtodos empregados para atrair e reter especialistas.</li></ul>'),
	(464,85,'c','Como a organizao assegura que a gesto do conhecimento seja utilizada para melhorar os seus processos, produtos e servios?',NULL),
	(465,85,'d','Como so identificados, desenvolvidos e mensurados os ativos intangveis da organizao?','<ul><li>Destacar os principais ativos intangveis da organizao.</li></ul>'),
	(466,86,'a','Como a organizao do trabalho  definida e implementada visando o alto desempenho da organizao?','<ul><li>Destacar as oportunidades para a participao das pessoas nos processos da organizao, possibilitando a iniciativa, a criatividade, a inovao e o desenvolvimento de seu potencial.</li><li>Destacar o grau de autonomia das pessoas para definir, gerir e melhorar os processos da organizao com flexibilidade e rapidez nas respostas aos interesses dos cidados.</li></ul>'),
	(467,86,'b','Como as pessoas so selecionadas para preenchimento de cargos e funes, em consonncia com as estratgias, os objetivos e a misso da organizao?','<ul><li>Destacar as competncias e habilidades necessrias aos cargos e funes.</li><li>Descrever de que forma so considerados os requisitos de desempenho e so asseguradas a justia e a igualdade de oportunidades para todas as pessoas.</li></ul>'),
	(468,86,'c','Como so definidos e disponibilizados os canais de interlocuo e a negociao com a fora de trabalho da organizao, quando pertinente?',NULL),
	(469,86,'d','Como  estimulada a integrao e a cooperao das pessoas e das equipes?','<ul><li>Destacar as prticas utilizadas para integrar as pessoas recm contratadas e remanejadas visando prepar-las para a execuo das suas funes.</li><li>Destacar de que forma  assegurada a comunicao eficaz entre as reas da organizao.</li></ul>'),
	(470,86,'e','Como o desempenho das pessoas e das equipes  gerenciado, de forma a estimular a obteno de metas de alto desempenho, a cultura da excelncia na organizao e o desenvolvimento profissional?','<ul><li>Destacar como  estruturada a progresso de carreira profissional.</li></ul>'),
	(471,86,'f','Como o sistema de remunerao, de reconhecimento e de incentivos para as pessoas estimula o alcance de metas de alto desempenho e do aprendizado?',NULL),
	(472,87,'a','Como as necessidades de capacitao e de desenvolvimento so identificadas?','<ul><li>Descrever as formas de participao dos lderes e das pessoas da fora de trabalho neste processo.</li></ul>'),
	(473,87,'b','Como as necessidades de capacitao e de desenvolvimento das pessoas so compatibilizadas com as necessidades da organizao, para efeito da definio dos programas de capacitao e desenvolvimento?','<ul><li>Destacar as aes de desenvolvimento de gerentes e pessoas com cargo de chefia.</li><li>Destacar as aes de capacitao das pessoas que atuam diretamente junto aos cidados-usurios.</li></ul>'),
	(474,87,'c','Como os programas de capacitao e desenvolvimento abordam a cultura da excelncia e contribuem para consolidar o aprendizado organizacional?','<ul><li>Citar os principais temas abordados e o pblico alcanado.</li></ul>'),
	(475,87,'d','Como  concebida a forma de realizao dos programas de capacitao e de desenvolvimento considerando as necessidades da organizao e das pessoas e os recursos disponveis?',NULL),
	(476,87,'e','Como as habilidades e os conhecimentos adquiridos so avaliados em relao  sua utilidade na execuo do trabalho e  sua eficcia na consecuo das estratgias da organizao?',NULL),
	(477,87,'f','Como a organizao promove o desenvolvimento integral das pessoas, como indivduos, cidados e profissionais?','<ul><li>Descrever os mtodos de orientao ou aconselhamento, empregabilidade e desenvolvimento de carreira.</li></ul>'),
	(478,88,'a','Como so identificados os perigos e tratados os riscos relacionados  sade ocupacional, segurana e ergonomia?','<ul><li>Destacar o modo como as pessoas participam da identificao, preveno e mitigao dos perigos e riscos.</li><li>Destacar os principais fatores relacionados  ergonomia, sade e segurana e seus requisitos, indicadores e metas.</li></ul>'),
	(479,88,'b','Como so identificados os fatores que afetam o bem-estar, a satisfao e a motivao considerando os diferentes grupos de pessoas?','<ul><li>Destacar os fatores identificados para os diversos grupos.</li></ul>'),
	(480,88,'c','Como so tratados os fatores que afetam o bem-estar, a satisfao e a motivao das pessoas e mantido um clima organizacional favorvel ao alto desempenho?','<ul><li>Destacar os principais servios, benefcios, programas e polticas colocados  disposio da fora de trabalho, fazendo uma comparao com as prticas de mercado.</li></ul>'),
	(481,88,'d','Como a organizao colabora para a melhoria da qualidade de vida das pessoas fora do ambiente de trabalho?','<ul><li>Destacar as principais aes desenvolvidas.</li></ul>'),
	(482,88,'e','Como so avaliados os fatores que afetam o bem-estar, a satisfao e a motivao considerando os diferentes grupos de pessoas?',NULL),
	(483,89,'a','Como so identificados e determinados os processos finalsticos e os processos de apoio, considerando a misso institucional da organizao?',NULL),
	(484,89,'b','Como as necessidades dos cidados-usurios e da sociedade so traduzidas em requisitos e incorporadas aos projetos de servios ou produtos e aos processos finalsticos?','<ul><li>Destacar os requisitos ambientais, de sade, de segurana e de ergonomia, quando pertinente.</li><li>Destacar os requisitos a serem atendidos e os seus respectivos indicadores de desempenho.</li></ul>'),
	(485,89,'c','Como os processos finalsticos e os processos de apoio so projetados, visando o cumprimento dos requisitos definidos?','<ul><li>Destacar os mtodos utilizados para a incorporao do conhecimento disponvel na organizao.</li></ul>'),
	(486,89,'d','Como os processos finalsticos e os processos de apoio so controlados?','<ul><li>Destacar o controle dos processos relativos s parcerias institucionais.</li><li>Destacar como so tratadas as no-conformidades identificadas.</li></ul>'),
	(487,89,'e','Como os processos finalsticos e os processos de apoio so refinados?','<ul><li>Descrever as principais metodologias utilizadas para aumentar a confiabilidade dos produtos ou servios fornecidos pela organizao.</li><li>Destacar as aes de desburocratizao dos principais processos finalsticos e dos processos de apoio.</li><li>Destacar as aes de otimizao dos custos associados aos processos finalsticos e de apoio.</li><li>Destacar as principais melhorias implementadas nos ltimos 3 anos.</li></ul>'),
	(488,90,'a','Como a organizao identifica potenciais fornecedores e desenvolve a sua cadeia de suprimentos visando assegurar a disponibilidade de fornecimento a longo prazo, melhorar o seu desempenho e o desenvolvimento sustentvel da prpria cadeia?',NULL),
	(489,90,'b','Como  realizado o processo de aquisio de bens, de materiais e de servios de forma a assegurar a transparncia do processo e o atendimento  legislao?','<ul><li>Destacar o atendimento s necessidades e requisitos especficos da organizao;</li><li>Destacar os indicadores utilizados para a avaliao do processo de suprimento.</li></ul>'),
	(490,90,'c','Como  assegurada a qualidade dos bens, produtos e servios adquiridos?','<ul><li>Destacar os mtodos de acompanhamento e controle da produo e entrega, de forma a garantir o atendimento dos requisitos estabelecidos;</li><li>Destacar a forma como  assegurada a obteno de um equilbrio entre qualidade, prazo e preo.</li></ul>'),
	(491,90,'d','Como a organizao realiza a gesto dos bens materiais, dos bens patrimoniais e dos estoques quando for pertinente?','<ul><li>Incluir os indicadores utilizados.</li></ul>'),
	(492,90,'e','Como  administrado o relacionamento com os fornecedores?','<ul><li>Destacar: como  definido e assegurado o atendimento aos requisitos da organizao por parte dos fornecedores.</li></ul>'),
	(493,90,'f','Como os fornecedores so avaliados e prontamente informados sobre seu desempenho?','<ul><li>Apresentar os indicadores utilizados para monitorar o seu desempenho.</li><li>Destacar a forma como a avaliao considera o atendimento aos requisitos estabelecidos, os valores e as diretrizes da organizao e os aspectos relativos  segurana, sade e meio ambiente.</li></ul>'),
	(494,90,'g','Como so minimizados os custos associados  gesto do fornecimento?',NULL),
	(495,90,'h','Como os fornecedores que atuam diretamente nos processos da organizao so envolvidos e comprometidos com os Princpios Organizacionais relativos  responsabilidade socioambiental, incluindo os aspectos da segurana e sade?',NULL),
	(496,91,'a','Como  elaborada a proposta oramentria e como so tratadas as restries e liberaes de oramento mais significativas que possam vir a afetar a execuo das atividades?',NULL),
	(497,91,'b','Como os processos oramentrios e financeiros so gerenciados para suportar as necessidades estratgicas e operacionais da organizao?',NULL),
	(498,91,'c','Como so monitorados a execuo oramentria e financeira e os possveis realinhamentos entre o oramento, estratgias e objetivos da organizao?','<ul><li>Destacar como so avaliados e administrados os riscos financeiros, quando pertinente.</li></ul>'),
	(499,91,'d','Como so selecionadas as melhores opes e realizadas captaes, investimentos e aplicaes de recursos financeiros, quando pertinente?',NULL),
	(500,91,'e','Como as operaes da organizao so acompanhadas em termos oramentrios e financeiros e como so administrados os parmetros oramentrios e financeiros?','Destacar, quando pertinente:<ul><li>a gerncia do patrimnio e das receitas decorrentes do seu uso;</li><li>a compatibilizao do custeio e do investimento com o oramento aprovado ? responsabilidade fiscal;</li><li>a gerncia das receitas decorrentes do recolhimento de taxas por prestao de servios ou de impostos.</li></ul>'),
	(501,92,'a','Apresentar os resultados dos principais indicadores relativos aos cidados-usurios. Estratificar por grupos de cidados-usurios, segmentos de mercado ou tipos de produtos, quando aplicvel. Incluir os nveis de desempenho de organizaes consideradas como referencial comparativo pertinente;Explicar, resumidamente, os resultados apresentados, esclarecendo eventuais tendncias adversas e comparaes desfavorveis.',NULL),
	(502,93,'a','Apresentar os resultados dos principais indicadores relativos  sociedade, incluindo os relativos  atuao socioambiental,  tica, ao controle social e s polticas pblicas. Estratificar os resultados por instalaes, quando aplicvel. Incluir os nveis de desempenho de organizaes consideradas como referencial comparativo pertinente; explicar, resumidamente, os resultados apresentados, esclarecendo eventuais tendncias adversas e comparaes desfavorveis.',NULL),
	(503,94,'a','Apresentar os resultados dos principais indicadores relativos  gesto oramentria e financeira. Estratificar os resultados por unidades ou filiais, quando aplicvel.','<ul><li> Incluir os nveis de desempenho de organizaes consideradas como referencial comparativo pertinente; explicar, resumidamente, os resultados apresentados, esclarecendo eventuais tendncias adversas e comparaes desfavorveis.</li><li>Destacar a relao entre recurso executado versus recurso planejado e o cumprimento das metas planejadas versus recursos executados.</li></ul>'),
	(504,95,'a','Apresentar os resultados dos principais indicadores relativos s pessoas, incluindo os relativos aos sistemas de trabalho,  capacitao e desenvolvimento e  qualidade de vida. Estratificar os resultados por grupos de pessoas da fora de trabalho, funes na organizao e, quando aplicvel, por instalaes.','<ul><li>Incluir os nveis de desempenho de organizaes consideradas como referencial comparativo pertinente; explicar, resumidamente, os resultados apresentados, esclarecendo eventuais tendncias adversas e comparaes desfavorveis.</li></ul>'),
	(505,96,'a','Apresentar os resultados dos principais indicadores relativos aos processos de suprimento.','<ul><li>Incluir os nveis de desempenho de organizaes consideradas como referencial comparativo pertinente; explicar, resumidamente, os resultados apresentados, esclarecendo eventuais tendncias adversas e comparaes desfavorveis.</li></ul>'),
	(506,97,'a','Apresentar os resultados dos principais indicadores relativos aos processos.','<ul><li>Incluir os nveis de desempenho de organizaes consideradas como referencial comparativo pertinente; explicar, resumidamente, os resultados apresentados, esclarecendo eventuais tendncias adversas e comparaes desfavorveis.</li></ul>');
	  
/*PQGF 1000*/
INSERT INTO pratica_marcador (pratica_marcador_id, pratica_marcador_item, pratica_marcador_letra, pratica_marcador_texto, pratica_marcador_extra) VALUES 
	(600,24,'a','Como as principais decises so tomadas, comunicadas e implementadas pela Alta Administrao, assegurando o envolvimento de todas as partes interessadas, a transparncia e a governabilidade?','<ul><li>Destacar as formas de seleo dos executivos, os membros dos conselhos e dos comits, conforme aplicvel.</li><li>Destacar os mtodos utilizados para registrar e monitorar os atos da Alta Administrao.</li></ul>'),
	(601,24,'b','Como so estabelecidos e atualizados os valores e os princpios organizacionais necessrios  criao de valor para todas as partes interessadas e ao desenvolvimento sustentvel?','<ul><li>Apresentar os valores e os princpios organizacionais</li></ul>'),
	(602,24,'c','Como so identificados, classificados, analisados e tratados os riscos organizacionais mais significativos que possam afetar a governabilidade e a capacidade da organizao de alcanar os seus objetivos estratgicos e de realizar sua misso?','<ul><li>Citar os principais riscos organizacionais assumidos pela Alta Administrao diante das incertezas inerentes  misso e s estratgias.</li><li>Citar os principais indicadores de desempenho utilizados na avaliao dos riscos organizacionais.</li></ul>'),
	(603,24,'d','Como a Alta Administrao presta conta de seus atos e resultados alcanados a quem a elegeu ou designou e aos rgos de controle?',NULL),
	(604,25,'a','Como os princpios e valores da administrao pblica e as diretrizes de governo so disseminados e internalizados na organizao?',NULL),
	(605,25,'b','Como a Alta Administrao, estabelecendo um exemplo a ser seguido, atua pessoalmente na busca de novas oportunidades para a organizao e para promover o comprometimento com todas as partes interessadas?',NULL),
	(606,25,'c','Como os valores e os princpios organizacionais so disseminados e internalizados  fora de trabalho e, quando pertinente, s demais partes interessadas?',NULL),
	(607,25,'d','Como  incentivado o comprometimento de todos com a cultura da excelncia?','<ul><li>Destacar as principais aes empreendidas para promover a excelncia na organizao.</li></ul>'),
	(608,25,'e','Como os lderes atuais e potenciais so avaliados e desenvolvidos em relao s competncias desejadas pela organizao?','<ul><li>Destacar as competncias desejadas.</li><li>Destacar os mtodos utilizados para identificar as pessoas com potencial de liderana.</li></ul>'),
	(609,25,'f','Como a Alta Administrao conduz a implementao do sistema de gesto da organizao, visando assegurar o atendimento aos requisitos de todas as partes interessadas?','<ul><li>Destacar os critrios adotados para garantir os recursos para a melhoria do sistema de gesto, da infra-estrutura de trabalho e da comunicao interna e externa.</li><li>Apresentar os compromissos e padres de atendimento, quando pertinente.</li></ul>'),
	(610,25,'g','Como  estimulado o aprendizado na organizao?','<ul><li>Descrever os principais mtodos utilizados para implementar o aprendizado e desenvolver melhorias e eventuais inovaes nos processos gerenciais.</li><li>Destacar a maneira adotada para estruturar a fora de trabalho a gerar novas idias, buscar inovaes e melhorias.</li><li>Apresentar os principais refinamentos (melhorias e inovaes) nos processos gerenciais implementadas nos ltimos trs anos.</li></ul>'),
	(611,26,'a','Como so analisadas as necessidades de informaes comparativas para avaliar o desempenho da organizao?','<ul><li>Destacar os critrios utilizados para determinar quais so os resultados mais significativos a serem comparados.</li><li>Apresentar as informaes utilizadas para comparar e avaliar o cumprimento dos nveis de desempenho esperados pelas partes interessadas.</li></ul>'),
	(612,26,'b','Como so analisados os desempenhos dos diversos nveis da organizao e o desempenho integrado de toda a organizao, considerando as informaes comparativas e o atendimento aos principais requisitos das partes interessadas?','<ul><li>Destacar o papel da Alta Administrao.</li><li>Descrever os principais mtodos de anlise utilizados, destacando a forma de agregao dos resultados.</li><li>Citar os resultados analisados demonstrando a sua abrangncia, incluindo os relativos aos programas / aes do governo sob sua responsabilidade, quando pertinente.</li></ul>'),
	(613,26,'c','Como so avaliados o xito das estratgias e o alcance dos respectivos objetivos da organizao a partir das concluses da anlise do seu desempenho?',NULL),
	(614,26,'d','Como as decises decorrentes da anlise do desempenho da organizao so comunicadas  fora de trabalho, em todos os nveis da organizao, e a outras partes interessadas, quando pertinente?',NULL),
	(615,26,'e','Como  acompanhada a implementao das decises decorrentes da anlise do desempenho da organizao?',NULL),
	(616,27,'a','Como  o processo de formulao das polticas pblicas, quando pertinente?','<ul><li>Destacar como a organizao identifica o universo institucional e os atores envolvidos nas polticas pblicas das quais participa como formuladora e/ou executora, quando pertinente.</li></ul>'),
	(617,27,'b','Como  o processo de formulao das estratgias da organizao?','<ul><li>Apresentar as principais etapas e as reas envolvidas no processo.</li></ul>'),
	(618,27,'c','Como os aspectos relativos ao ambiente externo so considerados no processo de formulao das estratgias?','<ul><li>Destacar os aspectos considerados.</li><li>Destacar a maneira de relacionamento com outros rgos e entidades para estabelecer parcerias com o intuito de melhor cumprir sua misso institucional.</li></ul>'),
	(619,27,'d','Como  realizada a anlise do ambiente interno?','<ul><li>Destacar de que forma  considerado, nessa anlise, o conhecimento da organizao.</li></ul>'),
	(620,27,'e','Como so avaliadas e selecionadas as estratgias?','<ul><li>Destacar as principais estratgias selecionadas e o alinhamento com o PPA, a LDO, a LOA e com os objetivos da organizao e os respectivos aspectos fundamentais para o seu sucesso.</li><li>Citar de que forma a organizao insere o desenvolvimento sustentvel na sua estratgia visando atingir resultados favorveis nas reas social, ambiental e econmica, quando pertinente.</li></ul>'),
	(621,27,'f','Como as reas da organizao e as partes interessadas, quando pertinente, so envolvidas nos processos de formulao de estratgias?',NULL),
	(622,27,'g','Como as estratgias so comunicadas s partes interessadas pertinentes para o estabelecimento de compromissos mtuos?',NULL),
	(623,28,'a','Como so definidos os indicadores para a avaliao da operacionalizao das estratgias, estabelecidas as metas de curto e longo prazos e definidos os respectivos planos de ao?','<ul><li>Apresentar os principais indicadores, metas e planos de ao, destacando aqueles relacionados  reduo de custos e melhorias da qualidade dos servios.</li><li>Destacar os mecanismos de projees sobre os referenciais comparativos utilizados pela organizao.</li><li>Destacar o envolvimento da fora de trabalho na elaborao dos planos de ao.</li></ul>'),
	(624,28,'b','Como as metas estabelecidas so desdobradas para as reas da organizao, assegurando a coerncia entre os indicadores utilizados na avaliao da implementao das estratgias e aqueles utilizados na avaliao do desempenho dos processos?',NULL),
	(625,28,'c','Como os planos de ao so desdobrados para as reas da organizao, assegurando a coerncia com as estratgias selecionadas e a consistncia entre os respectivos planos?',NULL),
	(626,28,'d','Como os diferentes recursos so alocados para assegurar a implementao dos planos de ao?','<ul><li>Apresentar os principais recursos financeiros e no-financeiros alocados</li></ul>'),
	(627,28,'e','Como so comunicadas as metas, os indicadores e os planos de ao para a fora de trabalho e, quando pertinente, para as demais partes interessadas?',NULL),
	(628,28,'f','Como  realizado o monitoramento da implementao dos planos de ao?',NULL),
	(629,29,'a','Como so identificados os cidados-usurios da organizao e como eles so classificados por tipos ou grupos?','<ul><li>Destacar como so identificados os cidados-usurios atuais e potenciais.</li><li>Destacar os critrios utilizados para agrupar seus cidados-usurios.</li></ul>'),
	(630,29,'b','Como as necessidades e expectativas dos cidados-usurios, atuais e potenciais, e de ex-usurios, quando pertinente, so identificadas, analisadas e compreendidas e utilizadas para definio e melhoria dos produtos, servios e processos da organizao?','<ul><li>Descrever as metodologias utilizadas para determinar a importncia relativa das necessidades e expectativas identificadas.</li></ul>'),
	(631,29,'c','Como os produtos e servios, padres de atendimento e as aes de melhoria da organizao so divulgados aos cidados de forma a criar credibilidade, confana e imagem positiva?','<ul><li>Destacar os mtodos utilizados para assegurar a clareza, a autenticidade e o contedo adequado das mensagens divulgadas.</li></ul>'),
	(632,29,'d','Como so identificados e avaliados os nveis de conhecimento do universo potencial de cidados-usurios sobre a organizao, seus servios, seus produtos e suas aes?',NULL),
	(633,29,'e','Como  avaliada a imagem da organizao perante os cidados-usurios?','<ul><li>Apresentar os atributos definidos pela organizao para caracterizar sua imagem.</li><li>Destacar os principais indicadores utilizados para medir a imagem da organizao e o conhecimento dos seus servios, seus produtos e suas aes perante os seus usurios.</li></ul>'),
	(634,29,'f','Como  avaliado o atendimento ao universo potencial dos cidados-usurios identificados?','<ul><li>Destacar os principais indicadores utilizados e as aes decorrentes.</li></ul>'),
	(635,30,'a','Como so definidos e divulgados aos cidados-usurios os principais canais de acesso para solicitarem informaes ou esclarecimentos sobre os servios e produtos ou comunicarem suas sugestes ou reclamaes?','<ul><li>Destacar os principais canais de acesso disponibilizados aos cidados-usurios.</li></ul>'),
	(636,30,'b','Como so tratadas as reclamaes e sugestes, formais e informais dos cidados - usurios, visando assegurar a resposta rpida e eficaz e o seu aproveitamento por toda a organizao?','<ul><li>Destacar as principais aes decorrentes e como elas so informadas aos cidados-usurios e repassadas s demais reas da organizao.</li></ul>'),
	(637,30,'c','Como os servios e os produtos, recentemente prestados ou entregues, so acompanhados junto aos cidados-usurios para permitir  organizao gerar solues rpidas e eficazes, evitar problemas de relacionamento e atender s expectativas dos cidados-usurios?',NULL),
	(638,30,'d','Como so avaliadas a satisfao e a insatisfao dos cidados-usurios em relao aos produtos ou servios da organizao e aos da concorrncia, quando pertinente?',NULL),
	(639,30,'e','Como as informaes obtidas dos cidados-usurios so utilizadas para melhorar o seu nvel de satisfao?','<ul><li>Destacar as principais aes implementadas.</li></ul>'),
	(640,31,'a','Como so identificados os aspectos e tratados os impactos sociais e ambientais dos produtos, servios, processos e instalaes da organizao, desde o projeto at a disposio final, sobre os quais tenha infuncia?','<ul><li>Descrever as principais aes e metas para eliminar minimizar ou compensar os impactos sociais e ambientais negativos, incluindo o tratamento de passivos sociais e ambientais.</li><li>Citar os planos existentes para enfrentar eventuais situaes de emergncia visando a reduo das conseqncias negativas.</li></ul>'),
	(641,31,'b','Como os impactos sociais e ambientais dos servios, dos produtos, dos processos e das instalaes, assim como as respectivas polticas, aes e resultados so comunicados  sociedade?','<ul><li>Destacar os critrios adotados para selecionar e priorizar as informaes divulgadas e os canais adotados.</li></ul>'),
	(642,31,'c','Como so tratadas as pendncias ou eventuais sanes referentes aos requisitos legais, regulamentares, ticos ou contratuais, relatando as atualmente existentes?',NULL),
	(643,31,'d','Como so promovidas aes que envolvam a conservao de recursos no - renovveis, a preservao dos ecossistemas e a otimizao do uso de recursos renovveis?',NULL),
	(644,31,'e','Como a fora de trabalho, os fornecedores e as demais partes interessadas so conscientizadas e envolvidas nas questes relativas  responsabilidade socioambiental?',NULL),
	(645,31,'f','Como a organizao direciona esforos para o fortalecimento da sociedade executando ou apoiando projetos sociais ou projetos voltados para o desenvolvimento nacional, regional, local ou setorial, quando pertinente?','<ul><li>Apresentar os critrios estabelecidos para a seleo dos projetos a serem implementados ou apoiados e citar os principais projetos em execuo e implementados.</li><li>Apresentar os principais indicadores de controle da execuo e de impactos dos projetos sociais.</li></ul>'),
	(646,32,'a','Como so divulgados ofcialmente os atos e as informaes sobre os planos, os programas e os projetos da organizao?','<ul><li>Destacar os mtodos utilizados para assegurar que as informaes sejam entendidas e interpretadas.</li></ul>'),
	(647,32,'b','Como as informaes relativas  execuo fsica, oramentria, financeira e  gesto da organizao so tornadas pblicas e tm seu acesso democratizado?',NULL),
	(648,32,'c','Como a sociedade  orientada e estimulada a participar no controle dos resultados organizacionais?','<ul><li>Destacar os mecanismos de relacionamento disponibilizados  sociedade para o exerccio do controle social.</li></ul>'),
	(649,32,'d','Como  estimulado o exerccio da responsabilidade social da fora de trabalho, no cumprimento de seu papel de agente pblico, e o comportamento tico em todos os nveis?','<ul><li>Destacar os padres ticos de conduta estabelecidos.</li></ul>'),
	(650,32,'e','Como so disponibilizados canais de comunicao para receber eventuais denncias de violao da tica?','<ul><li>Destacar as aes tomadas para minimizar esses acontecimentos e seus efeitos.</li></ul>'),
	(651,33,'a','Como so identificadas as necessidades da sociedade em relao ao setor de atuao da organizao e transformadas em requisitos para a formulao e execuo das polticas pblicas, quando pertinente?',NULL),
	(652,33,'b','Como a organizao contribui na formulao ou atua na execuo das polticas pblicas do seu setor?','<ul><li>Apresentar as principais polticas pblicas em que a organizao atua.</li><li>Destacar o nvel de atuao e os principais atores envolvidos.</li><li>Destacar como assegura a participao da sociedade.</li></ul>'),
	(653,33,'c','Como so divulgadas as polticas pblicas e seus respectivos objetivos para a sociedade?','<ul><li>Destacar os principais canais de comunicao utilizados.</li></ul>'),
	(654,33,'d','Como a execuo das polticas pblicas, em seu nvel de atuao,  monitorada e avaliada?','<ul><li>Destacar os indicadores de impacto e demais indicadores utilizados e seu relacionamento com os requisitos estabelecidos.</li></ul>'),
	(655,33,'e','Como  avaliada a satisfao da sociedade e das demais partes interessadas com a implementao das polticas pblicas, em seu nvel de atuao?',NULL),
	(656,34,'a','Como so identificadas as necessidades de coleta, tratamento e guarda de informaes para apoiar a gesto organizacional (as operaes dirias, as estratgias e o progresso dos planos de ao e subsidiar a tomada de deciso em todos os nveis e reas da organizao)?',NULL),
	(657,34,'b','Como so definidos, desenvolvidos, implantados e atualizados os principais sistemas de informao, visando atender s necessidades identificadas da organizao e dos usurios?','<ul><li>Destacar os principais sistemas de informao em uso e sua finalidade.</li><li>Destacar a integrao dos sistemas de informaes da organizao com o sistema de gesto administrativa do governo.</li><li>Destacar as principais tecnologias empregadas visando a integrao das informaes e dos sistemas.</li></ul>'),
	(658,34,'c','Como  estabelecida e mantida a memria administrativa da organizao?','<ul><li>Destacar os principais tipos de registro e seus principais usos.</li></ul>'),
	(659,34,'d','Como a gesto de informao  utilizada para apoiar o cumprimento da misso institucional e promover a integrao da organizao com seus cidados-usurios, sociedade, fornecedores e parceiros?',NULL),
	(660,34,'e','Como as informaes necessrias so colocadas  disposio dos pblicos internos e externos  organizao, incluindo cidados-usurios, fornecedores e parceiros?',NULL),
	(661,34,'f','Como  gerenciada a segurana das informaes?','<ul><li>Destacar os mtodos utilizados para garantir a atualizao, confdencialidade, integridade, preservao e disponibilidade das informaes.</li></ul>'),
	(662,35,'a','Como so identificadas as organizaes consideradas como um referencial comparativo pertinente?','<ul><li>Destacar os critrios utilizados para definir a pertinncia das organizaes para efeito de comparao e apresentar as principais organizaes identificadas.</li></ul>'),
	(663,35,'b','Como so identificadas as fontes, obtidas e mantidas atualizadas as informaes comparativas?','<ul><li>Destacar os critrios utilizados para determinar o mtodo mais apropriado de coleta, considerando as fontes das informaes comparativas identificadas.</li></ul>'),
	(664,35,'c','Como as informaes obtidas so utilizadas para melhorar o conhecimento dos processos organizacionais, estabelecer metas ousadas e, promover melhorias no desempenho da organizao?','<ul><li>Citar as principais aes de melhoria implantadas como decorrncia da utilizao das informaes comparativas.</li></ul>'),
	(665,36,'a','Como o conhecimento  desenvolvido e compartilhado na organizao?','<ul><li>Descrever as prticas existentes para identificao, tratamento e compartilhamento do conhecimento considerado relevante para a organizao.</li><li>Descrever os mtodos para identificar, desenvolver e incorporar novas tecnologias.</li></ul>'),
	(666,36,'b','Como o conhecimento  mantido e protegido?','<ul><li>Descrever, inclusive, os mtodos empregados para atrair e reter especialistas.</li></ul>'),
	(667,36,'c','Como a organizao assegura que a gesto do conhecimento seja utilizada para melhorar os seus processos, produtos e servios?',NULL),
	(668,36,'d','Como so identificados, desenvolvidos e mensurados os ativos intangveis da organizao?','<ul><li>Destacar os principais ativos intangveis da organizao.</li></ul>'),
	(669,37,'a','Como a organizao do trabalho  definida e implementada visando o alto desempenho da organizao?','<ul><li>Destacar as oportunidades para a participao das pessoas nos processos da organizao, possibilitando a iniciativa, a criatividade, a inovao e o desenvolvimento de seu potencial.</li><li>Destacar o grau de autonomia das pessoas para definir, gerir e melhorar os processos da organizao com fexibilidade e rapidez nas respostas aos interesses dos cidados.</li></ul>'),
	(670,37,'b','Como as pessoas so selecionadas para preenchimento de cargos e funes, em consonncia com as estratgias, os objetivos e a misso da organizao?','<ul><li>Destacar as competncias e as habilidades necessrias aos cargos e funes.</li><li>Descrever de que forma so considerados os requisitos de desempenho e so asseguradas a justia e a igualdade de oportunidades para todas as pessoas.</li></ul>'),
	(671,37,'c','Como so definidos e disponibilizados os canais de interlocuo e a negociao com a fora de trabalho da organizao, quando pertinente?',NULL),
	(672,37,'d','Como  estimulada a integrao e a cooperao das pessoas e das equipes?','<ul><li>Destacar as prticas utilizadas para integrar as pessoas recm-contratadas e remanejadas visando prepar-las para a execuo das suas funes.</li><li>Destacar de que forma  assegurada a comunicao eficaz entre as reas da organizao.</li></ul>'),
	(673,37,'e','Como o desempenho das pessoas e das equipes  gerenciado, de forma a estimular a obteno de metas de alto desempenho, a cultura da excelncia na organizao e o desenvolvimento profssional?',NULL),
	(674,37,'f','Como o sistema de remunerao, de reconhecimento e de incentivos para as pessoas estimula o alcance de metas de alto desempenho, do aprendizado e da cultura da excelncia?',NULL),
	(675,38,'a','Como as necessidades de capacitao e de desenvolvimento so identificadas?','<ul><li>Descrever as formas de participao dos lderes e das pessoas da fora de trabalho neste processo.</li></ul>'),
	(676,38,'b','Como as necessidades de capacitao e de desenvolvimento das pessoas so compatibilizadas com as necessidades da organizao, para efeito da definio dos programas de capacitao e desenvolvimento?','<ul><li>Destacar as aes de desenvolvimento de gerentes e pessoas com cargo de chefa.</li><li>Destacar as aes de capacitao das pessoas que atuam diretamente junto aos cidados-usurios.</li></ul>'),
	(677,38,'c','Como os programas de capacitao e desenvolvimento abordam a cultura da excelncia e contribuem para consolidar o aprendizado organizacional?','<ul><li>Citar os principais temas abordados e o pblico alcanado.</li></ul>'),
	(678,38,'d','Como  concebida a forma de realizao dos programas de capacitao e de desenvolvimento considerando as necessidades da organizao e das pessoas e os recursos disponveis?',NULL),
	(679,38,'e','Como as habilidades e os conhecimentos adquiridos so avaliados em relao  sua utilidade na execuo do trabalho e  sua efccia na consecuo das estratgias da organizao?',NULL),
	(680,38,'f','Como  promovido o desenvolvimento integral das pessoas, como indivduos, cidados e profssionais?','<ul><li>Descrever os mtodos de orientao ou aconselhamento, empregabilidade e desenvolvimento de carreira.</li></ul>'),
	(681,39,'a','Como so identificados os perigos e tratados os riscos relacionados  sade ocupacional,  segurana e  ergonomia?','<ul><li>Destacar o modo como as pessoas participam da identificao, preveno e mitigao dos perigos e riscos.</li><li>Destacar os principais fatores relacionados  ergonomia,  sade e  segurana e seus requisitos, indicadores e metas.</li></ul>'),
	(682,39,'b','Como so identificados os fatores que afetam o bem-estar, a satisfao e a motivao considerando os diferentes grupos de pessoas?','<ul><li>Destacar os fatores identificados para os diversos grupos.</li></ul>'),
	(683,39,'c','Como so tratados os fatores que afetam o bem-estar, a satisfao e a motivao das pessoas e mantido um clima organizacional favorvel ao alto desempenho?','<ul><li>Destacar os principais servios, benefcios, programas e polticas colocados  disposio da fora de trabalho, fazendo uma comparao com as prticas de mercado.</li></ul>'),
	(684,39,'d','Como a organizao colabora para a melhoria da qualidade de vida das pessoas e respectivas famlias fora do ambiente de trabalho?','<ul><li>Destacar as principais aes desenvolvidas.</li></ul>'),
	(685,39,'e','Como so avaliados os fatores que afetam o bem-estar, a satisfao e a motivao.',NULL),
	(686,40,'a','Como so identificados e determinados os processos finalsticos e os processos de apoio, considerando a misso institucional da organizao?',NULL),
	(687,40,'b','Como as necessidades dos cidados-usurios e da sociedade so traduzidas em requisitos e incorporadas aos projetos de servios ou produtos e aos processos finalsticos?','<ul><li>Destacar os requisitos ambientais, de sade, de segurana e de ergonomia, quando pertinente.</li><li>Destacar os requisitos a serem atendidos e os seus respectivos indicadores de desempenho.</li></ul>'),
	(688,40,'c','Como os processos finalsticos e os processos de apoio so projetados, visando o cumprimento dos requisitos definidos?','<ul><li>Destacar os mtodos utilizados para a incorporao do conhecimento disponvel na organizao.</li></ul>'),
	(689,40,'d','Como os processos finalsticos e os processos de apoio so controlados?','<ul><li>Destacar o controle dos processos relativos s parcerias institucionais.</li><li>Destacar como so tratadas as no-conformidades identificadas.</li></ul>'),
	(690,40,'e','Como os processos finalsticos e os processos de apoio so refinados?','<ul><li>Descrever as principais metodologias utilizadas para aumentar a confiabilidade dos produtos ou servios fornecidos pela organizao.</li><li>Destacar as aes de desburocratizao dos principais processos finalsticos e dos processos de apoio.</li><li>Destacar as aes de otimizao dos custos associados aos processos finalsticos e de apoio.</li><li>Destacar as principais melhorias implementadas nos ltimos trs anos.</li></ul>'),
	(691,41,'a','Como a organizao identifica potenciais fornecedores e desenvolve a sua cadeia de suprimentos visando assegurar a disponibilidade de fornecimento a longo prazo, melhorar o seu desempenho e o desenvolvimento sustentvel da prpria cadeia?',NULL),
	
	(692,41,'b','Como  realizado o processo de aquisio de bens, de materiais e de servios de forma a assegurar a transparncia e atender a legislao?','<ul><li>Destacar o atendimento s necessidades e aos requisitos especficos da organizao.</li><li>Destacar os indicadores utilizados para a avaliao do processo de suprimento.</li></ul>'),
	(693,41,'c','Como  assegurada a qualidade dos bens, dos produtos e dos servios adquiridos?','<ul><li>Destacar a forma de identificao e qualificao dos fornecedores.</li><li>Destacar a forma como  assegurada a obteno de um equilbrio entre qualidade, prazo e preo.</li></ul>'),
	(694,41,'d','Como  realizada a gesto dos bens materiais, dos bens patrimoniais e dos estoques, quando for pertinente?','<ul><li>Incluir os indicadores utilizados.</li></ul>'),
	(695,41,'e','Como  administrado o relacionamento com os fornecedores?','<ul><li>Destacar a forma de definir e assegurar o atendimento aos requisitos da organizao por parte dos fornecedores.</li></ul>'),
	(696,41,'f','Como os fornecedores so avaliados e prontamente informados sobre seu desempenho?','<ul><li>Apresentar os indicadores utilizados para monitorar o seu desempenho.</li><li>Destacar a forma como a avaliao considera o atendimento aos requisitos estabelecidos, os valores e as diretrizes da organizao e os aspectos relativos  segurana,  sade e ao meio ambiente.</li></ul>'),
	(697,41,'g','Como so minimizados os custos associados  gesto do fornecimento?',NULL),
	(698,41,'h','Como os fornecedores que atuam diretamente nos processos da organizao so envolvidos e comprometidos com os princpios Organizacionais relativos  responsabilidade socioambiental, incluindo os aspectos da segurana e sade?',NULL),
	(699,42,'a','Como  elaborada a proposta oramentria e como so tratadas as restries e liberaes de oramento mais significativas que possam vir a afetar a execuo de suas atividades?',NULL),
	(700,42,'b','Como os processos oramentrios e financeiros so gerenciados para suportar as necessidades estratgicas e operacionais da organizao?',NULL),
	(701,42,'c','Como so monitorados a execuo oramentria e financeira e os possveis realinhamentos entre o oramento, estratgias e objetivos da organizao?','<ul><li>Destacar como so avaliados e administrados os riscos financeiros, quando pertinente.</li></ul>'),
	(702,42,'d','Como so selecionadas as melhores opes e realizadas captaes, investimentos e aplicaes de recursos financeiros, quando pertinente?',NULL),
	(703,42,'e','Como as operaes que geram receita so acompanhadas?','Destacar, quando pertinente:<ul><li>a gerncia do patrimnio e das receitas decorrentes do seu uso;</li><li>a compatibilizao do custeio e do investimento com o oramento aprovado ? responsabilidade fiscal;</li><li>a gerncia das receitas decorrentes do recolhimento de taxas por prestao de servios ou de impostos.</li></ul>'),
	(704,42,'f','Como  so  administrados  os  parmetros oramentrios e financeiros?','<ul><li>Apresentar os principais parmetros utilizados.</li></ul>'),
	(705,43,'a','Apresentar os resultados dos principais indicadores relativos aos cidados-usurios. Estratificar por grupos de cidados-usurios, segmentos de mercado ou tipos de produtos, quando aplicvel.','<ul><li>Incluir os nveis de desempenho associados aos principais requisitos de partes interessadas, assim como os nveis de desempenho de organizaes consideradas como referencial comparativo pertinente; explicar, resumidamente, os resultados apresentados, esclarecendo eventuais tendncias adversas, nveis de desempenho abaixo do esperado pelas partes interessadas e comparaes desfavorveis.</li></ul>'),
	(706,44,'a','Apresentar os resultados dos principais indicadores relativos  sociedade, incluindo os relativos  atuao socioambiental,  tica, ao controle social e s polticas pblicas. Estratificar os resultados por instalaes, quando aplicvel.','<ul><li>Incluir os nveis de desempenho associados aos principais requisitos de partes interessadas assim como os nveis de desempenho de organizaes consideradas como referencial comparativo pertinente; explicar, resumidamente, os resultados apresentados, esclarecendo eventuais tendncias adversas, nveis de desempenho abaixo do esperado pelas partes interessadas e comparaes desfavorveis.</li></ul>'),
	(707,45,'a','Apresentar os resultados dos principais indicadores relativos  gesto oramentria e financeira. Estratificar os resultados por unidades ou fliais, quando aplicvel.','Incluir os nveis de desempenho associados aos principais requisitos de partes interessadas, assim como os nveis de desempenho de organizaes consideradas como referencial comparativo pertinente; explicar, resumidamente, os resultados apresentados, esclarecendo eventuais tendncias adversas, nveis de desempenho abaixo do esperado pelas partes interessadas e comparaes desfavorveis.<br>Apresentar resultados:<ul><li>de eficincia na aplicao dos recursos oramentrios e financeiros da organizao; destacar os resultados dos seguintes indicadores: relao entre recurso executado versus recurso planejado e cumprimento das metas planejadas versus recursos executados;</li><li>de desempenho na conservao do patrimnio e na arrecadao de receitas decorrentes do seu uso, quando pertinente;</li><li>de arrecadao de receitas decorrentes de recolhimento de taxas por prestao de servios ou de impostos, quando pertinente;</li><li>referentes ao desempenho financeiro e/ou valores econmicos, no caso de empresas pblicas e sociedades de economia mista que atuam no mercado.</li></ul>'),
	(708,46,'a','Apresentar os resultados dos principais indicadores relativos s pessoas, incluindo os relativos aos sistemas de trabalho,  capacitao e ao desenvolvimento e  qualidade de vida. Estratificar os resultados por grupos de pessoas da fora de trabalho, funes na organizao e, quando aplicvel, por instalaes.','<ul><li>Incluir os nveis de desempenho associados aos principais requisitos de partes interessadas, assim como os nveis de desempenho de organizaes consideradas como referencial comparativo pertinente; explicar, resumidamente, os resultados apresentados, esclarecendo eventuais tendncias adversas, nveis de desempenho abaixo do esperado pelas partes interessadas e comparaes desfavorveis.</li><li>Apresentar resultados dos principais indicadores de eficcia e melhoria dos sistemas de trabalho; avaliao, capacitao e desenvolvimento de pessoas e de bem-estar e satisfao de pessoas.</li></ul>'),
	(709,47,'a','Apresentar os resultados dos principais indicadores relativos aos produtos adquiridos e  gesto de relacionamento com os fornecedores. estratificar os resultados por grupos de fornecedores ou tipos de produtos adquiridos, quando aplicvel.','<ul><li>Incluir os nveis de desempenho associados aos principais requisitos de partes interessadas, assim como os nveis de desempenho de organizaes consideradas como referencial comparativo pertinente; explicar, resumidamente, os resultados apresentados, esclarecendo eventuais tendncias adversas, nveis de desempenho abaixo do esperado pelas partes interessadas e comparaes desfavorveis.</li></ul>'),
	(710,48,'a','Apresentar os resultados dos indicadores relativos ao produto/servio e  gesto dos processos finalsticos e de apoio.','<ul><li>Incluir os nveis de desempenho associados aos principais requisitos de partes interessadas, assim como os nveis de desempenho de organizaes consideradas como referencial comparativo pertinente; explicar, resumidamente, os resultados apresentados, esclarecendo eventuais tendncias adversas, nveis de desempenho abaixo do esperado pelas partes interessadas e comparaes desfavorveis.</li></ul>');
	  
/*Exercito 500*/  
INSERT INTO pratica_marcador (pratica_marcador_id, pratica_marcador_item, pratica_marcador_letra, pratica_marcador_texto, pratica_marcador_extra) VALUES    
	(800,119,'a','Como so tomadas as decises da OM relativas aos principais processos?',NULL),
	(801,119,'b','Como so tomadas as decises da OM relativas ao seu plano de gesto?',NULL),
	(802,119,'c','Como o Comando comunica as principais decises tomadas, de carter ostensivo, a todos os escales e integrantes da OM?',NULL),
	(803,119,'d','Como ocorre a implementao dessas decises em cada escalo?',NULL),
	(804,119,'e','Como so controlados pelo Comando os resultados das Sees do EM ou equivalentes?','<ul><li>Apresente os Indicadores de Desempenho utilizados para o ciclo de controle.</li></ul>'),
	(805,119,'f','Como o Comando da OM presta conta dos resultados organizacionais ao escalo enquadrante?',NULL),
	(806,119,'g','Como so estabelecidos os valores, contidos no Plano de Gesto, necessrios ao cumprimento de sua Misso?',NULL),
	(807,119,'h','Como so atualizados os valores, contidos no Plano de Gesto, necessrios ao cumprimento de sua Misso?',NULL),
	(808,119,'h','Como os princpios da Administrao Pblica (legalidade, impessoalidade, moralidade, publicidade e eficincia) so disseminados e utilizados por todos os integrantes da OM?',NULL),
	(809,119,'j','Descreva a atuao do Comando junto ao Escalo Superior e ao Escalo de Apoio para melhorar as condies de cumprimento da misso.',NULL),
	(810,119,'k','Como o Comando atua para verificar se os valores so aplicados pelos integrantes da OM?',NULL),
	(811,119,'l','Como so estabelecidos os principais padres de trabalho e regras de funcionamento para regular as atividades internas e externas da OM?',NULL),
	(812,119,'m','Como  verificado o cumprimento dos padres de trabalho e regras de funcionamento das atividades da OM?',NULL),
	(813,119,'n','Apresente os Indicadores de Desempenho utilizados para possibilitar as aes corretivas em cada processo ou atividade.',NULL),
	(814,120,'a','Descreva a atuao do Comando na busca de parcerias para facilitar o cumprimento da misso, capacitao do pessoal, melhorar a imagem da OM e do EB.',NULL),
	(815,120,'b','Como os valores da OM so disseminados pelo Comando aos seus integrantes?',NULL),
	(816,120,'c','Como os valores da OM so utilizados pelos seus integrantes?',NULL),
	(817,120,'d','Como o Comando atua para verificar se os valores so de conhecimento de todos os integrantes da OM?',NULL),
	(818,120,'e','Como o Comando atua para verificar se os valores so aplicados por todos os integrantes da OM?',NULL),
	(819,120,'f','Como  incentivado o comprometimento de todos os integrantes da OM com o Sistema de Excelncia no Exrcito Brasileiro (SE-EB)?','<ul><li>Apresente as melhorias nos processos da OM e a sua evoluo a cada autoavaliao.</li></ul>'),
	(820,120,'g','Como  estimulado o aprendizado e a implantao de melhorias em todos os nveis da OM?','<ul><li>Apresente as melhorias implementadas na OM nos ltimos trs anos.</li></ul>'),
	(821,121,'a','Como so analisados os desempenhos dos diversos nveis da OM?',NULL),
	(822,121,'b','Como  analisado o desempenho integrado de toda a OM?',NULL),
	(823,121,'c','Como so identificadas as necessidades de informaes comparativas para avaliar o desempenho da OM?',NULL),
	(824,121,'d','Como so avaliadas as estratgias contidas no Plano de Gesto da OM?',NULL),
	(825,121,'e','Como so avaliados os Objetivos Organizacionais contidos no Plano de Gesto da OM?',NULL),
	(826,121,'f','Como as decises decorrentes da anlise do desempenho da OM so comunicadas aos integrantes da organizao em todos os nveis?',NULL),
	(827,121,'g','Como  acompanhada a implementao das decises decorrentes da anlise do desempenho da OM?',NULL),
	(828,122,'a','Como a OM definiu a sua misso, considerando a misso imposta (portaria de criao e quadro de organizao), as diretrizes e planos do escalo superior, as normas, regulamentos e as peculiaridades de sua rea de jurisdio?',NULL),
	(829,122,'b','Como a OM garante o entendimento de sua misso por todos os seus integrantes?',NULL),
	(830,122,'c','Como a OM definiu sua viso de futuro?',NULL),
	(831,122,'d','Como o ambiente interno  analisado?',NULL),
	(832,122,'e','Como o ambiente externo  analisado?',NULL),
	(833,122,'f','Como a OM definiu seus objetivos organizacionais?',NULL),
	(834,122,'g','Como a OM definiu suas estratgias?',NULL),
	(835,122,'h','Como o Plano de Gesto  comunicado a todos os integrantes da OM?',NULL),
	(836,123,'a','Como as estratgias organizacionais so desdobradas em Planos de Ao?',NULL),
	(837,123,'b','Como so definidos os Indicadores de Desempenho (ID) para a avaliao das estratgias?',NULL),
	(838,123,'c','Como so definidas as metas da Organizao Militar?',NULL),
	(839,123,'d','Como as metas estabelecidas so transmitidas para as diversas reas da OM?',NULL),
	(840,123,'e','Como os diferentes recursos so alocados para assegurar a implementao dos Planos de Ao?',NULL),
	(841,123,'f','Como  realizado o acompanhamento da implementao dos Planos de Ao?',NULL),
	(842,124,'a','Como a OM identifica seus principais produtos e servios?',NULL),
	(843,124,'b','Apresente os principais produtos e servios da OM.',NULL),
	(844,124,'c','Como a OM identifica os principais usurios dos seus produtos e servios?',NULL),
	(845,124,'d','Apresente os respectivos usurios dos principais produtos e servios da OM.',NULL),
	(846,124,'e','Como so identificados os principais requisitos e especificaes dos produtos e servios apresentados na alnea B deste item, buscando atender s necessidades do escalo superior?',NULL),
	(847,124,'f','Como a OM avalia o atendimento s necessidades do escalo superior e usurios de seus produtos e servios?','<ul><li>Apresente, na resposta da alnea, os indicadores de desempenho utilizados e cadastre-os na tela de entrada do Critrio 3.</li></ul>'),
	(848,124,'g','Como os principais produtos e servios so divulgados aos usurios?',NULL),
	(849,125,'a','Quais os principais canais de acesso para que os usurios e o escalo superior obtenham informaes sobre os produtos e servios da OM?',NULL),
	(850,125,'b','Como so tratadas as solicitaes dos usurios e do escalo superior?',NULL),
	(851,125,'c','Como a OM avalia o atendimento s necessidades do escalo superior e dos usurios?',NULL),
	(852,125,'d','Como so melhorados os processos e produtos da OM com base nas informaes do escalo superior e usurios?','<ul><li>Apresente as 3 ltimas melhorias implementadas.</li></ul>'),
	(853,125,'e','Como a OM avalia a satisfao de seus usurios, quando pertinente?',NULL),
	(854,126,'a','Como a OM identifica os impactos sociais positivos de seus servios, processos e instalaes?',NULL),
	(855,126,'b','Como a OM identifica os impactos ambientais positivos de seus servios, processos e instalaes?',NULL),
	(856,126,'c','Como a OM identifica os impactos sociais negativos de seus servios, processos e instalaes?',NULL),
	(857,126,'d','Como a OM identifica os impactos ambientais negativos de seus servios, processos e instalaes?',NULL),
	(858,126,'e','Quais so os impactos sociais e ambientais dos servios, processos e instalaes da OM?',NULL),
	(859,126,'f','Como a OM trata os impactos sociais e ambientais negativos dos servios, processos e instalaes da OM?','<ul><li>Apresente as aes em desenvolvimento.</li></ul>'),
	(860,126,'g','Como so tratadas as pendncias ou eventuais sanes referentes aos requisitos legais, regulamentares e ticos?','<ul><li>Apresente as pendncias atualmente existentes.</li></ul>'),
	(861,127,'a','Como a OM seleciona projetos sociais dentro de sua rea de atuao?',NULL),
	(862,127,'b','Como a OM gerencia os projetos sociais sob sua responsabilidade?',NULL),
	(863,127,'c','Quais os projetos sociais desenvolvidos pela OM nos ltimos cinco anos?',NULL),
	(864,127,'d','Como a OM conscientiza seus integrantes sob sua responsabilidade social?',NULL),
	(865,127,'e','Como a OM estimula o exerccio da responsabilidade social dos seus integrantes?',NULL),
	(866,127,'f','Como so disponibilizados canais de comunicao para receber eventuais denncias de violao da tica?',NULL),
	(867,128,'a','Quais so as aes de execuo de polticas pblicas a cargo da OM?',NULL),
	(868,128,'b','Como a OM planeja as aes de execuo de polticas pblicas a seu cargo?',NULL),
	(869,128,'c','Como  avaliada a satisfao do escalo superior nas aes de execuo das polticas pblicas a cargo da OM?','<ul><li>Apresente os ID utilizados pela OM.</li></ul>'),
	(870,128,'d','Como  avaliada a satisfao da sociedade nas aes de execuo das polticas pblicas a cargo da OM?','<ul><li>Apresente os ID utilizados pela OM.</li></ul>'),
	(871,129,'a','Como a OM identifica as necessidades de informaes atinentes  execuo dos processos organizacionais?',NULL),
	(872,129,'b','Como a OM identifica as necessidades de informaes atinentes  execuo dos planos de ao contidos em seu Plano de Gesto?',NULL),
	(873,129,'c','Como so atualizadas as informaes da OM?',NULL),
	(874,129,'d','Como so implantados e atualizados os principais sistemas de informao, visando atender s necessidades da OM identificadas?',NULL),
	(875,129,'e','Como  estabelecida e mantida a memria administrativa da OM?',NULL),
	(876,129,'f','Como so disponibilizadas as informaes para todos os seus usurios constantes do Perfil da OM?',NULL),
	(877,129,'g','Como  gerenciada a segurana das informaes em meio fsico?',NULL),
	(878,129,'h','Como  gerenciada a segurana das informaes em meio eletrnico?',NULL),
	(879,130,'a','Como a OM identifica outras organizaes (civis ou militares) cujos processos podem ser considerados referenciais comparativos pertinentes para o cumprimento da misso?',NULL),
	(880,130,'b','Quais os critrios utilizados para definir as organizaes consideradas referencial comparativo para a OM?',NULL),
	(881,130,'c','Quais os canais utilizados pela OM para obter as informaes comparativas?',NULL),
	(882,130,'d','Como so atualizadas as informaes comparativas utilizadas pela OM?',NULL),
	(883,130,'e','Como as informaes obtidas so utilizadas para melhorar os processos organizacionais?',NULL),
	(884,130,'f','Apresente as trs ltimas melhorias implementadas nos processos da OM decorrentes do uso de informaes comparativas.',NULL),
	(885,130,'g','Como as informaes obtidas so utilizadas para melhorar o desempenho da OM?',NULL),
	(886,130,'h','Apresente as trs ltimas melhorias implementadas no desempenho da OM decorrentes do uso de informaes comparativas.',NULL),
	(887,131,'a','Como a OM identifica suas necessidades de competncias para desempenho das suas funes previstas no QCP?',NULL),
	(888,131,'b','Como a OM identifica as necessidades dos diversos tipos de conhecimento do meio civil para seus integrantes?',NULL),
	(889,131,'c','Como a OM assegura que os diversos conhecimentos existentes sejam utilizados para melhorar os seus processos e servios?',NULL),
	(890,131,'d','Quais as melhorias implementadas na OM decorrentes do conhecimento de seus integrantes?',NULL),
	(891,131,'e','Como a OM retm o conhecimento de seus integrantes por meio da padronizao de processos e outras prticas?',NULL),
	(892,132,'a','Como a OM seleciona as pessoas para preenchimento de cargos e funes destinadas a militares e civis temporrios?',NULL),
	(893,132,'b','Como a OM avalia o desempenho dos integrantes temporrios?',NULL),
	(894,132,'c','Como so disponibilizados os canais de comunicao dos integrantes da OM com o Comando da OM?',NULL),
	(895,132,'d','Como  estimulada a cooperao entre os militares da OM?',NULL),
	(896,132,'e','Como as pessoas recm apresentadas so integradas  cultura e ao ambiente da OM, visando prepar-las para o exerccio das suas funes?',NULL),
	(897,132,'f','Como o sistema de reconhecimento para os integrantes da OM estimula o alcance de metas de desempenho?','<ul><li>Cite as formas de recompensas utilizadas pela OM.</li></ul>'),
	(898,133,'a','Como as necessidades de treinamento dos integrantes da OM so identificadas?',NULL),
	(899,133,'b','Como os integrantes em cargo de chefia na OM so treinados em ferramentas e metodologias de gesto pela excelncia?',NULL),
	(900,133,'c','Como a OM treina seus integrantes nos assuntos relacionados  gesto?',NULL),
	(901,133,'d','Apresente as principais aes de treinamento na rea da gesto.',NULL),
	(902,133,'e','Como a OM gerencia os treinamentos necessrios ao cumprimento dos seus Planos de Ao?',NULL),
	(903,133,'f','Como a OM avalia os resultados dos treinamentos realizados na melhoria do cumprimento de sua misso?',NULL),
	(904,134,'a','Como a OM identifica os riscos relacionados  sade de seus integrantes na execuo de seus processos e atividades?','<ul><li>Apresente os riscos relacionados  sade dos integrantes da OM inerentes  execuo de seus processos e atividades.</li></ul>'),
	(905,134,'b','Como a OM identifica os riscos relacionados  segurana de seus integrantes na execuo de seus processos e atividades?','<ul><li>Apresente os riscos relacionados  segurana dos integrantes da OM inerentes  execuo de seus processos e atividades.</li></ul>'),
	(906,134,'c','Como a OM trata os riscos relacionados  sade de seus integrantes na execuo de seus processos e atividades?',NULL),
	(907,134,'d','Como a OM trata os riscos relacionados  segurana de seus integrantes na execuo de seus processos e atividades?',NULL),
	(908,134,'e','Como so identificados os fatores que afetam o bem-estar, a satisfao e a motivao dos integrantes da OM?',NULL),
	(909,134,'f','Como so tratados os fatores que afetam o bem-estar, a satisfao e a motivao dos militares da OM e mantido um clima organizacional favorvel?','<ul><li>Apresente as aes para a melhoria do bem-estar, da satisfao e da motivao de seus integrantes.</li></ul>'),
	(910,135,'a','Como so identificados os principais processos finalsticos necessrios ao cumprimento da misso da OM?','<ul><li>Apresente os principais processos finalsticos.</li></ul>'),
	(911,135,'b','Como so identificados os principais processos de apoio necessrios ao cumprimento da misso da OM?','<ul><li>Apresente os principais processos de apoio.</li></ul>'),
	(912,135,'c','Como as necessidades do escalo superior e usurios da OM so traduzidas em requisitos de qualidade para os processos finalsticos?',NULL),
	(913,135,'d','Como os processos finalsticos so controlados?','<ul><li>Cadastre os indicadores utilizados no ciclo de controle dos processos finalsticos.</li></ul>'),
	(914,135,'e','Como os processos de apoio so controlados?','<ul><li>Cadastre os indicadores utilizados no ciclo de controle dos processos de apoio.</li></ul>'),
	(915,135,'f','Como so tratados os problemas que so identificados nos processos finalsticos?',NULL),
	(916,135,'g','Como so tratados os problemas que so identificados nos processos de apoio?',NULL),
	(917,135,'h','Como os processos finalsticos so melhorados?',NULL),
	(918,135,'i','Apresente as melhorias implementadas nos ltimos trs anos em cada processo finalstico.',NULL),
	(919,135,'j','Como os processos de apoio so melhorados?',NULL),
	(920,135,'k','Apresente as melhorias implementadas nos ltimos trs anos em cada processo de apoio.',NULL),
	(921,136,'a','Como so identificadas as necessidades de insumos dos diversos setores e processos da OM?',NULL),
	(922,136,'b','Como so priorizados os suprimentos a serem adquiridos pela OM?',NULL),
	(923,136,'c','Como  assegurada a qualidade dos bens, produtos e servios adquiridos pela OM?',NULL),
	(924,136,'d','Como a OM garante a exatido entre os bens materiais existentes e os registros contbeis da OM?',NULL),
	(925,136,'e','Como os fornecedores civis so avaliados?',NULL),
	(926,136,'f','Como os fornecedores civis so informados sobre seu desempenho?',NULL),
	(927,136,'g','Como so minimizados os custos associados  gesto do fornecimento?',NULL),
	(928,136,'h','Como a OM assegura em seus processos de suprimento a obteno de um equilbrio entre qualidade, prazo e preo?',NULL),
	(929,137,'a','Como a OM identifica as necessidades de recursos para a execuo de seus processos?',NULL),
	(930,137,'b','Como a OM identifica as necessidades de recursos para a execuo de seu plano de gesto?',NULL),
	(931,137,'c','Como a OM informa os rgos pertinentes sobre suas necessidades de recursos para a execuo de seu plano de gesto?',NULL),
	(932,137,'d','Como a OM acompanha a descentralizao de recursos necessrios para a execuo de seu plano de gesto?',NULL),
	(933,137,'e','Como a OM compatibiliza os recursos recebidos com as necessidades de recursos de seu plano de gesto?',NULL),
	(934,138,'a','Grficos dos resultados dos principais Indicadores de Desempenho (ID) Estratgicos relativos ao Plano de Gesto da OM.','<ul><li>Indicadores de Desempenho do Plano de Gestao - Critrio 2 Estratgias e Planos e Critrio 7 Processos</li></ul>'),
	(935,139,'a','Grficos dos resultados dos principais Indicadores de Desempenho (ID) Operacionais relativos aos cidados-usurios. \r\n','<ul><li>Indicadores de Desempenho do Plano de Gestao - Critrio 3 Cidados</li></ul>'),
	(936,140,'a','Grficos dos resultados dos principais Indicadores de Desempenho (ID) Operacionais relativos aos sistemas de trabalho,  capacitao e desenvolvimento e  qualidade de vida.','<ul><li>Indicadores de Desempenho do Plano de Gestao - Critrio 1 Liderana e Critrio 6 Pessoas</li></ul>'),
	(937,141,'a','Indicadores de Desempenho do Plano de Gestao',NULL),
	(938,142,'a','Grficos dos resultados dos principais Indicadores de Desempenho (ID) Operacionais relativos aos produtos adquiridos pela OM e  gesto de relacionamento com os fornecedores.','<ul><li>Indicadores de Desempenho do Plano de Gestao - Critrio 7 Processos</li></ul>'),
	(939,143,'a','Grficos dos resultados dos principais Indicadores de Desempenho (ID) Operacionais relativos  sociedade.','<ul><li>Indicadores de Desempenho do Plano de Gestao - Critrio  4 Sociedade</li></ul>'),
	(940,144,'a','Grficos dos resultados dos principais Indicadores de Desempenho (ID) Operacionais relativos  gesto oramentria e financeira da OM.','<ul><li>Indicadores de Desempenho do Plano de Gestao - Critrio 7 Processos</li></ul>');
	  
   
TRUNCATE TABLE pratica_verbo;

/* FNQ 250 */
INSERT INTO pratica_verbo(pratica_verbo_marcador, pratica_verbo_texto) VALUES 
	(1,'Atualizar os valores necessrios  promoo da excelncia.'),
	(1,'Atualizar os valores necessrios  criao de valor para todas as partes interessadas.'),
	(1,'Atualizar os princpios organizacionais  promoo da excelncia.'),
	(1,'Atualizar os princpios organizacionais  criao de valor para todas as partes interessadas.'),
	(2,'Comunicar os valores  fora de trabalho e, quando pertinente, s demais partes interessadas.'),
	(2,'Comunicar os princpios organizacionais  fora de trabalho e, quando pertinente, s demais partes interessadas.'),
	(3,'Tratar as questes ticas nos relacionamentos internos.'),
	(3,'Tratar as questes ticas nos relacionamentos externos.'),
	(4,'Tomar as principais decises.'),
	(4,'Comunicar as principais decises.'),
	(4,'Implementar as principais decises.'),
	(5,'Exercer a liderana.'),
	(5,'Interagir com as partes interessadas.'),
	(6,'Estabelecer os principais padres de trabalho para os processos gerenciais.'),
	(6,'Verificar o cumprimento dos principais padres de trabalho para os processos gerenciais.'),
	(7,'Melhorar os processos gerenciais  por meio do aprendizado.'),
	(8,'Analisar o desempenho operacional da organizao.'),
	(8,'Analisar o desempenho estratgico da organizao.'),
	(9,'Definir as estratgias da organizao, considerando o ambiente externo.'),
	(9,'Definir as estratgias da organizao, considerando o ambiente interno.'),
	(10,'Definir os indicadores para a avaliao da implementao das estratgias e definio dos respectivos planos de ao.'),
	(10,'Definir os indicadores para o estabelecimento das metas e definio dos respectivos planos de ao.'),
	(11,'Comunicar as estratgias s pessoas da fora de trabalho e para as demais partes interessadas, quando pertinentes.'),
	(11,'Comunicar as metas s pessoas da fora de trabalho e para as demais partes interessadas, quando pertinentes.'),
	(11,'Comunicar os planos de ao s pessoas da fora de trabalho e para as demais partes interessadas, quando pertinentes.'),
	(12,'Realizar o monitoramento da implementao dos planos de ao.'),
	(13,'Definir os clientes-alvo.'),
	(14,'Identificar as necessidades e expectativas dos clientes-alvo para a definio e melhoria dos processos da organizao.'),
	(14,'Analisar as necessidades e expectativas dos clientes-alvo  para a definio e melhoria dos processos da organizao.'),
	(14,'Utilizar as necessidades e expectativas dos clientes-alvo  para a definio e melhoria dos processos da organizao.'),
	(15,'Divulgar os produtos da organizao .'),
	(15,'Divulgar as marcas da organizao .'),
	(16,'Tratar as solicitaes, formais ou informais, dos clientes visando a assegurar que sejam pronta e eficazmente atendidas ou solucionadas.'),
	(16,'Tratar as reclamaes, formais ou informais, dos clientes visando a assegurar que sejam pronta e eficazmente atendidas ou solucionadas.'),
	(16,'Tratar as sugestes, formais ou informais, dos clientes visando a assegurar que sejam pronta e eficazmente atendidas ou solucionadas.'),
	(17,'Avaliar a satisfao dos clientes.'),
	(18,'Tratar os impactos sociais e ambientais negativos de produtos.'),
	(18,'Tratar os impactos sociais e ambientais negativos de processos.'),
	(18,'Tratar os impactos sociais e ambientais negativos de instalaes.'),
	(19,'Identificar os requisitos legais aplicveis  organizao relativos a questes socioambientais.'),
	(19,'Identificar os requisitos regulamentares aplicveis  organizao relativos a questes socioambientais.'),
	(19,'Identificar os requisitos contratuais aplicveis  organizao relativos a questes socioambientais.'),
	(19,'Analisar os requisitos legais aplicveis  organizao relativos a questes socioambientais.'),
	(19,'Analisar os requisitos regulamentares aplicveis  organizao relativos a questes socioambientais.'),
	(19,'Analisar os requisitos contratuais aplicveis  organizao relativos a questes socioambientais.'),
	(20,'Selecionar e promover de forma voluntria aes para minimizao de consumo de recursos renovveis.'),
	(20,'Selecionar e promover de forma voluntria aes de conservao de recursos no renovveis.'),
	(20,'Selecionar e promover de forma voluntria aes de reciclagem ou reutilizao de materiais.'),
	(21,'Selecionar os projetos sociais.'),
	(21,'Desenvolver os projetos sociais.'),
	(21,'Apoiar os projetos sociais.'),
	(22,'Definir os sistemas de informao , considerando-se as necessidades de informaes para apoiar as operaes dirias em todos os nveis e reas da organizao.'),
	(22,'Definir os sistemas de informao , considerando-se as necessidades de informaes para apoiar a tomada de deciso em todos os nveis e reas da organizao.'),
	(23,'Garantir a segurana das informaes.'),
	(24,'Compartilhar os conhecimentos geradores de diferenciais para a organizao.'),
	(24,'Reter os conhecimentos geradores de diferenciais para a organizao.'),
	(25,'Definir a organizao do trabalho.'),
	(25,'Implementar a organizao do trabalho.'),
	(26,'Como as pessoas so selecionadas, internamente, e contratadas.'),
	(26,'Como as pessoas so selecionadas, externamente, e contratadas.'),
	(27,'Identificar as necessidades de capacitao das pessoas visando ao xito das estratgias.'),
	(27,'Identificar as necessidades de desenvolvimento das pessoas visando ao xito das estratgias.'),
	(27,'Identificar as necessidades de desenvolvimento das pessoas visando a formao da cultura da excelncia.'),
	(27,'Identificar as necessidades de desenvolvimento das pessoas visando a formao da cultura da excelncia.'),
	(28,'Identificar os perigos relacionados  sade ocupacional.'),
	(28,'Identificar os perigos relacionados  segurana.'),
	(28,'Tratar os perigos relacionados  sade ocupacional.'),
	(28,'Tratar os perigos relacionados  segurana.'),
	(29,'Avaliar a satisfao das pessoas.'),
	(30,'Determinar os requisitos dos processos principais do negcio, considerando as necessidades dos clientes e demais partes interessadas.'),
	(30,'Determinar os requisitos dos processos principais do negcio, considerando as expectativas dos clientes e demais partes interessadas.'),
	(30,'Determinar os requisitos dos processos de apoio do negcio, considerando as necessidades dos clientes e demais partes interessadas.'),
	(30,'Determinar os requisitos dos processos de apoio do negcio, considerando as expectativas dos clientes e demais partes interessadas.'),
	(31,'Assegurar o atendimento dos requisitos.'),
	(31,'Assegurar o atendimento dos processos principais do negcio.'),
	(31,'Assegurar o atendimento dos processos de apoio.'),
	(32,'Analisar os processos principais do negcio.'),
	(32,'Melhorar os processos principais do negcio.'),
	(32,'Analisar os processos de apoio.'),
	(32,'Melhorar os processos de apoio.'),
	(33,'Selecionar os fornecedores.'),
	(33,'Avaliar os fornecedores.'),
	(34,'Elaborar o oramento.'),
	(34,'Controlar o oramento.'),
	(34,'Manter o fluxo financeiro equilibrado.'),
	(35,'Apresentar os resultados relativos  gesto econmico-financeira.'),
	(36,'Apresentar os resultados relativos aos clientes e aos mercados.'),
	(37,'Apresentar os resultados relativos  sociedade.'),
	(38,'Apresentar os resultados relativos s pessoas.'),
	(39,'Apresentar os resultados relativos ao produto e  gesto dos processos principais do negcio.'),
	(39,'Apresentar os resultados relativos ao produto e  gesto dos processos de apoio.'),
	(40,'Apresentar os resultados relativos aos fornecedores.');

/* FNQ 500 */
INSERT INTO pratica_verbo(pratica_verbo_marcador, pratica_verbo_texto) VALUES 
	(100,'Atualizar os valores necessrios  criao de valor para todas as partes interessadas.'),
	(100,'Atualizar os princpios organizacionais necessrios  criao de valor para todas as partes interessadas.'),
	(101,'Tratar as questes ticas nos relacionamentos internos.'),
	(101,'Tratar as questes ticas nos relacionamentos externos.'),
	(102,'Identificar os riscos empresariais mais significativos que possam afetar o negcio.'),
	(102,'Classificar os riscos empresariais mais significativos que possam afetar o negcio.'),
	(102,'Tratar os riscos empresariais mais significativos que possam afetar o negcio.'),
	(103,'Tomar as principais decises.'),
	(103,'Comunicar as principais decises.'),
	(103,'Implementar as principais decises.'),
	(104,'Prestar conta das suas aes a quem a elegeu, nomeou ou designou.'),
	(104,'Prestar conta dos resultados alcanados a quem a elegeu, nomeou ou designou.'),
	(105,'Exercer a liderana, identificando suas expectativas.'),
	(105,'Exercer a liderana, buscando o alinhamento de interesses.'),
	(105,'Interagir com as partes interessadas, identificando suas expectativas.'),
	(105,'Interagir com as partes interessadas, buscando o alinhamento de interesses.'),
	(106,'Comunicar os valores para fora de trabalho e, quando pertinentes, s demais partes interessadas.'),
	(106,'Comunicar os princpios organizacionais para fora de trabalho e, quando pertinentes, s demais partes interessadas.'),
	(107,'Avaliar nos lderes, as competncias necessrias para o exerccio da liderana.'),
	(107,'Desenvolver nos lderes, as competncias necessrias para o exerccio da liderana.'),
	(108,'Estabelecer os principais padres de trabalho para os processos gerenciais.'),
	(108,'Verificar o cumprimento dos principais padres de trabalho para os processos gerenciais.'),
	(109,'Melhorar os processos gerenciais por meio do aprendizado.'),
	(110,'Identificar  as necessidades de informaes comparativas para analisar o desempenho operacional da organizao.'),
	(110,'Identificar  as necessidades de informaes comparativas para analisar o desempenho estratgico da organizao.'),
	(111,'Analisar o desempenho operacional da organizao.'),
	(111,'Analisar o desempenho estratgico da organizao.'),
	(112,'Comunicar as decises decorrentes da anlise do desempenho da organizao  fora de trabalho, em todos os nveis da organizao.'),
	(112,'Comunicar as decises decorrentes da anlise do desempenho da organizao a outras partes interessadas, quando pertinente.'),
	(113,'Acompanhar a implementao das decises decorrentes da anlise do desempenho da organizao.'),
	(114,'Realizar a anlise do ambiente externo.'),
	(115,'Realizar a anlise do ambiente interno.'),
	(116,'Avaliar as alternativas decorrentes das anlises dos ambientes e definir as estratgias da organizao.'),
	(117,'Definir os indicadores para a avaliao da implementao das estratgias e dos respectivos planos de ao.'),
	(117,'Estabelecer as metas de curto e longo prazos e os respectivos planos de ao.'),
	(118,'Alocar os recursos para assegurar a implementao dos planos de ao.'),
	(119,'Comunicar as estratgias s pessoas da fora de trabalho e para as demais partes interessadas, quando pertinente.'),
	(119,'Comunicar as metas s pessoas da fora de trabalho e para as demais partes interessadas, quando pertinente.'),
	(119,'Comunicar os planos de ao s pessoas da fora de trabalho e para as demais partes interessadas, quando pertinente.'),
	(120,'Realizar o monitoramento da implementao dos planos de ao.'),
	(121,'Segmentar o mercado.'),
	(122,'Identificar as necessidades e expectativas dos clientes-alvo para definio e melhoria dos processos da organizao.'),
	(122,'Analisar as necessidades e expectativas dos clientes-alvo para definio e melhoria dos processos da organizao.'),
	(122,'Utilizar as necessidades e expectativas dos clientes-alvo para definio e melhoria dos processos da organizao.'),
	(123,'Divulgar os produtos e as marcas da organizao aos clientes e ao mercado de forma a criar credibilidade.'),
	(123,'Divulgar os produtos e as marcas da organizao aos clientes e ao mercado de forma a criar confiana.'),
	(123,'Divulgar os produtos e as marcas da organizao aos clientes e ao mercado de forma a criar imagem positiva.'),
	(124,'Avaliar a imagem da organizao perante os clientes.'),
	(125,'Definir os canais de relacionamento, considerando eventuais diferenas nos perfis dos clientes.'),
	(125,'Divulgar os canais de relacionamento, considerando eventuais diferenas nos perfis dos clientes.'),
	(126,'Tratar as solicitaes, formais ou informais, dos clientes visando a assegurar que sejam pronta e eficazmente atendidas ou solucionadas.'),
	(126,'Tratar as reclamaes, formais ou informais, dos clientes visando a assegurar que sejam pronta e eficazmente atendidas ou solucionadas.'),
	(126,'Tratar as sugestes, formais ou informais, dos clientes visando a assegurar que sejam pronta e eficazmente atendidas ou solucionadas.'),
	(127,'Realizar acompanhamento das transaes com novos clientes.'),
	(127,'Realizar acompanhamento das transaes com novos produtos entregues.'),
	(128,'Avaliar a satisfao dos clientes e utilizar essas informaes para promover aes de melhoria.'),
	(128,'Avaliar a insatisfao dos clientes e utilizar essas informaes para promover aes de melhoria.'),
	(129,'Identificar os aspectos e tratar os impactos sociais e ambientais adversos de seus produtos.'),
	(129,'Identificar os aspectos e tratar os impactos sociais e ambientais adversos de seus processos'),
	(129,'Identificar os aspectos e tratar os impactos sociais e ambientais adversos de suas instalaes.'),
	(130,'Comunicar  sociedade, incluindo as comunidades vizinhas, os impactos sociais e ambientais dos produtos da organizao.'),
	(130,'Comunicar  sociedade, incluindo as comunidades vizinhas, os impactos sociais e ambientais dos processos organizao.'),
	(130,'Comunicar  sociedade, incluindo as comunidades vizinhas, informaes relativas  responsabilidade socio ambiental consideradas relevantes.'),
	(131,'Identificar  os requisitos legais, regulamentares e contratuais aplicveis a questes socioambientais.'),
	(131,'Analisar os requisitos legais, regulamentares e contratuais aplicveis a questes socioambientais.'),
	(132,'Selecionar de forma voluntria aes com vistas ao desenvolvimento sustentvel.'),
	(132,'Promover de forma voluntria aes com vistas ao desenvolvimento sustentvel.'),
	(133,'Identificar  as necessidades da sociedade, incluindo as comunidades vizinhas em relao s instalaes da organizao.'),
	(133,'Identificar  as expectativas da sociedade, incluindo as comunidades vizinhas em relao s instalaes da organizao.'),
	(134,'Direcionar os esforos para o fortalecimento da sociedade, incluindo as comunidades vizinhas, apoiando projetos sociais voltados para o desenvolvimento nacional, regional, local ou setorial.'),
	(134,'Direcionar os esforos para o fortalecimento da sociedade, incluindo as comunidades vizinhas, executando projetos sociais voltados para o desenvolvimento nacional, regional, local ou setorial.'),
	(135,'Identificar as necessidades de informaes para apoiar as operaes dirias em todos os nveis e reas da organizao.'),
	(135,'Identificar as necessidades de informaes para apoiar a tomada de deciso em todos os nveis e reas da organizao.'),
	(136,'Definir os sistemas de informao visando a atender as necessidades identificadas.'),
	(137,'Compatibilizar a infraestrutura para a disponibilizao das informaes aos usurios, internos da organizao, com o crescimento do negcio.'),
	(137,'Compatibilizar a infraestrutura para a disponibilizao das informaes aos usurios, internos da organizao, com o crescimento da demanda por informaes.'),
	(137,'Compatibilizar a infraestrutura para a disponibilizao das informaes aos usurios, externoa  organizao, com o crescimento do negcio.'),
	(137,'Compatibilizar a infraestrutura para a disponibilizao das informaes aos usurios, externoa  organizao, com o crescimento da demanda por informaes.'),
	(138,'Garantir a segurana das informaes.'),
	(139,'Identificar os ativos intangveis da organizao.'),
	(140,'Desenvolver os principais ativos intangveis.'),
	(140,'Proteger os principais ativos intangveis.'),
	(141,'Compartilhar o conhecimento da organizao.'),
	(141,'Reter o conhecimento da organizao.'),
	(142,'Elaborar a organizao do trabalho, visando ao alto desempenho.'),
	(142,'Implementar a organizao do trabalho, visando ao alto desempenho.'),
	(143,'Selecionar e contratar pessoas, internamente.'),
	(143,'Selecionar e contratar pessoas, externamente.'),
	(144,'Avaliar o desempenho das pessoas de forma a estimular o desenvolvimento profissional das mesmas.'),
	(144,'Avaliar o desempenho das equipes de forma a estimular o desenvolvimento profissional das mesmas.'),
	(145,'Estimular o alcance das metas, atravs da remunerao.'),
	(145,'Estimular o alcance das metas, atravs do reconhecimento.'),
	(145,'Estimular o alcance das metas, atravs dos incentivos.'),
	(146,'Identificar as necessidades de capacitao das pessoas visando ao xito das estratgicas e a melhoria do desempenho individual.'),
	(146,'Identificar as necessidades de capacitao das pessoas visando a formao da cultura da excelncia e a melhoria do desempenho individual.'),
	(146,'Identificar as necessidades de desenvolvimento das pessoas visando ao xito das estratgicas e a melhoria do desempenho individual.'),
	(146,'Identificar as necessidades de desenvolvimento das pessoas visando a formao da cultura da excelncia e a melhoria do desempenho individual.'),
	(147,'Conceber a forma de realizao dos programas de desenvolvimento, considerando as necessidades da organizao.'),
	(147,'Conceber a forma de realizao dos programas de desenvolvimento, considerando as necessidades das pessoas.'),
	(147,'Conceber a forma de realizao dos programas de capacitao, considerando as necessidades da organizao.'),
	(147,'Conceber a forma de realizao dos programas de capacitao, considerando as necessidades das pessoas.'),
	(148,'Avaliar a eficcia dos programas de desenvolvimento.'),
	(148,'Avaliar a eficcia dos programas de capacitao.'),
	(149,'Identificar os perigos relacionados  sade ocupacional.'),
	(149,'Identificar os perigos relacionados  segurana.'),
	(149,'Tratar os riscos relacionados  sade ocupacional.'),
	(149,'Tratar os riscos relacionados  segurana.'),
	(150,'Identificar as necessidades e expectativas das pessoas da fora de trabalho para o desenvolvimento de polticas e programas de pessoal e de benefcios a elas oferecidos.'),
	(150,'Analisar as necessidades e expectativas das pessoas da fora de trabalho para o desenvolvimento de polticas e programas de pessoal e de benefcios a elas oferecidos.'),
	(150,'Utilizar as necessidades e expectativas das pessoas da fora de trabalho para o desenvolvimento de polticas e programas de pessoal e de benefcios a elas oferecidos.'),
	(151,'Avaliar e desenvolver o bem-estar das pessoas.'),
	(151,'Avaliar e desenvolver a satisfao das pessoas.'),
	(151,'Avaliar e desenvolver o comprometimento das pessoas.'),
	(152,'Colaborar para a melhoria da qualidade de vida das pessoas fora do ambiente de trabalho.'),
	(153,'Determinar os requisitos aplicveis aos produtos, considerando-se as necessidades e as expectativas dos clientes e de outras partes interessadas.'),
	(153,'Determinar os requisitos aplicveis aos processos principais do negcio, considerando-se as necessidades e as expectativas dos clientes e de outras partes interessadas.'),
	(153,'Determinar os requisitos aplicveis aos processos de apoio, considerando-se as necessidades e as expectativas dos clientes e de outras partes interessadas.'),
	(154,'Projetar os processos principais do negcio, visando ao atendimento de requisitos estabelecidos.'),
	(154,'Projetar os processos principais do negcio, visando a superao de requisitos estabelecidos.'),
	(154,'Projetar os processos de apoio, visando ao atendimento de requisitos estabelecidos.'),
	(154,'Projetar os processos de apoio, visando a superao de requisitos estabelecidos.'),
	(155,'Assegurar o atendimento dos requisitos aplicveis aos produtos.'),
	(155,'Assegurar o atendimento dos requisitos aplicveis aos processos principais do negcio.'),
	(155,'Assegurar o atendimento dos requisitos aplicveis aos processos de apoio do negcio.'),
	(156,'Analisar os produtos.'),
	(156,'Analisar os processos principais do negcio.'),
	(156,'Analisar os processos de apoio.'),
	(156,'Melhorar os produtos.'),
	(156,'Melhorar os processos principais do negcio.'),
	(156,'Melhorar os processos de apoio.'),
	(157,'Qualificar os fornecedores.'),
	(157,'Selecionar os fornecedores.'),
	(158,'Avaliar os fornecedores.'),
	(158,'Prontamente informar os fornecedores sobre seu desempenho.'),
	(159,'Envolver os fornecedores que atuam diretamente nos processos da organizao com os valores, incluindo os relativos  responsabilidade socioambiental e  sade e segurana.'),
	(159,'Envolver os fornecedores que atuam diretamente nos processos da organizao com os princpios organizacionais, incluindo os relativos  responsabilidade socioambiental e  sade e segurana.'),
	(159,'Comprometer os fornecedores que atuam diretamente nos processos da organizao com os valores, incluindo os relativos  responsabilidade socioambiental e  sade e segurana.'),
	(159,'Comprometer os fornecedores que atuam diretamente nos processos da organizao com os princpios organizacionais, incluindo os relativos  responsabilidade socioambiental e  sade e segurana.'),
	(160,'Gerenciar os aspectos que causam impacto na sustentabilidade econmica do negcio.'),
	(161,'Assegurar os recursos financeiros necessrios para atender s necessidades operacionais.'),
	(162,'Definir os recursos financeiros visando a dar suporte as estratgias.'),
	(162,'Definir os recursos financeiros visando a dar suporte oos planos de ao.'),
	(162,'Avaliar os investimentos visando a dar suporte as estratgias.'),
	(162,'Avaliar os investimentos visando a dar suporte oos planos de ao.'),
	(163,'Elaborar o oramento, visando assegurar o atendimento dos nveis esperados de desempenho financeiro.'),
	(163,'Controlar o oramento, visando assegurar o atendimento dos nveis esperados de desempenho financeiro.'),
	(164,'Apresentar os resultados relativos  gesto econmico-financeira.'),
	(165,'Apresentar os resultados relativos aos clientes e aos mercados.'),
	(166,'Apresentar os resultados relativos  responsabilidade socioambiental e ao desenvolvimento social.'),
	(167,'Apresentar os resultados relativos ao sistema de trabalho,  capacitao e desenvolvimento e  qualidade de vida.'),
	(168,'Apresentar os resultados relativos ao produto e  gesto dos processos principais do negcio e dos processos de apoio, e de processos de gesto transversais no pertinentes aos demais itens.'),
	(169,'Apresentar os resultados dos principais indicadores relativos aos produtos adquiridos e  gesto de fornecedores.');

/* FNQ 1000 */
INSERT INTO pratica_verbo(pratica_verbo_marcador, pratica_verbo_texto) VALUES 
	(200,'Assegurar a equidade entre scios, mantenedores ou instituidores.'),
	(200,'Proteger os direitos das partes interessadas.'),
	(201,'Estabelecer os valores e princpios organizacionais necessrios  promoo da excelncia.'),
	(201,'Atualizar os valores e princpios organizacionais necessrios  promoo da excelncia.'),
	(201,'Estabelecer valor para todas as partes interessadas  criao de valor para todas as partes interessadas.'),
	(201,'Atualizar os valores para todas as partes interessadas  criao de valor para todas as partes interessadas.'),
	(201,'Estabelecer valor para todas as partes interessadas e ao desenvolvimento sustentvel.'),
	(201,'Atualizar os valores para todas as partes interessadas e ao desenvolvimento sustentvel.'),
	(202,'Estabelecer regras de conduta para os integrantes da sua administrao, buscando assegurar um relacionamento tico interno, com concorrentes e com outras partes interessadas.'),
	(202,'Estabelecer regras de conduta para a fora de trabalho, buscando assegurar um relacionamento tico interno, com concorrentes e com outras partes interessadas..'),
	(202,'Tratar as questes ticas, buscando assegurar um relacionamento tico interno, com concorrentes e com outras partes interessadas.'),
	(203,'Identificar os riscos empresariais mais significativos, que possam afetar a imagem e a capacidade da organizao de alcanar os objetivos estratgicos do negcio.'),
	(203,'Classificar os riscos empresariais mais significativos, que possam afetar a imagem e a capacidade da organizao de alcanar os objetivos estratgicos do negcio.'),
	(203,'Analisar os riscos empresariais mais significativos, que possam afetar a imagem e a capacidade da organizao de alcanar os objetivos estratgicos do negcio.'),
	(203,'Tratar os riscos empresariais mais significativos, que possam afetar a imagem e a capacidade da organizao de alcanar os objetivos estratgicos do negcio.'),
	(204,'Tomar as principais decises para assegurar a transparncia levando em considerao o envolvimento dos principais interessados nos temas tratados.'),
	(204,'Comunicar as principais decises para assegurar a transparncia levando em considerao o envolvimento dos principais interessados nos temas tratados.'),
	(204,'Implementar as principais decises para assegurar a transparncia levando em considerao o envolvimento dos principais interessados nos temas tratados.'),
	(205,'Comunicar prontamente os fatos relevantes  sociedade.'),
	(205,'Comunicar prontamente os fatos relevantes s demais partes interessadas.'),
	(206,'Prestar contas das suas aes a quem a elegeu, nomeou ou designou.'),
	(206,'Prestar contas dos resultados alcanados a quem a elegeu, nomeou ou designou.'),
	(207,'Exercer a liderana com as partes interessadas, identificando suas expectativas.'),
	(207,'Exercer a liderana com as partes interessadas, buscando o alinhamento de interesses.'),
	(207,'Interagir com as partes interessadas, identificando suas expectativas.'),
	(207,'Interagir com as partes interessadas, buscando o alinhamento de interesses.'),
	(208,'Identificar as mudanas culturais necessrias para a internalizao dos valores e o xito das estratgias.'),
	(208,'Identificar as mudanas culturais necessrias para a internalizao dos princpios organizacionais e o xito das estratgias.'),
	(208,'Desenvolver as mudanas culturais necessrias para a internalizao dos valores e o xito das estratgias.'),
	(208,'Desenvolver as mudanas culturais necessrias para a internalizao dos princpios organizacionais e o xito das estratgias.'),
	(209,'Comunicar os valores  fora de trabalho, e quando pertinente, s demais partes interessadas.'),
	(209,'Comunicar os princpios organizacionais  fora de trabalho, e quando pertinente, s demais partes interessadas.'),
	(210,'Avaliar nos lderes, as competncias necessrias para o exerccio da liderana.'),
	(210,'Desenvolver nos lderes, as competncias necessrias para o exerccio da liderana.'),
	(211,'Estabelecer os principais e padres de trabalho para os processos gerenciais.'),
	(211,'Verificar o cumprimento dos principais padres de trabalho para os processos gerenciais.'),
	(212,'Refinar os processos gerenciais por meio do aprendizado.'),
	(212,'Refinar os processos gerenciais por meio da inovao.'),
	(213,'Investigar as boas prticas de gesto das organizaes de referncia para apoiar o aprendizado.'),
	(214,'Identificar as necessidades de informaes comparativas para analisar o desempenho operacional da organizao.'),
	(214,'Identificar as necessidades de informaes comparativas para analisar o desempenho estratgico da organizao.'),
	(215,'Avaliar o desempenho operacional da organizao, visando ao desenvolvimento sustentvel.'),
	(215,'Avaliar o desempenho estratgico da organizao, visando ao desenvolvimento sustentvel.'),
	(216,'Comunicar  fora de trabalho as decises decorrentes da anlise do desempenho da organizao.'),
	(216,'Comunicar em todos os nveis da organizao as decises decorrentes da anlise do desempenho da organizao.'),
	(216,'Comunicar a outras partes interessadas as decises decorrentes da anlise do desempenho da organizao.'),
	(217,'Acompanhar a implementao das decises decorrentes da anlise do desempenho da organizao.'),
	(218,'Analisar o macroambiente da organizao e suas tendncias.'),
	(218,'Identificar as caractersticas do setor de atuao da organizao e suas tendncias.'),
	(218,'Analisar as caractersticas do setor de atuao da organizao e suas tendncias.'),
	(219,'Analisar o mercado de atuao da organizao.'),
	(219,'Analisar as tendncias do mercado de atuao da organizao.'),
	(220,'Analisar o ambiente interno da organizao.'),
	(221,'Avaliar as alternativas decorrentes das anlises dos ambientes.'),
	(221,'Definir as estratgias da organizao.'),
	(222,'Avaliar o modelo de negcio em consonncia com a definio das estratgias, visando  potencializao de seu xito.'),
	(223,'Definir os indicadores para a avaliao da implementao das estratgias e definir os respectivos planos de ao.'),
	(223,'Estabelecer as metas de curto e longo prazo e definir os respectivos planos de ao.'),
	(224,'Desdobar as metas e os planos de ao nas reas responsveis pelos processos principais do negcio e processos de apoio.'),
	(224,'Assegurar a coerncia das metas e dos planos resultantes com as estratgias e tambm entre si.'),
	(224,'Manter o alinhamento entre os indicadores utilizados na avaliao do desempenho estratgico e aqueles utilizados na avaliao do desempenho operacional.'),
	(225,'Alocar os recursos para assegurar a implementao dos principais planos de ao.'),
	(226,'Comunicar as estratgias para as pessoas da fora de trabalho e para as demais partes interessadas, quando pertinente.'),
	(226,'Comunicar as metas para as pessoas da fora de trabalho e para as demais partes interessadas, quando pertinente.'),
	(226,'Comunicar os planos de ao para as pessoas da fora de trabalho e para as demais partes interessadas, quando pertinente.'),
	(227,'Realizar o monitoramento da implementao dos planos de ao.'),
	(228,'Segmentar o mercado.'),
	(229,'Definir os clientes-alvo nos segmentos da organizao, considerando-se, inclusive, os clientes da concorrncia, quando existirem, e os clientes e mercados potenciais.'),
	(230,'Identificar as necessidades e as expectativas dos clientes, atuais e potenciais, para definir a melhoria dos produtos e processos da organizao.'),
	(230,'Identificar as necessidades e as expectativas de ex-clientes para definir a melhoria dos produtos e processos da organizao.'),
	(230,'Identificar as necessidades e as expectativas de usurios para definir a melhoria dos produtos e processos da organizao.'),
	(230,'Analisar as necessidades e as expectativas dos clientes, atuais e potenciais, para definir a melhoria dos produtos e processos da organizao.'),
	(230,'Analisar as necessidades e as expectativas de ex-clientes para definir a melhoria dos produtos e processos da organizao.'),
	(230,'Analisar as necessidades e as expectativas de usurios para definir a melhoria dos produtos e processos da organizao.'),
	(230,'Utilizar as necessidades e as expectativas dos clientes, atuais e potenciais, para definir a melhoria dos produtos e processos da organizao.'),
	(230,'Utilizar as necessidades e as expectativas de ex-clientes para definir a melhoria dos produtos e processos da organizao.'),
	(230,'Utilizar as necessidades e as expectativas de usurios para definir a melhoria dos produtos e processos da organizao.'),
	(231,'Divulgar para os clientes as marcas, os produtos, incluindo os cuidados necessrios ao seu uso e os riscos envolvidos, e tambm as aes de melhoria da organizao de forma a criar credibilidade.'),
	(231,'Divulgar para os clientes as marcas, os produtos, incluindo os cuidados necessrios ao seu uso e os riscos envolvidos, e tambm as aes de melhoria da organizao de forma a criar confiana.'),
	(231,'Divulgar para os clientes as marcas, os produtos, incluindo os cuidados necessrios ao seu uso e os riscos envolvidos, e tambm as aes de melhoria da organizao de forma a criar imagem positiva.'),
	(232,'Identificar os nveis de conhecimento dos clientes e mercados a respeito das marcas da organizao.'),
	(232,'Identificar os nveis de conhecimento dos clientes e mercados a respeito dos produtos da organizao.'),
	(232,'Avaliar os nveis de conhecimento dos clientes a respeito das marcas da organizao.'),
	(232,'Avaliar os nveis de conhecimento dos clientes a respeito dos produtos da organizao.'),
	(233,'Avaliar a imagem da organizao perante os clientes.'),
	(233,'Avaliar a imagem da organizao perante os mercados.'),
	(234,'Definir os canais de relacionamento com os clientes, considerando-se a segmentao do mercado.'),
	(234,'Definir os canais de relacionamento com os clientes, considerando-se o agrupamento de clientes utilizado.'),
	(234,'Divulgar para os clientes os canais de relacionamento, considerando-se a segmentao do mercado.'),
	(234,'Divulgar para os clientes os canais de relacionamento, considerando-se o agrupamento de clientes utilizado.'),
	(235,'Tratar as solicitaes, formais ou informais, dos clientes visando a assegurar que sejam pronta e eficazmente atendidas ou solucionadas.'),
	(235,'Tratar as reclamaes, formais ou informais, dos clientes visando a assegurar que sejam pronta e eficazmente atendidas ou solucionadas.'),
	(235,'Tratar as sugestes, formais ou informais, dos clientes visando a assegurar que sejam pronta e eficazmente atendidas ou solucionadas.'),
	(236,'Acompanhar as transaes com os clientes, de forma a permitir  organizao gerar solues rpidas e eficazes.'),
	(236,'Acompanhar as transaes com os clientes, de forma a permitir  organizao evitar problemas de relacionamento.'),
	(236,'Acompanhar as transaes com os clientes, de forma a permitir  organizao atender s expectativas dos clientes.'),
	(237,'Avaliar a satisfao dos clientes, inclusive em relao aos clientes dos concorrentes ou, quando no houver concorrncia, de outras organizaes de referncia.'),
	(237,'Avaliar a fidelidade, inclusive em relao aos clientes dos concorrentes ou, quando no houver concorrncia, de outras organizaes de referncia.'),
	(237,'Avaliar a insatisfao dos clientes, inclusive em relao aos clientes dos concorrentes ou, quando no houver concorrncia, de outras organizaes de referncia.'),
	(238,'Analisar as informaes obtidas dos clientes para intensificar a sua satisfao e torn-los fiis.'),
	(238,'Analisar as informaes obtidas dos clientes para incentiv-los que recomendem os produtos da organizao.'),
	(238,'Analisar as informaes obtidas dos clientes para que sejam desenvolvolvidos processos e produtos.'),
	(238,'Utilizar as informaes obtidas dos clientes para intensificar a sua satisfao e torn-los fiis.'),
	(238,'Utilizar as informaes obtidas dos clientes para incentiv-los que recomendem os produtos da organizao.'),
	(238,'Utilizar as informaes obtidas dos clientes para que sejam desenvolvolvidos processos e produtos.'),
	(239,'Identificar parcerias com clientes, visando  manuteno ou ao aumento da competitividade da organizao.'),
	(239,'Identificar parcerias com distribuidores, visando  manuteno ou ao aumento da competitividade da organizao.'),
	(239,'Identificar parcerias com revendedores visando  manuteno ou ao aumento da competitividade da organizao.'),
	(239,'Desenvolver parcerias com clientes visando  manuteno ou ao aumento da competitividade da organizao.'),
	(239,'Desenvolver parcerias com distribuidores visando  manuteno ou ao aumento da competitividade da organizao.'),
	(239,'Desenvolver parcerias revendedores visando  manuteno ou ao aumento da competitividade da organizao.'),
	(240,'Identificar os aspectos e tratar os impactos sociais adversos de seus produtos.'),
	(240,'Identificar os aspectos e tratar os impactos sociais adversos de seus processos.'),
	(240,'Identificar os aspectos e tratar os impactos sociais adversos de suas instalaes.'),
	(241,'Manter a organizao preparada para prevenir acidentes, visando prevenir ou mitigar os seus impactos adversos na sociedade, incluindo aqueles em comunidades potencialmente impactadas.'),
	(241,'Responder s eventuais situaes de emergncia, visando prevenir ou mitigar os seus impactos adversos na sociedade, incluindo aqueles em comunidades potencialmente impactadas.'),
	(242,'Comunicar os impactos sociais e ambientais dos produtos, as aes e os resultados relativos  responsabilidade socioambiental  sociedade, incluindo as comunidades potencialmente impactadas.'),
	(242,'Comunicar os impactos sociais e ambientais dos processos e instalaes, assim como as polticas, as aes e os resultados relativos  responsabilidade socioambiental  sociedade, incluindo as comunidades potencialmente impactadas.'),
	(243,'Identificar os requisitos legais, regulamentares e contratuais aplicveis a questes socioambientais e implementar aes de melhoria visando ao seu pleno atendimento.'),
	(243,'Analisar os requisitos legais, regulamentares e contratuais aplicveis a questes socioambientais e implementar aes de melhoria visando ao seu pleno atendimento.'),
	(244,'Propiciar a acessibilidade aos produtos da organizao.'),
	(244,'Propiciar a acessibilidade s instalaes da organizao.'),
	(245,'Selecionar de forma voluntria, aes com vista ao desenvolvimento sustentvel.'),
	(245,'Promover de forma voluntria, aes com vista ao desenvolvimento sustentvel.'),
	(246,'Identificar as necessidades e expectativas da sociedade, incluindo comunidades vizinhas s instalaes da organizao.'),
	(246,'Analisar as necessidades e expectativas da sociedade, incluindo comunidades vizinhas s instalaes da organizao.'),
	(246,'Utilizar as necessidades e expectativas da sociedade, incluindo comunidades vizinhas s instalaes da organizao.'),
	(247,'Direcionar os esforos para o fortalecimento da sociedade, incluindo as comunidades vizinhas, apoiando projetos sociais voltados para o desenvolvimento nacional.'),
	(247,'Direcionar os esforos para o fortalecimento da sociedade, incluindo as comunidades vizinhas, apoiando projetos sociais voltados para o desenvolvimento regional.'),
	(247,'Direcionar os esforos para o fortalecimento da sociedade, incluindo as comunidades vizinhas, apoiando projetos sociais voltados para o desenvolvimento local.'),
	(247,'Direcionar os esforos para o fortalecimento da sociedade, incluindo as comunidades vizinhas, apoiando projetos sociais voltados para o desenvolvimento setorial.'),
	(248,'Avaliar o grau de satisfao da sociedade, incluindo comunidades vizinhas, em relao  organizao.'),
	(249,'Analisar as informaes obtidas da sociedade, incluindo comunidades vizinhas, para intensificar a sua satisfao.'),
	(249,'Analisar as informaes obtidas da sociedade, incluindo comunidades vizinhas, para desenvolver projetos sociais.'),
	(249,'Utilizar as informaes obtidas da sociedade, incluindo comunidades vizinhas, para intensificar a sua satisfao.'),
	(249,'Utilizar as informaes obtidas da sociedade, incluindo comunidades vizinhas, para desenvolver projetos sociais.'),
	(250,'Avaliar sua imagem perante a sociedade, incluindo comunidades vizinhas.'),
	(250,'Zelar por sua imagem perante a sociedade, incluindo comunidades vizinhas.'),
	(251,'Identificar as necessidades de informaes e de seu tratamento para apoiar as operaes dirias.'),
	(251,'Acompanhar o progresso dos planos de ao.'),
	(251,'Subsidiar a tomada de decises em todos os nveis e reas da organizao.'),
	(252,'Definir os principais sistemas de informao, visando atender s necessidades identificadas.'),
	(252,'Desenvolver os principais sistemas de informao, visando atender s necessidades identificadas.'),
	(252,'Implantar os principais sistemas de informao, visando atender s necessidades identificadas.'),
	(252,'Melhorar os principais sistemas de informao, visando atender s necessidades identificadas.'),
	(253,'Analisar a tecnologia de informao para alavancar o negcio.'),
	(253,'Analisar a tecnologia de informao para promover a integrao da organizao com as partes interessadas.'),
	(253,'Utilizar a tecnologia de informao para alavancar o negcio.'),
	(253,'Utilizar a tecnologia de informao para promover a integrao da organizao com as partes interessadas.'),
	(254,'Compatibilizar a infraestrutura para a disponibilizao das informaes aos usurios, internos e externos  organizao, com o crescimento do negcio.'),
	(254,'Compatibilizar a infraestrutura para a disponibilizao das informaes aos usurios, internos e externos  organizao, com a demanda por informaes.'),
	(255,'Garantir a segurana das informaes.'),
	(256,'Identificar os ativos intangveis que mais agregam valor ao negcio, gerando um diferencial competitivo para a organizao. '),
	(257,'Desenvolver os principais atvos intangveis.'),
	(257,'Proteger os principais atvos intangveis.'),
	(258,'Identificar os conhecimentos que sustentam o desenvolvimento das estratgias.'),
	(258,'Identificar os conhecimentos que sustentam o desenvolvimento das operaes.'),
	(258,'Desenvolver os conhecimentos que sustentam o desenvolvimento das estratgias.'),
	(258,'Desenvolver os conhecimentos que sustentam o desenvolvimento das operaes.'),
	(259,'Compartilhar os conhecimentos da organizao.'),
	(259,'Reter os conhecimentos da organizao.'),
	(260,'Definir a organizao do trabalho em alinhamento com o modelo de negcio, visando ao alto desempenho.'),
	(260,'Definir a organizao do trabalho em alinhamento com o modelo de negcio, visando  inovao.'),
	(260,'Definir a organizao do trabalho em alinhamento com os processos, visando ao alto desempenho.'),
	(260,'Definir a organizao do trabalho em alinhamento com os processos, visando  inovao.'),
	(261,'Selecionar, interna e externamente, e contratar em consonncia com as estratgias da organizao.'),
	(261,'Selecionar, interna e externamente, e contratar em consonncia com as necessidades do modelo de negcio da organizao.'),
	(262,'Integrar pessoas recm-contratadas  cultura organizacional, visando prepar-las para o pleno exerccio das suas funes.'),
	(263,'Avaliar o desempenho das pessoas e das equipes de modo a estimular a obteno de metas de alto desempenho.'),
	(263,'Avaliar o desempenho das pessoas e das equipes de modo a estimular a cultura da excelncia na organizao.'),
	(263,'Avaliar o desempenho das pessoas e das equipes de modo a estimular o desenvolvimento profissional das mesmas.'),
	(264,'Estimular o alcance de metas, atravs da remunerao.'),
	(264,'Estimular o alcance de metas, atravs do reconhecimento.'),
	(264,'Estimular o alcance de metas, atravs dos incentivos.'),
	(265,'Identificar as necessidades de capacitao e desenvolvimento das pessoas, visando ao xito de estratgias.'),
	(265,'Identificar as necessidades de capacitao e desenvolvimento das pessoas, visando  formao da cultura da excelncia.'),
	(265,'Identificar as necessidades de capacitao e desenvolvimento das pessoas, visando  melhoria do desempenho individual.'),
	(266,'Conceber a forma de realizao dos programas de desenvolvimento e capacitao, considerando as necessidades da organizao.'),
	(266,'Conceber a forma de realizao dos programas de desenvolvimento e capacitao, considerando as necessidades das pessoas.'),
	(267,'Avaliar a eficcia dos programas de capacitao em relao ao alcance dos objetivos estratgicos da organizao.'),
	(267,'Avaliar a eficcia dos programas de capacitao em relao ao alcance dos objetivos operacionais da organizao.'),
	(268,'Promover o desenvolvimento integral das pessoas como indivduos.'),
	(268,'Promover o desenvolvimento integral das pessoas como cidados.'),
	(268,'Promover o desenvolvimento integral das pessoas como profissionais.'),
	(269,'Identificar os perigos relacionados  sade ocupacional.'),
	(269,'Identificar os perigos relacionados  segurana.'),
	(269,'Tratar os riscos relacionados  sade ocupacional.'),
	(269,'Tratar os riscos relacionados  segurana.'),
	(270,'Identificar as necessidades e expectativas das pessoas da fora de trabalho e do mercado para o desenvolvimento de polticas e programas de pessoal e dos benefcios a elas oferecidos.'),
	(270,'Analisar as necessidades e expectativas das pessoas da fora de trabalho e do mercado para o desenvolvimento de polticas e programas de pessoal e dos benefcios a elas oferecidos.'),
	(270,'Utilizar as necessidades e expectativas das pessoas da fora de trabalho e do mercado para o desenvolvimento de polticas e programas de pessoal e dos benefcios a elas oferecidos.'),
	(271,'Avaliar o bem-estar das pessoas.'),
	(271,'Avaliar a satisfao das pessoas.'),
	(271,'Avaliar o comprometimento das pessoas.'),
	(271,'Desenvolver o bem-estar das pessoas.'),
	(271,'Desenvolver a satisfao das pessoas.'),
	(271,'Desenvolver o comprometimento das pessoas.'),
	(272,'Manter um clima organizacional favorvel  criatividade das pessoas e das equipes.'),
	(272,'Manter um clima organizacional favorvel  inovao das pessoas e das equipes.'),
	(272,'Manter um clima organizacional favorvel  excelncia no desenpenho das pessoas e das equipes.'),
	(272,'Manter um clima organizacional favorvel ao desenvolvimento profissional das pessoas e das equipes.'),
	(273,'Colaborar para a melhoria da qualidade de vida das pessoas fora do ambiente de trabalho.'),
	(274,'Determinar os requisitos aplicveis aos produtos considerando-se as necessidades dos clientes, e sua importncia relativa, e de outras partes interessadas.'),
	(274,'Determinar os requisitos aplicveis aos processos principais do negcio considerando-se as necessidades dos clientes, e sua importncia relativa, e de outras partes interessadas.'),
	(274,'Determinar os requisitos aplicveis aos processos de apoio do negcio considerando-se as necessidades dos clientes, e sua importncia relativa, e de outras partes interessadas.'),
	(275,'Desenvolver novos produtos visando ao atendimento de requisitos estabelecidos.'),
	(275,'Desenvolver novos produtos visando  superao de requisitos estabelecidos.'),
	(276,'Projetar os processos principais do negcio, visando ao atendimento e  superao de requisitos estabelecidos.'),
	(276,'Projetar os processos de apoio do negcio, visando ao atendimento e  superao de requisitos estabelecidos.'),
	(277,'Avaliar o potencial de idias criativas para que convertam-se em inovaes.'),
	(277,'Avaliar o potencial de idias criativas para que convertam-se em produtos.'),
	(277,'Avaliar o potencial de idias criativas para que convertam-se em processos.'),
	(278,'Assegurar o atendimento dos requisitos aplicveis aos processos principais do negcio.'),
	(278,'Assegurar o atendimento dos requisitos aplicveis aos processos de apoio do negcio.'),
	(279,'Analisar os produtos.'),
	(279,'Analisar os os processos principais do negcio.'),
	(279,'Analisar os processos de apoio do negcio.'),
	(279,'Melhorar os produtos.'),
	(279,'Melhorar os os processos principais do negcio.'),
	(279,'Melhorar os processos de apoio do negcio.'),
	(280,'Investigar as caractersticas de produtos de concorrentes ou de outras organizaes de referncia para melhorar os prprios.'),
	(280,'Investigar as caractersticas de processos principais do negcio de concorrentes ou de outras organizaes de referncia para melhorar os prprios.'),
	(280,'Investigar as caractersticas de processos de apoio de concorrentes ou de outras organizaes de referncia para melhorar os prprios.'),
	(281,'Desenvolver a sua cadeia de suprimentos imediata e nela identificar potenciais fornecedores e parceiros visando assegurar a continuidade de fornecimento no longo prazo e agregar valor ao negcio.'),
	(281,'Desenvolver a sua cadeia de suprimentos imediata e nela identificar potenciais fornecedores e parceiros visando melhorar o desempenho e agregar valor ao negcio.'),
	(281,'Desenvolver a sua cadeia de suprimentos imediata e nela identificar potenciais fornecedores e parceiros visando promover o desenvolvimento sustentvel da prpria cadeia e agregar valor ao negcio.'),
	(282,'Identificar as necessidades e expectativas dos fornecedores,  para a definio e a melhoria das polticas e dos programas relativos aos fornecedores.'),
	(282,'Analisar as necessidades e expectativas dos fornecedores,  para a definio e a melhoria das polticas e dos programas relativos aos fornecedores.'),
	(282,'Utilizar as necessidades e expectativas dos fornecedores,  para a definio e a melhoria das polticas e dos programas relativos aos fornecedores.'),
	(283,'Qualificar os fornecedores.'),
	(283,'Selecionar os fornecedores.'),
	(284,'Assegurar o atendimento aos requisitos da organizao por parte dos fornecedores.'),
	(285,'Estimular a melhoria nos processos dos fornecedores'),
	(285,'Estimular a melhoria nos produtos dos fornecedores'),
	(285,'Estimular a inovao nos processos dos fornecedores'),
	(285,'Estimular a inovao nos produtos dos fornecedores'),
	(286,'Envolver os fornecedores que atuam diretamente nos processos da organizao com os valores e princpios organizacionais, incluindo os relativos  responsabilidade socioambiental.'),
	(286,'Envolver os fornecedores que atuam diretamente nos processos da organizao com os valores e princpios organizacionais, incluindo os relativos  sade e segurana.'),
	(286,'Comprometer os fornecedores que atuam diretamente nos processos da organizao  com os valores e princpios organizacionais, incluindo os relativos  responsabilidade socioambiental.'),
	(286,'Comprometer os fornecedores que atuam diretamente nos processos da organizao  com os valores e princpios organizacionais, incluindo os relativos  sade e segurana.'),
	(287,'Determinar os requisitos de desempenho econmico-financeiro da organizao.'),
	(287,'Monitorar os aspectos que causam impacto na sustentabilidade econmica do negcio.'),
	(288,'Assegurar os recursos financeiros necessrios para atender s necessidades operacionais.'),
	(289,'Definir os recursos financeiros visando a dar suporte para as estratgias.'),
	(289,'Definir os recursos financeiros visando a dar suporte para os planos de ao.'),
	(289,'Avaliar os recursos financeiros visando a dar suporte para as estratgias.'),
	(289,'Avaliar os recursos financeiros visando a dar suporte para os planos de ao.'),
	(290,'Quantificar os riscos financeiros da organizao.'),
	(290,'Monitorar os riscos financeiros da organizao.'),
	(291,'Elaborar o oramento visando assegurar o atendimento dos nveis esperados de desempenho.'),
	(291,'Controlar o oramento visando assegurar o atendimento dos nveis esperados de desempenho.'),
	(292,'Apresentar os resultados dos principais indicadores relativos  gesto econmico-financeira, classificando-os segundo os grupos de:<br>estrutura, liquidez, atividade e rentabilidade. Estratificar os resultados por unidades ou filiais, quando aplicveis.'),
	(293,'Apresentar os resultados dos principais indicadores relativos aos clientes e aos mercados, incluindo os referentes  imagem da organizao. Estratificar por grupos de clientes, segmentos de mercado ou tipos de produtos, quando aplicveis.'),
	(294,'Apresentar os resultados dos principais indicadores relativos  sociedade, incluindo os relativos  responsabilidade socioambiental e ao desenvolvimento social. Estratificar os resultados por instalaes ou por comunidades, quando aplicvel.'),
	(295,'Apresentar os resultados dos principais indicadores relativos s pessoas, incluindo os relativos aos sistemas de trabalho,  capacitao e desenvolvimento e  qualidade de vida e os de liderana de pessoas e de promoo da cultura da excelncia. Estratificar os resultados por grupos de pessoas da fora de trabalho, funes na organizao e, quando aplicvel, por instalaes.'),
	(296,'Apresentar os resultados dos indicadores relativos aos produtos, de processos principais do negcio e processos de apoio e de processos de gesto transversais no pertinentes aos demais itens.'),
	(297,'Apresentar os resultados dos principais indicadores relativos aos produtos recebidos dos fornecedores e  gesto de fornecedores. Estratificar os resultados por grupos de fornecedores ou tipos de produtos adquiridos, quando aplicveis.');

/*PQGF 250*/
INSERT INTO pratica_verbo(pratica_verbo_marcador, pratica_verbo_texto) VALUES 
	(300,'Exercer a liderana, interagindo com todas as partes interessadas.'),
	(300,'Exercer a liderana, promovendo o comprometimento com todas as partes interessadas.'),
	(301,'Tomar as principais decises da Alta Administrao.'),
	(301,'Comunicar as principais decises da Alta Administrao.'),
	(301,'Implementar as principais decises da Alta Administrao.'),
	(302,'Internalizar os Princpios e Valores da Administrao Pblica na organizao.'),
	(302,'Internalizar as Diretrizes do Governo na organizao.'),
	(302,'Internalizar os Princpios Organizacionais na organizao.'),
	(302,'Disseminar os Princpios e Valores da Administrao Pblica na organizao.'),
	(302,'Disseminar as Diretrizes do Governo na organizao.'),
	(302,'Disseminar os Princpios Organizacionais na organizao.'),
	(303,'Conduzir a implementao do sistema de gesto, visando assegurar o atendimento das necessidades e expectativas de todas as partes interessadas.'),
	(304,'Analisar criticamente o desempenho por meio de indicadores.'),
	(304,'Acompanhar a implementao das decises decorrentes da anlise dos indicadores.'),
	(305,'Avaliar as prticas de gesto e seus respectivos padres.'),
	(305,'Melhorar as prticas de gesto e seus respectivos padres.'),
	(306,'Definir as estratgias da organizao considerando-se as necessidades das partes interessadas.'),
	(306,'Definir as estratgias da organizao considerando-se as demandas do governo.'),
	(306,'Definir as estratgias da organizao considerando-se as informaes internas.'),
	(307,'Definir os indicadores para a avaliao da operacionalizao das estratgias e definir os respectivos planos de ao.'),
	(307,'Estabelecer as metas de curto e longo prazo e definir os respectivos planos de ao.'),
	(308,'Alocar os recursos para assegurar a implementao dos planos de ao.'),
	(309,'Comunicar as estratgias s pessoas da fora de trabalho e para as demais partes interessadas, quando pertinente.'),
	(309,'Comunicar as metas s pessoas da fora de trabalho e para as demais partes interessadas, quando pertinente.'),
	(309,'Comunicar os planos de ao s pessoas da fora de trabalho e para as demais partes interessadas, quando pertinente.'),
	(310,'Realizar o monitoramento da implementao dos planos de ao.'),
	(311,'Identificar as necessidades e expectativas dos cidados-usurios  para definio e melhoria dos produtos da organizao.'),
	(311,'Identificar as necessidades e expectativas dos cidados-usurios  para definio e melhoria dos servios da organizao.'),
	(311,'Identificar as necessidades e expectativas dos cidados-usurios  para definio e melhoria dos processos da organizao.'),
	(311,'Analisar as necessidades e expectativas dos cidados-usurios  para definio e melhoria dos produtos da organizao.'),
	(311,'Analisar as necessidades e expectativas dos cidados-usurios  para definio e melhoria dos servios da organizao.'),
	(311,'Analisar as necessidades e expectativas dos cidados-usurios  para definio e melhoria dos processos da organizao.'),
	(311,'Utilizar as necessidades e expectativas dos cidados-usurios  para definio e melhoria dos produtos da organizao.'),
	(311,'Utilizar as necessidades e expectativas dos cidados-usurios  para definio e melhoria dos servios da organizao.'),
	(311,'Utilizar as necessidades e expectativas dos cidados-usurios  para definio e melhoria dos processos da organizao.'),
	(312,'Divulgar os produtos e servios da organizao aos cidados e  sociedade.'),
	(312,'Divulgar os padres de atendimento da organizao aos cidados e  sociedade.'),
	(312,'Divulgar as aes de melhoria da organizao aos cidados e  sociedade.'),
	(313,'Tratar as reclamaes, formais ou informais, dos cidados-usurios visando a assegurar que sejam pronta e eficazmente atendidas ou solucionadas.'),
	(313,'Tratar as sugestes, formais ou informais, dos cidados-usurios visando a assegurar que sejam pronta e eficazmente atendidas ou solucionadas.'),
	(314,'Avaliar a satisfao dos cidados-usurios em relao aos seus servios.'),
	(314,'Avaliar a satisfao dos cidados-usurios em relao aos seus produtos.'),
	(315,'Identificar os aspectos de impactos sociais adversos decorrentes da atuao da organizao.'),
	(315,'Identificar os aspectos de impacos ambientais adversos decorrentes da atuao da organizao.'),
	(315,'Tratar os impactos sociais adversos decorrentes da atuao da organizao.'),
	(315,'Tratar os impacos ambientais adversos decorrentes da atuao da organizao.'), 
	(316,'Estimular a fora de trabalho nas questes relativas  responsabilidade socioambiental.'),
	(316,'Envolver a fora de trabalho nas questes relativas  responsabilidade socioambiental.'),
	(316,'Estimular seus parceiros nas questes relativas  responsabilidade socioambiental.'),
	(316,'Envolver seus parceiros nas questes relativas  responsabilidade socioambiental.'),
	(317,'Orientar a sociedade a exercer o controle social.'),
	(317,'Estimular a sociedade a exercer o controle social.'),
	(318,'Estimular o exerccio da responsabilidade social da fora de trabalho, no cumprimento de seu papel de agente pblico.'),
	(318,'Estimular o exerccio da responsabilidade social da fora de trabalho, no cumprimento do comportamento tico em todos os nveis.'),
	(319,'Identificar as necessidades da sociedade em relao ao seu setor de atuao.'),
	(319,'Transformar as necessidades da sociedade em relao ao seu setor de atuao em requisitos para a formulao e execuo de polticas pblicas, quando pertinente.'),
	(320,'Identificar as necessidades em relao aos sistemas de informaes para apoiar as operaes dirias.'),
	(320,'Definir os sistemas de informaes para apoiar as operaes dirias.'),
	(320,'Implantar os sistemas de informaes para apoiar as operaes dirias.'),
	(320,'Identificar as necessidades em relao aos sistemas de informaes para a tomada de deciso em todos os nveis e reas da organizao.'),
	(320,'Definir os sistemas de informaes para a tomada de deciso em todos os nveis e reas da organizao.'),
	(320,'Implantar os sistemas de informaes para a tomada de deciso em todos os nveis e reas da organizao.'),
	(321,'Tratar a segurana das informaes para assegurar sua atualizao.'),
	(321,'Tratar a segurana das informaes para assegurar sua confidencialidade.'),
	(321,'Tratar a segurana das informaes para assegurar sua integridade.'),
	(321,'Tratar a segurana das informaes para assegurar sua disponibilidade.'),
	(322,'Estabelecer a memria administrativa.'),
	(322,'Manter a memria administrativa.'),
	(323,'Utilizar outras organizaes como referencial comparativo pertinente.'),
	(324,'Desenvolver o conhecimento na organizao.'),
	(324,'Proteger o conhecimento na organizao.'),
	(324,'Compartilhar o conhecimento na organizao.'),
	(325,'Definir organizao do trabalho.'),
	(325,'Implementar organizao do trabalho.'),
	(326,'Gerenciar o desempenho das pessoas, de forma a estimular a busca por melhores resultados.'),
	(326,'Gerenciar o desempenho das equipes, de forma a estimular a busca por melhores resultados.'),
	(327,'Identificar as necessidades de capacitao considerando as estratgias.'),
	(327,'Identificar as necessidades de capacitao considerando as necessidades das pessoas.'),
	(327,'Identificar as necessidades de desenvolvimento considerando as estratgias.'),
	(327,'Identificar as necessidades de desenvolvimento considerando as necessidades das pessoas.'),
	(328,'Conceber a forma de realizao dos programas de capacitao considerando as necessidades identificadas.'),
	(328,'Conceber a forma de realizao dos programas de desenvolvimento considerando as necessidades identificadas.'),
	(329,'Identificar os perigos relacionados a sade ocupacional.'),
	(329,'Identificar os perigos relacionados a segurana.'),
	(329,'Identificar os perigos relacionados a ergonomia.'),
	(329,'Tratar os perigos relacionados a sade ocupacional.'),
	(329,'Tratar os perigos relacionados a segurana.'),
	(329,'Tratar os perigos relacionados a ergonomia.'),
	(330,'Identificar os fatores que afetam o bem-estar das pessoas e manter um clima organizacional favorvel ao alto desempenho.'),
	(330,'Identificar os fatores que afetam a satisfao das pessoas e manter um clima organizacional favorvel ao alto desempenho.'),
	(330,'Identificar os fatores que afetam a motivao das pessoas e manter um clima organizacional favorvel ao alto desempenho.'),
	(330,'Tratar os fatores que afetam o bem-estar das pessoas e manter um clima organizacional favorvel ao alto desempenho.'),
	(330,'Tratar os fatores que afetam a satisfao das pessoas e manter um clima organizacional favorvel ao alto desempenho.'),
	(330,'Tratar os fatores que afetam a motivao das pessoas e manter um clima organizacional favorvel ao alto desempenho.'),
	(331,'Avaliar a satisfao das pessoas.'),
	(332,'Projetar processos de apoio, visando ao cumprimento dos requisitos aplicveis.'),
	(332,'Projetar processos finalsticos, visando ao cumprimento dos requisitos aplicveis.'),
	(333,'Controlar os processos de apoio, visando ao cumprimento dos requisitos aplicveis.'),
	(333,'Controlar os processos finalsticos, visando ao cumprimento dos requisitos aplicveis.'),
	(334,'Analisar os processos finalsticos.'),
	(334,'Analisar os processos de apoio.'),
	(334,'Melhorar os processos finalsticos.'),
	(334,'Melhorar os processos de apoio.'),
	(335,'Selecionar os fornecedores.'),
	(336,'Avaliar o desempenho de fornecedores.'),
	(336,'Prontamente informar o desempenho aos fornecedores.'),
	(337,'Elaborar o oramento.'),
	(337,'Gerenciar o oramento.'),
	(338,'Apresentar os resultados relativos aos cidados-usurios'),
	(339,'Apresentar os resultados relativos  sociedade'),
	(340,'Apresentar os resultados oramentrios e financeiros'),
	(341,'Apresentar os resultados relativos s pessoas'),
	(342,'Apresentar os resultados relativos aos processos de suprimento'),
	(343,'Apresentar os resultados dos processos finalsticos e de apoio');

/*PQGF 500*/  
INSERT INTO pratica_verbo(pratica_verbo_marcador, pratica_verbo_texto) VALUES 
	(400,'Disseminar os princpios e valores da administrao pblica na organizao.'),
	(400,'Disseminar as diretrizes de governo na organizao.'),
	(400,'Internalizar os princpios e valores da administrao pblica na organizao.'),
	(400,'Internalizar as diretrizes de governo na organizao.'),
	(401,'Tomar as principais decises da Alta Administrao assegurando a transparncia e o envolvimento de todas as partes interessadas.'),
	(401,'Comunicar as principais decises da Alta Administrao assegurando a transparncia e o envolvimento de todas as partes interessadas.'),
	(401,'Implementar as principais decises da Alta Administrao a transparncia e o envolvimento de todas as partes interessadas.'),
	(402,'Identificar os riscos organizacionais mais significativos que possam afetar o desempenho.'),
	(402,'Tratar os riscos organizacionais mais significativos que possam afetar o desempenho.'),
	(403,'Prestar conta de seus atos para a sociedade.'),
	(403,'Prestar conta dos resultados alcanados para a sociedade.'),
	(403,'Prestar conta de seus atos para os rgos de controle.'),
	(403,'Prestar conta dos resultados alcanados para os rgos de controle.'),
	(404,'Estabelecer um exemplo a ser seguido.'),
	(404,'Atuar pessoalmente para buscar novas oportunidades para a organizao.'),
	(404,'Atuar pessoalmente para promover o comprometimento com todas as partes interessadas.'),
	(405,'Estabelecer os princpios organizacionais necessrios  criao de valor para todas as partes interessadas.'),
	(405,'Estabelecer os valores organizacionais necessrios  criao de valor para todas as partes interessadas.'),
	(405,'Atualizar os valores organizacionais necessrios  criao de valor para todas as partes interessadas.'),
	(405,'Atualizar os princpios organizacionais necessrios  criao de valor para todas as partes interessadas.'),
	(406,'Incentivar o comprometimento de todos com a cultura da excelncia.'),
	(407,'Definir as habilidades de liderana nos lderes.'),
	(407,'Identificar as habilidades de liderana nos lderes.'),
	(407,'Desenvolver as habilidades de liderana nos lderes.'),
	(408,'Estabelecer os principais padres de trabalho que orientam a execuo adequada das prticas de gesto da organizao.'),
	(408,'Estabelecer os principais padres de trabalho que orientam os mtodos para verificar o seu cumprimento na organizao.'),
	(409,'Estimular o aprendizado organizacional.'),
	(410,'Analisar as necessidades de informaes comparativas para avaliar o desempenho da organizao.'),
	(411,'Analisar o desempenho estratgico, considerando as informaes comparativas do ambiente interno.'),
	(411,'Analisar o desempenho estratgico, considerando as informaes comparativas do ambiente externo.'),
	(411,'Analisar o desempenho operacional, considerando as informaes comparativas do ambiente interno.'),
	(411,'Analisar o desempenho operacional, considerando as informaes comparativas do ambiente externo.'),
	(412,'Avaliar o xito das estratgias e o alcance dos respectivos objetivos da organizao a partir das concluses da anlise do seu desempenho.'),
	(413,'Comunicar as decises decorrentes da anlise do desempenho da organizao  fora de trabalho, quando pertinente.'),
	(413,'Comunicar as decises decorrentes da anlise do desempenho da organizao a outras partes interessadas, quando pertinente.'),
	(414,'Acompanhar a implementao das decises decorrentes da anlise do desempenho da organizao.'),
	(415,'Formular as polticas pblicas, quando pertinente.'),
	(416,'Formular as estratgias da organizao.'),
	(417,'Considerar os aspectos relativos ao ambiente externo no processo de formulao das estratgias.'),
	(418,'Analisar o ambiente interno da organizao.'),
	(419,'Avaliar as estratgias da organizao.'),
	(419,'Selecionar as estratgias da organizao.'),
	(420,'Envolver as reas da organizao no processo de formulao das estratgias.'),
	(421,'Comunicar as estratgias s partes interessadas pertinentes para o estabelecimento de compromissos mtuos.'),
	(422,'Definir os indicadores para a avaliao da operacionalizao das estratgias e definir os respectivos planos de ao.'),
	(422,'Estabelecer as metas de curto e longo prazo e definir os respectivos planos de ao.'),
	(423,'Desdobrar as metas para as reas da organizao, assegurando a coerncia com as estratgias selecionadas.'),
	(423,'Desdobrar os planos de ao para as reas da organizao, assegurando a coerncia com as estratgias selecionadas.'),
	(423,'Desdobrar as metas para as reas da organizao, assegurando a consistncia entre os respectivos planos.'),
	(423,'Desdobrar os planos de ao para as reas da organizao, assegurando consistncia entre os respectivos planos.'),
	(424,'Alocar os diferentes recursos financeiros para assegurar a implementao dos planos de ao.'),
	(424,'Alocar os diferentes recursos no-financeiros para assegurar a implementao dos planos de ao.'),
	(425,'Comunicar as metas para a fora de trabalho e, quando pertinente, para as demais partes interessadas.'),
	(425,'Comunicar os indicadores para a fora de trabalho e, quando pertinente, para as demais partes interessadas.'),
	(425,'Comunicar os planos de ao para a fora de trabalho e, quando pertinente, para as demais partes interessadas.'),
	(426,'Realizar o monitoramento da implementao dos planos de ao.'),
	(427,'Identificar os seus cidados-usurios e classificar por tipos.'),
	(427,'Identificar os seus cidados-usurios e classificar por grupos.'),
	(428,'Identificar as necessidades e expectativas dos cidados-usurios, atuais e potenciais, para definio e melhoria dos produtos, servios e processos da organizao.'),
	(428,'Analisar as necessidades e expectativas dos cidados-usurios, atuais e potenciais, para definio e melhoria dos produtos, servios e processos da organizao.'),
	(428,'Compreender as necessidades e expectativas dos cidados-usurios, atuais e potenciais, para definio e melhoria dos produtos, servios e processos da organizao.'),
	(428,'Utilizar as necessidades e expectativas dos cidados-usurios, atuais e potenciais, para definio e melhoria dos produtos, servios e processos da organizao.'),
	(429,'Divulgar os produtos e servios da organizao aos cidados e  sociedade de forma a criar credibilidade, confiana e imagem positiva.'),
	(429,'Divulgar os padres de atendimento da organizao aos cidados e  sociedade de forma a criar credibilidade, confiana e imagem positiva.'),
	(429,'Divulgar as aes de melhoria da organizao aos cidados e  sociedade de forma a criar credibilidade, confiana e imagem positiva.'),
	(430,'Identificar os nveis de conhecimento do universo potencial de cidados-usurios sobre a organizao e seus produtos.'),
	(430,'Identificar os nveis de conhecimento do universo potencial de cidados-usurios sobre a organizao e seus servios.'),
	(430,'Identificar os nveis de conhecimento do universo potencial de cidados-usurios sobre a organizao e suas aes.'),
	(430,'Avaliar os nveis de conhecimento do universo potencial de cidados-usurios sobre a organizao e seus produtos.'),
	(430,'Avaliar os nveis de conhecimento do universo potencial de cidados-usurios sobre a organizao e seus servios.'),
	(430,'Avaliar os nveis de conhecimento do universo potencial de cidados-usurios sobre a organizao e suas aes.'),
	(431,'Avaliar a imagem da organizao perante os cidados-usurios.'),
	(432,'Avaliar o atendimento ao universo potencial dos cidados-usurios identificados.'),
	(433,'Definir e divulgar aos cidados-usurios os principais canais de acesso para solicitarem informaes sobre os servios e produtos.'),
	(433,'Definir e divulgar aos cidados-usurios os principais canais de acesso para solicitarem esclarecimentos sobre os servios e produtos.'),
	(433,'Definir e divulgar aos cidados-usurios os principais canais de acesso para comunicarem suas sugestes ou reclamaes.'),
	(434,'Tratar as reclamaes, formais e informais dos cidados-usurios, visando assegurar a resposta rpida e eficaz e o seu aproveitamento por toda a organizao.'),
	(434,'Tratar as sugestes, formais e informais dos cidados-usurios, visando assegurar a resposta rpida e eficaz e o seu aproveitamento por toda a organizao.'),
	(435,'Acompanhar os servios e os produtos, recentemente prestados ou entregues, junto aos cidados-usurios para permitir  organizao gerar solues rpidas e eficazes.'),
	(435,'Acompanhar os servios e os produtos, recentemente prestados ou entregues, junto aos cidados-usurios para permitir  organizao evitar problemas de relacionamento.'),
	(435,'Acompanhar os servios e os produtos, recentemente prestados ou entregues, junto aos cidados-usurios para permitir  organizao atender as expectativas dos cidados-usurios.'),
	(436,'Avaliar a satisfao dos cidados-usurios em relao aos seus produtos ou servios e aos da concorrncia, quando pertinente.'),
	(436,'Avaliar a insatisfao dos cidados-usurios em relao aos seus produtos ou servios e aos da concorrncia, quando pertinente.'),
	(437,'Utilizar as informaes obtidas dos cidados-usurios para melhorar o seu nvel de satisfao.'),
	(438,'Identificar os aspectos e tratar os impactos sociais e ambientais de seus produtos, desde o projeto at a disposio final, sobre os quais tenha influncia.'),
	(438,'Identificar os aspectos e tratar os impactos sociais e ambientais de seus servios, desde o projeto at a disposio final, sobre os quais tenha influncia.'),
	(438,'Identificar os aspectos e tratar os impactos sociais e ambientais de seus processos desde o projeto at a disposio final, sobre os quais tenha influncia.'),
	(438,'Identificar os aspectos e tratar os impactos sociais e ambientais de suas instalaes, desde o projeto at a disposio final, sobre os quais tenha influncia.'),
	(439,'Comunicar os impactos sociais e ambientais dos servios, assim como as respectivas polticas, aes e resultados  sociedade.'),
	(439,'Comunicar os impactos sociais e ambientais dos produtos, assim como as respectivas polticas, aes e resultados  sociedade.'),
	(439,'Comunicar os impactos sociais e ambientais dos processos, assim como as respectivas polticas, aes e resultados  sociedade.'),
	(439,'Comunicar os impactos sociais e ambientais de suas instalaes, assim como as respectivas polticas, aes e resultados  sociedade.'),
	(440,'Tratar as pendncias referentes aos requisitos legais, regulamentares, ticos ou contratuais, relatando as atualmente existentes.'),
	(440,'Tratar as eventuais sanes referentes aos requisitos legais, regulamentares, ticos ou contratuais, relatando as atualmente existentes.'),
	(441,'Promover aes que envolvam a conservao de recursos no-renovveis.'),
	(441,'Promover aes que envolvam a preservao do ecossistema.'),
	(441,'Promover aes que envolvam a otimizao do uso de recursos renovveis.'),
	(442,'Conscientizar a fora de trabalho nas questes relativas  responsabilidade socioambiental.'),
	(442,'Conscientizar os fornecedores nas questes relativas  responsabilidade socioambiental.'),
	(442,'Conscientizar as demais partes interessadas nas questes relativas  responsabilidade socioambiental.'),
	(442,'Envolver a fora de trabalho nas questes relativas  responsabilidade socioambiental.'),
	(442,'Envolver os fornecedores nas questes relativas  responsabilidade socioambiental.'),
	(442,'Envolver as demais partes interessadas nas questes relativas  responsabilidade socioambiental.'),
	(443,'Direcionar os esforos para o fortalecimento da sociedade executando projetos sociais.'),
	(443,'Direcionar os esforos para o fortalecimento da sociedade executando projetos voltados para o desenvolvimento nacional, regional, local ou setorial quando pertinente.'),
	(443,'Direcionar os esforos para o fortalecimento da sociedade apoiando projetos sociais.'),
	(443,'Direcionar os esforos para o fortalecimento da sociedade apoiando projetos voltados para o desenvolvimento nacional, regional, local ou setorial quando pertinente.'),
	(444,'Divulgar oficialmente os seus atos e informaes sobre seus planos.'),
	(444,'Divulgar oficialmente os seus atos e informaes sobre seus programas.'),
	(444,'Divulgar oficialmente os seus atos e informaes sobre seus projetos.'),
	(445,'Tornar pblico o acesso as informaes relativas a execuo fsica.'),
	(445,'Tornar pblico o acesso as informaes relativas a execuo oramentria.'),
	(445,'Tornar pblico o acesso as informaes relativas a execuo financeira.'),
	(445,'Tornar pblico o acesso as informaes relativas  gesto.'),
	(445,'Democratizar o acesso as informaes relativas a execuo fsica.'),
	(445,'Democratizar o acesso as informaes relativas a execuo oramentria.'),
	(445,'Democratizar o acesso as informaes relativas a execuo financeira.'),
	(445,'Democratizar o acesso as informaes relativas  gesto.'),
	(446,'Orientar a sociedade a participar no controle dos seus resultados institucionais.'),
	(446,'Estimular a sociedade a participar no controle dos seus resultados institucionais.'),
	(447,'Estimular o exerccio da responsabilidade social da fora de trabalho, no cumprimento de seu papel de agente pblico.'),
	(447,'Estimular o comportamento tico em todos os nveis.'),
	(448,'Disponibilizar canais de comunicao para receber eventuais denncias de violao da tica.'),
	(448,'Atuar para minimizar esses acontecimentos e seus efeitos.'),
	(449,'Identificar as necessidades da sociedade em relao ao seu setor de atuao.'),
	(449,'Transformar as necessidades da sociedade em requisitos para a formulao e execuo das polticas pblicas, quando pertinente.'),
	(450,'Contribuir na formulao de execues polticas pblicas do seu setor.'),
	(450,'Atuar na execuo das polticas pblicas do seu setor.'),
	(451,'Divulgar as polticas pblicas e seus respectivos objetivos para a sociedade.'),
	(452,'Monitorar a execuo das polticas pblicas em seu nvel de atuao.'),
	(452,'Avaliar a execuo das polticas pblicas em seu nvel de atuao.'),
	(453,'Avaliar a satisfao da sociedade com a implementao das polticas pblicas.'),
	(453,'Avaliar a satisfao das demais partes interessadas com a implementao das polticas pblicas.'),
	(454,'Identificar os principais sistemas de informao, visando atender s necessidades identificadas da organizao e dos usurios.'),
	(454,'Definir os principais sistemas de informao, visando atender s necessidades identificadas da organizao e dos usurios.'),
	(454,'Desenvolver os principais sistemas de informao, visando atender s necessidades identificadas da organizao e dos usurios.'),
	(454,'Implantar os principais sistemas de informao, visando atender s necessidades identificadas da organizao e dos usurios.'),
	(454,'Atualizar os principais sistemas de informao, visando atender s necessidades identificadas da organizao e dos usurios.'),
	(455,'Estabelecer a memria administrativa da organizao.'),
	(455,'Manter a memria administrativa da organizao.'),
	(456,'Utilizar a informao para apoiar o cumprimento da misso institucional.'),
	(456,'Utilizar a informao para promover a integrao da organizao com seus cidados-usurios.'),
	(456,'Utilizar a informao para promover a integrao da organizao com a sociedade.'),
	(456,'Utilizar a informao para promover a integrao da organizao com seus fornecedores.'),
	(456,'Utilizar a informao para promover a integrao da organizao com seus parceiros.'),
	(457,'Colocar as informaes necessrias  disposio dos pblicos internos e externos, incluindo seus cidados-usurios.'),
	(457,'Colocar as informaes necessrias  disposio dos pblicos internos e externos, incluindo a sociedade.'),
	(457,'Colocar as informaes necessrias  disposio dos pblicos internos e externos, incluindo seus fornecedores.'),
	(457,'Colocar as informaes necessrias  disposio dos pblicos internos e externos, incluindo seus parceiros.'),
	(458,'Gerenciar a segurana das informaes.'),
	(459,'Identificar as organizaes consideradas como um referencial comparativo pertinente.'),
	(460,'Identificar as fontes de informaes comparativas.'),
	(460,'Obter as fontes de informaes comparativas.'),
	(460,'Manter atualizadas as fontes de informaes comparativas.'),
	(461,'Utilizar as informaes obtidas para melhorar o conhecimento dos processos organizacionais.'),
	(461,'Utilizar as informaes obtidas para estabelecer metas ousadas.'),
	(461,'Utilizar as informaes obtidas para promover melhorias no desempenho da organizao.'),
	(462,'Desenvolver o conhecimento na organizao.'),
	(462,'Compartilhar o conhecimento na organizao.'),
	(463,'Manter o conhecimento protegido.'),
	(464,'Assegurar que a gesto do conhecimento seja utilizada para melhorar seus processos.'),
	(464,'Assegurar que a gesto do conhecimento seja utilizada para melhorar seus produtos.'),
	(464,'Assegurar que a gesto do conhecimento seja utilizada para melhorar seus servios.'),
	(465,'Identificar os ativos intangveis da organizao'),
	(465,'Desenvolver os ativos intangveis da organizao'),
	(465,'Mensurar os ativos intangveis da organizao'),
	(466,'Denifir a organizao do trabalho visando o alto desempenho da organizao.'),
	(466,'Implementar a organizao do trabalho visando o alto desempenho da organizao.'),
	(467,'Selecionar pessoas para o preenchimento de cargos e funes em consonncia com as estratgias da organizao.'),
	(467,'Selecionar pessoas para o preenchimento de cargos e funes em consonncia com os objetivos da organizao.'),
	(467,'Selecionar pessoas para o preenchimento de cargos e funes em consonncia com a misso da organizao.'),
	(468,'Definir os canais de interlocuo e a negociao com a fora de trabalho da organizao, quando pertinente.'),
	(468,'Disponibilizar os canais de interlocuo e a negociao com a fora de trabalho da organizao, quando pertinente.'),
	(469,'Estimular a integrao das pessoas e das equipes.'),
	(469,'Estimular a cooperao das pessoas e das equipes.'),
	(470,'Gerenciar o desempenho das pessoas e das equipes, de forma a estimular a obteno de metas de alto desempenho.'),
	(470,'Gerenciar o desempenho das pessoas e das equipes, de forma a estimular a cultura da excelncia na organizao.'),
	(470,'Gerenciar o desempenho das pessoas e das equipes, de forma a estimular o desenvolvimento profissional.'),
	(471,'Estimular o alcance de metas de alto desempenho atravs do sistema de remunerao.'),
	(471,'Estimular o alcance de metas de alto desempenho atravs do sistema de reconhecimento.'),
	(471,'Estimular o alcance de metas de alto desempenho atravs do sistema de incentivos para as pessoas.'),
	(471,'Estimular o alcance de metas de aprendizado atravs do sistema de remunerao.'),
	(471,'Estimular o alcance de metas de aprendizado atravs do sistema de reconhecimento.'),
	(471,'Estimular o alcance de metas de aprendizado atravs do sistema de incentivos para as pessoas.'),
	(472,'Identificar as necessidades de capacitao.'),
	(472,'Identificar as necessidades de desenvolvimento.'),
	(473,'Compatibilizar as necessidades de capacitao e de desenvolvimento das pessoas com as necessidades da organizao, para efeito da definio dos programas de capacitao.'),
	(473,'Compatibilizar as necessidades de capacitao e de desenvolvimento das pessoas com as necessidades da organizao, para efeito da definio dos programas de desenvolvimento.'),
	(474,'Abordar a cultura da excelncia atravs dos programas de capacitao.'),
	(474,'Abordar a cultura da excelncia atravs dos programas de desenvolvimento.'),
	(474,'Contribuir para consolidar o aprendizado organizacional, atravs dos programas de capacitao.'),
	(474,'Contribuir para consolidar o aprendizado organizacional, atravs dos programas de desenvolvimento.'),
	(475,'Conceber a forma de realizao dos programas de capacitao considerando as necessidades da organizao.'),
	(475,'Conceber a forma de realizao dos programas de capacitao considerando as necessidades das pessoas.'),
	(475,'Conceber a forma de realizao dos programas de capacitao considerando os recursos disponveis.'),
	(475,'Conceber a forma de realizao dos programas de desenvolvimento considerando as necessidades da organizao.'),
	(475,'Conceber a forma de realizao dos programas de desenvolvimento considerando as necessidades das pessoas..'),
	(475,'Conceber a forma de realizao dos programas de desenvolvimento considerando os recursos disponveis.'),
	(476,'Avaliar as habilidades em relao  sua utilidade na execuo do trabalho da organizao.'),
	(476,'Avaliar as habilidades em relao  sua eficcia na consecuo das estratgias da organizao.'),
	(476,'Avaliar os conhecimentos adquiridos em relao  sua utilidade na execuo do trabalho da organizao.'),
	(476,'Avaliar os conhecimentos adquiridos em relao  sua eficcia na consecuo das estratgias da organizao.'),
	(477,'Promover o desenvolvimento integral das pessoas, como indivduos.'),
	(477,'Promover o desenvolvimento integral das pessoas, como cidados.'),
	(477,'Promover o desenvolvimento integral das pessoas, como profissionais.'),
	(478,'Identificar os perigos relacionados  sade ocupacional.'),
	(478,'Identificar os perigos relacionados  segurana.'),
	(478,'Identificar os perigos relacionados  ergonomia.'),
	(478,'Tratar os riscos relacionados  sade ocupacional.'),
	(478,'Tratar os riscos relacionados  segurana.'),
	(478,'Tratar os riscos relacionados  ergonomia.'),
	(479,'Identificar os fatores que afetam o bem-estar considerando os diferentes grupos de pessoas.'),
	(479,'Identificar os fatores que afetam a satisfao considerando os diferentes grupos de pessoas.'),
	(479,'Identificar os fatores que afetam a motivao considerando os diferentes grupos de pessoas.'),
	(480,'Tratar os fatores que afetam o bem-estar das pessoas e manter um clima organizacional favorvel ao alto desempenho.'),
	(480,'Tratar os fatores que afetam a satisfao das pessoas e manter um clima organizacional favorvel ao alto desempenho.'),
	(480,'Tratar os fatores que afetam a motivao das pessoas e manter um clima organizacional favorvel ao alto desempenho.'),
	(481,'Colaborar para a melhoria da qualidade de vida das pessoas fora do ambiente de trabalho.'),
	(482,'Avaliar os fatores que afetam o bem-estar, considerando os diferentes grupos de pessoas.'),
	(482,'Avaliar os fatores que afetam a satisfao, considerando os diferentes grupos de pessoas.'),
	(482,'Avaliar os fatores que afetam a motivao, considerando os diferentes grupos de pessoas.'),
	(483,'Identificar os processos finalsticos, considerando a misso institucional da organizao.'),
	(483,'Identificar os processos de apoio, considerando a misso institucional da organizao.'),
	(483,'Determinar os processos finalsticos, considerando a misso institucional da organizao.'),
	(483,'Determinar os processos de apoio, considerando a misso institucional da organizao.'),
	(484,'Traduzir em requisitos as necessidades dos cidados-usurios e da sociedade.'),
	(484,'Incorporar aos projetos de servios ou produtos as necessidades dos cidados-usurios e da sociedade.'),
	(484,'Incorporar aos processos finalsticos as necessidades dos cidados-usurios e da sociedade.'),
	(485,'Projetar os processos de apoio, visando o cumprimento dos requisitos definidos'),
	(485,'Projetar os processos finalsticos, visando o cumprimento dos requisitos definidos'),
	(486,'Controlar os processos finalsticos.'),
	(486,'Controlar os processos de apoio.'),
	(487,'Refinar os processos finalsticos.'),
	(487,'Refinar os processos de apoio.'),
	(488,'Identificar potenciais fornecedores visando assegurar a disponibilidade de fornecimento a longo prazo.'),
	(488,'Identificar potenciais fornecedores visando melhorar o desempenho.'),
	(488,'Identificar potenciais fornecedores visando assegurar o desenvolvimento sustentvel de sua cadeia de suprimentos.'),
	(488,'Desenvolver sua cadeia de suprimentos visando assegurar a disponibilidade de fornecimento a longo prazo.'),
	(488,'Desenvolver sua cadeia de suprimentos visando melhorar o seu desempenho.'),
	(488,'Desenvolver sua cadeia de suprimentos visando assegurar o desenvolvimento sustentvel de sua cadeia de suprimentos.'),
	(489,'Realizar o processo de aquisio de bens de forma a assegurar a transparncia do processo e atender a legislao.'),
	(489,'Realizar o processo de aquisio de materiais de forma a assegurar a transparncia do processo e atender a legislao.'),
	(489,'Realizar o processo de aquisio de servios de forma a assegurar a transparncia do processo e atender a legislao.'),
	(490,'Assegurar a qualidade dos bens adquiridos.'),
	(490,'Assegurar a qualidade dos produtos adquiridos.'),
	(490,'Assegurar a qualidade dos servios adquiridos.'),
	(491,'Realizar a gesto dos bens materiais quando for pertinente.'),
	(491,'Realizar a gesto dos bens patrimoniais quando for pertinente.'),
	(491,'Realizar a gesto dos estoques, quando for pertinente.'),
	(492,'Administrar o relacionamento com os fornecedores.'),
	(493,'Avaliar os fornecedores e prontamente informar sobre seu desempenho.'),
	(494,'Minimizar os custos associados a gesto do fornecimento.'),
	(495,'Envolver os fornecedores que atuam diretamente nos processos da organizao com os princpios Organizacionais relativos  responsabilidade socioambiental, incluindo os aspectos da segurana e sade.'),
	(495,'Comprometer os fornecedores que atuam diretamente nos processos da organizao com os princpios Organizacionais relativos  responsabilidade socioambiental, incluindo os aspectos da segurana e sade.'),
	(496,'Elaborar a proposta oramentria mais significativa que possa vir a afetar a execuo de suas atividades.'),
	(496,'Tratar as restries e liberaes de oramento mais significativas que possam vir a afetar a execuo de suas atividades.'),
	(497,'Gerenciar os processos oramentrios para suportar as necessidades estratgicas da organizao.'),
	(497,'Gerenciar os processos oramentrios para suportar as necessidades operacionais da organizao.'),
	(498,'Monitorar a execuo oramentria e os possveis realinhamentos entre o oramento, estratgias e objetivos da organizao.'),
	(498,'Monitorar a execuo financeira e os possveis realinhamentos entre o oramento, estratgias e objetivos da organizao.'),
	(499,'Selecionar as melhores opes de investimentos e aplicaes de recursos financeiros, quando pertinente.'),
	(499,'Realizar captaes de recursos financeiros, quando pertinente.'),
	(500,'Acompanhar as operaes da organizao em termos oramentrios e financeiros.'),
	(500,'Administrar os parmetros oramentrios e financeiros.'),
	(501,'Apresentar os resultados dos principais indicadores relativos aos cidadosusurios.Estratificar por grupos de cidados-usurios, segmentos de mercado ou tipos de produtos, quando aplicvel.Incluir os nveis de desempenho de organizaes consideradas como referencial comparativo pertinente;Explicar, resumidamente, os resultados apresentados, esclarecendo eventuais tendncias adversas e comparaes desfavorveis.'),
	(502,'Apresentar os resultados dos principais indicadores relativos  sociedade, incluindo os relativos  atuao socioambiental,  tica, ao controle social e s polticas pblicas. Estratificar os resultados por instalaes, quando aplicvel. Incluir os nveis de desempenho de organizaes consideradas como referencial comparativo pertinente; explicar, resumidamente, os resultados apresentados, esclarecendo eventuais tendncias adversas e comparaes desfavorveis.'),
	(503,'Apresentar os resultados dos principais indicadores relativos  gesto oramentria e financeira. Estratificar os resultados por unidades ou filiais, quando aplicvel.'),
	(504,'Apresentar os resultados dos principais indicadores relativos s pessoas, incluindo os relativos aos sistemas de trabalho,  capacitao e desenvolvimento e  qualidade de vida. Estratificar os resultados por grupos de pessoas da fora de trabalho, funes na organizao e, quando aplicvel, por instalaes.'),
	(505,'Apresentar os resultados dos principais indicadores relativos aos processos de suprimento.'),
	(506,'Apresentar os resultados dos principais indicadores relativos aos processos.');

/*PGQF 1000*/
INSERT INTO pratica_verbo(pratica_verbo_marcador, pratica_verbo_texto) VALUES 
	(600,'Tomar as principais decises, assegurando o envolvimento de todas as partes interessadas, a transparncia e a governabilidade.'),
	(600,'Comunicar as principais decises, assegurando o envolvimento de todas as partes interessadas, a transparncia e a governabilidade.'),
	(600,'Implementar as principais decises, assegurando o envolvimento de todas as partes interessadas, a transparncia e a governabilidade.'),
	(601,'Estabelecer os valores e os princpios organizacionais necessrios  criao de valor para todas as partes interessadas.'),
	(601,'Estabelecer os valores e os princpios organizacionais necessrios ao desenvolvimento sustentvel.'),
	(601,'Atualizar os valores e os princpios organizacionais necessrios  criao de valor para todas as partes interessadas.'),
	(601,'Atualizar os valores e os princpios organizacionais necessrios ao desenvolvimento sustentvel.'),
	(602,'Identificar os riscos organizacionais mais significativos que possam afetar a governabilidade.'),
	(602,'Identificar os riscos organizacionais mais significativos que possam afetar a capacidade da organizao de alcanar os seus objetivos estratgicos e realizar sua misso.'),
	(602,'Classificar os riscos organizacionais mais significativos que possam afetar a governabilidade.'),
	(602,'Classificar os riscos organizacionais mais significativos que possam afetar a capacidade da organizao de alcanar os seus objetivos estratgicos e realizar sua misso.'),
	(602,'Analisar os riscos organizacionais mais significativos que possam afetar a governabilidade.'),
	(602,'Analisar os riscos organizacionais mais significativos que possam afetar a capacidade da organizao de alcanar os seus objetivos estratgicos e realizar sua misso.'),
	(602,'Tratar os riscos organizacionais mais significativos que possam afetar a governabilidade.'),
	(602,'Tratar os riscos organizacionais mais significativos que possam afetar a capacidade da organizao de alcanar os seus objetivos estratgicos e realizar sua misso.'),
	(603,'Prestar contas de seus atos a quem a elegeu ou designou.'),
	(603,'Prestar contas de seus atos aos rgos de controle.'),
	(603,'Prestar contas dos resultados a quem a elegeu ou designou.'),
	(603,'Prestar contas dos resultados aos rgos de controle.'),
	(604,'Disseminar os princpios da administrao pblica na organizao.'),
	(604,'Disseminar os valores da administrao pblica na organizao.'),
	(604,'Disseminar as diretrizes de governo na organizao.'),
	(604,'Internalizar os princpios da administrao pblica na organizao.'),
	(604,'Internalizar os valores da administrao pblica na organizao.'),
	(604,'Internalizar as diretrizes de governo na organizao.'),
	(605,'Estabelecer um exemplo a ser seguido.'),
	(605,'Buscar novas oportunidades para a organizao.'),
	(605,'Promover o comprometimento com todas as partes interessadas.'),
	(606,'Disseminar os princpios organizacionais  fora de trabalho e, quando pertinente, s demais partes interessadas.'),
	(606,'Internalizar os princpios organizacionais  fora de trabalho e, quando pertinente, s demais partes interessadas.'),
	(607,'Incentivar o comprometimento de todos com a cultura da excelncia.'),
	(608,'Avaliar os lderes atuais e potenciais em relao s competncias desejadas pela organizao.'),
	(608,'Desenvolver os lderes atuais e potenciais em relao s competncias desejadas pela organizao.'),
	(609,'Conduzir a implementao do sistema de gesto da organizao, visando assegurar o atendimento aos requisitos de todas as partes interessadas.'),
	(610,'Estimular o aprendizado na organizao'),
	(611,'Analisar as necessidades de informaes comparativas para avaliar o desempenho da organizao.'),
	(612,'Analisar os desempenhos dos diversos nveis da organizao, considerando as informaes comparativas.'),
	(612,'Analisar os desempenhos dos diversos nveis da organizao, considerando o atendimento aos principais requisitos das partes interessadas.'),
	(612,'Analisar o desempenho integrado de toda a organizao, considerando as informaes comparativas.'),
	(612,'Analisar o desempenho integrado de toda a organizao, considerando o atendimento aos principais requisitos das partes interessadas.'),
	(613,'Avaliar o xito das estratgias a partir das concluses da anlise do seu desempenho.'),
	(613,'Avaliar o alcance dos respectivos objetivos da organizao a partir das concluses da anlise do seu desempenho.'),
	(614,'Comunicar as decises decorrentes da anlise do desempenho da organizao  fora de trabalho, em todos os nveis da organizao.'),
	(614,'Comunicar as decises decorrentes da anlise do desempenho da organizao a outras partes interessadas, quando pertinente.'),
	(615,'Acompanhar a implementao das decises decorrentes da anlise do desempenho da organizao.'),
	(616,'Formular os processos das polticas pblicas, quando pertinente.'),
	(617,'Formular os processos das estratgias da organizao.'),
	(618,'Considerar os aspectos relativos ao ambiente externo no processo de formulao das estratgias.'),
	(619,'Realizar a anlise do ambiente interno.'),
	(620,'Avaliar as estratgias.'),
	(620,'Selecionar as estratgias.'),
	(621,'Envolver as reas da organizao nos processos de formulao de estratgias.'),
	(621,'Envolver as partes interessadas, quando pertinente, nos processos de formulao de estratgias.'),
	(622,'Comunicar as estratgias s partes interessadas pertinentes para o estabelecimento de compromissos mtuos.'),
	(623,'Definir os indicadores para a avaliao da operacionalizao das estratgias, e definir os respectivos planos de ao.'),
	(623,'Estabelecer as metas de curto e longo prazos, e definir os respectivos planos de ao.'),
	(624,'Desdobrar as metas estabelecidas para as reas da organizao, assegurando a coerncia entre os indicadores utilizados na avaliao da implementao das estratgias e aqueles utilizados na avaliao do desempenho dos processos.'),
	(625,'Desdobrar os planos de ao para as reas da organizao, assegurando a coerncia com as estratgias selecionadas.'),
	(625,'Desdobrar os planos de ao para as reas da organizao, assegurando a consistncia entre os respectivos planos.'),
	(626,'Alocar os diferentes recursos para assegurar a implementao dos planos de ao.'),
	(627,'Comunicar as metas para a fora de trabalho e, quando pertinente, para as demais partes interessadas.'),
	(627,'Comunicar os indicadores para a fora de trabalho e, quando pertinente, para as demais partes interessadas.'),
	(627,'Comunicar os planos de ao para a fora de trabalho e, quando pertinente, para as demais partes interessadas.'),
	(628,'Realizar o monitoramento da implementao dos planos de ao.'),
	(629,'Identificar os cidados-usurios da organizao'),
	(629,'Classificar os cidados-usurios da organizao por tipos ou grupos.'),
	(630,'Identificar as necessidades e expectativas dos cidados-usurios, atuais e potenciais, e de ex-usurios, quando pertinente, para definio e melhoria dos produtos, servios e processos  da organizao.'),
	(630,'Analisar as necessidades e expectativas dos cidados-usurios, atuais e potenciais, e de ex-usurios, quando pertinente, para definio e melhoria dos produtos, servios e processos da organizao.'),
	(630,'Compreender as necessidades e expectativas dos cidados-usurios, atuais e potenciais, e de ex-usurios, quando pertinente, para definio e melhoria dos produtos, servios e processos da organizao.'),
	(630,'Utilizar as necessidades e expectativas dos cidados-usurios, atuais e potenciais, e de ex-usurios, quando pertinente, para definio e melhoria dos produtos, servios e processos da organizao.'),
	(631,'Divulgar os produtos e servios da organizao aos cidados de forma a criar credibilidade, confiana e imagem positiva.'),
	(631,'Divulgar os padres de atendimento da organizao aos cidados de forma a criar credibilidade, confiana e imagem positiva.'),
	(631,'Divulgar as aes de melhoria da organizao aos cidados de forma a criar credibilidade, confiana e imagem positiva.'),
	(632,'Identificar os nveis de conhecimento do universo potencial de cidados-usurios sobre a organizao e seus servios.'),
	(632,'Identificar os nveis de conhecimento do universo potencial de cidados-usurios sobre a organizao e seus produtos.'),
	(632,'Identificar os nveis de conhecimento do universo potencial de cidados-usurios sobre a organizao e suas aes.'),
	(632,'Avaliar os nveis de conhecimento do universo potencial de cidados-usurios sobre a organizao e seus servios.'),
	(632,'Avaliar os nveis de conhecimento do universo potencial de cidados-usurios sobre a organizao e seus produtos.'),
	(632,'Avaliar os nveis de conhecimento do universo potencial de cidados-usurios sobre a organizao e suas aes.'),
	(633,'Avaliar a imagem da organizao perante os cidados-usurios.'),
	(634,'Avaliar o atendimento ao universo potencial dos cidados-usurios identificados.'),
	(635,'Definir aos cidados-usurios os principais canais de acesso para solicitarem informaes ou esclarecimentos sobre os servios e produtos.'),
	(635,'Definir aos cidados-usurios os principais canais de acesso para comunicarem suas sugestes.'),
	(635,'Definir aos cidados-usurios os principais canais de acesso para comunicarem suas reclamaes.'),
	(636,'Tratar as reclamaes, formais e informais dos cidados-usurios, visando assegurar a resposta rpida e eficaz e o seu aproveitamento por toda a organizao.'),
	(636,'Tratar as sugestes, formais e informais dos cidados-usurios, visando assegurar a resposta rpida e eficaz e o seu aproveitamento por toda a organizao.'),
	(637,'Acompanhar os servios e produtos, recentemente prestados ou entregues, junto aos cidados-usurios para permitir  organizao gerar solues rpidas e eficazes.'),
	(637,'Acompanhar os servios e produtos, recentemente prestados ou entregues, junto aos cidados-usurios para permitir  organizao evitar problemas de relacionamento.'),
	(637,'Acompanhar os servios e produtos, recentemente prestados ou entregues, junto aos cidados-usurios para permitir  organizao atender s expectativas dos cidados-usurios.'),
	(638,'Avaliar a satisfao dos cidados-usurios em relao aos produtos da organizao e aos da concorrncia, quando pertinente.'),
	(638,'Avaliar a insatisfao dos cidados-usurios em relao aos produtos da organizao e aos da concorrncia, quando pertinente.'),
	(638,'Avaliar a satisfao dos cidados-usurios em relao aos servios da organizao e aos da concorrncia, quando pertinente.'),
	(638,'Avaliar a insatisfao dos cidados-usurios em relao aos servios da organizao e aos da concorrncia, quando pertinente.'),
	(639,'Utilizar as informaes obtidas dos cidados-usurios para melhorar o seu nvel de satisfao.'),
	(640,'Identificar os aspectos e tratar os impactos sociais e ambientais dos produtos, desde o projeto at a disposio final, sobre os quais tenha infuncia.'),
	(640,'Identificar os aspectos e tratar os impactos sociais e ambientais dos servios, desde o projeto at a disposio final, sobre os quais tenha infuncia.'),
	(640,'Identificar os aspectos e tratar os impactos sociais e ambientais dos processos, desde o projeto at a disposio final, sobre os quais tenha infuncia.'),
	(640,'Identificar os aspectos e tratar os impactos sociais e ambientais das instalaes, desde o projeto at a disposio final, sobre os quais tenha infuncia.'),
	(641,'Comunicar os impactos sociais e ambientais dos servios, assim como as respectivas polticas, aes e resultados  sociedade.'),
	(641,'Comunicar os impactos sociais e ambientais dos produtos, assim como as respectivas polticas, aes e resultados  sociedade.'),
	(641,'Comunicar os impactos sociais e ambientais dos processos, assim como as respectivas polticas, aes e resultados  sociedade.'),
	(641,'Comunicar os impactos sociais e ambientais das instalaes, assim como as respectivas polticas, aes e resultados  sociedade.'),
	(642,'Tratar as pendncias ou eventuais sanes referentes aos requisitos legais, relatando as atualmente existentes.'),
	(642,'Tratar as pendncias ou eventuais sanes referentes aos requisitos regulamentares, relatando as atualmente existentes.'),
	(642,'Tratar as pendncias ou eventuais sanes referentes aos requisitos ticos ou contratuais, relatando as atualmente existentes.'),
	(643,'Promover as aes que envolvam a conservao de recursos no-renovveis a preservao dos ecossistemas.'),
	(643,'Promover as aes que envolvam a conservao de recursos no-renovveis a otimizao do uso de recursos renovveis.'),
	(644,'Conscientizar a fora de trabalho nas questes relativas  responsabilidade socioambiental.'),
	(644,'Conscientizar os fornecedores nas questes relativas  responsabilidade socioambiental.'),
	(644,'Conscientizar as demais partes interessadas nas questes relativas  responsabilidade socioambiental.'),
	(644,'Envolver a fora de trabalho nas questes relativas  responsabilidade socioambiental.'),
	(644,'Envolver os fornecedores nas questes relativas  responsabilidade socioambiental.'),
	(644,'Envolver as demais partes interessadas nas questes relativas  responsabilidade socioambiental.'),
	(645,'Direcionar os esforos para o fortalecimento da sociedade executando projetos sociais, quando pertinente.'),
	(645,'Direcionar os esforos para o fortalecimento da sociedade executando projetos voltados para o desenvolvimento nacional, regional, local ou setorial, quando pertinente.'),
	(645,'Direcionar os esforos para o fortalecimento da sociedade apoiando projetos sociais, quando pertinente.'),
	(645,'Direcionar os esforos para o fortalecimento da sociedade apoiaando projetos voltados para o desenvolvimento nacional, regional, local ou setorial, quando pertinente.'),
	(646,'Divulgar ofcialmente os atos e as informaes sobre os planos da organizao.'),
	(646,'Divulgar ofcialmente os atos e as informaes sobre os programas da organizao.'),
	(646,'Divulgar ofcialmente os atos e as informaes sobre os projetos da organizao.'),
	(647,'Tornar pblicas as informaes relativas  execuo fsica da organizao e democratizar seu acesso.'),
	(647,'Tornar pblicas as informaes relativas  execuo oramentria da organizao e democratizar seu acesso.'),
	(647,'Tornar pblicas as informaes relativas  execuo financeira da organizao e democratizar seu acesso.'),
	(647,'Tornar pblicas as informaes relativas  gesto da organizao e democratizar seu acesso.'),
	(648,'Estimular a sociedade a participar no controle dos resultados organizacionais.'),
	(648,'Orientar a sociedade a participar no controle dos resultados organizacionais.'),
	(649,'Estimular o exerccio da responsabilidade social da fora de trabalho, no cumprimento de seu papel de agente pblico.'),
	(649,'Estimular o exerccio da responsabilidade social da fora de trabalho, no comportamento tico em todos os nveis.'),
	(650,'Disponibilizar os canais de comunicao para receber eventuais denncias de violao da tica.'),
	(651,'Identificar as necessidades da sociedade em relao ao setor de atuao'),
	(651,'Transformar as necessidades em requisitos para a formulao das polticas pblicas, quando pertinente.'),
	(651,'Transformar as necessidades em requisitos para a execuo das polticas pblicas, quando pertinente.'),
	(652,'Contribuir na formulao das polticas pblicas do seu setor.'),
	(652,'Atuar na execuo das polticas pblicas do seu setor.'),
	(653,'Divulgar as polticas pblicas e seus respectivos objetivos para a sociedade.'),
	(654,'Monitorar a execuo das polticas pblicas, em seu nvel de atuao.'),
	(654,'Avaliar a execuo das polticas pblicas, em seu nvel de atuao.'),
	(655,'Avaliar a satisfao da sociedade e das demais partes interessadas com a implementao das polticas pblicas, em seu nvel de atuao.'),
	(656,'Identificar as necessidades de coleta e tratamento, e guardar informaes para apoiar a gesto organizacional.'),
	(656,'Identificar as necessidades de coleta e tratamento, e guardar informaes para apoiar as operaes dirias.'),
	(656,'Identificar as necessidades de coleta e tratamento, e guardar informaes para apoiar as as estratgias.'),
	(656,'Identificar as necessidades de coleta e tratamento, e guardar informaes para apoiar o progresso dos planos de ao.'),
	(656,'Identificar as necessidades de coleta e tratamento, e guardar informaes para subsidiar a tomada de deciso em todos os nveis e reas da organizao.'),
	(657,'Definir os principais sistemas de informao, visando atender s necessidades identificadas da organizao e dos usurios.'),
	(657,'Desenvolver os principais sistemas de informao, visando atender s necessidades identificadas da organizao e dos usurios.'),
	(657,'Implantar os principais sistemas de informao, visando atender s necessidades identificadas da organizao e dos usurios.'),
	(657,'Atualizar os principais sistemas de informao, visando atender s necessidades identificadas da organizao e dos usurios.'),
	(658,'Estabelecer a memria administrativa da organizao.'),
	(658,'Manter a memria administrativa da organizao.'),
	(659,'Utilizar a gesto da informao para apoiar o cumprimento da misso institucional e promover a integrao da organizao com seus cidados-usurios.'),
	(659,'Utilizar a gesto da informao para apoiar o cumprimento da misso institucional e promover a integrao da organizao com a sociedade.'),
	(659,'Utilizar a gesto da informao para apoiar o cumprimento da misso institucional e promover a integrao da organizao com seus fornecedores.'),
	(659,'Utilizar a gesto da informao para apoiar o cumprimento da misso institucional e promover a integrao da organizao com seus parceiros.'),
	(660,'Colocar  disposio dos pblicos internos e externos as informaes necessrias  organizao, incluindo cidados-usurios.'),
	(660,'Colocar  disposio dos pblicos internos e externos as informaes necessrias  organizao, incluindo fornecedores.'),
	(660,'Colocar  disposio dos pblicos internos e externos as informaes necessrias  organizao, incluindo parceiros.'),
	(661,'Gerenciar a segurana das informaes.'),
	(662,'Identificar as organizaes consideradas como um referencial comparativo pertinente.'),
	(663,'Identificar as fontes de informaes comparativas.'),
	(663,'Obter as informaes comparativas.'),
	(663,'Manter atualizadas as informaes comparativas.'),
	(664,'Utilizar as informaes obtidas para melhorar o conhecimento dos processos organizacionais.'),
	(664,'Utilizar as informaes obtidas para estabelecer metas ousadas.'),
	(664,'Utilizar as informaes obtidas para promover melhorias no desempenho da organizao.'),
	(665,'Desenvolver o conhecimento na organizao.'),
	(665,'Compartilhar o conhecimento na organizao.'),
	(666,'Manter o conhecimento.'),
	(666,'Proteger o conhecimento.'),
	(667,'Assegurar que a gesto do conhecimento seja utilizada para melhorar os processos da organizao.'),
	(667,'Assegurar que a gesto do conhecimento seja utilizada para melhorar produtos da organizao.'),
	(667,'Assegurar que a gesto do conhecimento seja utilizada para melhorar servios da organizao.'),
	(668,'Identificar os ativos intangveis da organizao.'),
	(668,'Desenvolver os ativos intangveis da organizao.'),
	(668,'Mensurar os ativos intangveis da organizao.'),
	(669,'Definir a organizao do trabalho, visando o alto desempenho da organizao.'),
	(669,'Implementar a organizao do trabalho, visando o alto desempenho da organizao.'),
	(670,'Selecionar as pessoas para preenchimento de cargos e funes, em consonncia com as estratgias da organizao.'),
	(670,'Selecionar as pessoas para preenchimento de cargos e funes, em consonncia com os objetivos da organizao.'),
	(670,'Selecionar as pessoas para preenchimento de cargos e funes, em consonncia com a misso da organizao.'),
	(671,'Definir os canais de interlocuo com a fora de trabalho da organizao, quando pertinente.'),
	(671,'Definir a negociao com a fora de trabalho da organizao, quando pertinente.'),
	(671,'Disponibilizar os canais de interlocuo com a fora de trabalho da organizao, quando pertinente.'),
	(671,'Disponibilizar a negociao com a fora de trabalho da organizao, quando pertinente.'),
	(672,'Estimular a integrao das pessoas.'),
	(672,'Estimular a integrao das equipes.'),
	(672,'Estimular a cooperao das pessoas.'),
	(672,'Estimular a cooperao das equipes.'),
	(673,'Gerenciar o desempenho das pessoas e das equipes, de forma a estimular a obteno de metas de alto desempenho.'),
	(673,'Gerenciar o desempenho das pessoas e das equipes, de forma a estimular a cultura da excelncia na organizao.'),
	(673,'Gerenciar o desempenho das pessoas e das equipes, de forma a estimular o desenvolvimento profssional.'),
	(674,'Estimular o alcance de metas de alto desempenho atravs do sistema de remunerao, reconhecimento e incentivo para as pessoas.'),
	(674,'Estimular o aprendizado atravs do sistema de remunerao, reconhecimento e incentivo para as pessoas.'),
	(674,'Estimular a cultura da excelncia atravs do sistema de remunerao, reconhecimento e incentivo para as pessoas.'),
	(675,'Identificar as necessidades de capacitao'),
	(675,'Identificar as necessidades de desenvolvimento'),
	(676,'Compatibilizar as necessidades de capacitao das pessoas com as necessidades da organizao, para efeito da definio dos programas de capacitao.'),
	(676,'Compatibilizar as necessidades de capacitao das pessoas com as necessidades da organizao, para efeito da definio dos programas de desenvolvimento.'),
	(676,'Compatibilizar as necessidades de desenvolvimento das pessoas com as necessidades da organizao, para efeito da definio dos programas de capacitao.'),
	(676,'Compatibilizar as necessidades de desenvolvimento das pessoas com as necessidades da organizao, para efeito da definio dos programas de desenvolvimento.'),
	(677,'Abordar a cultura da excelncia atravs dos programas de capacitao.'),
	(677,'Contribuir para consolidar o aprendizado organizacional atravs dos programas de capacitao.'),
	(678,'Conceber a forma de realizao dos programas de capacitao e desenvolvimento considerando as necessidades da organizao.'),
	(678,'Conceber a forma de realizao dos programas de capacitao e desenvolvimento considerando as necessidades das pessoas.'),
	(678,'Conceber a forma de realizao dos programas de capacitao e desenvolvimento considerando os recursos disponveis.'),
	(679,'Avaliar as habilidades em relao  sua utilidade na execuo do trabalho da organizao.'),
	(679,'Avaliar os conhecimentos adquiridos em relao  sua utilidade na execuo do trabalho da organizao.'),
	(679,'Avaliar as habilidades em relao  sua efccia na consecuo das estratgias da organizao.'),
	(679,'Avaliar os conhecimentos adquiridos em relao  sua efccia na consecuo das estratgias da organizao.'),
	(680,'Promover o desenvolvimento integral das pessoas, como indivduos.'),
	(680,'Promover o desenvolvimento integral das pessoas, como cidados.'),
	(680,'Promover o desenvolvimento integral das pessoas, como profssionais.'),
	(681,'Identificar os perigos relacionados  sade ocupacional.'),
	(681,'Identificar os perigos relacionados  segurana.'),
	(681,'Identificar os perigos relacionados  ergonomia.'),
	(681,'Tratar os riscos relacionados  sade ocupacional.'),
	(681,'Tratar os riscos relacionados  segurana.'),
	(681,'Tratar os riscos relacionados  ergonomia.'),
	(682,'Identificar os fatores que afetam o bem-estar considerando os diferentes grupos de pessoas.'),
	(682,'Identificar os fatores que afetam a satisfao considerando os diferentes grupos de pessoas.'),
	(682,'Identificar os fatores que afetam a motivao considerando os diferentes grupos de pessoas.'),
	(683,'Tratar os fatores que afetam o bem-estar das pessoas e manter um clima organizacional favorvel ao alto desempenho.'),
	(683,'Tratar os fatores que afetam a satisfao das pessoas e manter um clima organizacional favorvel ao alto desempenho.'),
	(683,'Tratar os fatores que afetam a motivao das pessoas e manter um clima organizacional favorvel ao alto desempenho.'),
	(684,'Colaborar para a melhoria da qualidade de vida das pessoas e respectivas famlias fora do ambiente de trabalho.'),
	(685,'Avaliar os fatores que afetam o bem-estar.'),
	(685,'Avaliar os fatores que afetam a satisfao.'),
	(685,'Avaliar os fatores que afetam a motivao.'),
	(686,'Identificar os processos de apoio, considerando a misso institucional da organizao.'),
	(686,'Determinar os processos de apoio, considerando a misso institucional da organizao.'),
	(686,'Identificar os processos finalsticos, considerando a misso institucional da organizao.'),
	(686,'Determinar os processos finalsticos, considerando a misso institucional da organizao.'),
	(687,'Traduzir as necessidades dos cidados-usurios e da sociedade em requisitos aos projetos de servios ou produtos.'),
	(687,'Traduzir as necessidades dos cidados-usurios e da sociedade em requisitos aos processos finalsticos.'),
	(687,'Incorporar as necessidades dos cidados-usurios e da sociedade em requisitos aos projetos de servios.'),
	(687,'Incorporar as necessidades dos cidados-usurios e da sociedade em requisitos aos processos finalsticos.'),
	(688,'Projetar os processos finalsticos visando o cumprimento dos requisitos definidos.'),
	(688,'Projetar os processos de apoio visando o cumprimento dos requisitos definidos.'),
	(689,'Controlar os processos finalsticos.'),
	(689,'Controlar os processos de apoio.'),
	(690,'Refinar os processos finalsticos.'),
	(690,'Refinar os processos de apoio.'),
	(691,'Identificar potenciais fornecedores visando assegurar a disponibilidade de fornecimento a longo prazo.'),
	(691,'Identificar potenciais fornecedores visando melhorar seu desempenho e o desenvolvimento sustentvel de sua cadeia de suprimentos.'),
	(691,'Desenvolver sua cadeia de suprimentos visando assegurar a disponibilidade de fornecimento a longo prazo.'),
	(691,'Desenvolver sua cadeia de suprimentos visando melhorar o seu desempenho e o desenvolvimento sustentvel de sua cadeia de suprimentos.'),
	(692,'Realizar o processo de aquisio de bens de forma a assegurar a transparncia e atender a legislao.'),
	(692,'Realizar o processo de aquisio de materiais de forma a assegurar a transparncia e atender a legislao.'),
	(692,'Realizar o processo de aquisio de servios de forma a assegurar a transparncia e atender a legislao.'),
	(693,'Assegurar a qualidade dos bens adquiridos.'),
	(693,'Assegurar a qualidade dos produtos adquiridos.'),
	(693,'Assegurar a qualidade dos servios adquiridos.'),
	(694,'Realizar a gesto dos bens materiais quando for pertinente.'),
	(694,'Realizar a gesto dos bens patrimoniais quando for pertinente.'),
	(694,'Realizar a gesto dos estoques, quando for pertinente.'),
	(695,'Administrar o relacionamento com os fornecedores.'),
	(696,'Avaliar os fornecedores e prontamente informar sobre seu desempenho.'),
	(697,'Minimizar os custos associados  gesto do fornecimento.'),
	(698,'Envolver os fornecedores que atuam diretamente nos processos da organizao com os princpios organizacionais relativos  responsabilidade socioambiental, incluindo os aspectos da segurana e sade.'),
	(698,'Comprometer os fornecedores que atuam diretamente nos processos da organizao com os princpios organizacionais relativos  responsabilidade socioambiental, incluindo os aspectos da segurana e sade.'),
	(699,'Elaborar a proposta oramentria mais significativa que possa vir a afetar a execuo de suas atividades.'),
	(699,'Tratar as restries e liberaes de oramento mais significativas que possam vir a afetar a execuo de suas atividades.'),
	(700,'Gerenciar os processos oramentrios para suportar as necessidades estratgicas da organizao.'),
	(700,'Gerenciar os processos oramentrios para suportar as necessidades operacionais da organizao.'),
	(700,'Gerenciar os processos financeiros para suportar as necessidades operacionais da organizao.'),
	(700,'Gerenciar os processos financeiros para suportar as necessidades estratgicas da organizao.'),
	(701,'Monitorar a execuo oramentria e os possveis realinhamentos entre o oramento, estratgias e objetivos da organizao.'),
	(701,'Monitorar a execuo financeira e os possveis realinhamentos entre o oramento, estratgias e objetivos da organizao.'),
	(702,'Selecionar as melhores opes de investimentos e aplicaes de recursos financeiros, quando pertinente.'),
	(702,'Realizar captaes de recursos financeiros, quando pertinente.'),
	(703,'Acompanhar as operaes que geram receita.'),
	(704,'Administrar os  parmetros oramentrios.'),
	(704,'Administrar os  parmetros financeiros.'),
	(705,'Apresentar os resultados dos principais indicadores relativos aos cidados-usurios.'),
	(706,'Apresentar os resultados dos principais indicadores relativos  sociedade, incluindo os relativos  atuao socioambiental,  tica, ao controle social e s polticas pblicas.'),
	(707,'Apresentar os resultados dos principais indicadores relativos  gesto oramentria e financeira.'),
	(708,'Apresentar os resultados dos principais indicadores relativos s pessoas, incluindo os relativos aos sistemas de trabalho,  capacitao e ao desenvolvimento e  qualidade de vida.'),
	(709,'Apresentar os resultados dos principais indicadores relativos aos produtos adquiridos e  gesto de relacionamento com os fornecedores.'),
	(710,'Apresentar os resultados dos indicadores relativos ao produto/servio e  gesto dos processos finalsticos e de apoio.');

/*Exrcito 500*/
INSERT INTO pratica_verbo(pratica_verbo_marcador, pratica_verbo_texto) VALUES 
(800,'Tomar decises relativas aos principais processos.'),
  (801,'Tomar decises relativas ao plano de gesto.'),
  (802,'Comunicar as principais decises tomadas, de carter ostensivo, a todos os escales da OM'),
  (802,'Comunicar as principais decises tomadas, de carter ostensivo, a todos os integrantes da OM'),
  (803,'Implementar decises em cada escalo da OM.'),
  (804,'Controlar resultado das sees do OM.'),
  (804,'Controlar resultado de sees equivalente do OM.'),
  (805,'Prestar conta dos resultados organizacionais ao escalo enquadrante.'),
  (806,'Estabelecer os valores, contidos no Plano de Gesto, necessrios ao cumprimento de sua Misso.'),
  (807,'Atualizar os valores, contidos no Plano de Gesto, necessrios ao cumprimento de sua Misso.'),
  (808,'Disseminar os princpios da Administrao Pblica (legalidade, impessoalidade, moralidade, publicidade e eficincia) para todos os integrantes da OM.'),
  (809,'Descrever a atuao do Comando junto ao Escalo Superior para melhorar as condies de cumprimento da misso.'),
  (810,'Verificar se os valores so aplicados pelos integrantes da OM.'),
  (811,'Estabelecer os principais padres de trabalho para regular as atividades internas da OM.'),
  (811,'Estabelecer os principais padres de trabalho para regular as atividades externas da OM.'),
  (812,'Verificar o cumprimento dos padres de trabalho das atividades da OM.'),
  (812,'Verificar o cumprimento das regras de funcionamento das atividades da OM.'),
  (813,'Apresentar os Indicadores de Desempenho utilizados para possibilitar as aes corretivas em cada processo.'),
  (814,'Descrever a atuao do Comando na busca de parcerias para facilitar o cumprimento da misso da OM e do EB.'),
  (814,'Buscar parcerias para facilitar o cumprimento da misso da OM e do EB.'),
  (814,'Descrever a atuao do Comando na busca de parcerias para facilitar a capacitao do pessoal da OM e do EB.'),
  (814,'Descrever a atuao do Comando na busca de parcerias para melhorar a imagem da OM'),
  (814,'Descrever a atuao do Comando na busca de parcerias para melhorar a imagem do EB.'),
  (815,'Disseminar os valores da OM pelo Comando aos seus integrantes.'),
  (816,'Utilizar os valores da OM pelos seus integrantes.'),
  (817,'Atuar para verificar se os valores so de conhecimento de todos os integrantes da OM.'),
  (818,'Assegurar a equidade entre scios.'),
  (818,'Assegurar a equidade entre mantenedores.'),
  (818,'Assegurar a equidade entre instituidores.'),
  (819,'Incentivar o comprometimento na OM.'),
  (820,'estimular o aprendizado.'),
  (820,'estimular a implantao das melhorias.'),
  (821,'Analisar os desempenhos dos civersos nveis da OM.'),
  (822,'Analisar o desempenho integrado de toda a OM.'),
  (823,'Identificar as necessidades de informaes.'),
  (823,'Avaliar o desempenho da OM.'),
  (824,'Avaliar as estratgias contidas no plano de gesto da OM.'),
  (825,'Avaliar os objetivos organizacionais contigos no plano de gesto.'),
  (826,'Comunicar decises a todos da OM.'),
  (827,'Acompanhar a implementao das decises decorrentes.'),
  (828,'Definir a miso da OM, considerando os planos.'),
  (828,'Definir a miso da OM, considerando as diretrizes.'),
  (829,'Garantir o entendimento da misso pelos integrantes.'),
  (830,'Definir viso de futuro OM.'),
  (831,'Analisar o ambiente interno.'),
  (832,'Analisar o ambiente externo.'),
  (833,'Definir objetivos organizacionais para OM.'),
  (834,'Definir estratgia para OM.'),
  (835,'Comunicar plano de gesto para todos.'),
  (836,'Desdobrar estratgias em planos de ao.'),
  (837,'Definir indicadores de desempenho.'),
  (837,'Definir indicadores de avaliao estratgica'),
  (838,'Definir metas da OM.'),
  (839,'Estabelecer as metas para diversas reas da OM.'),
  (839,'Transmitir as metas para diversas reas da OM.'),
  (840,'Alocar recursos para assegurar a implementao de planos de ao.'),
  (841,'Acompanhar a implementao dos planos de ao.'),
  (842,'Identificar os principais produtos.'),
  (842,'Identificar os principais servios.'),
  (843,'Apresentar os principais produtosda OM.'),
  (843,'Apresentar os principais servios da OM.'),
  (844,'Identificar os principais usurios dos seus produtos.'),
  (844,'Identificar os principais usurios dos seus servios.'),
  (845,'Apresentar os respectivos usurios dos principais produtos da OM.'),
  (845,'Apresentar os respectivos usurios dos principai servios da OM.'),
  (846,'Identificar os principais requisitos dos produtos apresentados.'),
  (846,'Identificar os principais requisitos dos servios apresentados.'),
  (846,'Identificar as principais especificaes dos produtos apresentados.'),
  (846,'Identificar os principais especificaes dos servios apresentados.'),
  (847,'Avaliar o atendimento s necessidades do escalo superior.'),
  (847,'Avaliar o atendimento s necessidades dos usurios.'),
  (848,'Divulgar os principais produtos usurios.'),
  (848,'Divulgar os principais servios aos usurios.'), 
  (849,'Disponibilizar canais de acesso para todos usurios obter informaes.'),
  (850,'Tratar as solicitaes dos usurios.'),
  (850,'Tratar as solicitaes do escalo superior.'),
  (851,'Avaliar o atendimento s necessidades do escalo superios.'),
  (851,'Avaliar o atendimento s necessidades dos usurios.'),
  (852,'Melhorar os processos da OM com base nas informaes dos usurios.'),
  (853,'Avaliar a satisfao de seus usurios.'),
  (854,'Identificar os impactos sociais positivos de seus servios.'),
  (854,'Identificar os impactos sociais positivos de seus processos.'),
  (854,'Identificar os impactos sociais positivos de suas intalaes.'),
  (855,'Identificar os impactos ambientais positivos de servios.'),
  (855,'Identificar os impactos ambientais positivos de processos.'),
  (855,'Identificar os impactos ambientais positivos de intalaes.'),
  (856,'Identificar os impactos sociais negativos de seus servios.'),
  (856,'Identificar os impactos sociais negativos de seus processos.'),
  (856,'Identificar os impactos sociais negativos de suas intalaes.'),
  (857,'Identificar os impactos ambientais negativos de seus servios.'),
  (857,'Identificar os impactos ambientais negativos de seus processos.'),
  (857,'Identificar os impactos ambientais negativos de suas intalaes.'),
  (858,'Identificar quais impactos sociais  dos servios da OM.'),
  (858,'Identificar quais impactos ambientais dos servios da OM.'),
  (858,'Identificar quais impactos sociais  dos processos da OM.'),
  (858,'Identificar quais impactos ambientais dos processos da OM.'),
  (858,'Identificar quais impactos sociais  das intalaes da OM.'),
  (858,'Identificar quais impactos ambientais das intalaes da OM.'),
  (859,'Tratar os impactos sociais da OM.'),
  (859,'Tratar os impactos ambientais negativos dos servios da OM.'),
  (859,'Tratar os impactos ambientais negativos dos processos da OM.'),
  (859,'Tratar os impactos ambientais negativos das instalaes da OM.'),
  (860,'Tratar pendncias.'),
  (860,'Tratar eventuais sanes referentes aos reqisitos legais.'),
  (860,'tratar eventuais regulamentares tico.'),
  (861,'Selecionar projetos sociais dentro de sua rea de atuao.'),
  (862,'Gerenciar os projetos sociais sob sua responsbilidade.'),
  (863,'Desenvolver projetos sociais pela OM.'),
  (864,'Concientizar os integrantes da sua responsbilidde social.'),
  (865,'Estimular o exerccio da responsabilidade social dos seus integrantes.'),
  (866,'Disponibilizar canais de comunicao social aos integrantes.'),
  (867,'Identificar as aes polticas pblicas a cardo da OM.'),
  (868,'Planejar aes de execuo de polticas pblicas a seu cargo.'),
  (869,'Avaliar a satisfao do escalo superior nas aes de execuo das polticas pblicas a cargo da OM.'),
  (870,'Avaliar a satisfao da sociedade nas aes da execuo das polticas pblicas a cargo da OM.'),
  (871,'Identificar as necessidades de informaes atinentes  execuo dos processos organizacionais.'),
  (872,'Identificar as necessidads de informaes atinentes  execuo dos planos de ao contidos em seu plano de gesto.'),
  (873,'Atualizar as informaes da OM.'),
  (874,'Implantar os principais sistemas de informao, visando atender s necessidades da om identificadas.'),
  (874,'Atualizar os principais sistemas de informao, visando atender s necessidades da om identificadas.'),
  (875,'Estabelecer a memria adminstrativa da OM.'),
  (875,'Manter a memria adminstrativa da OM.'),
  (876,'Disponibilizar as informaes para todos os seus usurios constantes do Perfil da OM.'),
  (877,'Gerenciar a segurana das informaes em meio fsico.'),
  (878,'Gerenciar a segurana das informaes por meio eletrnico.'),
  (879,'Identificar outras ofranizaes (civis ou militares) cujos processos podem ser considerados referenciais comparativos pertinentes.'),
  (880,'Identificar os critrios utilizados para definir as organizaes consideradas referencial .'),
  (881,'Identificar os canais utilizados pela OM par obter as informaes comparativas.'),
  (882,'Atualizar as informaes comparativas utilizadas pela OM.'),
  (883,'Identificar as informaes obtidas so utilizadas para melhorar os processos organizacionais.'),
  (884,'Apresentar as trs ltimas melhorias implementadas nos processos da OM decorrentes do uso de informaes comparativas.'),
  (885,'Obter informaes utilizadas para melhorar o desempenho da OM.'),
  (886,'Apresentar as trs ltimas melhorias implementadas no desempenho da OM decorrentes do uso de informaes comparativas.'),
  (887,'Identificar as necessidades de competncia para o desempenho das suas funes prevista no QCP.'),
  (888,'Identificar as necessidades dos diversos tipos de conhecimentos do meio civil para seus integrantes.'),
  (889,'Assegurar que os diversos conhecimentos existentes sejam utilizados para melhorar os seus processos.'),
  (889,'Assegurar que os diversos conhecimentos existentes sejam utilizados para melhorar os seus servios.'),
  (889,'Utilizar os conhecimentos existentes para melhorar os seus processos.'),
  (889,'Utilizar os conhecimentos existentes para melhorar os seus servios.'),
  (890,'Implementar melhorias na OM decorrentes do conhecimento de seus integrantes.'),
  (891,'Reter o conhecimento de seus integrantes por meio da padronizao de processos.'),
  (891,'Reter o conhecimento de seus integrantes por meio de outras prticas.'),
  (892,'Selecionar as pessoas para preenchimento de cargos destinadas a militares.'),
  (892,'Selecionar as pessoas para preenchimento de cargos destinados a civis temporrios.'),
  (892,'Selecionar as pessoas para preenchimento de funes destinadas a militares .'),
  (892,'Selecionar as pessoas para preenchimento de funes destinadas a civis temporrios.'),
  (893,'Avaliar o desempenho dos integrantes temporrios.'),
  (894,'Disponibilizar os canais de comunicao dos integrantes da OM com o Comando da OM.'),
  (895,'Estimular a cooperao entre os militares da OM.'),
  (896,'Integrar novos integrantes  cultura da OM, visando prepar-las para o exerccio das suas funes.'),
  (896,'Integrar novos integrantes ao ambiente da OM, visando prepar-las para o exerccio das suas funes.'),
  (897,'Identificar o sistema de reconhecimento para os integrantes da OM estimula o alcance de metas de desempenho.'),
  (898,'Identificar as necessidades de treinamento dos integrantes da OM so identificadas.'),
  (899,'Identificar os integrantes em cargo de chefia na OM so treinados em ferramentas'),
  (899,'Identificar os integrantes em cargo de chefia na OM so treinados em metodologias de gesto pela excelncia'),
  (900,'Identificar como a OM treina seus integrantes nos assuntos relacionados  gesto.'),
  (901,'Apresentar as principais aes de treinamento na rea da gesto.'),
  (902,'Gerenciar os treinamentos necessrios ao cumprimento dos seus Planos de Ao.'),
  (903,'Acompanhar as transaes com os clientes, de forma a permitir  organizao gerar solues rpidas e eficazes.'),
  (904,'Identificar os riscos relacionados  sade de seus integrantes na execuo de seus processos.'),
  (904,'Identificar os riscos relacionados  sade de seus integrantes na execuo de suas atividades.'),
  (905,'Identificar os riscos relacionados  segurana de seus integrantes na execuo de seus processos.'),
  (905,'Identificar os riscos relacionados  segurana de seus integrantes na execuo de suas atividades.'),
  (906,'Tratar os riscos relacionados  sade de seus integrantes na execuo de seus processos.'),
  (906,'Tratar os riscos relacionados  sade de seus integrantes na execuo de suas atividades.'),
  (907,'Tratar os riscos relacionados  segurana de seus integrantes na execuo de seus processos.'),
  (907,'Tratar os riscos relacionados  segurana de seus integrantes na execuo de suas atividades.'),
  (908,'Identificar os fatores que afetam o bem-estar dos integrantes da OM.'),
  (908,'Identificar os fatores que afetam a satisfao dos integrantes da OM.'),
  (908,'Identificar os fatores que afetam a motivao dos integrantes da OM.'),
  (909,'Tratar os fatores que afetam o bem-estar dos militares da OM e mantido um clima organizacional favorvel.'),
  (909,'Tratar os fatores que afetam  a satisfao dos militares da OM e mantido um clima organizacional favorvel.'),
  (909,'Tratar os fatores que afetam  a motivao dos militares da OM e mantido um clima organizacional favorvel.'),
  (910,'Identificar os principais processos finalsticos necessrios ao cumprimento da misso da OM.'),
  (911,'Identificar os principais processos de apoio necessrios ao cumprimento da misso da OM.'),
  (912,'Identificar as necessidades do escalo superior OM.'),
  (912,'Identificar as necessidades dos usurios da OM.'),
  (912,'Traduzir em requisitos de qualidade para os processos finalsticos.'),
  (913,'Controlar os processos finalsticos.'),
  (914,'Controlar os processos de apoio.'),
  (915,'Tratar os problemas que so identificados nos processos finalsticos.'),
  (916,'Tratar os problemas que so identificados nos processos de apoio.'),
  (917,'Melhorar os processos finalsticos.'),
  (918,'Apresentar as melhorias implementadas nos ltimos trs anos em cada processo finalstico.'),
  (919,'Melhorar os processos de apoio.'),
  (920,'Apresentar as melhorias implementadas nos ltimos trs anos em cada processo de apoio.'),
  (921,'Identificar as necessidades de insumos dos diversos setores.'),
  (921,'Identificar as necessidades de processos da OM.'),
  (922,'Priorizar os suprimentos a serem adquiridos pela OM.'),
  (923,'Assegurar a qualidade dos bens pela OM.'),
  (923,'Assegurar a qualidade dos produtos pela OM.'),
  (923,'Assegurar a qualidade dos servios pela OM.'),
  (924,'Garantir a exatido entre os bens materiais existentes da OM.'),
  (924,'Garantir a exatido entre os registros contbeis da OM'),
  (925,'Avaliar os fornecedores civis'),
  (926,'Informar fornecedores civis de seus desempenho.'),
  (927,'Minimizar os custos associados  gesto do fornecimento.'),
  (928,'Assegurar em seus processos de suprimento a obteno de um equilbrio de qualidade.'),
  (928,'Assegurar em seus processos de suprimento a obteno de um equilbrio de prazo.'),
  (928,'Assegurar em seus processos de suprimento a obteno de um equilbrio de preo.'),
  (929,'Identificar as necessidades de recursos para a execuo de seus processos.'),
  (930,'Identificar as necessidades de recursos para a execuo de seu plano de gesto.'),
  (931,'Informar os rgos pertinentes sobre suas necessidades de recursos para a execuo de seu plano de gesto.'),
  (932,'Acompanhar a descentralizao de recursos necessrios para a execuo de seu plano de gesto.'),
  (933,'Compatibilizar os recursos recebidos com as necessidades de recursos de seu plano de gesto.'),
  (934,'Apresentar grficos dos resultados dos principais Indicadores de Desempenho (ID) Estratgicos relativos ao Plano de Gesto da OM.'),
  (935,'Apresentar grficos dos resultados dos principais Indicadores de Desempenho (ID) Operacionais relativos aos cidados-usurios.'),
  (936,'Apresentar grficos dos resultados dos principais Indicadores de Desempenho (ID) Operacionais relativos aos sistemas de trabalho.'),
  (936,'Apresentar grficos dos resultados dos principais Indicadores da capacitao.'),
  (936,'Apresentar grficos dos resultados dos principais Indicadores de desenvolvimento.'),
  (936,'Apresentar grficos dos resultados dos principais Indicadores de qualidade de vida.'),
  (937,'Apresentar indicadores de desempenho do plano de gestao.'),
  (938,'Apresentar grficos dos resultados dos principais Indicadores de Desempenho (ID) Operacionais relativos aos produtos adquiridos pela OM.'),
  (938,'Apresentar grficos dos resultados dos principais Indicadores de gesto de relacionamento com os fornecedores.'),
  (939,'Apresentar grficos dos resultados dos principais Indicadores de Desempenho (ID) Operacionais relativos  sociedade.'),
  (940,'Apresentar grficos dos resultados dos principais Indicadores de Desempenho (ID) Operacionais relativos  gesto oramentria da OM.');