SET FOREIGN_KEY_CHECKS=0;

UPDATE versao SET versao_codigo='8.4.37';
UPDATE versao SET ultima_atualizacao_bd='2015-10-29';
UPDATE versao SET ultima_atualizacao_codigo='2015-10-29';
UPDATE versao SET versao_bd=294;

UPDATE config SET config_grupo='legenda' WHERE config_nome='anexo_eb_nome';

UPDATE pratica_regra SET pratica_regra_campo='pratica_indicador_referencial' WHERE pratica_regra_campo='pratica_tem_referencial';

UPDATE pratica_mod_campo SET pratica_mod_campo_nome='pratica_indicador_superior' WHERE pratica_mod_campo_nome='pratica_indicador_ser_superior';
UPDATE pratica_regra_campo SET pratica_regra_campo_nome='pratica_indicador_superior' WHERE pratica_regra_campo_nome='pratica_indicador_ser_superior';
UPDATE pratica_regra SET pratica_regra_campo='pratica_indicador_superior' WHERE pratica_regra_campo='pratica_indicador_ser_superior';

INSERT INTO config_lista (config_nome, config_lista_nome) VALUES
	('genero_anexo_eb_nome','a'),
	('genero_anexo_eb_nome','o');

ALTER TABLE pratica_regra ADD COLUMN pratica_regra_preliminar TINYINT(1) DEFAULT 0;
ALTER TABLE pratica_regra CHANGE pratica_regra_campo pratica_regra_campo VARCHAR(80) DEFAULT NULL;

ALTER TABLE pratica_modelo ADD COLUMN pratica_modelo_tipo VARCHAR(50) DEFAULT 'fnq_2015';
UPDATE pratica_modelo SET pratica_modelo_tipo='fnq_2014' WHERE pratica_modelo_id < 10;

ALTER TABLE pratica_requisito ADD COLUMN pratica_gerencial TINYINT(1) DEFAULT 0;
ALTER TABLE pratica_requisito ADD COLUMN pratica_justificativa_gerencial MEDIUMTEXT;
ALTER TABLE pratica_requisito ADD COLUMN pratica_agil TINYINT(1) DEFAULT 0;
ALTER TABLE pratica_requisito ADD COLUMN pratica_justificativa_agil MEDIUMTEXT;

ALTER TABLE pratica_requisito ADD COLUMN pratica_refinada_implantacao TINYINT(1) DEFAULT 0;
ALTER TABLE pratica_requisito ADD COLUMN pratica_justificativa_refinada_implantacao MEDIUMTEXT;
ALTER TABLE pratica_requisito ADD COLUMN pratica_incoerente TINYINT(1) DEFAULT 0;
ALTER TABLE pratica_requisito ADD COLUMN pratica_justificativa_incoerente MEDIUMTEXT;

ALTER TABLE pratica_indicador_requisito ADD COLUMN pratica_indicador_requisito_favoravel TINYINT(1) DEFAULT 0;
ALTER TABLE pratica_indicador_requisito ADD COLUMN pratica_indicador_requisito_justificativa_favoravel MEDIUMTEXT;
ALTER TABLE pratica_indicador_requisito ADD COLUMN pratica_indicador_requisito_superior TINYINT(1) DEFAULT 0;
ALTER TABLE pratica_indicador_requisito ADD COLUMN pratica_indicador_requisito_justificativa_superior MEDIUMTEXT;

DROP TABLE IF EXISTS pratica_complemento;

CREATE TABLE pratica_complemento (
	pratica_complemento_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pratica_complemento_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_complemento_marcador INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_complemento_ano INTEGER(4) DEFAULT NULL,
  pratica_complemento_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (pratica_complemento_id),
  KEY pratica_complemento_pratica (pratica_complemento_pratica),
  KEY pratica_complemento_marcador (pratica_complemento_marcador),
  CONSTRAINT pratica_complemento_marcador FOREIGN KEY (pratica_complemento_marcador) REFERENCES pratica_marcador (pratica_marcador_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT pratica_complemento_pratica FOREIGN KEY (pratica_complemento_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS pratica_evidencia;

CREATE TABLE pratica_evidencia (
	pratica_evidencia_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pratica_evidencia_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_evidencia_marcador INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_evidencia_ano INTEGER(4) DEFAULT NULL,
  pratica_evidencia_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (pratica_evidencia_id),
  KEY pratica_evidencia_pratica (pratica_evidencia_pratica),
  KEY pratica_evidencia_marcador (pratica_evidencia_marcador),
  CONSTRAINT pratica_evidencia_marcador FOREIGN KEY (pratica_evidencia_marcador) REFERENCES pratica_marcador (pratica_marcador_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT pratica_evidencia_pratica FOREIGN KEY (pratica_evidencia_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS pratica_indicador_complemento;

CREATE TABLE pratica_indicador_complemento (
	pratica_indicador_complemento_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pratica_indicador_complemento_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_complemento_marcador INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_complemento_ano INTEGER(4) DEFAULT NULL,
  pratica_indicador_complemento_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (pratica_indicador_complemento_id),
  KEY pratica_indicador_complemento_indicador (pratica_indicador_complemento_indicador),
  KEY pratica_indicador_complemento_marcador (pratica_indicador_complemento_marcador),
  CONSTRAINT pratica_indicador_complemento_marcador FOREIGN KEY (pratica_indicador_complemento_marcador) REFERENCES pratica_marcador (pratica_marcador_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT pratica_indicador_complemento_indicador FOREIGN KEY (pratica_indicador_complemento_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS pratica_indicador_evidencia;

CREATE TABLE pratica_indicador_evidencia (
	pratica_indicador_evidencia_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pratica_indicador_evidencia_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_evidencia_marcador INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_evidencia_ano INTEGER(4) DEFAULT NULL,
  pratica_indicador_evidencia_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (pratica_indicador_evidencia_id),
  KEY pratica_indicador_evidencia_indicador (pratica_indicador_evidencia_indicador),
  KEY pratica_indicador_evidencia_marcador (pratica_indicador_evidencia_marcador),
  CONSTRAINT pratica_indicador_evidencia_marcador FOREIGN KEY (pratica_indicador_evidencia_marcador) REFERENCES pratica_marcador (pratica_marcador_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT pratica_indicador_evidencia_indicador FOREIGN KEY (pratica_indicador_evidencia_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;	
	
DELETE FROM pratica_modelo WHERE pratica_modelo_id >=10;
DELETE FROM pratica_criterio WHERE pratica_criterio_id >=73;
DELETE FROM pratica_item WHERE pratica_item_id >=191;
DELETE FROM pratica_marcador WHERE pratica_marcador_id >=1041;
DELETE FROM pratica_verbo WHERE pratica_verbo_id >=1642;
DELETE FROM pratica_regra_campo WHERE pratica_regra_campo_id >=90;
DELETE FROM pratica_regra WHERE pratica_regra_id >=961;


INSERT INTO pratica_modelo (pratica_modelo_id, pratica_modelo_nome, pratica_modelo_pontos, pratica_modelo_obs, pratica_modelo_tipo, pratica_modelo_ordem) VALUES 
  (10,'FNQ 2015 250 pontos',250,'<p>Aplicveis s organizaes que esto em estgios iniciais de evoluo do seu sistema de gesto e comeando a medir e perceber melhorias nos seus resultados.</p>','fnq_2015',8),
  (11,'FNQ 2015 500 pontos',500,'<p>Aplicveis s organizaes cujo sistema de gesto est em franca evoluo e j demonstram competitividade e atendimento s expectativas de partes interessadas em vrios resultados.</p>','fnq_2015',9),
  (12,'FNQ 2015 1000 pontos',1000,'<p>aplicveis s organizaes que tm um sistema de gesto bastante evoludo, j demonstram excelncia em alguns resultados, competitividade na maioria e pleno atendimento s expectativas de partes interessadas em quase todos eles.</p>','fnq_2015',10);

UPDATE pratica_mod_campo SET pratica_mod_campo_modelo=9 WHERE pratica_mod_campo_modelo=8;

INSERT INTO pratica_mod_campo (pratica_mod_campo_id, pratica_mod_campo_modelo, pratica_mod_campo_nome) VALUES
  (117,10,'pratica_adequada'),
	(118,10,'pratica_controlada'),
	(119,10,'pratica_proativa'),
	(120,10,'pratica_abrage_pertinentes'),
	(121,10,'pratica_continuada'),
	(122,10,'pratica_refinada'),
	(123,10,'pratica_refinada_implantacao'),
	(124,10,'pratica_coerente'),
	(125,10,'pratica_incoerente'),
	(126,10,'pratica_interrelacionada'),
	(127,10,'pratica_cooperacao'),
	(128,10,'pratica_gerencial'),
	(129,10,'pratica_agil'),
	(130,10,'pratica_indicador_favoravel'),
	(131,10,'pratica_indicador_superior'),
	(132,10,'pratica_indicador_relevante'),
	(133,10,'pratica_indicador_atendimento'),
	(134,10,'pratica_indicador_estrategico'),
	(135,11,'pratica_adequada'),
	(136,11,'pratica_controlada'),
	(137,11,'pratica_proativa'),
	(138,11,'pratica_abrage_pertinentes'),
	(139,11,'pratica_continuada'),
	(140,11,'pratica_refinada'),
	(141,11,'pratica_refinada_implantacao'),
	(142,11,'pratica_coerente'),
	(143,11,'pratica_incoerente'),
	(144,11,'pratica_interrelacionada'),
	(145,11,'pratica_cooperacao'),
	(146,11,'pratica_cooperacao_partes'),
	(147,11,'pratica_arte'),
	(148,11,'pratica_gerencial'),
	(149,11,'pratica_agil'),
	(150,11,'pratica_indicador_favoravel'),
	(151,11,'pratica_indicador_superior'),
	(152,11,'pratica_indicador_relevante'),
	(153,11,'pratica_indicador_atendimento'),
	(154,11,'pratica_indicador_lider'),
	(155,11,'pratica_indicador_estrategico'),
	(156,12,'pratica_adequada'),
	(157,12,'pratica_controlada'),
	(158,12,'pratica_proativa'),
	(159,12,'pratica_abrage_pertinentes'),
	(160,12,'pratica_continuada'),
	(161,12,'pratica_refinada'),
	(162,12,'pratica_coerente'),
	(163,12,'pratica_incoerente'),
	(164,12,'pratica_interrelacionada'),
	(165,12,'pratica_cooperacao'),
	(166,12,'pratica_cooperacao_partes'),
	(167,12,'pratica_arte'),
	(168,12,'pratica_inovacao'),
	(169,12,'pratica_gerencial'),
	(170,12,'pratica_agil'),
	(171,12,'pratica_indicador_favoravel'),
	(172,12,'pratica_indicador_superior'),
	(173,12,'pratica_indicador_relevante'),
	(174,12,'pratica_indicador_atendimento'),
	(175,12,'pratica_indicador_lider'),
	(176,12,'pratica_indicador_excelencia'),
	(177,12,'pratica_indicador_estrategico');



INSERT INTO pratica_criterio (pratica_criterio_id, pratica_criterio_modelo, pratica_criterio_numero, pratica_criterio_nome, pratica_criterio_pontos, pratica_criterio_obs, pratica_criterio_orientacao, pratica_criterio_resultado) VALUES 
 	(73,10,1,'Liderana',33,'<p>Este Critrio aborda processos gerenciais relativos  cultura organizacional e desenvolvimento da gesto, governana, exerccio da liderana e anlise do desempenho da organizao.</p>',NULL,0),
  (74,10,2,'Estratgias e Planos',20,'<p>Este Critrio aborda processos gerenciais relativos  formulao e implementao das estratgias.</p>',NULL,0),
  (75,10,3,'Clientes',20,'<p>Este Critrio aborda processos gerenciais relativos  anlise e desenvolvimento de mercado e ao relacionamento com clientes.</p>',NULL,0),
  (76,10,4,'Sociedade',	12,'<p>Este Critrio aborda processos gerenciais relativos  responsabilidade socioambiental e ao desenvolvimento social.</p>',NULL,0),
  (77,10,5,'Informaes e Conhecimento',	12,'<p>Este Critrio aborda processos gerenciais relativos s informaes da organizao e ao conhecimento organizacional.</p>',NULL,0),
  (78,10,6,'Pessoas',20,'<p>Este Critrio aborda processos gerenciais relativos aos sistemas de trabalho,  capacitao e desenvolvimento e  qualidade de vida.</p>',NULL,0),
  (79,10,7,'Processos',33,'<p>Este Critrio aborda processos gerenciais relativos aos processos da cadeia de valor, processos relativos a fornecedores e processos econmico-financeiros.</p>',NULL,0),
  (80,10,8,'Resultados',100,'<p>Este critrio aborda a apresentao de resultados estratgicos e operacionais relevantes para a organizao, na forma de indicadores que permitam avaliar, no conjunto, a melhoria dos resultados, o nvel de competitividade e o cumprimento de compromissos com requisitos de partes interessadas, nas perspectivas econmico-financeira, socioambiental e relativas a clientes e mercados, a pessoas e aos processos da cadeia de valor.</p>',NULL,1),
  (81,11,1,'Liderana',55,'<p>Este Critrio aborda processos gerenciais relativos  cultura organizacional e desenvolvimento da gesto, governana, exerccio da liderana e anlise do desempenho da organizao.</p>',NULL,0),
  (82,11,2,'Estratgias e Planos ',35,'<p>Este Critrio aborda processos gerenciais relativos  formulao e implementao das estratgias.</p>',NULL,0),
  (83,11,3,'Clientes',40,'<p>Este Critrio aborda processos gerenciais relativos  anlise e desenvolvimento de mercado e ao relacionamento com clientes.</p>',NULL,0),
  (84,11,4,'Sociedade',30,'<p>Este Critrio aborda processos gerenciais relativos  responsabilidade socioambiental e ao desenvolvimento social.</p>',NULL,0),
  (85,11,5,'Informaes e conhecimento',25,'<p>Este Critrio aborda processos gerenciais relativos s informaes da organizao e ao conhecimento organizacional.</p>',NULL,0),
  (86,11,6,'Pessoas',45,'<p>Este Critrio aborda processos gerenciais relativos aos sistemas de trabalho,  capacitao e desenvolvimento e  qualidade de vida.</p>',NULL,0),
  (87,11,7,'Processos',50,'<p>Este Critrio aborda processos gerenciais relativos aos processos da cadeia de valor, processos relativos a fornecedores e processos econmico-financeiros.</p>',NULL,0),
  (88,11,8,'Resultados',220,'<p>Este critrio aborda a apresentao de resultados estratgicos e operacionais relevantes para a organizao, na forma de indicadores que permitam avaliar, no conjunto, a melhoria dos resultados, o nvel de competitividade e o cumprimento de compromissos com requisitos de partes interessadas, nas perspectivas econmico-financeira, socioambiental e relativas a clientes e mercados, a pessoas e aos processos da cadeia de valor.</p>',NULL,1),
  (89,12,1,'Liderana',112,'<p>Este Critrio aborda os processos gerenciais relativos  cultura organizacional e desenvolvimento da gesto, governana, levantamento de interesses das partes interessadas, exerccio da liderana e anlise do desempenho da organizao.</p>',NULL,0),
  (90,12,2,'Estratgias e Planos',60,'<p>Este Critrio aborda os processos gerenciais relativos  formulao e  implementao das estratgias.</p>',NULL,0),
  (91,12,3,'Clientes',60,'<p>Este Critrio aborda os processos gerenciais relativos  anlise e desenvolvimento de mercado e ao relacionamento com clientes.</p>',NULL,0),
  (92,12,4,'Sociedade',60,'<p>Este Critrio aborda os processos gerenciais relativos  responsabilidade socioambiental e ao desenvolvimento social.</p>',NULL,0),
  (93,12,5,'Informaes e Conhecimento',60,'<p>Este Critrio aborda os processos gerenciais relativos s informaes da organizao e ao conhecimento organizacional.</p>',NULL,0),
  (94,12,6,'Pessoas',90,'<p>Este Critrio aborda os processos gerenciais relativos aos sistemas de trabalho,  capacitao e desenvolvimento e  qualidade de vida.</p>',NULL,0),
  (95,12,7,'Processos',108,'<p>Este Critrio aborda os processos gerenciais relativos aos processos da cadeia de valor, processos relativos a fornecedores e processos econmico-financeiros.</p>',NULL,0),
  (96,12,8,'Resultados',450,'<p>Este critrio aborda a apresentao de resultados estratgicos e operacionais relevantes para a organizao, na forma de indicadores que permitam avaliar, no conjunto, a melhoria dos resultados, o nvel de competitividade e o cumprimento de compromissos com requisitos de partes interessadas, nas perspectivas econmico-financeira, socioambiental e relativas a clientes e mercados, a pessoas e aos processos da cadeia de valor.</p>',NULL,1);


INSERT INTO pratica_item (pratica_item_id, pratica_item_criterio, pratica_item_numero, pratica_item_nome, pratica_item_pontos, pratica_item_obs, pratica_item_orientacao, pratica_item_oculto) VALUES 
  (191,73,1,'Liderana',33,NULL,NULL,1),
  (192,74,1,'Estratgias e Planos',20,NULL,NULL,1),
  (193,75,1,'Clientes',20,NULL,NULL,1),
  (194,76,1,'Sociedade',12,NULL,NULL,1),
  (195,77,1,'Informaes e Conhecimento',12,NULL,NULL,1),
  (196,78,1,'Pessoas',20,NULL,NULL,1),
  (197,79,1,'Processos',33,NULL,NULL,1),
  (198,80,1,'Resultado',100,NULL,NULL,1),
  (199,81,1,'Cultura organizacional e desenvolvimento da gesto',15,'<p>Este item aborda processos gerenciais utilizados para estabelecer valores e princpios organizacionais e padres de conduta, identificar elementos da cultura organizacional, estabelecer padres, controlar e melhorar processos gerenciais, para obter e utilizar as melhores prticas de gesto.</p>',NULL,0),
  (200,81,2,'Governana',	10,'<p>Este item aborda processos gerenciais referentes a gerenciar riscos aos quais a organizao est sujeita, tomar, comunicar e implementar decises e prestar contas, pela direo, das aes e resultados alcanados.</p>',NULL,0),
  (201,81,3,'Levantamento de interesses e exerccio da liderana',15,'<p>Este item aborda processos gerenciais utilizados para conhecer as necessidades e expectativas das partes interessadas, bem como os processos gerenciais da direo empregados para exerccio da sua liderana e interao com as partes interessadas.</p>',NULL,0),
  (202,81,4,'Anlise do desempenho da organizao',15,'<p>Este item aborda processos gerenciais utilizados para obter referenciais comparativos, analisar o desempenho operacional e estratgico da organizao, em termos de alcance de metas, competitividade e de atendimento de requisitos de partes interessadas e para acompanhar a implementao das decises decorrentes da anlise.</p>',NULL,0),
  (203,82,1,'Formulao das estratgias',15,'<p>Este item aborda processos gerenciais utilizados para analisar o macroambiente de atuao, e ambiente interno, identificar os ativos intangveis e definir as estratgias da organizao.</p>',NULL,0),
  (204,82,2,'Implementao das estratgias',20,'<p>Este item aborda processos gerenciais utilizados para estabelecer e desdobrar metas e planos de ao pelos processos e acompanhar a implementao dos planos de ao.</p>',NULL,0),
  (205,83,1,'Anlise e desenvolvimento de mercado',20,'<p>Este item aborda os processos gerenciais utilizados para segmentar o mercado, entender as necessidades e expectativas dos clientes-alvo, divulgar os produtos e as marcas e para avaliar a imagem perante os clientes e mercados.</p>','<ol>\t<li>O mercado abordado neste Item refere-se aos mercados que so alvos da colocao de produtos da organizao.</li>\t<li>Explicitar, quando aplicvel, como as prticas de gesto variam em funo das peculiaridades dos diferentes grupos de clientes e segmentos de mercado.</li>\t<li>Os resultados dos principais indicadores de desempenho so requeridos em 8.3.</li>\t<li>Os parceiros com caractersticas de clientes devem ser abordados neste Item, onde aplicvel.</li></ol>',0),
  (206,83,2,'Relacionamento com clientes',20,'<p>Este item aborda os processos gerenciais utilizados para permitir que o cliente tenha acesso  organizao, avaliar a satisfao e insatisfao dos clientes e utilizar as informaes para melhoria.</p>','<ol>\t<li>Explicitar como as prticas de gesto variam em funo das peculiaridades dos diferentes grupos de clientes e segmentos de mercados e dos parceiros, quando aplicvel.</li>\t<li>Os resultados dos principais indicadores de desempenho, bem como os reconhecimentos externos relativos a este Item, so requeridos em 8.3.</li></ol>',0),
  (207,84,1,'Responsabilidade socioambiental',15,'<p>Este item aborda os processos gerenciais utilizados para identificar e atender as leis, regulamentos e normas, tratar os impactos dos produtos, processos e instalaes, propiciar a acessibilidade e promover aes voluntrias, visando ao desenvolvimento sustentvel.</p>','<ol>\t<li>Os resultados dos principais indicadores de desempenho, bem como os reconhecimentos externos relativos a este Item, so requeridos em 8.2.</li></ol>',0),
  (208,84,2,'Desenvolvimento social',15,'<p>Este item aborda os processos gerenciais utilizados para identificar e utilizar as necessidades e expectativas, para promover o desenvolvimento da sociedade, avaliar a satisfao da sociedade e zelar pela imagem da organizao.</p>','<ol>\t<li>Neste Item, a sociedade inclui as comunidades existentes no entorno das instalaes da organizao, quando a presena das instalaes no local for relevante.</li>\t<li>Os resultados dos principais indicadores de desempenho so requeridos em 8.2.</li></ol>',0),
  (209,85,1,'Informaes da organizao',15,'<p>Este item aborda os processos gerenciais utilizados para se identificar necessidades de informao, desenvolver e implantar os sistemas de informao e manter a segurana das informaes.</p>',NULL,0),
  (210,85,2,'Conhecimento organizacional',	10,'<p>Este item aborda a implementao de processos gerenciais utilizados para desenvolver, difundir e utilizar os conhecimentos mais importantes para organizao realizar a misso.</p>',NULL,0),
  (211,86,1,'Sistemas de trabalho',15,'<p>Este item aborda os processos gerenciais utilizados para definir a organizao do trabalho, identificar competncias, selecionar e integrar pessoas, avaliar o desempenho e reconhecer as pessoas buscando o alcance de metas.</p>','<ol>\t<li>Explicitar, quando aplicvel, as prticas de gesto de pessoas que variam em funo dos diferentes grupos de pessoas da fora de trabalho, tais como gestores, tcnicos, administrativos e operacionais, horistas e mensalistas, contratados em tempo integral ou parcial, temporrios, autnomos e contratados de terceiros que trabalham sob coordenao direta da organizao.</li>\t<li>Os resultados dos principais indicadores de desempenho so requeridos em 8.4.</li></ol>',0),
  (212,86,2,'Capacitao e desenvolvimento',15,'<p>Este item aborda os processos gerenciais utilizados para identificar as necessidades de capacitao e desenvolvimento das pessoas, conceber os programas de capacitao e desenvolvimento e promover o desenvolvimento comportamental e da cidadania.</p>','<ol>\t<li>Explicitar, quando aplicvel, as prticas de gesto de pessoas que variam em funo dos diferentes grupos de pessoas da fora de trabalho, tais como gestores, tcnicos, administrativos e operacionais, horistas e mensalistas, contratados em tempo integral ou parcial, temporrios, autnomos e contratados de terceiros que trabalham sob coordenao direta da organizao.</li>\t<li>Os resultados dos principais indicadores de desempenho so requeridos em 8.4.</li></ol>',0),
  (213,86,3,'Qualidade de vida',15,'<p>Este item aborda os processos gerenciais utilizados para identificar os perigos e tratar os riscos relacionados  sade e segurana, identificar e utilizar as necessidades e expectativas e avaliar o bem-estar e a satisfao das pessoas.</p>','<ol>\t<li>Explicitar, quando aplicvel, as prticas de gesto de pessoas que variam em funo dos diferentes grupos de pessoas da fora de trabalho, tais como gestores, tcnicos, administrativos e operacionais, horistas e mensalistas, contratados em tempo integral ou parcial, temporrios, autnomos e contratados de terceiros que trabalham sob coordenao direta da organizao.</li>\t<li>Os resultados dos principais indicadores de desempenho so requeridos em 8.4.</li></ol>',0),
  (214,87,1,'Processos da cadeia de valor',20,'<p>Este Item aborda os processos gerenciais utilizados para identificar requisitos de produtos e processos, desenvolver novos produtos e para projetar, controlar, analisar e melhorar produtos e processos.</p>',NULL,0),
  (215,87,2,'Processos relativos a fornecedores',	10,'<p>Este item aborda os processos gerenciais utilizados para qualificar, selecionar e avaliar os fornecedores e para compromet-los com a excelncia.</p>',NULL,0),
  (216,87,3,'Processos econmico-financeiros',20,'<p>Este item aborda os processos gerenciais utilizados para monitorar os impactos na sustentabilidade econmico-financeira da organizao, assegurar os recursos para apoiar as operaes e as estratgias e para elaborar e controlar o oramento.</p>',NULL,0),
  (217,88,1,'Econmico-financeiros',50,'<p>Este Item aborda os resultados econmico-financeiros da organizao.</p>',NULL,0),
  (218,88,2,'Sociais e ambientais',35,'<p>Este Item aborda os resultados sociais e ambientais da organizao.</p>',NULL,0),
  (219,88,3,'Relativos a clientes e mercados',50,'<p>Este Item aborda os resultados relativos aos clientes e mercados alvos da organizao.</p>',NULL,0),
  (220,88,4,'Relativos s pessoas',35,'<p>Este Item aborda os resultados relativos s pessoas da fora de trabalho.</p>',NULL,0),
  (221,88,5,'Relativos aos processos',50,'<p>Este Item aborda os resultados relativos aos produtos, aos processos da cadeia de valor, aos fornecedores e aos processos de gesto transversais.</p>',NULL,0),
  (222,89,1,'Cultura organizacional e desenvolvimento da gesto',28,'<p>Este item aborda os processos gerenciais utilizados para estabelecer valores e princpios organizacionais e padres de conduta, identificar e desenvolver elementos da cultura organizacional, manter a comunicao com todos os pblicos, estabelecer padres, controlar e melhorar processos gerenciais, e para obter e utilizar as melhores prticas de gesto.</p>',NULL,0),
  (223,89,2,'Governana',28,'<p>Este item aborda os processos gerenciais utilizados para estabelecer diretrizes, assegurar a conformidade com requisitos e diretrizes, gerenciar riscos aos quais a organizao est sujeita, tomar decises e comunicar fatos importantes, e prestar contas pela direo das aes e resultados alcanados.</p>',NULL,0),
  (224,89,3,'Levantamento de interesses e exerccio da liderana',28,'<p>Este Item aborda os processos gerenciais utilizados para identificar partes interessadas e levantar seus interesses; identificar necessidades e expectativas dos controladores e demais partes interessadas, traduzindo-as em requisitos; identificar redes de atuao, bem como os processos gerenciais da direo empregados para exerccio da sua liderana e interao com as partes interessadas.</p>',NULL,0),
  (225,89,4,'Anlise do desempenho da organizao',28,'<p>Este Item aborda os processos gerenciais utilizados para selecionar indicadores e informaes, visando  anlise do desempenho, identificar e obter referenciais comparativos, analisar o desempenho operacional e estratgico da organizao, em termos de alcance de metas, competitividade e de atendimento de requisitos de partes interessadas, bem como acompanhar a implementao das decises decorrentes da anlise.</p>',NULL,0),
  (226,90,1,'Formulao das estratgias',30,'<p>Este Item aborda os processos gerenciais utilizados para analisar o macroambiente, os mercados, o setor de atuao, os ativos intangveis e o ambiente interno, e para definir as estratgias e avaliar o modelo de negcio.</p>','<ol>\t<li>A expresso &ldquo;formulao das estratgias&rdquo; refere-se  abordagem (formal ou informal) da organizao a fim de se preparar para o futuro. O processo pode utilizar vrios tipos diferentes de previses, projees, opes, cenrios ou outros mtodos, para se criar uma perspectiva do futuro com o propsito de orientar a tomada de deciso e a alocao dos recursos.</li></ol>',0),
  (227,90,2,'Implementao das estratgias',30,'<p>Este Item aborda os processos gerenciais utilizados para definir indicadores, estabelecer e desdobrar metas e planos de ao pelos processos, alocar recursos e acompanhar a implementao dos planos de ao.</p>',NULL,0),
  (228,91,1,'Anlise e desenvolvimento de mercado',30,'<p>Este Item aborda os processos gerenciais utilizados para analisar o mercado, entender as necessidades e expectativas dos clientes, desenvolver e proteger as marcas, tornar os produtos e as marcas conhecidos, bem como para avaliar a imagem perante os clientes e mercados.</p>','<ol>\t<li>O mercado abordado neste Item refere-se aos mercados que so alvos da colocao de produtos da organizao.</li>\t<li>Explicitar, quando aplicvel, como as prticas de gesto variam em funo das peculiaridades dos diferentes grupos de clientes e segmentos de mercado.</li>\t<li>Os resultados dos principais indicadores de desempenho, bem como os reconhecimentos externos relativos a este Item, so requeridos em 8.3.</li>\t<li>Os parceiros com caractersticas de clientes devem ser abordados neste Item, onde aplicvel.</li></ol>',0),
  (229,91,2,'Relacionamento com clientes',30,'<p>Este Item aborda os processos gerenciais utilizados para permitir que o cliente tenha acesso  organizao, avaliar a satisfao, insatisfao e fidelidade dos clientes, e utilizar as informaes para melhoria e desenvolvimento de parcerias.</p>','<ol>\t<li>Explicitar como as prticas de gesto variam em funo das peculiaridades dos diferentes grupos de clientes e segmentos de mercados e dos parceiros, quando aplicvel.</li>\t<li>Os resultados dos principais indicadores de desempenho, bem como os reconhecimentos externos relativos a este Item, so requeridos em 8.3.</li></ol>',0),
  (230,92,1,'Responsabilidade socioambiental',30,'<p>Este Item aborda os processos gerenciais utilizados para traduzir a legislao em requisitos de desempenho, tratar os impactos dos produtos, processos e instalaes, prevenir acidentes na sociedade e no meio ambiente, propiciar a acessibilidade e promover aes voluntrias visando ao desenvolvimento sustentvel. PROCESSOS gERENCIAIS complement</p>','<ol>\t<li>Os resultados dos principais indicadores de desempenho, bem como os reconhecimentos externos relativos a este Item, so requeridos em 8.2.</li></ol>',0),
  (231,92,2,'Desenvolvimento social',30,'<p>Este Item aborda os processos gerenciais utilizados para identificar as necessidades e expectativas da sociedade a fim de promover o desenvolvimento social, bem como avaliar sua satisfao e utilizar as informaes obtidas para a melhoria das aes sociais, avaliao e zelo pela imagem da organizao perante a sociedade.</p>','<ol>\t<li>Neste Item, a sociedade inclui as comunidades existentes no entorno das instalaes da organizao, quando a presena das instalaes no local for relevante.</li>\t<li>Os resultados dos principais indicadores de desempenho, bem como os reconhecimentos externos relativos a este Item, so requeridos em 8.2.</li></ol>',0),
  (232,93,1,'Informaes da organizao',30,'<p>Este Item aborda os processos gerenciais utilizados para identificar necessidades de informao e de seu tratamento, definir, desenvolver, implantar e melhorar os sistemas de informao, integrar as informaes da organizao com as partes interessadas externas e disponibiliz-las, mantida a segurana das informaes.</p>',NULL,0),
  (233,93,2,'Conhecimento da organizaco',30,'<p>Este Item aborda a implementao de processos gerenciais utilizados para identificar, desenvolver, reter, proteger, difundir e utilizar os conhecimentos necessrios para realizar as operaes e implementar as estratgias da organizao.</p>',NULL,0),
  (234,94,1,'Sistemas de trabalho',30,'<p>Este Item aborda os processos gerenciais utilizados para definir a organizao do trabalho, identificar competncias, selecionar e integrar pessoas, avaliar e planejar a melhoria do desempenho, bem como para remunerar e reconhecer as pessoas, buscando o alto desempenho.</p>','<ol>\t<li>Explicitar, quando aplicvel, as prticas de gesto de pessoas que variam em funo dos diferentes grupos de pessoas da fora de trabalho, tais como gestores, tcnicos, administrativos e operacionais, horistas e mensalistas, contratados em tempo integral ou parcial, temporrios, autnomos e contratados de terceiros que trabalham sob coordenao direta da organizao.</li>\t<li>Os resultados dos principais indicadores de desempenho, bem como os reconhecimentos externos relativos a este Item, so requeridos em 8.4.</li></ol>',0),
  (235,94,2,'Capacitao e desenvolvimento',30,'<p>Este Item aborda os processos gerenciais utilizados para identificar as necessidades de capacitao e desenvolvimento das pessoas, conceber e avaliar a eficcia dos programas de capacitao e desenvolvimento, identificar e preparar novos lderes e sucessores, e desenvolver as pessoas como indivduos, cidados e profissionais.</p>','<ol>\t<li>Explicitar como as prticas de gesto de pessoas levam em conta as diferentes categorias, tais como os contratados em tempo integral ou parcial, os temporrios, os autnomos e os contratados de terceiros que trabalham sob coordenao direta da organizao, procurando esclarecer, quando necessrio, as diferenas existentes.</li>\t<li>Os resultados dos principais indicadores de desempenho, bem como os reconhecimentos externos relativos a este Item, so requeridos em 8.4.</li></ol>',0),
  (236,94,3,'Qualidade de vida',30,'<p>Este Item aborda os processos gerenciais utilizados para tratar os riscos relacionados  sade e segurana, identificar as necessidades e expectativas, avaliar o bem-estar, satisfao e comprometimento das pessoas, promover a qualidade de vida e manter um clima organizacional favorvel  criatividade,  inovao e  excelncia no desempenho.</p>','<ol>\t<li>Explicitar como as prticas de gesto de pessoas levam em conta os diferentes grupos, tais como os contratados em tempo integral ou parcial, os temporrios, os autnomos e os contratados de terceiros que trabalham sob coordenao direta da organizao, esclarecendo, quando necessrio, as diferenas existentes.</li>\t<li>Os resultados dos principais indicadores de desempenho, bem como os reconhecimentos externos relativos a este Item, so requeridos em 8.4.</li></ol>',0),
  (237,95,1,'Processos da cadeia de valor',36,'<p>Este Item aborda os processos gerenciais utilizados para identificar requisitos de processos e produtos, projetar, analisar e melhorar produtos e processos, considerando as inovaes, novas tecnologias e as caractersticas dos produtos e processos de concorrentes ou de outras organizaes de referncia.</p>','<ol>\t<li>Os processos da cadeia de valor so requeridos em Perfil P1B(2). Em razo das particularidades da gesto dos processos relativos aos fornecedores e dos processos econmico-financeiros, esses so tratados em destaque nos itens 7.2 e 7.3, respectivamente.</li>\t<li>Os produtos citados nas questes deste Item so aqueles gerados, entregues e oferecidos com suporte para os clientes, incluindo servios associados a essas atividades.</li>\t<li>Explicitar, quando aplicvel, como as prticas variam em funo das peculiaridades ou importncia dos processos da cadeia de valor.</li>\t<li>Os resultados dos principais indicadores de desempenho, bem como os reconhecimentos externos relativos a este Item, so requeridos em 8.5.</li></ol>',0),
  (238,95,2,'Processos relativos a fornecedores',36,'<p>Este Item aborda os processos gerenciais utilizados para desenvolver a cadeia de suprimentos, conhecer, qualificar, selecionar, monitorar e avaliar os fornecedores, bem como para compromet-los com a excelncia.</p>','<ol>\t<li>Explicitar como as prticas de gesto variam em funo das peculiaridades dos diferentes tipos de fornecedores.</li>\t<li>Os parceiros mencionados nesse Item representam uma categoria especial de fornecedores, com os quais se estabelecem alianas estratgicas e cujo desempenho  crtico para o negcio. Podem ser includos nesta categoria os distribuidores e revendedores. Os fornecedores dessa categoria so requeridos no Perfil P1D(6).</li>\t<li>Os requisitos relativos a fornecedores deste Item aplicam-se tambm queles considerados parceiros.</li>\t<li>Os resultados dos principais indicadores de desempenho, bem como os reconhecimentos externos relativos a este Item, so requeridos em 8.5.</li></ol>',0),
  (239,95,3,'Processos econmico-financeiros',36,'<p>Este Item aborda os processos gerenciais utilizados para monitorar os impactos na sustentabilidade econmico-financeira da organizao, assegurar os recursos para apoiar as operaes e as estratgias, quantificar, tratar e monitorar os riscos mais significativos que podem afetar as demonstraes financeiras, bem como para elaborar e controlar o oramento.</p>','<ol>\t<li>Os resultados dos principais indicadores de desempenho bem como os reconhecimentos externos relativos a este Item so requeridos em 8.1.</li></ol>',0),
  (240,96,1,'Econmico-financeiros',100,'<p>Este Item aborda os resultados econmico-financeiros da organizao.</p>',NULL,0),
  (241,96,2,'Sociais e ambientais',75,'<p>Este Item aborda os resultados sociais e ambientais da organizao.</p>',NULL,0),
  (242,96,3,'Relativos a clientes e mercados',100,'<p>Este Item aborda os resultados relativos aos clientes e mercados-alvo da organizao.</p>',NULL,0),
  (243,96,4,'Relativos s pessoas',75,'<p>Este Item aborda os resultados relativos s pessoas da fora de trabalho.</p>',NULL,0),
  (244,96,5,'Relativos aos processos',100,'<p>Este Item aborda os resultados relativos aos produtos, aos processos da cadeia de valor, aos fornecedores e aos demais processos de gesto transversais.</p>',NULL,0);



INSERT INTO pratica_marcador (pratica_marcador_id, pratica_marcador_item, pratica_marcador_letra, pratica_marcador_texto, pratica_marcador_extra, pratica_marcador_evidencia, pratica_marcador_orientacao) VALUES	
	(1041,191,'a','<p>Como so comunicados os valores e princpios organizacionais, padres de conduta, objetivos e metas, interna e externamente?</p>','<ul><li>Destacar as formas de assegurar um relacionamento tico no ambiente em que opera.</li></ul>','<ul><li>Apresentar os valores e os princpios organizacionais.</li><li>Citar os cdigos de conduta emitidos.</li></ul>','<ol><li>A comunicao dos valores, princpios organizacionais, padres de conduta, estratgias, objetivos e metas, tem a finalidade de desenvolver um sentimento coletivo de pertencer a um grupo de pessoas que compartilham e perseguem os mesmos ideais, potencializando a contribuio de cada um.</li><li>A apresentao dos valores e princpios organizacionais inclui, por exemplo, as declaraes de misso, viso, credos e outras categorias de princpios porventura existentes.</li><li>Os padres de conduta contidos nos cdigos devem abranger os principais processos e relacionamentos em que h risco de ocorrncia de assdio no tico, corrupo e fraudes.</li><li>Os interlocutores do ambiente em que a organizao opera, que esto envolvidos nas questes ticas, abrangem partes interessadas, redes importantes, concorrentes e outros interlocutores com os quais a organizao precisa se relacionar.</li></ol>'),
	(1042,191,'b','<p>Como so estabelecidos os principais padres para os processos gerenciais e como  verificado o seu cumprimento?</p>',NULL,NULL,'<ol><li>O estabelecimento dos padres para os processos gerenciais visa a assegurar a uniformidade na sua execuo, por meio da instituio e padronizao das regras, que orientam o funcionamento das prticas de gesto da organizao. A verificao do cumprimento dos principais padres para os processos gerenciais visa a estimular, por meio do controle, a aplicao desses padres pelos gestores e, consequentemente, promover a qualidade da gesto.</li><li>Os padres para os processos gerenciais, tambm chamados de padres gerenciais, determinam o funcionamento das prticas de gesto adotadas pela organizao, para atender os processos gerenciais requeridos. Tais padres podem ser consolidados em manuais, procedimentos, diretrizes ou qualquer outro acervo que possibilite a reteno e a evoluo do conhecimento sobre a gesto da organizao.</li></ol>'),
	(1043,191,'c','<p>Como os processos gerenciais so aperfeioados?</p>','<ul><li>Destacar a forma de obteno e utilizao de informaes sobre boas prticas de gesto de organizaes de referncia.</li></ul>',NULL,'<ol><li>A melhoria dos processos gerenciais tem o objetivo de torn-los mais eficientes e eficazes, incorporando padres aprimorados, de forma integrada.</li><li>O aperfeioamento dos processos gerenciais e a busca e incorporao das boas prticas de gesto fazem parte do ciclo de aprendizado que integra o PDCL, preconizado pelo Diagrama de Gesto (Captulo 1).</li><li>As organizaes de referncia incluem aquelas de dentro e de fora do ramo ou setor de atuao da organizao.</li><li>Melhorias introduzidas no sistema de gesto da organizao, em consequncia da investigao de boas prticas de outras organizaes, tambm devem ser citadas, sempre que possvel, ao longo da descrio das prticas de gesto, relativas aos processos gerenciais, solicitados nos critrios de 1 a 7, a fim de se evidenciar a utilizao das boas prticas de gesto obtidas.</li></ol>'),
	(1044,191,'d','<p>Como as principais decises so tomadas e acompanhadas?</p>','<ul><li>Destacar a forma de tratamento de riscos aos quais a organizao est sujeita.</li></ul>',NULL,'<ol><li>A tomada de deciso tem a finalidade de compartilhar informaes nos diversos nveis da estrutura de liderana, sobre as dificuldades encontradas e as oportunidades identificadas no dia a dia da organizao, e de deliberar sobre a melhor forma de encaminhar as aes, corretivas ou proativas. O acompanhamento das decises visa a assegurar que as aes decididas sejam colocadas em prtica e concludas.</li><li>A tomada de deciso abrange os mtodos coordenados para deliberar e decidir direes a seguir e aes a realizar, desde o nvel de governana at o nvel operacional, em alinhamento s estratgias e objetivos da organizao.</li><li>Os riscos aos quais a organizao est sujeita so aqueles que ameaam a consecuo dos objetivos estratgicos e do negcio  luz das incertezas do mercado e do setor de atuao da organizao, do ambiente macroeconmico e dos prprios processos da organizao.</li></ol>'),
	(1045,191,'e','<p>Como a direo presta contas das suas aes aos controladores da organizao?</p>',NULL,NULL,'<ol><li>O controle sobre os atos da direo visa a verificar se esses esto ocorrendo de acordo com limites de delegao, pr-estabelecidos em estatutos, contratos de gesto, definies de nveis de alada ou documentos afins.</li><li>A prestao de contas das aes da direo para os controladores tem a finalidade de alinhar essas aes s expectativas desses controladores, dando a possibilidade, inclusive do realinhamento estratgico da organizao, quando necessrio.</li><li>A composio nominal da direo da organizao, incluindo as principais lideranas,  requerida no Perfil P5(1) - Estrutura organizacional.</li></ol>'),
	(1046,191,'f','<p>Como a direo exerce a liderana e interage com as partes interessadas relevantes?</p>','<ul><li>Destacar a forma de exercer a liderana junto  fora de trabalho.</li><li>Destacar a forma de internalizar as necessidades e expectativas das partes interessadas.</li></ul>','<ul><li>Citar os objetivos das principais interaes realizadas com as partes interessadas</li></ul>','<ol><li>A interao da direo com as partes interessadas relevantes tem por objetivo conhecer e compreender, sem intermedirios, seus principais anseios, identificar o valor percebido na organizao e em seus produtos e inform-las sobre as polticas e metas institucionais, buscando oportunidades, o engajamento, validando estratgias e gerando credibilidade em relao  organizao.</li><li>A interao com partes interessadas pode incluir aquelas realizadas por intermdio da estrutura de liderana adotada.</li><li>As principais necessidades e expectativas das partes interessadas so apresentadas no Perfil P1C(1).</li></ol>'),
	(1047,191,'g','<p>Como a direo analisa o desempenho estratgico e operacional da organizao?</p>','<ul><li>Destacar as formas de utilizao de metas, de referenciais comparativos pertinentes para avaliao da competitividade e de requisitos de partes interessadas para avaliao de compromissos.</li></ul>',NULL,'<ol><li>A anlise do desempenho da organizao tem a finalidade de estimular o comprometimento dos diversos nveis da estrutura de liderana com o alcance de metas, por meio do controle de resultados, incluindo a avaliao do nvel de competitividade da organizao no mercado ou setor de atuao e a verificao do atendimento s necessidades das partes interessadas.</li><li>Na apresentao de resultados no Critrio 8, que expressem os principais requisitos de partes interessadas, coerentes com as suas necessidades e expectativas mencionadas ao longo do Perfil, deve-se demonstrar que esses requisitos esto sendo atendidos.</li></ol>'),
	(1048,192,'a','<p>Como so analisadas as foras impulsoras e restritivas do ambiente externo?</p>','<ul><li>Destacar de que forma as redes importantes para a organizao so consideradas na anlise.</li></ul>','<ul><li>Citar as principais informaes utilizadas e as respectivas fontes.</li></ul>','<ol><li>A anlise das foras impulsoras e restritivas do ambiente externo visa  definio de prioridades quanto s estratgias para seu aproveitando ou contorno.</li><li>As foras impulsoras e restritivas do ambiente externo abrangem aquelas provenientes do macroambiente, das caractersticas do setor de atuao e dos mercados de atuao.</li></ol>'),
	(1049,192,'b','<p>Como so analisadas as foras impulsoras e restritivas do ambiente interno?</p>',NULL,NULL,'<ol><li>A anlise das foras impulsoras e restritivas do ambiente interno visa  definio de prioridades quanto s estratgias para seu aproveitando ou contorno.</li><li>As foras impulsoras e restritivas do ambiente interno abrangem aquelas relacionadas  fora de trabalho, infraestrutura, questes econmico-financeiras, processos, tecnologias, capacidades, informaes e outros. Entre as foras impulsoras do ambiente interno mais importantes, encontram-se os ativos intangveis.</li></ol>'),
	(1050,192,'c','<p>Como so definidas as estratgias a serem adotadas pela organizao?</p>',NULL,'<ul><li>Apresentar as principais estratgias e objetivos da organizao.</li></ul>','<ol><li>A definio das estratgias tem como finalidade estabelecer os objetivos e as iniciativas, necessrias para cumprir a misso e alcanar a viso de futuro da organizao, aproveitando as foras impulsoras e contornando as foras restritivas, provenientes do ambiente externo e do ambiente interno.</li></ol>'),
	(1051,192,'d','<p>Como so estabelecidas as metas e definidos os respectivos planos de ao para o xito das estratgias?</p>','<ul><li>Destacar a maneira de definir os indicadores para a avaliao do xito das estratgias.</li><li>Destacar a forma de alocar recursos para implementao dos planos de ao.</li><li>Destacar a maneira utilizada pela direo para acompanhar a implementao dos planos de ao.</li></ul>','<ul><li>Apresentar os principais indicadores, suas metas e principais aes planejadas ou projetos, relativos  implementao das estratgias.</li></ul>','<ol><li>O estabelecimento de metas para o xito das estratgias tem como objetivo definir nveis de desempenho esperados para os indicadores estratgicos, com base em fatos, tais como: projees de histricos, previses mercadolgicas, nveis de resultados alcanados por outras organizaes do mercado ou setor de atuao, picos de resultados j alcanados anteriormente e desafios incrementais.</li><li>A definio dos planos de ao tem a finalidade de selecionar projetos ou aes que possibilitam alcanar as estratgicas definidas e os resultados definidos pelas metas.</li><li>A alocao de recursos visa a assegurar a implementao dos planos de ao que sustentam as estratgias. Esses recursos podem abranger os financeiros, humanos, materiais, tecnolgicos, de capacidade produtiva ou de gesto, informao, conhecimento e outros.</li><li>Os planos de ao so tambm conhecidos como projetos estratgicos.</li><li>Os resultados dos indicadores citados nesta questo devem ser apresentados no Critrio 8, exceto os relativos aos indicadores em incio de uso, que no sejam comparveis e que no expressem requisitos de partes interessadas.</li></ol>'),
	(1052,193,'a','<p>Como so definidos os clientes-alvo nos segmentos de atuao?</p>','<ul><li>Destacar os critrios adotados para definio de clientes-alvo.</li></ul>',NULL,'<ol><li>A definio dos clientes-alvo tem por objetivo estabelecer os grupos de clientes com caractersticas similares, possibilitando a configurao de servios de marketing e vendas adequados para cada grupo e viabilizando a escala.</li></ol>'),
	(1053,193,'b','<p>Como as necessidades e expectativas dos clientes-alvo, nos segmentos de atuao, so identificadas e utilizadas para a definio e melhoria dos processos da organizao?</p>','<ul><li>Destacar a forma de traduzir as necessidades e expectativas dos clientes e do mercado em requisitos de desempenho.</li></ul>',NULL,'<ol><li>A identificao das necessidades e expectativas dos clientes-alvo tem por finalidade obter as informaes necessrias a serem utilizadas na configurao de produtos e servios associados, que incorporem as caractersticas mais relevantes para os clientes-alvo.</li><li>As principais necessidades e expectativas dos clientes so requeridas no Perfil P1C(1).</li></ol>'),
	(1054,193,'c','<p>Como os produtos so divulgados aos clientes e ao mercado?</p>','<ul><li>Destacar a forma de relacionamento com o mercado.</li></ul>',NULL,'<ol><li>A divulgao dos produtos aos clientes e ao mercado visa a assegurar que eles tenham pleno conhecimento da organizao, assim como criar credibilidade, confiana e imagem positiva.</li></ol>'),
	(1055,193,'d','<p>Como so tratadas as solicitaes,<br />reclamaes ou sugestes, formais ou<br />informais, dos clientes?</p>','<ul><li>Destacar a forma utilizada para comunicar aos clientes o resultado da anlise dessas manifestaes e as respectivas aes implementadas.</li></ul>','<ul><li>Citar os principais mecanismos ou canais de interao com os clientes.</li></ul>','<ol><li>O tratamento adequado das manifestaes dos clientes tem por finalidade assegurar que elas sejam pronta e eficazmente atendidas ou solucionadas.</li><li>O monitoramento das reclamaes  importante para avaliar a insatisfao dos clientes.</li><li>Mencionar, quando aplicvel, tambm os canais de relacionamento estabelecidos via parceiros, como distribuidores, revendedores, representantes e afins, para receber solicitaes, reclamaes e sugestes.</li></ol>'),
	(1056,193,'e','<p>Como  avaliada a satisfao dos clientes?</p>','<ul><li>Destacar a maneira de utilizar as informaes obtidas dos clientes.</li></ul>',NULL,'<ol><li>A avaliao da satisfao dos clientes tem por objetivo mensurar sua percepo sobre a organizao e seus produtos e identificar oportunidades para melhoria, aumentando a satisfao.</li></ol>'),
	(1057,194,'a','<p>Como as leis, regulamentos e normas ou cdigos de adeso voluntria, aplicveis  organizao so identificados e atendidos?</p>','<ul><li>Destacar de que maneira so tratadas as pendncias ou eventuais sanes relativas a requisitos associados a leis e regulamentos aplicveis  organizao. No caso de inexistncia, declarar formalmente a situao.</li></ul>',NULL,'<ol><li>A traduo de leis, regulamentos e normas ou cdigos de adeso voluntria, aplicveis  organizao tem a finalidade de estabelecer parmetros objetivos de monitoramento do atendimento.</li><li>As leis, regulamentos e normas ou cdigos de adeso voluntria, aplicveis  organizao, representam necessidades e expectativas da sociedade em geral, em relao  organizao.</li><li>A organizao pode atender, traduzindo a condio de legalidade em requisitos de desempenho, por exemplo, de conformidade.</li></ol>'),
	(1058,194,'b','<p>Como a organizao trata impactos sociais e ambientais adversos, decorrentes de seus produtos, processos e instalaes?</p>',NULL,'<ul><li>Apresentar as principais aes para eliminar, minimizar ou compensar os impactos sociais e ambientais negativos identificados.</li></ul>','<ol><li>O objetivo do tratamento de impactos sociais e ambientais  inventariar, priorizar e viabilizar o tratamento preventivo de tudo aquilo que a organizao pode causar de negativo, direta ou indiretamente,  sociedade e aos ecossistemas, em decorrncia de seus produtos, de seus processos e de suas instalaes.</li><li>Os aspectos e impactos adversos so aqueles sobre os quais a organizao tem influncia e devem ser considerados ao longo do ciclo de vida do produto, desde o projeto at a disposio final ou reutilizao.</li><li>Entre os impactos sociais, incluem-se aqueles relativos  segurana, sade e qualidade de vida dos usurios e da populao em geral, que possam advir dos produtos, processos e instalaes da organizao.</li><li>Os principais impactos sociais e ambientais adversos, existentes e potenciais, bem como os passivos ambientais, se existirem, so requeridos no Perfil P1D(5).</li></ol>'),
	(1059,194,'c','<p>Como a organizao promove, de forma voluntria, aes para o desenvolvimento sustentvel?</p>','<ul><li>Destacar a forma de desenvolver parcerias ou de atuar em rede e envolver a fora de trabalho, na implementao ou apoio s suas aes, relativas ao desenvolvimento sustentvel.</li></ul>','<ul><li>Citar as principais aes implementadas.</li></ul>','<ol><li>A promoo de aes para o desenvolvimento sustentvel visa a engajar a organizao e sua rede na causa da sustentabilidade do planeta, inclusive com o envolvimento de parceiros e de sua fora de trabalho. O envolvimento da fora de trabalho nesse aspecto potencializa o engajamento na causa da organizao.</li><li>As aes, diretas ou indiretas, para o desenvolvimento sustentvel podem abranger a minimizao de consumo de recursos renovveis, de conservao de recursos no renovveis, reciclagem ou reutilizao de materiais ou mesmo a contribuio para a soluo dos grandes temas mundiais. Tais temas incluem o aquecimento global, a reduo da camada de oznio, as mudanas climticas, a destruio de florestas naturais, o respeito aos direitos humanos, o trabalho infantil ou degradante, o combate  lavagem de dinheiro e trfico de pessoas, a pobreza extrema, a escassez de gua potvel e temas afins.</li></ol>'),
	(1060,194,'d','<p>Como a organizao direciona esforos para o desenvolvimento da sociedade?</p>','<ul><li>Destacar a forma de desenvolver parcerias ou de atuar em rede e de envolver a fora de trabalho na implementao de projetos sociais.</li></ul>','<ul><li>Citar os principais projetos implementados ou apoiados.</li></ul>','<ol><li>O direcionamento de esforos para o desenvolvimento sustentvel tem o objetivo de selecionar e conduzir ou participar de projetos ou programas compatveis com as prioridades da sociedade.</li><li>Os esforos para fortalecimento da sociedade incluem a execuo ou apoio a projetos voltados para o desenvolvimento nacional, regional, local ou setorial, emfuno do porte e tipo de atividade da organizao.</li><li>As ofertas de vagas para estagirios podem ser consideradas aes de desenvolvimento social.</li><li>As parcerias desenvolvidas so requeridas no Perfil P1D(6).</li></ol>'),
	(1061,195,'a','<p>Como so identificadas as necessidades de informaes para operar e gerenciar a organizao?</p>',NULL,NULL,'<ol><li>A identificao de necessidades de informaes para operar e gerenciar a organizao tem o objetivo de projetar sistemas de informao, informatizados ou no, compatveis com as estratgias e as necessidades dos usurios.</li><li>As necessidades de informaes para gerenciar a organizao abrangem indicadores de desempenho, situao de planos, projetos e oramentos, relatrios gerenciais, resultados de pesquisas e outras variveis importantes do ambiente, necessrias para apoiar o processo decisrio em todos os nveis e reas da organizao.</li></ol>'),
	(1062,195,'b','<p>Como so disponibilizados os principais sistemas de informao para apoiar a operao e o gerenciamento da organizao?</p>',NULL,'<ul><li>Citar os principais sistemas de informao em uso e sua finalidade.</li></ul>','<ol><li>A disponibilizao de sistemas de informao tem a finalidade de aumentar a produtividade e a qualidade no trato da informao, por meio de ferramentas e tecnologias.</li><li>Os sistemas de informao podem incluir sistemas no informatizados, visando a atender s necessidades de informao e de seu tratamento, como, por exemplo, sistemas de gesto  vista, sistemas de controle visuais, sistema de manuais, sistema de pronturios, sistemas de documentos para operao manual.</li></ol>'),
	(1063,195,'c','<p>Como a segurana das informaes  mantida?</p>','<ul><li>Destacar os mtodos de segurana de informao, utilizados para buscar assegurar a atualizao, confidencialidade, integridade das informaes e a disponibilidade das informaes.</li></ul>',NULL,'<ol><li>A segurana das informaes  tratada quanto  atualizao, com o objetivo de garantir que os usurios estejam utilizando informaes atuais para tomar decises e realizar seu trabalho.</li><li>A segurana das informaes busca assegurar a confidencialidade, com a finalidade de restringir o acesso e a distribuio das informaes aos usurios e pblicos autorizados a receb-las, protegendo o acervo de informaes da organizao contra o uso indevido. A confidencialidade das informaes pressupe que somente pessoas autorizadas tenham acesso a elas.</li><li>A segurana das informaes busca assegurar a integridade, visando a salvaguardar a exatido e completeza da informao recebida, armazenada e distribuda e dos mtodos de processamento.</li><li>A segurana das informaes busca assegurar a disponibilidade, visando a garantir a continuidade da infraestrutura de utilizao das informaes em situaes de emergncia.</li></ol>'),
	(1064,195,'d','<p>Como os conhecimentos mais importantes da organizao so difundidos?</p>',NULL,'<ul><li>Informar os conhecimentos mais importantes da organizao.</li></ul>','<ol><li>A difuso dos conhecimentos mais importantes da organizao tem a finalidade de ret-los e multiplic-los.</li><li>Os conhecimentos mais importantes podem abranger tecnologias, competncias da fora de trabalho, polticas, procedimentos, bases de dados, documentos e outros.</li><li>Os conhecimentos devem ser difundidos  fora de trabalho e demais partes interessadas, que tenham a necessidade explcita de utiliz-los.</li></ol>'),
	(1065,196,'a','<p>Como a organizao do trabalho  definida?</p>','<ul><li>Destacar a participao da fora de trabalho na melhoria dos processos da organizao na busca de inovaes.</li><li>Destacar a forma utilizada para definir o quadro de pessoal e suas responsabilidades.</li></ul>',NULL,'<ol><li>A definio da organizao do trabalho tem a finalidade de orientar a estrutura organizacional e os respectivos cargos, para cada vez melhor sustentar os processos, promovendo a sinergia do trabalho em equipe e a produtividade do sistema de trabalho.</li></ol>'),
	(1066,196,'b','<p>Como as pessoas so selecionadas, interna e externamente?</p>','<ul><li>Destacar as formas de preparao das pessoas recmcontratadas para o exerccio de suas funes e de integrao  cultura organizacional.</li></ul>',NULL,'<ol><li>A seleo de pessoas, interna e externamente, tem a finalidade de preencher as vagas da organizao com profissionais compatveis s necessidades de desempenho atual e futuro. O recrutamento interno tem por objetivo maximizar as oportunidades de desenvolvimento atual. A integrao tem por finalidade acelerar a adaptao dos novos membros em uma nova cultura.</li></ol>'),
	(1067,196,'c','<p>Como o desempenho das pessoas, incluindo lderes,  avaliado?</p>','<ul><li>Destacar a forma de definir as necessidades de melhoria com as pessoas.</li></ul>',NULL,'<ol><li>A avaliao tem a finalidade de informar as pessoas avaliadas sobre seu desempenho, debatendo formas de melhor-lo.</li><li>O desempenho pode abranger qualquer fator considerado importante para o exerccio das funes como, por exemplo, cumprimento de obrigaes, alcance de metas, comportamentos esperados, qualidade do trabalho e outros.</li></ol>'),
	(1068,196,'d','<p>Como as pessoas so reconhecidas e incentivadas?</p>',NULL,NULL,'<ol><li>O reconhecimento tem por objetivo promover a mobilizao das pessoas pela motivao, identificando e reforando comportamentos de alto desempenho ou realizaes extraordinrias, sem pr-condies. O reforo de comportamentos pode incluir premiaes, recompensas ou oportunidades especiais, formais ou informais, individuais ou em grupo.</li><li>O incentivo tem a finalidade de promover a mobilizao pelo desafio, condicionando seu recebimento ao alcance de metas de alto desempenho.</li><li>Os incentivos podem abranger alcance de metas, aquisio de conhecimentos, habilidades e competncias ou outros fatores indutores do alto desempenho.</li></ol>'),
	(1069,196,'e','<p>Como as pessoas so capacitadas e desenvolvidas?</p>','<ul><li>Destacar a forma de participao dos lderes e das prprias pessoas a serem capacitadas e desenvolvidas, na identificao das necessidades.</li><li>Destacar a forma de preparao de novos lderes e de desenvolvimento de lderes.</li></ul>','<ul><li>Citar os principais programas, incluindo aqueles relacionados ao desenvolvimento de lderes e  formao da cultura da excelncia.</li></ul>','<ol><li>A capacitao tem a finalidade de assegurar que as demandas, decorrentes das funes das pessoas e das estratgias da organizao, sejam incorporadas aos programas de treinamento das pessoas.</li><li>O desenvolvimento tem o objetivo de preparar as pessoas para os desafios da melhoria contnua, visando a criar a cultura de aprendizado, inovao e comprometimento com os resultados da organizao.</li></ol>'),
	(1070,196,'f','<p>Como os riscos relacionados  sade ocupacional e  segurana das pessoas so tratados?</p>','<p>Destacar a forma de identificar os perigos relacionados  sade ocupacional e  segurana das pessoas.</p>',NULL,'<ol><li>Os riscos relacionados  sade ocupacional e segurana das pessoas so tratados com o objetivo de prevenir os fatores que possam ameaar a integridade fsica ou psicolgica dos integrantes da fora de trabalho, em decorrncia de suas atividades.</li><li>A identificao de perigos tem por finalidade assegurar que os riscos existentes estejam sendo tratados.</li><li>A sade ocupacional abrange aspectos relativos  ergonomia.</li></ol>'),
	(1071,196,'g','<p>Como o bem-estar e a satisfao das pessoas so avaliados e desenvolvidos?</p>','<p>Destacar de que forma so tratados, com a participao de lderes, os fatores identificados na avaliao que afetam o bem-estar e a satisfao das pessoas</p>',NULL,'<ol><li>A avaliao do bem-estar e a satisfao das pessoas tem a finalidade de averiguar as condies de trabalho, no apenas em relao  sade e segurana, mas tambm quanto ao conforto nos postos de trabalho.</li><li>O desenvolvimento do bem-estar tem a finalidade de promover um ambiente de trabalho agradvel e participativo, com consequente motivao e entusiasmo das pessoas.</li><li>Os fatores que afetam o bem-estar so aqueles relativos  promoo de um ambiente de trabalho agradvel, tranquilo e equilibrado, no qual as pessoas se sintam bem.</li><li>Os fatores que afetam a satisfao so aqueles relativos ao atendimento de necessidades das pessoas e que determinam sua preferncia em trabalhar para a organizao.</li></ol>'),
	(1072,197,'a','<p>Como so definidos os requisitos aplicveis aos produtos e aos processos da cadeia de valor?</p>','<ul><li>Destacar a forma de organizar os processos da cadeia de valor.</li></ul>','<ul><li>Apresentar os principais requisitos relativos aos produtos e processos da cadeia de valor a serem atendidos e os respectivos indicadores de desempenho.</li></ul>','<ol><li>A definio dos requisitos aplicveis aos produtos e processos da cadeia de valor tem a finalidade de identificar os esforos necessrios para o atendimento das necessidades e expectativas das partes interessadas.</li><li>A organizao dos processos da cadeia de valor visa ao agrupamento de atividades em conjuntos, para facilitar a gesto.</li><li>Os requisitos dos produtos e processos devem levar em considerao os requisitos dos clientes, da sociedade e de outras partes interessadas aplicveis.</li></ol>'),
	(1073,197,'b','<p>Como  assegurado o atendimento dos requisitos aplicveis aos processos da cadeia de valor?</p>','<ul><li>Destacar os mtodos de padronizao e controle.</li><li>Destacar a forma de tratamento de eventuais no conformidades identificadas e de implementao das aes corretivas.</li></ul>',NULL,'<ol><li>O controle dos processos tem por finalidade assegurar que os requisitos de processo e produto sejam atendidos e, consequentemente, sejam atendidas as necessidades e expectativas de clientes e de outras partes interessadas. O controle  realizado por meio dos indicadores de desempenho, cujos resultados so comparados com padres (metas) previamente estabelecidos.</li></ol>'),
	(1074,197,'c','<p>Como a organizao analisa e melhora os produtos e os processos da cadeia de valor?</p>','<ul><li>Destacar as formas de investigao de caractersticas de produtos e de processos da cadeia de valor em outras organizaes para buscar melhorias.</li><li>Destacar a forma de avaliar o potencial de ideias criativas se converterem em inovaes.</li></ul>','<ul><li>Citar as principais melhorias ou inovaes recentes implementadas em produtos e em processos da cadeia de valor em decorrncia dessas comparaes.</li></ul>','<ol><li>A anlise e melhoria dos produtos e processos da cadeia de valor tem a finalidade de melhor atender s necessidades e expectativas das partes interessadas.</li><li>As outras organizaes, para investigao de caractersticas de seus produtos e processos, incluem aquelas de dentro e de fora do ramo ou setor de atuao da organizao.</li><li>Os produtos e processos, que so objeto da investigao, referem-se queles com finalidade similar ao da organizao.</li><li>A avaliao do potencial de ideias criativas pode incluir a realizao de experimentos, por meio de pilotos, prottipos, modelagem e simulaes.</li></ol>'),
	(1075,197,'d','<p>Como os fornecedores so selecionados e avaliados?</p>','<ul><li>Destacar a forma de qualificao dos fornecedores.</li><li>Destacar a maneira de monitorar o desempenho dos fornecedores.</li><li>Destacar as formas de envolvimento e comprometimento de fornecedores que atuam diretamente nos processos da cadeia de valor da organizao com os princpios organizacionais, incluindo os relativos  sade e  segurana.</li></ul>','<ul><li>Apresentar os principais indicadores de desempenho relativos aos fornecedores.</li></ul>','<ol><li>A seleo de fornecedores tem por objetivo definir a melhor opo de fornecimento, ponderando os fatores relevantes para a organizao.</li><li>A avaliao de fornecedores tem por finalidade retroaliment-los com as informaes sobre seu desempenho, para incentivar melhorias.</li><li>A qualificao de fornecedores tem a finalidade de verificar se os candidatos possuem as qualidades necessrias para se tornar fornecedores.</li><li>O monitoramento do desempenho dos fornecedores visa  verificao do preenchimento das condies de fornecimento contratadas.</li></ol>'),
	(1076,197,'e','<p>Como  elaborado e controlado o oramento e mantido o fluxo financeiro equilibrado?</p>',NULL,'<ul><li>A presentar indicadores de desempenho relativos aos processos econmicofinanceiros.</li></ul>','<ol><li>A elaborao e o controle do oramento tm a finalidade de viabilizar o planejamento, responsabilizao, controle e anlise integrada e segmentada das receitas, despesas e investimentos, proporcionando elementos para projeo de resultados financeiros da organizao.</li><li>A manuteno do fluxo financeiro equilibrado tem por objetivo assegurar a disponibilidade de recursos para operacionalizao de suas atividades sem sobressaltos.</li></ol>'),
	(1077,198,'a','<p>Apresentar os resultados dos principais indicadores relativos  gesto econmico-financeira.</p>',NULL,'<ul><li>Para cada indicador apresentado, informar se ele :<ul><li>(E) estratgico,</li><li>(O) operacional; ou</li><li>(E,O) ambos.</li></ul></li><li>Mostrar o sentido de favorabilidade de cada srie histrica:<ul><li>quanto maior, melhor ou;</li><li>quanto menor, melhor ou;</li><li>estabilizao em nvel aceitvel, i.e., nvel suficientemente competitivo ou cumprindo compromisso como requisito de parte interessada, ou ambos.</li></ul></li><li>Incluir os referenciais comparativos pertinentes, e a quem se referem, relativos ao ltimo exerccio ou ciclo de avaliao, para indicadores que permitam comparaes, principalmente relativos a clientes, mercado-alvo e produtos, a fim de avaliar a competitividade.</li><li>Incluir os nveis de desempenho ou melhorias esperadas que expressem os principais requisitos de partes interessadas, e a que partes se referem, relativas ao ltimo exerccio ou ciclo de avaliao, para indicadores que so utilizados para avaliar o cumprimento desses requisitos.</li><li>Incluir comentrios, se necessrio.</li></ul>','<ol><li>Explicar, resumidamente, o propsito de indicadores cujos nomes no sejam autoexplicativos.</li><li>No caso de unidade autnoma, em indicadores cujo levantamento de resultados  realizado somente no nvel corporativo, demonstrar a contribuio da unidade para o resultado alcanado.</li><li>As sries histricas devem abranger trs perodos ou ciclos de avaliao.</li><li>A competitividade do resultado em um tema pode ser avaliada por meio de indicadores com referenciais comparativos diferentes daqueles utilizados para avaliar a melhoria do mesmo tema.</li><li>Podem ser apresentados indicadores, entre os relevantes, sem referencial comparativo pertinente, quando o resultado no for comparvel; e sem requisito de parte interessada, quando no refletir necessidades e expectativas de partes interessadas, se eles forem relevantes para avaliar a melhoria.</li></ol>'),
	(1078,198,'b','<p>Apresentar os resultados dos principais indicadores relativos  sociedade e meio ambiente.</p>',NULL,'<ul><li>Para cada indicador apresentado, informar se ele :<ul><li>(E) estratgico,</li><li>(O) operacional; ou</li><li>(E,O) ambos.</li></ul></li><li>Mostrar o sentido de favorabilidade de cada srie histrica:<ul><li>quanto maior, melhor ou;</li><li>quanto menor, melhor ou;</li><li>estabilizao em nvel aceitvel, i.e., nvel suficientemente competitivo ou cumprindo compromisso como requisito de parte interessada, ou ambos.</li></ul></li><li>Incluir os referenciais comparativos pertinentes, e a quem se referem, relativos ao ltimo exerccio ou ciclo de avaliao, para indicadores que permitam comparaes, principalmente relativos a clientes, mercado-alvo e produtos, a fim de avaliar a competitividade.</li><li>Incluir os nveis de desempenho ou melhorias esperadas que expressem os principais requisitos de partes interessadas, e a que partes se referem, relativas ao ltimo exerccio ou ciclo de avaliao, para indicadores que so utilizados para avaliar o cumprimento desses requisitos.</li><li>Incluir comentrios, se necessrio.</li></ul>','<ol><li>Explicar, resumidamente, o propsito de indicadores cujos nomes no sejam autoexplicativos.</li><li>No caso de unidade autnoma, em indicadores cujo levantamento de resultados  realizado somente no nvel corporativo, demonstrar a contribuio da unidade para o resultado alcanado.</li><li>As sries histricas devem abranger trs perodos ou ciclos de avaliao.</li><li>A competitividade do resultado em um tema pode ser avaliada por meio de indicadores com referenciais comparativos diferentes daqueles utilizados para avaliar a melhoria do mesmo tema.</li><li>Podem ser apresentados indicadores, entre os relevantes, sem referencial comparativo pertinente, quando o resultado no for comparvel; e sem requisito de parte interessada, quando no refletir necessidades e expectativas de partes interessadas, se eles forem relevantes para avaliar a melhoria.</li></ol>'),
	(1079,198,'c','<p>Apresentar os resultados dos principais indicadores relativos a clientes e aos mercados.</p>','<ul><li>Estratificar por grupos de clientes, segmentos de mercado ou tipos de produtos, conforme aplicvel.</li></ul>','<ul><li>Para cada indicador apresentado, informar se ele :<ul><li>(E) estratgico,</li><li>(O) operacional; ou</li><li>(E,O) ambos.</li></ul></li><li>Mostrar o sentido de favorabilidade de cada srie histrica:<ul><li>quanto maior, melhor ou;</li><li>quanto menor, melhor ou;</li><li>estabilizao em nvel aceitvel, i.e., nvel suficientemente competitivo ou cumprindo compromisso como requisito de parte interessada, ou ambos.</li></ul></li><li>Incluir os referenciais comparativos pertinentes, e a quem se referem, relativos ao ltimo exerccio ou ciclo de avaliao, para indicadores que permitam comparaes, principalmente relativos a clientes, mercado-alvo e produtos, a fim de avaliar a competitividade.</li><li>Incluir os nveis de desempenho ou melhorias esperadas que expressem os principais requisitos de partes interessadas, e a que partes se referem, relativas ao ltimo exerccio ou ciclo de avaliao, para indicadores que so utilizados para avaliar o cumprimento desses requisitos.</li><li>Incluir comentrios, se necessrio.</li></ul>','<ol><li>Explicar, resumidamente, o propsito de indicadores cujos nomes no sejam autoexplicativos.</li><li>No caso de unidade autnoma, em indicadores cujo levantamento de resultados  realizado somente no nvel corporativo, demonstrar a contribuio da unidade para o resultado alcanado.</li><li>As sries histricas devem abranger trs perodos ou ciclos de avaliao.</li><li>A competitividade do resultado em um tema pode ser avaliada por meio de indicadores com referenciais comparativos diferentes daqueles utilizados para avaliar a melhoria do mesmo tema.</li><li>Podem ser apresentados indicadores, entre os relevantes, sem referencial comparativo pertinente, quando o resultado no for comparvel; e sem requisito de parte interessada, quando no refletir necessidades e expectativas de partes interessadas, se eles forem relevantes para avaliar a melhoria.</li></ol>'),
	(1080,198,'d','<p>Apresentar os resultados dos principais indicadores relativos s pessoas.</p>',NULL,'<ul><li>Para cada indicador apresentado, informar se ele :<ul><li>(E) estratgico,</li><li>(O) operacional; ou</li><li>(E,O) ambos.</li></ul></li><li>Mostrar o sentido de favorabilidade de cada srie histrica:<ul><li>quanto maior, melhor ou;</li><li>quanto menor, melhor ou;</li><li>estabilizao em nvel aceitvel, i.e., nvel suficientemente competitivo ou cumprindo compromisso como requisito de parte interessada, ou ambos.</li></ul></li><li>Incluir os referenciais comparativos pertinentes, e a quem se referem, relativos ao ltimo exerccio ou ciclo de avaliao, para indicadores que permitam comparaes, principalmente relativos a clientes, mercado-alvo e produtos, a fim de avaliar a competitividade.</li><li>Incluir os nveis de desempenho ou melhorias esperadas que expressem os principais requisitos de partes interessadas, e a que partes se referem, relativas ao ltimo exerccio ou ciclo de avaliao, para indicadores que so utilizados para avaliar o cumprimento desses requisitos.</li><li>Incluir comentrios, se necessrio.</li></ul>','<ol><li>Explicar, resumidamente, o propsito de indicadores cujos nomes no sejam autoexplicativos.</li><li>No caso de unidade autnoma, em indicadores cujo levantamento de resultados  realizado somente no nvel corporativo, demonstrar a contribuio da unidade para o resultado alcanado.</li><li>As sries histricas devem abranger trs perodos ou ciclos de avaliao.</li><li>A competitividade do resultado em um tema pode ser avaliada por meio de indicadores com referenciais comparativos diferentes daqueles utilizados para avaliar a melhoria do mesmo tema.</li><li>Podem ser apresentados indicadores, entre os relevantes, sem referencial comparativo pertinente, quando o resultado no for comparvel; e sem requisito de parte interessada, quando no refletir necessidades e expectativas de partes interessadas, se eles forem relevantes para avaliar a melhoria.</li></ol>'),
	(1081,198,'e','<p>Apresentar os resultados dos principais indicadores relativos aos produtos,  gesto dos processos da cadeia de valor e  gesto de fornecedores.</p>',NULL,'<ul><li>Para cada indicador apresentado, informar se ele :<ul><li>(E) estratgico,</li><li>(O) operacional; ou</li><li>(E,O) ambos.</li></ul></li><li>Mostrar o sentido de favorabilidade de cada srie histrica:<ul><li>quanto maior, melhor ou;</li><li>quanto menor, melhor ou;</li><li>estabilizao em nvel aceitvel, i.e., nvel suficientemente competitivo ou cumprindo compromisso como requisito de parte interessada, ou ambos.</li></ul></li><li>Incluir os referenciais comparativos pertinentes, e a quem se referem, relativos ao ltimo exerccio ou ciclo de avaliao, para indicadores que permitam comparaes, principalmente relativos a clientes, mercado-alvo e produtos, a fim de avaliar a competitividade.</li><li>Incluir os nveis de desempenho ou melhorias esperadas que expressem os principais requisitos de partes interessadas, e a que partes se referem, relativas ao ltimo exerccio ou ciclo de avaliao, para indicadores que so utilizados para avaliar o cumprimento desses requisitos.</li><li>Incluir comentrios, se necessrio.</li></ul>','<ol><li>Explicar, resumidamente, o propsito de indicadores cujos nomes no sejam autoexplicativos.</li><li>No caso de unidade autnoma, em indicadores cujo levantamento de resultados  realizado somente no nvel corporativo, demonstrar a contribuio da unidade para o resultado alcanado.</li><li>As sries histricas devem abranger trs perodos ou ciclos de avaliao.</li><li>A competitividade do resultado em um tema pode ser avaliada por meio de indicadores com referenciais comparativos diferentes daqueles utilizados para avaliar a melhoria do mesmo tema.</li><li>Podem ser apresentados indicadores, entre os relevantes, sem referencial comparativo pertinente, quando o resultado no for comparvel; e sem requisito de parte interessada, quando no refletir necessidades e expectativas de partes interessadas, se eles forem relevantes para avaliar a melhoria.</li><li>Os resultados de processos da cadeia de valor aqui solicitados so aqueles das operaes principais do negcio e de apoio, bem como eventuais indicadores de processos de gesto transversais, como de desenvolvimento da gesto, governana, atuao em rede, anlise do desempenho, planejamento, informaes, conhecimento, e similares, porventura utilizados pela organizao e ainda no solicitados anteriormente nesse Critrio.</li></ol>'),
	(1082,199,'a','<p>Como so estabelecidos os valores e princpios organizacionais?</p>',NULL,'<ul><li>Apresentar os valores e os princpios organizacionais.</li></ul>','<ol><li>Os valores e princpios abrangem aqueles necessrios  promoo da excelncia,  criao de valor para todas as partes interessadas e ao desenvolvimento sustentvel.</li><li>A apresentao dos valores e princpios organizacionais inclui, por exemplo, as declaraes de misso, viso, credos e outras categorias de princpios porventura existentes.</li></ol>'),
	(1083,199,'b','<p>Como os principais elementos da cultura organizacional so identificados?</p>',NULL,NULL,'<ol><li>Os elementos da cultura podem abranger comportamentos, pressupostos, preconceitos, smbolos utilizados, formas de organizao do trabalho, rituais, cdigos ou formas de comunicao verbal ou escrita, linguagem empregada e outros, atuantes na organizao.</li><li>A identificao dos principais elementos da cultura organizacional  importante para orientar a comunicao institucional na induo de mudanas culturais importantes.</li></ol>'),
	(1084,199,'c','<p>Como a organizao busca assegurar um relacionamento tico no ambiente em que opera?</p>',NULL,'<ul><li>Apresentar os canais de comunicao disponveis para receber reclamaes, denncias e sugestes relativas  conduta, envolvendo a organizao.</li><li>Citar os cdigos de conduta emitidos.</li></ul>','<ol><li>Os padres de conduta, constantes no cdigo de conduta, devem abranger os principais processos e relacionamentos em que h risco de ocorrncia de assdio no tico, corrupo e fraudes.</li><li>Os interlocutores do ambiente em que a organizao opera, que esto envolvidos nas questes ticas, abrangem partes interessadas, redes importantes, concorrentes e outros interlocutores com os quais a organizao precisa se relacionar.</li></ol>'),
	(1085,199,'d','<p>Como so comunicados os valores e princpios organizacionais, padres de conduta, estratgias, objetivos e metas  fora de trabalho e a outros pblicos?</p>',NULL,NULL,'<ol><li>Os outros pblicos mencionados nessa questo abrangem partes interessadas e redes importantes, podendo ser ou no aplicvel, conforme o tema comunicado.</li></ol>'),
	(1086,199,'e','<p>Como so estabelecidos os principais padres para os processos gerenciais e como  verificado o seu cumprimento?</p>',NULL,NULL,'<ol><li>Os padres para os processos gerenciais, tambm chamados de padres gerenciais, determinam o funcionamento das prticas de gesto adotadas pela organizao, para atender aos processos gerenciais requeridos.</li><li>A verificao do cumprimento dos padres gerenciais faz parte do ciclo de controle, que integra o PDCL preconizado pelo Diagrama da Gesto (Captulo 1).</li></ol>'),
	(1087,199,'f','<p>Como os processos gerenciais so aperfeioados?</p>','<ul><li>Destacar como so obtidas e utilizadas as informaes sobre boas prticas de gesto de organizaes de referncia.</li></ul>',NULL,'<ol><li>O aperfeioamento dos processos gerenciais faz parte do ciclo de aprendizado que integra o PDCL preconizado pelo Diagrama da Gesto (Captulo 1).</li></ol>'),
	(1088,200,'a','<p>Como so identificados e tratados os riscos aos quais a organizao est sujeita?</p>',NULL,'<ul><li>Apresentar os riscos aos quais a organizao est sujeita.</li></ul>','<ol><li>Os riscos aos quais a organizao est sujeita so aqueles que ameaam a consecuo dos objetivos estratgicos e do negcio,  luz das incertezas do mercado e do setor de atuao da organizao, do ambiente macroeconmico e dos prprios processos da organizao.</li><li>A identificao de riscos deve considerar tambm aqueles que possam vir a afetar as demonstraes financeiras da organizao e aqueles associados a dificuldades criadas por organizaes, pessoas ou redes, cujos interesses se opem aos da organizao, como, por exemplo: concorrncia desleal ou hostil; organizaes antiticas ou irresponsveis; crime organizado; fornecedores ou clientes com m-f e outras.</li><li>A forma de tratamento pode incluir a aceitao da exposio atual.</li></ol>'),
	(1089,200,'b','<p>Como as principais decises so tomadas, comunicadas aos envolvidos e implementadas?</p>',NULL,NULL,'<ol><li>A tomada de deciso abrange os mtodos coordenados para deliberar e decidir direes a seguir e aes a realizar, desde o nvel de governana at o nvel operacional, em alinhamento s estratgias e objetivos da organizao.</li><li>A implementao das decises inclui as formas de organizar as aes necessrias e de seu acompanhamento.</li></ol>'),
	(1090,200,'c','<p>Como a direo presta contas das suas aes e resultados alcanados aos controladores da organizao?</p>',NULL,NULL,'<ol><li>A composio nominal da direo da organizao, incluindo as principais lideranas,  requerida no Perfil P5(1) - Estrutura organizacional.</li><li>O controle sobre os atos da direo visa a verificar se esses esto ocorrendo de acordo com limites de delegao, pr-estabelecidos em estatutos, contratos de gesto, definies de nveis de alada ou documentos afins.</li></ol>'),
	(1091,201,'a','<p>Como so conhecidas as necessidades e expectativas das partes interessadas relevantes?</p>','<ul><li>Destacar a forma de internalizar as necessidades e expectativas das partes interessadas.</li></ul>',NULL,'<ol><li>O conhecimento das necessidades e expectativas das partes interessadas relevantes  fundamental para a avaliao dos Resultados Organizacionais, pois auxiliar na identificao dos requisitos das partes interessadas.</li><li>As partes interessadas relevantes so aquelas cujas necessidades e expectativas ou interesses devam ser identificadas e compreendidas plenamente.</li><li>O levantamento das necessidades e expectativas das partes interessadas relevantes visa a maximizar a sua satisfao de forma equilibrada e a sustentabilidade da organizao.</li><li>As principais partes interessadas e respectivas necessidades e expectativas so requeridas no Perfil P1C(1).</li></ol>'),
	(1092,201,'b','<p>Como so desenvolvidas redes de organizaes ou de pessoas que possam influenciar no xito das estratgias?</p>',NULL,NULL,'<ol><li>Exemplos de redes que envolvem a organizao incluem as redes associativas, de produtores, de clientes, de usurios, de fornecedores, de parceiros, de distribuidores, de consumidores, de apoiadores, sociais e outras, formais ou informais.</li><li>Exemplos de redes que atuam dentro da organizao incluem as redes de especialistas, de facilitadores, de comunicadores, de usurios, de apoio mtuo, de reas afins e outras, formais e informais.</li></ol>'),
	(1093,201,'c','<p>Como a direo exerce a liderana e interage com as partes interessadas e redes mais importantes?</p>',NULL,'<ul><li>Citar os objetivos das principais interaes realizadas com as partes interessadas e redes mais importantes.</li></ul>','<ol><li>O exerccio da liderana e interao com as partes interessadas e redes mais importantes visa a engajar pessoas e organizaes, promovendo o alinhamento de interesses e buscando apoio para o xito das estratgias e o alcance sustentado dos objetivos da organizao.</li><li>O exerccio da liderana e interao com partes interessadas e redes mais importantes pode incluir aquelas realizadas por intermdio da estrutura de liderana adotada.</li></ol>'),
	(1094,202,'a','<p>Como so obtidos os referenciais comparativos necessrios para analisar a competitividade da organizao?</p>','<ul><li>Destacar os critrios utilizados para definir quais so os resultados mais importantes a serem comparados.</li><li>Destacar os critrios utilizados para definir a pertinncia de referenciais comparativos utilizados pela organizao.</li></ul>',NULL,'<ol><li>Os referenciais comparativos so aqueles necessrios para apoiar a anlise da competitividade da organizao, tanto no mbito operacional quanto no estratgico.</li><li>A obteno dos referenciais comparativos, no mercado ou setor de atuao, pode abranger a regio de atuao da organizao ou, quando se desejar conhecer os nveis dos melhores da classe, as regies onde o setor  mais desenvolvido ou o mundo inteiro.</li><li>As fontes dos referenciais comparativos, utilizados na demonstrao de resultados no Critrio 8, devem ser coerentes com os critrios de definio de sua pertinncia aqui informados. Na demonstrao de um resultado, no Critrio 8, devem ser informados, para identificar o referencial comparativo utilizado, por exemplo, a caracterstica ou tipo de mdia, do setor ou mercado, relevante para avaliar a competitividade; nome dos concorrentes; nome da organizao de referncia; nome de ndice ou taxa referencial ou outros.</li></ol>'),
	(1095,202,'b','<p>Como a direo analisa o desempenho estratgico e operacional da organizao?</p>','<ul><li>Destacar a maneira de selecionar os indicadores e demais informaes que sero utilizadas na anlise do desempenho estratgico e operacional da organizao.</li><li>Destacar as formas de utilizao de metas, de referenciais comparativos, pertinentes para avaliao da competitividade, e de requisitos de partes interessadas para avaliao de compromissos.</li></ul>',NULL,'<ol><li>Na apresentao de resultados no Critrio 8, que expressem os principais requisitos de partes interessadas, coerentes com as suas necessidades e expectativas mencionadas ao longo do Perfil, deve-se demonstrar que esses requisitos estejam sendo atendidos.</li></ol>'),
	(1096,202,'c','<p>Como  acompanhada a implementao das decises decorrentes da anlise do desempenho da organizao?</p>',NULL,NULL,NULL),
	(1097,203,'a','<p>Como so analisadas as foras impulsoras e restritivas do ambiente externo?</p>','<ul><li>Destacar de que forma as redes importantes para a organizao so consideradas na anlise.</li></ul>','<ul><li>Citar as principais informaes utilizadas e as respectivas fontes.</li></ul>','<ol><li>As foras impulsoras e restritivas do ambiente externo abrangem aquelas provenientes do macroambiente, das caractersticas do setor de atuao e dos mercados de atuao.</li><li>As foras provenientes do macroambiente abrangem aspectos conjunturais das regies de atuao, tais como, sociais, polticos, legais, econmicos e tecnolgicos.</li><li>As foras provenientes do setor de atuao englobam aspectos relativos ao ambiente operacional da organizao, como caractersticas dos principais concorrentes, dos formadores de opinio e foras atuantes no setor como um todo.</li><li>As foras provenientes dos mercados de atuao abrangem aspectos relativos  competio por clientes, oportunidades e recursos, tais como o mercado-alvo de colocao de produtos, o mercado de trabalho, o mercado financeiro e de capitais, o mercado de fornecimento, o mercado de atuao socioambiental.</li></ol>'),
	(1098,203,'b','<p>Como so identificados os ativos intangveis mais importantes para a organizao?</p>','<ul><li>Destacar a maneira de desenvolver os ativos intangveis mais importantes.</li></ul>','<ul><li>Citar os ativos intangveis mais importantes.</li></ul>','<ol><li>Os ativos intagveis mais importantes para a organizao so aqueles que mais agregam valor ao negcio, gerando diferenciais competitivos para a organizao.</li></ol>'),
	(1099,203,'c','<p>Como so analisadas as foras impulsoras e restritivas do ambiente interno?</p>','<ul><li>Destacar de que forma as informaes sobre os riscos aos quais a organizao est sujeita so considerados na anlise.</li></ul>',NULL,'<ol><li>As foras impulsoras e restritivas do ambiente interno abrangem aquelas relacionadas  fora de trabalho, infraestrutura, questes econmico-financeiras, processos, tecnologias, capacidades, informaes e outros. Entre as foras impulsoras do ambiente interno mais importantes, encontram-se os ativos intangveis.</li><li>Os riscos aos quais a organizao est sujeita so geridos em 1.2a.</li></ol>'),
	(1100,203,'d','<p>Como so definidas as estratgias a serem adotadas pela organizao?</p>','<ul><li>Destacar de que forma os requisitos das partes interessadas so inseridos nas estratgias.</li><li>Destacar a forma de avaliao das caractersticas do modelo de negcio, em consonncia com a definio das estratgias.</li></ul>','<ul><li>Apresentar as principais estratgias e objetivos da organizao.</li></ul>','<ol><li>A definio das estratgias inclui a avaliao das alternativas decorrentes das anlises das foras impulsoras e restritivas do ambiente externo e interno.</li><li>A avaliao do modelo de negcio visa a potencializar o xito das estratgias. Pode envolver, por exemplo, a entrada e sada em negcios e mercados, o desenvolvimento de novas linhas de produtos ou sua retirada do mercado, o estabelecimento de parcerias, a reorganizao dos processos da cadeia de valor, a terceirizao ou internalizao de atividades, mudanas no modelo comercial e outras.</li></ol>'),
	(1101,204,'a','<p>Como so estabelecidas as metas de curto e longo prazos e definidos os respectivos planos de ao?</p>','<ul><li>Destacar a maneira de definir os indicadores para a avaliao do xito das estratgias.</li><li>Destacar de que forma os referenciais comparativos e os requisitos de partes interessadas so utilizados para definio de metas.</li></ul>','<ul><li>Apresentar os principais indicadores, suas metas e principais aes planejadas ou projetos, relativos  implementao das estratgias.</li></ul>','<ol><li>Os planos de ao so tambm conhecidos como projetos estratgicos.</li><li>Os resultados dos indicadores citados nesta questo devem ser apresentados no Critrio 8, exceto os relativos aos indicadores em incio de uso, que no sejam comparveis e que no expressem requisitos de partes interessadas.</li><li>Os nveis de desempenho ou melhorias esperadas, que expressam os principais requisitos de partes interessadas, utilizados ou no para estabelecer metas para os indicadores de avaliao da implementao das estratgias, devem ser apresentados no Critrio 8, juntamente com os indicadores pertinentes.</li></ol>'),
	(1102,204,'b','<p>Como as metas e os planos de ao so desdobrados nas reas responsveis pelos processos da cadeia de valor?</p>','<ul><li>Destacar a forma de assegurar a coerncia das metas e dos planos desdobrados com as estratgias e entre si.</li></ul>',NULL,'<ol><li>Os processos da cadeia de valor so aqueles citados no Perfil P1B(2).</li><li>O desdobramento das metas e planos de ao deve abranger todas as reas e nveis da organizao.</li><li>A coerncia das metas e dos planos desdobrados com as estratgias e entre si visa a manter alinhamento entre as iniciativas das diversas reas.</li></ol>'),
	(1103,204,'c','<p>Como os recursos para a implementao dos planos de ao so alocados?</p>',NULL,NULL,'<ol><li>A alocao de recursos visa a assegurar a implementao dos planos de ao que sustentam as estratgias. Esses recursos podem abranger os financeiros, humanos, materiais, tecnolgicos, de capacidade produtiva ou de gesto, informao, conhecimento e outros.</li></ol>'),
	(1104,204,'d','<p>Como a implementao dos planos de ao  acompanhada?</p>','<ul><li>Destacar a maneira utilizada pela direo para acompanhar a situao da implementao dos planos de ao.</li></ul>',NULL,NULL),
	(1105,205,'a','<p>Como a organizao segmenta seu mercado e define os clientes-alvo para seus produtos?</p>','<ul><li>Destacar os critrios adotados para segmentao do mercado e para definio de clientes-alvo.</li></ul>',NULL,'<ol><li>Os principais segmentos de mercado e clientes- alvo da organizao so requeridos no Perfil P1D(3).</li></ol>'),
	(1106,205,'b','<p>Como as necessidades e expectativas dos clientes-alvo, nos segmentos de atuao, so identificadas, traduzidas em requisitos de desempenho e utilizadas para a definio e melhoria de produtos e processos da organizao?</p>','<ul><li>Destacar de que forma a organizao atua em rede para ampliar o conhecimento sobre os clientes-alvo.</li></ul>','<ul><li>Apresentar os principais requisitos e respectivos indicadores de desempenho relativos aos clientes e mercados.</li></ul>','<ol><li>As principais necessidades e expectativas dos clientes so requeridas no Perfil P1C(1).</li><li>A traduo das necessidades e expectativas em requisitos de desempenho visa a transformar seus aspectos subjetivos e intangveis em caractersticas objetivas, tangveis e mensurveis, a serem verificadas na produo do bem ou servio, ou no gerenciamento do processo.</li></ol>'),
	(1107,205,'c','<p>Como os produtos so divulgados ao clientes e ao mercado?</p>','<ul><li>Destacar a forma de relacionamento com o mercado.</li></ul>',NULL,'<ol><li>A divulgao dos produtos aos clientes e ao mercado visa a assegurar que eles tenham pleno conhecimento da organizao, assim como criar credibilidade, confiana e imagem positiva.</li></ol>'),
	(1108,205,'d','<p>Como  avaliada a imagem da organizao perante os clientes e mercados?</p>','<ul><li>Destacar a maneira de desenvolver, proteger e divulgar as marcas no mercado</li></ul>','<ul><li>Citar os atributos que se deseja evidenciar para caracterizar a imagem da organizao.</li></ul>','<ol><li>A imagem da organizao deve ser avaliada, para verificar se os atributos que se deseja evidenciar esto sendo percebidos pelos clientes e mercados alvos.</li><li>O desenvolvimento das marcas tem o propsito de criar credibilidade, confiana e imagem positiva na organizao e seus produtos.</li><li>A divulgao de marcas visa a torn-las conhecidas e associ-las a atributos que se deseja evidenciar, da organizao e de seus produtos. A divulgao dos produtos tem a finalidade de despertar o interesse dos clientes atuais e clientes-alvo pelos produtos da organizao.</li><li>As marcas podem incluir tanto institucionais como as relacionadas a produtos.</li></ol>'),
	(1109,206,'a','<p>Como so tratadas as solicitaes, reclamaes ou sugestes dos clientes?</p>','<ul><li>Destacar a maneira de divulgar os canais de interao com os clientes, considerando a segmentao do mercado e a definio dos clientes-alvo.</li><li>Destacar a forma utilizada para comunicar aos clientes o resultado da anlise dessas manifestaes e as respectivas aes implementadas, e para repassar essas informaes a outras reas da organizao e, quando aplicvel, aos parceiros.</li></ul>','<ul><li>Citar os principais mecanismos ou canais de interao com os clientes.</li></ul>','<ol><li>O tratamento adequado das manifestaes dos clientes visa a assegurar que elas sejam pronta e eficazmente atendidas ou solucionadas.</li><li>O monitoramento das reclamaes  importante para avaliar a insatisfao dos clientes.</li><li>Mencionar, quando aplicvel, tambm os canais de relacionamento, estabelecidos via parceiros, como distribuidores, revendedores, representantes e afins, para receber solicitaes, reclamaes e sugestes.</li></ol>'),
	(1110,206,'b','<p>Como so acompanhadas as transaes com os novos clientes e a insero de novos produtos no mercado?</p>',NULL,NULL,'<ol><li>O acompanhamento das transaes com os clientes novos visa a permitir  organizao gerar solues rpidas e eficazes, evitar problemas de relacionamento e atender s expectativas dos clientes. Com o mesmo objetivo, a organizao deve acompanhar a qualidade, desempenho, aceitao, por exemplo, dos novos produtos inseridos no mercado e entregues aos clientes.</li></ol>'),
	(1111,206,'c','<p>Como so avaliadas a satisfao e a insatisfao dos clientes?</p>','<ul><li>Destacar a forma utilizada para avaliar a satisfao em relao aos clientes dos concorrentes ou de organizaes de referncia.</li></ul>',NULL,'<ol><li>A avaliao comparativa, em relao aos clientes de organizaes de referncia, deve ser realizada quando no h concorrentes.</li></ol>'),
	(1112,206,'d','<p>Como as informaes obtidas dos clientes so analisadas e utilizadas?</p>',NULL,NULL,'<ol><li>A utilizao eficaz das informaes obtidas dos clientes possibilita intensificar a sua satisfao, torn-los fiis, incentiv-los a recomendar os produtos da organizao. Alm disso, as informaes representam importantes subsdios para desenvolver processos e produtos.</li></ol>'),
	(1113,207,'a','<p>Como as leis, regulamentos e normas ou cdigos de adeso voluntria, aplicveis  organizao so identificados e atendidos?</p>','<ul><li>Destacar de que maneira so tratadas as pendncias ou eventuais sanes relativas a requisitos associados a leis e regulamentos aplicveis  organizao. No caso de inexistncia, declarar formalmente a situao.</li></ul>','<ul><li>Apresentar os principais requisitos e respectivos indicadores de desempenho relativos  sociedade e relativos s leis, regulamentos e normas ou cdigos de adeso voluntria.</li></ul>','<ol><li>As leis, regulamentos e normas ou cdigos de adeso voluntria, aplicveis  organizao, representam necessidades e expectativas da sociedade em geral, em relao  organizao.</li><li>A organizao pode atender, traduzindo a condio de legalidade em requisitos de desempenho, por exemplo, de conformidade.</li></ol>'),
	(1114,207,'b','<p>Como a organizao identifica os aspectos e trata os impactos sociais e ambientais adversos decorrentes de seus produtos, processos e instalaes?</p>','<ul><li>Destacar de que forma a organizao se mantm preparada para responder s eventuais situaes de emergncia.</li></ul>','<ul><li>Apresentar as principais aes e metas para eliminar, minimizar ou compensar os impactos sociais e ambientais negativos identificados.</li></ul>','<ol><li>Os aspectos e impactos adversos so aqueles sobre os quais a organizao tem influncia e devem ser considerados ao longo do ciclo de vida do produto, desde o projeto at a disposio final ou reutilizao.</li><li>Entre os impactos sociais, incluem-se aqueles relativos  segurana, sade e qualidade de vida dos usurios e da populao em geral, que possam advir dos produtos, processos e instalaes da organizao.</li><li>A prontido para responder s situaes de emergncia visa a evitar ou mitigar os seus impactos adversos na sociedade e no meio ambiente, incluindo comunidades potencialmente impactadas.</li><li>Os principais impactos sociais e ambientais adversos, existentes e potenciais, bem como os passivos ambientais, se existirem, so requeridos no Perfil P1D(5).</li></ol>'),
	(1115,207,'c','<p>Como  propiciada a acessibilidade aos produtos e instalaes da organizao?</p>',NULL,NULL,'<ol><li>A acessibilidade inclui as aes para garantir que o cidado possa acessar os produtos e instalaes, como usurio, empregado ou fornecedor, independente de quaisquer limitaes fsicas que o cidado possa ter.</li></ol>'),
	(1116,207,'d','<p>Como a organizao promove, de forma voluntria, aes com vistas ao desenvolvimento sustentvel?</p>','<ul><li>Destacar o critrio de seleo das aes com vistas ao desenvolvimento sustentvel.</li><li>Destacar a forma de desenvolver parcerias ou de atuar em rede e envolver a fora de trabalho na implementao ou apoio s suas aes relativas ao desenvolvimento sustentvel.</li></ul>','<ul><li>Citar as principais aes implementadas.</li></ul>','<ol><li>As aes, diretas ou indiretas, para o desenvolvimento sustentvel podem abranger a minimizao de consumo de recursos renovveis, de conservao de recursos no renovveis, reciclagem ou reutilizao de materiais ou mesmo a contribuio para a soluo dos grandes temas mundiais. Tais temas incluem o aquecimento global, a reduo da camada de oznio, as mudanas climticas, a destruio de florestas naturais, o respeito aos direitos humanos, o trabalho infantil ou degradante, o combate  lavagem de dinheiro e trfico de pessoas, a pobreza extrema, a escassez de gua potvel e temas afins.</li><li>As parcerias desenvolvidas so requeridas no Perfil P1D(6).</li></ol>'),
	(1117,208,'a','<p>Como as necessidades e as expectativas de desenvolvimento da sociedade so identificadas e atendidas?</p>',NULL,'<ul><li>Apresentar os principais requisitos e respectivos indicadores de desempenho relativos ao desenvolvimento da sociedade.</li></ul>','<ol><li>As principais necessidades e expectativas de desenvolvimento da sociedade relativas a essa questo, alm do cumprimento das leis e regulamentos tratados em 4.1a, so requeridas no Perfil P1C(1).</li></ol>'),
	(1118,208,'b','<p>Como a organizao direciona esforos para o desenvolvimento da sociedade?</p>','<ul><li>Destacar a forma de desenvolver parcerias ou de atuar em rede e de envolver a fora de trabalho na implementao de projetos sociais.</li></ul>','<ul><li>Citar os principais projetos implementados ou apoiados, incluindo aqueles voltados ao desenvolvimento da competitividade e sustentabilidade das organizaes do setor, do local, da regio ou do pas.</li></ul>','<ol><li>Os esforos para fortalecimento da sociedade incluem a execuo ou apoio a projetos voltados para o desenvolvimento nacional, regional, local ou setorial, em funo do porte e tipo de atividade da organizao.</li><li>Os efeitos dos projetos sociais podem ser avaliados em termos de participao ou benefcios para a comunidade ou fora de trabalho, contribuio  imagem da organizao ou qualquer outro tipo de retorno social.</li><li>As ofertas de vagas para estagirios podem ser consideradas aes de desenvolvimento social.</li><li>As parcerias desenvolvidas so requeridas no Perfil P1D(6).</li></ol>'),
	(1119,208,'c','<p>Como  avaliado o grau de satisfao da sociedade em relao aos principais projetos sociais da organizao?</p>',NULL,NULL,NULL),
	(1120,208,'d','<p>Como a organizao zela por sua imagem perante sociedade?</p>',NULL,NULL,'<ol><li>O zelo pela imagem abrange as atividades de comunicao social como, por exemplo, a presena na mdia associada a projetos sociais relevantes, a divulgao de relatrios de sustentabilidade, a promoo da transparncia, o comprometimento com a verdade e a legalidade e outros.</li></ol>'),
	(1121,209,'a','<p>Como so identificadas as necessidades de informaes para operar e gerenciar a organizao?</p>',NULL,NULL,'<ol><li>As necessidades de informaes para operar a organizao abrangem aquelas que apoiam as operaes dos processos da cadeia de valor.</li><li>As necessidades de informaes para gerenciar a organizao abrangem indicadores de desempenho, situao de planos, projetos e oramentos, relatrios gerenciais, resultados de pesquisas e outras variveis importantes do ambiente, necessrias para apoiar o processo decisrio em todos os nveis e reas da organizao.</li></ol>'),
	(1122,209,'b','<p>Como so desenvolvidos e implantados os principais sistemas de informao, considerando as necessidades identificadas?</p>','<ul><li>Destacar a maneira de promover a integrao da organizao com clientes, fornecedores e outras partes interessadas externas, por meio de sistemas de informao.</li><li>Destacar a maneira de compatibilizar a infraestrutura para a disponibilizao das informaes aos usurios com a demanda por informaes.</li></ul>','<ul><li>Citar os principais sistemas de informao em uso e sua finalidade.</li><li>Citar as principais solues adotadas, visando  integrao das informaes, dos sistemas e partes interessadas externas.</li></ul>','<ol><li>Os sistemas de informao podem incluir sistemas no informatizados, visando a atender s necessidades de informao e de seu tratamento, como por exemplo, sistemas de gesto  vista, sistemas de controle visuais, sistema de manuais, sistema de pronturios, sistemas de documentos para operao manual.</li><li>A infraestrutura para a disponibilizao das informaes aos usurios inclui a de comunicao.</li><li>Os usurios podem abranger a fora de trabalho e integrantes de outras partes interessadas.</li></ol>'),
	(1123,209,'c','<p>Como a segurana das informaes  mantida?</p>','<ul><li>Destacar os mtodos utilizados para buscar assegurar a atualizao, a confidencialidade e integridade das informaes e a continuidade da infraestrutura para disponibilizao de informaes em situaes de emergncia.</li></ul>',NULL,'<ol><li>A atualizao visa a garantir que os usurios estejam utilizando informaes atuais para tomar decises e realizar seu trabalho, no havendo pendncias de registros de fatos e lanamentos de documentos nos sistemas de informao.</li><li>A confidencialidade pressupe que somente pessoas autorizadas tenham acesso s informaes.</li><li>A integridade trata da salvaguarda da exatido e completeza da informao recebida, armazenada e distribuda e dos mtodos de processamento.</li><li>As situaes de emergncia so aquelas que podem causar a interrupo dos servios de informao.</li></ol>'),
	(1124,210,'a','<p>Como a organizao desenvolve os conhecimentos mais importantes?</p>','<ul><li>Destacar de que maneira a organizao cria um ambiente favorvel  busca e gerao de conhecimento.</li><li>Destacar as formas utilizadas para armazenar os conhecimentos.</li></ul>',NULL,'<ol><li>Os conhecimentos mais importantes so desenvolvidos para apoiar a realizao da misso e a implementao das estratgias.</li><li>O desenvolvimento do conhecimento pode incluir, alm do treinamento, o estabelecimento de equipes de conhecimento, de melhoria de processos ou de aprendizado, centros de competncia, pesquisa e desenvolvimento, comunidades de prtica, registro de lies aprendidas, fomento  inovao e busca de melhores prticas.</li><li>A busca do conhecimento abrange a pesquisa e apropriao de conhecimento externo  organizao.</li></ol>'),
	(1125,210,'b','<p>Como os conhecimentos mais importantes da organizao so difundidos e utilizados?</p>','<ul><li>Destacar as formas utilizadas para que os conhecimentos retidos possam ser acessados e utilizados, onde pertinente.</li></ul>','<ul><li>Informar os conhecimentos mais importantes da organizao.</li></ul>','<ol><li>O conhecimento deve ser difundido s pessoas da fora de trabalho e demais partes interessadas que tenham a necessidade explcita de utiliz-lo.</li></ol>'),
	(1126,211,'a','<p>Como a organizao do trabalho  definida?</p>','<ul><li>Destacar de que forma a organizao do trabalho estimula a resposta rpida e o aprendizado organizacional.</li><li>Destacar a participao da fora de trabalho para a melhoria dos processos da organizao e para buscar inovaes.</li><li>Destacar a forma utilizada para definir o quadro de pessoal e suas responsabilidades.</li></ul>',NULL,'<ol><li>A organizao do trabalho em reas, grupos ou estruturas afins, deve ser concebida em alinhamento com as competncias requeridas pelo modelo de negcio, estratgias e processos, visando ao alto desempenho e  inovao.</li><li>As caractersticas da organizao do trabalho para estimular a resposta rpida e o aprendizado devem incluir a comunicao eficaz entre as pessoas e entre as equipes, inclusive de diferentes localidades e reas.</li></ol>'),
	(1127,211,'b','<p>Como as competncias necessrias para o exerccio pleno das funes pelas pessoas, incluindo lderes, so identificadas?</p>',NULL,'<ul><li>Apresentar as principais competncias identificadas para as pessoas em geral e, especificamente, para os lderes.</li></ul>','<ol><li>A identificao das competncias  fundamental para a definio dos papis de cada pessoa na organizao, da estrutura de cargos e da organizao do trabalho.</li><li>As principais competncias identificadas a serem apresentadas podem variar em funo dos diferentes grupos de pessoas da fora de trabalho, como tcnico, administrativo, operacional e gerencial.</li></ol>'),
	(1128,211,'c','<p>Como as pessoas so selecionadas, interna e externamente?</p>','<ul><li>Destacar de que forma a organizao estimula a incluso de minorias e assegura a no discriminao e a igualdade de oportunidades para todas as pessoas.</li></ul>',NULL,'<ol><li>A seleo de pessoas, interna e externamente, visa a preencher as vagas da organizao com profissionais compatveis s necessidades de desempenho atual e futuro. O recrutamento interno tem por objetivo maximizar as oportunidades de desenvolvimento atual.</li></ol>'),
	(1129,211,'d','<p>Como as pessoas recm-contratadas so preparadas para o exerccio de suas funes e integradas  cultura organizacional?</p>',NULL,NULL,NULL),
	(1130,211,'e','<p>Como o desempenho das pessoas, incluindo lderes,  avaliado?</p>','<ul><li>Destacar a forma de definir as necessidades de melhoria, com as pessoas.</li><li>Destacar de que forma a avaliao estimula a busca do alto desempenho e o desenvolvimento profissional das pessoas.</li></ul>',NULL,'<ol><li>O desempenho pode abranger qualquer fator considerado importante para o exerccio das funes como, por exemplo, cumprimento de obrigaes, alcance de metas, comportamentos esperados, qualidade do trabalho e outros.</li></ol>'),
	(1131,211,'f','<p>Como as pessoas so reconhecidas e incentivadas?</p>',NULL,NULL,'<ol><li>O termo &ldquo;reconhecimento&rdquo; abrange a identificao e o reforo de comportamentos de alto desempenho das pessoas. A identificao de oportunidades de</li><li>reconhecimento pode incluir a percepo de realizaes ou contribuies extraordinrias das pessoas, o desempenho excepcional ou outros fatores passveis de reconhecimento.</li><li>O termo &ldquo;incentivo&rdquo; abrange o reforo desses comportamentos, condicionado a nveis de desempenho pr-determinados.</li><li>As condicionantes do incentivo podem abranger alcance de metas, aquisio de conhecimentos, habilidades e competncias ou outros fatores indutores do alto desempenho. O reforo de comportamentos pode incluir premiaes, recompensas ou oportunidades especiais, formais ou informais, individuais ou em grupo.</li></ol>'),
	(1132,212,'a','<p>Como so identificadas as necessidades de capacitao e desenvolvimento das pessoas?</p>','<ul><li>Destacar a forma de participao dos lderes e das prprias pessoas a serem capacitadas e desenvolvidas, na identificao das necessidades.</li></ul>',NULL,'<ol><li>A identificao das necessidades de capacitao e desenvolvimento das pessoas deve abranger o xito de estratgias,  formao da cultura da excelncia e  melhoria do desempenho individual, incluindo de lderes.</li></ol>'),
	(1133,212,'b','<p>Como  concebida a forma de realizao dos programas de capacitao e de desenvolvimento?</p>','<ul><li>Destacar a forma de avaliar a eficcia dos programas de capacitao e de desenvolvimento.</li><li>Destacar a forma de identificao e preparao de novos lderes e de desenvolvimento de lderes.</li></ul>','<ul><li>Citar os principais programas e o pblicoalvo, incluindo aqueles relacionados ao desenvolvimento de lderes e  formao da cultura da excelncia.</li></ul>','<ol><li>A preparao de novos lderes e o desenvolvimento de lderes devem abranger todas as funes de liderana.</li><li>A identificao de novos lderes deve abranger todas as funes de liderana, incluindo sucessores.</li></ol>'),
	(1134,212,'c','<p>Como a organizao promove o desenvolvimento comportamental e da cidadania das pessoas?</p>',NULL,NULL,'<ol><li>O desenvolvimento comportamental favorece os comportamentos e atitudes psicossociais para o trabalho em equipe e o relacionamento interpessoal. Por exemplo: programas de treinamento comportamental, comunicao interpessoal, vivncia em grupo, construo de times, trabalho em equipe, servios de assistncia psicolgica e social, entre outros.</li><li>O desenvolvimento da cidadania favorece o exerccio da tica e a vida em comunidade. Por exemplo: programas de orientao ou assistncia jurdica, treinamento em direitos do cidado, funcionamento e canais da administrao pblica e da justia, crdito responsvel, estmulo ou apoio ao voluntariado e tica empresarial, entre outros.</li></ol>'),
	(1135,213,'a','<p>Como so identificados os perigos e tratados os riscos relacionados  sade ocupacional e  segurana?</p>',NULL,'<ul><li>Citar os principais programas e as metas para eliminar ou minimizar esses riscos.</li></ul>','<ol><li>Os perigos relacionados  sade ocupacional e  segurana so identificados para que os riscos sejam tratados, a fim de prevenir a ocorrncia de fatores que possam ameaar a integridade fsica ou psicolgica das pessoas, em decorrncia de suas atividades.</li><li>A sade ocupacional abrange aspectos relativos  ergonomia.</li></ol>'),
	(1136,213,'b','<p>Como as necessidades e expectativas das pessoas so identificadas e utilizadas para o desenvolvimento de polticas e programas de pessoal e dos benefcios a elas oferecidos?</p>',NULL,'<ul><li>Apresentar os principais benefcios oferecidos s pessoas na organizao.</li><li>Apresentar os principais requisitos e respectivos indicadores de desempenho relativos s pessoas.</li></ul>','<ol><li>As principais necessidades e expectativas das pessoas so requeridas no Perfil P1C(1).</li><li>Os benefcios oferecidos s pessoas incluem quaisquer servios, facilidades, ambiente de trabalho e outros atrativos valorizados pelas pessoas na manuteno da relao de trabalho com a organizao.</li></ol>'),
	(1137,213,'c','<p>Como o bem-estar e a satisfao das pessoas so avaliados e desenvolvidos?</p>','<ul><li>Destacar de que forma so tratados, com a participao de lderes, os fatores identificados na avaliao, que afetam o bem-estar e a satisfao.</li><li>Destacar a maneira de promover a qualidade de vida das pessoas fora do ambiente de trabalho.</li></ul>','<ul><li>Citar as principais aes desenvolvidas para melhoria do bem-estar e da qualidade de vida fora do ambiente de trabalho.</li></ul>','<ol><li>Os fatores que afetam o bem-estar so aqueles relativos  promoo de um ambiente de trabalho agradvel, tranquilo e equilibrado, no qual as pessoas se sintam bem.</li><li>Os fatores que afetam a satisfao so aqueles relativos ao atendimento de necessidades das pessoas e que determinam sua preferncia em trabalhar para a organizao.</li><li>A promoo da qualidade de vida fora do ambiente de trabalho aborda temas relacionados  sade fsica e mental, no ocupacional, das pessoas e aos servios de apoio operacional que facilitam o seu dia a dia. Por exemplo: programas de bons hbitos alimentares, promoo da sade total, segurana domstica e manuteno domstica, conduo segura, segurana pblica, primeiros socorros, economia domstica e servios de orientao desportiva, grmio ou clube familiar, creche, transporte, acesso  internet, uso da telefonia, entre outros.</li></ol>'),
	(1138,214,'a','<p>Como so definidos os requisitos aplicveis aos produtos e aos processos da cadeia de valor?</p>',NULL,'<ul><li>Apresentar os principais requisitos relativos aos produtos e processos da cadeia de valor a serem atendidos e os respectivos indicadores de desempenho.</li></ul>','<ol><li>Os requisitos dos produtos e processos devem levar em considerao os requisitos dos clientes, da sociedade e de outras partes interessadas aplicveis.</li></ol>'),
	(1139,214,'b','<p>Como so desenvolvidos os novos produtos?</p>','<ul><li>Destacar a forma de avaliar o potencial de ideias criativas se converterem em inovaes nos produtos.</li></ul>',NULL,'<ol><li>A expresso &ldquo;novos produtos&rdquo; inclui variaes em produtos existentes.</li><li>Os novos produtos devem ser desenvolvidos para atender ou superar os requisitos dos clientes e de outras partes interessadas.</li><li>A avaliao do potencial de ideias criativas pode incluir a realizao de experimentos, por meio de pilotos, prottipos, modelagem e simulaes.</li></ol>'),
	(1140,214,'c','<p>Como so projetados os processos da cadeia de valor?</p>','<ul><li>Destacar a forma de identificao dos processos da cadeia de valor e a metodologia utilizada para projet-los.</li></ul>',NULL,'<ol><li>Os processos da cadeia de valor devem ser projetados, concebidos ou planejados, para atender aos requisitos dos clientes e de outras partes interessadas e, quando aplicvel, de outros processos da cadeia de valor deles dependentes.</li></ol>'),
	(1141,214,'d','<p>Como  assegurado o atendimento dos requisitos aplicveis aos processos da cadeia de valor?</p>','<ul><li>Destacar os mtodos de padronizao e controle.</li><li>Destacar a forma de tratamento de eventuais no conformidades identificadas e de implementao das aes corretivas.</li></ul>',NULL,'<ol><li>O controle dos processos tem por finalidade assegurar que os requisitos de processo e produto sejam atendidos e, consequentemente, sejam atendidas as necessidades e expectativas de clientes e de outras partes interessadas. O controle  realizado por meio dos indicadores de desempenho, cujos resultados so comparados com padres (metas) previamente estabelecidos. O responsvel pelos processos atua corretiva e preventivamente, para sanar no-conformidades identificadas. No conformidade se refere ao no atendimento a algum dos requisitos. O tratamento de uma no conformidade leva  identificao e bloqueio das causas, de modo a assegurar que no haver novas ocorrncias.</li></ol>'),
	(1142,214,'e','<p>Como a organizao analisa e melhora os produtos e os processos da cadeia de valor?</p>','<ul><li>Destacar as formas de investigao de caractersticas de produtos e de processos da cadeia de valor, de concorrentes ou de outras organizaes de referncia, para buscar melhorias.</li><li>Destacar a forma de avaliar o potencial de ideias criativas se converterem em inovaes nos processos.</li></ul>','<ul><li>Citar as principais melhorias e inovaes recentes, implementadas em produtos e em processos da cadeia de valor, em decorrncia dessas comparaes.</li></ul>','<ol><li>As organizaes de referncia incluem aquelas de dentro e de fora do ramo ou setor de atuao da organizao.</li><li>Os produtos e processos, que so objeto da investigao, referem-se queles com finalidade similar ao da organizao.</li><li>A avaliao do potencial de ideias criativas pode incluir a realizao de experimentos, por meio de pilotos, prottipos, modelagem e simulaes.</li></ol>'),
	(1143,215,'a','<p>Como os fornecedores so qualificados e selecionados?</p>','<ul><li>Destacar os principais critrios utilizados para qualificao e seleo.</li></ul>',NULL,'<ol><li>A qualificao de fornecedores tem a finalidade de verificar se os candidatos possuem as qualidades necessrias para se tornar fornecedores.</li><li>A seleo tem por objetivo definir a melhor opo de fornecimento, ponderando os fatores relevantes para a organizao.</li></ol>'),
	(1144,215,'b','<p>Como a organizao avalia o desempenho dos fornecedores, considerando os requisitos de fornecimento?</p>','<ul><li>Destacar a maneira de monitorar o desempenho dos fornecedores.</li><li>Destacar as formas de pronta comunicao de eventuais no conformidades e de solicitao de aes corretivas aos fornecedores.</li><li>Destacar como a organizao estimula os fornecedores a melhorarem seus processos ou produtos.</li></ul>','<ul><li>Apresentar exemplos de melhorias implantadas por fornecedores.</li></ul>','<ol><li>A avaliao de fornecedores tem por finalidade retroaliment-los com as informaes sobre seu desempenho, para incentivar melhorias.</li><li>O monitoramento do desempenho dos fornecedores visa  verificao do preenchimento das condies de fornecimento contratadas.</li><li>A avaliao e o monitoramento do nvel de desempenho de fornecedores possibilitam tambm a melhoria dos processos de qualificao e seleo.</li><li>O estmulo aos fornecedores visa a melhorar a qualidade dos produtos adquiridos, incluindo a otimizao de seus custos.</li></ol>'),
	(1145,215,'c','<p>Como a fora de trabalho dos fornecedores, que atua diretamente nos processos da cadeia de valor da organizao,  comprometida com os valores e princpios organizacionais e com as diretrizes a eles aplicveis?</p>',NULL,NULL,NULL),
	(1146,215,'d','<p>Como as necessidades e expectativas dos fornecedores so identificadas e analisadas?</p>',NULL,'<ul><li>Apresentar os principais requisitos e indicadores de desempenho relativos aos fornecedores.</li></ul>',NULL),
	(1147,216,'a','<p>Como so monitorados os aspectos que causam impacto na sustentabilidade econmica do negcio?</p>',NULL,'<ul><li>Apresentar os principais requisitos e os respectivos indicadores de desempenho monitorados, incluindo aqueles relativos aos grupos de estrutura, liquidez, atividade e rentabilidade.</li></ul>',NULL),
	(1148,216,'b','<p>Como a organizao busca assegurar os recursos financeiros necessrios para atender s necessidades operacionais e manter equilibrado o fluxo financeiro?</p>',NULL,NULL,NULL),
	(1149,216,'c','<p>Como a organizao avalia os investimentos necessrios para apoiar as estratgias e planos de ao?</p>','<ul><li>Destacar os critrios utilizados para definir a forma de captao apropriada.</li></ul>',NULL,NULL),
	(1150,216,'d','<p>Como  elaborado e controlado o oramento?</p>',NULL,NULL,'<ol><li>A elaborao e controle do oramento visam a assegurar o atendimento dos nveis esperados de desempenho financeiro e tambm o alinhamento com as estratgias e objetivos da organizao.</li></ol>'),
	(1151,217,'a','<p>Apresentar os resultados dos principais indicadores relativos  gesto econmico-financeira.</p>','<ul><li>Separar os resultados segundo os grupos de estrutura, liquidez, atividade e rentabilidade, conforme aplicvel.</li><li>Estratificar os resultados por unidades ou filiais mais importantes, quando aplicvel.</li></ul>','<ul><li>Para cada indicador apresentado, informar se ele : <ul><li>(E) estratgico, </li><li>(O) operacional; ou </li><li>(E,O) ambos. </li></ul></li><li>Mostrar o sentido de favorabilidade de cada srie histrica: <ul><li>quanto maior, melhor ou; </li><li>quanto menor, melhor ou; </li><li>estabilizao em nvel aceitvel,<ul><li>i.e., nvel suficientemente competitivo ou cumprindo compromisso com requisito de parte interessada, ou ambos, de forma compatvel com as estratgias. </li></ul></li></ul></li><li>Esclarecer por que o sentido da favorabilidade da srie histrica  a estabilizao em nvel aceitvel, quando for o caso. </li><li>Esclarecer eventual piora nos resultados, quando possvel. </li><li>Incluir os referenciais comparativos pertinentes, e a quem se referem, relativos ao ltimo exerccio ou ciclo de avaliao, para indicadores que permitam comparaes a fim de avaliar a competitividade no mercado ou setor de atuao. Esclarecer, quando possvel, nveis de desempenho desfavorveis em relao ao referencial comparativo. </li><li>Incluir os nveis de desempenho ou melhorias esperadas que expressem os principais requisitos de partes interessadas, e a que partes se referem, relativas ao ltimo exerccio ou ciclo de avaliao, para indicadores que so utilizados a fim de avaliar o cumprimento desses requisitos. Esclarecer, quando possvel, o no atendimento a esses requisitos.</li></ul>','<ol><li>Estes resultados se referem aos indicadores de desempenho dos processos citados em 7.3, assim como eventuais indicadores dessa perspectiva, utilizados para avaliar o atendimento de requisitos de partes interessadas e a implementao das estratgias.</li><li>Explicar, resumidamente, o propsito de indicadores cujos nomes no sejam autoexplicativos.</li><li>No caso de unidade autnoma, em indicadores cujo levantamento de resultados  realizado somente no nvel corporativo, demonstrar a contribuio da unidade para o resultado alcanado.</li><li>As sries histricas devem abranger trs perodos ou ciclos de avaliao.</li><li>A competitividade do resultado em um tema pode ser avaliada por meio de indicadores com referenciais comparativos diferentes daqueles utilizados para avaliar a melhoria do mesmo tema.</li><li>Podem ser apresentados indicadores, entre os relevantes, sem referencial comparativo pertinente, quando o resultado no for comparvel; e sem requisito de parte interessada, quando no refletir necessidades e expectativas de partes interessadas, se eles forem relevantes para avaliar a melhoria.</li></ol>'),
	(1152,218,'a','<p>Apresentar os resultados dos principais indicadores relativos  responsabilidade socioambiental e ao desenvolvimento social.</p>','<ul><li>Separar os resultados em sociais e ambientais.</li><li>Estratificar os resultados por instalaes ou comunidades mais importantes, conforme aplicvel.</li></ul>','<ul><li>Para cada indicador apresentado, informar se ele : <ul><li>(E) estratgico, </li><li>(O) operacional; ou </li><li>(E,O) ambos. </li></ul></li><li>Mostrar o sentido de favorabilidade de cada srie histrica: <ul><li>quanto maior, melhor ou; </li><li>quanto menor, melhor ou; </li><li>estabilizao em nvel aceitvel,<ul><li>i.e., nvel suficientemente competitivo ou cumprindo compromisso com requisito de parte interessada, ou ambos, de forma compatvel com as estratgias. </li></ul></li></ul></li><li>Esclarecer por que o sentido da favorabilidade da srie histrica  a estabilizao em nvel aceitvel, quando for o caso. </li><li>Esclarecer eventual piora nos resultados, quando possvel. </li><li>Incluir os referenciais comparativos pertinentes, e a quem se referem, relativos ao ltimo exerccio ou ciclo de avaliao, para indicadores que permitam comparaes a fim de avaliar a competitividade no mercado ou setor de atuao. Esclarecer, quando possvel, nveis de desempenho desfavorveis em relao ao referencial comparativo. </li><li>Incluir os nveis de desempenho ou melhorias esperadas que expressem os principais requisitos de partes interessadas, e a que partes se referem, relativas ao ltimo exerccio ou ciclo de avaliao, para indicadores que so utilizados a fim de avaliar o cumprimento desses requisitos. Esclarecer, quando possvel, o no atendimento a esses requisitos.</li></ul>','<ol><li>Estes resultados se referem aos indicadores de desempenho dos processos citados no Critrio 4, assim como eventuais indicadores dessa perspectiva, utilizados para avaliar o atendimento de requisitos de partes interessadas e a implementao das estratgias.</li><li>Explicar, resumidamente, o propsito de indicadores cujos nomes no sejam autoexplicativos.</li><li>No caso de unidade autnoma, em indicadores cujo levantamento de resultados  realizado somente no nvel corporativo, demonstrar a contribuio da unidade para o resultado alcanado.</li><li>As sries histricas devem abranger trs perodos ou ciclos de avaliao.</li><li>A competitividade do resultado em um tema pode ser avaliada por meio de indicadores com referenciais comparativos diferentes daqueles utilizados para avaliar a melhoria do mesmo tema.</li><li>Podem ser apresentados indicadores, entre os relevantes, sem referencial comparativo pertinente, quando o resultado no for comparvel; e sem requisito de parte interessada, quando no refletir necessidades e expectativas de partes interessadas, se eles forem relevantes para avaliar a melhoria.</li></ol>'),
	(1153,219,'a','<p>Apresentar os resultados dos principais indicadores relativos aos clientes.</p>','<ul><li>Separar os resultados em clientes e mercado-alvo.</li><li>Estratificar os resultados por segmentos de mercado, grupos de clientes ou tipos de produtos mais importantes, conforme aplicvel.</li></ul>','<ul><li>Para cada indicador apresentado, informar se ele : <ul><li>(E) estratgico, </li><li>(O) operacional; ou </li><li>(E,O) ambos. </li></ul></li><li>Mostrar o sentido de favorabilidade de cada srie histrica: <ul><li>quanto maior, melhor ou; </li><li>quanto menor, melhor ou; </li><li>estabilizao em nvel aceitvel,<ul><li>i.e., nvel suficientemente competitivo ou cumprindo compromisso com requisito de parte interessada, ou ambos, de forma compatvel com as estratgias. </li></ul></li></ul></li><li>Esclarecer por que o sentido da favorabilidade da srie histrica  a estabilizao em nvel aceitvel, quando for o caso. </li><li>Esclarecer eventual piora nos resultados, quando possvel. </li><li>Incluir os referenciais comparativos pertinentes, e a quem se referem, relativos ao ltimo exerccio ou ciclo de avaliao, para indicadores que permitam comparaes a fim de avaliar a competitividade no mercado ou setor de atuao. Esclarecer, quando possvel, nveis de desempenho desfavorveis em relao ao referencial comparativo. </li><li>Incluir os nveis de desempenho ou melhorias esperadas que expressem os principais requisitos de partes interessadas, e a que partes se referem, relativas ao ltimo exerccio ou ciclo de avaliao, para indicadores que so utilizados a fim de avaliar o cumprimento desses requisitos. Esclarecer, quando possvel, o no atendimento a esses requisitos.</li></ul>','<ol><li>Estes resultados se referem aos indicadores de desempenho dos processos citados no Critrio 3, assim como eventuais indicadores dessa perspectiva, utilizados para avaliar o atendimento de requisitos de controladores e a implementao das estratgias.</li><li>Explicar, resumidamente, o propsito de indicadores cujos nomes no sejam autoexplicativos.</li><li>No caso de unidade autnoma, em indicadores cujo levantamento de resultados  realizado somente no nvel corporativo, demonstrar a contribuio da unidade para o resultado alcanado.</li><li>As sries histricas devem abranger trs perodos ou ciclos de avaliao.</li><li>A competitividade do resultado em um tema pode ser avaliada por meio de indicadores com referenciais comparativos diferentes daqueles utilizados para avaliar a melhoria do mesmo tema.</li><li>Podem ser apresentados indicadores, entre os relevantes, sem referencial comparativo pertinente, quando o resultado no for comparvel; e sem requisito de parte interessada, quando no refletir necessidades e expectativas de partes interessadas, se eles forem relevantes para avaliar a melhoria.</li></ol>'),
	(1154,220,'a','<p>Apresentar os resultados dos principais indicadores relativos s pessoas.</p>','<ul><li>Separar os resultados referentes ao sistema de trabalho,  capacitao e desenvolvimento e  qualidade de vida, bem como os referentes  liderana, comunicao e cultura.</li><li>Estratificar os resultados por funes na organizao ou grupos de pessoas da fora de trabalho e, conforme aplicvel, por instalaes mais importantes.</li></ul>','<ul><li>Para cada indicador apresentado, informar se ele : <ul><li>(E) estratgico, </li><li>(O) operacional; ou </li><li>(E,O) ambos. </li></ul></li><li>Mostrar o sentido de favorabilidade de cada srie histrica: <ul><li>quanto maior, melhor ou; </li><li>quanto menor, melhor ou; </li><li>estabilizao em nvel aceitvel,<ul><li>i.e., nvel suficientemente competitivo ou cumprindo compromisso com requisito de parte interessada, ou ambos, de forma compatvel com as estratgias. </li></ul></li></ul></li><li>Esclarecer por que o sentido da favorabilidade da srie histrica  a estabilizao em nvel aceitvel, quando for o caso. </li><li>Esclarecer eventual piora nos resultados, quando possvel. </li><li>Incluir os referenciais comparativos pertinentes, e a quem se referem, relativos ao ltimo exerccio ou ciclo de avaliao, para indicadores que permitam comparaes a fim de avaliar a competitividade no mercado ou setor de atuao. Esclarecer, quando possvel, nveis de desempenho desfavorveis em relao ao referencial comparativo. </li><li>Incluir os nveis de desempenho ou melhorias esperadas que expressem os principais requisitos de partes interessadas, e a que partes se referem, relativas ao ltimo exerccio ou ciclo de avaliao, para indicadores que so utilizados a fim de avaliar o cumprimento desses requisitos. Esclarecer, quando possvel, o no atendimento a esses requisitos.</li></ul>','<ol><li>Estes resultados se referem aos indicadores de desempenho dos processos citados no Critrio 6, assim como eventuais indicadores dessa perspectiva, utilizados para avaliar o atendimento de requisitos de partes interessadas e a implementao das estratgias.</li><li>As funes na organizao podem abranger as funes operacionais, administrativas e de liderana, ou outra classificao adotada pela organizao.</li><li>Os grupos de pessoas da fora de trabalho podem abranger os contratados em tempo integral ou parcial, horistas, mensalistas, temporrios, autnomos e contratados de terceiros que trabalham sob coordenao direta da organizao ou outros grupos com gesto diferenciada.</li><li>Explicar, resumidamente, o propsito de indicadores cujos nomes no sejam autoexplicativos.</li><li>No caso de unidade autnoma, em indicadores cujo levantamento de resultados  realizado somente no nvel corporativo, demonstrar a contribuio da unidade para o resultado alcanado.</li><li>As sries histricas devem abranger trs perodos ou ciclos de avaliao.</li><li>A competitividade do resultado em um tema pode ser avaliada por meio de indicadores com referenciais comparativos diferentes daqueles utilizados para avaliar a melhoria do mesmo tema.</li><li>Podem ser apresentados indicadores, entre os relevantes, sem referencial comparativo pertinente, quando o resultado no for comparvel; e sem requisito de parte interessada, quando no refletir necessidades e expectativas de partes interessadas, se eles forem relevantes para avaliar a melhoria.</li></ol>'),
	(1155,221,'a','<p>Apresentar os resultados dos principais indicadores relativos aos produtos, aos processos da cadeia de valor, relativos a fornecedores e relativos a processos de gesto transversais no relacionados aos demais itens deste Critrio.</p>','<ul><li>Separar os resultados de produtos, de processos da cadeia de valor e relativos a fornecedores mais importantes e, caso haja, os relativos a processos de gesto transversais.</li><li>Estratificar por instalao, se aplicvel.</li><li>Estratificar por tipo de fornecedor, se aplicvel.</li></ul>','<ul><li>Para cada indicador apresentado, informar se ele : <ul><li>(E) estratgico, </li><li>(O) operacional; ou </li><li>(E,O) ambos. </li></ul></li><li>Mostrar o sentido de favorabilidade de cada srie histrica: <ul><li>quanto maior, melhor ou; </li><li>quanto menor, melhor ou; </li><li>estabilizao em nvel aceitvel,<ul><li>i.e., nvel suficientemente competitivo ou cumprindo compromisso com requisito de parte interessada, ou ambos, de forma compatvel com as estratgias. </li></ul></li></ul></li><li>Esclarecer por que o sentido da favorabilidade da srie histrica  a estabilizao em nvel aceitvel, quando for o caso. </li><li>Esclarecer eventual piora nos resultados, quando possvel. </li><li>Incluir os referenciais comparativos pertinentes, e a quem se referem, relativos ao ltimo exerccio ou ciclo de avaliao, para indicadores que permitam comparaes a fim de avaliar a competitividade no mercado ou setor de atuao. Esclarecer, quando possvel, nveis de desempenho desfavorveis em relao ao referencial comparativo. </li><li>Incluir os nveis de desempenho ou melhorias esperadas que expressem os principais requisitos de partes interessadas, e a que partes se referem, relativas ao ltimo exerccio ou ciclo de avaliao, para indicadores que so utilizados a fim de avaliar o cumprimento desses requisitos. Esclarecer, quando possvel, o no atendimento a esses requisitos.</li></ul>','<ol><li>Estes resultados se referem aos indicadores de desempenho dos processos citados em 7.1, compatveis com o Perfil P1B(1/2), e em 2, compatveis com P1D(4), assim como eventuais indicadores dessa perspectiva, utilizados para avaliar o atendimento de requisitos de partes interessadas e a implementao das estratgias citados em 2.2a.</li><li>Incluem tambm os resultados de indicadores de desempenho de sistemas de gesto transversais, como de desenvolvimento da gesto, governana, atuao em rede, anlise do desempenho, planejamento, informaes, conhecimento e similares, porventura utilizados pela organizao.</li><li>Explicar, resumidamente, o propsito de indicadores cujos nomes no sejam autoexplicativos.</li><li>No caso de unidade autnoma, em indicadores cujo levantamento de resultados  realizado somente no nvel corporativo, demonstrar a contribuio da unidade para o resultado alcanado.</li><li>As sries histricas devem abranger trs perodos ou ciclos de avaliao.</li><li>A competitividade do resultado em um tema pode ser avaliada por meio de indicadores com referenciais comparativos diferentes daqueles utilizados para avaliar a melhoria do mesmo tema.</li><li>Podem ser apresentados indicadores, entre os relevantes, sem referencial comparativo pertinente, quando o resultado no for comparvel; e sem requisito de parte interessada, quando no refletir necessidades e expectativas de partes interessadas, se eles forem relevantes para avaliar a melhoria.</li></ol>'),
	(1156,222,'a','<p>Como so estabelecidos os valores e princpios organizacionais?</p>',NULL,'<ul><li>Apresentar os valores e os princpios organizacionais.</li></ul>','<ol><li>O estabelecimento de valores e princpios organizacionais inclui sua reviso e atualizao.</li><li>Os valores e princpios abrangem aqueles necessrios  promoo da excelncia,  criao de valor para todas as partes interessadas e ao desenvolvimento sustentvel.</li><li>A apresentao dos valores e princpios organizacionais inclui, por exemplo, as declaraes de misso, viso, credos e outras categorias de princpios porventura existentes.</li></ol>'),
	(1157,222,'b','<p>Como os principais elementos da cultura organizacional so identificados, analisados e desenvolvidos?</p>','<ul><li>Destacar as formas de reforo de elementos favorveis e eliminao ou minimizao de elementos adversos da cultura organizacional;</li><li>Destacar de que maneira  respeitada a diversidade de ideias no desenvolvimento da cultura organizacional.</li></ul>',NULL,'<ol><li>Os elementos da cultura podem abranger comportamentos, pressupostos, preconceitos, smbolos utilizados, formas de organizao do trabalho, rituais, cdigos ou formas de comunicao verbal ou escrita, linguagem empregada e outros, atuantes na organizao.</li><li>O desenvolvimento de elementos da cultura organizacional identificados visa  incorporao de comportamentos compatveis com a promoo da excelncia,  criao de valor para todas as partes interessadas e ao desenvolvimento sustentvel.</li><li>O respeito  diversidade de ideias pode incluir a adaptao de padres aos costumes locais; a incorporao de boas prticas de diversas origens, incluindo de fora do setor e de diferentes nacionalidades ou correntes de pensamento; a participao de profissionais de diferentes faixas etrias, formaes, nveis hierrquicos ou gneros; o estmulo  livre expresso de opinies e qualquer outro mecanismo promotor da diversidade.</li></ol>'),
	(1158,222,'c','<p>Como a organizao estabelece padres de conduta e busca assegurar um relacionamento tico no ambiente em que opera?</p>','<ul><li>Destacar a forma de preveno de desvios de conduta envolvendo a organizao;</li><li>Destacar a forma de tratamento das manifestaes relativas  conduta tica e de retorno aos envolvidos.</li></ul>','<ul><li>Apresentar os canais de comunicao disponveis para receber reclamaes, denncias e sugestes relativas  conduta, envolvendo a organizao;</li><li>Citar os cdigos de conduta emitidos.</li></ul>','<ol><li>As formas de preveno de desvios de conduta abrangem os principais processos e relacionamentos em que h risco de ocorrncia de assdio no tico, corrupo e fraudes.</li><li>Os interlocutores do ambiente em que a organizao opera, que esto envolvidos nas questes ticas, abrangem partes interessadas, redes importantes, concorrentes e outros interlocutores com os quais a organizao precisa se relacionar.</li></ol>'),
	(1159,222,'d','<p>Como os temas para o desenvolvimento da cultura organizacional e para o engajamento das pessoas so comunicados  fora de trabalho e a outros pblicos?</p>','<ul><li>Destacar as formas de comunicao de valores e princpios organizacionais, padres de conduta, estratgias e objetivos, metas e melhoria de resultados alcanados,  fora de trabalho e a outros pblicos-alvo da comunicao;</li><li>Destacar de que forma  avaliado o entendimento dos temas pela fora de trabalho e outros pblicosalvo da comunicao.</li></ul>',NULL,'<ol><li>Os outros pblicos mencionados nesta questo abrangem, quando aplicvel, partes interessadas pertinentes e redes importantes, conforme o tema comunicado.</li></ol>'),
	(1160,222,'e','<p>Como so estabelecidos os principais padres para os processos gerenciais e como  verificado o seu cumprimento?</p>','<ul><li>Destacar a forma de implementar as aes corretivas.</li></ul>',NULL,'<ol><li>Os padres para os processos gerenciais, tambm chamados de padres gerenciais, determinam o funcionamento das prticas de gesto adotadas pela organizao para atender aos processos gerenciais requeridos.</li><li>A verificao do cumprimento dos padres gerenciais faz parte do ciclo de controle que integra o PDCL, preconizado pelo Diagrama do Ciclo da Gesto (Captulo 1).</li></ol>'),
	(1161,222,'f','<p>Como os processos gerenciais so aperfeioados?</p>','<ul><li>Destacar a forma de promover melhorias nos processos gerenciais por meio do aprendizado e da inovao.</li></ul>',NULL,'<ol><li>O aperfeioamento dos processos gerenciais faz parte do ciclo de aprendizado que integra o PDCL, preconizado pelo Diagrama do Ciclo da Gesto (Captulo 1).</li><li>Melhorias e inovaes recentes introduzidas no sistema de gesto da organizao devem ser exemplificadas, sempre que possvel, ao longo da descrio das prticas de gesto relativas aos processos gerenciais solicitados nos critrios de 1 a 7, a fim de evidenciar o aprendizado.</li></ol>'),
	(1162,222,'g','<p>Como so obtidas e utilizadas as informaes sobre boas prticas de gesto de organizaes de referncia?</p>','<ul><li>Destacar os critrios de seleo das organizaes de referncia.</li></ul>','<ul><li>Citar as principais melhorias recentes implementadas nos processos gerenciais, em decorrncia da utilizao das boas prticas obtidas.</li></ul>','<ol><li>A busca e a incorporao das boas prticas de gesto fazem parte do ciclo de aprendizado que integra o PDCL, preconizado pelo Diagrama do Ciclo da Gesto (Captulo 1).</li><li>As organizaes de referncia incluem aquelas de dentro e de fora do ramo ou setor de atuao da organizao.</li><li>Melhorias introduzidas no sistema de gesto da organizao, em consequncia da investigao de boas prticas de outras organizaes, tambm devem ser citadas, sempre que possvel, ao longo da descrio das prticas de gesto relativas aos processos gerenciais solicitados nos Critrios de 1 a 7, a fim de evidenciar a utilizao das boas prticas de gesto obtidas.</li></ol>'),
	(1163,223,'a','<p>Como so estabelecidas as diretrizes que a organizao deve observar?</p>','<ul><li>Destacar o envolvimento dos controladores da organizao na definio das diretrizes.</li></ul>',NULL,'<ol><li>As diretrizes que a organizao deve observar, alm das exigncias legais e regulamentares, so aquelas utilizadas pelos controladores para definir limites e orientar a atuao dos administradores e da fora de trabalho na tomada de deciso. Podem incluir, por exemplo, regras estatutrias, polticas, clusulas de contratos de gesto, regulamentos corporativos e compromissos estabelecidos com partes interessadas ou redes importantes.</li></ol>'),
	(1164,223,'b','<p>Como  assegurada a conformidade da organizao com os requisitos legais e regulamentares aplicveis e com as diretrizes estabelecidas?</p>','<ul><li>Destacar as formas utilizadas para prevenir e investigar desvios e implementar aes corretivas quando necessrio;</li><li>Destacar o envolvimento dos controladores da organizao na verificao da conformidade;</li><li>Destacar a forma de assegurar a independncia dos mecanismos de verificao de conformidade.</li></ul>',NULL,'<ol><li>Os requisitos legais e regulamentares aplicveis, explicitados pela sociedade em geral, devem considerar as regies de atuao e so identificados por meio do processo solicitado em 4.1A.</li></ol>'),
	(1165,223,'c','<p>Como so identificados e tratados<br />os riscos aos quais a organizao<br />est sujeita?</p>','<ul><li>Destacar a forma de classificar, definir a relevncia e<br />monitorar os riscos.</li></ul>',NULL,'<ol><li>Os riscos aos quais a organizao est sujeita so aqueles que ameaam a consecuo dos objetivos estratgicos e do negcio  luz das incertezas do mercado e do setor de atuao da organizao, do ambiente macroeconmico e dos prprios processos da organizao.</li><li>A identificao de riscos deve considerar tambm aqueles que possam vir a afetar as demonstraes financeiras da organizao e aqueles associados a dificuldades criadas por organizaes, pessoas ou redes, cujos interesses se opem aos da organizao, como por exemplo: concorrncia desleal ou hostil; organizaes antiticas ou irresponsveis; crime organizado; fornecedores ou clientes com m-f e outras.</li><li>Os riscos aos quais a organizao est sujeita podem ser classificados em funo da sua origem ou tipo - por exemplo, risco de sade e segurana, risco ambiental, risco financeiro, risco legal, risco do negcio, risco tecnolgico, risco operacional e risco regulatrio, entre outros.</li><li>Os riscos aos quais a organizao est sujeita podem ter sua relevncia definida pela combinao da probabilidade de ocorrncia, da intensidade do impacto e da tendncia de agravamento ao longo do tempo.</li><li>A forma de tratamento pode incluir a aceitao da exposio atual.</li></ol>'),
	(1166,223,'d','<p>Como as principais decises so tomadas, comunicadas aos envolvidos e implementadas?</p>','<ul><li>Destacar a forma de assegurar transparncia e envolvimento dos principais interessados nos temas tratados;</li><li>Destacar o papel dos administradores na tomada de deciso;</li><li>Destacar a forma utilizada para adequar a comunicao a cada tipo de pblico envolvido;</li><li>Destacar de que maneira os sistemas de informao proporcionam agilidade na tomada de deciso em todos os nveis da organizao.</li></ul>',NULL,'<ol><li>A tomada de deciso abrange os mtodos coordenados para deliberar e decidir direes a seguir e aes a realizar, desde o nvel de governana at o nvel operacional, em alinhamento s estratgias e objetivos da organizao.</li><li>A comunicao deve ser adequada a cada tipo de pblico envolvido, em funo das decises tomadas.</li><li>A implementao das decises contempla as formas de organizar as aes necessrias e de seu acompanhamento.</li><li>O apoio de sistemas de informao propicia a deciso com base em indicadores de desempenho extrados das bases de dados e em mecanismos de alerta antecipado, que detectam situaes anmalas ou fora do padro esperado e alertam preventivamente as reas e nveis de tomada de deciso pertinentes sobre tais situaes e sua evoluo.</li></ol>'),
	(1167,223,'e','<p>Como os fatos importantes so prontamente comunicados  sociedade e s demais partes interessadas?</p>','<ul><li>Destacar os critrios utilizados para definio do tipo de fato que deve ser considerado importante para ser comunicado.</li></ul>',NULL,'<ol><li>O tipo de fato importante pode variar de acordo com a parte interessada e a natureza do impacto sobre a mesma.</li><li>Podem ser considerados fatos importantes a serem comunicados, especificamente  sociedade, os impactos sociais e ambientais dos produtos, processos e instalaes, assim como as polticas, as aes e os resultados relativos  responsabilidade socioambiental.</li></ol>'),
	(1168,223,'f','<p>Como a direo presta contas das suas aes e resultados alcanados aos controladores da organizao e s demais partes interessadas relevantes?</p>','<ul><li>Destacar a forma utilizada para assegurar a autenticidade e suficincia das informaes relativas  prestao de contas;</li><li>Destacar os mtodos utilizados para controlar os atos da direo.</li></ul>',NULL,'<ol><li>A composio nominal da direo da organizao, incluindo as principais lideranas,  requerida no Perfil P5(1) - Estrutura organizacional.</li><li>O controle sobre os atos da direo visa verificar se esses esto ocorrendo de acordo com os limites de delegao pr-estabelecidos em estatutos, contratos de gesto, definies de nveis de alada ou documentos afins.</li></ol>'),
	(1169,224,'a','<p>Como so identificadas as partes interessadas relevantes e como so conhecidos os seus interesses?</p>','<ul><li>Destacar o critrio utilizado para definio das partes interessadas relevantes;</li><li>Destacar a forma de proteger os direitos das partes interessadas relevantes;</li><li>Destacar a forma de assegurar a equidade entre scios, mantenedores ou instituidores.</li></ul>',NULL,'<ol><li>As partes interessadas relevantes so aquelas cujas necessidades e expectativas ou interesses devem ser identificadas e compreendidas plenamente.</li><li>O levantamento dos interesses das partes interessadas relevantes e a proteo de seus direitos visam maximizar a sua satisfao de forma equilibrada e a sustentabilidade da organizao.</li><li>As principais partes interessadas e respectivas necessidades e expectativas so requeridas no Perfil P1C(1).</li></ol>'),
	(1170,224,'b','<p>Como as necessidades e expectativas dos controladores e demais partes interessadas no tradicionais so identificadas, analisadas e traduzidas em requisitos de desempenho?</p>',NULL,'<ul><li>Apresentar os principais requisitos e respectivos indicadores de desempenho associados aos controladores e demais partes interessadas no tradicionais.</li></ul>','<ol><li>As partes interessadas no tradicionais no incluem clientes, sociedade, fora de trabalho e fornecedores. A identificao das necessidades e expectativas dessas ltimas, bem como a traduo em requisitos de desempenho,  solicitada, respectivamente, nos itens 3.1B, 4.2A, 6.3B e 7.2B.</li></ol>'),
	(1171,224,'c','<p>Como so identificadas e desenvolvidas redes de organizaes ou de pessoas que possam influenciar no xito das estratgias e no alcance sustentado dos objetivos da organizao?</p>','<ul><li>Destacar a forma de atuao da organizao nas redes importantes que a beneficiam ou prejudicam.</li></ul>',NULL,'<ol><li>A identificao de redes deve abranger as atuais e potenciais, dentro ou que envolvem a organizao, e que ela julgue ser as mais importantes para se relacionar, fomentar, formar ou delas se proteger.</li><li>Exemplos de redes que envolvem a organizao incluem as redes associativas, de produtores, de clientes, de usurios, de fornecedores, de parceiros, de distribuidores, de consumidores, de apoiadores, sociais e outras, formais ou informais.</li><li>Exemplos de redes que atuam dentro da organizao incluem as redes de especialistas, de facilitadores, de comunicadores, de usurios, de apoio mtuo, de reas afins e outras, formais e informais.</li></ol>'),
	(1172,224,'d','<p>Como a direo exerce a liderana e interage com as demais partes interessadas e redes mais importantes?</p>','<ul><li>Destacar de que forma a direo exerce sua liderana junto  fora de trabalho.</li></ul>','<ul><li>Citar os objetivos das principais interaes realizadas com as partes interessadas e redes mais importantes.</li></ul>','<ol><li>O exerccio da liderana e a interao com as partes interessadas e redes mais importantes visam engajar pessoas e organizaes, promovendo o alinhamento de interesses e buscando apoio para o xito das estratgias e o alcance sustentado dos objetivos da organizao. Visam tambm harmonizar os interesses das partes interessadas, buscando a sua satisfao.</li><li>O exerccio da liderana e a interao com partes interessadas e redes mais importantes podem incluir aquelas realizadas por intermdio da estrutura de liderana adotada.</li></ol>'),
	(1173,225,'a','<p>Como so selecionados os indicadores e demais informaes que sero utilizados na anlise, pela direo, do desempenho estratgico e operacional da organizao?</p>','<ul><li>Destacar os critrios utilizados para a seleo dos indicadores de desempenho e demais informaes utilizadas na anlise do desempenho estratgico e operacional.</li></ul>',NULL,'<ol><li>O desempenho operacional refere-se ao desempenho dos processos da cadeia de valor citados no Perfil P1B(2).</li></ol>'),
	(1174,225,'b','<p>Como so identificados e obtidos os referenciais comparativos necessrios para analisar a competitividade da organizao?</p>','<ul><li>Destacar os critrios utilizados para definir quais so os resultados mais importantes a serem comparados;</li><li>Destacar os critrios utilizados para definir a pertinncia de referenciais comparativos utilizados pela organizao.</li></ul>',NULL,'<ol><li>Os referenciais comparativos so aqueles necessrios para apoiar a anlise da competitividade da organizao, tanto no mbito operacional quanto no estratgico.</li><li>A obteno dos referenciais comparativos, no mercado ou setor de atuao, pode abranger a regio de atuao da organizao ou, quando se desejar conhecer os nveis dos melhores da classe, as regies onde o setor  mais desenvolvido ou o mundo inteiro.</li><li>As identificaes dos referenciais comparativos, utilizados na demonstrao de resultados no Critrio 8, devem ser coerentes com os critrios de definio de sua pertinncia aqui informados. Para identificar o referencial comparativo utilizado, deve ser informada na demonstrao de resultados, no Critrio 8, a caracterstica ou tipo de mdia relevante, do setor ou mercado, para avaliar a competitividade; nome dos concorrentes; nome da organizao de referncia; nome de ndice ou taxa referencial ou outros.</li></ol>'),
	(1175,225,'c','<p>Como a direo analisa o desempenho estratgico e operacional da organizao?</p>','<ul><li>Destacar as tcnicas utilizadas para agregao e anlise dos resultados, incluindo a forma de utilizao das variveis do ambiente interno e externo para contextualizar a anlise e tomada de deciso;</li><li>Destacar as formas de utilizao, na avaliao do desempenho, de metas, referenciais comparativos e principais requisitos de partes interessadas.</li></ul>',NULL,'<ol><li>O desempenho operacional refere-se ao desempenho dos processos da cadeia de valor citados no Perfil P1B (2).</li><li>Na apresentao de resultados no Critrio 8, que expressem os principais requisitos de partes interessadas, coerentes com as suas necessidades e expectativas mencionadas ao longo do Perfil, deve-se demonstrar que esses requisitos estejam sendo atendidos.</li></ol>'),
	(1176,225,'d','<p>Como  acompanhada a implementao das decises decorrentes da anlise do desempenho da organizao?</p>','<ul><li>Destacar a forma utilizada pela direo para acompanhar a implementao das decises.</li></ul>',NULL,NULL),
	(1177,226,'a','<p>Como  analisado o macroambiente de atuao da organizao e suas tendncias?</p>',NULL,'<ul><li>Citar as principais informaes utilizadas e as respectivas fontes.</li></ul>','<ol><li>A anlise do macroambiente abrange a investigao de foras impulsoras e restritivas, atuais e emergentes, decorrentes de aspectos conjunturais das regies de atuao, tais como sociais, polticos, legais, econmicos e tecnolgicos.</li></ol>'),
	(1178,226,'b','<p>Como so analisadas as caractersticas do setor de atuao da organizao e suas tendncias?</p>','<ul><li>Destacar de que forma os benefcios ou dificuldades associadas s redes importantes para a organizao so consideradas na anlise;</li><li>Destacar de que forma as tecnologias relevantes necessrias para o negcio so identificadas e avaliadas.</li></ul>','<ul><li>Citar as principais informaes utilizadas e as respectivas fontes.</li></ul>','<ol><li>A anlise das caractersticas do setor de atuao engloba a investigao de foras impulsoras e restritivas, atuais e emergentes, decorrentes de aspectos relativos ao ambiente operacional da organizao, inerentes ao seu ramo, tais como as caracterstica dos principais produtores da cadeia, incluindo foras concorrenciais e seus diferenciais competitivos, dos formadores de opinio e influenciadores setoriais, e foras atuantes no setor como um todo.</li><li>As tecnologias relevantes mencionadas nesta questo so aquelas necessrias para o bom desempenho de todos os processos da cadeia de valor, bem como dos processos gerenciais.</li></ol>'),
	(1179,226,'c','<p>Como so analisados os mercados de atuao da organizao e suas tendncias?</p>',NULL,'<ul><li>Citar as principais informaes utilizadas e as respectivas fontes.</li></ul>','<ol><li>A anlise dos mercados de atuao abrange a investigao de foras impulsoras e restritivas, atuais e emergentes, relativas  competio por clientes, oportunidades e recursos, tais como o mercado-alvo de colocao de produtos, o mercado de trabalho, o mercado financeiro e de capitais, o mercado de fornecimento, o mercado de atuao socioambiental.</li></ol>'),
	(1180,226,'d','<p>Como so identificados e avaliados os ativos intangveis mais importantes para a organizao?</p>','<ul><li>Destacar os critrios utilizados para definio dos ativos intangveis mais importantes para a organizao;</li><li>Destacar de que forma os ativos intangveis mais importantes so desenvolvidos;</li><li>Destacar a maneira de proteger os ativos intangveis mais importantes.</li></ul>','<ul><li>Citar os ativos intangveis mais importantes.</li></ul>','<ol><li>Os ativos intangveis mais importantes para a organizao so aqueles que mais agregam valor ao negcio, gerando diferenciais competitivos para a organizao;</li><li>O desenvolvimento dos ativos intangveis marca, conhecimento e tecnologia  abordado, respectivamente, nos itens 3.1C, 5.2B e 7.1G, no precisando ser abordado nesse Item.</li></ol>'),
	(1181,226,'e','<p>Como  analisado o ambiente interno da organizao?</p>','<ul><li>Destacar de que forma as informaes sobre os riscos aos quais a organizao est sujeita, os elementos culturais a serem desenvolvidos e as competncias essenciais so considerados na anlise.</li></ul>',NULL,'<ol><li>Os riscos aos quais a organizao est sujeita so geridos em 1.2C.</li></ol>'),
	(1182,226,'f','<p>Como so avaliadas as alternativas decorrentes da anlise estratgica e definidas as estratgias a serem adotadas pela organizao?</p>','<ul><li>Destacar de que forma os requisitos das partes interessadas, bem como o desenvolvimento sustentvel, so considerados e inseridos nas estratgias;</li><li>Destacar de que forma a tecnologia da informao  utilizada para alavancar o negcio.</li></ul>','<ul><li>Apresentar as principais estratgias e objetivos da organizao.</li></ul>','<ol><li>O desenvolvimento sustentvel nesta questo engloba tambm o bem-estar da sociedade e a preservao e melhoria do meio ambiente.</li></ol>'),
	(1183,226,'g','<p>Como  avaliado o modelo de negcio em consonncia com a definio das estratgias?</p>','<ul><li>Destacar de que forma so considerados a entrada e a sada em negcios e mercados, o desenvolvimento de novas linhas de produtos ou sua retirada do mercado, o estabelecimento de parcerias e a reorganizao dos processos da cadeia de valor.</li></ul>',NULL,'<ol><li>A avaliao do modelo de negcio visa potencializar o xito das estratgias.</li></ol>'),
	(1184,227,'a','<p>Como so definidos os indicadores para a avaliao do xito das estratgias, estabelecidas as metas de curto e longo prazos e definidos os respectivos planos de ao?</p>','<ul><li>Destacar de que forma os referenciais comparativos e os requisitos de partes interessadas so utilizados para a definio de metas.</li></ul>','<ul><li>Apresentar os principais indicadores, suas metas e principais aes planejadas ou projetos, relativos  implementao das estratgias.</li></ul>','<ol><li>Os planos de ao so tambm conhecidos como projetos estratgicos.</li><li>Os resultados dos indicadores citados nesta questo devem ser apresentados no Critrio 8, exceto os relativos aos indicadores em incio de uso, que no sejam comparveis e no expressem requisitos de partes interessadas.</li></ol>'),
	(1185,227,'b','<p>Como as metas e os planos de ao so desdobrados nas reas responsveis pelos processos da cadeia de valor?</p>','<ul><li>Destacar a forma de assegurar a coerncia das metas e dos planos desdobrados com as estratgias, e tambm entre si, mantendo o alinhamento entre os indicadores utilizados na avaliao do desempenho estratgico e aqueles utilizados na avaliao do desempenho operacional;</li><li>Destacar de que forma os planos de ao so desdobrados para os parceiros, quando aplicvel.</li></ul>',NULL,'<ol><li>Os processos da cadeia de valor so aqueles citados no Perfil P1B(2).</li><li>Os nveis de desempenho ou melhorias esperadas, que expressam os principais requisitos de partes interessadas, mencionados em 2.2a, utilizados ou no para estabelecer metas para os indicadores de avaliao da implementao das estratgias, devem ser apresentados no Critrio 8, juntamente com os indicadores pertinentes.</li><li>O desdobramento das metas e planos de ao deve abranger todas as reas e nveis da organizao.</li></ol>'),
	(1186,227,'c','<p>Como os recursos para a implementao dos planos de ao so alocados?</p>',NULL,NULL,'<ol><li>A alocao de recursos visa assegurar a implementao dos planos de ao que sustentam as estratgias.</li><li>Os recursos para assegurar a implementao dos planos de ao que sustentam as estratgias podem abranger os financeiros, humanos, materiais, tecnolgicos, de capacidade produtiva ou de gesto, informao, conhecimento e outros.</li><li>A definio dos recursos financeiros e investimentos tambm  requerida em 7.3C.</li></ol>'),
	(1187,227,'d','<p>Como a implementao dos planos de ao  acompanhada?</p>','<ul><li>Destacar a maneira utilizada pela direo para acompanhar a situao da implementao dos planos de ao de forma integrada.</li></ul>',NULL,NULL),
	(1188,228,'a','<p>Como a organizao analisa e segmenta seu mercado atual e potencial, e define os clientes-alvo para seus produtos?</p>','<ul><li>Destacar os critrios adotados para segmentao do mercado e para definio de clientes-alvo.</li></ul>',NULL,'<ol><li>Os principais segmentos de mercado e clientes-alvo da organizao so requeridos no Perfil P1D(3).</li></ol>'),
	(1189,228,'b','<p>Como as necessidades, expectativas e comportamentos dos clientes atuais e dos clientes-alvo, e suas tendncias, so identificados, analisados e traduzidos em requisitos de desempenho, e como so utilizados para definio e melhoria dos produtos e processos da organizao?</p>','<ul><li>Destacar os mtodos utilizados para definir a importncia relativa das necessidades, expectativas e comportamentos identificados;</li><li>Destacar de que forma a organizao se antecipa s necessidades, expectativas e comportamentos de clientes atuais e potenciais;</li><li>Destacar de que forma a organizao atua em rede para ampliar o conhecimento sobre os clientes-alvo.</li></ul>','<ul><li>Apresentar os principais requisitos e respectivos indicadores de desempenho relativos aos clientes e mercados.</li></ul>','<ol><li>As principais necessidades e expectativas dos clientes so requeridas no Perfil P1C(1).</li></ol>'),
	(1190,228,'c','<p>Como as marcas so desenvolvidas no mercado?</p>','<ul><li>Destacar a forma de monitoramento, proteo e divulgao das marcas;</li><li>Destacar os mtodos utilizados para avaliar os nveis de conhecimento dos clientes e mercados a respeito das marcas.</li></ul>',NULL,'<ol><li>O desenvolvimento das marcas tem o propsito de criar credibilidade, confiana e imagem positiva.</li><li>As marcas podem incluir tanto as institucionais como as relacionadas a produtos.</li></ol>'),
	(1191,228,'d','<p>Como os produtos, incluindo os cuidados necessrios ao seu uso e os riscos envolvidos, e tambm as aes de melhoria da organizao so divulgados aos clientes e ao mercado?</p>','<ul><li>Destacar de que forma so asseguradas a clareza, a autenticidade e o contedo adequado das mensagens divulgadas;</li><li>Destacar os mtodos utilizados para avaliar os nveis de conhecimento dos clientes e mercados a respeito dos seus produtos e aes.</li></ul>',NULL,'<ol><li>A divulgao dos produtos e de outras informaes importantes aos clientes e ao mercado visa assegurar que eles tenham pleno conhecimento da organizao, assim como criar credibilidade, confiana e imagem positiva.</li></ol>'),
	(1192,228,'e','<p>Como  avaliada a imagem da organizao perante os clientes e mercados?</p>','<ul><li>Destacar a forma de definio dos atributos que se deseja evidenciar para caracterizar a imagem da organizao.</li></ul>','<ul><li>Citar os atributos que se deseja evidenciar para caracterizar a imagem da organizao;</li><li>Apresentar as principais aes implementadas para consolidar esses atributos.</li></ul>','<ol><li>A imagem da organizao deve ser avaliada para verificar se os atributos que se deseja evidenciar esto sendo percebidos pelos clientes e mercados-alvo.</li><li>As principais aes para consolidar os atributos que caracterizam a imagem podem ser implementadas pela prpria organizao ou por meio de parcerias.</li></ol>'),
	(1193,229,'a','<p>Como so estabelecidos, divulgados e monitorados os canais de interao com os clientes, considerando a segmentao do mercado e a definio dos clientes-alvo?</p>','<ul><li>Destacar os principais mecanismos ou canais de interao com os clientes.</li></ul>',NULL,'<ol><li>Mencionar, quando aplicvel, tambm os canais de relacionamento estabelecidos via parceiros, como distribuidores, revendedores, representantes e afins, para receber solicitaes, reclamaes e sugestes.</li></ol>'),
	(1194,229,'b','<p>Como so tratadas as solicitaes, reclamaes ou sugestes, formais ou informais, dos clientes?</p>','<ul><li>Destacar a forma utilizada para comunicar aos clientes o resultado da anlise dessas manifestaes e as respectivas aes implementadas, bem como para repassar essas informaes a outras reas da organizao e, quando aplicvel, aos parceiros.</li></ul>',NULL,'<ol><li>O tratamento adequado das manifestaes dos clientes visa assegurar que elas sejam pronta e eficazmente atendidas ou solucionadas.</li><li>O monitoramento das reclamaes  importante para avaliar a insatisfao dos clientes.</li></ol>'),
	(1195,229,'c','<p>Como so acompanhadas as transaes com os clientes, incluindo os novos, e a insero de novos produtos no mercado?</p>',NULL,NULL,'<ol><li>O acompanhamento das transaes com os clientes atuais e clientes novos visa permitir  organizao gerar solues rpidas e eficazes, evitar problemas de relacionamento e atender s expectativas dos clientes. Com o mesmo objetivo, a organizao deve acompanhar a qualidade, desempenho, aceitao, por exemplo, dos novos produtos inseridos no mercado e entregues aos clientes.</li></ol>'),
	(1196,229,'d','<p>Como so avaliadas a satisfao, a fidelidade e a insatisfao dos clientes?</p>','<ul><li>Destacar as formas utilizadas para avaliar a satisfao, a fidelidade e a insatisfao dos clientes em relao aos clientes dos concorrentes ou de organizaes de referncia.</li></ul>',NULL,'<ol><li>A avaliao comparativa em relao aos clientes e organizaes de referncia deve ser realizada quando no h concorrentes.</li></ol>'),
	(1197,229,'e','<p>Como as informaes obtidas dos clientes so analisadas e utilizadas?</p>',NULL,NULL,'<ul><li>A utilizao eficaz das informaes obtidas dos clientes possibilita intensificar a sua satisfao, torn-los fiis e incentiv-los a recomendar os produtos da organizao. Alm disso, as informaes representam importantes subsdios para desenvolver processos e produtos.</li></ul>'),
	(1198,229,'f','<p>Como so identificadas e desenvolvidas parcerias com clientes, distribuidores, representantes ou revendedores?</p>','<ul><li>Destacar as formas de desenvolvimento de redes de clientes ou usurios, distribuidores, representantes ou revendedores, bem como as formas de avaliao do seu desempenho.</li></ul>',NULL,'<ol><li>As parcerias com clientes, distribuidores, representantes ou revendedores visam  manuteno ou ao aumento da competitividade da organizao.</li><li>Os distribuidores, representantes ou revendedores so requeridos no Perfil P1D(3), e as parcerias desenvolvidas so requeridas no Perfil P1D(6).</li></ol>'),
	(1199,230,'a','<p>Como as leis, regulamentos e normas ou cdigos de adeso voluntria, aplicveis  organizao, so identificados, analisados e traduzidos em requisitos de desempenho?</p>','<ul><li>Destacar de que forma  assegurado o pleno atendimento aos requisitos relativos s leis, regulamentos e normas ou cdigos de adeso voluntria;</li><li>Destacar de que maneira so tratadas as pendncias ou eventuais sanes relativas aos requisitos associados a leis e regulamentos aplicveis  organizao. No caso de inexistncia, declarar formalmente a situao.</li></ul>','<ul><li>Apresentar os principais requisitos e respectivos indicadores de desempenho relativos  sociedade e relativos s leis, regulamentos e normas ou cdigos de adeso voluntria.</li></ul>','<ol><li>As leis, regulamentos e normas ou cdigos de adeso voluntria, aplicveis  organizao, representam necessidades e expectativas da sociedade em geral em relao  organizao.</li><li>As normas e cdigos de adeso voluntria incluem aqueles pactuados por entes da sociedade e podem ser utilizados para o desenvolvimento dos padres gerenciais em 1.1E. Podem abranger tanto os que possuem mecanismos de verificao independente ou por autocompromisso.</li></ol>'),
	(1200,230,'b','<p>Como a organizao identifica os aspectos e trata os impactos sociais e ambientais adversos decorrentes de seus produtos, processos e instalaes?</p>',NULL,'<ul><li>Apresentar as principais aes e metas para eliminar, minimizar ou compensar os impactos sociais e ambientais negativos, incluindo o tratamento dos passivos sociais e ambientais.</li></ul>','<ol><li>Os aspectos e impactos adversos so aqueles que a organizao tem influncia e devem ser considerados ao longo do ciclo de vida do produto, desde o projeto at a disposio final ou reutilizao.</li><li>Entre os impactos sociais, incluem-se aqueles relativos a segurana, sade e qualidade de vida dos usurios e da populao em geral, que possam advir dos produtos, processos e instalaes da organizao.</li><li>Os principais impactos sociais e ambientais adversos, existentes e potenciais, bem como os passivos ambientais, se existirem, so requeridos no Perfil P1D(5).</li></ol>'),
	(1201,230,'c','<p>Como a organizao mantm-se preparada para prevenir acidentes e responder s eventuais situaes de emergncia?</p>','<ul><li>Destacar de que forma os acidentes, incidentes e ensaios de situaes de emergncia so analisados, investigados e documentados.</li></ul>',NULL,'<ol><li>A preveno de acidentes deve abranger os relativos  sociedade e ao meio ambiente.</li><li>A atuao da organizao de forma preventiva e com prontido visa evitar ou mitigar os seus impactos adversos na sociedade e no meio ambiente, incluindo comunidades potencialmente impactadas.</li></ol>'),
	(1202,230,'d','<p>Como  propiciada a acessibilidade aos produtos, processos, informaes e instalaes da organizao?</p>',NULL,NULL,'<ol><li>Acessibilidade aos processos significa possibilitar que pessoas com necessidades especiais possam exercer atividades produtivas na organizao.</li></ol>'),
	(1203,230,'e','<p>Como a organizao seleciona e promove, de forma voluntria, aes com vistas ao desenvolvimento sustentvel?</p>','<ul><li>Destacar a forma de desenvolver parcerias ou de atuar em rede, conscientizar e envolver as partes interessadas na implementao ou apoio s suas aes e projetos ambientais.</li></ul>','<ul><li>Citar as principais aes implementadas como forma de contribuio para a soluo dos grandes temas mundiais e para a preservao ou recuperao de ecossistemas, incluindo incorporao de tecnologias limpas ou de baixo impacto ambiental;</li><li>Citar as aes efetuadas para a promoo de educao ambiental  sua fora de trabalho, clientes, fornecedores e comunidade, bem como aes para minimizao do consumo de recursos renovveis, conservao de recursos no renovveis na sua forma original, reciclagem e reutilizao de materiais.</li></ul>','<ol><li>As parcerias desenvolvidas so requeridas no Perfil P1D(6).</li><li>So exemplos de grandes temas mundiais: o aquecimento global, a reduo da camada de oznio, as mudanas climticas, a destruio de florestas naturais, o respeito aos direitos humanos, o trabalho infantil ou degradante, a lavagem de dinheiro e trfico de pessoas, a pobreza extrema, a escassez de gua potvel e temas afins.</li></ol>'),
	(1204,231,'a','<p>Como as necessidades e as expectativas de desenvolvimento da sociedade so identificadas, analisadas, traduzidas em requisitos de desempenho e utilizadas para a definio e a melhoria da atuao social da organizao?</p>',NULL,'<ul><li>Apresentar os principais requisitos e respectivos indicadores de desempenho relativos ao desenvolvimento da sociedade.</li></ul>','<ol><li>As principais necessidades e expectativas de desenvolvimento da sociedade relativas a essa questo, alm do cumprimento das leis e regulamentos tratados em 4.1a, so requeridas no Perfil P1C(1).</li></ol>'),
	(1205,231,'b','<p>Como a organizao direciona esforos para o desenvolvimento da sociedade?</p>','<ul><li>Destacar os critrios estabelecidos para a seleo, acompanhamento e avaliao do xito destes projetos sociais;</li><li>Destacar a forma de desenvolver parcerias ou de atuar em rede e envolver partes interessadas na implementao de projetos sociais.</li></ul>','<ul><li>Citar os principais projetos implementados ou apoiados, incluindo aqueles voltados ao desenvolvimento da competitividade e sustentabilidade das organizaes do setor, do local, da regio ou do pas.</li></ul>','<ol><li>Os esforos para o fortalecimento da sociedade incluem a execuo ou apoio a projetos voltados ao desenvolvimento nacional, regional, local ou setorial, em funo do porte e tipo de atividade da organizao.</li><li>As ofertas de vagas para estagirios podem ser consideradas aes de desenvolvimento social.</li><li>As parcerias desenvolvidas so requeridas no Perfil P1D(6).</li></ol>'),
	(1206,231,'c','<p>Como  avaliado o grau de satisfao da sociedade em relao aos projetos sociais da organizao?</p>',NULL,NULL,NULL),
	(1207,231,'d','<p>Como as informaes obtidas da sociedade so analisadas e utilizadas para melhorar a atuao social?</p>',NULL,NULL,'<ol><li>O uso eficaz das informaes obtidas possibilita a intensificao da satisfao da sociedade, bem como o aperfeioamento e o desenvolvimento dos projetos sociais atuais ou futuros.</li></ol>'),
	(1208,231,'e','<p>Como a organizao avalia e zela por sua imagem perante a sociedade?</p>',NULL,NULL,NULL),
	(1209,232,'a','<p>Como so identificadas as necessidades de informaes, e de seu tratamento, para operar e gerenciar a organizao?</p>','<ul><li>Destacar de que forma a organizao responde prontamente s novas demandas por informaes estratgicas e operacionais.</li></ul>',NULL,'<ol><li>As necessidades de informaes para operar a organizao abrangem aquelas que apoiam as operaes dos processos da cadeia de valor.</li><li>As necessidades de informaes para gerenciar a organizao abrangem indicadores de desempenho, situao de planos, projetos e oramentos, relatrios gerenciais, resultados de pesquisas e outras variveis importantes do ambiente, necessrias para apoiar o processo decisrio em todos os nveis e reas da organizao.</li><li>O tratamento de informaes diz respeito ao processamento necessrio para as informaes requeridas se apresentarem ntegras e completas, desde a coleta dos dados de origem.</li></ol>'),
	(1210,232,'b','<p>Como so definidos, desenvolvidos, implantados e melhorados os principais sistemas de informao, considerando as necessidades identificadas?</p>','<ul><li>Destacar de que forma  assegurada a atualizao tecnolgica dos sistemas de informao;</li><li>Destacar a maneira de promover a integrao da organizao com clientes, fornecedores e outras partes interessadas externas, por meio de sistemas de informao.</li></ul>','<ul><li>Citar os principais sistemas de informao em uso e sua finalidade;</li><li>Citar as principais solues adotadas, visando  integrao das informaes, dos sistemas e partes interessadas externas.</li></ul>','<ol><li>Os sistemas de informao podem incluir sistemas no informatizados, visando atender s necessidades de informao e de seu tratamento, como, por exemplo, sistemas de gesto  vista, sistemas de controle visuais, sistema de manuais, sistema de pronturios, sistemas de documentos para operao manual.</li></ol>'),
	(1211,232,'c','<p>Como a infraestrutura para a disponibilizao das informaes aos usurios  compatibilizada com o crescimento do negcio e da demanda por informaes?</p>','<ul><li>Destacar os mtodos utilizados para assegurar o acesso rpido e fcil s informaes pelos usurios;</li><li>Destacar as formas utilizadas para assegurar a continuidade da infraestrutura, para a disponibilizao de informaes em situaes de emergncia;</li><li>Destacar de que forma  avaliada a satisfao dos usurios dos servios de informao e de comunicao, informatizados ou no.</li></ul>',NULL,'<ol><li>A infraestrutura para a disponibilizao das informaes aos usurios inclui a de comunicao.</li><li>Os usurios podem abranger as pessoas da fora de trabalho e integrantes de outras partes interessadas.</li><li>As situaes de emergncia so aquelas que podem causar a interrupo dos servios de informao.</li></ol>'),
	(1212,232,'d','<p>Como a segurana das informaes  mantida?</p>','<ul><li>Destacar os mtodos utilizados para assegurar a atualizao, confidencialidade e integridade das informaes.</li></ul>',NULL,'<ol><li>A confidencialidade pressupe que somente pessoas autorizadas tenham acesso s informaes.</li><li>A integridade trata da salvaguarda da exatido e completeza da informao recebida, armazenada e distribuda, bem como dos mtodos de processamento.</li></ol>'),
	(1213,233,'a','<p>Como a organizao identifica os conhecimentos mais importantes para realizar sua misso e implementar as estratgias?</p>','<ul><li>Destacar as formas utilizadas para classificar os tipos de conhecimento e os critrios para definir os que so mais importantes.</li></ul>','<ul><li>Apresentar as principais fontes de conhecimento utilizadas, internas e externas;</li><li>Citar os tipos de conhecimentos mais importantes para a organizao.</li></ul>','<ol><li>Os conhecimentos da organizao para realizar sua misso podem incluir conhecimentos relativos a clientes e mercados, produtos, processos, tecnologias, pessoas, fornecedores, relacionamentos, articulaes e memria organizacional.</li><li>A classificao dos conhecimentos  importante para definir os seus tipos e propsitos, e fundamental para identificar os conhecimentos mais importantes.</li><li>Os critrios de classificao podem incluir pertinncia, valor, confiabilidade, propsito, redundncia, grau de incerteza ou outros parmetros.</li></ol>'),
	(1214,233,'b','<p>Como a organizao desenvolve os conhecimentos mais importantes?</p>','<ul><li>Destacar de que maneira a organizao cria um ambiente favorvel  busca e gerao de conhecimento;</li><li>Destacar a forma de utilizao de redes de pessoas ou organizaes para apoiar a busca e o desenvolvimento do conhecimento.</li></ul>',NULL,'<ol><li>A busca do conhecimento abrange a pesquisa e apropriao de conhecimento externo  organizao.</li><li>O desenvolvimento do conhecimento pode incluir, alm do treinamento, o estabelecimento de equipes de conhecimento, de melhoria de processos ou de aprendizado, centros de competncia, pesquisa e desenvolvimento, comunidades de prtica, registro de lies aprendidas, fomento  inovao e busca de melhores prticas.</li></ol>'),
	(1215,233,'c','<p>Como os conhecimentos mais importantes so retidos e protegidos?</p>','<ul><li>Destacar as formas utilizadas para armazenar os conhecimentos;</li><li>Destacar os mtodos utilizados para atrair e reter pessoas e parceiros considerados chave e detentores dos conhecimentos mais importantes da organizao.</li></ul>',NULL,'<ol><li>A reteno, necessria para permitir a difuso e a utilizao do conhecimento, pressupe a sua documentao e converso do conhecimento tcito em conhecimento explcito.</li><li>A proteo do conhecimento visa assegurar que o mesmo seja mantido na organizao e que as vantagens competitivas decorrentes do conhecimento possam ser sustentadas.</li></ol>'),
	(1216,233,'d','<p>Como os conhecimentos da organizao so difundidos e utilizados?</p>','<ul><li>Destacar as formas utilizadas para que os conhecimentos retidos possam ser rpida e facilmente acessados e utilizados, onde pertinentes;</li><li>Destacar as formas de compartilhamento do conhecimento, interna e externamente, quando pertinente;</li><li>Destacar a forma de utilizao de redes de pessoas ou organizaes para apoiar a difuso do conhecimento.</li></ul>',NULL,'<ol><li>O conhecimento deve ser difundido s pessoas da fora de trabalho e demais partes interessadas que tenham a necessidade explcita de utiliz-lo.</li></ol>'),
	(1217,234,'a','<p>Como a organizao do trabalho  definida?</p>','<ul><li>Destacar de que forma a organizao do trabalho estimula a resposta rpida e o aprendizado organizacional;</li><li>Destacar de que forma a organizao do trabalho facilita a atuao dos responsveis pelos processos na estrutura organizacional adotada;</li><li>Destacar a autonomia dos diversos nveis da fora de trabalho para definir, gerir e melhorar os processos da organizao e para buscar inovaes;</li><li>Destacar a forma utilizada para planejar o quadrode pessoal e suas responsabilidades, e o critrio utilizado para definir as atividades terceirizadas, quando existirem.</li></ul>',NULL,'<ol><li>A organizao do trabalho em reas, grupos ou estruturas afins deve ser concebida em alinhamento com as competncias requeridas pelo modelo de negcio, estratgias e processos, visando ao alto desempenho e  inovao;</li><li>As caractersticas da organizao do trabalho, para estimular a resposta rpida e o aprendizado, devem incluir a comunicao eficaz entre as pessoas e entre as equipes, inclusive de diferentes localidades e reas, bem como a formao de redes de cooperao.</li></ol>'),
	(1218,234,'b','<p>Como as competncias necessrias para o exerccio pleno das funes pelas pessoas, incluindo lderes, so identificadas?</p>',NULL,'<ul><li>Apresentar as principais competncias identificadas para as pessoas em geral e especificamente para os lderes.</li></ul>','<ol><li>A identificao das competncias  fundamental para a definio dos papis de cada pessoa na organizao, da estrutura de cargos e da organizao do trabalho.</li><li>As principais competncias identificadas a serem apresentadas podem variar em funo dos diferentes grupos de pessoas da fora de trabalho.</li></ol>'),
	(1219,234,'c','<p>Como as pessoas so selecionadas e contratadas, interna e externamente?</p>','<ul><li>Destacar de que maneira  acompanhada, no mercado de trabalho, a disponibilidade de pessoas com as competncias requeridas pela organizao e de que forma  tratada a eventual escassez;</li><li>Destacar de que forma a organizao estimula a incluso de minorias e assegura a no discriminao e a igualdade de oportunidades para todas as pessoas.</li></ul>',NULL,'<ol><li>O acompanhamento da disponibilidade de pessoas com competncias requeridas pela organizao no mercado de trabalho tem por objetivo detectar eventual escassez e tendncias que possam comprometer o xito das estratgias.</li></ol>'),
	(1220,234,'d','<p>Como as pessoas recm-contratadas so preparadas para o exerccio de suas funes e integradas  cultura organizacional?</p>',NULL,NULL,NULL),
	(1221,234,'e','<p>Como o desempenho das pessoas, incluindo lderes, e das equipes  avaliado e como as necessidades de melhoria so acordadas com as pessoas?</p>','<ul><li>Destacar de que forma a avaliao estimula a busca do alto desempenho, o alcance de metas, a cultura da excelncia e o desenvolvimento profissional das pessoas e equipes.</li></ul>',NULL,NULL),
	(1222,234,'f','<p>Como a remunerao, o reconhecimento e os incentivos estimulam a busca do alto desempenho, o alcance de metas e a cultura de excelncia?</p>',NULL,NULL,'<ol><li>O termo &ldquo;reconhecimento&rdquo; abrange a identificao e o reforo de comportamentos de alto desempenho das pessoas.</li><li>O termo &ldquo;incentivo&rdquo; abrange o reforo desses comportamentos, condicionado a nveis de desempenho pr-determinados.</li><li>A identificao de oportunidades de reconhecimento pode incluir a percepo de realizaes ou contribuies extraordinrias das pessoas, o desempenho excepcional ou outros fatores passveis de reconhecimento.</li><li>As condicionantes do incentivo podem abranger alcance de metas, aquisio de conhecimentos, habilidades e competncias ou outros fatores indutores do alto desempenho. O reforo de comportamentos pode incluir premiaes, recompensas ou oportunidades especiais, formais ou informais, individuais ou em grupo.</li></ol>'),
	(1223,235,'a','<p>Como so identificadas as necessidades de capacitao e desenvolvimento das pessoas?</p>','<ul><li>Destacar as formas de participao dos lderes e das prprias pessoas a serem capacitadas e desenvolvidas, na identificao das necessidades.</li></ul>',NULL,'<ol><li>A identificao das necessidades de capacitao e desenvolvimento das pessoas deve abranger o xito de estratgias, a formao da cultura da excelncia e a melhoria do desempenho individual.</li></ol>'),
	(1224,235,'b','<p>Como  concebida a forma de realizao dos programas de capacitao e de desenvolvimento?</p>','<ul><li>Destacar de que forma a concepo dos programas de capacitao e desenvolvimento levam em considerao as necessidades da organizao e das pessoas.</li></ul>','<ul><li>Citar os principais programas, o pblico-alvo, destacando aqueles relacionados ao desenvolvimento de lderes e  formao da cultura da excelncia.</li></ul>',NULL),
	(1225,235,'c','<p>Como so identificados e preparados os novos lderes e os sucessores para os lderes atuais?</p>','<ul><li>Destacar o papel da direo no desenvolvimento de lderes da organizao.</li></ul>',NULL,'<ol><li>A identificao e a preparao de sucessores para os lderes atuais devem abranger todas as funes de liderana.</li></ol>'),
	(1226,235,'d','<p>Como a eficcia dos programas de capacitao e desenvolvimento  avaliada?</p>',NULL,NULL,'<ol><li>A eficcia dos programas de capacitao deve ser avaliada considerando o alcance dos objetivos estratgicos e operacionais da organizao.</li></ol>'),
	(1227,235,'e','<p>Como a organizao promove o desenvolvimento integral das pessoas como indivduos, cidados e profissionais?</p>','<ul><li>Destacar os mtodos de orientao ou aconselhamento, empregabilidade e desenvolvimento de carreira.</li></ul>',NULL,'<ol><li>O desenvolvimento das pessoas como indivduos aborda temas relacionados  melhoria dos comportamentos e atitudes psicossociais que favorecem o trabalho em equipe e o relacionamento interpessoal. Por exemplo: programas de treinamento comportamental, comunicao interpessoal, vivncia em grupo, construo de times, trabalho em equipe, servios de assistncia psicolgica e social, entre outros.</li><li>O desenvolvimento das pessoas como cidados aborda aspectos voltados ao exerccio da tica e cidadania na comunidade. Por exemplo: programas de orientao ou assistncia jurdica, treinamento em direitos do cidado, funcionamento e canais da administrao pblica e da justia, crdito responsvel, estmulo ou apoio ao voluntariado e tica empresarial, entre outros.</li><li>O desenvolvimento das pessoas como profissionais aborda temas que aumentem a competncia, por meio da qualificao em novas habilidades que as tornem mais preparadas profissionalmente, independentemente das funes que exercem. Por exemplo: programas de uso e atualizao em informtica, capacitao em lngua estrangeira, comunicao oral e escrita, uso racional de correio eletrnico, mtodos de anlise e soluo de problemas, apresentaes eficazes, uso eficiente do tempo e trabalho administrativo completo, entre outros.</li></ol>'),
	(1228,236,'a','<p>Como so identificados os perigos e tratados os riscos relacionados  sade ocupacional e  segurana?</p>',NULL,'<ul><li>Citar os principais programas e as metas para eliminar ou minimizar esses riscos.</li></ul>','<ol><li>A sade ocupacional abrange aspectos relativos  ergonomia.</li></ol>'),
	(1229,236,'b','<p>Como as necessidades e expectativas das pessoas da fora de trabalho e do mercado de trabalho so identificadas, analisadas, traduzidas em requisitos de desempenho e utilizadas para o desenvolvimento de polticas e programas de pessoal e de benefcios a elas oferecidos?</p>',NULL,'<ul><li>Apresentar, de forma comparativa com o mercado de trabalho, os principais benefcios oferecidos s pessoas na organizao;</li><li>Apresentar os principais requisitos e respectivos indicadores de desempenho relativos s pessoas da fora de trabalho.</li></ul>','<ol><li>A identificao das necessidades e expectativas do mercado de trabalho tem por objetivo o desenvolvimento de polticas e programas de pessoal e de benefcios que sejam competitivos.</li><li>As principais necessidades e expectativas das pessoas da fora de trabalho so requeridas no Perfil P1C(1).</li><li>Os benefcios oferecidos s pessoas incluem quaisquer servios, facilidades, ambiente de trabalho e outros atrativos valorizados pelas pessoas na manuteno da relao de trabalho com a organizao.</li></ol>'),
	(1230,236,'c','<p>Como o bem-estar, a satisfao e o comprometimento das pessoas so avaliados e desenvolvidos?</p>','<ul><li>Destacar de que forma so tratados, com a participao de lderes dos diversos nveis, os fatores identificados na avaliao que afetam o bem-estar, a satisfao e o comprometimento das pessoas.</li></ul>',NULL,'<ol><li>Os fatores que afetam o bem-estar so aqueles relativos  promoo de um ambiente de trabalho agradvel, tranquilo e equilibrado, no qual as pessoas se sintam bem.</li><li>Os fatores que afetam a satisfao so aqueles relativos ao atendimento de necessidades das pessoas e que determinam sua preferncia em trabalhar para a organizao.</li><li>Os fatores que afetam o comprometimento so aqueles relativos ao compromisso assumido pelas pessoas com suas responsabilidades profissionais e com a causa da organizao.</li></ol>'),
	(1231,236,'d','<p>Como  mantido um clima organizacional favorvel  criatividade,  inovao,  excelncia no desempenho e ao desenvolvimento profissional das pessoas e das equipes?</p>','<ul><li>Destacar as formas utilizadas para mobilizar as pessoas em torno da explorao de ideias criativas, buscando inovaes.</li></ul>',NULL,'<ol><li>Podem ser citadas caractersticas especiais das instalaes e do ambiente, ferramentas de trabalho, servios e outros aspectos voltados  promoo do bem-estar, satisfao e comprometimento.</li></ol>'),
	(1232,236,'e','<p>Como a organizao promove a melhoria da qualidade de vida das pessoas fora do ambiente de trabalho?</p>',NULL,'<ul><li>Citar as principais aes desenvolvidas.</li></ul>','<ol><li>A promoo da qualidade de vida fora do ambiente de trabalho aborda temas relacionados  sade fsica e mental das pessoas, e aos servios de apoio operacional que facilitam o seu dia a dia. Por exemplo: programas de bons hbitos alimentares, promoo da sade total, segurana domstica e manuteno domstica, conduo segura, segurana pblica, primeiros socorros, economia domstica e servios de orientao desportiva, grmio ou clube familiar, creche, transporte, acesso  internet e uso da telefonia, entre outros.</li></ol>'),
	(1233,237,'a','<p>Como so definidos os requisitos aplicveis aos produtos e aos processos da cadeia de valor?</p>','<ul><li>Destacar os mtodos utilizados para traduzir os requisitos dos clientes e de outras partes interessadas em requisitos para os processos e produtos.</li></ul>','<ul><li>Apresentar os principais requisitos relativos aos produtos e processos da cadeia de valor a serem atendidos e os respectivos indicadores de desempenho.</li></ul>','<ol><li>Os requisitos dos produtos e processos devem levar em considerao os requisitos dos clientes, da sociedade e de outras partes interessadas aplicveis.</li></ol>'),
	(1234,237,'b','<p>Como so desenvolvidos os novos produtos?</p>','<ul><li>Destacar as metodologias de projeto utilizadas para desenvolvimento de novos produtos.</li></ul>',NULL,'<ol><li>A expresso &ldquo;novos produtos&rdquo; inclui variaes em produtos existentes.</li><li>Os novos produtos devem ser desenvolvidos para atender aos requisitos dos clientes e de outras partes interessadas.</li></ol>'),
	(1235,237,'c','<p>Como so projetados os processos da cadeia de valor?</p>','<ul><li>Destacar os mtodos adotados para assegurar que o projeto dos processos inclua a definio dos papis, responsabilidades e autoridades dos responsveis pelos processos;</li><li>Destacar as metodologias utilizadas nos projetos, considerando-se os diferentes tipos de processos.</li></ul>',NULL,'<ol><li>Os processos da cadeia de valor devem ser projetados, concebidos ou planejados para atender aos requisitos dos clientes e de outras partes interessadas, e, quando aplicvel, de outros processos da cadeia de valor deles dependentes.</li><li>A utilizao de metodologias, como as de gesto de processos, viabiliza o projeto dos processos de forma estruturada, definindo seus responsveis, &ldquo;donos&rdquo; ou lderes, estabelecendo os objetivos e requisitos de desempenho dos processos de forma transparente, realizando o desdobramento ou mapeamento das atividades que compem cada processo, a anlise de pontos crticos de controle, o estabelecimento dos indicadores mais importantes e suas respectivas metas, alm da distribuio das atividades entre as equipes e outros fatores.</li></ol>'),
	(1236,237,'d','<p>Como  avaliado o potencial de ideias criativas a serem convertidas em inovaes sustentveis nos produtos e processos?</p>',NULL,NULL,'<ol><li>A avaliao do potencial de ideias criativas pode incluir a realizao de experimentos por meio de pilotos, prottipos, modelagem e simulaes.</li><li>As inovaes sustentveis so aquelas concebidas considerando tambm seus potenciais impactos socioambientais.</li></ol>'),
	(1237,237,'e','<p>Como  assegurado o atendimento dos requisitos aplicveis aos processos da cadeia de valor?</p>','<ul><li>Destacar os mtodos de padronizao e controle, incluindo os de autogerenciamento das operaes;</li><li>Destacar a forma de tratamento de eventuais no-conformidades identificadas e de implementao das aes corretivas;</li><li>Destacar de que maneira os sistemas de informao propiciam agilidade e integrao na operao e no autogerenciamento dos processos da cadeia de valor.</li></ul>',NULL,'<ol><li>Os mtodos de autogerenciamento referem-se s atividades de gerenciamento realizadas pelos prprios executantes das operaes, visando ao cumprimento dos padres estabelecidos.</li></ol>'),
	(1238,237,'f','<p>Como a organizao analisa e melhora os produtos e os processos da cadeia de valor?</p>','<ul><li>Destacar os mtodos utilizados para reduzir a variabilidade e aumentar a confiabilidade e a ecoeficincia.</li></ul>','<ul><li>Citar as principais melhorias recentes implementadas em produtos e em processos da cadeia de valor.</li></ul>',NULL),
	(1239,237,'g','<p>Como a organizao avalia, incorpora e implanta as novas tecnologias no desenvolvimento e na melhoria dos produtos e processos da cadeia de valor?</p>',NULL,NULL,'<ol><li>A gesto de novas tecnologias deve ser considerada para que a organizao antecipe tendncias e esteja preparada para os desafios futuros.</li></ol>'),
	(1240,237,'h','<p>Como so investigadas as caractersticas de produtos e de processos da cadeia de valor, de concorrentes ou de outras organizaes de referncia, para buscar melhorias?</p>','<ul><li>Destacar os critrios de seleo das organizaes de referncia e as formas de obteno e utilizao dessas informaes.</li></ul>','<ul><li>Citar as principais melhorias recentes implementadas em produtos e em processos da cadeia de valor em decorrncia dessas comparaes.</li></ul>','<ol><li>Os produtos e processos que so objeto da investigao referem-se queles com finalidade similar ao da organizao.</li><li>As organizaes de referncia incluem aquelas de dentro e de fora do ramo ou setor de atuao da organizao.</li></ol>'),
	(1241,238,'a','<p>Como a organizao desenvolve a sua cadeia de suprimentos imediata e nela identifica potenciais fornecedores e parceiros?</p>','<ul><li>Destacar as formas de estmulo ao desenvolvimento dos fornecedores locais;</li><li>Destacar a atuao da organizao para erradicar o trabalho infantil, degradante ou forado, na cadeia de suprimentos.</li></ul>',NULL,'<ol><li>O desenvolvimento da cadeia visa assegurar a continuidade de fornecimento em longo prazo, melhorar o desempenho, promover o desenvolvimento sustentvel da prpria cadeia e agregar valor ao negcio.</li><li>O desenvolvimento dos fornecedores &ldquo;locais&rdquo; visa promover a sustentabilidade, por meio do desenvolvimento econmico das localidades das instalaes e do comrcio, bem como da reduo de impactos ambientais do transporte de mercadorias e de prestadores de servios.</li><li>Os fornecedores e parceiros mencionados nesta questo so aqueles que esto envolvidos ou que podem vir a se envolver com a cadeia de suprimento da organizao, fornecendo ou podendo vir a fornecer produtos ou prestar servios, direta ou indiretamente, para a organizao, ou atuando em nome dela para os seus clientes.</li></ol>'),
	(1242,238,'b','<p>Como as necessidades e expectativas dos fornecedores so identificadas, analisadas, traduzidas em requisitos de desempenho e utilizadas para a definio e melhoria das polticas e dos programas relativos aos fornecedores?</p>','<p>Destacar os principais mecanismos ou canais de interao com os fornecedores.</p>','<p>Apresentar os principais requisitos do fornecedor a serem atendidos e os respectivos indicadores de desempenho.</p>','<p>As principais necessidades e expectativas dos fornecedores so requeridas no Perfil P1C(1).</p>'),
	(1243,238,'c','<p>Como os fornecedores so qualificados e selecionados?</p>','<ul><li>Destacar os principais critrios utilizados para qualificao e seleo;</li><li>Destacar as formas utilizadas para estabelecer parcerias com fornecedores, conforme aplicvel.</li></ul>',NULL,NULL),
	(1244,238,'d','<p>Como a organizao monitora e avalia o desempenho dos fornecedores, considerando os requisitos de fornecimento?</p>','<ul><li>Destacar as formas de pronta comunicao de eventuais no-conformidades e de solicitao de aes corretivas aos fornecedores.</li></ul>','<ul><li>Apresentar os principais requisitos de fornecimento a serem atendidos pelos fornecedores e os respectivos indicadores de desempenho.</li></ul>','<ol><li>A avaliao e o monitoramento do nvel de desempenho de fornecedores possibilitam tambm a melhoria dos processos de qualificao e seleo.</li></ol>'),
	(1245,238,'e','<p>Como a organizao estimula os seus fornecedores a implementar melhorias, inovaes e otimizao de custos nos seus processos e produtos?</p>',NULL,'<ul><li>Apresentar exemplos de melhorias ou inovaes implantadas pelos fornecedores.</li></ul>',NULL),
	(1246,238,'f','<p>Como a fora de trabalho dos fornecedores, que atuam diretamente nos processos da cadeia de valor da organizao,  comprometida com os valores e princpios organizacionais, incluindo os relativos  responsabilidade socioambiental e  sade e segurana, bem como com as diretrizes a eles aplicveis?</p>','<ul><li>Destacar quais prticas de gesto da organizao so aplicveis a essas pessoas e quais foram desenvolvidas especificamente para elas.</li></ul>',NULL,NULL),
	(1247,239,'a','<p>Como so definidos os requisitos de desempenho econmico-financeiro da organizao e monitorados os aspectos que causam impacto na sustentabilidade econmica do negcio?</p>','<ul><li>Destacar a forma de participao dos scios, mantenedores ou instituidores e dos administradores na definio e monitoramento dos nveis esperados de desempenho econmico-financeiro.</li></ul>','<ul><li>Apresentar os principais requisitos e os respectivos indicadores de desempenho monitorados, incluindo aqueles relativos aos grupos de estrutura, liquidez, atividade e rentabilidade.</li></ul>','<ol><li>Cada organizao, em funo de seu perfil e estratgias, precisa identificar os parmetros financeiros que devem ser controlados. Usualmente, so utilizados indicadores, tais como: 1) Estrutura - endividamento (passivo circulante mais exigvel de longo prazo dividido pelo patrimnio lquido); composio do endividamento (passivo circulante dividido pelo passivo circulante mais exigvel de longo prazo); endividamento oneroso (recursos onerosos divididos pelo passivo circulante mais exigvel de longo prazo); imobilizao (ativo permanente dividido pelo patrimnio lquido); 2) Liquidez - liquidez corrente (ativo circulante dividido pelo passivo circulante); liquidez geral (ativo circulante mais realizvel de longo prazo dividido pelo passivo circulante mais exigvel de longo prazo); 3) Atividade - prazo mdio de recebimento de vendas; prazo mdio de renovao de estoques; prazo mdio do pagamento de compras; ciclo financeiro (prazo mdio de recebimento de vendas mais prazo mdio de renovao de estoques menos prazo mdio do pagamento de compras); e 4) Rentabilidade - giro do ativo (receita lquida dividida pelo ativo); rentabilidade do patrimnio lquido (lucro lquido dividido pelo patrimnio lquido); margem bruta (receita de vendas menos o custo dos produtos vendidos dividido pela receita de vendas); vendas (receita de vendas dividida pela receita de vendas prevista); crescimento da receita (total de vendas no perodo de um ano dividido pelas vendas no ano anterior). Ainda podem ser includos indicadores como: valor econmico agregado (EVA - lucro lquido menos custo de oportunidade do capital empregado); Ebitda; ndice de cobertura das despesas financeiras (Ebitda dividido pelas despesas financeiras).</li></ol>'),
	(1248,239,'b','<p>Como a organizao assegura os recursos financeiros necessrios para atender s necessidades operacionais e manter equilibrado o fluxo financeiro?</p>','<ul><li>Destacar os critrios usados para captao de recursos, concesso de crditos e controle de recebimentos.</li></ul>',NULL,NULL),
	(1249,239,'c','<p>Como a organizao define os recursos financeiros e avalia os investimentos necessrios para apoiar as estratgias e planos de ao?</p>','<ul><li>Destacar os critrios utilizados para definir a forma de captao apropriada.</li></ul>',NULL,NULL),
	(1250,239,'d','<p>Como  elaborado e controlado o oramento?</p>','<ul><li>Destacar a forma utilizada para assegurar o alinhamento entre o oramento e as estratgias e objetivos da organizao.</li></ul>',NULL,'<ol><li>A elaborao e o controle do oramento visam assegurar o atendimento dos nveis esperados de desempenho financeiro.</li></ol>'),
	(1251,240,'a','<p>Apresentar os resultados dos principais indicadores relativos  gesto econmico-financeira.</p>','<ul><li>Classificar os resultados segundo os grupos de estrutura, liquidez, atividade e rentabilidade, conforme aplicvel;</li><li>Estratificar os resultados por unidades ou filiais mais importantes, quando aplicvel.</li></ul>','<ul><li>Para cada indicador apresentado, informar se ele : <ul><li>(E) estratgico, </li><li>(O) operacional; ou </li><li>(E,O) ambos. </li></ul></li><li>Mostrar o sentido de favorabilidade de cada srie histrica: <ul><li>quanto maior, melhor ou; </li><li>quanto menor, melhor ou; </li><li>estabilizao em nvel aceitvel,<ul><li>i.e., nvel suficientemente competitivo ou cumprindo compromisso com requisito de parte interessada, ou ambos, de forma compatvel com as estratgias. </li></ul></li></ul></li><li>Esclarecer por que o sentido da favorabilidade da srie histrica  a estabilizao em nvel aceitvel, quando for o caso. </li><li>Esclarecer eventual piora nos resultados, quando possvel. </li><li>Incluir os referenciais comparativos pertinentes, e a quem se referem, relativos ao ltimo exerccio ou ciclo de avaliao, para indicadores que permitam comparaes a fim de avaliar a competitividade no mercado ou setor de atuao. Esclarecer, quando possvel, nveis de desempenho desfavorveis em relao ao referencial comparativo. </li><li>Incluir os nveis de desempenho ou melhorias esperadas que expressem os principais requisitos de partes interessadas, e a que partes se referem, relativas ao ltimo exerccio ou ciclo de avaliao, para indicadores que so utilizados a fim de avaliar o cumprimento desses requisitos. Esclarecer, quando possvel, o no atendimento a esses requisitos.</li></ul>','<ol><li>Estes resultados referem-se aos indicadores de desempenho dos processos citados em 7.3, assim como os eventuais indicadores econmico-financeiros utilizados para avaliar o atendimento de requisitos de controladores e outras partes interessadas, citados em 1.3c, e a implementao das estratgias, em 2.2a.</li><li>Explicar, resumidamente, o propsito de indicadores cujos nomes no sejam autoexplicativos.</li><li>Os referenciais comparativos pertinentes, que forem apresentados, devem ser compatveis com os padres gerenciais descritos em 1.4a para permitir a avaliao da competitividade.</li><li>A competitividade do resultado em um tema pode ser avaliada por meio de indicadores com referenciais comparativos diferentes daqueles utilizados para avaliar a melhoria no mesmo tema.</li><li>Os nveis de desempenho ou melhorias esperadas, que expressam os principais requisitos de partes interessadas, devem ser compatveis com os padres descritos em 1.3c, 3.1b, 4.1a, 4.2b, 6.3b, 7.1a, 7.2b e 7.3a.</li><li>Podem ser apresentados indicadores, entre os relevantes, sem referencial comparativo pertinente, quando o resultado no for comparvel; e sem requisito de parte interessada, quando no refletir necessidades e expectativas de partes interessadas, se eles forem relevantes para avaliar a melhoria.</li><li>No caso de unidade autnoma, em indicadores cujo levantamento de resultados  realizado somente no nvel corporativo, demonstrar a contribuio da unidade para o resultado alcanado.</li></ol>'),
	(1252,241,'a','<p>Apresentar os resultados dos principais indicadores relativos  responsabilidade socioambiental e ao desenvolvimento social.</p>','<ul><li>Separar os resultados em sociais e ambientais;</li><li>Estratificar os resultados por instalaes ou comunidades mais importantes, conforme aplicvel.</li></ul>','<ul><li>Para cada indicador apresentado, informar se ele : <ul><li>(E) estratgico, </li><li>(O) operacional; ou </li><li>(E,O) ambos. </li></ul></li><li>Mostrar o sentido de favorabilidade de cada srie histrica: <ul><li>quanto maior, melhor ou; </li><li>quanto menor, melhor ou; </li><li>estabilizao em nvel aceitvel,<ul><li>i.e., nvel suficientemente competitivo ou cumprindo compromisso com requisito de parte interessada, ou ambos, de forma compatvel com as estratgias. </li></ul></li></ul></li><li>Esclarecer por que o sentido da favorabilidade da srie histrica  a estabilizao em nvel aceitvel, quando for o caso. </li><li>Esclarecer eventual piora nos resultados, quando possvel. </li><li>Incluir os referenciais comparativos pertinentes, e a quem se referem, relativos ao ltimo exerccio ou ciclo de avaliao, para indicadores que permitam comparaes a fim de avaliar a competitividade no mercado ou setor de atuao. Esclarecer, quando possvel, nveis de desempenho desfavorveis em relao ao referencial comparativo. </li><li>Incluir os nveis de desempenho ou melhorias esperadas que expressem os principais requisitos de partes interessadas, e a que partes se referem, relativas ao ltimo exerccio ou ciclo de avaliao, para indicadores que so utilizados a fim de avaliar o cumprimento desses requisitos. Esclarecer, quando possvel, o no atendimento a esses requisitos.</li></ul>','<ol><li>Estes resultados referem-se aos indicadores de desempenho dos processos citados no Critrio 4, assim como os eventuais indicadores sociais e ambientais utilizados para avaliar o atendimento de requisitos de controladores e outras partes interessadas, citados em 1.3C, e a implementao das estratgias, em 2.2a.</li><li>Explicar, resumidamente, o propsito de indicadores cujos nomes no sejam autoexplicativos.</li><li>Os referenciais comparativos pertinentes, que forem apresentados, devem ser compatveis com os padres gerenciais descritos em 1.4a para permitir a avaliao da competitividade.</li><li>A competitividade do resultado em um tema pode ser avaliada por meio de indicadores com referenciais comparativos diferentes daqueles utilizados para avaliar a melhoria no mesmo tema.</li><li>Os nveis de desempenho ou melhorias esperadas, que expressam os principais requisitos de partes interessadas, devem ser compatveis com os padres descritos em 1.3c, 3.1b, 4.1a, 4.2b, 6.3b, 7.1a, 7.2b e 7.3a.</li><li>Podem ser apresentados indicadores, entre os relevantes, sem referencial comparativo pertinente, quando o resultado no for comparvel; e sem requisito de parte interessada, quando no refletir necessidades e expectativas de partes interessadas, se eles forem relevantes para avaliar a melhoria.</li><li>No caso de unidade autnoma, em indicadores cujo levantamento de resultados  realizado somente no nvel corporativo, demonstrar a contribuio da unidade para o resultado alcanado.</li></ol>'),
	(1253,242,'a','<p>Apresentar os resultados dos principais indicadores relativos aos clientes e aos mercados-alvo, incluindo os referentes  imagem da organizao.</p>','<ul><li>Estratificar os resultados por segmentos de mercado, grupos de clientes ou tipos de produtos mais importantes, conforme aplicvel.</li></ul>','<ul><li>Para cada indicador apresentado, informar se ele : <ul><li>(E) estratgico, </li><li>(O) operacional; ou </li><li>(E,O) ambos. </li></ul></li><li>Mostrar o sentido de favorabilidade de cada srie histrica: <ul><li>quanto maior, melhor ou; </li><li>quanto menor, melhor ou; </li><li>estabilizao em nvel aceitvel,<ul><li>i.e., nvel suficientemente competitivo ou cumprindo compromisso com requisito de parte interessada, ou ambos, de forma compatvel com as estratgias. </li></ul></li></ul></li><li>Esclarecer por que o sentido da favorabilidade da srie histrica  a estabilizao em nvel aceitvel, quando for o caso. </li><li>Esclarecer eventual piora nos resultados, quando possvel. </li><li>Incluir os referenciais comparativos pertinentes, e a quem se referem, relativos ao ltimo exerccio ou ciclo de avaliao, para indicadores que permitam comparaes a fim de avaliar a competitividade no mercado ou setor de atuao. Esclarecer, quando possvel, nveis de desempenho desfavorveis em relao ao referencial comparativo. </li><li>Incluir os nveis de desempenho ou melhorias esperadas que expressem os principais requisitos de partes interessadas, e a que partes se referem, relativas ao ltimo exerccio ou ciclo de avaliao, para indicadores que so utilizados a fim de avaliar o cumprimento desses requisitos. Esclarecer, quando possvel, o no atendimento a esses requisitos.</li></ul>','<ol><li>Estes resultados referem-se aos indicadores de desempenho dos processos citados no Critrio 3, assim como os eventuais indicadores relativos a clientes utilizados para avaliar o atendimento de requisitos de controladores e outras partes interessadas, citados em 1.3C, e a implementao das estratgias, em 2.2a.</li><li>Explicar, resumidamente, o propsito de indicadores cujos nomes no sejam autoexplicativos.</li><li>Os referenciais comparativos pertinentes, que forem apresentados, devem ser compatveis com os padres gerenciais descritos em 1.4a para permitir a avaliao da competitividade.</li><li>A competitividade do resultado em um tema pode ser avaliada por meio de indicadores com referenciais comparativos diferentes daqueles utilizados para avaliar a melhoria no mesmo tema.</li><li>Os nveis de desempenho ou melhorias esperadas, que expressam os principais requisitos de partes interessadas, devem ser compatveis com os padres descritos em 1.3c, 3.1b, 4.1a, 4.2b, 6.3b, 7.1a, 7.2b e 7.3a.</li><li>Podem ser apresentados indicadores, entre os relevantes, sem referencial comparativo pertinente, quando o resultado no for comparvel; e sem requisito de parte interessada, quando no refletir necessidades e expectativas de partes interessadas, se eles forem relevantes para avaliar a melhoria.</li><li>No caso de unidade autnoma, em indicadores cujo levantamento de resultados  realizado somente no nvel corporativo, demonstrar a contribuio da unidade para o resultado alcanado.</li></ol>'),
	(1254,243,'a','<p>Apresentar os resultados dos principais indicadores relativos a pessoas, incluindo os referentes ao sistema de trabalho, capacitao e desenvolvimento e qualidade de vida, bem como os referentes  liderana, comunicao e cultura.</p>','<ul><li>Estratificar os resultados por funes na organizao ou grupos de pessoas da fora de trabalho e, conforme aplicvel, por instalaes mais importantes.</li></ul>','<ul><li>Para cada indicador apresentado, informar se ele : <ul><li>(E) estratgico, </li><li>(O) operacional; ou </li><li>(E,O) ambos. </li></ul></li><li>Mostrar o sentido de favorabilidade de cada srie histrica: <ul><li>quanto maior, melhor ou; </li><li>quanto menor, melhor ou; </li><li>estabilizao em nvel aceitvel,<ul><li>i.e., nvel suficientemente competitivo ou cumprindo compromisso com requisito de parte interessada, ou ambos, de forma compatvel com as estratgias. </li></ul></li></ul></li><li>Esclarecer por que o sentido da favorabilidade da srie histrica  a estabilizao em nvel aceitvel, quando for o caso. </li><li>Esclarecer eventual piora nos resultados, quando possvel. </li><li>Incluir os referenciais comparativos pertinentes, e a quem se referem, relativos ao ltimo exerccio ou ciclo de avaliao, para indicadores que permitam comparaes a fim de avaliar a competitividade no mercado ou setor de atuao. Esclarecer, quando possvel, nveis de desempenho desfavorveis em relao ao referencial comparativo. </li><li>Incluir os nveis de desempenho ou melhorias esperadas que expressem os principais requisitos de partes interessadas, e a que partes se referem, relativas ao ltimo exerccio ou ciclo de avaliao, para indicadores que so utilizados a fim de avaliar o cumprimento desses requisitos. Esclarecer, quando possvel, o no atendimento a esses requisitos.</li></ul>','<ol><li>Estes resultados referem-se aos indicadores de desempenho dos processos citados no Critrio 6, assim como os eventuais indicadores relativos s pessoas utilizados para avaliar o atendimento de requisitos de controladores e outras partes interessadas, citados em 1.2c, e a implementao das estratgias, em 2.2a.</li><li>As funes na organizao podem abranger as funes operacionais, tcnicas, administrativas e de liderana ou outra classificao adotada pela organizao.</li><li>Os grupos de pessoas da fora de trabalho podem abranger os contratados em tempo integral ou parcial, horistas, mensalistas, temporrios, autnomos e contratados de terceiros que trabalham sob coordenao direta da organizao ou outros grupos com gesto diferenciada.</li><li>Explicar, resumidamente, o propsito de indicadores cujos nomes no sejam autoexplicativos.</li><li>Os referenciais comparativos pertinentes, que forem apresentados, devem ser compatveis com os padres gerenciais descritos em 1.4a para permitir a avaliao da competitividade.</li><li>A competitividade do resultado em um tema pode ser avaliada por meio de indicadores com referenciais comparativos diferentes daqueles utilizados para avaliar a melhoria no mesmo tema.</li><li>Os nveis de desempenho ou melhorias esperadas, que expressam os principais requisitos de partes interessadas, devem ser compatveis com os padres descritos em 1.3c, 3.1b, 4.1a, 4.2b, 6.3b, 7.1a, 7.2b e 7.3a.</li><li>Podem ser apresentados indicadores, entre os relevantes, sem referencial comparativo pertinente, quando o resultado no for comparvel; e sem requisito de parte interessada, quando no refletir necessidades e expectativas de partes interessadas, se eles forem relevantes para avaliar a melhoria.</li><li>No caso de unidade autnoma, em indicadores cujo levantamento de resultados  realizado somente no nvel corporativo, demonstrar a contribuio da unidade para o resultado alcanado.</li></ol>'),
	(1255,244,'a','<p>Apresentar os resultados dos principais indicadores relativos a produtos, aos processos da cadeia de valor, a fornecedores e a processos de gesto transversais no relacionados aos demais itens deste Critrio.</p>','<ul><li>Separar os resultados de produtos, de processos da cadeia de valor e relativos a fornecedores mais importantes e, caso haja, os relativos a processos de gesto transversais.</li></ul>','<ul><li>Para cada indicador apresentado, informar se ele : <ul><li>(E) estratgico, </li><li>(O) operacional; ou </li><li>(E,O) ambos. </li></ul></li><li>Mostrar o sentido de favorabilidade de cada srie histrica: <ul><li>quanto maior, melhor ou; </li><li>quanto menor, melhor ou; </li><li>estabilizao em nvel aceitvel,<ul><li>i.e., nvel suficientemente competitivo ou cumprindo compromisso com requisito de parte interessada, ou ambos, de forma compatvel com as estratgias. </li></ul></li></ul></li><li>Esclarecer por que o sentido da favorabilidade da srie histrica  a estabilizao em nvel aceitvel, quando for o caso. </li><li>Esclarecer eventual piora nos resultados, quando possvel. </li><li>Incluir os referenciais comparativos pertinentes, e a quem se referem, relativos ao ltimo exerccio ou ciclo de avaliao, para indicadores que permitam comparaes a fim de avaliar a competitividade no mercado ou setor de atuao. Esclarecer, quando possvel, nveis de desempenho desfavorveis em relao ao referencial comparativo. </li><li>Incluir os nveis de desempenho ou melhorias esperadas que expressem os principais requisitos de partes interessadas, e a que partes se referem, relativas ao ltimo exerccio ou ciclo de avaliao, para indicadores que so utilizados a fim de avaliar o cumprimento desses requisitos. Esclarecer, quando possvel, o no atendimento a esses requisitos.</li></ul>','<ol><li>Estes resultados referem-se aos indicadores de desempenho dos processos citados em 7.1, compatveis com o Perfil P1B(1/2), e em 7.3, compatveis com P1D(4), assim como os eventuais indicadores de processos utilizados para avaliar o atendimento de requisitos de controladores e outras partes interessadas, citados em 1.2c, e a implementao das estratgias, em 2.2a.</li><li>Incluem tambm os resultados de indicadores de desempenho de sistemas de gesto transversais, como de desenvolvimento da gesto, governana, atuao em rede, anlise do desempenho, planejamento, informaes, conhecimento, e similares, porventura utilizados pela organizao.</li><li>Explicar, resumidamente, o propsito de indicadores cujos nomes no sejam autoexplicativos.</li><li>Os referenciais comparativos pertinentes, que forem apresentados, devem ser compatveis com os padres gerenciais descritos em 1.4a para permitir a avaliao da competitividade.</li><li>A competitividade do resultado em um tema pode ser avaliada por meio de indicadores com referenciais comparativos diferentes daqueles utilizados para avaliar a melhoria no mesmo tema.</li><li>Os nveis de desempenho ou melhorias esperadas, que expressam os principais requisitos de partes interessadas, devem ser compatveis com os padres descritos em 1.3c, 3.1b, 4.1a, 4.2b, 6.3b, 7.1a, 7.2b e 7.3a.</li><li>Podem ser apresentados indicadores, entre os relevantes, sem referencial comparativo pertinente, quando o resultado no for comparvel; e sem requisito de parte interessada, quando no refletir necessidades e expectativas de partes interessadas, se eles forem relevantes para avaliar a melhoria.</li><li>No caso de unidade autnoma, em indicadores cujo levantamento de resultados  realizado somente no nvel corporativo, demonstrar a contribuio da unidade para o resultado alcanado.</li></ol>');
	

INSERT INTO pratica_verbo (pratica_verbo_id, pratica_verbo_marcador, pratica_verbo_texto, pratica_verbo_numero) VALUES 
  (1642,1041,'<p>Como so comunicados os valores internamente?</p>',1),  
  (1643,1041,'<p>Como so comunicados os valores externamente?</p>',2),
  (1644,1041,'<p>Como so comunicados os princpios organizacionais internamente?</p>',3),
  (1645,1041,'<p>Como so comunicados os princpios organizacionais externamente?</p>',4),
  (1646,1041,'<p>Como so comunicados os padres de conduta internamente?</p>',5),
  (1647,1041,'<p>Como so comunicados os padres de conduta externamente?</p>',6),
  (1648,1041,'<p>Como so comunicados os objetivos e metas internamente?</p>',7),
  (1649,1041,'<p>Como so comunicados os objetivos e metas externamente?</p>',8),
  (1650,1042,'<p>Como so estabelecidos os principais padres para os processos gerenciais?</p>',1),
  (1651,1042,'<p>Como  verificado o cumprimento dos principais padres para os processos gerenciais?</p>',2),
  (1652,1043,'<p>Como os processos gerenciais so aperfeioados?</p>',1),
  (1653,1044,'<p>Como as principais decises so tomadas?</p>',1),
  (1654,1044,'<p>Como as principais decises so acompanhadas?</p>',2),
  (1655,1045,'<p>Como a direo presta contas das suas aes aos controladores da organizao?</p>',1),
  (1656,1046,'<p>Como a direo exerce a liderana?</p>',1),
  (1657,1046,'<p>Como a direo interage com as partes interessadas relevantes?</p>',2),
  (1658,1047,'<p>Como a direo analisa o desempenho estratgico da organizao?</p>',1),
  (1659,1047,'<p>Como a direo analisa o desempenho operacional da organizao?</p>',2),
  (1660,1048,'<p>Como so analisadas as foras impulsoras do ambiente externo?</p>',1),
  (1661,1048,'<p>Como so analisadas as foras restritivas do ambiente externo?</p>',2),
  (1662,1049,'<p>Como so analisadas as foras impulsoras do ambiente interno?</p>',1),
  (1663,1049,'<p>Como so analisadas as foras restritivas do ambiente interno?</p>',2),
  (1664,1050,'<p>Como so definidas as estratgias a serem adotadas pela organizao?</p>',1),
  (1665,1051,'<p>Como so estabelecidas as metas para o xito das estratgias?</p>',1),
  (1666,1051,'<p>Como so estabelecidas os planos de ao para o xito das estratgias?</p>',2),
  (1667,1052,'<p>Como so definidos os clientes-alvo nos segmentos de atuao?</p>',1),
  (1668,1053,'<p>Como as necessidades dos clientes-alvo, nos segmentos de atuao, so identificadas?</p>',1),
  (1669,1053,'<p>Como as expectativas dos clientes-alvo, nos segmentos de atuao, so identificadas?</p>',2),
  (1670,1053,'<p>Como as necessidades dos clientes-alvo, nos segmentos de atuao, so utilizadas para a definio e melhoria dos processos da organizao?</p>',3),
  (1671,1053,'<p>Como as expectativas  dos clientes-alvo, nos segmentos de atuao, so utilizadas para a definio e melhoria dos processos da organizao?</p>',4),
  (1672,1054,'<p>Como os produtos so divulgados aos cliente?</p>',1),
  (1673,1054,'<p>Como os produtos so divulgados ao mercado?</p>',2),
  (1674,1055,'<p>Como so tratadas as solicitaes formais dos clientes?</p>',1),
  (1675,1055,'<p>Como so tratadas as solicitaes informais dos clientes?</p>',2),
  (1676,1055,'<p>Como so tratadas as reclamaes formais dos clientes?</p>',3),
  (1677,1055,'<p>Como so tratadas as reclamaes informais dos clientes?</p>',4),
  (1678,1055,'<p>Como so tratadas as sugestes formais dos clientes?</p>',5),
  (1679,1055,'<p>Como so tratadas as sugestes informais dos clientes?</p>',6),
  (1680,1056,'<p>Como  avaliada a satisfao dos clientes?</p>',1),
  (1681,1057,'<p>Como as leis, regulamentos e normas ou cdigos de adeso voluntria, aplicveis  organizao so identificados?</p>',1),
  (1682,1057,'<p>Como as leis, regulamentos e normas ou cdigos de adeso voluntria, aplicveis  organizao so atendidos?</p>',2),
  (1683,1058,'<p>Como a organizao trata impactos sociais adversos, decorrentes de seus produtos?</p>',1),
  (1684,1058,'<p>Como a organizao trata impactos ambientais adversos, decorrentes de seus produtos?</p>',2),
  (1685,1058,'<p>Como a organizao trata impactos sociais adversos, decorrentes de seus processos?</p>',3),
  (1686,1058,'<p>Como a organizao trata impactos ambientais adversos, decorrentes de seus processos?</p>',4),
  (1687,1058,'<p>Como a organizao trata impactos sociais adversos, decorrentes de suas instalaes?</p>',5),
  (1688,1058,'<p>Como a organizao trata impactos ambientais adversos, decorrentes de suas instalaes?</p>',6),
  (1689,1059,'<p>Como a organizao promove, de forma voluntria, aes para o desenvolvimento sustentvel?</p>',1),
  (1690,1060,'<p>Como a organizao direciona esforos para o desenvolvimento da sociedade?</p>',1),
  (1691,1061,'<p>Como so identificadas as necessidades de informaes para operar a organizao?</p>',1),
  (1692,1061,'<p>Como so identificadas as necessidades de informaes para gerenciar a organizao?</p>',2),
  (1693,1062,'<p>Como so disponibilizados os principais sistemas de informao para apoiar a operao da organizao?</p>',1),
  (1694,1062,'<p>Como so disponibilizados os principais sistemas de informao para apoiar o gerenciamento da organizao?</p>',2),
  (1695,1063,'<p>Como a segurana das informaes  mantida?</p>',1),
  (1696,1064,'<p>Como os conhecimentos mais importantes da organizao so difundidos?</p>',1),
  (1697,1065,'<p>Como a organizao do trabalho  definida?</p>',1),
  (1698,1066,'<p>Como as pessoas so selecionadas internamente?</p>',1),
  (1699,1066,'<p>Como as pessoas so selecionadas externamente?</p>',2),
  (1700,1067,'<p>Como o desempenho das pessoas  avaliado?</p>',1),
  (1701,1067,'<p>Como o desempenho dos lderes  avaliado?</p>',2),
  (1702,1068,'<p>Como as pessoas so reconhecidas?</p>',1),
  (1703,1068,'<p>Como as pessoas so incentivadas?</p>',2),
  (1704,1069,'<p>Como as pessoas so capacitadas?</p>',1),
  (1705,1069,'<p>Como as pessoas so desenvolvidas?</p>',2),
  (1706,1070,'<p>Como os riscos relacionados  sade ocupacional so tratados?</p>',1),
  (1707,1070,'<p>Como os riscos relacionados  segurana das pessoas so tratados?</p>',2),
  (1708,1071,'<p>Como o bem-estar das pessoas  avaliado?</p>',1),
  (1709,1071,'<p>Como a satisfao das pessoas  avaliada?</p>',2),
  (1710,1071,'<p>Como o bem-estar das pessoas  desenvolvido?</p>',3),
  (1711,1071,'<p>Como a satisfao das pessoas  desenvolvida?</p>',4),
  (1712,1072,'<p>Como so definidos os requisitos aplicveis aos produtos da cadeia de valor?</p>',1),
  (1713,1072,'<p>Como so definidos os requisitos aplicveis aos processos da cadeia de valor?</p>',2),
  (1714,1073,'<p>Como  assegurado o atendimento dos requisitos aplicveis aos processos da cadeia de valor?</p>',1),
  (1715,1074,'<p>Como a organizao analisa os produtos da cadeia de valor?</p>',1),
  (1716,1074,'<p>Como a organizao melhora os produtos da cadeia de valor?</p>',2),
  (1717,1074,'<p>Como a organizao analisa os processos da cadeia de valor?</p>',3),
  (1718,1074,'<p>Como a organizao melhora os processos da cadeia de valor?</p>',4),
  (1719,1075,'<p>Como os fornecedores so selecionados?</p>',1),
  (1720,1075,'<p>Como os fornecedores so avaliados?</p>',2),
  (1721,1076,'<p>Como  elaborado o oramento?</p>',1),
  (1722,1076,'<p>Como  controlado o oramento?</p>',2),
  (1723,1076,'<p>Como  mantido o fluxo financeiro equilibrado?</p>',3),
  (1724,1077,'<p>Apresentar os resultados dos principais indicadores relativos  gesto econmico-financeira.</p>',1),
  (1725,1078,'<p>Apresentar os resultados dos principais indicadores relativos  sociedade e meio ambiente.</p>',1),
  (1726,1079,'<p>Apresentar os resultados dos principais indicadores relativos a clientes e aos mercados.</p>',1),
  (1727,1080,'<p>Apresentar os resultados dos principais indicadores relativos s pessoas.</p>',1),
  (1728,1081,'<p>Apresentar os resultados dos principais indicadores relativos aos produtos,  gesto dos processos da cadeia de valor e  gesto de fornecedores.</p>',1),
  (1729,1082,'<p>Como so estabelecidos os valores organizacionais?</p>',1),
  (1730,1082,'<p>Como so estabelecidos os princpios organizacionais?</p>',2),
  (1731,1083,'<p>Como os principais elementos da cultura organizacional so identificados?</p>',1),
  (1732,1084,'<p>Como a organizao busca assegurar um relacionamento tico no ambiente em que opera?</p>',1),
  (1733,1085,'<p>Como so comunicados os valores  fora de trabalho?</p>',1),
  (1734,1085,'<p>Como so comunicados os valores a outros pblicos?</p>',2),
  (1735,1085,'<p>Como so comunicados os princpios organizacionais  fora de trabalho?</p>',3),
  (1736,1085,'<p>Como so comunicados os princpios organizacionais a outros pblicos?</p>',4),
  (1737,1085,'<p>Como so comunicados padres de conduta  fora de trabalho?</p>',5),
  (1738,1085,'<p>Como so comunicados padres de conduta a outros pblicos?</p>',6),
  (1739,1085,'<p>Como so comunicados estratgias, objetivos e metas  fora de trabalho?</p>',7),
  (1740,1085,'<p>Como so comunicados estratgias, objetivos e metas a outros pblicos?</p>',8),
  (1741,1086,'<p>Como so estabelecidos os principais padres para os processos gerenciais?</p>',1),
  (1742,1086,'<p>Como  verificado o cumprimento dos principais padres para os processos gerenciais?</p>',2),
  (1743,1087,'<p>Como os processos gerenciais so aperfeioados?</p>',1),
  (1744,1088,'<p>Como so identificados os riscos aos quais a organizao est sujeita?</p>',1),
  (1745,1088,'<p>Como so tratados os riscos aos quais a organizao est sujeita?</p>',2),
  (1746,1089,'<p>Como as principais decises so tomadas?</p>',1),
  (1747,1089,'<p>Como as principais decises so comunicadas aos envolvidos?</p>',2),
  (1748,1089,'<p>Como as principais decises so implementadas?</p>',3),
  (1749,1090,'<p>Como a direo presta contas das suas aes aos controladores da organizao?</p>',1),
  (1750,1090,'<p>Como a direo presta contas dos resultados alcanados aos controladores da organizao?</p>',2),
  (1751,1091,'<p>Como so conhecidas as necessidades das partes interessadas relevantes?</p>',1),
  (1752,1091,'<p>Como so conhecidas as expectativas das partes interessadas relevantes?</p>',2),
  (1753,1092,'<p>Como so desenvolvidas redes de organizaes que possam influenciar no xito das estratgias?</p>',1),
  (1754,1092,'<p>Como so desenvolvidas redes de pessoas que possam influenciar no xito das estratgias?</p>',2),
  (1755,1093,'<p>Como a direo exerce a liderana?</p>',1),
  (1756,1093,'<p>Como a direo interage com as partes interessadas?</p>',2),
  (1757,1093,'<p>Como a direo interage com as redes mais importantes?</p>',3);


INSERT INTO pratica_verbo (pratica_verbo_id, pratica_verbo_marcador, pratica_verbo_texto, pratica_verbo_numero) VALUES
  (1758,1094,'<p>Como so obtidos os referenciais comparativos necessrios para analisar a competitividade da organizao?</p>',1),
  (1759,1095,'<p>Como a direo analisa o desempenho estratgico da organizao?</p>',1),
  (1760,1095,'<p>Como a direo analisa o desempenho operacional da organizao?</p>',2),
  (1761,1096,'<p>Como  acompanhada a implementao das decises decorrentes da anlise do desempenho da organizao?</p>',1),
  (1762,1097,'<p>Como so analisadas as foras impulsoras do ambiente externo?</p>',1),
  (1763,1097,'<p>Como so analisadas as foras restritivas do ambiente externo?</p>',2),
  (1764,1098,'<p> Como so identificados os ativos intangveis mais importantes para a organizao?</p>',1),
  (1765,1099,'<p>Como so analisadas as foras impulsoras do ambiente interno?</p>',1),
  (1766,1099,'<p>Como so analisadas as foras restritivas do ambiente interno?</p>',2),
  (1767,1100,'<p>Como so definidas as estratgias a serem adotadas pela organizao?</p>',1),
  (1768,1101,'<p> Como so estabelecidas as metas de curto prazo?</p>',1),
  (1769,1101,'<p>Como so estabelecidas as metas de longo prazo?</p>',2),
  (1770,1101,'<p>Como so definidos os planos de ao das metas de curto prazo?</p>',3),
  (1771,1101,'<p>Como so definidos os planos de ao das metas de longo prazo?</p>',4),
  (1772,1102,'<p>Como as metas so desdobradas nas reas responsveis pelos processos da cadeia de valor?</p>',1),
  (1773,1102,'<p>Como os planos de ao so desdobrados nas reas responsveis pelos processos da cadeia de valor?</p>',2),
  (1774,1103,'<p>Como os recursos para a implementao dos planos de ao so alocados?</p>',1),
  (1775,1104,'<p>Como a implementao dos planos de ao  acompanhada?</p>',1),
  (1776,1105,'<p>Como a organizao segmenta seu mercado?</p>',1),
  (1777,1105,'<p>Como a organizao define os clientes-alvo para seus produtos?</p>',2),
  (1778,1106,'<p>Como as necessidades dos clientes-alvo, nos segmentos de atuao, so identificadas?</p>',1),
  (1779,1106,'<p>Como as expectativas dos clientes-alvo, nos segmentos de atuao, so identificadas?</p>',2),
  (1780,1106,'<p>Como as necessidades dos clientes-alvo, nos segmentos de atuao, so traduzidas em requisitos de desempenho?</p>',3),
  (1781,1106,'<p>Como as expectativas dos clientes-alvo, nos segmentos de atuao, so traduzidas em requisitos de desempenho?</p>',4),
  (1782,1106,'<p>Como as necessidades dos clientes-alvo, nos segmentos de atuao, so utilizadas para a definio de produtos da organizao?</p>',5),
  (1783,1106,'<p>Como as expectativas dos clientes-alvo, nos segmentos de atuao, so utilizadas para a definio de produtos da organizao?</p>',6),
  (1784,1106,'<p>Como as necessidades dos clientes-alvo, nos segmentos de atuao, so utilizadas para a melhoria de produtos da organizao?</p>',7),
  (1785,1106,'<p>Como as expectativas dos clientes-alvo, nos segmentos de atuao, so utilizadas para a melhoria de produtos da organizao?</p>',8),
  (1786,1106,'<p>Como as necessidades dos clientes-alvo, nos segmentos de atuao, so utilizadas para a melhoria de processos da organizao?</p>',9),
  (1787,1106,'<p>Como as expectativas dos clientes-alvo, nos segmentos de atuao, so utilizadas para a melhoria de processos da organizao?</p>',10),
  (1788,1107,'<p>Como os produtos so divulgados ao clientes?</p>',1),
  (1789,1107,'<p>Como os produtos so divulgados ao mercado?</p>',2),
  (1790,1108,'<p>Como  avaliada a imagem da organizao perante os clientes?</p>',1),
  (1791,1108,'<p>Como  avaliada a imagem da organizao perante os mercados?</p>',2),
  (1792,1109,'<p>Como so tratadas as solicitaes dos clientes?</p>',1),
  (1793,1109,'<p>Como so tratadas as reclamaes dos clientes?</p>',2),
  (1794,1109,'<p>Como so tratadas as sugestes dos clientes?</p>',3),
  (1795,1110,'<p>Como so acompanhadas as transaes com os novos clientes?</p>',1),
  (1796,1110,'<p>Como  acompanhada a insero de novos produtos no mercado?</p>',2),
  (1797,1111,'<p>Como  avaliada a satisfao dos clientes?</p>',1),
  (1798,1111,'<p>Como  avaliada a insatisfao dos clientes?</p>',2),
  (1799,1112,'<p>Como as informaes obtidas dos clientes so analisadas?</p>',1),
  (1800,1112,'<p>Como as informaes obtidas dos clientes so utilizadas?</p>',2),
  (1801,1113,'<p>Como as leis, regulamentos e normas ou cdigos de adeso voluntria, aplicveis  organizao so identificados?</p>',1),
  (1802,1113,'<p>Como as leis, regulamentos e normas ou cdigos de adeso voluntria, aplicveis  organizao so atendidos?</p>',2),
  (1803,1114,'<p>Como a organizao identifica os impactos sociais adversos decorrentes de seus produtos?</p>',1),
  (1804,1114,'<p>Como a organizao identifica os impactos sociais adversos decorrentes de seus processos?</p>',2),
  (1805,1114,'<p>Como a organizao identifica os impactos sociais adversos decorrentes de suas instalaes?</p>',3),
  (1806,1114,'<p>Como a organizao identifica os impactos ambientais adversos decorrentes de seus produtos?</p>',4),
  (1807,1114,'<p>Como a organizao identifica os impactos ambientais adversos decorrentes de seus processos?</p>',5),
  (1808,1114,'<p>Como a organizao identifica os impactos ambientais adversos decorrentes de suas instalaes?</p>',6),
  (1809,1114,'<p>Como a organizao trata os impactos sociais adversos decorrentes de seus produtos?</p>',7),
  (1810,1114,'<p>Como a organizao trata os impactos sociais adversos decorrentes de seus processos?</p>',8),
  (1811,1114,'<p>Como a organizao trata os impactos sociais adversos decorrentes de seus instalaes?</p>',9),
  (1812,1114,'<p>Como a organizao trata os impactos ambientais adversos decorrentes de seus produtos?</p>',10),
  (1813,1114,'<p>Como a organizao trata os impactos ambientais adversos decorrentes de seus processos?</p>',11),
  (1814,1114,'<p>Como a organizao trata os impactos ambientais adversos decorrentes de seus instalaes?</p>',12),
  (1815,1115,'<p>Como  propiciada a acessibilidade aos produtos da organizao?</p>',1),
  (1816,1115,'<p>Como  propiciada a acessibilidade as instalaes da organizao?</p>',2),
  (1817,1116,'<p>Como a organizao promove, de forma voluntria, aes com vistas ao desenvolvimento sustentvel?</p>',1),
  (1818,1117,'<p>Como as necessidades de desenvolvimento da sociedade so identificadas?</p>',1),
  (1819,1117,'<p>Como as expectativas de desenvolvimento da sociedade so identificadas?</p>',2),
  (1820,1117,'<p>Como as necessidades de desenvolvimento da sociedade so atendidas?</p>',3),
  (1821,1117,'<p>Como as expectativas de desenvolvimento da sociedade so atendidas?</p>',4),
  (1822,1118,'<p>Como a organizao direciona esforos para o desenvolvimento da sociedade?</p>',1),
  (1823,1119,'<p>Como  avaliado o grau de satisfao da sociedade em relao aos principais projetos sociais da organizao?</p>',1),
  (1824,1120,'<p>Como a organizao zela por sua imagem perante sociedade?</p>',1),
  (1825,1121,'<p>Como so identificadas as necessidades de informaes para operar a organizao?</p>',1),
  (1826,1121,'<p>Como so identificadas as necessidades de informaes para gerenciar a organizao?</p>',2),
  (1827,1122,'<p>Como so desenvolvidos os principais sistemas de informao, considerando as necessidades identificadas?</p>',1),
  (1828,1122,'<p>Como so implantados os principais sistemas de informao, considerando as necessidades identificadas?</p>',2),
  (1829,1123,'<p>Como a segurana das informaes  mantida?</p>',1),
  (1830,1124,'<p>Como a organizao desenvolve os conhecimentos mais importantes?</p>',1),
  (1831,1125,'<p>Como os conhecimentos mais importantes da organizao so difundidos?</p>',1),
  (1832,1125,'<p>Como os conhecimentos mais importantes da organizao so utilizados?</p>',2),
  (1833,1126,'<p>Como a organizao do trabalho  definida?</p>',1),
  (1834,1127,'<p>Como as competncias necessrias para o exerccio pleno das funes pelas pessoas so identificadas?</p>',1),
  (1835,1127,'<p>Como as competncias necessrias para o exerccio pleno das funes dos lderes so identificadas?</p>',2),
  (1836,1128,'<p>Como as pessoas so selecionadas internamente?</p>',1),
  (1837,1128,'<p>Como as pessoas so selecionadas externamente?</p>',2),
  (1838,1129,'<p>Como as pessoas recm-contratadas so preparadas para o exerccio de suas funes?</p>',1),
  (1839,1129,'<p>Como as pessoas recm-contratadas so integradas  cultura organizacional?</p>',2),
  (1840,1130,'<p>Como o desempenho das pessoas  avaliado?</p>',1),
  (1841,1130,'<p>Como o desempenho dos lderes  avaliado?</p>',2),
  (1842,1131,'<p>Como as pessoas so reconhecidas?</p>',1),
  (1843,1131,'<p>Como as pessoas so incentivadas?</p>',2),
  (1844,1132,'<p>Como so identificadas as necessidades de capacitao das pessoas?</p>',1),
  (1845,1132,'<p>Como so identificadas as necessidades de desenvolvimento das pessoas?</p>',2),
  (1846,1133,'<p>Como  concebida a forma de realizao dos programas de capacitao?</p>',1),
  (1847,1133,'<p>Como  concebida a forma de realizao dos programas de desenvolvimento?</p>',2),
  (1848,1134,'<p>Como a organizao promove o desenvolvimento comportamental das pessoas?</p>',1),
  (1849,1134,'<p>Como a organizao promove o desenvolvimento da cidadania das pessoas?</p>',2),
  (1850,1135,'<p>Como so identificados os perigos relacionados  sade ocupacional?</p>',1),
  (1851,1135,'<p>Como so tratados os riscos relacionados  sade ocupacional?</p>',2),
  (1852,1135,'<p>Como so identificados os perigos relacionados  segurana?</p>',3),
  (1853,1135,'<p>Como so tratados os riscos relacionados  segurana?</p>',4),
  (1854,1136,'<p>Como as necessidades das pessoas so identificadas?</p>',1),
  (1855,1136,'<p>Como as expectativas das pessoas so identificadas?</p>',2),
  (1856,1136,'<p>Como as necessidades das pessoas so utilizadas para o desenvolvimento de polticas?</p>',3),
  (1857,1136,'<p>Como as expectativas das pessoas so utilizadas para o desenvolvimento de polticas?</p>',4),
  (1858,1136,'<p>Como as necessidades das pessoas so utilizadas para o desenvolvimento de programas de pessoal a elas oferecidos?</p>',5),
  (1859,1136,'<p>Como as expectativas das pessoas so utilizadas para o desenvolvimento de programas de pessoal a elas oferecidos?</p>',6),
  (1860,1136,'<p>Como as necessidades das pessoas so utilizadas para o desenvolvimento de benefcios a elas oferecidos?</p>',7),
  (1861,1136,'<p>Como as expectativas das pessoas so utilizadas para o desenvolvimento de benefcios a elas oferecidos?</p>',8),
  (1862,1137,'<p>Como o bem-estar das pessoas  avaliado?</p>',1),
  (1863,1137,'<p>Como a satisfao das pessoas  avaliada?</p>',2),
  (1864,1137,'<p>Como o bem-estar das pessoas  desenvolvido?</p>',3),
  (1865,1137,'<p>Como a satisfao das pessoas  desenvolvida?</p>',4),
  (1866,1138,'<p>Como so definidos os requisitos aplicveis aos produtos da cadeia de valor?</p>',1),
  (1867,1138,'<p>Como so definidos os requisitos aplicveis aos processos da cadeia de valor?</p>',2),
  (1868,1139,'<p>Como so desenvolvidos os novos produtos?</p>',1),
  (1869,1140,'<p>Como so projetados os processos da cadeia de valor?</p>',1),
  (1870,1141,'<p>Como  assegurado o atendimento dos requisitos aplicveis aos processos da cadeia de valor?</p>',1),
  (1871,1142,'<p>Como a organizao analisa os produtos da cadeia de valor?</p>',1),
  (1872,1142,'<p>Como a organizao melhora os produtos da cadeia de valor?</p>',2),
  (1873,1142,'<p>Como a organizao analisa os processos da cadeia de valor?</p>',3),
  (1874,1142,'<p>Como a organizao melhora os processos da cadeia de valor?</p>',4),
  (1875,1143,'<p>Como os fornecedores so qualificados?</p>',1),
  (1876,1143,'<p>Como os fornecedores so selecionados?</p>',2),
  (1877,1144,'<p>Como a organizao avalia o desempenho dos fornecedores, considerando os requisitos de fornecimento?</p>',1),
  (1878,1145,'<p>Como a fora de trabalho dos fornecedores, que atua diretamente nos processos da cadeia de valor da organizao,  comprometida com os valores organizacionais?</p>',1),
  (1879,1145,'<p>Como a fora de trabalho dos fornecedores, que atua diretamente nos processos da cadeia de valor da organizao,  comprometida com os princpios organizacionais?</p>',2),
  (1880,1145,'<p>Como a fora de trabalho dos fornecedores, que atua diretamente nos processos da cadeia de valor da organizao,  comprometida com as diretrizes a eles aplicveis?</p>',3),
  (1881,1146,'<p>Como as necessidades dos fornecedores so identificadas?</p>',1),
  (1882,1146,'<p>Como as expectativas dos fornecedores so identificadas?</p>',2),
  (1883,1146,'<p>Como as necessidades dos fornecedores so analisadas?</p>',3),
  (1884,1146,'<p>Como as expectativas dos fornecedores so analisadas?</p>',4),
  (1885,1147,'<p>Como so monitorados os aspectos que causam impacto na sustentabilidade econmica do negcio?</p>',1),
  (1886,1148,'<p>Como a organizao busca assegurar os recursos financeiros necessrios para atender s necessidades operacionais?</p>',1),
  (1887,1148,'<p>Como a organizao busca assegurar os recursos financeiros necessrios para manter equilibrado o fluxo financeiro?</p>',2),
  (1888,1149,'<p>Como a organizao avalia os investimentos necessrios para apoiar as estratgias?</p>',1),
  (1889,1149,'<p>Como a organizao avalia os investimentos necessrios para apoiar os planos de ao?</p>',2),
  (1890,1150,'<p>Como  elaborado o oramento?</p>',1),
  (1891,1151,'<p>Apresentar os resultados dos principais indicadores relativos  gesto econmico-financeira.</p>',1),
  (1892,1152,'<p>Apresentar os resultados dos principais indicadores relativos  responsabilidade socioambiental e ao desenvolvimento social.</p>',1),
  (1893,1153,'<p>Apresentar os resultados dos principais indicadores relativos aos clientes.</p>',1),
  (1894,1154,'<p>Apresentar os resultados dos principais indicadores relativos s pessoas.</p>',1),
  (1895,1155,'<p>Apresentar os resultados dos principais indicadores relativos aos produtos, aos processos da cadeia de valor, relativos a fornecedores e relativos a processos de gesto transversais no relacionados aos demais itens deste Critrio.</p>',1),
  (1896,1150,'<p>Como  controlado o oramento?</p>',2),
  (1897,1156,'<p>Como so estabelecidos os valores organizacionais?</p>',1),
  (1898,1156,'<p>Como so estabelecidos os princpios organizacionais?</p>',2),
  (1899,1157,'<p>Como os principais elementos da cultura organizacional so identificados?</p>',1),
  (1900,1157,'<p>Como os principais elementos da cultura organizacional so analisados?</p>',2),
  (1901,1157,'<p>Como os principais elementos da cultura organizacional so desenvolvidos?</p>',3),
  (1902,1158,'<p>Como a organizao estabelece padres de conduta no ambiente em que opera?</p>',1),
  (1903,1158,'<p>Como a organizao busca assegurar um relacionamento tico no ambiente em que opera?</p>',2),
  (1904,1159,'<p>Como os temas para o desenvolvimento da cultura organizacional  comunicados  fora de trabalho?</p>',1),
  (1905,1159,'<p>Como os temas para o desenvolvimento da cultura organizacional  comunicados  outros pblicos?</p>',2),
  (1906,1159,'<p>Como os temas para o engajamento das pessoas   comunicados  fora de trabalho?</p>',3),
  (1907,1159,'<p>Como os temas para o engajamento das pessoas   comunicados  outros pblicos?</p>',4),
  (1908,1160,'<p>Como so estabelecidos os principais padres para os processos gerenciais?</p>',1),
  (1909,1160,'<p>Como  verificado o cumprimento dos principais padres para os processos gerenciais?</p>',2),
  (1910,1161,'<p>Como os processos gerenciais so aperfeioados?</p>',1),
  (1911,1162,'<p>Como so obtidas as informaes sobre boas prticas de gesto de organizaes de referncia?</p>',1),
  (1912,1162,'<p>Como so utilizadas as informaes sobre boas prticas de gesto de organizaes de referncia?</p>',2),
  (1913,1163,'<p>Como so estabelecidas as diretrizes que a organizao deve observar?</p>',1),
  (1914,1164,'<p>Como  assegurada a conformidade da organizao com os requisitos legais?</p>',1),
  (1915,1164,'<p>Como  assegurada a conformidade da organizao com os requisitos regulamentares aplicveis?</p>',2),
  (1916,1164,'<p>Como  assegurada a conformidade da organizao com as diretrizes estabelecidas?</p>',3),
  (1917,1165,'<p> Como so identificados riscos aos quais a organizaoest sujeita?</p>',1),
  (1918,1165,'<p> Como so tratadosos riscos aos quais a organizaoest sujeita?</p>',2),
  (1919,1166,'<p>Como as principais decises so tomadas?</p>',1),
  (1920,1166,'<p>Como as principais decises so comunicadas aos envolvidos?</p>',2),
  (1921,1166,'<p>Como as principais decises so implementadas?</p>',3),
  (1922,1167,'<p>Como os fatos importantes so prontamente comunicados  sociedade?</p>',1),
  (1923,1167,'<p>Como os fatos importantes so prontamente comunicados s demais partes interessadas?</p>',2),
  (1924,1168,'<p>Como a direo presta contas das suas aes aos controladores da organizao?</p>',1),
  (1925,1168,'<p>Como a direo presta contas de seus resultados alcanadosaos controladores da organizao?</p>',2),
  (1926,1168,'<p>Como a direo presta contas das suas aes s demais partes interessadas relevantes?</p>',3),
  (1927,1168,'<p>Como a direo presta contas de seus resultados alcanados s demais partes interessadas relevantes?</p>',4),
  (1928,1169,'<p>Como so identificadas as partes interessadas relevantes?</p>',1),
  (1929,1169,'<p>Como so conhecidos os interesses das partes interessadas relevantes?</p>',2),
  (1930,1170,'<p>Como as necessidades dos controladores so identificadas?</p>',1),
  (1931,1170,'<p>Como as expectativas dos controladores so identificadas?</p>',2),
  (1932,1170,'<p>Como as necessidades dos controladores so analisadas?</p>',3),
  (1933,1170,'<p>Como as expectativas dos controladores so analisadas?</p>',4),
  (1934,1170,'<p>Como as necessidades dos controladores so traduzidas em requisitos de desempenho?</p>',5),
  (1935,1170,'<p>Como as expectativas dos controladores so traduzidas em requisitos de desempenho?</p>',6),
  (1936,1170,'<p>Como as necessidades das demais partes interessadas so identificadas?</p>',7),
  (1937,1170,'<p>Como as expectativas das demais partes interessadas so identificadas?</p>',8),
  (1938,1170,'<p>Como as necessidades das demais partes interessadas so analisadas?</p>',9),
  (1939,1170,'<p>Como as expectativas das demais partes interessadas so analisadas?</p>',10),
  (1940,1170,'<p>Como as necessidades das demais partes interessadas so traduzidas em requisitos de desempenho?</p>',11),
  (1941,1170,'<p>Como as expectativas das demais partes interessadas so traduzidas em requisitos de desempenho?</p>',12),
  (1942,1171,'<p>Como so identificadas redes de organizaes que possam influenciar no xito das estratgias?</p>',1),
  (1943,1171,'<p>Como so identificadas redes de organizaes que possam influenciar no alcance sustentado dos objetivos da organizao?</p>',2),
  (1944,1171,'<p>Como so desenvolvidas redes de organizaes que possam influenciar no xito das estratgias?</p>',3),
  (1945,1171,'<p>Como so desenvolvidas redes de organizaes que possam influenciar no alcance sustentado dos objetivos da organizao?</p>',4),
  (1946,1171,'<p>Como so identificadas redes de pessoas que possam influenciar no xito das estratgias?</p>',5),
  (1947,1171,'<p>Como so identificadas redes de pessoas que possam influenciar no alcance sustentado dos objetivos da organizao?</p>',6),
  (1948,1171,'<p>Como so desenvolvidas redes de pessoas que possam influenciar no xito das estratgias?</p>',7),
  (1949,1171,'<p>Como so desenvolvidas redes de pessoas que possam influenciar no alcance sustentado dos objetivos da organizao?</p>',8),
  (1950,1172,'<p>Como a direo exerce a liderana?</p>',1),
  (1951,1172,'<p>Como a direo interage com as demais partes interessadas?</p>',2),
  (1952,1172,'<p>Como a direo interage com as redes mais importantes?</p>',3),
  (1953,1173,'<p>Como so selecionados os indicadores que sero utilizados na anlise, pela direo, do desempenho estratgico da organizao?</p>',1),
  (1954,1173,'<p>Como so selecionados os indicadores que sero utilizados na anlise, pela direo, do desempenho operacional da organizao?</p>',2),
  (1955,1173,'<p>Como so selecionados as informaes, excetuando indicadores, que sero utilizados na anlise, pela direo, do desempenho estratgico da organizao?</p>',3),
  (1956,1173,'<p>Como so selecionados as informaes, excetuando indicadores, que sero utilizados na anlise, pela direo, do desempenho operacional da organizao?</p>',4),
  (1957,1174,'<p>Como so identificados os referenciais comparativos necessrios para analisar a competitividade da organizao?</p>',1),
  (1958,1174,'<p>Como so obtidos os referenciais comparativos necessrios para analisar a competitividade da organizao?</p>',2),
  (1959,1175,'<p>Como a direo analisa o desempenho estratgico da organizao?</p>',1),
  (1960,1175,'<p>Como a direo analisa o desempenho operacional da organizao?</p>',2),
  (1961,1176,'<p>Como  acompanhada a implementao das decises decorrentes da anlise do desempenho da organizao?</p>',1),
  (1962,1177,'<p>Como  analisado o macroambiente de atuao da organizao?</p>',1),
  (1963,1177,'<p>Como  analisado as tendncias do macroambiente de atuao da organizao?</p>',2),
  (1964,1178,'<p>Como so analisadas as caractersticas do setor de atuao da organizao?</p>',1),
  (1965,1178,'<p>Como so analisadas as tendncias do setor de atuao da organizao?</p>',2),
  (1966,1179,'<p>Como so analisados os mercados de atuao da organizao?</p>',1),
  (1967,1179,'<p>Como so analisados as tendncias dos mercados de atuao da organizao?</p>',2),
  (1968,1180,'<p>Como so identificados os ativos intangveis mais importantes para a organizao?</p>',1),
  (1969,1180,'<p>Como so avaliados os ativos intangveis mais importantes para a organizao?</p>',2),
  (1970,1181,'<p>Como  analisado o ambiente interno da organizao?</p>',1),
  (1971,1182,'<p>Como so avaliadas as alternativas decorrentes da anlise estratgica?</p>',1),
  (1972,1182,'<p>Como so definidas as estratgias a serem adotadas pela organizao?</p>',2),
  (1973,1183,'<p>Como  avaliado o modelo de negcio em consonncia com a definio das estratgias?</p>',1),
  (1974,1184,'<p>Como so definidos os indicadores para a avaliao do xito das estratgias?</p>',1),
  (1975,1184,'<p>Como so estabelecidas as metas de curto prazo?</p>',2),
  (1976,1184,'<p>Como so estabelecidas as metas de longo prazo?</p>',3),
  (1977,1184,'<p>Como so definidos os planos de ao das metas de curto prazo?</p>',4),
  (1978,1184,'<p>Como so definidos os planos de ao das metas de longo prazo?</p>',5),
  (1979,1185,'<p>Como as metas so desdobradas nas reas responsveis pelos processos da cadeia de valor?</p>',1),
  (1980,1185,'<p>Como os planos de ao so desdobrados nas reas responsveis pelos processos da cadeia de valor?</p>',2),
  (1981,1186,'<p>Como os recursos para a implementao dos planos de ao so alocados?</p>',1),
  (1982,1187,'<p>Como a implementao dos planos de ao  acompanhada?</p>',1),
  (1983,1188,'<p>Como a organizao analisa seu mercado atual?</p>',1),
  (1984,1188,'<p>Como a organizao segmenta seu mercado atual?</p>',2),
  (1985,1188,'<p>Como a organizao analisa seu mercado potencial?</p>',3),
  (1986,1188,'<p>Como a organizao segmenta seu mercado potencial?</p>',4),
  (1987,1188,'<p>Como a organizao define os clientes-alvo para seus produtos no mercado atual?</p>',5),
  (1988,1188,'<p>Como a organizao define os clientes-alvo para seus produtos no mercado potencial?</p>',6),
  (1989,1189,'<p>Como as necessidade dos clientes atuais so identificados?</p>',1),
  (1990,1189,'<p>Como as expectativas dos clientes atuais so identificados?</p>',2),
  (1991,1189,'<p>Como os comportamentos dos clientes atuais so identificados?</p>',3),
  (1992,1189,'<p>Como as necessidade dos clientes-alvo so identificados?</p>',5),
  (1993,1189,'<p>Como as expectativas dos clientes-alvo so identificados?</p>',6),
  (1994,1189,'<p>Como os comportamentos dos clientes-alvo so identificados?</p>',7),
  (1995,1189,'<p>Como as tendncias dos clientes atuais so identificadas?</p>',4),
  (1996,1189,'<p>Como as tendncias dos clientes-alvo so identificadas?</p>',8),
  (1997,1189,'<p>Como as necessidade dos clientes atuais so analisados?</p>',9),
  (1998,1189,'<p>Como as expectativas dos clientes atuais so analisados?</p>',10),
  (1999,1189,'<p>Como os comportamentos dos clientes atuais so analisados?</p>',11),
  (2000,1189,'<p>Como as tendncias dos clientes atuais so analisadas?</p>',12),
  (2001,1189,'<p>Como as necessidade dos clientes-alvo so analisados?</p>',13),
  (2002,1189,'<p>Como as expectativas dos clientes-alvo so analisados?</p>',14),
  (2003,1189,'<p>Como os comportamentos dos clientes-alvo so analisados?</p>',15),
  (2004,1189,'<p>Como as tendncias dos clientes-alvo so analisadas?</p>',16),
  (2005,1189,'<p>Como as necessidade dos clientes atuais so traduzidas em requisitos de desempenho?</p>',17),
  (2006,1189,'<p>Como as expectativas dos clientes atuais so traduzidas em requisitos de desempenho?</p>',18),
  (2007,1189,'<p>Como os comportamentos dos clientes atuais so traduzidos em requisitos de desempenho?</p>',19),
  (2008,1189,'<p>Como as tendncias dos clientes atuais so traduzidas em requisitos de desempenho?</p>',20),
  (2009,1189,'<p>Como as necessidade dos clientes-alvo so traduzidas em requisitos de desempenho?</p>',21),
  (2010,1189,'<p>Como as expectativas dos clientes-alvo so traduzidas em requisitos de desempenho?</p>',22),
  (2011,1189,'<p>Como os comportamentos dos clientes-alvo so traduzidos em requisitos de desempenho?</p>',23),
  (2012,1189,'<p>Como as tendncias dos clientes-alvo so traduzidas em requisitos de desempenho?</p>',24),
  (2013,1189,'<p>Como as necessidade dos clientes atuais so utilizadas para definio e melhoria dos produtos da organizao?</p>',25),
  (2014,1189,'<p>Como as expectativas dos clientes atuais so utilizadas para definio e melhoria dos produtos da organizao?</p>',26),
  (2015,1189,'<p>Como os comportamentos dos clientes atuais so so utilizados para definio e melhoria dos produtos da organizao?</p>',27),
  (2016,1189,'<p>Como as tendncias dos clientes atuais so utilizadas para definio e melhoria dos produtos da organizao?</p>',28),
  (2017,1189,'<p>Como as necessidade dos clientes-alvo so utilizadas para definio e melhoria dos produtos da organizao?</p>',29),
  (2018,1189,'<p>Como as expectativas dos clientes-alvo so utilizadas para definio e melhoria dos produtos da organizao?</p>',30),
  (2019,1189,'<p>Como os comportamentos dos clientes-alvo so utilizados para definio e melhoria dos produtos da organizao?</p>',31),
  (2020,1189,'<p>Como as tendncias dos clientes-alvo so utilizados para definio e melhoria dos produtos da organizao?</p>',32),
  (2021,1189,'<p>Como as necessidade dos clientes atuais so utilizadas para definio e melhoria dos processos da organizao?</p>',33),
  (2022,1189,'<p>Como as expectativas dos clientes atuais so utilizadas para definio e melhoria dos processos da organizao?</p>',34),
  (2023,1189,'<p>Como os comportamentos dos clientes atuais so so utilizados para definio e melhoria dos processos da organizao?</p>',35),
  (2024,1189,'<p>Como as tendncias dos clientes atuais so utilizadas para definio e melhoria dos processos da organizao?</p>',36),
  (2025,1189,'<p>Como as necessidade dos clientes-alvo so utilizadas para definio e melhoria dos processos da organizao?</p>',37),
  (2026,1189,'<p>Como as expectativas dos clientes-alvo so utilizadas para definio e melhoria dos processos da organizao?</p>',38),
  (2027,1189,'<p>Como os comportamentos dos clientes-alvo so utilizados para definio e melhoria dos processos da organizao?</p>',39),
  (2028,1189,'<p>Como as tendncias dos clientes-alvo so utilizados para definio e melhoria dos processos da organizao?</p>',40),
  (2029,1190,'<p>Como as marcas so desenvolvidas no mercado?</p>',1),
  (2030,1191,'<p>Como os produtos, incluindo os cuidados necessrios ao seu uso e os riscos envolvidos, so divulgados aos clientes?</p>',1),
  (2031,1191,'<p>Como os produtos, incluindo os cuidados necessrios ao seu uso e os riscos envolvidos, so divulgados ao mercado?</p>',2),
  (2032,1191,'<p>Como as aes de melhoria da organizao so divulgados aos clientes?</p>',3),
  (2033,1191,'<p>Como as aes de melhoria da organizao so divulgados ao mercado?</p>',4),
  (2034,1192,'<p>Como  avaliada a imagem da organizao perante os clientes?</p>',1),
  (2035,1192,'<p>Como  avaliada a imagem da organizao perante o mercados?</p>',2),
  (2036,1193,'<p>Como so estabelecidos, os canais de interao com os clientes, considerando a segmentao do mercado e a definio dos clientes-alvo?</p>',1),
  (2037,1193,'<p>Como so divulgados os canais de interao com os clientes, considerando a segmentao do mercado e a definio dos clientes-alvo?</p>',2),
  (2038,1193,'<p>Como so monitorados os canais de interao com os clientes, considerando a segmentao do mercado e a definio dos clientes-alvo?</p>',3),
  (2039,1194,'<p>Como so tratadas as solicitaes formais dos clientes?</p>',1),
  (2040,1194,'<p>Como so tratadas as solicitaes informais dos clientes?</p>',2),
  (2041,1194,'<p>Como so tratadas as reclamaes formais dos clientes?</p>',3),
  (2042,1194,'<p>Como so tratadas as reclamaes informais dos clientes?</p>',4),
  (2043,1194,'<p>Como so tratadas as sugestes formais dos clientes?</p>',5),
  (2044,1194,'<p>Como so tratadas as sugestes informais dos clientes?</p>',6),
  (2045,1195,'<p>Como so acompanhadas as transaes com os clientes?</p>',1),
  (2046,1195,'<p>Como so acompanhadas as transaes com os novos clientes?</p>',2),
  (2047,1195,'<p>Como  acompanhada a insero de novos produtos no mercado?</p>',3),
  (2048,1196,'<p>Como  avaliada a satisfao dos clientes?</p>',1),
  (2049,1196,'<p>Como  avaliada a fidelidade dos clientes?</p>',2),
  (2050,1196,'<p>Como  avaliada a insatisfao dos clientes?</p>',3),
  (2051,1197,'<p>Como as informaes obtidas dos clientes so analisadas?</p>',1),
  (2052,1197,'<p>Como as informaes obtidas dos clientes so utilizadas?</p>',2),
  (2053,1198,'<p>Como so identificadas parcerias com clientes?</p>',1),
  (2054,1198,'<p>Como so desenvolvidas parcerias com clientes?</p>',2),
  (2055,1198,'<p>Como so identificadas parcerias com distribuidores?</p>',3),
  (2056,1198,'<p>Como so desenvolvidas parcerias com distribuidores?</p>',4),
  (2057,1198,'<p>Como so identificadas parcerias com representantes?</p>',5),
  (2058,1198,'<p>Como so desenvolvidas parcerias com representantes?</p>',6),
  (2059,1198,'<p>Como so identificadas parcerias com revendedores?</p>',7),
  (2060,1198,'<p>Como so desenvolvidas parcerias com revendedores?</p>',8),
  (2061,1199,'<p>Como as leis, aplicveis  organizao, so identificadas?</p>',1),
	(2062,1199,'<p>Como os regulamentos e normas, aplicveis  organizao, so identificados?</p>',2),
	(2063,1199,'<p>Como os cdigos de adeso voluntria, aplicveis  organizao, so identificados?</p>',3),
	(2064,1199,'<p>Como as leis, aplicveis  organizao, so analisados?</p>',4),
	(2065,1199,'<p>Como os regulamentos e normas, aplicveis  organizao, so analisados?</p>',5),
	(2066,1199,'<p>Como os cdigos de adeso voluntria, aplicveis  organizao, so analisados?</p>',6),
	(2067,1199,'<p>Como as leis, aplicveis  organizao, so traduzidas em requisitos de desempenho?</p>',7),
	(2068,1199,'<p>Como os regulamentos e normas, aplicveis  organizao, so traduzidos em requisitos de desempenho?</p>',8),
	(2069,1199,'<p>Como os cdigos de adeso voluntria, aplicveis  organizao, so traduzidos em requisitos de desempenho?</p>',9),
	(2070,1200,'<p>Como a organizao identifica os aspectos sociais adversos decorrentes de seus produtos?</p>',1),
	(2071,1200,'<p>Como a organizao trata os aspectos sociais adversos decorrentes de seus produtos?</p>',2),
	(2072,1200,'<p>Como a organizao identifica os aspectos sociais adversos decorrentes de seus processos?</p>',3),
	(2073,1200,'<p>Como a organizao trata os aspectos sociais adversos decorrentes de seus processos?</p>',4),
	(2074,1200,'<p>Como a organizao identifica os aspectos sociais adversos decorrentes de suas instalaes?</p>',5),
	(2075,1200,'<p>Como a organizao trata os aspectos sociais adversos decorrentes de suas instalaes?</p>',6),
	(2076,1200,'<p>Como a organizao identifica os aspectos ambientais adversos decorrentes de seus produtos?</p>',7),
	(2077,1200,'<p>Como a organizao trata os aspectos ambientais adversos decorrentes de seus produtos?</p>',8),
	(2078,1200,'<p>Como a organizao identifica os aspectos ambientais adversos decorrentes de seus processos?</p>',9),
	(2079,1200,'<p>Como a organizao trata os aspectos sociais adversos decorrentes de seus processos?</p>',10),
	(2080,1200,'<p>Como a organizao identifica os aspectos ambientais adversos decorrentes de suas instalaes?</p>',11),
	(2081,1200,'<p>Como a organizao trata os aspectos ambientais adversos decorrentes de suas instalaes?</p>',12),
	(2082,1201,'<p>Como a organizao mantm-se preparada para prevenir acidentes?</p>',1),
	(2083,1201,'<p>Como a organizao mantm-se preparada para responder s eventuais situaes de emergncia?</p>',2),
	(2084,1202,'<p>Como  propiciada a acessibilidade aos produtos da organizao?</p>',1),
	(2085,1202,'<p>Como  propiciada a acessibilidade aos processos da organizao?</p>',2),
	(2086,1202,'<p>Como  propiciada a acessibilidade as informaes da organizao?</p>',3),
	(2087,1202,'<p>Como  propiciada a acessibilidade as instalaes da organizao?</p>',4),
	(2088,1203,'<p>Como a organizao seleciona aes com vistas ao desenvolvimento sustentvel?</p>',1),
	(2089,1203,'<p>Como a organizao promove, de forma voluntria, aes com vistas ao desenvolvimento sustentvel?</p>',2),
	(2090,1204,'<p>Como as necessidades de desenvolvimento da sociedade so identificadas?</p>',1),
	(2091,1204,'<p>Como as necessidades de desenvolvimento da sociedade so analisadas?</p>',2),
	(2092,1204,'<p>Como as necessidades de desenvolvimento da sociedade so traduzidas em requisitos de desempenho?</p>',3),
	(2093,1204,'<p>Como as necessidades de desenvolvimento da sociedade so utilizadas para a definio da atuao social da organizao?</p>',4),
	(2094,1204,'<p>Como as necessidades de desenvolvimento da sociedade so utilizadas para a melhoria da atuao social da organizao?</p>',5),
	(2095,1204,'<p>Como as expectativas de desenvolvimento da sociedade so identificadas?</p>',6),
	(2096,1204,'<p>Como as expectativas de desenvolvimento da sociedade so analisadas?</p>',7),
	(2097,1204,'<p>Como as expectativas de desenvolvimento da sociedade so traduzidas em requisitos de desempenho?</p>',8),
	(2098,1204,'<p>Como as expectativas de desenvolvimento da sociedade so utilizadas para a definio da atuao social da organizao?</p>',9),
	(2099,1204,'<p>Como as expectativas de desenvolvimento da sociedade so utilizadas para a melhoria da atuao social da organizao?</p>',10),
	(2100,1205,'<p>Como a organizao direciona esforos para o desenvolvimento da sociedade?</p>',1),
	(2101,1206,'<p>Como  avaliado o grau de satisfao da sociedade em relao aos projetos sociais da organizao?</p>',1),
	(2102,1207,'<p>Como as informaes obtidas da sociedade so analisadas?</p>',1),
	(2103,1207,'<p>Como as informaes obtidas da sociedade so utilizadas para melhorar a atuao social?</p>',2),
	(2104,1208,'<p>Como a organizao avalia sua imagem perante a sociedade?</p>',1),
	(2105,1208,'<p>Como a organizao zela por sua imagem perante a sociedade?</p>',2),
	(2106,1209,'<p>Como so identificadas as necessidades de informaes para operar a organizao?</p>',1),
	(2107,1209,'<p>Como so identificadas as necessidades de informaes para gerenciar a organizao?</p>',2),
	(2108,1209,'<p>Como so tratadas as necessidades de informaes para operar a organizao?</p>',3),
	(2109,1209,'<p>Como so tratadas as necessidades de informaes para gerenciar a organizao?</p>',4),
	(2110,1210,'<p>Como so definidos os principais sistemas de informao, considerando as necessidades identificadas?</p>',1),
	(2111,1210,'<p>Como so desenvolvidos os principais sistemas de informao, considerando as necessidades identificadas?</p>',2),
	(2112,1210,'<p>Como so implantados os principais sistemas de informao, considerando as necessidades identificadas?</p>',3),
	(2113,1210,'<p>Como so melhorados os principais sistemas de informao, considerando as necessidades identificadas?</p>',4),
	(2114,1211,'<p>Como a infraestrutura para a disponibilizao das informaes aos usurios  compatibilizada com o crescimento do negcio?</p>',1),
	(2115,1211,'<p>Como a infraestrutura para a disponibilizao das informaes aos usurios  compatibilizada com o crescimento da demanda por informaes?</p>',2),
	(2116,1212,'<p>Como a segurana das informaes  mantida?</p>',1),
	(2117,1213,'<p>Como a organizao identifica os conhecimentos mais importantes para realizar sua misso?</p>',1),
	(2118,1213,'<p>Como a organizao identifica os conhecimentos mais importantes para implementar as estratgias?</p>',2),
	(2119,1214,'<p>Como a organizao desenvolve os conhecimentos mais importantes?</p>',1),
	(2120,1215,'<p>Como os conhecimentos mais importantes so retidos?</p>',1),
	(2121,1215,'<p>Como os conhecimentos mais importantes so protegidos?</p>',2),
	(2122,1216,'<p>Como os conhecimentos da organizao so difundidos?</p>',1),
	(2123,1216,'<p>Como os conhecimentos da organizao so utilizados?</p>',2),
	(2124,1217,'<p>Como a organizao do trabalho  definida?</p>',1),
	(2125,1218,'<p>Como as competncias necessrias para o exerccio pleno das funes pelas pessoas so identificadas?</p>',1),
	(2126,1218,'<p>Como as competncias necessrias para o exerccio pleno das funes pelos lderes so identificadas?</p>',2),
	(2127,1219,'<p>Como as pessoas so selecionadas internamente?</p>',1),
	(2128,1219,'<p>Como as pessoas so selecionadas externamente?</p>',2),
	(2129,1219,'<p>Como as pessoas so contratadas internamente?</p>',3),
	(2130,1219,'<p>Como as pessoas so contratadas externamente?</p>',4),
	(2131,1220,'<p>Como as pessoas recm-contratadas so preparadas para o exerccio de suas funes?</p>',1),
	(2132,1220,'<p>Como as pessoas recm-contratadas so integradas  cultura organizacional?</p>',2),
	(2133,1221,'<p>Como o desempenho das pessoas  avaliado?</p>',1),
	(2134,1221,'<p>Como o desempenho dos lderes  avaliado?</p>',2),
	(2135,1221,'<p>Como o desempenho das equipes  avaliado?</p>',3),
	(2136,1221,'<p>Como as necessidades de melhoria so acordadas com as pessoas?</p>',4),
	(2137,1221,'<p>Como as necessidades de melhoria so acordadas com os lderes?</p>',5),
	(2138,1221,'<p>Como as necessidades de melhoria so acordadas com as equipes?</p>',6),
	(2139,1222,'<p>Como a remunerao estimula a busca do alto desempenho?</p>',1),
	(2140,1222,'<p>Como o reconhecimento estimula a busca do alto desempenho?</p>',2),
	(2141,1222,'<p>Como os incentivos estimulam a busca do alto desempenho?</p>',3),
	(2142,1222,'<p>Como a remunerao estimula o alcance de metas?</p>',4),
	(2143,1222,'<p>Como o reconhecimento estimula o alcance de metas?</p>',5),
	(2144,1222,'<p>Como os incentivos estimulam o alcance de metas?</p>',6),
	(2145,1222,'<p>Como a remunerao estimula a cultura de excelncia?</p>',7),
	(2146,1222,'<p>Como o reconhecimento estimula a cultura de excelncia?</p>',8),
	(2147,1222,'<p>Como os incentivos estimulam a cultura de excelncia?</p>',9),
	(2148,1223,'<p>Como so identificadas as necessidades de capacitao das pessoas?</p>',1),
	(2149,1223,'<p>Como so identificadas as necessidades de desenvolvimento das pessoas?</p>',2),
	(2150,1224,'<p>Como  concebida a forma de realizao dos programas de capacitao?</p>',1),
	(2151,1224,'<p>Como  concebida a forma de realizao dos programas de desenvolvimento?</p>',2),
	(2152,1225,'<p>Como so identificados os novos lderes?</p>',1),
	(2153,1225,'<p>Como so preparados os novos lderes?</p>',2),
	(2154,1225,'<p>Como so identificados os sucessores para os lderes atuais?</p>',3),
	(2155,1225,'<p>Como so preparados os sucessores para os lderes atuais?</p>',4),
	(2156,1226,'<p>Como a eficcia dos programas de capacitao  avaliada?</p>',1),
	(2157,1226,'<p>Como a eficcia dos programas de desenvolvimento  avaliada?</p>',2),
	(2158,1227,'<p>Como a organizao promove o desenvolvimento integral das pessoas como indivduos?</p>',1),
	(2159,1227,'<p>Como a organizao promove o desenvolvimento integral das pessoas como cidados?</p>',2),
	(2160,1227,'<p>Como a organizao promove o desenvolvimento integral das pessoas como profissionais?</p>',3),
	(2161,1228,'<p>Como so identificados os perigos relacionados  sade ocupacional?</p>',1),
	(2162,1228,'<p>Como so tratados os riscos relacionados  sade ocupacional?</p>',2),
	(2163,1228,'<p>Como so identificados os perigos relacionados  segurana?</p>',3),
	(2164,1228,'<p>Como so tratados os riscos relacionados  segurana?</p>',4),
	(2165,1229,'<p>Como as necessidades das pessoas da fora de trabalho so identificadas?</p>',1),
	(2166,1229,'<p>Como as necessidades das pessoas da fora de trabalho so analisadas?</p>',2),
	(2167,1229,'<p>Como as necessidades das pessoas da fora de trabalho so traduzidas em requisitos de desempenho?</p>',3),
	(2168,1229,'<p>Como as necessidades das pessoas da fora de trabalho so utilizadas para o desenvolvimento de polticas de pessoal?</p>',4),
	(2169,1229,'<p>Como as necessidades das pessoas da fora de trabalho so utilizadas para o desenvolvimento de programas de pessoal?</p>',5),
	(2170,1229,'<p>Como as necessidades das pessoas da fora de trabalho so utilizadas para o desenvolvimento de benefcios?</p>',6),
	(2171,1229,'<p>Como as necessidades do mercado so identificadas?</p>',7),
	(2172,1229,'<p>Como as necessidades do mercado so analisadas?</p>',8),
	(2173,1229,'<p>Como as necessidades do mercado so traduzidas em requisitos de desempenho?</p>',9),
	(2174,1229,'<p>Como as necessidades do mercado so utilizadas para o desenvolvimento de polticas de pessoal?</p>',10),
	(2175,1229,'<p>Como as necessidades do mercado so utilizadas para o desenvolvimento de programas de pessoal?</p>',11),
	(2176,1229,'<p>Como as necessidades do mercado so utilizadas para o desenvolvimento de benefcios?</p>',12),
	(2177,1230,'<p>Como o bem-estar das pessoas  avaliado?</p>',1),
	(2178,1230,'<p>Como a satisfao das pessoas  avaliada?</p>',2),
	(2179,1230,'<p>Como o comprometimento das pessoas  avaliado?</p>',3),
	(2180,1230,'<p>Como o bem-estar das pessoas  desenvolvido?</p>',4),
	(2181,1230,'<p>Como a satisfao das pessoas  desenvolvida?</p>',5),
	(2182,1230,'<p>Como o comprometimento das pessoas  desenvolvido?</p>',6),
	(2183,1231,'<p>Como  mantido um clima organizacional favorvel  criatividade no desempenho profissional das pessoas?</p>',1),
	(2184,1231,'<p>Como  mantido um clima organizacional favorvel  inovao no desempenho profissional das pessoas?</p>',2),
	(2185,1231,'<p>Como  mantido um clima organizacional favorvel  excelncia no desempenho profissional das pessoas?</p>',3),
	(2186,1231,'<p>Como  mantido um clima organizacional favorvel  criatividade no desenvolvimento profissional das pessoas?</p>',4),
	(2187,1231,'<p>Como  mantido um clima organizacional favorvel  inovao no desenvolvimento profissional das pessoas?</p>',5),
	(2188,1231,'<p>Como  mantido um clima organizacional favorvel  excelncia no desenvolvimento profissional das pessoas?</p>',6),
	(2189,1231,'<p>Como  mantido um clima organizacional favorvel  criatividade no desempenho profissional das equipes?</p>',7),
	(2190,1231,'<p>Como  mantido um clima organizacional favorvel  inovao no desempenho profissional das equipes?</p>',8),
	(2191,1231,'<p>Como  mantido um clima organizacional favorvel  excelncia no desempenho profissional das equipes?</p>',9),
	(2192,1231,'<p>Como  mantido um clima organizacional favorvel  criatividade no desenvolvimento profissional das equipes?</p>',10),
	(2193,1231,'<p>Como  mantido um clima organizacional favorvel  inovao no desenvolvimento profissional das equipes?</p>',11),
	(2194,1231,'<p>Como  mantido um clima organizacional favorvel  excelncia no desenvolvimento profissional das equipes?</p>',12),
	(2195,1232,'<p>Como a organizao promove a melhoria da qualidade de vida das pessoas fora do ambiente de trabalho?</p>',1),
	(2196,1233,'<p>Como so definidos os requisitos aplicveis aos produtos da cadeia de valor?</p>',1),
	(2197,1233,'<p>Como so definidos os requisitos aplicveis aos processos da cadeia de valor?</p>',2),
	(2198,1234,'<p>Como so desenvolvidos os novos produtos?</p>',1),
	(2199,1235,'<p>Como so projetados os processos da cadeia de valor?</p>',1),
	(2200,1236,'<p>Como  avaliado o potencial de ideias criativas a serem convertidas em inovaes sustentveis nos produtos?</p>',1),
	(2201,1236,'<p>Como  avaliado o potencial de ideias criativas a serem convertidas em inovaes sustentveis nos processos?</p>',2),
	(2202,1237,'<p>Como  assegurado o atendimento dos requisitos aplicveis aos processos da cadeia de valor?</p>',1),
	(2203,1238,'<p>Como a organizao analisa os produtos da cadeia de valor?</p>',1),
	(2204,1238,'<p>Como a organizao melhora os produtos da cadeia de valor?</p>',2),
	(2205,1238,'<p>Como a organizao analisa os processos da cadeia de valor?</p>',3),
	(2206,1238,'<p>Como a organizao melhora os processos da cadeia de valor?</p>',4),
	(2207,1239,'<p>Como a organizao avalia as novas tecnologias no desenvolvimento dos produtos?</p>',1),
	(2208,1239,'<p>Como a organizao incorpora as novas tecnologias no desenvolvimento dos produtos?</p>',2),
	(2209,1239,'<p>Como a organizao implanta as novas tecnologias no desenvolvimento dos produtos?</p>',3),
	(2210,1239,'<p>Como a organizao avalia as novas tecnologias na melhoria dos produtos?</p>',4),
	(2211,1239,'<p>Como a organizao incorpora as novas tecnologias na melhoria dos produtos?</p>',5),
	(2212,1239,'<p>Como a organizao implanta as novas tecnologias na melhoria dos produtos?</p>',6),
	(2213,1239,'<p>Como a organizao avalia as novas tecnologias no desenvolvimento dos processos da cadeia de valor?</p>',7),
	(2214,1239,'<p>Como a organizao incorpora as novas tecnologias no desenvolvimento dos processos da cadeia de valor?</p>',8),
	(2215,1239,'<p>Como a organizao implanta as novas tecnologias no desenvolvimento dos processos da cadeia de valor?</p>',9),
	(2216,1239,'<p>Como a organizao avalia as novas tecnologias na melhoria dos processos da cadeia de valor?</p>',10),
	(2217,1239,'<p>Como a organizao incorpora as novas tecnologias na melhoria dos processos da cadeia de valor?</p>',11),
	(2218,1239,'<p>Como a organizao implanta as novas tecnologias na melhoria dos processos da cadeia de valor?</p>',12),
	(2219,1240,'<p>Como so investigadas as caractersticas de produtos de concorrentes para buscar melhorias?</p>',1),
	(2220,1240,'<p>Como so investigadas as caractersticas de processos da cadeia de valor de concorrentes para buscar melhorias?</p>',2),
	(2221,1240,'<p>Como so investigadas as caractersticas de produtos de de outras organizaes de referncia para buscar melhorias?</p>',3),
	(2222,1240,'<p>Como so investigadas as caractersticas de processos da cadeia de valor de outras organizaes de referncia para buscar melhorias?</p>',4),
	(2223,1241,'<p>Como a organizao desenvolve a sua cadeia de suprimentos imediata?</p>',1),
	(2224,1241,'<p>Como a organizao identifica potenciais fornecedores da cadeia de suprimentos?</p>',2),
	(2225,1241,'<p>Como a organizao identifica potenciais parceiros da cadeia de suprimentos?</p>',3),
	(2226,1242,'<p>Como as necessidades dos fornecedores so identificadas?</p>',1),
	(2227,1242,'<p>Como as necessidades dos fornecedores so analisadas?</p>',2),
	(2228,1242,'<p>Como as necessidades dos fornecedores so traduzidas em requisitos de desempenho?</p>',3),
	(2229,1242,'<p>Como as necessidades dos fornecedores so utilizadas para a definio das polticas relativas aos fornecedores?</p>',4),
	(2230,1242,'<p>Como as necessidades dos fornecedores so utilizadas para a melhoria das polticas relativas aos fornecedores?</p>',5),
	(2231,1242,'<p>Como as necessidades dos fornecedores so utilizadas para a definio dos programas relativos aos fornecedores?</p>',6),
	(2232,1242,'<p>Como as necessidades dos fornecedores so utilizadas para a melhoria dos programas relativos aos fornecedores?</p>',7),
	(2233,1242,'<p>Como as expectativas dos fornecedores so identificadas?</p>',8),
	(2234,1242,'<p>Como as expectativas dos fornecedores so analisadas?</p>',9),
	(2235,1242,'<p>Como as expectativas dos fornecedores so traduzidas em requisitos de desempenho?</p>',10),
	(2236,1242,'<p>Como as expectativas dos fornecedores so utilizadas para a definio das polticas relativas aos fornecedores?</p>',11),
	(2237,1242,'<p>Como as expectativas dos fornecedores so utilizadas para a melhoria das polticas relativas aos fornecedores?</p>',12),
	(2238,1242,'<p>Como as expectativas dos fornecedores so utilizadas para a definio dos programas relativos aos fornecedores?</p>',13),
	(2239,1242,'<p>Como as expectativas dos fornecedores so utilizadas para a melhoria dos programas relativos aos fornecedores?</p>',14),
	(2240,1243,'<p>Como os fornecedores so qualificados?</p>',1),
	(2241,1243,'<p>Como os fornecedores so selecionados?</p>',2),
	(2242,1244,'<p>Como a organizao monitora o desempenho dos fornecedores, considerando os requisitos de fornecimento?</p>',1),
	(2243,1244,'<p>Como a organizao avalia o desempenho dos fornecedores, considerando os requisitos de fornecimento?</p>',2),
	(2244,1245,'<p>Como a organizao estimula os seus fornecedores a implementar melhorias nos seus processos?</p>',1),
	(2245,1245,'<p>Como a organizao estimula os seus fornecedores a implementar inovaes nos seus processos?</p>',2),
	(2246,1245,'<p>Como a organizao estimula os seus fornecedores a implementar otimizao de custos nos seus processos?</p>',3),
	(2247,1245,'<p>Como a organizao estimula os seus fornecedores a implementar melhorias nos seus produtos?</p>',4),
	(2248,1245,'<p>Como a organizao estimula os seus fornecedores a implementar inovaes nos seus produtos?</p>',5),
	(2249,1245,'<p>Como a organizao estimula os seus fornecedores a implementar otimizao de custos nos seus produtos?</p>',6),
	(2250,1246,'<p>Como a fora de trabalho dos fornecedores, que atuam diretamente nos processos da cadeia de valor da organizao,  comprometida com os valores organizacionais?</p>',1),
	(2251,1246,'<p>Como a fora de trabalho dos fornecedores, que atuam diretamente nos processos da cadeia de valor da organizao,  comprometida com os princpios organizacionais?</p>',2),
	(2252,1246,'<p>Como a fora de trabalho dos fornecedores, que atuam diretamente nos processos da cadeia de valor da organizao,  comprometida com os valores organizacionais relativos  responsabilidade socioambienta?</p>',3),
	(2253,1246,'<p>Como a fora de trabalho dos fornecedores, que atuam diretamente nos processos da cadeia de valor da organizao,  comprometida com os princpios organizacionais relativos  responsabilidade socioambienta?</p>',4),
	(2254,1246,'<p>Como a fora de trabalho dos fornecedores, que atuam diretamente nos processos da cadeia de valor da organizao,  comprometida com os valores organizacionais relativos  sade?</p>',5),
	(2255,1246,'<p>Como a fora de trabalho dos fornecedores, que atuam diretamente nos processos da cadeia de valor da organizao,  comprometida com os princpios organizacionais relativos  sade?</p>',6),
	(2256,1246,'<p>Como a fora de trabalho dos fornecedores, que atuam diretamente nos processos da cadeia de valor da organizao,  comprometida com os valores organizacionais relativos  segurana?</p>',7),
	(2257,1246,'<p>Como a fora de trabalho dos fornecedores, que atuam diretamente nos processos da cadeia de valor da organizao,  comprometida com os princpios organizacionais relativos  segurana?</p>',8),
	(2258,1247,'<p>Como so definidos os requisitos de desempenho econmico-financeiro da organizao?</p>',1),
	(2259,1247,'<p>Como so monitorados os aspectos que causam impacto na sustentabilidade econmica do negcio?</p>',2),
	(2260,1248,'<p>Como a organizao assegura os recursos financeiros necessrios para atender s necessidades operacionais?</p>',1),
	(2261,1248,'<p>Como a organizao assegura os recursos financeiros necessrios para manter equilibrado o fluxo financeiro?</p>',2),
	(2262,1249,'<p>Como a organizao define os recursos financeiros para apoiar as estratgias?</p>',1),
	(2263,1249,'<p>Como a organizao avalia os investimentos para apoiar as estratgias?</p>',2),
	(2264,1249,'<p>Como a organizao define os recursos financeiros para apoiar os planos de ao?</p>',3),
	(2265,1249,'<p>Como a organizao avalia os investimentos para apoiar os planos de ao?</p>',4),
	(2266,1250,'<p>Como  elaborado o oramento?</p>',1),
	(2267,1250,'<p>Como  controlado o oramento?</p>',2),
	(2268,1251,'<p>Apresentar os resultados dos principais indicadores relativos  gesto econmico-financeira.</p>',1),
	(2269,1252,'<p>Apresentar os resultados dos principais indicadores relativos  responsabilidade socioambiental e ao desenvolvimento social.</p>',1),
	(2270,1253,'<p>Apresentar os resultados dos principais indicadores relativos aos clientes e aos mercados-alvo, incluindo os referentes  imagem da organizao.</p>',1),
	(2271,1254,'<p>Apresentar os resultados dos principais indicadores relativos a pessoas, incluindo os referentes ao sistema de trabalho, capacitao e desenvolvimento e qualidade de vida, bem como os referentes  liderana, comunicao e cultura.</p>',1),
	(2272,1255,'<p>Apresentar os resultados dos principais indicadores relativos a produtos, aos processos da cadeia de valor, a fornecedores e a processos de gesto transversais no relacionados aos demais itens deste Critrio.</p>',1);

DELETE FROM pratica_maturidade WHERE pratica_maturidade_id>=38;
INSERT INTO pratica_maturidade (pratica_maturidade_id, pratica_modelo_id, minimo, maximo, descricao) VALUES
	(38,12,851,1000,'<p>Enfoques muito avanados, com praticamente todos os processos gerenciais e complementos para a excelncia atendidos, com proatividade, agilidade e padronizao totalmente incorporadas no sistema de gesto. Aplicao das prticas de gesto com abrangncia quase total e forte controle sobre o sistema de gesto. Aprendizado totalmente incorporado no sistema de gesto, com muitas prticas exemplares e muitas inovaes na gesto. Integrao plena, formando um sistema de gesto muito harmnico entre as prticas, com forte cooperao de partes interessadas e total coerncia com valores, princpios, estratgias e objetivos. Praticamente todos os indicadores de desempenho estratgicos e operacionais necessrios para avaliar as melhorias, a competitividade dos resultados e o cumprimento de compromissos com resultados relativos a requisitos de partes interessadas esto presentes. Melhoria demonstrada em praticamente todos. Praticamente todos os resultados comparveis demonstram competitividade, estando alguns resultados em nvel de liderana no setor ou no mercado, e alguns em nvel de excelncia. Praticamente todos os resultados relativos ao atendimento de necessidades e expectativas de partes interessadas demonstram esse atendimento.</p>'),
  (39,12,751,850,'<p>Enfoques bem avanados, com quase todos os processos gerenciais e complementos para a excelncia atendidos, com proatividade, agilidade e padronizao bem incorporadas no sistema de gesto. Aplicao das prticas de gesto com abrangncia muito boa e controle muito bom sobre o sistema de gesto. Aprendizado muito bem incorporado no sistema de gesto, com muitas prticas exemplares e vrias inovaes na gesto. Integrao quase total, formando um sistema de gesto bastante harmnico entre as prticas, com muito boa cooperao de partes interessadas e forte coerncia com valores, princpios, estratgias e objetivos. Praticamente todos os indicadores de desempenho estratgicos e quase todos os operacionais necessrios para avaliar as melhorias, a competitividade dos resultados e o cumprimento de compromissos com resultados relativos a requisitos de partes interessadas esto presentes. Melhoria demonstrada em quase todos, incluindo todos os estratgicos. Quase todos os resultados comparveis demonstram competitividade, incluindo quase todos os estratgicos, estando alguns resultados em nvel de liderana no setor ou no mercado. Quase todos os resultados relativos ao atendimento de necessidades e expectativas de partes interessadas demonstram esse atendimento.</p>'),
  (40,12,651,750,'<p>Enfoques avanados, com quase todos os processos gerenciais e a maioria dos complementos para a excelncia atendidos, com proatividade, agilidade e padronizao relativamente bem incorporadas no sistema de gesto. Aplicao das prticas de gesto com abrangncia boa e controle bom sobre todo o sistema de gesto. Aprendizado muito bem incorporado no sistema de gesto, com algumas prticas exemplares e algumas inovaes na gesto. Integrao muito forte, formando um sistema de gesto com boa harmonia entre as prticas, boa cooperao de partes interessadas e muito boa coerncia com valores, princpios, estratgias e objetivos. Praticamente todos os indicadores de desempenho estratgicos e a maioria dos operacionais necessrios para avaliar as melhorias, a competitividade dos resultados e o cumprimento de compromissos com resultados relativos a requisitos de partes interessadas esto presentes. Melhoria demonstrada em quase todos, incluindo quase todos estratgicos. A grande maioria dos resultados comparveis demonstra competitividade, incluindo estratgicos, estando muito poucos em nvel de liderana no setor ou no mercado. A grande maioria dos resultados relativos ao atendimento de necessidades e expectativas de partes interessadas demonstram esse atendimento.</p>'),
  (41,12,551,650,'<p>Enfoques bem robustos, com a maioria dos processos gerenciais e complementos para a excelncia atendidos, com proatividade, agilidade e padronizao sendo incorporadas por todo o sistema de gesto. Aplicao das prticas de gesto com abrangncia regular e controle bom sobre partes do sistema de gesto. Aprendizado bem incorporado no sistema de gesto, com muito poucas prticas exemplares e incio de inovao na gesto. Integrao forte, formando um sistema de gesto com harmonia regular entre as prticas, com alguma cooperao de partes interessadas e boa coerncia com valores, princpios, estratgias e objetivos, sem incoerncia grave. Quase todos os indicadores de desempenho estratgicos e a maioria dos operacionais necessrios para avaliar as melhorias, a competitividade dos resultados e o cumprimento de compromissos com resultados relativos a requisitos de partes interessadas esto presentes. Melhoria demonstrada na maioria, incluindo quase todos os estratgicos. A grande maioria dos resultados comparveis demonstra competitividade, incluindo os estratgicos. A grande maioria dos resultados relativos ao atendimento de necessidades e expectativas de partes interessadas demonstram esse atendimento.</p>'),
  (42,12,451,550,'<p>Enfoques robustos, com a maioria dos processos gerenciais e muitos complementos para a excelncia atendidos, com proatividade, agilidade e padronizao sendo incorporadas em partes do sistema de gesto. Aplicao das prticas de gesto com abrangncia irregular e com controle irregular sobre o sistema de gesto. Aprendizado sendo gradativamente incorporado por todo o sistema de gesto. Integrao em construo, desenvolvendo um sistema de gesto com alguma harmonia entre as prticas, com princpios de cooperao de partes interessadas e coerncia razovel com valores, princpios, estratgias e objetivos, sem incoerncia grave. A maioria dos indicadores de desempenho estratgicos e operacionais necessrios para avaliar as melhorias, a competitividade dos resultados e o cumprimento de compromissos com resultados relativos a requisitos de partes interessadas esto presentes. Melhoria demonstrada na maioria, incluindo a maioria dos estratgicos. A maioria dos resultados comparveis demonstra competitividade. A maioria dos resultados relativos ao atendimento de necessidades e expectativas de partes interessadas demonstram esse atendimento</p>'),
  (43,12,351,450,'<p>Enfoques em construo, com muitos processos gerenciais e complementos para a excelncia atendidos, com proatividade, agilidade e padronizao sendo incorporadas em partes do sistema de gesto. Aplicao das prticas de gesto com abrangncia irregular e com controle irregular sobre o sistema de gesto. Aprendizado sendo gradativamente incorporado em partes do sistema de gesto. Integrao em incio de construo, desenvolvendo um sistema de gesto com pouca harmonia entre as prticas, com a cooperao de partes interessadas em fase experimental e coerncia regular com valores, princpios, estratgias e objetivos, sem incoerncia grave. A maioria dos indicadores de desempenho estratgicos e muitos dos operacionais necessrios para avaliar as melhorias, a competitividade dos resultados e o cumprimento de compromissos com resultados relativos a requisitos de partes interessadas esto presentes. Melhoria demonstrada para muitos, vrios estratgicos. Muitos dos resultados comparveis demonstram competitividade. Muitos dos resultados relativos ao atendimento de necessidades e expectativas de partes interessadas demonstram esse atendimento.</p>'),
  (44,12,251,350,'<p>Enfoques incompletos, com poucos processos gerenciais e complementos para a excelncia atendidos, com proatividade, agilidade e padronizao sendo incorporadas em partes do sistema de gesto. Aplicao das prticas de gesto com pequena abrangncia e com controle muito irregular sobre o sistema de gesto. Aprendizado em incio de incorporao em partes do sistema de gesto. Integrao ocasional, desenvolvendo um sistema de gesto com muito pouca harmonia em partes do sistema de gesto, com a cooperao casual de partes interessadas e coerncia irregular com valores, princpios, estratgias e objetivos, sem incoerncia grave. Muitos dos indicadores de desempenho estratgicos e operacionais necessrios para avaliar as melhorias, a competitividade dos resultados e o cumprimento de compromissos com resultados relativos a requisitos de partes interessadas esto presentes. Melhoria demonstrada para alguns, poucos estratgicos. Alguns dos resultados comparveis demonstram competitividade. Alguns dos resultados relativos ao atendimento de necessidades e expectativas de partes interessadas demonstram esse atendimento.</p>'),
  (45,12,151,250,'<p>Enfoques bem incompletos, com muito poucos processos gerenciais e complementos para a excelncia atendidos, com proatividade, agilidade e padronizao incorporadas casualmente em partes do sistema de gesto. Aplicao das prticas de gesto com muito pequena abrangncia e com controle ocasional sobre o sistema de gesto. Aprendizado ocasional em partes do sistema de gesto. Integrao fraca, desenvolvendo um sistema de gesto com muito pouca harmonia entre as prticas, com a cooperao de partes interessadas praticamente inexistente e coerncia fraca com valores, princpios, estratgias e objetivos, podendo ter incoerncia grave. Alguns dos indicadores de desempenho estratgicos e alguns operacionais necessrios para avaliar as melhorias, a competitividade dos resultados e o cumprimento de compromissos com resultados relativos a requisitos de partes interessadas esto presentes. Melhoria demonstrada para poucos. Poucos dos resultados comparveis demonstram competitividade. Poucos dos resultados relativos ao atendimento de necessidades e expectativas de partes interessadas demonstram esse atendimento.</p>'),
  (46,12,0,150,'<p>Enfoques em incio de construo, com muito poucos processos gerenciais e raros complementos para a excelncia atendidos, com proatividade, agilidade e padronizao pouco presentes. Aplicao das prticas de gesto com abrangncia muito limitada e com controle muito irregular sobre o sistema de gesto. Aprendizado raramente incorporado em partes do sistema de gesto. Integrao rara, desenvolvendo um sistema de gesto com harmonia ocasional entre prticas, com a cooperao de partes interessadas inexistente e coerncia muito fraca com valores, princpios, estratgias e objetivos, podendo ter uma ou mais incoerncias graves. Muito poucos indicadores de desempenho estratgicos operacionais necessrios para avaliar as melhorias, a competitividade dos resultados e o cumprimento de compromissos com resultados relativos a requisitos de partes interessadas esto presentes. Melhoria demonstrada para muito poucos. Muito poucos resultados comparveis demonstram competitividade. Muito poucos resultados relativos ao atendimento de necessidades e expectativas de partes interessadas demonstram esse atendimento.</p>');