SET FOREIGN_KEY_CHECKS=0;

DROP TABLE IF EXISTS log;

CREATE TABLE log (
  log_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  log_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	log_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	log_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	log_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	log_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	log_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	log_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	log_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	log_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	log_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	log_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	log_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	log_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	log_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	log_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	log_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	log_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	log_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	log_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	log_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	log_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	log_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	log_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	log_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	log_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	log_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	log_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	log_link INTEGER(100) UNSIGNED DEFAULT NULL,
	log_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	log_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	log_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	log_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	log_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	log_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	log_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	log_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	log_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	log_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	log_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	log_template INTEGER(100) UNSIGNED DEFAULT NULL,
	log_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	log_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	log_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	log_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	log_me INTEGER(100) UNSIGNED DEFAULT NULL,
	log_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	log_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	log_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	log_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	log_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	log_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
  log_criador INTEGER(100) UNSIGNED DEFAULT NULL,
  log_correcao	INTEGER(100) UNSIGNED DEFAULT NULL,
  log_tipo_problema INTEGER(10) DEFAULT 0,
  log_horas DECIMAL(20,5) UNSIGNED DEFAULT 0,
  log_descricao MEDIUMTEXT,
  log_corrigir TINYINT(1) DEFAULT 0,
  log_referencia INTEGER(11) DEFAULT NULL,
  log_nome TEXT,
  log_data DATE DEFAULT NULL,
  log_url_relacionada VARCHAR(250) DEFAULT NULL,
  log_custo decimal(20,5) UNSIGNED DEFAULT 0,
	log_nd varchar(11) DEFAULT NULL,
	log_categoria_economica varchar(1) DEFAULT NULL,
	log_grupo_despesa varchar(1) DEFAULT NULL,
	log_modalidade_aplicacao varchar(2) DEFAULT NULL,
	log_reg_mudanca_inicio datetime DEFAULT NULL,
	log_reg_mudanca_fim datetime DEFAULT NULL,
	log_reg_mudanca_duracao decimal(20,5) UNSIGNED DEFAULT NULL,
	log_reg_mudanca_percentagem decimal(20,5) UNSIGNED DEFAULT NULL,
	log_reg_mudanca_realizado decimal(20,5) UNSIGNED DEFAULT NULL,
	log_reg_mudanca_status INTEGER(100) UNSIGNED DEFAULT '0',
	log_aprovou INTEGER(100) UNSIGNED DEFAULT NULL,
	log_aprovado tinyint(1) DEFAULT NULL,
	log_data_aprovado datetime DEFAULT NULL, 
  log_acesso INTEGER(100) DEFAULT 0,
  PRIMARY KEY (log_id),
  KEY log_criador (log_criador),
  KEY log_correcao (log_correcao),
  KEY log_aprovou (log_aprovou),
	KEY log_projeto (log_projeto),
	KEY log_tarefa (log_tarefa),
	KEY log_perspectiva (log_perspectiva),
	KEY log_tema (log_tema),
	KEY log_objetivo (log_objetivo),
	KEY log_estrategia (log_estrategia),
	KEY log_meta (log_meta),
	KEY log_fator (log_fator),
	KEY log_pratica (log_pratica),
	KEY log_indicador (log_indicador),
	KEY log_acao (log_acao),
	KEY log_canvas (log_canvas),
	KEY log_risco (log_risco),
	KEY log_risco_resposta (log_risco_resposta),
	KEY log_calendario (log_calendario),
	KEY log_monitoramento (log_monitoramento),
	KEY log_ata (log_ata),
	KEY log_mswot(log_mswot),
	KEY log_swot(log_swot),
	KEY log_operativo(log_operativo),
	KEY log_instrumento (log_instrumento),
	KEY log_recurso (log_recurso),
	KEY log_problema (log_problema),
	KEY log_demanda (log_demanda),
	KEY log_programa (log_programa),
	KEY log_licao (log_licao),
	KEY log_evento (log_evento),
	KEY log_link (log_link),
	KEY log_avaliacao (log_avaliacao),
	KEY log_tgn (log_tgn),
	KEY log_brainstorm (log_brainstorm),
	KEY log_gut (log_gut),
	KEY log_causa_efeito (log_causa_efeito),
	KEY log_arquivo (log_arquivo),
	KEY log_forum (log_forum),
	KEY log_checklist (log_checklist),
	KEY log_agenda (log_agenda),
	KEY log_agrupamento (log_agrupamento),
	KEY log_patrocinador (log_patrocinador),
	KEY log_template (log_template),
	KEY log_painel (log_painel),
	KEY log_painel_odometro (log_painel_odometro),
	KEY log_painel_composicao (log_painel_composicao),
	KEY log_tr (log_tr),
	KEY log_me (log_me),
	KEY log_acao_item (log_acao_item),
	KEY log_beneficio (log_beneficio),
	KEY log_painel_slideshow (log_painel_slideshow),
	KEY log_projeto_viabilidade (log_projeto_viabilidade),
	KEY log_projeto_abertura (log_projeto_abertura),
	KEY log_plano_gestao (log_plano_gestao),
  CONSTRAINT log_projeto FOREIGN KEY (log_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_tarefa FOREIGN KEY (log_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_perspectiva FOREIGN KEY (log_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_tema FOREIGN KEY (log_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_objetivo FOREIGN KEY (log_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_fator FOREIGN KEY (log_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_estrategia FOREIGN KEY (log_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_meta FOREIGN KEY (log_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_pratica FOREIGN KEY (log_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_indicador FOREIGN KEY (log_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_acao FOREIGN KEY (log_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_canvas FOREIGN KEY (log_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_risco FOREIGN KEY (log_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_risco_resposta FOREIGN KEY (log_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_calendario FOREIGN KEY (log_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_monitoramento FOREIGN KEY (log_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_ata FOREIGN KEY (log_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_mswot FOREIGN KEY (log_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_swot FOREIGN KEY (log_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_operativo FOREIGN KEY (log_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_instrumento FOREIGN KEY (log_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_recurso FOREIGN KEY (log_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_problema FOREIGN KEY (log_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_demanda FOREIGN KEY (log_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_programa FOREIGN KEY (log_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_licao FOREIGN KEY (log_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_evento FOREIGN KEY (log_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_link FOREIGN KEY (log_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_avaliacao FOREIGN KEY (log_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_tgn FOREIGN KEY (log_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_brainstorm FOREIGN KEY (log_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_gut FOREIGN KEY (log_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_causa_efeito FOREIGN KEY (log_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_arquivo FOREIGN KEY (log_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_forum FOREIGN KEY (log_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_checklist FOREIGN KEY (log_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_agenda FOREIGN KEY (log_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_agrupamento FOREIGN KEY (log_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_patrocinador FOREIGN KEY (log_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_template FOREIGN KEY (log_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_painel FOREIGN KEY (log_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_painel_odometro FOREIGN KEY (log_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_painel_composicao FOREIGN KEY (log_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_tr FOREIGN KEY (log_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_me FOREIGN KEY (log_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_acao_item FOREIGN KEY (log_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_beneficio FOREIGN KEY (log_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_painel_slideshow FOREIGN KEY (log_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_projeto_viabilidade FOREIGN KEY (log_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_projeto_abertura FOREIGN KEY (log_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_plano_gestao FOREIGN KEY (log_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT log_criador FOREIGN KEY (log_criador) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT log_correcao FOREIGN KEY (log_correcao) REFERENCES log (log_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT log_aprovou FOREIGN KEY (log_aprovou) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS log_arquivo;

CREATE TABLE log_arquivo (
  log_arquivo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  log_arquivo_log INTEGER(100) UNSIGNED DEFAULT NULL,
  log_arquivo_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  log_arquivo_ordem INTEGER(11) DEFAULT 0,
  log_arquivo_endereco VARCHAR(150) DEFAULT NULL,
  log_arquivo_data DATETIME DEFAULT NULL,
  log_arquivo_nome VARCHAR(255) DEFAULT NULL,
  log_arquivo_nome_real VARCHAR(255) DEFAULT NULL,
	log_arquivo_local VARCHAR (255) DEFAULT NULL,
  log_arquivo_tipo VARCHAR(50) DEFAULT NULL,
  log_arquivo_extensao VARCHAR(50) DEFAULT NULL,
  log_arquivo_tamanho INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (log_arquivo_id),
  KEY log_arquivo_log (log_arquivo_log),
  KEY log_arquivo_usuario (log_arquivo_usuario),
  CONSTRAINT log_arquivos_fk FOREIGN KEY (log_arquivo_log) REFERENCES log (log_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT log_arquivos_fk1 FOREIGN KEY (log_arquivo_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_log_arquivo;

CREATE TABLE baseline_log_arquivo (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
  log_arquivo_id INTEGER(100) UNSIGNED NOT NULL,
  log_arquivo_log INTEGER(100) UNSIGNED DEFAULT NULL,
  log_arquivo_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  log_arquivo_ordem INTEGER(11) DEFAULT 0,
  log_arquivo_endereco VARCHAR(150) DEFAULT NULL,
  log_arquivo_data DATETIME DEFAULT NULL,
  log_arquivo_nome VARCHAR(255) DEFAULT NULL,
  log_arquivo_nome_real VARCHAR(255) DEFAULT NULL,
	log_arquivo_local VARCHAR (255) DEFAULT NULL,
  log_arquivo_tipo VARCHAR(50) DEFAULT NULL,
  log_arquivo_extensao VARCHAR(50) DEFAULT NULL,
  log_arquivo_tamanho INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (baseline_id, log_arquivo_id),
  CONSTRAINT baseline_log_arquivo FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_log;

CREATE TABLE baseline_log (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
  log_id INTEGER(100) UNSIGNED NOT NULL,
  log_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	log_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	log_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	log_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	log_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	log_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	log_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	log_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	log_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	log_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	log_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	log_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	log_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	log_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	log_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	log_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	log_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	log_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	log_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	log_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	log_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	log_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	log_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	log_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	log_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	log_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	log_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	log_link INTEGER(100) UNSIGNED DEFAULT NULL,
	log_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	log_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	log_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	log_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	log_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	log_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	log_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	log_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	log_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	log_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	log_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	log_template INTEGER(100) UNSIGNED DEFAULT NULL,
	log_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	log_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	log_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	log_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	log_me INTEGER(100) UNSIGNED DEFAULT NULL,
	log_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	log_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	log_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	log_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	log_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	log_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
  log_criador INTEGER(100) UNSIGNED DEFAULT NULL,
  log_correcao	INTEGER(100) UNSIGNED DEFAULT NULL,
  log_tipo_problema INTEGER(10) DEFAULT 0,
  log_horas DECIMAL(20,5) UNSIGNED DEFAULT 0,
  log_descricao TEXT,
  log_corrigir TINYINT(1) DEFAULT 0,
  log_referencia INTEGER(11) DEFAULT NULL,
  log_nome VARCHAR(200) DEFAULT NULL,
  log_data DATETIME DEFAULT NULL,
  log_url_relacionada VARCHAR(250) DEFAULT NULL,
  log_custo decimal(20,5) UNSIGNED DEFAULT 0,
	log_nd varchar(11) DEFAULT NULL,
	log_categoria_economica varchar(1) DEFAULT NULL,
	log_grupo_despesa varchar(1) DEFAULT NULL,
	log_modalidade_aplicacao varchar(2) DEFAULT NULL,
	log_reg_mudanca_inicio datetime DEFAULT NULL,
	log_reg_mudanca_fim datetime DEFAULT NULL,
	log_reg_mudanca_duracao decimal(20,5) UNSIGNED DEFAULT NULL,
	log_reg_mudanca_percentagem decimal(20,5) UNSIGNED DEFAULT NULL,
	log_reg_mudanca_realizado decimal(20,5) UNSIGNED DEFAULT NULL,
	log_reg_mudanca_status INTEGER(100) UNSIGNED DEFAULT '0',
	log_aprovou INTEGER(100) UNSIGNED DEFAULT NULL,
	log_aprovado tinyint(1) DEFAULT NULL,
	log_data_aprovado datetime DEFAULT NULL, 
  log_acesso INTEGER(100) DEFAULT 0,
  PRIMARY KEY (baseline_id, log_id),
  CONSTRAINT baseline_log FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS patrocinadores;

CREATE TABLE patrocinadores (
  patrocinador_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  patrocinador_nome TEXT,
  patrocinador_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  patrocinador_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  patrocinador_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  patrocinador_descricao MEDIUMTEXT,
  patrocinador_endereco1 VARCHAR(100) DEFAULT '',
  patrocinador_endereco2 VARCHAR(100) DEFAULT '',
  patrocinador_cidade VARCHAR(50) DEFAULT '',
  patrocinador_estado VARCHAR(30) DEFAULT '',
  patrocinador_cep VARCHAR(9) DEFAULT '',
  patrocinador_pais VARCHAR(30) NOT NULL DEFAULT '',
  patrocinador_cpf VARCHAR(14) DEFAULT NULL,
  patrocinador_cnpj VARCHAR(18) DEFAULT NULL,
  patrocinador_email VARCHAR(60) DEFAULT NULL,
  patrocinador_url VARCHAR(255) DEFAULT NULL,
  patrocinador_tel VARCHAR(20) DEFAULT NULL,
  patrocinador_tel2 VARCHAR(20) DEFAULT NULL,
  patrocinador_cel VARCHAR(20) DEFAULT NULL,
  patrocinador_cor VARCHAR(6) DEFAULT 'FFFFFF',
  patrocinador_ativo TINYINT(1) DEFAULT 1,
  patrocinador_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  patrocinador_tipo VARCHAR(50) DEFAULT NULL,
  patrocinador_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
  patrocinador_aprovado TINYINT(1) DEFAULT 0,
  PRIMARY KEY (patrocinador_id),
  KEY patrocinador_cia (patrocinador_cia),
  KEY patrocinador_dept (patrocinador_dept),
  KEY patrocinador_responsavel (patrocinador_responsavel),
  KEY patrocinador_moeda (patrocinador_moeda),
  CONSTRAINT patrocinador_cia FOREIGN KEY (patrocinador_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT patrocinador_responsavel FOREIGN KEY (patrocinador_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT patrocinador_dept FOREIGN KEY (patrocinador_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT patrocinador_moeda FOREIGN KEY (patrocinador_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE 
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS patrocinadores_depts;

CREATE TABLE patrocinadores_depts (
  patrocinador_id INTEGER(100) UNSIGNED NOT NULL,
  dept_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (patrocinador_id, dept_id),
  KEY patrocinador_id (patrocinador_id),
  KEY dept_id (dept_id)
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS patrocinadores_instrumentos;

CREATE TABLE patrocinadores_instrumentos (
  patrocinador_id INTEGER(100) UNSIGNED NOT NULL,
  instrumento_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (patrocinador_id, instrumento_id),
  KEY patrocinador_id (patrocinador_id),
  KEY instrumento_id (instrumento_id)
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS patrocinadores_log;

CREATE TABLE patrocinadores_log (
  patrocinador_log_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  patrocinador_log_horas FLOAT DEFAULT NULL,
  patrocinador_log_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
  patrocinador_log_descricao TEXT,
  patrocinador_log_custo FLOAT(100,3) DEFAULT 0,
  patrocinador_log_nd VARCHAR(11) DEFAULT NULL,
  patrocinador_log_categoria_economica VARCHAR(1) DEFAULT NULL,
  patrocinador_log_grupo_despesa VARCHAR(1) DEFAULT NULL,
  patrocinador_log_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  patrocinador_log_problema TINYINT(1) DEFAULT 0,
  patrocinador_log_criador INTEGER(100) UNSIGNED DEFAULT NULL,
  patrocinador_log_referencia INTEGER(11) DEFAULT NULL,
  patrocinador_log_nome VARCHAR(200) DEFAULT NULL,
  patrocinador_log_data DATETIME DEFAULT NULL,
  patrocinador_log_url_relacionada VARCHAR(250) DEFAULT NULL,
  patrocinador_log_acesso INTEGER(100) DEFAULT 0,
  PRIMARY KEY (patrocinador_log_id)
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS patrocinadores_usuarios;

CREATE TABLE patrocinadores_usuarios (
  patrocinador_id INTEGER(100) UNSIGNED NOT NULL,
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (patrocinador_id, usuario_id),
  KEY patrocinador_id (patrocinador_id),
  KEY usuario_id (usuario_id)
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS aviso;

CREATE TABLE aviso (
  aviso_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  aviso_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  aviso_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  aviso_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  aviso_nome VARCHAR(250) DEFAULT NULL,
  aviso_inicio DATE DEFAULT NULL,
  aviso_fim DATE DEFAULT NULL,
  aviso_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  aviso_cor VARCHAR(6) DEFAULT 'FFFFFF',
  aviso_descricao MEDIUMTEXT,
  aviso_ativo TINYINT(1) DEFAULT 1,
  aviso_repetitivo TINYINT(1) DEFAULT 0,
  aviso_aprovado TINYINT(1) DEFAULT 0,
  PRIMARY KEY (aviso_id),
  KEY aviso_cia (aviso_cia),
  KEY aviso_dept (aviso_dept),
  KEY aviso_usuario (aviso_usuario),
  CONSTRAINT aviso_cia FOREIGN KEY (aviso_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT aviso_dept FOREIGN KEY (aviso_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT aviso_usuario FOREIGN KEY (aviso_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS aviso_leitura;

CREATE TABLE aviso_leitura (
	aviso_leitura_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  aviso_leitura_aviso INTEGER(100) UNSIGNED NOT NULL,
  aviso_leitura_usuario INTEGER(100) UNSIGNED NOT NULL,
  aviso_leitura_data DATETIME DEFAULT NULL,
  PRIMARY KEY (aviso_leitura_id),
  KEY aviso_leitura_aviso (aviso_leitura_aviso),
  KEY aviso_leitura_usuario (aviso_leitura_usuario),
  CONSTRAINT aviso_leitura_aviso FOREIGN KEY (aviso_leitura_aviso) REFERENCES aviso (aviso_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT aviso_leitura_usuario FOREIGN KEY (aviso_leitura_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB;

DROP TABLE IF EXISTS aviso_usuario;

CREATE TABLE aviso_usuario (
  aviso_usuario_aviso INTEGER(100) UNSIGNED NOT NULL,
  aviso_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (aviso_usuario_aviso, aviso_usuario_usuario),
  KEY aviso_usuario_aviso (aviso_usuario_aviso),
  KEY aviso_usuario_usuario (aviso_usuario_usuario),
  CONSTRAINT aviso_usuario_aviso FOREIGN KEY (aviso_usuario_aviso) REFERENCES aviso (aviso_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT aviso_usuario_usuario FOREIGN KEY (aviso_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB;


DROP TABLE IF EXISTS aviso_cia;

CREATE TABLE aviso_cia (
  aviso_cia_aviso INTEGER(100) UNSIGNED NOT NULL,
  aviso_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (aviso_cia_aviso, aviso_cia_cia),
  KEY aviso_cia_aviso (aviso_cia_aviso),
  KEY aviso_cia_cia (aviso_cia_cia),
  CONSTRAINT aviso_cia_cia FOREIGN KEY (aviso_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT aviso_cia_aviso FOREIGN KEY (aviso_cia_aviso) REFERENCES aviso (aviso_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS aviso_dept;

CREATE TABLE aviso_dept (
  aviso_dept_aviso INTEGER(100) UNSIGNED NOT NULL,
  aviso_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (aviso_dept_aviso, aviso_dept_dept),
  KEY aviso_dept_aviso (aviso_dept_aviso),
  KEY aviso_dept_dept (aviso_dept_dept),
  CONSTRAINT aviso_dept_aviso FOREIGN KEY (aviso_dept_aviso) REFERENCES aviso (aviso_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT aviso_dept_dept FOREIGN KEY (aviso_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS aviso_para_cia;

CREATE TABLE aviso_para_cia (
  aviso_para_cia_aviso INTEGER(100) UNSIGNED NOT NULL,
  aviso_para_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (aviso_para_cia_aviso, aviso_para_cia_cia),
  KEY aviso_para_cia_aviso (aviso_para_cia_aviso),
  KEY aviso_para_cia_cia (aviso_para_cia_cia),
  CONSTRAINT aviso_para_cia_cia FOREIGN KEY (aviso_para_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT aviso_para_cia_aviso FOREIGN KEY (aviso_para_cia_aviso) REFERENCES aviso (aviso_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS aviso_para_dept;

CREATE TABLE aviso_para_dept (
  aviso_para_dept_aviso INTEGER(100) UNSIGNED NOT NULL,
  aviso_para_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (aviso_para_dept_aviso, aviso_para_dept_dept),
  KEY aviso_para_dept_aviso (aviso_para_dept_aviso),
  KEY aviso_para_dept_dept (aviso_para_dept_dept),
  CONSTRAINT aviso_para_dept_aviso FOREIGN KEY (aviso_para_dept_aviso) REFERENCES aviso (aviso_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT aviso_para_dept_dept FOREIGN KEY (aviso_para_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS tr_campo;

CREATE TABLE tr_campo (
  tr_campo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  tr_campo_tr INTEGER(100) UNSIGNED DEFAULT NULL,
  tr_campo_tipo VARCHAR(50) DEFAULT NULL,
 	tr_campo_texto MEDIUMTEXT,
  PRIMARY KEY (tr_campo_id),
  KEY tr_campo_tr (tr_campo_tr),
  CONSTRAINT tr_campo_tr FOREIGN KEY (tr_campo_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE
 )ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS tr_multiplo;

CREATE TABLE tr_multiplo (
  tr_multiplo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  tr_multiplo_tr INTEGER(100) UNSIGNED DEFAULT NULL,
  tr_multiplo_tipo VARCHAR(50) DEFAULT NULL,
 	tr_multiplo_valor INTEGER(10) UNSIGNED DEFAULT NULL,
 	tr_multiplo_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (tr_multiplo_id),
  KEY tr_multiplo_tr (tr_multiplo_tr),
  CONSTRAINT tr_multiplo_tr FOREIGN KEY (tr_multiplo_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE
 )ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS tr_usuario;

CREATE TABLE tr_usuario (
  tr_usuario_tr INTEGER(100) UNSIGNED NOT NULL,
  tr_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (tr_usuario_tr, tr_usuario_usuario),
  KEY tr_usuario_tr (tr_usuario_tr),
  KEY tr_usuario_usuario (tr_usuario_usuario),
  CONSTRAINT tr_usuario_tr FOREIGN KEY (tr_usuario_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tr_usuario_usuario FOREIGN KEY (tr_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB;

DROP TABLE IF EXISTS tr_dept;

CREATE TABLE tr_dept (
  tr_dept_tr INTEGER(100) UNSIGNED NOT NULL,
  tr_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (tr_dept_tr, tr_dept_dept),
  KEY tr_dept_tr (tr_dept_tr),
  KEY tr_dept_dept (tr_dept_dept),
  CONSTRAINT tr_dept_tr FOREIGN KEY (tr_dept_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tr_dept_dept FOREIGN KEY (tr_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS tr_gestao;

CREATE TABLE tr_gestao (
	tr_gestao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	tr_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY tr_gestao_id (tr_gestao_id),
	KEY tr_gestao_tr (tr_gestao_tr),
	KEY tr_gestao_semelhante (tr_gestao_semelhante),
	KEY tr_gestao_projeto (tr_gestao_projeto),
	KEY tr_gestao_tarefa (tr_gestao_tarefa),
	KEY tr_gestao_perspectiva (tr_gestao_perspectiva),
	KEY tr_gestao_tema (tr_gestao_tema),
	KEY tr_gestao_objetivo (tr_gestao_objetivo),
	KEY tr_gestao_estrategia (tr_gestao_estrategia),
	KEY tr_gestao_meta (tr_gestao_meta),
	KEY tr_gestao_fator (tr_gestao_fator),
	KEY tr_gestao_pratica (tr_gestao_pratica),
	KEY tr_gestao_indicador (tr_gestao_indicador),
	KEY tr_gestao_acao (tr_gestao_acao),
	KEY tr_gestao_canvas (tr_gestao_canvas),
	KEY tr_gestao_risco (tr_gestao_risco),
	KEY tr_gestao_risco_resposta (tr_gestao_risco_resposta),
	KEY tr_gestao_calendario (tr_gestao_calendario),
	KEY tr_gestao_monitoramento (tr_gestao_monitoramento),
	KEY tr_gestao_ata (tr_gestao_ata),
	KEY tr_gestao_mswot(tr_gestao_mswot),
	KEY tr_gestao_swot(tr_gestao_swot),
	KEY tr_gestao_operativo(tr_gestao_operativo),
	KEY tr_gestao_instrumento (tr_gestao_instrumento),
	KEY tr_gestao_recurso (tr_gestao_recurso),
	KEY tr_gestao_problema (tr_gestao_problema),
	KEY tr_gestao_demanda (tr_gestao_demanda),
	KEY tr_gestao_programa (tr_gestao_programa),
	KEY tr_gestao_licao (tr_gestao_licao),
	KEY tr_gestao_evento (tr_gestao_evento),
	KEY tr_gestao_link (tr_gestao_link),
	KEY tr_gestao_avaliacao (tr_gestao_avaliacao),
	KEY tr_gestao_tgn (tr_gestao_tgn),
	KEY tr_gestao_brainstorm (tr_gestao_brainstorm),
	KEY tr_gestao_gut (tr_gestao_gut),
	KEY tr_gestao_causa_efeito (tr_gestao_causa_efeito),
	KEY tr_gestao_arquivo (tr_gestao_arquivo),
	KEY tr_gestao_forum (tr_gestao_forum),
	KEY tr_gestao_checklist (tr_gestao_checklist),
	KEY tr_gestao_agenda (tr_gestao_agenda),
	KEY tr_gestao_agrupamento (tr_gestao_agrupamento),
	KEY tr_gestao_patrocinador (tr_gestao_patrocinador),
	KEY tr_gestao_template (tr_gestao_template),
	KEY tr_gestao_painel (tr_gestao_painel),
	KEY tr_gestao_painel_composicao (tr_gestao_painel_composicao),
	KEY tr_gestao_painel_odometro (tr_gestao_painel_odometro),
	KEY tr_gestao_me (tr_gestao_me),
	KEY tr_gestao_acao_item (tr_gestao_acao_item),
	KEY tr_gestao_beneficio (tr_gestao_beneficio),
	KEY tr_gestao_painel_slideshow (tr_gestao_painel_slideshow),
	KEY tr_gestao_projeto_viabilidade (tr_gestao_projeto_viabilidade),
	KEY tr_gestao_projeto_abertura (tr_gestao_projeto_abertura),
	KEY tr_gestao_plano_gestao (tr_gestao_plano_gestao),
	CONSTRAINT tr_gestao_tr FOREIGN KEY (tr_gestao_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_semelhante FOREIGN KEY (tr_gestao_semelhante) REFERENCES tr (tr_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_projeto FOREIGN KEY (tr_gestao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_tarefa FOREIGN KEY (tr_gestao_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_perspectiva FOREIGN KEY (tr_gestao_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_tema FOREIGN KEY (tr_gestao_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_objetivo FOREIGN KEY (tr_gestao_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_fator FOREIGN KEY (tr_gestao_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_estrategia FOREIGN KEY (tr_gestao_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_meta FOREIGN KEY (tr_gestao_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_pratica FOREIGN KEY (tr_gestao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_indicador FOREIGN KEY (tr_gestao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_acao FOREIGN KEY (tr_gestao_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_canvas FOREIGN KEY (tr_gestao_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_risco FOREIGN KEY (tr_gestao_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_risco_resposta FOREIGN KEY (tr_gestao_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_calendario FOREIGN KEY (tr_gestao_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_monitoramento FOREIGN KEY (tr_gestao_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_ata FOREIGN KEY (tr_gestao_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_mswot FOREIGN KEY (tr_gestao_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_swot FOREIGN KEY (tr_gestao_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_operativo FOREIGN KEY (tr_gestao_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_instrumento FOREIGN KEY (tr_gestao_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_recurso FOREIGN KEY (tr_gestao_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_problema FOREIGN KEY (tr_gestao_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_demanda FOREIGN KEY (tr_gestao_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_programa FOREIGN KEY (tr_gestao_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_licao FOREIGN KEY (tr_gestao_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_evento FOREIGN KEY (tr_gestao_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_link FOREIGN KEY (tr_gestao_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_avaliacao FOREIGN KEY (tr_gestao_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_tgn FOREIGN KEY (tr_gestao_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_brainstorm FOREIGN KEY (tr_gestao_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_gut FOREIGN KEY (tr_gestao_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_causa_efeito FOREIGN KEY (tr_gestao_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_arquivo FOREIGN KEY (tr_gestao_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_forum FOREIGN KEY (tr_gestao_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_checklist FOREIGN KEY (tr_gestao_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_agenda FOREIGN KEY (tr_gestao_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_agrupamento FOREIGN KEY (tr_gestao_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_patrocinador FOREIGN KEY (tr_gestao_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_template FOREIGN KEY (tr_gestao_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_painel FOREIGN KEY (tr_gestao_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_painel_odometro FOREIGN KEY (tr_gestao_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_painel_composicao FOREIGN KEY (tr_gestao_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_me FOREIGN KEY (tr_gestao_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_acao_item FOREIGN KEY (tr_gestao_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_beneficio FOREIGN KEY (tr_gestao_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_painel_slideshow FOREIGN KEY (tr_gestao_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_projeto_viabilidade FOREIGN KEY (tr_gestao_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_projeto_abertura FOREIGN KEY (tr_gestao_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_plano_gestao FOREIGN KEY (tr_gestao_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS agrupamento_config;

CREATE TABLE agrupamento_config (
	agrupamento_config_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	agrupamento_config_cia INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_config_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  agrupamento_config_lista VARCHAR(255),
  agrupamento_config_detalhe VARCHAR(255),
  PRIMARY KEY (agrupamento_config_id),
  KEY agrupamento_config_cia (agrupamento_config_cia),
  KEY agrupamento_config_usuario (agrupamento_config_usuario),
  CONSTRAINT agrupamento_config_fk1 FOREIGN KEY (agrupamento_config_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT agrupamento_config_fk2 FOREIGN KEY (agrupamento_config_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB;

DROP TABLE IF EXISTS agrupamento_dept;

CREATE TABLE agrupamento_dept (
  agrupamento_dept_agrupamento INTEGER(100) UNSIGNED NOT NULL,
  agrupamento_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (agrupamento_dept_agrupamento, agrupamento_dept_dept),
  KEY agrupamento_dept_agrupamento (agrupamento_dept_agrupamento),
  KEY agrupamento_dept_dept (agrupamento_dept_dept),
  CONSTRAINT agrupamento_dept_dept FOREIGN KEY (agrupamento_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT agrupamento_dept_agrupamento FOREIGN KEY (agrupamento_dept_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB;


DROP TABLE IF EXISTS agrupamento_usuario;

CREATE TABLE agrupamento_usuario (
	agrupamento_usuario_agrupamento INTEGER(100) UNSIGNED NOT NULL,
	agrupamento_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
	PRIMARY KEY (agrupamento_usuario_agrupamento, agrupamento_usuario_usuario),
	KEY agrupamento_usuario_agrupamento (agrupamento_usuario_agrupamento),
	KEY agrupamento_usuario_usuario (agrupamento_usuario_usuario),
	CONSTRAINT agrupamento_usuario_agrupamento FOREIGN KEY (agrupamento_usuario_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_usuario_usuario FOREIGN KEY (agrupamento_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS agrupamento_projeto;

CREATE TABLE agrupamento_projeto (
	agrupamento_projeto_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  agrupamento_projeto_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
  agrupamento_projeto_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  agrupamento_projeto_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (agrupamento_projeto_id),
  KEY agrupamento_projeto_agrupamento (agrupamento_projeto_agrupamento),
  KEY agrupamento_projeto_projeto (agrupamento_projeto_projeto),
  CONSTRAINT agrupamento_projeto_fk FOREIGN KEY (agrupamento_projeto_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT agrupamento_projeto_fk1 FOREIGN KEY (agrupamento_projeto_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS agrupamento_gestao;

CREATE TABLE agrupamento_gestao (
	agrupamento_gestao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	agrupamento_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY agrupamento_gestao_id (agrupamento_gestao_id),
	KEY agrupamento_gestao_agrupamento (agrupamento_gestao_agrupamento),
	KEY agrupamento_gestao_semelhante (agrupamento_gestao_semelhante),
	KEY agrupamento_gestao_projeto (agrupamento_gestao_projeto),
	KEY agrupamento_gestao_tarefa (agrupamento_gestao_tarefa),
	KEY agrupamento_gestao_perspectiva (agrupamento_gestao_perspectiva),
	KEY agrupamento_gestao_tema (agrupamento_gestao_tema),
	KEY agrupamento_gestao_objetivo (agrupamento_gestao_objetivo),
	KEY agrupamento_gestao_estrategia (agrupamento_gestao_estrategia),
	KEY agrupamento_gestao_meta (agrupamento_gestao_meta),
	KEY agrupamento_gestao_fator (agrupamento_gestao_fator),
	KEY agrupamento_gestao_pratica (agrupamento_gestao_pratica),
	KEY agrupamento_gestao_indicador (agrupamento_gestao_indicador),
	KEY agrupamento_gestao_acao (agrupamento_gestao_acao),
	KEY agrupamento_gestao_canvas (agrupamento_gestao_canvas),
	KEY agrupamento_gestao_risco (agrupamento_gestao_risco),
	KEY agrupamento_gestao_risco_resposta (agrupamento_gestao_risco_resposta),
	KEY agrupamento_gestao_calendario (agrupamento_gestao_calendario),
	KEY agrupamento_gestao_monitoramento (agrupamento_gestao_monitoramento),
	KEY agrupamento_gestao_ata (agrupamento_gestao_ata),
	KEY agrupamento_gestao_mswot(agrupamento_gestao_mswot),
	KEY agrupamento_gestao_swot(agrupamento_gestao_swot),
	KEY agrupamento_gestao_operativo(agrupamento_gestao_operativo),
	KEY agrupamento_gestao_instrumento (agrupamento_gestao_instrumento),
	KEY agrupamento_gestao_recurso (agrupamento_gestao_recurso),
	KEY agrupamento_gestao_problema (agrupamento_gestao_problema),
	KEY agrupamento_gestao_demanda (agrupamento_gestao_demanda),
	KEY agrupamento_gestao_programa (agrupamento_gestao_programa),
	KEY agrupamento_gestao_licao (agrupamento_gestao_licao),
	KEY agrupamento_gestao_evento (agrupamento_gestao_evento),
	KEY agrupamento_gestao_link (agrupamento_gestao_link),
	KEY agrupamento_gestao_avaliacao (agrupamento_gestao_avaliacao),
	KEY agrupamento_gestao_tgn (agrupamento_gestao_tgn),
	KEY agrupamento_gestao_brainstorm (agrupamento_gestao_brainstorm),
	KEY agrupamento_gestao_gut (agrupamento_gestao_gut),
	KEY agrupamento_gestao_causa_efeito (agrupamento_gestao_causa_efeito),
	KEY agrupamento_gestao_arquivo (agrupamento_gestao_arquivo),
	KEY agrupamento_gestao_forum (agrupamento_gestao_forum),
	KEY agrupamento_gestao_checklist (agrupamento_gestao_checklist),
	KEY agrupamento_gestao_agenda (agrupamento_gestao_agenda),
	KEY agrupamento_gestao_patrocinador (agrupamento_gestao_patrocinador),
	KEY agrupamento_gestao_template (agrupamento_gestao_template),
	KEY agrupamento_gestao_painel (agrupamento_gestao_painel),
	KEY agrupamento_gestao_painel_odometro (agrupamento_gestao_painel_odometro),
	KEY agrupamento_gestao_painel_composicao (agrupamento_gestao_painel_composicao),
	KEY agrupamento_gestao_tr (agrupamento_gestao_tr),
	KEY agrupamento_gestao_me (agrupamento_gestao_me),
	KEY agrupamento_gestao_acao_item (agrupamento_gestao_acao_item),
	KEY agrupamento_gestao_beneficio (agrupamento_gestao_beneficio),
	KEY agrupamento_gestao_painel_slideshow (agrupamento_gestao_painel_slideshow),
	KEY agrupamento_gestao_projeto_viabilidade (agrupamento_gestao_projeto_viabilidade),
	KEY agrupamento_gestao_projeto_abertura (agrupamento_gestao_projeto_abertura),
	KEY agrupamento_gestao_plano_gestao (agrupamento_gestao_plano_gestao),
	CONSTRAINT agrupamento_gestao_agrupamento FOREIGN KEY (agrupamento_gestao_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_semelhante FOREIGN KEY (agrupamento_gestao_semelhante) REFERENCES agrupamento (agrupamento_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_projeto FOREIGN KEY (agrupamento_gestao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_tarefa FOREIGN KEY (agrupamento_gestao_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_perspectiva FOREIGN KEY (agrupamento_gestao_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_tema FOREIGN KEY (agrupamento_gestao_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_objetivo FOREIGN KEY (agrupamento_gestao_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_fator FOREIGN KEY (agrupamento_gestao_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_estrategia FOREIGN KEY (agrupamento_gestao_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_meta FOREIGN KEY (agrupamento_gestao_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_pratica FOREIGN KEY (agrupamento_gestao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_indicador FOREIGN KEY (agrupamento_gestao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_acao FOREIGN KEY (agrupamento_gestao_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_canvas FOREIGN KEY (agrupamento_gestao_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_risco FOREIGN KEY (agrupamento_gestao_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_risco_resposta FOREIGN KEY (agrupamento_gestao_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_calendario FOREIGN KEY (agrupamento_gestao_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_monitoramento FOREIGN KEY (agrupamento_gestao_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_ata FOREIGN KEY (agrupamento_gestao_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_mswot FOREIGN KEY (agrupamento_gestao_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_swot FOREIGN KEY (agrupamento_gestao_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_operativo FOREIGN KEY (agrupamento_gestao_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_instrumento FOREIGN KEY (agrupamento_gestao_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_recurso FOREIGN KEY (agrupamento_gestao_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_problema FOREIGN KEY (agrupamento_gestao_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_demanda FOREIGN KEY (agrupamento_gestao_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_programa FOREIGN KEY (agrupamento_gestao_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_licao FOREIGN KEY (agrupamento_gestao_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_evento FOREIGN KEY (agrupamento_gestao_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_link FOREIGN KEY (agrupamento_gestao_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_avaliacao FOREIGN KEY (agrupamento_gestao_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_tgn FOREIGN KEY (agrupamento_gestao_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_brainstorm FOREIGN KEY (agrupamento_gestao_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_gut FOREIGN KEY (agrupamento_gestao_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_causa_efeito FOREIGN KEY (agrupamento_gestao_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_arquivo FOREIGN KEY (agrupamento_gestao_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_forum FOREIGN KEY (agrupamento_gestao_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_checklist FOREIGN KEY (agrupamento_gestao_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_agenda FOREIGN KEY (agrupamento_gestao_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_patrocinador FOREIGN KEY (agrupamento_gestao_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_template FOREIGN KEY (agrupamento_gestao_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_painel FOREIGN KEY (agrupamento_gestao_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_painel_odometro FOREIGN KEY (agrupamento_gestao_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_painel_composicao FOREIGN KEY (agrupamento_gestao_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_tr FOREIGN KEY (agrupamento_gestao_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_me FOREIGN KEY (agrupamento_gestao_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_acao_item FOREIGN KEY (agrupamento_gestao_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_beneficio FOREIGN KEY (agrupamento_gestao_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_painel_slideshow FOREIGN KEY (agrupamento_gestao_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_projeto_viabilidade FOREIGN KEY (agrupamento_gestao_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_projeto_abertura FOREIGN KEY (agrupamento_gestao_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_plano_gestao FOREIGN KEY (agrupamento_gestao_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS swot_depts;

CREATE TABLE swot_depts (
  swot_id INTEGER(100) UNSIGNED NOT NULL,
  dept_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (swot_id, dept_id),
  KEY swot_id (swot_id),
  KEY dept_id (dept_id),
  CONSTRAINT swot_depts_fk1 FOREIGN KEY (dept_id) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT swot_depts_fk FOREIGN KEY (swot_id) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS swot_log;

CREATE TABLE swot_log (
  swot_log_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  swot_log_meta INTEGER(100) UNSIGNED DEFAULT NULL,
  swot_log_criador INTEGER(100) UNSIGNED DEFAULT NULL,
  swot_log_horas DECIMAL(20,5) UNSIGNED DEFAULT 0,
  swot_log_descricao TEXT,
  swot_log_custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
  swot_log_nd VARCHAR(11) DEFAULT NULL,
  swot_log_categoria_economica VARCHAR(1) DEFAULT NULL,
  swot_log_grupo_despesa VARCHAR(1) DEFAULT NULL,
  swot_log_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  swot_log_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_log_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
  swot_log_problema TINYINT(1) DEFAULT 0,
  swot_log_referencia INTEGER(11) DEFAULT NULL,
  swot_log_nome VARCHAR(200) DEFAULT NULL,
  swot_log_data DATETIME DEFAULT NULL,
  swot_log_url_relacionada VARCHAR(250) DEFAULT NULL,
  swot_log_acesso INTEGER(100) DEFAULT 0,
  PRIMARY KEY (swot_log_id),
  KEY swot_log_meta (swot_log_meta),
  KEY swot_log_criador (swot_log_criador),
  CONSTRAINT swot_log_fk FOREIGN KEY (swot_log_meta) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT swot_log_fk1 FOREIGN KEY (swot_log_criador) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS swot_usuarios;

CREATE TABLE swot_usuarios (
  swot_id INTEGER(100) UNSIGNED NOT NULL,
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (swot_id, usuario_id),
  KEY swot_id (swot_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT swot_usuarios_fk1 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT swot_usuarios_fk FOREIGN KEY (swot_id) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS operativo_observacao;

CREATE TABLE operativo_observacao (
  operativo_observacao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  operativo_observacao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
  operativo_observacao_data DATETIME DEFAULT NULL,
  operativo_observacao_texto MEDIUMTEXT,
  operativo_observacao_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  operativo_observacao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (operativo_observacao_id),
  KEY operativo_observacao_operativo (operativo_observacao_operativo),
  KEY operativo_observacao_usuario (operativo_observacao_usuario),
  CONSTRAINT operativo_observacao_fk1 FOREIGN KEY (operativo_observacao_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT operativo_observacao_fk FOREIGN KEY (operativo_observacao_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB;

DROP TABLE IF EXISTS operativo_depts;

CREATE TABLE operativo_depts (
  operativo_id INTEGER(100) UNSIGNED NOT NULL,
  dept_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (operativo_id, dept_id),
  KEY operativo_id (operativo_id),
  KEY dept_id (dept_id),
  CONSTRAINT operativo_depts_fk1 FOREIGN KEY (dept_id) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT operativo_depts_fk FOREIGN KEY (operativo_id) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB;

DROP TABLE IF EXISTS operativo_usuarios;

CREATE TABLE operativo_usuarios (
  operativo_id INTEGER(100) UNSIGNED NOT NULL,
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (operativo_id, usuario_id),
  KEY operativo_id (operativo_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT operativo_usuarios_fk1 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT operativo_usuarios_fk FOREIGN KEY (operativo_id) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB;


DROP TABLE IF EXISTS problema_log;

CREATE TABLE problema_log (
  problema_log_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  problema_log_problema_id INTEGER(100) UNSIGNED DEFAULT NULL,
  problema_log_criador INTEGER(100) UNSIGNED DEFAULT NULL,
  problema_log_horas DECIMAL(20,5) UNSIGNED DEFAULT 0,
  problema_log_descricao TEXT,
  problema_log_custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
  problema_log_nd VARCHAR(11) DEFAULT NULL,
  problema_log_categoria_economica VARCHAR(1) DEFAULT NULL,
  problema_log_grupo_despesa VARCHAR(1) DEFAULT NULL,
  problema_log_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  problema_log_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_log_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
  problema_log_problema TINYINT(1) DEFAULT 0,
  problema_log_referencia INTEGER(11) DEFAULT NULL,
  problema_log_nome VARCHAR(200) DEFAULT NULL,
  problema_log_data DATETIME DEFAULT NULL,
  problema_log_url_relacionada VARCHAR(250) DEFAULT NULL,
  problema_log_acesso INTEGER(100) DEFAULT 0,
  PRIMARY KEY (problema_log_id),
  KEY problema_log_problema_id (problema_log_problema_id),
  KEY problema_log_criador (problema_log_criador),
  CONSTRAINT problema_log_problema_id FOREIGN KEY (problema_log_problema_id) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT problema_log_criador FOREIGN KEY (problema_log_criador) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS problema_usuarios;

CREATE TABLE problema_usuarios (
  problema_id INTEGER(100) UNSIGNED NOT NULL,
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  KEY problema_id (problema_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT problema_usuarios_problema FOREIGN KEY (problema_id) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT problema_usuarios_usuario FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB;

DROP TABLE IF EXISTS problema_depts;

CREATE TABLE problema_depts (
  problema_id INTEGER(100) UNSIGNED NOT NULL,
  dept_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (problema_id, dept_id),
  KEY problema_id (problema_id),
  KEY dept_id (dept_id),
  CONSTRAINT problema_depts_fk FOREIGN KEY (problema_id) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT problema_depts_fk1 FOREIGN KEY (dept_id) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS meta_media;

CREATE TABLE meta_media (
	meta_media_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	meta_media_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_media_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_media_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_media_peso DECIMAL(20,5) DEFAULT 0,
	meta_media_ponto DECIMAL(20,5) DEFAULT 0,
	meta_media_tipo VARCHAR(40) DEFAULT NULL,
	meta_media_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_media_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (meta_media_id),
	KEY meta_media_meta (meta_media_meta),
	KEY meta_media_projeto (meta_media_projeto),
	KEY meta_media_acao (meta_media_acao),
	CONSTRAINT meta_media_meta FOREIGN KEY (meta_media_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_media_projeto FOREIGN KEY (meta_media_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_media_acao FOREIGN KEY (meta_media_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE
	)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS perspectiva_media;

CREATE TABLE perspectiva_media (
	perspectiva_media_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	perspectiva_media_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	perspectiva_media_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	perspectiva_media_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	perspectiva_media_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	perspectiva_media_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	perspectiva_media_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	perspectiva_media_peso DECIMAL(20,5) DEFAULT 0,
	perspectiva_media_ponto DECIMAL(20,5) DEFAULT 0,
	perspectiva_media_tipo VARCHAR(40) DEFAULT NULL,
	perspectiva_media_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	perspectiva_media_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (perspectiva_media_id),
	KEY perspectiva_media_perspectiva (perspectiva_media_perspectiva),
	KEY perspectiva_media_tema (perspectiva_media_tema),
	KEY perspectiva_media_objetivo (perspectiva_media_objetivo),
	KEY perspectiva_media_estrategia (perspectiva_media_estrategia),
	KEY perspectiva_media_projeto (perspectiva_media_projeto),
	KEY perspectiva_media_acao (perspectiva_media_acao),
	CONSTRAINT perspectiva_media_perspectiva FOREIGN KEY (perspectiva_media_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT perspectiva_media_tema FOREIGN KEY (perspectiva_media_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT perspectiva_media_objetivo FOREIGN KEY (perspectiva_media_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT perspectiva_media_estrategia FOREIGN KEY (perspectiva_media_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT perspectiva_media_projeto FOREIGN KEY (perspectiva_media_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT perspectiva_media_acao FOREIGN KEY (perspectiva_media_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE
	)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS tema_media;

CREATE TABLE tema_media (
	tema_media_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	tema_media_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	tema_media_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	tema_media_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	tema_media_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	tema_media_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	tema_media_peso DECIMAL(20,5) DEFAULT 0,
	tema_media_ponto DECIMAL(20,5) DEFAULT 0,
	tema_media_tipo VARCHAR(40) DEFAULT NULL,
	tema_media_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	tema_media_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (tema_media_id),
	KEY tema_media_tema (tema_media_tema),
	KEY tema_media_objetivo (tema_media_objetivo),
	KEY tema_media_estrategia (tema_media_estrategia),
	KEY tema_media_projeto (tema_media_projeto),
	KEY tema_media_acao (tema_media_acao),
	CONSTRAINT tema_media_tema FOREIGN KEY (tema_media_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tema_media_objetivo FOREIGN KEY (tema_media_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tema_media_estrategia FOREIGN KEY (tema_media_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tema_media_projeto FOREIGN KEY (tema_media_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tema_media_acao FOREIGN KEY (tema_media_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE
	)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS objetivo_media;

CREATE TABLE objetivo_media (
	objetivo_media_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	objetivo_media_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	objetivo_media_me INTEGER(100) UNSIGNED DEFAULT NULL,
	objetivo_media_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	objetivo_media_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	objetivo_media_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	objetivo_media_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	objetivo_media_peso DECIMAL(20,5) DEFAULT 0,
	objetivo_media_ponto DECIMAL(20,5) DEFAULT 0,
	objetivo_media_tipo VARCHAR(40) DEFAULT NULL,
	objetivo_media_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	objetivo_media_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (objetivo_media_id),
	KEY objetivo_media_objetivo (objetivo_media_objetivo),
	KEY objetivo_media_me (objetivo_media_me),
	KEY objetivo_media_fator (objetivo_media_fator),
	KEY objetivo_media_estrategia (objetivo_media_estrategia),
	KEY objetivo_media_projeto (objetivo_media_projeto),
	KEY objetivo_media_acao (objetivo_media_acao),
	CONSTRAINT objetivo_media_objetivo FOREIGN KEY (objetivo_media_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT objetivo_media_me FOREIGN KEY (objetivo_media_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT objetivo_media_fator FOREIGN KEY (objetivo_media_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT objetivo_media_estrategia FOREIGN KEY (objetivo_media_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT objetivo_media_projeto FOREIGN KEY (objetivo_media_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT objetivo_media_acao FOREIGN KEY (objetivo_media_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE
	)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS me_media;

CREATE TABLE me_media (
	me_media_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	me_media_me INTEGER(100) UNSIGNED DEFAULT NULL,
	me_media_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	me_media_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	me_media_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	me_media_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	me_media_peso DECIMAL(20,5) DEFAULT 0,
	me_media_ponto DECIMAL(20,5) DEFAULT 0,
	me_media_tipo VARCHAR(40) DEFAULT NULL,
	me_media_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	me_media_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (me_media_id),
	KEY me_media_me (me_media_me),
	KEY me_media_fator (me_media_fator),
	KEY me_media_estrategia (me_media_estrategia),
	KEY me_media_projeto (me_media_projeto),
	KEY me_media_acao (me_media_acao),
	CONSTRAINT me_media_me FOREIGN KEY (me_media_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT me_media_fator FOREIGN KEY (me_media_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT me_media_estrategia FOREIGN KEY (me_media_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT me_media_projeto FOREIGN KEY (me_media_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT me_media_acao FOREIGN KEY (me_media_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE
	)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS fator_media;

CREATE TABLE fator_media (
	fator_media_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	fator_media_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	fator_media_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	fator_media_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	fator_media_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	fator_media_peso DECIMAL(20,5) DEFAULT 0,
	fator_media_ponto DECIMAL(20,5) DEFAULT 0,
	fator_media_tipo VARCHAR(40) DEFAULT NULL,
	fator_media_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	fator_media_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (fator_media_id),
	KEY fator_media_fator (fator_media_fator),
	KEY fator_media_estrategia (fator_media_estrategia),
	KEY fator_media_projeto (fator_media_projeto),
	KEY fator_media_acao (fator_media_acao),
	CONSTRAINT fator_media_fator FOREIGN KEY (fator_media_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT fator_media_estrategia FOREIGN KEY (fator_media_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT fator_media_projeto FOREIGN KEY (fator_media_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT fator_media_acao FOREIGN KEY (fator_media_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE
	)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS estrategia_media;

CREATE TABLE estrategia_media (
	estrategia_media_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	estrategia_media_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	estrategia_media_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	estrategia_media_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	estrategia_media_peso DECIMAL(20,5) DEFAULT 0,
	estrategia_media_ponto DECIMAL(20,5) DEFAULT 0,
	estrategia_media_tipo VARCHAR(40) DEFAULT NULL,
	estrategia_media_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	estrategia_media_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (estrategia_media_id),
	KEY estrategia_media_estrategia (estrategia_media_estrategia),
	KEY estrategia_media_projeto (estrategia_media_projeto),
	KEY estrategia_media_acao (estrategia_media_acao),
	CONSTRAINT estrategia_media_estrategia FOREIGN KEY (estrategia_media_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT estrategia_media_projeto FOREIGN KEY (estrategia_media_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT estrategia_media_acao FOREIGN KEY (estrategia_media_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE
	)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS risco_media;

CREATE TABLE risco_media (
	risco_media_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	risco_media_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_media_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_media_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_media_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_media_peso DECIMAL(20,5) DEFAULT 0,
	risco_media_ponto DECIMAL(20,5) DEFAULT 0,
	risco_media_tipo VARCHAR(40) DEFAULT NULL,
	risco_media_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_media_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (risco_media_id),
	KEY risco_media_risco (risco_media_risco),
	KEY risco_media_risco_resposta (risco_media_risco_resposta),
	KEY risco_media_projeto (risco_media_projeto),
	KEY risco_media_acao (risco_media_acao),
	CONSTRAINT risco_media_risco FOREIGN KEY (risco_media_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_media_risco_resposta FOREIGN KEY (risco_media_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_media_projeto FOREIGN KEY (risco_media_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_media_acao FOREIGN KEY (risco_media_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE
	)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS risco_resposta_media;

CREATE TABLE risco_resposta_media (
	risco_resposta_media_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	risco_resposta_media_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_media_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_media_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_media_peso DECIMAL(20,5) DEFAULT 0,
	risco_resposta_media_ponto DECIMAL(20,5) DEFAULT 0,
	risco_resposta_media_tipo VARCHAR(40) DEFAULT NULL,
	risco_resposta_media_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_media_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (risco_resposta_media_id),
	KEY risco_resposta_media_risco_resposta (risco_resposta_media_risco_resposta),
	KEY risco_resposta_media_projeto (risco_resposta_media_projeto),
	KEY risco_resposta_media_acao (risco_resposta_media_acao),
	CONSTRAINT risco_resposta_media_risco_resposta FOREIGN KEY (risco_resposta_media_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_media_projeto FOREIGN KEY (risco_resposta_media_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_media_acao FOREIGN KEY (risco_resposta_media_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE
	)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS tema_observador;

CREATE TABLE tema_observador (
  tema_observador_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  tema_observador_tema INTEGER(100) UNSIGNED DEFAULT NULL,
  tema_observador_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
  tema_observador_acao VARCHAR(30) DEFAULT 'fisico',
  tema_observador_metodo VARCHAR(255) DEFAULT NULL,
  tema_observador_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (tema_observador_id),
  KEY tema_observador_tema (tema_observador_tema),
  KEY tema_observador_perspectiva (tema_observador_perspectiva),
  CONSTRAINT tema_observador_tema FOREIGN KEY (tema_observador_tema) REFERENCES tema (tema_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT tema_observador_perspectiva FOREIGN KEY (tema_observador_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS objetivo_observador;

CREATE TABLE objetivo_observador (
  objetivo_observador_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  objetivo_observador_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
  objetivo_observador_tema INTEGER(100) UNSIGNED DEFAULT NULL,
  objetivo_observador_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
  objetivo_observador_acao VARCHAR(30) DEFAULT 'fisico',
  objetivo_observador_metodo VARCHAR(255) DEFAULT NULL,
  objetivo_observador_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (objetivo_observador_id),
  KEY objetivo_observador_objetivo (objetivo_observador_objetivo),
  KEY objetivo_observador_tema (objetivo_observador_tema),
  KEY objetivo_observador_perspectiva (objetivo_observador_perspectiva),
  CONSTRAINT objetivo_observador_objetivo FOREIGN KEY (objetivo_observador_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT objetivo_observador_tema FOREIGN KEY (objetivo_observador_tema) REFERENCES tema (tema_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT objetivo_observador_perspectiva FOREIGN KEY (objetivo_observador_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS fator_observador;

CREATE TABLE fator_observador (
  fator_observador_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  fator_observador_fator INTEGER(100) UNSIGNED DEFAULT NULL,
  fator_observador_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
  fator_observador_me INTEGER(100) UNSIGNED DEFAULT NULL,
  fator_observador_acao VARCHAR(30) DEFAULT 'fisico',
  fator_observador_metodo VARCHAR(255) DEFAULT NULL,
  fator_observador_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (fator_observador_id),
  KEY fator_observador_fator (fator_observador_fator),
  KEY fator_observador_objetivo (fator_observador_objetivo),
  KEY fator_observador_me (fator_observador_me),
  CONSTRAINT fator_observador_fator FOREIGN KEY (fator_observador_fator) REFERENCES fator (fator_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT fator_observador_objetivo FOREIGN KEY (fator_observador_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT fator_observador_me FOREIGN KEY (fator_observador_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS me_observador;

CREATE TABLE me_observador (
  me_observador_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  me_observador_me INTEGER(100) UNSIGNED DEFAULT NULL,
  me_observador_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
  me_observador_acao VARCHAR(30) DEFAULT 'fisico',
  me_observador_metodo VARCHAR(255) DEFAULT NULL,
  me_observador_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (me_observador_id),
  KEY me_observador_me (me_observador_me),
  KEY me_observador_objetivo (me_observador_objetivo),
  CONSTRAINT me_observador_me FOREIGN KEY (me_observador_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT me_observador_objetivo FOREIGN KEY (me_observador_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS estrategia_observador;

CREATE TABLE estrategia_observador (
  estrategia_observador_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  estrategia_observador_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
  estrategia_observador_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
  estrategia_observador_tema INTEGER(100) UNSIGNED DEFAULT NULL,
  estrategia_observador_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
  estrategia_observador_me INTEGER(100) UNSIGNED DEFAULT NULL,
  estrategia_observador_fator INTEGER(100) UNSIGNED DEFAULT NULL,
  estrategia_observador_acao VARCHAR(30) DEFAULT 'fisico',
  estrategia_observador_metodo VARCHAR(255) DEFAULT NULL,
  estrategia_observador_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (estrategia_observador_id),
  KEY estrategia_observador_estrategia (estrategia_observador_estrategia),
  KEY estrategia_observador_perspectiva (estrategia_observador_perspectiva),
  KEY estrategia_observador_tema (estrategia_observador_tema),
  KEY estrategia_observador_objetivo (estrategia_observador_objetivo),
  KEY estrategia_observador_me (estrategia_observador_me),
  KEY estrategia_observador_fator (estrategia_observador_fator),
  CONSTRAINT estrategia_observador_estrategia FOREIGN KEY (estrategia_observador_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT estrategia_observador_perspectiva FOREIGN KEY (estrategia_observador_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT estrategia_observador_tema FOREIGN KEY (estrategia_observador_tema) REFERENCES tema (tema_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT estrategia_observador_objetivo FOREIGN KEY (estrategia_observador_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT estrategia_observador_me FOREIGN KEY (estrategia_observador_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT estrategia_observador_fator FOREIGN KEY (estrategia_observador_fator) REFERENCES fator (fator_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS projeto_observador;

CREATE TABLE projeto_observador (
  projeto_observador_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  projeto_observador_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_observador_portfolio INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_observador_programa INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_observador_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_observador_tema INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_observador_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_observador_me INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_observador_fator INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_observador_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_observador_meta INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_observador_risco INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_observador_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_observador_acao VARCHAR(30) DEFAULT 'fisico',
  projeto_observador_metodo VARCHAR(255) DEFAULT NULL,
  projeto_observador_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (projeto_observador_id),
  KEY projeto_observador_projeto (projeto_observador_projeto),
	KEY projeto_observador_portfolio (projeto_observador_portfolio),
	KEY projeto_observador_programa (projeto_observador_programa),
	KEY projeto_observador_perspectiva (projeto_observador_perspectiva),
	KEY projeto_observador_tema (projeto_observador_tema),
	KEY projeto_observador_objetivo (projeto_observador_objetivo),
	KEY projeto_observador_me (projeto_observador_me),
	KEY projeto_observador_fator (projeto_observador_fator),
	KEY projeto_observador_estrategia (projeto_observador_estrategia),
	KEY projeto_observador_meta (projeto_observador_meta),
	KEY projeto_observador_risco (projeto_observador_risco),
	KEY projeto_observador_risco_resposta (projeto_observador_risco_resposta),
	CONSTRAINT projeto_observador_projeto FOREIGN KEY (projeto_observador_projeto) REFERENCES projetos (projeto_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT projeto_observador_portfolio FOREIGN KEY (projeto_observador_portfolio) REFERENCES projetos (projeto_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT projeto_observador_programa FOREIGN KEY (projeto_observador_programa) REFERENCES programa (programa_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT projeto_observador_perspectiva FOREIGN KEY (projeto_observador_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT projeto_observador_tema FOREIGN KEY (projeto_observador_tema) REFERENCES tema (tema_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT projeto_observador_objetivo FOREIGN KEY (projeto_observador_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_observador_me FOREIGN KEY (projeto_observador_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_observador_fator FOREIGN KEY (projeto_observador_fator) REFERENCES fator (fator_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT projeto_observador_estrategia FOREIGN KEY (projeto_observador_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_observador_meta FOREIGN KEY (projeto_observador_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_observador_risco FOREIGN KEY (projeto_observador_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_observador_risco_resposta FOREIGN KEY (projeto_observador_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS plano_acao_observador;

CREATE TABLE plano_acao_observador (
  plano_acao_observador_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  plano_acao_observador_plano_acao INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_observador_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_observador_programa INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_observador_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_observador_tema INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_observador_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_observador_me INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_observador_fator INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_observador_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_observador_meta INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_observador_risco INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_observador_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_observador_acao VARCHAR(30) DEFAULT 'fisico',
  plano_acao_observador_metodo VARCHAR(255) DEFAULT NULL,
  plano_acao_observador_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (plano_acao_observador_id),
  KEY plano_acao_observador_plano_acao (plano_acao_observador_plano_acao),
  KEY plano_acao_observador_projeto (plano_acao_observador_projeto),
	KEY plano_acao_observador_programa (plano_acao_observador_programa),
	KEY plano_acao_observador_perspectiva (plano_acao_observador_perspectiva),
	KEY plano_acao_observador_tema (plano_acao_observador_tema),
	KEY plano_acao_observador_objetivo (plano_acao_observador_objetivo),
	KEY plano_acao_observador_me (plano_acao_observador_me),
	KEY plano_acao_observador_fator (plano_acao_observador_fator),
	KEY plano_acao_observador_estrategia (plano_acao_observador_estrategia),
	KEY plano_acao_observador_meta (plano_acao_observador_meta),
	KEY plano_acao_observador_risco (plano_acao_observador_risco),
	KEY plano_acao_observador_risco_resposta (plano_acao_observador_risco_resposta),
	CONSTRAINT plano_acao_observador_projeto FOREIGN KEY (plano_acao_observador_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_observador_plano_acao FOREIGN KEY (plano_acao_observador_plano_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_observador_programa FOREIGN KEY (plano_acao_observador_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_observador_perspectiva FOREIGN KEY (plano_acao_observador_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_observador_tema FOREIGN KEY (plano_acao_observador_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_observador_objetivo FOREIGN KEY (plano_acao_observador_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_observador_me FOREIGN KEY (plano_acao_observador_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_observador_fator FOREIGN KEY (plano_acao_observador_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_acao_observador_estrategia FOREIGN KEY (plano_acao_observador_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_acao_observador_meta FOREIGN KEY (plano_acao_observador_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_observador_risco FOREIGN KEY (plano_acao_observador_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_observador_risco_resposta FOREIGN KEY (plano_acao_observador_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS pratica_indicador_externo;

CREATE TABLE pratica_indicador_externo (
  pratica_indicador_externo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pratica_indicador_externo_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_externo_tipo VARCHAR(25) DEFAULT NULL,
  pratica_indicador_externo_tabela VARCHAR(100) DEFAULT NULL,
  pratica_indicador_externo_data VARCHAR(100) DEFAULT NULL,
  pratica_indicador_externo_valor VARCHAR(100) DEFAULT NULL,
  pratica_indicador_externo_chave VARCHAR(100) DEFAULT NULL,
  pratica_indicador_externo_chave_valor VARCHAR(100) DEFAULT NULL,
  pratica_indicador_externo_sql MEDIUMTEXT,
  pratica_indicador_externo_host VARCHAR(100) DEFAULT NULL,
  pratica_indicador_externo_porta VARCHAR(100) DEFAULT NULL,
  pratica_indicador_externo_timeout INTEGER(10) DEFAULT NULL,
  pratica_indicador_externo_usuario VARCHAR(100) DEFAULT NULL,
  pratica_indicador_externo_senha VARCHAR(100) DEFAULT NULL,
  pratica_indicador_externo_base VARCHAR(100) DEFAULT NULL,
  pratica_indicador_externo_charset VARCHAR(50) DEFAULT NULL,
  pratica_indicador_externo_modo VARCHAR(50) DEFAULT NULL,
  pratica_indicador_externo_string_conexao MEDIUMTEXT,
  pratica_indicador_externo_simples SMALLINT(1) DEFAULT 0,
  uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (pratica_indicador_externo_id),
  KEY pratica_indicador_externo_indicador (pratica_indicador_externo_indicador),
  CONSTRAINT pratica_indicador_externo_fk FOREIGN KEY (pratica_indicador_externo_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS meta_observador;

CREATE TABLE meta_observador (
  meta_observador_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  meta_observador_meta INTEGER(100) UNSIGNED DEFAULT NULL,
  meta_observador_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
  meta_observador_tema INTEGER(100) UNSIGNED DEFAULT NULL,
  meta_observador_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
  meta_observador_me INTEGER(100) UNSIGNED DEFAULT NULL,
  meta_observador_fator INTEGER(100) UNSIGNED DEFAULT NULL,
  meta_observador_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
  meta_observador_acao VARCHAR(30) DEFAULT 'fisico',
  meta_observador_metodo VARCHAR(255) DEFAULT NULL,
  meta_observador_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (meta_observador_id),
  KEY meta_observador_meta (meta_observador_meta),
  KEY meta_observador_perspectiva (meta_observador_perspectiva),
  KEY meta_observador_tema (meta_observador_tema),
  KEY meta_observador_objetivo (meta_observador_objetivo),
  KEY meta_observador_me (meta_observador_me),
  KEY meta_observador_fator (meta_observador_fator),
  KEY meta_observador_estrategia (meta_observador_estrategia),
  CONSTRAINT meta_observador_meta FOREIGN KEY (meta_observador_meta) REFERENCES metas (pg_meta_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT meta_observador_perspectiva FOREIGN KEY (meta_observador_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT meta_observador_tema FOREIGN KEY (meta_observador_tema) REFERENCES tema (tema_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT meta_observador_objetivo FOREIGN KEY (meta_observador_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT meta_observador_me FOREIGN KEY (meta_observador_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT meta_observador_fator FOREIGN KEY (meta_observador_fator) REFERENCES fator (fator_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT meta_observador_estrategia FOREIGN KEY (meta_observador_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS risco_resposta_observador;

CREATE TABLE risco_resposta_observador (
  risco_resposta_observador_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	risco_resposta_observador_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
  risco_resposta_observador_risco INTEGER(100) UNSIGNED DEFAULT NULL,
  risco_resposta_observador_acao VARCHAR(30) DEFAULT 'fisico',
  risco_resposta_observador_metodo VARCHAR(255) DEFAULT NULL,
  risco_resposta_observador_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (risco_resposta_observador_id),
 	KEY risco_resposta_observador_risco_resposta (risco_resposta_observador_risco_resposta),
 	KEY risco_resposta_observador_risco (risco_resposta_observador_risco),
	CONSTRAINT risco_resposta_observador_risco_resposta FOREIGN KEY (risco_resposta_observador_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT risco_resposta_observador_risco FOREIGN KEY (risco_resposta_observador_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS programa_dept;

CREATE TABLE programa_dept (
  programa_dept_programa INTEGER(100) UNSIGNED NOT NULL,
  programa_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (programa_dept_programa, programa_dept_dept),
  KEY programa_dept_programa (programa_dept_programa),
  KEY programa_dept_dept (programa_dept_dept),
  CONSTRAINT programa_dept_dept FOREIGN KEY (programa_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT programa_dept_programa FOREIGN KEY (programa_dept_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS programa_usuario;

CREATE TABLE programa_usuario (
  programa_usuario_programa INTEGER(100) UNSIGNED NOT NULL,
  programa_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (programa_usuario_programa, programa_usuario_usuario),
  KEY programa_usuario_usuario (programa_usuario_usuario),
  KEY programa_usuario_programa (programa_usuario_programa),
  CONSTRAINT programa_usuario_usuario FOREIGN KEY (programa_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT programa_usuario_programa FOREIGN KEY (programa_usuario_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS programa_stakeholder;

CREATE TABLE programa_stakeholder (
	programa_stakeholder_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	programa_stakeholder_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_stakeholder_contato INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_stakeholder_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_stakeholder_perfil INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_stakeholder_autoridade INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_stakeholder_interesse INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_stakeholder_influencia INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_stakeholder_impacto INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_stakeholder_descricao MEDIUMTEXT,
	PRIMARY KEY (programa_stakeholder_id),
	KEY programa_stakeholder_programa (programa_stakeholder_programa),
	KEY programa_stakeholder_contato (programa_stakeholder_contato),
	CONSTRAINT programa_stakeholder_fk FOREIGN KEY (programa_stakeholder_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_stakeholder_fk1 FOREIGN KEY (programa_stakeholder_contato) REFERENCES contatos (contato_id) ON DELETE CASCADE ON UPDATE CASCADE
	)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;




DROP TABLE IF EXISTS beneficio_dept;

CREATE TABLE beneficio_dept (
  beneficio_dept_beneficio INTEGER(100) UNSIGNED NOT NULL,
  beneficio_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (beneficio_dept_beneficio, beneficio_dept_dept),
  KEY beneficio_dept_beneficio (beneficio_dept_beneficio),
  KEY beneficio_dept_dept (beneficio_dept_dept),
  CONSTRAINT beneficio_dept_dept FOREIGN KEY (beneficio_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT beneficio_dept_beneficio FOREIGN KEY (beneficio_dept_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS beneficio_cia;

CREATE TABLE beneficio_cia (
  beneficio_cia_beneficio INTEGER(100) UNSIGNED NOT NULL,
  beneficio_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (beneficio_cia_beneficio, beneficio_cia_cia),
  KEY beneficio_cia_beneficio (beneficio_cia_beneficio),
  KEY beneficio_cia_cia (beneficio_cia_cia),
  CONSTRAINT beneficio_cia_cia FOREIGN KEY (beneficio_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT beneficio_cia_beneficio FOREIGN KEY (beneficio_cia_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS beneficio_usuario;

CREATE TABLE beneficio_usuario (
  beneficio_usuario_beneficio INTEGER(100) UNSIGNED NOT NULL,
  beneficio_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (beneficio_usuario_beneficio, beneficio_usuario_usuario),
  KEY beneficio_usuario_usuario (beneficio_usuario_usuario),
  KEY beneficio_usuario_beneficio (beneficio_usuario_beneficio),
  CONSTRAINT beneficio_usuario_usuario FOREIGN KEY (beneficio_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT beneficio_usuario_beneficio FOREIGN KEY (beneficio_usuario_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS beneficio_projeto;

CREATE TABLE beneficio_projeto (
	beneficio_projeto_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  beneficio_projeto_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
  beneficio_projeto_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  beneficio_projeto_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  beneficio_projeto_peso DECIMAL(20,5) UNSIGNED DEFAULT 0,
  uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (beneficio_projeto_id),
  KEY beneficio_projeto_beneficio (beneficio_projeto_beneficio),
  KEY beneficio_projeto_projeto (beneficio_projeto_projeto),
  CONSTRAINT beneficio_projeto_beneficio FOREIGN KEY (beneficio_projeto_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT beneficio_projeto_projeto FOREIGN KEY (beneficio_projeto_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS demanda_portfolio;

CREATE TABLE demanda_portfolio (
  demanda_portfolio_pai INTEGER(100) UNSIGNED DEFAULT NULL,
  demanda_portfolio_filho INTEGER(100) UNSIGNED DEFAULT NULL,
  demanda_portfolio_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  uuid VARCHAR(36) DEFAULT NULL,
  KEY demanda_portfolio_pai (demanda_portfolio_pai),
  KEY demanda_portfolio_filho (demanda_portfolio_filho),
  CONSTRAINT demanda_portfolio_fk FOREIGN KEY (demanda_portfolio_pai) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT demanda_portfolio_fk1 FOREIGN KEY (demanda_portfolio_filho) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS demanda_custo;

CREATE TABLE demanda_custo (
  demanda_custo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  demanda_custo_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
  demanda_custo_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  demanda_custo_tr INTEGER(100) UNSIGNED DEFAULT NULL,
  demanda_custo_nome VARCHAR(255) DEFAULT NULL,
  demanda_custo_codigo VARCHAR(255) DEFAULT NULL,
  demanda_custo_fonte VARCHAR(255) DEFAULT NULL,
  demanda_custo_regiao VARCHAR(255) DEFAULT NULL,
  demanda_custo_tipo INTEGER(100) UNSIGNED DEFAULT 1,
  demanda_custo_data DATETIME DEFAULT NULL,
  demanda_custo_quantidade DECIMAL(20,5) UNSIGNED DEFAULT 0,
  demanda_custo_custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
  demanda_custo_bdi DECIMAL(20,5) UNSIGNED DEFAULT 0,
	demanda_custo_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
	demanda_custo_cotacao DECIMAL(6,5) UNSIGNED DEFAULT 1.00000, 
	demanda_custo_data_moeda DATE DEFAULT NULL,
  demanda_custo_percentagem TINYINT(4) DEFAULT 0,
  demanda_custo_descricao MEDIUMTEXT,
  demanda_custo_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  demanda_custo_nd VARCHAR(11) DEFAULT NULL,
  demanda_custo_categoria_economica VARCHAR(1) DEFAULT NULL,
  demanda_custo_grupo_despesa VARCHAR(1) DEFAULT NULL,
  demanda_custo_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  demanda_custo_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_custo_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
	demanda_custo_data_limite DATE DEFAULT NULL,
	demanda_custo_pi VARCHAR(100) DEFAULT NULL,
	demanda_custo_aprovou INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_custo_aprovado TINYINT(1) DEFAULT NULL,
	demanda_custo_data_aprovado DATETIME DEFAULT NULL,
  PRIMARY KEY (demanda_custo_id),
  KEY demanda_custo_demanda (demanda_custo_demanda),
  KEY demanda_custo_usuario_inicio (demanda_custo_usuario),
  KEY demanda_custo_tr (demanda_custo_tr),
  KEY demanda_custo_ordem (demanda_custo_ordem),
  KEY demanda_custo_data_inicio (demanda_custo_data),
  KEY demanda_custo_nome (demanda_custo_nome),
  KEY demanda_custo_aprovou (demanda_custo_aprovou),
  KEY demanda_custo_moeda (demanda_custo_moeda),
  CONSTRAINT demanda_custo_usuario FOREIGN KEY (demanda_custo_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT demanda_custo_tr FOREIGN KEY (demanda_custo_tr) REFERENCES tr (tr_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT demanda_custo_demanda FOREIGN KEY (demanda_custo_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT demanda_custo_aprovou FOREIGN KEY (demanda_custo_aprovou) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT demanda_custo_moeda FOREIGN KEY (demanda_custo_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS projeto_resumo;

CREATE TABLE projeto_resumo (
	projeto_resumo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	projeto_id INTEGER(100) UNSIGNED DEFAULT NULL,
	nome VARCHAR(255) DEFAULT NULL,
	organizacao VARCHAR(255) DEFAULT NULL,
	indicador VARCHAR(255) DEFAULT NULL,
	codigo VARCHAR(255) DEFAULT NULL,
	setor VARCHAR(255) DEFAULT NULL,
	segmento VARCHAR(255) DEFAULT NULL,
	intervencao VARCHAR(255) DEFAULT NULL,
	tipo_intervencao VARCHAR(255) DEFAULT NULL,
	categoria VARCHAR(255) DEFAULT NULL,
	oque MEDIUMTEXT,
	porque MEDIUMTEXT,
	como MEDIUMTEXT,
	onde MEDIUMTEXT,
	inicio DATETIME DEFAULT NULL,
	termino DATETIME DEFAULT NULL,
	termino_atualizado DATETIME DEFAULT NULL,
	gerente VARCHAR(255) DEFAULT NULL,
	supervisor VARCHAR(255) DEFAULT NULL,
	autoridade VARCHAR(255) DEFAULT NULL,
	cliente VARCHAR(255) DEFAULT NULL,
	url VARCHAR(255) DEFAULT NULL,
	www VARCHAR(255) DEFAULT NULL,
	custo_inicial DECIMAL(20,5) UNSIGNED DEFAULT 0,
	custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
	gasto DECIMAL(20,5) UNSIGNED DEFAULT 0,
	gasto_mo DECIMAL(20,5) UNSIGNED DEFAULT 0,
	estimado_mo DECIMAL(20,5) UNSIGNED DEFAULT 0,
	estimado_total_mo DECIMAL(20,5) UNSIGNED DEFAULT 0,
	estimado_recurso DECIMAL(20,5) UNSIGNED DEFAULT 0,
	estimado_total_recurso DECIMAL(20,5) UNSIGNED DEFAULT 0,
	gasto_extra DECIMAL(20,5) UNSIGNED DEFAULT 0,
	custo_previsto DECIMAL(20,5) UNSIGNED DEFAULT 0,
	vel_financeiro DECIMAL(20,5) UNSIGNED DEFAULT 0,
	financeiro_alocado DECIMAL(20,5) UNSIGNED DEFAULT 0,
	total_estimado_hoje DECIMAL(20,5) UNSIGNED DEFAULT 0,
	total_estimado_final DECIMAL(20,5) UNSIGNED DEFAULT 0,
	gasto_total DECIMAL(20,5) UNSIGNED DEFAULT 0,
	status VARCHAR(255) DEFAULT NULL,
	acesso VARCHAR(255) DEFAULT NULL,
	prioridade VARCHAR(255) DEFAULT NULL,
	progresso DECIMAL(20,5) UNSIGNED DEFAULT 0,
	fisico_previsto DECIMAL(20,5) UNSIGNED DEFAULT 0,
	vel_fisico DECIMAL(20,5) UNSIGNED DEFAULT 0,
	ativo VARCHAR(3) DEFAULT NULL,
	horas_trab DECIMAL(20,5) UNSIGNED DEFAULT 0,
	horas_registro DECIMAL(20,5) UNSIGNED DEFAULT 0,
	horas_projeto DECIMAL(20,5) UNSIGNED DEFAULT 0,
	homem_hora DECIMAL(20,5) UNSIGNED DEFAULT 0,
	endereco TEXT,
	latitude VARCHAR(255) DEFAULT NULL,
	observacao MEDIUMTEXT,
  PRIMARY KEY (projeto_resumo_id),
  KEY projeto_id (projeto_id),
  CONSTRAINT projeto_id FOREIGN KEY (projeto_id) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS canvas_config;

CREATE TABLE canvas_config (
  canvas_config_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  canvas_config_cor_porque VARCHAR(6) DEFAULT NULL,
  canvas_config_cor_oque VARCHAR(6) DEFAULT NULL,
  canvas_config_cor_quem VARCHAR(6) DEFAULT NULL,
  canvas_config_cor_como VARCHAR(6) DEFAULT NULL,
  canvas_config_cor_quanto VARCHAR(6) DEFAULT NULL,
  PRIMARY KEY (canvas_config_id)
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS canvas_fase;

CREATE TABLE canvas_fase (
	canvas_fase_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  canvas_fase_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_fase_inicio DATETIME DEFAULT NULL,
	canvas_fase_fim DATETIME DEFAULT NULL,
	canvas_fase_duracao DECIMAL(20,5) DEFAULT 0,
	canvas_fase_nr INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_fase_tipo VARCHAR(20) DEFAULT NULL,
	canvas_fase_categoria VARCHAR(20) DEFAULT NULL,
	canvas_fase_usuarios VARCHAR(20) DEFAULT 'todos',
	uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (canvas_fase_id),
  KEY canvas_fase_canvas (canvas_fase_canvas),
  CONSTRAINT canvas_fase_canvas FOREIGN KEY (canvas_fase_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS canvas_cia;

CREATE TABLE canvas_cia (
  canvas_cia_canvas INTEGER(100) UNSIGNED NOT NULL,
  canvas_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (canvas_cia_canvas, canvas_cia_cia),
  KEY canvas_cia_canvas (canvas_cia_canvas),
  KEY canvas_cia_cia (canvas_cia_cia),
  CONSTRAINT canvas_cia_cia FOREIGN KEY (canvas_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT canvas_cia_canvas FOREIGN KEY (canvas_cia_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS canvas_usuario;

CREATE TABLE canvas_usuario (
  canvas_usuario_canvas INTEGER(100) UNSIGNED NOT NULL,
  canvas_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (canvas_usuario_canvas, canvas_usuario_usuario),
  KEY canvas_usuario_canvas (canvas_usuario_canvas),
  KEY canvas_usuario_usuario (canvas_usuario_usuario),
  CONSTRAINT canvas_usuario_usuario FOREIGN KEY (canvas_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT canvas_usuario_canvas FOREIGN KEY (canvas_usuario_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS canvas_ideia;

CREATE TABLE canvas_ideia (
	canvas_ideia_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  canvas_ideia_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
  canvas_ideia_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  canvas_ideia_pai INTEGER(100) UNSIGNED DEFAULT NULL,
  canvas_ideia_categoria VARCHAR(20) DEFAULT NULL,
	canvas_ideia_data DATETIME DEFAULT NULL,
	canvas_ideia_texto MEDIUMTEXT,
	canvas_ideia_extra1 VARCHAR(30),
	canvas_ideia_extra2 VARCHAR(30),
	canvas_ideia_inativa TINYINT(1) DEFAULT 0,
  PRIMARY KEY (canvas_ideia_id),
  KEY canvas_ideia_canvas (canvas_ideia_canvas),
  KEY canvas_ideia_usuario (canvas_ideia_usuario),
  KEY canvas_ideia_pai (canvas_ideia_pai),
  CONSTRAINT canvas_ideia_usuario FOREIGN KEY (canvas_ideia_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT canvas_ideia_canvas FOREIGN KEY (canvas_ideia_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT canvas_ideia_pai FOREIGN KEY (canvas_ideia_pai) REFERENCES canvas_ideia (canvas_ideia_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS canvas_ideia_custo;

CREATE TABLE canvas_ideia_custo (
  canvas_ideia_custo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  canvas_ideia_custo_ideia INTEGER(100) UNSIGNED DEFAULT NULL,
  canvas_ideia_custo_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  canvas_ideia_custo_nome VARCHAR(255) DEFAULT NULL,
  canvas_ideia_custo_codigo VARCHAR(255) DEFAULT NULL,
  canvas_ideia_custo_fonte VARCHAR(255) DEFAULT NULL,
  canvas_ideia_custo_regiao VARCHAR(255) DEFAULT NULL,
  canvas_ideia_custo_tipo INTEGER(100) UNSIGNED DEFAULT 1,
  canvas_ideia_custo_data DATETIME DEFAULT NULL,
  canvas_ideia_custo_quantidade DECIMAL(20,5) UNSIGNED DEFAULT 0,
  canvas_ideia_custo_custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
  canvas_ideia_custo_bdi DECIMAL(20,5) UNSIGNED DEFAULT 0,
  canvas_ideia_custo_moeda INTEGER(100) UNSIGNED DEFAULT 1,
  canvas_ideia_custo_cotacao DECIMAL(6,5) UNSIGNED DEFAULT 1.00000,
  canvas_ideia_custo_data_moeda DATE DEFAULT NULL,
  canvas_ideia_custo_percentagem TINYINT(4) DEFAULT 0,
  canvas_ideia_custo_descricao MEDIUMTEXT,
  canvas_ideia_custo_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  canvas_ideia_custo_nd VARCHAR(11) DEFAULT NULL,
  canvas_ideia_custo_categoria_economica VARCHAR(1) DEFAULT NULL,
  canvas_ideia_custo_grupo_despesa VARCHAR(1) DEFAULT NULL,
  canvas_ideia_custo_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  canvas_ideia_custo_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_ideia_custo_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
	canvas_ideia_custo_data_limite DATE DEFAULT NULL,
	canvas_ideia_custo_pi VARCHAR(100) DEFAULT NULL,
	canvas_ideia_custo_ptres VARCHAR(100) DEFAULT NULL,
	canvas_ideia_custo_aprovou INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_ideia_custo_aprovado TINYINT(1) DEFAULT NULL,
	canvas_ideia_custo_data_aprovado DATETIME DEFAULT NULL,
	canvas_ideia_custo_uuid varchar(36) DEFAULT NULL,
  PRIMARY KEY (canvas_ideia_custo_id),
  KEY canvas_ideia_custo_ideia (canvas_ideia_custo_ideia),
  KEY canvas_ideia_custo_usuario (canvas_ideia_custo_usuario),
  KEY canvas_ideia_custo_ordem (canvas_ideia_custo_ordem),
  KEY canvas_ideia_custo_data (canvas_ideia_custo_data),
  KEY canvas_ideia_custo_nome (canvas_ideia_custo_nome),
  KEY canvas_ideia_custo_aprovou (canvas_ideia_custo_aprovou),
  KEY canvas_ideia_custo_moeda (canvas_ideia_custo_moeda),
  CONSTRAINT canvas_ideia_custo_usuario FOREIGN KEY (canvas_ideia_custo_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT canvas_ideia_custo_ideia FOREIGN KEY (canvas_ideia_custo_ideia) REFERENCES canvas_ideia (canvas_ideia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT canvas_ideia_custo_aprovou FOREIGN KEY (canvas_ideia_custo_aprovou) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT canvas_ideia_custo_moeda FOREIGN KEY (canvas_ideia_custo_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS canvas_ponto;

CREATE TABLE canvas_ponto (
	canvas_ponto_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  canvas_ponto_ideia INTEGER(100) UNSIGNED DEFAULT NULL,
  canvas_ponto_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_ponto_data DATETIME DEFAULT NULL,
	canvas_ponto_ponto INTEGER(10) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (canvas_ponto_id),
  KEY canvas_ponto_ideia (canvas_ponto_ideia),
  KEY canvas_ponto_usuario (canvas_ponto_usuario),
  CONSTRAINT canvas_ponto_usuario FOREIGN KEY (canvas_ponto_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT canvas_ponto_ideia FOREIGN KEY (canvas_ponto_ideia) REFERENCES canvas_ideia (canvas_ideia_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS canvas_comentario;

CREATE TABLE canvas_comentario (
	canvas_comentario_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  canvas_comentario_ideia INTEGER(100) UNSIGNED DEFAULT NULL,
  canvas_comentario_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_comentario_data DATETIME DEFAULT NULL,
	canvas_comentario_comentario MEDIUMTEXT,
  PRIMARY KEY (canvas_comentario_id),
  KEY canvas_comentario_ideia (canvas_comentario_ideia),
  KEY canvas_comentario_usuario (canvas_comentario_usuario),
  CONSTRAINT canvas_comentario_usuario FOREIGN KEY (canvas_comentario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT canvas_comentario_ideia FOREIGN KEY (canvas_comentario_ideia) REFERENCES canvas_ideia (canvas_ideia_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;




DROP TABLE IF EXISTS canvas_chat;

CREATE TABLE canvas_chat (
	canvas_chat_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  canvas_chat_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
  canvas_chat_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  canvas_chat_data DATETIME,
  canvas_chat_texto MEDIUMTEXT,
  canvas_chat_administrador TINYINT(1) DEFAULT 0,
  PRIMARY KEY (canvas_chat_id),
  KEY canvas_chat_canvas (canvas_chat_canvas),
  KEY canvas_chat_usuario (canvas_chat_usuario),
  CONSTRAINT canvas_chat_usuario FOREIGN KEY (canvas_chat_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT canvas_chat_canvas FOREIGN KEY (canvas_chat_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS canvas_log;

CREATE TABLE canvas_log (
  canvas_log_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  canvas_log_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
  canvas_log_criador INTEGER(100) UNSIGNED DEFAULT NULL,
  canvas_log_horas DECIMAL(20,5) UNSIGNED DEFAULT 0,
  canvas_log_descricao TEXT,
  canvas_log_custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
  canvas_log_nd VARCHAR(11) DEFAULT NULL,
  canvas_log_categoria_economica VARCHAR(1) DEFAULT NULL,
  canvas_log_grupo_despesa VARCHAR(1) DEFAULT NULL,
  canvas_log_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  canvas_log_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_log_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
  canvas_log_problema TINYINT(1) DEFAULT 0,
  canvas_log_referencia INTEGER(11) DEFAULT NULL,
  canvas_log_nome VARCHAR(200) DEFAULT NULL,
  canvas_log_data DATETIME DEFAULT NULL,
  canvas_log_url_relacionada VARCHAR(250) DEFAULT NULL,
  canvas_log_acesso INTEGER(100) DEFAULT 0,
  PRIMARY KEY (canvas_log_id),
  KEY canvas_log_canvas (canvas_log_canvas),
  KEY canvas_log_criador (canvas_log_criador),
  CONSTRAINT canvas_log_fk FOREIGN KEY (canvas_log_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT canvas_log_fk1 FOREIGN KEY (canvas_log_criador) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS canvas_fase_usuario;

CREATE TABLE canvas_fase_usuario (
  canvas_fase_usuario_fase INTEGER(100) UNSIGNED NOT NULL,
  canvas_fase_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (canvas_fase_usuario_fase, canvas_fase_usuario_usuario),
  KEY canvas_fase_usuario_fase (canvas_fase_usuario_fase),
  KEY canvas_fase_usuario_usuario (canvas_fase_usuario_usuario),
  CONSTRAINT canvas_fase_usuario_usuario FOREIGN KEY (canvas_fase_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT canvas_fase_usuario_fase FOREIGN KEY (canvas_fase_usuario_fase) REFERENCES canvas_fase (canvas_fase_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS tgn_fase;

CREATE TABLE tgn_fase (
	tgn_fase_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  tgn_fase_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_fase_inicio DATETIME DEFAULT NULL,
	tgn_fase_fim DATETIME DEFAULT NULL,
	tgn_fase_duracao DECIMAL(20,5) DEFAULT 0,
	tgn_fase_nr INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_fase_tipo VARCHAR(20) DEFAULT NULL,
	tgn_fase_usuarios VARCHAR(20) DEFAULT 'todos',
	uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (tgn_fase_id),
  KEY tgn_fase_tgn (tgn_fase_tgn),
  CONSTRAINT tgn_fase_tgn FOREIGN KEY (tgn_fase_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS tgn_fase_usuario;

CREATE TABLE tgn_fase_usuario (
  tgn_fase_usuario_fase INTEGER(100) UNSIGNED NOT NULL,
  tgn_fase_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (tgn_fase_usuario_fase, tgn_fase_usuario_usuario),
  KEY tgn_fase_usuario_fase (tgn_fase_usuario_fase),
  KEY tgn_fase_usuario_usuario (tgn_fase_usuario_usuario),
  CONSTRAINT tgn_fase_usuario_usuario FOREIGN KEY (tgn_fase_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tgn_fase_usuario_fase FOREIGN KEY (tgn_fase_usuario_fase) REFERENCES tgn_fase (tgn_fase_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS tgn_cia;

CREATE TABLE tgn_cia (
  tgn_cia_tgn INTEGER(100) UNSIGNED NOT NULL,
  tgn_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (tgn_cia_tgn, tgn_cia_cia),
  KEY tgn_cia_tgn (tgn_cia_tgn),
  KEY tgn_cia_cia (tgn_cia_cia),
  CONSTRAINT tgn_cia_cia FOREIGN KEY (tgn_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tgn_cia_tgn FOREIGN KEY (tgn_cia_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS tgn_dept;

CREATE TABLE tgn_dept (
  tgn_dept_tgn INTEGER(100) UNSIGNED NOT NULL,
  tgn_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (tgn_dept_tgn, tgn_dept_dept),
  KEY tgn_dept_tgn (tgn_dept_tgn),
  KEY tgn_dept_dept (tgn_dept_dept),
  CONSTRAINT tgn_dept_dept FOREIGN KEY (tgn_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tgn_dept_tgn FOREIGN KEY (tgn_dept_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS tgn_usuario;

CREATE TABLE tgn_usuario (
  tgn_usuario_tgn INTEGER(100) UNSIGNED NOT NULL,
  tgn_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (tgn_usuario_tgn, tgn_usuario_usuario),
  KEY tgn_usuario_tgn (tgn_usuario_tgn),
  KEY tgn_usuario_usuario (tgn_usuario_usuario),
  CONSTRAINT tgn_usuario_usuario FOREIGN KEY (tgn_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tgn_usuario_tgn FOREIGN KEY (tgn_usuario_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS tgn_ideia;

CREATE TABLE tgn_ideia (
	tgn_ideia_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  tgn_ideia_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
  tgn_ideia_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_ideia_data DATETIME DEFAULT NULL,
	tgn_ideia_texto MEDIUMTEXT,
	tgn_ideia_inativa TINYINT(1) DEFAULT 0,
  PRIMARY KEY (tgn_ideia_id),
  KEY tgn_ideia_tgn (tgn_ideia_tgn),
  KEY tgn_ideia_usuario (tgn_ideia_usuario),
  CONSTRAINT tgn_ideia_usuario FOREIGN KEY (tgn_ideia_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tgn_ideia_tgn FOREIGN KEY (tgn_ideia_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS tgn_ponto;

CREATE TABLE tgn_ponto (
	tgn_ponto_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  tgn_ponto_ideia INTEGER(100) UNSIGNED DEFAULT NULL,
  tgn_ponto_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_ponto_data DATETIME DEFAULT NULL,
	tgn_ponto_ponto INTEGER(10) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (tgn_ponto_id),
  KEY tgn_ponto_ideia (tgn_ponto_ideia),
  KEY tgn_ponto_usuario (tgn_ponto_usuario),
  CONSTRAINT tgn_ponto_usuario FOREIGN KEY (tgn_ponto_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tgn_ponto_ideia FOREIGN KEY (tgn_ponto_ideia) REFERENCES tgn_ideia (tgn_ideia_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS tgn_comentario;

CREATE TABLE tgn_comentario (
	tgn_comentario_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  tgn_comentario_ideia INTEGER(100) UNSIGNED DEFAULT NULL,
  tgn_comentario_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_comentario_data DATETIME DEFAULT NULL,
	tgn_comentario_comentario TEXT,
  PRIMARY KEY (tgn_comentario_id),
  KEY tgn_comentario_ideia (tgn_comentario_ideia),
  KEY tgn_comentario_usuario (tgn_comentario_usuario),
  CONSTRAINT tgn_comentario_usuario FOREIGN KEY (tgn_comentario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tgn_comentario_ideia FOREIGN KEY (tgn_comentario_ideia) REFERENCES tgn_ideia (tgn_ideia_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS tgn_chat;

CREATE TABLE tgn_chat (
	tgn_chat_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  tgn_chat_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
  tgn_chat_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  tgn_chat_data DATETIME,
  tgn_chat_texto MEDIUMTEXT,
  tgn_chat_administrador TINYINT(1) DEFAULT 0,
  PRIMARY KEY (tgn_chat_id),
  KEY tgn_chat_tgn (tgn_chat_tgn),
  KEY tgn_chat_usuario (tgn_chat_usuario),
  CONSTRAINT tgn_chat_usuario FOREIGN KEY (tgn_chat_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tgn_chat_tgn FOREIGN KEY (tgn_chat_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS projeto_portfolio;

CREATE TABLE projeto_portfolio (
  projeto_portfolio_pai INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_portfolio_filho INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_portfolio_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  uuid VARCHAR(36) DEFAULT NULL,
  KEY projeto_portfolio_pai (projeto_portfolio_pai),
  KEY projeto_portfolio_filho (projeto_portfolio_filho),
  CONSTRAINT projeto_portfolio_fk FOREIGN KEY (projeto_portfolio_pai) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_portfolio_fk1 FOREIGN KEY (projeto_portfolio_filho) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS operativo_projeto;

CREATE TABLE operativo_projeto (
	operativo_projeto_id int(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  operativo_projeto_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
  operativo_projeto_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  operativo_projeto_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  operativo_projeto_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY operativo_projeto_id (operativo_projeto_id),
  KEY operativo_projeto_operativo (operativo_projeto_operativo),
  KEY operativo_projeto_projeto (operativo_projeto_projeto),
  CONSTRAINT operativo_projeto_operativo FOREIGN KEY (operativo_projeto_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT operativo_projeto_projeto FOREIGN KEY (operativo_projeto_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS risco_depts;

CREATE TABLE risco_depts (
  risco_id INTEGER(100) UNSIGNED NOT NULL,
  dept_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (risco_id, dept_id),
  KEY risco_id (risco_id),
  KEY dept_id (dept_id),
  CONSTRAINT risco_depts_fk1 FOREIGN KEY (dept_id) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT risco_depts_fk FOREIGN KEY (risco_id) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS risco_log;

CREATE TABLE risco_log (
  risco_log_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  risco_log_risco INTEGER(100) UNSIGNED DEFAULT NULL,
  risco_log_criador INTEGER(100) UNSIGNED DEFAULT NULL,
  risco_log_horas DECIMAL(20,5) UNSIGNED DEFAULT 0,
  risco_log_descricao TEXT,
  risco_log_custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
  risco_log_nd VARCHAR(11) DEFAULT NULL,
  risco_log_categoria_economica VARCHAR(1) DEFAULT NULL,
  risco_log_grupo_despesa VARCHAR(1) DEFAULT NULL,
  risco_log_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  risco_log_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_log_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
  risco_log_problema TINYINT(1) DEFAULT 0,
  risco_log_referencia INTEGER(11) DEFAULT NULL,
  risco_log_nome VARCHAR(200) DEFAULT NULL,
  risco_log_data DATETIME DEFAULT NULL,
  risco_log_url_relacionada VARCHAR(250) DEFAULT NULL,
  risco_log_acesso INTEGER(100) DEFAULT 0,
  risco_log_inicio DATETIME DEFAULT NULL,
	risco_log_fim DATETIME DEFAULT NULL,
	risco_log_duracao DECIMAL(20,5) UNSIGNED DEFAULT NULL,
  risco_log_percentagem DECIMAL(20,5) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (risco_log_id),
  KEY risco_log_risco (risco_log_risco),
  KEY risco_log_criador (risco_log_criador),
  CONSTRAINT risco_log_fk FOREIGN KEY (risco_log_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT risco_log_fk1 FOREIGN KEY (risco_log_criador) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS risco_usuarios;

CREATE TABLE risco_usuarios (
  risco_id INTEGER(100) UNSIGNED NOT NULL,
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (risco_id, usuario_id),
  KEY risco_id (risco_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT risco_usuarios_fk1 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT risco_usuarios_fk FOREIGN KEY (risco_id) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS risco_matriz;

CREATE TABLE risco_matriz (
  risco_matriz_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  risco_matriz_probabilidade INTEGER(10) UNSIGNED DEFAULT NULL,
  risco_matriz_impacto INTEGER(1) UNSIGNED DEFAULT NULL,
  risco_matriz_gravidade INTEGER(1) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (risco_matriz_id)
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS risco_resposta_depts;

CREATE TABLE risco_resposta_depts (
  risco_resposta_id INTEGER(100) UNSIGNED NOT NULL,
  dept_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (risco_resposta_id, dept_id),
  KEY risco_resposta_id (risco_resposta_id),
  KEY dept_id (dept_id),
  CONSTRAINT risco_resposta_depts_fk1 FOREIGN KEY (dept_id) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT risco_resposta_depts_fk FOREIGN KEY (risco_resposta_id) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS risco_resposta_log;

CREATE TABLE risco_resposta_log (
  risco_resposta_log_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  risco_resposta_log_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
  risco_resposta_log_criador INTEGER(100) UNSIGNED DEFAULT NULL,
  risco_resposta_log_horas DECIMAL(20,5) UNSIGNED DEFAULT 0,
  risco_resposta_log_descricao TEXT,
  risco_resposta_log_custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
  risco_resposta_log_nd VARCHAR(11) DEFAULT NULL,
  risco_resposta_log_categoria_economica VARCHAR(1) DEFAULT NULL,
  risco_resposta_log_grupo_despesa VARCHAR(1) DEFAULT NULL,
  risco_resposta_log_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  risco_resposta_log_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_log_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
  risco_resposta_log_problema TINYINT(1) DEFAULT 0,
  risco_resposta_log_referencia INTEGER(11) DEFAULT NULL,
  risco_resposta_log_nome VARCHAR(200) DEFAULT NULL,
  risco_resposta_log_data DATETIME DEFAULT NULL,
  risco_resposta_log_url_relacionada VARCHAR(250) DEFAULT NULL,
  risco_resposta_log_acesso INTEGER(100) DEFAULT 0,
  risco_resposta_log_inicio DATETIME DEFAULT NULL,
	risco_resposta_log_fim DATETIME DEFAULT NULL,
	risco_resposta_log_duracao DECIMAL(20,5) UNSIGNED DEFAULT NULL,
  risco_resposta_log_percentagem DECIMAL(20,5) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (risco_resposta_log_id),
  KEY risco_resposta_log_risco_resposta (risco_resposta_log_risco_resposta),
  KEY risco_resposta_log_criador (risco_resposta_log_criador),
  CONSTRAINT risco_resposta_log_fk FOREIGN KEY (risco_resposta_log_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT risco_resposta_log_fk1 FOREIGN KEY (risco_resposta_log_criador) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS risco_resposta_usuarios;

CREATE TABLE risco_resposta_usuarios (
  risco_resposta_id INTEGER(100) UNSIGNED NOT NULL,
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (risco_resposta_id, usuario_id),
  KEY risco_resposta_id (risco_resposta_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT risco_resposta_usuarios_fk1 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT risco_resposta_usuarios_fk FOREIGN KEY (risco_resposta_id) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS usuario_cha_mod;

CREATE TABLE usuario_cha_mod (
	usuario_cha_mod_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	usuario_cha_mod_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	usuario_cha_mod_nome VARCHAR(255) DEFAULT NULL,
	usuario_cha_mod_tipo VARCHAR(20) DEFAULT NULL,
	usuario_cha_mod_area VARCHAR(20) DEFAULT NULL,
	usuario_cha_mod_descricao MEDIUMTEXT,
	PRIMARY KEY (usuario_cha_mod_id)
	)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS usuario_cha_mod_opcao;

CREATE TABLE usuario_cha_mod_opcao (
	usuario_cha_mod_opcao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	usuario_cha_mod_opcao_modelo INTEGER(100) UNSIGNED DEFAULT NULL,
	usuario_cha_mod_opcao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	usuario_cha_mod_opcao_nome VARCHAR(255) DEFAULT NULL,
	usuario_cha_mod_opcao_valor INTEGER(100) DEFAULT NULL,
	PRIMARY KEY (usuario_cha_mod_opcao_id),
	KEY usuario_cha_mod_opcao_modelo (usuario_cha_mod_opcao_modelo),
	CONSTRAINT usuario_cha_mod_opcao_fk FOREIGN KEY (usuario_cha_mod_opcao_modelo) REFERENCES usuario_cha_mod (usuario_cha_mod_id) ON DELETE CASCADE ON UPDATE CASCADE
	)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS usuario_cha;

CREATE TABLE usuario_cha (
	usuario_cha_usuario INTEGER(100) UNSIGNED NOT NULL,
	usuario_cha_modelo INTEGER(100) UNSIGNED NOT NULL,
	usuario_cha_valor INTEGER(100) DEFAULT NULL,
	PRIMARY KEY (usuario_cha_usuario, usuario_cha_modelo),
	KEY usuario_cha_usuario (usuario_cha_usuario),
	KEY usuario_cha_modelo (usuario_cha_modelo),
	CONSTRAINT usuario_cha_fk1 FOREIGN KEY (usuario_cha_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT usuario_cha_fk2 FOREIGN KEY (usuario_cha_modelo) REFERENCES usuario_cha_mod (usuario_cha_mod_id) ON DELETE CASCADE ON UPDATE CASCADE
	)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS nd;

CREATE TABLE nd (
  nd_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  nd_pai INTEGER(11) DEFAULT NULL,
  nd_codigo VARCHAR(20) DEFAULT NULL,
  nd_classe INTEGER(1) DEFAULT NULL,
  nd_grupo INTEGER(1) DEFAULT NULL,
  nd_subgrupo INTEGER(1) DEFAULT NULL,
  nd_elemento INTEGER(1) DEFAULT NULL,
  nd_subelemento INTEGER(1) DEFAULT NULL,
  nd_elemento_subelemento VARCHAR(3) DEFAULT NULL,
  nd_item VARCHAR(3) COLLATE latin1_swedish_ci DEFAULT NULL,
  nd_subitem VARCHAR(3) DEFAULT NULL,
  nd_item_subitem VARCHAR(6) DEFAULT NULL,
  nd_texto VARCHAR(80) DEFAULT NULL,
  nd_observacao VARCHAR(80) DEFAULT NULL,
  nd_inicio DATE DEFAULT NULL,
  PRIMARY KEY (nd_id)
)ENGINE=InnoDB CHARACTER SET 'latin1' COLLATE 'latin1_swedish_ci';

DROP TABLE IF EXISTS ator;

CREATE TABLE ator (
  ator_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  ator_nome VARCHAR(255) DEFAULT NULL,
  ator_obs TEXT,
  ator_tipo VARCHAR(50) DEFAULT NULL,
	ator_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  ator_cor VARCHAR(6) DEFAULT 'FFFFFF',
  ator_ativo TINYINT(1) DEFAULT 1,
  PRIMARY KEY (ator_id)
)ENGINE=InnoDB  CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS ator_usuario;

CREATE TABLE ator_usuario (
  ator_usuario_ator INTEGER(100) UNSIGNED DEFAULT NULL,
  ator_usuario_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  ator_usuario_uuid VARCHAR(36) DEFAULT NULL,
  KEY ator_usuario_ator (ator_usuario_ator),
  KEY ator_usuario_usuario (ator_usuario_usuario),
  KEY ator_usuario_uuid (ator_usuario_uuid),
  CONSTRAINT ator_usuario_fk1 FOREIGN KEY (ator_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT ator_usuario_fk FOREIGN KEY (ator_usuario_ator) REFERENCES ator (ator_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS ator_cia;

CREATE TABLE ator_cia (
  ator_cia_ator INTEGER(100) UNSIGNED DEFAULT NULL,
  ator_cia_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  ator_cia_uuid VARCHAR(36) DEFAULT NULL,
  KEY ator_cia_ator (ator_cia_ator),
  KEY ator_cia_cia (ator_cia_cia),
  KEY ator_cia_uuid (ator_cia_uuid),
  CONSTRAINT ator_cia_fk FOREIGN KEY (ator_cia_ator) REFERENCES ator (ator_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT ator_cia_fk1 FOREIGN KEY (ator_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS ator_projeto;

CREATE TABLE ator_projeto (
  ator_projeto_ator INTEGER(100) UNSIGNED DEFAULT NULL,
  ator_projeto_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  ator_projeto_uuid VARCHAR(36) DEFAULT NULL,
  KEY ator_projeto_ator (ator_projeto_ator),
  KEY ator_projeto_projeto (ator_projeto_projeto),
  KEY ator_projeto_uuid (ator_projeto_uuid),
  CONSTRAINT ator_projeto_fk FOREIGN KEY (ator_projeto_ator) REFERENCES ator (ator_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT ator_projeto_fk1 FOREIGN KEY (ator_projeto_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS ator_acao;

CREATE TABLE ator_acao (
	ator_acao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  ator_acao_remetente INTEGER(100) UNSIGNED DEFAULT NULL,
  ator_acao_acao_remetente INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (ator_acao_id),
  KEY ator_acao_remetente (ator_acao_remetente),
  CONSTRAINT ator_acao_fk FOREIGN KEY (ator_acao_remetente) REFERENCES ator (ator_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS ator_acao_destinatario;

CREATE TABLE ator_acao_destinatario (
	ator_acao_destinatario_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  ator_acao_destinatario_acao INTEGER(100) UNSIGNED DEFAULT NULL,
  ator_acao_destinatario_ator INTEGER(100) UNSIGNED DEFAULT NULL,
  ator_acao_destinatario_verbo INTEGER(100) UNSIGNED DEFAULT NULL,
  ator_acao_destinatario_tipo_om VARCHAR(30) DEFAULT NULL,
  ator_acao_destinatario_tem_prazo TINYINT(1) DEFAULT 0,
  ator_acao_destinatario_tipo_prazo VARCHAR(30) DEFAULT NULL,
  PRIMARY KEY (ator_acao_destinatario_id),
  KEY ator_acao_destinatario_acao (ator_acao_destinatario_acao),
  KEY ator_acao_destinatario_ator (ator_acao_destinatario_ator),
  KEY ator_acao_destinatario_verbo (ator_acao_destinatario_verbo),
  CONSTRAINT ator_acao_destinatario_fk FOREIGN KEY (ator_acao_destinatario_acao) REFERENCES ator_acao (ator_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT ator_acao_destinatario_fk1 FOREIGN KEY (ator_acao_destinatario_ator) REFERENCES ator (ator_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT ator_acao_destinatario_fk2 FOREIGN KEY (ator_acao_destinatario_verbo) REFERENCES ator_acao_verbo (ator_acao_verbo_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS ator_acao_verbo;

CREATE TABLE ator_acao_verbo (
	ator_acao_verbo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  ator_acao_verbo_acao INTEGER(100) UNSIGNED DEFAULT NULL,
  ator_acao_verbo_texto TEXT,
  ator_acao_verbo_valor VARCHAR(255) DEFAULT NULL,
  PRIMARY KEY (ator_acao_verbo_id),
  KEY ator_acao_verbo_acao (ator_acao_verbo_acao),
  CONSTRAINT ator_acao_verbo_fk FOREIGN KEY (ator_acao_verbo_acao) REFERENCES ator_acao (ator_acao_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS ator_acao_dependencia;

CREATE TABLE ator_acao_dependencia (
	ator_acao_dependencia_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  ator_acao_dependencia_pai INTEGER(100) UNSIGNED DEFAULT NULL,
	ator_acao_dependencia_filho INTEGER(100) UNSIGNED DEFAULT NULL,
  ator_acao_no_grupo TEXT,
  ator_acao_fora_grupo TEXT,
  PRIMARY KEY (ator_acao_dependencia_id),
  KEY ator_acao_dependencia_pai (ator_acao_dependencia_pai),
  CONSTRAINT ator_acao_dependencia_fk FOREIGN KEY (ator_acao_dependencia_pai) REFERENCES ator_acao (ator_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT ator_acao_dependencia_fk1 FOREIGN KEY (ator_acao_dependencia_filho) REFERENCES ator_acao (ator_acao_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS ator_informar_acao;

CREATE TABLE ator_informar_acao (
	ator_informar_acao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  ator_informar_acao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
  ator_informar_acao_ator INTEGER(100) UNSIGNED DEFAULT NULL,
  ator_informar_acao_tipo_om VARCHAR(30) DEFAULT NULL,
  PRIMARY KEY (ator_informar_acao_id),
  KEY ator_informar_acao_acao (ator_informar_acao_acao),
  KEY ator_informar_acao_ator (ator_informar_acao_ator),
  CONSTRAINT ator_informar_acao_fk FOREIGN KEY (ator_informar_acao_acao) REFERENCES ator_acao (ator_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT ator_informar_acao_fk1 FOREIGN KEY (ator_informar_acao_ator) REFERENCES ator (ator_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS indicador_valor_arquivo;

CREATE TABLE indicador_valor_arquivo (
  indicador_valor_arquivo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  indicador_valor_arquivo_indicador_valor INTEGER(100) UNSIGNED DEFAULT NULL,
  indicador_valor_arquivo_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
  indicador_valor_arquivo_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  indicador_valor_arquivo_ordem INTEGER(11) DEFAULT 0,
  indicador_valor_arquivo_endereco VARCHAR(150) DEFAULT NULL,
  indicador_valor_arquivo_data DATETIME DEFAULT NULL,
  indicador_valor_arquivo_nome VARCHAR(150) DEFAULT NULL,
  indicador_valor_arquivo_nome_real VARCHAR(255) DEFAULT NULL,
	indicador_valor_arquivo_local VARCHAR (255) DEFAULT NULL,
	indicador_valor_arquivo_tamanho INTEGER(100) UNSIGNED DEFAULT NULL,
  indicador_valor_arquivo_tipo VARCHAR(50) DEFAULT NULL,
  indicador_valor_arquivo_extensao VARCHAR(50) DEFAULT NULL,
  PRIMARY KEY (indicador_valor_arquivo_id),
  KEY indicador_valor_arquivo_indicador_valor (indicador_valor_arquivo_indicador_valor),
  KEY indicador_valor_arquivo_checklist (indicador_valor_arquivo_checklist),
  KEY indicador_valor_arquivo_usuario (indicador_valor_arquivo_usuario),
  CONSTRAINT indicador_valor_arquivos_fk FOREIGN KEY (indicador_valor_arquivo_indicador_valor) REFERENCES pratica_indicador_valor (pratica_indicador_valor_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT indicador_valor_arquivo_checklist_fk1 FOREIGN KEY (indicador_valor_arquivo_checklist) REFERENCES checklist_dados (checklist_dados_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT indicador_valor_arquivos_fk2 FOREIGN KEY (indicador_valor_arquivo_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS pi;

CREATE TABLE pi (
	pi_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	pi_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_link INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_template INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_me INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_pi varchar(11) DEFAULT NULL,
  pi_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  pi_uuid varchar(36) DEFAULT NULL,
	PRIMARY KEY pi_id (pi_id),
	KEY pi_projeto (pi_projeto),
	KEY pi_tarefa (pi_tarefa),
	KEY pi_perspectiva (pi_perspectiva),
	KEY pi_tema (pi_tema),
	KEY pi_objetivo (pi_objetivo),
	KEY pi_estrategia (pi_estrategia),
	KEY pi_meta (pi_meta),
	KEY pi_fator (pi_fator),
	KEY pi_pratica (pi_pratica),
	KEY pi_indicador (pi_indicador),
	KEY pi_acao (pi_acao),
	KEY pi_canvas (pi_canvas),
	KEY pi_risco (pi_risco),
	KEY pi_risco_resposta (pi_risco_resposta),
	KEY pi_calendario (pi_calendario),
	KEY pi_monitoramento (pi_monitoramento),
	KEY pi_ata (pi_ata),
	KEY pi_mswot(pi_mswot),
	KEY pi_swot(pi_swot),
	KEY pi_operativo(pi_operativo),
	KEY pi_instrumento (pi_instrumento),
	KEY pi_recurso (pi_recurso),
	KEY pi_problema (pi_problema),
	KEY pi_demanda (pi_demanda),
	KEY pi_programa (pi_programa),
	KEY pi_licao (pi_licao),
	KEY pi_evento (pi_evento),
	KEY pi_link (pi_link),
	KEY pi_avaliacao (pi_avaliacao),
	KEY pi_tgn (pi_tgn),
	KEY pi_brainstorm (pi_brainstorm),
	KEY pi_gut (pi_gut),
	KEY pi_causa_efeito (pi_causa_efeito),
	KEY pi_arquivo (pi_arquivo),
	KEY pi_forum (pi_forum),
	KEY pi_checklist (pi_checklist),
	KEY pi_agenda (pi_agenda),
	KEY pi_agrupamento (pi_agrupamento),
	KEY pi_patrocinador (pi_patrocinador),
	KEY pi_template (pi_template),
	KEY pi_painel (pi_painel),
	KEY pi_painel_odometro (pi_painel_odometro),
	KEY pi_painel_composicao (pi_painel_composicao),
	KEY pi_tr (pi_tr),
	KEY pi_me (pi_me),
	KEY pi_acao_item (pi_acao_item),
	KEY pi_beneficio (pi_beneficio),
	KEY pi_painel_slideshow (pi_painel_slideshow),
	KEY pi_projeto_viabilidade (pi_projeto_viabilidade),
	KEY pi_projeto_abertura (pi_projeto_abertura),
	KEY pi_plano_gestao (pi_plano_gestao),
	CONSTRAINT pi_projeto FOREIGN KEY (pi_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_tarefa FOREIGN KEY (pi_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_perspectiva FOREIGN KEY (pi_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_tema FOREIGN KEY (pi_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_objetivo FOREIGN KEY (pi_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_fator FOREIGN KEY (pi_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_estrategia FOREIGN KEY (pi_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_meta FOREIGN KEY (pi_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_pratica FOREIGN KEY (pi_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_indicador FOREIGN KEY (pi_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_acao FOREIGN KEY (pi_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_canvas FOREIGN KEY (pi_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_risco FOREIGN KEY (pi_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_risco_resposta FOREIGN KEY (pi_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_calendario FOREIGN KEY (pi_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_monitoramento FOREIGN KEY (pi_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_ata FOREIGN KEY (pi_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_mswot FOREIGN KEY (pi_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_swot FOREIGN KEY (pi_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_operativo FOREIGN KEY (pi_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_instrumento FOREIGN KEY (pi_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_recurso FOREIGN KEY (pi_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_problema FOREIGN KEY (pi_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_demanda FOREIGN KEY (pi_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_programa FOREIGN KEY (pi_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_licao FOREIGN KEY (pi_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_evento FOREIGN KEY (pi_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_link FOREIGN KEY (pi_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_avaliacao FOREIGN KEY (pi_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_tgn FOREIGN KEY (pi_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_brainstorm FOREIGN KEY (pi_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_gut FOREIGN KEY (pi_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_causa_efeito FOREIGN KEY (pi_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_arquivo FOREIGN KEY (pi_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_forum FOREIGN KEY (pi_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_checklist FOREIGN KEY (pi_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_agenda FOREIGN KEY (pi_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_agrupamento FOREIGN KEY (pi_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_patrocinador FOREIGN KEY (pi_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_template FOREIGN KEY (pi_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_painel FOREIGN KEY (pi_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_painel_odometro FOREIGN KEY (pi_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_painel_composicao FOREIGN KEY (pi_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_tr FOREIGN KEY (pi_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_me FOREIGN KEY (pi_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_acao_item FOREIGN KEY (pi_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_beneficio FOREIGN KEY (pi_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_painel_slideshow FOREIGN KEY (pi_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_projeto_viabilidade FOREIGN KEY (pi_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_projeto_abertura FOREIGN KEY (pi_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_plano_gestao FOREIGN KEY (pi_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS ptres;

CREATE TABLE ptres (
	ptres_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	ptres_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_link INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_template INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_me INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_ptres varchar(11) DEFAULT NULL,
  ptres_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  ptres_uuid varchar(36) DEFAULT NULL,
	PRIMARY KEY ptres_id (ptres_id),
	KEY ptres_projeto (ptres_projeto),
	KEY ptres_tarefa (ptres_tarefa),
	KEY ptres_perspectiva (ptres_perspectiva),
	KEY ptres_tema (ptres_tema),
	KEY ptres_objetivo (ptres_objetivo),
	KEY ptres_estrategia (ptres_estrategia),
	KEY ptres_meta (ptres_meta),
	KEY ptres_fator (ptres_fator),
	KEY ptres_pratica (ptres_pratica),
	KEY ptres_indicador (ptres_indicador),
	KEY ptres_acao (ptres_acao),
	KEY ptres_canvas (ptres_canvas),
	KEY ptres_risco (ptres_risco),
	KEY ptres_risco_resposta (ptres_risco_resposta),
	KEY ptres_calendario (ptres_calendario),
	KEY ptres_monitoramento (ptres_monitoramento),
	KEY ptres_ata (ptres_ata),
	KEY ptres_mswot(ptres_mswot),
	KEY ptres_swot(ptres_swot),
	KEY ptres_operativo(ptres_operativo),
	KEY ptres_instrumento (ptres_instrumento),
	KEY ptres_recurso (ptres_recurso),
	KEY ptres_problema (ptres_problema),
	KEY ptres_demanda (ptres_demanda),
	KEY ptres_programa (ptres_programa),
	KEY ptres_licao (ptres_licao),
	KEY ptres_evento (ptres_evento),
	KEY ptres_link (ptres_link),
	KEY ptres_avaliacao (ptres_avaliacao),
	KEY ptres_tgn (ptres_tgn),
	KEY ptres_brainstorm (ptres_brainstorm),
	KEY ptres_gut (ptres_gut),
	KEY ptres_causa_efeito (ptres_causa_efeito),
	KEY ptres_arquivo (ptres_arquivo),
	KEY ptres_forum (ptres_forum),
	KEY ptres_checklist (ptres_checklist),
	KEY ptres_agenda (ptres_agenda),
	KEY ptres_agrupamento (ptres_agrupamento),
	KEY ptres_patrocinador (ptres_patrocinador),
	KEY ptres_template (ptres_template),
	KEY ptres_painel (ptres_painel),
	KEY ptres_painel_odometro (ptres_painel_odometro),
	KEY ptres_painel_composicao (ptres_painel_composicao),
	KEY ptres_tr (ptres_tr),
	KEY ptres_me (ptres_me),
	KEY ptres_acao_item (ptres_acao_item),
	KEY ptres_beneficio (ptres_beneficio),
	KEY ptres_painel_slideshow (ptres_painel_slideshow),
	KEY ptres_projeto_viabilidade (ptres_projeto_viabilidade),
	KEY ptres_projeto_abertura (ptres_projeto_abertura),
	KEY ptres_plano_gestao (ptres_plano_gestao),
	CONSTRAINT ptres_projeto FOREIGN KEY (ptres_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_tarefa FOREIGN KEY (ptres_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_perspectiva FOREIGN KEY (ptres_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_tema FOREIGN KEY (ptres_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_objetivo FOREIGN KEY (ptres_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_fator FOREIGN KEY (ptres_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_estrategia FOREIGN KEY (ptres_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_meta FOREIGN KEY (ptres_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_pratica FOREIGN KEY (ptres_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_indicador FOREIGN KEY (ptres_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_acao FOREIGN KEY (ptres_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_canvas FOREIGN KEY (ptres_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_risco FOREIGN KEY (ptres_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_risco_resposta FOREIGN KEY (ptres_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_calendario FOREIGN KEY (ptres_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_monitoramento FOREIGN KEY (ptres_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_ata FOREIGN KEY (ptres_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_mswot FOREIGN KEY (ptres_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_swot FOREIGN KEY (ptres_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_operativo FOREIGN KEY (ptres_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_instrumento FOREIGN KEY (ptres_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_recurso FOREIGN KEY (ptres_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_problema FOREIGN KEY (ptres_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_demanda FOREIGN KEY (ptres_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_programa FOREIGN KEY (ptres_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_licao FOREIGN KEY (ptres_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_evento FOREIGN KEY (ptres_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_link FOREIGN KEY (ptres_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_avaliacao FOREIGN KEY (ptres_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_tgn FOREIGN KEY (ptres_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_brainstorm FOREIGN KEY (ptres_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_gut FOREIGN KEY (ptres_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_causa_efeito FOREIGN KEY (ptres_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_arquivo FOREIGN KEY (ptres_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_forum FOREIGN KEY (ptres_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_checklist FOREIGN KEY (ptres_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_agenda FOREIGN KEY (ptres_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_agrupamento FOREIGN KEY (ptres_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_patrocinador FOREIGN KEY (ptres_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_template FOREIGN KEY (ptres_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_painel FOREIGN KEY (ptres_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_painel_odometro FOREIGN KEY (ptres_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_painel_composicao FOREIGN KEY (ptres_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_tr FOREIGN KEY (ptres_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_me FOREIGN KEY (ptres_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_acao_item FOREIGN KEY (ptres_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_beneficio FOREIGN KEY (ptres_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_painel_slideshow FOREIGN KEY (ptres_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_projeto_viabilidade FOREIGN KEY (ptres_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_projeto_abertura FOREIGN KEY (ptres_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_plano_gestao FOREIGN KEY (ptres_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS pratica_indicador_avaliacao;

CREATE TABLE pratica_indicador_avaliacao (
  pratica_indicador_avaliacao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pratica_indicador_avaliacao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_avaliacao_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_avaliacao_data DATE DEFAULT NULL,
  pratica_indicador_avaliacao_sucesso TINYINT(1) DEFAULT 0,
  pratica_indicador_avaliacao_causa VARCHAR(255) DEFAULT NULL,
  pratica_indicador_avaliacao_sanar MEDIUMTEXT,
  pratica_indicador_avaliacao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (pratica_indicador_avaliacao_id),
  KEY pratica_indicador_avaliacao_indicador (pratica_indicador_avaliacao_indicador),
  KEY pratica_indicador_avaliacao_responsavel (pratica_indicador_avaliacao_responsavel),
  CONSTRAINT pratica_indicador_avaliacao_fk FOREIGN KEY (pratica_indicador_avaliacao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT pratica_indicador_avaliacao_fk1 FOREIGN KEY (pratica_indicador_avaliacao_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_arquivo;

CREATE TABLE eb_arquivo (
  eb_arquivo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  eb_arquivo_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_arquivo_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_arquivo_artefato VARCHAR(30) DEFAULT NULL,
  eb_arquivo_ordem INTEGER(11) DEFAULT NULL,
  eb_arquivo_endereco VARCHAR(150) DEFAULT NULL,
  eb_arquivo_data DATETIME DEFAULT NULL,
  eb_arquivo_nome VARCHAR(150) DEFAULT NULL,
  eb_arquivo_tipo VARCHAR(50) DEFAULT NULL,
  eb_arquivo_extensao VARCHAR(50) DEFAULT NULL,
	eb_arquivo_nome_real VARCHAR(255) DEFAULT NULL,
	eb_arquivo_local VARCHAR(255) DEFAULT NULL,
	eb_arquivo_tamanho INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (eb_arquivo_id),
  KEY eb_arquivo_projeto (eb_arquivo_projeto),
  KEY eb_arquivo_usuario (eb_arquivo_usuario),
  CONSTRAINT eb_arquivo_fk FOREIGN KEY (eb_arquivo_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT eb_arquivo_fk1 FOREIGN KEY (eb_arquivo_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_encerramento;

CREATE TABLE eb_encerramento (
	eb_encerramento_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_encerramento_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_encerramento_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_encerramento_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_encerramento_data_preparado DATE DEFAULT NULL,
	eb_encerramento_data_aprovado DATE DEFAULT NULL,
	eb_encerramento_data_revisado DATE DEFAULT NULL,
	eb_encerramento_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_encerramento_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_encerramento_baseline INTEGER(100) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (eb_encerramento_id),
	KEY eb_encerramento_projeto (eb_encerramento_projeto),
	KEY eb_encerramento_preparado_por (eb_encerramento_preparado_por),
	KEY eb_encerramento_aprovado_por (eb_encerramento_aprovado_por),
	KEY eb_encerramento_baseline (eb_encerramento_baseline),
	CONSTRAINT eb_encerramento_fk FOREIGN KEY (eb_encerramento_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT eb_encerramento_fk2 FOREIGN KEY (eb_encerramento_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT eb_encerramento_fk3 FOREIGN KEY (eb_encerramento_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT eb_encerramento_fk4 FOREIGN KEY (eb_encerramento_baseline) REFERENCES baseline (baseline_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_encerramento_campo;

CREATE TABLE eb_encerramento_campo (
	eb_encerramento_campo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_encerramento_campo_encerramento INTEGER(100) UNSIGNED NOT NULL,
	eb_encerramento_campo_texto TEXT,
	eb_encerramento_campo_titulo VARCHAR(50),
	PRIMARY KEY (eb_encerramento_campo_id),
	KEY eb_encerramento_campo_encerramento (eb_encerramento_campo_encerramento),
	CONSTRAINT eb_encerramento_campo_fk FOREIGN KEY (eb_encerramento_campo_encerramento) REFERENCES eb_encerramento (eb_encerramento_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_situacao;

CREATE TABLE eb_situacao (
	eb_situacao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_situacao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_situacao_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_situacao_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_situacao_data_preparado DATE DEFAULT NULL,
	eb_situacao_data_aprovado DATE DEFAULT NULL,
	eb_situacao_data_revisado DATE DEFAULT NULL,
	eb_situacao_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_situacao_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_situacao_baseline INTEGER(100) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (eb_situacao_id),
	KEY eb_situacao_projeto (eb_situacao_projeto),
	KEY eb_situacao_preparado_por (eb_situacao_preparado_por),
	KEY eb_situacao_aprovado_por (eb_situacao_aprovado_por),
	KEY eb_situacao_baseline (eb_situacao_baseline),
	CONSTRAINT eb_situacao_fk FOREIGN KEY (eb_situacao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT eb_situacao_fk2 FOREIGN KEY (eb_situacao_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT eb_situacao_fk3 FOREIGN KEY (eb_situacao_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT eb_situacao_fk4 FOREIGN KEY (eb_situacao_baseline) REFERENCES baseline (baseline_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_situacao_campo;

CREATE TABLE eb_situacao_campo (
	eb_situacao_campo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_situacao_campo_situacao INTEGER(100) UNSIGNED NOT NULL,
	eb_situacao_campo_texto TEXT,
	eb_situacao_campo_titulo VARCHAR(50),
	PRIMARY KEY (eb_situacao_campo_id),
	KEY eb_situacao_campo_situacao (eb_situacao_campo_situacao),
	CONSTRAINT eb_situacao_campo_fk FOREIGN KEY (eb_situacao_campo_situacao) REFERENCES eb_situacao (eb_situacao_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_aceite;

CREATE TABLE eb_aceite (
	eb_aceite_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_aceite_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_aceite_nr INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_aceite_data DATE DEFAULT NULL,
	eb_aceite_produto TEXT,
	eb_aceite_obs TEXT,
	eb_aceite_ok TINYINT(1) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (eb_aceite_id),
	KEY eb_aceite_projeto (eb_aceite_projeto),
	CONSTRAINT eb_aceite_fk FOREIGN KEY (eb_aceite_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_mudanca_controle;

CREATE TABLE eb_mudanca_controle (
	eb_mudanca_controle_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_mudanca_controle_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_data_preparado DATE DEFAULT NULL,
	eb_mudanca_controle_data_aprovado DATE DEFAULT NULL,
	eb_mudanca_controle_data_revisado DATE DEFAULT NULL,
	eb_mudanca_controle_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_nr_rcm INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_data_abertura DATE DEFAULT NULL,
	eb_mudanca_controle_subprojeto VARCHAR (255) DEFAULT NULL,
	eb_mudanca_controle_solicitante INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_baseline1 INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_baseline2 INTEGER(100) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (eb_mudanca_controle_id),
	KEY eb_mudanca_controle_projeto (eb_mudanca_controle_projeto),
	KEY eb_mudanca_controle_preparado_por (eb_mudanca_controle_preparado_por),
	KEY eb_mudanca_controle_aprovado_por (eb_mudanca_controle_aprovado_por),
	KEY eb_mudanca_controle_solicitante (eb_mudanca_controle_solicitante),
	KEY eb_mudanca_controle_baseline1 (eb_mudanca_controle_baseline1),
	KEY eb_mudanca_controle_baseline2 (eb_mudanca_controle_baseline2),
	CONSTRAINT eb_mudanca_controle_fk FOREIGN KEY (eb_mudanca_controle_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT eb_mudanca_controle_fk2 FOREIGN KEY (eb_mudanca_controle_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT eb_mudanca_controle_fk3 FOREIGN KEY (eb_mudanca_controle_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT eb_mudanca_controle_fk4 FOREIGN KEY (eb_mudanca_controle_baseline1) REFERENCES baseline (baseline_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT eb_mudanca_controle_fk5 FOREIGN KEY (eb_mudanca_controle_baseline2) REFERENCES baseline (baseline_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT eb_mudanca_controle_fk6 FOREIGN KEY (eb_mudanca_controle_solicitante) REFERENCES contatos (contato_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS eb_mudanca_controle_campo;

CREATE TABLE eb_mudanca_controle_campo (
	eb_mudanca_controle_campo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_mudanca_controle_campo_mudanca INTEGER(100) UNSIGNED NOT NULL,
	eb_mudanca_controle_campo_texto TEXT,
	eb_mudanca_controle_campo_titulo VARCHAR(50),
	PRIMARY KEY (eb_mudanca_controle_campo_id),
	KEY eb_mudanca_controle_campo_mudanca (eb_mudanca_controle_campo_mudanca),
	CONSTRAINT eb_mudanca_controle_campo_fk FOREIGN KEY (eb_mudanca_controle_campo_mudanca) REFERENCES eb_mudanca_controle (eb_mudanca_controle_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS eb_mudanca_controle_item;

CREATE TABLE eb_mudanca_controle_item (
	eb_mudanca_controle_item_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_mudanca_controle_item_mudanca_controle INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_item_contato INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_item_papel VARCHAR(255),
	eb_mudanca_controle_item_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_item_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (eb_mudanca_controle_item_id),
	KEY eb_mudanca_controle_item_mudanca_controle (eb_mudanca_controle_item_mudanca_controle),
	KEY eb_mudanca_controle_item_contato (eb_mudanca_controle_item_contato),
	CONSTRAINT eb_mudanca_controle_item_fk FOREIGN KEY (eb_mudanca_controle_item_mudanca_controle) REFERENCES eb_mudanca_controle (eb_mudanca_controle_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT eb_mudanca_controle_item_fk2 FOREIGN KEY (eb_mudanca_controle_item_contato) REFERENCES contatos (contato_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS eb_mudanca_controle_escopo;

CREATE TABLE eb_mudanca_controle_escopo (
	eb_mudanca_controle_escopo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_mudanca_controle_escopo_mudanca_controle INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_escopo_tipo INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_escopo_entrega TEXT,
	eb_mudanca_controle_escopo_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_escopo_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (eb_mudanca_controle_escopo_id),
	KEY eb_mudanca_controle_escopo_mudanca_controle (eb_mudanca_controle_escopo_mudanca_controle),
	CONSTRAINT eb_mudanca_controle_escopo_fk FOREIGN KEY (eb_mudanca_controle_escopo_mudanca_controle) REFERENCES eb_mudanca_controle (eb_mudanca_controle_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS eb_mudanca_controle_custo;

CREATE TABLE eb_mudanca_controle_custo (
	eb_mudanca_controle_custo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_mudanca_controle_custo_mudanca_controle INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_custo_produto TEXT,
	eb_mudanca_controle_custo_antes DECIMAL(20,5) UNSIGNED DEFAULT 0,
	eb_mudanca_controle_custo_depois DECIMAL(20,5) UNSIGNED DEFAULT '0.000',
	eb_mudanca_controle_custo_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_custo_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (eb_mudanca_controle_custo_id),
	KEY eb_mudanca_controle_custo_mudanca_controle (eb_mudanca_controle_custo_mudanca_controle),
	CONSTRAINT eb_mudanca_controle_custo_fk FOREIGN KEY (eb_mudanca_controle_custo_mudanca_controle) REFERENCES eb_mudanca_controle (eb_mudanca_controle_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_mudanca;

CREATE TABLE eb_mudanca (
	eb_mudanca_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_mudanca_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_data_preparado DATE DEFAULT NULL,
	eb_mudanca_data_aprovado DATE DEFAULT NULL,
	eb_mudanca_data_revisado DATE DEFAULT NULL,
	eb_mudanca_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_mudanca_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (eb_mudanca_id),
	KEY eb_mudanca_projeto (eb_mudanca_projeto),
	KEY eb_mudanca_preparado_por (eb_mudanca_preparado_por),
	KEY eb_mudanca_aprovado_por (eb_mudanca_aprovado_por),
	CONSTRAINT eb_mudanca_fk FOREIGN KEY (eb_mudanca_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT eb_mudanca_fk2 FOREIGN KEY (eb_mudanca_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT eb_mudanca_fk3 FOREIGN KEY (eb_mudanca_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_mudanca_campo;

CREATE TABLE eb_mudanca_campo (
	eb_mudanca_campo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_mudanca_campo_mudanca INTEGER(100) UNSIGNED NOT NULL,
	eb_mudanca_campo_texto TEXT,
	eb_mudanca_campo_titulo VARCHAR(50),
	PRIMARY KEY (eb_mudanca_campo_id),
	KEY eb_mudanca_campo_mudanca (eb_mudanca_campo_mudanca),
	CONSTRAINT eb_mudanca_campo_fk FOREIGN KEY (eb_mudanca_campo_mudanca) REFERENCES eb_mudanca (eb_mudanca_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_mudanca_item;

CREATE TABLE eb_mudanca_item (
	eb_mudanca_item_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_mudanca_item_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_item_contato INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_item_papel VARCHAR(255),
	eb_mudanca_item_responsabilidade TEXT,
	eb_mudanca_item_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (eb_mudanca_item_id),
	KEY eb_mudanca_item_projeto (eb_mudanca_item_projeto),
	KEY eb_mudanca_item_contato (eb_mudanca_item_contato),
	CONSTRAINT eb_mudanca_item_fk FOREIGN KEY (eb_mudanca_item_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT eb_mudanca_item_fk2 FOREIGN KEY (eb_mudanca_item_contato) REFERENCES contatos (contato_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_qualidade;

CREATE TABLE eb_qualidade (
	eb_qualidade_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_qualidade_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_qualidade_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_qualidade_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_qualidade_data_preparado DATE DEFAULT NULL,
	eb_qualidade_data_aprovado DATE DEFAULT NULL,
	eb_qualidade_data_revisado DATE DEFAULT NULL,
	eb_qualidade_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_qualidade_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_qualidade_requisito TEXT,
	PRIMARY KEY (eb_qualidade_id),
	KEY eb_qualidade_projeto (eb_qualidade_projeto),
	KEY eb_qualidade_preparado_por (eb_qualidade_preparado_por),
	KEY eb_qualidade_data_aprovado (eb_qualidade_data_aprovado),
	CONSTRAINT eb_qualidade_fk FOREIGN KEY (eb_qualidade_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT eb_qualidade_fk2 FOREIGN KEY (eb_qualidade_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT eb_qualidade_fk3 FOREIGN KEY (eb_qualidade_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_qualidade_item;

CREATE TABLE eb_qualidade_item (
	eb_qualidade_item_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_qualidade_item_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_qualidade_item_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_qualidade_item_contato INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_qualidade_item_requisito TEXT,
	eb_qualidade_item_meta TEXT,
	eb_qualidade_item_indicador TEXT,
	eb_qualidade_item_desempenho TEXT,
	eb_qualidade_item_acao TEXT,
	eb_qualidade_item_recurso TEXT,
	eb_qualidade_item_treinamento TEXT,
	eb_qualidade_item_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (eb_qualidade_item_id),
	KEY eb_qualidade_item_projeto (eb_qualidade_item_projeto),
	KEY eb_qualidade_item_tarefa (eb_qualidade_item_tarefa),
	KEY eb_qualidade_item_contato (eb_qualidade_item_contato),
	CONSTRAINT eb_qualidade_item_fk FOREIGN KEY (eb_qualidade_item_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT eb_qualidade_item_fk1 FOREIGN KEY (eb_qualidade_item_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT eb_qualidade_item_fk2 FOREIGN KEY (eb_qualidade_item_contato) REFERENCES contatos (contato_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_risco_item;

CREATE TABLE eb_risco_item (
  eb_risco_item_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  eb_risco_item_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_risco_item_contato INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_risco_item_usuario_inseriu INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_risco_item_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_risco_item_descricao VARCHAR(255) DEFAULT NULL,
  eb_risco_item_categoria VARCHAR(1) DEFAULT NULL,
  eb_risco_item_probabilidade1 VARCHAR(1) DEFAULT NULL,
  eb_risco_item_impacto1 VARCHAR(1) DEFAULT NULL,
  eb_risco_item_criticidade1 VARCHAR(1) DEFAULT NULL,
  eb_risco_item_estrategia VARCHAR(20) DEFAULT NULL,
  eb_risco_item_acao_proposta TEXT,
  eb_risco_item_probabilidade2 VARCHAR(1) DEFAULT NULL,
  eb_risco_item_impacto2 VARCHAR(1) DEFAULT NULL,
  eb_risco_item_criticidade2 VARCHAR(1) DEFAULT NULL,
  eb_risco_item_data DATE DEFAULT NULL,
  eb_risco_item_data_inseriu DATETIME DEFAULT NULL,
  PRIMARY KEY (eb_risco_item_id),
  KEY eb_risco_item_projeto (eb_risco_item_projeto),
  KEY eb_risco_item_usuario_inseriu (eb_risco_item_usuario_inseriu),
  KEY eb_risco_item_contato (eb_risco_item_contato),
  CONSTRAINT eb_risco_item_fk2 FOREIGN KEY (eb_risco_item_contato) REFERENCES contatos (contato_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT eb_risco_item_fk FOREIGN KEY (eb_risco_item_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT eb_risco_item_fk1 FOREIGN KEY (eb_risco_item_usuario_inseriu) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS eb_risco;

CREATE TABLE eb_risco (
	eb_risco_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_risco_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_risco_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_risco_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_risco_data_preparado DATE DEFAULT NULL,
	eb_risco_data_aprovado DATE DEFAULT NULL,
	eb_risco_data_revisado DATE DEFAULT NULL,
	eb_risco_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_risco_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (eb_risco_id),
	KEY eb_risco_projeto (eb_risco_projeto),
	KEY eb_risco_preparado_por (eb_risco_preparado_por),
	KEY eb_risco_aprovado_por (eb_risco_aprovado_por),
	CONSTRAINT eb_risco_fk FOREIGN KEY (eb_risco_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT eb_risco_fk2 FOREIGN KEY (eb_risco_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT eb_risco_fk3 FOREIGN KEY (eb_risco_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_interessado;

CREATE TABLE eb_interessado (
	eb_interessado_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_interessado_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_interessado_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_interessado_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_interessado_data_preparado DATE DEFAULT NULL,
	eb_interessado_data_aprovado DATE DEFAULT NULL,
	eb_interessado_data_revisado DATE DEFAULT NULL,
	eb_interessado_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_interessado_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (eb_interessado_id),
	KEY eb_interessado_projeto (eb_interessado_projeto),
	KEY eb_interessado_preparado_por (eb_interessado_preparado_por),
	KEY eb_interessado_aprovado_por (eb_interessado_aprovado_por),
	CONSTRAINT eb_interessado_fk FOREIGN KEY (eb_interessado_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT eb_interessado_fk2 FOREIGN KEY (eb_interessado_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT eb_interessado_fk3 FOREIGN KEY (eb_interessado_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_interessado_campo;

CREATE TABLE eb_interessado_campo (
	eb_interessado_campo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_interessado_campo_interessado INTEGER(100) UNSIGNED NOT NULL,
	eb_interessado_campo_texto TEXT,
	eb_interessado_campo_titulo VARCHAR(50),
	PRIMARY KEY (eb_interessado_campo_id),
	KEY eb_interessado_campo_interessado (eb_interessado_campo_interessado),
	CONSTRAINT eb_interessado_campo_fk FOREIGN KEY (eb_interessado_campo_interessado) REFERENCES eb_interessado (eb_interessado_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS eb_comunicacao;

CREATE TABLE eb_comunicacao (
	eb_comunicacao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_comunicacao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_comunicacao_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_comunicacao_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_comunicacao_data_preparado DATE DEFAULT NULL,
	eb_comunicacao_data_aprovado DATE DEFAULT NULL,
	eb_comunicacao_data_revisado DATE DEFAULT NULL,
	eb_comunicacao_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_comunicacao_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (eb_comunicacao_id),
	KEY eb_comunicacao_projeto (eb_comunicacao_projeto),
	KEY eb_comunicacao_preparado_por (eb_comunicacao_preparado_por),
	KEY eb_comunicacao_aprovado_por (eb_comunicacao_aprovado_por),
	CONSTRAINT eb_comunicacao_fk FOREIGN KEY (eb_comunicacao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT eb_comunicacao_fk2 FOREIGN KEY (eb_comunicacao_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT eb_comunicacao_fk3 FOREIGN KEY (eb_comunicacao_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_comunicacao_campo;

CREATE TABLE eb_comunicacao_campo (
	eb_comunicacao_campo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_comunicacao_campo_comunicacao INTEGER(100) UNSIGNED NOT NULL,
	eb_comunicacao_campo_texto TEXT,
	eb_comunicacao_campo_titulo VARCHAR(50),
	PRIMARY KEY (eb_comunicacao_campo_id),
	KEY eb_comunicacao_campo_comunicacao (eb_comunicacao_campo_comunicacao),
	CONSTRAINT eb_comunicacao_campo_fk FOREIGN KEY (eb_comunicacao_campo_comunicacao) REFERENCES eb_comunicacao (eb_comunicacao_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_humano;

CREATE TABLE eb_humano (
	eb_humano_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_humano_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_humano_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_humano_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_humano_data_preparado DATE DEFAULT NULL,
	eb_humano_data_aprovado DATE DEFAULT NULL,
	eb_humano_data_revisado DATE DEFAULT NULL,
	eb_humano_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_humano_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_humano_finalidade TEXT,
	eb_humano_organograma VARCHAR(255),
	eb_humano_avaliacao TEXT,
	PRIMARY KEY (eb_humano_id),
	KEY eb_humano_projeto (eb_humano_projeto),
	KEY eb_humano_preparado_por (eb_humano_preparado_por),
	KEY eb_humano_data_aprovado (eb_humano_data_aprovado),
	CONSTRAINT eb_humano_fk FOREIGN KEY (eb_humano_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT eb_humano_fk2 FOREIGN KEY (eb_humano_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT eb_humano_fk3 FOREIGN KEY (eb_humano_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_humano_matriz;

CREATE TABLE eb_humano_matriz (
	eb_humano_matriz_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_humano_matriz_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_humano_matriz_contato INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_humano_matriz_area VARCHAR(255),
	eb_humano_matriz_responsabilidade TEXT,
	eb_humano_matriz_escopo INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_humano_matriz_tempo INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_humano_matriz_custo INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_humano_matriz_qualidade INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_humano_matriz_rh INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_humano_matriz_comunicacao INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_humano_matriz_riscos INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_humano_matriz_contratos INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_humano_matriz_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (eb_humano_matriz_id),
	KEY eb_humano_matriz_projeto (eb_humano_matriz_projeto),
	KEY eb_humano_matriz_contato (eb_humano_matriz_contato),
	CONSTRAINT eb_humano_matriz_fk FOREIGN KEY (eb_humano_matriz_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT eb_humano_matriz_fk2 FOREIGN KEY (eb_humano_matriz_contato) REFERENCES contatos (contato_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS eb_plano_item;

CREATE TABLE eb_plano_item (
  eb_plano_item_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  eb_plano_item_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_plano_item_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_plano_item_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_plano_item_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_plano_item_nome VARCHAR(255) DEFAULT NULL,
  eb_plano_item_quando TEXT,
  eb_plano_item_oque TEXT,
  eb_plano_item_como TEXT,
  eb_plano_item_onde TEXT,
  eb_plano_item_quanto TEXT,
  eb_plano_item_porque TEXT,
  eb_plano_item_quem TEXT,
  eb_plano_item_inicio DATETIME DEFAULT NULL,
  eb_plano_item_fim DATETIME DEFAULT NULL,
  eb_plano_item_duracao DECIMAL(20,5) UNSIGNED DEFAULT NULL,
  eb_plano_item_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  eb_plano_item_principal_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (eb_plano_item_id),
  KEY eb_plano_item_projeto (eb_plano_item_projeto),
  KEY eb_plano_item_responsavel (eb_plano_item_responsavel),
  KEY eb_plano_item_cia (eb_plano_item_cia),
	KEY eb_plano_item_principal_indicador (eb_plano_item_principal_indicador),
  CONSTRAINT eb_plano_item_fk FOREIGN KEY (eb_plano_item_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT eb_plano_item_fk1 FOREIGN KEY (eb_plano_item_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT eb_plano_item_fk2 FOREIGN KEY (eb_plano_item_principal_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT eb_plano_item_fk3 FOREIGN KEY (eb_plano_item_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_plano_item_depts;

CREATE TABLE eb_plano_item_depts (
	eb_plano_item_depts_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  eb_plano_item_id INTEGER(100) UNSIGNED DEFAULT NULL,
  dept_id INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (eb_plano_item_depts_id),
  KEY eb_plano_item_id (eb_plano_item_id),
  KEY dept_id (dept_id),
  CONSTRAINT eb_plano_item_depts_fk1 FOREIGN KEY (dept_id) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT eb_plano_item_depts_fk FOREIGN KEY (eb_plano_item_id) REFERENCES eb_plano_item (eb_plano_item_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS eb_plano_item_custos;

CREATE TABLE eb_plano_item_custos (
  eb_plano_item_custos_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  eb_plano_item_custos_eb_plano_item INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_plano_item_custos_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_plano_item_custos_tipo INTEGER(100) UNSIGNED DEFAULT 1,
  eb_plano_item_custos_nome VARCHAR(255) DEFAULT NULL,
  eb_plano_item_custos_data DATETIME DEFAULT NULL,
  eb_plano_item_custos_quantidade DECIMAL(20,5) UNSIGNED DEFAULT 0,
  eb_plano_item_custos_custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
  eb_plano_item_custos_percentagem TINYINT(4) DEFAULT 0,
  eb_plano_item_custos_descricao TEXT,
  eb_plano_item_custos_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_plano_item_custos_nd VARCHAR(11) DEFAULT NULL,
  eb_plano_item_custos_categoria_economica VARCHAR(1) DEFAULT NULL,
  eb_plano_item_custos_grupo_despesa VARCHAR(1) DEFAULT NULL,
  eb_plano_item_custos_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  eb_plano_item_custos_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_plano_item_custos_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
  eb_plano_item_custos_data_limite DATE DEFAULT NULL,
  uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (eb_plano_item_custos_id),
  KEY idxeb_plano_item_custos_eb_plano_item (eb_plano_item_custos_eb_plano_item),
  KEY idxeb_plano_item_custos_usuario_inicio (eb_plano_item_custos_usuario),
  KEY idxeb_plano_item_custos_ordem (eb_plano_item_custos_ordem),
  KEY idxeb_plano_item_custos_data_inicio (eb_plano_item_custos_data),
  KEY idxeb_plano_item_custos_nome (eb_plano_item_custos_nome),
  CONSTRAINT eb_plano_item_custos_fk FOREIGN KEY (eb_plano_item_custos_eb_plano_item) REFERENCES eb_plano_item (eb_plano_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT eb_plano_item_custos_fk1 FOREIGN KEY (eb_plano_item_custos_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_plano_item_designados;

CREATE TABLE eb_plano_item_designados (
	eb_plano_item_designados_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  eb_plano_item_id INTEGER(100) UNSIGNED DEFAULT NULL,
  usuario_id INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (eb_plano_item_designados_id),
  KEY eb_plano_item_id (eb_plano_item_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT eb_plano_item_designados_fk1 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT eb_plano_item_designados_fk FOREIGN KEY (eb_plano_item_id) REFERENCES eb_plano_item (eb_plano_item_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_plano_item_gastos;

CREATE TABLE eb_plano_item_gastos (
  eb_plano_item_gastos_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  eb_plano_item_gastos_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_plano_item_gastos_eb_plano_item INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_plano_item_gastos_tipo INTEGER(100) UNSIGNED DEFAULT 1,
  eb_plano_item_gastos_nome VARCHAR(255) DEFAULT NULL,
  eb_plano_item_gastos_data DATETIME DEFAULT NULL,
  eb_plano_item_gastos_data_recebido DATETIME DEFAULT NULL,
  eb_plano_item_gastos_quantidade DECIMAL(20,5) UNSIGNED DEFAULT 0,
  eb_plano_item_gastos_custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
  eb_plano_item_gastos_percentagem TINYINT(4) DEFAULT 0,
  eb_plano_item_gastos_descricao TEXT,
  eb_plano_item_gastos_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_plano_item_gastos_nd VARCHAR(11) DEFAULT NULL,
  eb_plano_item_gastos_categoria_economica VARCHAR(1) DEFAULT NULL,
  eb_plano_item_gastos_grupo_despesa VARCHAR(1) DEFAULT NULL,
  eb_plano_item_gastos_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  eb_plano_item_gastos_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_plano_item_gastos_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
  eb_plano_item_custos_data_recebido DATE DEFAULT NULL,
  uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (eb_plano_item_gastos_id),
  KEY idxeb_plano_item_gastos_eb_plano_item (eb_plano_item_gastos_eb_plano_item),
  KEY idxeb_plano_item_gastos_usuario_inicio (eb_plano_item_gastos_usuario),
  KEY idxeb_plano_item_gastos_ordem (eb_plano_item_gastos_ordem),
  KEY idxeb_plano_item_gastos_data_inicio (eb_plano_item_gastos_data),
  KEY idxeb_plano_item_gastos_nome (eb_plano_item_gastos_nome),
  CONSTRAINT eb_plano_item_gastos_fk FOREIGN KEY (eb_plano_item_gastos_eb_plano_item) REFERENCES eb_plano_item (eb_plano_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT eb_plano_item_gastos_fk1 FOREIGN KEY (eb_plano_item_gastos_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_plano_item_h_custos;

CREATE TABLE eb_plano_item_h_custos (
  h_custos_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  h_custos_eb_plano_item INTEGER(100) UNSIGNED DEFAULT NULL,
  h_custos_eb_plano_item_custos_id INTEGER(100) UNSIGNED DEFAULT NULL,
  h_custos_nome1 VARCHAR(255) DEFAULT NULL,
  h_custos_nome2 VARCHAR(255) DEFAULT NULL,
  h_custos_tipo1 INTEGER(100) UNSIGNED DEFAULT 1,
  h_custos_tipo2 INTEGER(100) UNSIGNED DEFAULT 1,
  h_custos_usuario1 INTEGER(100) UNSIGNED DEFAULT NULL,
  h_custos_usuario2 INTEGER(100) UNSIGNED DEFAULT NULL,
  h_custos_data1 DATETIME DEFAULT NULL,
  h_custos_data2 DATETIME DEFAULT NULL,
  h_custos_quantidade1 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_custos_quantidade2 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_custos_custo1 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_custos_custo2 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_custos_percentagem1 TINYINT(4) DEFAULT 0,
  h_custos_percentagem2 TINYINT(4) DEFAULT 0,
  h_custos_descricao1 TEXT,
  h_custos_descricao2 TEXT,
  h_custos_nd1 VARCHAR(20) DEFAULT NULL,
  h_custos_nd2 VARCHAR(20) DEFAULT NULL,
  h_custos_categoria_economica1 VARCHAR(1) DEFAULT NULL,
  h_custos_grupo_despesa1 VARCHAR(1) DEFAULT NULL,
  h_custos_modalidade_aplicacao1 VARCHAR(2) DEFAULT NULL,
  h_custos_categoria_economica2 VARCHAR(1) DEFAULT NULL,
  h_custos_grupo_despesa2 VARCHAR(1) DEFAULT NULL,
  h_custos_modalidade_aplicacao2 VARCHAR(2) DEFAULT NULL,
  h_custos_metodo1 INTEGER(100) UNSIGNED DEFAULT NULL,
	h_custos_metodo2 INTEGER(100) UNSIGNED DEFAULT NULL,
	h_custos_exercicio1 INTEGER(4) UNSIGNED DEFAULT NULL,
	h_custos_exercicio2 INTEGER(4) UNSIGNED DEFAULT NULL,
  h_custos_excluido TINYINT(1) DEFAULT 0,
  uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (h_custos_id),
  KEY h_custos_eb_plano_item_custos_id (h_custos_eb_plano_item_custos_id),
  CONSTRAINT eb_plano_item_h_custos_fk FOREIGN KEY (h_custos_eb_plano_item_custos_id) REFERENCES eb_plano_item_custos (eb_plano_item_custos_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_plano_item_h_gastos;

CREATE TABLE eb_plano_item_h_gastos (
  h_gastos_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  h_gastos_eb_plano_item_gastos_id INTEGER(100) UNSIGNED DEFAULT NULL,
  h_gastos_eb_plano_item INTEGER(100) UNSIGNED DEFAULT NULL,
  h_gastos_nome1 VARCHAR(255) DEFAULT NULL,
  h_gastos_nome2 VARCHAR(255) DEFAULT NULL,
  h_gastos_tipo1 INTEGER(100) UNSIGNED DEFAULT 1,
  h_gastos_tipo2 INTEGER(100) UNSIGNED DEFAULT 1,
  h_gastos_usuario1 INTEGER(100) UNSIGNED DEFAULT NULL,
  h_gastos_usuario2 INTEGER(100) UNSIGNED DEFAULT NULL,
  h_gastos_data1 DATETIME DEFAULT NULL,
  h_gastos_data2 DATETIME DEFAULT NULL,
  h_gastos_quantidade1 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_gastos_quantidade2 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_gastos_custo1 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_gastos_custo2 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_gastos_percentagem1 TINYINT(4) DEFAULT 0,
  h_gastos_percentagem2 TINYINT(4) DEFAULT 0,
  h_gastos_descricao1 TEXT,
  h_gastos_descricao2 TEXT,
  h_gastos_nd1 VARCHAR(20) DEFAULT NULL,
  h_gastos_nd2 VARCHAR(20) DEFAULT NULL,
  h_gastos_categoria_economica1 VARCHAR(1) DEFAULT NULL,
  h_gastos_grupo_despesa1 VARCHAR(1) DEFAULT NULL,
  h_gastos_modalidade_aplicacao1 VARCHAR(2) DEFAULT NULL,
  h_gastos_categoria_economica2 VARCHAR(1) DEFAULT NULL,
  h_gastos_grupo_despesa2 VARCHAR(1) DEFAULT NULL,
  h_gastos_modalidade_aplicacao2 VARCHAR(2) DEFAULT NULL,
  h_gastos_metodo1 INTEGER(100) UNSIGNED DEFAULT NULL,
	h_gastos_metodo2 INTEGER(100) UNSIGNED DEFAULT NULL,
	h_gastos_exercicio1 INTEGER(4) UNSIGNED DEFAULT NULL,
	h_gastos_exercicio2 INTEGER(4) UNSIGNED DEFAULT NULL,
  h_gastos_excluido TINYINT(1) DEFAULT 0,
  uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (h_gastos_id),
  KEY h_gastos_eb_plano_item_gastos_id (h_gastos_eb_plano_item_gastos_id),
  CONSTRAINT eb_plano_item_h_gastos_fk FOREIGN KEY (h_gastos_eb_plano_item_gastos_id) REFERENCES eb_plano_item_gastos (eb_plano_item_gastos_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_plano;

CREATE TABLE eb_plano (
	eb_plano_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_plano_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_plano_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_plano_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_plano_data_preparado DATE DEFAULT NULL,
	eb_plano_data_aprovado DATE DEFAULT NULL,
	eb_plano_data_revisado DATE DEFAULT NULL,
	eb_plano_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_plano_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_plano_sintese TEXT,
	eb_plano_objetivo TEXT,
	eb_plano_info TEXT,
	eb_plano_anexo TEXT,
	PRIMARY KEY (eb_plano_id),
	KEY eb_plano_projeto (eb_plano_projeto),
	KEY eb_plano_preparado_por (eb_plano_preparado_por),
	KEY eb_plano_data_aprovado (eb_plano_data_aprovado),
	CONSTRAINT eb_plano_fk FOREIGN KEY (eb_plano_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT eb_plano_fk2 FOREIGN KEY (eb_plano_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT eb_plano_fk3 FOREIGN KEY (eb_plano_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS eb_escopo;

CREATE TABLE eb_escopo (
	eb_escopo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_escopo_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_escopo_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_escopo_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_escopo_data_preparado DATE DEFAULT NULL,
	eb_escopo_data_aprovado DATE DEFAULT NULL,
	eb_escopo_data_revisado DATE DEFAULT NULL,
	eb_escopo_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_escopo_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (eb_escopo_id),
	KEY eb_escopo_projeto (eb_escopo_projeto),
	KEY eb_escopo_preparado_por (eb_escopo_preparado_por),
	KEY eb_escopo_aprovado_por (eb_escopo_aprovado_por),
	CONSTRAINT eb_escopo_fk FOREIGN KEY (eb_escopo_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT eb_escopo_fk2 FOREIGN KEY (eb_escopo_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT eb_escopo_fk3 FOREIGN KEY (eb_escopo_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_escopo_campo;

CREATE TABLE eb_escopo_campo (
	eb_escopo_campo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_escopo_campo_escopo INTEGER(100) UNSIGNED NOT NULL,
	eb_escopo_campo_texto TEXT,
	eb_escopo_campo_titulo VARCHAR(50),
	PRIMARY KEY (eb_escopo_campo_id),
	KEY eb_escopo_campo_escopo (eb_escopo_campo_escopo),
	CONSTRAINT eb_escopo_campo_fk FOREIGN KEY (eb_escopo_campo_escopo) REFERENCES eb_escopo (eb_escopo_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_iniciacao;

CREATE TABLE eb_iniciacao (
	eb_iniciacao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_iniciacao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_iniciacao_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_iniciacao_data_aprovado DATE DEFAULT NULL,
	PRIMARY KEY (eb_iniciacao_id),
	KEY eb_iniciacao_projeto (eb_iniciacao_projeto),
	KEY eb_iniciacao_aprovado_por (eb_iniciacao_aprovado_por),
	CONSTRAINT eb_iniciacao_fk FOREIGN KEY (eb_iniciacao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT eb_iniciacao_fk1 FOREIGN KEY (eb_iniciacao_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_iniciacao_campo;

CREATE TABLE eb_iniciacao_campo (
	eb_iniciacao_campo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_iniciacao_campo_iniciacao INTEGER(100) UNSIGNED NOT NULL,
	eb_iniciacao_campo_texto TEXT,
	eb_iniciacao_campo_titulo VARCHAR(50),
	PRIMARY KEY (eb_iniciacao_campo_id),
	KEY eb_iniciacao_campo_iniciacao (eb_iniciacao_campo_iniciacao),
	CONSTRAINT eb_iniciacao_campo_fk FOREIGN KEY (eb_iniciacao_campo_iniciacao) REFERENCES eb_iniciacao (eb_iniciacao_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS eb_iniciacao_envolvido;

CREATE TABLE eb_iniciacao_envolvido (
  eb_iniciacao_envolvido_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  projeto_id INTEGER(100) UNSIGNED DEFAULT NULL,
  contato_id INTEGER(100) UNSIGNED DEFAULT NULL,
  ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (eb_iniciacao_envolvido_id),
  KEY projeto_id (projeto_id),
  KEY contato_id (contato_id),
  CONSTRAINT eb_iniciacao_envolvido_fk1 FOREIGN KEY (contato_id) REFERENCES contatos (contato_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT eb_iniciacao_envolvido_fk FOREIGN KEY (projeto_id) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_implantacao;

CREATE TABLE eb_implantacao (
	eb_implantacao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_implantacao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_implantacao_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_implantacao_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_implantacao_data_preparado DATE DEFAULT NULL,
	eb_implantacao_data_aprovado DATE DEFAULT NULL,
	eb_implantacao_data_revisado DATE DEFAULT NULL,
	eb_implantacao_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_implantacao_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (eb_implantacao_id),
	KEY eb_implantacao_projeto (eb_implantacao_projeto),
	KEY eb_implantacao_preparado_por (eb_implantacao_preparado_por),
	KEY eb_implantacao_aprovado_por (eb_implantacao_aprovado_por),
	CONSTRAINT eb_implantacao_fk FOREIGN KEY (eb_implantacao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT eb_implantacao_fk1 FOREIGN KEY (eb_implantacao_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT eb_implantacao_fk2 FOREIGN KEY (eb_implantacao_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_implantacao_campo;

CREATE TABLE eb_implantacao_campo (
	eb_implantacao_campo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_implantacao_campo_implantacao INTEGER(100) UNSIGNED NOT NULL,
	eb_implantacao_campo_texto TEXT,
	eb_implantacao_campo_titulo VARCHAR(50),
	PRIMARY KEY (eb_implantacao_campo_id),
	KEY eb_implantacao_campo_implantacao (eb_implantacao_campo_implantacao),
	CONSTRAINT eb_implantacao_campo_fk FOREIGN KEY (eb_implantacao_campo_implantacao) REFERENCES eb_implantacao (eb_implantacao_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_viabilidade;

CREATE TABLE eb_viabilidade (
	eb_viabilidade_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_viabilidade_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_viabilidade_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_viabilidade_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_viabilidade_data_preparado DATE DEFAULT NULL,
	eb_viabilidade_data_aprovado DATE DEFAULT NULL,
	eb_viabilidade_data_revisado DATE DEFAULT NULL,
	eb_viabilidade_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_viabilidade_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_viabilidade_planejamento_inicio DATE DEFAULT NULL,
	eb_viabilidade_planejamento_fim DATE DEFAULT NULL,
	eb_viabilidade_execucao_inicio DATE DEFAULT NULL,
	eb_viabilidade_execucao_fim DATE DEFAULT NULL,
	eb_viabilidade_recurso_inicio DATE DEFAULT NULL,
	eb_viabilidade_recurso_fim DATE DEFAULT NULL,
	eb_viabilidade_data_compensador DATE DEFAULT NULL,
	eb_viabilidade_implementacao_inicio DATE DEFAULT NULL,
	eb_viabilidade_implementacao_fim DATE DEFAULT NULL,
	PRIMARY KEY (eb_viabilidade_id),
	KEY eb_viabilidade_projeto (eb_viabilidade_projeto),
	KEY eb_viabilidade_preparado_por (eb_viabilidade_preparado_por),
	KEY eb_viabilidade_aprovado_por (eb_viabilidade_aprovado_por),
	CONSTRAINT eb_viabilidade_fk FOREIGN KEY (eb_viabilidade_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT eb_viabilidade_fk1 FOREIGN KEY (eb_viabilidade_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT eb_viabilidade_fk2 FOREIGN KEY (eb_viabilidade_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_viabilidade_campo;

CREATE TABLE eb_viabilidade_campo (
	eb_viabilidade_campo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_viabilidade_campo_viabilidade INTEGER(100) UNSIGNED NOT NULL,
	eb_viabilidade_campo_texto TEXT,
	eb_viabilidade_campo_titulo VARCHAR(50),
	PRIMARY KEY (eb_viabilidade_campo_id),
	KEY eb_viabilidade_campo_viabilidade (eb_viabilidade_campo_viabilidade),
	CONSTRAINT eb_viabilidade_campo_fk FOREIGN KEY (eb_viabilidade_campo_viabilidade) REFERENCES eb_viabilidade (eb_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS eb_viabilidade_envolvido;

CREATE TABLE eb_viabilidade_envolvido (
  eb_viabilidade_envolvido_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  projeto_id INTEGER(100) UNSIGNED DEFAULT NULL,
  contato_id INTEGER(100) UNSIGNED DEFAULT NULL,
  ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (eb_viabilidade_envolvido_id),
  KEY projeto_id (projeto_id),
  KEY contato_id (contato_id),
  CONSTRAINT eb_viabilidade_envolvido_fk1 FOREIGN KEY (contato_id) REFERENCES contatos (contato_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT eb_viabilidade_envolvido_fk FOREIGN KEY (projeto_id) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_arquivo;

CREATE TABLE baseline_eb_arquivo (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
  eb_arquivo_id INTEGER(100) UNSIGNED NOT NULL,
  eb_arquivo_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_arquivo_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_arquivo_artefato VARCHAR(30) DEFAULT NULL,
  eb_arquivo_ordem INTEGER(11) DEFAULT NULL,
  eb_arquivo_endereco VARCHAR(150) DEFAULT NULL,
  eb_arquivo_data DATETIME DEFAULT NULL,
  eb_arquivo_nome VARCHAR(150) DEFAULT NULL,
  eb_arquivo_tipo VARCHAR(50) DEFAULT NULL,
  eb_arquivo_extensao VARCHAR(50) DEFAULT NULL,
  eb_arquivo_nome_real VARCHAR(255) DEFAULT NULL,
	eb_arquivo_local VARCHAR(255) DEFAULT NULL,
	eb_arquivo_tamanho INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (baseline_id, eb_arquivo_id),
	KEY baseline_id (baseline_id),
  KEY eb_arquivo_projeto (eb_arquivo_projeto),
  KEY eb_arquivo_usuario (eb_arquivo_usuario),
	CONSTRAINT baseline_eb_arquivo_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_arquivo_projeto FOREIGN KEY (eb_arquivo_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_arquivo_usuario FOREIGN KEY (eb_arquivo_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_encerramento;

CREATE TABLE baseline_eb_encerramento (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_encerramento_id INTEGER(100) UNSIGNED NOT NULL,
	eb_encerramento_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_encerramento_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_encerramento_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_encerramento_data_preparado DATE DEFAULT NULL,
	eb_encerramento_data_aprovado DATE DEFAULT NULL,
	eb_encerramento_data_revisado DATE DEFAULT NULL,
	eb_encerramento_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_encerramento_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_encerramento_baseline INTEGER(100) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (baseline_id, eb_encerramento_id),
	KEY baseline_id (baseline_id),
	KEY eb_encerramento_projeto (eb_encerramento_projeto),
	KEY eb_encerramento_preparado_por (eb_encerramento_preparado_por),
	KEY eb_encerramento_aprovado_por (eb_encerramento_aprovado_por),
	KEY eb_encerramento_baseline (eb_encerramento_baseline),
	CONSTRAINT baseline_eb_encerramento_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_encerramento_projeto FOREIGN KEY (eb_encerramento_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_encerramento_preparado FOREIGN KEY (eb_encerramento_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_encerramento_aprovado FOREIGN KEY (eb_encerramento_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_encerramento_baseline2 FOREIGN KEY (eb_encerramento_baseline) REFERENCES baseline (baseline_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_situacao;

CREATE TABLE baseline_eb_situacao (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_situacao_id INTEGER(100) UNSIGNED NOT NULL,
	eb_situacao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_situacao_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_situacao_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_situacao_data_preparado DATE DEFAULT NULL,
	eb_situacao_data_aprovado DATE DEFAULT NULL,
	eb_situacao_data_revisado DATE DEFAULT NULL,
	eb_situacao_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_situacao_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_situacao_baseline INTEGER(100) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (baseline_id, eb_situacao_id),
	KEY baseline_id (baseline_id),
	KEY eb_situacao_projeto (eb_situacao_projeto),
	KEY eb_situacao_preparado_por (eb_situacao_preparado_por),
	KEY eb_situacao_aprovado_por (eb_situacao_aprovado_por),
	KEY eb_situacao_baseline (eb_situacao_baseline),
	CONSTRAINT baseline_eb_situacao_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_situacao_projeto FOREIGN KEY (eb_situacao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_situacao_preparado FOREIGN KEY (eb_situacao_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_situacao_aprovado FOREIGN KEY (eb_situacao_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_situacao_baseline2 FOREIGN KEY (eb_situacao_baseline) REFERENCES baseline (baseline_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_aceite;

CREATE TABLE baseline_eb_aceite (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_aceite_id INTEGER(100) UNSIGNED NOT NULL,
	eb_aceite_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_aceite_nr INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_aceite_data DATE DEFAULT NULL,
	eb_aceite_produto TEXT,
	eb_aceite_obs TEXT,
	eb_aceite_ok TINYINT(1) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (baseline_id, eb_aceite_id),
	KEY baseline_id (baseline_id),
	KEY eb_aceite_projeto (eb_aceite_projeto),
	CONSTRAINT baseline_eb_aceite_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_aceite_projeto FOREIGN KEY (eb_aceite_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_mudanca_controle;

CREATE TABLE baseline_eb_mudanca_controle (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_mudanca_controle_id INTEGER(100) UNSIGNED NOT NULL,
	eb_mudanca_controle_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_data_preparado DATE DEFAULT NULL,
	eb_mudanca_controle_data_aprovado DATE DEFAULT NULL,
	eb_mudanca_controle_data_revisado DATE DEFAULT NULL,
	eb_mudanca_controle_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_nr_rcm INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_data_abertura DATE DEFAULT NULL,
	eb_mudanca_controle_subprojeto VARCHAR (255) DEFAULT NULL,
	eb_mudanca_controle_solicitante INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_baseline1 INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_baseline2 INTEGER(100) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (baseline_id, eb_mudanca_controle_id),
	KEY baseline_id (baseline_id),
	KEY eb_mudanca_controle_projeto (eb_mudanca_controle_projeto),
	KEY eb_mudanca_controle_preparado_por (eb_mudanca_controle_preparado_por),
	KEY eb_mudanca_controle_aprovado_por (eb_mudanca_controle_aprovado_por),
	KEY eb_mudanca_controle_solicitante (eb_mudanca_controle_solicitante),
	KEY eb_mudanca_controle_baseline1 (eb_mudanca_controle_baseline1),
	KEY eb_mudanca_controle_baseline2 (eb_mudanca_controle_baseline2),
	CONSTRAINT baseline_eb_mudanca_controle_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_mudanca_controle_projeto FOREIGN KEY (eb_mudanca_controle_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_mudanca_controle_preparado FOREIGN KEY (eb_mudanca_controle_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_mudanca_controle_aprovado FOREIGN KEY (eb_mudanca_controle_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_mudanca_controle_baseline1 FOREIGN KEY (eb_mudanca_controle_baseline1) REFERENCES baseline (baseline_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_mudanca_controle_baseline2 FOREIGN KEY (eb_mudanca_controle_baseline2) REFERENCES baseline (baseline_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_mudanca_controle_solicitante FOREIGN KEY (eb_mudanca_controle_solicitante) REFERENCES contatos (contato_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_mudanca;

CREATE TABLE baseline_eb_mudanca (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_mudanca_id INTEGER(100) UNSIGNED NOT NULL,
	eb_mudanca_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_data_preparado DATE DEFAULT NULL,
	eb_mudanca_data_aprovado DATE DEFAULT NULL,
	eb_mudanca_data_revisado DATE DEFAULT NULL,
	eb_mudanca_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_mudanca_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (baseline_id, eb_mudanca_id),
	KEY baseline_id (baseline_id),
	KEY eb_mudanca_projeto (eb_mudanca_projeto),
	KEY eb_mudanca_preparado_por (eb_mudanca_preparado_por),
	KEY eb_mudanca_aprovado_por (eb_mudanca_aprovado_por),
	CONSTRAINT baseline_eb_mudanca_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_mudanca_projeto FOREIGN KEY (eb_mudanca_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_mudanca_preparado FOREIGN KEY (eb_mudanca_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_mudanca_aprovado FOREIGN KEY (eb_mudanca_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_mudanca_item;

CREATE TABLE baseline_eb_mudanca_item (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_mudanca_item_id INTEGER(100) UNSIGNED NOT NULL,
	eb_mudanca_item_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_item_contato INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_item_papel VARCHAR(255),
	eb_mudanca_item_responsabilidade TEXT,
	eb_mudanca_item_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (baseline_id, eb_mudanca_item_id),
	KEY baseline_id (baseline_id),
	KEY eb_mudanca_item_projeto (eb_mudanca_item_projeto),
	KEY eb_mudanca_item_contato (eb_mudanca_item_contato),
	CONSTRAINT baseline_eb_mudanca_item_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_mudanca_item_projeto FOREIGN KEY (eb_mudanca_item_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_mudanca_item_contato FOREIGN KEY (eb_mudanca_item_contato) REFERENCES contatos (contato_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_qualidade;

CREATE TABLE baseline_eb_qualidade (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_qualidade_id INTEGER(100) UNSIGNED NOT NULL,
	eb_qualidade_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_qualidade_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_qualidade_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_qualidade_data_preparado DATE DEFAULT NULL,
	eb_qualidade_data_aprovado DATE DEFAULT NULL,
	eb_qualidade_data_revisado DATE DEFAULT NULL,
	eb_qualidade_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_qualidade_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_qualidade_requisito TEXT,
	PRIMARY KEY (baseline_id, eb_qualidade_id),
	KEY baseline_id (baseline_id),
	KEY eb_qualidade_projeto (eb_qualidade_projeto),
	KEY eb_qualidade_preparado_por (eb_qualidade_preparado_por),
	KEY eb_qualidade_data_aprovado (eb_qualidade_data_aprovado),
	CONSTRAINT baseline_eb_qualidade_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_qualidade_projeto FOREIGN KEY (eb_qualidade_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_qualidade_preparado FOREIGN KEY (eb_qualidade_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_qualidade_aprovado FOREIGN KEY (eb_qualidade_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_qualidade_item;

CREATE TABLE baseline_eb_qualidade_item (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_qualidade_item_id INTEGER(100) UNSIGNED NOT NULL,
	eb_qualidade_item_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_qualidade_item_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_qualidade_item_contato INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_qualidade_item_requisito TEXT,
	eb_qualidade_item_meta TEXT,
	eb_qualidade_item_indicador TEXT,
	eb_qualidade_item_desempenho TEXT,
	eb_qualidade_item_acao TEXT,
	eb_qualidade_item_recurso TEXT,
	eb_qualidade_item_treinamento TEXT,
	eb_qualidade_item_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (baseline_id, eb_qualidade_item_id),
	KEY baseline_id (baseline_id),
	KEY eb_qualidade_item_projeto (eb_qualidade_item_projeto),
	KEY eb_qualidade_item_tarefa (eb_qualidade_item_tarefa),
	KEY eb_qualidade_item_contato (eb_qualidade_item_contato),
	CONSTRAINT baseline_eb_qualidade_item_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_qualidade_item_projeto FOREIGN KEY (eb_qualidade_item_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_qualidade_item_tarefa FOREIGN KEY (eb_qualidade_item_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_qualidade_item_contato FOREIGN KEY (eb_qualidade_item_contato) REFERENCES contatos (contato_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_risco_item;

CREATE TABLE baseline_eb_risco_item (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
  eb_risco_item_id INTEGER(100) UNSIGNED NOT NULL,
  eb_risco_item_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_risco_item_contato INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_risco_item_usuario_inseriu INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_risco_item_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_risco_item_descricao VARCHAR(255) DEFAULT NULL,
  eb_risco_item_categoria VARCHAR(1) DEFAULT NULL,
  eb_risco_item_probabilidade1 VARCHAR(1) DEFAULT NULL,
  eb_risco_item_impacto1 VARCHAR(1) DEFAULT NULL,
  eb_risco_item_criticidade1 VARCHAR(1) DEFAULT NULL,
  eb_risco_item_estrategia VARCHAR(20) DEFAULT NULL,
  eb_risco_item_acao_proposta TEXT,
  eb_risco_item_probabilidade2 VARCHAR(1) DEFAULT NULL,
  eb_risco_item_impacto2 VARCHAR(1) DEFAULT NULL,
  eb_risco_item_criticidade2 VARCHAR(1) DEFAULT NULL,
  eb_risco_item_data DATE DEFAULT NULL,
  eb_risco_item_data_inseriu DATETIME DEFAULT NULL,
  PRIMARY KEY (baseline_id, eb_risco_item_id),
	KEY baseline_id (baseline_id),
  KEY eb_risco_item_projeto (eb_risco_item_projeto),
  KEY eb_risco_item_usuario_inseriu (eb_risco_item_usuario_inseriu),
  KEY eb_risco_item_contato (eb_risco_item_contato),
	CONSTRAINT baseline_eb_risco_item_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_risco_item_contato FOREIGN KEY (eb_risco_item_contato) REFERENCES contatos (contato_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_risco_item_projeto FOREIGN KEY (eb_risco_item_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_risco_item_usuario FOREIGN KEY (eb_risco_item_usuario_inseriu) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_risco;

CREATE TABLE baseline_eb_risco (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_risco_id INTEGER(100) UNSIGNED NOT NULL,
	eb_risco_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_risco_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_risco_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_risco_data_preparado DATE DEFAULT NULL,
	eb_risco_data_aprovado DATE DEFAULT NULL,
	eb_risco_data_revisado DATE DEFAULT NULL,
	eb_risco_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_risco_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (baseline_id, eb_risco_id),
	KEY baseline_id (baseline_id),
	KEY eb_risco_projeto (eb_risco_projeto),
	KEY eb_risco_preparado_por (eb_risco_preparado_por),
	KEY eb_risco_aprovado_por (eb_risco_aprovado_por),
	CONSTRAINT baseline_eb_risco_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_risco_projeto FOREIGN KEY (eb_risco_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_risco_preparado FOREIGN KEY (eb_risco_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_risco_aprovado FOREIGN KEY (eb_risco_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_interessado;

CREATE TABLE baseline_eb_interessado (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_interessado_id INTEGER(100) UNSIGNED NOT NULL,
	eb_interessado_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_interessado_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_interessado_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_interessado_data_preparado DATE DEFAULT NULL,
	eb_interessado_data_aprovado DATE DEFAULT NULL,
	eb_interessado_data_revisado DATE DEFAULT NULL,
	eb_interessado_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_interessado_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (baseline_id, eb_interessado_id),
	KEY baseline_id (baseline_id),
	KEY eb_interessado_projeto (eb_interessado_projeto),
	KEY eb_interessado_preparado_por (eb_interessado_preparado_por),
	KEY eb_interessado_aprovado_por (eb_interessado_aprovado_por),
	CONSTRAINT baseline_eb_interessado_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_interessado_projeto FOREIGN KEY (eb_interessado_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_interessado_preparado FOREIGN KEY (eb_interessado_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_interessado_aprovado FOREIGN KEY (eb_interessado_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_comunicacao;

CREATE TABLE baseline_eb_comunicacao (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_comunicacao_id INTEGER(100) UNSIGNED NOT NULL,
	eb_comunicacao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_comunicacao_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_comunicacao_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_comunicacao_data_preparado DATE DEFAULT NULL,
	eb_comunicacao_data_aprovado DATE DEFAULT NULL,
	eb_comunicacao_data_revisado DATE DEFAULT NULL,
	eb_comunicacao_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_comunicacao_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (baseline_id, eb_comunicacao_id),
	KEY baseline_id (baseline_id),
	KEY eb_comunicacao_projeto (eb_comunicacao_projeto),
	KEY eb_comunicacao_preparado_por (eb_comunicacao_preparado_por),
	KEY eb_comunicacao_aprovado_por (eb_comunicacao_aprovado_por),
	CONSTRAINT baseline_eb_comunicacao_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_comunicacao_projeto FOREIGN KEY (eb_comunicacao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_comunicacao_preparado FOREIGN KEY (eb_comunicacao_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_comunicacao_aprovado FOREIGN KEY (eb_comunicacao_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_humano;

CREATE TABLE baseline_eb_humano (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_humano_id INTEGER(100) UNSIGNED NOT NULL,
	eb_humano_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_humano_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_humano_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_humano_data_preparado DATE DEFAULT NULL,
	eb_humano_data_aprovado DATE DEFAULT NULL,
	eb_humano_data_revisado DATE DEFAULT NULL,
	eb_humano_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_humano_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_humano_finalidade TEXT,
	eb_humano_organograma VARCHAR(255),
	eb_humano_avaliacao TEXT,
	PRIMARY KEY (baseline_id, eb_humano_id),
	KEY baseline_id (baseline_id),
	KEY eb_humano_projeto (eb_humano_projeto),
	KEY eb_humano_preparado_por (eb_humano_preparado_por),
	KEY eb_humano_data_aprovado (eb_humano_data_aprovado),
	CONSTRAINT baseline_eb_humano_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_humano_projeto FOREIGN KEY (eb_humano_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_humano_preparado FOREIGN KEY (eb_humano_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_humano_aprovado FOREIGN KEY (eb_humano_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_humano_matriz;

CREATE TABLE baseline_eb_humano_matriz (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_humano_matriz_id INTEGER(100) UNSIGNED NOT NULL,
	eb_humano_matriz_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_humano_matriz_contato INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_humano_matriz_area VARCHAR(255),
	eb_humano_matriz_responsabilidade TEXT,
	eb_humano_matriz_escopo INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_humano_matriz_tempo INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_humano_matriz_custo INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_humano_matriz_qualidade INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_humano_matriz_rh INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_humano_matriz_comunicacao INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_humano_matriz_riscos INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_humano_matriz_contratos INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_humano_matriz_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (baseline_id, eb_humano_matriz_id),
	KEY baseline_id (baseline_id),
	KEY eb_humano_matriz_projeto (eb_humano_matriz_projeto),
	KEY eb_humano_matriz_contato (eb_humano_matriz_contato),
	CONSTRAINT baseline_eb_humano_matriz_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_humano_matriz_projeto FOREIGN KEY (eb_humano_matriz_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_humano_matriz_contato FOREIGN KEY (eb_humano_matriz_contato) REFERENCES contatos (contato_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_plano_item;

CREATE TABLE baseline_eb_plano_item (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
  eb_plano_item_id INTEGER(100) UNSIGNED NOT NULL,
  eb_plano_item_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_plano_item_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_plano_item_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_plano_item_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_plano_item_nome VARCHAR(255) DEFAULT NULL,
  eb_plano_item_quando TEXT,
  eb_plano_item_oque TEXT,
  eb_plano_item_como TEXT,
  eb_plano_item_onde TEXT,
  eb_plano_item_quanto TEXT,
  eb_plano_item_porque TEXT,
  eb_plano_item_quem TEXT,
  eb_plano_item_inicio DATETIME DEFAULT NULL,
  eb_plano_item_fim DATETIME DEFAULT NULL,
  eb_plano_item_duracao DECIMAL(20,5) UNSIGNED DEFAULT NULL,
  eb_plano_item_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  eb_plano_item_principal_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (baseline_id, eb_plano_item_id),
	KEY baseline_id (baseline_id),
  KEY eb_plano_item_projeto (eb_plano_item_projeto),
  KEY eb_plano_item_responsavel (eb_plano_item_responsavel),
  KEY eb_plano_item_cia (eb_plano_item_cia),
	KEY eb_plano_item_principal_indicador (eb_plano_item_principal_indicador),
	CONSTRAINT baseline_eb_plano_item_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_plano_item_projeto FOREIGN KEY (eb_plano_item_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_plano_item_responsavel FOREIGN KEY (eb_plano_item_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_plano_item_indicador FOREIGN KEY (eb_plano_item_principal_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_plano_item_cia FOREIGN KEY (eb_plano_item_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_eb_plano;

CREATE TABLE baseline_eb_plano (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_plano_id INTEGER(100) UNSIGNED NOT NULL,
	eb_plano_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_plano_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_plano_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_plano_data_preparado DATE DEFAULT NULL,
	eb_plano_data_aprovado DATE DEFAULT NULL,
	eb_plano_data_revisado DATE DEFAULT NULL,
	eb_plano_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_plano_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_plano_sintese TEXT,
	eb_plano_objetivo TEXT,
	eb_plano_info TEXT,
	eb_plano_anexo TEXT,
	PRIMARY KEY (baseline_id, eb_plano_id),
	KEY baseline_id (baseline_id),
	KEY eb_plano_projeto (eb_plano_projeto),
	KEY eb_plano_preparado_por (eb_plano_preparado_por),
	KEY eb_plano_data_aprovado (eb_plano_data_aprovado),
	CONSTRAINT baseline_eb_plano_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_plano_projeto FOREIGN KEY (eb_plano_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_plano_preparado FOREIGN KEY (eb_plano_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_plano_aprovado FOREIGN KEY (eb_plano_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_escopo;

CREATE TABLE baseline_eb_escopo (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_escopo_id INTEGER(100) UNSIGNED NOT NULL,
	eb_escopo_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_escopo_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_escopo_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_escopo_data_preparado DATE DEFAULT NULL,
	eb_escopo_data_aprovado DATE DEFAULT NULL,
	eb_escopo_data_revisado DATE DEFAULT NULL,
	eb_escopo_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_escopo_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (baseline_id, eb_escopo_id),
	KEY baseline_id (baseline_id),
	KEY eb_escopo_projeto (eb_escopo_projeto),
	KEY eb_escopo_preparado_por (eb_escopo_preparado_por),
	KEY eb_escopo_aprovado_por (eb_escopo_aprovado_por),
	CONSTRAINT baseline_eb_escopo_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_escopo_projeto FOREIGN KEY (eb_escopo_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_escopo_preparado FOREIGN KEY (eb_escopo_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_escopo_aprovado FOREIGN KEY (eb_escopo_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_iniciacao;

CREATE TABLE baseline_eb_iniciacao (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_iniciacao_id INTEGER(100) UNSIGNED NOT NULL,
	eb_iniciacao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_iniciacao_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_iniciacao_data_aprovado DATE DEFAULT NULL,
	PRIMARY KEY (baseline_id, eb_iniciacao_id),
	KEY baseline_id (baseline_id),
	KEY eb_iniciacao_projeto (eb_iniciacao_projeto),
	KEY eb_iniciacao_aprovado_por (eb_iniciacao_aprovado_por),
	CONSTRAINT baseline_eb_iniciacao_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_iniciacao_projeto FOREIGN KEY (eb_iniciacao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_iniciacao_aprovado FOREIGN KEY (eb_iniciacao_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS baseline_eb_iniciacao_envolvido;

CREATE TABLE baseline_eb_iniciacao_envolvido (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
  eb_iniciacao_envolvido_id INTEGER(100) UNSIGNED NOT NULL,
  projeto_id INTEGER(100) UNSIGNED DEFAULT NULL,
  contato_id INTEGER(100) UNSIGNED DEFAULT NULL,
  ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (baseline_id, eb_iniciacao_envolvido_id),
	KEY baseline_id (baseline_id),
  KEY projeto_id (projeto_id),
  KEY contato_id (contato_id),
	CONSTRAINT baseline_eb_iniciacao_envolvido_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_iniciacao_envolvido_contato FOREIGN KEY (contato_id) REFERENCES contatos (contato_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_iniciacao_envolvido_projeto FOREIGN KEY (projeto_id) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_implantacao;

CREATE TABLE baseline_eb_implantacao (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_implantacao_id INTEGER(100) UNSIGNED NOT NULL,
	eb_implantacao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_implantacao_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_implantacao_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_implantacao_data_preparado DATE DEFAULT NULL,
	eb_implantacao_data_aprovado DATE DEFAULT NULL,
	eb_implantacao_data_revisado DATE DEFAULT NULL,
	eb_implantacao_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_implantacao_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (baseline_id, eb_implantacao_id),
	KEY baseline_id (baseline_id),
	KEY eb_implantacao_projeto (eb_implantacao_projeto),
	KEY eb_implantacao_preparado_por (eb_implantacao_preparado_por),
	KEY eb_implantacao_aprovado_por (eb_implantacao_aprovado_por),
	CONSTRAINT baseline_eb_implantacao_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_implantacao_projeto FOREIGN KEY (eb_implantacao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_implantacao_preparado FOREIGN KEY (eb_implantacao_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_implantacao_aprovado FOREIGN KEY (eb_implantacao_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_viabilidade;

CREATE TABLE baseline_eb_viabilidade (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_viabilidade_id INTEGER(100) UNSIGNED NOT NULL,
	eb_viabilidade_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_viabilidade_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_viabilidade_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_viabilidade_data_preparado DATE DEFAULT NULL,
	eb_viabilidade_data_aprovado DATE DEFAULT NULL,
	eb_viabilidade_data_revisado DATE DEFAULT NULL,
	eb_viabilidade_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_viabilidade_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_viabilidade_planejamento_inicio DATE DEFAULT NULL,
	eb_viabilidade_planejamento_fim DATE DEFAULT NULL,
	eb_viabilidade_execucao_inicio DATE DEFAULT NULL,
	eb_viabilidade_execucao_fim DATE DEFAULT NULL,
	eb_viabilidade_recurso_inicio DATE DEFAULT NULL,
	eb_viabilidade_recurso_fim DATE DEFAULT NULL,
	eb_viabilidade_data_compensador DATE DEFAULT NULL,
	eb_viabilidade_implementacao_inicio DATE DEFAULT NULL,
	eb_viabilidade_implementacao_fim DATE DEFAULT NULL,
	PRIMARY KEY (baseline_id, eb_viabilidade_id),
	KEY baseline_id (baseline_id),
	KEY eb_viabilidade_projeto (eb_viabilidade_projeto),
	KEY eb_viabilidade_preparado_por (eb_viabilidade_preparado_por),
	KEY eb_viabilidade_aprovado_por (eb_viabilidade_aprovado_por),
	CONSTRAINT baseline_eb_viabilidade_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_viabilidade_projeto FOREIGN KEY (eb_viabilidade_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_viabilidade_preparado FOREIGN KEY (eb_viabilidade_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_viabilidade_aprovado FOREIGN KEY (eb_viabilidade_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_viabilidade_envolvido;

CREATE TABLE baseline_eb_viabilidade_envolvido (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
  eb_viabilidade_envolvido_id INTEGER(100) UNSIGNED NOT NULL,
  projeto_id INTEGER(100) UNSIGNED DEFAULT NULL,
  contato_id INTEGER(100) UNSIGNED DEFAULT NULL,
  ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (baseline_id, eb_viabilidade_envolvido_id),
	KEY baseline_id (baseline_id),
  KEY projeto_id (projeto_id),
  KEY contato_id (contato_id),
	CONSTRAINT baseline_eb_viabilidade_envolvido_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_viabilidade_envolvido_contato FOREIGN KEY (contato_id) REFERENCES contatos (contato_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_viabilidade_envolvido_projeto FOREIGN KEY (projeto_id) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_encerramento_campo;

CREATE TABLE baseline_eb_encerramento_campo (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_encerramento_campo_id INTEGER(100) UNSIGNED NOT NULL,
	eb_encerramento_campo_encerramento INTEGER(100) UNSIGNED NOT NULL,
	eb_encerramento_campo_texto TEXT,
	eb_encerramento_campo_titulo VARCHAR(50),
	PRIMARY KEY (baseline_id, eb_encerramento_campo_id),
	KEY baseline_id (baseline_id),
	KEY eb_encerramento_campo_id (eb_encerramento_campo_id),
	CONSTRAINT baseline_eb_encerramento_campo_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_encerramento_campo_encerramento FOREIGN KEY (eb_encerramento_campo_encerramento) REFERENCES eb_encerramento (eb_encerramento_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_situacao_campo;

CREATE TABLE baseline_eb_situacao_campo (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_situacao_campo_id INTEGER(100) UNSIGNED NOT NULL,
	eb_situacao_campo_situacao INTEGER(100) UNSIGNED NOT NULL,
	eb_situacao_campo_texto TEXT,
	eb_situacao_campo_titulo VARCHAR(50),
	PRIMARY KEY (baseline_id, eb_situacao_campo_id),
	KEY baseline_id (baseline_id),
	KEY eb_situacao_campo_id (eb_situacao_campo_id),
	KEY eb_situacao_campo_situacao (eb_situacao_campo_situacao),
	CONSTRAINT baseline_eb_situacao_campo_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_situacao_campo_situacao FOREIGN KEY (eb_situacao_campo_situacao) REFERENCES eb_situacao (eb_situacao_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_mudanca_controle_campo;

CREATE TABLE baseline_eb_mudanca_controle_campo (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_mudanca_controle_campo_id INTEGER(100) UNSIGNED NOT NULL,
	eb_mudanca_controle_campo_mudanca INTEGER(100) UNSIGNED NOT NULL,
	eb_mudanca_controle_campo_texto TEXT,
	eb_mudanca_controle_campo_titulo VARCHAR(50),
  PRIMARY KEY (baseline_id, eb_mudanca_controle_campo_id),
	KEY baseline_id (baseline_id),
	KEY eb_mudanca_controle_campo_id (eb_mudanca_controle_campo_id),
	CONSTRAINT baseline_eb_mudanca_controle_campo_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_mudanca_controle_campo_mudanca FOREIGN KEY (eb_mudanca_controle_campo_mudanca) REFERENCES eb_mudanca_controle (eb_mudanca_controle_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_mudanca_controle_item;

CREATE TABLE baseline_eb_mudanca_controle_item (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_mudanca_controle_item_id INTEGER(100) UNSIGNED NOT NULL,
	eb_mudanca_controle_item_mudanca_controle INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_item_contato INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_item_papel VARCHAR(255),
	eb_mudanca_controle_item_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_item_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (baseline_id, eb_mudanca_controle_item_id),
	KEY baseline_id (baseline_id),
	KEY eb_mudanca_controle_item_mudanca_controle (eb_mudanca_controle_item_mudanca_controle),
	KEY eb_mudanca_controle_item_contato (eb_mudanca_controle_item_contato),
	CONSTRAINT baseline_eb_mudanca_controle_item_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_mudanca_controle_item_controle FOREIGN KEY (eb_mudanca_controle_item_mudanca_controle) REFERENCES eb_mudanca_controle (eb_mudanca_controle_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_mudanca_controle_item_contato FOREIGN KEY (eb_mudanca_controle_item_contato) REFERENCES contatos (contato_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_mudanca_controle_escopo;

CREATE TABLE baseline_eb_mudanca_controle_escopo (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_mudanca_controle_escopo_id INTEGER(100) UNSIGNED NOT NULL,
	eb_mudanca_controle_escopo_mudanca_controle INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_escopo_tipo INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_escopo_entrega TEXT,
	eb_mudanca_controle_escopo_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_escopo_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (baseline_id, eb_mudanca_controle_escopo_id),
	KEY baseline_id (baseline_id),
	KEY eb_mudanca_controle_escopo_mudanca_controle (eb_mudanca_controle_escopo_mudanca_controle),
	CONSTRAINT baseline_eb_mudanca_controle_escopo_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_mudanca_controle_escopo_controle FOREIGN KEY (eb_mudanca_controle_escopo_mudanca_controle) REFERENCES eb_mudanca_controle (eb_mudanca_controle_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_mudanca_controle_custo;

CREATE TABLE baseline_eb_mudanca_controle_custo (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_mudanca_controle_custo_id INTEGER(100) UNSIGNED NOT NULL,
	eb_mudanca_controle_custo_mudanca_controle INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_custo_produto TEXT,
	eb_mudanca_controle_custo_antes DECIMAL(20,5) UNSIGNED DEFAULT 0,
	eb_mudanca_controle_custo_depois DECIMAL(20,5) UNSIGNED DEFAULT '0.000',
	eb_mudanca_controle_custo_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_custo_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (baseline_id, eb_mudanca_controle_custo_id),
	KEY baseline_id (baseline_id),
	KEY eb_mudanca_controle_custo_mudanca_controle (eb_mudanca_controle_custo_mudanca_controle),
	CONSTRAINT baseline_eb_mudanca_controle_custo_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_mudanca_controle_custo_controle FOREIGN KEY (eb_mudanca_controle_custo_mudanca_controle) REFERENCES eb_mudanca_controle (eb_mudanca_controle_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_mudanca_campo;

CREATE TABLE baseline_eb_mudanca_campo (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_mudanca_campo_id INTEGER(100) UNSIGNED NOT NULL,
	eb_mudanca_campo_mudanca INTEGER(100) UNSIGNED NOT NULL,
	eb_mudanca_campo_texto TEXT,
	eb_mudanca_campo_titulo VARCHAR(50),
	PRIMARY KEY (baseline_id, eb_mudanca_campo_id),
	KEY baseline_id (baseline_id),
	KEY eb_mudanca_campo_id (eb_mudanca_campo_id),
	KEY eb_mudanca_campo_mudanca (eb_mudanca_campo_mudanca),
	CONSTRAINT baseline_eb_mudanca_campo_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_mudanca_campo_mudanca FOREIGN KEY (eb_mudanca_campo_mudanca) REFERENCES eb_mudanca (eb_mudanca_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_interessado_campo;

CREATE TABLE baseline_eb_interessado_campo (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_interessado_campo_id INTEGER(100) UNSIGNED NOT NULL,
	eb_interessado_campo_interessado INTEGER(100) UNSIGNED NOT NULL,
	eb_interessado_campo_texto TEXT,
	eb_interessado_campo_titulo VARCHAR(50),
	PRIMARY KEY (baseline_id, eb_interessado_campo_id),
	KEY baseline_id (baseline_id),
	KEY eb_interessado_campo_id (eb_interessado_campo_id),
	KEY eb_interessado_campo_interessado (eb_interessado_campo_interessado),
	CONSTRAINT baseline_eb_interessado_campo_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_interessado_campo_interessado FOREIGN KEY (eb_interessado_campo_interessado) REFERENCES eb_interessado (eb_interessado_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_comunicacao_campo;

CREATE TABLE baseline_eb_comunicacao_campo (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_comunicacao_campo_id INTEGER(100) UNSIGNED NOT NULL,
	eb_comunicacao_campo_comunicacao INTEGER(100) UNSIGNED NOT NULL,
	eb_comunicacao_campo_texto TEXT,
	eb_comunicacao_campo_titulo VARCHAR(50),
	PRIMARY KEY (baseline_id, eb_comunicacao_campo_id),
	KEY baseline_id (baseline_id),
	KEY eb_comunicacao_campo_id (eb_comunicacao_campo_id),
	CONSTRAINT baseline_eb_comunicacao_campo_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_comunicacao_campo_comunicacao FOREIGN KEY (eb_comunicacao_campo_comunicacao) REFERENCES eb_comunicacao (eb_comunicacao_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_plano_item_depts;

CREATE TABLE baseline_eb_plano_item_depts (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_plano_item_depts_id INTEGER(100) UNSIGNED NOT NULL,
  eb_plano_item_id INTEGER(100) UNSIGNED DEFAULT NULL,
  dept_id INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (baseline_id, eb_plano_item_depts_id),
	KEY baseline_id (baseline_id),
  KEY eb_plano_item_id (eb_plano_item_id),
  KEY dept_id (dept_id),
	CONSTRAINT baseline_eb_plano_item_depts_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_plano_item_depts_dept FOREIGN KEY (dept_id) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_plano_item_depts_item FOREIGN KEY (eb_plano_item_id) REFERENCES eb_plano_item (eb_plano_item_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_plano_item_custos;

CREATE TABLE baseline_eb_plano_item_custos (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
  eb_plano_item_custos_id INTEGER(100) UNSIGNED NOT NULL,
  eb_plano_item_custos_eb_plano_item INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_plano_item_custos_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_plano_item_custos_tipo INTEGER(100) UNSIGNED DEFAULT 1,
  eb_plano_item_custos_nome VARCHAR(255) DEFAULT NULL,
  eb_plano_item_custos_data DATETIME DEFAULT NULL,
  eb_plano_item_custos_quantidade DECIMAL(20,5) UNSIGNED DEFAULT 0,
  eb_plano_item_custos_custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
  eb_plano_item_custos_percentagem TINYINT(4) DEFAULT 0,
  eb_plano_item_custos_descricao TEXT,
  eb_plano_item_custos_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_plano_item_custos_nd VARCHAR(11) DEFAULT NULL,
  eb_plano_item_custos_categoria_economica VARCHAR(1) DEFAULT NULL,
  eb_plano_item_custos_grupo_despesa VARCHAR(1) DEFAULT NULL,
  eb_plano_item_custos_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  eb_plano_item_custos_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_plano_item_custos_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
  eb_plano_item_custos_data_limite DATE DEFAULT NULL,
  uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (baseline_id, eb_plano_item_custos_id),
	KEY baseline_id (baseline_id),
  KEY idxeb_plano_item_custos_eb_plano_item (eb_plano_item_custos_eb_plano_item),
  KEY idxeb_plano_item_custos_usuario_inicio (eb_plano_item_custos_usuario),
  KEY idxeb_plano_item_custos_ordem (eb_plano_item_custos_ordem),
  KEY idxeb_plano_item_custos_data_inicio (eb_plano_item_custos_data),
  KEY idxeb_plano_item_custos_nome (eb_plano_item_custos_nome),
	CONSTRAINT baseline_eb_plano_item_custos_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_plano_item_custos_item FOREIGN KEY (eb_plano_item_custos_eb_plano_item) REFERENCES eb_plano_item (eb_plano_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_plano_item_custos_usuario FOREIGN KEY (eb_plano_item_custos_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_plano_item_designados;

CREATE TABLE baseline_eb_plano_item_designados (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_plano_item_designados_id INTEGER(100) UNSIGNED NOT NULL,
  eb_plano_item_id INTEGER(100) UNSIGNED DEFAULT NULL,
  usuario_id INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (baseline_id, eb_plano_item_designados_id),
	KEY baseline_id (baseline_id),
	KEY eb_plano_item_id (eb_plano_item_id),
  KEY usuario_id (usuario_id),
  KEY eb_plano_item_designados_id (eb_plano_item_designados_id),
	CONSTRAINT baseline_eb_plano_item_designados_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_plano_item_designados_usuario FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_plano_item_designados_item FOREIGN KEY (eb_plano_item_id) REFERENCES eb_plano_item (eb_plano_item_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_plano_item_gastos;

CREATE TABLE baseline_eb_plano_item_gastos (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
  eb_plano_item_gastos_id INTEGER(100) UNSIGNED NOT NULL,
  eb_plano_item_gastos_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_plano_item_gastos_eb_plano_item INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_plano_item_gastos_tipo INTEGER(100) UNSIGNED DEFAULT 1,
  eb_plano_item_gastos_nome VARCHAR(255) DEFAULT NULL,
  eb_plano_item_gastos_data DATETIME DEFAULT NULL,
  eb_plano_item_gastos_data_recebido DATETIME DEFAULT NULL,
  eb_plano_item_gastos_quantidade DECIMAL(20,5) UNSIGNED DEFAULT 0,
  eb_plano_item_gastos_custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
  eb_plano_item_gastos_percentagem TINYINT(4) DEFAULT 0,
  eb_plano_item_gastos_descricao TEXT,
  eb_plano_item_gastos_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_plano_item_gastos_nd VARCHAR(11) DEFAULT NULL,
  eb_plano_item_gastos_categoria_economica VARCHAR(1) DEFAULT NULL,
  eb_plano_item_gastos_grupo_despesa VARCHAR(1) DEFAULT NULL,
  eb_plano_item_gastos_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  eb_plano_item_gastos_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_plano_item_gastos_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
  eb_plano_item_custos_data_recebido DATE DEFAULT NULL,
  uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (baseline_id, eb_plano_item_gastos_id),
	KEY baseline_id (baseline_id),
  KEY idxeb_plano_item_gastos_eb_plano_item (eb_plano_item_gastos_eb_plano_item),
  KEY idxeb_plano_item_gastos_usuario_inicio (eb_plano_item_gastos_usuario),
  KEY idxeb_plano_item_gastos_ordem (eb_plano_item_gastos_ordem),
  KEY idxeb_plano_item_gastos_data_inicio (eb_plano_item_gastos_data),
  KEY idxeb_plano_item_gastos_nome (eb_plano_item_gastos_nome),
	CONSTRAINT baseline_eb_plano_item_gastos_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_plano_item_gastos_item FOREIGN KEY (eb_plano_item_gastos_eb_plano_item) REFERENCES eb_plano_item (eb_plano_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_plano_item_gastos_usuario FOREIGN KEY (eb_plano_item_gastos_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_plano_item_h_custos;

CREATE TABLE baseline_eb_plano_item_h_custos (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
  h_custos_id INTEGER(100) UNSIGNED NOT NULL,
  h_custos_eb_plano_item INTEGER(100) UNSIGNED DEFAULT NULL,
  h_custos_eb_plano_item_custos_id INTEGER(100) UNSIGNED DEFAULT NULL,
  h_custos_nome1 VARCHAR(255) DEFAULT NULL,
  h_custos_nome2 VARCHAR(255) DEFAULT NULL,
  h_custos_tipo1 INTEGER(100) UNSIGNED DEFAULT 1,
  h_custos_tipo2 INTEGER(100) UNSIGNED DEFAULT 1,
  h_custos_usuario1 INTEGER(100) UNSIGNED DEFAULT NULL,
  h_custos_usuario2 INTEGER(100) UNSIGNED DEFAULT NULL,
  h_custos_data1 DATETIME DEFAULT NULL,
  h_custos_data2 DATETIME DEFAULT NULL,
  h_custos_quantidade1 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_custos_quantidade2 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_custos_custo1 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_custos_custo2 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_custos_percentagem1 TINYINT(4) DEFAULT 0,
  h_custos_percentagem2 TINYINT(4) DEFAULT 0,
  h_custos_descricao1 TEXT,
  h_custos_descricao2 TEXT,
  h_custos_nd1 VARCHAR(20) DEFAULT NULL,
  h_custos_nd2 VARCHAR(20) DEFAULT NULL,
  h_custos_categoria_economica1 VARCHAR(1) DEFAULT NULL,
  h_custos_grupo_despesa1 VARCHAR(1) DEFAULT NULL,
  h_custos_modalidade_aplicacao1 VARCHAR(2) DEFAULT NULL,
  h_custos_categoria_economica2 VARCHAR(1) DEFAULT NULL,
  h_custos_grupo_despesa2 VARCHAR(1) DEFAULT NULL,
  h_custos_modalidade_aplicacao2 VARCHAR(2) DEFAULT NULL,
  h_custos_metodo1 INTEGER(100) UNSIGNED DEFAULT NULL,
	h_custos_metodo2 INTEGER(100) UNSIGNED DEFAULT NULL,
	h_custos_exercicio1 INTEGER(4) UNSIGNED DEFAULT NULL,
	h_custos_exercicio2 INTEGER(4) UNSIGNED DEFAULT NULL,
  h_custos_excluido TINYINT(1) DEFAULT 0,
  uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (baseline_id, h_custos_id),
	KEY baseline_id (baseline_id),
  KEY h_custos_eb_plano_item_custos_id (h_custos_eb_plano_item_custos_id),
	CONSTRAINT baseline_eb_plano_item_h_custos_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_plano_item_h_custos_custo FOREIGN KEY (h_custos_eb_plano_item_custos_id) REFERENCES eb_plano_item_custos (eb_plano_item_custos_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_plano_item_h_gastos;

CREATE TABLE baseline_eb_plano_item_h_gastos (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
  h_gastos_id INTEGER(100) UNSIGNED NOT NULL,
  h_gastos_eb_plano_item_gastos_id INTEGER(100) UNSIGNED DEFAULT NULL,
  h_gastos_eb_plano_item INTEGER(100) UNSIGNED DEFAULT NULL,
  h_gastos_nome1 VARCHAR(255) DEFAULT NULL,
  h_gastos_nome2 VARCHAR(255) DEFAULT NULL,
  h_gastos_tipo1 INTEGER(100) UNSIGNED DEFAULT 1,
  h_gastos_tipo2 INTEGER(100) UNSIGNED DEFAULT 1,
  h_gastos_usuario1 INTEGER(100) UNSIGNED DEFAULT NULL,
  h_gastos_usuario2 INTEGER(100) UNSIGNED DEFAULT NULL,
  h_gastos_data1 DATETIME DEFAULT NULL,
  h_gastos_data2 DATETIME DEFAULT NULL,
  h_gastos_quantidade1 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_gastos_quantidade2 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_gastos_custo1 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_gastos_custo2 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_gastos_percentagem1 TINYINT(4) DEFAULT 0,
  h_gastos_percentagem2 TINYINT(4) DEFAULT 0,
  h_gastos_descricao1 TEXT,
  h_gastos_descricao2 TEXT,
  h_gastos_nd1 VARCHAR(20) DEFAULT NULL,
  h_gastos_nd2 VARCHAR(20) DEFAULT NULL,
  h_gastos_categoria_economica1 VARCHAR(1) DEFAULT NULL,
  h_gastos_grupo_despesa1 VARCHAR(1) DEFAULT NULL,
  h_gastos_modalidade_aplicacao1 VARCHAR(2) DEFAULT NULL,
  h_gastos_categoria_economica2 VARCHAR(1) DEFAULT NULL,
  h_gastos_grupo_despesa2 VARCHAR(1) DEFAULT NULL,
  h_gastos_modalidade_aplicacao2 VARCHAR(2) DEFAULT NULL,
  h_gastos_metodo1 INTEGER(100) UNSIGNED DEFAULT NULL,
	h_gastos_metodo2 INTEGER(100) UNSIGNED DEFAULT NULL,
	h_gastos_exercicio1 INTEGER(4) UNSIGNED DEFAULT NULL,
	h_gastos_exercicio2 INTEGER(4) UNSIGNED DEFAULT NULL,
  h_gastos_excluido TINYINT(1) DEFAULT 0,
  uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (baseline_id, h_gastos_id),
	KEY baseline_id (baseline_id),
  KEY h_gastos_eb_plano_item_gastos_id (h_gastos_eb_plano_item_gastos_id),
	CONSTRAINT baseline_eb_plano_item_h_gastos_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_plano_item_h_gastos_gasto FOREIGN KEY (h_gastos_eb_plano_item_gastos_id) REFERENCES eb_plano_item_gastos (eb_plano_item_gastos_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_escopo_campo;

CREATE TABLE baseline_eb_escopo_campo (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_escopo_campo_id INTEGER(100) UNSIGNED NOT NULL,
	eb_escopo_campo_escopo INTEGER(100) UNSIGNED NOT NULL,
	eb_escopo_campo_texto TEXT,
	eb_escopo_campo_titulo VARCHAR(50),
  PRIMARY KEY (baseline_id, eb_escopo_campo_id),
	KEY baseline_id (baseline_id),
	KEY eb_escopo_campo_id (eb_escopo_campo_id),
	CONSTRAINT baseline_eb_escopo_campo_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_escopo_campo_escopo FOREIGN KEY (eb_escopo_campo_escopo) REFERENCES eb_escopo (eb_escopo_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_iniciacao_campo;

CREATE TABLE baseline_eb_iniciacao_campo (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_iniciacao_campo_id INTEGER(100) UNSIGNED NOT NULL,
	eb_iniciacao_campo_iniciacao INTEGER(100) UNSIGNED NOT NULL,
	eb_iniciacao_campo_texto TEXT,
	eb_iniciacao_campo_titulo VARCHAR(50),
	PRIMARY KEY (baseline_id, eb_iniciacao_campo_id),
	KEY baseline_id (baseline_id),
	KEY eb_iniciacao_campo_id (eb_iniciacao_campo_id),
	KEY eb_iniciacao_campo_iniciacao (eb_iniciacao_campo_iniciacao),
	CONSTRAINT baseline_eb_iniciacao_campo_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_iniciacao_campo_iniciacao FOREIGN KEY (eb_iniciacao_campo_iniciacao) REFERENCES eb_iniciacao (eb_iniciacao_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_implantacao_campo;

CREATE TABLE baseline_eb_implantacao_campo (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_implantacao_campo_id INTEGER(100) UNSIGNED NOT NULL,
	eb_implantacao_campo_implantacao INTEGER(100) UNSIGNED NOT NULL,
	eb_implantacao_campo_texto TEXT,
	eb_implantacao_campo_titulo VARCHAR(50),
	PRIMARY KEY (baseline_id, eb_implantacao_campo_id),
	KEY baseline_id (baseline_id),
	KEY eb_implantacao_campo_implantacao (eb_implantacao_campo_implantacao),
	CONSTRAINT baseline_eb_implantacao_campo_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_implantacao_campo_implantacao FOREIGN KEY (eb_implantacao_campo_implantacao) REFERENCES eb_implantacao (eb_implantacao_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_viabilidade_campo;

CREATE TABLE baseline_eb_viabilidade_campo (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_viabilidade_campo_id INTEGER(100) UNSIGNED NOT NULL,
	eb_viabilidade_campo_viabilidade INTEGER(100) UNSIGNED NOT NULL,
	eb_viabilidade_campo_texto TEXT,
	eb_viabilidade_campo_titulo VARCHAR(50),
	PRIMARY KEY (baseline_id, eb_viabilidade_campo_id),
	KEY baseline_id (baseline_id),
	KEY eb_viabilidade_campo_id (eb_viabilidade_campo_id),
	KEY eb_viabilidade_campo_viabilidade (eb_viabilidade_campo_viabilidade),
	CONSTRAINT baseline_eb_viabilidade_campo_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_viabilidade_campo_viabilidade FOREIGN KEY (eb_viabilidade_campo_viabilidade) REFERENCES eb_viabilidade (eb_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS tarefa_entrega;

CREATE TABLE tarefa_entrega (
  tarefa_entrega_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  tarefa_entrega_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_entrega_previsto INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_entrega_realizado INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_entrega_nome VARCHAR(255) DEFAULT NULL,
  tarefa_entrega_descricao MEDIUMTEXT,
  tarefa_entrega_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_entrega_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (tarefa_entrega_id),
  KEY tarefa_entrega_tarefa (tarefa_entrega_tarefa),
  CONSTRAINT tarefa_entrega_fk FOREIGN KEY (tarefa_entrega_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_tarefa_entrega;

CREATE TABLE baseline_tarefa_entrega (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
  tarefa_entrega_id INTEGER(100) UNSIGNED NOT NULL,
  tarefa_entrega_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_entrega_previsto INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_entrega_realizado INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_entrega_nome VARCHAR(255) DEFAULT NULL,
  tarefa_entrega_descricao MEDIUMTEXT,
  tarefa_entrega_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_entrega_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (baseline_id, tarefa_entrega_id),
  CONSTRAINT baseline_tarefa_entrega_fk FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS priorizacao_modelo;

CREATE TABLE priorizacao_modelo (
	priorizacao_modelo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	priorizacao_modelo_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_modelo_nome VARCHAR(255) DEFAULT NULL,
	priorizacao_modelo_tipo VARCHAR(20) DEFAULT NULL,
	priorizacao_modelo_descricao MEDIUMTEXT,
	priorizacao_modelo_projeto TINYINT(1) DEFAULT 0,
  priorizacao_modelo_tarefa TINYINT(1) DEFAULT 0,
  priorizacao_modelo_perspectiva TINYINT(1) DEFAULT 0,
  priorizacao_modelo_tema TINYINT(1) DEFAULT 0,
  priorizacao_modelo_objetivo TINYINT(1) DEFAULT 0,
  priorizacao_modelo_fator TINYINT(1) DEFAULT 0,
  priorizacao_modelo_estrategia TINYINT(1) DEFAULT 0,
  priorizacao_modelo_meta TINYINT(1) DEFAULT 0,
  priorizacao_modelo_pratica TINYINT(1) DEFAULT 0,
  priorizacao_modelo_indicador TINYINT(1) DEFAULT 0,
  priorizacao_modelo_acao TINYINT(1) DEFAULT 0,
  priorizacao_modelo_canvas TINYINT(1) DEFAULT 0,
  priorizacao_modelo_risco TINYINT(1) DEFAULT 0,
  priorizacao_modelo_risco_resposta TINYINT(1) DEFAULT 0,
  priorizacao_modelo_calendario TINYINT(1) DEFAULT 0,
  priorizacao_modelo_monitoramento TINYINT(1) DEFAULT 0,
  priorizacao_modelo_ata TINYINT(1) DEFAULT 0,
  priorizacao_modelo_mswot TINYINT(1) DEFAULT 0,
  priorizacao_modelo_swot TINYINT(1) DEFAULT 0,
  priorizacao_modelo_operativo TINYINT(1) DEFAULT 0,
  priorizacao_modelo_instrumento TINYINT(1) DEFAULT 0,
  priorizacao_modelo_recurso TINYINT(1) DEFAULT 0,
  priorizacao_modelo_problema TINYINT(1) DEFAULT 0,
  priorizacao_modelo_demanda TINYINT(1) DEFAULT 0,
  priorizacao_modelo_programa TINYINT(1) DEFAULT 0,
  priorizacao_modelo_licao TINYINT(1) DEFAULT 0,
  priorizacao_modelo_evento TINYINT(1) DEFAULT 0,
  priorizacao_modelo_link TINYINT(1) DEFAULT 0,
  priorizacao_modelo_avaliacao TINYINT(1) DEFAULT 0,
  priorizacao_modelo_tgn TINYINT(1) DEFAULT 0,
  priorizacao_modelo_brainstorm TINYINT(1) DEFAULT 0,
  priorizacao_modelo_gut TINYINT(1) DEFAULT 0,
  priorizacao_modelo_causa_efeito TINYINT(1) DEFAULT 0,
  priorizacao_modelo_arquivo TINYINT(1) DEFAULT 0,
  priorizacao_modelo_forum TINYINT(1) DEFAULT 0,
  priorizacao_modelo_checklist TINYINT(1) DEFAULT 0,
  priorizacao_modelo_agenda TINYINT(1) DEFAULT 0,
  priorizacao_modelo_agrupamento TINYINT(1) DEFAULT 0,
  priorizacao_modelo_patrocinador TINYINT(1) DEFAULT 0,
  priorizacao_modelo_template TINYINT(1) DEFAULT 0,
  priorizacao_modelo_painel TINYINT(1) DEFAULT 0,
	priorizacao_modelo_painel_odometro TINYINT(1) DEFAULT 0,
	priorizacao_modelo_painel_composicao TINYINT(1) DEFAULT 0,
	priorizacao_modelo_tr TINYINT(1) DEFAULT 0,
	priorizacao_modelo_me TINYINT(1) DEFAULT 0,
	priorizacao_modelo_acao_item TINYINT(1) DEFAULT 0,
	priorizacao_modelo_beneficio TINYINT(1) DEFAULT 0,
	priorizacao_modelo_painel_slideshow TINYINT(1) DEFAULT 0,
	priorizacao_modelo_projeto_viabilidade TINYINT(1) DEFAULT 0,
	priorizacao_modelo_projeto_abertura TINYINT(1) DEFAULT 0,
	priorizacao_modelo_plano_gestao TINYINT(1) DEFAULT 0,
	PRIMARY KEY (priorizacao_modelo_id)
	)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS priorizacao_modelo_opcao;

CREATE TABLE priorizacao_modelo_opcao (
	priorizacao_modelo_opcao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	priorizacao_modelo_opcao_modelo INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_modelo_opcao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_modelo_opcao_nome VARCHAR(255) DEFAULT NULL,
	priorizacao_modelo_opcao_valor INTEGER(100) DEFAULT NULL,
	PRIMARY KEY (priorizacao_modelo_opcao_id),
	KEY priorizacao_modelo_opcao_modelo (priorizacao_modelo_opcao_modelo),
	CONSTRAINT priorizacao_modelo_opcao_modelo FOREIGN KEY (priorizacao_modelo_opcao_modelo) REFERENCES priorizacao_modelo (priorizacao_modelo_id) ON DELETE CASCADE ON UPDATE CASCADE
	)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS priorizacao;

CREATE TABLE priorizacao (
	priorizacao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	priorizacao_modelo INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_valor INTEGER(100) DEFAULT NULL,
	priorizacao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY priorizacao_id (priorizacao_id),
	KEY priorizacao_modelo (priorizacao_modelo),
	KEY priorizacao_projeto (priorizacao_projeto),
	KEY priorizacao_tarefa (priorizacao_tarefa),
	KEY priorizacao_perspectiva (priorizacao_perspectiva),
	KEY priorizacao_tema (priorizacao_tema),
	KEY priorizacao_objetivo (priorizacao_objetivo),
	KEY priorizacao_estrategia (priorizacao_estrategia),
	KEY priorizacao_meta (priorizacao_meta),
	KEY priorizacao_fator (priorizacao_fator),
	KEY priorizacao_pratica (priorizacao_pratica),
	KEY priorizacao_indicador (priorizacao_indicador),
	KEY priorizacao_acao (priorizacao_acao),
	KEY priorizacao_canvas (priorizacao_canvas),
	KEY priorizacao_risco (priorizacao_risco),
	KEY priorizacao_risco_resposta (priorizacao_risco_resposta),
	KEY priorizacao_calendario (priorizacao_calendario),
	KEY priorizacao_monitoramento (priorizacao_monitoramento),
	KEY priorizacao_ata (priorizacao_ata),
	KEY priorizacao_mswot(priorizacao_mswot),
	KEY priorizacao_swot(priorizacao_swot),
	KEY priorizacao_operativo(priorizacao_operativo),
	KEY priorizacao_instrumento (priorizacao_instrumento),
	KEY priorizacao_recurso (priorizacao_recurso),
	KEY priorizacao_problema (priorizacao_problema),
	KEY priorizacao_demanda (priorizacao_demanda),
	KEY priorizacao_programa (priorizacao_programa),
	KEY priorizacao_licao (priorizacao_licao),
	KEY priorizacao_evento (priorizacao_evento),
	KEY priorizacao_link (priorizacao_link),
	KEY priorizacao_avaliacao (priorizacao_avaliacao),
	KEY priorizacao_tgn (priorizacao_tgn),
	KEY priorizacao_brainstorm (priorizacao_brainstorm),
	KEY priorizacao_gut (priorizacao_gut),
	KEY priorizacao_causa_efeito (priorizacao_causa_efeito),
	KEY priorizacao_arquivo (priorizacao_arquivo),
	KEY priorizacao_forum (priorizacao_forum),
	KEY priorizacao_checklist (priorizacao_checklist),
	KEY priorizacao_agenda (priorizacao_agenda),
	KEY priorizacao_agrupamento (priorizacao_agrupamento),
	KEY priorizacao_patrocinador (priorizacao_patrocinador),
	KEY priorizacao_template (priorizacao_template),
	KEY priorizacao_painel (priorizacao_painel),
	KEY priorizacao_painel_odometro (priorizacao_painel_odometro),
	KEY priorizacao_painel_composicao (priorizacao_painel_composicao),
	KEY priorizacao_tr (priorizacao_tr),
	KEY priorizacao_me (priorizacao_me),
	KEY priorizacao_acao_item (priorizacao_acao_item),
	KEY priorizacao_beneficio (priorizacao_beneficio),
	KEY priorizacao_painel_slideshow (priorizacao_painel_slideshow),
	KEY priorizacao_projeto_viabilidade (priorizacao_projeto_viabilidade),
	KEY priorizacao_projeto_abertura (priorizacao_projeto_abertura),
	KEY priorizacao_plano_gestao (priorizacao_plano_gestao),
	CONSTRAINT priorizacao_modelo FOREIGN KEY (priorizacao_modelo) REFERENCES priorizacao_modelo (priorizacao_modelo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_projeto FOREIGN KEY (priorizacao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_tarefa FOREIGN KEY (priorizacao_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_perspectiva FOREIGN KEY (priorizacao_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_tema FOREIGN KEY (priorizacao_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_objetivo FOREIGN KEY (priorizacao_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_fator FOREIGN KEY (priorizacao_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_estrategia FOREIGN KEY (priorizacao_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_meta FOREIGN KEY (priorizacao_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_pratica FOREIGN KEY (priorizacao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_indicador FOREIGN KEY (priorizacao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_acao FOREIGN KEY (priorizacao_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_canvas FOREIGN KEY (priorizacao_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_risco FOREIGN KEY (priorizacao_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_risco_resposta FOREIGN KEY (priorizacao_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_calendario FOREIGN KEY (priorizacao_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_monitoramento FOREIGN KEY (priorizacao_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_ata FOREIGN KEY (priorizacao_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_mswot FOREIGN KEY (priorizacao_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_swot FOREIGN KEY (priorizacao_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_operativo FOREIGN KEY (priorizacao_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_instrumento FOREIGN KEY (priorizacao_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_recurso FOREIGN KEY (priorizacao_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_problema FOREIGN KEY (priorizacao_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_demanda FOREIGN KEY (priorizacao_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_programa FOREIGN KEY (priorizacao_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_licao FOREIGN KEY (priorizacao_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_evento FOREIGN KEY (priorizacao_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_link FOREIGN KEY (priorizacao_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_avaliacao FOREIGN KEY (priorizacao_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_tgn FOREIGN KEY (priorizacao_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_brainstorm FOREIGN KEY (priorizacao_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_gut FOREIGN KEY (priorizacao_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_causa_efeito FOREIGN KEY (priorizacao_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_arquivo FOREIGN KEY (priorizacao_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_forum FOREIGN KEY (priorizacao_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_checklist FOREIGN KEY (priorizacao_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_agenda FOREIGN KEY (priorizacao_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_agrupamento FOREIGN KEY (priorizacao_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_patrocinador FOREIGN KEY (priorizacao_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_template FOREIGN KEY (priorizacao_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_painel FOREIGN KEY (priorizacao_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_painel_odometro FOREIGN KEY (priorizacao_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_painel_composicao FOREIGN KEY (priorizacao_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_tr FOREIGN KEY (priorizacao_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_me FOREIGN KEY (priorizacao_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_acao_item FOREIGN KEY (priorizacao_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_beneficio FOREIGN KEY (priorizacao_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_painel_slideshow FOREIGN KEY (priorizacao_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_projeto_viabilidade FOREIGN KEY (priorizacao_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_projeto_abertura FOREIGN KEY (priorizacao_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_plano_gestao FOREIGN KEY (priorizacao_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_priorizacao;

CREATE TABLE baseline_priorizacao (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	priorizacao_id INTEGER(100) UNSIGNED NOT NULL,
	priorizacao_modelo INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_valor INTEGER(100) DEFAULT NULL,
	priorizacao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (baseline_id, priorizacao_id),
  KEY baseline_id (baseline_id),
  CONSTRAINT baseline_priorizacao_fk FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS pratica_indicador_filtro;

CREATE TABLE pratica_indicador_filtro (
  pratica_indicador_filtro_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pratica_indicador_filtro_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_filtro_status INTEGER(100) DEFAULT NULL,
  pratica_indicador_filtro_prioridade TINYINT(4) DEFAULT NULL,
  pratica_indicador_filtro_tipo VARCHAR(255) DEFAULT NULL,
  pratica_indicador_filtro_setor VARCHAR(2) DEFAULT NULL,
  pratica_indicador_filtro_segmento VARCHAR(4) DEFAULT NULL,
  pratica_indicador_filtro_intervencao VARCHAR(6) DEFAULT NULL,
  pratica_indicador_filtro_tipo_intervencao VARCHAR(9) DEFAULT NULL,
 	pratica_indicador_filtro_comunidade INTEGER(100) DEFAULT NULL,
  pratica_indicador_filtro_social INTEGER(100) DEFAULT NULL,
  pratica_indicador_filtro_acao INTEGER(100) DEFAULT NULL,
  pratica_indicador_filtro_cidade VARCHAR(7) DEFAULT NULL,
  pratica_indicador_filtro_estado VARCHAR(2) DEFAULT NULL,
  pratica_indicador_filtro_texto VARCHAR(255) DEFAULT NULL,
  uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (pratica_indicador_filtro_id),
  KEY pratica_indicador_filtro_indicador (pratica_indicador_filtro_indicador),
  CONSTRAINT pratica_indicador_filtro_fk FOREIGN KEY (pratica_indicador_filtro_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS projeto_comunicacao_evento_calendario;
CREATE TABLE projeto_comunicacao_evento_calendario (
	projeto_comunicacao_evento_calendario_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  projeto_comunicacao_evento_id INTEGER(100) UNSIGNED DEFAULT NULL,
  evento_id INTEGER(100) UNSIGNED DEFAULT NULL,
  ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (projeto_comunicacao_evento_calendario_id),
  KEY projeto_comunicacao_evento_id (projeto_comunicacao_evento_id),
  KEY evento_id (evento_id),
  CONSTRAINT projeto_comunicacao_evento_calendario_fk FOREIGN KEY (projeto_comunicacao_evento_id) REFERENCES projeto_comunicacao_evento (projeto_comunicacao_evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_comunicacao_evento_calendario_fk1 FOREIGN KEY (evento_id) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS codigo;
CREATE TABLE codigo (
  codigo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  codigo_tipo VARCHAR(20) DEFAULT NULL,
  codigo_ativo TINYINT(1) DEFAULT 0,
  codigo_legenda TINYINT(1) DEFAULT 0,
  codigo_code39 TINYINT(1) DEFAULT 0,
  codigo_code93 TINYINT(1) DEFAULT 0,
  codigo_code128 TINYINT(1) DEFAULT 0,
  codigo_codabar TINYINT(1) DEFAULT 0,
  codigo_qr_codigo TINYINT(1) DEFAULT 0,
  codigo_qr_link TINYINT(1) DEFAULT 0,
  codigo_qr_telefone TINYINT(1) DEFAULT 0,
  codigo_qr_responsavel TINYINT(1) DEFAULT 0,
  codigo_qr_geo TINYINT(1) DEFAULT 0,
  codigo_datamatrix_codigo TINYINT(1) DEFAULT 0,
  codigo_pdf417_codigo TINYINT(1) DEFAULT 0,
  codigo_topo TINYINT(1) DEFAULT 0,
  PRIMARY KEY (codigo_id)
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS alerta_msg;
CREATE TABLE alerta_msg (
  alerta_msg_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  alerta_msg_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  alerta_msg_titulo VARCHAR(255) DEFAULT NULL,
  alerta_msg_texto MEDIUMTEXT,
  alerta_msg_link_interno TEXT,
  alerta_msg_link_externo TEXT,
  alerta_msg_data DATETIME DEFAULT NULL,
  alerta_msg_enviar_email TINYINT(1) DEFAULT 0,
  alerta_msg_enviar_msg TINYINT(1) DEFAULT 0,
  alerta_msg_enviar_sms TINYINT(4) DEFAULT 0,
  alerta_msg_instantaneo TINYINT(1) DEFAULT 0,
  alerta_msg_tipo VARCHAR(30) DEFAULT NULL,
  alerta_msg_obj INTEGER(100) UNSIGNED DEFAULT NULL,
  alerta_msg_intervalo INTEGER(100) DEFAULT 0,
  PRIMARY KEY (alerta_msg_id),
  KEY alerta_msg_usuario (alerta_msg_usuario),
  CONSTRAINT alerta_msg_fk FOREIGN KEY (alerta_msg_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS alerta;
CREATE TABLE alerta (
  alerta_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  alerta_campo VARCHAR(100) DEFAULT NULL,
  alerta_ativo TINYINT(1) DEFAULT 0,
  alerta_tem_valor TINYINT(1) DEFAULT 0,
  alerta_valor_min DECIMAL(20,5) DEFAULT NULL,
  alerta_valor_max DECIMAL(20,5) DEFAULT NULL,
  alerta_email TINYINT(1) DEFAULT 0,
  alerta_msg TINYINT(1) DEFAULT 0,
  alerta_sms TINYINT(4) DEFAULT 0,
  alerta_instantaneo TINYINT(1) DEFAULT 0,
  alerta_legenda VARCHAR(255) DEFAULT NULL,
  alerta_grupo VARCHAR(40) DEFAULT NULL,
  alerta_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  alerta_responsavel TINYINT(1) DEFAULT 0,
  alerta_supervisor TINYINT(1) DEFAULT 0,
  alerta_designado TINYINT(1) DEFAULT 0,
  alerta_incluir VARCHAR(255) DEFAULT NULL,
  alerta_intervalo INTEGER(100) DEFAULT 1,
	alerta_texto MEDIUMTEXT,
  PRIMARY KEY (alerta_id)
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS pratica_indicador_formula_simples;
CREATE TABLE pratica_indicador_formula_simples (
  pratica_indicador_formula_simples_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pratica_indicador_formula_simples_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_formula_simples_nome VARCHAR(255) DEFAULT NULL,
  ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (pratica_indicador_formula_simples_id),
  KEY pratica_indicador_formula_simples_indicador (pratica_indicador_formula_simples_indicador),
  CONSTRAINT pratica_indicador_formula_simples_fk FOREIGN KEY (pratica_indicador_formula_simples_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS pratica_legislacao;
CREATE TABLE pratica_legislacao (
  pratica_legislacao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pratica_legislacao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_legislacao_ano INTEGER(4) DEFAULT NULL,
  pratica_legislacao_norma VARCHAR(255) DEFAULT NULL,
  pratica_legislacao_esfera INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_legislacao_detalhe MEDIUMTEXT,
  pratica_legislacao_impacto INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_legislacao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_legislacao_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (pratica_legislacao_id),
  KEY pratica_legislacao_pratica (pratica_legislacao_pratica),
  CONSTRAINT pratica_legislacao_fk FOREIGN KEY (pratica_legislacao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS monitoramento_deliberacao;

CREATE TABLE monitoramento_deliberacao (
	monitoramento_deliberacao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	monitoramento_deliberacao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_deliberacao_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_deliberacao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_deliberacao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_deliberacao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_deliberacao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_deliberacao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_deliberacao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_deliberacao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_deliberacao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_deliberacao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_deliberacao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_deliberacao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_deliberacao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_deliberacao_prazo DATE DEFAULT NULL,
	monitoramento_deliberacao_status INTEGER(100) UNSIGNED DEFAULT 0,
	monitoramento_deliberacao_agir MEDIUMTEXT,
	monitoramento_deliberacao_obs MEDIUMTEXT,
	monitoramento_deliberacao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (monitoramento_deliberacao_id),
	KEY monitoramento_deliberacao_monitoramento (monitoramento_deliberacao_monitoramento),
	KEY monitoramento_deliberacao_usuario (monitoramento_deliberacao_usuario),
	KEY monitoramento_deliberacao_perspectiva (monitoramento_deliberacao_perspectiva),
	KEY monitoramento_deliberacao_tema (monitoramento_deliberacao_tema),
	KEY monitoramento_deliberacao_objetivo (monitoramento_deliberacao_objetivo),
	KEY monitoramento_deliberacao_estrategia (monitoramento_deliberacao_estrategia),
	KEY monitoramento_deliberacao_meta (monitoramento_deliberacao_meta),
	KEY monitoramento_deliberacao_projeto (monitoramento_deliberacao_projeto),
	KEY monitoramento_deliberacao_tarefa (monitoramento_deliberacao_tarefa),
	KEY monitoramento_deliberacao_pratica (monitoramento_deliberacao_pratica),
	KEY monitoramento_deliberacao_indicador (monitoramento_deliberacao_indicador),
	KEY monitoramento_deliberacao_acao (monitoramento_deliberacao_acao),
	KEY monitoramento_deliberacao_fator (monitoramento_deliberacao_fator),
	KEY monitoramento_deliberacao_operativo (monitoramento_deliberacao_operativo),
	CONSTRAINT monitoramento_deliberacao_fk1 FOREIGN KEY (monitoramento_deliberacao_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_deliberacao_fk2 FOREIGN KEY (monitoramento_deliberacao_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT monitoramento_deliberacao_fk3 FOREIGN KEY (monitoramento_deliberacao_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT monitoramento_deliberacao_fk4 FOREIGN KEY (monitoramento_deliberacao_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_deliberacao_fk5 FOREIGN KEY (monitoramento_deliberacao_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_deliberacao_fk6 FOREIGN KEY (monitoramento_deliberacao_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_deliberacao_fk7 FOREIGN KEY (monitoramento_deliberacao_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_deliberacao_fk8 FOREIGN KEY (monitoramento_deliberacao_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_deliberacao_fk9 FOREIGN KEY (monitoramento_deliberacao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_deliberacao_fk10 FOREIGN KEY (monitoramento_deliberacao_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT monitoramento_deliberacao_fk11 FOREIGN KEY (monitoramento_deliberacao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_deliberacao_fk12 FOREIGN KEY (monitoramento_deliberacao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_deliberacao_fk13 FOREIGN KEY (monitoramento_deliberacao_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_deliberacao_fk14 FOREIGN KEY (monitoramento_deliberacao_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;






DROP TABLE IF EXISTS monitoramento_depts;

CREATE TABLE monitoramento_depts (
  monitoramento_id INTEGER(100) UNSIGNED NOT NULL,
  dept_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (monitoramento_id, dept_id),
  KEY monitoramento_id (monitoramento_id),
  KEY dept_id (dept_id),
  CONSTRAINT monitoramento_depts_fk1 FOREIGN KEY (dept_id) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT monitoramento_depts_fk FOREIGN KEY (monitoramento_id) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS monitoramento_usuarios;

CREATE TABLE monitoramento_usuarios (
  monitoramento_id INTEGER(100) UNSIGNED NOT NULL,
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (monitoramento_id, usuario_id),
  KEY monitoramento_id (monitoramento_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT monitoramento_usuarios_fk1 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT monitoramento_usuarios_fk FOREIGN KEY (monitoramento_id) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS pagamento;

CREATE TABLE pagamento (
  pagamento_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pagamento_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  pagamento_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  pagamento_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  pagamento_data DATE DEFAULT NULL,
  pagamento_valor DECIMAL(20,5) DEFAULT NULL,
  pagamento_loa TINYINT(1) DEFAULT NULL,
  pagamento_rap TINYINT(1) DEFAULT NULL,
  pagamento_obs MEDIUMTEXT,
  PRIMARY KEY (pagamento_id),
  KEY pagamento_usuario (pagamento_usuario),
  KEY pagamento_projeto (pagamento_projeto),
  KEY pagamento_tarefa (pagamento_tarefa),
  CONSTRAINT pagamento_fk2 FOREIGN KEY (pagamento_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT pagamento_fk FOREIGN KEY (pagamento_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE SET NULL,
  CONSTRAINT pagamento_fk1 FOREIGN KEY (pagamento_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_pagamento;

CREATE TABLE baseline_pagamento (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
  pagamento_id INTEGER(100) UNSIGNED NOT NULL,
  pagamento_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  pagamento_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  pagamento_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  pagamento_data DATE DEFAULT NULL,
  pagamento_valor DECIMAL(20,5) DEFAULT NULL,
  pagamento_loa TINYINT(1) DEFAULT NULL,
  pagamento_rap TINYINT(1) DEFAULT NULL,
  pagamento_obs MEDIUMTEXT,
  PRIMARY KEY (baseline_id, pagamento_id),
  KEY baseline_id (baseline_id),
  CONSTRAINT baseline_pagamento_fk FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS usuario_externo;

CREATE TABLE usuario_externo (
  usuario_externo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  usuario_externo_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  usuario_externo_chave VARCHAR(100) DEFAULT NULL,
  usuario_externo_endereco TEXT,
  usuario_externo_geral TINYINT(1) DEFAULT 0,
  PRIMARY KEY (usuario_externo_id),
  KEY usuario_externo_usuario (usuario_externo_usuario),
  CONSTRAINT usuario_externo_fk FOREIGN KEY (usuario_externo_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS folha_ponto;

CREATE TABLE folha_ponto (
  folha_ponto_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  folha_ponto_usuario INTEGER(100)UNSIGNED DEFAULT NULL,
  folha_ponto_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  folha_ponto_evento INTEGER(100) UNSIGNED DEFAULT NULL,
  folha_ponto_insercao TIMESTAMP NOT NULL DEFAULT NOW(),
  folha_ponto_inicio DATETIME,
  folha_ponto_fim DATETIME,
  folha_ponto_duracao DECIMAL(20,5) UNSIGNED DEFAULT 0,
  folha_ponto_aprovou INTEGER(100) UNSIGNED DEFAULT NULL,
  folha_ponto_aprovado TINYINT(1) DEFAULT NULL,
  folha_ponto_data DATETIME,
	folha_ponto_valor_hora DECIMAL(20,5) UNSIGNED DEFAULT 0,
	folha_ponto_obs MEDIUMTEXT,
	folha_ponto_porcentagem INTEGER(100) UNSIGNED DEFAULT 100,
	folha_ponto_corrido TINYINT(1) NOT NULL DEFAULT 0,
	folha_ponto_empenhado DECIMAL(20,5) UNSIGNED DEFAULT 0,
	folha_ponto_liquidado DECIMAL(20,5) UNSIGNED DEFAULT 0,
	folha_ponto_pago DECIMAL(20,5) UNSIGNED DEFAULT 0,
  PRIMARY KEY (folha_ponto_id),
  KEY folha_ponto_usuario (folha_ponto_usuario),
  KEY folha_ponto_tarefa (folha_ponto_tarefa),
  KEY folha_ponto_evento (folha_ponto_evento),
  KEY folha_ponto_aprovou (folha_ponto_aprovou),
  CONSTRAINT folha_ponto_fk1 FOREIGN KEY (folha_ponto_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT folha_ponto_fk2 FOREIGN KEY (folha_ponto_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT folha_ponto_fk3 FOREIGN KEY (folha_ponto_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT folha_ponto_fk4 FOREIGN KEY (folha_ponto_aprovou) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS folha_ponto_gasto;

CREATE TABLE folha_ponto_gasto (
  folha_ponto_gasto_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  folha_ponto_gasto_folha INTEGER(100) UNSIGNED DEFAULT NULL,
  folha_ponto_gasto_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  folha_ponto_gasto_tipo INTEGER(100) UNSIGNED DEFAULT 1,
  folha_ponto_gasto_nome VARCHAR(255) DEFAULT NULL,
  folha_ponto_gasto_codigo VARCHAR(255) DEFAULT NULL,
	folha_ponto_gasto_fonte VARCHAR(255) DEFAULT NULL,
	folha_ponto_gasto_regiao VARCHAR(255) DEFAULT NULL,
	folha_ponto_gasto_bdi DECIMAL(20,5) UNSIGNED DEFAULT 0,
	folha_ponto_gasto_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
	folha_ponto_gasto_cotacao DECIMAL(6,5) UNSIGNED DEFAULT 1.00000, 
	folha_ponto_gasto_data_moeda DATE DEFAULT NULL, 
  folha_ponto_gasto_data DATETIME DEFAULT NULL,
  folha_ponto_gasto_quantidade DECIMAL(20,5) UNSIGNED DEFAULT 0,
  folha_ponto_gasto_gasto DECIMAL(20,5) UNSIGNED DEFAULT 0,
  folha_ponto_gasto_percentagem TINYINT(4) DEFAULT 0,
  folha_ponto_gasto_descricao MEDIUMTEXT,
  folha_ponto_gasto_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  folha_ponto_gasto_nd VARCHAR(11) DEFAULT NULL,
  folha_ponto_gasto_categoria_economica VARCHAR(1) DEFAULT NULL,
  folha_ponto_gasto_grupo_despesa VARCHAR(1) DEFAULT NULL,
  folha_ponto_gasto_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  folha_ponto_gasto_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	folha_ponto_gasto_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
  folha_ponto_gasto_data_limite DATE DEFAULT NULL,
	folha_ponto_gasto_empenhado DECIMAL(20,5) UNSIGNED DEFAULT 0,
	folha_ponto_gasto_liquidado DECIMAL(20,5) UNSIGNED DEFAULT 0,
	folha_ponto_gasto_pago DECIMAL(20,5) UNSIGNED DEFAULT 0,
  PRIMARY KEY (folha_ponto_gasto_id),
  KEY folha_ponto_gasto_folha (folha_ponto_gasto_folha),
  KEY folha_ponto_gasto_usuario_inicio (folha_ponto_gasto_usuario),
  KEY folha_ponto_gasto_ordem (folha_ponto_gasto_ordem),
  KEY folha_ponto_gasto_data_inicio (folha_ponto_gasto_data),
  KEY folha_ponto_gasto_nome (folha_ponto_gasto_nome),
  KEY folha_ponto_gasto_moeda (folha_ponto_gasto_moeda),
  CONSTRAINT folha_ponto_gasto_fk FOREIGN KEY (folha_ponto_gasto_folha) REFERENCES folha_ponto (folha_ponto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT folha_ponto_gasto_fk1 FOREIGN KEY (folha_ponto_gasto_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT folha_ponto_gasto_moeda FOREIGN KEY (folha_ponto_gasto_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS folha_ponto_arquivo;

CREATE TABLE folha_ponto_arquivo (
  folha_ponto_arquivo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  folha_ponto_arquivo_ponto INTEGER(100) UNSIGNED DEFAULT NULL,
  folha_ponto_arquivo_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  folha_ponto_arquivo_endereco VARCHAR(150) DEFAULT NULL,
  folha_ponto_arquivo_data DATETIME DEFAULT NULL,
  folha_ponto_arquivo_nome VARCHAR(150) DEFAULT NULL,
  folha_ponto_arquivo_tipo VARCHAR(50) DEFAULT NULL,
  folha_ponto_arquivo_extensao VARCHAR(50) DEFAULT NULL,
  folha_ponto_arquivo_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  folha_ponto_arquivo_nome_real VARCHAR(255) DEFAULT NULL,
	folha_ponto_arquivo_local VARCHAR(255) DEFAULT NULL,
	folha_ponto_arquivo_tamanho INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (folha_ponto_arquivo_id),
  KEY folha_ponto_arquivo_ponto (folha_ponto_arquivo_ponto),
  KEY folha_ponto_arquivo_usuario (folha_ponto_arquivo_usuario),
  CONSTRAINT folha_ponto_arquivo_fk1 FOREIGN KEY (folha_ponto_arquivo_ponto) REFERENCES folha_ponto (folha_ponto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT folha_ponto_arquivo_fk2 FOREIGN KEY (folha_ponto_arquivo_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_folha_ponto;

CREATE TABLE baseline_folha_ponto (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
  folha_ponto_id INTEGER(100) UNSIGNED NOT NULL,
  folha_ponto_usuario INTEGER(100)UNSIGNED DEFAULT NULL,
  folha_ponto_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  folha_ponto_evento INTEGER(100) UNSIGNED DEFAULT NULL,
  folha_ponto_insercao TIMESTAMP NOT NULL DEFAULT NOW(),
  folha_ponto_inicio DATETIME,
  folha_ponto_fim DATETIME,
  folha_ponto_duracao DECIMAL(20,5) UNSIGNED DEFAULT 0,
  folha_ponto_aprovou INTEGER(100)UNSIGNED DEFAULT NULL,
  folha_ponto_aprovado TINYINT(1) DEFAULT NULL,
  folha_ponto_data DATETIME,
	folha_ponto_valor_hora DECIMAL(20,5) UNSIGNED DEFAULT 0,
	folha_ponto_obs MEDIUMTEXT,
	folha_ponto_porcentagem INTEGER(100) UNSIGNED DEFAULT 100,
	folha_ponto_corrido TINYINT(1) NOT NULL DEFAULT 0,
	folha_ponto_empenhado DECIMAL(20,5) UNSIGNED DEFAULT 0,
	folha_ponto_liquidado DECIMAL(20,5) UNSIGNED DEFAULT 0,
	folha_ponto_pago DECIMAL(20,5) UNSIGNED DEFAULT 0,
 	PRIMARY KEY (baseline_id, folha_ponto_id),
  KEY baseline_id (baseline_id),
  KEY folha_ponto_id (folha_ponto_id),
  CONSTRAINT baseline_folha_ponto_fk FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_folha_ponto_gasto;

CREATE TABLE baseline_folha_ponto_gasto (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
  folha_ponto_gasto_id INTEGER(100) UNSIGNED NOT NULL,
  folha_ponto_gasto_folha INTEGER(100) UNSIGNED DEFAULT NULL,
  folha_ponto_gasto_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  folha_ponto_gasto_tipo INTEGER(100) UNSIGNED DEFAULT 1,
  folha_ponto_gasto_nome VARCHAR(255) DEFAULT NULL,
  folha_ponto_gasto_codigo VARCHAR(255) DEFAULT NULL,
	folha_ponto_gasto_fonte VARCHAR(255) DEFAULT NULL,
	folha_ponto_gasto_regiao VARCHAR(255) DEFAULT NULL,
	folha_ponto_gasto_bdi DECIMAL(20,5) UNSIGNED DEFAULT 0,
	folha_ponto_gasto_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
	folha_ponto_gasto_cotacao DECIMAL(6,5) UNSIGNED DEFAULT 1.00000, 
	folha_ponto_gasto_data_moeda DATE DEFAULT NULL, 
  folha_ponto_gasto_data DATETIME DEFAULT NULL,
  folha_ponto_gasto_quantidade DECIMAL(20,5) UNSIGNED DEFAULT 0,
  folha_ponto_gasto_gasto DECIMAL(20,5) UNSIGNED DEFAULT 0,
  folha_ponto_gasto_percentagem TINYINT(4) DEFAULT 0,
  folha_ponto_gasto_descricao MEDIUMTEXT,
  folha_ponto_gasto_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  folha_ponto_gasto_nd VARCHAR(11) DEFAULT NULL,
  folha_ponto_gasto_categoria_economica VARCHAR(1) DEFAULT NULL,
  folha_ponto_gasto_grupo_despesa VARCHAR(1) DEFAULT NULL,
  folha_ponto_gasto_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  folha_ponto_gasto_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	folha_ponto_gasto_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
  folha_ponto_gasto_data_limite DATE DEFAULT NULL,
	folha_ponto_gasto_empenhado DECIMAL(20,5) UNSIGNED DEFAULT 0,
	folha_ponto_gasto_liquidado DECIMAL(20,5) UNSIGNED DEFAULT 0,
	folha_ponto_gasto_pago DECIMAL(20,5) UNSIGNED DEFAULT 0,
 	PRIMARY KEY (baseline_id, folha_ponto_gasto_id),
  KEY baseline_id (baseline_id),
  KEY folha_ponto_gasto_id (folha_ponto_gasto_id),
  CONSTRAINT baseline_folha_ponto_gasto_fk FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_folha_ponto_arquivo;

CREATE TABLE baseline_folha_ponto_arquivo (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
  folha_ponto_arquivo_id INTEGER(100) UNSIGNED NOT NULL,
  folha_ponto_arquivo_ponto INTEGER(100) UNSIGNED DEFAULT NULL,
  folha_ponto_arquivo_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  folha_ponto_arquivo_endereco VARCHAR(150) DEFAULT NULL,
  folha_ponto_arquivo_data DATETIME DEFAULT NULL,
  folha_ponto_arquivo_nome VARCHAR(150) DEFAULT NULL,
  folha_ponto_arquivo_tipo VARCHAR(50) DEFAULT NULL,
  folha_ponto_arquivo_extensao VARCHAR(50) DEFAULT NULL,
  folha_ponto_arquivo_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (baseline_id, folha_ponto_arquivo_id),
  KEY baseline_id (baseline_id),
  KEY folha_ponto_arquivo_id (folha_ponto_arquivo_id),
  CONSTRAINT baseline_folha_ponto_arquivo_fk FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS recurso_ponto;

CREATE TABLE recurso_ponto (
  recurso_ponto_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  recurso_ponto_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_ponto_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_ponto_evento INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_ponto_insercao TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  recurso_ponto_inicio DATETIME,
  recurso_ponto_fim DATETIME,
  recurso_ponto_duracao DECIMAL(20,5) UNSIGNED DEFAULT 0,
  recurso_ponto_aprovou INTEGER(100)UNSIGNED DEFAULT NULL,
  recurso_ponto_aprovado TINYINT(1) DEFAULT NULL,
  recurso_ponto_data DATETIME,
  recurso_ponto_quantidade DECIMAL(20,5) UNSIGNED DEFAULT 0.000,
	recurso_ponto_valor_hora DECIMAL(20,5) UNSIGNED DEFAULT 0,
	recurso_ponto_empenhado DECIMAL(20,5) UNSIGNED DEFAULT 0,
	recurso_ponto_liquidado DECIMAL(20,5) UNSIGNED DEFAULT 0,
	recurso_ponto_pago DECIMAL(20,5) UNSIGNED DEFAULT 0,
  recurso_ponto_percentual INTEGER UNSIGNED NULL DEFAULT 100,
  recurso_ponto_custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
	recurso_ponto_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
	recurso_ponto_cotacao DECIMAL(6,5) UNSIGNED DEFAULT 1.00000,
	recurso_ponto_data_moeda DATE DEFAULT NULL,
	recurso_ponto_codigo VARCHAR(255) DEFAULT NULL,
	recurso_ponto_fonte VARCHAR(255) DEFAULT NULL,
	recurso_ponto_regiao VARCHAR(255) DEFAULT NULL,
	recurso_ponto_bdi DECIMAL(20,5) UNSIGNED DEFAULT 0,
	recurso_ponto_nd VARCHAR(11) DEFAULT NULL,
  recurso_ponto_categoria_economica VARCHAR(1) DEFAULT NULL,
  recurso_ponto_grupo_despesa VARCHAR(1) DEFAULT NULL,
  recurso_ponto_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  recurso_ponto_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	recurso_ponto_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
	recurso_ponto_obs MEDIUMTEXT,
	recurso_ponto_corrido TINYINT(1) NOT NULL DEFAULT 0,
  recurso_ponto_ordem INT(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (recurso_ponto_id),
  KEY recurso_ponto_recurso (recurso_ponto_recurso),
  KEY recurso_ponto_tarefa (recurso_ponto_tarefa),
  KEY recurso_ponto_evento (recurso_ponto_evento),
  KEY recurso_ponto_aprovou (recurso_ponto_aprovou),
  CONSTRAINT recurso_ponto_fk1 FOREIGN KEY (recurso_ponto_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT recurso_ponto_fk2 FOREIGN KEY (recurso_ponto_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT recurso_ponto_fk3 FOREIGN KEY (recurso_ponto_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT recurso_ponto_fk4 FOREIGN KEY (recurso_ponto_aprovou) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS recurso_ponto_gasto;

CREATE TABLE recurso_ponto_gasto (
  recurso_ponto_gasto_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  recurso_ponto_gasto_ponto INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_ponto_gasto_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_ponto_gasto_tipo INTEGER(100) UNSIGNED DEFAULT 1,
  recurso_ponto_gasto_nome VARCHAR(255) DEFAULT NULL,
  recurso_ponto_gasto_codigo VARCHAR(255) DEFAULT NULL,
	recurso_ponto_gasto_fonte VARCHAR(255) DEFAULT NULL,
	recurso_ponto_gasto_regiao VARCHAR(255) DEFAULT NULL,
	recurso_ponto_gasto_bdi DECIMAL(20,5) UNSIGNED DEFAULT 0,
	recurso_ponto_gasto_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
	recurso_ponto_gasto_cotacao DECIMAL(6,5) UNSIGNED DEFAULT 1.00000,
	recurso_ponto_gasto_data_moeda DATE DEFAULT NULL, 	
  recurso_ponto_gasto_data DATETIME DEFAULT NULL,
  recurso_ponto_gasto_quantidade DECIMAL(20,5) UNSIGNED DEFAULT 0,
  recurso_ponto_gasto_gasto DECIMAL(20,5) UNSIGNED DEFAULT 0,
  recurso_ponto_gasto_percentagem TINYINT(4) DEFAULT 0,
  recurso_ponto_gasto_descricao MEDIUMTEXT,
  recurso_ponto_gasto_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_ponto_gasto_nd VARCHAR(11) DEFAULT NULL,
  recurso_ponto_gasto_categoria_economica VARCHAR(1) DEFAULT NULL,
  recurso_ponto_gasto_grupo_despesa VARCHAR(1) DEFAULT NULL,
  recurso_ponto_gasto_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  recurso_ponto_gasto_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	recurso_ponto_gasto_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
  recurso_ponto_gasto_data_limite DATE DEFAULT NULL,
  recurso_ponto_gasto_empenhado DECIMAL(20,5) UNSIGNED DEFAULT 0,
	recurso_ponto_gasto_liquidado DECIMAL(20,5) UNSIGNED DEFAULT 0,
	recurso_ponto_gasto_pago DECIMAL(20,5) UNSIGNED DEFAULT 0,
  PRIMARY KEY (recurso_ponto_gasto_id),
  KEY recurso_ponto_gasto_ponto (recurso_ponto_gasto_ponto),
  KEY recurso_ponto_gasto_usuario (recurso_ponto_gasto_usuario),
  KEY recurso_ponto_gasto_ordem (recurso_ponto_gasto_ordem),
  KEY recurso_ponto_gasto_data_inicio (recurso_ponto_gasto_data),
  KEY recurso_ponto_gasto_nome (recurso_ponto_gasto_nome),
  KEY recurso_ponto_gasto_moeda (recurso_ponto_gasto_moeda),
  CONSTRAINT recurso_ponto_gasto_fk FOREIGN KEY (recurso_ponto_gasto_ponto) REFERENCES recurso_ponto (recurso_ponto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT recurso_ponto_gasto_fk1 FOREIGN KEY (recurso_ponto_gasto_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT recurso_ponto_gasto_moeda FOREIGN KEY (recurso_ponto_gasto_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS recurso_ponto_arquivo;

CREATE TABLE recurso_ponto_arquivo (
  recurso_ponto_arquivo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  recurso_ponto_arquivo_ponto INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_ponto_arquivo_endereco VARCHAR(150) DEFAULT NULL,
  recurso_ponto_arquivo_data DATETIME DEFAULT NULL,
  recurso_ponto_arquivo_nome VARCHAR(150) DEFAULT NULL,
  recurso_ponto_arquivo_tipo VARCHAR(50) DEFAULT NULL,
  recurso_ponto_arquivo_extensao VARCHAR(50) DEFAULT NULL,
  recurso_ponto_arquivo_nome_real VARCHAR(255) DEFAULT NULL,
	recurso_ponto_arquivo_local VARCHAR(255) DEFAULT NULL,
	recurso_ponto_arquivo_tamanho INTEGER(100) UNSIGNED DEFAULT NULL, 
  recurso_ponto_arquivo_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (recurso_ponto_arquivo_id),
  KEY recurso_ponto_arquivo_ponto (recurso_ponto_arquivo_ponto),
  CONSTRAINT recurso_ponto_arquivo_fk1 FOREIGN KEY (recurso_ponto_arquivo_ponto) REFERENCES recurso_ponto (recurso_ponto_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_recurso_ponto;

CREATE TABLE baseline_recurso_ponto (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
  recurso_ponto_id INTEGER(100) UNSIGNED NOT NULL,
  recurso_ponto_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_ponto_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_ponto_evento INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_ponto_insercao TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  recurso_ponto_inicio DATETIME,
  recurso_ponto_fim DATETIME,
  recurso_ponto_duracao DECIMAL(20,5) UNSIGNED DEFAULT 0,
  recurso_ponto_aprovou INTEGER(100)UNSIGNED DEFAULT NULL,
  recurso_ponto_aprovado TINYINT(1) DEFAULT NULL,
  recurso_ponto_data DATETIME,
  recurso_ponto_quantidade DECIMAL(20,5) UNSIGNED DEFAULT 0.000,
	recurso_ponto_valor_hora DECIMAL(20,5) UNSIGNED DEFAULT 0,
	recurso_ponto_empenhado DECIMAL(20,5) UNSIGNED DEFAULT 0,
	recurso_ponto_liquidado DECIMAL(20,5) UNSIGNED DEFAULT 0,
	recurso_ponto_pago DECIMAL(20,5) UNSIGNED DEFAULT 0,
  recurso_ponto_percentual INTEGER UNSIGNED NULL DEFAULT 100,
  recurso_ponto_custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
	recurso_ponto_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
	recurso_ponto_cotacao DECIMAL(6,5) UNSIGNED DEFAULT 1.00000,
	recurso_ponto_data_moeda DATE DEFAULT NULL,
	recurso_ponto_codigo VARCHAR(255) DEFAULT NULL,
	recurso_ponto_fonte VARCHAR(255) DEFAULT NULL,
	recurso_ponto_regiao VARCHAR(255) DEFAULT NULL,
	recurso_ponto_bdi DECIMAL(20,5) UNSIGNED DEFAULT 0,
	recurso_ponto_nd VARCHAR(11) DEFAULT NULL,
  recurso_ponto_categoria_economica VARCHAR(1) DEFAULT NULL,
  recurso_ponto_grupo_despesa VARCHAR(1) DEFAULT NULL,
  recurso_ponto_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  recurso_ponto_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	recurso_ponto_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
	recurso_ponto_obs MEDIUMTEXT,
	recurso_ponto_corrido TINYINT(1) NOT NULL DEFAULT 0,
  recurso_ponto_ordem INT(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (baseline_id, recurso_ponto_id),
  KEY baseline_id (baseline_id),
  KEY recurso_ponto_id (recurso_ponto_id),
  CONSTRAINT baseline_recurso_ponto_fk FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_recurso_ponto_gasto;

CREATE TABLE baseline_recurso_ponto_gasto (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
  recurso_ponto_gasto_id INTEGER(100) UNSIGNED NOT NULL,
  recurso_ponto_gasto_ponto INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_ponto_gasto_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_ponto_gasto_tipo INTEGER(100) UNSIGNED DEFAULT 1,
  recurso_ponto_gasto_nome VARCHAR(255) DEFAULT NULL,
  recurso_ponto_gasto_codigo VARCHAR(255) DEFAULT NULL,
	recurso_ponto_gasto_fonte VARCHAR(255) DEFAULT NULL,
	recurso_ponto_gasto_regiao VARCHAR(255) DEFAULT NULL,
	recurso_ponto_gasto_bdi DECIMAL(20,5) UNSIGNED DEFAULT 0,
	recurso_ponto_gasto_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
	recurso_ponto_gasto_cotacao DECIMAL(6,5) UNSIGNED DEFAULT 1.00000,
	recurso_ponto_gasto_data_moeda DATE DEFAULT NULL, 	
  recurso_ponto_gasto_data DATETIME DEFAULT NULL,
  recurso_ponto_gasto_quantidade DECIMAL(20,5) UNSIGNED DEFAULT 0,
  recurso_ponto_gasto_gasto DECIMAL(20,5) UNSIGNED DEFAULT 0,
  recurso_ponto_gasto_percentagem TINYINT(4) DEFAULT 0,
  recurso_ponto_gasto_descricao MEDIUMTEXT,
  recurso_ponto_gasto_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_ponto_gasto_nd VARCHAR(11) DEFAULT NULL,
  recurso_ponto_gasto_categoria_economica VARCHAR(1) DEFAULT NULL,
  recurso_ponto_gasto_grupo_despesa VARCHAR(1) DEFAULT NULL,
  recurso_ponto_gasto_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  recurso_ponto_gasto_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	recurso_ponto_gasto_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
  recurso_ponto_gasto_data_limite DATE DEFAULT NULL,
  recurso_ponto_gasto_empenhado DECIMAL(20,5) UNSIGNED DEFAULT 0,
	recurso_ponto_gasto_liquidado DECIMAL(20,5) UNSIGNED DEFAULT 0,
	recurso_ponto_gasto_pago DECIMAL(20,5) UNSIGNED DEFAULT 0,
  PRIMARY KEY (baseline_id, recurso_ponto_gasto_id),
  KEY baseline_id (baseline_id),
  KEY recurso_ponto_gasto_id (recurso_ponto_gasto_id),
  CONSTRAINT baseline_recurso_ponto_gasto_fk FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_recurso_ponto_arquivo;

CREATE TABLE baseline_recurso_ponto_arquivo (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
  recurso_ponto_arquivo_id INTEGER(100) UNSIGNED NOT NULL,
  recurso_ponto_arquivo_ponto INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_ponto_arquivo_endereco VARCHAR(150) DEFAULT NULL,
  recurso_ponto_arquivo_data DATETIME DEFAULT NULL,
  recurso_ponto_arquivo_nome VARCHAR(150) DEFAULT NULL,
  recurso_ponto_arquivo_tipo VARCHAR(50) DEFAULT NULL,
  recurso_ponto_arquivo_extensao VARCHAR(50) DEFAULT NULL,
	recurso_ponto_arquivo_nome_real VARCHAR(255) DEFAULT NULL,
	recurso_ponto_arquivo_local VARCHAR(255) DEFAULT NULL,
	recurso_ponto_arquivo_tamanho INTEGER(100) UNSIGNED DEFAULT NULL, 
  recurso_ponto_arquivo_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (baseline_id, recurso_ponto_arquivo_id),
  KEY baseline_id (baseline_id),
  KEY recurso_ponto_arquivo_id (recurso_ponto_arquivo_id),
  CONSTRAINT baseline_recurso_ponto_arquivo_fk FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;




DROP TABLE IF EXISTS painel_odometro_dept;

CREATE TABLE painel_odometro_dept (
  painel_odometro_dept_painel_odometro INTEGER(100) UNSIGNED NOT NULL,
  painel_odometro_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (painel_odometro_dept_painel_odometro, painel_odometro_dept_dept),
  KEY painel_odometro_dept_painel_odometro (painel_odometro_dept_painel_odometro),
  KEY painel_odometro_dept_dept (painel_odometro_dept_dept),
  CONSTRAINT painel_odometro_dept_dept FOREIGN KEY (painel_odometro_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT painel_odometro_dept_painel_odometro FOREIGN KEY (painel_odometro_dept_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS painel_odometro_usuario;

CREATE TABLE painel_odometro_usuario (
  painel_odometro_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
  painel_odometro_usuario_painel_odometro INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (painel_odometro_usuario_usuario, painel_odometro_usuario_painel_odometro),
  KEY painel_odometro_usuario_usuario (painel_odometro_usuario_usuario),
  KEY painel_odometro_usuario_painel_odometro (painel_odometro_usuario_painel_odometro),
  CONSTRAINT painel_odometro_usuario_fk FOREIGN KEY (painel_odometro_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT painel_odometro_usuario_fk1 FOREIGN KEY (painel_odometro_usuario_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS painel_dept;

CREATE TABLE painel_dept (
  painel_dept_painel INTEGER(100) UNSIGNED NOT NULL,
  painel_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (painel_dept_painel, painel_dept_dept),
  KEY painel_dept_painel (painel_dept_painel),
  KEY painel_dept_dept (painel_dept_dept),
  CONSTRAINT painel_dept_dept FOREIGN KEY (painel_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT painel_dept_painel FOREIGN KEY (painel_dept_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS painel_usuario;

CREATE TABLE painel_usuario (
  painel_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
  painel_usuario_painel INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (painel_usuario_usuario, painel_usuario_painel),
  KEY painel_usuario_usuario (painel_usuario_usuario),
  KEY painel_usuario_painel (painel_usuario_painel),
  CONSTRAINT painel_usuario_fk FOREIGN KEY (painel_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT painel_usuario_fk1 FOREIGN KEY (painel_usuario_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS painel_indicador;

CREATE TABLE painel_indicador (
	painel_indicador_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  painel_indicador_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  painel_indicador_painel INTEGER(100) UNSIGNED DEFAULT NULL,
  painel_indicador_deslocar INTEGER(100) DEFAULT NULL,
  painel_indicador_tipo_deslocamento VARCHAR(1) DEFAULT NULL,
  painel_indicador_y_direita TINYINT(1) DEFAULT 0,
  painel_indicador_meta TINYINT(1) DEFAULT 0,
  painel_indicador_meta_faixas TINYINT(1) DEFAULT 0,
	painel_indicador_referencial TINYINT(1) DEFAULT 0,
	painel_indicador_pontuacao TINYINT(1) DEFAULT 0,
  painel_indicador_legenda VARCHAR(255) DEFAULT NULL,
  painel_indicador_unidade VARCHAR(15)  DEFAULT NULL,
  painel_indicador_unidade_esquerda TINYINT(1) DEFAULT 0,
  painel_indicador_cor VARCHAR(6)  DEFAULT NULL,
  painel_indicador_grafico VARCHAR(15)  DEFAULT 'linha',
  painel_indicador_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (painel_indicador_id),
  KEY painel_indicador_indicador (painel_indicador_indicador),
  KEY painel_indicador_painel (painel_indicador_painel),
  CONSTRAINT painel_indicador_fk FOREIGN KEY (painel_indicador_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT painel_indicador_fk1 FOREIGN KEY (painel_indicador_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS painel_slideshow_dept;

CREATE TABLE painel_slideshow_dept (
  painel_slideshow_dept_painel_slideshow INTEGER(100) UNSIGNED NOT NULL,
  painel_slideshow_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (painel_slideshow_dept_painel_slideshow, painel_slideshow_dept_dept),
  KEY painel_slideshow_dept_painel_slideshow (painel_slideshow_dept_painel_slideshow),
  KEY painel_slideshow_dept_dept (painel_slideshow_dept_dept),
  CONSTRAINT painel_slideshow_dept_dept FOREIGN KEY (painel_slideshow_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT painel_slideshow_dept_painel_slideshow FOREIGN KEY (painel_slideshow_dept_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS painel_slideshow_usuario;

CREATE TABLE painel_slideshow_usuario (
  painel_slideshow_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
  painel_slideshow_usuario_slideshow INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (painel_slideshow_usuario_usuario, painel_slideshow_usuario_slideshow),
  KEY painel_slideshow_usuario_usuario (painel_slideshow_usuario_usuario),
  KEY painel_slideshow_usuario_slideshow (painel_slideshow_usuario_slideshow),
  CONSTRAINT painel_slideshow_usuario_fk FOREIGN KEY (painel_slideshow_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT painel_slideshow_usuario_fk1 FOREIGN KEY (painel_slideshow_usuario_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS painel_slideshow_composicao;

CREATE TABLE painel_slideshow_composicao (
	painel_slideshow_composicao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  painel_slideshow_composicao_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
  painel_slideshow_composicao_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
  painel_slideshow_composicao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (painel_slideshow_composicao_id),
  KEY painel_slideshow_composicao_composicao (painel_slideshow_composicao_composicao),
  KEY painel_slideshow_composicao_slideshow (painel_slideshow_composicao_slideshow),
  CONSTRAINT painel_slideshow_composicao_fk FOREIGN KEY (painel_slideshow_composicao_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT painel_slideshow_composicao_fk1 FOREIGN KEY (painel_slideshow_composicao_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS painel_composicao_dept;

CREATE TABLE painel_composicao_dept (
  painel_composicao_dept_painel_composicao INTEGER(100) UNSIGNED NOT NULL,
  painel_composicao_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (painel_composicao_dept_painel_composicao, painel_composicao_dept_dept),
  KEY painel_composicao_dept_painel_composicao (painel_composicao_dept_painel_composicao),
  KEY painel_composicao_dept_dept (painel_composicao_dept_dept),
  CONSTRAINT painel_composicao_dept_dept FOREIGN KEY (painel_composicao_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT painel_composicao_dept_painel_composicao FOREIGN KEY (painel_composicao_dept_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS painel_composicao_usuario;

CREATE TABLE painel_composicao_usuario (
  painel_composicao_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
  painel_composicao_usuario_painel_composicao INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (painel_composicao_usuario_usuario, painel_composicao_usuario_painel_composicao),
  KEY painel_composicao_usuario_usuario (painel_composicao_usuario_usuario),
  KEY painel_composicao_usuario_painel_composicao (painel_composicao_usuario_painel_composicao),
  CONSTRAINT painel_composicao_usuario_fk FOREIGN KEY (painel_composicao_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT painel_composicao_usuario_fk1 FOREIGN KEY (painel_composicao_usuario_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS painel_composicao_painel;

CREATE TABLE painel_composicao_painel (
	painel_composicao_painel_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  painel_composicao_painel_painel INTEGER(100) UNSIGNED DEFAULT NULL,
  painel_composicao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
  painel_composicao_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
  painel_composicao_painel_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (painel_composicao_painel_id),
  KEY painel_composicao_painel_painel (painel_composicao_painel_painel),
  KEY painel_composicao_painel_composicao (painel_composicao_painel_composicao),
  KEY painel_composicao_odometro (painel_composicao_odometro),
  CONSTRAINT painel_composicao_painel_fk FOREIGN KEY (painel_composicao_painel_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT painel_composicao_painel_fk1 FOREIGN KEY (painel_composicao_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT painel_composicao_painel_fk2 FOREIGN KEY (painel_composicao_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS projeto_stakeholder;

CREATE TABLE projeto_stakeholder (
	projeto_stakeholder_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	projeto_stakeholder_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_stakeholder_contato INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_stakeholder_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_stakeholder_perfil INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_stakeholder_autoridade INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_stakeholder_interesse INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_stakeholder_influencia INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_stakeholder_impacto INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_stakeholder_descricao MEDIUMTEXT,
	projeto_stakeholder_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (projeto_stakeholder_id),
	KEY projeto_stakeholder_projeto (projeto_stakeholder_projeto),
	KEY projeto_stakeholder_contato (projeto_stakeholder_contato),
	CONSTRAINT projeto_stakeholder_fk FOREIGN KEY (projeto_stakeholder_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_stakeholder_fk1 FOREIGN KEY (projeto_stakeholder_contato) REFERENCES contatos (contato_id) ON DELETE CASCADE ON UPDATE CASCADE
	)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS baseline_projeto_stakeholder;

CREATE TABLE baseline_projeto_stakeholder (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	projeto_stakeholder_id INTEGER(100) UNSIGNED NOT NULL,
	projeto_stakeholder_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_stakeholder_contato INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_stakeholder_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_stakeholder_perfil INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_stakeholder_autoridade INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_stakeholder_interesse INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_stakeholder_influencia INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_stakeholder_impacto INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_stakeholder_descricao MEDIUMTEXT,
	projeto_stakeholder_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (baseline_id, projeto_stakeholder_id),
	CONSTRAINT baseline_projeto_stakeholder_fk FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
	)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS menu;

CREATE TABLE menu (
  menu_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  menu_usuario_id INTEGER(100) UNSIGNED DEFAULT NULL,
  menu_descricao varchar(255) DEFAULT NULL,
  PRIMARY KEY (menu_id),
  KEY menu_usuario_id (menu_usuario_id),
  CONSTRAINT menu_fk FOREIGN KEY (menu_usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS menu_item;

CREATE TABLE menu_item (
  menu_item_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  menu_item_chave VARCHAR(255) DEFAULT NULL,
  menu_item_superior_id INTEGER(100) UNSIGNED NOT NULL,
  menu_item_chave_pai VARCHAR(255) DEFAULT NULL,
  menu_item_titulo MEDIUMTEXT,
  menu_item_modulo VARCHAR(64) DEFAULT NULL,
  menu_item_parametros TEXT,
  menu_item_menu_id INTEGER(100) UNSIGNED DEFAULT NULL,
  menu_item_tipo VARCHAR(30) DEFAULT 'button',
  menu_item_acao TINYINT(4) NOT NULL DEFAULT 0,
  menu_item_tip MEDIUMTEXT,
  menu_item_smodulo VARCHAR(64) DEFAULT NULL,
  menu_item_permissao INTEGER(100) UNSIGNED DEFAULT 0,
  menu_item_icone MEDIUMTEXT,
  menu_item_icone_classe MEDIUMTEXT,
  menu_item_script TEXT,
  menu_item_index INTEGER(100) UNSIGNED DEFAULT 0,
  menu_item_permissao_extra MEDIUMTEXT,
  PRIMARY KEY (menu_item_id),
  KEY menu_item_menu_id (menu_item_menu_id),
  CONSTRAINT menu_item_fk FOREIGN KEY (menu_item_menu_id) REFERENCES menu (menu_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS grafico;
CREATE TABLE grafico (
  grafico_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  grafico_nome varchar(255) NOT NULL,
  grafico_area varchar(30) NOT NULL,
  grafico_usuario_id INTEGER(100) UNSIGNED DEFAULT NULL,
  grafico_tipo varchar(20) NOT NULL,
  grafico_raio varchar(30) DEFAULT NULL,
  grafico_tipo_label tinyint(4) DEFAULT 0,
  grafico_periodo tinyint(4) DEFAULT 0,
  grafico_mostrar_valores char(1) DEFAULT 0,
  PRIMARY KEY (grafico_id),
  KEY grafico_usuarios_fk_idx (grafico_usuario_id),
  CONSTRAINT grafico_usuarios_fk FOREIGN KEY (grafico_usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS grafico_campo;
CREATE TABLE grafico_campo (
  grafico_campo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  grafico_campo_grafico_id INTEGER(100) UNSIGNED NOT NULL,
  grafico_campo_tipo varchar(30) NOT NULL,
  grafico_campo_cor varchar(6) DEFAULT NULL,
  grafico_campo_texto varchar(255) DEFAULT NULL,
  PRIMARY KEY (grafico_campo_id),
  KEY grafico_campo_grafico_fk_idx (grafico_campo_grafico_id),
  CONSTRAINT grafico_campo_grafico_fk FOREIGN KEY (grafico_campo_grafico_id) REFERENCES grafico (grafico_id) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS evento_compartilhamento;
CREATE TABLE evento_compartilhamento (
  comp_id int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  comp_chave varchar(50) NOT NULL,
  comp_nome varchar(255) NOT NULL,
  comp_descricao varchar(255) DEFAULT NULL,
  comp_evento_acessos int(10) UNSIGNED DEFAULT '0',
  comp_evento_objetos int(10) UNSIGNED DEFAULT '0',
  comp_tarefa_acessos int(10) UNSIGNED DEFAULT '0',
  comp_tarefa_relacoes int(10) UNSIGNED DEFAULT '0',
  comp_ativo tinyint(1) DEFAULT '1',
  PRIMARY KEY (comp_id),
  UNIQUE KEY comp_chave_UNIQUE (comp_chave),
  KEY comp_evento_usuario_fk_idx (usuario_id),
  CONSTRAINT comp_evento_usuario_fk FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS tarefa_designado_periodos;
CREATE TABLE tarefa_designado_periodos (
  periodo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  tarefa_id INTEGER(100) UNSIGNED NOT NULL,
  inicio DATETIME NOT NULL,
  fim DATETIME NOT NULL,
  percentual DECIMAL(10,3) DEFAULT '100.000',
  PRIMARY KEY (periodo_id),
  KEY tarefa_designado_periodo_usuario_fk_idx (usuario_id),
  KEY tarefa_designado_periodo_tarefa_fk_idx (tarefa_id),
  CONSTRAINT tarefa_designado_periodo_tarefa_fk FOREIGN KEY (tarefa_id) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tarefa_designado_periodo_usuario_fk FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS baseline_tarefa_designado_periodos;
CREATE TABLE baseline_tarefa_designado_periodos (
  baseline_id INTEGER(100) UNSIGNED NOT NULL,
  periodo_id INTEGER(100) UNSIGNED NOT NULL,
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  tarefa_id INTEGER(100) UNSIGNED NOT NULL,
  inicio DATETIME NOT NULL,
  fim DATETIME NOT NULL,
  percentual DECIMAL(10,3) DEFAULT '100.000',
  PRIMARY KEY (baseline_id, periodo_id),
  CONSTRAINT baseline_tarefa_designado_periodos_fk FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS problema_gestao;

CREATE TABLE problema_gestao (
	problema_gestao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	problema_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY problema_gestao_id (problema_gestao_id),
	KEY problema_gestao_problema (problema_gestao_problema),
	KEY problema_gestao_semelhante (problema_gestao_semelhante),
	KEY problema_gestao_projeto (problema_gestao_projeto),
	KEY problema_gestao_tarefa (problema_gestao_tarefa),
	KEY problema_gestao_perspectiva (problema_gestao_perspectiva),
	KEY problema_gestao_tema (problema_gestao_tema),
	KEY problema_gestao_objetivo (problema_gestao_objetivo),
	KEY problema_gestao_estrategia (problema_gestao_estrategia),
	KEY problema_gestao_meta (problema_gestao_meta),
	KEY problema_gestao_fator (problema_gestao_fator),
	KEY problema_gestao_pratica (problema_gestao_pratica),
	KEY problema_gestao_indicador (problema_gestao_indicador),
	KEY problema_gestao_acao (problema_gestao_acao),
	KEY problema_gestao_canvas (problema_gestao_canvas),
	KEY problema_gestao_risco (problema_gestao_risco),
	KEY problema_gestao_risco_resposta (problema_gestao_risco_resposta),
	KEY problema_gestao_calendario (problema_gestao_calendario),
	KEY problema_gestao_monitoramento (problema_gestao_monitoramento),
	KEY problema_gestao_ata (problema_gestao_ata),
	KEY problema_gestao_instrumento (problema_gestao_instrumento),
	KEY problema_gestao_recurso (problema_gestao_recurso),
	KEY problema_gestao_demanda (problema_gestao_demanda),
	KEY problema_gestao_programa (problema_gestao_programa),
	KEY problema_gestao_licao (problema_gestao_licao),
	KEY problema_gestao_evento (problema_gestao_evento),
	KEY problema_gestao_link (problema_gestao_link),
	KEY problema_gestao_avaliacao (problema_gestao_avaliacao),
	KEY problema_gestao_tgn (problema_gestao_tgn),
	KEY problema_gestao_brainstorm (problema_gestao_brainstorm),
	KEY problema_gestao_gut (problema_gestao_gut),
	KEY problema_gestao_causa_efeito (problema_gestao_causa_efeito),
	KEY problema_gestao_arquivo (problema_gestao_arquivo),
	KEY problema_gestao_forum (problema_gestao_forum),
	KEY problema_gestao_checklist (problema_gestao_checklist),
	KEY problema_gestao_agenda (problema_gestao_agenda),
	KEY problema_gestao_operativo (problema_gestao_operativo),
	KEY problema_gestao_agrupamento (problema_gestao_agrupamento),
	KEY problema_gestao_patrocinador (problema_gestao_patrocinador),
	KEY problema_gestao_mswot (problema_gestao_mswot),
	KEY problema_gestao_swot (problema_gestao_swot),
	KEY problema_gestao_template (problema_gestao_template),
	KEY problema_gestao_painel (problema_gestao_painel),
	KEY problema_gestao_painel_odometro (problema_gestao_painel_odometro),
	KEY problema_gestao_painel_composicao (problema_gestao_painel_composicao),
	KEY problema_gestao_tr (problema_gestao_tr),
	KEY problema_gestao_me (problema_gestao_me),
	KEY problema_gestao_acao_item (problema_gestao_acao_item),
	KEY problema_gestao_beneficio (problema_gestao_beneficio),
	KEY problema_gestao_painel_slideshow (problema_gestao_painel_slideshow),
	KEY problema_gestao_projeto_viabilidade (problema_gestao_projeto_viabilidade),
	KEY problema_gestao_projeto_abertura (problema_gestao_projeto_abertura),
	KEY problema_gestao_plano_gestao (problema_gestao_plano_gestao),
	CONSTRAINT problema_gestao_problema FOREIGN KEY (problema_gestao_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_semelhante FOREIGN KEY (problema_gestao_semelhante) REFERENCES problema (problema_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_projeto FOREIGN KEY (problema_gestao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_tarefa FOREIGN KEY (problema_gestao_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_perspectiva FOREIGN KEY (problema_gestao_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_tema FOREIGN KEY (problema_gestao_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_objetivo FOREIGN KEY (problema_gestao_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_fator FOREIGN KEY (problema_gestao_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_estrategia FOREIGN KEY (problema_gestao_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_meta FOREIGN KEY (problema_gestao_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_pratica FOREIGN KEY (problema_gestao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_indicador FOREIGN KEY (problema_gestao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_acao FOREIGN KEY (problema_gestao_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_canvas FOREIGN KEY (problema_gestao_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_risco FOREIGN KEY (problema_gestao_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_risco_resposta FOREIGN KEY (problema_gestao_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_calendario FOREIGN KEY (problema_gestao_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_monitoramento FOREIGN KEY (problema_gestao_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_ata FOREIGN KEY (problema_gestao_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_instrumento FOREIGN KEY (problema_gestao_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_recurso FOREIGN KEY (problema_gestao_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_demanda FOREIGN KEY (problema_gestao_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_programa FOREIGN KEY (problema_gestao_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_licao FOREIGN KEY (problema_gestao_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_evento FOREIGN KEY (problema_gestao_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_link FOREIGN KEY (problema_gestao_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_avaliacao FOREIGN KEY (problema_gestao_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_tgn FOREIGN KEY (problema_gestao_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_brainstorm FOREIGN KEY (problema_gestao_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_gut FOREIGN KEY (problema_gestao_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_causa_efeito FOREIGN KEY (problema_gestao_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_arquivo FOREIGN KEY (problema_gestao_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_forum FOREIGN KEY (problema_gestao_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_checklist FOREIGN KEY (problema_gestao_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_agenda FOREIGN KEY (problema_gestao_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_operativo FOREIGN KEY (problema_gestao_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_agrupamento FOREIGN KEY (problema_gestao_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_patrocinador FOREIGN KEY (problema_gestao_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_mswot FOREIGN KEY (problema_gestao_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_swot FOREIGN KEY (problema_gestao_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_template FOREIGN KEY (problema_gestao_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_painel FOREIGN KEY (problema_gestao_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_painel_odometro FOREIGN KEY (problema_gestao_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_painel_composicao FOREIGN KEY (problema_gestao_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_tr FOREIGN KEY (problema_gestao_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_me FOREIGN KEY (problema_gestao_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_acao_item FOREIGN KEY (problema_gestao_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_beneficio FOREIGN KEY (problema_gestao_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_painel_slideshow FOREIGN KEY (problema_gestao_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_projeto_viabilidade FOREIGN KEY (problema_gestao_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_projeto_abertura FOREIGN KEY (problema_gestao_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_plano_gestao FOREIGN KEY (problema_gestao_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS msg_gestao;

CREATE TABLE msg_gestao (
	msg_gestao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	msg_gestao_msg INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY msg_gestao_id (msg_gestao_id),
	KEY msg_gestao_msg (msg_gestao_msg),
	KEY msg_gestao_semelhante (msg_gestao_semelhante),
	KEY msg_gestao_projeto (msg_gestao_projeto),
	KEY msg_gestao_tarefa (msg_gestao_tarefa),
	KEY msg_gestao_perspectiva (msg_gestao_perspectiva),
	KEY msg_gestao_tema (msg_gestao_tema),
	KEY msg_gestao_objetivo (msg_gestao_objetivo),
	KEY msg_gestao_estrategia (msg_gestao_estrategia),
	KEY msg_gestao_meta (msg_gestao_meta),
	KEY msg_gestao_fator (msg_gestao_fator),
	KEY msg_gestao_pratica (msg_gestao_pratica),
	KEY msg_gestao_indicador (msg_gestao_indicador),
	KEY msg_gestao_acao (msg_gestao_acao),
	KEY msg_gestao_canvas (msg_gestao_canvas),
	KEY msg_gestao_risco (msg_gestao_risco),
	KEY msg_gestao_risco_resposta (msg_gestao_risco_resposta),
	KEY msg_gestao_calendario (msg_gestao_calendario),
	KEY msg_gestao_monitoramento (msg_gestao_monitoramento),
	KEY msg_gestao_ata (msg_gestao_ata),
	KEY msg_gestao_mswot(msg_gestao_mswot),
	KEY msg_gestao_swot(msg_gestao_swot),
	KEY msg_gestao_operativo(msg_gestao_operativo),
	KEY msg_gestao_instrumento (msg_gestao_instrumento),
	KEY msg_gestao_recurso (msg_gestao_recurso),
	KEY msg_gestao_problema (msg_gestao_problema),
	KEY msg_gestao_demanda (msg_gestao_demanda),
	KEY msg_gestao_programa (msg_gestao_programa),
	KEY msg_gestao_licao (msg_gestao_licao),
	KEY msg_gestao_evento (msg_gestao_evento),
	KEY msg_gestao_link (msg_gestao_link),
	KEY msg_gestao_avaliacao (msg_gestao_avaliacao),
	KEY msg_gestao_tgn (msg_gestao_tgn),
	KEY msg_gestao_brainstorm (msg_gestao_brainstorm),
	KEY msg_gestao_gut (msg_gestao_gut),
	KEY msg_gestao_causa_efeito (msg_gestao_causa_efeito),
	KEY msg_gestao_arquivo (msg_gestao_arquivo),
	KEY msg_gestao_forum (msg_gestao_forum),
	KEY msg_gestao_checklist (msg_gestao_checklist),
	KEY msg_gestao_agenda (msg_gestao_agenda),
	KEY msg_gestao_agrupamento (msg_gestao_agrupamento),
	KEY msg_gestao_patrocinador (msg_gestao_patrocinador),
	KEY msg_gestao_template (msg_gestao_template),
	KEY msg_gestao_painel (msg_gestao_painel),
	KEY msg_gestao_painel_odometro (msg_gestao_painel_odometro),
	KEY msg_gestao_painel_composicao (msg_gestao_painel_composicao),
	KEY msg_gestao_tr (msg_gestao_tr),
	KEY msg_gestao_me (msg_gestao_me),
	KEY msg_gestao_acao_item (msg_gestao_acao_item),
	KEY msg_gestao_beneficio (msg_gestao_beneficio),
	KEY msg_gestao_painel_slideshow (msg_gestao_painel_slideshow),
	KEY msg_gestao_projeto_viabilidade (msg_gestao_projeto_viabilidade),
	KEY msg_gestao_projeto_abertura (msg_gestao_projeto_abertura),
	KEY msg_gestao_plano_gestao (msg_gestao_plano_gestao),
	CONSTRAINT msg_gestao_msg FOREIGN KEY (msg_gestao_msg) REFERENCES msg (msg_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_semelhante FOREIGN KEY (msg_gestao_semelhante) REFERENCES msg (msg_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_projeto FOREIGN KEY (msg_gestao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_tarefa FOREIGN KEY (msg_gestao_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_perspectiva FOREIGN KEY (msg_gestao_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_tema FOREIGN KEY (msg_gestao_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_objetivo FOREIGN KEY (msg_gestao_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_fator FOREIGN KEY (msg_gestao_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_estrategia FOREIGN KEY (msg_gestao_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_meta FOREIGN KEY (msg_gestao_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_pratica FOREIGN KEY (msg_gestao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_indicador FOREIGN KEY (msg_gestao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_acao FOREIGN KEY (msg_gestao_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_canvas FOREIGN KEY (msg_gestao_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_risco FOREIGN KEY (msg_gestao_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_risco_resposta FOREIGN KEY (msg_gestao_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_calendario FOREIGN KEY (msg_gestao_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_monitoramento FOREIGN KEY (msg_gestao_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_ata FOREIGN KEY (msg_gestao_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_mswot FOREIGN KEY (msg_gestao_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_swot FOREIGN KEY (msg_gestao_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_operativo FOREIGN KEY (msg_gestao_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_instrumento FOREIGN KEY (msg_gestao_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_recurso FOREIGN KEY (msg_gestao_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_problema FOREIGN KEY (msg_gestao_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_demanda FOREIGN KEY (msg_gestao_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_programa FOREIGN KEY (msg_gestao_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_licao FOREIGN KEY (msg_gestao_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_evento FOREIGN KEY (msg_gestao_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_link FOREIGN KEY (msg_gestao_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_avaliacao FOREIGN KEY (msg_gestao_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_tgn FOREIGN KEY (msg_gestao_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_brainstorm FOREIGN KEY (msg_gestao_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_gut FOREIGN KEY (msg_gestao_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_causa_efeito FOREIGN KEY (msg_gestao_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_arquivo FOREIGN KEY (msg_gestao_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_forum FOREIGN KEY (msg_gestao_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_checklist FOREIGN KEY (msg_gestao_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_agenda FOREIGN KEY (msg_gestao_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_agrupamento FOREIGN KEY (msg_gestao_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_patrocinador FOREIGN KEY (msg_gestao_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_template FOREIGN KEY (msg_gestao_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_painel FOREIGN KEY (msg_gestao_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_painel_odometro FOREIGN KEY (msg_gestao_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_painel_composicao FOREIGN KEY (msg_gestao_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_tr FOREIGN KEY (msg_gestao_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_me FOREIGN KEY (msg_gestao_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_acao_item FOREIGN KEY (msg_gestao_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_beneficio FOREIGN KEY (msg_gestao_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_painel_slideshow FOREIGN KEY (msg_gestao_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_projeto_viabilidade FOREIGN KEY (msg_gestao_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_projeto_abertura FOREIGN KEY (msg_gestao_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT msg_gestao_plano_gestao FOREIGN KEY (msg_gestao_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS licao_gestao;

CREATE TABLE licao_gestao (
	licao_gestao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	licao_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	licao_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY licao_gestao_id (licao_gestao_id),
	KEY licao_gestao_licao (licao_gestao_licao),
	KEY licao_gestao_semelhante (licao_gestao_semelhante),
	KEY licao_gestao_projeto (licao_gestao_projeto),
	KEY licao_gestao_tarefa (licao_gestao_tarefa),
	KEY licao_gestao_perspectiva (licao_gestao_perspectiva),
	KEY licao_gestao_tema (licao_gestao_tema),
	KEY licao_gestao_objetivo (licao_gestao_objetivo),
	KEY licao_gestao_estrategia (licao_gestao_estrategia),
	KEY licao_gestao_meta (licao_gestao_meta),
	KEY licao_gestao_fator (licao_gestao_fator),
	KEY licao_gestao_pratica (licao_gestao_pratica),
	KEY licao_gestao_indicador (licao_gestao_indicador),
	KEY licao_gestao_acao (licao_gestao_acao),
	KEY licao_gestao_canvas (licao_gestao_canvas),
	KEY licao_gestao_risco (licao_gestao_risco),
	KEY licao_gestao_risco_resposta (licao_gestao_risco_resposta),
	KEY licao_gestao_calendario (licao_gestao_calendario),
	KEY licao_gestao_monitoramento (licao_gestao_monitoramento),
	KEY licao_gestao_ata (licao_gestao_ata),
	KEY licao_gestao_mswot(licao_gestao_mswot),
	KEY licao_gestao_swot(licao_gestao_swot),
	KEY licao_gestao_operativo(licao_gestao_operativo),
	KEY licao_gestao_instrumento (licao_gestao_instrumento),
	KEY licao_gestao_recurso (licao_gestao_recurso),
	KEY licao_gestao_problema (licao_gestao_problema),
	KEY licao_gestao_demanda (licao_gestao_demanda),
	KEY licao_gestao_programa (licao_gestao_programa),
	KEY licao_gestao_evento (licao_gestao_evento),
	KEY licao_gestao_link (licao_gestao_link),
	KEY licao_gestao_avaliacao (licao_gestao_avaliacao),
	KEY licao_gestao_tgn (licao_gestao_tgn),
	KEY licao_gestao_brainstorm (licao_gestao_brainstorm),
	KEY licao_gestao_gut (licao_gestao_gut),
	KEY licao_gestao_causa_efeito (licao_gestao_causa_efeito),
	KEY licao_gestao_arquivo (licao_gestao_arquivo),
	KEY licao_gestao_forum (licao_gestao_forum),
	KEY licao_gestao_checklist (licao_gestao_checklist),
	KEY licao_gestao_agenda (licao_gestao_agenda),
	KEY licao_gestao_agrupamento (licao_gestao_agrupamento),
	KEY licao_gestao_patrocinador (licao_gestao_patrocinador),
	KEY licao_gestao_template (licao_gestao_template),
	KEY licao_gestao_painel (licao_gestao_painel),
	KEY licao_gestao_painel_odometro (licao_gestao_painel_odometro),
	KEY licao_gestao_painel_composicao (licao_gestao_painel_composicao),
	KEY licao_gestao_tr (licao_gestao_tr),
	KEY licao_gestao_me (licao_gestao_me),
	KEY licao_gestao_acao_item (licao_gestao_acao_item),
	KEY licao_gestao_beneficio (licao_gestao_beneficio),
	KEY licao_gestao_painel_slideshow (licao_gestao_painel_slideshow),
	KEY licao_gestao_projeto_viabilidade (licao_gestao_projeto_viabilidade),
	KEY licao_gestao_projeto_abertura (licao_gestao_projeto_abertura),
	KEY licao_gestao_plano_gestao (licao_gestao_plano_gestao),
	CONSTRAINT licao_gestao_licao FOREIGN KEY (licao_gestao_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_semelhante FOREIGN KEY (licao_gestao_semelhante) REFERENCES licao (licao_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_projeto FOREIGN KEY (licao_gestao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_tarefa FOREIGN KEY (licao_gestao_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_perspectiva FOREIGN KEY (licao_gestao_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_tema FOREIGN KEY (licao_gestao_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_objetivo FOREIGN KEY (licao_gestao_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_fator FOREIGN KEY (licao_gestao_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_estrategia FOREIGN KEY (licao_gestao_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_meta FOREIGN KEY (licao_gestao_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_pratica FOREIGN KEY (licao_gestao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_indicador FOREIGN KEY (licao_gestao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_acao FOREIGN KEY (licao_gestao_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_canvas FOREIGN KEY (licao_gestao_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_risco FOREIGN KEY (licao_gestao_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_risco_resposta FOREIGN KEY (licao_gestao_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_calendario FOREIGN KEY (licao_gestao_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_monitoramento FOREIGN KEY (licao_gestao_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_ata FOREIGN KEY (licao_gestao_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_mswot FOREIGN KEY (licao_gestao_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_swot FOREIGN KEY (licao_gestao_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_operativo FOREIGN KEY (licao_gestao_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_instrumento FOREIGN KEY (licao_gestao_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_recurso FOREIGN KEY (licao_gestao_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_problema FOREIGN KEY (licao_gestao_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_demanda FOREIGN KEY (licao_gestao_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_programa FOREIGN KEY (licao_gestao_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_evento FOREIGN KEY (licao_gestao_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_link FOREIGN KEY (licao_gestao_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_avaliacao FOREIGN KEY (licao_gestao_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_tgn FOREIGN KEY (licao_gestao_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_brainstorm FOREIGN KEY (licao_gestao_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_gut FOREIGN KEY (licao_gestao_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_causa_efeito FOREIGN KEY (licao_gestao_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_arquivo FOREIGN KEY (licao_gestao_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_forum FOREIGN KEY (licao_gestao_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_checklist FOREIGN KEY (licao_gestao_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_agenda FOREIGN KEY (licao_gestao_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_agrupamento FOREIGN KEY (licao_gestao_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_patrocinador FOREIGN KEY (licao_gestao_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_template FOREIGN KEY (licao_gestao_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_painel FOREIGN KEY (licao_gestao_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_painel_odometro FOREIGN KEY (licao_gestao_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_painel_composicao FOREIGN KEY (licao_gestao_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_tr FOREIGN KEY (licao_gestao_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_me FOREIGN KEY (licao_gestao_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_acao_item FOREIGN KEY (licao_gestao_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_beneficio FOREIGN KEY (licao_gestao_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_painel_slideshow FOREIGN KEY (licao_gestao_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_projeto_viabilidade FOREIGN KEY (licao_gestao_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_projeto_abertura FOREIGN KEY (licao_gestao_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_gestao_plano_gestao FOREIGN KEY (licao_gestao_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS programa_gestao;

CREATE TABLE programa_gestao (
	programa_gestao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	programa_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY programa_gestao_id (programa_gestao_id),
	KEY programa_gestao_programa (programa_gestao_programa),
	KEY programa_gestao_semelhante (programa_gestao_semelhante),
	KEY programa_gestao_projeto (programa_gestao_projeto),
	KEY programa_gestao_tarefa (programa_gestao_tarefa),
	KEY programa_gestao_perspectiva (programa_gestao_perspectiva),
	KEY programa_gestao_tema (programa_gestao_tema),
	KEY programa_gestao_objetivo (programa_gestao_objetivo),
	KEY programa_gestao_estrategia (programa_gestao_estrategia),
	KEY programa_gestao_meta (programa_gestao_meta),
	KEY programa_gestao_fator (programa_gestao_fator),
	KEY programa_gestao_pratica (programa_gestao_pratica),
	KEY programa_gestao_indicador (programa_gestao_indicador),
	KEY programa_gestao_acao (programa_gestao_acao),
	KEY programa_gestao_canvas (programa_gestao_canvas),
	KEY programa_gestao_risco (programa_gestao_risco),
	KEY programa_gestao_risco_resposta (programa_gestao_risco_resposta),
	KEY programa_gestao_calendario (programa_gestao_calendario),
	KEY programa_gestao_monitoramento (programa_gestao_monitoramento),
	KEY programa_gestao_ata (programa_gestao_ata),
	KEY programa_gestao_mswot(programa_gestao_mswot),
	KEY programa_gestao_swot(programa_gestao_swot),
	KEY programa_gestao_operativo(programa_gestao_operativo),
	KEY programa_gestao_instrumento (programa_gestao_instrumento),
	KEY programa_gestao_recurso (programa_gestao_recurso),
	KEY programa_gestao_problema (programa_gestao_problema),
	KEY programa_gestao_demanda (programa_gestao_demanda),
	KEY programa_gestao_licao (programa_gestao_licao),
	KEY programa_gestao_evento (programa_gestao_evento),
	KEY programa_gestao_link (programa_gestao_link),
	KEY programa_gestao_avaliacao (programa_gestao_avaliacao),
	KEY programa_gestao_tgn (programa_gestao_tgn),
	KEY programa_gestao_brainstorm (programa_gestao_brainstorm),
	KEY programa_gestao_gut (programa_gestao_gut),
	KEY programa_gestao_causa_efeito (programa_gestao_causa_efeito),
	KEY programa_gestao_arquivo (programa_gestao_arquivo),
	KEY programa_gestao_forum (programa_gestao_forum),
	KEY programa_gestao_checklist (programa_gestao_checklist),
	KEY programa_gestao_agenda (programa_gestao_agenda),
	KEY programa_gestao_agrupamento (programa_gestao_agrupamento),
	KEY programa_gestao_patrocinador (programa_gestao_patrocinador),
	KEY programa_gestao_template (programa_gestao_template),
	KEY programa_gestao_painel (programa_gestao_painel),
	KEY programa_gestao_painel_odometro (programa_gestao_painel_odometro),
	KEY programa_gestao_painel_composicao (programa_gestao_painel_composicao),
	KEY programa_gestao_tr (programa_gestao_tr),
	KEY programa_gestao_me (programa_gestao_me),
	KEY programa_gestao_acao_item (programa_gestao_acao_item),
	KEY programa_gestao_beneficio (programa_gestao_beneficio),
	KEY programa_gestao_painel_slideshow (programa_gestao_painel_slideshow),
	KEY programa_gestao_projeto_viabilidade (programa_gestao_projeto_viabilidade),
	KEY programa_gestao_projeto_abertura (programa_gestao_projeto_abertura),
	KEY programa_gestao_plano_gestao (programa_gestao_plano_gestao),
	CONSTRAINT programa_gestao_programa FOREIGN KEY (programa_gestao_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_semelhante FOREIGN KEY (programa_gestao_semelhante) REFERENCES programa (programa_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_projeto FOREIGN KEY (programa_gestao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_tarefa FOREIGN KEY (programa_gestao_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_perspectiva FOREIGN KEY (programa_gestao_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_tema FOREIGN KEY (programa_gestao_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_objetivo FOREIGN KEY (programa_gestao_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_fator FOREIGN KEY (programa_gestao_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_estrategia FOREIGN KEY (programa_gestao_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_meta FOREIGN KEY (programa_gestao_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_pratica FOREIGN KEY (programa_gestao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_indicador FOREIGN KEY (programa_gestao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_acao FOREIGN KEY (programa_gestao_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_canvas FOREIGN KEY (programa_gestao_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_risco FOREIGN KEY (programa_gestao_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_risco_resposta FOREIGN KEY (programa_gestao_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_calendario FOREIGN KEY (programa_gestao_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_monitoramento FOREIGN KEY (programa_gestao_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_ata FOREIGN KEY (programa_gestao_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_mswot FOREIGN KEY (programa_gestao_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_swot FOREIGN KEY (programa_gestao_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_operativo FOREIGN KEY (programa_gestao_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_instrumento FOREIGN KEY (programa_gestao_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_recurso FOREIGN KEY (programa_gestao_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_problema FOREIGN KEY (programa_gestao_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_demanda FOREIGN KEY (programa_gestao_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_licao FOREIGN KEY (programa_gestao_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_evento FOREIGN KEY (programa_gestao_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_link FOREIGN KEY (programa_gestao_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_avaliacao FOREIGN KEY (programa_gestao_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_tgn FOREIGN KEY (programa_gestao_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_brainstorm FOREIGN KEY (programa_gestao_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_gut FOREIGN KEY (programa_gestao_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_causa_efeito FOREIGN KEY (programa_gestao_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_arquivo FOREIGN KEY (programa_gestao_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_forum FOREIGN KEY (programa_gestao_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_checklist FOREIGN KEY (programa_gestao_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_agenda FOREIGN KEY (programa_gestao_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_agrupamento FOREIGN KEY (programa_gestao_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_patrocinador FOREIGN KEY (programa_gestao_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_template FOREIGN KEY (programa_gestao_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_painel FOREIGN KEY (programa_gestao_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_painel_odometro FOREIGN KEY (programa_gestao_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_painel_composicao FOREIGN KEY (programa_gestao_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_tr FOREIGN KEY (programa_gestao_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_me FOREIGN KEY (programa_gestao_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_acao_item FOREIGN KEY (programa_gestao_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_beneficio FOREIGN KEY (programa_gestao_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_painel_slideshow FOREIGN KEY (programa_gestao_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_projeto_viabilidade FOREIGN KEY (programa_gestao_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_projeto_abertura FOREIGN KEY (programa_gestao_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_gestao_plano_gestao FOREIGN KEY (programa_gestao_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS ata_gestao;

CREATE TABLE ata_gestao (
	ata_gestao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	ata_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY ata_gestao_id (ata_gestao_id),
	KEY ata_gestao_ata (ata_gestao_ata),
	KEY ata_gestao_semelhante (ata_gestao_semelhante),
	KEY ata_gestao_projeto (ata_gestao_projeto),
	KEY ata_gestao_tarefa (ata_gestao_tarefa),
	KEY ata_gestao_perspectiva (ata_gestao_perspectiva),
	KEY ata_gestao_tema (ata_gestao_tema),
	KEY ata_gestao_objetivo (ata_gestao_objetivo),
	KEY ata_gestao_estrategia (ata_gestao_estrategia),
	KEY ata_gestao_meta (ata_gestao_meta),
	KEY ata_gestao_fator (ata_gestao_fator),
	KEY ata_gestao_pratica (ata_gestao_pratica),
	KEY ata_gestao_indicador (ata_gestao_indicador),
	KEY ata_gestao_acao (ata_gestao_acao),
	KEY ata_gestao_canvas (ata_gestao_canvas),
	KEY ata_gestao_risco (ata_gestao_risco),
	KEY ata_gestao_risco_resposta (ata_gestao_risco_resposta),
	KEY ata_gestao_calendario (ata_gestao_calendario),
	KEY ata_gestao_monitoramento (ata_gestao_monitoramento),
	KEY ata_gestao_mswot(ata_gestao_mswot),
	KEY ata_gestao_swot(ata_gestao_swot),
	KEY ata_gestao_operativo(ata_gestao_operativo),
	KEY ata_gestao_instrumento (ata_gestao_instrumento),
	KEY ata_gestao_recurso (ata_gestao_recurso),
	KEY ata_gestao_problema (ata_gestao_problema),
	KEY ata_gestao_demanda (ata_gestao_demanda),
	KEY ata_gestao_programa (ata_gestao_programa),
	KEY ata_gestao_licao (ata_gestao_licao),
	KEY ata_gestao_evento (ata_gestao_evento),
	KEY ata_gestao_link (ata_gestao_link),
	KEY ata_gestao_avaliacao (ata_gestao_avaliacao),
	KEY ata_gestao_tgn (ata_gestao_tgn),
	KEY ata_gestao_brainstorm (ata_gestao_brainstorm),
	KEY ata_gestao_gut (ata_gestao_gut),
	KEY ata_gestao_causa_efeito (ata_gestao_causa_efeito),
	KEY ata_gestao_arquivo (ata_gestao_arquivo),
	KEY ata_gestao_forum (ata_gestao_forum),
	KEY ata_gestao_checklist (ata_gestao_checklist),
	KEY ata_gestao_agenda (ata_gestao_agenda),
	KEY ata_gestao_agrupamento (ata_gestao_agrupamento),
	KEY ata_gestao_patrocinador (ata_gestao_patrocinador),
	KEY ata_gestao_template (ata_gestao_template),
	KEY ata_gestao_painel (ata_gestao_painel),
	KEY ata_gestao_painel_odometro (ata_gestao_painel_odometro),
	KEY ata_gestao_painel_composicao (ata_gestao_painel_composicao),
	KEY ata_gestao_tr (ata_gestao_tr),
	KEY ata_gestao_me (ata_gestao_me),
	KEY ata_gestao_acao_item (ata_gestao_acao_item),
	KEY ata_gestao_beneficio (ata_gestao_beneficio),
	KEY ata_gestao_painel_slideshow (ata_gestao_painel_slideshow),
	KEY ata_gestao_projeto_viabilidade (ata_gestao_projeto_viabilidade),
	KEY ata_gestao_projeto_abertura (ata_gestao_projeto_abertura),
	KEY ata_gestao_plano_gestao (ata_gestao_plano_gestao),
	CONSTRAINT ata_gestao_ata FOREIGN KEY (ata_gestao_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_semelhante FOREIGN KEY (ata_gestao_semelhante) REFERENCES ata (ata_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_projeto FOREIGN KEY (ata_gestao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_tarefa FOREIGN KEY (ata_gestao_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_perspectiva FOREIGN KEY (ata_gestao_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_tema FOREIGN KEY (ata_gestao_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_objetivo FOREIGN KEY (ata_gestao_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_fator FOREIGN KEY (ata_gestao_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_estrategia FOREIGN KEY (ata_gestao_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_meta FOREIGN KEY (ata_gestao_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_pratica FOREIGN KEY (ata_gestao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_indicador FOREIGN KEY (ata_gestao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_acao FOREIGN KEY (ata_gestao_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_canvas FOREIGN KEY (ata_gestao_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_risco FOREIGN KEY (ata_gestao_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_risco_resposta FOREIGN KEY (ata_gestao_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_calendario FOREIGN KEY (ata_gestao_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_monitoramento FOREIGN KEY (ata_gestao_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_mswot FOREIGN KEY (ata_gestao_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_swot FOREIGN KEY (ata_gestao_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_operativo FOREIGN KEY (ata_gestao_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_instrumento FOREIGN KEY (ata_gestao_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_recurso FOREIGN KEY (ata_gestao_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_problema FOREIGN KEY (ata_gestao_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_demanda FOREIGN KEY (ata_gestao_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_programa FOREIGN KEY (ata_gestao_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_licao FOREIGN KEY (ata_gestao_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_evento FOREIGN KEY (ata_gestao_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_link FOREIGN KEY (ata_gestao_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_avaliacao FOREIGN KEY (ata_gestao_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_tgn FOREIGN KEY (ata_gestao_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_brainstorm FOREIGN KEY (ata_gestao_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_gut FOREIGN KEY (ata_gestao_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_causa_efeito FOREIGN KEY (ata_gestao_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_arquivo FOREIGN KEY (ata_gestao_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_forum FOREIGN KEY (ata_gestao_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_checklist FOREIGN KEY (ata_gestao_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_agenda FOREIGN KEY (ata_gestao_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_agrupamento FOREIGN KEY (ata_gestao_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_patrocinador FOREIGN KEY (ata_gestao_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_template FOREIGN KEY (ata_gestao_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_painel FOREIGN KEY (ata_gestao_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_painel_odometro FOREIGN KEY (ata_gestao_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_painel_composicao FOREIGN KEY (ata_gestao_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_tr FOREIGN KEY (ata_gestao_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_me FOREIGN KEY (ata_gestao_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_acao_item FOREIGN KEY (ata_gestao_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_beneficio FOREIGN KEY (ata_gestao_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_painel_slideshow FOREIGN KEY (ata_gestao_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_projeto_viabilidade FOREIGN KEY (ata_gestao_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_projeto_abertura FOREIGN KEY (ata_gestao_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ata_gestao_plano_gestao FOREIGN KEY (ata_gestao_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS pratica_indicador_gestao;

CREATE TABLE pratica_indicador_gestao (
	pratica_indicador_gestao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	pratica_indicador_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY pratica_indicador_gestao_id (pratica_indicador_gestao_id),
	KEY pratica_indicador_gestao_indicador (pratica_indicador_gestao_indicador),
	KEY pratica_indicador_gestao_semelhante (pratica_indicador_gestao_semelhante),
	KEY pratica_indicador_gestao_projeto (pratica_indicador_gestao_projeto),
	KEY pratica_indicador_gestao_tarefa (pratica_indicador_gestao_tarefa),
	KEY pratica_indicador_gestao_perspectiva (pratica_indicador_gestao_perspectiva),
	KEY pratica_indicador_gestao_tema (pratica_indicador_gestao_tema),
	KEY pratica_indicador_gestao_objetivo (pratica_indicador_gestao_objetivo),
	KEY pratica_indicador_gestao_estrategia (pratica_indicador_gestao_estrategia),
	KEY pratica_indicador_gestao_meta (pratica_indicador_gestao_meta),
	KEY pratica_indicador_gestao_fator (pratica_indicador_gestao_fator),
	KEY pratica_indicador_gestao_pratica (pratica_indicador_gestao_pratica),
	KEY pratica_indicador_gestao_acao (pratica_indicador_gestao_acao),
	KEY pratica_indicador_gestao_canvas (pratica_indicador_gestao_canvas),
	KEY pratica_indicador_gestao_risco (pratica_indicador_gestao_risco),
	KEY pratica_indicador_gestao_risco_resposta (pratica_indicador_gestao_risco_resposta),
	KEY pratica_indicador_gestao_calendario (pratica_indicador_gestao_calendario),
	KEY pratica_indicador_gestao_monitoramento (pratica_indicador_gestao_monitoramento),
	KEY pratica_indicador_gestao_ata (pratica_indicador_gestao_ata),
	KEY pratica_indicador_gestao_mswot(pratica_indicador_gestao_mswot),
	KEY pratica_indicador_gestao_swot(pratica_indicador_gestao_swot),
	KEY pratica_indicador_gestao_operativo(pratica_indicador_gestao_operativo),
	KEY pratica_indicador_gestao_instrumento (pratica_indicador_gestao_instrumento),
	KEY pratica_indicador_gestao_recurso (pratica_indicador_gestao_recurso),
	KEY pratica_indicador_gestao_problema (pratica_indicador_gestao_problema),
	KEY pratica_indicador_gestao_demanda (pratica_indicador_gestao_demanda),
	KEY pratica_indicador_gestao_programa (pratica_indicador_gestao_programa),
	KEY pratica_indicador_gestao_licao (pratica_indicador_gestao_licao),
	KEY pratica_indicador_gestao_evento (pratica_indicador_gestao_evento),
	KEY pratica_indicador_gestao_link (pratica_indicador_gestao_link),
	KEY pratica_indicador_gestao_avaliacao (pratica_indicador_gestao_avaliacao),
	KEY pratica_indicador_gestao_tgn (pratica_indicador_gestao_tgn),
	KEY pratica_indicador_gestao_brainstorm (pratica_indicador_gestao_brainstorm),
	KEY pratica_indicador_gestao_gut (pratica_indicador_gestao_gut),
	KEY pratica_indicador_gestao_causa_efeito (pratica_indicador_gestao_causa_efeito),
	KEY pratica_indicador_gestao_arquivo (pratica_indicador_gestao_arquivo),
	KEY pratica_indicador_gestao_forum (pratica_indicador_gestao_forum),
	KEY pratica_indicador_gestao_checklist (pratica_indicador_gestao_checklist),
	KEY pratica_indicador_gestao_agenda (pratica_indicador_gestao_agenda),
	KEY pratica_indicador_gestao_agrupamento (pratica_indicador_gestao_agrupamento),
	KEY pratica_indicador_gestao_patrocinador (pratica_indicador_gestao_patrocinador),
	KEY pratica_indicador_gestao_template (pratica_indicador_gestao_template),
	KEY pratica_indicador_gestao_painel (pratica_indicador_gestao_painel),
	KEY pratica_indicador_gestao_painel_odometro (pratica_indicador_gestao_painel_odometro),
	KEY pratica_indicador_gestao_painel_composicao (pratica_indicador_gestao_painel_composicao),
	KEY pratica_indicador_gestao_tr (pratica_indicador_gestao_tr),
	KEY pratica_indicador_gestao_me (pratica_indicador_gestao_me),
	KEY pratica_indicador_gestao_acao_item (pratica_indicador_gestao_acao_item),
	KEY pratica_indicador_gestao_beneficio (pratica_indicador_gestao_beneficio),
	KEY pratica_indicador_gestao_painel_slideshow (pratica_indicador_gestao_painel_slideshow),
	KEY pratica_indicador_gestao_projeto_viabilidade (pratica_indicador_gestao_projeto_viabilidade),
	KEY pratica_indicador_gestao_projeto_abertura (pratica_indicador_gestao_projeto_abertura),
	KEY pratica_indicador_gestao_plano_gestao (pratica_indicador_gestao_plano_gestao),
	CONSTRAINT pratica_indicador_gestao_indicador FOREIGN KEY (pratica_indicador_gestao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_semelhante FOREIGN KEY (pratica_indicador_gestao_semelhante) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_projeto FOREIGN KEY (pratica_indicador_gestao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_tarefa FOREIGN KEY (pratica_indicador_gestao_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_perspectiva FOREIGN KEY (pratica_indicador_gestao_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_tema FOREIGN KEY (pratica_indicador_gestao_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_objetivo FOREIGN KEY (pratica_indicador_gestao_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_fator FOREIGN KEY (pratica_indicador_gestao_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_estrategia FOREIGN KEY (pratica_indicador_gestao_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_meta FOREIGN KEY (pratica_indicador_gestao_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_pratica FOREIGN KEY (pratica_indicador_gestao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_acao FOREIGN KEY (pratica_indicador_gestao_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_canvas FOREIGN KEY (pratica_indicador_gestao_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_risco FOREIGN KEY (pratica_indicador_gestao_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_risco_resposta FOREIGN KEY (pratica_indicador_gestao_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_calendario FOREIGN KEY (pratica_indicador_gestao_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_monitoramento FOREIGN KEY (pratica_indicador_gestao_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_ata FOREIGN KEY (pratica_indicador_gestao_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_mswot FOREIGN KEY (pratica_indicador_gestao_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_swot FOREIGN KEY (pratica_indicador_gestao_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_operativo FOREIGN KEY (pratica_indicador_gestao_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_instrumento FOREIGN KEY (pratica_indicador_gestao_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_recurso FOREIGN KEY (pratica_indicador_gestao_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_problema FOREIGN KEY (pratica_indicador_gestao_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_demanda FOREIGN KEY (pratica_indicador_gestao_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_programa FOREIGN KEY (pratica_indicador_gestao_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_licao FOREIGN KEY (pratica_indicador_gestao_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_evento FOREIGN KEY (pratica_indicador_gestao_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_link FOREIGN KEY (pratica_indicador_gestao_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_avaliacao FOREIGN KEY (pratica_indicador_gestao_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_tgn FOREIGN KEY (pratica_indicador_gestao_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_brainstorm FOREIGN KEY (pratica_indicador_gestao_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_gut FOREIGN KEY (pratica_indicador_gestao_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_causa_efeito FOREIGN KEY (pratica_indicador_gestao_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_arquivo FOREIGN KEY (pratica_indicador_gestao_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_forum FOREIGN KEY (pratica_indicador_gestao_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_checklist FOREIGN KEY (pratica_indicador_gestao_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_agenda FOREIGN KEY (pratica_indicador_gestao_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_agrupamento FOREIGN KEY (pratica_indicador_gestao_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_patrocinador FOREIGN KEY (pratica_indicador_gestao_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_template FOREIGN KEY (pratica_indicador_gestao_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_painel FOREIGN KEY (pratica_indicador_gestao_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_painel_odometro FOREIGN KEY (pratica_indicador_gestao_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_painel_composicao FOREIGN KEY (pratica_indicador_gestao_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_tr FOREIGN KEY (pratica_indicador_gestao_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_me FOREIGN KEY (pratica_indicador_gestao_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_acao_item FOREIGN KEY (pratica_indicador_gestao_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_beneficio FOREIGN KEY (pratica_indicador_gestao_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_painel_slideshow FOREIGN KEY (pratica_indicador_gestao_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_projeto_viabilidade FOREIGN KEY (pratica_indicador_gestao_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_projeto_abertura FOREIGN KEY (pratica_indicador_gestao_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_gestao_plano_gestao FOREIGN KEY (pratica_indicador_gestao_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS demanda_gestao;

CREATE TABLE demanda_gestao (
	demanda_gestao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	demanda_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY demanda_gestao_id (demanda_gestao_id),
	KEY demanda_gestao_demanda (demanda_gestao_demanda),
	KEY demanda_gestao_semelhante (demanda_gestao_semelhante),
	KEY demanda_gestao_projeto (demanda_gestao_projeto),
	KEY demanda_gestao_tarefa (demanda_gestao_tarefa),
	KEY demanda_gestao_perspectiva (demanda_gestao_perspectiva),
	KEY demanda_gestao_tema (demanda_gestao_tema),
	KEY demanda_gestao_objetivo (demanda_gestao_objetivo),
	KEY demanda_gestao_estrategia (demanda_gestao_estrategia),
	KEY demanda_gestao_meta (demanda_gestao_meta),
	KEY demanda_gestao_fator (demanda_gestao_fator),
	KEY demanda_gestao_pratica (demanda_gestao_pratica),
	KEY demanda_gestao_indicador (demanda_gestao_indicador),
	KEY demanda_gestao_acao (demanda_gestao_acao),
	KEY demanda_gestao_canvas (demanda_gestao_canvas),
	KEY demanda_gestao_risco (demanda_gestao_risco),
	KEY demanda_gestao_risco_resposta (demanda_gestao_risco_resposta),
	KEY demanda_gestao_calendario (demanda_gestao_calendario),
	KEY demanda_gestao_monitoramento (demanda_gestao_monitoramento),
	KEY demanda_gestao_ata (demanda_gestao_ata),
	KEY demanda_gestao_mswot(demanda_gestao_mswot),
	KEY demanda_gestao_swot(demanda_gestao_swot),
	KEY demanda_gestao_operativo(demanda_gestao_operativo),
	KEY demanda_gestao_instrumento (demanda_gestao_instrumento),
	KEY demanda_gestao_recurso (demanda_gestao_recurso),
	KEY demanda_gestao_problema (demanda_gestao_problema),
	KEY demanda_gestao_programa (demanda_gestao_programa),
	KEY demanda_gestao_licao (demanda_gestao_licao),
	KEY demanda_gestao_evento (demanda_gestao_evento),
	KEY demanda_gestao_link (demanda_gestao_link),
	KEY demanda_gestao_avaliacao (demanda_gestao_avaliacao),
	KEY demanda_gestao_tgn (demanda_gestao_tgn),
	KEY demanda_gestao_brainstorm (demanda_gestao_brainstorm),
	KEY demanda_gestao_gut (demanda_gestao_gut),
	KEY demanda_gestao_causa_efeito (demanda_gestao_causa_efeito),
	KEY demanda_gestao_arquivo (demanda_gestao_arquivo),
	KEY demanda_gestao_forum (demanda_gestao_forum),
	KEY demanda_gestao_checklist (demanda_gestao_checklist),
	KEY demanda_gestao_agenda (demanda_gestao_agenda),
	KEY demanda_gestao_agrupamento (demanda_gestao_agrupamento),
	KEY demanda_gestao_patrocinador (demanda_gestao_patrocinador),
	KEY demanda_gestao_template (demanda_gestao_template),
	KEY demanda_gestao_painel (demanda_gestao_painel),
	KEY demanda_gestao_painel_odometro (demanda_gestao_painel_odometro),
	KEY demanda_gestao_painel_composicao (demanda_gestao_painel_composicao),
	KEY demanda_gestao_tr (demanda_gestao_tr),
	KEY demanda_gestao_me (demanda_gestao_me),
	KEY demanda_gestao_acao_item (demanda_gestao_acao_item),
	KEY demanda_gestao_beneficio (demanda_gestao_beneficio),
	KEY demanda_gestao_painel_slideshow (demanda_gestao_painel_slideshow),
	KEY demanda_gestao_projeto_viabilidade (demanda_gestao_projeto_viabilidade),
	KEY demanda_gestao_projeto_abertura (demanda_gestao_projeto_abertura),
	KEY demanda_gestao_plano_gestao (demanda_gestao_plano_gestao),
	CONSTRAINT demanda_gestao_demanda FOREIGN KEY (demanda_gestao_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_semelhante FOREIGN KEY (demanda_gestao_semelhante) REFERENCES demandas (demanda_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_projeto FOREIGN KEY (demanda_gestao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_tarefa FOREIGN KEY (demanda_gestao_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_perspectiva FOREIGN KEY (demanda_gestao_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_tema FOREIGN KEY (demanda_gestao_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_objetivo FOREIGN KEY (demanda_gestao_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_fator FOREIGN KEY (demanda_gestao_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_estrategia FOREIGN KEY (demanda_gestao_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_meta FOREIGN KEY (demanda_gestao_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_pratica FOREIGN KEY (demanda_gestao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_indicador FOREIGN KEY (demanda_gestao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_acao FOREIGN KEY (demanda_gestao_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_canvas FOREIGN KEY (demanda_gestao_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_risco FOREIGN KEY (demanda_gestao_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_risco_resposta FOREIGN KEY (demanda_gestao_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_calendario FOREIGN KEY (demanda_gestao_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_monitoramento FOREIGN KEY (demanda_gestao_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_ata FOREIGN KEY (demanda_gestao_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_mswot FOREIGN KEY (demanda_gestao_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_swot FOREIGN KEY (demanda_gestao_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_operativo FOREIGN KEY (demanda_gestao_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_instrumento FOREIGN KEY (demanda_gestao_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_recurso FOREIGN KEY (demanda_gestao_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_problema FOREIGN KEY (demanda_gestao_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_programa FOREIGN KEY (demanda_gestao_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_licao FOREIGN KEY (demanda_gestao_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_evento FOREIGN KEY (demanda_gestao_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_link FOREIGN KEY (demanda_gestao_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_avaliacao FOREIGN KEY (demanda_gestao_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_tgn FOREIGN KEY (demanda_gestao_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_brainstorm FOREIGN KEY (demanda_gestao_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_gut FOREIGN KEY (demanda_gestao_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_causa_efeito FOREIGN KEY (demanda_gestao_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_arquivo FOREIGN KEY (demanda_gestao_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_forum FOREIGN KEY (demanda_gestao_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_checklist FOREIGN KEY (demanda_gestao_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_agenda FOREIGN KEY (demanda_gestao_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_agrupamento FOREIGN KEY (demanda_gestao_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_patrocinador FOREIGN KEY (demanda_gestao_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_template FOREIGN KEY (demanda_gestao_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_painel FOREIGN KEY (demanda_gestao_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_painel_odometro FOREIGN KEY (demanda_gestao_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_painel_composicao FOREIGN KEY (demanda_gestao_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_tr FOREIGN KEY (demanda_gestao_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_me FOREIGN KEY (demanda_gestao_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_acao_item FOREIGN KEY (demanda_gestao_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_beneficio FOREIGN KEY (demanda_gestao_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_painel_slideshow FOREIGN KEY (demanda_gestao_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_projeto_viabilidade FOREIGN KEY (demanda_gestao_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_projeto_abertura FOREIGN KEY (demanda_gestao_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT demanda_gestao_plano_gestao FOREIGN KEY (demanda_gestao_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS instrumento_gestao;

CREATE TABLE instrumento_gestao (
	instrumento_gestao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	instrumento_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY instrumento_gestao_id (instrumento_gestao_id),
	KEY instrumento_gestao_instrumento (instrumento_gestao_instrumento),
	KEY instrumento_gestao_semelhante (instrumento_gestao_semelhante),
	KEY instrumento_gestao_projeto (instrumento_gestao_projeto),
	KEY instrumento_gestao_tarefa (instrumento_gestao_tarefa),
	KEY instrumento_gestao_perspectiva (instrumento_gestao_perspectiva),
	KEY instrumento_gestao_tema (instrumento_gestao_tema),
	KEY instrumento_gestao_objetivo (instrumento_gestao_objetivo),
	KEY instrumento_gestao_estrategia (instrumento_gestao_estrategia),
	KEY instrumento_gestao_meta (instrumento_gestao_meta),
	KEY instrumento_gestao_fator (instrumento_gestao_fator),
	KEY instrumento_gestao_pratica (instrumento_gestao_pratica),
	KEY instrumento_gestao_indicador (instrumento_gestao_indicador),
	KEY instrumento_gestao_acao (instrumento_gestao_acao),
	KEY instrumento_gestao_canvas (instrumento_gestao_canvas),
	KEY instrumento_gestao_risco (instrumento_gestao_risco),
	KEY instrumento_gestao_risco_resposta (instrumento_gestao_risco_resposta),
	KEY instrumento_gestao_calendario (instrumento_gestao_calendario),
	KEY instrumento_gestao_monitoramento (instrumento_gestao_monitoramento),
	KEY instrumento_gestao_ata (instrumento_gestao_ata),
	KEY instrumento_gestao_mswot(instrumento_gestao_mswot),
	KEY instrumento_gestao_swot(instrumento_gestao_swot),
	KEY instrumento_gestao_operativo(instrumento_gestao_operativo),
	KEY instrumento_gestao_recurso (instrumento_gestao_recurso),
	KEY instrumento_gestao_problema (instrumento_gestao_problema),
	KEY instrumento_gestao_demanda (instrumento_gestao_demanda),
	KEY instrumento_gestao_programa (instrumento_gestao_programa),
	KEY instrumento_gestao_licao (instrumento_gestao_licao),
	KEY instrumento_gestao_evento (instrumento_gestao_evento),
	KEY instrumento_gestao_link (instrumento_gestao_link),
	KEY instrumento_gestao_avaliacao (instrumento_gestao_avaliacao),
	KEY instrumento_gestao_tgn (instrumento_gestao_tgn),
	KEY instrumento_gestao_brainstorm (instrumento_gestao_brainstorm),
	KEY instrumento_gestao_gut (instrumento_gestao_gut),
	KEY instrumento_gestao_causa_efeito (instrumento_gestao_causa_efeito),
	KEY instrumento_gestao_arquivo (instrumento_gestao_arquivo),
	KEY instrumento_gestao_forum (instrumento_gestao_forum),
	KEY instrumento_gestao_checklist (instrumento_gestao_checklist),
	KEY instrumento_gestao_agenda (instrumento_gestao_agenda),
	KEY instrumento_gestao_agrupamento (instrumento_gestao_agrupamento),
	KEY instrumento_gestao_patrocinador (instrumento_gestao_patrocinador),
	KEY instrumento_gestao_template (instrumento_gestao_template),
	KEY instrumento_gestao_painel (instrumento_gestao_painel),
	KEY instrumento_gestao_painel_odometro (instrumento_gestao_painel_odometro),
	KEY instrumento_gestao_painel_composicao (instrumento_gestao_painel_composicao),
	KEY instrumento_gestao_tr (instrumento_gestao_tr),
	KEY instrumento_gestao_me (instrumento_gestao_me),
	KEY instrumento_gestao_acao_item (instrumento_gestao_acao_item),
	KEY instrumento_gestao_beneficio (instrumento_gestao_beneficio),
	KEY instrumento_gestao_painel_slideshow (instrumento_gestao_painel_slideshow),
	KEY instrumento_gestao_projeto_viabilidade (instrumento_gestao_projeto_viabilidade),
	KEY instrumento_gestao_projeto_abertura (instrumento_gestao_projeto_abertura),
	KEY instrumento_gestao_plano_gestao (instrumento_gestao_plano_gestao),
	CONSTRAINT instrumento_gestao_instrumento FOREIGN KEY (instrumento_gestao_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_semelhante FOREIGN KEY (instrumento_gestao_semelhante) REFERENCES instrumento (instrumento_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_projeto FOREIGN KEY (instrumento_gestao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_tarefa FOREIGN KEY (instrumento_gestao_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_perspectiva FOREIGN KEY (instrumento_gestao_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_tema FOREIGN KEY (instrumento_gestao_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_objetivo FOREIGN KEY (instrumento_gestao_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_fator FOREIGN KEY (instrumento_gestao_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_estrategia FOREIGN KEY (instrumento_gestao_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_meta FOREIGN KEY (instrumento_gestao_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_pratica FOREIGN KEY (instrumento_gestao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_indicador FOREIGN KEY (instrumento_gestao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_acao FOREIGN KEY (instrumento_gestao_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_canvas FOREIGN KEY (instrumento_gestao_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_risco FOREIGN KEY (instrumento_gestao_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_risco_resposta FOREIGN KEY (instrumento_gestao_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_calendario FOREIGN KEY (instrumento_gestao_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_monitoramento FOREIGN KEY (instrumento_gestao_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_ata FOREIGN KEY (instrumento_gestao_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_mswot FOREIGN KEY (instrumento_gestao_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_swot FOREIGN KEY (instrumento_gestao_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_operativo FOREIGN KEY (instrumento_gestao_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_recurso FOREIGN KEY (instrumento_gestao_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_problema FOREIGN KEY (instrumento_gestao_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_demanda FOREIGN KEY (instrumento_gestao_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_programa FOREIGN KEY (instrumento_gestao_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_licao FOREIGN KEY (instrumento_gestao_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_evento FOREIGN KEY (instrumento_gestao_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_link FOREIGN KEY (instrumento_gestao_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_avaliacao FOREIGN KEY (instrumento_gestao_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_tgn FOREIGN KEY (instrumento_gestao_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_brainstorm FOREIGN KEY (instrumento_gestao_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_gut FOREIGN KEY (instrumento_gestao_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_causa_efeito FOREIGN KEY (instrumento_gestao_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_arquivo FOREIGN KEY (instrumento_gestao_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_forum FOREIGN KEY (instrumento_gestao_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_checklist FOREIGN KEY (instrumento_gestao_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_agenda FOREIGN KEY (instrumento_gestao_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_agrupamento FOREIGN KEY (instrumento_gestao_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_patrocinador FOREIGN KEY (instrumento_gestao_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_template FOREIGN KEY (instrumento_gestao_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_painel FOREIGN KEY (instrumento_gestao_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_painel_odometro FOREIGN KEY (instrumento_gestao_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_painel_composicao FOREIGN KEY (instrumento_gestao_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_tr FOREIGN KEY (instrumento_gestao_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_me FOREIGN KEY (instrumento_gestao_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_acao_item FOREIGN KEY (instrumento_gestao_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_beneficio FOREIGN KEY (instrumento_gestao_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_painel_slideshow FOREIGN KEY (instrumento_gestao_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_projeto_viabilidade FOREIGN KEY (instrumento_gestao_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_projeto_abertura FOREIGN KEY (instrumento_gestao_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_gestao_plano_gestao FOREIGN KEY (instrumento_gestao_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS canvas_gestao;

CREATE TABLE canvas_gestao (
	canvas_gestao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	canvas_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY canvas_gestao_id (canvas_gestao_id),
	KEY canvas_gestao_canvas (canvas_gestao_canvas),
	KEY canvas_gestao_semelhante (canvas_gestao_semelhante),
	KEY canvas_gestao_projeto (canvas_gestao_projeto),
	KEY canvas_gestao_tarefa (canvas_gestao_tarefa),
	KEY canvas_gestao_perspectiva (canvas_gestao_perspectiva),
	KEY canvas_gestao_tema (canvas_gestao_tema),
	KEY canvas_gestao_objetivo (canvas_gestao_objetivo),
	KEY canvas_gestao_estrategia (canvas_gestao_estrategia),
	KEY canvas_gestao_meta (canvas_gestao_meta),
	KEY canvas_gestao_fator (canvas_gestao_fator),
	KEY canvas_gestao_pratica (canvas_gestao_pratica),
	KEY canvas_gestao_indicador (canvas_gestao_indicador),
	KEY canvas_gestao_acao (canvas_gestao_acao),
	KEY canvas_gestao_risco (canvas_gestao_risco),
	KEY canvas_gestao_risco_resposta (canvas_gestao_risco_resposta),
	KEY canvas_gestao_calendario (canvas_gestao_calendario),
	KEY canvas_gestao_monitoramento (canvas_gestao_monitoramento),
	KEY canvas_gestao_ata (canvas_gestao_ata),
	KEY canvas_gestao_mswot(canvas_gestao_mswot),
	KEY canvas_gestao_swot(canvas_gestao_swot),
	KEY canvas_gestao_operativo(canvas_gestao_operativo),
	KEY canvas_gestao_instrumento (canvas_gestao_instrumento),
	KEY canvas_gestao_recurso (canvas_gestao_recurso),
	KEY canvas_gestao_problema (canvas_gestao_problema),
	KEY canvas_gestao_demanda (canvas_gestao_demanda),
	KEY canvas_gestao_programa (canvas_gestao_programa),
	KEY canvas_gestao_licao (canvas_gestao_licao),
	KEY canvas_gestao_evento (canvas_gestao_evento),
	KEY canvas_gestao_link (canvas_gestao_link),
	KEY canvas_gestao_avaliacao (canvas_gestao_avaliacao),
	KEY canvas_gestao_tgn (canvas_gestao_tgn),
	KEY canvas_gestao_brainstorm (canvas_gestao_brainstorm),
	KEY canvas_gestao_gut (canvas_gestao_gut),
	KEY canvas_gestao_causa_efeito (canvas_gestao_causa_efeito),
	KEY canvas_gestao_arquivo (canvas_gestao_arquivo),
	KEY canvas_gestao_forum (canvas_gestao_forum),
	KEY canvas_gestao_checklist (canvas_gestao_checklist),
	KEY canvas_gestao_agenda (canvas_gestao_agenda),
	KEY canvas_gestao_agrupamento (canvas_gestao_agrupamento),
	KEY canvas_gestao_patrocinador (canvas_gestao_patrocinador),
	KEY canvas_gestao_template (canvas_gestao_template),
	KEY canvas_gestao_painel (canvas_gestao_painel),
	KEY canvas_gestao_painel_odometro (canvas_gestao_painel_odometro),
	KEY canvas_gestao_painel_composicao (canvas_gestao_painel_composicao),
	KEY canvas_gestao_tr (canvas_gestao_tr),
	KEY canvas_gestao_me (canvas_gestao_me),
	KEY canvas_gestao_acao_item (canvas_gestao_acao_item),
	KEY canvas_gestao_beneficio (canvas_gestao_beneficio),
	KEY canvas_gestao_painel_slideshow (canvas_gestao_painel_slideshow),
	KEY canvas_gestao_projeto_viabilidade (canvas_gestao_projeto_viabilidade),
	KEY canvas_gestao_projeto_abertura (canvas_gestao_projeto_abertura),
	KEY canvas_gestao_plano_gestao (canvas_gestao_plano_gestao),
	CONSTRAINT canvas_gestao_canvas FOREIGN KEY (canvas_gestao_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_semelhante FOREIGN KEY (canvas_gestao_semelhante) REFERENCES canvas (canvas_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_projeto FOREIGN KEY (canvas_gestao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_tarefa FOREIGN KEY (canvas_gestao_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_perspectiva FOREIGN KEY (canvas_gestao_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_tema FOREIGN KEY (canvas_gestao_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_objetivo FOREIGN KEY (canvas_gestao_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_fator FOREIGN KEY (canvas_gestao_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_estrategia FOREIGN KEY (canvas_gestao_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_meta FOREIGN KEY (canvas_gestao_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_pratica FOREIGN KEY (canvas_gestao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_indicador FOREIGN KEY (canvas_gestao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_acao FOREIGN KEY (canvas_gestao_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_risco FOREIGN KEY (canvas_gestao_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_risco_resposta FOREIGN KEY (canvas_gestao_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_calendario FOREIGN KEY (canvas_gestao_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_monitoramento FOREIGN KEY (canvas_gestao_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_ata FOREIGN KEY (canvas_gestao_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_mswot FOREIGN KEY (canvas_gestao_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_swot FOREIGN KEY (canvas_gestao_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_operativo FOREIGN KEY (canvas_gestao_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_instrumento FOREIGN KEY (canvas_gestao_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_recurso FOREIGN KEY (canvas_gestao_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_problema FOREIGN KEY (canvas_gestao_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_demanda FOREIGN KEY (canvas_gestao_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_programa FOREIGN KEY (canvas_gestao_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_licao FOREIGN KEY (canvas_gestao_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_evento FOREIGN KEY (canvas_gestao_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_link FOREIGN KEY (canvas_gestao_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_avaliacao FOREIGN KEY (canvas_gestao_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_tgn FOREIGN KEY (canvas_gestao_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_brainstorm FOREIGN KEY (canvas_gestao_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_gut FOREIGN KEY (canvas_gestao_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_causa_efeito FOREIGN KEY (canvas_gestao_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_arquivo FOREIGN KEY (canvas_gestao_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_forum FOREIGN KEY (canvas_gestao_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_checklist FOREIGN KEY (canvas_gestao_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_agenda FOREIGN KEY (canvas_gestao_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_agrupamento FOREIGN KEY (canvas_gestao_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_patrocinador FOREIGN KEY (canvas_gestao_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_template FOREIGN KEY (canvas_gestao_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_painel FOREIGN KEY (canvas_gestao_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_painel_odometro FOREIGN KEY (canvas_gestao_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_painel_composicao FOREIGN KEY (canvas_gestao_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_tr FOREIGN KEY (canvas_gestao_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_me FOREIGN KEY (canvas_gestao_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_acao_item FOREIGN KEY (canvas_gestao_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_beneficio FOREIGN KEY (canvas_gestao_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_painel_slideshow FOREIGN KEY (canvas_gestao_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_projeto_viabilidade FOREIGN KEY (canvas_gestao_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_projeto_abertura FOREIGN KEY (canvas_gestao_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT canvas_gestao_plano_gestao FOREIGN KEY (canvas_gestao_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS tgn_gestao;

CREATE TABLE tgn_gestao (
	tgn_gestao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	tgn_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY tgn_gestao_id (tgn_gestao_id),
	KEY tgn_gestao_tgn (tgn_gestao_tgn),
	KEY tgn_gestao_semelhante (tgn_gestao_semelhante),
	KEY tgn_gestao_projeto (tgn_gestao_projeto),
	KEY tgn_gestao_tarefa (tgn_gestao_tarefa),
	KEY tgn_gestao_perspectiva (tgn_gestao_perspectiva),
	KEY tgn_gestao_tema (tgn_gestao_tema),
	KEY tgn_gestao_objetivo (tgn_gestao_objetivo),
	KEY tgn_gestao_estrategia (tgn_gestao_estrategia),
	KEY tgn_gestao_meta (tgn_gestao_meta),
	KEY tgn_gestao_fator (tgn_gestao_fator),
	KEY tgn_gestao_pratica (tgn_gestao_pratica),
	KEY tgn_gestao_indicador (tgn_gestao_indicador),
	KEY tgn_gestao_acao (tgn_gestao_acao),
	KEY tgn_gestao_canvas (tgn_gestao_canvas),
	KEY tgn_gestao_risco (tgn_gestao_risco),
	KEY tgn_gestao_risco_resposta (tgn_gestao_risco_resposta),
	KEY tgn_gestao_calendario (tgn_gestao_calendario),
	KEY tgn_gestao_monitoramento (tgn_gestao_monitoramento),
	KEY tgn_gestao_ata (tgn_gestao_ata),
	KEY tgn_gestao_mswot(tgn_gestao_mswot),
	KEY tgn_gestao_swot(tgn_gestao_swot),
	KEY tgn_gestao_operativo(tgn_gestao_operativo),
	KEY tgn_gestao_instrumento (tgn_gestao_instrumento),
	KEY tgn_gestao_recurso (tgn_gestao_recurso),
	KEY tgn_gestao_problema (tgn_gestao_problema),
	KEY tgn_gestao_demanda (tgn_gestao_demanda),
	KEY tgn_gestao_programa (tgn_gestao_programa),
	KEY tgn_gestao_licao (tgn_gestao_licao),
	KEY tgn_gestao_evento (tgn_gestao_evento),
	KEY tgn_gestao_link (tgn_gestao_link),
	KEY tgn_gestao_avaliacao (tgn_gestao_avaliacao),
	KEY tgn_gestao_brainstorm (tgn_gestao_brainstorm),
	KEY tgn_gestao_gut (tgn_gestao_gut),
	KEY tgn_gestao_causa_efeito (tgn_gestao_causa_efeito),
	KEY tgn_gestao_arquivo (tgn_gestao_arquivo),
	KEY tgn_gestao_forum (tgn_gestao_forum),
	KEY tgn_gestao_checklist (tgn_gestao_checklist),
	KEY tgn_gestao_agenda (tgn_gestao_agenda),
	KEY tgn_gestao_agrupamento (tgn_gestao_agrupamento),
	KEY tgn_gestao_patrocinador (tgn_gestao_patrocinador),
	KEY tgn_gestao_template (tgn_gestao_template),
	KEY tgn_gestao_painel (tgn_gestao_painel),
	KEY tgn_gestao_painel_odometro (tgn_gestao_painel_odometro),
	KEY tgn_gestao_painel_composicao (tgn_gestao_painel_composicao),
	KEY tgn_gestao_tr (tgn_gestao_tr),
	KEY tgn_gestao_me (tgn_gestao_me),
	KEY tgn_gestao_acao_item (tgn_gestao_acao_item),
	KEY tgn_gestao_beneficio (tgn_gestao_beneficio),
	KEY tgn_gestao_painel_slideshow (tgn_gestao_painel_slideshow),
	KEY tgn_gestao_projeto_viabilidade (tgn_gestao_projeto_viabilidade),
	KEY tgn_gestao_projeto_abertura (tgn_gestao_projeto_abertura),
	KEY tgn_gestao_plano_gestao (tgn_gestao_plano_gestao),
	CONSTRAINT tgn_gestao_tgn FOREIGN KEY (tgn_gestao_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_semelhante FOREIGN KEY (tgn_gestao_semelhante) REFERENCES tgn (tgn_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_projeto FOREIGN KEY (tgn_gestao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_tarefa FOREIGN KEY (tgn_gestao_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_perspectiva FOREIGN KEY (tgn_gestao_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_tema FOREIGN KEY (tgn_gestao_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_objetivo FOREIGN KEY (tgn_gestao_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_fator FOREIGN KEY (tgn_gestao_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_estrategia FOREIGN KEY (tgn_gestao_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_meta FOREIGN KEY (tgn_gestao_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_pratica FOREIGN KEY (tgn_gestao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_indicador FOREIGN KEY (tgn_gestao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_acao FOREIGN KEY (tgn_gestao_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_canvas FOREIGN KEY (tgn_gestao_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_risco FOREIGN KEY (tgn_gestao_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_risco_resposta FOREIGN KEY (tgn_gestao_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_calendario FOREIGN KEY (tgn_gestao_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_monitoramento FOREIGN KEY (tgn_gestao_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_ata FOREIGN KEY (tgn_gestao_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_mswot FOREIGN KEY (tgn_gestao_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_swot FOREIGN KEY (tgn_gestao_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_operativo FOREIGN KEY (tgn_gestao_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_instrumento FOREIGN KEY (tgn_gestao_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_recurso FOREIGN KEY (tgn_gestao_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_problema FOREIGN KEY (tgn_gestao_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_demanda FOREIGN KEY (tgn_gestao_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_programa FOREIGN KEY (tgn_gestao_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_licao FOREIGN KEY (tgn_gestao_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_evento FOREIGN KEY (tgn_gestao_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_link FOREIGN KEY (tgn_gestao_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_avaliacao FOREIGN KEY (tgn_gestao_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_brainstorm FOREIGN KEY (tgn_gestao_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_gut FOREIGN KEY (tgn_gestao_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_causa_efeito FOREIGN KEY (tgn_gestao_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_arquivo FOREIGN KEY (tgn_gestao_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_forum FOREIGN KEY (tgn_gestao_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_checklist FOREIGN KEY (tgn_gestao_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_agenda FOREIGN KEY (tgn_gestao_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_agrupamento FOREIGN KEY (tgn_gestao_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_patrocinador FOREIGN KEY (tgn_gestao_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_template FOREIGN KEY (tgn_gestao_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_painel FOREIGN KEY (tgn_gestao_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_painel_odometro FOREIGN KEY (tgn_gestao_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_painel_composicao FOREIGN KEY (tgn_gestao_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_tr FOREIGN KEY (tgn_gestao_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_me FOREIGN KEY (tgn_gestao_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_acao_item FOREIGN KEY (tgn_gestao_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_beneficio FOREIGN KEY (tgn_gestao_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_painel_slideshow FOREIGN KEY (tgn_gestao_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_projeto_viabilidade FOREIGN KEY (tgn_gestao_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_projeto_abertura FOREIGN KEY (tgn_gestao_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tgn_gestao_plano_gestao FOREIGN KEY (tgn_gestao_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_projeto_gestao;

CREATE TABLE baseline_projeto_gestao (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	projeto_gestao_id INTEGER(100) UNSIGNED NOT NULL,
	projeto_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (baseline_id, projeto_gestao_id),
	CONSTRAINT baseline_projeto_gestao_fk FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS projeto_gestao;

CREATE TABLE projeto_gestao (
	projeto_gestao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	projeto_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY projeto_gestao_id (projeto_gestao_id),
	KEY projeto_gestao_projeto (projeto_gestao_projeto),
	KEY projeto_gestao_semelhante (projeto_gestao_semelhante),
	KEY projeto_gestao_tarefa (projeto_gestao_tarefa),
	KEY projeto_gestao_perspectiva (projeto_gestao_perspectiva),
	KEY projeto_gestao_tema (projeto_gestao_tema),
	KEY projeto_gestao_objetivo (projeto_gestao_objetivo),
	KEY projeto_gestao_estrategia (projeto_gestao_estrategia),
	KEY projeto_gestao_meta (projeto_gestao_meta),
	KEY projeto_gestao_fator (projeto_gestao_fator),
	KEY projeto_gestao_pratica (projeto_gestao_pratica),
	KEY projeto_gestao_indicador (projeto_gestao_indicador),
	KEY projeto_gestao_acao (projeto_gestao_acao),
	KEY projeto_gestao_canvas (projeto_gestao_canvas),
	KEY projeto_gestao_risco (projeto_gestao_risco),
	KEY projeto_gestao_risco_resposta (projeto_gestao_risco_resposta),
	KEY projeto_gestao_calendario (projeto_gestao_calendario),
	KEY projeto_gestao_monitoramento (projeto_gestao_monitoramento),
	KEY projeto_gestao_ata (projeto_gestao_ata),
	KEY projeto_gestao_mswot(projeto_gestao_mswot),
	KEY projeto_gestao_swot(projeto_gestao_swot),
	KEY projeto_gestao_operativo(projeto_gestao_operativo),
	KEY projeto_gestao_instrumento (projeto_gestao_instrumento),
	KEY projeto_gestao_recurso (projeto_gestao_recurso),
	KEY projeto_gestao_problema (projeto_gestao_problema),
	KEY projeto_gestao_demanda (projeto_gestao_demanda),
	KEY projeto_gestao_programa (projeto_gestao_programa),
	KEY projeto_gestao_licao (projeto_gestao_licao),
	KEY projeto_gestao_evento (projeto_gestao_evento),
	KEY projeto_gestao_link (projeto_gestao_link),
	KEY projeto_gestao_avaliacao (projeto_gestao_avaliacao),
	KEY projeto_gestao_tgn (projeto_gestao_tgn),
	KEY projeto_gestao_brainstorm (projeto_gestao_brainstorm),
	KEY projeto_gestao_gut (projeto_gestao_gut),
	KEY projeto_gestao_causa_efeito (projeto_gestao_causa_efeito),
	KEY projeto_gestao_arquivo (projeto_gestao_arquivo),
	KEY projeto_gestao_forum (projeto_gestao_forum),
	KEY projeto_gestao_checklist (projeto_gestao_checklist),
	KEY projeto_gestao_agenda (projeto_gestao_agenda),
	KEY projeto_gestao_agrupamento (projeto_gestao_agrupamento),
	KEY projeto_gestao_patrocinador (projeto_gestao_patrocinador),
	KEY projeto_gestao_template (projeto_gestao_template),
	KEY projeto_gestao_painel (projeto_gestao_painel),
	KEY projeto_gestao_painel_odometro (projeto_gestao_painel_odometro),
	KEY projeto_gestao_painel_composicao (projeto_gestao_painel_composicao),
	KEY projeto_gestao_tr (projeto_gestao_tr),
	KEY projeto_gestao_me (projeto_gestao_me),
	KEY projeto_gestao_acao_item (projeto_gestao_acao_item),
	KEY projeto_gestao_beneficio (projeto_gestao_beneficio),
	KEY projeto_gestao_painel_slideshow (projeto_gestao_painel_slideshow),
	KEY projeto_gestao_projeto_viabilidade (projeto_gestao_projeto_viabilidade),
	KEY projeto_gestao_projeto_abertura (projeto_gestao_projeto_abertura),
	KEY projeto_gestao_plano_gestao (projeto_gestao_plano_gestao),
	CONSTRAINT projeto_gestao_projeto FOREIGN KEY (projeto_gestao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_semelhante FOREIGN KEY (projeto_gestao_semelhante) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_tarefa FOREIGN KEY (projeto_gestao_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_perspectiva FOREIGN KEY (projeto_gestao_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_tema FOREIGN KEY (projeto_gestao_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_objetivo FOREIGN KEY (projeto_gestao_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_fator FOREIGN KEY (projeto_gestao_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_estrategia FOREIGN KEY (projeto_gestao_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_meta FOREIGN KEY (projeto_gestao_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_pratica FOREIGN KEY (projeto_gestao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_indicador FOREIGN KEY (projeto_gestao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_acao FOREIGN KEY (projeto_gestao_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_canvas FOREIGN KEY (projeto_gestao_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_risco FOREIGN KEY (projeto_gestao_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_risco_resposta FOREIGN KEY (projeto_gestao_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_calendario FOREIGN KEY (projeto_gestao_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_monitoramento FOREIGN KEY (projeto_gestao_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_ata FOREIGN KEY (projeto_gestao_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_mswot FOREIGN KEY (projeto_gestao_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_swot FOREIGN KEY (projeto_gestao_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_operativo FOREIGN KEY (projeto_gestao_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_instrumento FOREIGN KEY (projeto_gestao_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_recurso FOREIGN KEY (projeto_gestao_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_problema FOREIGN KEY (projeto_gestao_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_demanda FOREIGN KEY (projeto_gestao_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_programa FOREIGN KEY (projeto_gestao_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_licao FOREIGN KEY (projeto_gestao_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_evento FOREIGN KEY (projeto_gestao_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_link FOREIGN KEY (projeto_gestao_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_avaliacao FOREIGN KEY (projeto_gestao_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_tgn FOREIGN KEY (projeto_gestao_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_brainstorm FOREIGN KEY (projeto_gestao_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_gut FOREIGN KEY (projeto_gestao_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_causa_efeito FOREIGN KEY (projeto_gestao_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_arquivo FOREIGN KEY (projeto_gestao_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_forum FOREIGN KEY (projeto_gestao_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_checklist FOREIGN KEY (projeto_gestao_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_agenda FOREIGN KEY (projeto_gestao_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_agrupamento FOREIGN KEY (projeto_gestao_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_patrocinador FOREIGN KEY (projeto_gestao_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_template FOREIGN KEY (projeto_gestao_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_painel FOREIGN KEY (projeto_gestao_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_painel_odometro FOREIGN KEY (projeto_gestao_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_painel_composicao FOREIGN KEY (projeto_gestao_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_tr FOREIGN KEY (projeto_gestao_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_me FOREIGN KEY (projeto_gestao_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_acao_item FOREIGN KEY (projeto_gestao_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_beneficio FOREIGN KEY (projeto_gestao_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_painel_slideshow FOREIGN KEY (projeto_gestao_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_projeto_viabilidade FOREIGN KEY (projeto_gestao_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_projeto_abertura FOREIGN KEY (projeto_gestao_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_gestao_plano_gestao FOREIGN KEY (projeto_gestao_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS risco_gestao;

CREATE TABLE risco_gestao (
	risco_gestao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	risco_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY risco_gestao_id (risco_gestao_id),
	KEY risco_gestao_risco (risco_gestao_risco),
	KEY risco_gestao_semelhante (risco_gestao_semelhante),
	KEY risco_gestao_projeto (risco_gestao_projeto),
	KEY risco_gestao_tarefa (risco_gestao_tarefa),
	KEY risco_gestao_perspectiva (risco_gestao_perspectiva),
	KEY risco_gestao_tema (risco_gestao_tema),
	KEY risco_gestao_objetivo (risco_gestao_objetivo),
	KEY risco_gestao_estrategia (risco_gestao_estrategia),
	KEY risco_gestao_meta (risco_gestao_meta),
	KEY risco_gestao_fator (risco_gestao_fator),
	KEY risco_gestao_pratica (risco_gestao_pratica),
	KEY risco_gestao_indicador (risco_gestao_indicador),
	KEY risco_gestao_acao (risco_gestao_acao),
	KEY risco_gestao_canvas (risco_gestao_canvas),
	KEY risco_gestao_risco_resposta (risco_gestao_risco_resposta),
	KEY risco_gestao_calendario (risco_gestao_calendario),
	KEY risco_gestao_monitoramento (risco_gestao_monitoramento),
	KEY risco_gestao_ata (risco_gestao_ata),
	KEY risco_gestao_mswot(risco_gestao_mswot),
	KEY risco_gestao_swot(risco_gestao_swot),
	KEY risco_gestao_operativo(risco_gestao_operativo),
	KEY risco_gestao_instrumento (risco_gestao_instrumento),
	KEY risco_gestao_recurso (risco_gestao_recurso),
	KEY risco_gestao_problema (risco_gestao_problema),
	KEY risco_gestao_demanda (risco_gestao_demanda),
	KEY risco_gestao_programa (risco_gestao_programa),
	KEY risco_gestao_licao (risco_gestao_licao),
	KEY risco_gestao_evento (risco_gestao_evento),
	KEY risco_gestao_link (risco_gestao_link),
	KEY risco_gestao_avaliacao (risco_gestao_avaliacao),
	KEY risco_gestao_tgn (risco_gestao_tgn),
	KEY risco_gestao_brainstorm (risco_gestao_brainstorm),
	KEY risco_gestao_gut (risco_gestao_gut),
	KEY risco_gestao_causa_efeito (risco_gestao_causa_efeito),
	KEY risco_gestao_arquivo (risco_gestao_arquivo),
	KEY risco_gestao_forum (risco_gestao_forum),
	KEY risco_gestao_checklist (risco_gestao_checklist),
	KEY risco_gestao_agenda (risco_gestao_agenda),
	KEY risco_gestao_agrupamento (risco_gestao_agrupamento),
	KEY risco_gestao_patrocinador (risco_gestao_patrocinador),
	KEY risco_gestao_template (risco_gestao_template),
	KEY risco_gestao_painel (risco_gestao_painel),
	KEY risco_gestao_painel_odometro (risco_gestao_painel_odometro),
	KEY risco_gestao_painel_composicao (risco_gestao_painel_composicao),
	KEY risco_gestao_tr (risco_gestao_tr),
	KEY risco_gestao_me (risco_gestao_me),
	KEY risco_gestao_acao_item (risco_gestao_acao_item),
	KEY risco_gestao_beneficio (risco_gestao_beneficio),
	KEY risco_gestao_painel_slideshow (risco_gestao_painel_slideshow),
	KEY risco_gestao_projeto_viabilidade (risco_gestao_projeto_viabilidade),
	KEY risco_gestao_projeto_abertura (risco_gestao_projeto_abertura),
	KEY risco_gestao_plano_gestao (risco_gestao_plano_gestao),
	CONSTRAINT risco_gestao_risco FOREIGN KEY (risco_gestao_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_semelhante FOREIGN KEY (risco_gestao_semelhante) REFERENCES risco (risco_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_projeto FOREIGN KEY (risco_gestao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_tarefa FOREIGN KEY (risco_gestao_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_perspectiva FOREIGN KEY (risco_gestao_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_tema FOREIGN KEY (risco_gestao_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_objetivo FOREIGN KEY (risco_gestao_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_fator FOREIGN KEY (risco_gestao_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_estrategia FOREIGN KEY (risco_gestao_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_meta FOREIGN KEY (risco_gestao_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_pratica FOREIGN KEY (risco_gestao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_indicador FOREIGN KEY (risco_gestao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_acao FOREIGN KEY (risco_gestao_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_canvas FOREIGN KEY (risco_gestao_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_risco_resposta FOREIGN KEY (risco_gestao_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_calendario FOREIGN KEY (risco_gestao_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_monitoramento FOREIGN KEY (risco_gestao_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_ata FOREIGN KEY (risco_gestao_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_mswot FOREIGN KEY (risco_gestao_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_swot FOREIGN KEY (risco_gestao_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_operativo FOREIGN KEY (risco_gestao_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_instrumento FOREIGN KEY (risco_gestao_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_recurso FOREIGN KEY (risco_gestao_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_problema FOREIGN KEY (risco_gestao_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_demanda FOREIGN KEY (risco_gestao_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_programa FOREIGN KEY (risco_gestao_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_licao FOREIGN KEY (risco_gestao_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_evento FOREIGN KEY (risco_gestao_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_link FOREIGN KEY (risco_gestao_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_avaliacao FOREIGN KEY (risco_gestao_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_tgn FOREIGN KEY (risco_gestao_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_brainstorm FOREIGN KEY (risco_gestao_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_gut FOREIGN KEY (risco_gestao_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_causa_efeito FOREIGN KEY (risco_gestao_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_arquivo FOREIGN KEY (risco_gestao_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_forum FOREIGN KEY (risco_gestao_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_checklist FOREIGN KEY (risco_gestao_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_agenda FOREIGN KEY (risco_gestao_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_agrupamento FOREIGN KEY (risco_gestao_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_patrocinador FOREIGN KEY (risco_gestao_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_template FOREIGN KEY (risco_gestao_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_painel FOREIGN KEY (risco_gestao_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_painel_odometro FOREIGN KEY (risco_gestao_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_painel_composicao FOREIGN KEY (risco_gestao_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_tr FOREIGN KEY (risco_gestao_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_me FOREIGN KEY (risco_gestao_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_acao_item FOREIGN KEY (risco_gestao_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_beneficio FOREIGN KEY (risco_gestao_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_painel_slideshow FOREIGN KEY (risco_gestao_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_projeto_viabilidade FOREIGN KEY (risco_gestao_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_projeto_abertura FOREIGN KEY (risco_gestao_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_gestao_plano_gestao FOREIGN KEY (risco_gestao_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS risco_resposta_gestao;

CREATE TABLE risco_resposta_gestao (
	risco_resposta_gestao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	risco_resposta_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY risco_resposta_gestao_id (risco_resposta_gestao_id),
	KEY risco_resposta_gestao_risco_resposta (risco_resposta_gestao_risco_resposta),
	KEY risco_resposta_gestao_semelhante (risco_resposta_gestao_semelhante),
	KEY risco_resposta_gestao_projeto (risco_resposta_gestao_projeto),
	KEY risco_resposta_gestao_tarefa (risco_resposta_gestao_tarefa),
	KEY risco_resposta_gestao_perspectiva (risco_resposta_gestao_perspectiva),
	KEY risco_resposta_gestao_tema (risco_resposta_gestao_tema),
	KEY risco_resposta_gestao_objetivo (risco_resposta_gestao_objetivo),
	KEY risco_resposta_gestao_estrategia (risco_resposta_gestao_estrategia),
	KEY risco_resposta_gestao_meta (risco_resposta_gestao_meta),
	KEY risco_resposta_gestao_fator (risco_resposta_gestao_fator),
	KEY risco_resposta_gestao_pratica (risco_resposta_gestao_pratica),
	KEY risco_resposta_gestao_indicador (risco_resposta_gestao_indicador),
	KEY risco_resposta_gestao_acao (risco_resposta_gestao_acao),
	KEY risco_resposta_gestao_canvas (risco_resposta_gestao_canvas),
	KEY risco_resposta_gestao_risco (risco_resposta_gestao_risco),
	KEY risco_resposta_gestao_calendario (risco_resposta_gestao_calendario),
	KEY risco_resposta_gestao_monitoramento (risco_resposta_gestao_monitoramento),
	KEY risco_resposta_gestao_ata (risco_resposta_gestao_ata),
	KEY risco_resposta_gestao_mswot(risco_resposta_gestao_mswot),
	KEY risco_resposta_gestao_swot(risco_resposta_gestao_swot),
	KEY risco_resposta_gestao_operativo(risco_resposta_gestao_operativo),
	KEY risco_resposta_gestao_instrumento (risco_resposta_gestao_instrumento),
	KEY risco_resposta_gestao_recurso (risco_resposta_gestao_recurso),
	KEY risco_resposta_gestao_problema (risco_resposta_gestao_problema),
	KEY risco_resposta_gestao_demanda (risco_resposta_gestao_demanda),
	KEY risco_resposta_gestao_programa (risco_resposta_gestao_programa),
	KEY risco_resposta_gestao_licao (risco_resposta_gestao_licao),
	KEY risco_resposta_gestao_evento (risco_resposta_gestao_evento),
	KEY risco_resposta_gestao_link (risco_resposta_gestao_link),
	KEY risco_resposta_gestao_avaliacao (risco_resposta_gestao_avaliacao),
	KEY risco_resposta_gestao_tgn (risco_resposta_gestao_tgn),
	KEY risco_resposta_gestao_brainstorm (risco_resposta_gestao_brainstorm),
	KEY risco_resposta_gestao_gut (risco_resposta_gestao_gut),
	KEY risco_resposta_gestao_causa_efeito (risco_resposta_gestao_causa_efeito),
	KEY risco_resposta_gestao_arquivo (risco_resposta_gestao_arquivo),
	KEY risco_resposta_gestao_forum (risco_resposta_gestao_forum),
	KEY risco_resposta_gestao_checklist (risco_resposta_gestao_checklist),
	KEY risco_resposta_gestao_agenda (risco_resposta_gestao_agenda),
	KEY risco_resposta_gestao_agrupamento (risco_resposta_gestao_agrupamento),
	KEY risco_resposta_gestao_patrocinador (risco_resposta_gestao_patrocinador),
	KEY risco_resposta_gestao_template (risco_resposta_gestao_template),
	KEY risco_resposta_gestao_painel (risco_resposta_gestao_painel),
	KEY risco_resposta_gestao_painel_odometro (risco_resposta_gestao_painel_odometro),
	KEY risco_resposta_gestao_painel_composicao (risco_resposta_gestao_painel_composicao),
	KEY risco_resposta_gestao_tr (risco_resposta_gestao_tr),
	KEY risco_resposta_gestao_me (risco_resposta_gestao_me),
	KEY risco_resposta_gestao_acao_item (risco_resposta_gestao_acao_item),
	KEY risco_resposta_gestao_beneficio (risco_resposta_gestao_beneficio),
	KEY risco_resposta_gestao_painel_slideshow (risco_resposta_gestao_painel_slideshow),
	KEY risco_resposta_gestao_projeto_viabilidade (risco_resposta_gestao_projeto_viabilidade),
	KEY risco_resposta_gestao_projeto_abertura (risco_resposta_gestao_projeto_abertura),
	KEY risco_resposta_gestao_plano_gestao (risco_resposta_gestao_plano_gestao),
	CONSTRAINT risco_resposta_gestao_risco_resposta FOREIGN KEY (risco_resposta_gestao_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_semelhante FOREIGN KEY (risco_resposta_gestao_semelhante) REFERENCES risco_resposta (risco_resposta_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_projeto FOREIGN KEY (risco_resposta_gestao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_tarefa FOREIGN KEY (risco_resposta_gestao_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_perspectiva FOREIGN KEY (risco_resposta_gestao_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_tema FOREIGN KEY (risco_resposta_gestao_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_objetivo FOREIGN KEY (risco_resposta_gestao_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_fator FOREIGN KEY (risco_resposta_gestao_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_estrategia FOREIGN KEY (risco_resposta_gestao_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_meta FOREIGN KEY (risco_resposta_gestao_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_pratica FOREIGN KEY (risco_resposta_gestao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_indicador FOREIGN KEY (risco_resposta_gestao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_acao FOREIGN KEY (risco_resposta_gestao_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_canvas FOREIGN KEY (risco_resposta_gestao_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_risco FOREIGN KEY (risco_resposta_gestao_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_calendario FOREIGN KEY (risco_resposta_gestao_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_monitoramento FOREIGN KEY (risco_resposta_gestao_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_ata FOREIGN KEY (risco_resposta_gestao_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_mswot FOREIGN KEY (risco_resposta_gestao_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_swot FOREIGN KEY (risco_resposta_gestao_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_operativo FOREIGN KEY (risco_resposta_gestao_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_instrumento FOREIGN KEY (risco_resposta_gestao_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_recurso FOREIGN KEY (risco_resposta_gestao_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_problema FOREIGN KEY (risco_resposta_gestao_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_demanda FOREIGN KEY (risco_resposta_gestao_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_programa FOREIGN KEY (risco_resposta_gestao_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_licao FOREIGN KEY (risco_resposta_gestao_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_evento FOREIGN KEY (risco_resposta_gestao_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_link FOREIGN KEY (risco_resposta_gestao_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_avaliacao FOREIGN KEY (risco_resposta_gestao_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_tgn FOREIGN KEY (risco_resposta_gestao_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_brainstorm FOREIGN KEY (risco_resposta_gestao_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_gut FOREIGN KEY (risco_resposta_gestao_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_causa_efeito FOREIGN KEY (risco_resposta_gestao_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_arquivo FOREIGN KEY (risco_resposta_gestao_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_forum FOREIGN KEY (risco_resposta_gestao_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_checklist FOREIGN KEY (risco_resposta_gestao_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_agenda FOREIGN KEY (risco_resposta_gestao_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_agrupamento FOREIGN KEY (risco_resposta_gestao_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_patrocinador FOREIGN KEY (risco_resposta_gestao_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_template FOREIGN KEY (risco_resposta_gestao_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_painel FOREIGN KEY (risco_resposta_gestao_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_painel_odometro FOREIGN KEY (risco_resposta_gestao_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_painel_composicao FOREIGN KEY (risco_resposta_gestao_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_tr FOREIGN KEY (risco_resposta_gestao_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_me FOREIGN KEY (risco_resposta_gestao_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_acao_item FOREIGN KEY (risco_resposta_gestao_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_beneficio FOREIGN KEY (risco_resposta_gestao_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_painel_slideshow FOREIGN KEY (risco_resposta_gestao_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_projeto_viabilidade FOREIGN KEY (risco_resposta_gestao_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_projeto_abertura FOREIGN KEY (risco_resposta_gestao_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_gestao_plano_gestao FOREIGN KEY (risco_resposta_gestao_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS monitoramento_gestao;

CREATE TABLE monitoramento_gestao (
	monitoramento_gestao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	monitoramento_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY monitoramento_gestao_id (monitoramento_gestao_id),
	KEY monitoramento_gestao_monitoramento (monitoramento_gestao_monitoramento),
	KEY monitoramento_gestao_semelhante (monitoramento_gestao_semelhante),
	KEY monitoramento_gestao_projeto (monitoramento_gestao_projeto),
	KEY monitoramento_gestao_tarefa (monitoramento_gestao_tarefa),
	KEY monitoramento_gestao_perspectiva (monitoramento_gestao_perspectiva),
	KEY monitoramento_gestao_tema (monitoramento_gestao_tema),
	KEY monitoramento_gestao_objetivo (monitoramento_gestao_objetivo),
	KEY monitoramento_gestao_estrategia (monitoramento_gestao_estrategia),
	KEY monitoramento_gestao_meta (monitoramento_gestao_meta),
	KEY monitoramento_gestao_fator (monitoramento_gestao_fator),
	KEY monitoramento_gestao_pratica (monitoramento_gestao_pratica),
	KEY monitoramento_gestao_indicador (monitoramento_gestao_indicador),
	KEY monitoramento_gestao_acao (monitoramento_gestao_acao),
	KEY monitoramento_gestao_canvas (monitoramento_gestao_canvas),
	KEY monitoramento_gestao_risco (monitoramento_gestao_risco),
	KEY monitoramento_gestao_risco_resposta (monitoramento_gestao_risco_resposta),
	KEY monitoramento_gestao_calendario (monitoramento_gestao_calendario),
	KEY monitoramento_gestao_ata (monitoramento_gestao_ata),
	KEY monitoramento_gestao_mswot(monitoramento_gestao_mswot),
	KEY monitoramento_gestao_swot(monitoramento_gestao_swot),
	KEY monitoramento_gestao_operativo(monitoramento_gestao_operativo),
	KEY monitoramento_gestao_instrumento (monitoramento_gestao_instrumento),
	KEY monitoramento_gestao_recurso (monitoramento_gestao_recurso),
	KEY monitoramento_gestao_problema (monitoramento_gestao_problema),
	KEY monitoramento_gestao_demanda (monitoramento_gestao_demanda),
	KEY monitoramento_gestao_programa (monitoramento_gestao_programa),
	KEY monitoramento_gestao_licao (monitoramento_gestao_licao),
	KEY monitoramento_gestao_evento (monitoramento_gestao_evento),
	KEY monitoramento_gestao_link (monitoramento_gestao_link),
	KEY monitoramento_gestao_avaliacao (monitoramento_gestao_avaliacao),
	KEY monitoramento_gestao_tgn (monitoramento_gestao_tgn),
	KEY monitoramento_gestao_brainstorm (monitoramento_gestao_brainstorm),
	KEY monitoramento_gestao_gut (monitoramento_gestao_gut),
	KEY monitoramento_gestao_causa_efeito (monitoramento_gestao_causa_efeito),
	KEY monitoramento_gestao_arquivo (monitoramento_gestao_arquivo),
	KEY monitoramento_gestao_forum (monitoramento_gestao_forum),
	KEY monitoramento_gestao_checklist (monitoramento_gestao_checklist),
	KEY monitoramento_gestao_agenda (monitoramento_gestao_agenda),
	KEY monitoramento_gestao_agrupamento (monitoramento_gestao_agrupamento),
	KEY monitoramento_gestao_patrocinador (monitoramento_gestao_patrocinador),
	KEY monitoramento_gestao_template (monitoramento_gestao_template),
	KEY monitoramento_gestao_painel (monitoramento_gestao_painel),
	KEY monitoramento_gestao_painel_odometro (monitoramento_gestao_painel_odometro),
	KEY monitoramento_gestao_painel_composicao (monitoramento_gestao_painel_composicao),
	KEY monitoramento_gestao_tr (monitoramento_gestao_tr),
	KEY monitoramento_gestao_me (monitoramento_gestao_me),
	KEY monitoramento_gestao_acao_item (monitoramento_gestao_acao_item),
	KEY monitoramento_gestao_beneficio (monitoramento_gestao_beneficio),
	KEY monitoramento_gestao_painel_slideshow (monitoramento_gestao_painel_slideshow),
	KEY monitoramento_gestao_projeto_viabilidade (monitoramento_gestao_projeto_viabilidade),
	KEY monitoramento_gestao_projeto_abertura (monitoramento_gestao_projeto_abertura),
	KEY monitoramento_gestao_plano_gestao (monitoramento_gestao_plano_gestao),
	CONSTRAINT monitoramento_gestao_monitoramento FOREIGN KEY (monitoramento_gestao_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_semelhante FOREIGN KEY (monitoramento_gestao_semelhante) REFERENCES monitoramento (monitoramento_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_projeto FOREIGN KEY (monitoramento_gestao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_tarefa FOREIGN KEY (monitoramento_gestao_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_perspectiva FOREIGN KEY (monitoramento_gestao_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_tema FOREIGN KEY (monitoramento_gestao_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_objetivo FOREIGN KEY (monitoramento_gestao_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_fator FOREIGN KEY (monitoramento_gestao_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_estrategia FOREIGN KEY (monitoramento_gestao_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_meta FOREIGN KEY (monitoramento_gestao_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_pratica FOREIGN KEY (monitoramento_gestao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_indicador FOREIGN KEY (monitoramento_gestao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_acao FOREIGN KEY (monitoramento_gestao_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_canvas FOREIGN KEY (monitoramento_gestao_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_risco FOREIGN KEY (monitoramento_gestao_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_risco_resposta FOREIGN KEY (monitoramento_gestao_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_calendario FOREIGN KEY (monitoramento_gestao_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_ata FOREIGN KEY (monitoramento_gestao_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_mswot FOREIGN KEY (monitoramento_gestao_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_swot FOREIGN KEY (monitoramento_gestao_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_operativo FOREIGN KEY (monitoramento_gestao_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_instrumento FOREIGN KEY (monitoramento_gestao_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_recurso FOREIGN KEY (monitoramento_gestao_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_problema FOREIGN KEY (monitoramento_gestao_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_demanda FOREIGN KEY (monitoramento_gestao_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_programa FOREIGN KEY (monitoramento_gestao_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_licao FOREIGN KEY (monitoramento_gestao_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_evento FOREIGN KEY (monitoramento_gestao_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_link FOREIGN KEY (monitoramento_gestao_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_avaliacao FOREIGN KEY (monitoramento_gestao_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_tgn FOREIGN KEY (monitoramento_gestao_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_brainstorm FOREIGN KEY (monitoramento_gestao_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_gut FOREIGN KEY (monitoramento_gestao_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_causa_efeito FOREIGN KEY (monitoramento_gestao_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_arquivo FOREIGN KEY (monitoramento_gestao_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_forum FOREIGN KEY (monitoramento_gestao_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_checklist FOREIGN KEY (monitoramento_gestao_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_agenda FOREIGN KEY (monitoramento_gestao_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_agrupamento FOREIGN KEY (monitoramento_gestao_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_patrocinador FOREIGN KEY (monitoramento_gestao_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_template FOREIGN KEY (monitoramento_gestao_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_painel FOREIGN KEY (monitoramento_gestao_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_painel_odometro FOREIGN KEY (monitoramento_gestao_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_painel_composicao FOREIGN KEY (monitoramento_gestao_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_tr FOREIGN KEY (monitoramento_gestao_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_me FOREIGN KEY (monitoramento_gestao_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_acao_item FOREIGN KEY (monitoramento_gestao_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_beneficio FOREIGN KEY (monitoramento_gestao_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_painel_slideshow FOREIGN KEY (monitoramento_gestao_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_projeto_viabilidade FOREIGN KEY (monitoramento_gestao_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_projeto_abertura FOREIGN KEY (monitoramento_gestao_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_gestao_plano_gestao FOREIGN KEY (monitoramento_gestao_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS plano_acao_gestao;

CREATE TABLE plano_acao_gestao (
	plano_acao_gestao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	plano_acao_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY plano_acao_gestao_id (plano_acao_gestao_id),
	KEY plano_acao_gestao_acao (plano_acao_gestao_acao),
	KEY plano_acao_gestao_semelhante (plano_acao_gestao_semelhante),
	KEY plano_acao_gestao_projeto (plano_acao_gestao_projeto),
	KEY plano_acao_gestao_tarefa (plano_acao_gestao_tarefa),
	KEY plano_acao_gestao_perspectiva (plano_acao_gestao_perspectiva),
	KEY plano_acao_gestao_tema (plano_acao_gestao_tema),
	KEY plano_acao_gestao_objetivo (plano_acao_gestao_objetivo),
	KEY plano_acao_gestao_estrategia (plano_acao_gestao_estrategia),
	KEY plano_acao_gestao_meta (plano_acao_gestao_meta),
	KEY plano_acao_gestao_fator (plano_acao_gestao_fator),
	KEY plano_acao_gestao_pratica (plano_acao_gestao_pratica),
	KEY plano_acao_gestao_indicador (plano_acao_gestao_indicador),
	KEY plano_acao_gestao_canvas (plano_acao_gestao_canvas),
	KEY plano_acao_gestao_risco (plano_acao_gestao_risco),
	KEY plano_acao_gestao_risco_resposta (plano_acao_gestao_risco_resposta),
	KEY plano_acao_gestao_calendario (plano_acao_gestao_calendario),
	KEY plano_acao_gestao_monitoramento (plano_acao_gestao_monitoramento),
	KEY plano_acao_gestao_ata (plano_acao_gestao_ata),
	KEY plano_acao_gestao_mswot(plano_acao_gestao_mswot),
	KEY plano_acao_gestao_swot(plano_acao_gestao_swot),
	KEY plano_acao_gestao_operativo(plano_acao_gestao_operativo),
	KEY plano_acao_gestao_instrumento (plano_acao_gestao_instrumento),
	KEY plano_acao_gestao_recurso (plano_acao_gestao_recurso),
	KEY plano_acao_gestao_problema (plano_acao_gestao_problema),
	KEY plano_acao_gestao_demanda (plano_acao_gestao_demanda),
	KEY plano_acao_gestao_programa (plano_acao_gestao_programa),
	KEY plano_acao_gestao_licao (plano_acao_gestao_licao),
	KEY plano_acao_gestao_evento (plano_acao_gestao_evento),
	KEY plano_acao_gestao_link (plano_acao_gestao_link),
	KEY plano_acao_gestao_avaliacao (plano_acao_gestao_avaliacao),
	KEY plano_acao_gestao_tgn (plano_acao_gestao_tgn),
	KEY plano_acao_gestao_brainstorm (plano_acao_gestao_brainstorm),
	KEY plano_acao_gestao_gut (plano_acao_gestao_gut),
	KEY plano_acao_gestao_causa_efeito (plano_acao_gestao_causa_efeito),
	KEY plano_acao_gestao_arquivo (plano_acao_gestao_arquivo),
	KEY plano_acao_gestao_forum (plano_acao_gestao_forum),
	KEY plano_acao_gestao_checklist (plano_acao_gestao_checklist),
	KEY plano_acao_gestao_agenda (plano_acao_gestao_agenda),
	KEY plano_acao_gestao_agrupamento (plano_acao_gestao_agrupamento),
	KEY plano_acao_gestao_patrocinador (plano_acao_gestao_patrocinador),
	KEY plano_acao_gestao_template (plano_acao_gestao_template),
	KEY plano_acao_gestao_painel (plano_acao_gestao_painel),
	KEY plano_acao_gestao_painel_odometro (plano_acao_gestao_painel_odometro),
	KEY plano_acao_gestao_painel_composicao (plano_acao_gestao_painel_composicao),
	KEY plano_acao_gestao_tr (plano_acao_gestao_tr),
	KEY plano_acao_gestao_me (plano_acao_gestao_me),
	KEY plano_acao_gestao_acao_item (plano_acao_gestao_acao_item),
	KEY plano_acao_gestao_beneficio (plano_acao_gestao_beneficio),
	KEY plano_acao_gestao_painel_slideshow (plano_acao_gestao_painel_slideshow),
	KEY plano_acao_gestao_projeto_viabilidade (plano_acao_gestao_projeto_viabilidade),
	KEY plano_acao_gestao_projeto_abertura (plano_acao_gestao_projeto_abertura),
	KEY plano_acao_gestao_plano_gestao (plano_acao_gestao_plano_gestao),
	CONSTRAINT plano_acao_gestao_acao FOREIGN KEY (plano_acao_gestao_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_semelhante FOREIGN KEY (plano_acao_gestao_semelhante) REFERENCES plano_acao (plano_acao_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_projeto FOREIGN KEY (plano_acao_gestao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_tarefa FOREIGN KEY (plano_acao_gestao_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_perspectiva FOREIGN KEY (plano_acao_gestao_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_tema FOREIGN KEY (plano_acao_gestao_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_objetivo FOREIGN KEY (plano_acao_gestao_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_fator FOREIGN KEY (plano_acao_gestao_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_estrategia FOREIGN KEY (plano_acao_gestao_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_meta FOREIGN KEY (plano_acao_gestao_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_pratica FOREIGN KEY (plano_acao_gestao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_indicador FOREIGN KEY (plano_acao_gestao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_canvas FOREIGN KEY (plano_acao_gestao_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_risco FOREIGN KEY (plano_acao_gestao_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_risco_resposta FOREIGN KEY (plano_acao_gestao_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_calendario FOREIGN KEY (plano_acao_gestao_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_monitoramento FOREIGN KEY (plano_acao_gestao_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_ata FOREIGN KEY (plano_acao_gestao_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_mswot FOREIGN KEY (plano_acao_gestao_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_swot FOREIGN KEY (plano_acao_gestao_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_operativo FOREIGN KEY (plano_acao_gestao_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_instrumento FOREIGN KEY (plano_acao_gestao_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_recurso FOREIGN KEY (plano_acao_gestao_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_problema FOREIGN KEY (plano_acao_gestao_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_demanda FOREIGN KEY (plano_acao_gestao_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_programa FOREIGN KEY (plano_acao_gestao_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_licao FOREIGN KEY (plano_acao_gestao_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_evento FOREIGN KEY (plano_acao_gestao_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_link FOREIGN KEY (plano_acao_gestao_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_avaliacao FOREIGN KEY (plano_acao_gestao_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_tgn FOREIGN KEY (plano_acao_gestao_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_brainstorm FOREIGN KEY (plano_acao_gestao_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_gut FOREIGN KEY (plano_acao_gestao_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_causa_efeito FOREIGN KEY (plano_acao_gestao_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_arquivo FOREIGN KEY (plano_acao_gestao_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_forum FOREIGN KEY (plano_acao_gestao_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_checklist FOREIGN KEY (plano_acao_gestao_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_agenda FOREIGN KEY (plano_acao_gestao_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_agrupamento FOREIGN KEY (plano_acao_gestao_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_patrocinador FOREIGN KEY (plano_acao_gestao_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_template FOREIGN KEY (plano_acao_gestao_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_painel FOREIGN KEY (plano_acao_gestao_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_painel_odometro FOREIGN KEY (plano_acao_gestao_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_painel_composicao FOREIGN KEY (plano_acao_gestao_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_tr FOREIGN KEY (plano_acao_gestao_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_me FOREIGN KEY (plano_acao_gestao_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_acao_item FOREIGN KEY (plano_acao_gestao_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_beneficio FOREIGN KEY (plano_acao_gestao_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_painel_slideshow FOREIGN KEY (plano_acao_gestao_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_projeto_viabilidade FOREIGN KEY (plano_acao_gestao_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_projeto_abertura FOREIGN KEY (plano_acao_gestao_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_gestao_plano_gestao FOREIGN KEY (plano_acao_gestao_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS plano_acao_item_gestao;

CREATE TABLE plano_acao_item_gestao (
	plano_acao_item_gestao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	plano_acao_item_gestao_plano_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY plano_acao_item_gestao_id (plano_acao_item_gestao_id),
	KEY plano_acao_item_gestao_plano_acao_item (plano_acao_item_gestao_plano_acao_item),
	KEY plano_acao_item_gestao_semelhante (plano_acao_item_gestao_semelhante),
	KEY plano_acao_item_gestao_projeto (plano_acao_item_gestao_projeto),
	KEY plano_acao_item_gestao_tarefa (plano_acao_item_gestao_tarefa),
	KEY plano_acao_item_gestao_perspectiva (plano_acao_item_gestao_perspectiva),
	KEY plano_acao_item_gestao_tema (plano_acao_item_gestao_tema),
	KEY plano_acao_item_gestao_objetivo (plano_acao_item_gestao_objetivo),
	KEY plano_acao_item_gestao_estrategia (plano_acao_item_gestao_estrategia),
	KEY plano_acao_item_gestao_meta (plano_acao_item_gestao_meta),
	KEY plano_acao_item_gestao_fator (plano_acao_item_gestao_fator),
	KEY plano_acao_item_gestao_pratica (plano_acao_item_gestao_pratica),
	KEY plano_acao_item_gestao_indicador (plano_acao_item_gestao_indicador),
	KEY plano_acao_item_gestao_acao (plano_acao_item_gestao_acao),
	KEY plano_acao_item_gestao_canvas (plano_acao_item_gestao_canvas),
	KEY plano_acao_item_gestao_risco (plano_acao_item_gestao_risco),
	KEY plano_acao_item_gestao_risco_resposta (plano_acao_item_gestao_risco_resposta),
	KEY plano_acao_item_gestao_calendario (plano_acao_item_gestao_calendario),
	KEY plano_acao_item_gestao_monitoramento (plano_acao_item_gestao_monitoramento),
	KEY plano_acao_item_gestao_ata (plano_acao_item_gestao_ata),
	KEY plano_acao_item_gestao_mswot(plano_acao_item_gestao_mswot),
	KEY plano_acao_item_gestao_swot(plano_acao_item_gestao_swot),
	KEY plano_acao_item_gestao_operativo(plano_acao_item_gestao_operativo),
	KEY plano_acao_item_gestao_instrumento (plano_acao_item_gestao_instrumento),
	KEY plano_acao_item_gestao_recurso (plano_acao_item_gestao_recurso),
	KEY plano_acao_item_gestao_problema (plano_acao_item_gestao_problema),
	KEY plano_acao_item_gestao_demanda (plano_acao_item_gestao_demanda),
	KEY plano_acao_item_gestao_programa (plano_acao_item_gestao_programa),
	KEY plano_acao_item_gestao_licao (plano_acao_item_gestao_licao),
	KEY plano_acao_item_gestao_evento (plano_acao_item_gestao_evento),
	KEY plano_acao_item_gestao_link (plano_acao_item_gestao_link),
	KEY plano_acao_item_gestao_avaliacao (plano_acao_item_gestao_avaliacao),
	KEY plano_acao_item_gestao_tgn (plano_acao_item_gestao_tgn),
	KEY plano_acao_item_gestao_brainstorm (plano_acao_item_gestao_brainstorm),
	KEY plano_acao_item_gestao_gut (plano_acao_item_gestao_gut),
	KEY plano_acao_item_gestao_causa_efeito (plano_acao_item_gestao_causa_efeito),
	KEY plano_acao_item_gestao_arquivo (plano_acao_item_gestao_arquivo),
	KEY plano_acao_item_gestao_forum (plano_acao_item_gestao_forum),
	KEY plano_acao_item_gestao_checklist (plano_acao_item_gestao_checklist),
	KEY plano_acao_item_gestao_agenda (plano_acao_item_gestao_agenda),
	KEY plano_acao_item_gestao_agrupamento (plano_acao_item_gestao_agrupamento),
	KEY plano_acao_item_gestao_patrocinador (plano_acao_item_gestao_patrocinador),
	KEY plano_acao_item_gestao_template (plano_acao_item_gestao_template),
	KEY plano_acao_item_gestao_painel (plano_acao_item_gestao_painel),
	KEY plano_acao_item_gestao_painel_odometro (plano_acao_item_gestao_painel_odometro),
	KEY plano_acao_item_gestao_painel_composicao (plano_acao_item_gestao_painel_composicao),
	KEY plano_acao_item_gestao_tr (plano_acao_item_gestao_tr),
	KEY plano_acao_item_gestao_me (plano_acao_item_gestao_me),
	KEY plano_acao_item_gestao_beneficio (plano_acao_item_gestao_beneficio),
	KEY plano_acao_item_gestao_painel_slideshow (plano_acao_item_gestao_painel_slideshow),
	KEY plano_acao_item_gestao_projeto_viabilidade (plano_acao_item_gestao_projeto_viabilidade),
	KEY plano_acao_item_gestao_projeto_abertura (plano_acao_item_gestao_projeto_abertura),
	KEY plano_acao_item_gestao_plano_gestao (plano_acao_item_gestao_plano_gestao),
	CONSTRAINT plano_acao_item_gestao_plano_acao_item FOREIGN KEY (plano_acao_item_gestao_plano_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_semelhante FOREIGN KEY (plano_acao_item_gestao_semelhante) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_projeto FOREIGN KEY (plano_acao_item_gestao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_tarefa FOREIGN KEY (plano_acao_item_gestao_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_perspectiva FOREIGN KEY (plano_acao_item_gestao_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_tema FOREIGN KEY (plano_acao_item_gestao_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_objetivo FOREIGN KEY (plano_acao_item_gestao_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_fator FOREIGN KEY (plano_acao_item_gestao_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_estrategia FOREIGN KEY (plano_acao_item_gestao_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_meta FOREIGN KEY (plano_acao_item_gestao_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_pratica FOREIGN KEY (plano_acao_item_gestao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_indicador FOREIGN KEY (plano_acao_item_gestao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_acao FOREIGN KEY (plano_acao_item_gestao_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_canvas FOREIGN KEY (plano_acao_item_gestao_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_risco FOREIGN KEY (plano_acao_item_gestao_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_risco_resposta FOREIGN KEY (plano_acao_item_gestao_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_calendario FOREIGN KEY (plano_acao_item_gestao_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_monitoramento FOREIGN KEY (plano_acao_item_gestao_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_ata FOREIGN KEY (plano_acao_item_gestao_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_mswot FOREIGN KEY (plano_acao_item_gestao_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_swot FOREIGN KEY (plano_acao_item_gestao_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_operativo FOREIGN KEY (plano_acao_item_gestao_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_instrumento FOREIGN KEY (plano_acao_item_gestao_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_recurso FOREIGN KEY (plano_acao_item_gestao_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_problema FOREIGN KEY (plano_acao_item_gestao_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_demanda FOREIGN KEY (plano_acao_item_gestao_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_programa FOREIGN KEY (plano_acao_item_gestao_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_licao FOREIGN KEY (plano_acao_item_gestao_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_evento FOREIGN KEY (plano_acao_item_gestao_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_link FOREIGN KEY (plano_acao_item_gestao_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_avaliacao FOREIGN KEY (plano_acao_item_gestao_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_tgn FOREIGN KEY (plano_acao_item_gestao_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_brainstorm FOREIGN KEY (plano_acao_item_gestao_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_gut FOREIGN KEY (plano_acao_item_gestao_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_causa_efeito FOREIGN KEY (plano_acao_item_gestao_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_arquivo FOREIGN KEY (plano_acao_item_gestao_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_forum FOREIGN KEY (plano_acao_item_gestao_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_checklist FOREIGN KEY (plano_acao_item_gestao_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_agenda FOREIGN KEY (plano_acao_item_gestao_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_agrupamento FOREIGN KEY (plano_acao_item_gestao_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_patrocinador FOREIGN KEY (plano_acao_item_gestao_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_template FOREIGN KEY (plano_acao_item_gestao_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_painel FOREIGN KEY (plano_acao_item_gestao_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_painel_odometro FOREIGN KEY (plano_acao_item_gestao_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_painel_composicao FOREIGN KEY (plano_acao_item_gestao_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_tr FOREIGN KEY (plano_acao_item_gestao_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_me FOREIGN KEY (plano_acao_item_gestao_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_beneficio FOREIGN KEY (plano_acao_item_gestao_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_painel_slideshow FOREIGN KEY (plano_acao_item_gestao_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_projeto_viabilidade FOREIGN KEY (plano_acao_item_gestao_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_projeto_abertura FOREIGN KEY (plano_acao_item_gestao_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_item_gestao_plano_gestao FOREIGN KEY (plano_acao_item_gestao_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS evento_gestao;

CREATE TABLE evento_gestao (
	evento_gestao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	evento_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY evento_gestao_id (evento_gestao_id),
	KEY evento_gestao_evento (evento_gestao_evento),
	KEY evento_gestao_semelhante (evento_gestao_semelhante),
	KEY evento_gestao_projeto (evento_gestao_projeto),
	KEY evento_gestao_tarefa (evento_gestao_tarefa),
	KEY evento_gestao_perspectiva (evento_gestao_perspectiva),
	KEY evento_gestao_tema (evento_gestao_tema),
	KEY evento_gestao_objetivo (evento_gestao_objetivo),
	KEY evento_gestao_estrategia (evento_gestao_estrategia),
	KEY evento_gestao_meta (evento_gestao_meta),
	KEY evento_gestao_fator (evento_gestao_fator),
	KEY evento_gestao_pratica (evento_gestao_pratica),
	KEY evento_gestao_indicador (evento_gestao_indicador),
	KEY evento_gestao_acao (evento_gestao_acao),
	KEY evento_gestao_canvas (evento_gestao_canvas),
	KEY evento_gestao_risco (evento_gestao_risco),
	KEY evento_gestao_risco_resposta (evento_gestao_risco_resposta),
	KEY evento_gestao_calendario (evento_gestao_calendario),
	KEY evento_gestao_monitoramento (evento_gestao_monitoramento),
	KEY evento_gestao_ata (evento_gestao_ata),
	KEY evento_gestao_mswot(evento_gestao_mswot),
	KEY evento_gestao_swot(evento_gestao_swot),
	KEY evento_gestao_operativo(evento_gestao_operativo),
	KEY evento_gestao_instrumento (evento_gestao_instrumento),
	KEY evento_gestao_recurso (evento_gestao_recurso),
	KEY evento_gestao_problema (evento_gestao_problema),
	KEY evento_gestao_demanda (evento_gestao_demanda),
	KEY evento_gestao_programa (evento_gestao_programa),
	KEY evento_gestao_licao (evento_gestao_licao),
	KEY evento_gestao_link (evento_gestao_link),
	KEY evento_gestao_avaliacao (evento_gestao_avaliacao),
	KEY evento_gestao_tgn (evento_gestao_tgn),
	KEY evento_gestao_brainstorm (evento_gestao_brainstorm),
	KEY evento_gestao_gut (evento_gestao_gut),
	KEY evento_gestao_causa_efeito (evento_gestao_causa_efeito),
	KEY evento_gestao_arquivo (evento_gestao_arquivo),
	KEY evento_gestao_forum (evento_gestao_forum),
	KEY evento_gestao_checklist (evento_gestao_checklist),
	KEY evento_gestao_agenda (evento_gestao_agenda),
	KEY evento_gestao_agrupamento (evento_gestao_agrupamento),
	KEY evento_gestao_patrocinador (evento_gestao_patrocinador),
	KEY evento_gestao_template (evento_gestao_template),
	KEY evento_gestao_painel (evento_gestao_painel),
	KEY evento_gestao_painel_odometro (evento_gestao_painel_odometro),
	KEY evento_gestao_painel_composicao (evento_gestao_painel_composicao),
	KEY evento_gestao_tr (evento_gestao_tr),
	KEY evento_gestao_me (evento_gestao_me),
	KEY evento_gestao_acao_item (evento_gestao_acao_item),
	KEY evento_gestao_beneficio (evento_gestao_beneficio),
	KEY evento_gestao_painel_slideshow (evento_gestao_painel_slideshow),
	KEY evento_gestao_projeto_viabilidade (evento_gestao_projeto_viabilidade),
	KEY evento_gestao_projeto_abertura (evento_gestao_projeto_abertura),
	KEY evento_gestao_plano_gestao (evento_gestao_plano_gestao),
	CONSTRAINT evento_gestao_evento FOREIGN KEY (evento_gestao_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_semelhante FOREIGN KEY (evento_gestao_semelhante) REFERENCES eventos (evento_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_projeto FOREIGN KEY (evento_gestao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_tarefa FOREIGN KEY (evento_gestao_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_perspectiva FOREIGN KEY (evento_gestao_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_tema FOREIGN KEY (evento_gestao_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_objetivo FOREIGN KEY (evento_gestao_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_fator FOREIGN KEY (evento_gestao_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_estrategia FOREIGN KEY (evento_gestao_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_meta FOREIGN KEY (evento_gestao_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_pratica FOREIGN KEY (evento_gestao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_indicador FOREIGN KEY (evento_gestao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_acao FOREIGN KEY (evento_gestao_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_canvas FOREIGN KEY (evento_gestao_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_risco FOREIGN KEY (evento_gestao_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_risco_resposta FOREIGN KEY (evento_gestao_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_calendario FOREIGN KEY (evento_gestao_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_monitoramento FOREIGN KEY (evento_gestao_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_ata FOREIGN KEY (evento_gestao_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_mswot FOREIGN KEY (evento_gestao_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_swot FOREIGN KEY (evento_gestao_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_operativo FOREIGN KEY (evento_gestao_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_instrumento FOREIGN KEY (evento_gestao_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_recurso FOREIGN KEY (evento_gestao_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_problema FOREIGN KEY (evento_gestao_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_demanda FOREIGN KEY (evento_gestao_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_programa FOREIGN KEY (evento_gestao_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_licao FOREIGN KEY (evento_gestao_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_link FOREIGN KEY (evento_gestao_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_avaliacao FOREIGN KEY (evento_gestao_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_tgn FOREIGN KEY (evento_gestao_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_brainstorm FOREIGN KEY (evento_gestao_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_gut FOREIGN KEY (evento_gestao_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_causa_efeito FOREIGN KEY (evento_gestao_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_arquivo FOREIGN KEY (evento_gestao_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_forum FOREIGN KEY (evento_gestao_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_checklist FOREIGN KEY (evento_gestao_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_agenda FOREIGN KEY (evento_gestao_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_agrupamento FOREIGN KEY (evento_gestao_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_patrocinador FOREIGN KEY (evento_gestao_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_template FOREIGN KEY (evento_gestao_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_painel FOREIGN KEY (evento_gestao_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_painel_odometro FOREIGN KEY (evento_gestao_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_painel_composicao FOREIGN KEY (evento_gestao_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_tr FOREIGN KEY (evento_gestao_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_me FOREIGN KEY (evento_gestao_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_acao_item FOREIGN KEY (evento_gestao_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_beneficio FOREIGN KEY (evento_gestao_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_painel_slideshow FOREIGN KEY (evento_gestao_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_projeto_viabilidade FOREIGN KEY (evento_gestao_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_projeto_abertura FOREIGN KEY (evento_gestao_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT evento_gestao_plano_gestao FOREIGN KEY (evento_gestao_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_evento_gestao;

CREATE TABLE baseline_evento_gestao (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	evento_gestao_id INTEGER(100) UNSIGNED NOT NULL,
	evento_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	evento_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (baseline_id, evento_gestao_id),
  CONSTRAINT evento_gestao_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;




DROP TABLE IF EXISTS forum_gestao;

CREATE TABLE forum_gestao (
	forum_gestao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	forum_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY forum_gestao_id (forum_gestao_id),
	KEY forum_gestao_forum (forum_gestao_forum),
	KEY forum_gestao_semelhante (forum_gestao_semelhante),
	KEY forum_gestao_projeto (forum_gestao_projeto),
	KEY forum_gestao_tarefa (forum_gestao_tarefa),
	KEY forum_gestao_perspectiva (forum_gestao_perspectiva),
	KEY forum_gestao_tema (forum_gestao_tema),
	KEY forum_gestao_objetivo (forum_gestao_objetivo),
	KEY forum_gestao_estrategia (forum_gestao_estrategia),
	KEY forum_gestao_meta (forum_gestao_meta),
	KEY forum_gestao_fator (forum_gestao_fator),
	KEY forum_gestao_pratica (forum_gestao_pratica),
	KEY forum_gestao_indicador (forum_gestao_indicador),
	KEY forum_gestao_acao (forum_gestao_acao),
	KEY forum_gestao_canvas (forum_gestao_canvas),
	KEY forum_gestao_risco (forum_gestao_risco),
	KEY forum_gestao_risco_resposta (forum_gestao_risco_resposta),
	KEY forum_gestao_calendario (forum_gestao_calendario),
	KEY forum_gestao_monitoramento (forum_gestao_monitoramento),
	KEY forum_gestao_ata (forum_gestao_ata),
	KEY forum_gestao_mswot(forum_gestao_mswot),
	KEY forum_gestao_swot(forum_gestao_swot),
	KEY forum_gestao_operativo(forum_gestao_operativo),
	KEY forum_gestao_instrumento (forum_gestao_instrumento),
	KEY forum_gestao_recurso (forum_gestao_recurso),
	KEY forum_gestao_problema (forum_gestao_problema),
	KEY forum_gestao_demanda (forum_gestao_demanda),
	KEY forum_gestao_programa (forum_gestao_programa),
	KEY forum_gestao_licao (forum_gestao_licao),
	KEY forum_gestao_evento (forum_gestao_evento),
	KEY forum_gestao_link (forum_gestao_link),
	KEY forum_gestao_avaliacao (forum_gestao_avaliacao),
	KEY forum_gestao_tgn (forum_gestao_tgn),
	KEY forum_gestao_brainstorm (forum_gestao_brainstorm),
	KEY forum_gestao_gut (forum_gestao_gut),
	KEY forum_gestao_causa_efeito (forum_gestao_causa_efeito),
	KEY forum_gestao_arquivo (forum_gestao_arquivo),
	KEY forum_gestao_checklist (forum_gestao_checklist),
	KEY forum_gestao_agenda (forum_gestao_agenda),
	KEY forum_gestao_agrupamento (forum_gestao_agrupamento),
	KEY forum_gestao_patrocinador (forum_gestao_patrocinador),
	KEY forum_gestao_template (forum_gestao_template),
	KEY forum_gestao_painel (forum_gestao_painel),
	KEY forum_gestao_painel_odometro (forum_gestao_painel_odometro),
	KEY forum_gestao_painel_composicao (forum_gestao_painel_composicao),
	KEY forum_gestao_tr (forum_gestao_tr),
	KEY forum_gestao_me (forum_gestao_me),
	KEY forum_gestao_acao_item (forum_gestao_acao_item),
	KEY forum_gestao_beneficio (forum_gestao_beneficio),
	KEY forum_gestao_painel_slideshow (forum_gestao_painel_slideshow),
	KEY forum_gestao_projeto_viabilidade (forum_gestao_projeto_viabilidade),
	KEY forum_gestao_projeto_abertura (forum_gestao_projeto_abertura),
	KEY forum_gestao_plano_gestao (forum_gestao_plano_gestao),
	CONSTRAINT forum_gestao_forum FOREIGN KEY (forum_gestao_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_semelhante FOREIGN KEY (forum_gestao_semelhante) REFERENCES foruns (forum_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_projeto FOREIGN KEY (forum_gestao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_tarefa FOREIGN KEY (forum_gestao_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_perspectiva FOREIGN KEY (forum_gestao_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_tema FOREIGN KEY (forum_gestao_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_objetivo FOREIGN KEY (forum_gestao_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_fator FOREIGN KEY (forum_gestao_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_estrategia FOREIGN KEY (forum_gestao_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_meta FOREIGN KEY (forum_gestao_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_pratica FOREIGN KEY (forum_gestao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_indicador FOREIGN KEY (forum_gestao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_acao FOREIGN KEY (forum_gestao_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_canvas FOREIGN KEY (forum_gestao_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_risco FOREIGN KEY (forum_gestao_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_risco_resposta FOREIGN KEY (forum_gestao_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_calendario FOREIGN KEY (forum_gestao_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_monitoramento FOREIGN KEY (forum_gestao_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_ata FOREIGN KEY (forum_gestao_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_mswot FOREIGN KEY (forum_gestao_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_swot FOREIGN KEY (forum_gestao_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_operativo FOREIGN KEY (forum_gestao_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_instrumento FOREIGN KEY (forum_gestao_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_recurso FOREIGN KEY (forum_gestao_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_problema FOREIGN KEY (forum_gestao_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_demanda FOREIGN KEY (forum_gestao_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_programa FOREIGN KEY (forum_gestao_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_licao FOREIGN KEY (forum_gestao_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_evento FOREIGN KEY (forum_gestao_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_link FOREIGN KEY (forum_gestao_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_avaliacao FOREIGN KEY (forum_gestao_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_tgn FOREIGN KEY (forum_gestao_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_brainstorm FOREIGN KEY (forum_gestao_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_gut FOREIGN KEY (forum_gestao_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_causa_efeito FOREIGN KEY (forum_gestao_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_arquivo FOREIGN KEY (forum_gestao_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_checklist FOREIGN KEY (forum_gestao_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_agenda FOREIGN KEY (forum_gestao_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_agrupamento FOREIGN KEY (forum_gestao_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_patrocinador FOREIGN KEY (forum_gestao_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_template FOREIGN KEY (forum_gestao_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_painel FOREIGN KEY (forum_gestao_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_painel_odometro FOREIGN KEY (forum_gestao_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_painel_composicao FOREIGN KEY (forum_gestao_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_tr FOREIGN KEY (forum_gestao_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_me FOREIGN KEY (forum_gestao_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_acao_item FOREIGN KEY (forum_gestao_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_beneficio FOREIGN KEY (forum_gestao_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_painel_slideshow FOREIGN KEY (forum_gestao_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_projeto_viabilidade FOREIGN KEY (forum_gestao_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_projeto_abertura FOREIGN KEY (forum_gestao_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT forum_gestao_plano_gestao FOREIGN KEY (forum_gestao_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS link_gestao;

CREATE TABLE link_gestao (
	link_gestao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	link_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY link_gestao_id (link_gestao_id),
	KEY link_gestao_link (link_gestao_link),
	KEY link_gestao_semelhante (link_gestao_semelhante),
	KEY link_gestao_projeto (link_gestao_projeto),
	KEY link_gestao_tarefa (link_gestao_tarefa),
	KEY link_gestao_perspectiva (link_gestao_perspectiva),
	KEY link_gestao_tema (link_gestao_tema),
	KEY link_gestao_objetivo (link_gestao_objetivo),
	KEY link_gestao_estrategia (link_gestao_estrategia),
	KEY link_gestao_meta (link_gestao_meta),
	KEY link_gestao_fator (link_gestao_fator),
	KEY link_gestao_pratica (link_gestao_pratica),
	KEY link_gestao_indicador (link_gestao_indicador),
	KEY link_gestao_acao (link_gestao_acao),
	KEY link_gestao_canvas (link_gestao_canvas),
	KEY link_gestao_risco (link_gestao_risco),
	KEY link_gestao_risco_resposta (link_gestao_risco_resposta),
	KEY link_gestao_calendario (link_gestao_calendario),
	KEY link_gestao_monitoramento (link_gestao_monitoramento),
	KEY link_gestao_ata (link_gestao_ata),
	KEY link_gestao_mswot(link_gestao_mswot),
	KEY link_gestao_swot(link_gestao_swot),
	KEY link_gestao_operativo(link_gestao_operativo),
	KEY link_gestao_instrumento (link_gestao_instrumento),
	KEY link_gestao_recurso (link_gestao_recurso),
	KEY link_gestao_problema (link_gestao_problema),
	KEY link_gestao_demanda (link_gestao_demanda),
	KEY link_gestao_programa (link_gestao_programa),
	KEY link_gestao_licao (link_gestao_licao),
	KEY link_gestao_evento (link_gestao_evento),
	KEY link_gestao_avaliacao (link_gestao_avaliacao),
	KEY link_gestao_tgn (link_gestao_tgn),
	KEY link_gestao_brainstorm (link_gestao_brainstorm),
	KEY link_gestao_gut (link_gestao_gut),
	KEY link_gestao_causa_efeito (link_gestao_causa_efeito),
	KEY link_gestao_arquivo (link_gestao_arquivo),
	KEY link_gestao_forum (link_gestao_forum),
	KEY link_gestao_checklist (link_gestao_checklist),
	KEY link_gestao_agenda (link_gestao_agenda),
	KEY link_gestao_agrupamento (link_gestao_agrupamento),
	KEY link_gestao_patrocinador (link_gestao_patrocinador),
	KEY link_gestao_template (link_gestao_template),
	KEY link_gestao_painel (link_gestao_painel),
	KEY link_gestao_painel_odometro (link_gestao_painel_odometro),
	KEY link_gestao_painel_composicao (link_gestao_painel_composicao),
	KEY link_gestao_tr (link_gestao_tr),
	KEY link_gestao_me (link_gestao_me),
	KEY link_gestao_acao_item (link_gestao_acao_item),
	KEY link_gestao_beneficio (link_gestao_beneficio),
	KEY link_gestao_painel_slideshow (link_gestao_painel_slideshow),
	KEY link_gestao_projeto_viabilidade (link_gestao_projeto_viabilidade),
	KEY link_gestao_projeto_abertura (link_gestao_projeto_abertura),
	KEY link_gestao_plano_gestao (link_gestao_plano_gestao),
	CONSTRAINT link_gestao_link FOREIGN KEY (link_gestao_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_semelhante FOREIGN KEY (link_gestao_semelhante) REFERENCES links (link_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT link_gestao_projeto FOREIGN KEY (link_gestao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_tarefa FOREIGN KEY (link_gestao_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_perspectiva FOREIGN KEY (link_gestao_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_tema FOREIGN KEY (link_gestao_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_objetivo FOREIGN KEY (link_gestao_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_fator FOREIGN KEY (link_gestao_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_estrategia FOREIGN KEY (link_gestao_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_meta FOREIGN KEY (link_gestao_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_pratica FOREIGN KEY (link_gestao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_indicador FOREIGN KEY (link_gestao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_acao FOREIGN KEY (link_gestao_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_canvas FOREIGN KEY (link_gestao_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_risco FOREIGN KEY (link_gestao_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_risco_resposta FOREIGN KEY (link_gestao_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_calendario FOREIGN KEY (link_gestao_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_monitoramento FOREIGN KEY (link_gestao_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_ata FOREIGN KEY (link_gestao_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_mswot FOREIGN KEY (link_gestao_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_swot FOREIGN KEY (link_gestao_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_operativo FOREIGN KEY (link_gestao_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_instrumento FOREIGN KEY (link_gestao_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_recurso FOREIGN KEY (link_gestao_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_problema FOREIGN KEY (link_gestao_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_demanda FOREIGN KEY (link_gestao_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_programa FOREIGN KEY (link_gestao_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_licao FOREIGN KEY (link_gestao_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_evento FOREIGN KEY (link_gestao_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_avaliacao FOREIGN KEY (link_gestao_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_tgn FOREIGN KEY (link_gestao_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_brainstorm FOREIGN KEY (link_gestao_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_gut FOREIGN KEY (link_gestao_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_causa_efeito FOREIGN KEY (link_gestao_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_arquivo FOREIGN KEY (link_gestao_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_forum FOREIGN KEY (link_gestao_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_checklist FOREIGN KEY (link_gestao_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_agenda FOREIGN KEY (link_gestao_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_agrupamento FOREIGN KEY (link_gestao_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_patrocinador FOREIGN KEY (link_gestao_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_template FOREIGN KEY (link_gestao_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_painel FOREIGN KEY (link_gestao_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_painel_odometro FOREIGN KEY (link_gestao_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_painel_composicao FOREIGN KEY (link_gestao_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_tr FOREIGN KEY (link_gestao_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_me FOREIGN KEY (link_gestao_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_acao_item FOREIGN KEY (link_gestao_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_beneficio FOREIGN KEY (link_gestao_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_painel_slideshow FOREIGN KEY (link_gestao_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_projeto_viabilidade FOREIGN KEY (link_gestao_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_projeto_abertura FOREIGN KEY (link_gestao_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT link_gestao_plano_gestao FOREIGN KEY (link_gestao_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS patrocinador_gestao;

CREATE TABLE patrocinador_gestao (
	patrocinador_gestao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	patrocinador_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY patrocinador_gestao_id (patrocinador_gestao_id),
	KEY patrocinador_gestao_patrocinador (patrocinador_gestao_patrocinador),
	KEY patrocinador_gestao_semelhante (patrocinador_gestao_semelhante),
	KEY patrocinador_gestao_projeto (patrocinador_gestao_projeto),
	KEY patrocinador_gestao_tarefa (patrocinador_gestao_tarefa),
	KEY patrocinador_gestao_perspectiva (patrocinador_gestao_perspectiva),
	KEY patrocinador_gestao_tema (patrocinador_gestao_tema),
	KEY patrocinador_gestao_objetivo (patrocinador_gestao_objetivo),
	KEY patrocinador_gestao_estrategia (patrocinador_gestao_estrategia),
	KEY patrocinador_gestao_meta (patrocinador_gestao_meta),
	KEY patrocinador_gestao_fator (patrocinador_gestao_fator),
	KEY patrocinador_gestao_pratica (patrocinador_gestao_pratica),
	KEY patrocinador_gestao_indicador (patrocinador_gestao_indicador),
	KEY patrocinador_gestao_acao (patrocinador_gestao_acao),
	KEY patrocinador_gestao_canvas (patrocinador_gestao_canvas),
	KEY patrocinador_gestao_risco (patrocinador_gestao_risco),
	KEY patrocinador_gestao_risco_resposta (patrocinador_gestao_risco_resposta),
	KEY patrocinador_gestao_calendario (patrocinador_gestao_calendario),
	KEY patrocinador_gestao_monitoramento (patrocinador_gestao_monitoramento),
	KEY patrocinador_gestao_ata (patrocinador_gestao_ata),
	KEY patrocinador_gestao_mswot(patrocinador_gestao_mswot),
	KEY patrocinador_gestao_swot(patrocinador_gestao_swot),
	KEY patrocinador_gestao_operativo(patrocinador_gestao_operativo),
	KEY patrocinador_gestao_instrumento (patrocinador_gestao_instrumento),
	KEY patrocinador_gestao_recurso (patrocinador_gestao_recurso),
	KEY patrocinador_gestao_problema (patrocinador_gestao_problema),
	KEY patrocinador_gestao_demanda (patrocinador_gestao_demanda),
	KEY patrocinador_gestao_programa (patrocinador_gestao_programa),
	KEY patrocinador_gestao_licao (patrocinador_gestao_licao),
	KEY patrocinador_gestao_evento (patrocinador_gestao_evento),
	KEY patrocinador_gestao_link (patrocinador_gestao_link),
	KEY patrocinador_gestao_avaliacao (patrocinador_gestao_avaliacao),
	KEY patrocinador_gestao_tgn (patrocinador_gestao_tgn),
	KEY patrocinador_gestao_brainstorm (patrocinador_gestao_brainstorm),
	KEY patrocinador_gestao_gut (patrocinador_gestao_gut),
	KEY patrocinador_gestao_causa_efeito (patrocinador_gestao_causa_efeito),
	KEY patrocinador_gestao_arquivo (patrocinador_gestao_arquivo),
	KEY patrocinador_gestao_forum (patrocinador_gestao_forum),
	KEY patrocinador_gestao_checklist (patrocinador_gestao_checklist),
	KEY patrocinador_gestao_agenda (patrocinador_gestao_agenda),
	KEY patrocinador_gestao_agrupamento (patrocinador_gestao_agrupamento),
	KEY patrocinador_gestao_template (patrocinador_gestao_template),
	KEY patrocinador_gestao_painel (patrocinador_gestao_painel),
	KEY patrocinador_gestao_painel_odometro (patrocinador_gestao_painel_odometro),
	KEY patrocinador_gestao_painel_composicao (patrocinador_gestao_painel_composicao),
	KEY patrocinador_gestao_tr (patrocinador_gestao_tr),
	KEY patrocinador_gestao_me (patrocinador_gestao_me),
	KEY patrocinador_gestao_acao_item (patrocinador_gestao_acao_item),
	KEY patrocinador_gestao_beneficio (patrocinador_gestao_beneficio),
	KEY patrocinador_gestao_painel_slideshow (patrocinador_gestao_painel_slideshow),
	KEY patrocinador_gestao_projeto_viabilidade (patrocinador_gestao_projeto_viabilidade),
	KEY patrocinador_gestao_projeto_abertura (patrocinador_gestao_projeto_abertura),
	KEY patrocinador_gestao_plano_gestao (patrocinador_gestao_plano_gestao),
	CONSTRAINT patrocinador_gestao_patrocinador FOREIGN KEY (patrocinador_gestao_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_semelhante FOREIGN KEY (patrocinador_gestao_semelhante) REFERENCES patrocinadores (patrocinador_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_projeto FOREIGN KEY (patrocinador_gestao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_tarefa FOREIGN KEY (patrocinador_gestao_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_perspectiva FOREIGN KEY (patrocinador_gestao_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_tema FOREIGN KEY (patrocinador_gestao_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_objetivo FOREIGN KEY (patrocinador_gestao_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_fator FOREIGN KEY (patrocinador_gestao_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_estrategia FOREIGN KEY (patrocinador_gestao_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_meta FOREIGN KEY (patrocinador_gestao_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_pratica FOREIGN KEY (patrocinador_gestao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_indicador FOREIGN KEY (patrocinador_gestao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_acao FOREIGN KEY (patrocinador_gestao_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_canvas FOREIGN KEY (patrocinador_gestao_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_risco FOREIGN KEY (patrocinador_gestao_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_risco_resposta FOREIGN KEY (patrocinador_gestao_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_calendario FOREIGN KEY (patrocinador_gestao_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_monitoramento FOREIGN KEY (patrocinador_gestao_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_ata FOREIGN KEY (patrocinador_gestao_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_mswot FOREIGN KEY (patrocinador_gestao_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_swot FOREIGN KEY (patrocinador_gestao_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_operativo FOREIGN KEY (patrocinador_gestao_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_instrumento FOREIGN KEY (patrocinador_gestao_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_recurso FOREIGN KEY (patrocinador_gestao_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_problema FOREIGN KEY (patrocinador_gestao_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_demanda FOREIGN KEY (patrocinador_gestao_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_programa FOREIGN KEY (patrocinador_gestao_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_licao FOREIGN KEY (patrocinador_gestao_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_evento FOREIGN KEY (patrocinador_gestao_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_link FOREIGN KEY (patrocinador_gestao_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_avaliacao FOREIGN KEY (patrocinador_gestao_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_tgn FOREIGN KEY (patrocinador_gestao_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_brainstorm FOREIGN KEY (patrocinador_gestao_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_gut FOREIGN KEY (patrocinador_gestao_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_causa_efeito FOREIGN KEY (patrocinador_gestao_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_arquivo FOREIGN KEY (patrocinador_gestao_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_forum FOREIGN KEY (patrocinador_gestao_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_checklist FOREIGN KEY (patrocinador_gestao_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_agenda FOREIGN KEY (patrocinador_gestao_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_agrupamento FOREIGN KEY (patrocinador_gestao_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_template FOREIGN KEY (patrocinador_gestao_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_painel FOREIGN KEY (patrocinador_gestao_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_painel_odometro FOREIGN KEY (patrocinador_gestao_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_painel_composicao FOREIGN KEY (patrocinador_gestao_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_tr FOREIGN KEY (patrocinador_gestao_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_me FOREIGN KEY (patrocinador_gestao_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_acao_item FOREIGN KEY (patrocinador_gestao_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_beneficio FOREIGN KEY (patrocinador_gestao_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_painel_slideshow FOREIGN KEY (patrocinador_gestao_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_projeto_viabilidade FOREIGN KEY (patrocinador_gestao_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_projeto_abertura FOREIGN KEY (patrocinador_gestao_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT patrocinador_gestao_plano_gestao FOREIGN KEY (patrocinador_gestao_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS operativo_gestao;

CREATE TABLE operativo_gestao (
	operativo_gestao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	operativo_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY operativo_gestao_id (operativo_gestao_id),
	KEY operativo_gestao_operativo (operativo_gestao_operativo),
	KEY operativo_gestao_semelhante (operativo_gestao_semelhante),
	KEY operativo_gestao_projeto (operativo_gestao_projeto),
	KEY operativo_gestao_tarefa (operativo_gestao_tarefa),
	KEY operativo_gestao_perspectiva (operativo_gestao_perspectiva),
	KEY operativo_gestao_tema (operativo_gestao_tema),
	KEY operativo_gestao_objetivo (operativo_gestao_objetivo),
	KEY operativo_gestao_estrategia (operativo_gestao_estrategia),
	KEY operativo_gestao_meta (operativo_gestao_meta),
	KEY operativo_gestao_fator (operativo_gestao_fator),
	KEY operativo_gestao_pratica (operativo_gestao_pratica),
	KEY operativo_gestao_indicador (operativo_gestao_indicador),
	KEY operativo_gestao_acao (operativo_gestao_acao),
	KEY operativo_gestao_canvas (operativo_gestao_canvas),
	KEY operativo_gestao_risco (operativo_gestao_risco),
	KEY operativo_gestao_risco_resposta (operativo_gestao_risco_resposta),
	KEY operativo_gestao_calendario (operativo_gestao_calendario),
	KEY operativo_gestao_monitoramento (operativo_gestao_monitoramento),
	KEY operativo_gestao_ata (operativo_gestao_ata),
	KEY operativo_gestao_mswot(operativo_gestao_mswot),
	KEY operativo_gestao_swot(operativo_gestao_swot),
	KEY operativo_gestao_instrumento (operativo_gestao_instrumento),
	KEY operativo_gestao_recurso (operativo_gestao_recurso),
	KEY operativo_gestao_problema (operativo_gestao_problema),
	KEY operativo_gestao_demanda (operativo_gestao_demanda),
	KEY operativo_gestao_programa (operativo_gestao_programa),
	KEY operativo_gestao_licao (operativo_gestao_licao),
	KEY operativo_gestao_evento (operativo_gestao_evento),
	KEY operativo_gestao_link (operativo_gestao_link),
	KEY operativo_gestao_avaliacao (operativo_gestao_avaliacao),
	KEY operativo_gestao_tgn (operativo_gestao_tgn),
	KEY operativo_gestao_brainstorm (operativo_gestao_brainstorm),
	KEY operativo_gestao_gut (operativo_gestao_gut),
	KEY operativo_gestao_causa_efeito (operativo_gestao_causa_efeito),
	KEY operativo_gestao_arquivo (operativo_gestao_arquivo),
	KEY operativo_gestao_forum (operativo_gestao_forum),
	KEY operativo_gestao_checklist (operativo_gestao_checklist),
	KEY operativo_gestao_agenda (operativo_gestao_agenda),
	KEY operativo_gestao_agrupamento (operativo_gestao_agrupamento),
	KEY operativo_gestao_patrocinador (operativo_gestao_patrocinador),
	KEY operativo_gestao_template (operativo_gestao_template),
	KEY operativo_gestao_painel (operativo_gestao_painel),
	KEY operativo_gestao_painel_odometro (operativo_gestao_painel_odometro),
	KEY operativo_gestao_painel_composicao (operativo_gestao_painel_composicao),
	KEY operativo_gestao_tr (operativo_gestao_tr),
	KEY operativo_gestao_me (operativo_gestao_me),
	KEY operativo_gestao_acao_item (operativo_gestao_acao_item),
	KEY operativo_gestao_beneficio (operativo_gestao_beneficio),
	KEY operativo_gestao_painel_slideshow (operativo_gestao_painel_slideshow),
	KEY operativo_gestao_projeto_viabilidade (operativo_gestao_projeto_viabilidade),
	KEY operativo_gestao_projeto_abertura (operativo_gestao_projeto_abertura),
	KEY operativo_gestao_plano_gestao (operativo_gestao_plano_gestao),
	CONSTRAINT operativo_gestao_operativo FOREIGN KEY (operativo_gestao_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_semelhante FOREIGN KEY (operativo_gestao_semelhante) REFERENCES operativo (operativo_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_projeto FOREIGN KEY (operativo_gestao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_tarefa FOREIGN KEY (operativo_gestao_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_perspectiva FOREIGN KEY (operativo_gestao_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_tema FOREIGN KEY (operativo_gestao_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_objetivo FOREIGN KEY (operativo_gestao_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_fator FOREIGN KEY (operativo_gestao_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_estrategia FOREIGN KEY (operativo_gestao_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_meta FOREIGN KEY (operativo_gestao_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_pratica FOREIGN KEY (operativo_gestao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_indicador FOREIGN KEY (operativo_gestao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_acao FOREIGN KEY (operativo_gestao_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_canvas FOREIGN KEY (operativo_gestao_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_risco FOREIGN KEY (operativo_gestao_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_risco_resposta FOREIGN KEY (operativo_gestao_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_calendario FOREIGN KEY (operativo_gestao_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_monitoramento FOREIGN KEY (operativo_gestao_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_ata FOREIGN KEY (operativo_gestao_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_mswot FOREIGN KEY (operativo_gestao_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_swot FOREIGN KEY (operativo_gestao_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_instrumento FOREIGN KEY (operativo_gestao_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_recurso FOREIGN KEY (operativo_gestao_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_problema FOREIGN KEY (operativo_gestao_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_demanda FOREIGN KEY (operativo_gestao_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_programa FOREIGN KEY (operativo_gestao_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_licao FOREIGN KEY (operativo_gestao_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_evento FOREIGN KEY (operativo_gestao_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_link FOREIGN KEY (operativo_gestao_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_avaliacao FOREIGN KEY (operativo_gestao_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_tgn FOREIGN KEY (operativo_gestao_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_brainstorm FOREIGN KEY (operativo_gestao_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_gut FOREIGN KEY (operativo_gestao_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_causa_efeito FOREIGN KEY (operativo_gestao_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_arquivo FOREIGN KEY (operativo_gestao_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_forum FOREIGN KEY (operativo_gestao_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_checklist FOREIGN KEY (operativo_gestao_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_agenda FOREIGN KEY (operativo_gestao_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_agrupamento FOREIGN KEY (operativo_gestao_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_patrocinador FOREIGN KEY (operativo_gestao_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_template FOREIGN KEY (operativo_gestao_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_painel FOREIGN KEY (operativo_gestao_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_painel_odometro FOREIGN KEY (operativo_gestao_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_painel_composicao FOREIGN KEY (operativo_gestao_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_tr FOREIGN KEY (operativo_gestao_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_me FOREIGN KEY (operativo_gestao_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_acao_item FOREIGN KEY (operativo_gestao_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_beneficio FOREIGN KEY (operativo_gestao_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_painel_slideshow FOREIGN KEY (operativo_gestao_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_projeto_viabilidade FOREIGN KEY (operativo_gestao_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_projeto_abertura FOREIGN KEY (operativo_gestao_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT operativo_gestao_plano_gestao FOREIGN KEY (operativo_gestao_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS swot_gestao;

CREATE TABLE swot_gestao (
	swot_gestao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	swot_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY swot_gestao_id (swot_gestao_id),
	KEY swot_gestao_swot (swot_gestao_swot),
	KEY swot_gestao_semelhante (swot_gestao_semelhante),
	KEY swot_gestao_mswot (swot_gestao_mswot),
	KEY swot_gestao_projeto (swot_gestao_projeto),
	KEY swot_gestao_tarefa (swot_gestao_tarefa),
	KEY swot_gestao_perspectiva (swot_gestao_perspectiva),
	KEY swot_gestao_tema (swot_gestao_tema),
	KEY swot_gestao_objetivo (swot_gestao_objetivo),
	KEY swot_gestao_estrategia (swot_gestao_estrategia),
	KEY swot_gestao_meta (swot_gestao_meta),
	KEY swot_gestao_fator (swot_gestao_fator),
	KEY swot_gestao_pratica (swot_gestao_pratica),
	KEY swot_gestao_indicador (swot_gestao_indicador),
	KEY swot_gestao_acao (swot_gestao_acao),
	KEY swot_gestao_canvas (swot_gestao_canvas),
	KEY swot_gestao_risco (swot_gestao_risco),
	KEY swot_gestao_risco_resposta (swot_gestao_risco_resposta),
	KEY swot_gestao_calendario (swot_gestao_calendario),
	KEY swot_gestao_monitoramento (swot_gestao_monitoramento),
	KEY swot_gestao_ata (swot_gestao_ata),
	KEY swot_gestao_operativo(swot_gestao_operativo),
	KEY swot_gestao_instrumento (swot_gestao_instrumento),
	KEY swot_gestao_recurso (swot_gestao_recurso),
	KEY swot_gestao_problema (swot_gestao_problema),
	KEY swot_gestao_demanda (swot_gestao_demanda),
	KEY swot_gestao_programa (swot_gestao_programa),
	KEY swot_gestao_licao (swot_gestao_licao),
	KEY swot_gestao_evento (swot_gestao_evento),
	KEY swot_gestao_link (swot_gestao_link),
	KEY swot_gestao_avaliacao (swot_gestao_avaliacao),
	KEY swot_gestao_tgn (swot_gestao_tgn),
	KEY swot_gestao_brainstorm (swot_gestao_brainstorm),
	KEY swot_gestao_gut (swot_gestao_gut),
	KEY swot_gestao_causa_efeito (swot_gestao_causa_efeito),
	KEY swot_gestao_arquivo (swot_gestao_arquivo),
	KEY swot_gestao_forum (swot_gestao_forum),
	KEY swot_gestao_checklist (swot_gestao_checklist),
	KEY swot_gestao_agenda (swot_gestao_agenda),
	KEY swot_gestao_agrupamento (swot_gestao_agrupamento),
	KEY swot_gestao_patrocinador (swot_gestao_patrocinador),
	KEY swot_gestao_template (swot_gestao_template),
	KEY swot_gestao_painel (swot_gestao_painel),
	KEY swot_gestao_painel_odometro (swot_gestao_painel_odometro),
	KEY swot_gestao_painel_composicao (swot_gestao_painel_composicao),
	KEY swot_gestao_tr (swot_gestao_tr),
	KEY swot_gestao_me (swot_gestao_me),
	KEY swot_gestao_acao_item (swot_gestao_acao_item),
	KEY swot_gestao_beneficio (swot_gestao_beneficio),
	KEY swot_gestao_painel_slideshow (swot_gestao_painel_slideshow),
	KEY swot_gestao_projeto_viabilidade (swot_gestao_projeto_viabilidade),
	KEY swot_gestao_projeto_abertura (swot_gestao_projeto_abertura),
	KEY swot_gestao_plano_gestao (swot_gestao_plano_gestao),
	CONSTRAINT swot_gestao_swot FOREIGN KEY (swot_gestao_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_semelhante FOREIGN KEY (swot_gestao_semelhante) REFERENCES swot (swot_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_mswot FOREIGN KEY (swot_gestao_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_projeto FOREIGN KEY (swot_gestao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_tarefa FOREIGN KEY (swot_gestao_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_perspectiva FOREIGN KEY (swot_gestao_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_tema FOREIGN KEY (swot_gestao_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_objetivo FOREIGN KEY (swot_gestao_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_fator FOREIGN KEY (swot_gestao_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_estrategia FOREIGN KEY (swot_gestao_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_meta FOREIGN KEY (swot_gestao_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_pratica FOREIGN KEY (swot_gestao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_indicador FOREIGN KEY (swot_gestao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_acao FOREIGN KEY (swot_gestao_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_canvas FOREIGN KEY (swot_gestao_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_risco FOREIGN KEY (swot_gestao_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_risco_resposta FOREIGN KEY (swot_gestao_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_calendario FOREIGN KEY (swot_gestao_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_monitoramento FOREIGN KEY (swot_gestao_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_ata FOREIGN KEY (swot_gestao_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_operativo FOREIGN KEY (swot_gestao_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_instrumento FOREIGN KEY (swot_gestao_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_recurso FOREIGN KEY (swot_gestao_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_problema FOREIGN KEY (swot_gestao_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_demanda FOREIGN KEY (swot_gestao_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_programa FOREIGN KEY (swot_gestao_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_licao FOREIGN KEY (swot_gestao_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_evento FOREIGN KEY (swot_gestao_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_link FOREIGN KEY (swot_gestao_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_avaliacao FOREIGN KEY (swot_gestao_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_tgn FOREIGN KEY (swot_gestao_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_brainstorm FOREIGN KEY (swot_gestao_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_gut FOREIGN KEY (swot_gestao_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_causa_efeito FOREIGN KEY (swot_gestao_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_arquivo FOREIGN KEY (swot_gestao_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_forum FOREIGN KEY (swot_gestao_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_checklist FOREIGN KEY (swot_gestao_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_agenda FOREIGN KEY (swot_gestao_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_agrupamento FOREIGN KEY (swot_gestao_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_patrocinador FOREIGN KEY (swot_gestao_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_template FOREIGN KEY (swot_gestao_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_painel FOREIGN KEY (swot_gestao_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_painel_odometro FOREIGN KEY (swot_gestao_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_painel_composicao FOREIGN KEY (swot_gestao_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_tr FOREIGN KEY (swot_gestao_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_me FOREIGN KEY (swot_gestao_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_acao_item FOREIGN KEY (swot_gestao_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_beneficio FOREIGN KEY (swot_gestao_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_painel_slideshow FOREIGN KEY (swot_gestao_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_projeto_viabilidade FOREIGN KEY (swot_gestao_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_projeto_abertura FOREIGN KEY (swot_gestao_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT swot_gestao_plano_gestao FOREIGN KEY (swot_gestao_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS arquivo_gestao;

CREATE TABLE arquivo_gestao (
	arquivo_gestao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	arquivo_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY arquivo_gestao_id (arquivo_gestao_id),
	KEY arquivo_gestao_arquivo (arquivo_gestao_arquivo),
	KEY arquivo_gestao_semelhante (arquivo_gestao_semelhante),
	KEY arquivo_gestao_projeto (arquivo_gestao_projeto),
	KEY arquivo_gestao_tarefa (arquivo_gestao_tarefa),
	KEY arquivo_gestao_perspectiva (arquivo_gestao_perspectiva),
	KEY arquivo_gestao_tema (arquivo_gestao_tema),
	KEY arquivo_gestao_objetivo (arquivo_gestao_objetivo),
	KEY arquivo_gestao_estrategia (arquivo_gestao_estrategia),
	KEY arquivo_gestao_meta (arquivo_gestao_meta),
	KEY arquivo_gestao_fator (arquivo_gestao_fator),
	KEY arquivo_gestao_pratica (arquivo_gestao_pratica),
	KEY arquivo_gestao_indicador (arquivo_gestao_indicador),
	KEY arquivo_gestao_acao (arquivo_gestao_acao),
	KEY arquivo_gestao_canvas (arquivo_gestao_canvas),
	KEY arquivo_gestao_risco (arquivo_gestao_risco),
	KEY arquivo_gestao_risco_resposta (arquivo_gestao_risco_resposta),
	KEY arquivo_gestao_calendario (arquivo_gestao_calendario),
	KEY arquivo_gestao_monitoramento (arquivo_gestao_monitoramento),
	KEY arquivo_gestao_ata (arquivo_gestao_ata),
	KEY arquivo_gestao_mswot(arquivo_gestao_mswot),
	KEY arquivo_gestao_swot(arquivo_gestao_swot),
	KEY arquivo_gestao_operativo(arquivo_gestao_operativo),
	KEY arquivo_gestao_instrumento (arquivo_gestao_instrumento),
	KEY arquivo_gestao_recurso (arquivo_gestao_recurso),
	KEY arquivo_gestao_problema (arquivo_gestao_problema),
	KEY arquivo_gestao_demanda (arquivo_gestao_demanda),
	KEY arquivo_gestao_programa (arquivo_gestao_programa),
	KEY arquivo_gestao_licao (arquivo_gestao_licao),
	KEY arquivo_gestao_evento (arquivo_gestao_evento),
	KEY arquivo_gestao_link (arquivo_gestao_link),
	KEY arquivo_gestao_avaliacao (arquivo_gestao_avaliacao),
	KEY arquivo_gestao_tgn (arquivo_gestao_tgn),
	KEY arquivo_gestao_brainstorm (arquivo_gestao_brainstorm),
	KEY arquivo_gestao_gut (arquivo_gestao_gut),
	KEY arquivo_gestao_causa_efeito (arquivo_gestao_causa_efeito),
	KEY arquivo_gestao_forum (arquivo_gestao_forum),
	KEY arquivo_gestao_checklist (arquivo_gestao_checklist),
	KEY arquivo_gestao_agenda (arquivo_gestao_agenda),
	KEY arquivo_gestao_agrupamento (arquivo_gestao_agrupamento),
	KEY arquivo_gestao_patrocinador (arquivo_gestao_patrocinador),
	KEY arquivo_gestao_template (arquivo_gestao_template),
	KEY arquivo_gestao_painel (arquivo_gestao_painel),
	KEY arquivo_gestao_painel_odometro (arquivo_gestao_painel_odometro),
	KEY arquivo_gestao_painel_composicao (arquivo_gestao_painel_composicao),
	KEY arquivo_gestao_usuario (arquivo_gestao_usuario),
	KEY arquivo_gestao_tr (arquivo_gestao_tr),
	KEY arquivo_gestao_me (arquivo_gestao_me),
	KEY arquivo_gestao_acao_item (arquivo_gestao_acao_item),
	KEY arquivo_gestao_beneficio (arquivo_gestao_beneficio),
	KEY arquivo_gestao_painel_slideshow (arquivo_gestao_painel_slideshow),
	KEY arquivo_gestao_projeto_viabilidade (arquivo_gestao_projeto_viabilidade),
	KEY arquivo_gestao_projeto_abertura (arquivo_gestao_projeto_abertura),
	KEY arquivo_gestao_plano_gestao (arquivo_gestao_plano_gestao),
	CONSTRAINT arquivo_gestao_arquivo FOREIGN KEY (arquivo_gestao_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_semelhante FOREIGN KEY (arquivo_gestao_semelhante) REFERENCES arquivo (arquivo_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_projeto FOREIGN KEY (arquivo_gestao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_tarefa FOREIGN KEY (arquivo_gestao_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_perspectiva FOREIGN KEY (arquivo_gestao_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_tema FOREIGN KEY (arquivo_gestao_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_objetivo FOREIGN KEY (arquivo_gestao_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_fator FOREIGN KEY (arquivo_gestao_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_estrategia FOREIGN KEY (arquivo_gestao_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_meta FOREIGN KEY (arquivo_gestao_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_pratica FOREIGN KEY (arquivo_gestao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_indicador FOREIGN KEY (arquivo_gestao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_acao FOREIGN KEY (arquivo_gestao_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_canvas FOREIGN KEY (arquivo_gestao_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_risco FOREIGN KEY (arquivo_gestao_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_risco_resposta FOREIGN KEY (arquivo_gestao_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_calendario FOREIGN KEY (arquivo_gestao_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_monitoramento FOREIGN KEY (arquivo_gestao_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_ata FOREIGN KEY (arquivo_gestao_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_mswot FOREIGN KEY (arquivo_gestao_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_swot FOREIGN KEY (arquivo_gestao_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_operativo FOREIGN KEY (arquivo_gestao_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_instrumento FOREIGN KEY (arquivo_gestao_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_recurso FOREIGN KEY (arquivo_gestao_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_problema FOREIGN KEY (arquivo_gestao_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_demanda FOREIGN KEY (arquivo_gestao_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_programa FOREIGN KEY (arquivo_gestao_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_licao FOREIGN KEY (arquivo_gestao_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_evento FOREIGN KEY (arquivo_gestao_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_link FOREIGN KEY (arquivo_gestao_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_avaliacao FOREIGN KEY (arquivo_gestao_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_tgn FOREIGN KEY (arquivo_gestao_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_brainstorm FOREIGN KEY (arquivo_gestao_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_gut FOREIGN KEY (arquivo_gestao_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_causa_efeito FOREIGN KEY (arquivo_gestao_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_forum FOREIGN KEY (arquivo_gestao_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_checklist FOREIGN KEY (arquivo_gestao_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_agenda FOREIGN KEY (arquivo_gestao_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_agrupamento FOREIGN KEY (arquivo_gestao_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_patrocinador FOREIGN KEY (arquivo_gestao_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_template FOREIGN KEY (arquivo_gestao_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_painel FOREIGN KEY (arquivo_gestao_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_painel_odometro FOREIGN KEY (arquivo_gestao_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_painel_composicao FOREIGN KEY (arquivo_gestao_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_tr FOREIGN KEY (arquivo_gestao_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_me FOREIGN KEY (arquivo_gestao_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_acao_item FOREIGN KEY (arquivo_gestao_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_beneficio FOREIGN KEY (arquivo_gestao_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_painel_slideshow FOREIGN KEY (arquivo_gestao_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_projeto_viabilidade FOREIGN KEY (arquivo_gestao_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_projeto_abertura FOREIGN KEY (arquivo_gestao_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_plano_gestao FOREIGN KEY (arquivo_gestao_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_gestao_usuario FOREIGN KEY (arquivo_gestao_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS arquivo_pasta_gestao;

CREATE TABLE arquivo_pasta_gestao (
	arquivo_pasta_gestao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	arquivo_pasta_gestao_pasta INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_pasta_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY arquivo_pasta_gestao_id (arquivo_pasta_gestao_id),
	KEY arquivo_pasta_gestao_pasta (arquivo_pasta_gestao_pasta),
	KEY arquivo_pasta_gestao_semelhante (arquivo_pasta_gestao_semelhante),
	KEY arquivo_pasta_gestao_projeto (arquivo_pasta_gestao_projeto),
	KEY arquivo_pasta_gestao_tarefa (arquivo_pasta_gestao_tarefa),
	KEY arquivo_pasta_gestao_perspectiva (arquivo_pasta_gestao_perspectiva),
	KEY arquivo_pasta_gestao_tema (arquivo_pasta_gestao_tema),
	KEY arquivo_pasta_gestao_objetivo (arquivo_pasta_gestao_objetivo),
	KEY arquivo_pasta_gestao_estrategia (arquivo_pasta_gestao_estrategia),
	KEY arquivo_pasta_gestao_meta (arquivo_pasta_gestao_meta),
	KEY arquivo_pasta_gestao_fator (arquivo_pasta_gestao_fator),
	KEY arquivo_pasta_gestao_pratica (arquivo_pasta_gestao_pratica),
	KEY arquivo_pasta_gestao_indicador (arquivo_pasta_gestao_indicador),
	KEY arquivo_pasta_gestao_acao (arquivo_pasta_gestao_acao),
	KEY arquivo_pasta_gestao_canvas (arquivo_pasta_gestao_canvas),
	KEY arquivo_pasta_gestao_risco (arquivo_pasta_gestao_risco),
	KEY arquivo_pasta_gestao_risco_resposta (arquivo_pasta_gestao_risco_resposta),
	KEY arquivo_pasta_gestao_calendario (arquivo_pasta_gestao_calendario),
	KEY arquivo_pasta_gestao_monitoramento (arquivo_pasta_gestao_monitoramento),
	KEY arquivo_pasta_gestao_ata (arquivo_pasta_gestao_ata),
	KEY arquivo_pasta_gestao_mswot(arquivo_pasta_gestao_mswot),
	KEY arquivo_pasta_gestao_swot(arquivo_pasta_gestao_swot),
	KEY arquivo_pasta_gestao_operativo(arquivo_pasta_gestao_operativo),
	KEY arquivo_pasta_gestao_instrumento (arquivo_pasta_gestao_instrumento),
	KEY arquivo_pasta_gestao_recurso (arquivo_pasta_gestao_recurso),
	KEY arquivo_pasta_gestao_problema (arquivo_pasta_gestao_problema),
	KEY arquivo_pasta_gestao_demanda (arquivo_pasta_gestao_demanda),
	KEY arquivo_pasta_gestao_programa (arquivo_pasta_gestao_programa),
	KEY arquivo_pasta_gestao_licao (arquivo_pasta_gestao_licao),
	KEY arquivo_pasta_gestao_evento (arquivo_pasta_gestao_evento),
	KEY arquivo_pasta_gestao_link (arquivo_pasta_gestao_link),
	KEY arquivo_pasta_gestao_avaliacao (arquivo_pasta_gestao_avaliacao),
	KEY arquivo_pasta_gestao_tgn (arquivo_pasta_gestao_tgn),
	KEY arquivo_pasta_gestao_brainstorm (arquivo_pasta_gestao_brainstorm),
	KEY arquivo_pasta_gestao_gut (arquivo_pasta_gestao_gut),
	KEY arquivo_pasta_gestao_causa_efeito (arquivo_pasta_gestao_causa_efeito),
	KEY arquivo_pasta_gestao_arquivo (arquivo_pasta_gestao_arquivo),
	KEY arquivo_pasta_gestao_forum (arquivo_pasta_gestao_forum),
	KEY arquivo_pasta_gestao_checklist (arquivo_pasta_gestao_checklist),
	KEY arquivo_pasta_gestao_agenda (arquivo_pasta_gestao_agenda),
	KEY arquivo_pasta_gestao_agrupamento (arquivo_pasta_gestao_agrupamento),
	KEY arquivo_pasta_gestao_patrocinador (arquivo_pasta_gestao_patrocinador),
	KEY arquivo_pasta_gestao_template (arquivo_pasta_gestao_template),
	KEY arquivo_pasta_gestao_painel (arquivo_pasta_gestao_painel),
	KEY arquivo_pasta_gestao_painel_odometro (arquivo_pasta_gestao_painel_odometro),
	KEY arquivo_pasta_gestao_painel_composicao (arquivo_pasta_gestao_painel_composicao),
	KEY arquivo_pasta_gestao_tr (arquivo_pasta_gestao_tr),
	KEY arquivo_pasta_gestao_me (arquivo_pasta_gestao_me),
	KEY arquivo_pasta_gestao_acao_item (arquivo_pasta_gestao_acao_item),
	KEY arquivo_pasta_gestao_beneficio (arquivo_pasta_gestao_beneficio),
	KEY arquivo_pasta_gestao_painel_slideshow (arquivo_pasta_gestao_painel_slideshow),
	KEY arquivo_pasta_gestao_projeto_viabilidade (arquivo_pasta_gestao_projeto_viabilidade),
	KEY arquivo_pasta_gestao_projeto_abertura (arquivo_pasta_gestao_projeto_abertura),
	KEY arquivo_pasta_gestao_plano_gestao (arquivo_pasta_gestao_plano_gestao),
	KEY arquivo_pasta_gestao_usuario (arquivo_pasta_gestao_usuario),
	CONSTRAINT arquivo_pasta_gestao_pasta FOREIGN KEY (arquivo_pasta_gestao_pasta) REFERENCES arquivo_pasta (arquivo_pasta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_semelhante FOREIGN KEY (arquivo_pasta_gestao_semelhante) REFERENCES arquivo_pasta (arquivo_pasta_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_projeto FOREIGN KEY (arquivo_pasta_gestao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_tarefa FOREIGN KEY (arquivo_pasta_gestao_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_perspectiva FOREIGN KEY (arquivo_pasta_gestao_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_tema FOREIGN KEY (arquivo_pasta_gestao_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_objetivo FOREIGN KEY (arquivo_pasta_gestao_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_fator FOREIGN KEY (arquivo_pasta_gestao_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_estrategia FOREIGN KEY (arquivo_pasta_gestao_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_meta FOREIGN KEY (arquivo_pasta_gestao_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_pratica FOREIGN KEY (arquivo_pasta_gestao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_indicador FOREIGN KEY (arquivo_pasta_gestao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_acao FOREIGN KEY (arquivo_pasta_gestao_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_canvas FOREIGN KEY (arquivo_pasta_gestao_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_risco FOREIGN KEY (arquivo_pasta_gestao_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_risco_resposta FOREIGN KEY (arquivo_pasta_gestao_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_calendario FOREIGN KEY (arquivo_pasta_gestao_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_monitoramento FOREIGN KEY (arquivo_pasta_gestao_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_ata FOREIGN KEY (arquivo_pasta_gestao_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_mswot FOREIGN KEY (arquivo_pasta_gestao_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_swot FOREIGN KEY (arquivo_pasta_gestao_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_operativo FOREIGN KEY (arquivo_pasta_gestao_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_instrumento FOREIGN KEY (arquivo_pasta_gestao_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_recurso FOREIGN KEY (arquivo_pasta_gestao_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_problema FOREIGN KEY (arquivo_pasta_gestao_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_demanda FOREIGN KEY (arquivo_pasta_gestao_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_programa FOREIGN KEY (arquivo_pasta_gestao_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_licao FOREIGN KEY (arquivo_pasta_gestao_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_evento FOREIGN KEY (arquivo_pasta_gestao_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_link FOREIGN KEY (arquivo_pasta_gestao_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_avaliacao FOREIGN KEY (arquivo_pasta_gestao_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_tgn FOREIGN KEY (arquivo_pasta_gestao_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_brainstorm FOREIGN KEY (arquivo_pasta_gestao_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_gut FOREIGN KEY (arquivo_pasta_gestao_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_causa_efeito FOREIGN KEY (arquivo_pasta_gestao_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_arquivo FOREIGN KEY (arquivo_pasta_gestao_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_forum FOREIGN KEY (arquivo_pasta_gestao_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_checklist FOREIGN KEY (arquivo_pasta_gestao_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_agenda FOREIGN KEY (arquivo_pasta_gestao_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_agrupamento FOREIGN KEY (arquivo_pasta_gestao_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_patrocinador FOREIGN KEY (arquivo_pasta_gestao_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_template FOREIGN KEY (arquivo_pasta_gestao_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_painel FOREIGN KEY (arquivo_pasta_gestao_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_painel_odometro FOREIGN KEY (arquivo_pasta_gestao_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_painel_composicao FOREIGN KEY (arquivo_pasta_gestao_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_tr FOREIGN KEY (arquivo_pasta_gestao_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_me FOREIGN KEY (arquivo_pasta_gestao_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_acao_item FOREIGN KEY (arquivo_pasta_gestao_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_beneficio FOREIGN KEY (arquivo_pasta_gestao_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_painel_slideshow FOREIGN KEY (arquivo_pasta_gestao_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_projeto_viabilidade FOREIGN KEY (arquivo_pasta_gestao_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_projeto_abertura FOREIGN KEY (arquivo_pasta_gestao_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_plano_gestao FOREIGN KEY (arquivo_pasta_gestao_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_gestao_usuario FOREIGN KEY (arquivo_pasta_gestao_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS checklist_gestao;

CREATE TABLE checklist_gestao (
	checklist_gestao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	checklist_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY checklist_gestao_id (checklist_gestao_id),
	KEY checklist_gestao_checklist (checklist_gestao_checklist),
	KEY checklist_gestao_semelhante (checklist_gestao_semelhante),
	KEY checklist_gestao_projeto (checklist_gestao_projeto),
	KEY checklist_gestao_tarefa (checklist_gestao_tarefa),
	KEY checklist_gestao_perspectiva (checklist_gestao_perspectiva),
	KEY checklist_gestao_tema (checklist_gestao_tema),
	KEY checklist_gestao_objetivo (checklist_gestao_objetivo),
	KEY checklist_gestao_estrategia (checklist_gestao_estrategia),
	KEY checklist_gestao_meta (checklist_gestao_meta),
	KEY checklist_gestao_fator (checklist_gestao_fator),
	KEY checklist_gestao_pratica (checklist_gestao_pratica),
	KEY checklist_gestao_indicador (checklist_gestao_indicador),
	KEY checklist_gestao_acao (checklist_gestao_acao),
	KEY checklist_gestao_canvas (checklist_gestao_canvas),
	KEY checklist_gestao_risco (checklist_gestao_risco),
	KEY checklist_gestao_risco_resposta (checklist_gestao_risco_resposta),
	KEY checklist_gestao_calendario (checklist_gestao_calendario),
	KEY checklist_gestao_monitoramento (checklist_gestao_monitoramento),
	KEY checklist_gestao_ata (checklist_gestao_ata),
	KEY checklist_gestao_mswot(checklist_gestao_mswot),
	KEY checklist_gestao_swot(checklist_gestao_swot),
	KEY checklist_gestao_operativo(checklist_gestao_operativo),
	KEY checklist_gestao_instrumento (checklist_gestao_instrumento),
	KEY checklist_gestao_recurso (checklist_gestao_recurso),
	KEY checklist_gestao_problema (checklist_gestao_problema),
	KEY checklist_gestao_demanda (checklist_gestao_demanda),
	KEY checklist_gestao_programa (checklist_gestao_programa),
	KEY checklist_gestao_licao (checklist_gestao_licao),
	KEY checklist_gestao_evento (checklist_gestao_evento),
	KEY checklist_gestao_link (checklist_gestao_link),
	KEY checklist_gestao_avaliacao (checklist_gestao_avaliacao),
	KEY checklist_gestao_tgn (checklist_gestao_tgn),
	KEY checklist_gestao_brainstorm (checklist_gestao_brainstorm),
	KEY checklist_gestao_gut (checklist_gestao_gut),
	KEY checklist_gestao_causa_efeito (checklist_gestao_causa_efeito),
	KEY checklist_gestao_arquivo (checklist_gestao_arquivo),
	KEY checklist_gestao_forum (checklist_gestao_forum),
	KEY checklist_gestao_agenda (checklist_gestao_agenda),
	KEY checklist_gestao_agrupamento (checklist_gestao_agrupamento),
	KEY checklist_gestao_patrocinador (checklist_gestao_patrocinador),
	KEY checklist_gestao_template (checklist_gestao_template),
	KEY checklist_gestao_painel (checklist_gestao_painel),
	KEY checklist_gestao_painel_odometro (checklist_gestao_painel_odometro),
	KEY checklist_gestao_painel_composicao (checklist_gestao_painel_composicao),
	KEY checklist_gestao_tr (checklist_gestao_tr),
	KEY checklist_gestao_me (checklist_gestao_me),
	KEY checklist_gestao_acao_item (checklist_gestao_acao_item),
	KEY checklist_gestao_beneficio (checklist_gestao_beneficio),
	KEY checklist_gestao_painel_slideshow (checklist_gestao_painel_slideshow),
	KEY checklist_gestao_projeto_viabilidade (checklist_gestao_projeto_viabilidade),
	KEY checklist_gestao_projeto_abertura (checklist_gestao_projeto_abertura),
	KEY checklist_gestao_plano_gestao (checklist_gestao_plano_gestao),
	CONSTRAINT checklist_gestao_checklist FOREIGN KEY (checklist_gestao_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_semelhante FOREIGN KEY (checklist_gestao_semelhante) REFERENCES checklist (checklist_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_projeto FOREIGN KEY (checklist_gestao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_tarefa FOREIGN KEY (checklist_gestao_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_perspectiva FOREIGN KEY (checklist_gestao_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_tema FOREIGN KEY (checklist_gestao_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_objetivo FOREIGN KEY (checklist_gestao_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_fator FOREIGN KEY (checklist_gestao_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_estrategia FOREIGN KEY (checklist_gestao_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_meta FOREIGN KEY (checklist_gestao_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_pratica FOREIGN KEY (checklist_gestao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_indicador FOREIGN KEY (checklist_gestao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_acao FOREIGN KEY (checklist_gestao_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_canvas FOREIGN KEY (checklist_gestao_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_risco FOREIGN KEY (checklist_gestao_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_risco_resposta FOREIGN KEY (checklist_gestao_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_calendario FOREIGN KEY (checklist_gestao_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_monitoramento FOREIGN KEY (checklist_gestao_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_ata FOREIGN KEY (checklist_gestao_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_mswot FOREIGN KEY (checklist_gestao_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_swot FOREIGN KEY (checklist_gestao_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_operativo FOREIGN KEY (checklist_gestao_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_instrumento FOREIGN KEY (checklist_gestao_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_recurso FOREIGN KEY (checklist_gestao_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_problema FOREIGN KEY (checklist_gestao_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_demanda FOREIGN KEY (checklist_gestao_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_programa FOREIGN KEY (checklist_gestao_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_licao FOREIGN KEY (checklist_gestao_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_evento FOREIGN KEY (checklist_gestao_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_link FOREIGN KEY (checklist_gestao_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_avaliacao FOREIGN KEY (checklist_gestao_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_tgn FOREIGN KEY (checklist_gestao_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_brainstorm FOREIGN KEY (checklist_gestao_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_gut FOREIGN KEY (checklist_gestao_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_causa_efeito FOREIGN KEY (checklist_gestao_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_arquivo FOREIGN KEY (checklist_gestao_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_forum FOREIGN KEY (checklist_gestao_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_agenda FOREIGN KEY (checklist_gestao_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_agrupamento FOREIGN KEY (checklist_gestao_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_patrocinador FOREIGN KEY (checklist_gestao_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_template FOREIGN KEY (checklist_gestao_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_painel FOREIGN KEY (checklist_gestao_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_painel_odometro FOREIGN KEY (checklist_gestao_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_painel_composicao FOREIGN KEY (checklist_gestao_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_tr FOREIGN KEY (checklist_gestao_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_me FOREIGN KEY (checklist_gestao_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_acao_item FOREIGN KEY (checklist_gestao_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_beneficio FOREIGN KEY (checklist_gestao_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_painel_slideshow FOREIGN KEY (checklist_gestao_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_projeto_viabilidade FOREIGN KEY (checklist_gestao_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_projeto_abertura FOREIGN KEY (checklist_gestao_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT checklist_gestao_plano_gestao FOREIGN KEY (checklist_gestao_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS brainstorm_gestao;

CREATE TABLE brainstorm_gestao (
	brainstorm_gestao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	brainstorm_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY brainstorm_gestao_id (brainstorm_gestao_id),
	KEY brainstorm_gestao_brainstorm (brainstorm_gestao_brainstorm),
	KEY brainstorm_gestao_semelhante (brainstorm_gestao_semelhante),
	KEY brainstorm_gestao_projeto (brainstorm_gestao_projeto),
	KEY brainstorm_gestao_tarefa (brainstorm_gestao_tarefa),
	KEY brainstorm_gestao_perspectiva (brainstorm_gestao_perspectiva),
	KEY brainstorm_gestao_tema (brainstorm_gestao_tema),
	KEY brainstorm_gestao_objetivo (brainstorm_gestao_objetivo),
	KEY brainstorm_gestao_estrategia (brainstorm_gestao_estrategia),
	KEY brainstorm_gestao_meta (brainstorm_gestao_meta),
	KEY brainstorm_gestao_fator (brainstorm_gestao_fator),
	KEY brainstorm_gestao_pratica (brainstorm_gestao_pratica),
	KEY brainstorm_gestao_indicador (brainstorm_gestao_indicador),
	KEY brainstorm_gestao_acao (brainstorm_gestao_acao),
	KEY brainstorm_gestao_canvas (brainstorm_gestao_canvas),
	KEY brainstorm_gestao_risco (brainstorm_gestao_risco),
	KEY brainstorm_gestao_risco_resposta (brainstorm_gestao_risco_resposta),
	KEY brainstorm_gestao_calendario (brainstorm_gestao_calendario),
	KEY brainstorm_gestao_monitoramento (brainstorm_gestao_monitoramento),
	KEY brainstorm_gestao_ata (brainstorm_gestao_ata),
	KEY brainstorm_gestao_mswot(brainstorm_gestao_mswot),
	KEY brainstorm_gestao_swot(brainstorm_gestao_swot),
	KEY brainstorm_gestao_operativo(brainstorm_gestao_operativo),
	KEY brainstorm_gestao_instrumento (brainstorm_gestao_instrumento),
	KEY brainstorm_gestao_recurso (brainstorm_gestao_recurso),
	KEY brainstorm_gestao_problema (brainstorm_gestao_problema),
	KEY brainstorm_gestao_demanda (brainstorm_gestao_demanda),
	KEY brainstorm_gestao_programa (brainstorm_gestao_programa),
	KEY brainstorm_gestao_licao (brainstorm_gestao_licao),
	KEY brainstorm_gestao_evento (brainstorm_gestao_evento),
	KEY brainstorm_gestao_link (brainstorm_gestao_link),
	KEY brainstorm_gestao_avaliacao (brainstorm_gestao_avaliacao),
	KEY brainstorm_gestao_tgn (brainstorm_gestao_tgn),
	KEY brainstorm_gestao_gut (brainstorm_gestao_gut),
	KEY brainstorm_gestao_causa_efeito (brainstorm_gestao_causa_efeito),
	KEY brainstorm_gestao_arquivo (brainstorm_gestao_arquivo),
	KEY brainstorm_gestao_forum (brainstorm_gestao_forum),
	KEY brainstorm_gestao_checklist (brainstorm_gestao_checklist),
	KEY brainstorm_gestao_agenda (brainstorm_gestao_agenda),
	KEY brainstorm_gestao_agrupamento (brainstorm_gestao_agrupamento),
	KEY brainstorm_gestao_patrocinador (brainstorm_gestao_patrocinador),
	KEY brainstorm_gestao_template (brainstorm_gestao_template),
	KEY brainstorm_gestao_painel (brainstorm_gestao_painel),
	KEY brainstorm_gestao_painel_odometro (brainstorm_gestao_painel_odometro),
	KEY brainstorm_gestao_painel_composicao (brainstorm_gestao_painel_composicao),
	KEY brainstorm_gestao_tr (brainstorm_gestao_tr),
	KEY brainstorm_gestao_me (brainstorm_gestao_me),
	KEY brainstorm_gestao_acao_item (brainstorm_gestao_acao_item),
	KEY brainstorm_gestao_beneficio (brainstorm_gestao_beneficio),
	KEY brainstorm_gestao_painel_slideshow (brainstorm_gestao_painel_slideshow),
	KEY brainstorm_gestao_projeto_viabilidade (brainstorm_gestao_projeto_viabilidade),
	KEY brainstorm_gestao_projeto_abertura (brainstorm_gestao_projeto_abertura),
	KEY brainstorm_gestao_plano_gestao (brainstorm_gestao_plano_gestao),
	CONSTRAINT brainstorm_gestao_brainstorm FOREIGN KEY (brainstorm_gestao_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_semelhante FOREIGN KEY (brainstorm_gestao_semelhante) REFERENCES brainstorm (brainstorm_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_projeto FOREIGN KEY (brainstorm_gestao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_tarefa FOREIGN KEY (brainstorm_gestao_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_perspectiva FOREIGN KEY (brainstorm_gestao_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_tema FOREIGN KEY (brainstorm_gestao_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_objetivo FOREIGN KEY (brainstorm_gestao_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_fator FOREIGN KEY (brainstorm_gestao_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_estrategia FOREIGN KEY (brainstorm_gestao_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_meta FOREIGN KEY (brainstorm_gestao_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_pratica FOREIGN KEY (brainstorm_gestao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_indicador FOREIGN KEY (brainstorm_gestao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_acao FOREIGN KEY (brainstorm_gestao_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_canvas FOREIGN KEY (brainstorm_gestao_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_risco FOREIGN KEY (brainstorm_gestao_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_risco_resposta FOREIGN KEY (brainstorm_gestao_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_calendario FOREIGN KEY (brainstorm_gestao_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_monitoramento FOREIGN KEY (brainstorm_gestao_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_ata FOREIGN KEY (brainstorm_gestao_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_mswot FOREIGN KEY (brainstorm_gestao_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_swot FOREIGN KEY (brainstorm_gestao_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_operativo FOREIGN KEY (brainstorm_gestao_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_instrumento FOREIGN KEY (brainstorm_gestao_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_recurso FOREIGN KEY (brainstorm_gestao_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_problema FOREIGN KEY (brainstorm_gestao_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_demanda FOREIGN KEY (brainstorm_gestao_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_programa FOREIGN KEY (brainstorm_gestao_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_licao FOREIGN KEY (brainstorm_gestao_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_evento FOREIGN KEY (brainstorm_gestao_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_link FOREIGN KEY (brainstorm_gestao_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_avaliacao FOREIGN KEY (brainstorm_gestao_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_tgn FOREIGN KEY (brainstorm_gestao_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_gut FOREIGN KEY (brainstorm_gestao_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_causa_efeito FOREIGN KEY (brainstorm_gestao_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_arquivo FOREIGN KEY (brainstorm_gestao_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_forum FOREIGN KEY (brainstorm_gestao_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_checklist FOREIGN KEY (brainstorm_gestao_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_agenda FOREIGN KEY (brainstorm_gestao_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_agrupamento FOREIGN KEY (brainstorm_gestao_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_patrocinador FOREIGN KEY (brainstorm_gestao_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_template FOREIGN KEY (brainstorm_gestao_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_painel FOREIGN KEY (brainstorm_gestao_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_painel_odometro FOREIGN KEY (brainstorm_gestao_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_painel_composicao FOREIGN KEY (brainstorm_gestao_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_tr FOREIGN KEY (brainstorm_gestao_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_me FOREIGN KEY (brainstorm_gestao_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_acao_item FOREIGN KEY (brainstorm_gestao_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_beneficio FOREIGN KEY (brainstorm_gestao_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_painel_slideshow FOREIGN KEY (brainstorm_gestao_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_projeto_viabilidade FOREIGN KEY (brainstorm_gestao_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_projeto_abertura FOREIGN KEY (brainstorm_gestao_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT brainstorm_gestao_plano_gestao FOREIGN KEY (brainstorm_gestao_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS causa_efeito_gestao;

CREATE TABLE causa_efeito_gestao (
	causa_efeito_gestao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	causa_efeito_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY causa_efeito_gestao_id (causa_efeito_gestao_id),
	KEY causa_efeito_gestao_causa_efeito (causa_efeito_gestao_causa_efeito),
	KEY causa_efeito_gestao_semelhante (causa_efeito_gestao_semelhante),
	KEY causa_efeito_gestao_projeto (causa_efeito_gestao_projeto),
	KEY causa_efeito_gestao_tarefa (causa_efeito_gestao_tarefa),
	KEY causa_efeito_gestao_perspectiva (causa_efeito_gestao_perspectiva),
	KEY causa_efeito_gestao_tema (causa_efeito_gestao_tema),
	KEY causa_efeito_gestao_objetivo (causa_efeito_gestao_objetivo),
	KEY causa_efeito_gestao_estrategia (causa_efeito_gestao_estrategia),
	KEY causa_efeito_gestao_meta (causa_efeito_gestao_meta),
	KEY causa_efeito_gestao_fator (causa_efeito_gestao_fator),
	KEY causa_efeito_gestao_pratica (causa_efeito_gestao_pratica),
	KEY causa_efeito_gestao_indicador (causa_efeito_gestao_indicador),
	KEY causa_efeito_gestao_acao (causa_efeito_gestao_acao),
	KEY causa_efeito_gestao_canvas (causa_efeito_gestao_canvas),
	KEY causa_efeito_gestao_risco (causa_efeito_gestao_risco),
	KEY causa_efeito_gestao_risco_resposta (causa_efeito_gestao_risco_resposta),
	KEY causa_efeito_gestao_calendario (causa_efeito_gestao_calendario),
	KEY causa_efeito_gestao_monitoramento (causa_efeito_gestao_monitoramento),
	KEY causa_efeito_gestao_ata (causa_efeito_gestao_ata),
	KEY causa_efeito_gestao_mswot(causa_efeito_gestao_mswot),
	KEY causa_efeito_gestao_swot(causa_efeito_gestao_swot),
	KEY causa_efeito_gestao_operativo(causa_efeito_gestao_operativo),
	KEY causa_efeito_gestao_instrumento (causa_efeito_gestao_instrumento),
	KEY causa_efeito_gestao_recurso (causa_efeito_gestao_recurso),
	KEY causa_efeito_gestao_problema (causa_efeito_gestao_problema),
	KEY causa_efeito_gestao_demanda (causa_efeito_gestao_demanda),
	KEY causa_efeito_gestao_programa (causa_efeito_gestao_programa),
	KEY causa_efeito_gestao_licao (causa_efeito_gestao_licao),
	KEY causa_efeito_gestao_evento (causa_efeito_gestao_evento),
	KEY causa_efeito_gestao_link (causa_efeito_gestao_link),
	KEY causa_efeito_gestao_avaliacao (causa_efeito_gestao_avaliacao),
	KEY causa_efeito_gestao_tgn (causa_efeito_gestao_tgn),
	KEY causa_efeito_gestao_brainstorm (causa_efeito_gestao_brainstorm),
	KEY causa_efeito_gestao_gut (causa_efeito_gestao_gut),
	KEY causa_efeito_gestao_arquivo (causa_efeito_gestao_arquivo),
	KEY causa_efeito_gestao_forum (causa_efeito_gestao_forum),
	KEY causa_efeito_gestao_checklist (causa_efeito_gestao_checklist),
	KEY causa_efeito_gestao_agenda (causa_efeito_gestao_agenda),
	KEY causa_efeito_gestao_agrupamento (causa_efeito_gestao_agrupamento),
	KEY causa_efeito_gestao_patrocinador (causa_efeito_gestao_patrocinador),
	KEY causa_efeito_gestao_template (causa_efeito_gestao_template),
	KEY causa_efeito_gestao_painel (causa_efeito_gestao_painel),
	KEY causa_efeito_gestao_painel_odometro (causa_efeito_gestao_painel_odometro),
	KEY causa_efeito_gestao_painel_composicao (causa_efeito_gestao_painel_composicao),
	KEY causa_efeito_gestao_tr (causa_efeito_gestao_tr),
	KEY causa_efeito_gestao_me (causa_efeito_gestao_me),
	KEY causa_efeito_gestao_acao_item (causa_efeito_gestao_acao_item),
	KEY causa_efeito_gestao_beneficio (causa_efeito_gestao_beneficio),
	KEY causa_efeito_gestao_painel_slideshow (causa_efeito_gestao_painel_slideshow),
	KEY causa_efeito_gestao_projeto_viabilidade (causa_efeito_gestao_projeto_viabilidade),
	KEY causa_efeito_gestao_projeto_abertura (causa_efeito_gestao_projeto_abertura),
	KEY causa_efeito_gestao_plano_gestao (causa_efeito_gestao_plano_gestao),
	CONSTRAINT causa_efeito_gestao_causa_efeito FOREIGN KEY (causa_efeito_gestao_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_semelhante FOREIGN KEY (causa_efeito_gestao_semelhante) REFERENCES causa_efeito (causa_efeito_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_projeto FOREIGN KEY (causa_efeito_gestao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_tarefa FOREIGN KEY (causa_efeito_gestao_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_perspectiva FOREIGN KEY (causa_efeito_gestao_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_tema FOREIGN KEY (causa_efeito_gestao_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_objetivo FOREIGN KEY (causa_efeito_gestao_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_fator FOREIGN KEY (causa_efeito_gestao_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_estrategia FOREIGN KEY (causa_efeito_gestao_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_meta FOREIGN KEY (causa_efeito_gestao_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_pratica FOREIGN KEY (causa_efeito_gestao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_indicador FOREIGN KEY (causa_efeito_gestao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_acao FOREIGN KEY (causa_efeito_gestao_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_canvas FOREIGN KEY (causa_efeito_gestao_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_risco FOREIGN KEY (causa_efeito_gestao_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_risco_resposta FOREIGN KEY (causa_efeito_gestao_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_calendario FOREIGN KEY (causa_efeito_gestao_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_monitoramento FOREIGN KEY (causa_efeito_gestao_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_ata FOREIGN KEY (causa_efeito_gestao_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_mswot FOREIGN KEY (causa_efeito_gestao_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_swot FOREIGN KEY (causa_efeito_gestao_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_operativo FOREIGN KEY (causa_efeito_gestao_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_instrumento FOREIGN KEY (causa_efeito_gestao_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_recurso FOREIGN KEY (causa_efeito_gestao_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_problema FOREIGN KEY (causa_efeito_gestao_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_demanda FOREIGN KEY (causa_efeito_gestao_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_programa FOREIGN KEY (causa_efeito_gestao_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_licao FOREIGN KEY (causa_efeito_gestao_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_evento FOREIGN KEY (causa_efeito_gestao_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_link FOREIGN KEY (causa_efeito_gestao_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_avaliacao FOREIGN KEY (causa_efeito_gestao_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_tgn FOREIGN KEY (causa_efeito_gestao_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_brainstorm FOREIGN KEY (causa_efeito_gestao_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_gut FOREIGN KEY (causa_efeito_gestao_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_arquivo FOREIGN KEY (causa_efeito_gestao_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_forum FOREIGN KEY (causa_efeito_gestao_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_checklist FOREIGN KEY (causa_efeito_gestao_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_agenda FOREIGN KEY (causa_efeito_gestao_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_agrupamento FOREIGN KEY (causa_efeito_gestao_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_patrocinador FOREIGN KEY (causa_efeito_gestao_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_template FOREIGN KEY (causa_efeito_gestao_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_painel FOREIGN KEY (causa_efeito_gestao_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_painel_odometro FOREIGN KEY (causa_efeito_gestao_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_painel_composicao FOREIGN KEY (causa_efeito_gestao_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_tr FOREIGN KEY (causa_efeito_gestao_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_me FOREIGN KEY (causa_efeito_gestao_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_acao_item FOREIGN KEY (causa_efeito_gestao_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_beneficio FOREIGN KEY (causa_efeito_gestao_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_painel_slideshow FOREIGN KEY (causa_efeito_gestao_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_projeto_viabilidade FOREIGN KEY (causa_efeito_gestao_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_projeto_abertura FOREIGN KEY (causa_efeito_gestao_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT causa_efeito_gestao_plano_gestao FOREIGN KEY (causa_efeito_gestao_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS gut_gestao;

CREATE TABLE gut_gestao (
	gut_gestao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	gut_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY gut_gestao_id (gut_gestao_id),
	KEY gut_gestao_gut (gut_gestao_gut),
	KEY gut_gestao_semelhante (gut_gestao_semelhante),
	KEY gut_gestao_projeto (gut_gestao_projeto),
	KEY gut_gestao_tarefa (gut_gestao_tarefa),
	KEY gut_gestao_perspectiva (gut_gestao_perspectiva),
	KEY gut_gestao_tema (gut_gestao_tema),
	KEY gut_gestao_objetivo (gut_gestao_objetivo),
	KEY gut_gestao_estrategia (gut_gestao_estrategia),
	KEY gut_gestao_meta (gut_gestao_meta),
	KEY gut_gestao_fator (gut_gestao_fator),
	KEY gut_gestao_pratica (gut_gestao_pratica),
	KEY gut_gestao_indicador (gut_gestao_indicador),
	KEY gut_gestao_acao (gut_gestao_acao),
	KEY gut_gestao_canvas (gut_gestao_canvas),
	KEY gut_gestao_risco (gut_gestao_risco),
	KEY gut_gestao_risco_resposta (gut_gestao_risco_resposta),
	KEY gut_gestao_calendario (gut_gestao_calendario),
	KEY gut_gestao_monitoramento (gut_gestao_monitoramento),
	KEY gut_gestao_ata (gut_gestao_ata),
	KEY gut_gestao_mswot(gut_gestao_mswot),
	KEY gut_gestao_swot(gut_gestao_swot),
	KEY gut_gestao_operativo(gut_gestao_operativo),
	KEY gut_gestao_instrumento (gut_gestao_instrumento),
	KEY gut_gestao_recurso (gut_gestao_recurso),
	KEY gut_gestao_problema (gut_gestao_problema),
	KEY gut_gestao_demanda (gut_gestao_demanda),
	KEY gut_gestao_programa (gut_gestao_programa),
	KEY gut_gestao_licao (gut_gestao_licao),
	KEY gut_gestao_evento (gut_gestao_evento),
	KEY gut_gestao_link (gut_gestao_link),
	KEY gut_gestao_avaliacao (gut_gestao_avaliacao),
	KEY gut_gestao_tgn (gut_gestao_tgn),
	KEY gut_gestao_brainstorm (gut_gestao_brainstorm),
	KEY gut_gestao_causa_efeito (gut_gestao_causa_efeito),
	KEY gut_gestao_arquivo (gut_gestao_arquivo),
	KEY gut_gestao_forum (gut_gestao_forum),
	KEY gut_gestao_checklist (gut_gestao_checklist),
	KEY gut_gestao_agenda (gut_gestao_agenda),
	KEY gut_gestao_agrupamento (gut_gestao_agrupamento),
	KEY gut_gestao_patrocinador (gut_gestao_patrocinador),
	KEY gut_gestao_template (gut_gestao_template),
	KEY gut_gestao_painel (gut_gestao_painel),
	KEY gut_gestao_painel_odometro (gut_gestao_painel_odometro),
	KEY gut_gestao_painel_composicao (gut_gestao_painel_composicao),
	KEY gut_gestao_tr (gut_gestao_tr),
	KEY gut_gestao_me (gut_gestao_me),
	KEY gut_gestao_acao_item (gut_gestao_acao_item),
	KEY gut_gestao_beneficio (gut_gestao_beneficio),
	KEY gut_gestao_painel_slideshow (gut_gestao_painel_slideshow),
	KEY gut_gestao_projeto_viabilidade (gut_gestao_projeto_viabilidade),
	KEY gut_gestao_projeto_abertura (gut_gestao_projeto_abertura),
	KEY gut_gestao_plano_gestao (gut_gestao_plano_gestao),
	CONSTRAINT gut_gestao_gut FOREIGN KEY (gut_gestao_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_semelhante FOREIGN KEY (gut_gestao_semelhante) REFERENCES gut (gut_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_projeto FOREIGN KEY (gut_gestao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_tarefa FOREIGN KEY (gut_gestao_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_perspectiva FOREIGN KEY (gut_gestao_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_tema FOREIGN KEY (gut_gestao_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_objetivo FOREIGN KEY (gut_gestao_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_fator FOREIGN KEY (gut_gestao_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_estrategia FOREIGN KEY (gut_gestao_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_meta FOREIGN KEY (gut_gestao_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_pratica FOREIGN KEY (gut_gestao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_indicador FOREIGN KEY (gut_gestao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_acao FOREIGN KEY (gut_gestao_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_canvas FOREIGN KEY (gut_gestao_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_risco FOREIGN KEY (gut_gestao_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_risco_resposta FOREIGN KEY (gut_gestao_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_calendario FOREIGN KEY (gut_gestao_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_monitoramento FOREIGN KEY (gut_gestao_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_ata FOREIGN KEY (gut_gestao_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_mswot FOREIGN KEY (gut_gestao_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_swot FOREIGN KEY (gut_gestao_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_operativo FOREIGN KEY (gut_gestao_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_instrumento FOREIGN KEY (gut_gestao_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_recurso FOREIGN KEY (gut_gestao_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_problema FOREIGN KEY (gut_gestao_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_demanda FOREIGN KEY (gut_gestao_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_programa FOREIGN KEY (gut_gestao_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_licao FOREIGN KEY (gut_gestao_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_evento FOREIGN KEY (gut_gestao_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_link FOREIGN KEY (gut_gestao_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_avaliacao FOREIGN KEY (gut_gestao_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_tgn FOREIGN KEY (gut_gestao_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_brainstorm FOREIGN KEY (gut_gestao_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_causa_efeito FOREIGN KEY (gut_gestao_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_arquivo FOREIGN KEY (gut_gestao_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_forum FOREIGN KEY (gut_gestao_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_checklist FOREIGN KEY (gut_gestao_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_agenda FOREIGN KEY (gut_gestao_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_agrupamento FOREIGN KEY (gut_gestao_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_patrocinador FOREIGN KEY (gut_gestao_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_template FOREIGN KEY (gut_gestao_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_painel FOREIGN KEY (gut_gestao_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_painel_odometro FOREIGN KEY (gut_gestao_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_painel_composicao FOREIGN KEY (gut_gestao_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_tr FOREIGN KEY (gut_gestao_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_me FOREIGN KEY (gut_gestao_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_acao_item FOREIGN KEY (gut_gestao_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_beneficio FOREIGN KEY (gut_gestao_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_painel_slideshow FOREIGN KEY (gut_gestao_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_projeto_viabilidade FOREIGN KEY (gut_gestao_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_projeto_abertura FOREIGN KEY (gut_gestao_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT gut_gestao_plano_gestao FOREIGN KEY (gut_gestao_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS modelo_gestao;

CREATE TABLE modelo_gestao (
	modelo_gestao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	modelo_gestao_modelo INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY modelo_gestao_id (modelo_gestao_id),
	KEY modelo_gestao_modelo (modelo_gestao_modelo),
	KEY modelo_gestao_semelhante (modelo_gestao_semelhante),
	KEY modelo_gestao_projeto (modelo_gestao_projeto),
	KEY modelo_gestao_tarefa (modelo_gestao_tarefa),
	KEY modelo_gestao_perspectiva (modelo_gestao_perspectiva),
	KEY modelo_gestao_tema (modelo_gestao_tema),
	KEY modelo_gestao_objetivo (modelo_gestao_objetivo),
	KEY modelo_gestao_estrategia (modelo_gestao_estrategia),
	KEY modelo_gestao_meta (modelo_gestao_meta),
	KEY modelo_gestao_fator (modelo_gestao_fator),
	KEY modelo_gestao_pratica (modelo_gestao_pratica),
	KEY modelo_gestao_indicador (modelo_gestao_indicador),
	KEY modelo_gestao_acao (modelo_gestao_acao),
	KEY modelo_gestao_canvas (modelo_gestao_canvas),
	KEY modelo_gestao_risco (modelo_gestao_risco),
	KEY modelo_gestao_risco_resposta (modelo_gestao_risco_resposta),
	KEY modelo_gestao_calendario (modelo_gestao_calendario),
	KEY modelo_gestao_monitoramento (modelo_gestao_monitoramento),
	KEY modelo_gestao_ata (modelo_gestao_ata),
	KEY modelo_gestao_mswot(modelo_gestao_mswot),
	KEY modelo_gestao_swot(modelo_gestao_swot),
	KEY modelo_gestao_operativo(modelo_gestao_operativo),
	KEY modelo_gestao_instrumento (modelo_gestao_instrumento),
	KEY modelo_gestao_recurso (modelo_gestao_recurso),
	KEY modelo_gestao_problema (modelo_gestao_problema),
	KEY modelo_gestao_demanda (modelo_gestao_demanda),
	KEY modelo_gestao_programa (modelo_gestao_programa),
	KEY modelo_gestao_licao (modelo_gestao_licao),
	KEY modelo_gestao_evento (modelo_gestao_evento),
	KEY modelo_gestao_link (modelo_gestao_link),
	KEY modelo_gestao_avaliacao (modelo_gestao_avaliacao),
	KEY modelo_gestao_tgn (modelo_gestao_tgn),
	KEY modelo_gestao_brainstorm (modelo_gestao_brainstorm),
	KEY modelo_gestao_gut (modelo_gestao_gut),
	KEY modelo_gestao_causa_efeito (modelo_gestao_causa_efeito),
	KEY modelo_gestao_arquivo (modelo_gestao_arquivo),
	KEY modelo_gestao_forum (modelo_gestao_forum),
	KEY modelo_gestao_checklist (modelo_gestao_checklist),
	KEY modelo_gestao_agenda (modelo_gestao_agenda),
	KEY modelo_gestao_agrupamento (modelo_gestao_agrupamento),
	KEY modelo_gestao_patrocinador (modelo_gestao_patrocinador),
	KEY modelo_gestao_template (modelo_gestao_template),
	KEY modelo_gestao_painel (modelo_gestao_painel),
	KEY modelo_gestao_painel_odometro (modelo_gestao_painel_odometro),
	KEY modelo_gestao_painel_composicao (modelo_gestao_painel_composicao),
	KEY modelo_gestao_tr (modelo_gestao_tr),
	KEY modelo_gestao_me (modelo_gestao_me),
	KEY modelo_gestao_acao_item (modelo_gestao_acao_item),
	KEY modelo_gestao_beneficio (modelo_gestao_beneficio),
	KEY modelo_gestao_painel_slideshow (modelo_gestao_painel_slideshow),
	KEY modelo_gestao_projeto_viabilidade (modelo_gestao_projeto_viabilidade),
	KEY modelo_gestao_projeto_abertura (modelo_gestao_projeto_abertura),
	KEY modelo_gestao_plano_gestao (modelo_gestao_plano_gestao),
	CONSTRAINT modelo_gestao_modelo FOREIGN KEY (modelo_gestao_modelo) REFERENCES modelos (modelo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_semelhante FOREIGN KEY (modelo_gestao_semelhante) REFERENCES modelo (modelo_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_projeto FOREIGN KEY (modelo_gestao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_tarefa FOREIGN KEY (modelo_gestao_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_perspectiva FOREIGN KEY (modelo_gestao_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_tema FOREIGN KEY (modelo_gestao_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_objetivo FOREIGN KEY (modelo_gestao_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_fator FOREIGN KEY (modelo_gestao_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_estrategia FOREIGN KEY (modelo_gestao_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_meta FOREIGN KEY (modelo_gestao_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_pratica FOREIGN KEY (modelo_gestao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_indicador FOREIGN KEY (modelo_gestao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_acao FOREIGN KEY (modelo_gestao_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_canvas FOREIGN KEY (modelo_gestao_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_risco FOREIGN KEY (modelo_gestao_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_risco_resposta FOREIGN KEY (modelo_gestao_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_calendario FOREIGN KEY (modelo_gestao_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_monitoramento FOREIGN KEY (modelo_gestao_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_ata FOREIGN KEY (modelo_gestao_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_mswot FOREIGN KEY (modelo_gestao_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_swot FOREIGN KEY (modelo_gestao_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_operativo FOREIGN KEY (modelo_gestao_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_instrumento FOREIGN KEY (modelo_gestao_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_recurso FOREIGN KEY (modelo_gestao_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_problema FOREIGN KEY (modelo_gestao_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_demanda FOREIGN KEY (modelo_gestao_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_programa FOREIGN KEY (modelo_gestao_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_licao FOREIGN KEY (modelo_gestao_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_evento FOREIGN KEY (modelo_gestao_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_link FOREIGN KEY (modelo_gestao_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_avaliacao FOREIGN KEY (modelo_gestao_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_tgn FOREIGN KEY (modelo_gestao_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_brainstorm FOREIGN KEY (modelo_gestao_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_gut FOREIGN KEY (modelo_gestao_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_causa_efeito FOREIGN KEY (modelo_gestao_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_arquivo FOREIGN KEY (modelo_gestao_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_forum FOREIGN KEY (modelo_gestao_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_checklist FOREIGN KEY (modelo_gestao_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_agenda FOREIGN KEY (modelo_gestao_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_agrupamento FOREIGN KEY (modelo_gestao_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_patrocinador FOREIGN KEY (modelo_gestao_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_template FOREIGN KEY (modelo_gestao_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_painel FOREIGN KEY (modelo_gestao_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_painel_odometro FOREIGN KEY (modelo_gestao_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_painel_composicao FOREIGN KEY (modelo_gestao_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_tr FOREIGN KEY (modelo_gestao_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_me FOREIGN KEY (modelo_gestao_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_acao_item FOREIGN KEY (modelo_gestao_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_beneficio FOREIGN KEY (modelo_gestao_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_painel_slideshow FOREIGN KEY (modelo_gestao_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_projeto_viabilidade FOREIGN KEY (modelo_gestao_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_projeto_abertura FOREIGN KEY (modelo_gestao_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_gestao_plano_gestao FOREIGN KEY (modelo_gestao_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS custo_observacao;

CREATE TABLE custo_observacao (
  custo_observacao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  custo_observacao_custo INTEGER(100) UNSIGNED DEFAULT NULL,
  custo_observacao_gasto INTEGER(100) UNSIGNED DEFAULT NULL,
  custo_observacao_tarefa_custo	INTEGER(100) UNSIGNED DEFAULT NULL,
  custo_observacao_tarefa_gasto	INTEGER(100) UNSIGNED DEFAULT NULL,
  custo_observacao_log int(100) unsigned DEFAULT NULL,
  custo_observacao_demanda_custo INTEGER(100) UNSIGNED DEFAULT NULL,
  custo_observacao_plano_acao_item_custos INTEGER(100) UNSIGNED DEFAULT NULL,
  custo_observacao_plano_acao_item_gastos INTEGER(100) UNSIGNED DEFAULT NULL,
  custo_observacao_projeto_viabilidade_custo INTEGER(100) UNSIGNED DEFAULT NULL,
  custo_observacao_projeto_abertura_custo INTEGER(100) UNSIGNED DEFAULT NULL,
  custo_observacao_projeto_custo INTEGER(100) UNSIGNED DEFAULT NULL,
  custo_observacao_folha_ponto	INTEGER(100) UNSIGNED DEFAULT NULL,
  custo_observacao_recurso_ponto	INTEGER(100) UNSIGNED DEFAULT NULL,
  custo_observacao_recurso_tarefa	INTEGER(100) UNSIGNED DEFAULT NULL,
  custo_observacao_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  custo_observacao_data DATETIME DEFAULT NULL,
  custo_observacao_descricao MEDIUMTEXT,
  PRIMARY KEY (custo_observacao_id),
  KEY custo_observacao_custo (custo_observacao_custo),
  KEY custo_observacao_gasto (custo_observacao_gasto),
  KEY custo_observacao_tarefa_custo (custo_observacao_tarefa_custo),
  KEY custo_observacao_tarefa_gasto (custo_observacao_tarefa_gasto),
  KEY custo_observacao_log (custo_observacao_log),
  KEY custo_observacao_demanda_custo (custo_observacao_demanda_custo),
  KEY custo_observacao_plano_acao_item_custos (custo_observacao_plano_acao_item_custos),
  KEY custo_observacao_plano_acao_item_gastos (custo_observacao_plano_acao_item_gastos),
  KEY custo_observacao_projeto_viabilidade_custo (custo_observacao_projeto_viabilidade_custo),
  KEY custo_observacao_projeto_abertura_custo (custo_observacao_projeto_abertura_custo),
  KEY custo_observacao_projeto_custo (custo_observacao_projeto_custo),
  KEY custo_observacao_folha_ponto (custo_observacao_folha_ponto),
  KEY custo_observacao_recurso_ponto (custo_observacao_recurso_ponto),
  KEY custo_observacao_recurso_tarefa (custo_observacao_recurso_tarefa),
  KEY custo_observacao_usuario (custo_observacao_usuario),
  CONSTRAINT custo_observacao_custo FOREIGN KEY (custo_observacao_custo) REFERENCES tarefa_custos (tarefa_custos_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT custo_observacao_gasto FOREIGN KEY (custo_observacao_gasto) REFERENCES tarefa_gastos (tarefa_gastos_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT custo_observacao_tarefa_custo FOREIGN KEY (custo_observacao_tarefa_custo) REFERENCES tarefa_custos (tarefa_custos_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT custo_observacao_tarefa_gasto FOREIGN KEY (custo_observacao_tarefa_gasto) REFERENCES tarefa_gastos (tarefa_gastos_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT custo_observacao_demanda_custo FOREIGN KEY (custo_observacao_demanda_custo) REFERENCES demanda_custo (demanda_custo_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT custo_observacao_plano_acao_item_custos FOREIGN KEY (custo_observacao_plano_acao_item_custos) REFERENCES plano_acao_item_custos (plano_acao_item_custos_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT custo_observacao_plano_acao_item_gastos FOREIGN KEY (custo_observacao_plano_acao_item_gastos) REFERENCES plano_acao_item_gastos (plano_acao_item_gastos_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT custo_observacao_projeto_viabilidade_custo FOREIGN KEY (custo_observacao_projeto_viabilidade_custo) REFERENCES projeto_viabilidade_custo (projeto_viabilidade_custo_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT custo_observacao_projeto_abertura_custo FOREIGN KEY (custo_observacao_projeto_abertura_custo) REFERENCES projeto_abertura_custo (projeto_abertura_custo_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT custo_observacao_projeto_custo FOREIGN KEY (custo_observacao_projeto_custo) REFERENCES projeto_custo (projeto_custo_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT custo_observacao_log FOREIGN KEY (custo_observacao_log) REFERENCES log (log_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT custo_observacao_folha_ponto FOREIGN KEY (custo_observacao_folha_ponto) REFERENCES folha_ponto (folha_ponto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT custo_observacao_recurso_ponto FOREIGN KEY (custo_observacao_recurso_ponto) REFERENCES recurso_ponto (recurso_ponto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT custo_observacao_recurso_tarefa FOREIGN KEY (custo_observacao_recurso_tarefa) REFERENCES recurso_tarefa (recurso_tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT custo_observacao_usuario FOREIGN KEY (custo_observacao_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS painel_gestao;

CREATE TABLE painel_gestao (
	painel_gestao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	painel_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY painel_gestao_id (painel_gestao_id),
	KEY painel_gestao_painel (painel_gestao_painel),
	KEY painel_gestao_semelhante (painel_gestao_semelhante),
	KEY painel_gestao_projeto (painel_gestao_projeto),
	KEY painel_gestao_tarefa (painel_gestao_tarefa),
	KEY painel_gestao_perspectiva (painel_gestao_perspectiva),
	KEY painel_gestao_tema (painel_gestao_tema),
	KEY painel_gestao_objetivo (painel_gestao_objetivo),
	KEY painel_gestao_estrategia (painel_gestao_estrategia),
	KEY painel_gestao_meta (painel_gestao_meta),
	KEY painel_gestao_fator (painel_gestao_fator),
	KEY painel_gestao_pratica (painel_gestao_pratica),
	KEY painel_gestao_indicador (painel_gestao_indicador),
	KEY painel_gestao_acao (painel_gestao_acao),
	KEY painel_gestao_canvas (painel_gestao_canvas),
	KEY painel_gestao_risco (painel_gestao_risco),
	KEY painel_gestao_risco_resposta (painel_gestao_risco_resposta),
	KEY painel_gestao_calendario (painel_gestao_calendario),
	KEY painel_gestao_monitoramento (painel_gestao_monitoramento),
	KEY painel_gestao_ata (painel_gestao_ata),
	KEY painel_gestao_mswot(painel_gestao_mswot),
	KEY painel_gestao_swot(painel_gestao_swot),
	KEY painel_gestao_operativo(painel_gestao_operativo),
	KEY painel_gestao_instrumento (painel_gestao_instrumento),
	KEY painel_gestao_recurso (painel_gestao_recurso),
	KEY painel_gestao_problema (painel_gestao_problema),
	KEY painel_gestao_demanda (painel_gestao_demanda),
	KEY painel_gestao_programa (painel_gestao_programa),
	KEY painel_gestao_licao (painel_gestao_licao),
	KEY painel_gestao_evento (painel_gestao_evento),
	KEY painel_gestao_link (painel_gestao_link),
	KEY painel_gestao_avaliacao (painel_gestao_avaliacao),
	KEY painel_gestao_tgn (painel_gestao_tgn),
	KEY painel_gestao_brainstorm (painel_gestao_brainstorm),
	KEY painel_gestao_gut (painel_gestao_gut),
	KEY painel_gestao_causa_efeito (painel_gestao_causa_efeito),
	KEY painel_gestao_arquivo (painel_gestao_arquivo),
	KEY painel_gestao_forum (painel_gestao_forum),
	KEY painel_gestao_checklist (painel_gestao_checklist),
	KEY painel_gestao_agenda (painel_gestao_agenda),
	KEY painel_gestao_agrupamento (painel_gestao_agrupamento),
	KEY painel_gestao_patrocinador (painel_gestao_patrocinador),
	KEY painel_gestao_template (painel_gestao_template),
	KEY painel_gestao_painel_odometro (painel_gestao_painel_odometro),
	KEY painel_gestao_painel_composicao (painel_gestao_painel_composicao),
	KEY painel_gestao_tr (painel_gestao_tr),
	KEY painel_gestao_me (painel_gestao_me),
	KEY painel_gestao_acao_item (painel_gestao_acao_item),
	KEY painel_gestao_beneficio (painel_gestao_beneficio),
	KEY painel_gestao_painel_slideshow (painel_gestao_painel_slideshow),
	KEY painel_gestao_projeto_viabilidade (painel_gestao_projeto_viabilidade),
	KEY painel_gestao_projeto_abertura (painel_gestao_projeto_abertura),
	KEY painel_gestao_plano_gestao (painel_gestao_plano_gestao),
	CONSTRAINT painel_gestao_painel FOREIGN KEY (painel_gestao_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_semelhante FOREIGN KEY (painel_gestao_semelhante) REFERENCES painel (painel_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_projeto FOREIGN KEY (painel_gestao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_tarefa FOREIGN KEY (painel_gestao_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_perspectiva FOREIGN KEY (painel_gestao_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_tema FOREIGN KEY (painel_gestao_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_objetivo FOREIGN KEY (painel_gestao_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_fator FOREIGN KEY (painel_gestao_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_estrategia FOREIGN KEY (painel_gestao_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_meta FOREIGN KEY (painel_gestao_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_pratica FOREIGN KEY (painel_gestao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_indicador FOREIGN KEY (painel_gestao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_acao FOREIGN KEY (painel_gestao_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_canvas FOREIGN KEY (painel_gestao_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_risco FOREIGN KEY (painel_gestao_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_risco_resposta FOREIGN KEY (painel_gestao_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_calendario FOREIGN KEY (painel_gestao_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_monitoramento FOREIGN KEY (painel_gestao_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_ata FOREIGN KEY (painel_gestao_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_mswot FOREIGN KEY (painel_gestao_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_swot FOREIGN KEY (painel_gestao_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_operativo FOREIGN KEY (painel_gestao_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_instrumento FOREIGN KEY (painel_gestao_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_recurso FOREIGN KEY (painel_gestao_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_problema FOREIGN KEY (painel_gestao_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_demanda FOREIGN KEY (painel_gestao_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_programa FOREIGN KEY (painel_gestao_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_licao FOREIGN KEY (painel_gestao_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_evento FOREIGN KEY (painel_gestao_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_link FOREIGN KEY (painel_gestao_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_avaliacao FOREIGN KEY (painel_gestao_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_tgn FOREIGN KEY (painel_gestao_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_brainstorm FOREIGN KEY (painel_gestao_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_gut FOREIGN KEY (painel_gestao_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_causa_efeito FOREIGN KEY (painel_gestao_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_arquivo FOREIGN KEY (painel_gestao_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_forum FOREIGN KEY (painel_gestao_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_checklist FOREIGN KEY (painel_gestao_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_agenda FOREIGN KEY (painel_gestao_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_agrupamento FOREIGN KEY (painel_gestao_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_patrocinador FOREIGN KEY (painel_gestao_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_template FOREIGN KEY (painel_gestao_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_painel_odometro FOREIGN KEY (painel_gestao_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_painel_composicao FOREIGN KEY (painel_gestao_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_tr FOREIGN KEY (painel_gestao_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_me FOREIGN KEY (painel_gestao_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_acao_item FOREIGN KEY (painel_gestao_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_beneficio FOREIGN KEY (painel_gestao_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_painel_slideshow FOREIGN KEY (painel_gestao_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_projeto_viabilidade FOREIGN KEY (painel_gestao_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_projeto_abertura FOREIGN KEY (painel_gestao_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_gestao_plano_gestao FOREIGN KEY (painel_gestao_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS painel_odometro_gestao;

CREATE TABLE painel_odometro_gestao (
	painel_odometro_gestao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	painel_odometro_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY painel_odometro_gestao_id (painel_odometro_gestao_id),
	KEY painel_odometro_gestao_painel_odometro (painel_odometro_gestao_painel_odometro),
	KEY painel_odometro_gestao_semelhante (painel_odometro_gestao_semelhante),
	KEY painel_odometro_gestao_projeto (painel_odometro_gestao_projeto),
	KEY painel_odometro_gestao_tarefa (painel_odometro_gestao_tarefa),
	KEY painel_odometro_gestao_perspectiva (painel_odometro_gestao_perspectiva),
	KEY painel_odometro_gestao_tema (painel_odometro_gestao_tema),
	KEY painel_odometro_gestao_objetivo (painel_odometro_gestao_objetivo),
	KEY painel_odometro_gestao_estrategia (painel_odometro_gestao_estrategia),
	KEY painel_odometro_gestao_meta (painel_odometro_gestao_meta),
	KEY painel_odometro_gestao_fator (painel_odometro_gestao_fator),
	KEY painel_odometro_gestao_pratica (painel_odometro_gestao_pratica),
	KEY painel_odometro_gestao_indicador (painel_odometro_gestao_indicador),
	KEY painel_odometro_gestao_acao (painel_odometro_gestao_acao),
	KEY painel_odometro_gestao_canvas (painel_odometro_gestao_canvas),
	KEY painel_odometro_gestao_risco (painel_odometro_gestao_risco),
	KEY painel_odometro_gestao_risco_resposta (painel_odometro_gestao_risco_resposta),
	KEY painel_odometro_gestao_calendario (painel_odometro_gestao_calendario),
	KEY painel_odometro_gestao_monitoramento (painel_odometro_gestao_monitoramento),
	KEY painel_odometro_gestao_ata (painel_odometro_gestao_ata),
	KEY painel_odometro_gestao_mswot(painel_odometro_gestao_mswot),
	KEY painel_odometro_gestao_swot(painel_odometro_gestao_swot),
	KEY painel_odometro_gestao_operativo(painel_odometro_gestao_operativo),
	KEY painel_odometro_gestao_instrumento (painel_odometro_gestao_instrumento),
	KEY painel_odometro_gestao_recurso (painel_odometro_gestao_recurso),
	KEY painel_odometro_gestao_problema (painel_odometro_gestao_problema),
	KEY painel_odometro_gestao_demanda (painel_odometro_gestao_demanda),
	KEY painel_odometro_gestao_programa (painel_odometro_gestao_programa),
	KEY painel_odometro_gestao_licao (painel_odometro_gestao_licao),
	KEY painel_odometro_gestao_evento (painel_odometro_gestao_evento),
	KEY painel_odometro_gestao_link (painel_odometro_gestao_link),
	KEY painel_odometro_gestao_avaliacao (painel_odometro_gestao_avaliacao),
	KEY painel_odometro_gestao_tgn (painel_odometro_gestao_tgn),
	KEY painel_odometro_gestao_brainstorm (painel_odometro_gestao_brainstorm),
	KEY painel_odometro_gestao_gut (painel_odometro_gestao_gut),
	KEY painel_odometro_gestao_causa_efeito (painel_odometro_gestao_causa_efeito),
	KEY painel_odometro_gestao_arquivo (painel_odometro_gestao_arquivo),
	KEY painel_odometro_gestao_forum (painel_odometro_gestao_forum),
	KEY painel_odometro_gestao_checklist (painel_odometro_gestao_checklist),
	KEY painel_odometro_gestao_agenda (painel_odometro_gestao_agenda),
	KEY painel_odometro_gestao_agrupamento (painel_odometro_gestao_agrupamento),
	KEY painel_odometro_gestao_patrocinador (painel_odometro_gestao_patrocinador),
	KEY painel_odometro_gestao_template (painel_odometro_gestao_template),
	KEY painel_odometro_gestao_painel (painel_odometro_gestao_painel),
	KEY painel_odometro_gestao_painel_composicao (painel_odometro_gestao_painel_composicao),
	KEY painel_odometro_gestao_tr (painel_odometro_gestao_tr),
	KEY painel_odometro_gestao_me (painel_odometro_gestao_me),
	KEY painel_odometro_gestao_acao_item (painel_odometro_gestao_acao_item),
	KEY painel_odometro_gestao_beneficio (painel_odometro_gestao_beneficio),
	KEY painel_odometro_gestao_painel_slideshow (painel_odometro_gestao_painel_slideshow),
	KEY painel_odometro_gestao_projeto_viabilidade (painel_odometro_gestao_projeto_viabilidade),
	KEY painel_odometro_gestao_projeto_abertura (painel_odometro_gestao_projeto_abertura),
	KEY painel_odometro_gestao_plano_gestao (painel_odometro_gestao_plano_gestao),
	CONSTRAINT painel_odometro_gestao_painel_odometro FOREIGN KEY (painel_odometro_gestao_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_semelhante FOREIGN KEY (painel_odometro_gestao_semelhante) REFERENCES painel_odometro (painel_odometro_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_projeto FOREIGN KEY (painel_odometro_gestao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_tarefa FOREIGN KEY (painel_odometro_gestao_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_perspectiva FOREIGN KEY (painel_odometro_gestao_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_tema FOREIGN KEY (painel_odometro_gestao_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_objetivo FOREIGN KEY (painel_odometro_gestao_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_fator FOREIGN KEY (painel_odometro_gestao_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_estrategia FOREIGN KEY (painel_odometro_gestao_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_meta FOREIGN KEY (painel_odometro_gestao_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_pratica FOREIGN KEY (painel_odometro_gestao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_indicador FOREIGN KEY (painel_odometro_gestao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_acao FOREIGN KEY (painel_odometro_gestao_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_canvas FOREIGN KEY (painel_odometro_gestao_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_risco FOREIGN KEY (painel_odometro_gestao_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_risco_resposta FOREIGN KEY (painel_odometro_gestao_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_calendario FOREIGN KEY (painel_odometro_gestao_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_monitoramento FOREIGN KEY (painel_odometro_gestao_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_ata FOREIGN KEY (painel_odometro_gestao_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_mswot FOREIGN KEY (painel_odometro_gestao_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_swot FOREIGN KEY (painel_odometro_gestao_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_operativo FOREIGN KEY (painel_odometro_gestao_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_instrumento FOREIGN KEY (painel_odometro_gestao_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_recurso FOREIGN KEY (painel_odometro_gestao_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_problema FOREIGN KEY (painel_odometro_gestao_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_demanda FOREIGN KEY (painel_odometro_gestao_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_programa FOREIGN KEY (painel_odometro_gestao_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_licao FOREIGN KEY (painel_odometro_gestao_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_evento FOREIGN KEY (painel_odometro_gestao_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_link FOREIGN KEY (painel_odometro_gestao_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_avaliacao FOREIGN KEY (painel_odometro_gestao_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_tgn FOREIGN KEY (painel_odometro_gestao_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_brainstorm FOREIGN KEY (painel_odometro_gestao_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_gut FOREIGN KEY (painel_odometro_gestao_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_causa_efeito FOREIGN KEY (painel_odometro_gestao_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_arquivo FOREIGN KEY (painel_odometro_gestao_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_forum FOREIGN KEY (painel_odometro_gestao_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_checklist FOREIGN KEY (painel_odometro_gestao_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_agenda FOREIGN KEY (painel_odometro_gestao_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_agrupamento FOREIGN KEY (painel_odometro_gestao_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_patrocinador FOREIGN KEY (painel_odometro_gestao_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_template FOREIGN KEY (painel_odometro_gestao_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_painel FOREIGN KEY (painel_odometro_gestao_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_painel_composicao FOREIGN KEY (painel_odometro_gestao_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_tr FOREIGN KEY (painel_odometro_gestao_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_me FOREIGN KEY (painel_odometro_gestao_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_acao_item FOREIGN KEY (painel_odometro_gestao_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_beneficio FOREIGN KEY (painel_odometro_gestao_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_painel_slideshow FOREIGN KEY (painel_odometro_gestao_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_projeto_viabilidade FOREIGN KEY (painel_odometro_gestao_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_projeto_abertura FOREIGN KEY (painel_odometro_gestao_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_gestao_plano_gestao FOREIGN KEY (painel_odometro_gestao_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS painel_composicao_gestao;

CREATE TABLE painel_composicao_gestao (
	painel_composicao_gestao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	painel_composicao_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY painel_composicao_gestao_id (painel_composicao_gestao_id),
	KEY painel_composicao_gestao_painel_composicao (painel_composicao_gestao_painel_composicao),
	KEY painel_composicao_gestao_semelhante (painel_composicao_gestao_semelhante),
	KEY painel_composicao_gestao_projeto (painel_composicao_gestao_projeto),
	KEY painel_composicao_gestao_tarefa (painel_composicao_gestao_tarefa),
	KEY painel_composicao_gestao_perspectiva (painel_composicao_gestao_perspectiva),
	KEY painel_composicao_gestao_tema (painel_composicao_gestao_tema),
	KEY painel_composicao_gestao_objetivo (painel_composicao_gestao_objetivo),
	KEY painel_composicao_gestao_estrategia (painel_composicao_gestao_estrategia),
	KEY painel_composicao_gestao_meta (painel_composicao_gestao_meta),
	KEY painel_composicao_gestao_fator (painel_composicao_gestao_fator),
	KEY painel_composicao_gestao_pratica (painel_composicao_gestao_pratica),
	KEY painel_composicao_gestao_indicador (painel_composicao_gestao_indicador),
	KEY painel_composicao_gestao_acao (painel_composicao_gestao_acao),
	KEY painel_composicao_gestao_canvas (painel_composicao_gestao_canvas),
	KEY painel_composicao_gestao_risco (painel_composicao_gestao_risco),
	KEY painel_composicao_gestao_risco_resposta (painel_composicao_gestao_risco_resposta),
	KEY painel_composicao_gestao_calendario (painel_composicao_gestao_calendario),
	KEY painel_composicao_gestao_monitoramento (painel_composicao_gestao_monitoramento),
	KEY painel_composicao_gestao_ata (painel_composicao_gestao_ata),
	KEY painel_composicao_gestao_mswot(painel_composicao_gestao_mswot),
	KEY painel_composicao_gestao_swot(painel_composicao_gestao_swot),
	KEY painel_composicao_gestao_operativo(painel_composicao_gestao_operativo),
	KEY painel_composicao_gestao_instrumento (painel_composicao_gestao_instrumento),
	KEY painel_composicao_gestao_recurso (painel_composicao_gestao_recurso),
	KEY painel_composicao_gestao_problema (painel_composicao_gestao_problema),
	KEY painel_composicao_gestao_demanda (painel_composicao_gestao_demanda),
	KEY painel_composicao_gestao_programa (painel_composicao_gestao_programa),
	KEY painel_composicao_gestao_licao (painel_composicao_gestao_licao),
	KEY painel_composicao_gestao_evento (painel_composicao_gestao_evento),
	KEY painel_composicao_gestao_link (painel_composicao_gestao_link),
	KEY painel_composicao_gestao_avaliacao (painel_composicao_gestao_avaliacao),
	KEY painel_composicao_gestao_tgn (painel_composicao_gestao_tgn),
	KEY painel_composicao_gestao_brainstorm (painel_composicao_gestao_brainstorm),
	KEY painel_composicao_gestao_gut (painel_composicao_gestao_gut),
	KEY painel_composicao_gestao_causa_efeito (painel_composicao_gestao_causa_efeito),
	KEY painel_composicao_gestao_arquivo (painel_composicao_gestao_arquivo),
	KEY painel_composicao_gestao_forum (painel_composicao_gestao_forum),
	KEY painel_composicao_gestao_checklist (painel_composicao_gestao_checklist),
	KEY painel_composicao_gestao_agenda (painel_composicao_gestao_agenda),
	KEY painel_composicao_gestao_agrupamento (painel_composicao_gestao_agrupamento),
	KEY painel_composicao_gestao_patrocinador (painel_composicao_gestao_patrocinador),
	KEY painel_composicao_gestao_template (painel_composicao_gestao_template),
	KEY painel_composicao_gestao_painel (painel_composicao_gestao_painel),
	KEY painel_composicao_gestao_painel_odometro (painel_composicao_gestao_painel_odometro),
	KEY painel_composicao_gestao_tr (painel_composicao_gestao_tr),
	KEY painel_composicao_gestao_me (painel_composicao_gestao_me),
	KEY painel_composicao_gestao_acao_item (painel_composicao_gestao_acao_item),
	KEY painel_composicao_gestao_beneficio (painel_composicao_gestao_beneficio),
	KEY painel_composicao_gestao_painel_slideshow (painel_composicao_gestao_painel_slideshow),
	KEY painel_composicao_gestao_projeto_viabilidade (painel_composicao_gestao_projeto_viabilidade),
	KEY painel_composicao_gestao_projeto_abertura (painel_composicao_gestao_projeto_abertura),
	KEY painel_composicao_gestao_plano_gestao (painel_composicao_gestao_plano_gestao),
	CONSTRAINT painel_composicao_gestao_painel_composicao FOREIGN KEY (painel_composicao_gestao_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_semelhante FOREIGN KEY (painel_composicao_gestao_semelhante) REFERENCES painel_composicao (painel_composicao_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_projeto FOREIGN KEY (painel_composicao_gestao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_tarefa FOREIGN KEY (painel_composicao_gestao_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_perspectiva FOREIGN KEY (painel_composicao_gestao_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_tema FOREIGN KEY (painel_composicao_gestao_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_objetivo FOREIGN KEY (painel_composicao_gestao_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_fator FOREIGN KEY (painel_composicao_gestao_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_estrategia FOREIGN KEY (painel_composicao_gestao_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_meta FOREIGN KEY (painel_composicao_gestao_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_pratica FOREIGN KEY (painel_composicao_gestao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_indicador FOREIGN KEY (painel_composicao_gestao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_acao FOREIGN KEY (painel_composicao_gestao_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_canvas FOREIGN KEY (painel_composicao_gestao_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_risco FOREIGN KEY (painel_composicao_gestao_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_risco_resposta FOREIGN KEY (painel_composicao_gestao_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_calendario FOREIGN KEY (painel_composicao_gestao_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_monitoramento FOREIGN KEY (painel_composicao_gestao_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_ata FOREIGN KEY (painel_composicao_gestao_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_mswot FOREIGN KEY (painel_composicao_gestao_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_swot FOREIGN KEY (painel_composicao_gestao_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_operativo FOREIGN KEY (painel_composicao_gestao_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_instrumento FOREIGN KEY (painel_composicao_gestao_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_recurso FOREIGN KEY (painel_composicao_gestao_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_problema FOREIGN KEY (painel_composicao_gestao_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_demanda FOREIGN KEY (painel_composicao_gestao_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_programa FOREIGN KEY (painel_composicao_gestao_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_licao FOREIGN KEY (painel_composicao_gestao_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_evento FOREIGN KEY (painel_composicao_gestao_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_link FOREIGN KEY (painel_composicao_gestao_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_avaliacao FOREIGN KEY (painel_composicao_gestao_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_tgn FOREIGN KEY (painel_composicao_gestao_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_brainstorm FOREIGN KEY (painel_composicao_gestao_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_gut FOREIGN KEY (painel_composicao_gestao_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_causa_efeito FOREIGN KEY (painel_composicao_gestao_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_arquivo FOREIGN KEY (painel_composicao_gestao_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_forum FOREIGN KEY (painel_composicao_gestao_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_checklist FOREIGN KEY (painel_composicao_gestao_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_agenda FOREIGN KEY (painel_composicao_gestao_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_agrupamento FOREIGN KEY (painel_composicao_gestao_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_patrocinador FOREIGN KEY (painel_composicao_gestao_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_template FOREIGN KEY (painel_composicao_gestao_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_painel FOREIGN KEY (painel_composicao_gestao_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_painel_odometro FOREIGN KEY (painel_composicao_gestao_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_tr FOREIGN KEY (painel_composicao_gestao_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_me FOREIGN KEY (painel_composicao_gestao_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_acao_item FOREIGN KEY (painel_composicao_gestao_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_beneficio FOREIGN KEY (painel_composicao_gestao_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_painel_slideshow FOREIGN KEY (painel_composicao_gestao_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_projeto_viabilidade FOREIGN KEY (painel_composicao_gestao_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_projeto_abertura FOREIGN KEY (painel_composicao_gestao_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT painel_composicao_gestao_plano_gestao FOREIGN KEY (painel_composicao_gestao_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS assinatura;

CREATE TABLE assinatura (
	assinatura_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	assinatura_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_link INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_template INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_me INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_plano_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_aviso INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_modelo INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  assinatura_atesta INTEGER(100) UNSIGNED DEFAULT NULL,
  assinatura_atesta_opcao INTEGER(100) UNSIGNED DEFAULT NULL,
  assinatura_funcao VARCHAR (255),
  assinatura_data DATETIME,
  assinatura_aprova TINYINT(1) DEFAULT 0,
  assinatura_aprovou TINYINT(1) DEFAULT 0,
  assinatura_observacao MEDIUMTEXT,
  assinatura_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  assinatura_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY assinatura_id (assinatura_id),
	KEY assinatura_projeto (assinatura_projeto),
	KEY assinatura_tarefa (assinatura_tarefa),
	KEY assinatura_perspectiva (assinatura_perspectiva),
	KEY assinatura_tema (assinatura_tema),
	KEY assinatura_objetivo (assinatura_objetivo),
	KEY assinatura_estrategia (assinatura_estrategia),
	KEY assinatura_meta (assinatura_meta),
	KEY assinatura_fator (assinatura_fator),
	KEY assinatura_pratica (assinatura_pratica),
	KEY assinatura_indicador (assinatura_indicador),
	KEY assinatura_acao (assinatura_acao),
	KEY assinatura_canvas (assinatura_canvas),
	KEY assinatura_risco (assinatura_risco),
	KEY assinatura_risco_resposta (assinatura_risco_resposta),
	KEY assinatura_calendario (assinatura_calendario),
	KEY assinatura_monitoramento (assinatura_monitoramento),
	KEY assinatura_ata (assinatura_ata),
	KEY assinatura_mswot(assinatura_mswot),
	KEY assinatura_swot(assinatura_swot),
	KEY assinatura_operativo(assinatura_operativo),
	KEY assinatura_instrumento (assinatura_instrumento),
	KEY assinatura_recurso (assinatura_recurso),
	KEY assinatura_problema (assinatura_problema),
	KEY assinatura_demanda (assinatura_demanda),
	KEY assinatura_programa (assinatura_programa),
	KEY assinatura_licao (assinatura_licao),
	KEY assinatura_evento (assinatura_evento),
	KEY assinatura_link (assinatura_link),
	KEY assinatura_avaliacao (assinatura_avaliacao),
	KEY assinatura_tgn (assinatura_tgn),
	KEY assinatura_brainstorm (assinatura_brainstorm),
	KEY assinatura_gut (assinatura_gut),
	KEY assinatura_causa_efeito (assinatura_causa_efeito),
	KEY assinatura_arquivo (assinatura_arquivo),
	KEY assinatura_forum (assinatura_forum),
	KEY assinatura_checklist (assinatura_checklist),
	KEY assinatura_agenda (assinatura_agenda),
	KEY assinatura_agrupamento (assinatura_agrupamento),
	KEY assinatura_patrocinador (assinatura_patrocinador),
	KEY assinatura_template (assinatura_template),
	KEY assinatura_painel (assinatura_painel),
	KEY assinatura_painel_odometro (assinatura_painel_odometro),
	KEY assinatura_painel_composicao (assinatura_painel_composicao),
	KEY assinatura_tr (assinatura_tr),
	KEY assinatura_me (assinatura_me),
	KEY assinatura_plano_acao_item (assinatura_plano_acao_item),
	KEY assinatura_beneficio (assinatura_beneficio),
	KEY assinatura_painel_slideshow (assinatura_painel_slideshow),
	KEY assinatura_viabilidade (assinatura_viabilidade),
	KEY assinatura_abertura (assinatura_abertura),
	KEY assinatura_plano_gestao (assinatura_plano_gestao),
	KEY assinatura_aviso (assinatura_aviso),
	KEY assinatura_modelo (assinatura_modelo),
	KEY assinatura_usuario (assinatura_usuario),
  KEY assinatura_atesta (assinatura_atesta),
  KEY assinatura_atesta_opcao (assinatura_atesta_opcao),
	CONSTRAINT assinatura_projeto FOREIGN KEY (assinatura_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_tarefa FOREIGN KEY (assinatura_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_perspectiva FOREIGN KEY (assinatura_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_tema FOREIGN KEY (assinatura_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_objetivo FOREIGN KEY (assinatura_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_fator FOREIGN KEY (assinatura_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_estrategia FOREIGN KEY (assinatura_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_meta FOREIGN KEY (assinatura_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_pratica FOREIGN KEY (assinatura_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_indicador FOREIGN KEY (assinatura_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_acao FOREIGN KEY (assinatura_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_canvas FOREIGN KEY (assinatura_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_risco FOREIGN KEY (assinatura_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_risco_resposta FOREIGN KEY (assinatura_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_calendario FOREIGN KEY (assinatura_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_monitoramento FOREIGN KEY (assinatura_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_ata FOREIGN KEY (assinatura_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_mswot FOREIGN KEY (assinatura_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_swot FOREIGN KEY (assinatura_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_operativo FOREIGN KEY (assinatura_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_instrumento FOREIGN KEY (assinatura_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_recurso FOREIGN KEY (assinatura_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_problema FOREIGN KEY (assinatura_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_demanda FOREIGN KEY (assinatura_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_programa FOREIGN KEY (assinatura_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_licao FOREIGN KEY (assinatura_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_evento FOREIGN KEY (assinatura_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_link FOREIGN KEY (assinatura_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_avaliacao FOREIGN KEY (assinatura_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_tgn FOREIGN KEY (assinatura_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_brainstorm FOREIGN KEY (assinatura_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_gut FOREIGN KEY (assinatura_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_causa_efeito FOREIGN KEY (assinatura_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_arquivo FOREIGN KEY (assinatura_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_forum FOREIGN KEY (assinatura_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_checklist FOREIGN KEY (assinatura_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_agenda FOREIGN KEY (assinatura_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_agrupamento FOREIGN KEY (assinatura_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_patrocinador FOREIGN KEY (assinatura_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_template FOREIGN KEY (assinatura_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_painel FOREIGN KEY (assinatura_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_painel_odometro FOREIGN KEY (assinatura_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_painel_composicao FOREIGN KEY (assinatura_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_tr FOREIGN KEY (assinatura_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_me FOREIGN KEY (assinatura_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_plano_acao_item FOREIGN KEY (assinatura_plano_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_beneficio FOREIGN KEY (assinatura_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_painel_slideshow FOREIGN KEY (assinatura_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT assinatura_viabilidade FOREIGN KEY (assinatura_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT assinatura_abertura FOREIGN KEY (assinatura_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT assinatura_plano_gestao FOREIGN KEY (assinatura_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT assinatura_aviso FOREIGN KEY (assinatura_aviso) REFERENCES aviso (aviso_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT assinatura_modelo FOREIGN KEY (assinatura_modelo) REFERENCES modelos (modelo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT assinatura_usuario FOREIGN KEY (assinatura_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT assinatura_atesta FOREIGN KEY (assinatura_atesta) REFERENCES assinatura_atesta (assinatura_atesta_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT assinatura_atesta_opcao FOREIGN KEY (assinatura_atesta_opcao) REFERENCES assinatura_atesta_opcao (assinatura_atesta_opcao_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS assinatura_historico;

CREATE TABLE assinatura_historico (
	assinatura_historico_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	assinatura_historico_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_link INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_template INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  assinatura_historico_atesta INTEGER(100) UNSIGNED DEFAULT NULL,
  assinatura_historico_atesta_opcao INTEGER(100) UNSIGNED DEFAULT NULL,
  assinatura_historico_funcao VARCHAR (255),
  assinatura_historico_data DATETIME,
  assinatura_historico_aprova TINYINT(1) DEFAULT 0,
  assinatura_historico_observacao MEDIUMTEXT,
	PRIMARY KEY assinatura_historico_id (assinatura_historico_id),
	KEY assinatura_historico_projeto (assinatura_historico_projeto),
	KEY assinatura_historico_tarefa (assinatura_historico_tarefa),
	KEY assinatura_historico_perspectiva (assinatura_historico_perspectiva),
	KEY assinatura_historico_tema (assinatura_historico_tema),
	KEY assinatura_historico_objetivo (assinatura_historico_objetivo),
	KEY assinatura_historico_estrategia (assinatura_historico_estrategia),
	KEY assinatura_historico_meta (assinatura_historico_meta),
	KEY assinatura_historico_fator (assinatura_historico_fator),
	KEY assinatura_historico_pratica (assinatura_historico_pratica),
	KEY assinatura_historico_indicador (assinatura_historico_indicador),
	KEY assinatura_historico_acao (assinatura_historico_acao),
	KEY assinatura_historico_canvas (assinatura_historico_canvas),
	KEY assinatura_historico_risco (assinatura_historico_risco),
	KEY assinatura_historico_risco_resposta (assinatura_historico_risco_resposta),
	KEY assinatura_historico_calendario (assinatura_historico_calendario),
	KEY assinatura_historico_monitoramento (assinatura_historico_monitoramento),
	KEY assinatura_historico_ata (assinatura_historico_ata),
	KEY assinatura_historico_mswot(assinatura_historico_mswot),
	KEY assinatura_historico_swot(assinatura_historico_swot),
	KEY assinatura_historico_operativo(assinatura_historico_operativo),
	KEY assinatura_historico_instrumento (assinatura_historico_instrumento),
	KEY assinatura_historico_recurso (assinatura_historico_recurso),
	KEY assinatura_historico_problema (assinatura_historico_problema),
	KEY assinatura_historico_demanda (assinatura_historico_demanda),
	KEY assinatura_historico_programa (assinatura_historico_programa),
	KEY assinatura_historico_licao (assinatura_historico_licao),
	KEY assinatura_historico_evento (assinatura_historico_evento),
	KEY assinatura_historico_link (assinatura_historico_link),
	KEY assinatura_historico_avaliacao (assinatura_historico_avaliacao),
	KEY assinatura_historico_tgn (assinatura_historico_tgn),
	KEY assinatura_historico_brainstorm (assinatura_historico_brainstorm),
	KEY assinatura_historico_gut (assinatura_historico_gut),
	KEY assinatura_historico_causa_efeito (assinatura_historico_causa_efeito),
	KEY assinatura_historico_arquivo (assinatura_historico_arquivo),
	KEY assinatura_historico_forum (assinatura_historico_forum),
	KEY assinatura_historico_checklist (assinatura_historico_checklist),
	KEY assinatura_historico_agenda (assinatura_historico_agenda),
	KEY assinatura_historico_agrupamento (assinatura_historico_agrupamento),
	KEY assinatura_historico_patrocinador (assinatura_historico_patrocinador),
	KEY assinatura_historico_template (assinatura_historico_template),
	KEY assinatura_historico_painel (assinatura_historico_painel),
	KEY assinatura_historico_painel_odometro (assinatura_historico_painel_odometro),
	KEY assinatura_historico_painel_composicao (assinatura_historico_painel_composicao),
	KEY assinatura_historico_tr (assinatura_historico_tr),
	KEY assinatura_historico_usuario (assinatura_historico_usuario),
  KEY assinatura_historico_atesta (assinatura_historico_atesta),
  KEY assinatura_historico_atesta_opcao (assinatura_historico_atesta_opcao),
	CONSTRAINT assinatura_historico_projeto FOREIGN KEY (assinatura_historico_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_tarefa FOREIGN KEY (assinatura_historico_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_perspectiva FOREIGN KEY (assinatura_historico_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_tema FOREIGN KEY (assinatura_historico_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_objetivo FOREIGN KEY (assinatura_historico_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_fator FOREIGN KEY (assinatura_historico_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_estrategia FOREIGN KEY (assinatura_historico_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_meta FOREIGN KEY (assinatura_historico_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_pratica FOREIGN KEY (assinatura_historico_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_indicador FOREIGN KEY (assinatura_historico_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_acao FOREIGN KEY (assinatura_historico_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_canvas FOREIGN KEY (assinatura_historico_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_risco FOREIGN KEY (assinatura_historico_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_risco_resposta FOREIGN KEY (assinatura_historico_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_calendario FOREIGN KEY (assinatura_historico_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_monitoramento FOREIGN KEY (assinatura_historico_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_ata FOREIGN KEY (assinatura_historico_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_mswot FOREIGN KEY (assinatura_historico_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_swot FOREIGN KEY (assinatura_historico_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_operativo FOREIGN KEY (assinatura_historico_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_instrumento FOREIGN KEY (assinatura_historico_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_recurso FOREIGN KEY (assinatura_historico_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_problema FOREIGN KEY (assinatura_historico_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_demanda FOREIGN KEY (assinatura_historico_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_programa FOREIGN KEY (assinatura_historico_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_licao FOREIGN KEY (assinatura_historico_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_evento FOREIGN KEY (assinatura_historico_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_link FOREIGN KEY (assinatura_historico_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_avaliacao FOREIGN KEY (assinatura_historico_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_tgn FOREIGN KEY (assinatura_historico_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_brainstorm FOREIGN KEY (assinatura_historico_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_gut FOREIGN KEY (assinatura_historico_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_causa_efeito FOREIGN KEY (assinatura_historico_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_arquivo FOREIGN KEY (assinatura_historico_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_forum FOREIGN KEY (assinatura_historico_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_checklist FOREIGN KEY (assinatura_historico_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_agenda FOREIGN KEY (assinatura_historico_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_agrupamento FOREIGN KEY (assinatura_historico_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_patrocinador FOREIGN KEY (assinatura_historico_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_template FOREIGN KEY (assinatura_historico_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_painel FOREIGN KEY (assinatura_historico_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_painel_odometro FOREIGN KEY (assinatura_historico_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_painel_composicao FOREIGN KEY (assinatura_historico_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_tr FOREIGN KEY (assinatura_historico_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT assinatura_historico_usuario FOREIGN KEY (assinatura_historico_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT assinatura_historico_atesta FOREIGN KEY (assinatura_historico_atesta) REFERENCES assinatura_atesta (assinatura_atesta_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT assinatura_historico_atesta_opcao FOREIGN KEY (assinatura_historico_atesta_opcao) REFERENCES assinatura_atesta_opcao (assinatura_atesta_opcao_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS meta_gestao;

CREATE TABLE meta_gestao (
	meta_gestao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	meta_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY meta_gestao_id (meta_gestao_id),
	KEY meta_gestao_meta (meta_gestao_meta),
	KEY meta_gestao_semelhante (meta_gestao_semelhante),
	KEY meta_gestao_projeto (meta_gestao_projeto),
	KEY meta_gestao_tarefa (meta_gestao_tarefa),
	KEY meta_gestao_perspectiva (meta_gestao_perspectiva),
	KEY meta_gestao_tema (meta_gestao_tema),
	KEY meta_gestao_objetivo (meta_gestao_objetivo),
	KEY meta_gestao_me (meta_gestao_me),
	KEY meta_gestao_estrategia (meta_gestao_estrategia),
	KEY meta_gestao_fator (meta_gestao_fator),
	KEY meta_gestao_pratica (meta_gestao_pratica),
	KEY meta_gestao_indicador (meta_gestao_indicador),
	KEY meta_gestao_acao (meta_gestao_acao),
	KEY meta_gestao_canvas (meta_gestao_canvas),
	KEY meta_gestao_risco (meta_gestao_risco),
	KEY meta_gestao_risco_resposta (meta_gestao_risco_resposta),
	KEY meta_gestao_calendario (meta_gestao_calendario),
	KEY meta_gestao_monitoramento (meta_gestao_monitoramento),
	KEY meta_gestao_ata (meta_gestao_ata),
	KEY meta_gestao_mswot(meta_gestao_mswot),
	KEY meta_gestao_swot(meta_gestao_swot),
	KEY meta_gestao_operativo(meta_gestao_operativo),
	KEY meta_gestao_instrumento (meta_gestao_instrumento),
	KEY meta_gestao_recurso (meta_gestao_recurso),
	KEY meta_gestao_problema (meta_gestao_problema),
	KEY meta_gestao_demanda (meta_gestao_demanda),
	KEY meta_gestao_programa (meta_gestao_programa),
	KEY meta_gestao_licao (meta_gestao_licao),
	KEY meta_gestao_evento (meta_gestao_evento),
	KEY meta_gestao_link (meta_gestao_link),
	KEY meta_gestao_avaliacao (meta_gestao_avaliacao),
	KEY meta_gestao_tgn (meta_gestao_tgn),
	KEY meta_gestao_brainstorm (meta_gestao_brainstorm),
	KEY meta_gestao_gut (meta_gestao_gut),
	KEY meta_gestao_causa_efeito (meta_gestao_causa_efeito),
	KEY meta_gestao_arquivo (meta_gestao_arquivo),
	KEY meta_gestao_forum (meta_gestao_forum),
	KEY meta_gestao_checklist (meta_gestao_checklist),
	KEY meta_gestao_agenda (meta_gestao_agenda),
	KEY meta_gestao_agrupamento (meta_gestao_agrupamento),
	KEY meta_gestao_patrocinador (meta_gestao_patrocinador),
	KEY meta_gestao_template (meta_gestao_template),
	KEY meta_gestao_painel (meta_gestao_painel),
	KEY meta_gestao_painel_odometro (meta_gestao_painel_odometro),
	KEY meta_gestao_painel_composicao (meta_gestao_painel_composicao),
	KEY meta_gestao_tr (meta_gestao_tr),
	KEY meta_gestao_acao_item (meta_gestao_acao_item),
	KEY meta_gestao_beneficio (meta_gestao_beneficio),
	KEY meta_gestao_painel_slideshow (meta_gestao_painel_slideshow),
	KEY meta_gestao_projeto_viabilidade (meta_gestao_projeto_viabilidade),
	KEY meta_gestao_projeto_abertura (meta_gestao_projeto_abertura),
	KEY meta_gestao_plano_gestao (meta_gestao_plano_gestao),
	CONSTRAINT meta_gestao_meta FOREIGN KEY (meta_gestao_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_semelhante FOREIGN KEY (meta_gestao_semelhante) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_projeto FOREIGN KEY (meta_gestao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_tarefa FOREIGN KEY (meta_gestao_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_perspectiva FOREIGN KEY (meta_gestao_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_tema FOREIGN KEY (meta_gestao_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_objetivo FOREIGN KEY (meta_gestao_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_me FOREIGN KEY (meta_gestao_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_fator FOREIGN KEY (meta_gestao_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_estrategia FOREIGN KEY (meta_gestao_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_pratica FOREIGN KEY (meta_gestao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_indicador FOREIGN KEY (meta_gestao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_acao FOREIGN KEY (meta_gestao_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_canvas FOREIGN KEY (meta_gestao_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_risco FOREIGN KEY (meta_gestao_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_risco_resposta FOREIGN KEY (meta_gestao_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_calendario FOREIGN KEY (meta_gestao_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_monitoramento FOREIGN KEY (meta_gestao_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_ata FOREIGN KEY (meta_gestao_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_mswot FOREIGN KEY (meta_gestao_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_swot FOREIGN KEY (meta_gestao_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_operativo FOREIGN KEY (meta_gestao_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_instrumento FOREIGN KEY (meta_gestao_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_recurso FOREIGN KEY (meta_gestao_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_problema FOREIGN KEY (meta_gestao_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_demanda FOREIGN KEY (meta_gestao_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_programa FOREIGN KEY (meta_gestao_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_licao FOREIGN KEY (meta_gestao_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_evento FOREIGN KEY (meta_gestao_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_link FOREIGN KEY (meta_gestao_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_avaliacao FOREIGN KEY (meta_gestao_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_tgn FOREIGN KEY (meta_gestao_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_brainstorm FOREIGN KEY (meta_gestao_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_gut FOREIGN KEY (meta_gestao_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_causa_efeito FOREIGN KEY (meta_gestao_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_arquivo FOREIGN KEY (meta_gestao_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_forum FOREIGN KEY (meta_gestao_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_checklist FOREIGN KEY (meta_gestao_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_agenda FOREIGN KEY (meta_gestao_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_agrupamento FOREIGN KEY (meta_gestao_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_patrocinador FOREIGN KEY (meta_gestao_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_template FOREIGN KEY (meta_gestao_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_painel FOREIGN KEY (meta_gestao_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_painel_odometro FOREIGN KEY (meta_gestao_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_painel_composicao FOREIGN KEY (meta_gestao_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_tr FOREIGN KEY (meta_gestao_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_acao_item FOREIGN KEY (meta_gestao_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_beneficio FOREIGN KEY (meta_gestao_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_painel_slideshow FOREIGN KEY (meta_gestao_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_projeto_viabilidade FOREIGN KEY (meta_gestao_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_projeto_abertura FOREIGN KEY (meta_gestao_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_gestao_plano_gestao FOREIGN KEY (meta_gestao_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS patrocinador_cia;

CREATE TABLE patrocinador_cia (
  patrocinador_cia_patrocinador INTEGER(100) UNSIGNED NOT NULL,
  patrocinador_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (patrocinador_cia_patrocinador, patrocinador_cia_cia),
  KEY patrocinador_cia_patrocinador (patrocinador_cia_patrocinador),
  KEY patrocinador_cia_cia (patrocinador_cia_cia),
  CONSTRAINT patrocinador_cia_cia FOREIGN KEY (patrocinador_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT patrocinador_cia_patrocinador FOREIGN KEY (patrocinador_cia_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS canvas_cia;

CREATE TABLE canvas_cia (
  canvas_cia_canvas INTEGER(100) UNSIGNED NOT NULL,
  canvas_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (canvas_cia_canvas, canvas_cia_cia),
  KEY canvas_cia_canvas (canvas_cia_canvas),
  KEY canvas_cia_cia (canvas_cia_cia),
  CONSTRAINT canvas_cia_cia FOREIGN KEY (canvas_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT canvas_cia_canvas FOREIGN KEY (canvas_cia_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS risco_cia;

CREATE TABLE risco_cia (
  risco_cia_risco INTEGER(100) UNSIGNED NOT NULL,
  risco_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (risco_cia_risco, risco_cia_cia),
  KEY risco_cia_risco (risco_cia_risco),
  KEY risco_cia_cia (risco_cia_cia),
  CONSTRAINT risco_cia_cia FOREIGN KEY (risco_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT risco_cia_risco FOREIGN KEY (risco_cia_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS risco_resposta_cia;

CREATE TABLE risco_resposta_cia (
  risco_resposta_cia_risco_resposta INTEGER(100) UNSIGNED NOT NULL,
  risco_resposta_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (risco_resposta_cia_risco_resposta, risco_resposta_cia_cia),
  KEY risco_resposta_cia_risco_resposta (risco_resposta_cia_risco_resposta),
  KEY risco_resposta_cia_cia (risco_resposta_cia_cia),
  CONSTRAINT risco_resposta_cia_cia FOREIGN KEY (risco_resposta_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT risco_resposta_cia_risco_resposta FOREIGN KEY (risco_resposta_cia_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS monitoramento_cia;

CREATE TABLE monitoramento_cia (
  monitoramento_cia_monitoramento INTEGER(100) UNSIGNED NOT NULL,
  monitoramento_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (monitoramento_cia_monitoramento, monitoramento_cia_cia),
  KEY monitoramento_cia_monitoramento (monitoramento_cia_monitoramento),
  KEY monitoramento_cia_cia (monitoramento_cia_cia),
  CONSTRAINT monitoramento_cia_cia FOREIGN KEY (monitoramento_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT monitoramento_cia_monitoramento FOREIGN KEY (monitoramento_cia_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS ata_cia;

CREATE TABLE ata_cia (
  ata_cia_ata INTEGER(100) UNSIGNED NOT NULL,
  ata_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (ata_cia_ata, ata_cia_cia),
  KEY ata_cia_ata (ata_cia_ata),
  KEY ata_cia_cia (ata_cia_cia),
  CONSTRAINT ata_cia_cia FOREIGN KEY (ata_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT ata_cia_ata FOREIGN KEY (ata_cia_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS swot_cia;

CREATE TABLE swot_cia (
  swot_cia_swot INTEGER(100) UNSIGNED NOT NULL,
  swot_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (swot_cia_swot, swot_cia_cia),
  KEY swot_cia_swot (swot_cia_swot),
  KEY swot_cia_cia (swot_cia_cia),
  CONSTRAINT swot_cia_cia FOREIGN KEY (swot_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT swot_cia_swot FOREIGN KEY (swot_cia_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS operativo_cia;

CREATE TABLE operativo_cia (
  operativo_cia_operativo INTEGER(100) UNSIGNED NOT NULL,
  operativo_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (operativo_cia_operativo, operativo_cia_cia),
  KEY operativo_cia_operativo (operativo_cia_operativo),
  KEY operativo_cia_cia (operativo_cia_cia),
  CONSTRAINT operativo_cia_cia FOREIGN KEY (operativo_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT operativo_cia_operativo FOREIGN KEY (operativo_cia_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS problema_cia;

CREATE TABLE problema_cia (
  problema_cia_problema INTEGER(100) UNSIGNED NOT NULL,
  problema_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (problema_cia_problema, problema_cia_cia),
  KEY problema_cia_problema (problema_cia_problema),
  KEY problema_cia_cia (problema_cia_cia),
  CONSTRAINT problema_cia_cia FOREIGN KEY (problema_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT problema_cia_problema FOREIGN KEY (problema_cia_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS programa_cia;

CREATE TABLE programa_cia (
  programa_cia_programa INTEGER(100) UNSIGNED NOT NULL,
  programa_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (programa_cia_programa, programa_cia_cia),
  KEY programa_cia_programa (programa_cia_programa),
  KEY programa_cia_cia (programa_cia_cia),
  CONSTRAINT programa_cia_cia FOREIGN KEY (programa_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT programa_cia_programa FOREIGN KEY (programa_cia_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS tgn_cia;

CREATE TABLE tgn_cia (
  tgn_cia_tgn INTEGER(100) UNSIGNED NOT NULL,
  tgn_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (tgn_cia_tgn, tgn_cia_cia),
  KEY tgn_cia_tgn (tgn_cia_tgn),
  KEY tgn_cia_cia (tgn_cia_cia),
  CONSTRAINT tgn_cia_cia FOREIGN KEY (tgn_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tgn_cia_tgn FOREIGN KEY (tgn_cia_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS agrupamento_cia;

CREATE TABLE agrupamento_cia (
  agrupamento_cia_agrupamento INTEGER(100) UNSIGNED NOT NULL,
  agrupamento_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (agrupamento_cia_agrupamento, agrupamento_cia_cia),
  KEY agrupamento_cia_agrupamento (agrupamento_cia_agrupamento),
  KEY agrupamento_cia_cia (agrupamento_cia_cia),
  CONSTRAINT agrupamento_cia_cia FOREIGN KEY (agrupamento_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT agrupamento_cia_agrupamento FOREIGN KEY (agrupamento_cia_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS template_cia;

CREATE TABLE template_cia (
  template_cia_template INTEGER(100) UNSIGNED NOT NULL,
  template_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (template_cia_template, template_cia_cia),
  KEY template_cia_template (template_cia_template),
  KEY template_cia_cia (template_cia_cia),
  CONSTRAINT template_cia_cia FOREIGN KEY (template_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT template_cia_template FOREIGN KEY (template_cia_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS painel_cia;

CREATE TABLE painel_cia (
  painel_cia_painel INTEGER(100) UNSIGNED NOT NULL,
  painel_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (painel_cia_painel, painel_cia_cia),
  KEY painel_cia_painel (painel_cia_painel),
  KEY painel_cia_cia (painel_cia_cia),
  CONSTRAINT painel_cia_cia FOREIGN KEY (painel_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT painel_cia_painel FOREIGN KEY (painel_cia_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS painel_odometro_cia;

CREATE TABLE painel_odometro_cia (
  painel_odometro_cia_painel_odometro INTEGER(100) UNSIGNED NOT NULL,
  painel_odometro_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (painel_odometro_cia_painel_odometro, painel_odometro_cia_cia),
  KEY painel_odometro_cia_painel_odometro (painel_odometro_cia_painel_odometro),
  KEY painel_odometro_cia_cia (painel_odometro_cia_cia),
  CONSTRAINT painel_odometro_cia_cia FOREIGN KEY (painel_odometro_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT painel_odometro_cia_painel_odometro FOREIGN KEY (painel_odometro_cia_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS painel_composicao_cia;

CREATE TABLE painel_composicao_cia (
  painel_composicao_cia_painel_composicao INTEGER(100) UNSIGNED NOT NULL,
  painel_composicao_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (painel_composicao_cia_painel_composicao, painel_composicao_cia_cia),
  KEY painel_composicao_cia_painel_composicao (painel_composicao_cia_painel_composicao),
  KEY painel_composicao_cia_cia (painel_composicao_cia_cia),
  CONSTRAINT painel_composicao_cia_cia FOREIGN KEY (painel_composicao_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT painel_composicao_cia_painel_composicao FOREIGN KEY (painel_composicao_cia_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS painel_slideshow_cia;

CREATE TABLE painel_slideshow_cia (
  painel_slideshow_cia_painel_slideshow INTEGER(100) UNSIGNED NOT NULL,
  painel_slideshow_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (painel_slideshow_cia_painel_slideshow, painel_slideshow_cia_cia),
  KEY painel_slideshow_cia_painel_slideshow (painel_slideshow_cia_painel_slideshow),
  KEY painel_slideshow_cia_cia (painel_slideshow_cia_cia),
  CONSTRAINT painel_slideshow_cia_cia FOREIGN KEY (painel_slideshow_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT painel_slideshow_cia_painel_slideshow FOREIGN KEY (painel_slideshow_cia_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS tr_cia;

CREATE TABLE tr_cia (
  tr_cia_tr INTEGER(100) UNSIGNED NOT NULL,
  tr_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (tr_cia_tr, tr_cia_cia),
  KEY tr_cia_tr (tr_cia_tr),
  KEY tr_cia_cia (tr_cia_cia),
  CONSTRAINT tr_cia_cia FOREIGN KEY (tr_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tr_cia_tr FOREIGN KEY (tr_cia_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

ALTER TABLE preferencia ADD KEY favorito (favorito);
ALTER TABLE preferencia ADD CONSTRAINT favorito FOREIGN KEY (favorito) REFERENCES menu_item (menu_item_id) ON DELETE SET NULL ON UPDATE CASCADE;


DROP TABLE IF EXISTS mswot_dept;

CREATE TABLE mswot_dept (
  mswot_dept_mswot INTEGER(100) UNSIGNED NOT NULL,
  mswot_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (mswot_dept_mswot, mswot_dept_dept),
  KEY mswot_dept_mswot (mswot_dept_mswot),
  KEY mswot_dept_dept (mswot_dept_dept),
  CONSTRAINT mswot_dept_dept FOREIGN KEY (mswot_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT mswot_dept_mswot FOREIGN KEY (mswot_dept_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS mswot_usuario;

CREATE TABLE mswot_usuario (
  mswot_usuario_mswot INTEGER(100) UNSIGNED NOT NULL,
  mswot_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (mswot_usuario_mswot, mswot_usuario_usuario),
  KEY mswot_usuario_mswot (mswot_usuario_mswot),
  KEY mswot_usuario_usuario (mswot_usuario_usuario),
  CONSTRAINT mswot_usuario_usuario FOREIGN KEY (mswot_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT mswot_usuario_mswot FOREIGN KEY (mswot_usuario_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS mswot_swot;

CREATE TABLE mswot_swot (
	mswot_swot_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  mswot_swot_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
  mswot_swot_swot INTEGER(100) UNSIGNED NOT NULL,
  mswot_swot_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_swot_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (mswot_swot_id),
  KEY mswot_swot_mswot (mswot_swot_mswot),
  KEY mswot_swot_swot (mswot_swot_swot),
  CONSTRAINT mswot_swot_mswot FOREIGN KEY (mswot_swot_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT mswot_swot_swot FOREIGN KEY (mswot_swot_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS mswot_cia;

CREATE TABLE mswot_cia (
  mswot_cia_mswot INTEGER(100) UNSIGNED NOT NULL,
  mswot_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (mswot_cia_mswot, mswot_cia_cia),
  KEY mswot_cia_mswot (mswot_cia_mswot),
  KEY mswot_cia_cia (mswot_cia_cia),
  CONSTRAINT mswot_cia_cia FOREIGN KEY (mswot_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT mswot_cia_mswot FOREIGN KEY (mswot_cia_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS mswot_gestao;

CREATE TABLE mswot_gestao (
	mswot_gestao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	mswot_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY mswot_gestao_id (mswot_gestao_id),
	KEY mswot_gestao_mswot (mswot_gestao_mswot),
	KEY mswot_gestao_semelhante (mswot_gestao_semelhante),
	KEY mswot_gestao_projeto (mswot_gestao_projeto),
	KEY mswot_gestao_tarefa (mswot_gestao_tarefa),
	KEY mswot_gestao_perspectiva (mswot_gestao_perspectiva),
	KEY mswot_gestao_tema (mswot_gestao_tema),
	KEY mswot_gestao_objetivo (mswot_gestao_objetivo),
	KEY mswot_gestao_estrategia (mswot_gestao_estrategia),
	KEY mswot_gestao_meta (mswot_gestao_meta),
	KEY mswot_gestao_fator (mswot_gestao_fator),
	KEY mswot_gestao_pratica (mswot_gestao_pratica),
	KEY mswot_gestao_indicador (mswot_gestao_indicador),
	KEY mswot_gestao_acao (mswot_gestao_acao),
	KEY mswot_gestao_canvas (mswot_gestao_canvas),
	KEY mswot_gestao_risco (mswot_gestao_risco),
	KEY mswot_gestao_risco_resposta (mswot_gestao_risco_resposta),
	KEY mswot_gestao_calendario (mswot_gestao_calendario),
	KEY mswot_gestao_monitoramento (mswot_gestao_monitoramento),
	KEY mswot_gestao_ata (mswot_gestao_ata),
	KEY mswot_gestao_swot (mswot_gestao_swot),
	KEY mswot_gestao_operativo(mswot_gestao_operativo),
	KEY mswot_gestao_instrumento (mswot_gestao_instrumento),
	KEY mswot_gestao_recurso (mswot_gestao_recurso),
	KEY mswot_gestao_problema (mswot_gestao_problema),
	KEY mswot_gestao_demanda (mswot_gestao_demanda),
	KEY mswot_gestao_programa (mswot_gestao_programa),
	KEY mswot_gestao_licao (mswot_gestao_licao),
	KEY mswot_gestao_evento (mswot_gestao_evento),
	KEY mswot_gestao_link (mswot_gestao_link),
	KEY mswot_gestao_avaliacao (mswot_gestao_avaliacao),
	KEY mswot_gestao_tgn (mswot_gestao_tgn),
	KEY mswot_gestao_brainstorm (mswot_gestao_brainstorm),
	KEY mswot_gestao_gut (mswot_gestao_gut),
	KEY mswot_gestao_causa_efeito (mswot_gestao_causa_efeito),
	KEY mswot_gestao_arquivo (mswot_gestao_arquivo),
	KEY mswot_gestao_forum (mswot_gestao_forum),
	KEY mswot_gestao_checklist (mswot_gestao_checklist),
	KEY mswot_gestao_agenda (mswot_gestao_agenda),
	KEY mswot_gestao_agrupamento (mswot_gestao_agrupamento),
	KEY mswot_gestao_patrocinador (mswot_gestao_patrocinador),
	KEY mswot_gestao_template (mswot_gestao_template),
	KEY mswot_gestao_painel (mswot_gestao_painel),
	KEY mswot_gestao_painel_odometro (mswot_gestao_painel_odometro),
	KEY mswot_gestao_painel_composicao (mswot_gestao_painel_composicao),
	KEY mswot_gestao_tr (mswot_gestao_tr),
	KEY mswot_gestao_me (mswot_gestao_me),
	KEY mswot_gestao_acao_item (mswot_gestao_acao_item),
	KEY mswot_gestao_beneficio (mswot_gestao_beneficio),
	KEY mswot_gestao_painel_slideshow (mswot_gestao_painel_slideshow),
	KEY mswot_gestao_projeto_viabilidade (mswot_gestao_projeto_viabilidade),
	KEY mswot_gestao_projeto_abertura (mswot_gestao_projeto_abertura),
	KEY mswot_gestao_plano_gestao (mswot_gestao_plano_gestao),
	CONSTRAINT mswot_gestao_mswot FOREIGN KEY (mswot_gestao_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_semelhante FOREIGN KEY (mswot_gestao_semelhante) REFERENCES mswot (mswot_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_projeto FOREIGN KEY (mswot_gestao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_tarefa FOREIGN KEY (mswot_gestao_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_perspectiva FOREIGN KEY (mswot_gestao_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_tema FOREIGN KEY (mswot_gestao_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_objetivo FOREIGN KEY (mswot_gestao_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_fator FOREIGN KEY (mswot_gestao_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_estrategia FOREIGN KEY (mswot_gestao_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_meta FOREIGN KEY (mswot_gestao_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_pratica FOREIGN KEY (mswot_gestao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_indicador FOREIGN KEY (mswot_gestao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_acao FOREIGN KEY (mswot_gestao_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_canvas FOREIGN KEY (mswot_gestao_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_risco FOREIGN KEY (mswot_gestao_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_risco_resposta FOREIGN KEY (mswot_gestao_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_calendario FOREIGN KEY (mswot_gestao_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_monitoramento FOREIGN KEY (mswot_gestao_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_ata FOREIGN KEY (mswot_gestao_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_swot FOREIGN KEY (mswot_gestao_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_operativo FOREIGN KEY (mswot_gestao_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_instrumento FOREIGN KEY (mswot_gestao_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_recurso FOREIGN KEY (mswot_gestao_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_problema FOREIGN KEY (mswot_gestao_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_demanda FOREIGN KEY (mswot_gestao_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_programa FOREIGN KEY (mswot_gestao_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_licao FOREIGN KEY (mswot_gestao_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_evento FOREIGN KEY (mswot_gestao_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_link FOREIGN KEY (mswot_gestao_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_avaliacao FOREIGN KEY (mswot_gestao_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_tgn FOREIGN KEY (mswot_gestao_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_brainstorm FOREIGN KEY (mswot_gestao_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_gut FOREIGN KEY (mswot_gestao_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_causa_efeito FOREIGN KEY (mswot_gestao_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_arquivo FOREIGN KEY (mswot_gestao_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_forum FOREIGN KEY (mswot_gestao_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_checklist FOREIGN KEY (mswot_gestao_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_agenda FOREIGN KEY (mswot_gestao_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_agrupamento FOREIGN KEY (mswot_gestao_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_patrocinador FOREIGN KEY (mswot_gestao_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_template FOREIGN KEY (mswot_gestao_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_painel FOREIGN KEY (mswot_gestao_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_painel_odometro FOREIGN KEY (mswot_gestao_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_painel_composicao FOREIGN KEY (mswot_gestao_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_tr FOREIGN KEY (mswot_gestao_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_me FOREIGN KEY (mswot_gestao_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_acao_item FOREIGN KEY (mswot_gestao_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_beneficio FOREIGN KEY (mswot_gestao_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_painel_slideshow FOREIGN KEY (mswot_gestao_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_projeto_viabilidade FOREIGN KEY (mswot_gestao_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_projeto_abertura FOREIGN KEY (mswot_gestao_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT mswot_gestao_plano_gestao FOREIGN KEY (mswot_gestao_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_arquivo_gestao;

CREATE TABLE baseline_arquivo_gestao (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	arquivo_gestao_id INTEGER(100) UNSIGNED NOT NULL,
	arquivo_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	arquivo_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (baseline_id, arquivo_gestao_id),
	KEY baseline_id (baseline_id),
	CONSTRAINT baseline_arquivo_gestao FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_forum_gestao;

CREATE TABLE baseline_forum_gestao (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	forum_gestao_id INTEGER(100) UNSIGNED NOT NULL,
	forum_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	forum_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (baseline_id, forum_gestao_id),
	KEY baseline_id (baseline_id),
	CONSTRAINT baseline_forum_gestao FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_link_gestao;

CREATE TABLE baseline_link_gestao (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	link_gestao_id INTEGER(100) UNSIGNED NOT NULL,
	link_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	link_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (baseline_id, link_gestao_id),
	KEY baseline_id (baseline_id),
	CONSTRAINT baseline_link_gestao FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_patrocinador_gestao;

CREATE TABLE baseline_patrocinador_gestao (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	patrocinador_gestao_id INTEGER(100) UNSIGNED NOT NULL,
	patrocinador_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	patrocinador_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (baseline_id, patrocinador_gestao_id),
	KEY baseline_id (baseline_id),
	CONSTRAINT baseline_patrocinador_gestao FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_operativo_gestao;

CREATE TABLE baseline_operativo_gestao (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	operativo_gestao_id INTEGER(100) UNSIGNED NOT NULL,
	operativo_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	operativo_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (baseline_id, operativo_gestao_id),
	KEY baseline_id (baseline_id),
	CONSTRAINT baseline_operativo_gestao FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_swot_gestao;

CREATE TABLE baseline_swot_gestao (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	swot_gestao_id INTEGER(100) UNSIGNED NOT NULL,
	swot_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	swot_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (baseline_id, swot_gestao_id),
	KEY baseline_id (baseline_id),
	CONSTRAINT baseline_swot_gestao FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_checklist_gestao;

CREATE TABLE baseline_checklist_gestao (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	checklist_gestao_id INTEGER(100) UNSIGNED NOT NULL,
	checklist_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	checklist_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (baseline_id, checklist_gestao_id),
	KEY baseline_id (baseline_id),
	CONSTRAINT baseline_checklist_gestao FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_brainstorm_gestao;

CREATE TABLE baseline_brainstorm_gestao (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	brainstorm_gestao_id INTEGER(100) UNSIGNED NOT NULL,
	brainstorm_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	brainstorm_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (baseline_id, brainstorm_gestao_id),
	KEY baseline_id (baseline_id),
	CONSTRAINT baseline_brainstorm_gestao FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_causa_efeito_gestao;

CREATE TABLE baseline_causa_efeito_gestao (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	causa_efeito_gestao_id INTEGER(100) UNSIGNED NOT NULL,
	causa_efeito_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	causa_efeito_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (baseline_id, causa_efeito_gestao_id),
	KEY baseline_id (baseline_id),
	CONSTRAINT baseline_causa_efeito_gestao FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_gut_gestao;

CREATE TABLE baseline_gut_gestao (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	gut_gestao_id INTEGER(100) UNSIGNED NOT NULL,
	gut_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	gut_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (baseline_id, gut_gestao_id),
	KEY baseline_id (baseline_id),
	CONSTRAINT baseline_gut_gestao FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_modelo_gestao;

CREATE TABLE baseline_modelo_gestao (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	modelo_gestao_id INTEGER(100) UNSIGNED NOT NULL,
	modelo_gestao_modelo INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (baseline_id, modelo_gestao_id),
	KEY baseline_id (baseline_id),
	CONSTRAINT baseline_modelo_gestao FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_painel_gestao;

CREATE TABLE baseline_painel_gestao (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	painel_gestao_id INTEGER(100) UNSIGNED NOT NULL,
	painel_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (baseline_id, painel_gestao_id),
	KEY baseline_id (baseline_id),
	CONSTRAINT baseline_painel_gestao FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_painel_odometro_gestao;

CREATE TABLE baseline_painel_odometro_gestao (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	painel_odometro_gestao_id INTEGER(100) UNSIGNED NOT NULL,
	painel_odometro_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (baseline_id, painel_odometro_gestao_id),
	KEY baseline_id (baseline_id),
	CONSTRAINT baseline_painel_odometro_gestao FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_painel_composicao_gestao;

CREATE TABLE baseline_painel_composicao_gestao (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	painel_composicao_gestao_id INTEGER(100) UNSIGNED NOT NULL,
	painel_composicao_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (baseline_id, painel_composicao_gestao_id),
	KEY baseline_id (baseline_id),
	CONSTRAINT baseline_painel_composicao_gestao FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_meta_gestao;

CREATE TABLE baseline_meta_gestao (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	meta_gestao_id INTEGER(100) UNSIGNED NOT NULL,
	meta_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (baseline_id, meta_gestao_id),
	KEY baseline_id (baseline_id),
	CONSTRAINT baseline_meta_gestao FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_mswot_gestao;

CREATE TABLE baseline_mswot_gestao (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	mswot_gestao_id INTEGER(100) UNSIGNED NOT NULL,
	mswot_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (baseline_id, mswot_gestao_id),
	KEY baseline_id (baseline_id),
	CONSTRAINT baseline_mswot_gestao FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_tr_gestao;

CREATE TABLE baseline_tr_gestao (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	tr_gestao_id INTEGER(100) UNSIGNED NOT NULL,
	tr_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	
	tr_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (baseline_id, tr_gestao_id),
	KEY baseline_id (baseline_id),
	CONSTRAINT baseline_tr_gestao FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_agrupamento_gestao;

CREATE TABLE baseline_agrupamento_gestao (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	agrupamento_gestao_id INTEGER(100) UNSIGNED NOT NULL,
	agrupamento_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (baseline_id, agrupamento_gestao_id),
	KEY baseline_id (baseline_id),
	CONSTRAINT baseline_agrupamento_gestao FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_problema_gestao;

CREATE TABLE baseline_problema_gestao (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	problema_gestao_id INTEGER(100) UNSIGNED NOT NULL,
	problema_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (baseline_id, problema_gestao_id),
	KEY baseline_id (baseline_id),
	CONSTRAINT baseline_problema_gestao FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_msg_gestao;

CREATE TABLE baseline_msg_gestao (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	msg_gestao_id INTEGER(100) UNSIGNED NOT NULL,
	msg_gestao_msg INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (baseline_id, msg_gestao_id),
	KEY baseline_id (baseline_id),
	CONSTRAINT baseline_msg_gestao FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_ata_gestao;

CREATE TABLE baseline_ata_gestao (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	ata_gestao_id INTEGER(100) UNSIGNED NOT NULL,
	ata_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (baseline_id, ata_gestao_id),
	KEY baseline_id (baseline_id),
	CONSTRAINT baseline_ata_gestao FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_pratica_indicador_gestao;

CREATE TABLE baseline_pratica_indicador_gestao (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	pratica_indicador_gestao_id INTEGER(100) UNSIGNED NOT NULL,
	pratica_indicador_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (baseline_id, pratica_indicador_gestao_id),
	KEY baseline_id (baseline_id),
	CONSTRAINT baseline_pratica_indicador_gestao FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_demanda_gestao;

CREATE TABLE baseline_demanda_gestao (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	demanda_gestao_id INTEGER(100) UNSIGNED NOT NULL,
	demanda_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (baseline_id, demanda_gestao_id),
	KEY baseline_id (baseline_id),
	CONSTRAINT baseline_demanda_gestao FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_instrumento_gestao;

CREATE TABLE baseline_instrumento_gestao (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	instrumento_gestao_id INTEGER(100) UNSIGNED NOT NULL,
	instrumento_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (baseline_id, instrumento_gestao_id),
	KEY baseline_id (baseline_id),
	CONSTRAINT baseline_instrumento_gestao FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_canvas_gestao;

CREATE TABLE baseline_canvas_gestao (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	canvas_gestao_id INTEGER(100) UNSIGNED NOT NULL,
	canvas_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	can