UPDATE versao SET versao_bd=52; 
UPDATE versao SET versao_codigo='7.7.3'; 

UPDATE config SET config_valor='' WHERE config_nome='modelo_projetos_status_id';

ALTER TABLE projetos ADD COLUMN projeto_municipios VARCHAR(255) DEFAULT NULL;
ALTER TABLE baseline_projetos ADD COLUMN projeto_municipios VARCHAR(255) DEFAULT NULL;

ALTER TABLE tarefas ADD COLUMN tarefa_municipios VARCHAR(255) DEFAULT NULL;
ALTER TABLE baseline_tarefas ADD COLUMN tarefa_municipios VARCHAR(255) DEFAULT NULL;


ALTER TABLE pratica_indicador ADD COLUMN pratica_indicador_superior INTEGER(100) UNSIGNED DEFAULT '0';

ALTER TABLE agendas MODIFY agenda_criacao datetime DEFAULT NULL;
ALTER TABLE agendas MODIFY agenda_modificacao datetime DEFAULT NULL;

ALTER TABLE versao MODIFY ultima_atualizacao_bd date DEFAULT NULL;
ALTER TABLE versao MODIFY ultima_atualizacao_codigo date DEFAULT NULL;

ALTER TABLE usuario_reg_acesso MODIFY entrou datetime DEFAULT NULL;
ALTER TABLE usuario_reg_acesso MODIFY saiu datetime DEFAULT NULL;
ALTER TABLE usuario_reg_acesso MODIFY ultima_atividade datetime DEFAULT NULL;

ALTER TABLE tarefas MODIFY tarefa_data_criada datetime DEFAULT NULL;
ALTER TABLE tarefas MODIFY tarefa_data_atualizada datetime DEFAULT NULL;
ALTER TABLE sessoes MODIFY sessao_criada datetime DEFAULT NULL;

ALTER TABLE projetos MODIFY projeto_criado datetime DEFAULT NULL;
ALTER TABLE projetos MODIFY projeto_atualizado datetime DEFAULT NULL;
ALTER TABLE projetos MODIFY projeto_data_fim_ajustada datetime DEFAULT NULL;

ALTER TABLE historico MODIFY historico_data datetime DEFAULT NULL;

ALTER TABLE foruns MODIFY forum_data_criacao datetime DEFAULT NULL;
ALTER TABLE foruns MODIFY forum_ultima_data datetime DEFAULT NULL;

ALTER TABLE forum_mensagens MODIFY mensagem_data datetime DEFAULT NULL;

ALTER TABLE chaves_publicas MODIFY chave_publica_data datetime DEFAULT NULL;

INSERT INTO sisvalores (sisvalor_chave_id, sisvalor_titulo, sisvalor_valor, sisvalor_valor_id) VALUES 
(1,	'StatusTarefa','Proposto','1'),
(1,	'StatusTarefa','Planejado','2'),
(1,	'StatusTarefa','Andamento','3'),
(1,	'StatusTarefa','Aguardando','4'),
(1,	'StatusTarefa','Completado','5'),
(1,	'StatusTarefa','paralisado - embargo judicial','6'),
(1,	'StatusTarefa','paralisado - embargo rgo controle','7'),
(1,	'StatusTarefa','paralisado - problema tcnico','8'),
(1,	'StatusTarefa','paralisado - recursos financeiros','9'),
(1,	'StatusTarefa','paralisado - razes climticas','10'),
(1,	'StatusTarefa','paralisado - acidente','11');

DROP TABLE IF EXISTS projeto_area;

CREATE TABLE projeto_area (
  projeto_area_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  projeto_area_projeto INTEGER(100) UNSIGNED NOT NULL DEFAULT '0',
  projeto_area_tarefa INTEGER(100) UNSIGNED NOT NULL DEFAULT '0',
  projeto_area_nome VARCHAR(255) DEFAULT NULL,
  projeto_area_obs TEXT,
  projeto_area_cor VARCHAR(6) DEFAULT 'ffffff',
  projeto_area_espessura INTEGER(10) UNSIGNED NOT NULL DEFAULT '2',
  projeto_area_opacidade FLOAT DEFAULT '0.5',
  projeto_area_poligono TINYINT(1) DEFAULT '1',
  PRIMARY KEY (projeto_area_id),
  KEY projeto_area_projeto (projeto_area_projeto),
  KEY projeto_area_tarefa (projeto_area_tarefa)
)ENGINE=InnoDB;

DROP TABLE IF EXISTS projeto_ponto;

CREATE TABLE projeto_ponto (
	projeto_ponto_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  projeto_area_id INTEGER(100) UNSIGNED NOT NULL DEFAULT '0',
  projeto_ponto_latitude  FLOAT(10,6) NOT NULL,
  projeto_ponto_longitude FLOAT(10,6) NOT NULL,
  PRIMARY KEY (projeto_ponto_id),
  KEY projeto_area_id (projeto_area_id)
)ENGINE=InnoDB;


DROP TABLE IF EXISTS projeto_municipios;

CREATE TABLE projeto_municipios (
  projeto_id INTEGER(100) UNSIGNED NOT NULL DEFAULT '0',
  municipio_id INTEGER(100) UNSIGNED NOT NULL DEFAULT '0',
  KEY projeto_id (projeto_id),
  KEY municipio_id (municipio_id)
)ENGINE=InnoDB;


DROP TABLE IF EXISTS baseline_projeto_municipios;

CREATE TABLE baseline_projeto_municipios (
  projeto_id INTEGER(100) UNSIGNED NOT NULL DEFAULT '0',
  municipio_id INTEGER(100) UNSIGNED NOT NULL DEFAULT '0',
  KEY projeto_id (projeto_id),
  KEY municipio_id (municipio_id)
)ENGINE=InnoDB;

DROP TABLE IF EXISTS tarefa_municipios;

CREATE TABLE tarefa_municipios (
  tarefa_id INTEGER(100) UNSIGNED NOT NULL DEFAULT '0',
  municipio_id INTEGER(100) UNSIGNED NOT NULL DEFAULT '0',
  KEY tarefa_id (tarefa_id),
  KEY municipio_id (municipio_id)
)ENGINE=InnoDB;


DROP TABLE IF EXISTS baseline_tarefa_municipios;

CREATE TABLE baseline_tarefa_municipios (
  tarefa_id INTEGER(100) UNSIGNED NOT NULL DEFAULT '0',
  municipio_id INTEGER(100) UNSIGNED NOT NULL DEFAULT '0',
  KEY tarefa_id (tarefa_id),
  KEY municipio_id (municipio_id)
)ENGINE=InnoDB;


DROP TABLE IF EXISTS estado;

CREATE TABLE estado (
  estado_sigla varchar(2) NOT NULL default '',
  estado_nome varchar(20) NOT NULL default '',
  KEY estado_sigla (estado_sigla)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO estado (estado_sigla,estado_nome) VALUES 
 ('AC','Acre'),
 ('AL','Alagoas'),
 ('AM','Amazonas'),
 ('AP','Amap'),
 ('BA','Bahia'),
 ('CE','Cear'),
 ('DF','Distrito Federal'),
 ('ES','Esprito Santo'),
 ('GO','Gois'),
 ('MA','Maranho'),
 ('MG','Minas Gerais'),
 ('MS','Mato Grosso do Sul'),
 ('MT','Mato Grosso'),
 ('PA','Par'),
 ('PB','Paraba'),
 ('PE','Pernambuco'),
 ('PI','Piau'),
 ('PR','Paran'),
 ('RJ','Rio de Janeiro'),
 ('RS','Rio Grande do Sul'),
 ('RN','Rio Grande do Norte'),
 ('RO','Rondnia'),
 ('RR','Roraima'),
 ('SC','Santa Catarina'),
 ('SE','Sergipe'),
 ('SP','So Paulo'),
 ('TO','Tocantins');
 
DROP TABLE IF EXISTS municipios;

CREATE TABLE municipios (
  municipio_id int(20) unsigned NOT NULL,
  municipio_nome varchar(50)NOT NULL default '',
  estado_sigla varchar(2) NOT NULL default '',
  UNIQUE KEY municipio_id (municipio_id),
  KEY estado_sigla (estado_sigla)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO municipios (municipio_id, municipio_nome, estado_sigla) VALUES 
  (1100015,'Alta Floresta D''Oeste','RO'),
  (1100023,'Ariquemes','RO'),
  (1100031,'Cabixi','RO'),
  (1100049,'Cacoal','RO'),
  (1100056,'Cerejeiras','RO'),
  (1100064,'Colorado do Oeste','RO'),
  (1100072,'Corumbiara','RO'),
  (1100080,'Costa Marques','RO'),
  (1100098,'Espigo D''Oeste','RO'),
  (1100106,'Guajar-Mirim','RO'),
  (1100114,'Jaru','RO'),
  (1100122,'Ji-Paran','RO'),
  (1100130,'Machadinho D''Oeste','RO'),
  (1100148,'Nova Brasilndia D''Oeste','RO'),
  (1100155,'Ouro Preto do Oeste','RO'),
  (1100189,'Pimenta Bueno','RO'),
  (1100205,'Porto Velho','RO'),
  (1100254,'Presidente Mdici','RO'),
  (1100262,'Rio Crespo','RO'),
  (1100288,'Rolim de Moura','RO'),
  (1100296,'Santa Luzia D''Oeste','RO'),
  (1100304,'Vilhena','RO'),
  (1100320,'So Miguel do Guapor','RO'),
  (1100338,'Nova Mamor','RO'),
  (1100346,'Alvorada D''Oeste','RO'),
  (1100379,'Alto Alegre dos Parecis','RO'),
  (1100403,'Alto Paraso','RO'),
  (1100452,'Buritis','RO'),
  (1100502,'Novo Horizonte do Oeste','RO'),
  (1100601,'Cacaulndia','RO'),
  (1100700,'Campo Novo de Rondnia','RO'),
  (1100809,'Candeias do Jamari','RO'),
  (1100908,'Castanheiras','RO'),
  (1100924,'Chupinguaia','RO'),
  (1100940,'Cujubim','RO'),
  (1101005,'Governador Jorge Teixeira','RO'),
  (1101104,'Itapu do Oeste','RO'),
  (1101203,'Ministro Andreazza','RO'),
  (1101302,'Mirante da Serra','RO'),
  (1101401,'Monte Negro','RO'),
  (1101435,'Nova Unio','RO'),
  (1101450,'Parecis','RO'),
  (1101468,'Pimenteiras do Oeste','RO'),
  (1101476,'Primavera de Rondnia','RO'),
  (1101484,'So Felipe D''Oeste','RO'),
  (1101492,'So Francisco do Guapor','RO'),
  (1101500,'Seringueiras','RO'),
  (1101559,'Teixeirpolis','RO'),
  (1101609,'Theobroma','RO'),
  (1101708,'Urup','RO'),
  (1101757,'Vale do Anari','RO'),
  (1101807,'Vale do Paraso','RO'),
  (1200013,'Acrelndia','AC'),
  (1200054,'Assis Brasil','AC'),
  (1200104,'Brasilia','AC'),
  (1200138,'Bujari','AC'),
  (1200179,'Capixaba','AC'),
  (1200203,'Cruzeiro do Sul','AC'),
  (1200252,'Epitaciolndia','AC'),
  (1200302,'Feij','AC'),
  (1200328,'Jordo','AC'),
  (1200336,'Mncio Lima','AC'),
  (1200344,'Manoel Urbano','AC'),
  (1200351,'Marechal Thaumaturgo','AC'),
  (1200385,'Plcido de Castro','AC'),
  (1200393,'Porto Walter','AC'),
  (1200401,'Rio Branco','AC'),
  (1200427,'Rodrigues Alves','AC'),
  (1200435,'Santa Rosa do Purus','AC'),
  (1200450,'Senador Guiomard','AC'),
  (1200500,'Sena Madureira','AC'),
  (1200609,'Tarauac','AC'),
  (1200708,'Xapuri','AC'),
  (1200807,'Porto Acre','AC'),
  (1300029,'Alvares','AM'),
  (1300060,'Amatur','AM'),
  (1300086,'Anam','AM'),
  (1300102,'Anori','AM'),
  (1300144,'Apu','AM'),
  (1300201,'Atalaia do Norte','AM'),
  (1300300,'Autazes','AM'),
  (1300409,'Barcelos','AM'),
  (1300508,'Barreirinha','AM'),
  (1300607,'Benjamin Constant','AM'),
  (1300631,'Beruri','AM'),
  (1300680,'Boa Vista do Ramos','AM'),
  (1300706,'Boca do Acre','AM'),
  (1300805,'Borba','AM'),
  (1300839,'Caapiranga','AM'),
  (1300904,'Canutama','AM'),
  (1301001,'Carauari','AM'),
  (1301100,'Careiro','AM'),
  (1301159,'Careiro da Vrzea','AM'),
  (1301209,'Coari','AM'),
  (1301308,'Codajs','AM'),
  (1301407,'Eirunep','AM'),
  (1301506,'Envira','AM'),
  (1301605,'Fonte Boa','AM'),
  (1301654,'Guajar','AM'),
  (1301704,'Humait','AM'),
  (1301803,'Ipixuna','AM'),
  (1301852,'Iranduba','AM'),
  (1301902,'Itacoatiara','AM'),
  (1301951,'Itamarati','AM'),
  (1302009,'Itapiranga','AM'),
  (1302108,'Japur','AM'),
  (1302207,'Juru','AM'),
  (1302306,'Juta','AM'),
  (1302405,'Lbrea','AM'),
  (1302504,'Manacapuru','AM'),
  (1302553,'Manaquiri','AM'),
  (1302603,'Manaus','AM'),
  (1302702,'Manicor','AM'),
  (1302801,'Mara','AM'),
  (1302900,'Maus','AM'),
  (1303007,'Nhamund','AM'),
  (1303106,'Nova Olinda do Norte','AM'),
  (1303205,'Novo Airo','AM'),
  (1303304,'Novo Aripuan','AM'),
  (1303403,'Parintins','AM'),
  (1303502,'Pauini','AM'),
  (1303536,'Presidente Figueiredo','AM'),
  (1303569,'Rio Preto da Eva','AM'),
  (1303601,'Santa Isabel do Rio Negro','AM'),
  (1303700,'Santo Antnio do I','AM'),
  (1303809,'So Gabriel da Cachoeira','AM'),
  (1303908,'So Paulo de Olivena','AM'),
  (1303957,'So Sebastio do Uatum','AM'),
  (1304005,'Silves','AM'),
  (1304062,'Tabatinga','AM'),
  (1304104,'Tapau','AM'),
  (1304203,'Tef','AM'),
  (1304237,'Tonantins','AM'),
  (1304260,'Uarini','AM'),
  (1304302,'Urucar','AM'),
  (1304401,'Urucurituba','AM'),
  (1400027,'Amajari','RR'),
  (1400050,'Alto Alegre','RR'),
  (1400100,'Boa Vista','RR'),
  (1400159,'Bonfim','RR'),
  (1400175,'Cant','RR'),
  (1400209,'Caracara','RR'),
  (1400233,'Caroebe','RR'),
  (1400282,'Iracema','RR'),
  (1400308,'Mucaja','RR'),
  (1400407,'Normandia','RR'),
  (1400456,'Pacaraima','RR'),
  (1400472,'Rorainpolis','RR'),
  (1400506,'So Joo da Baliza','RR'),
  (1400605,'So Luiz','RR'),
  (1400704,'Uiramut','RR'),
  (1500107,'Abaetetuba','PA'),
  (1500131,'Abel Figueiredo','PA'),
  (1500206,'Acar','PA'),
  (1500305,'Afu','PA'),
  (1500347,'gua Azul do Norte','PA'),
  (1500404,'Alenquer','PA'),
  (1500503,'Almeirim','PA'),
  (1500602,'Altamira','PA'),
  (1500701,'Anajs','PA'),
  (1500800,'Ananindeua','PA'),
  (1500859,'Anapu','PA'),
  (1500909,'Augusto Corra','PA'),
  (1500958,'Aurora do Par','PA'),
  (1501006,'Aveiro','PA'),
  (1501105,'Bagre','PA'),
  (1501204,'Baio','PA'),
  (1501253,'Bannach','PA'),
  (1501303,'Barcarena','PA'),
  (1501402,'Belm','PA'),
  (1501451,'Belterra','PA'),
  (1501501,'Benevides','PA'),
  (1501576,'Bom Jesus do Tocantins','PA'),
  (1501600,'Bonito','PA'),
  (1501709,'Bragana','PA'),
  (1501725,'Brasil Novo','PA'),
  (1501758,'Brejo Grande do Araguaia','PA'),
  (1501782,'Breu Branco','PA'),
  (1501808,'Breves','PA'),
  (1501907,'Bujaru','PA'),
  (1501956,'Cachoeira do Piri','PA'),
  (1502004,'Cachoeira do Arari','PA'),
  (1502103,'Camet','PA'),
  (1502152,'Cana dos Carajs','PA'),
  (1502202,'Capanema','PA'),
  (1502301,'Capito Poo','PA'),
  (1502400,'Castanhal','PA'),
  (1502509,'Chaves','PA'),
  (1502608,'Colares','PA'),
  (1502707,'Conceio do Araguaia','PA'),
  (1502756,'Concrdia do Par','PA'),
  (1502764,'Cumaru do Norte','PA'),
  (1502772,'Curionpolis','PA'),
  (1502806,'Curralinho','PA'),
  (1502855,'Curu','PA'),
  (1502905,'Curu','PA'),
  (1502939,'Dom Eliseu','PA'),
  (1502954,'Eldorado dos Carajs','PA'),
  (1503002,'Faro','PA'),
  (1503044,'Floresta do Araguaia','PA'),
  (1503077,'Garrafo do Norte','PA'),
  (1503093,'Goiansia do Par','PA'),
  (1503101,'Gurup','PA'),
  (1503200,'Igarap-Au','PA'),
  (1503309,'Igarap-Miri','PA'),
  (1503408,'Inhangapi','PA'),
  (1503457,'Ipixuna do Par','PA'),
  (1503507,'Irituia','PA'),
  (1503606,'Itaituba','PA'),
  (1503705,'Itupiranga','PA'),
  (1503754,'Jacareacanga','PA'),
  (1503804,'Jacund','PA'),
  (1503903,'Juruti','PA'),
  (1504000,'Limoeiro do Ajuru','PA'),
  (1504059,'Me do Rio','PA'),
  (1504109,'Magalhes Barata','PA'),
  (1504208,'Marab','PA'),
  (1504307,'Maracan','PA'),
  (1504406,'Marapanim','PA'),
  (1504422,'Marituba','PA'),
  (1504455,'Medicilndia','PA'),
  (1504505,'Melgao','PA'),
  (1504604,'Mocajuba','PA'),
  (1504703,'Moju','PA'),
  (1504802,'Monte Alegre','PA'),
  (1504901,'Muan','PA'),
  (1504950,'Nova Esperana do Piri','PA'),
  (1504976,'Nova Ipixuna','PA'),
  (1505007,'Nova Timboteua','PA'),
  (1505031,'Novo Progresso','PA'),
  (1505064,'Novo Repartimento','PA'),
  (1505106,'bidos','PA'),
  (1505205,'Oeiras do Par','PA'),
  (1505304,'Oriximin','PA'),
  (1505403,'Ourm','PA'),
  (1505437,'Ourilndia do Norte','PA'),
  (1505486,'Pacaj','PA'),
  (1505494,'Palestina do Par','PA'),
  (1505502,'Paragominas','PA'),
  (1505536,'Parauapebas','PA'),
  (1505551,'Pau D''Arco','PA'),
  (1505601,'Peixe-Boi','PA'),
  (1505635,'Piarra','PA'),
  (1505650,'Placas','PA'),
  (1505700,'Ponta de Pedras','PA'),
  (1505809,'Portel','PA'),
  (1505908,'Porto de Moz','PA'),
  (1506005,'Prainha','PA'),
  (1506104,'Primavera','PA'),
  (1506112,'Quatipuru','PA'),
  (1506138,'Redeno','PA'),
  (1506161,'Rio Maria','PA'),
  (1506187,'Rondon do Par','PA'),
  (1506195,'Rurpolis','PA'),
  (1506203,'Salinpolis','PA'),
  (1506302,'Salvaterra','PA'),
  (1506351,'Santa Brbara do Par','PA'),
  (1506401,'Santa Cruz do Arari','PA'),
  (1506500,'Santa Isabel do Par','PA'),
  (1506559,'Santa Luzia do Par','PA'),
  (1506583,'Santa Maria das Barreiras','PA'),
  (1506609,'Santa Maria do Par','PA'),
  (1506708,'Santana do Araguaia','PA'),
  (1506807,'Santarm','PA'),
  (1506906,'Santarm Novo','PA'),
  (1507003,'Santo Antnio do Tau','PA'),
  (1507102,'So Caetano de Odivelas','PA'),
  (1507151,'So Domingos do Araguaia','PA'),
  (1507201,'So Domingos do Capim','PA'),
  (1507300,'So Flix do Xingu','PA'),
  (1507409,'So Francisco do Par','PA'),
  (1507458,'So Geraldo do Araguaia','PA'),
  (1507466,'So Joo da Ponta','PA'),
  (1507474,'So Joo de Pirabas','PA'),
  (1507508,'So Joo do Araguaia','PA'),
  (1507607,'So Miguel do Guam','PA'),
  (1507706,'So Sebastio da Boa Vista','PA'),
  (1507755,'Sapucaia','PA'),
  (1507805,'Senador Jos Porfrio','PA'),
  (1507904,'Soure','PA'),
  (1507953,'Tailndia','PA'),
  (1507961,'Terra Alta','PA'),
  (1507979,'Terra Santa','PA'),
  (1508001,'Tom-Au','PA'),
  (1508035,'Tracuateua','PA'),
  (1508050,'Trairo','PA'),
  (1508084,'Tucum','PA'),
  (1508100,'Tucuru','PA'),
  (1508126,'Ulianpolis','PA'),
  (1508159,'Uruar','PA'),
  (1508209,'Vigia','PA'),
  (1508308,'Viseu','PA'),
  (1508357,'Vitria do Xingu','PA'),
  (1508407,'Xinguara','PA'),
  (1600055,'Serra do Navio','AP'),
  (1600105,'Amap','AP'),
  (1600154,'Pedra Branca do Amapari','AP'),
  (1600204,'Caloene','AP'),
  (1600212,'Cutias','AP'),
  (1600238,'Ferreira Gomes','AP'),
  (1600253,'Itaubal','AP'),
  (1600279,'Laranjal do Jari','AP'),
  (1600303,'Macap','AP'),
  (1600402,'Mazago','AP'),
  (1600501,'Oiapoque','AP'),
  (1600535,'Porto Grande','AP'),
  (1600550,'Pracuba','AP'),
  (1600600,'Santana','AP'),
  (1600709,'Tartarugalzinho','AP'),
  (1600808,'Vitria do Jari','AP'),
  (1700251,'Abreulndia','TO'),
  (1700301,'Aguiarnpolis','TO'),
  (1700350,'Aliana do Tocantins','TO'),
  (1700400,'Almas','TO'),
  (1700707,'Alvorada','TO'),
  (1701002,'Anans','TO'),
  (1701051,'Angico','TO'),
  (1701101,'Aparecida do Rio Negro','TO'),
  (1701309,'Aragominas','TO'),
  (1701903,'Araguacema','TO'),
  (1702000,'Araguau','TO'),
  (1702109,'Araguana','TO'),
  (1702158,'Araguan','TO'),
  (1702208,'Araguatins','TO'),
  (1702307,'Arapoema','TO'),
  (1702406,'Arraias','TO'),
  (1702554,'Augustinpolis','TO'),
  (1702703,'Aurora do Tocantins','TO'),
  (1702901,'Axix do Tocantins','TO'),
  (1703008,'Babaulndia','TO'),
  (1703057,'Bandeirantes do Tocantins','TO'),
  (1703073,'Barra do Ouro','TO'),
  (1703107,'Barrolndia','TO'),
  (1703206,'Bernardo Sayo','TO'),
  (1703305,'Bom Jesus do Tocantins','TO'),
  (1703602,'Brasilndia do Tocantins','TO'),
  (1703701,'Brejinho de Nazar','TO'),
  (1703800,'Buriti do Tocantins','TO'),
  (1703826,'Cachoeirinha','TO'),
  (1703842,'Campos Lindos','TO'),
  (1703867,'Cariri do Tocantins','TO'),
  (1703883,'Carmolndia','TO'),
  (1703891,'Carrasco Bonito','TO'),
  (1703909,'Caseara','TO'),
  (1704105,'Centenrio','TO'),
  (1704600,'Chapada de Areia','TO'),
  (1705102,'Chapada da Natividade','TO'),
  (1705508,'Colinas do Tocantins','TO'),
  (1705557,'Combinado','TO'),
  (1705607,'Conceio do Tocantins','TO'),
  (1706001,'Couto Magalhes','TO'),
  (1706100,'Cristalndia','TO'),
  (1706258,'Crixs do Tocantins','TO'),
  (1706506,'Darcinpolis','TO'),
  (1707009,'Dianpolis','TO'),
  (1707108,'Divinpolis do Tocantins','TO'),
  (1707207,'Dois Irmos do Tocantins','TO'),
  (1707306,'Duer','TO'),
  (1707405,'Esperantina','TO'),
  (1707553,'Ftima','TO'),
  (1707652,'Figueirpolis','TO'),
  (1707702,'Filadlfia','TO'),
  (1708205,'Formoso do Araguaia','TO'),
  (1708254,'Fortaleza do Taboco','TO'),
  (1708304,'Goianorte','TO'),
  (1709005,'Goiatins','TO'),
  (1709302,'Guara','TO'),
  (1709500,'Gurupi','TO'),
  (1709807,'Ipueiras','TO'),
  (1710508,'Itacaj','TO'),
  (1710706,'Itaguatins','TO'),
  (1710904,'Itapiratins','TO'),
  (1711100,'Itapor do Tocantins','TO'),
  (1711506,'Ja do Tocantins','TO'),
  (1711803,'Juarina','TO'),
  (1711902,'Lagoa da Confuso','TO'),
  (1711951,'Lagoa do Tocantins','TO'),
  (1712009,'Lajeado','TO'),
  (1712157,'Lavandeira','TO'),
  (1712405,'Lizarda','TO'),
  (1712454,'Luzinpolis','TO'),
  (1712504,'Marianpolis do Tocantins','TO'),
  (1712702,'Mateiros','TO'),
  (1712801,'Maurilndia do Tocantins','TO'),
  (1713205,'Miracema do Tocantins','TO'),
  (1713304,'Miranorte','TO'),
  (1713601,'Monte do Carmo','TO'),
  (1713700,'Monte Santo do Tocantins','TO'),
  (1713809,'Palmeiras do Tocantins','TO'),
  (1713957,'Muricilndia','TO'),
  (1714203,'Natividade','TO'),
  (1714302,'Nazar','TO'),
  (1714880,'Nova Olinda','TO'),
  (1715002,'Nova Rosalndia','TO'),
  (1715101,'Novo Acordo','TO'),
  (1715150,'Novo Alegre','TO'),
  (1715259,'Novo Jardim','TO'),
  (1715507,'Oliveira de Ftima','TO'),
  (1715705,'Palmeirante','TO'),
  (1715754,'Palmeirpolis','TO'),
  (1716109,'Paraso do Tocantins','TO'),
  (1716208,'Paran','TO'),
  (1716307,'Pau D''Arco','TO'),
  (1716505,'Pedro Afonso','TO'),
  (1716604,'Peixe','TO'),
  (1716653,'Pequizeiro','TO'),
  (1716703,'Colmia','TO'),
  (1717008,'Pindorama do Tocantins','TO'),
  (1717206,'Piraqu','TO'),
  (1717503,'Pium','TO'),
  (1717800,'Ponte Alta do Bom Jesus','TO'),
  (1717909,'Ponte Alta do Tocantins','TO'),
  (1718006,'Porto Alegre do Tocantins','TO'),
  (1718204,'Porto Nacional','TO'),
  (1718303,'Praia Norte','TO'),
  (1718402,'Presidente Kennedy','TO'),
  (1718451,'Pugmil','TO'),
  (1718501,'Recursolndia','TO'),
  (1718550,'Riachinho','TO'),
  (1718659,'Rio da Conceio','TO'),
  (1718709,'Rio dos Bois','TO'),
  (1718758,'Rio Sono','TO'),
  (1718808,'Sampaio','TO'),
  (1718840,'Sandolndia','TO'),
  (1718865,'Santa F do Araguaia','TO'),
  (1718881,'Santa Maria do Tocantins','TO'),
  (1718899,'Santa Rita do Tocantins','TO'),
  (1718907,'Santa Rosa do Tocantins','TO'),
  (1719004,'Santa Tereza do Tocantins','TO'),
  (1720002,'Santa Terezinha do Tocantins','TO'),
  (1720101,'So Bento do Tocantins','TO'),
  (1720150,'So Flix do Tocantins','TO'),
  (1720200,'So Miguel do Tocantins','TO'),
  (1720259,'So Salvador do Tocantins','TO'),
  (1720309,'So Sebastio do Tocantins','TO'),
  (1720499,'So Valrio','TO'),
  (1720655,'Silvanpolis','TO'),
  (1720804,'Stio Novo do Tocantins','TO'),
  (1720853,'Sucupira','TO'),
  (1720903,'Taguatinga','TO'),
  (1720937,'Taipas do Tocantins','TO'),
  (1720978,'Talism','TO'),
  (1721000,'Palmas','TO'),
  (1721109,'Tocantnia','TO'),
  (1721208,'Tocantinpolis','TO'),
  (1721257,'Tupirama','TO'),
  (1721307,'Tupiratins','TO'),
  (1722081,'Wanderlndia','TO'),
  (1722107,'Xambio','TO'),
  (2100055,'Aailndia','MA'),
  (2100105,'Afonso Cunha','MA'),
  (2100154,'gua Doce do Maranho','MA'),
  (2100204,'Alcntara','MA'),
  (2100303,'Aldeias Altas','MA'),
  (2100402,'Altamira do Maranho','MA'),
  (2100436,'Alto Alegre do Maranho','MA'),
  (2100477,'Alto Alegre do Pindar','MA'),
  (2100501,'Alto Parnaba','MA'),
  (2100550,'Amap do Maranho','MA'),
  (2100600,'Amarante do Maranho','MA'),
  (2100709,'Anajatuba','MA'),
  (2100808,'Anapurus','MA'),
  (2100832,'Apicum-Au','MA'),
  (2100873,'Araguan','MA'),
  (2100907,'Araioses','MA'),
  (2100956,'Arame','MA'),
  (2101004,'Arari','MA'),
  (2101103,'Axix','MA'),
  (2101202,'Bacabal','MA'),
  (2101251,'Bacabeira','MA'),
  (2101301,'Bacuri','MA'),
  (2101350,'Bacurituba','MA'),
  (2101400,'Balsas','MA'),
  (2101509,'Baro de Graja','MA'),
  (2101608,'Barra do Corda','MA'),
  (2101707,'Barreirinhas','MA'),
  (2101731,'Belgua','MA'),
  (2101772,'Bela Vista do Maranho','MA'),
  (2101806,'Benedito Leite','MA'),
  (2101905,'Bequimo','MA'),
  (2101939,'Bernardo do Mearim','MA'),
  (2101970,'Boa Vista do Gurupi','MA'),
  (2102002,'Bom Jardim','MA'),
  (2102036,'Bom Jesus das Selvas','MA'),
  (2102077,'Bom Lugar','MA'),
  (2102101,'Brejo','MA'),
  (2102150,'Brejo de Areia','MA'),
  (2102200,'Buriti','MA'),
  (2102309,'Buriti Bravo','MA'),
  (2102325,'Buriticupu','MA'),
  (2102358,'Buritirana','MA'),
  (2102374,'Cachoeira Grande','MA'),
  (2102408,'Cajapi','MA'),
  (2102507,'Cajari','MA'),
  (2102556,'Campestre do Maranho','MA'),
  (2102606,'Cndido Mendes','MA'),
  (2102705,'Cantanhede','MA'),
  (2102754,'Capinzal do Norte','MA'),
  (2102804,'Carolina','MA'),
  (2102903,'Carutapera','MA');


INSERT INTO municipios (municipio_id, municipio_nome, estado_sigla) VALUES 
  (2103000,'Caxias','MA'),
  (2103109,'Cedral','MA'),
  (2103125,'Central do Maranho','MA'),
  (2103158,'Centro do Guilherme','MA'),
  (2103174,'Centro Novo do Maranho','MA'),
  (2103208,'Chapadinha','MA'),
  (2103257,'Cidelndia','MA'),
  (2103307,'Cod','MA'),
  (2103406,'Coelho Neto','MA'),
  (2103505,'Colinas','MA'),
  (2103554,'Conceio do Lago-Au','MA'),
  (2103604,'Coroat','MA'),
  (2103703,'Cururupu','MA'),
  (2103752,'Davinpolis','MA'),
  (2103802,'Dom Pedro','MA'),
  (2103901,'Duque Bacelar','MA'),
  (2104008,'Esperantinpolis','MA'),
  (2104057,'Estreito','MA'),
  (2104073,'Feira Nova do Maranho','MA'),
  (2104081,'Fernando Falco','MA'),
  (2104099,'Formosa da Serra Negra','MA'),
  (2104107,'Fortaleza dos Nogueiras','MA'),
  (2104206,'Fortuna','MA'),
  (2104305,'Godofredo Viana','MA'),
  (2104404,'Gonalves Dias','MA'),
  (2104503,'Governador Archer','MA'),
  (2104552,'Governador Edison Lobo','MA'),
  (2104602,'Governador Eugnio Barros','MA'),
  (2104628,'Governador Luiz Rocha','MA'),
  (2104651,'Governador Newton Bello','MA'),
  (2104677,'Governador Nunes Freire','MA'),
  (2104701,'Graa Aranha','MA'),
  (2104800,'Graja','MA'),
  (2104909,'Guimares','MA'),
  (2105005,'Humberto de Campos','MA'),
  (2105104,'Icatu','MA'),
  (2105153,'Igarap do Meio','MA'),
  (2105203,'Igarap Grande','MA'),
  (2105302,'Imperatriz','MA'),
  (2105351,'Itaipava do Graja','MA'),
  (2105401,'Itapecuru Mirim','MA'),
  (2105427,'Itinga do Maranho','MA'),
  (2105450,'Jatob','MA'),
  (2105476,'Jenipapo dos Vieiras','MA'),
  (2105500,'Joo Lisboa','MA'),
  (2105609,'Joselndia','MA'),
  (2105658,'Junco do Maranho','MA'),
  (2105708,'Lago da Pedra','MA'),
  (2105807,'Lago do Junco','MA'),
  (2105906,'Lago Verde','MA'),
  (2105922,'Lagoa do Mato','MA'),
  (2105948,'Lago dos Rodrigues','MA'),
  (2105963,'Lagoa Grande do Maranho','MA'),
  (2105989,'Lajeado Novo','MA'),
  (2106003,'Lima Campos','MA'),
  (2106102,'Loreto','MA'),
  (2106201,'Lus Domingues','MA'),
  (2106300,'Magalhes de Almeida','MA'),
  (2106326,'Maracaum','MA'),
  (2106359,'Maraj do Sena','MA'),
  (2106375,'Maranhozinho','MA'),
  (2106409,'Mata Roma','MA'),
  (2106508,'Matinha','MA'),
  (2106607,'Mates','MA'),
  (2106631,'Mates do Norte','MA'),
  (2106672,'Milagres do Maranho','MA'),
  (2106706,'Mirador','MA'),
  (2106755,'Miranda do Norte','MA'),
  (2106805,'Mirinzal','MA'),
  (2106904,'Mono','MA'),
  (2107001,'Montes Altos','MA'),
  (2107100,'Morros','MA'),
  (2107209,'Nina Rodrigues','MA'),
  (2107258,'Nova Colinas','MA'),
  (2107308,'Nova Iorque','MA'),
  (2107357,'Nova Olinda do Maranho','MA'),
  (2107407,'Olho d''gua das Cunhs','MA'),
  (2107456,'Olinda Nova do Maranho','MA'),
  (2107506,'Pao do Lumiar','MA'),
  (2107605,'Palmeirndia','MA'),
  (2107704,'Paraibano','MA'),
  (2107803,'Parnarama','MA'),
  (2107902,'Passagem Franca','MA'),
  (2108009,'Pastos Bons','MA'),
  (2108058,'Paulino Neves','MA'),
  (2108108,'Paulo Ramos','MA'),
  (2108207,'Pedreiras','MA'),
  (2108256,'Pedro do Rosrio','MA'),
  (2108306,'Penalva','MA'),
  (2108405,'Peri Mirim','MA'),
  (2108454,'Peritor','MA'),
  (2108504,'Pindar-Mirim','MA'),
  (2108603,'Pinheiro','MA'),
  (2108702,'Pio XII','MA'),
  (2108801,'Pirapemas','MA'),
  (2108900,'Poo de Pedras','MA'),
  (2109007,'Porto Franco','MA'),
  (2109056,'Porto Rico do Maranho','MA'),
  (2109106,'Presidente Dutra','MA'),
  (2109205,'Presidente Juscelino','MA'),
  (2109239,'Presidente Mdici','MA'),
  (2109270,'Presidente Sarney','MA'),
  (2109304,'Presidente Vargas','MA'),
  (2109403,'Primeira Cruz','MA'),
  (2109452,'Raposa','MA'),
  (2109502,'Riacho','MA'),
  (2109551,'Ribamar Fiquene','MA'),
  (2109601,'Rosrio','MA'),
  (2109700,'Sambaba','MA'),
  (2109759,'Santa Filomena do Maranho','MA'),
  (2109809,'Santa Helena','MA'),
  (2109908,'Santa Ins','MA'),
  (2110005,'Santa Luzia','MA'),
  (2110039,'Santa Luzia do Paru','MA'),
  (2110104,'Santa Quitria do Maranho','MA'),
  (2110203,'Santa Rita','MA'),
  (2110237,'Santana do Maranho','MA'),
  (2110278,'Santo Amaro do Maranho','MA'),
  (2110302,'Santo Antnio dos Lopes','MA'),
  (2110401,'So Benedito do Rio Preto','MA'),
  (2110500,'So Bento','MA'),
  (2110609,'So Bernardo','MA'),
  (2110658,'So Domingos do Azeito','MA'),
  (2110708,'So Domingos do Maranho','MA'),
  (2110807,'So Flix de Balsas','MA'),
  (2110856,'So Francisco do Brejo','MA'),
  (2110906,'So Francisco do Maranho','MA'),
  (2111003,'So Joo Batista','MA'),
  (2111029,'So Joo do Car','MA'),
  (2111052,'So Joo do Paraso','MA'),
  (2111078,'So Joo do Soter','MA'),
  (2111102,'So Joo dos Patos','MA'),
  (2111201,'So Jos de Ribamar','MA'),
  (2111250,'So Jos dos Baslios','MA'),
  (2111300,'So Lus','MA'),
  (2111409,'So Lus Gonzaga do Maranho','MA'),
  (2111508,'So Mateus do Maranho','MA'),
  (2111532,'So Pedro da gua Branca','MA'),
  (2111573,'So Pedro dos Crentes','MA'),
  (2111607,'So Raimundo das Mangabeiras','MA'),
  (2111631,'So Raimundo do Doca Bezerra','MA'),
  (2111672,'So Roberto','MA'),
  (2111706,'So Vicente Ferrer','MA'),
  (2111722,'Satubinha','MA'),
  (2111748,'Senador Alexandre Costa','MA'),
  (2111763,'Senador La Rocque','MA'),
  (2111789,'Serrano do Maranho','MA'),
  (2111805,'Stio Novo','MA'),
  (2111904,'Sucupira do Norte','MA'),
  (2111953,'Sucupira do Riacho','MA'),
  (2112001,'Tasso Fragoso','MA'),
  (2112100,'Timbiras','MA'),
  (2112209,'Timon','MA'),
  (2112233,'Trizidela do Vale','MA'),
  (2112274,'Tufilndia','MA'),
  (2112308,'Tuntum','MA'),
  (2112407,'Turiau','MA'),
  (2112456,'Turilndia','MA'),
  (2112506,'Tutia','MA'),
  (2112605,'Urbano Santos','MA'),
  (2112704,'Vargem Grande','MA'),
  (2112803,'Viana','MA'),
  (2112852,'Vila Nova dos Martrios','MA'),
  (2112902,'Vitria do Mearim','MA'),
  (2113009,'Vitorino Freire','MA'),
  (2114007,'Z Doca','MA'),
  (2200053,'Acau','PI'),
  (2200103,'Agricolndia','PI'),
  (2200202,'gua Branca','PI'),
  (2200251,'Alagoinha do Piau','PI'),
  (2200277,'Alegrete do Piau','PI'),
  (2200301,'Alto Long','PI'),
  (2200400,'Altos','PI'),
  (2200459,'Alvorada do Gurguia','PI'),
  (2200509,'Amarante','PI'),
  (2200608,'Angical do Piau','PI'),
  (2200707,'Ansio de Abreu','PI'),
  (2200806,'Antnio Almeida','PI'),
  (2200905,'Aroazes','PI'),
  (2200954,'Aroeiras do Itaim','PI'),
  (2201002,'Arraial','PI'),
  (2201051,'Assuno do Piau','PI'),
  (2201101,'Avelino Lopes','PI'),
  (2201150,'Baixa Grande do Ribeiro','PI'),
  (2201176,'Barra D''Alcntara','PI'),
  (2201200,'Barras','PI'),
  (2201309,'Barreiras do Piau','PI'),
  (2201408,'Barro Duro','PI'),
  (2201507,'Batalha','PI'),
  (2201556,'Bela Vista do Piau','PI'),
  (2201572,'Belm do Piau','PI'),
  (2201606,'Beneditinos','PI'),
  (2201705,'Bertolnia','PI'),
  (2201739,'Betnia do Piau','PI'),
  (2201770,'Boa Hora','PI'),
  (2201804,'Bocaina','PI'),
  (2201903,'Bom Jesus','PI'),
  (2201919,'Bom Princpio do Piau','PI'),
  (2201929,'Bonfim do Piau','PI'),
  (2201945,'Boqueiro do Piau','PI'),
  (2201960,'Brasileira','PI'),
  (2201988,'Brejo do Piau','PI'),
  (2202000,'Buriti dos Lopes','PI'),
  (2202026,'Buriti dos Montes','PI'),
  (2202059,'Cabeceiras do Piau','PI'),
  (2202075,'Cajazeiras do Piau','PI'),
  (2202083,'Cajueiro da Praia','PI'),
  (2202091,'Caldeiro Grande do Piau','PI'),
  (2202109,'Campinas do Piau','PI'),
  (2202117,'Campo Alegre do Fidalgo','PI'),
  (2202133,'Campo Grande do Piau','PI'),
  (2202174,'Campo Largo do Piau','PI'),
  (2202208,'Campo Maior','PI'),
  (2202251,'Canavieira','PI'),
  (2202307,'Canto do Buriti','PI'),
  (2202406,'Capito de Campos','PI'),
  (2202455,'Capito Gervsio Oliveira','PI'),
  (2202505,'Caracol','PI'),
  (2202539,'Carabas do Piau','PI'),
  (2202554,'Caridade do Piau','PI'),
  (2202604,'Castelo do Piau','PI'),
  (2202653,'Caxing','PI'),
  (2202703,'Cocal','PI'),
  (2202711,'Cocal de Telha','PI'),
  (2202729,'Cocal dos Alves','PI'),
  (2202737,'Coivaras','PI'),
  (2202752,'Colnia do Gurguia','PI'),
  (2202778,'Colnia do Piau','PI'),
  (2202802,'Conceio do Canind','PI'),
  (2202851,'Coronel Jos Dias','PI'),
  (2202901,'Corrente','PI'),
  (2203008,'Cristalndia do Piau','PI'),
  (2203107,'Cristino Castro','PI'),
  (2203206,'Curimat','PI'),
  (2203230,'Currais','PI'),
  (2203255,'Curralinhos','PI'),
  (2203271,'Curral Novo do Piau','PI'),
  (2203305,'Demerval Lobo','PI'),
  (2203354,'Dirceu Arcoverde','PI'),
  (2203404,'Dom Expedito Lopes','PI'),
  (2203420,'Domingos Mouro','PI'),
  (2203453,'Dom Inocncio','PI'),
  (2203503,'Elesbo Veloso','PI'),
  (2203602,'Eliseu Martins','PI'),
  (2203701,'Esperantina','PI'),
  (2203750,'Fartura do Piau','PI'),
  (2203800,'Flores do Piau','PI'),
  (2203859,'Floresta do Piau','PI'),
  (2203909,'Floriano','PI'),
  (2204006,'Francinpolis','PI'),
  (2204105,'Francisco Ayres','PI'),
  (2204154,'Francisco Macedo','PI'),
  (2204204,'Francisco Santos','PI'),
  (2204303,'Fronteiras','PI'),
  (2204352,'Geminiano','PI'),
  (2204402,'Gilbus','PI'),
  (2204501,'Guadalupe','PI'),
  (2204550,'Guaribas','PI'),
  (2204600,'Hugo Napoleo','PI'),
  (2204659,'Ilha Grande','PI'),
  (2204709,'Inhuma','PI'),
  (2204808,'Ipiranga do Piau','PI'),
  (2204907,'Isaas Coelho','PI'),
  (2205003,'Itainpolis','PI'),
  (2205102,'Itaueira','PI'),
  (2205151,'Jacobina do Piau','PI'),
  (2205201,'Jaics','PI'),
  (2205250,'Jardim do Mulato','PI'),
  (2205276,'Jatob do Piau','PI'),
  (2205300,'Jerumenha','PI'),
  (2205359,'Joo Costa','PI'),
  (2205409,'Joaquim Pires','PI'),
  (2205458,'Joca Marques','PI'),
  (2205508,'Jos de Freitas','PI'),
  (2205516,'Juazeiro do Piau','PI'),
  (2205524,'Jlio Borges','PI'),
  (2205532,'Jurema','PI'),
  (2205540,'Lagoinha do Piau','PI'),
  (2205557,'Lagoa Alegre','PI'),
  (2205565,'Lagoa do Barro do Piau','PI'),
  (2205573,'Lagoa de So Francisco','PI'),
  (2205581,'Lagoa do Piau','PI'),
  (2205599,'Lagoa do Stio','PI'),
  (2205607,'Landri Sales','PI'),
  (2205706,'Lus Correia','PI'),
  (2205805,'Luzilndia','PI'),
  (2205854,'Madeiro','PI'),
  (2205904,'Manoel Emdio','PI'),
  (2205953,'Marcolndia','PI'),
  (2206001,'Marcos Parente','PI'),
  (2206050,'Massap do Piau','PI'),
  (2206100,'Matias Olmpio','PI'),
  (2206209,'Miguel Alves','PI'),
  (2206308,'Miguel Leo','PI'),
  (2206357,'Milton Brando','PI'),
  (2206407,'Monsenhor Gil','PI'),
  (2206506,'Monsenhor Hiplito','PI'),
  (2206605,'Monte Alegre do Piau','PI'),
  (2206654,'Morro Cabea no Tempo','PI'),
  (2206670,'Morro do Chapu do Piau','PI'),
  (2206696,'Murici dos Portelas','PI'),
  (2206704,'Nazar do Piau','PI'),
  (2206720,'Nazria','PI'),
  (2206753,'Nossa Senhora de Nazar','PI'),
  (2206803,'Nossa Senhora dos Remdios','PI'),
  (2206902,'Novo Oriente do Piau','PI'),
  (2206951,'Novo Santo Antnio','PI'),
  (2207009,'Oeiras','PI'),
  (2207108,'Olho D''gua do Piau','PI'),
  (2207207,'Padre Marcos','PI'),
  (2207306,'Paes Landim','PI'),
  (2207355,'Paje do Piau','PI'),
  (2207405,'Palmeira do Piau','PI'),
  (2207504,'Palmeirais','PI'),
  (2207553,'Paquet','PI'),
  (2207603,'Parnagu','PI'),
  (2207702,'Parnaba','PI'),
  (2207751,'Passagem Franca do Piau','PI'),
  (2207777,'Patos do Piau','PI'),
  (2207793,'Pau D''Arco do Piau','PI'),
  (2207801,'Paulistana','PI'),
  (2207850,'Pavussu','PI'),
  (2207900,'Pedro II','PI'),
  (2207934,'Pedro Laurentino','PI'),
  (2207959,'Nova Santa Rita','PI'),
  (2208007,'Picos','PI'),
  (2208106,'Pimenteiras','PI'),
  (2208205,'Pio IX','PI'),
  (2208304,'Piracuruca','PI'),
  (2208403,'Piripiri','PI'),
  (2208502,'Porto','PI'),
  (2208551,'Porto Alegre do Piau','PI'),
  (2208601,'Prata do Piau','PI'),
  (2208650,'Queimada Nova','PI'),
  (2208700,'Redeno do Gurguia','PI'),
  (2208809,'Regenerao','PI'),
  (2208858,'Riacho Frio','PI'),
  (2208874,'Ribeira do Piau','PI'),
  (2208908,'Ribeiro Gonalves','PI'),
  (2209005,'Rio Grande do Piau','PI'),
  (2209104,'Santa Cruz do Piau','PI'),
  (2209153,'Santa Cruz dos Milagres','PI'),
  (2209203,'Santa Filomena','PI'),
  (2209302,'Santa Luz','PI'),
  (2209351,'Santana do Piau','PI'),
  (2209377,'Santa Rosa do Piau','PI'),
  (2209401,'Santo Antnio de Lisboa','PI'),
  (2209450,'Santo Antnio dos Milagres','PI'),
  (2209500,'Santo Incio do Piau','PI'),
  (2209559,'So Braz do Piau','PI'),
  (2209609,'So Flix do Piau','PI'),
  (2209658,'So Francisco de Assis do Piau','PI'),
  (2209708,'So Francisco do Piau','PI'),
  (2209757,'So Gonalo do Gurguia','PI'),
  (2209807,'So Gonalo do Piau','PI'),
  (2209856,'So Joo da Canabrava','PI'),
  (2209872,'So Joo da Fronteira','PI'),
  (2209906,'So Joo da Serra','PI'),
  (2209955,'So Joo da Varjota','PI'),
  (2209971,'So Joo do Arraial','PI'),
  (2210003,'So Joo do Piau','PI'),
  (2210052,'So Jos do Divino','PI'),
  (2210102,'So Jos do Peixe','PI'),
  (2210201,'So Jos do Piau','PI'),
  (2210300,'So Julio','PI'),
  (2210359,'So Loureno do Piau','PI'),
  (2210375,'So Luis do Piau','PI'),
  (2210383,'So Miguel da Baixa Grande','PI'),
  (2210391,'So Miguel do Fidalgo','PI'),
  (2210409,'So Miguel do Tapuio','PI'),
  (2210508,'So Pedro do Piau','PI'),
  (2210607,'So Raimundo Nonato','PI'),
  (2210623,'Sebastio Barros','PI'),
  (2210631,'Sebastio Leal','PI'),
  (2210656,'Sigefredo Pacheco','PI'),
  (2210706,'Simes','PI'),
  (2210805,'Simplcio Mendes','PI'),
  (2210904,'Socorro do Piau','PI'),
  (2210938,'Sussuapara','PI'),
  (2210953,'Tamboril do Piau','PI'),
  (2210979,'Tanque do Piau','PI'),
  (2211001,'Teresina','PI'),
  (2211100,'Unio','PI'),
  (2211209,'Uruu','PI'),
  (2211308,'Valena do Piau','PI'),
  (2211357,'Vrzea Branca','PI'),
  (2211407,'Vrzea Grande','PI'),
  (2211506,'Vera Mendes','PI'),
  (2211605,'Vila Nova do Piau','PI'),
  (2211704,'Wall Ferraz','PI'),
  (2300101,'Abaiara','CE'),
  (2300150,'Acarape','CE'),
  (2300200,'Acara','CE'),
  (2300309,'Acopiara','CE'),
  (2300408,'Aiuaba','CE'),
  (2300507,'Alcntaras','CE'),
  (2300606,'Altaneira','CE'),
  (2300705,'Alto Santo','CE'),
  (2300754,'Amontada','CE'),
  (2300804,'Antonina do Norte','CE'),
  (2300903,'Apuiars','CE'),
  (2301000,'Aquiraz','CE'),
  (2301109,'Aracati','CE'),
  (2301208,'Aracoiaba','CE'),
  (2301257,'Ararend','CE'),
  (2301307,'Araripe','CE'),
  (2301406,'Aratuba','CE'),
  (2301505,'Arneiroz','CE'),
  (2301604,'Assar','CE'),
  (2301703,'Aurora','CE'),
  (2301802,'Baixio','CE'),
  (2301851,'Banabui','CE'),
  (2301901,'Barbalha','CE'),
  (2301950,'Barreira','CE'),
  (2302008,'Barro','CE'),
  (2302057,'Barroquinha','CE'),
  (2302107,'Baturit','CE'),
  (2302206,'Beberibe','CE'),
  (2302305,'Bela Cruz','CE'),
  (2302404,'Boa Viagem','CE'),
  (2302503,'Brejo Santo','CE'),
  (2302602,'Camocim','CE'),
  (2302701,'Campos Sales','CE'),
  (2302800,'Canind','CE'),
  (2302909,'Capistrano','CE'),
  (2303006,'Caridade','CE'),
  (2303105,'Carir','CE'),
  (2303204,'Caririau','CE'),
  (2303303,'Caris','CE'),
  (2303402,'Carnaubal','CE'),
  (2303501,'Cascavel','CE'),
  (2303600,'Catarina','CE'),
  (2303659,'Catunda','CE'),
  (2303709,'Caucaia','CE'),
  (2303808,'Cedro','CE'),
  (2303907,'Chaval','CE'),
  (2303931,'Chor','CE'),
  (2303956,'Chorozinho','CE'),
  (2304004,'Corea','CE'),
  (2304103,'Crates','CE'),
  (2304202,'Crato','CE'),
  (2304236,'Croat','CE'),
  (2304251,'Cruz','CE'),
  (2304269,'Deputado Irapuan Pinheiro','CE'),
  (2304277,'Erer','CE'),
  (2304285,'Eusbio','CE'),
  (2304301,'Farias Brito','CE'),
  (2304350,'Forquilha','CE'),
  (2304400,'Fortaleza','CE'),
  (2304459,'Fortim','CE'),
  (2304509,'Frecheirinha','CE'),
  (2304608,'General Sampaio','CE'),
  (2304657,'Graa','CE'),
  (2304707,'Granja','CE'),
  (2304806,'Granjeiro','CE'),
  (2304905,'Groaras','CE'),
  (2304954,'Guaiba','CE'),
  (2305001,'Guaraciaba do Norte','CE'),
  (2305100,'Guaramiranga','CE'),
  (2305209,'Hidrolndia','CE'),
  (2305233,'Horizonte','CE'),
  (2305266,'Ibaretama','CE'),
  (2305308,'Ibiapina','CE'),
  (2305332,'Ibicuitinga','CE'),
  (2305357,'Icapu','CE'),
  (2305407,'Ic','CE'),
  (2305506,'Iguatu','CE'),
  (2305605,'Independncia','CE'),
  (2305654,'Ipaporanga','CE'),
  (2305704,'Ipaumirim','CE'),
  (2305803,'Ipu','CE'),
  (2305902,'Ipueiras','CE'),
  (2306009,'Iracema','CE'),
  (2306108,'Irauuba','CE'),
  (2306207,'Itaiaba','CE'),
  (2306256,'Itaitinga','CE'),
  (2306306,'Itapag','CE'),
  (2306405,'Itapipoca','CE'),
  (2306504,'Itapina','CE'),
  (2306553,'Itarema','CE'),
  (2306603,'Itatira','CE'),
  (2306702,'Jaguaretama','CE'),
  (2306801,'Jaguaribara','CE'),
  (2306900,'Jaguaribe','CE'),
  (2307007,'Jaguaruana','CE'),
  (2307106,'Jardim','CE'),
  (2307205,'Jati','CE'),
  (2307254,'Jijoca de Jericoacoara','CE'),
  (2307304,'Juazeiro do Norte','CE'),
  (2307403,'Jucs','CE'),
  (2307502,'Lavras da Mangabeira','CE'),
  (2307601,'Limoeiro do Norte','CE'),
  (2307635,'Madalena','CE'),
  (2307650,'Maracana','CE'),
  (2307700,'Maranguape','CE'),
  (2307809,'Marco','CE'),
  (2307908,'Martinpole','CE'),
  (2308005,'Massap','CE'),
  (2308104,'Mauriti','CE'),
  (2308203,'Meruoca','CE');

INSERT INTO municipios (municipio_id, municipio_nome, estado_sigla) VALUES 
  (2308302,'Milagres','CE'),
  (2308351,'Milh','CE'),
  (2308377,'Mirama','CE'),
  (2308401,'Misso Velha','CE'),
  (2308500,'Mombaa','CE'),
  (2308609,'Monsenhor Tabosa','CE'),
  (2308708,'Morada Nova','CE'),
  (2308807,'Morajo','CE'),
  (2308906,'Morrinhos','CE'),
  (2309003,'Mucambo','CE'),
  (2309102,'Mulungu','CE'),
  (2309201,'Nova Olinda','CE'),
  (2309300,'Nova Russas','CE'),
  (2309409,'Novo Oriente','CE'),
  (2309458,'Ocara','CE'),
  (2309508,'Ors','CE'),
  (2309607,'Pacajus','CE'),
  (2309706,'Pacatuba','CE'),
  (2309805,'Pacoti','CE'),
  (2309904,'Pacuj','CE'),
  (2310001,'Palhano','CE'),
  (2310100,'Palmcia','CE'),
  (2310209,'Paracuru','CE'),
  (2310258,'Paraipaba','CE'),
  (2310308,'Parambu','CE'),
  (2310407,'Paramoti','CE'),
  (2310506,'Pedra Branca','CE'),
  (2310605,'Penaforte','CE'),
  (2310704,'Pentecoste','CE'),
  (2310803,'Pereiro','CE'),
  (2310852,'Pindoretama','CE'),
  (2310902,'Piquet Carneiro','CE'),
  (2310951,'Pires Ferreira','CE'),
  (2311009,'Poranga','CE'),
  (2311108,'Porteiras','CE'),
  (2311207,'Potengi','CE'),
  (2311231,'Potiretama','CE'),
  (2311264,'Quiterianpolis','CE'),
  (2311306,'Quixad','CE'),
  (2311355,'Quixel','CE'),
  (2311405,'Quixeramobim','CE'),
  (2311504,'Quixer','CE'),
  (2311603,'Redeno','CE'),
  (2311702,'Reriutaba','CE'),
  (2311801,'Russas','CE'),
  (2311900,'Saboeiro','CE'),
  (2311959,'Salitre','CE'),
  (2312007,'Santana do Acara','CE'),
  (2312106,'Santana do Cariri','CE'),
  (2312205,'Santa Quitria','CE'),
  (2312304,'So Benedito','CE'),
  (2312403,'So Gonalo do Amarante','CE'),
  (2312502,'So Joo do Jaguaribe','CE'),
  (2312601,'So Lus do Curu','CE'),
  (2312700,'Senador Pompeu','CE'),
  (2312809,'Senador S','CE'),
  (2312908,'Sobral','CE'),
  (2313005,'Solonpole','CE'),
  (2313104,'Tabuleiro do Norte','CE'),
  (2313203,'Tamboril','CE'),
  (2313252,'Tarrafas','CE'),
  (2313302,'Tau','CE'),
  (2313351,'Tejuuoca','CE'),
  (2313401,'Tiangu','CE'),
  (2313500,'Trairi','CE'),
  (2313559,'Tururu','CE'),
  (2313609,'Ubajara','CE'),
  (2313708,'Umari','CE'),
  (2313757,'Umirim','CE'),
  (2313807,'Uruburetama','CE'),
  (2313906,'Uruoca','CE'),
  (2313955,'Varjota','CE'),
  (2314003,'Vrzea Alegre','CE'),
  (2314102,'Viosa do Cear','CE'),
  (2400109,'Acari','RN'),
  (2400208,'Au','RN'),
  (2400307,'Afonso Bezerra','RN'),
  (2400406,'gua Nova','RN'),
  (2400505,'Alexandria','RN'),
  (2400604,'Almino Afonso','RN'),
  (2400703,'Alto do Rodrigues','RN'),
  (2400802,'Angicos','RN'),
  (2400901,'Antnio Martins','RN'),
  (2401008,'Apodi','RN'),
  (2401107,'Areia Branca','RN'),
  (2401206,'Ars','RN'),
  (2401305,'Augusto Severo','RN'),
  (2401404,'Baa Formosa','RN'),
  (2401453,'Barana','RN'),
  (2401503,'Barcelona','RN'),
  (2401602,'Bento Fernandes','RN'),
  (2401651,'Bod','RN'),
  (2401701,'Bom Jesus','RN'),
  (2401800,'Brejinho','RN'),
  (2401859,'Caiara do Norte','RN'),
  (2401909,'Caiara do Rio do Vento','RN'),
  (2402006,'Caic','RN'),
  (2402105,'Campo Redondo','RN'),
  (2402204,'Canguaretama','RN'),
  (2402303,'Carabas','RN'),
  (2402402,'Carnaba dos Dantas','RN'),
  (2402501,'Carnaubais','RN'),
  (2402600,'Cear-Mirim','RN'),
  (2402709,'Cerro Cor','RN'),
  (2402808,'Coronel Ezequiel','RN'),
  (2402907,'Coronel Joo Pessoa','RN'),
  (2403004,'Cruzeta','RN'),
  (2403103,'Currais Novos','RN'),
  (2403202,'Doutor Severiano','RN'),
  (2403251,'Parnamirim','RN'),
  (2403301,'Encanto','RN'),
  (2403400,'Equador','RN'),
  (2403509,'Esprito Santo','RN'),
  (2403608,'Extremoz','RN'),
  (2403707,'Felipe Guerra','RN'),
  (2403756,'Fernando Pedroza','RN'),
  (2403806,'Flornia','RN'),
  (2403905,'Francisco Dantas','RN'),
  (2404002,'Frutuoso Gomes','RN'),
  (2404101,'Galinhos','RN'),
  (2404200,'Goianinha','RN'),
  (2404309,'Governador Dix-Sept Rosado','RN'),
  (2404408,'Grossos','RN'),
  (2404507,'Guamar','RN'),
  (2404606,'Ielmo Marinho','RN'),
  (2404705,'Ipanguau','RN'),
  (2404804,'Ipueira','RN'),
  (2404853,'Itaj','RN'),
  (2404903,'Ita','RN'),
  (2405009,'Jaan','RN'),
  (2405108,'Jandara','RN'),
  (2405207,'Jandus','RN'),
  (2405306,'Janurio Cicco','RN'),
  (2405405,'Japi','RN'),
  (2405504,'Jardim de Angicos','RN'),
  (2405603,'Jardim de Piranhas','RN'),
  (2405702,'Jardim do Serid','RN'),
  (2405801,'Joo Cmara','RN'),
  (2405900,'Joo Dias','RN'),
  (2406007,'Jos da Penha','RN'),
  (2406106,'Jucurutu','RN'),
  (2406155,'Jundi','RN'),
  (2406205,'Lagoa d''Anta','RN'),
  (2406304,'Lagoa de Pedras','RN'),
  (2406403,'Lagoa de Velhos','RN'),
  (2406502,'Lagoa Nova','RN'),
  (2406601,'Lagoa Salgada','RN'),
  (2406700,'Lajes','RN'),
  (2406809,'Lajes Pintadas','RN'),
  (2406908,'Lucrcia','RN'),
  (2407005,'Lus Gomes','RN'),
  (2407104,'Macaba','RN'),
  (2407203,'Macau','RN'),
  (2407252,'Major Sales','RN'),
  (2407302,'Marcelino Vieira','RN'),
  (2407401,'Martins','RN'),
  (2407500,'Maxaranguape','RN'),
  (2407609,'Messias Targino','RN'),
  (2407708,'Montanhas','RN'),
  (2407807,'Monte Alegre','RN'),
  (2407906,'Monte das Gameleiras','RN'),
  (2408003,'Mossor','RN'),
  (2408102,'Natal','RN'),
  (2408201,'Nsia Floresta','RN'),
  (2408300,'Nova Cruz','RN'),
  (2408409,'Olho-d''gua do Borges','RN'),
  (2408508,'Ouro Branco','RN'),
  (2408607,'Paran','RN'),
  (2408706,'Para','RN'),
  (2408805,'Parazinho','RN'),
  (2408904,'Parelhas','RN'),
  (2408953,'Rio do Fogo','RN'),
  (2409100,'Passa e Fica','RN'),
  (2409209,'Passagem','RN'),
  (2409308,'Patu','RN'),
  (2409332,'Santa Maria','RN'),
  (2409407,'Pau dos Ferros','RN'),
  (2409506,'Pedra Grande','RN'),
  (2409605,'Pedra Preta','RN'),
  (2409704,'Pedro Avelino','RN'),
  (2409803,'Pedro Velho','RN'),
  (2409902,'Pendncias','RN'),
  (2410009,'Piles','RN'),
  (2410108,'Poo Branco','RN'),
  (2410207,'Portalegre','RN'),
  (2410256,'Porto do Mangue','RN'),
  (2410306,'Presidente Juscelino','RN'),
  (2410405,'Pureza','RN'),
  (2410504,'Rafael Fernandes','RN'),
  (2410603,'Rafael Godeiro','RN'),
  (2410702,'Riacho da Cruz','RN'),
  (2410801,'Riacho de Santana','RN'),
  (2410900,'Riachuelo','RN'),
  (2411007,'Rodolfo Fernandes','RN'),
  (2411056,'Tibau','RN'),
  (2411106,'Ruy Barbosa','RN'),
  (2411205,'Santa Cruz','RN'),
  (2411403,'Santana do Matos','RN'),
  (2411429,'Santana do Serid','RN'),
  (2411502,'Santo Antnio','RN'),
  (2411601,'So Bento do Norte','RN'),
  (2411700,'So Bento do Trair','RN'),
  (2411809,'So Fernando','RN'),
  (2411908,'So Francisco do Oeste','RN'),
  (2412005,'So Gonalo do Amarante','RN'),
  (2412104,'So Joo do Sabugi','RN'),
  (2412203,'So Jos de Mipibu','RN'),
  (2412302,'So Jos do Campestre','RN'),
  (2412401,'So Jos do Serid','RN'),
  (2412500,'So Miguel','RN'),
  (2412559,'So Miguel do Gostoso','RN'),
  (2412609,'So Paulo do Potengi','RN'),
  (2412708,'So Pedro','RN'),
  (2412807,'So Rafael','RN'),
  (2412906,'So Tom','RN'),
  (2413003,'So Vicente','RN'),
  (2413102,'Senador Eli de Souza','RN'),
  (2413201,'Senador Georgino Avelino','RN'),
  (2413300,'Serra de So Bento','RN'),
  (2413359,'Serra do Mel','RN'),
  (2413409,'Serra Negra do Norte','RN'),
  (2413508,'Serrinha','RN'),
  (2413557,'Serrinha dos Pintos','RN'),
  (2413607,'Severiano Melo','RN'),
  (2413706,'Stio Novo','RN'),
  (2413805,'Taboleiro Grande','RN'),
  (2413904,'Taipu','RN'),
  (2414001,'Tangar','RN'),
  (2414100,'Tenente Ananias','RN'),
  (2414159,'Tenente Laurentino Cruz','RN'),
  (2414209,'Tibau do Sul','RN'),
  (2414308,'Timbaba dos Batistas','RN'),
  (2414407,'Touros','RN'),
  (2414456,'Triunfo Potiguar','RN'),
  (2414506,'Umarizal','RN'),
  (2414605,'Upanema','RN'),
  (2414704,'Vrzea','RN'),
  (2414753,'Venha-Ver','RN'),
  (2414803,'Vera Cruz','RN'),
  (2414902,'Viosa','RN'),
  (2415008,'Vila Flor','RN'),
  (2500106,'gua Branca','PB'),
  (2500205,'Aguiar','PB'),
  (2500304,'Alagoa Grande','PB'),
  (2500403,'Alagoa Nova','PB'),
  (2500502,'Alagoinha','PB'),
  (2500536,'Alcantil','PB'),
  (2500577,'Algodo de Jandara','PB'),
  (2500601,'Alhandra','PB'),
  (2500700,'So Joo do Rio do Peixe','PB'),
  (2500734,'Amparo','PB'),
  (2500775,'Aparecida','PB'),
  (2500809,'Araagi','PB'),
  (2500908,'Arara','PB'),
  (2501005,'Araruna','PB'),
  (2501104,'Areia','PB'),
  (2501153,'Areia de Baranas','PB'),
  (2501203,'Areial','PB'),
  (2501302,'Aroeiras','PB'),
  (2501351,'Assuno','PB'),
  (2501401,'Baa da Traio','PB'),
  (2501500,'Bananeiras','PB'),
  (2501534,'Barana','PB'),
  (2501575,'Barra de Santana','PB'),
  (2501609,'Barra de Santa Rosa','PB'),
  (2501708,'Barra de So Miguel','PB'),
  (2501807,'Bayeux','PB'),
  (2501906,'Belm','PB'),
  (2502003,'Belm do Brejo do Cruz','PB'),
  (2502052,'Bernardino Batista','PB'),
  (2502102,'Boa Ventura','PB'),
  (2502151,'Boa Vista','PB'),
  (2502201,'Bom Jesus','PB'),
  (2502300,'Bom Sucesso','PB'),
  (2502409,'Bonito de Santa F','PB'),
  (2502508,'Boqueiro','PB'),
  (2502607,'Igaracy','PB'),
  (2502706,'Borborema','PB'),
  (2502805,'Brejo do Cruz','PB'),
  (2502904,'Brejo dos Santos','PB'),
  (2503001,'Caapor','PB'),
  (2503100,'Cabaceiras','PB'),
  (2503209,'Cabedelo','PB'),
  (2503308,'Cachoeira dos ndios','PB'),
  (2503407,'Cacimba de Areia','PB'),
  (2503506,'Cacimba de Dentro','PB'),
  (2503555,'Cacimbas','PB'),
  (2503605,'Caiara','PB'),
  (2503704,'Cajazeiras','PB'),
  (2503753,'Cajazeirinhas','PB'),
  (2503803,'Caldas Brando','PB'),
  (2503902,'Camala','PB'),
  (2504009,'Campina Grande','PB'),
  (2504033,'Capim','PB'),
  (2504074,'Carabas','PB'),
  (2504108,'Carrapateira','PB'),
  (2504157,'Casserengue','PB'),
  (2504207,'Catingueira','PB'),
  (2504306,'Catol do Rocha','PB'),
  (2504355,'Caturit','PB'),
  (2504405,'Conceio','PB'),
  (2504504,'Condado','PB'),
  (2504603,'Conde','PB'),
  (2504702,'Congo','PB'),
  (2504801,'Coremas','PB'),
  (2504850,'Coxixola','PB'),
  (2504900,'Cruz do Esprito Santo','PB'),
  (2505006,'Cubati','PB'),
  (2505105,'Cuit','PB'),
  (2505204,'Cuitegi','PB'),
  (2505238,'Cuit de Mamanguape','PB'),
  (2505279,'Curral de Cima','PB'),
  (2505303,'Curral Velho','PB'),
  (2505352,'Damio','PB'),
  (2505402,'Desterro','PB'),
  (2505501,'Vista Serrana','PB'),
  (2505600,'Diamante','PB'),
  (2505709,'Dona Ins','PB'),
  (2505808,'Duas Estradas','PB'),
  (2505907,'Emas','PB'),
  (2506004,'Esperana','PB'),
  (2506103,'Fagundes','PB'),
  (2506202,'Frei Martinho','PB'),
  (2506251,'Gado Bravo','PB'),
  (2506301,'Guarabira','PB'),
  (2506400,'Gurinhm','PB'),
  (2506509,'Gurjo','PB'),
  (2506608,'Ibiara','PB'),
  (2506707,'Imaculada','PB'),
  (2506806,'Ing','PB'),
  (2506905,'Itabaiana','PB'),
  (2507002,'Itaporanga','PB'),
  (2507101,'Itapororoca','PB'),
  (2507200,'Itatuba','PB'),
  (2507309,'Jacara','PB'),
  (2507408,'Jeric','PB'),
  (2507507,'Joo Pessoa','PB'),
  (2507606,'Juarez Tvora','PB'),
  (2507705,'Juazeirinho','PB'),
  (2507804,'Junco do Serid','PB'),
  (2507903,'Juripiranga','PB'),
  (2508000,'Juru','PB'),
  (2508109,'Lagoa','PB'),
  (2508208,'Lagoa de Dentro','PB'),
  (2508307,'Lagoa Seca','PB'),
  (2508406,'Lastro','PB'),
  (2508505,'Livramento','PB'),
  (2508554,'Logradouro','PB'),
  (2508604,'Lucena','PB'),
  (2508703,'Me d''gua','PB'),
  (2508802,'Malta','PB'),
  (2508901,'Mamanguape','PB'),
  (2509008,'Manara','PB'),
  (2509057,'Marcao','PB'),
  (2509107,'Mari','PB'),
  (2509156,'Marizpolis','PB'),
  (2509206,'Massaranduba','PB'),
  (2509305,'Mataraca','PB'),
  (2509339,'Matinhas','PB'),
  (2509370,'Mato Grosso','PB'),
  (2509396,'Maturia','PB'),
  (2509404,'Mogeiro','PB'),
  (2509503,'Montadas','PB'),
  (2509602,'Monte Horebe','PB'),
  (2509701,'Monteiro','PB'),
  (2509800,'Mulungu','PB'),
  (2509909,'Natuba','PB'),
  (2510006,'Nazarezinho','PB'),
  (2510105,'Nova Floresta','PB'),
  (2510204,'Nova Olinda','PB'),
  (2510303,'Nova Palmeira','PB'),
  (2510402,'Olho d''gua','PB'),
  (2510501,'Olivedos','PB'),
  (2510600,'Ouro Velho','PB'),
  (2510659,'Parari','PB'),
  (2510709,'Passagem','PB'),
  (2510808,'Patos','PB'),
  (2510907,'Paulista','PB'),
  (2511004,'Pedra Branca','PB'),
  (2511103,'Pedra Lavrada','PB'),
  (2511202,'Pedras de Fogo','PB'),
  (2511301,'Pianc','PB'),
  (2511400,'Picu','PB'),
  (2511509,'Pilar','PB'),
  (2511608,'Piles','PB'),
  (2511707,'Pilezinhos','PB'),
  (2511806,'Pirpirituba','PB'),
  (2511905,'Pitimbu','PB'),
  (2512002,'Pocinhos','PB'),
  (2512036,'Poo Dantas','PB'),
  (2512077,'Poo de Jos de Moura','PB'),
  (2512101,'Pombal','PB'),
  (2512200,'Prata','PB'),
  (2512309,'Princesa Isabel','PB'),
  (2512408,'Puxinan','PB'),
  (2512507,'Queimadas','PB'),
  (2512606,'Quixab','PB'),
  (2512705,'Remgio','PB'),
  (2512721,'Pedro Rgis','PB'),
  (2512747,'Riacho','PB'),
  (2512754,'Riacho do Bacamarte','PB'),
  (2512762,'Riacho do Poo','PB'),
  (2512788,'Riacho de Santo Antnio','PB'),
  (2512804,'Riacho dos Cavalos','PB'),
  (2512903,'Rio Tinto','PB'),
  (2513000,'Salgadinho','PB'),
  (2513109,'Salgado de So Flix','PB'),
  (2513158,'Santa Ceclia','PB'),
  (2513208,'Santa Cruz','PB'),
  (2513307,'Santa Helena','PB'),
  (2513356,'Santa Ins','PB'),
  (2513406,'Santa Luzia','PB'),
  (2513505,'Santana de Mangueira','PB'),
  (2513604,'Santana dos Garrotes','PB'),
  (2513653,'Santarm','PB'),
  (2513703,'Santa Rita','PB'),
  (2513802,'Santa Teresinha','PB'),
  (2513851,'Santo Andr','PB'),
  (2513901,'So Bento','PB'),
  (2513927,'So Bentinho','PB'),
  (2513943,'So Domingos do Cariri','PB'),
  (2513968,'So Domingos','PB'),
  (2513984,'So Francisco','PB'),
  (2514008,'So Joo do Cariri','PB'),
  (2514107,'So Joo do Tigre','PB'),
  (2514206,'So Jos da Lagoa Tapada','PB'),
  (2514305,'So Jos de Caiana','PB'),
  (2514404,'So Jos de Espinharas','PB'),
  (2514453,'So Jos dos Ramos','PB'),
  (2514503,'So Jos de Piranhas','PB'),
  (2514552,'So Jos de Princesa','PB'),
  (2514602,'So Jos do Bonfim','PB'),
  (2514651,'So Jos do Brejo do Cruz','PB'),
  (2514701,'So Jos do Sabugi','PB'),
  (2514800,'So Jos dos Cordeiros','PB'),
  (2514909,'So Mamede','PB'),
  (2515005,'So Miguel de Taipu','PB'),
  (2515104,'So Sebastio de Lagoa de Roa','PB'),
  (2515203,'So Sebastio do Umbuzeiro','PB'),
  (2515302,'Sap','PB'),
  (2515401,'Serid','PB'),
  (2515500,'Serra Branca','PB'),
  (2515609,'Serra da Raiz','PB'),
  (2515708,'Serra Grande','PB'),
  (2515807,'Serra Redonda','PB'),
  (2515906,'Serraria','PB'),
  (2515930,'Sertozinho','PB'),
  (2515971,'Sobrado','PB'),
  (2516003,'Solnea','PB'),
  (2516102,'Soledade','PB'),
  (2516151,'Sossgo','PB'),
  (2516201,'Sousa','PB'),
  (2516300,'Sum','PB'),
  (2516409,'Campo de Santana','PB'),
  (2516508,'Tapero','PB'),
  (2516607,'Tavares','PB'),
  (2516706,'Teixeira','PB'),
  (2516755,'Tenrio','PB'),
  (2516805,'Triunfo','PB'),
  (2516904,'Uirana','PB'),
  (2517001,'Umbuzeiro','PB'),
  (2517100,'Vrzea','PB'),
  (2517209,'Vieirpolis','PB'),
  (2517407,'Zabel','PB'),
  (2600054,'Abreu e Lima','PE'),
  (2600104,'Afogados da Ingazeira','PE'),
  (2600203,'Afrnio','PE'),
  (2600302,'Agrestina','PE'),
  (2600401,'gua Preta','PE'),
  (2600500,'guas Belas','PE'),
  (2600609,'Alagoinha','PE'),
  (2600708,'Aliana','PE'),
  (2600807,'Altinho','PE'),
  (2600906,'Amaraji','PE'),
  (2601003,'Angelim','PE'),
  (2601052,'Araoiaba','PE'),
  (2601102,'Araripina','PE'),
  (2601201,'Arcoverde','PE'),
  (2601300,'Barra de Guabiraba','PE'),
  (2601409,'Barreiros','PE'),
  (2601508,'Belm de Maria','PE'),
  (2601607,'Belm do So Francisco','PE'),
  (2601706,'Belo Jardim','PE'),
  (2601805,'Betnia','PE'),
  (2601904,'Bezerros','PE'),
  (2602001,'Bodoc','PE'),
  (2602100,'Bom Conselho','PE'),
  (2602209,'Bom Jardim','PE'),
  (2602308,'Bonito','PE'),
  (2602407,'Brejo','PE'),
  (2602506,'Brejinho','PE'),
  (2602605,'Brejo da Madre de Deus','PE'),
  (2602704,'Buenos Aires','PE'),
  (2602803,'Buque','PE'),
  (2602902,'Cabo de Santo Agostinho','PE'),
  (2603009,'Cabrob','PE'),
  (2603108,'Cachoeirinha','PE'),
  (2603207,'Caets','PE'),
  (2603306,'Calado','PE'),
  (2603405,'Calumbi','PE');

INSERT INTO municipios (municipio_id, municipio_nome, estado_sigla) VALUES 
  (2603454,'Camaragibe','PE'),
  (2603504,'Camocim de So Flix','PE'),
  (2603603,'Camutanga','PE'),
  (2603702,'Canhotinho','PE'),
  (2603801,'Capoeiras','PE'),
  (2603900,'Carnaba','PE'),
  (2603926,'Carnaubeira da Penha','PE'),
  (2604007,'Carpina','PE'),
  (2604106,'Caruaru','PE'),
  (2604155,'Casinhas','PE'),
  (2604205,'Catende','PE'),
  (2604304,'Cedro','PE'),
  (2604403,'Ch de Alegria','PE'),
  (2604502,'Ch Grande','PE'),
  (2604601,'Condado','PE'),
  (2604700,'Correntes','PE'),
  (2604809,'Corts','PE'),
  (2604908,'Cumaru','PE'),
  (2605004,'Cupira','PE'),
  (2605103,'Custdia','PE'),
  (2605152,'Dormentes','PE'),
  (2605202,'Escada','PE'),
  (2605301,'Exu','PE'),
  (2605400,'Feira Nova','PE'),
  (2605459,'Fernando de Noronha','PE'),
  (2605509,'Ferreiros','PE'),
  (2605608,'Flores','PE'),
  (2605707,'Floresta','PE'),
  (2605806,'Frei Miguelinho','PE'),
  (2605905,'Gameleira','PE'),
  (2606002,'Garanhuns','PE'),
  (2606101,'Glria do Goit','PE'),
  (2606200,'Goiana','PE'),
  (2606309,'Granito','PE'),
  (2606408,'Gravat','PE'),
  (2606507,'Iati','PE'),
  (2606606,'Ibimirim','PE'),
  (2606705,'Ibirajuba','PE'),
  (2606804,'Igarassu','PE'),
  (2606903,'Iguaraci','PE'),
  (2607000,'Inaj','PE'),
  (2607109,'Ingazeira','PE'),
  (2607208,'Ipojuca','PE'),
  (2607307,'Ipubi','PE'),
  (2607406,'Itacuruba','PE'),
  (2607505,'Itaba','PE'),
  (2607604,'Ilha de Itamarac','PE'),
  (2607653,'Itamb','PE'),
  (2607703,'Itapetim','PE'),
  (2607752,'Itapissuma','PE'),
  (2607802,'Itaquitinga','PE'),
  (2607901,'Jaboato dos Guararapes','PE'),
  (2607950,'Jaqueira','PE'),
  (2608008,'Jataba','PE'),
  (2608057,'Jatob','PE'),
  (2608107,'Joo Alfredo','PE'),
  (2608206,'Joaquim Nabuco','PE'),
  (2608255,'Jucati','PE'),
  (2608305,'Jupi','PE'),
  (2608404,'Jurema','PE'),
  (2608453,'Lagoa do Carro','PE'),
  (2608503,'LAGOA DE ITAENGA','PE'),
  (2608602,'Lagoa do Ouro','PE'),
  (2608701,'Lagoa dos Gatos','PE'),
  (2608750,'Lagoa Grande','PE'),
  (2608800,'Lajedo','PE'),
  (2608909,'Limoeiro','PE'),
  (2609006,'Macaparana','PE'),
  (2609105,'Machados','PE'),
  (2609154,'Manari','PE'),
  (2609204,'Maraial','PE'),
  (2609303,'Mirandiba','PE'),
  (2609402,'Moreno','PE'),
  (2609501,'Nazar da Mata','PE'),
  (2609600,'Olinda','PE'),
  (2609709,'Orob','PE'),
  (2609808,'Oroc','PE'),
  (2609907,'Ouricuri','PE'),
  (2610004,'Palmares','PE'),
  (2610103,'Palmeirina','PE'),
  (2610202,'Panelas','PE'),
  (2610301,'Paranatama','PE'),
  (2610400,'Parnamirim','PE'),
  (2610509,'Passira','PE'),
  (2610608,'Paudalho','PE'),
  (2610707,'Paulista','PE'),
  (2610806,'Pedra','PE'),
  (2610905,'Pesqueira','PE'),
  (2611002,'Petrolndia','PE'),
  (2611101,'Petrolina','PE'),
  (2611200,'Poo','PE'),
  (2611309,'Pombos','PE'),
  (2611408,'Primavera','PE'),
  (2611507,'Quipap','PE'),
  (2611533,'Quixaba','PE'),
  (2611606,'Recife','PE'),
  (2611705,'Riacho das Almas','PE'),
  (2611804,'Ribeiro','PE'),
  (2611903,'Rio Formoso','PE'),
  (2612000,'Sair','PE'),
  (2612109,'Salgadinho','PE'),
  (2612208,'Salgueiro','PE'),
  (2612307,'Salo','PE'),
  (2612406,'Sanhar','PE'),
  (2612455,'Santa Cruz','PE'),
  (2612471,'Santa Cruz da Baixa Verde','PE'),
  (2612505,'Santa Cruz do Capibaribe','PE'),
  (2612554,'Santa Filomena','PE'),
  (2612604,'Santa Maria da Boa Vista','PE'),
  (2612703,'Santa Maria do Cambuc','PE'),
  (2612802,'Santa Terezinha','PE'),
  (2612901,'So Benedito do Sul','PE'),
  (2613008,'So Bento do Una','PE'),
  (2613107,'So Caetano','PE'),
  (2613206,'So Joo','PE'),
  (2613305,'So Joaquim do Monte','PE'),
  (2613404,'So Jos da Coroa Grande','PE'),
  (2613503,'So Jos do Belmonte','PE'),
  (2613602,'So Jos do Egito','PE'),
  (2613701,'So Loureno da Mata','PE'),
  (2613800,'So Vicente Ferrer','PE'),
  (2613909,'Serra Talhada','PE'),
  (2614006,'Serrita','PE'),
  (2614105,'Sertnia','PE'),
  (2614204,'Sirinham','PE'),
  (2614303,'Moreilndia','PE'),
  (2614402,'Solido','PE'),
  (2614501,'Surubim','PE'),
  (2614600,'Tabira','PE'),
  (2614709,'Tacaimb','PE'),
  (2614808,'Tacaratu','PE'),
  (2614857,'Tamandar','PE'),
  (2615003,'Taquaritinga do Norte','PE'),
  (2615102,'Terezinha','PE'),
  (2615201,'Terra Nova','PE'),
  (2615300,'Timbaba','PE'),
  (2615409,'Toritama','PE'),
  (2615508,'Tracunham','PE'),
  (2615607,'Trindade','PE'),
  (2615706,'Triunfo','PE'),
  (2615805,'Tupanatinga','PE'),
  (2615904,'Tuparetama','PE'),
  (2616001,'Venturosa','PE'),
  (2616100,'Verdejante','PE'),
  (2616183,'Vertente do Lrio','PE'),
  (2616209,'Vertentes','PE'),
  (2616308,'Vicncia','PE'),
  (2616407,'Vitria de Santo Anto','PE'),
  (2616506,'Xexu','PE'),
  (2700102,'gua Branca','AL'),
  (2700201,'Anadia','AL'),
  (2700300,'Arapiraca','AL'),
  (2700409,'Atalaia','AL'),
  (2700508,'Barra de Santo Antnio','AL'),
  (2700607,'Barra de So Miguel','AL'),
  (2700706,'Batalha','AL'),
  (2700805,'Belm','AL'),
  (2700904,'Belo Monte','AL'),
  (2701001,'Boca da Mata','AL'),
  (2701100,'Branquinha','AL'),
  (2701209,'Cacimbinhas','AL'),
  (2701308,'Cajueiro','AL'),
  (2701357,'Campestre','AL'),
  (2701407,'Campo Alegre','AL'),
  (2701506,'Campo Grande','AL'),
  (2701605,'Canapi','AL'),
  (2701704,'Capela','AL'),
  (2701803,'Carneiros','AL'),
  (2701902,'Ch Preta','AL'),
  (2702009,'Coit do Nia','AL'),
  (2702108,'Colnia Leopoldina','AL'),
  (2702207,'Coqueiro Seco','AL'),
  (2702306,'Coruripe','AL'),
  (2702355,'Crabas','AL'),
  (2702405,'Delmiro Gouveia','AL'),
  (2702504,'Dois Riachos','AL'),
  (2702553,'Estrela de Alagoas','AL'),
  (2702603,'Feira Grande','AL'),
  (2702702,'Feliz Deserto','AL'),
  (2702801,'Flexeiras','AL'),
  (2702900,'Girau do Ponciano','AL'),
  (2703007,'Ibateguara','AL'),
  (2703106,'Igaci','AL'),
  (2703205,'Igreja Nova','AL'),
  (2703304,'Inhapi','AL'),
  (2703403,'Jacar dos Homens','AL'),
  (2703502,'Jacupe','AL'),
  (2703601,'Japaratinga','AL'),
  (2703700,'Jaramataia','AL'),
  (2703759,'Jequi da Praia','AL'),
  (2703809,'Joaquim Gomes','AL'),
  (2703908,'Jundi','AL'),
  (2704005,'Junqueiro','AL'),
  (2704104,'Lagoa da Canoa','AL'),
  (2704203,'Limoeiro de Anadia','AL'),
  (2704302,'Macei','AL'),
  (2704401,'Major Isidoro','AL'),
  (2704500,'Maragogi','AL'),
  (2704609,'Maravilha','AL'),
  (2704708,'Marechal Deodoro','AL'),
  (2704807,'Maribondo','AL'),
  (2704906,'Mar Vermelho','AL'),
  (2705002,'Mata Grande','AL'),
  (2705101,'Matriz de Camaragibe','AL'),
  (2705200,'Messias','AL'),
  (2705309,'Minador do Negro','AL'),
  (2705408,'Monteirpolis','AL'),
  (2705507,'Murici','AL'),
  (2705606,'Novo Lino','AL'),
  (2705705,'Olho d''gua das Flores','AL'),
  (2705804,'Olho d''gua do Casado','AL'),
  (2705903,'Olho d''gua Grande','AL'),
  (2706000,'Olivena','AL'),
  (2706109,'Ouro Branco','AL'),
  (2706208,'Palestina','AL'),
  (2706307,'Palmeira dos ndios','AL'),
  (2706406,'Po de Acar','AL'),
  (2706422,'Pariconha','AL'),
  (2706448,'Paripueira','AL'),
  (2706505,'Passo de Camaragibe','AL'),
  (2706604,'Paulo Jacinto','AL'),
  (2706703,'Penedo','AL'),
  (2706802,'Piaabuu','AL'),
  (2706901,'Pilar','AL'),
  (2707008,'Pindoba','AL'),
  (2707107,'Piranhas','AL'),
  (2707206,'Poo das Trincheiras','AL'),
  (2707305,'Porto Calvo','AL'),
  (2707404,'Porto de Pedras','AL'),
  (2707503,'Porto Real do Colgio','AL'),
  (2707602,'Quebrangulo','AL'),
  (2707701,'Rio Largo','AL'),
  (2707800,'Roteiro','AL'),
  (2707909,'Santa Luzia do Norte','AL'),
  (2708006,'Santana do Ipanema','AL'),
  (2708105,'Santana do Munda','AL'),
  (2708204,'So Brs','AL'),
  (2708303,'So Jos da Laje','AL'),
  (2708402,'So Jos da Tapera','AL'),
  (2708501,'So Lus do Quitunde','AL'),
  (2708600,'So Miguel dos Campos','AL'),
  (2708709,'So Miguel dos Milagres','AL'),
  (2708808,'So Sebastio','AL'),
  (2708907,'Satuba','AL'),
  (2708956,'Senador Rui Palmeira','AL'),
  (2709004,'Tanque d''Arca','AL'),
  (2709103,'Taquarana','AL'),
  (2709152,'Teotnio Vilela','AL'),
  (2709202,'Traipu','AL'),
  (2709301,'Unio dos Palmares','AL'),
  (2709400,'Viosa','AL'),
  (2800100,'Amparo de So Francisco','SE'),
  (2800209,'Aquidab','SE'),
  (2800308,'Aracaju','SE'),
  (2800407,'Arau','SE'),
  (2800506,'Areia Branca','SE'),
  (2800605,'Barra dos Coqueiros','SE'),
  (2800670,'Boquim','SE'),
  (2800704,'Brejo Grande','SE'),
  (2801009,'Campo do Brito','SE'),
  (2801108,'Canhoba','SE'),
  (2801207,'Canind de So Francisco','SE'),
  (2801306,'Capela','SE'),
  (2801405,'Carira','SE'),
  (2801504,'Carmpolis','SE'),
  (2801603,'Cedro de So Joo','SE'),
  (2801702,'Cristinpolis','SE'),
  (2801900,'Cumbe','SE'),
  (2802007,'Divina Pastora','SE'),
  (2802106,'Estncia','SE'),
  (2802205,'Feira Nova','SE'),
  (2802304,'Frei Paulo','SE'),
  (2802403,'Gararu','SE'),
  (2802502,'General Maynard','SE'),
  (2802601,'Gracho Cardoso','SE'),
  (2802700,'Ilha das Flores','SE'),
  (2802809,'Indiaroba','SE'),
  (2802908,'Itabaiana','SE'),
  (2803005,'Itabaianinha','SE'),
  (2803104,'Itabi','SE'),
  (2803203,'Itaporanga d''Ajuda','SE'),
  (2803302,'Japaratuba','SE'),
  (2803401,'Japoat','SE'),
  (2803500,'Lagarto','SE'),
  (2803609,'Laranjeiras','SE'),
  (2803708,'Macambira','SE'),
  (2803807,'Malhada dos Bois','SE'),
  (2803906,'Malhador','SE'),
  (2804003,'Maruim','SE'),
  (2804102,'Moita Bonita','SE'),
  (2804201,'Monte Alegre de Sergipe','SE'),
  (2804300,'Muribeca','SE'),
  (2804409,'Nepolis','SE'),
  (2804458,'Nossa Senhora Aparecida','SE'),
  (2804508,'Nossa Senhora da Glria','SE'),
  (2804607,'Nossa Senhora das Dores','SE'),
  (2804706,'Nossa Senhora de Lourdes','SE'),
  (2804805,'Nossa Senhora do Socorro','SE'),
  (2804904,'Pacatuba','SE'),
  (2805000,'Pedra Mole','SE'),
  (2805109,'Pedrinhas','SE'),
  (2805208,'Pinho','SE'),
  (2805307,'Pirambu','SE'),
  (2805406,'Poo Redondo','SE'),
  (2805505,'Poo Verde','SE'),
  (2805604,'Porto da Folha','SE'),
  (2805703,'Propri','SE'),
  (2805802,'Riacho do Dantas','SE'),
  (2805901,'Riachuelo','SE'),
  (2806008,'Ribeirpolis','SE'),
  (2806107,'Rosrio do Catete','SE'),
  (2806206,'Salgado','SE'),
  (2806305,'Santa Luzia do Itanhy','SE'),
  (2806404,'Santana do So Francisco','SE'),
  (2806503,'Santa Rosa de Lima','SE'),
  (2806602,'Santo Amaro das Brotas','SE'),
  (2806701,'So Cristvo','SE'),
  (2806800,'So Domingos','SE'),
  (2806909,'So Francisco','SE'),
  (2807006,'So Miguel do Aleixo','SE'),
  (2807105,'Simo Dias','SE'),
  (2807204,'Siriri','SE'),
  (2807303,'Telha','SE'),
  (2807402,'Tobias Barreto','SE'),
  (2807501,'Tomar do Geru','SE'),
  (2807600,'Umbaba','SE'),
  (2900108,'Abara','BA'),
  (2900207,'Abar','BA'),
  (2900306,'Acajutiba','BA'),
  (2900355,'Adustina','BA'),
  (2900405,'gua Fria','BA'),
  (2900504,'rico Cardoso','BA'),
  (2900603,'Aiquara','BA'),
  (2900702,'Alagoinhas','BA'),
  (2900801,'Alcobaa','BA'),
  (2900900,'Almadina','BA'),
  (2901007,'Amargosa','BA'),
  (2901106,'Amlia Rodrigues','BA'),
  (2901155,'Amrica Dourada','BA'),
  (2901205,'Anag','BA'),
  (2901304,'Andara','BA'),
  (2901353,'Andorinha','BA'),
  (2901403,'Angical','BA'),
  (2901502,'Anguera','BA'),
  (2901601,'Antas','BA'),
  (2901700,'Antnio Cardoso','BA'),
  (2901809,'Antnio Gonalves','BA'),
  (2901908,'Apor','BA'),
  (2901957,'Apuarema','BA'),
  (2902005,'Aracatu','BA'),
  (2902054,'Araas','BA'),
  (2902104,'Araci','BA'),
  (2902203,'Aramari','BA'),
  (2902252,'Arataca','BA'),
  (2902302,'Aratupe','BA'),
  (2902401,'Aurelino Leal','BA'),
  (2902500,'Baianpolis','BA'),
  (2902609,'Baixa Grande','BA'),
  (2902658,'Banza','BA'),
  (2902708,'Barra','BA'),
  (2902807,'Barra da Estiva','BA'),
  (2902906,'Barra do Choa','BA'),
  (2903003,'Barra do Mendes','BA'),
  (2903102,'Barra do Rocha','BA'),
  (2903201,'Barreiras','BA'),
  (2903235,'Barro Alto','BA'),
  (2903276,'Barrocas','BA'),
  (2903300,'Barro Preto','BA'),
  (2903409,'Belmonte','BA'),
  (2903508,'Belo Campo','BA'),
  (2903607,'Biritinga','BA'),
  (2903706,'Boa Nova','BA'),
  (2903805,'Boa Vista do Tupim','BA'),
  (2903904,'Bom Jesus da Lapa','BA'),
  (2903953,'Bom Jesus da Serra','BA'),
  (2904001,'Boninal','BA'),
  (2904050,'Bonito','BA'),
  (2904100,'Boquira','BA'),
  (2904209,'Botupor','BA'),
  (2904308,'Brejes','BA'),
  (2904407,'Brejolndia','BA'),
  (2904506,'Brotas de Macabas','BA'),
  (2904605,'Brumado','BA'),
  (2904704,'Buerarema','BA'),
  (2904753,'Buritirama','BA'),
  (2904803,'Caatiba','BA'),
  (2904852,'Cabaceiras do Paraguau','BA'),
  (2904902,'Cachoeira','BA'),
  (2905008,'Cacul','BA'),
  (2905107,'Cam','BA'),
  (2905156,'Caetanos','BA'),
  (2905206,'Caetit','BA'),
  (2905305,'Cafarnaum','BA'),
  (2905404,'Cairu','BA'),
  (2905503,'Caldeiro Grande','BA'),
  (2905602,'Camacan','BA'),
  (2905701,'Camaari','BA'),
  (2905800,'Camamu','BA'),
  (2905909,'Campo Alegre de Lourdes','BA'),
  (2906006,'Campo Formoso','BA'),
  (2906105,'Canpolis','BA'),
  (2906204,'Canarana','BA'),
  (2906303,'Canavieiras','BA'),
  (2906402,'Candeal','BA'),
  (2906501,'Candeias','BA'),
  (2906600,'Candiba','BA'),
  (2906709,'Cndido Sales','BA'),
  (2906808,'Cansano','BA'),
  (2906824,'Canudos','BA'),
  (2906857,'Capela do Alto Alegre','BA'),
  (2906873,'Capim Grosso','BA'),
  (2906899,'Carabas','BA'),
  (2906907,'Caravelas','BA'),
  (2907004,'Cardeal da Silva','BA'),
  (2907103,'Carinhanha','BA'),
  (2907202,'Casa Nova','BA'),
  (2907301,'Castro Alves','BA'),
  (2907400,'Catolndia','BA'),
  (2907509,'Catu','BA'),
  (2907558,'Caturama','BA'),
  (2907608,'Central','BA'),
  (2907707,'Chorroch','BA'),
  (2907806,'Ccero Dantas','BA'),
  (2907905,'Cip','BA'),
  (2908002,'Coaraci','BA'),
  (2908101,'Cocos','BA'),
  (2908200,'Conceio da Feira','BA'),
  (2908309,'Conceio do Almeida','BA'),
  (2908408,'Conceio do Coit','BA'),
  (2908507,'Conceio do Jacupe','BA'),
  (2908606,'Conde','BA'),
  (2908705,'Condeba','BA'),
  (2908804,'Contendas do Sincor','BA'),
  (2908903,'Corao de Maria','BA'),
  (2909000,'Cordeiros','BA'),
  (2909109,'Coribe','BA'),
  (2909208,'Coronel Joo S','BA'),
  (2909307,'Correntina','BA'),
  (2909406,'Cotegipe','BA'),
  (2909505,'Cravolndia','BA'),
  (2909604,'Crispolis','BA'),
  (2909703,'Cristpolis','BA'),
  (2909802,'Cruz das Almas','BA'),
  (2909901,'Cura','BA'),
  (2910008,'Drio Meira','BA'),
  (2910057,'Dias d''vila','BA'),
  (2910107,'Dom Baslio','BA'),
  (2910206,'Dom Macedo Costa','BA'),
  (2910305,'Elsio Medrado','BA'),
  (2910404,'Encruzilhada','BA'),
  (2910503,'Entre Rios','BA'),
  (2910602,'Esplanada','BA'),
  (2910701,'Euclides da Cunha','BA'),
  (2910727,'Eunpolis','BA'),
  (2910750,'Ftima','BA'),
  (2910776,'Feira da Mata','BA'),
  (2910800,'Feira de Santana','BA'),
  (2910859,'Filadlfia','BA'),
  (2910909,'Firmino Alves','BA'),
  (2911006,'Floresta Azul','BA'),
  (2911105,'Formosa do Rio Preto','BA'),
  (2911204,'Gandu','BA'),
  (2911253,'Gavio','BA'),
  (2911303,'Gentio do Ouro','BA'),
  (2911402,'Glria','BA'),
  (2911501,'Gongogi','BA'),
  (2911600,'Governador Mangabeira','BA'),
  (2911659,'Guajeru','BA'),
  (2911709,'Guanambi','BA'),
  (2911808,'Guaratinga','BA'),
  (2911857,'Helipolis','BA'),
  (2911907,'Iau','BA'),
  (2912004,'Ibiassuc','BA'),
  (2912103,'Ibicara','BA'),
  (2912202,'Ibicoara','BA'),
  (2912301,'Ibicu','BA'),
  (2912400,'Ibipeba','BA'),
  (2912509,'Ibipitanga','BA'),
  (2912608,'Ibiquera','BA'),
  (2912707,'Ibirapitanga','BA'),
  (2912806,'Ibirapu','BA'),
  (2912905,'Ibirataia','BA'),
  (2913002,'Ibitiara','BA'),
  (2913101,'Ibitit','BA'),
  (2913200,'Ibotirama','BA'),
  (2913309,'Ichu','BA'),
  (2913408,'Igapor','BA'),
  (2913457,'Igrapina','BA'),
  (2913507,'Igua','BA'),
  (2913606,'Ilhus','BA'),
  (2913705,'Inhambupe','BA'),
  (2913804,'Ipecaet','BA'),
  (2913903,'Ipia','BA'),
  (2914000,'Ipir','BA'),
  (2914109,'Ipupiara','BA'),
  (2914208,'Irajuba','BA'),
  (2914307,'Iramaia','BA'),
  (2914406,'Iraquara','BA'),
  (2914505,'Irar','BA'),
  (2914604,'Irec','BA');

INSERT INTO municipios (municipio_id, municipio_nome, estado_sigla) VALUES 
  (2914653,'Itabela','BA'),
  (2914703,'Itaberaba','BA'),
  (2914802,'Itabuna','BA'),
  (2914901,'Itacar','BA'),
  (2915007,'Itaet','BA'),
  (2915106,'Itagi','BA'),
  (2915205,'Itagib','BA'),
  (2915304,'Itagimirim','BA'),
  (2915353,'Itaguau da Bahia','BA'),
  (2915403,'Itaju do Colnia','BA'),
  (2915502,'Itajupe','BA'),
  (2915601,'Itamaraju','BA'),
  (2915700,'Itamari','BA'),
  (2915809,'Itamb','BA'),
  (2915908,'Itanagra','BA'),
  (2916005,'Itanhm','BA'),
  (2916104,'Itaparica','BA'),
  (2916203,'Itap','BA'),
  (2916302,'Itapebi','BA'),
  (2916401,'Itapetinga','BA'),
  (2916500,'Itapicuru','BA'),
  (2916609,'Itapitanga','BA'),
  (2916708,'Itaquara','BA'),
  (2916807,'Itarantim','BA'),
  (2916856,'Itatim','BA'),
  (2916906,'Itiruu','BA'),
  (2917003,'Itiba','BA'),
  (2917102,'Itoror','BA'),
  (2917201,'Ituau','BA'),
  (2917300,'Ituber','BA'),
  (2917334,'Iui','BA'),
  (2917359,'Jaborandi','BA'),
  (2917409,'Jacaraci','BA'),
  (2917508,'Jacobina','BA'),
  (2917607,'Jaguaquara','BA'),
  (2917706,'Jaguarari','BA'),
  (2917805,'Jaguaripe','BA'),
  (2917904,'Jandara','BA'),
  (2918001,'Jequi','BA'),
  (2918100,'Jeremoabo','BA'),
  (2918209,'Jiquiri','BA'),
  (2918308,'Jitana','BA'),
  (2918357,'Joo Dourado','BA'),
  (2918407,'Juazeiro','BA'),
  (2918456,'Jucuruu','BA'),
  (2918506,'Jussara','BA'),
  (2918555,'Jussari','BA'),
  (2918605,'Jussiape','BA'),
  (2918704,'Lafaiete Coutinho','BA'),
  (2918753,'Lagoa Real','BA'),
  (2918803,'Laje','BA'),
  (2918902,'Lajedo','BA'),
  (2919009,'Lajedinho','BA'),
  (2919058,'Lajedo do Tabocal','BA'),
  (2919108,'Lamaro','BA'),
  (2919157,'Lapo','BA'),
  (2919207,'Lauro de Freitas','BA'),
  (2919306,'Lenis','BA'),
  (2919405,'Licnio de Almeida','BA'),
  (2919504,'Livramento de Nossa Senhora','BA'),
  (2919553,'Lus Eduardo Magalhes','BA'),
  (2919603,'Macajuba','BA'),
  (2919702,'Macarani','BA'),
  (2919801,'Macabas','BA'),
  (2919900,'Macurur','BA'),
  (2919926,'Madre de Deus','BA'),
  (2919959,'Maetinga','BA'),
  (2920007,'Maiquinique','BA'),
  (2920106,'Mairi','BA'),
  (2920205,'Malhada','BA'),
  (2920304,'Malhada de Pedras','BA'),
  (2920403,'Manoel Vitorino','BA'),
  (2920452,'Mansido','BA'),
  (2920502,'Maracs','BA'),
  (2920601,'Maragogipe','BA'),
  (2920700,'Mara','BA'),
  (2920809,'Marcionlio Souza','BA'),
  (2920908,'Mascote','BA'),
  (2921005,'Mata de So Joo','BA'),
  (2921054,'Matina','BA'),
  (2921104,'Medeiros Neto','BA'),
  (2921203,'Miguel Calmon','BA'),
  (2921302,'Milagres','BA'),
  (2921401,'Mirangaba','BA'),
  (2921450,'Mirante','BA'),
  (2921500,'Monte Santo','BA'),
  (2921609,'Morpar','BA'),
  (2921708,'Morro do Chapu','BA'),
  (2921807,'Mortugaba','BA'),
  (2921906,'Mucug','BA'),
  (2922003,'Mucuri','BA'),
  (2922052,'Mulungu do Morro','BA'),
  (2922102,'Mundo Novo','BA'),
  (2922201,'Muniz Ferreira','BA'),
  (2922250,'Muqum de So Francisco','BA'),
  (2922300,'Muritiba','BA'),
  (2922409,'Mutupe','BA'),
  (2922508,'Nazar','BA'),
  (2922607,'Nilo Peanha','BA'),
  (2922656,'Nordestina','BA'),
  (2922706,'Nova Cana','BA'),
  (2922730,'Nova Ftima','BA'),
  (2922755,'Nova Ibi','BA'),
  (2922805,'Nova Itarana','BA'),
  (2922854,'Nova Redeno','BA'),
  (2922904,'Nova Soure','BA'),
  (2923001,'Nova Viosa','BA'),
  (2923035,'Novo Horizonte','BA'),
  (2923050,'Novo Triunfo','BA'),
  (2923100,'Olindina','BA'),
  (2923209,'Oliveira dos Brejinhos','BA'),
  (2923308,'Ouriangas','BA'),
  (2923357,'Ourolndia','BA'),
  (2923407,'Palmas de Monte Alto','BA'),
  (2923506,'Palmeiras','BA'),
  (2923605,'Paramirim','BA'),
  (2923704,'Paratinga','BA'),
  (2923803,'Paripiranga','BA'),
  (2923902,'Pau Brasil','BA'),
  (2924009,'Paulo Afonso','BA'),
  (2924058,'P de Serra','BA'),
  (2924108,'Pedro','BA'),
  (2924207,'Pedro Alexandre','BA'),
  (2924306,'Piat','BA'),
  (2924405,'Pilo Arcado','BA'),
  (2924504,'Pinda','BA'),
  (2924603,'Pindobau','BA'),
  (2924652,'Pintadas','BA'),
  (2924678,'Pira do Norte','BA'),
  (2924702,'Pirip','BA'),
  (2924801,'Piritiba','BA'),
  (2924900,'Planaltino','BA'),
  (2925006,'Planalto','BA'),
  (2925105,'Poes','BA'),
  (2925204,'Pojuca','BA'),
  (2925253,'Ponto Novo','BA'),
  (2925303,'Porto Seguro','BA'),
  (2925402,'Potiragu','BA'),
  (2925501,'Prado','BA'),
  (2925600,'Presidente Dutra','BA'),
  (2925709,'Presidente Jnio Quadros','BA'),
  (2925758,'Presidente Tancredo Neves','BA'),
  (2925808,'Queimadas','BA'),
  (2925907,'Quijingue','BA'),
  (2925931,'Quixabeira','BA'),
  (2925956,'Rafael Jambeiro','BA'),
  (2926004,'Remanso','BA'),
  (2926103,'Retirolndia','BA'),
  (2926202,'Riacho das Neves','BA'),
  (2926301,'Riacho do Jacupe','BA'),
  (2926400,'Riacho de Santana','BA'),
  (2926509,'Ribeira do Amparo','BA'),
  (2926608,'Ribeira do Pombal','BA'),
  (2926657,'Ribeiro do Largo','BA'),
  (2926707,'Rio de Contas','BA'),
  (2926806,'Rio do Antnio','BA'),
  (2926905,'Rio do Pires','BA'),
  (2927002,'Rio Real','BA'),
  (2927101,'Rodelas','BA'),
  (2927200,'Ruy Barbosa','BA'),
  (2927309,'Salinas da Margarida','BA'),
  (2927408,'Salvador','BA'),
  (2927507,'Santa Brbara','BA'),
  (2927606,'Santa Brgida','BA'),
  (2927705,'Santa Cruz Cabrlia','BA'),
  (2927804,'Santa Cruz da Vitria','BA'),
  (2927903,'Santa Ins','BA'),
  (2928000,'Santaluz','BA'),
  (2928059,'Santa Luzia','BA'),
  (2928109,'Santa Maria da Vitria','BA'),
  (2928208,'Santana','BA'),
  (2928307,'Santanpolis','BA'),
  (2928406,'Santa Rita de Cssia','BA'),
  (2928505,'Santa Teresinha','BA'),
  (2928604,'Santo Amaro','BA'),
  (2928703,'Santo Antnio de Jesus','BA'),
  (2928802,'Santo Estvo','BA'),
  (2928901,'So Desidrio','BA'),
  (2928950,'So Domingos','BA'),
  (2929008,'So Flix','BA'),
  (2929057,'So Flix do Coribe','BA'),
  (2929107,'So Felipe','BA'),
  (2929206,'So Francisco do Conde','BA'),
  (2929255,'So Gabriel','BA'),
  (2929305,'So Gonalo dos Campos','BA'),
  (2929354,'So Jos da Vitria','BA'),
  (2929370,'So Jos do Jacupe','BA'),
  (2929404,'So Miguel das Matas','BA'),
  (2929503,'So Sebastio do Pass','BA'),
  (2929602,'Sapeau','BA'),
  (2929701,'Stiro Dias','BA'),
  (2929750,'Saubara','BA'),
  (2929800,'Sade','BA'),
  (2929909,'Seabra','BA'),
  (2930006,'Sebastio Laranjeiras','BA'),
  (2930105,'Senhor do Bonfim','BA'),
  (2930154,'Serra do Ramalho','BA'),
  (2930204,'Sento S','BA'),
  (2930303,'Serra Dourada','BA'),
  (2930402,'Serra Preta','BA'),
  (2930501,'Serrinha','BA'),
  (2930600,'Serrolndia','BA'),
  (2930709,'Simes Filho','BA'),
  (2930758,'Stio do Mato','BA'),
  (2930766,'Stio do Quinto','BA'),
  (2930774,'Sobradinho','BA'),
  (2930808,'Souto Soares','BA'),
  (2930907,'Tabocas do Brejo Velho','BA'),
  (2931004,'Tanhau','BA'),
  (2931053,'Tanque Novo','BA'),
  (2931103,'Tanquinho','BA'),
  (2931202,'Tapero','BA'),
  (2931301,'Tapiramut','BA'),
  (2931350,'Teixeira de Freitas','BA'),
  (2931400,'Teodoro Sampaio','BA'),
  (2931509,'Teofilndia','BA'),
  (2931608,'Teolndia','BA'),
  (2931707,'Terra Nova','BA'),
  (2931806,'Tremedal','BA'),
  (2931905,'Tucano','BA'),
  (2932002,'Uau','BA'),
  (2932101,'Ubara','BA'),
  (2932200,'Ubaitaba','BA'),
  (2932309,'Ubat','BA'),
  (2932408,'Uiba','BA'),
  (2932457,'Umburanas','BA'),
  (2932507,'Una','BA'),
  (2932606,'Urandi','BA'),
  (2932705,'Uruuca','BA'),
  (2932804,'Utinga','BA'),
  (2932903,'Valena','BA'),
  (2933000,'Valente','BA'),
  (2933059,'Vrzea da Roa','BA'),
  (2933109,'Vrzea do Poo','BA'),
  (2933158,'Vrzea Nova','BA'),
  (2933174,'Varzedo','BA'),
  (2933208,'Vera Cruz','BA'),
  (2933257,'Vereda','BA'),
  (2933307,'Vitria da Conquista','BA'),
  (2933406,'Wagner','BA'),
  (2933455,'Wanderley','BA'),
  (2933505,'Wenceslau Guimares','BA'),
  (2933604,'Xique-Xique','BA'),
  (3100104,'Abadia dos Dourados','MG'),
  (3100203,'Abaet','MG'),
  (3100302,'Abre Campo','MG'),
  (3100401,'Acaiaca','MG'),
  (3100500,'Aucena','MG'),
  (3100609,'gua Boa','MG'),
  (3100708,'gua Comprida','MG'),
  (3100807,'Aguanil','MG'),
  (3100906,'guas Formosas','MG'),
  (3101003,'guas Vermelhas','MG'),
  (3101102,'Aimors','MG'),
  (3101201,'Aiuruoca','MG'),
  (3101300,'Alagoa','MG'),
  (3101409,'Albertina','MG'),
  (3101508,'Alm Paraba','MG'),
  (3101607,'Alfenas','MG'),
  (3101631,'Alfredo Vasconcelos','MG'),
  (3101706,'Almenara','MG'),
  (3101805,'Alpercata','MG'),
  (3101904,'Alpinpolis','MG'),
  (3102001,'Alterosa','MG'),
  (3102050,'Alto Capara','MG'),
  (3102100,'Alto Rio Doce','MG'),
  (3102209,'Alvarenga','MG'),
  (3102308,'Alvinpolis','MG'),
  (3102407,'Alvorada de Minas','MG'),
  (3102506,'Amparo do Serra','MG'),
  (3102605,'Andradas','MG'),
  (3102704,'Cachoeira de Paje','MG'),
  (3102803,'Andrelndia','MG'),
  (3102852,'Angelndia','MG'),
  (3102902,'Antnio Carlos','MG'),
  (3103009,'Antnio Dias','MG'),
  (3103108,'Antnio Prado de Minas','MG'),
  (3103207,'Araa','MG'),
  (3103306,'Aracitaba','MG'),
  (3103405,'Araua','MG'),
  (3103504,'Araguari','MG'),
  (3103603,'Arantina','MG'),
  (3103702,'Araponga','MG'),
  (3103751,'Arapor','MG'),
  (3103801,'Arapu','MG'),
  (3103900,'Arajos','MG'),
  (3104007,'Arax','MG'),
  (3104106,'Arceburgo','MG'),
  (3104205,'Arcos','MG'),
  (3104304,'Areado','MG'),
  (3104403,'Argirita','MG'),
  (3104452,'Aricanduva','MG'),
  (3104502,'Arinos','MG'),
  (3104601,'Astolfo Dutra','MG'),
  (3104700,'Atalia','MG'),
  (3104809,'Augusto de Lima','MG'),
  (3104908,'Baependi','MG'),
  (3105004,'Baldim','MG'),
  (3105103,'Bambu','MG'),
  (3105202,'Bandeira','MG'),
  (3105301,'Bandeira do Sul','MG'),
  (3105400,'Baro de Cocais','MG'),
  (3105509,'Baro de Monte Alto','MG'),
  (3105608,'Barbacena','MG'),
  (3105707,'Barra Longa','MG'),
  (3105905,'Barroso','MG'),
  (3106002,'Bela Vista de Minas','MG'),
  (3106101,'Belmiro Braga','MG'),
  (3106200,'Belo Horizonte','MG'),
  (3106309,'Belo Oriente','MG'),
  (3106408,'Belo Vale','MG'),
  (3106507,'Berilo','MG'),
  (3106606,'Bertpolis','MG'),
  (3106655,'Berizal','MG'),
  (3106705,'Betim','MG'),
  (3106804,'Bias Fortes','MG'),
  (3106903,'Bicas','MG'),
  (3107000,'Biquinhas','MG'),
  (3107109,'Boa Esperana','MG'),
  (3107208,'Bocaina de Minas','MG'),
  (3107307,'Bocaiva','MG'),
  (3107406,'Bom Despacho','MG'),
  (3107505,'Bom Jardim de Minas','MG'),
  (3107604,'Bom Jesus da Penha','MG'),
  (3107703,'Bom Jesus do Amparo','MG'),
  (3107802,'Bom Jesus do Galho','MG'),
  (3107901,'Bom Repouso','MG'),
  (3108008,'Bom Sucesso','MG'),
  (3108107,'Bonfim','MG'),
  (3108206,'Bonfinpolis de Minas','MG'),
  (3108255,'Bonito de Minas','MG'),
  (3108305,'Borda da Mata','MG'),
  (3108404,'Botelhos','MG'),
  (3108503,'Botumirim','MG'),
  (3108552,'Brasilndia de Minas','MG'),
  (3108602,'Braslia de Minas','MG'),
  (3108701,'Brs Pires','MG'),
  (3108800,'Branas','MG'),
  (3108909,'Braspolis','MG'),
  (3109006,'Brumadinho','MG'),
  (3109105,'Bueno Brando','MG'),
  (3109204,'Buenpolis','MG'),
  (3109253,'Bugre','MG'),
  (3109303,'Buritis','MG'),
  (3109402,'Buritizeiro','MG'),
  (3109451,'Cabeceira Grande','MG'),
  (3109501,'Cabo Verde','MG'),
  (3109600,'Cachoeira da Prata','MG'),
  (3109709,'Cachoeira de Minas','MG'),
  (3109808,'Cachoeira Dourada','MG'),
  (3109907,'Caetanpolis','MG'),
  (3110004,'Caet','MG'),
  (3110103,'Caiana','MG'),
  (3110202,'Cajuri','MG'),
  (3110301,'Caldas','MG'),
  (3110400,'Camacho','MG'),
  (3110509,'Camanducaia','MG'),
  (3110608,'Cambu','MG'),
  (3110707,'Cambuquira','MG'),
  (3110806,'Campanrio','MG'),
  (3110905,'Campanha','MG'),
  (3111002,'Campestre','MG'),
  (3111101,'Campina Verde','MG'),
  (3111150,'Campo Azul','MG'),
  (3111200,'Campo Belo','MG'),
  (3111309,'Campo do Meio','MG'),
  (3111408,'Campo Florido','MG'),
  (3111507,'Campos Altos','MG'),
  (3111606,'Campos Gerais','MG'),
  (3111705,'Cana','MG'),
  (3111804,'Canpolis','MG'),
  (3111903,'Cana Verde','MG'),
  (3112000,'Candeias','MG'),
  (3112059,'Cantagalo','MG'),
  (3112109,'Capara','MG'),
  (3112208,'Capela Nova','MG'),
  (3112307,'Capelinha','MG'),
  (3112406,'Capetinga','MG'),
  (3112505,'Capim Branco','MG'),
  (3112604,'Capinpolis','MG'),
  (3112653,'Capito Andrade','MG'),
  (3112703,'Capito Enas','MG'),
  (3112802,'Capitlio','MG'),
  (3112901,'Caputira','MG'),
  (3113008,'Cara','MG'),
  (3113107,'Caranaba','MG'),
  (3113206,'Caranda','MG'),
  (3113305,'Carangola','MG'),
  (3113404,'Caratinga','MG'),
  (3113503,'Carbonita','MG'),
  (3113602,'Careau','MG'),
  (3113701,'Carlos Chagas','MG'),
  (3113800,'Carmsia','MG'),
  (3113909,'Carmo da Cachoeira','MG'),
  (3114006,'Carmo da Mata','MG'),
  (3114105,'Carmo de Minas','MG'),
  (3114204,'Carmo do Cajuru','MG'),
  (3114303,'Carmo do Paranaba','MG'),
  (3114402,'Carmo do Rio Claro','MG'),
  (3114501,'Carmpolis de Minas','MG'),
  (3114550,'Carneirinho','MG'),
  (3114600,'Carrancas','MG'),
  (3114709,'Carvalhpolis','MG'),
  (3114808,'Carvalhos','MG'),
  (3114907,'Casa Grande','MG'),
  (3115003,'Cascalho Rico','MG'),
  (3115102,'Cssia','MG'),
  (3115201,'Conceio da Barra de Minas','MG'),
  (3115300,'Cataguases','MG'),
  (3115359,'Catas Altas','MG'),
  (3115409,'Catas Altas da Noruega','MG'),
  (3115458,'Catuji','MG'),
  (3115474,'Catuti','MG'),
  (3115508,'Caxambu','MG'),
  (3115607,'Cedro do Abaet','MG'),
  (3115706,'Central de Minas','MG'),
  (3115805,'Centralina','MG'),
  (3115904,'Chcara','MG'),
  (3116001,'Chal','MG'),
  (3116100,'Chapada do Norte','MG'),
  (3116159,'Chapada Gacha','MG'),
  (3116209,'Chiador','MG'),
  (3116308,'Cipotnea','MG'),
  (3116407,'Claraval','MG'),
  (3116506,'Claro dos Poes','MG'),
  (3116605,'Cludio','MG'),
  (3116704,'Coimbra','MG'),
  (3116803,'Coluna','MG'),
  (3116902,'Comendador Gomes','MG'),
  (3117009,'Comercinho','MG'),
  (3117108,'Conceio da Aparecida','MG'),
  (3117207,'Conceio das Pedras','MG'),
  (3117306,'Conceio das Alagoas','MG'),
  (3117405,'Conceio de Ipanema','MG'),
  (3117504,'Conceio do Mato Dentro','MG'),
  (3117603,'Conceio do Par','MG'),
  (3117702,'Conceio do Rio Verde','MG'),
  (3117801,'Conceio dos Ouros','MG'),
  (3117836,'Cnego Marinho','MG'),
  (3117876,'Confins','MG'),
  (3117900,'Congonhal','MG'),
  (3118007,'Congonhas','MG'),
  (3118106,'Congonhas do Norte','MG'),
  (3118205,'Conquista','MG'),
  (3118304,'Conselheiro Lafaiete','MG'),
  (3118403,'Conselheiro Pena','MG'),
  (3118502,'Consolao','MG'),
  (3118601,'Contagem','MG'),
  (3118700,'Coqueiral','MG'),
  (3118809,'Corao de Jesus','MG'),
  (3118908,'Cordisburgo','MG'),
  (3119005,'Cordislndia','MG'),
  (3119104,'Corinto','MG'),
  (3119203,'Coroaci','MG'),
  (3119302,'Coromandel','MG'),
  (3119401,'Coronel Fabriciano','MG'),
  (3119500,'Coronel Murta','MG'),
  (3119609,'Coronel Pacheco','MG'),
  (3119708,'Coronel Xavier Chaves','MG'),
  (3119807,'Crrego Danta','MG'),
  (3119906,'Crrego do Bom Jesus','MG'),
  (3119955,'Crrego Fundo','MG'),
  (3120003,'Crrego Novo','MG'),
  (3120102,'Couto de Magalhes de Minas','MG'),
  (3120151,'Crislita','MG'),
  (3120201,'Cristais','MG'),
  (3120300,'Cristlia','MG'),
  (3120409,'Cristiano Otoni','MG'),
  (3120508,'Cristina','MG'),
  (3120607,'Crucilndia','MG'),
  (3120706,'Cruzeiro da Fortaleza','MG'),
  (3120805,'Cruzlia','MG'),
  (3120839,'Cuparaque','MG'),
  (3120870,'Curral de Dentro','MG'),
  (3120904,'Curvelo','MG'),
  (3121001,'Datas','MG'),
  (3121100,'Delfim Moreira','MG'),
  (3121209,'Delfinpolis','MG'),
  (3121258,'Delta','MG'),
  (3121308,'Descoberto','MG'),
  (3121407,'Desterro de Entre Rios','MG'),
  (3121506,'Desterro do Melo','MG'),
  (3121605,'Diamantina','MG'),
  (3121704,'Diogo de Vasconcelos','MG'),
  (3121803,'Dionsio','MG'),
  (3121902,'Divinsia','MG'),
  (3122009,'Divino','MG'),
  (3122108,'Divino das Laranjeiras','MG'),
  (3122207,'Divinolndia de Minas','MG'),
  (3122306,'Divinpolis','MG'),
  (3122355,'Divisa Alegre','MG'),
  (3122405,'Divisa Nova','MG'),
  (3122454,'Divispolis','MG'),
  (3122470,'Dom Bosco','MG'),
  (3122504,'Dom Cavati','MG'),
  (3122603,'Dom Joaquim','MG'),
  (3122702,'Dom Silvrio','MG'),
  (3122801,'Dom Vioso','MG'),
  (3122900,'Dona Eusbia','MG'),
  (3123007,'Dores de Campos','MG');

INSERT INTO municipios (municipio_id, municipio_nome, estado_sigla) VALUES 
  (3123106,'Dores de Guanhes','MG'),
  (3123205,'Dores do Indai','MG'),
  (3123304,'Dores do Turvo','MG'),
  (3123403,'Dorespolis','MG'),
  (3123502,'Douradoquara','MG'),
  (3123528,'Durand','MG'),
  (3123601,'Eli Mendes','MG'),
  (3123700,'Engenheiro Caldas','MG'),
  (3123809,'Engenheiro Navarro','MG'),
  (3123858,'Entre Folhas','MG'),
  (3123908,'Entre Rios de Minas','MG'),
  (3124005,'Ervlia','MG'),
  (3124104,'Esmeraldas','MG'),
  (3124203,'Espera Feliz','MG'),
  (3124302,'Espinosa','MG'),
  (3124401,'Esprito Santo do Dourado','MG'),
  (3124500,'Estiva','MG'),
  (3124609,'Estrela Dalva','MG'),
  (3124708,'Estrela do Indai','MG'),
  (3124807,'Estrela do Sul','MG'),
  (3124906,'Eugenpolis','MG'),
  (3125002,'Ewbank da Cmara','MG'),
  (3125101,'Extrema','MG'),
  (3125200,'Fama','MG'),
  (3125309,'Faria Lemos','MG'),
  (3125408,'Felcio dos Santos','MG'),
  (3125507,'So Gonalo do Rio Preto','MG'),
  (3125606,'Felisburgo','MG'),
  (3125705,'Felixlndia','MG'),
  (3125804,'Fernandes Tourinho','MG'),
  (3125903,'Ferros','MG'),
  (3125952,'Fervedouro','MG'),
  (3126000,'Florestal','MG'),
  (3126109,'Formiga','MG'),
  (3126208,'Formoso','MG'),
  (3126307,'Fortaleza de Minas','MG'),
  (3126406,'Fortuna de Minas','MG'),
  (3126505,'Francisco Badar','MG'),
  (3126604,'Francisco Dumont','MG'),
  (3126703,'Francisco S','MG'),
  (3126752,'Franciscpolis','MG'),
  (3126802,'Frei Gaspar','MG'),
  (3126901,'Frei Inocncio','MG'),
  (3126950,'Frei Lagonegro','MG'),
  (3127008,'Fronteira','MG'),
  (3127057,'Fronteira dos Vales','MG'),
  (3127073,'Fruta de Leite','MG'),
  (3127107,'Frutal','MG'),
  (3127206,'Funilndia','MG'),
  (3127305,'Galilia','MG'),
  (3127339,'Gameleiras','MG'),
  (3127354,'Glaucilndia','MG'),
  (3127370,'Goiabeira','MG'),
  (3127388,'Goian','MG'),
  (3127404,'Gonalves','MG'),
  (3127503,'Gonzaga','MG'),
  (3127602,'Gouveia','MG'),
  (3127701,'Governador Valadares','MG'),
  (3127800,'Gro Mogol','MG'),
  (3127909,'Grupiara','MG'),
  (3128006,'Guanhes','MG'),
  (3128105,'Guap','MG'),
  (3128204,'Guaraciaba','MG'),
  (3128253,'Guaraciama','MG'),
  (3128303,'Guaransia','MG'),
  (3128402,'Guarani','MG'),
  (3128501,'Guarar','MG'),
  (3128600,'Guarda-Mor','MG'),
  (3128709,'Guaxup','MG'),
  (3128808,'Guidoval','MG'),
  (3128907,'Guimarnia','MG'),
  (3129004,'Guiricema','MG'),
  (3129103,'Gurinhat','MG'),
  (3129202,'Heliodora','MG'),
  (3129301,'Iapu','MG'),
  (3129400,'Ibertioga','MG'),
  (3129509,'Ibi','MG'),
  (3129608,'Ibia','MG'),
  (3129657,'Ibiracatu','MG'),
  (3129707,'Ibiraci','MG'),
  (3129806,'Ibirit','MG'),
  (3129905,'Ibitira de Minas','MG'),
  (3130002,'Ibituruna','MG'),
  (3130051,'Icara de Minas','MG'),
  (3130101,'Igarap','MG'),
  (3130200,'Igaratinga','MG'),
  (3130309,'Iguatama','MG'),
  (3130408,'Ijaci','MG'),
  (3130507,'Ilicnea','MG'),
  (3130556,'Imb de Minas','MG'),
  (3130606,'Inconfidentes','MG'),
  (3130655,'Indaiabira','MG'),
  (3130705,'Indianpolis','MG'),
  (3130804,'Inga','MG'),
  (3130903,'Inhapim','MG'),
  (3131000,'Inhama','MG'),
  (3131109,'Inimutaba','MG'),
  (3131158,'Ipaba','MG'),
  (3131208,'Ipanema','MG'),
  (3131307,'Ipatinga','MG'),
  (3131406,'Ipiau','MG'),
  (3131505,'Ipuina','MG'),
  (3131604,'Ira de Minas','MG'),
  (3131703,'Itabira','MG'),
  (3131802,'Itabirinha','MG'),
  (3131901,'Itabirito','MG'),
  (3132008,'Itacambira','MG'),
  (3132107,'Itacarambi','MG'),
  (3132206,'Itaguara','MG'),
  (3132305,'Itaip','MG'),
  (3132404,'Itajub','MG'),
  (3132503,'Itamarandiba','MG'),
  (3132602,'Itamarati de Minas','MG'),
  (3132701,'Itambacuri','MG'),
  (3132800,'Itamb do Mato Dentro','MG'),
  (3132909,'Itamogi','MG'),
  (3133006,'Itamonte','MG'),
  (3133105,'Itanhandu','MG'),
  (3133204,'Itanhomi','MG'),
  (3133303,'Itaobim','MG'),
  (3133402,'Itapagipe','MG'),
  (3133501,'Itapecerica','MG'),
  (3133600,'Itapeva','MG'),
  (3133709,'Itatiaiuu','MG'),
  (3133758,'Ita de Minas','MG'),
  (3133808,'Itana','MG'),
  (3133907,'Itaverava','MG'),
  (3134004,'Itinga','MG'),
  (3134103,'Itueta','MG'),
  (3134202,'Ituiutaba','MG'),
  (3134301,'Itumirim','MG'),
  (3134400,'Iturama','MG'),
  (3134509,'Itutinga','MG'),
  (3134608,'Jaboticatubas','MG'),
  (3134707,'Jacinto','MG'),
  (3134806,'Jacu','MG'),
  (3134905,'Jacutinga','MG'),
  (3135001,'Jaguarau','MG'),
  (3135050,'Jaba','MG'),
  (3135076,'Jampruca','MG'),
  (3135100,'Janaba','MG'),
  (3135209,'Januria','MG'),
  (3135308,'Japaraba','MG'),
  (3135357,'Japonvar','MG'),
  (3135407,'Jeceaba','MG'),
  (3135456,'Jenipapo de Minas','MG'),
  (3135506,'Jequeri','MG'),
  (3135605,'Jequita','MG'),
  (3135704,'Jequitib','MG'),
  (3135803,'Jequitinhonha','MG'),
  (3135902,'Jesunia','MG'),
  (3136009,'Joama','MG'),
  (3136108,'Joansia','MG'),
  (3136207,'Joo Monlevade','MG'),
  (3136306,'Joo Pinheiro','MG'),
  (3136405,'Joaquim Felcio','MG'),
  (3136504,'Jordnia','MG'),
  (3136520,'Jos Gonalves de Minas','MG'),
  (3136553,'Jos Raydan','MG'),
  (3136579,'Josenpolis','MG'),
  (3136603,'Nova Unio','MG'),
  (3136652,'Juatuba','MG'),
  (3136702,'Juiz de Fora','MG'),
  (3136801,'Juramento','MG'),
  (3136900,'Juruaia','MG'),
  (3136959,'Juvenlia','MG'),
  (3137007,'Ladainha','MG'),
  (3137106,'Lagamar','MG'),
  (3137205,'Lagoa da Prata','MG'),
  (3137304,'Lagoa dos Patos','MG'),
  (3137403,'Lagoa Dourada','MG'),
  (3137502,'Lagoa Formosa','MG'),
  (3137536,'Lagoa Grande','MG'),
  (3137601,'Lagoa Santa','MG'),
  (3137700,'Lajinha','MG'),
  (3137809,'Lambari','MG'),
  (3137908,'Lamim','MG'),
  (3138005,'Laranjal','MG'),
  (3138104,'Lassance','MG'),
  (3138203,'Lavras','MG'),
  (3138302,'Leandro Ferreira','MG'),
  (3138351,'Leme do Prado','MG'),
  (3138401,'Leopoldina','MG'),
  (3138500,'Liberdade','MG'),
  (3138609,'Lima Duarte','MG'),
  (3138625,'Limeira do Oeste','MG'),
  (3138658,'Lontra','MG'),
  (3138674,'Luisburgo','MG'),
  (3138682,'Luislndia','MG'),
  (3138708,'Luminrias','MG'),
  (3138807,'Luz','MG'),
  (3138906,'Machacalis','MG'),
  (3139003,'Machado','MG'),
  (3139102,'Madre de Deus de Minas','MG'),
  (3139201,'Malacacheta','MG'),
  (3139250,'Mamonas','MG'),
  (3139300,'Manga','MG'),
  (3139409,'Manhuau','MG'),
  (3139508,'Manhumirim','MG'),
  (3139607,'Mantena','MG'),
  (3139706,'Maravilhas','MG'),
  (3139805,'Mar de Espanha','MG'),
  (3139904,'Maria da F','MG'),
  (3140001,'Mariana','MG'),
  (3140100,'Marilac','MG'),
  (3140159,'Mrio Campos','MG'),
  (3140209,'Marip de Minas','MG'),
  (3140308,'Marliria','MG'),
  (3140407,'Marmelpolis','MG'),
  (3140506,'Martinho Campos','MG'),
  (3140530,'Martins Soares','MG'),
  (3140555,'Mata Verde','MG'),
  (3140605,'Materlndia','MG'),
  (3140704,'Mateus Leme','MG'),
  (3140803,'Matias Barbosa','MG'),
  (3140852,'Matias Cardoso','MG'),
  (3140902,'Matip','MG'),
  (3141009,'Mato Verde','MG'),
  (3141108,'Matozinhos','MG'),
  (3141207,'Matutina','MG'),
  (3141306,'Medeiros','MG'),
  (3141405,'Medina','MG'),
  (3141504,'Mendes Pimentel','MG'),
  (3141603,'Mercs','MG'),
  (3141702,'Mesquita','MG'),
  (3141801,'Minas Novas','MG'),
  (3141900,'Minduri','MG'),
  (3142007,'Mirabela','MG'),
  (3142106,'Miradouro','MG'),
  (3142205,'Mira','MG'),
  (3142254,'Miravnia','MG'),
  (3142304,'Moeda','MG'),
  (3142403,'Moema','MG'),
  (3142502,'Monjolos','MG'),
  (3142601,'Monsenhor Paulo','MG'),
  (3142700,'Montalvnia','MG'),
  (3142809,'Monte Alegre de Minas','MG'),
  (3142908,'Monte Azul','MG'),
  (3143005,'Monte Belo','MG'),
  (3143104,'Monte Carmelo','MG'),
  (3143153,'Monte Formoso','MG'),
  (3143203,'Monte Santo de Minas','MG'),
  (3143302,'Montes Claros','MG'),
  (3143401,'Monte Sio','MG'),
  (3143450,'Montezuma','MG'),
  (3143500,'Morada Nova de Minas','MG'),
  (3143609,'Morro da Gara','MG'),
  (3143708,'Morro do Pilar','MG'),
  (3143807,'Munhoz','MG'),
  (3143906,'Muria','MG'),
  (3144003,'Mutum','MG'),
  (3144102,'Muzambinho','MG'),
  (3144201,'Nacip Raydan','MG'),
  (3144300,'Nanuque','MG'),
  (3144359,'Naque','MG'),
  (3144375,'Natalndia','MG'),
  (3144409,'Natrcia','MG'),
  (3144508,'Nazareno','MG'),
  (3144607,'Nepomuceno','MG'),
  (3144656,'Ninheira','MG'),
  (3144672,'Nova Belm','MG'),
  (3144706,'Nova Era','MG'),
  (3144805,'Nova Lima','MG'),
  (3144904,'Nova Mdica','MG'),
  (3145000,'Nova Ponte','MG'),
  (3145059,'Nova Porteirinha','MG'),
  (3145109,'Nova Resende','MG'),
  (3145208,'Nova Serrana','MG'),
  (3145307,'Novo Cruzeiro','MG'),
  (3145356,'Novo Oriente de Minas','MG'),
  (3145372,'Novorizonte','MG'),
  (3145406,'Olaria','MG'),
  (3145455,'Olhos-d''gua','MG'),
  (3145505,'Olmpio Noronha','MG'),
  (3145604,'Oliveira','MG'),
  (3145703,'Oliveira Fortes','MG'),
  (3145802,'Ona de Pitangui','MG'),
  (3145851,'Oratrios','MG'),
  (3145877,'Oriznia','MG'),
  (3145901,'Ouro Branco','MG'),
  (3146008,'Ouro Fino','MG'),
  (3146107,'Ouro Preto','MG'),
  (3146206,'Ouro Verde de Minas','MG'),
  (3146255,'Padre Carvalho','MG'),
  (3146305,'Padre Paraso','MG'),
  (3146404,'Paineiras','MG'),
  (3146503,'Pains','MG'),
  (3146552,'Pai Pedro','MG'),
  (3146602,'Paiva','MG'),
  (3146701,'Palma','MG'),
  (3146750,'Palmpolis','MG'),
  (3146909,'Papagaios','MG'),
  (3147006,'Paracatu','MG'),
  (3147105,'Par de Minas','MG'),
  (3147204,'Paraguau','MG'),
  (3147303,'Paraispolis','MG'),
  (3147402,'Paraopeba','MG'),
  (3147501,'Passabm','MG'),
  (3147600,'Passa Quatro','MG'),
  (3147709,'Passa Tempo','MG'),
  (3147808,'Passa-Vinte','MG'),
  (3147907,'Passos','MG'),
  (3147956,'Patis','MG'),
  (3148004,'Patos de Minas','MG'),
  (3148103,'Patrocnio','MG'),
  (3148202,'Patrocnio do Muria','MG'),
  (3148301,'Paula Cndido','MG'),
  (3148400,'Paulistas','MG'),
  (3148509,'Pavo','MG'),
  (3148608,'Peanha','MG'),
  (3148707,'Pedra Azul','MG'),
  (3148756,'Pedra Bonita','MG'),
  (3148806,'Pedra do Anta','MG'),
  (3148905,'Pedra do Indai','MG'),
  (3149002,'Pedra Dourada','MG'),
  (3149101,'Pedralva','MG'),
  (3149150,'Pedras de Maria da Cruz','MG'),
  (3149200,'Pedrinpolis','MG'),
  (3149309,'Pedro Leopoldo','MG'),
  (3149408,'Pedro Teixeira','MG'),
  (3149507,'Pequeri','MG'),
  (3149606,'Pequi','MG'),
  (3149705,'Perdigo','MG'),
  (3149804,'Perdizes','MG'),
  (3149903,'Perdes','MG'),
  (3149952,'Periquito','MG'),
  (3150000,'Pescador','MG'),
  (3150109,'Piau','MG'),
  (3150158,'Piedade de Caratinga','MG'),
  (3150208,'Piedade de Ponte Nova','MG'),
  (3150307,'Piedade do Rio Grande','MG'),
  (3150406,'Piedade dos Gerais','MG'),
  (3150505,'Pimenta','MG'),
  (3150539,'Pingo-d''gua','MG'),
  (3150570,'Pintpolis','MG'),
  (3150604,'Piracema','MG'),
  (3150703,'Pirajuba','MG'),
  (3150802,'Piranga','MG'),
  (3150901,'Piranguu','MG'),
  (3151008,'Piranguinho','MG'),
  (3151107,'Pirapetinga','MG'),
  (3151206,'Pirapora','MG'),
  (3151305,'Piraba','MG'),
  (3151404,'Pitangui','MG'),
  (3151503,'Piumhi','MG'),
  (3151602,'Planura','MG'),
  (3151701,'Poo Fundo','MG'),
  (3151800,'Poos de Caldas','MG'),
  (3151909,'Pocrane','MG'),
  (3152006,'Pompu','MG'),
  (3152105,'Ponte Nova','MG'),
  (3152131,'Ponto Chique','MG'),
  (3152170,'Ponto dos Volantes','MG'),
  (3152204,'Porteirinha','MG'),
  (3152303,'Porto Firme','MG'),
  (3152402,'Pot','MG'),
  (3152501,'Pouso Alegre','MG'),
  (3152600,'Pouso Alto','MG'),
  (3152709,'Prados','MG'),
  (3152808,'Prata','MG'),
  (3152907,'Pratpolis','MG'),
  (3153004,'Pratinha','MG'),
  (3153103,'Presidente Bernardes','MG'),
  (3153202,'Presidente Juscelino','MG'),
  (3153301,'Presidente Kubitschek','MG'),
  (3153400,'Presidente Olegrio','MG'),
  (3153509,'Alto Jequitib','MG'),
  (3153608,'Prudente de Morais','MG'),
  (3153707,'Quartel Geral','MG'),
  (3153806,'Queluzito','MG'),
  (3153905,'Raposos','MG'),
  (3154002,'Raul Soares','MG'),
  (3154101,'Recreio','MG'),
  (3154150,'Reduto','MG'),
  (3154200,'Resende Costa','MG'),
  (3154309,'Resplendor','MG'),
  (3154408,'Ressaquinha','MG'),
  (3154457,'Riachinho','MG'),
  (3154507,'Riacho dos Machados','MG'),
  (3154606,'Ribeiro das Neves','MG'),
  (3154705,'Ribeiro Vermelho','MG'),
  (3154804,'Rio Acima','MG'),
  (3154903,'Rio Casca','MG'),
  (3155009,'Rio Doce','MG'),
  (3155108,'Rio do Prado','MG'),
  (3155207,'Rio Espera','MG'),
  (3155306,'Rio Manso','MG'),
  (3155405,'Rio Novo','MG'),
  (3155504,'Rio Paranaba','MG'),
  (3155603,'Rio Pardo de Minas','MG'),
  (3155702,'Rio Piracicaba','MG'),
  (3155801,'Rio Pomba','MG'),
  (3155900,'Rio Preto','MG'),
  (3156007,'Rio Vermelho','MG'),
  (3156106,'Ritpolis','MG'),
  (3156205,'Rochedo de Minas','MG'),
  (3156304,'Rodeiro','MG'),
  (3156403,'Romaria','MG'),
  (3156452,'Rosrio da Limeira','MG'),
  (3156502,'Rubelita','MG'),
  (3156601,'Rubim','MG'),
  (3156700,'Sabar','MG'),
  (3156809,'Sabinpolis','MG'),
  (3156908,'Sacramento','MG'),
  (3157005,'Salinas','MG'),
  (3157104,'Salto da Divisa','MG'),
  (3157203,'Santa Brbara','MG'),
  (3157252,'Santa Brbara do Leste','MG'),
  (3157278,'Santa Brbara do Monte Verde','MG'),
  (3157302,'Santa Brbara do Tugrio','MG'),
  (3157336,'Santa Cruz de Minas','MG'),
  (3157377,'Santa Cruz de Salinas','MG'),
  (3157401,'Santa Cruz do Escalvado','MG'),
  (3157500,'Santa Efignia de Minas','MG'),
  (3157609,'Santa F de Minas','MG'),
  (3157658,'Santa Helena de Minas','MG'),
  (3157708,'Santa Juliana','MG'),
  (3157807,'Santa Luzia','MG'),
  (3157906,'Santa Margarida','MG'),
  (3158003,'Santa Maria de Itabira','MG'),
  (3158102,'Santa Maria do Salto','MG'),
  (3158201,'Santa Maria do Suau','MG'),
  (3158300,'Santana da Vargem','MG'),
  (3158409,'Santana de Cataguases','MG'),
  (3158508,'Santana de Pirapama','MG'),
  (3158607,'Santana do Deserto','MG'),
  (3158706,'Santana do Garambu','MG'),
  (3158805,'Santana do Jacar','MG'),
  (3158904,'Santana do Manhuau','MG'),
  (3158953,'Santana do Paraso','MG'),
  (3159001,'Santana do Riacho','MG'),
  (3159100,'Santana dos Montes','MG'),
  (3159209,'Santa Rita de Caldas','MG'),
  (3159308,'Santa Rita de Jacutinga','MG'),
  (3159357,'Santa Rita de Minas','MG'),
  (3159407,'Santa Rita de Ibitipoca','MG'),
  (3159506,'Santa Rita do Itueto','MG'),
  (3159605,'Santa Rita do Sapuca','MG'),
  (3159704,'Santa Rosa da Serra','MG'),
  (3159803,'Santa Vitria','MG'),
  (3159902,'Santo Antnio do Amparo','MG'),
  (3160009,'Santo Antnio do Aventureiro','MG'),
  (3160108,'Santo Antnio do Grama','MG'),
  (3160207,'Santo Antnio do Itamb','MG'),
  (3160306,'Santo Antnio do Jacinto','MG'),
  (3160405,'Santo Antnio do Monte','MG'),
  (3160454,'Santo Antnio do Retiro','MG'),
  (3160504,'Santo Antnio do Rio Abaixo','MG'),
  (3160603,'Santo Hiplito','MG'),
  (3160702,'Santos Dumont','MG'),
  (3160801,'So Bento Abade','MG'),
  (3160900,'So Brs do Suau','MG'),
  (3160959,'So Domingos das Dores','MG'),
  (3161007,'So Domingos do Prata','MG'),
  (3161056,'So Flix de Minas','MG'),
  (3161106,'So Francisco','MG'),
  (3161205,'So Francisco de Paula','MG'),
  (3161304,'So Francisco de Sales','MG'),
  (3161403,'So Francisco do Glria','MG'),
  (3161502,'So Geraldo','MG'),
  (3161601,'So Geraldo da Piedade','MG'),
  (3161650,'So Geraldo do Baixio','MG'),
  (3161700,'So Gonalo do Abaet','MG'),
  (3161809,'So Gonalo do Par','MG'),
  (3161908,'So Gonalo do Rio Abaixo','MG'),
  (3162005,'So Gonalo do Sapuca','MG'),
  (3162104,'So Gotardo','MG'),
  (3162203,'So Joo Batista do Glria','MG'),
  (3162252,'So Joo da Lagoa','MG'),
  (3162302,'So Joo da Mata','MG'),
  (3162401,'So Joo da Ponte','MG'),
  (3162450,'So Joo das Misses','MG'),
  (3162500,'So Joo del Rei','MG'),
  (3162559,'So Joo do Manhuau','MG'),
  (3162575,'So Joo do Manteninha','MG'),
  (3162609,'So Joo do Oriente','MG'),
  (3162658,'So Joo do Pacu','MG'),
  (3162708,'So Joo do Paraso','MG'),
  (3162807,'So Joo Evangelista','MG'),
  (3162906,'So Joo Nepomuceno','MG'),
  (3162922,'So Joaquim de Bicas','MG'),
  (3162948,'So Jos da Barra','MG'),
  (3162955,'So Jos da Lapa','MG'),
  (3163003,'So Jos da Safira','MG'),
  (3163102,'So Jos da Varginha','MG'),
  (3163201,'So Jos do Alegre','MG'),
  (3163300,'So Jos do Divino','MG'),
  (3163409,'So Jos do Goiabal','MG'),
  (3163508,'So Jos do Jacuri','MG'),
  (3163607,'So Jos do Mantimento','MG'),
  (3163706,'So Loureno','MG'),
  (3163805,'So Miguel do Anta','MG'),
  (3163904,'So Pedro da Unio','MG'),
  (3164001,'So Pedro dos Ferros','MG'),
  (3164100,'So Pedro do Suau','MG'),
  (3164209,'So Romo','MG'),
  (3164308,'So Roque de Minas','MG'),
  (3164407,'So Sebastio da Bela Vista','MG'),
  (3164431,'So Sebastio da Vargem Alegre','MG'),
  (3164472,'So Sebastio do Anta','MG');

INSERT INTO municipios (municipio_id, municipio_nome, estado_sigla) VALUES 
  (3164506,'So Sebastio do Maranho','MG'),
  (3164605,'So Sebastio do Oeste','MG'),
  (3164704,'So Sebastio do Paraso','MG'),
  (3164803,'So Sebastio do Rio Preto','MG'),
  (3164902,'So Sebastio do Rio Verde','MG'),
  (3165008,'So Tiago','MG'),
  (3165107,'So Toms de Aquino','MG'),
  (3165206,'So Thom das Letras','MG'),
  (3165305,'So Vicente de Minas','MG'),
  (3165404,'Sapuca-Mirim','MG'),
  (3165503,'Sardo','MG'),
  (3165537,'Sarzedo','MG'),
  (3165552,'Setubinha','MG'),
  (3165560,'Sem-Peixe','MG'),
  (3165578,'Senador Amaral','MG'),
  (3165602,'Senador Cortes','MG'),
  (3165701,'Senador Firmino','MG'),
  (3165800,'Senador Jos Bento','MG'),
  (3165909,'Senador Modestino Gonalves','MG'),
  (3166006,'Senhora de Oliveira','MG'),
  (3166105,'Senhora do Porto','MG'),
  (3166204,'Senhora dos Remdios','MG'),
  (3166303,'Sericita','MG'),
  (3166402,'Seritinga','MG'),
  (3166501,'Serra Azul de Minas','MG'),
  (3166600,'Serra da Saudade','MG'),
  (3166709,'Serra dos Aimors','MG'),
  (3166808,'Serra do Salitre','MG'),
  (3166907,'Serrania','MG'),
  (3166956,'Serranpolis de Minas','MG'),
  (3167004,'Serranos','MG'),
  (3167103,'Serro','MG'),
  (3167202,'Sete Lagoas','MG'),
  (3167301,'Silveirnia','MG'),
  (3167400,'Silvianpolis','MG'),
  (3167509,'Simo Pereira','MG'),
  (3167608,'Simonsia','MG'),
  (3167707,'Sobrlia','MG'),
  (3167806,'Soledade de Minas','MG'),
  (3167905,'Tabuleiro','MG'),
  (3168002,'Taiobeiras','MG'),
  (3168051,'Taparuba','MG'),
  (3168101,'Tapira','MG'),
  (3168200,'Tapira','MG'),
  (3168309,'Taquarau de Minas','MG'),
  (3168408,'Tarumirim','MG'),
  (3168507,'Teixeiras','MG'),
  (3168606,'Tefilo Otoni','MG'),
  (3168705,'Timteo','MG'),
  (3168804,'Tiradentes','MG'),
  (3168903,'Tiros','MG'),
  (3169000,'Tocantins','MG'),
  (3169059,'Tocos do Moji','MG'),
  (3169109,'Toledo','MG'),
  (3169208,'Tombos','MG'),
  (3169307,'Trs Coraes','MG'),
  (3169356,'Trs Marias','MG'),
  (3169406,'Trs Pontas','MG'),
  (3169505,'Tumiritinga','MG'),
  (3169604,'Tupaciguara','MG'),
  (3169703,'Turmalina','MG'),
  (3169802,'Turvolndia','MG'),
  (3169901,'Ub','MG'),
  (3170008,'Uba','MG'),
  (3170057,'Ubaporanga','MG'),
  (3170107,'Uberaba','MG'),
  (3170206,'Uberlndia','MG'),
  (3170305,'Umburatiba','MG'),
  (3170404,'Una','MG'),
  (3170438,'Unio de Minas','MG'),
  (3170479,'Uruana de Minas','MG'),
  (3170503,'Urucnia','MG'),
  (3170529,'Urucuia','MG'),
  (3170578,'Vargem Alegre','MG'),
  (3170602,'Vargem Bonita','MG'),
  (3170651,'Vargem Grande do Rio Pardo','MG'),
  (3170701,'Varginha','MG'),
  (3170750,'Varjo de Minas','MG'),
  (3170800,'Vrzea da Palma','MG'),
  (3170909,'Varzelndia','MG'),
  (3171006,'Vazante','MG'),
  (3171030,'Verdelndia','MG'),
  (3171071,'Veredinha','MG'),
  (3171105,'Verssimo','MG'),
  (3171154,'Vermelho Novo','MG'),
  (3171204,'Vespasiano','MG'),
  (3171303,'Viosa','MG'),
  (3171402,'Vieiras','MG'),
  (3171501,'Mathias Lobato','MG'),
  (3171600,'Virgem da Lapa','MG'),
  (3171709,'Virgnia','MG'),
  (3171808,'Virginpolis','MG'),
  (3171907,'Virgolndia','MG'),
  (3172004,'Visconde do Rio Branco','MG'),
  (3172103,'Volta Grande','MG'),
  (3172202,'Wenceslau Braz','MG'),
  (3200102,'Afonso Cludio','ES'),
  (3200136,'guia Branca','ES'),
  (3200169,'gua Doce do Norte','ES'),
  (3200201,'Alegre','ES'),
  (3200300,'Alfredo Chaves','ES'),
  (3200359,'Alto Rio Novo','ES'),
  (3200409,'Anchieta','ES'),
  (3200508,'Apiac','ES'),
  (3200607,'Aracruz','ES'),
  (3200706,'Atilio Vivacqua','ES'),
  (3200805,'Baixo Guandu','ES'),
  (3200904,'Barra de So Francisco','ES'),
  (3201001,'Boa Esperana','ES'),
  (3201100,'Bom Jesus do Norte','ES'),
  (3201159,'Brejetuba','ES'),
  (3201209,'Cachoeiro de Itapemirim','ES'),
  (3201308,'Cariacica','ES'),
  (3201407,'Castelo','ES'),
  (3201506,'Colatina','ES'),
  (3201605,'Conceio da Barra','ES'),
  (3201704,'Conceio do Castelo','ES'),
  (3201803,'Divino de So Loureno','ES'),
  (3201902,'Domingos Martins','ES'),
  (3202009,'Dores do Rio Preto','ES'),
  (3202108,'Ecoporanga','ES'),
  (3202207,'Fundo','ES'),
  (3202256,'Governador Lindenberg','ES'),
  (3202306,'Guau','ES'),
  (3202405,'Guarapari','ES'),
  (3202454,'Ibatiba','ES'),
  (3202504,'Ibirau','ES'),
  (3202553,'Ibitirama','ES'),
  (3202603,'Iconha','ES'),
  (3202652,'Irupi','ES'),
  (3202702,'Itaguau','ES'),
  (3202801,'Itapemirim','ES'),
  (3202900,'Itarana','ES'),
  (3203007,'Ina','ES'),
  (3203056,'Jaguar','ES'),
  (3203106,'Jernimo Monteiro','ES'),
  (3203130,'Joo Neiva','ES'),
  (3203163,'Laranja da Terra','ES'),
  (3203205,'Linhares','ES'),
  (3203304,'Mantenpolis','ES'),
  (3203320,'Maratazes','ES'),
  (3203346,'Marechal Floriano','ES'),
  (3203353,'Marilndia','ES'),
  (3203403,'Mimoso do Sul','ES'),
  (3203502,'Montanha','ES'),
  (3203601,'Mucurici','ES'),
  (3203700,'Muniz Freire','ES'),
  (3203809,'Muqui','ES'),
  (3203908,'Nova Vencia','ES'),
  (3204005,'Pancas','ES'),
  (3204054,'Pedro Canrio','ES'),
  (3204104,'Pinheiros','ES'),
  (3204203,'Pima','ES'),
  (3204252,'Ponto Belo','ES'),
  (3204302,'Presidente Kennedy','ES'),
  (3204351,'Rio Bananal','ES'),
  (3204401,'Rio Novo do Sul','ES'),
  (3204500,'Santa Leopoldina','ES'),
  (3204559,'Santa Maria de Jetib','ES'),
  (3204609,'Santa Teresa','ES'),
  (3204658,'So Domingos do Norte','ES'),
  (3204708,'So Gabriel da Palha','ES'),
  (3204807,'So Jos do Calado','ES'),
  (3204906,'So Mateus','ES'),
  (3204955,'So Roque do Cana','ES'),
  (3205002,'Serra','ES'),
  (3205010,'Sooretama','ES'),
  (3205036,'Vargem Alta','ES'),
  (3205069,'Venda Nova do Imigrante','ES'),
  (3205101,'Viana','ES'),
  (3205150,'Vila Pavo','ES'),
  (3205176,'Vila Valrio','ES'),
  (3205200,'Vila Velha','ES'),
  (3205309,'Vitria','ES'),
  (3300100,'Angra dos Reis','RJ'),
  (3300159,'Aperib','RJ'),
  (3300209,'Araruama','RJ'),
  (3300225,'Areal','RJ'),
  (3300233,'Armao dos Bzios','RJ'),
  (3300258,'Arraial do Cabo','RJ'),
  (3300308,'Barra do Pira','RJ'),
  (3300407,'Barra Mansa','RJ'),
  (3300456,'Belford Roxo','RJ'),
  (3300506,'Bom Jardim','RJ'),
  (3300605,'Bom Jesus do Itabapoana','RJ'),
  (3300704,'Cabo Frio','RJ'),
  (3300803,'Cachoeiras de Macacu','RJ'),
  (3300902,'Cambuci','RJ'),
  (3300936,'Carapebus','RJ'),
  (3300951,'Comendador Levy Gasparian','RJ'),
  (3301009,'Campos dos Goytacazes','RJ'),
  (3301108,'Cantagalo','RJ'),
  (3301157,'Cardoso Moreira','RJ'),
  (3301207,'Carmo','RJ'),
  (3301306,'Casimiro de Abreu','RJ'),
  (3301405,'Conceio de Macabu','RJ'),
  (3301504,'Cordeiro','RJ'),
  (3301603,'Duas Barras','RJ'),
  (3301702,'Duque de Caxias','RJ'),
  (3301801,'Engenheiro Paulo de Frontin','RJ'),
  (3301850,'Guapimirim','RJ'),
  (3301876,'Iguaba Grande','RJ'),
  (3301900,'Itabora','RJ'),
  (3302007,'Itagua','RJ'),
  (3302056,'Italva','RJ'),
  (3302106,'Itaocara','RJ'),
  (3302205,'Itaperuna','RJ'),
  (3302254,'Itatiaia','RJ'),
  (3302270,'Japeri','RJ'),
  (3302304,'Laje do Muria','RJ'),
  (3302403,'Maca','RJ'),
  (3302452,'Macuco','RJ'),
  (3302502,'Mag','RJ'),
  (3302601,'Mangaratiba','RJ'),
  (3302700,'Maric','RJ'),
  (3302809,'Mendes','RJ'),
  (3302858,'Mesquita','RJ'),
  (3302908,'Miguel Pereira','RJ'),
  (3303005,'Miracema','RJ'),
  (3303104,'Natividade','RJ'),
  (3303203,'Nilpolis','RJ'),
  (3303302,'Niteri','RJ'),
  (3303401,'Nova Friburgo','RJ'),
  (3303500,'Nova Iguau','RJ'),
  (3303609,'Paracambi','RJ'),
  (3303708,'Paraba do Sul','RJ'),
  (3303807,'Paraty','RJ'),
  (3303856,'Paty do Alferes','RJ'),
  (3303906,'Petrpolis','RJ'),
  (3303955,'Pinheiral','RJ'),
  (3304003,'Pira','RJ'),
  (3304102,'Porcincula','RJ'),
  (3304110,'Porto Real','RJ'),
  (3304128,'Quatis','RJ'),
  (3304144,'Queimados','RJ'),
  (3304151,'Quissam','RJ'),
  (3304201,'Resende','RJ'),
  (3304300,'Rio Bonito','RJ'),
  (3304409,'Rio Claro','RJ'),
  (3304508,'Rio das Flores','RJ'),
  (3304524,'Rio das Ostras','RJ'),
  (3304557,'Rio de Janeiro','RJ'),
  (3304607,'Santa Maria Madalena','RJ'),
  (3304706,'Santo Antnio de Pdua','RJ'),
  (3304755,'So Francisco de Itabapoana','RJ'),
  (3304805,'So Fidlis','RJ'),
  (3304904,'So Gonalo','RJ'),
  (3305000,'So Joo da Barra','RJ'),
  (3305109,'So Joo de Meriti','RJ'),
  (3305133,'So Jos de Ub','RJ'),
  (3305158,'So Jos do Vale do Rio Preto','RJ'),
  (3305208,'So Pedro da Aldeia','RJ'),
  (3305307,'So Sebastio do Alto','RJ'),
  (3305406,'Sapucaia','RJ'),
  (3305505,'Saquarema','RJ'),
  (3305554,'Seropdica','RJ'),
  (3305604,'Silva Jardim','RJ'),
  (3305703,'Sumidouro','RJ'),
  (3305752,'Tangu','RJ'),
  (3305802,'Terespolis','RJ'),
  (3305901,'Trajano de Moraes','RJ'),
  (3306008,'Trs Rios','RJ'),
  (3306107,'Valena','RJ'),
  (3306156,'Varre-Sai','RJ'),
  (3306206,'Vassouras','RJ'),
  (3306305,'Volta Redonda','RJ'),
  (3500105,'Adamantina','SP'),
  (3500204,'Adolfo','SP'),
  (3500303,'Agua','SP'),
  (3500402,'guas da Prata','SP'),
  (3500501,'guas de Lindia','SP'),
  (3500550,'guas de Santa Brbara','SP'),
  (3500600,'guas de So Pedro','SP'),
  (3500709,'Agudos','SP'),
  (3500758,'Alambari','SP'),
  (3500808,'Alfredo Marcondes','SP'),
  (3500907,'Altair','SP'),
  (3501004,'Altinpolis','SP'),
  (3501103,'Alto Alegre','SP'),
  (3501152,'Alumnio','SP'),
  (3501202,'lvares Florence','SP'),
  (3501301,'lvares Machado','SP'),
  (3501400,'lvaro de Carvalho','SP'),
  (3501509,'Alvinlndia','SP'),
  (3501608,'Americana','SP'),
  (3501707,'Amrico Brasiliense','SP'),
  (3501806,'Amrico de Campos','SP'),
  (3501905,'Amparo','SP'),
  (3502002,'Analndia','SP'),
  (3502101,'Andradina','SP'),
  (3502200,'Angatuba','SP'),
  (3502309,'Anhembi','SP'),
  (3502408,'Anhumas','SP'),
  (3502507,'Aparecida','SP'),
  (3502606,'Aparecida d''Oeste','SP'),
  (3502705,'Apia','SP'),
  (3502754,'Araariguama','SP'),
  (3502804,'Araatuba','SP'),
  (3502903,'Araoiaba da Serra','SP'),
  (3503000,'Aramina','SP'),
  (3503109,'Arandu','SP'),
  (3503158,'Arape','SP'),
  (3503208,'Araraquara','SP'),
  (3503307,'Araras','SP'),
  (3503356,'Arco-ris','SP'),
  (3503406,'Arealva','SP'),
  (3503505,'Areias','SP'),
  (3503604,'Areipolis','SP'),
  (3503703,'Ariranha','SP'),
  (3503802,'Artur Nogueira','SP'),
  (3503901,'Aruj','SP'),
  (3503950,'Aspsia','SP'),
  (3504008,'Assis','SP'),
  (3504107,'Atibaia','SP'),
  (3504206,'Auriflama','SP'),
  (3504305,'Ava','SP'),
  (3504404,'Avanhandava','SP'),
  (3504503,'Avar','SP'),
  (3504602,'Bady Bassitt','SP'),
  (3504701,'Balbinos','SP'),
  (3504800,'Blsamo','SP'),
  (3504909,'Bananal','SP'),
  (3505005,'Baro de Antonina','SP'),
  (3505104,'Barbosa','SP'),
  (3505203,'Bariri','SP'),
  (3505302,'Barra Bonita','SP'),
  (3505351,'Barra do Chapu','SP'),
  (3505401,'Barra do Turvo','SP'),
  (3505500,'Barretos','SP'),
  (3505609,'Barrinha','SP'),
  (3505708,'Barueri','SP'),
  (3505807,'Bastos','SP'),
  (3505906,'Batatais','SP'),
  (3506003,'Bauru','SP'),
  (3506102,'Bebedouro','SP'),
  (3506201,'Bento de Abreu','SP'),
  (3506300,'Bernardino de Campos','SP'),
  (3506359,'Bertioga','SP'),
  (3506409,'Bilac','SP'),
  (3506508,'Birigui','SP'),
  (3506607,'Biritiba-Mirim','SP'),
  (3506706,'Boa Esperana do Sul','SP'),
  (3506805,'Bocaina','SP'),
  (3506904,'Bofete','SP'),
  (3507001,'Boituva','SP'),
  (3507100,'Bom Jesus dos Perdes','SP'),
  (3507159,'Bom Sucesso de Itarar','SP'),
  (3507209,'Bor','SP'),
  (3507308,'Boracia','SP'),
  (3507407,'Borborema','SP'),
  (3507456,'Borebi','SP'),
  (3507506,'Botucatu','SP'),
  (3507605,'Bragana Paulista','SP'),
  (3507704,'Brana','SP'),
  (3507753,'Brejo Alegre','SP'),
  (3507803,'Brodowski','SP'),
  (3507902,'Brotas','SP'),
  (3508009,'Buri','SP'),
  (3508108,'Buritama','SP'),
  (3508207,'Buritizal','SP'),
  (3508306,'Cabrlia Paulista','SP'),
  (3508405,'Cabreva','SP'),
  (3508504,'Caapava','SP'),
  (3508603,'Cachoeira Paulista','SP'),
  (3508702,'Caconde','SP'),
  (3508801,'Cafelndia','SP'),
  (3508900,'Caiabu','SP'),
  (3509007,'Caieiras','SP'),
  (3509106,'Caiu','SP'),
  (3509205,'Cajamar','SP'),
  (3509254,'Cajati','SP'),
  (3509304,'Cajobi','SP'),
  (3509403,'Cajuru','SP'),
  (3509452,'Campina do Monte Alegre','SP'),
  (3509502,'Campinas','SP'),
  (3509601,'Campo Limpo Paulista','SP'),
  (3509700,'Campos do Jordo','SP'),
  (3509809,'Campos Novos Paulista','SP'),
  (3509908,'Canania','SP'),
  (3509957,'Canas','SP'),
  (3510005,'Cndido Mota','SP'),
  (3510104,'Cndido Rodrigues','SP'),
  (3510153,'Canitar','SP'),
  (3510203,'Capo Bonito','SP'),
  (3510302,'Capela do Alto','SP'),
  (3510401,'Capivari','SP'),
  (3510500,'Caraguatatuba','SP'),
  (3510609,'Carapicuba','SP'),
  (3510708,'Cardoso','SP'),
  (3510807,'Casa Branca','SP'),
  (3510906,'Cssia dos Coqueiros','SP'),
  (3511003,'Castilho','SP'),
  (3511102,'Catanduva','SP'),
  (3511201,'Catigu','SP'),
  (3511300,'Cedral','SP'),
  (3511409,'Cerqueira Csar','SP'),
  (3511508,'Cerquilho','SP'),
  (3511607,'Cesrio Lange','SP'),
  (3511706,'Charqueada','SP'),
  (3511904,'Clementina','SP'),
  (3512001,'Colina','SP'),
  (3512100,'Colmbia','SP'),
  (3512209,'Conchal','SP'),
  (3512308,'Conchas','SP'),
  (3512407,'Cordeirpolis','SP'),
  (3512506,'Coroados','SP'),
  (3512605,'Coronel Macedo','SP'),
  (3512704,'Corumbata','SP'),
  (3512803,'Cosmpolis','SP'),
  (3512902,'Cosmorama','SP'),
  (3513009,'Cotia','SP'),
  (3513108,'Cravinhos','SP'),
  (3513207,'Cristais Paulista','SP'),
  (3513306,'Cruzlia','SP'),
  (3513405,'Cruzeiro','SP'),
  (3513504,'Cubato','SP'),
  (3513603,'Cunha','SP'),
  (3513702,'Descalvado','SP'),
  (3513801,'Diadema','SP'),
  (3513850,'Dirce Reis','SP'),
  (3513900,'Divinolndia','SP'),
  (3514007,'Dobrada','SP'),
  (3514106,'Dois Crregos','SP'),
  (3514205,'Dolcinpolis','SP'),
  (3514304,'Dourado','SP'),
  (3514403,'Dracena','SP'),
  (3514502,'Duartina','SP'),
  (3514601,'Dumont','SP'),
  (3514700,'Echapor','SP'),
  (3514809,'Eldorado','SP'),
  (3514908,'Elias Fausto','SP'),
  (3514924,'Elisirio','SP'),
  (3514957,'Embaba','SP'),
  (3515004,'Embu','SP'),
  (3515103,'Embu-Guau','SP'),
  (3515129,'Emilianpolis','SP'),
  (3515152,'Engenheiro Coelho','SP'),
  (3515186,'Esprito Santo do Pinhal','SP'),
  (3515194,'Esprito Santo do Turvo','SP'),
  (3515202,'Estrela d''Oeste','SP'),
  (3515301,'Estrela do Norte','SP'),
  (3515350,'Euclides da Cunha Paulista','SP'),
  (3515400,'Fartura','SP'),
  (3515509,'Fernandpolis','SP'),
  (3515608,'Fernando Prestes','SP'),
  (3515657,'Ferno','SP'),
  (3515707,'Ferraz de Vasconcelos','SP'),
  (3515806,'Flora Rica','SP'),
  (3515905,'Floreal','SP'),
  (3516002,'Flrida Paulista','SP'),
  (3516101,'Flornia','SP'),
  (3516200,'Franca','SP'),
  (3516309,'Francisco Morato','SP'),
  (3516408,'Franco da Rocha','SP'),
  (3516507,'Gabriel Monteiro','SP'),
  (3516606,'Glia','SP'),
  (3516705,'Gara','SP'),
  (3516804,'Gasto Vidigal','SP'),
  (3516853,'Gavio Peixoto','SP'),
  (3516903,'General Salgado','SP'),
  (3517000,'Getulina','SP'),
  (3517109,'Glicrio','SP'),
  (3517208,'Guaiara','SP'),
  (3517307,'Guaimb','SP'),
  (3517406,'Guara','SP'),
  (3517505,'Guapiau','SP'),
  (3517604,'Guapiara','SP'),
  (3517703,'Guar','SP'),
  (3517802,'Guaraa','SP'),
  (3517901,'Guaraci','SP'),
  (3518008,'Guarani d''Oeste','SP'),
  (3518107,'Guarant','SP'),
  (3518206,'Guararapes','SP'),
  (3518305,'Guararema','SP'),
  (3518404,'Guaratinguet','SP'),
  (3518503,'Guare','SP'),
  (3518602,'Guariba','SP'),
  (3518701,'Guaruj','SP'),
  (3518800,'Guarulhos','SP'),
  (3518859,'Guatapar','SP'),
  (3518909,'Guzolndia','SP'),
  (3519006,'Herculndia','SP'),
  (3519055,'Holambra','SP'),
  (3519071,'Hortolndia','SP'),
  (3519105,'Iacanga','SP'),
  (3519204,'Iacri','SP'),
  (3519253,'Iaras','SP'),
  (3519303,'Ibat','SP'),
  (3519402,'Ibir','SP'),
  (3519501,'Ibirarema','SP'),
  (3519600,'Ibitinga','SP'),
  (3519709,'Ibina','SP'),
  (3519808,'Icm','SP'),
  (3519907,'Iep','SP'),
  (3520004,'Igarau do Tiet','SP'),
  (3520103,'Igarapava','SP'),
  (3520202,'Igarat','SP'),
  (3520301,'Iguape','SP'),
  (3520400,'Ilhabela','SP'),
  (3520426,'Ilha Comprida','SP');

INSERT INTO municipios (municipio_id, municipio_nome, estado_sigla) VALUES 
  (3520442,'Ilha Solteira','SP'),
  (3520509,'Indaiatuba','SP'),
  (3520608,'Indiana','SP'),
  (3520707,'Indiapor','SP'),
  (3520806,'Inbia Paulista','SP'),
  (3520905,'Ipaussu','SP'),
  (3521002,'Iper','SP'),
  (3521101,'Ipena','SP'),
  (3521150,'Ipigu','SP'),
  (3521200,'Iporanga','SP'),
  (3521309,'Ipu','SP'),
  (3521408,'Iracempolis','SP'),
  (3521507,'Irapu','SP'),
  (3521606,'Irapuru','SP'),
  (3521705,'Itaber','SP'),
  (3521804,'Ita','SP'),
  (3521903,'Itajobi','SP'),
  (3522000,'Itaju','SP'),
  (3522109,'Itanham','SP'),
  (3522158,'Itaca','SP'),
  (3522208,'Itapecerica da Serra','SP'),
  (3522307,'Itapetininga','SP'),
  (3522406,'Itapeva','SP'),
  (3522505,'Itapevi','SP'),
  (3522604,'Itapira','SP'),
  (3522653,'Itapirapu Paulista','SP'),
  (3522703,'Itpolis','SP'),
  (3522802,'Itaporanga','SP'),
  (3522901,'Itapu','SP'),
  (3523008,'Itapura','SP'),
  (3523107,'Itaquaquecetuba','SP'),
  (3523206,'Itarar','SP'),
  (3523305,'Itariri','SP'),
  (3523404,'Itatiba','SP'),
  (3523503,'Itatinga','SP'),
  (3523602,'Itirapina','SP'),
  (3523701,'Itirapu','SP'),
  (3523800,'Itobi','SP'),
  (3523909,'Itu','SP'),
  (3524006,'Itupeva','SP'),
  (3524105,'Ituverava','SP'),
  (3524204,'Jaborandi','SP'),
  (3524303,'Jaboticabal','SP'),
  (3524402,'Jacare','SP'),
  (3524501,'Jaci','SP'),
  (3524600,'Jacupiranga','SP'),
  (3524709,'Jaguarina','SP'),
  (3524808,'Jales','SP'),
  (3524907,'Jambeiro','SP'),
  (3525003,'Jandira','SP'),
  (3525102,'Jardinpolis','SP'),
  (3525201,'Jarinu','SP'),
  (3525300,'Ja','SP'),
  (3525409,'Jeriquara','SP'),
  (3525508,'Joanpolis','SP'),
  (3525607,'Joo Ramalho','SP'),
  (3525706,'Jos Bonifcio','SP'),
  (3525805,'Jlio Mesquita','SP'),
  (3525854,'Jumirim','SP'),
  (3525904,'Jundia','SP'),
  (3526001,'Junqueirpolis','SP'),
  (3526100,'Juqui','SP'),
  (3526209,'Juquitiba','SP'),
  (3526308,'Lagoinha','SP'),
  (3526407,'Laranjal Paulista','SP'),
  (3526506,'Lavnia','SP'),
  (3526605,'Lavrinhas','SP'),
  (3526704,'Leme','SP'),
  (3526803,'Lenis Paulista','SP'),
  (3526902,'Limeira','SP'),
  (3527009,'Lindia','SP'),
  (3527108,'Lins','SP'),
  (3527207,'Lorena','SP'),
  (3527256,'Lourdes','SP'),
  (3527306,'Louveira','SP'),
  (3527405,'Luclia','SP'),
  (3527504,'Lucianpolis','SP'),
  (3527603,'Lus Antnio','SP'),
  (3527702,'Luizinia','SP'),
  (3527801,'Luprcio','SP'),
  (3527900,'Lutcia','SP'),
  (3528007,'Macatuba','SP'),
  (3528106,'Macaubal','SP'),
  (3528205,'Macednia','SP'),
  (3528304,'Magda','SP'),
  (3528403,'Mairinque','SP'),
  (3528502,'Mairipor','SP'),
  (3528601,'Manduri','SP'),
  (3528700,'Marab Paulista','SP'),
  (3528809,'Maraca','SP'),
  (3528858,'Marapoama','SP'),
  (3528908,'Maripolis','SP'),
  (3529005,'Marlia','SP'),
  (3529104,'Marinpolis','SP'),
  (3529203,'Martinpolis','SP'),
  (3529302,'Mato','SP'),
  (3529401,'Mau','SP'),
  (3529500,'Mendona','SP'),
  (3529609,'Meridiano','SP'),
  (3529658,'Mespolis','SP'),
  (3529708,'Miguelpolis','SP'),
  (3529807,'Mineiros do Tiet','SP'),
  (3529906,'Miracatu','SP'),
  (3530003,'Mira Estrela','SP'),
  (3530102,'Mirandpolis','SP'),
  (3530201,'Mirante do Paranapanema','SP'),
  (3530300,'Mirassol','SP'),
  (3530409,'Mirassolndia','SP'),
  (3530508,'Mococa','SP'),
  (3530607,'Mogi das Cruzes','SP'),
  (3530706,'Mogi Guau','SP'),
  (3530805,'Moji Mirim','SP'),
  (3530904,'Mombuca','SP'),
  (3531001,'Mones','SP'),
  (3531100,'Mongagu','SP'),
  (3531209,'Monte Alegre do Sul','SP'),
  (3531308,'Monte Alto','SP'),
  (3531407,'Monte Aprazvel','SP'),
  (3531506,'Monte Azul Paulista','SP'),
  (3531605,'Monte Castelo','SP'),
  (3531704,'Monteiro Lobato','SP'),
  (3531803,'Monte Mor','SP'),
  (3531902,'Morro Agudo','SP'),
  (3532009,'Morungaba','SP'),
  (3532058,'Motuca','SP'),
  (3532108,'Murutinga do Sul','SP'),
  (3532157,'Nantes','SP'),
  (3532207,'Narandiba','SP'),
  (3532306,'Natividade da Serra','SP'),
  (3532405,'Nazar Paulista','SP'),
  (3532504,'Neves Paulista','SP'),
  (3532603,'Nhandeara','SP'),
  (3532702,'Nipo','SP'),
  (3532801,'Nova Aliana','SP'),
  (3532827,'Nova Campina','SP'),
  (3532843,'Nova Cana Paulista','SP'),
  (3532868,'Nova Castilho','SP'),
  (3532900,'Nova Europa','SP'),
  (3533007,'Nova Granada','SP'),
  (3533106,'Nova Guataporanga','SP'),
  (3533205,'Nova Independncia','SP'),
  (3533254,'Novais','SP'),
  (3533304,'Nova Luzitnia','SP'),
  (3533403,'Nova Odessa','SP'),
  (3533502,'Novo Horizonte','SP'),
  (3533601,'Nuporanga','SP'),
  (3533700,'Ocauu','SP'),
  (3533809,'leo','SP'),
  (3533908,'Olmpia','SP'),
  (3534005,'Onda Verde','SP'),
  (3534104,'Oriente','SP'),
  (3534203,'Orindiva','SP'),
  (3534302,'Orlndia','SP'),
  (3534401,'Osasco','SP'),
  (3534500,'Oscar Bressane','SP'),
  (3534609,'Osvaldo Cruz','SP'),
  (3534708,'Ourinhos','SP'),
  (3534757,'Ouroeste','SP'),
  (3534807,'Ouro Verde','SP'),
  (3534906,'Pacaembu','SP'),
  (3535002,'Palestina','SP'),
  (3535101,'Palmares Paulista','SP'),
  (3535200,'Palmeira d''Oeste','SP'),
  (3535309,'Palmital','SP'),
  (3535408,'Panorama','SP'),
  (3535507,'Paraguau Paulista','SP'),
  (3535606,'Paraibuna','SP'),
  (3535705,'Paraso','SP'),
  (3535804,'Paranapanema','SP'),
  (3535903,'Paranapu','SP'),
  (3536000,'Parapu','SP'),
  (3536109,'Pardinho','SP'),
  (3536208,'Pariquera-Au','SP'),
  (3536257,'Parisi','SP'),
  (3536307,'Patrocnio Paulista','SP'),
  (3536406,'Paulicia','SP'),
  (3536505,'Paulnia','SP'),
  (3536570,'Paulistnia','SP'),
  (3536604,'Paulo de Faria','SP'),
  (3536703,'Pederneiras','SP'),
  (3536802,'Pedra Bela','SP'),
  (3536901,'Pedranpolis','SP'),
  (3537008,'Pedregulho','SP'),
  (3537107,'Pedreira','SP'),
  (3537156,'Pedrinhas Paulista','SP'),
  (3537206,'Pedro de Toledo','SP'),
  (3537305,'Penpolis','SP'),
  (3537404,'Pereira Barreto','SP'),
  (3537503,'Pereiras','SP'),
  (3537602,'Perube','SP'),
  (3537701,'Piacatu','SP'),
  (3537800,'Piedade','SP'),
  (3537909,'Pilar do Sul','SP'),
  (3538006,'Pindamonhangaba','SP'),
  (3538105,'Pindorama','SP'),
  (3538204,'Pinhalzinho','SP'),
  (3538303,'Piquerobi','SP'),
  (3538501,'Piquete','SP'),
  (3538600,'Piracaia','SP'),
  (3538709,'Piracicaba','SP'),
  (3538808,'Piraju','SP'),
  (3538907,'Piraju','SP'),
  (3539004,'Pirangi','SP'),
  (3539103,'Pirapora do Bom Jesus','SP'),
  (3539202,'Pirapozinho','SP'),
  (3539301,'Pirassununga','SP'),
  (3539400,'Piratininga','SP'),
  (3539509,'Pitangueiras','SP'),
  (3539608,'Planalto','SP'),
  (3539707,'Platina','SP'),
  (3539806,'Po','SP'),
  (3539905,'Poloni','SP'),
  (3540002,'Pompia','SP'),
  (3540101,'Ponga','SP'),
  (3540200,'Pontal','SP'),
  (3540259,'Pontalinda','SP'),
  (3540309,'Pontes Gestal','SP'),
  (3540408,'Populina','SP'),
  (3540507,'Porangaba','SP'),
  (3540606,'Porto Feliz','SP'),
  (3540705,'Porto Ferreira','SP'),
  (3540754,'Potim','SP'),
  (3540804,'Potirendaba','SP'),
  (3540853,'Pracinha','SP'),
  (3540903,'Pradpolis','SP'),
  (3541000,'Praia Grande','SP'),
  (3541059,'Pratnia','SP'),
  (3541109,'Presidente Alves','SP'),
  (3541208,'Presidente Bernardes','SP'),
  (3541307,'Presidente Epitcio','SP'),
  (3541406,'Presidente Prudente','SP'),
  (3541505,'Presidente Venceslau','SP'),
  (3541604,'Promisso','SP'),
  (3541653,'Quadra','SP'),
  (3541703,'Quat','SP'),
  (3541802,'Queiroz','SP'),
  (3541901,'Queluz','SP'),
  (3542008,'Quintana','SP'),
  (3542107,'Rafard','SP'),
  (3542206,'Rancharia','SP'),
  (3542305,'Redeno da Serra','SP'),
  (3542404,'Regente Feij','SP'),
  (3542503,'Reginpolis','SP'),
  (3542602,'Registro','SP'),
  (3542701,'Restinga','SP'),
  (3542800,'Ribeira','SP'),
  (3542909,'Ribeiro Bonito','SP'),
  (3543006,'Ribeiro Branco','SP'),
  (3543105,'Ribeiro Corrente','SP'),
  (3543204,'Ribeiro do Sul','SP'),
  (3543238,'Ribeiro dos ndios','SP'),
  (3543253,'Ribeiro Grande','SP'),
  (3543303,'Ribeiro Pires','SP'),
  (3543402,'Ribeiro Preto','SP'),
  (3543501,'Riversul','SP'),
  (3543600,'Rifaina','SP'),
  (3543709,'Rinco','SP'),
  (3543808,'Rinpolis','SP'),
  (3543907,'Rio Claro','SP'),
  (3544004,'Rio das Pedras','SP'),
  (3544103,'Rio Grande da Serra','SP'),
  (3544202,'Riolndia','SP'),
  (3544251,'Rosana','SP'),
  (3544301,'Roseira','SP'),
  (3544400,'Rubicea','SP'),
  (3544509,'Rubinia','SP'),
  (3544608,'Sabino','SP'),
  (3544707,'Sagres','SP'),
  (3544806,'Sales','SP'),
  (3544905,'Sales Oliveira','SP'),
  (3545001,'Salespolis','SP'),
  (3545100,'Salmouro','SP'),
  (3545159,'Saltinho','SP'),
  (3545209,'Salto','SP'),
  (3545308,'Salto de Pirapora','SP'),
  (3545407,'Salto Grande','SP'),
  (3545506,'Sandovalina','SP'),
  (3545605,'Santa Adlia','SP'),
  (3545704,'Santa Albertina','SP'),
  (3545803,'Santa Brbara d''Oeste','SP'),
  (3546009,'Santa Branca','SP'),
  (3546108,'Santa Clara d''Oeste','SP'),
  (3546207,'Santa Cruz da Conceio','SP'),
  (3546256,'Santa Cruz da Esperana','SP'),
  (3546306,'Santa Cruz das Palmeiras','SP'),
  (3546405,'Santa Cruz do Rio Pardo','SP'),
  (3546504,'Santa Ernestina','SP'),
  (3546603,'Santa F do Sul','SP'),
  (3546702,'Santa Gertrudes','SP'),
  (3546801,'Santa Isabel','SP'),
  (3546900,'Santa Lcia','SP'),
  (3547007,'Santa Maria da Serra','SP'),
  (3547106,'Santa Mercedes','SP'),
  (3547205,'Santana da Ponte Pensa','SP'),
  (3547304,'Santana de Parnaba','SP'),
  (3547403,'Santa Rita d''Oeste','SP'),
  (3547502,'Santa Rita do Passa Quatro','SP'),
  (3547601,'Santa Rosa de Viterbo','SP'),
  (3547650,'Santa Salete','SP'),
  (3547700,'Santo Anastcio','SP'),
  (3547809,'Santo Andr','SP'),
  (3547908,'Santo Antnio da Alegria','SP'),
  (3548005,'Santo Antnio de Posse','SP'),
  (3548054,'Santo Antnio do Aracangu','SP'),
  (3548104,'Santo Antnio do Jardim','SP'),
  (3548203,'Santo Antnio do Pinhal','SP'),
  (3548302,'Santo Expedito','SP'),
  (3548401,'Santpolis do Aguape','SP'),
  (3548500,'Santos','SP'),
  (3548609,'So Bento do Sapuca','SP'),
  (3548708,'So Bernardo do Campo','SP'),
  (3548807,'So Caetano do Sul','SP'),
  (3548906,'So Carlos','SP'),
  (3549003,'So Francisco','SP'),
  (3549102,'So Joo da Boa Vista','SP'),
  (3549201,'So Joo das Duas Pontes','SP'),
  (3549250,'So Joo de Iracema','SP'),
  (3549300,'So Joo do Pau d''Alho','SP'),
  (3549409,'So Joaquim da Barra','SP'),
  (3549508,'So Jos da Bela Vista','SP'),
  (3549607,'So Jos do Barreiro','SP'),
  (3549706,'So Jos do Rio Pardo','SP'),
  (3549805,'So Jos do Rio Preto','SP'),
  (3549904,'So Jos dos Campos','SP'),
  (3549953,'So Loureno da Serra','SP'),
  (3550001,'So Lus do Paraitinga','SP'),
  (3550100,'So Manuel','SP'),
  (3550209,'So Miguel Arcanjo','SP'),
  (3550308,'So Paulo','SP'),
  (3550407,'So Pedro','SP'),
  (3550506,'So Pedro do Turvo','SP'),
  (3550605,'So Roque','SP'),
  (3550704,'So Sebastio','SP'),
  (3550803,'So Sebastio da Grama','SP'),
  (3550902,'So Simo','SP'),
  (3551009,'So Vicente','SP'),
  (3551108,'Sarapu','SP'),
  (3551207,'Sarutai','SP'),
  (3551306,'Sebastianpolis do Sul','SP'),
  (3551405,'Serra Azul','SP'),
  (3551504,'Serrana','SP'),
  (3551603,'Serra Negra','SP'),
  (3551702,'Sertozinho','SP'),
  (3551801,'Sete Barras','SP'),
  (3551900,'Severnia','SP'),
  (3552007,'Silveiras','SP'),
  (3552106,'Socorro','SP'),
  (3552205,'Sorocaba','SP'),
  (3552304,'Sud Mennucci','SP'),
  (3552403,'Sumar','SP'),
  (3552502,'Suzano','SP'),
  (3552551,'Suzanpolis','SP'),
  (3552601,'Tabapu','SP'),
  (3552700,'Tabatinga','SP'),
  (3552809,'Taboo da Serra','SP'),
  (3552908,'Taciba','SP'),
  (3553005,'Tagua','SP'),
  (3553104,'Taiau','SP'),
  (3553203,'Taiva','SP'),
  (3553302,'Tamba','SP'),
  (3553401,'Tanabi','SP'),
  (3553500,'Tapira','SP'),
  (3553609,'Tapiratiba','SP'),
  (3553658,'Taquaral','SP'),
  (3553708,'Taquaritinga','SP'),
  (3553807,'Taquarituba','SP'),
  (3553856,'Taquariva','SP'),
  (3553906,'Tarabai','SP'),
  (3553955,'Tarum','SP'),
  (3554003,'Tatu','SP'),
  (3554102,'Taubat','SP'),
  (3554201,'Tejup','SP'),
  (3554300,'Teodoro Sampaio','SP'),
  (3554409,'Terra Roxa','SP'),
  (3554508,'Tiet','SP'),
  (3554607,'Timburi','SP'),
  (3554656,'Torre de Pedra','SP'),
  (3554706,'Torrinha','SP'),
  (3554755,'Trabiju','SP'),
  (3554805,'Trememb','SP'),
  (3554904,'Trs Fronteiras','SP'),
  (3554953,'Tuiuti','SP'),
  (3555000,'Tup','SP'),
  (3555109,'Tupi Paulista','SP'),
  (3555208,'Turiba','SP'),
  (3555307,'Turmalina','SP'),
  (3555356,'Ubarana','SP'),
  (3555406,'Ubatuba','SP'),
  (3555505,'Ubirajara','SP'),
  (3555604,'Uchoa','SP'),
  (3555703,'Unio Paulista','SP'),
  (3555802,'Urnia','SP'),
  (3555901,'Uru','SP'),
  (3556008,'Urups','SP'),
  (3556107,'Valentim Gentil','SP'),
  (3556206,'Valinhos','SP'),
  (3556305,'Valparaso','SP'),
  (3556354,'Vargem','SP'),
  (3556404,'Vargem Grande do Sul','SP'),
  (3556453,'Vargem Grande Paulista','SP'),
  (3556503,'Vrzea Paulista','SP'),
  (3556602,'Vera Cruz','SP'),
  (3556701,'Vinhedo','SP'),
  (3556800,'Viradouro','SP'),
  (3556909,'Vista Alegre do Alto','SP'),
  (3556958,'Vitria Brasil','SP'),
  (3557006,'Votorantim','SP'),
  (3557105,'Votuporanga','SP'),
  (3557154,'Zacarias','SP'),
  (3557204,'Chavantes','SP'),
  (3557303,'Estiva Gerbi','SP'),
  (4100103,'Abati','PR'),
  (4100202,'Adrianpolis','PR'),
  (4100301,'Agudos do Sul','PR'),
  (4100400,'Almirante Tamandar','PR'),
  (4100459,'Altamira do Paran','PR'),
  (4100509,'Altnia','PR'),
  (4100608,'Alto Paran','PR'),
  (4100707,'Alto Piquiri','PR'),
  (4100806,'Alvorada do Sul','PR'),
  (4100905,'Amapor','PR'),
  (4101002,'Ampre','PR'),
  (4101051,'Anahy','PR'),
  (4101101,'Andir','PR'),
  (4101150,'ngulo','PR'),
  (4101200,'Antonina','PR'),
  (4101309,'Antnio Olinto','PR'),
  (4101408,'Apucarana','PR'),
  (4101507,'Arapongas','PR'),
  (4101606,'Arapoti','PR'),
  (4101655,'Arapu','PR'),
  (4101705,'Araruna','PR'),
  (4101804,'Araucria','PR'),
  (4101853,'Ariranha do Iva','PR'),
  (4101903,'Assa','PR'),
  (4102000,'Assis Chateaubriand','PR'),
  (4102109,'Astorga','PR'),
  (4102208,'Atalaia','PR'),
  (4102307,'Balsa Nova','PR'),
  (4102406,'Bandeirantes','PR'),
  (4102505,'Barbosa Ferraz','PR'),
  (4102604,'Barraco','PR'),
  (4102703,'Barra do Jacar','PR'),
  (4102752,'Bela Vista da Caroba','PR'),
  (4102802,'Bela Vista do Paraso','PR'),
  (4102901,'Bituruna','PR'),
  (4103008,'Boa Esperana','PR'),
  (4103024,'Boa Esperana do Iguau','PR'),
  (4103040,'Boa Ventura de So Roque','PR'),
  (4103057,'Boa Vista da Aparecida','PR'),
  (4103107,'Bocaiva do Sul','PR'),
  (4103156,'Bom Jesus do Sul','PR'),
  (4103206,'Bom Sucesso','PR'),
  (4103222,'Bom Sucesso do Sul','PR'),
  (4103305,'Borrazpolis','PR'),
  (4103354,'Braganey','PR'),
  (4103370,'Brasilndia do Sul','PR'),
  (4103404,'Cafeara','PR'),
  (4103453,'Cafelndia','PR'),
  (4103479,'Cafezal do Sul','PR'),
  (4103503,'Califrnia','PR'),
  (4103602,'Cambar','PR'),
  (4103701,'Camb','PR'),
  (4103800,'Cambira','PR'),
  (4103909,'Campina da Lagoa','PR'),
  (4103958,'Campina do Simo','PR'),
  (4104006,'Campina Grande do Sul','PR'),
  (4104055,'Campo Bonito','PR'),
  (4104105,'Campo do Tenente','PR'),
  (4104204,'Campo Largo','PR'),
  (4104253,'Campo Magro','PR'),
  (4104303,'Campo Mouro','PR'),
  (4104402,'Cndido de Abreu','PR'),
  (4104428,'Candi','PR'),
  (4104451,'Cantagalo','PR'),
  (4104501,'Capanema','PR'),
  (4104600,'Capito Lenidas Marques','PR'),
  (4104659,'Carambe','PR'),
  (4104709,'Carlpolis','PR'),
  (4104808,'Cascavel','PR'),
  (4104907,'Castro','PR'),
  (4105003,'Catanduvas','PR'),
  (4105102,'Centenrio do Sul','PR'),
  (4105201,'Cerro Azul','PR'),
  (4105300,'Cu Azul','PR'),
  (4105409,'Chopinzinho','PR'),
  (4105508,'Cianorte','PR'),
  (4105607,'Cidade Gacha','PR'),
  (4105706,'Clevelndia','PR'),
  (4105805,'Colombo','PR'),
  (4105904,'Colorado','PR'),
  (4106001,'Congonhinhas','PR'),
  (4106100,'Conselheiro Mairinck','PR'),
  (4106209,'Contenda','PR'),
  (4106308,'Corblia','PR'),
  (4106407,'Cornlio Procpio','PR'),
  (4106456,'Coronel Domingos Soares','PR'),
  (4106506,'Coronel Vivida','PR'),
  (4106555,'Corumbata do Sul','PR'),
  (4106571,'Cruzeiro do Iguau','PR');

INSERT INTO municipios (municipio_id, municipio_nome, estado_sigla) VALUES 
  (4106605,'Cruzeiro do Oeste','PR'),
  (4106704,'Cruzeiro do Sul','PR'),
  (4106803,'Cruz Machado','PR'),
  (4106852,'Cruzmaltina','PR'),
  (4106902,'Curitiba','PR'),
  (4107009,'Curiva','PR'),
  (4107108,'Diamante do Norte','PR'),
  (4107124,'Diamante do Sul','PR'),
  (4107157,'Diamante D''Oeste','PR'),
  (4107207,'Dois Vizinhos','PR'),
  (4107256,'Douradina','PR'),
  (4107306,'Doutor Camargo','PR'),
  (4107405,'Enas Marques','PR'),
  (4107504,'Engenheiro Beltro','PR'),
  (4107520,'Esperana Nova','PR'),
  (4107538,'Entre Rios do Oeste','PR'),
  (4107546,'Espigo Alto do Iguau','PR'),
  (4107553,'Farol','PR'),
  (4107603,'Faxinal','PR'),
  (4107652,'Fazenda Rio Grande','PR'),
  (4107702,'Fnix','PR'),
  (4107736,'Fernandes Pinheiro','PR'),
  (4107751,'Figueira','PR'),
  (4107801,'Flora','PR'),
  (4107850,'Flor da Serra do Sul','PR'),
  (4107900,'Floresta','PR'),
  (4108007,'Florestpolis','PR'),
  (4108106,'Flrida','PR'),
  (4108205,'Formosa do Oeste','PR'),
  (4108304,'Foz do Iguau','PR'),
  (4108320,'Francisco Alves','PR'),
  (4108403,'Francisco Beltro','PR'),
  (4108452,'Foz do Jordo','PR'),
  (4108502,'General Carneiro','PR'),
  (4108551,'Godoy Moreira','PR'),
  (4108601,'Goioer','PR'),
  (4108650,'Goioxim','PR'),
  (4108700,'Grandes Rios','PR'),
  (4108809,'Guara','PR'),
  (4108908,'Guaira','PR'),
  (4108957,'Guamiranga','PR'),
  (4109005,'Guapirama','PR'),
  (4109104,'Guaporema','PR'),
  (4109203,'Guaraci','PR'),
  (4109302,'Guaraniau','PR'),
  (4109401,'Guarapuava','PR'),
  (4109500,'Guaraqueaba','PR'),
  (4109609,'Guaratuba','PR'),
  (4109658,'Honrio Serpa','PR'),
  (4109708,'Ibaiti','PR'),
  (4109757,'Ibema','PR'),
  (4109807,'Ibipor','PR'),
  (4109906,'Icarama','PR'),
  (4110003,'Iguarau','PR'),
  (4110052,'Iguatu','PR'),
  (4110078,'Imba','PR'),
  (4110102,'Imbituva','PR'),
  (4110201,'Incio Martins','PR'),
  (4110300,'Inaj','PR'),
  (4110409,'Indianpolis','PR'),
  (4110508,'Ipiranga','PR'),
  (4110607,'Ipor','PR'),
  (4110656,'Iracema do Oeste','PR'),
  (4110706,'Irati','PR'),
  (4110805,'Iretama','PR'),
  (4110904,'Itaguaj','PR'),
  (4110953,'Itaipulndia','PR'),
  (4111001,'Itambarac','PR'),
  (4111100,'Itamb','PR'),
  (4111209,'Itapejara d''Oeste','PR'),
  (4111258,'Itaperuu','PR'),
  (4111308,'Itana do Sul','PR'),
  (4111407,'Iva','PR'),
  (4111506,'Ivaipor','PR'),
  (4111555,'Ivat','PR'),
  (4111605,'Ivatuba','PR'),
  (4111704,'Jaboti','PR'),
  (4111803,'Jacarezinho','PR'),
  (4111902,'Jaguapit','PR'),
  (4112009,'Jaguariava','PR'),
  (4112108,'Jandaia do Sul','PR'),
  (4112207,'Janipolis','PR'),
  (4112306,'Japira','PR'),
  (4112405,'Japur','PR'),
  (4112504,'Jardim Alegre','PR'),
  (4112603,'Jardim Olinda','PR'),
  (4112702,'Jataizinho','PR'),
  (4112751,'Jesutas','PR'),
  (4112801,'Joaquim Tvora','PR'),
  (4112900,'Jundia do Sul','PR'),
  (4112959,'Juranda','PR'),
  (4113007,'Jussara','PR'),
  (4113106,'Kalor','PR'),
  (4113205,'Lapa','PR'),
  (4113254,'Laranjal','PR'),
  (4113304,'Laranjeiras do Sul','PR'),
  (4113403,'Lepolis','PR'),
  (4113429,'Lidianpolis','PR'),
  (4113452,'Lindoeste','PR'),
  (4113502,'Loanda','PR'),
  (4113601,'Lobato','PR'),
  (4113700,'Londrina','PR'),
  (4113734,'Luiziana','PR'),
  (4113759,'Lunardelli','PR'),
  (4113809,'Lupionpolis','PR'),
  (4113908,'Mallet','PR'),
  (4114005,'Mambor','PR'),
  (4114104,'Mandaguau','PR'),
  (4114203,'Mandaguari','PR'),
  (4114302,'Mandirituba','PR'),
  (4114351,'Manfrinpolis','PR'),
  (4114401,'Mangueirinha','PR'),
  (4114500,'Manoel Ribas','PR'),
  (4114609,'Marechal Cndido Rondon','PR'),
  (4114708,'Maria Helena','PR'),
  (4114807,'Marialva','PR'),
  (4114906,'Marilndia do Sul','PR'),
  (4115002,'Marilena','PR'),
  (4115101,'Mariluz','PR'),
  (4115200,'Maring','PR'),
  (4115309,'Maripolis','PR'),
  (4115358,'Marip','PR'),
  (4115408,'Marmeleiro','PR'),
  (4115457,'Marquinho','PR'),
  (4115507,'Marumbi','PR'),
  (4115606,'Matelndia','PR'),
  (4115705,'Matinhos','PR'),
  (4115739,'Mato Rico','PR'),
  (4115754,'Mau da Serra','PR'),
  (4115804,'Medianeira','PR'),
  (4115853,'Mercedes','PR'),
  (4115903,'Mirador','PR'),
  (4116000,'Miraselva','PR'),
  (4116059,'Missal','PR'),
  (4116109,'Moreira Sales','PR'),
  (4116208,'Morretes','PR'),
  (4116307,'Munhoz de Melo','PR'),
  (4116406,'Nossa Senhora das Graas','PR'),
  (4116505,'Nova Aliana do Iva','PR'),
  (4116604,'Nova Amrica da Colina','PR'),
  (4116703,'Nova Aurora','PR'),
  (4116802,'Nova Cantu','PR'),
  (4116901,'Nova Esperana','PR'),
  (4116950,'Nova Esperana do Sudoeste','PR'),
  (4117008,'Nova Ftima','PR'),
  (4117057,'Nova Laranjeiras','PR'),
  (4117107,'Nova Londrina','PR'),
  (4117206,'Nova Olmpia','PR'),
  (4117214,'Nova Santa Brbara','PR'),
  (4117222,'Nova Santa Rosa','PR'),
  (4117255,'Nova Prata do Iguau','PR'),
  (4117271,'Nova Tebas','PR'),
  (4117297,'Novo Itacolomi','PR'),
  (4117305,'Ortigueira','PR'),
  (4117404,'Ourizona','PR'),
  (4117453,'Ouro Verde do Oeste','PR'),
  (4117503,'Paiandu','PR'),
  (4117602,'Palmas','PR'),
  (4117701,'Palmeira','PR'),
  (4117800,'Palmital','PR'),
  (4117909,'Palotina','PR'),
  (4118006,'Paraso do Norte','PR'),
  (4118105,'Paranacity','PR'),
  (4118204,'Paranagu','PR'),
  (4118303,'Paranapoema','PR'),
  (4118402,'Paranava','PR'),
  (4118451,'Pato Bragado','PR'),
  (4118501,'Pato Branco','PR'),
  (4118600,'Paula Freitas','PR'),
  (4118709,'Paulo Frontin','PR'),
  (4118808,'Peabiru','PR'),
  (4118857,'Perobal','PR'),
  (4118907,'Prola','PR'),
  (4119004,'Prola d''Oeste','PR'),
  (4119103,'Pin','PR'),
  (4119152,'Pinhais','PR'),
  (4119202,'Pinhalo','PR'),
  (4119251,'Pinhal de So Bento','PR'),
  (4119301,'Pinho','PR'),
  (4119400,'Pira do Sul','PR'),
  (4119509,'Piraquara','PR'),
  (4119608,'Pitanga','PR'),
  (4119657,'Pitangueiras','PR'),
  (4119707,'Planaltina do Paran','PR'),
  (4119806,'Planalto','PR'),
  (4119905,'Ponta Grossa','PR'),
  (4119954,'Pontal do Paran','PR'),
  (4120002,'Porecatu','PR'),
  (4120101,'Porto Amazonas','PR'),
  (4120150,'Porto Barreiro','PR'),
  (4120200,'Porto Rico','PR'),
  (4120309,'Porto Vitria','PR'),
  (4120333,'Prado Ferreira','PR'),
  (4120358,'Pranchita','PR'),
  (4120408,'Presidente Castelo Branco','PR'),
  (4120507,'Primeiro de Maio','PR'),
  (4120606,'Prudentpolis','PR'),
  (4120655,'Quarto Centenrio','PR'),
  (4120705,'Quatigu','PR'),
  (4120804,'Quatro Barras','PR'),
  (4120853,'Quatro Pontes','PR'),
  (4120903,'Quedas do Iguau','PR'),
  (4121000,'Querncia do Norte','PR'),
  (4121109,'Quinta do Sol','PR'),
  (4121208,'Quitandinha','PR'),
  (4121257,'Ramilndia','PR'),
  (4121307,'Rancho Alegre','PR'),
  (4121356,'Rancho Alegre D''Oeste','PR'),
  (4121406,'Realeza','PR'),
  (4121505,'Rebouas','PR'),
  (4121604,'Renascena','PR'),
  (4121703,'Reserva','PR'),
  (4121752,'Reserva do Iguau','PR'),
  (4121802,'Ribeiro Claro','PR'),
  (4121901,'Ribeiro do Pinhal','PR'),
  (4122008,'Rio Azul','PR'),
  (4122107,'Rio Bom','PR'),
  (4122156,'Rio Bonito do Iguau','PR'),
  (4122172,'Rio Branco do Iva','PR'),
  (4122206,'Rio Branco do Sul','PR'),
  (4122305,'Rio Negro','PR'),
  (4122404,'Rolndia','PR'),
  (4122503,'Roncador','PR'),
  (4122602,'Rondon','PR'),
  (4122651,'Rosrio do Iva','PR'),
  (4122701,'Sabudia','PR'),
  (4122800,'Salgado Filho','PR'),
  (4122909,'Salto do Itarar','PR'),
  (4123006,'Salto do Lontra','PR'),
  (4123105,'Santa Amlia','PR'),
  (4123204,'Santa Ceclia do Pavo','PR'),
  (4123303,'Santa Cruz de Monte Castelo','PR'),
  (4123402,'Santa F','PR'),
  (4123501,'Santa Helena','PR'),
  (4123600,'Santa Ins','PR'),
  (4123709,'Santa Isabel do Iva','PR'),
  (4123808,'Santa Izabel do Oeste','PR'),
  (4123824,'Santa Lcia','PR'),
  (4123857,'Santa Maria do Oeste','PR'),
  (4123907,'Santa Mariana','PR'),
  (4123956,'Santa Mnica','PR'),
  (4124004,'Santana do Itarar','PR'),
  (4124020,'Santa Tereza do Oeste','PR'),
  (4124053,'Santa Terezinha de Itaipu','PR'),
  (4124103,'Santo Antnio da Platina','PR'),
  (4124202,'Santo Antnio do Caiu','PR'),
  (4124301,'Santo Antnio do Paraso','PR'),
  (4124400,'Santo Antnio do Sudoeste','PR'),
  (4124509,'Santo Incio','PR'),
  (4124608,'So Carlos do Iva','PR'),
  (4124707,'So Jernimo da Serra','PR'),
  (4124806,'So Joo','PR'),
  (4124905,'So Joo do Caiu','PR'),
  (4125001,'So Joo do Iva','PR'),
  (4125100,'So Joo do Triunfo','PR'),
  (4125209,'So Jorge d''Oeste','PR'),
  (4125308,'So Jorge do Iva','PR'),
  (4125357,'So Jorge do Patrocnio','PR'),
  (4125407,'So Jos da Boa Vista','PR'),
  (4125456,'So Jos das Palmeiras','PR'),
  (4125506,'So Jos dos Pinhais','PR'),
  (4125555,'So Manoel do Paran','PR'),
  (4125605,'So Mateus do Sul','PR'),
  (4125704,'So Miguel do Iguau','PR'),
  (4125753,'So Pedro do Iguau','PR'),
  (4125803,'So Pedro do Iva','PR'),
  (4125902,'So Pedro do Paran','PR'),
  (4126009,'So Sebastio da Amoreira','PR'),
  (4126108,'So Tom','PR'),
  (4126207,'Sapopema','PR'),
  (4126256,'Sarandi','PR'),
  (4126272,'Saudade do Iguau','PR'),
  (4126306,'Sengs','PR'),
  (4126355,'Serranpolis do Iguau','PR'),
  (4126405,'Sertaneja','PR'),
  (4126504,'Sertanpolis','PR'),
  (4126603,'Siqueira Campos','PR'),
  (4126652,'Sulina','PR'),
  (4126678,'Tamarana','PR'),
  (4126702,'Tamboara','PR'),
  (4126801,'Tapejara','PR'),
  (4126900,'Tapira','PR'),
  (4127007,'Teixeira Soares','PR'),
  (4127106,'Telmaco Borba','PR'),
  (4127205,'Terra Boa','PR'),
  (4127304,'Terra Rica','PR'),
  (4127403,'Terra Roxa','PR'),
  (4127502,'Tibagi','PR'),
  (4127601,'Tijucas do Sul','PR'),
  (4127700,'Toledo','PR'),
  (4127809,'Tomazina','PR'),
  (4127858,'Trs Barras do Paran','PR'),
  (4127882,'Tunas do Paran','PR'),
  (4127908,'Tuneiras do Oeste','PR'),
  (4127957,'Tupssi','PR'),
  (4127965,'Turvo','PR'),
  (4128005,'Ubirat','PR'),
  (4128104,'Umuarama','PR'),
  (4128203,'Unio da Vitria','PR'),
  (4128302,'Uniflor','PR'),
  (4128401,'Ura','PR'),
  (4128500,'Wenceslau Braz','PR'),
  (4128534,'Ventania','PR'),
  (4128559,'Vera Cruz do Oeste','PR'),
  (4128609,'Ver','PR'),
  (4128625,'Alto Paraso','PR'),
  (4128633,'Doutor Ulysses','PR'),
  (4128658,'Virmond','PR'),
  (4128708,'Vitorino','PR'),
  (4128807,'Xambr','PR'),
  (4200051,'Abdon Batista','SC'),
  (4200101,'Abelardo Luz','SC'),
  (4200200,'Agrolndia','SC'),
  (4200309,'Agronmica','SC'),
  (4200408,'gua Doce','SC'),
  (4200507,'guas de Chapec','SC'),
  (4200556,'guas Frias','SC'),
  (4200606,'guas Mornas','SC'),
  (4200705,'Alfredo Wagner','SC'),
  (4200754,'Alto Bela Vista','SC'),
  (4200804,'Anchieta','SC'),
  (4200903,'Angelina','SC'),
  (4201000,'Anita Garibaldi','SC'),
  (4201109,'Anitpolis','SC'),
  (4201208,'Antnio Carlos','SC'),
  (4201257,'Apina','SC'),
  (4201273,'Arabut','SC'),
  (4201307,'Araquari','SC'),
  (4201406,'Ararangu','SC'),
  (4201505,'Armazm','SC'),
  (4201604,'Arroio Trinta','SC'),
  (4201653,'Arvoredo','SC'),
  (4201703,'Ascurra','SC'),
  (4201802,'Atalanta','SC'),
  (4201901,'Aurora','SC'),
  (4201950,'Balnerio Arroio do Silva','SC'),
  (4202008,'Balnerio Cambori','SC'),
  (4202057,'Balnerio Barra do Sul','SC'),
  (4202073,'Balnerio Gaivota','SC'),
  (4202081,'Bandeirante','SC'),
  (4202099,'Barra Bonita','SC'),
  (4202107,'Barra Velha','SC'),
  (4202131,'Bela Vista do Toldo','SC'),
  (4202156,'Belmonte','SC'),
  (4202206,'Benedito Novo','SC'),
  (4202305,'Biguau','SC'),
  (4202404,'Blumenau','SC'),
  (4202438,'Bocaina do Sul','SC'),
  (4202453,'Bombinhas','SC'),
  (4202503,'Bom Jardim da Serra','SC'),
  (4202537,'Bom Jesus','SC'),
  (4202578,'Bom Jesus do Oeste','SC'),
  (4202602,'Bom Retiro','SC'),
  (4202701,'Botuver','SC'),
  (4202800,'Brao do Norte','SC'),
  (4202859,'Brao do Trombudo','SC'),
  (4202875,'Brunpolis','SC'),
  (4202909,'Brusque','SC'),
  (4203006,'Caador','SC'),
  (4203105,'Caibi','SC'),
  (4203154,'Calmon','SC'),
  (4203204,'Cambori','SC'),
  (4203253,'Capo Alto','SC'),
  (4203303,'Campo Alegre','SC'),
  (4203402,'Campo Belo do Sul','SC'),
  (4203501,'Campo Er','SC'),
  (4203600,'Campos Novos','SC'),
  (4203709,'Canelinha','SC'),
  (4203808,'Canoinhas','SC'),
  (4203907,'Capinzal','SC'),
  (4203956,'Capivari de Baixo','SC'),
  (4204004,'Catanduvas','SC'),
  (4204103,'Caxambu do Sul','SC'),
  (4204152,'Celso Ramos','SC'),
  (4204178,'Cerro Negro','SC'),
  (4204194,'Chapado do Lageado','SC'),
  (4204202,'Chapec','SC'),
  (4204251,'Cocal do Sul','SC'),
  (4204301,'Concrdia','SC'),
  (4204350,'Cordilheira Alta','SC'),
  (4204400,'Coronel Freitas','SC'),
  (4204459,'Coronel Martins','SC'),
  (4204509,'Corup','SC'),
  (4204558,'Correia Pinto','SC'),
  (4204608,'Cricima','SC'),
  (4204707,'Cunha Por','SC'),
  (4204756,'Cunhata','SC'),
  (4204806,'Curitibanos','SC'),
  (4204905,'Descanso','SC'),
  (4205001,'Dionsio Cerqueira','SC'),
  (4205100,'Dona Emma','SC'),
  (4205159,'Doutor Pedrinho','SC'),
  (4205175,'Entre Rios','SC'),
  (4205191,'Ermo','SC'),
  (4205209,'Erval Velho','SC'),
  (4205308,'Faxinal dos Guedes','SC'),
  (4205357,'Flor do Serto','SC'),
  (4205407,'Florianpolis','SC'),
  (4205431,'Formosa do Sul','SC'),
  (4205456,'Forquilhinha','SC'),
  (4205506,'Fraiburgo','SC'),
  (4205555,'Frei Rogrio','SC'),
  (4205605,'Galvo','SC'),
  (4205704,'Garopaba','SC'),
  (4205803,'Garuva','SC'),
  (4205902,'Gaspar','SC'),
  (4206009,'Governador Celso Ramos','SC'),
  (4206108,'Gro Par','SC'),
  (4206207,'Gravatal','SC'),
  (4206306,'Guabiruba','SC'),
  (4206405,'Guaraciaba','SC'),
  (4206504,'Guaramirim','SC'),
  (4206603,'Guaruj do Sul','SC'),
  (4206652,'Guatamb','SC'),
  (4206702,'Herval d''Oeste','SC'),
  (4206751,'Ibiam','SC'),
  (4206801,'Ibicar','SC'),
  (4206900,'Ibirama','SC'),
  (4207007,'Iara','SC'),
  (4207106,'Ilhota','SC'),
  (4207205,'Imaru','SC'),
  (4207304,'Imbituba','SC'),
  (4207403,'Imbuia','SC'),
  (4207502,'Indaial','SC'),
  (4207577,'Iomer','SC'),
  (4207601,'Ipira','SC'),
  (4207650,'Ipor do Oeste','SC'),
  (4207684,'Ipuau','SC'),
  (4207700,'Ipumirim','SC'),
  (4207759,'Iraceminha','SC'),
  (4207809,'Irani','SC'),
  (4207858,'Irati','SC'),
  (4207908,'Irinepolis','SC'),
  (4208005,'It','SC'),
  (4208104,'Itaipolis','SC'),
  (4208203,'Itaja','SC'),
  (4208302,'Itapema','SC'),
  (4208401,'Itapiranga','SC'),
  (4208450,'Itapo','SC'),
  (4208500,'Ituporanga','SC'),
  (4208609,'Jabor','SC'),
  (4208708,'Jacinto Machado','SC'),
  (4208807,'Jaguaruna','SC'),
  (4208906,'Jaragu do Sul','SC'),
  (4208955,'Jardinpolis','SC'),
  (4209003,'Joaaba','SC'),
  (4209102,'Joinville','SC'),
  (4209151,'Jos Boiteux','SC'),
  (4209177,'Jupi','SC'),
  (4209201,'Lacerdpolis','SC'),
  (4209300,'Lages','SC'),
  (4209409,'Laguna','SC'),
  (4209458,'Lajeado Grande','SC'),
  (4209508,'Laurentino','SC'),
  (4209607,'Lauro Muller','SC'),
  (4209706,'Lebon Rgis','SC'),
  (4209805,'Leoberto Leal','SC'),
  (4209854,'Lindia do Sul','SC'),
  (4209904,'Lontras','SC'),
  (4210001,'Luiz Alves','SC'),
  (4210035,'Luzerna','SC'),
  (4210050,'Macieira','SC'),
  (4210100,'Mafra','SC'),
  (4210209,'Major Gercino','SC'),
  (4210308,'Major Vieira','SC'),
  (4210407,'Maracaj','SC'),
  (4210506,'Maravilha','SC'),
  (4210555,'Marema','SC'),
  (4210605,'Massaranduba','SC'),
  (4210704,'Matos Costa','SC'),
  (4210803,'Meleiro','SC'),
  (4210852,'Mirim Doce','SC'),
  (4210902,'Modelo','SC'),
  (4211009,'Monda','SC'),
  (4211058,'Monte Carlo','SC'),
  (4211108,'Monte Castelo','SC'),
  (4211207,'Morro da Fumaa','SC'),
  (4211256,'Morro Grande','SC'),
  (4211306,'Navegantes','SC'),
  (4211405,'Nova Erechim','SC'),
  (4211454,'Nova Itaberaba','SC'),
  (4211504,'Nova Trento','SC'),
  (4211603,'Nova Veneza','SC'),
  (4211652,'Novo Horizonte','SC'),
  (4211702,'Orleans','SC'),
  (4211751,'Otaclio Costa','SC'),
  (4211801,'Ouro','SC'),
  (4211850,'Ouro Verde','SC'),
  (4211876,'Paial','SC'),
  (4211892,'Painel','SC'),
  (4211900,'Palhoa','SC'),
  (4212007,'Palma Sola','SC'),
  (4212056,'Palmeira','SC'),
  (4212106,'Palmitos','SC'),
  (4212205,'Papanduva','SC'),
  (4212239,'Paraso','SC'),
  (4212254,'Passo de Torres','SC'),
  (4212270,'Passos Maia','SC'),
  (4212304,'Paulo Lopes','SC'),
  (4212403,'Pedras Grandes','SC');

INSERT INTO municipios (municipio_id, municipio_nome, estado_sigla) VALUES 
  (4212502,'Penha','SC'),
  (4212601,'Peritiba','SC'),
  (4212700,'Petrolndia','SC'),
  (4212809,'Balnerio Piarras','SC'),
  (4212908,'Pinhalzinho','SC'),
  (4213005,'Pinheiro Preto','SC'),
  (4213104,'Piratuba','SC'),
  (4213153,'Planalto Alegre','SC'),
  (4213203,'Pomerode','SC'),
  (4213302,'Ponte Alta','SC'),
  (4213351,'Ponte Alta do Norte','SC'),
  (4213401,'Ponte Serrada','SC'),
  (4213500,'Porto Belo','SC'),
  (4213609,'Porto Unio','SC'),
  (4213708,'Pouso Redondo','SC'),
  (4213807,'Praia Grande','SC'),
  (4213906,'Presidente Castello Branco','SC'),
  (4214003,'Presidente Getlio','SC'),
  (4214102,'Presidente Nereu','SC'),
  (4214151,'Princesa','SC'),
  (4214201,'Quilombo','SC'),
  (4214300,'Rancho Queimado','SC'),
  (4214409,'Rio das Antas','SC'),
  (4214508,'Rio do Campo','SC'),
  (4214607,'Rio do Oeste','SC'),
  (4214706,'Rio dos Cedros','SC'),
  (4214805,'Rio do Sul','SC'),
  (4214904,'Rio Fortuna','SC'),
  (4215000,'Rio Negrinho','SC'),
  (4215059,'Rio Rufino','SC'),
  (4215075,'Riqueza','SC'),
  (4215109,'Rodeio','SC'),
  (4215208,'Romelndia','SC'),
  (4215307,'Salete','SC'),
  (4215356,'Saltinho','SC'),
  (4215406,'Salto Veloso','SC'),
  (4215455,'Sango','SC'),
  (4215505,'Santa Ceclia','SC'),
  (4215554,'Santa Helena','SC'),
  (4215604,'Santa Rosa de Lima','SC'),
  (4215653,'Santa Rosa do Sul','SC'),
  (4215679,'Santa Terezinha','SC'),
  (4215687,'Santa Terezinha do Progresso','SC'),
  (4215695,'Santiago do Sul','SC'),
  (4215703,'Santo Amaro da Imperatriz','SC'),
  (4215752,'So Bernardino','SC'),
  (4215802,'So Bento do Sul','SC'),
  (4215901,'So Bonifcio','SC'),
  (4216008,'So Carlos','SC'),
  (4216057,'So Cristovo do Sul','SC'),
  (4216107,'So Domingos','SC'),
  (4216206,'So Francisco do Sul','SC'),
  (4216255,'So Joo do Oeste','SC'),
  (4216305,'So Joo Batista','SC'),
  (4216354,'So Joo do Itaperi','SC'),
  (4216404,'So Joo do Sul','SC'),
  (4216503,'So Joaquim','SC'),
  (4216602,'So Jos','SC'),
  (4216701,'So Jos do Cedro','SC'),
  (4216800,'So Jos do Cerrito','SC'),
  (4216909,'So Loureno do Oeste','SC'),
  (4217006,'So Ludgero','SC'),
  (4217105,'So Martinho','SC'),
  (4217154,'So Miguel da Boa Vista','SC'),
  (4217204,'So Miguel do Oeste','SC'),
  (4217253,'So Pedro de Alcntara','SC'),
  (4217303,'Saudades','SC'),
  (4217402,'Schroeder','SC'),
  (4217501,'Seara','SC'),
  (4217550,'Serra Alta','SC'),
  (4217600,'Siderpolis','SC'),
  (4217709,'Sombrio','SC'),
  (4217758,'Sul Brasil','SC'),
  (4217808,'Tai','SC'),
  (4217907,'Tangar','SC'),
  (4217956,'Tigrinhos','SC'),
  (4218004,'Tijucas','SC'),
  (4218103,'Timb do Sul','SC'),
  (4218202,'Timb','SC'),
  (4218251,'Timb Grande','SC'),
  (4218301,'Trs Barras','SC'),
  (4218350,'Treviso','SC'),
  (4218400,'Treze de Maio','SC'),
  (4218509,'Treze Tlias','SC'),
  (4218608,'Trombudo Central','SC'),
  (4218707,'Tubaro','SC'),
  (4218756,'Tunpolis','SC'),
  (4218806,'Turvo','SC'),
  (4218855,'Unio do Oeste','SC'),
  (4218905,'Urubici','SC'),
  (4218954,'Urupema','SC'),
  (4219002,'Urussanga','SC'),
  (4219101,'Vargeo','SC'),
  (4219150,'Vargem','SC'),
  (4219176,'Vargem Bonita','SC'),
  (4219200,'Vidal Ramos','SC'),
  (4219309,'Videira','SC'),
  (4219358,'Vitor Meireles','SC'),
  (4219408,'Witmarsum','SC'),
  (4219507,'Xanxer','SC'),
  (4219606,'Xavantina','SC'),
  (4219705,'Xaxim','SC'),
  (4219853,'Zorta','SC'),
  (4300034,'Acegu','RS'),
  (4300059,'gua Santa','RS'),
  (4300109,'Agudo','RS'),
  (4300208,'Ajuricaba','RS'),
  (4300307,'Alecrim','RS'),
  (4300406,'Alegrete','RS'),
  (4300455,'Alegria','RS'),
  (4300471,'Almirante Tamandar do Sul','RS'),
  (4300505,'Alpestre','RS'),
  (4300554,'Alto Alegre','RS'),
  (4300570,'Alto Feliz','RS'),
  (4300604,'Alvorada','RS'),
  (4300638,'Amaral Ferrador','RS'),
  (4300646,'Ametista do Sul','RS'),
  (4300661,'Andr da Rocha','RS'),
  (4300703,'Anta Gorda','RS'),
  (4300802,'Antnio Prado','RS'),
  (4300851,'Arambar','RS'),
  (4300877,'Araric','RS'),
  (4300901,'Aratiba','RS'),
  (4301008,'Arroio do Meio','RS'),
  (4301057,'Arroio do Sal','RS'),
  (4301073,'Arroio do Padre','RS'),
  (4301107,'Arroio dos Ratos','RS'),
  (4301206,'Arroio do Tigre','RS'),
  (4301305,'Arroio Grande','RS'),
  (4301404,'Arvorezinha','RS'),
  (4301503,'Augusto Pestana','RS'),
  (4301552,'urea','RS'),
  (4301602,'Bag','RS'),
  (4301636,'Balnerio Pinhal','RS'),
  (4301651,'Baro','RS'),
  (4301701,'Baro de Cotegipe','RS'),
  (4301750,'Baro do Triunfo','RS'),
  (4301800,'Barraco','RS'),
  (4301859,'Barra do Guarita','RS'),
  (4301875,'Barra do Quara','RS'),
  (4301909,'Barra do Ribeiro','RS'),
  (4301925,'Barra do Rio Azul','RS'),
  (4301958,'Barra Funda','RS'),
  (4302006,'Barros Cassal','RS'),
  (4302055,'Benjamin Constant do Sul','RS'),
  (4302105,'Bento Gonalves','RS'),
  (4302154,'Boa Vista das Misses','RS'),
  (4302204,'Boa Vista do Buric','RS'),
  (4302220,'Boa Vista do Cadeado','RS'),
  (4302238,'Boa Vista do Incra','RS'),
  (4302253,'Boa Vista do Sul','RS'),
  (4302303,'Bom Jesus','RS'),
  (4302352,'Bom Princpio','RS'),
  (4302378,'Bom Progresso','RS'),
  (4302402,'Bom Retiro do Sul','RS'),
  (4302451,'Boqueiro do Leo','RS'),
  (4302501,'Bossoroca','RS'),
  (4302584,'Bozano','RS'),
  (4302600,'Braga','RS'),
  (4302659,'Brochier','RS'),
  (4302709,'Buti','RS'),
  (4302808,'Caapava do Sul','RS'),
  (4302907,'Cacequi','RS'),
  (4303004,'Cachoeira do Sul','RS'),
  (4303103,'Cachoeirinha','RS'),
  (4303202,'Cacique Doble','RS'),
  (4303301,'Caibat','RS'),
  (4303400,'Caiara','RS'),
  (4303509,'Camaqu','RS'),
  (4303558,'Camargo','RS'),
  (4303608,'Cambar do Sul','RS'),
  (4303673,'Campestre da Serra','RS'),
  (4303707,'Campina das Misses','RS'),
  (4303806,'Campinas do Sul','RS'),
  (4303905,'Campo Bom','RS'),
  (4304002,'Campo Novo','RS'),
  (4304101,'Campos Borges','RS'),
  (4304200,'Candelria','RS'),
  (4304309,'Cndido Godi','RS'),
  (4304358,'Candiota','RS'),
  (4304408,'Canela','RS'),
  (4304507,'Canguu','RS'),
  (4304606,'Canoas','RS'),
  (4304614,'Canudos do Vale','RS'),
  (4304622,'Capo Bonito do Sul','RS'),
  (4304630,'Capo da Canoa','RS'),
  (4304655,'Capo do Cip','RS'),
  (4304663,'Capo do Leo','RS'),
  (4304671,'Capivari do Sul','RS'),
  (4304689,'Capela de Santana','RS'),
  (4304697,'Capito','RS'),
  (4304705,'Carazinho','RS'),
  (4304713,'Cara','RS'),
  (4304804,'Carlos Barbosa','RS'),
  (4304853,'Carlos Gomes','RS'),
  (4304903,'Casca','RS'),
  (4304952,'Caseiros','RS'),
  (4305009,'Catupe','RS'),
  (4305108,'Caxias do Sul','RS'),
  (4305116,'Centenrio','RS'),
  (4305124,'Cerrito','RS'),
  (4305132,'Cerro Branco','RS'),
  (4305157,'Cerro Grande','RS'),
  (4305173,'Cerro Grande do Sul','RS'),
  (4305207,'Cerro Largo','RS'),
  (4305306,'Chapada','RS'),
  (4305355,'Charqueadas','RS'),
  (4305371,'Charrua','RS'),
  (4305405,'Chiapetta','RS'),
  (4305439,'Chu','RS'),
  (4305447,'Chuvisca','RS'),
  (4305454,'Cidreira','RS'),
  (4305504,'Ciraco','RS'),
  (4305587,'Colinas','RS'),
  (4305603,'Colorado','RS'),
  (4305702,'Condor','RS'),
  (4305801,'Constantina','RS'),
  (4305835,'Coqueiro Baixo','RS'),
  (4305850,'Coqueiros do Sul','RS'),
  (4305871,'Coronel Barros','RS'),
  (4305900,'Coronel Bicaco','RS'),
  (4305934,'Coronel Pilar','RS'),
  (4305959,'Cotipor','RS'),
  (4305975,'Coxilha','RS'),
  (4306007,'Crissiumal','RS'),
  (4306056,'Cristal','RS'),
  (4306072,'Cristal do Sul','RS'),
  (4306106,'Cruz Alta','RS'),
  (4306130,'Cruzaltense','RS'),
  (4306205,'Cruzeiro do Sul','RS'),
  (4306304,'David Canabarro','RS'),
  (4306320,'Derrubadas','RS'),
  (4306353,'Dezesseis de Novembro','RS'),
  (4306379,'Dilermando de Aguiar','RS'),
  (4306403,'Dois Irmos','RS'),
  (4306429,'Dois Irmos das Misses','RS'),
  (4306452,'Dois Lajeados','RS'),
  (4306502,'Dom Feliciano','RS'),
  (4306551,'Dom Pedro de Alcntara','RS'),
  (4306601,'Dom Pedrito','RS'),
  (4306700,'Dona Francisca','RS'),
  (4306734,'Doutor Maurcio Cardoso','RS'),
  (4306759,'Doutor Ricardo','RS'),
  (4306767,'Eldorado do Sul','RS'),
  (4306809,'Encantado','RS'),
  (4306908,'Encruzilhada do Sul','RS'),
  (4306924,'Engenho Velho','RS'),
  (4306932,'Entre-Ijus','RS'),
  (4306957,'Entre Rios do Sul','RS'),
  (4306973,'Erebango','RS'),
  (4307005,'Erechim','RS'),
  (4307054,'Ernestina','RS'),
  (4307104,'Herval','RS'),
  (4307203,'Erval Grande','RS'),
  (4307302,'Erval Seco','RS'),
  (4307401,'Esmeralda','RS'),
  (4307450,'Esperana do Sul','RS'),
  (4307500,'Espumoso','RS'),
  (4307559,'Estao','RS'),
  (4307609,'Estncia Velha','RS'),
  (4307708,'Esteio','RS'),
  (4307807,'Estrela','RS'),
  (4307815,'Estrela Velha','RS'),
  (4307831,'Eugnio de Castro','RS'),
  (4307864,'Fagundes Varela','RS'),
  (4307906,'Farroupilha','RS'),
  (4308003,'Faxinal do Soturno','RS'),
  (4308052,'Faxinalzinho','RS'),
  (4308078,'Fazenda Vilanova','RS'),
  (4308102,'Feliz','RS'),
  (4308201,'Flores da Cunha','RS'),
  (4308250,'Floriano Peixoto','RS'),
  (4308300,'Fontoura Xavier','RS'),
  (4308409,'Formigueiro','RS'),
  (4308433,'Forquetinha','RS'),
  (4308458,'Fortaleza dos Valos','RS'),
  (4308508,'Frederico Westphalen','RS'),
  (4308607,'Garibaldi','RS'),
  (4308656,'Garruchos','RS'),
  (4308706,'Gaurama','RS'),
  (4308805,'General Cmara','RS'),
  (4308854,'Gentil','RS'),
  (4308904,'Getlio Vargas','RS'),
  (4309001,'Giru','RS'),
  (4309050,'Glorinha','RS'),
  (4309100,'Gramado','RS'),
  (4309126,'Gramado dos Loureiros','RS'),
  (4309159,'Gramado Xavier','RS'),
  (4309209,'Gravata','RS'),
  (4309258,'Guabiju','RS'),
  (4309308,'Guaba','RS'),
  (4309407,'Guapor','RS'),
  (4309506,'Guarani das Misses','RS'),
  (4309555,'Harmonia','RS'),
  (4309571,'Herveiras','RS'),
  (4309605,'Horizontina','RS'),
  (4309654,'Hulha Negra','RS'),
  (4309704,'Humait','RS'),
  (4309753,'Ibarama','RS'),
  (4309803,'Ibia','RS'),
  (4309902,'Ibiraiaras','RS'),
  (4309951,'Ibirapuit','RS'),
  (4310009,'Ibirub','RS'),
  (4310108,'Igrejinha','RS'),
  (4310207,'Iju','RS'),
  (4310306,'Ilpolis','RS'),
  (4310330,'Imb','RS'),
  (4310363,'Imigrante','RS'),
  (4310405,'Independncia','RS'),
  (4310413,'Inhacor','RS'),
  (4310439,'Ip','RS'),
  (4310462,'Ipiranga do Sul','RS'),
  (4310504,'Ira','RS'),
  (4310538,'Itaara','RS'),
  (4310553,'Itacurubi','RS'),
  (4310579,'Itapuca','RS'),
  (4310603,'Itaqui','RS'),
  (4310652,'Itati','RS'),
  (4310702,'Itatiba do Sul','RS'),
  (4310751,'Ivor','RS'),
  (4310801,'Ivoti','RS'),
  (4310850,'Jaboticaba','RS'),
  (4310876,'Jacuizinho','RS'),
  (4310900,'Jacutinga','RS'),
  (4311007,'Jaguaro','RS'),
  (4311106,'Jaguari','RS'),
  (4311122,'Jaquirana','RS'),
  (4311130,'Jari','RS'),
  (4311155,'Jia','RS'),
  (4311205,'Jlio de Castilhos','RS'),
  (4311239,'Lagoa Bonita do Sul','RS'),
  (4311254,'Lagoo','RS'),
  (4311270,'Lagoa dos Trs Cantos','RS'),
  (4311304,'Lagoa Vermelha','RS'),
  (4311403,'Lajeado','RS'),
  (4311429,'Lajeado do Bugre','RS'),
  (4311502,'Lavras do Sul','RS'),
  (4311601,'Liberato Salzano','RS'),
  (4311627,'Lindolfo Collor','RS'),
  (4311643,'Linha Nova','RS'),
  (4311700,'Machadinho','RS'),
  (4311718,'Maambar','RS'),
  (4311734,'Mampituba','RS'),
  (4311759,'Manoel Viana','RS'),
  (4311775,'Maquin','RS'),
  (4311791,'Marat','RS'),
  (4311809,'Marau','RS'),
  (4311908,'Marcelino Ramos','RS'),
  (4311981,'Mariana Pimentel','RS'),
  (4312005,'Mariano Moro','RS'),
  (4312054,'Marques de Souza','RS'),
  (4312104,'Mata','RS'),
  (4312138,'Mato Castelhano','RS'),
  (4312153,'Mato Leito','RS'),
  (4312179,'Mato Queimado','RS'),
  (4312203,'Maximiliano de Almeida','RS'),
  (4312252,'Minas do Leo','RS'),
  (4312302,'Miragua','RS'),
  (4312351,'Montauri','RS'),
  (4312377,'Monte Alegre dos Campos','RS'),
  (4312385,'Monte Belo do Sul','RS'),
  (4312401,'Montenegro','RS'),
  (4312427,'Mormao','RS'),
  (4312443,'Morrinhos do Sul','RS'),
  (4312450,'Morro Redondo','RS'),
  (4312476,'Morro Reuter','RS'),
  (4312500,'Mostardas','RS'),
  (4312609,'Muum','RS'),
  (4312617,'Muitos Capes','RS'),
  (4312625,'Muliterno','RS'),
  (4312658,'No-Me-Toque','RS'),
  (4312674,'Nicolau Vergueiro','RS'),
  (4312708,'Nonoai','RS'),
  (4312757,'Nova Alvorada','RS'),
  (4312807,'Nova Ara','RS'),
  (4312906,'Nova Bassano','RS'),
  (4312955,'Nova Boa Vista','RS'),
  (4313003,'Nova Brscia','RS'),
  (4313011,'Nova Candelria','RS'),
  (4313037,'Nova Esperana do Sul','RS'),
  (4313060,'Nova Hartz','RS'),
  (4313086,'Nova Pdua','RS'),
  (4313102,'Nova Palma','RS'),
  (4313201,'Nova Petrpolis','RS'),
  (4313300,'Nova Prata','RS'),
  (4313334,'Nova Ramada','RS'),
  (4313359,'Nova Roma do Sul','RS'),
  (4313375,'Nova Santa Rita','RS'),
  (4313391,'Novo Cabrais','RS'),
  (4313409,'Novo Hamburgo','RS'),
  (4313425,'Novo Machado','RS'),
  (4313441,'Novo Tiradentes','RS'),
  (4313466,'Novo Xingu','RS'),
  (4313490,'Novo Barreiro','RS'),
  (4313508,'Osrio','RS'),
  (4313607,'Paim Filho','RS'),
  (4313656,'Palmares do Sul','RS'),
  (4313706,'Palmeira das Misses','RS'),
  (4313805,'Palmitinho','RS'),
  (4313904,'Panambi','RS'),
  (4313953,'Pantano Grande','RS'),
  (4314001,'Para','RS'),
  (4314027,'Paraso do Sul','RS'),
  (4314035,'Pareci Novo','RS'),
  (4314050,'Parob','RS'),
  (4314068,'Passa Sete','RS'),
  (4314076,'Passo do Sobrado','RS'),
  (4314100,'Passo Fundo','RS'),
  (4314134,'Paulo Bento','RS'),
  (4314159,'Paverama','RS'),
  (4314175,'Pedras Altas','RS'),
  (4314209,'Pedro Osrio','RS'),
  (4314308,'Pejuara','RS'),
  (4314407,'Pelotas','RS'),
  (4314423,'Picada Caf','RS'),
  (4314456,'Pinhal','RS'),
  (4314464,'Pinhal da Serra','RS'),
  (4314472,'Pinhal Grande','RS'),
  (4314498,'Pinheirinho do Vale','RS'),
  (4314506,'Pinheiro Machado','RS'),
  (4314555,'Pirap','RS'),
  (4314605,'Piratini','RS'),
  (4314704,'Planalto','RS'),
  (4314753,'Poo das Antas','RS'),
  (4314779,'Ponto','RS'),
  (4314787,'Ponte Preta','RS'),
  (4314803,'Porto','RS'),
  (4314902,'Porto Alegre','RS'),
  (4315008,'Porto Lucena','RS'),
  (4315057,'Porto Mau','RS'),
  (4315073,'Porto Vera Cruz','RS'),
  (4315107,'Porto Xavier','RS'),
  (4315131,'Pouso Novo','RS'),
  (4315149,'Presidente Lucena','RS'),
  (4315156,'Progresso','RS'),
  (4315172,'Protsio Alves','RS'),
  (4315206,'Putinga','RS'),
  (4315305,'Quara','RS'),
  (4315313,'Quatro Irmos','RS'),
  (4315321,'Quevedos','RS'),
  (4315354,'Quinze de Novembro','RS'),
  (4315404,'Redentora','RS'),
  (4315453,'Relvado','RS'),
  (4315503,'Restinga Seca','RS'),
  (4315552,'Rio dos ndios','RS'),
  (4315602,'Rio Grande','RS'),
  (4315701,'Rio Pardo','RS'),
  (4315750,'Riozinho','RS'),
  (4315800,'Roca Sales','RS'),
  (4315909,'Rodeio Bonito','RS'),
  (4315958,'Rolador','RS'),
  (4316006,'Rolante','RS'),
  (4316105,'Ronda Alta','RS'),
  (4316204,'Rondinha','RS'),
  (4316303,'Roque Gonzales','RS'),
  (4316402,'Rosrio do Sul','RS'),
  (4316428,'Sagrada Famlia','RS'),
  (4316436,'Saldanha Marinho','RS'),
  (4316451,'Salto do Jacu','RS'),
  (4316477,'Salvador das Misses','RS'),
  (4316501,'Salvador do Sul','RS'),
  (4316600,'Sananduva','RS'),
  (4316709,'Santa Brbara do Sul','RS'),
  (4316733,'Santa Ceclia do Sul','RS'),
  (4316758,'Santa Clara do Sul','RS'),
  (4316808,'Santa Cruz do Sul','RS'),
  (4316907,'Santa Maria','RS'),
  (4316956,'Santa Maria do Herval','RS'),
  (4316972,'Santa Margarida do Sul','RS'),
  (4317004,'Santana da Boa Vista','RS'),
  (4317103,'Sant''Ana do Livramento','RS'),
  (4317202,'Santa Rosa','RS'),
  (4317251,'Santa Tereza','RS'),
  (4317301,'Santa Vitria do Palmar','RS'),
  (4317400,'Santiago','RS'),
  (4317509,'Santo ngelo','RS'),
  (4317558,'Santo Antnio do Palma','RS'),
  (4317608,'Santo Antnio da Patrulha','RS'),
  (4317707,'Santo Antnio das Misses','RS'),
  (4317756,'Santo Antnio do Planalto','RS'),
  (4317806,'Santo Augusto','RS'),
  (4317905,'Santo Cristo','RS'),
  (4317954,'Santo Expedito do Sul','RS'),
  (4318002,'So Borja','RS'),
  (4318051,'So Domingos do Sul','RS'),
  (4318101,'So Francisco de Assis','RS'),
  (4318200,'So Francisco de Paula','RS'),
  (4318309,'So Gabriel','RS'),
  (4318408,'So Jernimo','RS'),
  (4318424,'So Joo da Urtiga','RS'),
  (4318432,'So Joo do Polsine','RS'),
  (4318440,'So Jorge','RS'),
  (4318457,'So Jos das Misses','RS'),
  (4318465,'So Jos do Herval','RS'),
  (4318481,'So Jos do Hortncio','RS'),
  (4318499,'So Jos do Inhacor','RS'),
  (4318507,'So Jos do Norte','RS'),
  (4318606,'So Jos do Ouro','RS'),
  (4318614,'So Jos do Sul','RS'),
  (4318622,'So Jos dos Ausentes','RS');

INSERT INTO municipios (municipio_id, municipio_nome, estado_sigla) VALUES 
  (4318705,'So Leopoldo','RS'),
  (4318804,'So Loureno do Sul','RS'),
  (4318903,'So Luiz Gonzaga','RS'),
  (4319000,'So Marcos','RS'),
  (4319109,'So Martinho','RS'),
  (4319125,'So Martinho da Serra','RS'),
  (4319158,'So Miguel das Misses','RS'),
  (4319208,'So Nicolau','RS'),
  (4319307,'So Paulo das Misses','RS'),
  (4319356,'So Pedro da Serra','RS'),
  (4319364,'So Pedro das Misses','RS'),
  (4319372,'So Pedro do Buti','RS'),
  (4319406,'So Pedro do Sul','RS'),
  (4319505,'So Sebastio do Ca','RS'),
  (4319604,'So Sep','RS'),
  (4319703,'So Valentim','RS'),
  (4319711,'So Valentim do Sul','RS'),
  (4319737,'So Valrio do Sul','RS'),
  (4319752,'So Vendelino','RS'),
  (4319802,'So Vicente do Sul','RS'),
  (4319901,'Sapiranga','RS'),
  (4320008,'Sapucaia do Sul','RS'),
  (4320107,'Sarandi','RS'),
  (4320206,'Seberi','RS'),
  (4320230,'Sede Nova','RS'),
  (4320263,'Segredo','RS'),
  (4320305,'Selbach','RS'),
  (4320321,'Senador Salgado Filho','RS'),
  (4320354,'Sentinela do Sul','RS'),
  (4320404,'Serafina Corra','RS'),
  (4320453,'Srio','RS'),
  (4320503,'Serto','RS'),
  (4320552,'Serto Santana','RS'),
  (4320578,'Sete de Setembro','RS'),
  (4320602,'Severiano de Almeida','RS'),
  (4320651,'Silveira Martins','RS'),
  (4320677,'Sinimbu','RS'),
  (4320701,'Sobradinho','RS'),
  (4320800,'Soledade','RS'),
  (4320859,'Taba','RS'),
  (4320909,'Tapejara','RS'),
  (4321006,'Tapera','RS'),
  (4321105,'Tapes','RS'),
  (4321204,'Taquara','RS'),
  (4321303,'Taquari','RS'),
  (4321329,'Taquaruu do Sul','RS'),
  (4321352,'Tavares','RS'),
  (4321402,'Tenente Portela','RS'),
  (4321436,'Terra de Areia','RS'),
  (4321451,'Teutnia','RS'),
  (4321469,'Tio Hugo','RS'),
  (4321477,'Tiradentes do Sul','RS'),
  (4321493,'Toropi','RS'),
  (4321501,'Torres','RS'),
  (4321600,'Tramanda','RS'),
  (4321626,'Travesseiro','RS'),
  (4321634,'Trs Arroios','RS'),
  (4321667,'Trs Cachoeiras','RS'),
  (4321709,'Trs Coroas','RS'),
  (4321808,'Trs de Maio','RS'),
  (4321832,'Trs Forquilhas','RS'),
  (4321857,'Trs Palmeiras','RS'),
  (4321907,'Trs Passos','RS'),
  (4321956,'Trindade do Sul','RS'),
  (4322004,'Triunfo','RS'),
  (4322103,'Tucunduva','RS'),
  (4322152,'Tunas','RS'),
  (4322186,'Tupanci do Sul','RS'),
  (4322202,'Tupanciret','RS'),
  (4322251,'Tupandi','RS'),
  (4322301,'Tuparendi','RS'),
  (4322327,'Turuu','RS'),
  (4322343,'Ubiretama','RS'),
  (4322350,'Unio da Serra','RS'),
  (4322376,'Unistalda','RS'),
  (4322400,'Uruguaiana','RS'),
  (4322509,'Vacaria','RS'),
  (4322525,'Vale Verde','RS'),
  (4322533,'Vale do Sol','RS'),
  (4322541,'Vale Real','RS'),
  (4322558,'Vanini','RS'),
  (4322608,'Venncio Aires','RS'),
  (4322707,'Vera Cruz','RS'),
  (4322806,'Veranpolis','RS'),
  (4322855,'Vespasiano Correa','RS'),
  (4322905,'Viadutos','RS'),
  (4323002,'Viamo','RS'),
  (4323101,'Vicente Dutra','RS'),
  (4323200,'Victor Graeff','RS'),
  (4323309,'Vila Flores','RS'),
  (4323358,'Vila Lngaro','RS'),
  (4323408,'Vila Maria','RS'),
  (4323457,'Vila Nova do Sul','RS'),
  (4323507,'Vista Alegre','RS'),
  (4323606,'Vista Alegre do Prata','RS'),
  (4323705,'Vista Gacha','RS'),
  (4323754,'Vitria das Misses','RS'),
  (4323770,'Westfalia','RS'),
  (4323804,'Xangri-l','RS'),
  (5000203,'gua Clara','MS'),
  (5000252,'Alcinpolis','MS'),
  (5000609,'Amambai','MS'),
  (5000708,'Anastcio','MS'),
  (5000807,'Anaurilndia','MS'),
  (5000856,'Anglica','MS'),
  (5000906,'Antnio Joo','MS'),
  (5001003,'Aparecida do Taboado','MS'),
  (5001102,'Aquidauana','MS'),
  (5001243,'Aral Moreira','MS'),
  (5001508,'Bandeirantes','MS'),
  (5001904,'Bataguassu','MS'),
  (5002001,'Bataypor','MS'),
  (5002100,'Bela Vista','MS'),
  (5002159,'Bodoquena','MS'),
  (5002209,'Bonito','MS'),
  (5002308,'Brasilndia','MS'),
  (5002407,'Caarap','MS'),
  (5002605,'Camapu','MS'),
  (5002704,'Campo Grande','MS'),
  (5002803,'Caracol','MS'),
  (5002902,'Cassilndia','MS'),
  (5002951,'Chapado do Sul','MS'),
  (5003108,'Corguinho','MS'),
  (5003157,'Coronel Sapucaia','MS'),
  (5003207,'Corumb','MS'),
  (5003256,'Costa Rica','MS'),
  (5003306,'Coxim','MS'),
  (5003454,'Deodpolis','MS'),
  (5003488,'Dois Irmos do Buriti','MS'),
  (5003504,'Douradina','MS'),
  (5003702,'Dourados','MS'),
  (5003751,'Eldorado','MS'),
  (5003801,'Ftima do Sul','MS'),
  (5003900,'Figueiro','MS'),
  (5004007,'Glria de Dourados','MS'),
  (5004106,'Guia Lopes da Laguna','MS'),
  (5004304,'Iguatemi','MS'),
  (5004403,'Inocncia','MS'),
  (5004502,'Itapor','MS'),
  (5004601,'Itaquira','MS'),
  (5004700,'Ivinhema','MS'),
  (5004809,'Japor','MS'),
  (5004908,'Jaraguari','MS'),
  (5005004,'Jardim','MS'),
  (5005103,'Jate','MS'),
  (5005152,'Juti','MS'),
  (5005202,'Ladrio','MS'),
  (5005251,'Laguna Carap','MS'),
  (5005400,'Maracaju','MS'),
  (5005608,'Miranda','MS'),
  (5005681,'Mundo Novo','MS'),
  (5005707,'Navira','MS'),
  (5005806,'Nioaque','MS'),
  (5006002,'Nova Alvorada do Sul','MS'),
  (5006200,'Nova Andradina','MS'),
  (5006259,'Novo Horizonte do Sul','MS'),
  (5006309,'Paranaba','MS'),
  (5006358,'Paranhos','MS'),
  (5006408,'Pedro Gomes','MS'),
  (5006606,'Ponta Por','MS'),
  (5006903,'Porto Murtinho','MS'),
  (5007109,'Ribas do Rio Pardo','MS'),
  (5007208,'Rio Brilhante','MS'),
  (5007307,'Rio Negro','MS'),
  (5007406,'Rio Verde de Mato Grosso','MS'),
  (5007505,'Rochedo','MS'),
  (5007554,'Santa Rita do Pardo','MS'),
  (5007695,'So Gabriel do Oeste','MS'),
  (5007703,'Sete Quedas','MS'),
  (5007802,'Selvria','MS'),
  (5007901,'Sidrolndia','MS'),
  (5007935,'Sonora','MS'),
  (5007950,'Tacuru','MS'),
  (5007976,'Taquarussu','MS'),
  (5008008,'Terenos','MS'),
  (5008305,'Trs Lagoas','MS'),
  (5008404,'Vicentina','MS'),
  (5100102,'Acorizal','MG'),
  (5100201,'gua Boa','MT'),
  (5100250,'Alta Floresta','MT'),
  (5100300,'Alto Araguaia','MT'),
  (5100359,'Alto Boa Vista','MT'),
  (5100409,'Alto Garas','MT'),
  (5100508,'Alto Paraguai','MT'),
  (5100607,'Alto Taquari','MT'),
  (5100805,'Apiacs','MT'),
  (5101001,'Araguaiana','MT'),
  (5101209,'Araguainha','MT'),
  (5101258,'Araputanga','MT'),
  (5101308,'Arenpolis','MT'),
  (5101407,'Aripuan','MT'),
  (5101605,'Baro de Melgao','MT'),
  (5101704,'Barra do Bugres','MT'),
  (5101803,'Barra do Garas','MT'),
  (5101852,'Bom Jesus do Araguaia','MT'),
  (5101902,'Brasnorte','MT'),
  (5102504,'Cceres','MT'),
  (5102603,'Campinpolis','MT'),
  (5102637,'Campo Novo do Parecis','MT'),
  (5102678,'Campo Verde','MT'),
  (5102686,'Campos de Jlio','MT'),
  (5102694,'Canabrava do Norte','MT'),
  (5102702,'Canarana','MT'),
  (5102793,'Carlinda','MT'),
  (5102850,'Castanheira','MT'),
  (5103007,'Chapada dos Guimares','MT'),
  (5103056,'Cludia','MT'),
  (5103106,'Cocalinho','MT'),
  (5103205,'Colder','MT'),
  (5103254,'Colniza','MT'),
  (5103304,'Comodoro','MT'),
  (5103353,'Confresa','MT'),
  (5103361,'Conquista D''Oeste','MT'),
  (5103379,'Cotriguau','MT'),
  (5103403,'Cuiab','MT'),
  (5103437,'Curvelndia','MT'),
  (5103452,'Denise','MT'),
  (5103502,'Diamantino','MT'),
  (5103601,'Dom Aquino','MT'),
  (5103700,'Feliz Natal','MT'),
  (5103809,'Figueirpolis D''Oeste','MT'),
  (5103858,'Gacha do Norte','MT'),
  (5103908,'General Carneiro','MT'),
  (5103957,'Glria D''Oeste','MT'),
  (5104104,'Guarant do Norte','MT'),
  (5104203,'Guiratinga','MT'),
  (5104500,'Indiava','MT'),
  (5104526,'Ipiranga do Norte','MT'),
  (5104542,'Itanhang','MT'),
  (5104559,'Itaba','MT'),
  (5104609,'Itiquira','MT'),
  (5104807,'Jaciara','MT'),
  (5104906,'Jangada','MT'),
  (5105002,'Jauru','MT'),
  (5105101,'Juara','MT'),
  (5105150,'Juna','MT'),
  (5105176,'Juruena','MT'),
  (5105200,'Juscimeira','MT'),
  (5105234,'Lambari D''Oeste','MT'),
  (5105259,'Lucas do Rio Verde','MT'),
  (5105309,'Luciara','MT'),
  (5105507,'Vila Bela da Santssima Trindade','MT'),
  (5105580,'Marcelndia','MT'),
  (5105606,'Matup','MT'),
  (5105622,'Mirassol D''Oeste','MT'),
  (5105903,'Nobres','MT'),
  (5106000,'Nortelndia','MT'),
  (5106109,'Nossa Senhora do Livramento','MT'),
  (5106158,'Nova Bandeirantes','MT'),
  (5106174,'Nova Nazar','MT'),
  (5106182,'Nova Lacerda','MT'),
  (5106190,'Nova Santa Helena','MT'),
  (5106208,'Nova Brasilndia','MT'),
  (5106216,'Nova Cana do Norte','MT'),
  (5106224,'Nova Mutum','MT'),
  (5106232,'Nova Olmpia','MT'),
  (5106240,'Nova Ubirat','MT'),
  (5106257,'Nova Xavantina','MT'),
  (5106265,'Novo Mundo','MT'),
  (5106273,'Novo Horizonte do Norte','MT'),
  (5106281,'Novo So Joaquim','MT'),
  (5106299,'Paranata','MT'),
  (5106307,'Paranatinga','MT'),
  (5106315,'Novo Santo Antnio','MT'),
  (5106372,'Pedra Preta','MT'),
  (5106422,'Peixoto de Azevedo','MT'),
  (5106455,'Planalto da Serra','MT'),
  (5106505,'Pocon','MT'),
  (5106653,'Pontal do Araguaia','MT'),
  (5106703,'Ponte Branca','MT'),
  (5106752,'Pontes e Lacerda','MT'),
  (5106778,'Porto Alegre do Norte','MT'),
  (5106802,'Porto dos Gachos','MT'),
  (5106828,'Porto Esperidio','MT'),
  (5106851,'Porto Estrela','MT'),
  (5107008,'Poxoro','MT'),
  (5107040,'Primavera do Leste','MT'),
  (5107065,'Querncia','MT'),
  (5107107,'So Jos dos Quatro Marcos','MT'),
  (5107156,'Reserva do Cabaal','MT'),
  (5107180,'Ribeiro Cascalheira','MT'),
  (5107198,'Ribeirozinho','MT'),
  (5107206,'Rio Branco','MT'),
  (5107248,'Santa Carmem','MT'),
  (5107263,'Santo Afonso','MT'),
  (5107297,'So Jos do Povo','MT'),
  (5107305,'So Jos do Rio Claro','MT'),
  (5107354,'So Jos do Xingu','MT'),
  (5107404,'So Pedro da Cipa','MT'),
  (5107578,'Rondolndia','MT'),
  (5107602,'Rondonpolis','MT'),
  (5107701,'Rosrio Oeste','MT'),
  (5107743,'Santa Cruz do Xingu','MT'),
  (5107750,'Salto do Cu','MT'),
  (5107768,'Santa Rita do Trivelato','MT'),
  (5107776,'Santa Terezinha','MT'),
  (5107792,'Santo Antnio do Leste','MT'),
  (5107800,'Santo Antnio do Leverger','MT'),
  (5107859,'So Flix do Araguaia','MT'),
  (5107875,'Sapezal','MT'),
  (5107883,'Serra Nova Dourada','MT'),
  (5107909,'Sinop','MT'),
  (5107925,'Sorriso','MT'),
  (5107941,'Tabapor','MT'),
  (5107958,'Tangar da Serra','MT'),
  (5108006,'Tapurah','MT'),
  (5108055,'Terra Nova do Norte','MT'),
  (5108105,'Tesouro','MT'),
  (5108204,'Torixoru','MT'),
  (5108303,'Unio do Sul','MT'),
  (5108352,'Vale de So Domingos','MT'),
  (5108402,'Vrzea Grande','MT'),
  (5108501,'Vera','MT'),
  (5108600,'Vila Rica','MT'),
  (5108808,'Nova Guarita','MT'),
  (5108857,'Nova Marilndia','MT'),
  (5108907,'Nova Maring','MT'),
  (5108956,'Nova Monte Verde','MT'),
  (5200050,'Abadia de Gois','GO'),
  (5200100,'Abadinia','GO'),
  (5200134,'Acrena','GO'),
  (5200159,'Adelndia','GO'),
  (5200175,'gua Fria de Gois','GO'),
  (5200209,'gua Limpa','GO'),
  (5200258,'guas Lindas de Gois','GO'),
  (5200308,'Alexnia','GO'),
  (5200506,'Alondia','GO'),
  (5200555,'Alto Horizonte','GO'),
  (5200605,'Alto Paraso de Gois','GO'),
  (5200803,'Alvorada do Norte','GO'),
  (5200829,'Amaralina','GO'),
  (5200852,'Americano do Brasil','GO'),
  (5200902,'Amorinpolis','GO'),
  (5201108,'Anpolis','GO'),
  (5201207,'Anhanguera','GO'),
  (5201306,'Anicuns','GO'),
  (5201405,'Aparecida de Goinia','GO'),
  (5201454,'Aparecida do Rio Doce','GO'),
  (5201504,'Apor','GO'),
  (5201603,'Arau','GO'),
  (5201702,'Aragaras','GO'),
  (5201801,'Aragoinia','GO'),
  (5202155,'Araguapaz','GO'),
  (5202353,'Arenpolis','GO'),
  (5202502,'Aruan','GO'),
  (5202601,'Aurilndia','GO'),
  (5202809,'Avelinpolis','GO'),
  (5203104,'Baliza','GO'),
  (5203203,'Barro Alto','GO'),
  (5203302,'Bela Vista de Gois','GO'),
  (5203401,'Bom Jardim de Gois','GO'),
  (5203500,'Bom Jesus de Gois','GO'),
  (5203559,'Bonfinpolis','GO'),
  (5203575,'Bonpolis','GO'),
  (5203609,'Brazabrantes','GO'),
  (5203807,'Britnia','GO'),
  (5203906,'Buriti Alegre','GO'),
  (5203939,'Buriti de Gois','GO'),
  (5203962,'Buritinpolis','GO'),
  (5204003,'Cabeceiras','GO'),
  (5204102,'Cachoeira Alta','GO'),
  (5204201,'Cachoeira de Gois','GO'),
  (5204250,'Cachoeira Dourada','GO'),
  (5204300,'Cau','GO'),
  (5204409,'Caiapnia','GO'),
  (5204508,'Caldas Novas','GO'),
  (5204557,'Caldazinha','GO'),
  (5204607,'Campestre de Gois','GO'),
  (5204656,'Campinau','GO'),
  (5204706,'Campinorte','GO'),
  (5204805,'Campo Alegre de Gois','GO'),
  (5204854,'Campo Limpo de Gois','GO'),
  (5204904,'Campos Belos','GO'),
  (5204953,'Campos Verdes','GO'),
  (5205000,'Carmo do Rio Verde','GO'),
  (5205059,'Castelndia','GO'),
  (5205109,'Catalo','GO'),
  (5205208,'Catura','GO'),
  (5205307,'Cavalcante','GO'),
  (5205406,'Ceres','GO'),
  (5205455,'Cezarina','GO'),
  (5205471,'Chapado do Cu','GO'),
  (5205497,'Cidade Ocidental','GO'),
  (5205513,'Cocalzinho de Gois','GO'),
  (5205521,'Colinas do Sul','GO'),
  (5205703,'Crrego do Ouro','GO'),
  (5205802,'Corumb de Gois','GO'),
  (5205901,'Corumbaba','GO'),
  (5206206,'Cristalina','GO'),
  (5206305,'Cristianpolis','GO'),
  (5206404,'Crixs','GO'),
  (5206503,'Cromnia','GO'),
  (5206602,'Cumari','GO'),
  (5206701,'Damianpolis','GO'),
  (5206800,'Damolndia','GO'),
  (5206909,'Davinpolis','GO'),
  (5207105,'Diorama','GO'),
  (5207253,'Doverlndia','GO'),
  (5207352,'Edealina','GO'),
  (5207402,'Edia','GO'),
  (5207501,'Estrela do Norte','GO'),
  (5207535,'Faina','GO'),
  (5207600,'Fazenda Nova','GO'),
  (5207808,'Firminpolis','GO'),
  (5207907,'Flores de Gois','GO'),
  (5208004,'Formosa','GO'),
  (5208103,'Formoso','GO'),
  (5208152,'Gameleira de Gois','GO'),
  (5208301,'Divinpolis de Gois','GO'),
  (5208400,'Goianpolis','GO'),
  (5208509,'Goiandira','GO'),
  (5208608,'Goiansia','GO'),
  (5208707,'Goinia','GO'),
  (5208806,'Goianira','GO'),
  (5208905,'Gois','GO'),
  (5209101,'Goiatuba','GO'),
  (5209150,'Gouvelndia','GO'),
  (5209200,'Guap','GO'),
  (5209291,'Guarata','GO'),
  (5209408,'Guarani de Gois','GO'),
  (5209457,'Guarinos','GO'),
  (5209606,'Heitora','GO'),
  (5209705,'Hidrolndia','GO'),
  (5209804,'Hidrolina','GO'),
  (5209903,'Iaciara','GO'),
  (5209937,'Inaciolndia','GO'),
  (5209952,'Indiara','GO'),
  (5210000,'Inhumas','GO'),
  (5210109,'Ipameri','GO'),
  (5210158,'Ipiranga de Gois','GO'),
  (5210208,'Ipor','GO'),
  (5210307,'Israelndia','GO'),
  (5210406,'Itabera','GO'),
  (5210562,'Itaguari','GO'),
  (5210604,'Itaguaru','GO'),
  (5210802,'Itaj','GO'),
  (5210901,'Itapaci','GO'),
  (5211008,'Itapirapu','GO'),
  (5211206,'Itapuranga','GO'),
  (5211305,'Itarum','GO'),
  (5211404,'Itauu','GO'),
  (5211503,'Itumbiara','GO'),
  (5211602,'Ivolndia','GO'),
  (5211701,'Jandaia','GO'),
  (5211800,'Jaragu','GO'),
  (5211909,'Jata','GO'),
  (5212006,'Jaupaci','GO'),
  (5212055,'Jespolis','GO'),
  (5212105,'Jovinia','GO'),
  (5212204,'Jussara','GO'),
  (5212253,'Lagoa Santa','GO'),
  (5212303,'Leopoldo de Bulhes','GO'),
  (5212501,'Luzinia','GO'),
  (5212600,'Mairipotaba','GO'),
  (5212709,'Mamba','GO'),
  (5212808,'Mara Rosa','GO'),
  (5212907,'Marzago','GO'),
  (5212956,'Matrinch','GO'),
  (5213004,'Maurilndia','GO'),
  (5213053,'Mimoso de Gois','GO'),
  (5213087,'Minau','GO'),
  (5213103,'Mineiros','GO'),
  (5213400,'Moipor','GO'),
  (5213509,'Monte Alegre de Gois','GO'),
  (5213707,'Montes Claros de Gois','GO'),
  (5213756,'Montividiu','GO'),
  (5213772,'Montividiu do Norte','GO'),
  (5213806,'Morrinhos','GO'),
  (5213855,'Morro Agudo de Gois','GO'),
  (5213905,'Mossmedes','GO'),
  (5214002,'Mozarlndia','GO'),
  (5214051,'Mundo Novo','GO'),
  (5214101,'Mutunpolis','GO'),
  (5214408,'Nazrio','GO'),
  (5214507,'Nerpolis','GO'),
  (5214606,'Niquelndia','GO'),
  (5214705,'Nova Amrica','GO'),
  (5214804,'Nova Aurora','GO'),
  (5214838,'Nova Crixs','GO'),
  (5214861,'Nova Glria','GO'),
  (5214879,'Nova Iguau de Gois','GO'),
  (5214903,'Nova Roma','GO'),
  (5215009,'Nova Veneza','GO'),
  (5215207,'Novo Brasil','GO'),
  (5215231,'Novo Gama','GO'),
  (5215256,'Novo Planalto','GO'),
  (5215306,'Orizona','GO'),
  (5215405,'Ouro Verde de Gois','GO'),
  (5215504,'Ouvidor','GO'),
  (5215603,'Padre Bernardo','GO'),
  (5215652,'Palestina de Gois','GO'),
  (5215702,'Palmeiras de Gois','GO'),
  (5215801,'Palmelo','GO'),
  (5215900,'Palminpolis','GO'),
  (5216007,'Panam','GO'),
  (5216304,'Paranaiguara','GO'),
  (5216403,'Parana','GO'),
  (5216452,'Perolndia','GO'),
  (5216809,'Petrolina de Gois','GO'),
  (5216908,'Pilar de Gois','GO');

INSERT INTO municipios (municipio_id, municipio_nome, estado_sigla) VALUES 
  (5217104,'Piracanjuba','GO'),
  (5217203,'Piranhas','GO'),
  (5217302,'Pirenpolis','GO'),
  (5217401,'Pires do Rio','GO'),
  (5217609,'Planaltina','GO'),
  (5217708,'Pontalina','GO'),
  (5218003,'Porangatu','GO'),
  (5218052,'Porteiro','GO'),
  (5218102,'Portelndia','GO'),
  (5218300,'Posse','GO'),
  (5218391,'Professor Jamil','GO'),
  (5218508,'Quirinpolis','GO'),
  (5218607,'Rialma','GO'),
  (5218706,'Rianpolis','GO'),
  (5218789,'Rio Quente','GO'),
  (5218805,'Rio Verde','GO'),
  (5218904,'Rubiataba','GO'),
  (5219001,'Sanclerlndia','GO'),
  (5219100,'Santa Brbara de Gois','GO'),
  (5219209,'Santa Cruz de Gois','GO'),
  (5219258,'Santa F de Gois','GO'),
  (5219308,'Santa Helena de Gois','GO'),
  (5219357,'Santa Isabel','GO'),
  (5219407,'Santa Rita do Araguaia','GO'),
  (5219456,'Santa Rita do Novo Destino','GO'),
  (5219506,'Santa Rosa de Gois','GO'),
  (5219605,'Santa Tereza de Gois','GO'),
  (5219704,'Santa Terezinha de Gois','GO'),
  (5219712,'Santo Antnio da Barra','GO'),
  (5219738,'Santo Antnio de Gois','GO'),
  (5219753,'Santo Antnio do Descoberto','GO'),
  (5219803,'So Domingos','GO'),
  (5219902,'So Francisco de Gois','GO'),
  (5220009,'So Joo d''Aliana','GO'),
  (5220058,'So Joo da Parana','GO'),
  (5220108,'So Lus de Montes Belos','GO'),
  (5220157,'So Luz do Norte','GO'),
  (5220207,'So Miguel do Araguaia','GO'),
  (5220264,'So Miguel do Passa Quatro','GO'),
  (5220280,'So Patrcio','GO'),
  (5220405,'So Simo','GO'),
  (5220454,'Senador Canedo','GO'),
  (5220504,'Serranpolis','GO'),
  (5220603,'Silvnia','GO'),
  (5220686,'Simolndia','GO'),
  (5220702,'Stio d''Abadia','GO'),
  (5221007,'Taquaral de Gois','GO'),
  (5221080,'Teresina de Gois','GO'),
  (5221197,'Terezpolis de Gois','GO'),
  (5221304,'Trs Ranchos','GO'),
  (5221403,'Trindade','GO'),
  (5221452,'Trombas','GO'),
  (5221502,'Turvnia','GO'),
  (5221551,'Turvelndia','GO'),
  (5221577,'Uirapuru','GO'),
  (5221601,'Uruau','GO'),
  (5221700,'Uruana','GO'),
  (5221809,'Uruta','GO'),
  (5221858,'Valparaso de Gois','GO'),
  (5221908,'Varjo','GO'),
  (5222005,'Vianpolis','GO'),
  (5222054,'Vicentinpolis','GO'),
  (5222203,'Vila Boa','GO'),
  (5222302,'Vila Propcio','GO'),
  (5300108,'Braslia','DF');
