SET FOREIGN_KEY_CHECKS=0;

UPDATE versao SET versao_codigo='8.5.27';
UPDATE versao SET ultima_atualizacao_bd='2020-08-22';
UPDATE versao SET ultima_atualizacao_codigo='2020-08-22';
UPDATE versao SET versao_bd=582;

DROP TABLE IF EXISTS financeiro_estorno_ob_fiplan;

CREATE TABLE financeiro_estorno_ob_fiplan(
	financeiro_estorno_ob_fiplan_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	financeiro_estorno_ob_fiplan_cia INTEGER(100) UNSIGNED DEFAULT NULL,
	financeiro_estorno_ob_fiplan_dept INTEGER(100) UNSIGNED DEFAULT NULL,
	financeiro_estorno_ob_fiplan_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
	financeiro_estorno_ob_fiplan_cor VARCHAR(6) DEFAULT 'FFFFFF',
	financeiro_estorno_ob_fiplan_acesso INTEGER(100) UNSIGNED DEFAULT 0,
	financeiro_estorno_ob_fiplan_ativo TINYINT(1) DEFAULT 1,
	NUMR_EMP VARCHAR(18) DEFAULT NULL,
	NUM_NOB VARCHAR(18) DEFAULT NULL,
	VALR_NOB DECIMAL(15,2) DEFAULT NULL,
	NUMR_LIQ VARCHAR(18) DEFAULT NULL,
	CD_EXERCICIO VARCHAR(4) DEFAULT NULL,
	ID_USUARIO VARCHAR(8) DEFAULT NULL,
	DATA_EMISSAO DATE DEFAULT NULL,
	HISTORICO_OBSERVACAO VARCHAR(150) DEFAULT NULL,
	DATA_VENCIMENTO DATE DEFAULT NULL,
	CD_CREDOR VARCHAR(10) DEFAULT NULL,
	REGULARIZACAO VARCHAR(3) DEFAULT NULL,
	TIPO_PAGAMENTO VARCHAR(100) DEFAULT NULL,
	NUMR_NEX VARCHAR(18) DEFAULT NULL,
	CD_UNIDADE_ORCAMENTARIA VARCHAR(6) DEFAULT NULL,
	DS_UNIDADE_ORCAMENTARIA VARCHAR(110) DEFAULT NULL,
	CD_UNIDADE_GESTORA VARCHAR(4) DEFAULT NULL,
	DS_UNIDADE_GESTORA VARCHAR(100) DEFAULT NULL,
	CD_FONTE_RECURSO VARCHAR(3) DEFAULT NULL,
	CD_BANCO_CREDOR VARCHAR(3) DEFAULT NULL,
	CD_AGENCIA_CREDOR VARCHAR(4) DEFAULT NULL,
	NUMR_CONTA_CORRENTE_CREDOR VARCHAR(15) DEFAULT NULL,
	CODG_NUMR_DIG_CC_CREDOR VARCHAR(2) DEFAULT NULL,
	DATA_CRIACAO_DOCTO DATE DEFAULT NULL,
	HORA_CRIACAO_DOCTO TIME DEFAULT NULL,
	NOME_CREDOR VARCHAR(100) DEFAULT NULL,
	IDEN_CREDOR VARCHAR(14) DEFAULT NULL,
	CD_ELEMENTO_DESPESA VARCHAR(2) DEFAULT NULL,
	FLAG_TRANSMISSAO VARCHAR(100) DEFAULT NULL,
	TRANSMISSAO_ELETRONICA VARCHAR(100) DEFAULT NULL,
	SITUACAO VARCHAR(100) DEFAULT NULL,
	NUMR_NOBLIST VARCHAR(18) DEFAULT NULL,
	NUMR_DOTLIST VARCHAR(18) DEFAULT NULL,
	CODG_BANCO VARCHAR(3) DEFAULT NULL,
	CODG_AGENCIA VARCHAR(4) DEFAULT NULL,
	CODG_NUMRCC VARCHAR(15) DEFAULT NULL,
	CODG_NUMR_DIG_CC VARCHAR(2) DEFAULT NULL,
	CODG_CONTA_BANCARIA VARCHAR(8) DEFAULT NULL,
	NUMR_PROTOCOLO VARCHAR(8) DEFAULT NULL,
	CD_EXERCICIO_PROTOCOLO VARCHAR(4) DEFAULT NULL,
	TIPO_OB VARCHAR(8) DEFAULT NULL,
	DS_TIPO_OB VARCHAR(100) DEFAULT NULL,
	FLAG_NOB_FATURA_FATO54 VARCHAR(100) DEFAULT NULL,
	CDG_ORDENADOR_DESPESA VARCHAR(8) DEFAULT NULL,
	ORDENADOR_DESPESA VARCHAR(100) DEFAULT NULL,
	NUMR_NOB_ESTORNO VARCHAR(18) DEFAULT NULL,
	DATA_OCORRENCIA DATE DEFAULT NULL,
	NUMR_ARQUIVO_LOTE VARCHAR(7) DEFAULT NULL,
	NUMR_RELACAO_PAGAMENTO_RE VARCHAR(18) DEFAULT NULL,
	DATA_RETORNO DATE DEFAULT NULL,
	NUMR_ARQUIVO_RETORNO VARCHAR(18) DEFAULT NULL,
	OBSERVACAO VARCHAR(150) DEFAULT NULL,
	PRIMARY KEY (financeiro_estorno_ob_fiplan_id),
  KEY financeiro_estorno_ob_fiplan_cia (financeiro_estorno_ob_fiplan_cia),
  KEY financeiro_estorno_ob_fiplan_dept (financeiro_estorno_ob_fiplan_dept),
  KEY financeiro_estorno_ob_fiplan_responsavel (financeiro_estorno_ob_fiplan_responsavel),
  CONSTRAINT financeiro_estorno_ob_fiplan_dept FOREIGN KEY (financeiro_estorno_ob_fiplan_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT financeiro_estorno_ob_fiplan_cia FOREIGN KEY (financeiro_estorno_ob_fiplan_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT financeiro_estorno_ob_fiplan_responsavel FOREIGN KEY (financeiro_estorno_ob_fiplan_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;	



DROP TABLE IF EXISTS financeiro_gvc;

CREATE TABLE financeiro_gvc(
	financeiro_gvc_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	financeiro_gvc_cia INTEGER(100) UNSIGNED DEFAULT NULL,
	financeiro_gvc_dept INTEGER(100) UNSIGNED DEFAULT NULL,
	financeiro_gvc_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
	financeiro_gvc_cor VARCHAR(6) DEFAULT 'FFFFFF',
	financeiro_gvc_acesso INTEGER(100) UNSIGNED DEFAULT 0,
	financeiro_gvc_ativo TINYINT(1) DEFAULT 1,
	CD_EXERCICIO VARCHAR(4) DEFAULT NULL,
	CD_UNIDADE_ORCAMENTARIA VARCHAR(5) DEFAULT NULL,
	CD_UNIDADE_GESTORA VARCHAR(4) DEFAULT NULL,
	DS_UNIDADE_ORCAMENTARIA VARCHAR(110) DEFAULT NULL,
	DS_UNIDADE_GESTORA VARCHAR(100) DEFAULT NULL,
	NUMR_GCV VARCHAR(18) DEFAULT NULL,
	NUMR_GCV_ESTORNO VARCHAR(18) DEFAULT NULL,
	DATA_GCV DATE DEFAULT NULL,
	HISTORICO_GCV VARCHAR(400) DEFAULT NULL,
	VALR_GCV DECIMAL(15,2) DEFAULT NULL,
	CD_FLAG_TIPO_PAGAMENTO VARCHAR(1) DEFAULT NULL,
	DS_FLAG_TIPO_PAGAMENTO VARCHAR(100) DEFAULT NULL,
	DATA_CADASTRO DATE DEFAULT NULL,
	NUMR_GUIA_DEPOSITO VARCHAR(18) DEFAULT NULL,
	DS_NOME VARCHAR(100) DEFAULT NULL,
	NUMR_NOB VARCHAR(18) DEFAULT NULL,
	DATA_NOB DATE DEFAULT NULL,
	NUMR_LIQ VARCHAR(18) DEFAULT NULL,
	DATA_LIQ DATE DEFAULT NULL,
	NUMR_DOTLIST VARCHAR(18) DEFAULT NULL,
	NUMR_NOBLIST VARCHAR(18) DEFAULT NULL,
	NUMR_EMP VARCHAR(18) DEFAULT NULL,
	DATA_EMP DATE DEFAULT NULL,
	CD_TIPO_EMPENHO VARCHAR(1) DEFAULT NULL,
	DS_TIPO_EMPENHO VARCHAR(100) DEFAULT NULL,
	IDEN_CREDOR VARCHAR(10) DEFAULT NULL,
	NOME_CREDOR VARCHAR(100) DEFAULT NULL,
	DOCUMENTO_CREDOR VARCHAR(14) DEFAULT NULL,
	NOME_PESSOA_JURIDICA VARCHAR(100) DEFAULT NULL,
	NOME_PESSOA_FISICA VARCHAR(100) DEFAULT NULL,
	CNPJ VARCHAR(14) DEFAULT NULL,
	CPF VARCHAR(11) DEFAULT NULL,
	CODG_DOTACAO_ORCAMENTARIA VARCHAR(49) DEFAULT NULL,
	CD_ELEMENTO_DESPESA VARCHAR(2) DEFAULT NULL,
	DS_ELEMENTO_DESPESA VARCHAR(100) DEFAULT NULL,
	CD_TIPO_DESPESA VARCHAR(2) DEFAULT NULL,
	DS_TIPO_DESPESA VARCHAR(100) DEFAULT NULL,
	NUMR_CONTRATO VARCHAR(18) DEFAULT NULL,
	NUMR_CONVENIO VARCHAR(35) DEFAULT NULL,
	CODG_CONTA_BANCARIA VARCHAR(8) DEFAULT NULL,
	NOME_CONTA_BANCARIA VARCHAR(100) DEFAULT NULL,
	CODG_BANCO VARCHAR(3) DEFAULT NULL,
	CD_AGENCIA_BANCARIA VARCHAR(6) DEFAULT NULL,
	NUMR_CONTA_CORRENTE_CB VARCHAR(18) DEFAULT NULL,
	CODG_SUBCONTA VARCHAR(5) DEFAULT NULL,
	NOME_SUBCONTA VARCHAR(100) DEFAULT NULL,
	FLAG_FORMA_RECEBIMENTO VARCHAR(100) DEFAULT NULL,
	CODG_BANCO_CREDOR VARCHAR(3) DEFAULT NULL,
	CD_AGENCIA_BANCARIA_CREDOR VARCHAR(6) DEFAULT NULL,
	NUMR_CONTA_CORRENTE_CREDOR VARCHAR(18) DEFAULT NULL,
	IDEN_CONTA_CORRENTE_CREDOR VARCHAR(8) DEFAULT NULL,
	EXERCICIO_FOLHA VARCHAR(5) DEFAULT NULL,
	UO_SEAP VARCHAR(10) DEFAULT NULL,
	MES_FOLHA VARCHAR(2) DEFAULT NULL,
	TIPO_FOLHA VARCHAR(10) DEFAULT NULL,
	NUMR_FOLHA VARCHAR(2) DEFAULT NULL,
	NUMR_PED VARCHAR(18) DEFAULT NULL,
	DATA_PED DATE DEFAULT NULL,
	NUMR_PAD VARCHAR(18) DEFAULT NULL,
	CD_FLAG_MOTIVO_REGULARIZACAO VARCHAR(1) DEFAULT NULL,
	DS_FLAG_MOTIVO_REGULARIZACAO VARCHAR(100) DEFAULT NULL,
	DS_ORIGEM_GUIA VARCHAR(100) DEFAULT NULL,
	VALOR_DEPOSITO DECIMAL(15,2) DEFAULT NULL,
	DATA_DEPOSITO_DEVOLUCAO DATE DEFAULT NULL,
	FORMA_PAGAMENTO VARCHAR(3) DEFAULT NULL,
	CD_NATUREZA_DESPESA VARCHAR(9) DEFAULT NULL,
	CD_FONTE_RECURSO VARCHAR(3) DEFAULT NULL,
	NUMR_PROTOCOLO VARCHAR(8) DEFAULT NULL,
	CD_EXERCICIO_PED VARCHAR(5) DEFAULT NULL,
	TIPO_VINCULO VARCHAR(20) DEFAULT NULL,
	EXEC_ANTERIOR VARCHAR(3) DEFAULT NULL,
	CD_ELEMENTO_DESPESA_ANTERIOR VARCHAR(2) DEFAULT NULL,
	DS_ELEMENTO_DESPESA_ANTERIOR VARCHAR(100) DEFAULT NULL,
	NOME_SERVIDOR VARCHAR(100) DEFAULT NULL,
	CPF_SERVIDOR VARCHAR(11) DEFAULT NULL,
	CD_SITUACAO_GCV VARCHAR(1) DEFAULT NULL,
	DESC_SITUACAO_GCV VARCHAR(100) DEFAULT NULL,
	CD_SITUACAO_NOB VARCHAR(1) DEFAULT NULL,
	DESC_SITUACAO_NOB VARCHAR(100) DEFAULT NULL,
	CD_TRANSMISSAO_NOB VARCHAR(1) DEFAULT NULL,
	DESC_TRANSMISSAO_NOB VARCHAR(100) DEFAULT NULL,
	CD_TRANSMISSAO_ELETRONICA_NOB VARCHAR(2) DEFAULT NULL,
	DS_TRANSMISSAO_ELETRONICA_NOB VARCHAR(100) DEFAULT NULL,
	CD_REGIONAL VARCHAR(4) DEFAULT NULL,
	NUMR_ELI VARCHAR(18) DEFAULT NULL,
	CD_SUBELEMENTO_DESPESA VARCHAR(3) DEFAULT NULL,
	DS_SUBELEMENTO_DESPESA VARCHAR(100) DEFAULT NULL,
	PRIMARY KEY (financeiro_gvc_id),
  KEY financeiro_gvc_cia (financeiro_gvc_cia),
  KEY financeiro_gvc_dept (financeiro_gvc_dept),
  KEY financeiro_gvc_responsavel (financeiro_gvc_responsavel),
  CONSTRAINT financeiro_gvc_dept FOREIGN KEY (financeiro_gvc_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT financeiro_gvc_cia FOREIGN KEY (financeiro_gvc_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT financeiro_gvc_responsavel FOREIGN KEY (financeiro_gvc_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;	


DROP TABLE IF EXISTS financeiro_rel_gvc;

CREATE TABLE financeiro_rel_gvc (
  financeiro_rel_gvc_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  financeiro_rel_gvc_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	financeiro_rel_gvc_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	financeiro_rel_gvc_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	financeiro_rel_gvc_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	financeiro_rel_gvc_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	financeiro_rel_gvc_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	financeiro_rel_gvc_os INTEGER(100) UNSIGNED DEFAULT NULL,
  financeiro_rel_gvc_gvc INTEGER(100) UNSIGNED DEFAULT NULL,
  financeiro_rel_gvc_aprovou INTEGER(100) UNSIGNED DEFAULT NULL,
  financeiro_rel_gvc_data_aprovou DATETIME,
  financeiro_rel_gvc_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  financeiro_rel_gvc_valor DECIMAL(20,3) DEFAULT 0,
  PRIMARY KEY (financeiro_rel_gvc_id),
  KEY financeiro_rel_gvc_projeto (financeiro_rel_gvc_projeto),
  KEY financeiro_rel_gvc_tarefa (financeiro_rel_gvc_tarefa),
  KEY financeiro_rel_gvc_acao (financeiro_rel_gvc_acao),
  KEY financeiro_rel_gvc_acao_item (financeiro_rel_gvc_acao_item),
  KEY financeiro_rel_gvc_tr (financeiro_rel_gvc_tr),
  KEY financeiro_rel_gvc_instrumento (financeiro_rel_gvc_instrumento),
  KEY financeiro_rel_gvc_os (financeiro_rel_gvc_os),
  KEY financeiro_rel_gvc_gvc (financeiro_rel_gvc_gvc),
  KEY financeiro_rel_gvc_aprovou (financeiro_rel_gvc_aprovou),
  CONSTRAINT financeiro_rel_gvc_projeto FOREIGN KEY (financeiro_rel_gvc_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT financeiro_rel_gvc_tarefa FOREIGN KEY (financeiro_rel_gvc_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT financeiro_rel_gvc_acao FOREIGN KEY (financeiro_rel_gvc_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT financeiro_rel_gvc_acao_item FOREIGN KEY (financeiro_rel_gvc_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT financeiro_rel_gvc_aprovou FOREIGN KEY (financeiro_rel_gvc_aprovou) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT financeiro_rel_gvc_tr FOREIGN KEY (financeiro_rel_gvc_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT financeiro_rel_gvc_instrumento FOREIGN KEY (financeiro_rel_gvc_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT financeiro_rel_gvc_os FOREIGN KEY (financeiro_rel_gvc_os) REFERENCES os (os_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT financeiro_rel_gvc_gvc FOREIGN KEY (financeiro_rel_gvc_gvc) REFERENCES financeiro_gvc (financeiro_gvc_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;
