SET FOREIGN_KEY_CHECKS=0;

UPDATE versao SET versao_codigo='8.5.27';
UPDATE versao SET ultima_atualizacao_bd='2020-08-26';
UPDATE versao SET ultima_atualizacao_codigo='2020-08-26';
UPDATE versao SET versao_bd=583;

DROP TABLE IF EXISTS financeiro_gvc;
DROP TABLE IF EXISTS financeiro_rel_gvc;

DROP TABLE IF EXISTS financeiro_gcv;

CREATE TABLE financeiro_gcv(
	financeiro_gcv_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	financeiro_gcv_cia INTEGER(100) UNSIGNED DEFAULT NULL,
	financeiro_gcv_dept INTEGER(100) UNSIGNED DEFAULT NULL,
	financeiro_gcv_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
	financeiro_gcv_cor VARCHAR(6) DEFAULT 'FFFFFF',
	financeiro_gcv_acesso INTEGER(100) UNSIGNED DEFAULT 0,
	financeiro_gcv_ativo TINYINT(1) DEFAULT 1,
	CD_EXERCICIO VARCHAR(4) DEFAULT NULL,
	CD_UNIDADE_ORCAMENTARIA VARCHAR(5) DEFAULT NULL,
	CD_UNIDADE_GESTORA VARCHAR(4) DEFAULT NULL,
	DS_UNIDADE_ORCAMENTARIA VARCHAR(110) DEFAULT NULL,
	DS_UNIDADE_GESTORA VARCHAR(100) DEFAULT NULL,
	NUMR_GCV VARCHAR(18) DEFAULT NULL,
	NUMR_GCV_ESTORNO VARCHAR(18) DEFAULT NULL,
	DATA_GCV DATE DEFAULT NULL,
	HISTORICO_GCV VARCHAR(400) DEFAULT NULL,
	VALR_GCV DECIMAL(15,2) DEFAULT NULL,
	CD_FLAG_TIPO_PAGAMENTO VARCHAR(1) DEFAULT NULL,
	DS_FLAG_TIPO_PAGAMENTO VARCHAR(100) DEFAULT NULL,
	DATA_CADASTRO DATE DEFAULT NULL,
	NUMR_GUIA_DEPOSITO VARCHAR(18) DEFAULT NULL,
	DS_NOME VARCHAR(100) DEFAULT NULL,
	NUMR_NOB VARCHAR(18) DEFAULT NULL,
	DATA_NOB DATE DEFAULT NULL,
	NUMR_LIQ VARCHAR(18) DEFAULT NULL,
	DATA_LIQ DATE DEFAULT NULL,
	NUMR_DOTLIST VARCHAR(18) DEFAULT NULL,
	NUMR_NOBLIST VARCHAR(18) DEFAULT NULL,
	NUMR_EMP VARCHAR(18) DEFAULT NULL,
	DATA_EMP DATE DEFAULT NULL,
	CD_TIPO_EMPENHO VARCHAR(1) DEFAULT NULL,
	DS_TIPO_EMPENHO VARCHAR(100) DEFAULT NULL,
	IDEN_CREDOR VARCHAR(10) DEFAULT NULL,
	NOME_CREDOR VARCHAR(100) DEFAULT NULL,
	DOCUMENTO_CREDOR VARCHAR(14) DEFAULT NULL,
	NOME_PESSOA_JURIDICA VARCHAR(100) DEFAULT NULL,
	NOME_PESSOA_FISICA VARCHAR(100) DEFAULT NULL,
	CNPJ VARCHAR(14) DEFAULT NULL,
	CPF VARCHAR(11) DEFAULT NULL,
	CODG_DOTACAO_ORCAMENTARIA VARCHAR(49) DEFAULT NULL,
	CD_ELEMENTO_DESPESA VARCHAR(2) DEFAULT NULL,
	DS_ELEMENTO_DESPESA VARCHAR(100) DEFAULT NULL,
	CD_TIPO_DESPESA VARCHAR(2) DEFAULT NULL,
	DS_TIPO_DESPESA VARCHAR(100) DEFAULT NULL,
	NUMR_CONTRATO VARCHAR(18) DEFAULT NULL,
	NUMR_CONVENIO VARCHAR(35) DEFAULT NULL,
	CODG_CONTA_BANCARIA VARCHAR(8) DEFAULT NULL,
	NOME_CONTA_BANCARIA VARCHAR(100) DEFAULT NULL,
	CODG_BANCO VARCHAR(3) DEFAULT NULL,
	CD_AGENCIA_BANCARIA VARCHAR(6) DEFAULT NULL,
	NUMR_CONTA_CORRENTE_CB VARCHAR(18) DEFAULT NULL,
	CODG_SUBCONTA VARCHAR(5) DEFAULT NULL,
	NOME_SUBCONTA VARCHAR(100) DEFAULT NULL,
	FLAG_FORMA_RECEBIMENTO VARCHAR(100) DEFAULT NULL,
	CODG_BANCO_CREDOR VARCHAR(3) DEFAULT NULL,
	CD_AGENCIA_BANCARIA_CREDOR VARCHAR(6) DEFAULT NULL,
	NUMR_CONTA_CORRENTE_CREDOR VARCHAR(18) DEFAULT NULL,
	IDEN_CONTA_CORRENTE_CREDOR VARCHAR(8) DEFAULT NULL,
	EXERCICIO_FOLHA VARCHAR(5) DEFAULT NULL,
	UO_SEAP VARCHAR(10) DEFAULT NULL,
	MES_FOLHA VARCHAR(2) DEFAULT NULL,
	TIPO_FOLHA VARCHAR(10) DEFAULT NULL,
	NUMR_FOLHA VARCHAR(2) DEFAULT NULL,
	NUMR_PED VARCHAR(18) DEFAULT NULL,
	DATA_PED DATE DEFAULT NULL,
	NUMR_PAD VARCHAR(18) DEFAULT NULL,
	CD_FLAG_MOTIVO_REGULARIZACAO VARCHAR(1) DEFAULT NULL,
	DS_FLAG_MOTIVO_REGULARIZACAO VARCHAR(100) DEFAULT NULL,
	DS_ORIGEM_GUIA VARCHAR(100) DEFAULT NULL,
	VALOR_DEPOSITO DECIMAL(15,2) DEFAULT NULL,
	DATA_DEPOSITO_DEVOLUCAO DATE DEFAULT NULL,
	FORMA_PAGAMENTO VARCHAR(3) DEFAULT NULL,
	CD_NATUREZA_DESPESA VARCHAR(9) DEFAULT NULL,
	CD_FONTE_RECURSO VARCHAR(3) DEFAULT NULL,
	NUMR_PROTOCOLO VARCHAR(8) DEFAULT NULL,
	CD_EXERCICIO_PED VARCHAR(5) DEFAULT NULL,
	TIPO_VINCULO VARCHAR(20) DEFAULT NULL,
	EXEC_ANTERIOR VARCHAR(3) DEFAULT NULL,
	CD_ELEMENTO_DESPESA_ANTERIOR VARCHAR(2) DEFAULT NULL,
	DS_ELEMENTO_DESPESA_ANTERIOR VARCHAR(100) DEFAULT NULL,
	NOME_SERVIDOR VARCHAR(100) DEFAULT NULL,
	CPF_SERVIDOR VARCHAR(11) DEFAULT NULL,
	CD_SITUACAO_GCV VARCHAR(1) DEFAULT NULL,
	DESC_SITUACAO_GCV VARCHAR(100) DEFAULT NULL,
	CD_SITUACAO_NOB VARCHAR(1) DEFAULT NULL,
	DESC_SITUACAO_NOB VARCHAR(100) DEFAULT NULL,
	CD_TRANSMISSAO_NOB VARCHAR(1) DEFAULT NULL,
	DESC_TRANSMISSAO_NOB VARCHAR(100) DEFAULT NULL,
	CD_TRANSMISSAO_ELETRONICA_NOB VARCHAR(2) DEFAULT NULL,
	DS_TRANSMISSAO_ELETRONICA_NOB VARCHAR(100) DEFAULT NULL,
	CD_REGIONAL VARCHAR(4) DEFAULT NULL,
	NUMR_ELI VARCHAR(18) DEFAULT NULL,
	CD_SUBELEMENTO_DESPESA VARCHAR(3) DEFAULT NULL,
	DS_SUBELEMENTO_DESPESA VARCHAR(100) DEFAULT NULL,
	PRIMARY KEY (financeiro_gcv_id),
  KEY financeiro_gcv_cia (financeiro_gcv_cia),
  KEY financeiro_gcv_dept (financeiro_gcv_dept),
  KEY financeiro_gcv_responsavel (financeiro_gcv_responsavel),
  CONSTRAINT financeiro_gcv_dept FOREIGN KEY (financeiro_gcv_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT financeiro_gcv_cia FOREIGN KEY (financeiro_gcv_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT financeiro_gcv_responsavel FOREIGN KEY (financeiro_gcv_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;	


DROP TABLE IF EXISTS financeiro_rel_gcv;

CREATE TABLE financeiro_rel_gcv (
  financeiro_rel_gcv_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  financeiro_rel_gcv_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	financeiro_rel_gcv_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	financeiro_rel_gcv_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	financeiro_rel_gcv_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	financeiro_rel_gcv_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	financeiro_rel_gcv_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	financeiro_rel_gcv_os INTEGER(100) UNSIGNED DEFAULT NULL,
  financeiro_rel_gcv_gcv INTEGER(100) UNSIGNED DEFAULT NULL,
  financeiro_rel_gcv_aprovou INTEGER(100) UNSIGNED DEFAULT NULL,
  financeiro_rel_gcv_data_aprovou DATETIME,
  financeiro_rel_gcv_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  financeiro_rel_gcv_valor DECIMAL(20,3) DEFAULT 0,
  PRIMARY KEY (financeiro_rel_gcv_id),
  KEY financeiro_rel_gcv_projeto (financeiro_rel_gcv_projeto),
  KEY financeiro_rel_gcv_tarefa (financeiro_rel_gcv_tarefa),
  KEY financeiro_rel_gcv_acao (financeiro_rel_gcv_acao),
  KEY financeiro_rel_gcv_acao_item (financeiro_rel_gcv_acao_item),
  KEY financeiro_rel_gcv_tr (financeiro_rel_gcv_tr),
  KEY financeiro_rel_gcv_instrumento (financeiro_rel_gcv_instrumento),
  KEY financeiro_rel_gcv_os (financeiro_rel_gcv_os),
  KEY financeiro_rel_gcv_gcv (financeiro_rel_gcv_gcv),
  KEY financeiro_rel_gcv_aprovou (financeiro_rel_gcv_aprovou),
  CONSTRAINT financeiro_rel_gcv_projeto FOREIGN KEY (financeiro_rel_gcv_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT financeiro_rel_gcv_tarefa FOREIGN KEY (financeiro_rel_gcv_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT financeiro_rel_gcv_acao FOREIGN KEY (financeiro_rel_gcv_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT financeiro_rel_gcv_acao_item FOREIGN KEY (financeiro_rel_gcv_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT financeiro_rel_gcv_aprovou FOREIGN KEY (financeiro_rel_gcv_aprovou) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT financeiro_rel_gcv_tr FOREIGN KEY (financeiro_rel_gcv_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT financeiro_rel_gcv_instrumento FOREIGN KEY (financeiro_rel_gcv_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT financeiro_rel_gcv_os FOREIGN KEY (financeiro_rel_gcv_os) REFERENCES os (os_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT financeiro_rel_gcv_gcv FOREIGN KEY (financeiro_rel_gcv_gcv) REFERENCES financeiro_gcv (financeiro_gcv_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;