UPDATE versao SET versao_codigo='7.7.9'; 
UPDATE versao SET versao_bd=68;

SET FOREIGN_KEY_CHECKS=0;

UPDATE depts SET dept_superior=null WHERE dept_superior=0;
UPDATE cias SET cia_superior=null WHERE cia_superior=0;

INSERT INTO artefatos_tipo (artefato_tipo_id, artefato_tipo_nome, artefato_tipo_campos, artefato_tipo_descricao, artefato_tipo_imagem) VALUES 
  (2,'Anlise de Viabilidade do Projeto (AVP)',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,'','');


ALTER TABLE modelos CHANGE modelo_versao_aprovada modelo_versao_aprovada INTEGER(100) UNSIGNED;
UPDATE modelos SET modelo_versao_aprovada=NULL WHERE modelo_versao_aprovada=0;

ALTER TABLE demandas CHANGE demanda_crecurso_externo demanda_recurso_externo INTEGER(10) DEFAULT '0';
ALTER TABLE demandas ADD COLUMN demanda_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL;

ALTER TABLE demandas CHANGE demanda_projeto demanda_projeto INTEGER(100) UNSIGNED DEFAULT NULL;

ALTER TABLE usuarios ADD COLUMN usuario_analisa_viabilidade TINYINT(1) DEFAULT '0';

UPDATE usuarios SET usuario_analisa_viabilidade=1 WHERE usuario_id=1;

DROP TABLE IF EXISTS projeto_viabilidade;

CREATE TABLE projeto_viabilidade (
  projeto_viabilidade_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  projeto_viabilidade_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_viabilidade_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_viabilidade_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_viabilidade_nome VARCHAR(255),
  projeto_viabilidade_codigo VARCHAR(255),
  projeto_viabilidade_necessidade TEXT,
  projeto_viabilidade_alinhamento TEXT,
  projeto_viabilidade_requisitos TEXT,
  projeto_viabilidade_solucoes TEXT,
  projeto_viabilidade_viabilidade_tecnica TEXT,
  projeto_viabilidade_financeira TEXT,
  projeto_viabilidade_institucional TEXT,
  projeto_viabilidade_solucao TEXT,
  projeto_viabilidade_continuidade TEXT,
  projeto_viabilidade_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_viabilidade_acesso INTEGER(11) DEFAULT '0',
  projeto_viabilidade_cor VARCHAR(6) DEFAULT 'FFFFFF',
  projeto_viabilidade_data DATETIME DEFAULT NULL,
  projeto_viabilidade_ativo TINYINT(1) DEFAULT '0',
  projeto_viabilidade_viavel TINYINT(1) DEFAULT '0',
  PRIMARY KEY (projeto_viabilidade_id),
  KEY projeto_viabilidade_cia (projeto_viabilidade_cia),
  KEY projeto_viabilidade_demanda (projeto_viabilidade_demanda),
  KEY projeto_viabilidade_projeto (projeto_viabilidade_projeto),
  KEY projeto_viabilidade_responsavel (projeto_viabilidade_responsavel),
  CONSTRAINT projeto_viabilidade_fk3 FOREIGN KEY (projeto_viabilidade_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_viabilidade_fk1 FOREIGN KEY (projeto_viabilidade_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_viabilidade_fk FOREIGN KEY (projeto_viabilidade_projeto) REFERENCES projetos (projeto_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT projeto_viabilidade_fk2 FOREIGN KEY (projeto_viabilidade_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB;


DROP TABLE IF EXISTS projeto_viabilidade_usuarios;

CREATE TABLE projeto_viabilidade_usuarios (
  projeto_viabilidade_id INTEGER(100) UNSIGNED DEFAULT NULL,
  usuario_id INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (projeto_viabilidade_id, usuario_id),
  KEY projeto_viabilidade_id (projeto_viabilidade_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT projeto_viabilidade_usuarios_fk1 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_viabilidade_usuarios_fk FOREIGN KEY (projeto_viabilidade_id) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB;


DROP TABLE IF EXISTS projeto_viabilidade_patrocinadores;

CREATE TABLE projeto_viabilidade_patrocinadores (
  projeto_viabilidade_id INTEGER(100) UNSIGNED DEFAULT NULL,
  contato_id INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (projeto_viabilidade_id, contato_id),
  KEY projeto_viabilidade_id (projeto_viabilidade_id),
  KEY contato_id (contato_id),
  CONSTRAINT projeto_viabilidade_patrocinadores_fk1 FOREIGN KEY (contato_id) REFERENCES contatos (contato_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_viabilidade_patrocinadores_fk FOREIGN KEY (projeto_viabilidade_id) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB;


DROP TABLE IF EXISTS projeto_viabilidade_interessados;

CREATE TABLE projeto_viabilidade_interessados (
  projeto_viabilidade_id INTEGER(100) UNSIGNED DEFAULT NULL,
  contato_id INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (projeto_viabilidade_id, contato_id),
  KEY projeto_viabilidade_id (projeto_viabilidade_id),
  KEY contato_id (contato_id),
  CONSTRAINT projeto_viabilidade_interessados_fk1 FOREIGN KEY (contato_id) REFERENCES contatos (contato_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_viabilidade_interessados_fk FOREIGN KEY (projeto_viabilidade_id) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB;

ALTER TABLE demandas ADD CONSTRAINT demandas_fk3 FOREIGN KEY (demanda_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE SET NULL ON UPDATE CASCADE;
ALTER TABLE demandas ADD CONSTRAINT demandas_fk2 FOREIGN KEY (demanda_projeto) REFERENCES projetos (projeto_id) ON DELETE SET NULL ON UPDATE CASCADE;