UPDATE versao SET versao_codigo='7.7.9'; 
UPDATE versao SET versao_bd=69;

SET FOREIGN_KEY_CHECKS=0;

DELETE FROM sisvalores WHERE sisvalor_titulo='StatusProjeto';

INSERT INTO sisvalores (sisvalor_titulo, sisvalor_valor, sisvalor_valor_id, sisvalor_chave_id_pai) VALUES 
	('StatusProjeto','Em execuo','1',NULL),
	('StatusProjeto','Adiado/Suspenso','2',NULL),
	('StatusProjeto','Cancelado','3',NULL),
	('StatusProjeto','Concludo','4',NULL);

UPDATE projetos SET projeto_status=2 WHERE projeto_status=0;
UPDATE projetos SET projeto_status=2 WHERE projeto_status=1;
UPDATE projetos SET projeto_status=2 WHERE projeto_status=2;
UPDATE projetos SET projeto_status=1 WHERE projeto_status=3;
UPDATE projetos SET projeto_status=2 WHERE projeto_status=4;
UPDATE projetos SET projeto_status=4 WHERE projeto_status=5;




INSERT INTO config (config_nome, config_valor, config_grupo, config_tipo) VALUES 
	('qnt_demanda','30','qnt','text'),
	('qnt_viabilidade','30','qnt','text'),
	('qnt_banco_projeto','30','qnt','text'),
	('anexo_eb','true','projetos','checkbox'),
	('anexo_civil','true','projetos','checkbox'),
	('termo_abertura_obrigatorio','false','projetos','checkbox');


INSERT INTO artefatos_tipo (artefato_tipo_id, artefato_tipo_nome, artefato_tipo_campos, artefato_tipo_descricao, artefato_tipo_imagem) VALUES 
  (3,'Termo de Abertura do Projeto (TAP)',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,'','');

DROP TABLE IF EXISTS projeto_patrocinadores;

CREATE TABLE projeto_patrocinadores (
  projeto_patrocinador_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  projeto_id INTEGER(100) UNSIGNED DEFAULT NULL,
  contato_id INTEGER(100) UNSIGNED DEFAULT NULL,
  ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  envolvimento VARCHAR(255) DEFAULT NULL,
  PRIMARY KEY (projeto_patrocinador_id),
  KEY projeto_id (projeto_id),
  KEY contato_id (contato_id),
 	CONSTRAINT projeto_patrocinadores_fk1 FOREIGN KEY (contato_id) REFERENCES contatos (contato_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_patrocinadores_fk FOREIGN KEY (projeto_id) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB;

ALTER TABLE demandas ADD KEY demanda_viabilidade (demanda_viabilidade);
ALTER TABLE demandas ADD KEY demanda_projeto (demanda_projeto);
ALTER TABLE demandas ADD COLUMN demanda_termo_abertura INTEGER(100) UNSIGNED DEFAULT NULL;
ALTER TABLE demandas ADD COLUMN demanda_caracteristica_projeto TINYINT(1) DEFAULT '0';
ALTER TABLE usuarios ADD COLUMN usuario_cria_termo_abertura TINYINT(1) DEFAULT '0';
UPDATE usuarios SET usuario_cria_termo_abertura=1 WHERE usuario_id=1;

ALTER TABLE usuarios ADD COLUMN usuario_aprovar_termo_abertura TINYINT(1) DEFAULT '0';
UPDATE usuarios SET usuario_aprovar_termo_abertura=1 WHERE usuario_id=1;

DROP TABLE IF EXISTS projeto_abertura;

CREATE TABLE projeto_abertura (
  projeto_abertura_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  projeto_abertura_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_abertura_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_abertura_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_abertura_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
 	projeto_abertura_autoridade INTEGER(100) UNSIGNED DEFAULT NULL,
 	projeto_abertura_gerente_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_abertura_acesso INTEGER(11) DEFAULT '0',
  projeto_abertura_nome VARCHAR(255) DEFAULT NULL,
  projeto_abertura_codigo VARCHAR(255) DEFAULT NULL,
 	projeto_abertura_justificativa TEXT,
	projeto_abertura_objetivo TEXT,
	projeto_abertura_escopo TEXT,
	projeto_abertura_nao_escopo TEXT,
	projeto_abertura_tempo TEXT,
	projeto_abertura_custo TEXT,
	projeto_abertura_premissas TEXT,
	projeto_abertura_restricoes TEXT,
	projeto_abertura_riscos TEXT,
 	projeto_abertura_infraestrutura TEXT,
  projeto_abertura_cor VARCHAR(6) DEFAULT 'FFFFFF',
  projeto_abertura_aprovado TINYINT(1) DEFAULT '0',
  projeto_abertura_data DATETIME DEFAULT NULL,
  PRIMARY KEY (projeto_abertura_id),
  KEY projeto_abertura_cia (projeto_abertura_cia),
  KEY projeto_abertura_demanda (projeto_abertura_demanda),
  KEY projeto_abertura_projeto (projeto_abertura_projeto),
  KEY projeto_abertura_responsavel (projeto_abertura_responsavel),
  CONSTRAINT projeto_abertura_fk3 FOREIGN KEY (projeto_abertura_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_abertura_fk1 FOREIGN KEY (projeto_abertura_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_abertura_fk FOREIGN KEY (projeto_abertura_projeto) REFERENCES projetos (projeto_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT projeto_abertura_fk2 FOREIGN KEY (projeto_abertura_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT projeto_abertura_fk4 FOREIGN KEY (projeto_abertura_gerente_projeto) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT projeto_abertura_fk5 FOREIGN KEY (projeto_abertura_autoridade) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB;

DROP TABLE IF EXISTS projeto_abertura_usuarios;

CREATE TABLE projeto_abertura_usuarios (
  projeto_abertura_id INTEGER(100) UNSIGNED DEFAULT NULL,
  usuario_id INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (projeto_abertura_id, usuario_id),
  KEY projeto_abertura_id (projeto_abertura_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT projeto_abertura_usuarios_fk1 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_abertura_usuarios_fk FOREIGN KEY (projeto_abertura_id) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB;

DROP TABLE IF EXISTS projeto_abertura_patrocinadores;

CREATE TABLE projeto_abertura_patrocinadores (
  projeto_abertura_id INTEGER(100) UNSIGNED DEFAULT NULL,
  contato_id INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (projeto_abertura_id, contato_id),
  KEY projeto_abertura_id (projeto_abertura_id),
  KEY contato_id (contato_id),
  CONSTRAINT projeto_abertura_patrocinadores_fk1 FOREIGN KEY (contato_id) REFERENCES contatos (contato_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_abertura_patrocinadores_fk FOREIGN KEY (projeto_abertura_id) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB;


DROP TABLE IF EXISTS projeto_abertura_interessados;

CREATE TABLE projeto_abertura_interessados (
  projeto_abertura_id INTEGER(100) UNSIGNED DEFAULT NULL,
  contato_id INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (projeto_abertura_id, contato_id),
  KEY projeto_abertura_id (projeto_abertura_id),
  KEY contato_id (contato_id),
  CONSTRAINT projeto_abertura_interessados_fk1 FOREIGN KEY (contato_id) REFERENCES contatos (contato_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_abertura_interessados_fk FOREIGN KEY (projeto_abertura_id) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB;


ALTER TABLE demandas ADD KEY demanda_termo_abertura (demanda_termo_abertura);
ALTER TABLE demandas ADD CONSTRAINT demandas_fk4 FOREIGN KEY (demanda_termo_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE SET NULL ON UPDATE CASCADE;