UPDATE versao SET versao_codigo='8.0.0'; 
UPDATE versao SET versao_bd=70;

SET FOREIGN_KEY_CHECKS=0;

DROP TABLE IF EXISTS projeto_qualidade_entrega;

CREATE TABLE projeto_qualidade_entrega (
  projeto_qualidade_entrega_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  projeto_qualidade_entrega_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_qualidade_entrega_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_qualidade_entrega_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_qualidade_entrega_entrega VARCHAR(255) DEFAULT NULL,
  projeto_qualidade_entrega_criterio TEXT,
  projeto_qualidade_entrega_data DATETIME DEFAULT NULL,
  PRIMARY KEY (projeto_qualidade_entrega_id),
  KEY projeto_qualidade_entrega_projeto (projeto_qualidade_entrega_projeto),
  KEY projeto_qualidade_entrega_usuario (projeto_qualidade_entrega_usuario),
  CONSTRAINT projeto_qualidade_entrega_fk FOREIGN KEY (projeto_qualidade_entrega_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_qualidade_entrega_fk1 FOREIGN KEY (projeto_qualidade_entrega_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB;


DROP TABLE IF EXISTS projeto_qualidade;

CREATE TABLE projeto_qualidade (
  projeto_qualidade_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_qualidade_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_qualidade_descricao TEXT,
  projeto_qualidade_data DATETIME DEFAULT NULL,
  PRIMARY KEY (projeto_qualidade_projeto),
  KEY projeto_qualidade_usuario (projeto_qualidade_usuario),
  CONSTRAINT projeto_qualidade_fk FOREIGN KEY (projeto_qualidade_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_qualidade_fk1 FOREIGN KEY (projeto_qualidade_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB;



INSERT INTO artefatos_tipo (artefato_tipo_id, artefato_tipo_nome, artefato_tipo_campos, artefato_tipo_descricao, artefato_tipo_imagem) VALUES 
   (4,'Embasamento do Projeto (EP)',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,'',''),
   (5,'Plano de Qualidade (PQ)',0x613A393A7B733A353A2263616D706F223B613A393A7B693A313B613A323A7B733A343A227469706F223B733A343A226C6F676F223B733A353A226461646F73223B733A31313A2270726F6A65746F5F636961223B7D693A323B613A323A7B733A343A227469706F223B733A393A226361626563616C686F223B733A353A226461646F73223B733A31313A2270726F6A65746F5F636961223B7D693A333B613A323A7B733A343A227469706F223B733A31333A22626C6F636F5F73696D706C6573223B733A353A226461646F73223B733A31343A2270726F6A65746F5F636F6469676F223B7D693A343B613A323A7B733A343A227469706F223B733A31333A22626C6F636F5F73696D706C6573223B733A353A226461646F73223B733A31323A2270726F6A65746F5F6E6F6D65223B7D693A353B613A323A7B733A343A227469706F223B733A31333A22626C6F636F5F73696D706C6573223B733A353A226461646F73223B733A32373A2270726F6A65746F5F7175616C69646164655F64657363726963616F223B7D693A363B613A323A7B733A343A227469706F223B733A31343A226C697374615F657370656369616C223B733A353A226461646F73223B733A32353A2270726F6A65746F5F7175616C69646164655F656E7472656761223B7D693A373B613A323A7B733A343A227469706F223B733A31323A226E6F6D655F7573756172696F223B733A353A226461646F73223B733A32353A2270726F6A65746F5F7175616C69646164655F7573756172696F223B7D693A383B613A323A7B733A343A227469706F223B733A31343A2266756E63616F5F7573756172696F223B733A353A226461646F73223B733A32353A2270726F6A65746F5F7175616C69646164655F7573756172696F223B7D693A393B613A323A7B733A343A227469706F223B733A343A2264617461223B733A353A226461646F73223B733A32323A2270726F6A65746F5F7175616C69646164655F64617461223B7D7D733A31313A226D6F64656C6F5F7469706F223B733A313A2235223B733A363A2265646963616F223B623A303B733A393A22696D7072657373616F223B623A303B733A393A226D6F64656C6F5F6964223B693A303B733A393A2270617261677261666F223B693A303B733A31353A226D6F64656C6F5F6461646F735F6964223B693A303B733A363A226D6F64656C6F223B4E3B733A333A22716E74223B693A393B7D,'','');


DROP TABLE IF EXISTS projeto_embasamento;

CREATE TABLE projeto_embasamento (
  projeto_embasamento_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_embasamento_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
 	projeto_embasamento_justificativa TEXT,
	projeto_embasamento_objetivo TEXT,
	projeto_embasamento_escopo TEXT,
	projeto_embasamento_nao_escopo TEXT,
	projeto_embasamento_premissas TEXT,
	projeto_embasamento_restricoes TEXT,
	projeto_embasamento_orcamento TEXT,
  projeto_embasamento_data DATETIME DEFAULT NULL,
  PRIMARY KEY (projeto_embasamento_projeto),
  KEY projeto_embasamento_responsavel (projeto_embasamento_responsavel),
  CONSTRAINT projeto_embasamento_fk FOREIGN KEY (projeto_embasamento_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_embasamento_fk2 FOREIGN KEY (projeto_embasamento_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB;