UPDATE versao SET versao_codigo='8.0.0'; 
UPDATE versao SET ultima_atualizacao_bd='2011-10-03'; 
UPDATE versao SET ultima_atualizacao_codigo='2011-10-04'; 
UPDATE versao SET versao_bd=72;

SET FOREIGN_KEY_CHECKS=0;

ALTER TABLE usuarios ADD COLUMN usuario_pode_lateral TINYINT(1) NOT NULL DEFAULT '0';

DROP TABLE IF EXISTS projeto_comunicacao;

CREATE TABLE projeto_comunicacao (
 projeto_comunicacao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
 projeto_comunicacao_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
 projeto_comunicacao_descricao TEXT,
 projeto_comunicacao_data DATETIME DEFAULT NULL,
 PRIMARY KEY (projeto_comunicacao_projeto),
 KEY projeto_comunicacao_usuario (projeto_comunicacao_usuario),
 CONSTRAINT projeto_comunicacao_fk FOREIGN KEY (projeto_comunicacao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
 CONSTRAINT projeto_comunicacao_fk1 FOREIGN KEY (projeto_comunicacao_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB;


DROP TABLE IF EXISTS projeto_comunicacao_evento;

CREATE TABLE projeto_comunicacao_evento (
 projeto_comunicacao_evento_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
 projeto_comunicacao_evento_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
 projeto_comunicacao_evento_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
 projeto_comunicacao_evento_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
 projeto_comunicacao_evento_evento TEXT,
 projeto_comunicacao_evento_objetivo TEXT,
 projeto_comunicacao_evento_responsavel TEXT,
 projeto_comunicacao_evento_publico TEXT,
 projeto_comunicacao_evento_canal TEXT,
 projeto_comunicacao_evento_periodicidade TEXT,
 projeto_comunicacao_evento_data DATETIME DEFAULT NULL,
 PRIMARY KEY (projeto_comunicacao_evento_id),
 KEY projeto_comunicacao_evento_projeto (projeto_comunicacao_evento_projeto),
 KEY projeto_comunicacao_evento_usuario (projeto_comunicacao_evento_usuario),
 CONSTRAINT projeto_comunicacao_evento_fk FOREIGN KEY (projeto_comunicacao_evento_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
 CONSTRAINT projeto_comunicacao_evento_fk1 FOREIGN KEY (projeto_comunicacao_evento_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB;


DROP TABLE IF EXISTS projeto_risco;

CREATE TABLE projeto_risco (
 projeto_risco_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
 projeto_risco_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
 projeto_risco_descricao TEXT,
 projeto_risco_data DATETIME DEFAULT NULL,
 PRIMARY KEY (projeto_risco_projeto),
 KEY projeto_risco_usuario (projeto_risco_usuario),
 CONSTRAINT projeto_risco_fk FOREIGN KEY (projeto_risco_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
 CONSTRAINT projeto_risco_fk1 FOREIGN KEY (projeto_risco_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB;


DROP TABLE IF EXISTS projeto_risco_tipo;

CREATE TABLE projeto_risco_tipo (
 projeto_risco_tipo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
 projeto_risco_tipo_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
 projeto_risco_tipo_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
 projeto_risco_tipo_descricao TEXT,
 projeto_risco_tipo_categoria VARCHAR(255) DEFAULT NULL,
 projeto_risco_tipo_tipo VARCHAR(8) DEFAULT NULL,
 projeto_risco_tipo_consequencia TEXT,
 projeto_risco_tipo_probabilidade VARCHAR(5) DEFAULT NULL,
 projeto_risco_tipo_impacto VARCHAR(5) DEFAULT NULL,
 projeto_risco_tipo_severidade VARCHAR(5) DEFAULT NULL,
 projeto_risco_tipo_acao TEXT,
 projeto_risco_tipo_gatilho VARCHAR(255) DEFAULT NULL,
 projeto_risco_tipo_resposta TEXT,
 projeto_risco_tipo_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
 projeto_risco_tipo_status  VARCHAR(255) DEFAULT NULL,
 projeto_risco_tipo_data DATETIME DEFAULT NULL,
 PRIMARY KEY (projeto_risco_tipo_id),
 KEY projeto_risco_tipo_projeto (projeto_risco_tipo_projeto),
 KEY projeto_risco_tipo_usuario (projeto_risco_tipo_usuario),
 CONSTRAINT projeto_risco_tipo_fk FOREIGN KEY (projeto_risco_tipo_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
 CONSTRAINT projeto_risco_tipo_fk1 FOREIGN KEY (projeto_risco_tipo_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB;


INSERT INTO artefatos_tipo (artefato_tipo_id, artefato_tipo_nome, artefato_tipo_campos, artefato_tipo_descricao, artefato_tipo_imagem) VALUES 
   (6,'Pano de Comunicao (PC)',0x613A393A7B733A353A2263616D706F223B613A393A7B693A313B613A323A7B733A343A227469706F223B733A343A226C6F676F223B733A353A226461646F73223B733A31313A2270726F6A65746F5F636961223B7D693A323B613A323A7B733A343A227469706F223B733A393A226361626563616C686F223B733A353A226461646F73223B733A31313A2270726F6A65746F5F636961223B7D693A333B613A323A7B733A343A227469706F223B733A31333A22626C6F636F5F73696D706C6573223B733A353A226461646F73223B733A31343A2270726F6A65746F5F636F6469676F223B7D693A343B613A323A7B733A343A227469706F223B733A31333A22626C6F636F5F73696D706C6573223B733A353A226461646F73223B733A31323A2270726F6A65746F5F6E6F6D65223B7D693A353B613A323A7B733A343A227469706F223B733A31333A22626C6F636F5F73696D706C6573223B733A353A226461646F73223B733A32393A2270726F6A65746F5F636F6D756E69636163616F5F64657363726963616F223B7D693A363B613A323A7B733A343A227469706F223B733A31343A226C697374615F657370656369616C223B733A353A226461646F73223B733A32363A2270726F6A65746F5F636F6D756E69636163616F5F6576656E746F223B7D693A373B613A323A7B733A343A227469706F223B733A31323A226E6F6D655F7573756172696F223B733A353A226461646F73223B733A32373A2270726F6A65746F5F636F6D756E69636163616F5F7573756172696F223B7D693A383B613A323A7B733A343A227469706F223B733A31343A2266756E63616F5F7573756172696F223B733A353A226461646F73223B733A32373A2270726F6A65746F5F636F6D756E69636163616F5F7573756172696F223B7D693A393B613A323A7B733A343A227469706F223B733A343A2264617461223B733A353A226461646F73223B733A32343A2270726F6A65746F5F636F6D756E69636163616F5F64617461223B7D7D733A31313A226D6F64656C6F5F7469706F223B733A313A2236223B733A363A2265646963616F223B623A303B733A393A22696D7072657373616F223B623A303B733A393A226D6F64656C6F5F6964223B693A303B733A393A2270617261677261666F223B693A303B733A31353A226D6F64656C6F5F6461646F735F6964223B693A303B733A363A226D6F64656C6F223B4E3B733A333A22716E74223B693A393B7D,'','');