UPDATE versao SET versao_codigo='8.0.0'; 
UPDATE versao SET ultima_atualizacao_bd='2011-10-16'; 
UPDATE versao SET ultima_atualizacao_codigo='2011-10-16'; 
UPDATE versao SET versao_bd=77;

SET FOREIGN_KEY_CHECKS=0;


DROP TABLE IF EXISTS projeto_encerramento;

CREATE TABLE projeto_encerramento (
  projeto_encerramento_projeto INTEGER(100) UNSIGNED NOT NULL DEFAULT '0',
  projeto_encerramento_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_encerramento_justificativa TEXT,
  projeto_encerramento_encerrado TINYINT(1) UNSIGNED DEFAULT '0',
  projeto_encerramento_encerrado_ressalvas TINYINT(1) UNSIGNED DEFAULT '0',
  projeto_encerramento_nao_encerrado TINYINT(1) UNSIGNED DEFAULT '0',
  projeto_encerramento_data DATETIME DEFAULT NULL,
  PRIMARY KEY (projeto_encerramento_projeto),
  KEY projeto_encerramento_responsavel (projeto_encerramento_responsavel),
  CONSTRAINT projeto_encerramento_fk FOREIGN KEY (projeto_encerramento_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_encerramento_fk2 FOREIGN KEY (projeto_encerramento_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB;

ALTER TABLE projeto_anexo_m1 CHANGE info_mudancas_escolpo info_mudancas_escopo TEXT;

DROP TABLE IF EXISTS licao;

CREATE TABLE licao (
  licao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  licao_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  licao_responsavel INTEGER(100) UNSIGNED NULL,
  licao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  licao_nome VARCHAR(255) DEFAULT NULL,
  licao_ocorrencia TEXT,
  licao_tipo TINYINT(1) UNSIGNED DEFAULT '0',
  licao_categoria VARCHAR(255) DEFAULT NULL,
  licao_consequencia TEXT,
  licao_acao_tomada TEXT,
  licao_aprendizado TEXT,
  licao_data DATETIME DEFAULT NULL,
  licao_acesso INTEGER(100) UNSIGNED DEFAULT '0',
  licao_cor VARCHAR(6) DEFAULT 'ffffff',
  licao_ativa TINYINT(1) DEFAULT '1',
  PRIMARY KEY (licao_id),
  KEY licao_cia (licao_cia),
  KEY licao_responsavel (licao_responsavel),
  KEY licao_projeto (licao_projeto),
  CONSTRAINT licao_fk FOREIGN KEY (licao_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT licao_fk1 FOREIGN KEY (licao_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT licao_fk2 FOREIGN KEY (licao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB;


DROP TABLE IF EXISTS licao_usuarios;

CREATE TABLE licao_usuarios (
  licao_id INTEGER(100) UNSIGNED DEFAULT NULL,
  usuario_id INTEGER(100) UNSIGNED DEFAULT NULL,
  KEY licao_id (licao_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT licao_usuarios_fk FOREIGN KEY (licao_id) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT licao_usuarios_fk1 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB;


INSERT INTO config (config_nome, config_valor, config_grupo, config_tipo) VALUES 
	('qnt_licoes','30','qnt','text');
	
INSERT INTO sisvalores (sisvalor_titulo, sisvalor_valor, sisvalor_valor_id, sisvalor_chave_id_pai) VALUES 
	('LicaoCategoria','Escopo','Escopo',NULL),
	('LicaoCategoria','Tempo','Tempo',NULL),
	('LicaoCategoria','Custo','Custo',NULL),
	('LicaoCategoria','Qualidade','Qualidade',NULL),
	('LicaoCategoria','Aquisio','Aquisio',NULL),
	('LicaoCategoria','Integrao','Integrao',NULL),
	('LicaoCategoria','Recursos Humanos','Recursos Humanos',NULL),
	('LicaoCategoria','Comunicao','Comunicao',NULL),
	('LicaoCategoria','Risco','Risco',NULL);



INSERT INTO artefatos_tipo (artefato_tipo_id, artefato_tipo_nome, artefato_tipo_campos, artefato_tipo_descricao, artefato_tipo_imagem) VALUES 
  (9,'Lies Aprendidas (LA)',0x613A393A7B733A353A2263616D706F223B613A353A7B693A313B613A323A7B733A343A227469706F223B733A343A226C6F676F223B733A353A226461646F73223B733A31313A2270726F6A65746F5F636961223B7D693A323B613A323A7B733A343A227469706F223B733A393A226361626563616C686F223B733A353A226461646F73223B733A31313A2270726F6A65746F5F636961223B7D693A333B613A323A7B733A343A227469706F223B733A31333A22626C6F636F5F73696D706C6573223B733A353A226461646F73223B733A31343A2270726F6A65746F5F636F6469676F223B7D693A343B613A323A7B733A343A227469706F223B733A31333A22626C6F636F5F73696D706C6573223B733A353A226461646F73223B733A31323A2270726F6A65746F5F6E6F6D65223B7D693A353B613A323A7B733A343A227469706F223B733A31343A226C697374615F657370656369616C223B733A353A226461646F73223B733A353A226C6963616F223B7D7D733A31313A226D6F64656C6F5F7469706F223B733A313A2239223B733A363A2265646963616F223B623A303B733A393A22696D7072657373616F223B623A303B733A393A226D6F64656C6F5F6964223B693A303B733A393A2270617261677261666F223B693A303B733A31353A226D6F64656C6F5F6461646F735F6964223B693A303B733A363A226D6F64656C6F223B4E3B733A333A22716E74223B693A353B7D,'',''),
  (10,'Termo de Encerramento de Projeto (TEP)',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,'','');
