UPDATE versao SET versao_codigo='8.0.2'; 
UPDATE versao SET ultima_atualizacao_bd='2011-10-31'; 
UPDATE versao SET ultima_atualizacao_codigo='2011-10-31'; 
UPDATE versao SET versao_bd=80;

SET FOREIGN_KEY_CHECKS=0;

DROP TABLE IF EXISTS projeto_mudanca;

CREATE TABLE projeto_mudanca (
  projeto_mudanca_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  projeto_mudanca_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_mudanca_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_mudanca_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_mudanca_cliente INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_mudanca_autoridade INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_mudanca_numero INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_mudanca_justificativa TEXT,
  projeto_mudanca_parecer_tecnico TEXT,
  projeto_mudanca_solucoes TEXT,
  projeto_mudanca_impacto_cronograma TEXT,
  projeto_mudanca_impacto_custo TEXT,
  projeto_mudanca_novo_risco TEXT,
  projeto_mudanca_outros_impactos TEXT,
  projeto_mudanca_solucao TEXT,
  projeto_mudanca_parecer TEXT,
  projeto_mudanca_requisitante_aprovada TINYINT(1) UNSIGNED DEFAULT '0',
  projeto_mudanca_requisitante_reprovada TINYINT(1) UNSIGNED DEFAULT '0',
  projeto_mudanca_administracao_aprovada TINYINT(1) UNSIGNED DEFAULT '0',
  projeto_mudanca_administracao_reprovada TINYINT(1) UNSIGNED DEFAULT '0',
  projeto_mudanca_data DATETIME DEFAULT NULL,
  projeto_mudanca_data_aprovacao DATETIME DEFAULT NULL,
  projeto_mudanca_cor VARCHAR(6) DEFAULT 'ffffff',
  projeto_mudanca_acesso INTEGER(100) UNSIGNED DEFAULT '0',
  PRIMARY KEY (projeto_mudanca_id),
  KEY projeto_mudanca_projeto (projeto_mudanca_projeto),
  KEY projeto_mudanca_tarefa (projeto_mudanca_tarefa),
  KEY projeto_mudanca_responsavel (projeto_mudanca_responsavel),
  KEY projeto_mudanca_autoridade (projeto_mudanca_autoridade),
  KEY projeto_mudanca_cliente (projeto_mudanca_cliente),
  CONSTRAINT projeto_mudanca_fk FOREIGN KEY (projeto_mudanca_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_mudanca_fk5 FOREIGN KEY (projeto_mudanca_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT projeto_mudanca_fk2 FOREIGN KEY (projeto_mudanca_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT projeto_mudanca_fk4 FOREIGN KEY (projeto_mudanca_autoridade) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT projeto_mudanca_fk3 FOREIGN KEY (projeto_mudanca_cliente) REFERENCES contatos (contato_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB;

DROP TABLE IF EXISTS projeto_mudanca_usuarios;

CREATE TABLE projeto_mudanca_usuarios (
  projeto_mudanca_id INTEGER(100) UNSIGNED DEFAULT NULL,
  usuario_id INTEGER(100) UNSIGNED DEFAULT NULL,
  KEY projeto_mudanca_id (projeto_mudanca_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT projeto_mudanca_usuarios_fk FOREIGN KEY (projeto_mudanca_id) REFERENCES projeto_mudanca (projeto_mudanca_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_mudanca_usuarios_fk1 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB;

INSERT INTO artefatos_tipo (artefato_tipo_id, artefato_tipo_nome, artefato_tipo_campos, artefato_tipo_descricao, artefato_tipo_imagem) VALUES 
  (12,'Formulrio de Solicitao de Mudanas (FSM)',0x613A393A7B733A353A2263616D706F223B613A32363A7B693A313B613A323A7B733A343A227469706F223B733A343A226C6F676F223B733A353A226461646F73223B733A31313A2270726F6A65746F5F636961223B7D693A323B613A323A7B733A343A227469706F223B733A393A226361626563616C686F223B733A353A226461646F73223B733A31313A2270726F6A65746F5F636961223B7D693A333B613A323A7B733A343A227469706F223B733A31333A22626C6F636F5F73696D706C6573223B733A353A226461646F73223B733A31343A2270726F6A65746F5F636F6469676F223B7D693A343B613A323A7B733A343A227469706F223B733A31333A22626C6F636F5F73696D706C6573223B733A353A226461646F73223B733A31323A2270726F6A65746F5F6E6F6D65223B7D693A353B613A323A7B733A343A227469706F223B733A31393A226E756D65726F5F747265735F64696769746F73223B733A353A226461646F73223B733A32323A2270726F6A65746F5F6D7564616E63615F6E756D65726F223B7D693A363B613A323A7B733A343A227469706F223B733A343A2264617461223B733A353A226461646F73223B733A32303A2270726F6A65746F5F6D7564616E63615F64617461223B7D693A373B613A323A7B733A343A227469706F223B733A31323A226E6F6D655F636F6E7461746F223B733A353A226461646F73223B733A32333A2270726F6A65746F5F6D7564616E63615F636C69656E7465223B7D693A383B613A323A7B733A343A227469706F223B733A31323A22646570745F636F6E7461746F223B733A353A226461646F73223B733A32333A2270726F6A65746F5F6D7564616E63615F636C69656E7465223B7D693A393B613A323A7B733A343A227469706F223B733A31333A22656D61696C5F636F6E7461746F223B733A353A226461646F73223B733A32333A2270726F6A65746F5F6D7564616E63615F636C69656E7465223B7D693A31303B613A323A7B733A343A227469706F223B733A31363A2274656C65666F6E655F636F6E7461746F223B733A353A226461646F73223B733A32333A2270726F6A65746F5F6D7564616E63615F636C69656E7465223B7D693A31313B613A323A7B733A343A227469706F223B733A31333A22626C6F636F5F73696D706C6573223B733A353A226461646F73223B733A32393A2270726F6A65746F5F6D7564616E63615F6A757374696669636174697661223B7D693A31323B613A323A7B733A343A227469706F223B733A31333A22626C6F636F5F73696D706C6573223B733A353A226461646F73223B733A33313A2270726F6A65746F5F6D7564616E63615F706172656365725F7465636E69636F223B7D693A31333B613A323A7B733A343A227469706F223B733A31333A22626C6F636F5F73696D706C6573223B733A353A226461646F73223B733A32343A2270726F6A65746F5F6D7564616E63615F736F6C75636F6573223B7D693A31343B613A323A7B733A343A227469706F223B733A31333A22626C6F636F5F73696D706C6573223B733A353A226461646F73223B733A33343A2270726F6A65746F5F6D7564616E63615F696D706163746F5F63726F6E6F6772616D61223B7D693A31353B613A323A7B733A343A227469706F223B733A31333A22626C6F636F5F73696D706C6573223B733A353A226461646F73223B733A32393A2270726F6A65746F5F6D7564616E63615F696D706163746F5F637573746F223B7D693A31363B613A323A7B733A343A227469706F223B733A31333A22626C6F636F5F73696D706C6573223B733A353A226461646F73223B733A32363A2270726F6A65746F5F6D7564616E63615F6E6F766F5F726973636F223B7D693A31373B613A323A7B733A343A227469706F223B733A31333A22626C6F636F5F73696D706C6573223B733A353A226461646F73223B733A33313A2270726F6A65746F5F6D7564616E63615F6F7574726F735F696D706163746F73223B7D693A31383B613A323A7B733A343A227469706F223B733A31333A22626C6F636F5F73696D706C6573223B733A353A226461646F73223B733A32333A2270726F6A65746F5F6D7564616E63615F736F6C7563616F223B7D693A31393B613A323A7B733A343A227469706F223B733A31333A22626C6F636F5F73696D706C6573223B733A353A226461646F73223B733A32333A2270726F6A65746F5F6D7564616E63615F70617265636572223B7D693A32303B613A323A7B733A343A227469706F223B733A383A226D61726361725F78223B733A353A226461646F73223B733A33373A2270726F6A65746F5F6D7564616E63615F7265717569736974616E74655F6170726F76616461223B7D693A32313B613A323A7B733A343A227469706F223B733A383A226D61726361725F78223B733A353A226461646F73223B733A33383A2270726F6A65746F5F6D7564616E63615F7265717569736974616E74655F726570726F76616461223B7D693A32323B613A323A7B733A343A227469706F223B733A383A226D61726361725F78223B733A353A226461646F73223B733A33383A2270726F6A65746F5F6D7564616E63615F61646D696E697374726163616F5F6170726F76616461223B7D693A32333B613A323A7B733A343A227469706F223B733A383A226D61726361725F78223B733A353A226461646F73223B733A33393A2270726F6A65746F5F6D7564616E63615F61646D696E697374726163616F5F726570726F76616461223B7D693A32343B613A323A7B733A343A227469706F223B733A31323A226E6F6D655F7573756172696F223B733A353A226461646F73223B733A32363A2270726F6A65746F5F6D7564616E63615F6175746F726964616465223B7D693A32353B613A323A7B733A343A227469706F223B733A31343A2266756E63616F5F7573756172696F223B733A353A226461646F73223B733A32363A2270726F6A65746F5F6D7564616E63615F6175746F726964616465223B7D693A32363B613A323A7B733A343A227469706F223B733A343A2264617461223B733A353A226461646F73223B733A33303A2270726F6A65746F5F6D7564616E63615F646174615F6170726F766163616F223B7D7D733A31313A226D6F64656C6F5F7469706F223B733A323A223132223B733A363A2265646963616F223B623A303B733A393A22696D7072657373616F223B623A303B733A393A226D6F64656C6F5F6964223B693A303B733A393A2270617261677261666F223B693A303B733A31353A226D6F64656C6F5F6461646F735F6964223B693A303B733A363A226D6F64656C6F223B4E3B733A333A22716E74223B693A32363B7D,'','');

