UPDATE versao SET versao_codigo='8.0.3'; 
UPDATE versao SET ultima_atualizacao_bd='2011-11-02'; 
UPDATE versao SET ultima_atualizacao_codigo='2011-11-02'; 
UPDATE versao SET versao_bd=81;

SET FOREIGN_KEY_CHECKS=0;

ALTER TABLE baseline_tarefas ADD COLUMN tarefa_numeracao INTEGER(100) UNSIGNED DEFAULT NULL;

DROP TABLE IF EXISTS projeto_ata;

CREATE TABLE projeto_ata (
  projeto_ata_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  projeto_ata_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_ata_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_ata_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_ata_numero INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_ata_data_inicio DATETIME DEFAULT NULL,
  projeto_ata_data_fim DATETIME DEFAULT NULL,
  projeto_ata_local TEXT,
  projeto_ata_relato TEXT, 
  projeto_ata_proxima_data_inicio DATETIME DEFAULT NULL,
  projeto_ata_proxima_data_fim DATETIME DEFAULT NULL,
  projeto_ata_proxima_local TEXT,
  projeto_ata_cor VARCHAR(6) DEFAULT 'ffffff',
  projeto_ata_acesso INTEGER(100) UNSIGNED DEFAULT '0',
  PRIMARY KEY (projeto_ata_id),
  KEY projeto_ata_projeto (projeto_ata_projeto),
  KEY projeto_ata_tarefa (projeto_ata_tarefa),
  KEY projeto_ata_responsavel (projeto_ata_responsavel),
  CONSTRAINT projeto_ata_fk FOREIGN KEY (projeto_ata_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_ata_fk5 FOREIGN KEY (projeto_ata_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT projeto_ata_fk2 FOREIGN KEY (projeto_ata_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB;

DROP TABLE IF EXISTS projeto_ata_usuarios;

CREATE TABLE projeto_ata_usuarios (
  projeto_ata_id INTEGER(100) UNSIGNED DEFAULT NULL,
  usuario_id INTEGER(100) UNSIGNED DEFAULT NULL,
  KEY projeto_ata_id (projeto_ata_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT projeto_ata_usuarios_fk FOREIGN KEY (projeto_ata_id) REFERENCES projeto_ata (projeto_ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_ata_usuarios_fk1 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB;

DROP TABLE IF EXISTS projeto_ata_pauta;

CREATE TABLE projeto_ata_pauta (
  projeto_ata_pauta_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  projeto_ata_id INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_ata_pauta_texto TEXT, 
  projeto_ata_pauta_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_ata_pauta_tipo VARCHAR(20)  DEFAULT '',
  PRIMARY KEY (projeto_ata_pauta_id),
  KEY projeto_ata_id (projeto_ata_id),
  CONSTRAINT projeto_ata_pauta_fk FOREIGN KEY (projeto_ata_id) REFERENCES projeto_ata (projeto_ata_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB;


DROP TABLE IF EXISTS projeto_ata_acao;

CREATE TABLE projeto_ata_acao (
  projeto_ata_acao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  projeto_ata_id INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_ata_acao_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_ata_acao_data DATETIME DEFAULT NULL,
  projeto_ata_acao_texto TEXT, 
  projeto_ata_acao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_ata_acao_tipo VARCHAR(20)  DEFAULT '',
  PRIMARY KEY (projeto_ata_acao_id),
  KEY projeto_ata_id (projeto_ata_id),
  KEY projeto_ata_acao_responsavel (projeto_ata_acao_responsavel),
  CONSTRAINT projeto_ata_acao_fk1 FOREIGN KEY (projeto_ata_acao_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT projeto_ata_acao_fk FOREIGN KEY (projeto_ata_id) REFERENCES projeto_ata (projeto_ata_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB;

INSERT INTO artefatos_tipo (artefato_tipo_id, artefato_tipo_nome, artefato_tipo_campos, artefato_tipo_descricao, artefato_tipo_imagem) VALUES 
  (13,'Ata de Reunio',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,'','');

