SET FOREIGN_KEY_CHECKS=0;
UPDATE versao SET versao_codigo='8.0.7'; 
UPDATE versao SET ultima_atualizacao_bd='2012-01-01'; 
UPDATE versao SET ultima_atualizacao_codigo='2012-01-01'; 
UPDATE versao SET versao_bd=89;

ALTER TABLE depts DROP FOREIGN KEY depts_fk2;
ALTER TABLE depts ADD CONSTRAINT depts_fk2 FOREIGN KEY (dept_responsavel) REFERENCES contatos (contato_id) ON DELETE SET NULL ON UPDATE CASCADE;

ALTER TABLE projetos ADD COLUMN projeto_portfolio INTEGER(1) DEFAULT '0';

DROP TABLE IF EXISTS projeto_portfolio;

CREATE TABLE projeto_portfolio (
  projeto_portfolio_pai INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_portfolio_filho INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_portfolio_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (projeto_portfolio_pai, projeto_portfolio_filho),
  KEY projeto_portfolio_pai (projeto_portfolio_pai),
  KEY projeto_portfolio_filho (projeto_portfolio_filho),
  CONSTRAINT projeto_portfolio_fk FOREIGN KEY (projeto_portfolio_pai) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_portfolio_fk1 FOREIGN KEY (projeto_portfolio_filho) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB;


ALTER TABLE recurso_tarefas DROP COLUMN recurso_inicio;
ALTER TABLE recurso_tarefas DROP COLUMN recurso_fim;

DELETE FROM sisvalores WHERE sisvalor_titulo='IndicadorTipo';

INSERT INTO sisvalores (sisvalor_titulo, sisvalor_valor, sisvalor_valor_id, sisvalor_chave_id_pai) VALUES 
('IndicadorTipo','Eficincia','eficiencia',NULL),
('IndicadorTipo','Eficcia ','eficacia ',NULL),
('IndicadorTipo','Efetividade ','efetividade ',NULL);


DROP TABLE IF EXISTS campo_formulario;

CREATE TABLE campo_formulario (
  campo_formulario_id INTEGER(100) NOT NULL AUTO_INCREMENT,
  campo_formulario_tipo VARCHAR(20) DEFAULT NULL,
  campo_formulario_campo VARCHAR(20) DEFAULT NULL,
  campo_formulario_descricao VARCHAR(100) DEFAULT NULL,
  campo_formulario_ativo TINYINT(1) DEFAULT '1',
  PRIMARY KEY (campo_formulario_id)
)ENGINE=InnoDB;

INSERT INTO campo_formulario (campo_formulario_tipo, campo_formulario_campo, campo_formulario_descricao, campo_formulario_ativo) VALUES 
	('projeto','supervisor','Supervisor',1),
	('projeto','autoridade','Autoridade',1),
	('projeto','codigo','Cdigo',1),
	('projeto','ano','Ano',1),
	('projeto','setor','Setor',1),
	('projeto','segmento','Segmento',1),
	('projeto','intervencao','Interveno',1),
	('projeto','tipo_intervencao','Tipo de intero',1),
	('projeto','categoria','Categoria',1),
	('projeto','url','URL',1),
	('projeto','www','Endereo web',1),
	('projeto','oque','O que',1),
	('projeto','porque','Por que',1),
	('projeto','como','Como',1),
	('projeto','onde','Onde',1),
	('projeto','endereco','Endereo',1),
	('projeto','municipios','Municipios',1),
	('projeto','latitude','Latitude',1),
	('projeto','longitude','Longitude',1),
	('projeto','area','rea',1),
	('projeto','partes','Partes diretamente envolvidas',1),
	('projeto','depts','Departamentos',1),
	('tarefa','link','Link',1),
	('tarefa','codigo','Cdigo',1),
	('tarefa','tipo','Tipo',1),
	('tarefa','depts','Departamentos',1),
	('tarefa','contatos','Contatos',1),
	('tarefa','endereco','Endereo',1),
	('tarefa','latitude','Latitude',1),
	('tarefa','longitude','Longitude',1),
	('tarefa','area','rea',1),
	('tarefa','oque','O que',1),
	('tarefa','porque','Por que',1),
	('tarefa','como','Como',1),
	('tarefa','onde','Onde',1),
	('tarefa','previsto','Quantidade prevista',1),
	('tarefa','realizado','Quantidade realizada',1),
	('tarefa','unidade','Unidade',1),
	('tarefa','empregos_execucao','Empregos durante a execuo',1),
	('tarefa','empregos_diretos','Empregos diretos aps concluso',1),
	('tarefa','empregos_indiretos','Empregos indiretos aps concluso',1),
	('tarefa','implantacao','Forma de implantao',1),
	('tarefa','populacao','Populao atendida',1),
	('tarefa','municipios','Municipios',1),
	('projetos','cor','Cor',1),
	('projetos','prioridade','Prioridade',1),
	('projetos','cia','Organizao',1),
	('projetos','depts','Departamentos',1),
	('projetos','inicio','Incio',1),
	('projetos','termino','Trmino',1),
	('projetos','provavel_inicio','Provavel incio',1),
	('projetos','provavel_termino','Provavel trmino',1),
	('projetos','problema','Registro de problema',1),
	('projetos','responsavel','Responsavel',1),
	('projetos','custo','Custo total',1),
	('projetos','status','Status',1),
	('projetos','gasto','Gasto total',0),
	('projetos','recursos','Recursos financeiros alocados',0),
	('projetos','supervisor','Supervisor',0),
	('projetos','autoridade','Autoridade',0),
	('projetos','codigo','Cdigo',0),
	('projetos','ano','Ano',0),
	('projetos','setor','Setor',0),
	('projetos','segmento','Segmento',0),
	('projetos','intervencao','Interveno',0),
	('projetos','tipo_intervencao','Tipo de intero',0),
	('projetos','categoria','Categoria',0),
	('projetos','url','URL',0),
	('projetos','www','Endereo web',0),
	('projetos','partes','Partes diretamente envolvidas',0),
	('projetos','integrantes','Integrantes do projeto',0);

ALTER TABLE pratica_indicador ADD COLUMN pratica_indicador_campo_projeto TINYINT(1) DEFAULT '0';
ALTER TABLE pratica_indicador ADD COLUMN pratica_indicador_parametro_projeto VARCHAR(20) DEFAULT NULL;

UPDATE config SET config_valor='mpog', config_tipo='select' WHERE config_nome='anexo_civil';

INSERT INTO config_lista (config_lista_id, config_nome, config_lista_nome) VALUES 
  (38,'anexo_civil',''),
  (39,'anexo_civil','mpog'),
  (40,'anexo_civil','cnj');
  
ALTER TABLE artefatos_tipo ADD COLUMN artefato_tipo_civil VARCHAR(20) DEFAULT NULL; 
UPDATE artefatos_tipo SET artefato_tipo_civil='mpog' WHERE artefato_tipo_id<15;


INSERT INTO artefatos_tipo (artefato_tipo_id, artefato_tipo_nome, artefato_tipo_civil, artefato_tipo_descricao, artefato_tipo_imagem, artefato_tipo_campos) VALUES 
  (15,'Documento de Oficializao de Demanda (DOD)','cnj','','',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
  (16,'Anlise de Viabilidade do Projeto (AVP)','cnj','','',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),
  (17,'Termo de Abertura do Projeto (TAP)','cnj','','',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),
  (18,'Embasamento do Projeto (EP)','cnj','','',0x613A393A7B733A353A2263616D706F223B613A31343A7B693A313B613A323A7B733A343A227469706F223B733A343A226C6F676F223B733A353A226461646F73223B733A31313A2270726F6A65746F5F636961223B7D693A323B613A323A7B733A343A227469706F223B733A393A226361626563616C686F223B733A353A226461646F73223B733A31313A2270726F6A65746F5F636961223B7D693A333B613A323A7B733A343A227469706F223B733A31343A226C697374615F657370656369616C223B733A353A226461646F73223B733A31343A2270726F6A65746F5F636F6469676F223B7D693A343B613A323A7B733A343A227469706F223B733A31333A22626C6F636F5F73696D706C6573223B733A353A226461646F73223B733A31323A2270726F6A65746F5F6E6F6D65223B7D693A353B613A323A7B733A343A227469706F223B733A31333A22626C6F636F5F73696D706C6573223B733A353A226461646F73223B733A33333A2270726F6A65746F5F656D626173616D656E746F5F6A757374696669636174697661223B7D693A363B613A323A7B733A343A227469706F223B733A31333A22626C6F636F5F73696D706C6573223B733A353A226461646F73223B733A32383A2270726F6A65746F5F656D626173616D656E746F5F6F626A657469766F223B7D693A373B613A323A7B733A343A227469706F223B733A31333A22626C6F636F5F73696D706C6573223B733A353A226461646F73223B733A32363A2270726F6A65746F5F656D626173616D656E746F5F6573636F706F223B7D693A383B613A323A7B733A343A227469706F223B733A31333A22626C6F636F5F73696D706C6573223B733A353A226461646F73223B733A33303A2270726F6A65746F5F656D626173616D656E746F5F6E616F5F6573636F706F223B7D693A393B613A323A7B733A343A227469706F223B733A31333A22626C6F636F5F73696D706C6573223B733A353A226461646F73223B733A32393A2270726F6A65746F5F656D626173616D656E746F5F7072656D6973736173223B7D693A31303B613A323A7B733A343A227469706F223B733A31333A22626C6F636F5F73696D706C6573223B733A353A226461646F73223B733A33303A2270726F6A65746F5F656D626173616D656E746F5F726573747269636F6573223B7D693A31313B613A323A7B733A343A227469706F223B733A31333A22626C6F636F5F73696D706C6573223B733A353A226461646F73223B733A32393A2270726F6A65746F5F656D626173616D656E746F5F6F7263616D656E746F223B7D693A31323B613A323A7B733A343A227469706F223B733A31323A226E6F6D655F7573756172696F223B733A353A226461646F73223B733A33313A2270726F6A65746F5F656D626173616D656E746F5F726573706F6E736176656C223B7D693A31333B613A323A7B733A343A227469706F223B733A31343A2266756E63616F5F7573756172696F223B733A353A226461646F73223B733A33313A2270726F6A65746F5F656D626173616D656E746F5F726573706F6E736176656C223B7D693A31343B613A323A7B733A343A227469706F223B733A343A2264617461223B733A353A226461646F73223B733A32343A2270726F6A65746F5F656D626173616D656E746F5F64617461223B7D7D733A31313A226D6F64656C6F5F7469706F223B733A313A2234223B733A363A2265646963616F223B623A303B733A393A22696D7072657373616F223B623A303B733A393A226D6F64656C6F5F6964223B693A303B733A393A2270617261677261666F223B693A303B733A31353A226D6F64656C6F5F6461646F735F6964223B693A303B733A363A226D6F64656C6F223B4E3B733A333A22716E74223B693A31343B7D),
  (19,'Plano de Qualidade (PQ)','cnj','','',0x613A393A7B733A353A2263616D706F223B613A393A7B693A313B613A323A7B733A343A227469706F223B733A343A226C6F676F223B733A353A226461646F73223B733A31313A2270726F6A65746F5F636961223B7D693A323B613A323A7B733A343A227469706F223B733A393A226361626563616C686F223B733A353A226461646F73223B733A31313A2270726F6A65746F5F636961223B7D693A333B613A323A7B733A343A227469706F223B733A31343A226C697374615F657370656369616C223B733A353A226461646F73223B733A31343A2270726F6A65746F5F636F6469676F223B7D693A343B613A323A7B733A343A227469706F223B733A31333A22626C6F636F5F73696D706C6573223B733A353A226461646F73223B733A31323A2270726F6A65746F5F6E6F6D65223B7D693A353B613A323A7B733A343A227469706F223B733A31333A22626C6F636F5F73696D706C6573223B733A353A226461646F73223B733A32373A2270726F6A65746F5F7175616C69646164655F64657363726963616F223B7D693A363B613A323A7B733A343A227469706F223B733A31343A226C697374615F657370656369616C223B733A353A226461646F73223B733A32353A2270726F6A65746F5F7175616C69646164655F656E7472656761223B7D693A373B613A323A7B733A343A227469706F223B733A31323A226E6F6D655F7573756172696F223B733A353A226461646F73223B733A32353A2270726F6A65746F5F7175616C69646164655F7573756172696F223B7D693A383B613A323A7B733A343A227469706F223B733A31343A2266756E63616F5F7573756172696F223B733A353A226461646F73223B733A32353A2270726F6A65746F5F7175616C69646164655F7573756172696F223B7D693A393B613A323A7B733A343A227469706F223B733A343A2264617461223B733A353A226461646F73223B733A32323A2270726F6A65746F5F7175616C69646164655F64617461223B7D7D733A31313A226D6F64656C6F5F7469706F223B733A313A2235223B733A363A2265646963616F223B623A303B733A393A22696D7072657373616F223B623A303B733A393A226D6F64656C6F5F6964223B693A303B733A393A2270617261677261666F223B693A303B733A31353A226D6F64656C6F5F6461646F735F6964223B693A303B733A363A226D6F64656C6F223B4E3B733A333A22716E74223B693A393B7D),
  (20,'Plano de Comunicao (PC)','cnj','','',0x613A393A7B733A353A2263616D706F223B613A393A7B693A313B613A323A7B733A343A227469706F223B733A343A226C6F676F223B733A353A226461646F73223B733A31313A2270726F6A65746F5F636961223B7D693A323B613A323A7B733A343A227469706F223B733A393A226361626563616C686F223B733A353A226461646F73223B733A31313A2270726F6A65746F5F636961223B7D693A333B613A323A7B733A343A227469706F223B733A31343A226C697374615F657370656369616C223B733A353A226461646F73223B733A31343A2270726F6A65746F5F636F6469676F223B7D693A343B613A323A7B733A343A227469706F223B733A31333A22626C6F636F5F73696D706C6573223B733A353A226461646F73223B733A31323A2270726F6A65746F5F6E6F6D65223B7D693A353B613A323A7B733A343A227469706F223B733A31333A22626C6F636F5F73696D706C6573223B733A353A226461646F73223B733A32393A2270726F6A65746F5F636F6D756E69636163616F5F64657363726963616F223B7D693A363B613A323A7B733A343A227469706F223B733A31343A226C697374615F657370656369616C223B733A353A226461646F73223B733A32363A2270726F6A65746F5F636F6D756E69636163616F5F6576656E746F223B7D693A373B613A323A7B733A343A227469706F223B733A31323A226E6F6D655F7573756172696F223B733A353A226461646F73223B733A32373A2270726F6A65746F5F636F6D756E69636163616F5F7573756172696F223B7D693A383B613A323A7B733A343A227469706F223B733A31343A2266756E63616F5F7573756172696F223B733A353A226461646F73223B733A32373A2270726F6A65746F5F636F6D756E69636163616F5F7573756172696F223B7D693A393B613A323A7B733A343A227469706F223B733A343A2264617461223B733A353A226461646F73223B733A32343A2270726F6A65746F5F636F6D756E69636163616F5F64617461223B7D7D733A31313A226D6F64656C6F5F7469706F223B733A313A2236223B733A363A2265646963616F223B623A303B733A393A22696D7072657373616F223B623A303B733A393A226D6F64656C6F5F6964223B693A303B733A393A2270617261677261666F223B693A303B733A31353A226D6F64656C6F5F6461646F735F6964223B693A303B733A363A226D6F64656C6F223B4E3B733A333A22716E74223B693A393B7D),
  (21,'Gerenciamento de Risco(GR)','cnj','','',0x613A393A7B733A353A2263616D706F223B613A393A7B693A313B613A323A7B733A343A227469706F223B733A343A226C6F676F223B733A353A226461646F73223B733A31313A2270726F6A65746F5F636961223B7D693A323B613A323A7B733A343A227469706F223B733A393A226361626563616C686F223B733A353A226461646F73223B733A31313A2270726F6A65746F5F636961223B7D693A333B613A323A7B733A343A227469706F223B733A31343A226C697374615F657370656369616C223B733A353A226461646F73223B733A31343A2270726F6A65746F5F636F6469676F223B7D693A343B613A323A7B733A343A227469706F223B733A31333A22626C6F636F5F73696D706C6573223B733A353A226461646F73223B733A31323A2270726F6A65746F5F6E6F6D65223B7D693A353B613A323A7B733A343A227469706F223B733A31333A22626C6F636F5F73696D706C6573223B733A353A226461646F73223B733A32333A2270726F6A65746F5F726973636F5F64657363726963616F223B7D693A363B613A323A7B733A343A227469706F223B733A31343A226C697374615F657370656369616C223B733A353A226461646F73223B733A31383A2270726F6A65746F5F726973636F5F7469706F223B7D693A373B613A323A7B733A343A227469706F223B733A31323A226E6F6D655F7573756172696F223B733A353A226461646F73223B733A32313A2270726F6A65746F5F726973636F5F7573756172696F223B7D693A383B613A323A7B733A343A227469706F223B733A31343A2266756E63616F5F7573756172696F223B733A353A226461646F73223B733A32313A2270726F6A65746F5F726973636F5F7573756172696F223B7D693A393B613A323A7B733A343A227469706F223B733A343A2264617461223B733A353A226461646F73223B733A31383A2270726F6A65746F5F726973636F5F64617461223B7D7D733A31313A226D6F64656C6F5F7469706F223B733A313A2237223B733A363A2265646963616F223B623A303B733A393A22696D7072657373616F223B623A303B733A393A226D6F64656C6F5F6964223B693A303B733A393A2270617261677261666F223B693A303B733A31353A226D6F64656C6F5F6461646F735F6964223B693A303B733A363A226D6F64656C6F223B4E3B733A333A22716E74223B693A393B7D),
  (22,'Plano de Gerenciamento do Projeto (PGP)','cnj','','',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),
  (23,'Lies Aprendidas (LA)','cnj','','',0x613A393A7B733A353A2263616D706F223B613A353A7B693A313B613A323A7B733A343A227469706F223B733A343A226C6F676F223B733A353A226461646F73223B733A31313A2270726F6A65746F5F636961223B7D693A323B613A323A7B733A343A227469706F223B733A393A226361626563616C686F223B733A353A226461646F73223B733A31313A2270726F6A65746F5F636961223B7D693A333B613A323A7B733A343A227469706F223B733A31343A226C697374615F657370656369616C223B733A353A226461646F73223B733A31343A2270726F6A65746F5F636F6469676F223B7D693A343B613A323A7B733A343A227469706F223B733A31333A22626C6F636F5F73696D706C6573223B733A353A226461646F73223B733A31323A2270726F6A65746F5F6E6F6D65223B7D693A353B613A323A7B733A343A227469706F223B733A31343A226C697374615F657370656369616C223B733A353A226461646F73223B733A353A226C6963616F223B7D7D733A31313A226D6F64656C6F5F7469706F223B733A313A2239223B733A363A2265646963616F223B623A303B733A393A22696D7072657373616F223B623A303B733A393A226D6F64656C6F5F6964223B693A303B733A393A2270617261677261666F223B693A303B733A31353A226D6F64656C6F5F6461646F735F6964223B693A303B733A363A226D6F64656C6F223B4E3B733A333A22716E74223B693A353B7D),
  (24,'Termo de Encerramento de Projeto (TEP)','cnj','','',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),
  (25,'Termo de Recebimento de Produto/Servio (TRPS)','cnj','','',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),
  (26,'Formulrio de Solicitao de Mudanas (FSM)','cnj','','',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),
  (27,'Ata de Reunio','cnj','','',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),
  (28,'Mensurao do Tamanho do Projeto (MTP)','cnj','','',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
  (29,'Matriz de Controle de Indicadores','cnj','','',0x613A393A7B733A353A2263616D706F223B613A353A7B693A313B613A323A7B733A343A227469706F223B733A343A226C6F676F223B733A353A226461646F73223B733A31313A2270726F6A65746F5F636961223B7D693A323B613A323A7B733A343A227469706F223B733A393A226361626563616C686F223B733A353A226461646F73223B733A31313A2270726F6A65746F5F636961223B7D693A333B613A323A7B733A343A227469706F223B733A31333A22626C6F636F5F73696D706C6573223B733A353A226461646F73223B733A31343A2270726F6A65746F5F636F6469676F223B7D693A343B613A323A7B733A343A227469706F223B733A31333A22626C6F636F5F73696D706C6573223B733A353A226461646F73223B733A31323A2270726F6A65746F5F6E6F6D65223B7D693A353B613A323A7B733A343A227469706F223B733A31343A226C697374615F657370656369616C223B733A353A226461646F73223B733A32353A2270726F6A65746F5F6C697374615F696E64696361646F726573223B7D7D733A31313A226D6F64656C6F5F7469706F223B733A323A223239223B733A363A2265646963616F223B623A303B733A393A22696D7072657373616F223B623A303B733A393A226D6F64656C6F5F6964223B693A303B733A393A2270617261677261666F223B693A303B733A31353A226D6F64656C6F5F6461646F735F6964223B693A303B733A363A226D6F64656C6F223B4E3B733A333A22716E74223B693A353B7D),
	(30,'Matriz de Controle de Indicadores','mpog','','',0x613A393A7B733A353A2263616D706F223B613A353A7B693A313B613A323A7B733A343A227469706F223B733A343A226C6F676F223B733A353A226461646F73223B733A31313A2270726F6A65746F5F636961223B7D693A323B613A323A7B733A343A227469706F223B733A393A226361626563616C686F223B733A353A226461646F73223B733A31313A2270726F6A65746F5F636961223B7D693A333B613A323A7B733A343A227469706F223B733A31333A22626C6F636F5F73696D706C6573223B733A353A226461646F73223B733A31343A2270726F6A65746F5F636F6469676F223B7D693A343B613A323A7B733A343A227469706F223B733A31333A22626C6F636F5F73696D706C6573223B733A353A226461646F73223B733A31323A2270726F6A65746F5F6E6F6D65223B7D693A353B613A323A7B733A343A227469706F223B733A31343A226C697374615F657370656369616C223B733A353A226461646F73223B733A32353A2270726F6A65746F5F6C697374615F696E64696361646F726573223B7D7D733A31313A226D6F64656C6F5F7469706F223B733A323A223239223B733A363A2265646963616F223B623A303B733A393A22696D7072657373616F223B623A303B733A393A226D6F64656C6F5F6964223B693A303B733A393A2270617261677261666F223B693A303B733A31353A226D6F64656C6F5F6461646F735F6964223B693A303B733A363A226D6F64656C6F223B4E3B733A333A22716E74223B693A353B7D);

