SET FOREIGN_KEY_CHECKS=0;

DROP TABLE IF EXISTS agrupamento;

CREATE TABLE agrupamento (
  agrupamento_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  agrupamento_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  agrupamento_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  agrupamento_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  agrupamento_nome TEXT,
	agrupamento_descricao MEDIUMTEXT,
	agrupamento_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
  agrupamento_cor VARCHAR(6) DEFAULT 'FFFFFF',
  agrupamento_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  agrupamento_ativo TINYINT(1) DEFAULT 1,
  agrupamento_aprovado TINYINT(1) DEFAULT 0,
  PRIMARY KEY (agrupamento_id),
  KEY agrupamento_cia (agrupamento_cia),
  KEY agrupamento_dept (agrupamento_dept),
  KEY agrupamento_usuario (agrupamento_usuario),
  KEY agrupamento_moeda (agrupamento_moeda),
	CONSTRAINT agrupamento_moeda FOREIGN KEY (agrupamento_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE, 
  CONSTRAINT agrupamento_cia FOREIGN KEY (agrupamento_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT agrupamento_dept FOREIGN KEY (agrupamento_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT agrupamento_usuario FOREIGN KEY (agrupamento_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB;

DROP TABLE IF EXISTS swot;

CREATE TABLE swot (
  swot_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  swot_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  swot_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  swot_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  swot_principal_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  swot_nome TEXT,
  swot_prazo DATE DEFAULT NULL,
  swot_inicio DATE DEFAULT NULL,
  swot_fim DATE DEFAULT NULL,
  swot_percentagem DECIMAL(20,5) UNSIGNED DEFAULT 0,
  swot_oque TEXT,
  swot_descricao MEDIUMTEXT,
  swot_onde TEXT,
  swot_quando TEXT,
  swot_como TEXT,
  swot_porque TEXT,
  swot_quanto TEXT,
  swot_quem TEXT,
  swot_controle TEXT,
  swot_melhorias TEXT,
  swot_metodo_aprendizado TEXT,
  swot_desde_quando TEXT,
  swot_g INTEGER(10) UNSIGNED DEFAULT 1,
  swot_u INTEGER(10) UNSIGNED DEFAULT 1,
  swot_t INTEGER(10) UNSIGNED DEFAULT 1,
  swot_pontuacao INTEGER(10) UNSIGNED DEFAULT 1,
  swot_tipo VARCHAR(1) DEFAULT NULL,
  swot_cor VARCHAR(6) DEFAULT 'FFFFFF',
  swot_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  swot_ativo TINYINT(1) DEFAULT 1,
  swot_aprovado TINYINT(1) DEFAULT 0,
  swot_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
  PRIMARY KEY (swot_id),
  KEY swot_cia (swot_cia),
  KEY swot_dept (swot_dept),
  KEY swot_responsavel (swot_responsavel),
 	KEY swot_principal_indicador (swot_principal_indicador),
 	KEY swot_moeda (swot_moeda),
  CONSTRAINT swot_cia FOREIGN KEY (swot_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT swot_dept FOREIGN KEY (swot_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT swot_responsavel FOREIGN KEY (swot_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT swot_principal_indicador FOREIGN KEY (swot_principal_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT swot_moeda FOREIGN KEY (swot_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS operativo;

CREATE TABLE operativo (
  operativo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  operativo_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  operativo_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  operativo_previsao DATE DEFAULT NULL,
  operativo_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  operativo_atualizacao DATETIME DEFAULT NULL,
  operativo_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
  operativo_tema INTEGER(100) UNSIGNED DEFAULT NULL,
  operativo_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
  operativo_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  operativo_projeto_principal INTEGER(100) UNSIGNED DEFAULT NULL,
  operativo_nome TEXT,
  operativo_descricao MEDIUMTEXT,
  operativo_convenio VARCHAR(200) DEFAULT NULL,
  operativo_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
  operativo_cor VARCHAR(6) DEFAULT 'FFFFFF',
  operativo_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  operativo_ativo TINYINT(1) DEFAULT 1,
  operativo_aprovado TINYINT(1) DEFAULT 0,
  PRIMARY KEY (operativo_id),
  KEY operativo_cia (operativo_cia),
  KEY operativo_dept (operativo_dept),
  KEY operativo_usuario (operativo_usuario),
  KEY operativo_perspectiva (operativo_perspectiva),
  KEY operativo_tema (operativo_tema),
  KEY operativo_objetivo (operativo_objetivo),
  KEY operativo_projeto (operativo_projeto),
  KEY operativo_projeto_principal (operativo_projeto_principal),
  KEY operativo_moeda (operativo_moeda),
  CONSTRAINT operativo_cia FOREIGN KEY (operativo_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT operativo_dept FOREIGN KEY (operativo_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT operativo_usuario FOREIGN KEY (operativo_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT operativo_perspectiva FOREIGN KEY (operativo_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT operativo_tema FOREIGN KEY (operativo_tema) REFERENCES tema (tema_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT operativo_objetivo FOREIGN KEY (operativo_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT operativo_projeto FOREIGN KEY (operativo_projeto) REFERENCES projetos (projeto_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT operativo_projeto_principal FOREIGN KEY (operativo_projeto_principal) REFERENCES projetos (projeto_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT operativo_moeda FOREIGN KEY (operativo_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB;

DROP TABLE IF EXISTS problema;

CREATE TABLE problema (
  problema_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  problema_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  problema_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  problema_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  problema_principal_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  problema_nome TEXT,
  problema_descricao MEDIUMTEXT,
  problema_percentagem DECIMAL(20,5) UNSIGNED DEFAULT 0,
  problema_inicio DATETIME DEFAULT NULL,
  problema_fim DATETIME DEFAULT NULL,
  problema_duracao DECIMAL(20,5) UNSIGNED DEFAULT NULL,
  problema_solucao MEDIUMTEXT,
  problema_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
  problema_cor VARCHAR(6) DEFAULT 'ffffff',
  problema_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  problema_ativo TINYINT(1) DEFAULT 1,
  problema_aprovado TINYINT(1) DEFAULT 0,
  problema_status INTEGER(10) DEFAULT 0,
  PRIMARY KEY (problema_id),
  KEY problema_cia (problema_cia),
  KEY problema_dept (problema_dept),
  KEY problema_responsavel (problema_responsavel),
  KEY problema_principal_indicador (problema_principal_indicador),
  KEY problema_moeda (problema_moeda),
	CONSTRAINT problema_cia FOREIGN KEY (problema_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_dept FOREIGN KEY (problema_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT problema_responsavel FOREIGN KEY (problema_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT problema_principal_indicador FOREIGN KEY (problema_principal_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT problema_moeda FOREIGN KEY (problema_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE 
)ENGINE=InnoDB;

DROP TABLE IF EXISTS programa;

CREATE TABLE programa (
  programa_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  programa_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  programa_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  programa_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  programa_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  programa_nome TEXT,
  programa_data DATETIME DEFAULT NULL,
  programa_inicio DATETIME DEFAULT NULL,
	programa_fim DATETIME DEFAULT NULL,
	programa_duracao DECIMAL(20,5) UNSIGNED DEFAULT 0,
  programa_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  programa_descricao MEDIUMTEXT,
  programa_percentagem DECIMAL(20,5) UNSIGNED DEFAULT 0,
  programa_meta DECIMAL(20,5) UNSIGNED DEFAULT 0,
  programa_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
  programa_cor VARCHAR(6) DEFAULT 'FFFFFF',
	programa_ativo TINYINT(1) DEFAULT 1,
	programa_aprovado TINYINT(1) DEFAULT 0,
  PRIMARY KEY (programa_id),
  KEY programa_cia (programa_cia),
  KEY programa_dept (programa_dept),
  KEY programa_usuario (programa_usuario),
  KEY programa_indicador (programa_indicador),
  KEY programa_moeda (programa_moeda),
  CONSTRAINT programa_cia FOREIGN KEY (programa_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT programa_usuario FOREIGN KEY (programa_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT programa_indicador FOREIGN KEY (programa_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT programa_dept FOREIGN KEY (programa_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT programa_moeda FOREIGN KEY (programa_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS tgn;

CREATE TABLE tgn (
  tgn_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  tgn_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  tgn_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  tgn_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  tgn_principal_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  tgn_nome TEXT,
  tgn_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  tgn_cor VARCHAR(6) DEFAULT 'FFFFFF',
  tgn_descricao MEDIUMTEXT,
  tgn_ativo TINYINT(1) DEFAULT 1,
  tgn_categoria VARCHAR(50) DEFAULT NULL,
  tgn_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
  tgn_aprovado TINYINT(1) DEFAULT 0,
  PRIMARY KEY (tgn_id),
  KEY tgn_cia (tgn_cia),
  KEY tgn_dept (tgn_dept),
  KEY tgn_usuario (tgn_usuario),
  KEY tgn_principal_indicador (tgn_principal_indicador),
  KEY tgn_moeda (tgn_moeda),
  CONSTRAINT tgn_cia FOREIGN KEY (tgn_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tgn_usuario FOREIGN KEY (tgn_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT tgn_dept FOREIGN KEY (tgn_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT tgn_principal_indicador FOREIGN KEY (tgn_principal_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT tgn_moeda FOREIGN KEY (tgn_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS risco;

CREATE TABLE risco (
  risco_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  risco_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  risco_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  risco_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  risco_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  risco_nome TEXT,
  risco_probabilidade1 INTEGER(10) UNSIGNED DEFAULT NULL,
  risco_impacto1 INTEGER(10) UNSIGNED DEFAULT NULL,
  risco_gravidade1 INTEGER(10) UNSIGNED DEFAULT NULL,
  risco_urgencia1 INTEGER(10) UNSIGNED DEFAULT NULL,
  risco_tendencia1 INTEGER(10) UNSIGNED DEFAULT NULL,
 	risco_probabilidade2 INTEGER(10) UNSIGNED DEFAULT NULL,
  risco_impacto2 INTEGER(10) UNSIGNED DEFAULT NULL,
  risco_gravidade2 INTEGER(10) UNSIGNED DEFAULT NULL,
  risco_urgencia2 INTEGER(10) UNSIGNED DEFAULT NULL,
  risco_tendencia2 INTEGER(10) UNSIGNED DEFAULT NULL,
  risco_iniciativa VARCHAR(20) DEFAULT NULL,
  risco_gatilho MEDIUMTEXT,
  risco_acao_proposta MEDIUMTEXT,
  risco_data DATETIME DEFAULT NULL,
  risco_inicio DATETIME DEFAULT NULL,
	risco_fim DATETIME DEFAULT NULL,
	risco_duracao DECIMAL(20,5) UNSIGNED DEFAULT 0,
  risco_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  risco_cor VARCHAR(6) DEFAULT 'FFFFFF',
  risco_descricao MEDIUMTEXT,
  risco_categoria VARCHAR(50) DEFAULT NULL,
  risco_percentagem DECIMAL(20,5) UNSIGNED DEFAULT 0,
  risco_tipo_pontuacao VARCHAR(40) DEFAULT NULL,
  risco_ponto_alvo DECIMAL(20,5) UNSIGNED DEFAULT 0,
  risco_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
  risco_positivo TINYINT(1) DEFAULT 0,
  risco_ativo TINYINT(1) DEFAULT 1,
  risco_aprovado TINYINT(1) DEFAULT 0,
  PRIMARY KEY (risco_id),
  KEY risco_cia (risco_cia),
  KEY risco_dept (risco_dept),
  KEY risco_usuario (risco_usuario),
  KEY risco_indicador (risco_indicador),
  KEY risco_moeda (risco_moeda),
  CONSTRAINT risco_fk FOREIGN KEY (risco_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT risco_fk2 FOREIGN KEY (risco_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT risco_fk3 FOREIGN KEY (risco_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT risco_dept FOREIGN KEY (risco_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT risco_moeda FOREIGN KEY (risco_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE 
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS risco_resposta;

CREATE TABLE risco_resposta (
  risco_resposta_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  risco_resposta_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  risco_resposta_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  risco_resposta_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  risco_resposta_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  risco_resposta_nome TEXT,
  risco_resposta_acao_proposta MEDIUMTEXT,
  risco_resposta_data DATETIME DEFAULT NULL,
  risco_resposta_inicio DATETIME DEFAULT NULL,
	risco_resposta_fim DATETIME DEFAULT NULL,
	risco_resposta_duracao DECIMAL(20,5) UNSIGNED DEFAULT 0,
  risco_resposta_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  risco_resposta_cor VARCHAR(6) DEFAULT 'FFFFFF',
  risco_resposta_descricao MEDIUMTEXT,
  risco_resposta_categoria VARCHAR(50) DEFAULT NULL,
  risco_resposta_percentagem DECIMAL(20,5) UNSIGNED DEFAULT 0,
  risco_resposta_tipo_pontuacao VARCHAR(40) DEFAULT NULL,
	risco_resposta_ponto_alvo DECIMAL(20,5) UNSIGNED DEFAULT 0,
	risco_resposta_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
	risco_resposta_ativo TINYINT(1) DEFAULT 1,
	risco_resposta_aprovado TINYINT(1) DEFAULT 0,
  PRIMARY KEY (risco_resposta_id),
  KEY risco_resposta_cia (risco_resposta_cia),
  KEY risco_resposta_dept (risco_resposta_dept),
  KEY risco_resposta_usuario (risco_resposta_usuario),
  KEY risco_resposta_indicador (risco_resposta_indicador),
  KEY risco_resposta_moeda (risco_resposta_moeda),
  CONSTRAINT risco_resposta_cia FOREIGN KEY (risco_resposta_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT risco_resposta_usuario FOREIGN KEY (risco_resposta_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT risco_resposta_indicador FOREIGN KEY (risco_resposta_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT risco_resposta_dept FOREIGN KEY (risco_resposta_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT risco_resposta_moeda FOREIGN KEY (risco_resposta_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE 
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS monitoramento;

CREATE TABLE monitoramento (
  monitoramento_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  monitoramento_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  monitoramento_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  monitoramento_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  monitoramento_principal_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  monitoramento_nome TEXT,
  monitoramento_data DATETIME DEFAULT NULL,
  monitoramento_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  monitoramento_cor VARCHAR(6) DEFAULT 'FFFFFF',
  monitoramento_oque TEXT,
  monitoramento_descricao MEDIUMTEXT,
  monitoramento_onde TEXT,
  monitoramento_quando TEXT,
  monitoramento_como TEXT,
  monitoramento_porque TEXT,
  monitoramento_quanto TEXT,
  monitoramento_quem TEXT,
  monitoramento_controle TEXT,
  monitoramento_melhorias TEXT,
  monitoramento_metodo_aprendizado TEXT,
  monitoramento_desde_quando TEXT,
  monitoramento_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
  monitoramento_ativo TINYINT(1) DEFAULT 1,
  monitoramento_aprovado TINYINT(1) DEFAULT 0,
  PRIMARY KEY (monitoramento_id),
  KEY monitoramento_cia (monitoramento_cia),
  KEY monitoramento_usuario (monitoramento_usuario),
  KEY monitoramento_principal_indicador (monitoramento_principal_indicador),
  KEY monitoramento_moeda (monitoramento_moeda),
  CONSTRAINT monitoramento_cia FOREIGN KEY (monitoramento_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT monitoramento_dept FOREIGN KEY (monitoramento_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT monitoramento_usuario FOREIGN KEY (monitoramento_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT monitoramento_principal_indicador FOREIGN KEY (monitoramento_principal_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT monitoramento_moeda FOREIGN KEY (monitoramento_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS painel_odometro;

CREATE TABLE painel_odometro (
  painel_odometro_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  painel_odometro_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  painel_odometro_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  painel_odometro_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_nome TEXT,
	painel_odometro_descricao MEDIUMTEXT,
  painel_odometro_titulo VARCHAR(255) DEFAULT NULL,
  painel_odometro_subtitulo VARCHAR(255) DEFAULT NULL,
  painel_odometro_url VARCHAR(255) DEFAULT NULL,
  painel_odometro_link_tipo VARCHAR(30) DEFAULT NULL,
	painel_odometro_link_chave INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_odometro_link_chave2 INTEGER(100) UNSIGNED DEFAULT NULL,
  painel_odometro_texto_painel VARCHAR(18) DEFAULT NULL,
  painel_odometro_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  painel_odometro_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  painel_odometro_cor VARCHAR(6)  DEFAULT 'FFFFFF',
  painel_odometro_tipo VARCHAR(20) DEFAULT 'odometro',
 	painel_odometro_angulo_inicial INTEGER(10) DEFAULT -150,
 	painel_odometro_angulo_final INTEGER(10) DEFAULT 150,
 	painel_odometro_pontuacao TINYINT(1) DEFAULT 0,
 	painel_odometro_ponto0 DECIMAL(20,5) DEFAULT 0,
 	painel_odometro_ponto1 DECIMAL(20,5) DEFAULT 50,
 	painel_odometro_ponto2 DECIMAL(20,5) DEFAULT 80,
 	painel_odometro_ponto3 DECIMAL(20,5) DEFAULT 100,
 	painel_odometro_gradiente0 DECIMAL(20,5) DEFAULT 0.1,
 	painel_odometro_gradiente1 DECIMAL(20,5) DEFAULT 0.5,
 	painel_odometro_gradiente2 DECIMAL(20,5) DEFAULT 0.9,
 	painel_odometro_data_final DATE DEFAULT NULL,
 	painel_odometro_final_hoje TINYINT(1) DEFAULT 0,
	painel_odometro_largura INTEGER(10) UNSIGNED DEFAULT 400,
	painel_odometro_altura INTEGER(10) UNSIGNED DEFAULT 400,
	painel_odometro_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
	painel_odometro_ativo TINYINT(1) DEFAULT 1,
	painel_odometro_aprovado TINYINT(1) DEFAULT 0,
  PRIMARY KEY (painel_odometro_id),
  KEY painel_odometro_cia (painel_odometro_cia),
 	KEY painel_odometro_dept (painel_odometro_dept),
	KEY painel_odometro_moeda (painel_odometro_moeda),
  CONSTRAINT painel_odometro_cia FOREIGN KEY (painel_odometro_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT painel_odometro_indicador FOREIGN KEY (painel_odometro_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
 	CONSTRAINT painel_odometro_dept FOREIGN KEY (painel_odometro_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT painel_odometro_moeda FOREIGN KEY (painel_odometro_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS painel;

CREATE TABLE painel (
  painel_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  painel_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  painel_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  painel_nome TEXT,
  painel_titulo VARCHAR(255) DEFAULT NULL,
  painel_subtitulo VARCHAR(255) DEFAULT NULL,
  painel_link_tipo VARCHAR(30) DEFAULT NULL,
	painel_link_chave INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_link_chave2 INTEGER(100) UNSIGNED DEFAULT NULL,
  painel_url VARCHAR(255) DEFAULT NULL,
  painel_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  painel_descricao MEDIUMTEXT,
  painel_cor VARCHAR(6)  DEFAULT 'FFFFFF',
  painel_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  painel_suavizar TINYINT(1) DEFAULT 0,
  painel_multiplo_y TINYINT(1) DEFAULT 0,
  painel_legenda_y VARCHAR(50) DEFAULT NULL,
  painel_max_zoom INTEGER(100) UNSIGNED DEFAULT 0,
  painel_nr_pontos INTEGER(100) UNSIGNED DEFAULT 10,
	painel_agrupar VARCHAR(20)  DEFAULT 'ano',
	painel_data_final DATE DEFAULT NULL,
	painel_final_hoje TINYINT(1) DEFAULT 0,
	painel_angulo_legenda_x INTEGER(10) DEFAULT 0,
	painel_largura INTEGER(10) UNSIGNED DEFAULT 400,
	painel_altura INTEGER(10) UNSIGNED DEFAULT 400,
	painel_legenda_largura INTEGER(10) DEFAULT NULL,
	painel_legenda TINYINT(1) DEFAULT 1,
	painel_legenday TINYINT(1) DEFAULT 0,
	painel_valor_ponto TINYINT(1) DEFAULT 0,
	painel_valor_sobreposicao TINYINT(1) DEFAULT 0,
	painel_valor_rotacao SMALLINT DEFAULT 0,
	painel_valor_alinhamento VARCHAR(6) DEFAULT 'center',
	painel_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
	painel_ativo TINYINT(1) DEFAULT 1,
	painel_aprovado TINYINT(1) DEFAULT 0,
  PRIMARY KEY (painel_id),
  KEY painel_cia (painel_cia),
  KEY painel_dept (painel_dept),
  KEY painel_moeda (painel_moeda),
  CONSTRAINT painel_cia FOREIGN KEY (painel_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT painel_dept FOREIGN KEY (painel_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT painel_moeda FOREIGN KEY (painel_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS painel_slideshow;

CREATE TABLE painel_slideshow (
  painel_slideshow_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  painel_slideshow_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  painel_slideshow_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  painel_slideshow_nome TEXT,
  painel_slideshow_descricao MEDIUMTEXT,
  painel_slideshow_tempo INTEGER(10) UNSIGNED DEFAULT 15,
  painel_slideshow_refresh INTEGER(10) UNSIGNED DEFAULT 0,
  painel_slideshow_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  painel_slideshow_cor VARCHAR(6)  DEFAULT 'FFFFFF',
  painel_slideshow_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  painel_slideshow_ativo TINYINT(1) DEFAULT 1,
  painel_slideshow_moeda INTEGER(100) UNSIGNED DEFAULT 1,
  painel_slideshow_aprovado TINYINT(1) DEFAULT 0,
  PRIMARY KEY (painel_slideshow_id),
  KEY painel_slideshow_cia (painel_slideshow_cia),
  KEY painel_slideshow_dept (painel_slideshow_dept),
  KEY painel_slideshow_moeda (painel_slideshow_moeda),
  CONSTRAINT painel_slideshow_cia FOREIGN KEY (painel_slideshow_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT painel_slideshow_dept FOREIGN KEY (painel_slideshow_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT painel_slideshow_moeda FOREIGN KEY (painel_slideshow_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS painel_composicao;

CREATE TABLE painel_composicao (
  painel_composicao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  painel_composicao_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  painel_composicao_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  painel_composicao_nome TEXT,
  painel_composicao_titulo VARCHAR(255) DEFAULT NULL,
  painel_composicao_subtitulo VARCHAR(255) DEFAULT NULL,
  painel_composicao_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  painel_composicao_url VARCHAR(255) DEFAULT NULL,
  painel_composicao_link_tipo VARCHAR(30) DEFAULT NULL,
	painel_composicao_link_chave INTEGER(100) UNSIGNED DEFAULT NULL,
	painel_composicao_link_chave2 INTEGER(100) UNSIGNED DEFAULT NULL,
  painel_composicao_descricao MEDIUMTEXT,
  painel_composicao_cor VARCHAR(6)  DEFAULT 'FFFFFF',
  painel_composicao_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  painel_composicao_colunas INTEGER(100) UNSIGNED DEFAULT 3,
 	painel_composicao_largura INTEGER(10) UNSIGNED DEFAULT NULL,
	painel_composicao_altura INTEGER(10) UNSIGNED DEFAULT NULL,
	painel_composicao_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
	painel_composicao_ativo TINYINT(1) DEFAULT 1,
	painel_composicao_aprovado TINYINT(1) DEFAULT 0,
  PRIMARY KEY (painel_composicao_id),
  KEY painel_composicao_cia (painel_composicao_cia),
  KEY painel_composicao_dept (painel_composicao_dept),
  KEY painel_composicao_moeda (painel_composicao_moeda),
  CONSTRAINT painel_composicao_cia FOREIGN KEY (painel_composicao_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT painel_composicao_dept FOREIGN KEY (painel_composicao_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT painel_composicao_moeda FOREIGN KEY (painel_composicao_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS relatorio_favorito;

CREATE TABLE relatorio_favorito (
  relatorio_favorito_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  relatorio_favorito_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  relatorio_favorito_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  relatorio_favorito_tipo VARCHAR(50) DEFAULT NULL,
  relatorio_favorito_nome VARCHAR(255) DEFAULT NULL,
  relatorio_favorito_campos MEDIUMTEXT,
  relatorio_favorito_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (relatorio_favorito_id),
  KEY relatorio_favorito_cia (relatorio_favorito_cia),
  KEY relatorio_favorito_usuario (relatorio_favorito_usuario),
  CONSTRAINT relatorio_favorito_usuario FOREIGN KEY (relatorio_favorito_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT relatorio_favorito_cia FOREIGN KEY (relatorio_favorito_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS custo;

CREATE TABLE custo (
  custo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  custo_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  custo_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  custo_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
  custo_acao INTEGER(100) UNSIGNED DEFAULT NULL,
  custo_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
  custo_tema INTEGER(100) UNSIGNED DEFAULT NULL,
  custo_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
  custo_fator INTEGER(100) UNSIGNED DEFAULT NULL,
  custo_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
  custo_meta INTEGER(100) UNSIGNED DEFAULT NULL,
  custo_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  custo_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
  custo_log INTEGER(100) UNSIGNED DEFAULT NULL,
  custo_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  custo_nome TEXT,
  custo_codigo VARCHAR(255) DEFAULT NULL,
  custo_fonte VARCHAR(255) DEFAULT NULL,
  custo_regiao VARCHAR(255) DEFAULT NULL,
  custo_tipo INTEGER(100) UNSIGNED DEFAULT 1,
  custo_data DATETIME DEFAULT NULL,
  custo_quantidade DECIMAL(20,5) UNSIGNED DEFAULT 0,
  custo_custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
  custo_bdi DECIMAL(20,5) UNSIGNED DEFAULT 0,
  custo_moeda INTEGER(100) UNSIGNED DEFAULT 1,  
	custo_cotacao DECIMAL(6,5) UNSIGNED DEFAULT 1, 
	custo_data_moeda DATE DEFAULT NULL, 
  custo_percentagem TINYINT(4) DEFAULT 0,
  custo_descricao MEDIUMTEXT,
  custo_nd VARCHAR(11) DEFAULT NULL,
  custo_categoria_economica VARCHAR(1) DEFAULT NULL,
  custo_grupo_despesa VARCHAR(1) DEFAULT NULL,
  custo_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  custo_data_recebido DATE DEFAULT NULL,
  custo_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
  custo_empenhado DECIMAL(20,5) UNSIGNED DEFAULT 0,
	custo_entregue DECIMAL(20,5) UNSIGNED DEFAULT 0,
	custo_liquidado DECIMAL(20,5) UNSIGNED DEFAULT 0,
	custo_pago DECIMAL(20,5) UNSIGNED DEFAULT 0,
	custo_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
	custo_data_limite DATE DEFAULT NULL,
	custo_pi VARCHAR(100) DEFAULT NULL,
	custo_ptres VARCHAR(100) DEFAULT NULL,
	custo_aprovou INTEGER(100) UNSIGNED DEFAULT NULL,
	custo_aprovado TINYINT(1) DEFAULT NULL,
	custo_data_aprovado DATETIME DEFAULT NULL,
	custo_gasto TINYINT(1) DEFAULT 0,
	custo_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	custo_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (custo_id),
  KEY custo_projeto (custo_projeto),
  KEY custo_tarefa (custo_tarefa),
  KEY custo_pratica (custo_pratica),
  KEY custo_acao (custo_acao),
  KEY custo_perspectiva (custo_perspectiva),
  KEY custo_tema (custo_tema),
  KEY custo_objetivo (custo_objetivo),
  KEY custo_fator (custo_fator),
  KEY custo_estrategia (custo_estrategia),
  KEY custo_meta (custo_meta),
 	KEY custo_indicador (custo_indicador),
  KEY custo_canvas (custo_canvas),
  KEY custo_log (custo_log),
  KEY custo_usuario (custo_usuario),
  KEY custo_ordem (custo_ordem),
  KEY custo_data (custo_data),
  KEY custo_aprovou (custo_aprovou),
  KEY custo_moeda (custo_moeda),
  CONSTRAINT custo_usuario FOREIGN KEY (custo_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT custo_log FOREIGN KEY (custo_log) REFERENCES log (log_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT custo_estrategia FOREIGN KEY (custo_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT custo_meta FOREIGN KEY (custo_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT custo_tema FOREIGN KEY (custo_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT custo_perspectiva FOREIGN KEY (custo_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT custo_projeto FOREIGN KEY (custo_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT custo_tarefa FOREIGN KEY (custo_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT custo_pratica FOREIGN KEY (custo_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT custo_acao FOREIGN KEY (custo_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT custo_indicador FOREIGN KEY (custo_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT custo_objetivo FOREIGN KEY (custo_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT custo_fator FOREIGN KEY (custo_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT custo_aprovou FOREIGN KEY (custo_aprovou) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT custo_moeda FOREIGN KEY (custo_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;




DROP TABLE IF EXISTS brainstorm;

CREATE TABLE brainstorm (
  brainstorm_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  brainstorm_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  brainstorm_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  brainstorm_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  brainstorm_principal_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  brainstorm_nome TEXT,
  brainstorm_descricao MEDIUMTEXT,
  brainstorm_objeto TEXT,
  brainstorm_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  brainstorm_datahora DATETIME DEFAULT NULL,
  brainstorm_data DATE DEFAULT NULL,
  brainstorm_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
  brainstorm_cor VARCHAR(6) DEFAULT 'FFFFFF',
  brainstorm_ativo TINYINT(1) DEFAULT 1,
  brainstorm_aprovado TINYINT(1) DEFAULT 0,
  PRIMARY KEY (brainstorm_id),
  KEY brainstorm_cia (brainstorm_cia),
  KEY brainstorm_dept (brainstorm_dept),
  KEY brainstorm_responsavel (brainstorm_responsavel),
  KEY brainstorm_principal_indicador (brainstorm_principal_indicador),
  KEY brainstorm_moeda (brainstorm_moeda),
  CONSTRAINT brainstorm_cia FOREIGN KEY (brainstorm_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT brainstorm_responsavel FOREIGN KEY (brainstorm_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT brainstorm_dept FOREIGN KEY (brainstorm_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT brainstorm_principal_indicador FOREIGN KEY (brainstorm_principal_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT brainstorm_moeda FOREIGN KEY (brainstorm_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;




DROP TABLE IF EXISTS canvas;

CREATE TABLE canvas (
  canvas_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  canvas_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  canvas_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  canvas_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  canvas_principal_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  canvas_nome TEXT,
  canvas_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  canvas_descricao MEDIUMTEXT,
	canvas_oque MEDIUMTEXT,
	canvas_onde MEDIUMTEXT,
	canvas_quando MEDIUMTEXT,
	canvas_como MEDIUMTEXT,
	canvas_porque MEDIUMTEXT,
	canvas_quanto MEDIUMTEXT,
	canvas_quem MEDIUMTEXT,
  canvas_categoria VARCHAR(50) DEFAULT NULL,
  canvas_anonimo TINYINT(1) DEFAULT 1,
  canvas_limite_texto INTEGER(100) UNSIGNED DEFAULT NULL,
  canvas_moeda INTEGER(100) UNSIGNED DEFAULT 1,
  canvas_cor VARCHAR(6) DEFAULT 'FFFFFF',
  canvas_ativo TINYINT(1) DEFAULT 1,
  canvas_aprovado TINYINT(1) DEFAULT 0,
  PRIMARY KEY (canvas_id),
  KEY canvas_cia (canvas_cia),
  KEY canvas_dept (canvas_dept),
  KEY canvas_usuario (canvas_usuario),
  KEY canvas_principal_indicador (canvas_principal_indicador),
  KEY canvas_moeda (canvas_moeda),
  CONSTRAINT canvas_cia FOREIGN KEY (canvas_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT canvas_usuario FOREIGN KEY (canvas_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT canvas_dept FOREIGN KEY (canvas_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT canvas_principal_indicador FOREIGN KEY (canvas_principal_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT canvas_moeda FOREIGN KEY (canvas_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS canvas_dept;

CREATE TABLE canvas_dept (
  canvas_dept_canvas INTEGER(100) UNSIGNED NOT NULL,
  canvas_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (canvas_dept_canvas, canvas_dept_dept),
  KEY canvas_dept_canvas (canvas_dept_canvas),
  KEY canvas_dept_dept (canvas_dept_dept),
  CONSTRAINT canvas_dept_dept FOREIGN KEY (canvas_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT canvas_dept_canvas FOREIGN KEY (canvas_dept_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS projeto_cia;

CREATE TABLE projeto_cia (
  projeto_cia_projeto INTEGER(100) UNSIGNED NOT NULL,
  projeto_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (projeto_cia_projeto, projeto_cia_cia),
  KEY projeto_cia_projeto (projeto_cia_projeto),
  KEY projeto_cia_cia (projeto_cia_cia),
  CONSTRAINT projeto_cia_cia FOREIGN KEY (projeto_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_cia_projeto FOREIGN KEY (projeto_cia_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_projeto_cia;

CREATE TABLE baseline_projeto_cia (
  baseline_id INTEGER(100) UNSIGNED NOT NULL,
  projeto_cia_projeto INTEGER(100) UNSIGNED NOT NULL,
  projeto_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (baseline_id, projeto_cia_projeto, projeto_cia_cia),
  CONSTRAINT baseline_projeto_cia_fk FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS registro;
CREATE TABLE registro (
  registro_id INTEGER(100) NOT NULL AUTO_INCREMENT,
  registro_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  registro_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  registro_m VARCHAR(30) DEFAULT NULL,
  registro_a VARCHAR(50) DEFAULT NULL,
  registro_u VARCHAR(30) DEFAULT NULL,
  registro_acao VARCHAR(10) DEFAULT NULL,
  registro_sql MEDIUMTEXT,
  registro_data DATETIME DEFAULT NULL,
  registro_ip VARCHAR(255) DEFAULT NULL,
  PRIMARY KEY (registro_id)
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS artefato_campo;

CREATE TABLE artefato_campo (
  artefato_campo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  artefato_campo_arquivo VARCHAR(255) DEFAULT NULL,
  artefato_campo_campo VARCHAR(255) DEFAULT NULL,
  artefato_campo_descricao VARCHAR(255) DEFAULT NULL,
  PRIMARY KEY (artefato_campo_id)
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS jornada;

CREATE TABLE jornada (
  jornada_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  jornada_nome VARCHAR(255) DEFAULT NULL,
  jornada_1_inicio TIME DEFAULT NULL,
  jornada_1_almoco_inicio TIME DEFAULT NULL,
  jornada_1_almoco_fim TIME DEFAULT NULL,
  jornada_1_fim TIME DEFAULT NULL,
  jornada_1_duracao DECIMAL(20,5) UNSIGNED DEFAULT 0,
  jornada_2_inicio TIME DEFAULT NULL,
  jornada_2_almoco_inicio TIME DEFAULT NULL,
  jornada_2_almoco_fim TIME DEFAULT NULL,
  jornada_2_fim TIME DEFAULT NULL,
  jornada_2_duracao DECIMAL(20,5) UNSIGNED DEFAULT 0,
  jornada_3_inicio TIME DEFAULT NULL,
  jornada_3_almoco_inicio TIME DEFAULT NULL,
  jornada_3_almoco_fim TIME DEFAULT NULL,
  jornada_3_fim TIME DEFAULT NULL,
  jornada_3_duracao DECIMAL(20,5) UNSIGNED DEFAULT 0,
  jornada_4_inicio TIME DEFAULT NULL,
  jornada_4_almoco_inicio TIME DEFAULT NULL,
  jornada_4_almoco_fim TIME DEFAULT NULL,
  jornada_4_fim TIME DEFAULT NULL,
  jornada_4_duracao DECIMAL(20,5) UNSIGNED DEFAULT 0,
  jornada_5_inicio TIME DEFAULT NULL,
  jornada_5_almoco_inicio TIME DEFAULT NULL,
  jornada_5_almoco_fim TIME DEFAULT NULL,
  jornada_5_fim TIME DEFAULT NULL,
  jornada_5_duracao DECIMAL(20,5) UNSIGNED DEFAULT 0,
  jornada_6_inicio TIME DEFAULT NULL,
  jornada_6_almoco_inicio TIME DEFAULT NULL,
  jornada_6_almoco_fim TIME DEFAULT NULL,
  jornada_6_fim TIME DEFAULT NULL,
  jornada_6_duracao DECIMAL(20,5) UNSIGNED DEFAULT 0,
  jornada_7_inicio TIME DEFAULT NULL,
  jornada_7_almoco_inicio TIME DEFAULT NULL,
  jornada_7_almoco_fim TIME DEFAULT NULL,
  jornada_7_fim TIME DEFAULT NULL,
  jornada_7_duracao DECIMAL(20,5) UNSIGNED DEFAULT 0,
  PRIMARY KEY (jornada_id)
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS jornada_excessao;

CREATE TABLE jornada_excessao (
  jornada_excessao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  jornada_excessao_jornada INTEGER(100) UNSIGNED DEFAULT NULL,
  jornada_excessao_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  jornada_excessao_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  jornada_excessao_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  jornada_excessao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
  jornada_excessao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  jornada_excessao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  jornada_excessao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
  jornada_excessao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
  jornada_excessao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
  jornada_excessao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
  jornada_excessao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
  jornada_excessao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
  jornada_excessao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
  jornada_excessao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  jornada_excessao_inicio TIME DEFAULT NULL,
  jornada_excessao_almoco_inicio TIME DEFAULT NULL,
  jornada_excessao_almoco_fim TIME DEFAULT NULL,
  jornada_excessao_fim TIME DEFAULT NULL,
  jornada_excessao_data DATE DEFAULT NULL,
  jornada_excessao_duracao DECIMAL(20,5) UNSIGNED DEFAULT 0,
  jornada_excessao_trabalha TINYINT(1) DEFAULT '0',
  jornada_excessao_anual TINYINT(1) DEFAULT '0',
  PRIMARY KEY (jornada_excessao_id),
  KEY jornada_excessao_jornada (jornada_excessao_jornada),
  KEY jornada_excessao_cia (jornada_excessao_cia),
  KEY jornada_excessao_dept (jornada_excessao_dept),
  KEY jornada_excessao_usuario (jornada_excessao_usuario),
  KEY jornada_excessao_recurso (jornada_excessao_recurso),
  KEY jornada_excessao_projeto (jornada_excessao_projeto),
  KEY jornada_excessao_tarefa (jornada_excessao_tarefa),
  KEY jornada_excessao_acao (jornada_excessao_acao),
  KEY jornada_excessao_tema (jornada_excessao_tema),
  KEY jornada_excessao_objetivo (jornada_excessao_objetivo),
  KEY jornada_excessao_fator (jornada_excessao_fator),
  KEY jornada_excessao_estrategia (jornada_excessao_estrategia),
  KEY jornada_excessao_pratica (jornada_excessao_pratica),
  KEY jornada_excessao_meta (jornada_excessao_meta),
  KEY jornada_excessao_indicador (jornada_excessao_indicador),
	CONSTRAINT jornada_excessao_fk1 FOREIGN KEY (jornada_excessao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT jornada_excessao_fk2 FOREIGN KEY (jornada_excessao_jornada) REFERENCES jornada (jornada_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT jornada_excessao_fk3 FOREIGN KEY (jornada_excessao_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT jornada_excessao_fk4 FOREIGN KEY (jornada_excessao_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT jornada_excessao_fk5 FOREIGN KEY (jornada_excessao_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT jornada_excessao_fk6 FOREIGN KEY (jornada_excessao_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT jornada_excessao_fk7 FOREIGN KEY (jornada_excessao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT jornada_excessao_fk8 FOREIGN KEY (jornada_excessao_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT jornada_excessao_fk9 FOREIGN KEY (jornada_excessao_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT jornada_excessao_fk10 FOREIGN KEY (jornada_excessao_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT jornada_excessao_fk11 FOREIGN KEY (jornada_excessao_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT jornada_excessao_fk12 FOREIGN KEY (jornada_excessao_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT jornada_excessao_fk13 FOREIGN KEY (jornada_excessao_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT jornada_excessao_fk14 FOREIGN KEY (jornada_excessao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT jornada_excessao_fk15 FOREIGN KEY (jornada_excessao_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS jornada_pertence;
CREATE TABLE jornada_pertence (
  jornada_pertence_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  jornada_pertence_jornada INTEGER(100) UNSIGNED DEFAULT NULL,
  jornada_pertence_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  jornada_pertence_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  jornada_pertence_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  jornada_pertence_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
  jornada_pertence_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  jornada_pertence_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  jornada_pertence_acao INTEGER(100) UNSIGNED DEFAULT NULL,
  jornada_pertence_tema INTEGER(100) UNSIGNED DEFAULT NULL,
  jornada_pertence_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
  jornada_pertence_fator INTEGER(100) UNSIGNED DEFAULT NULL,
  jornada_pertence_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
  jornada_pertence_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
  jornada_pertence_meta INTEGER(100) UNSIGNED DEFAULT NULL,
  jornada_pertence_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (jornada_pertence_id),
  KEY jornada_pertence_jornada (jornada_pertence_jornada),
  KEY jornada_pertence_cia (jornada_pertence_cia),
  KEY jornada_pertence_dept (jornada_pertence_dept),
  KEY jornada_pertence_usuario (jornada_pertence_usuario),
  KEY jornada_pertence_recurso (jornada_pertence_recurso),
  KEY jornada_pertence_projeto (jornada_pertence_projeto),
  KEY jornada_pertence_tarefa (jornada_pertence_tarefa),
  KEY jornada_pertence_acao (jornada_pertence_acao),
  KEY jornada_pertence_tema (jornada_pertence_tema),
  KEY jornada_pertence_objetivo (jornada_pertence_objetivo),
  KEY jornada_pertence_fator (jornada_pertence_fator),
  KEY jornada_pertence_estrategia (jornada_pertence_estrategia),
  KEY jornada_pertence_pratica (jornada_pertence_pratica),
  KEY jornada_pertence_meta (jornada_pertence_meta),
  KEY jornada_pertence_indicador (jornada_pertence_indicador),
	CONSTRAINT jornada_pertence_fk1 FOREIGN KEY (jornada_pertence_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT jornada_pertence_fk2 FOREIGN KEY (jornada_pertence_jornada) REFERENCES jornada (jornada_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT jornada_pertence_fk3 FOREIGN KEY (jornada_pertence_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT jornada_pertence_fk4 FOREIGN KEY (jornada_pertence_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT jornada_pertence_fk5 FOREIGN KEY (jornada_pertence_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT jornada_pertence_fk6 FOREIGN KEY (jornada_pertence_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT jornada_pertence_fk7 FOREIGN KEY (jornada_pertence_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT jornada_pertence_fk8 FOREIGN KEY (jornada_pertence_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT jornada_pertence_fk9 FOREIGN KEY (jornada_pertence_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT jornada_pertence_fk10 FOREIGN KEY (jornada_pertence_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT jornada_pertence_fk11 FOREIGN KEY (jornada_pertence_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT jornada_pertence_fk12 FOREIGN KEY (jornada_pertence_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT jornada_pertence_fk13 FOREIGN KEY (jornada_pertence_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT jornada_pertence_fk14 FOREIGN KEY (jornada_pertence_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT jornada_pertence_fk15 FOREIGN KEY (jornada_pertence_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS tarefas_cache;

CREATE TABLE tarefas_cache (
  projeto_id INTEGER(100) UNSIGNED NOT NULL,
  time timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  dados longtext,
  KEY tarefas_cache_fk (projeto_id,time)
) ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS categoria;

CREATE TABLE categoria (
  categoria_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  categoria_nome VARCHAR(255) DEFAULT NULL,
  PRIMARY KEY (categoria_id)
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS segmento;

CREATE TABLE segmento (
  segmento_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  segmento_categoria INTEGER(100) UNSIGNED DEFAULT NULL,
  segmento_nome VARCHAR(255) DEFAULT NULL,
  PRIMARY KEY (segmento_id),
  KEY segmento_categoria (segmento_categoria),
  CONSTRAINT segmento_fk FOREIGN KEY (segmento_categoria) REFERENCES categoria (categoria_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS cia_segmento;

CREATE TABLE cia_segmento (
  cia_segmento_cia INTEGER(100) UNSIGNED NOT NULL,
  cia_segmento_segmento INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (cia_segmento_cia, cia_segmento_segmento),
  KEY cia_segmento_cia (cia_segmento_cia),
  KEY cia_segmento_segmento (cia_segmento_segmento),
  CONSTRAINT cia_segmentos_fk FOREIGN KEY (cia_segmento_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT cia_segmentos_fk1 FOREIGN KEY (cia_segmento_segmento) REFERENCES segmento (segmento_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS campo_formulario;

CREATE TABLE campo_formulario (
  campo_formulario_id INTEGER(100) NOT NULL AUTO_INCREMENT,
  campo_formulario_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  campo_formulario_customizado INTEGER(100) UNSIGNED DEFAULT NULL,
  campo_formulario_tipo VARCHAR(20) DEFAULT NULL,
  campo_formulario_campo VARCHAR(50) DEFAULT NULL,
  campo_formulario_descricao VARCHAR(100) DEFAULT NULL,
  campo_formulario_ativo TINYINT(1) DEFAULT 1,
  PRIMARY KEY (campo_formulario_id),
  KEY campo_formulario_usuario (campo_formulario_usuario),
  KEY campo_formulario_customizado (campo_formulario_customizado),
  CONSTRAINT campo_formulario_customizado FOREIGN KEY (campo_formulario_customizado) REFERENCES campo_customizado (campo_customizado_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT campo_formulario_fk FOREIGN KEY (campo_formulario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS usuario_grupo;

CREATE TABLE usuario_grupo (
  usuario_grupo_pai INTEGER(100) UNSIGNED DEFAULT NULL,
  usuario_grupo_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  usuario_grupo_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  KEY usuario_grupo_pai (usuario_grupo_pai),
  KEY usuario_grupo_usuario (usuario_grupo_usuario),
  KEY usuario_grupo_dept (usuario_grupo_dept),
  CONSTRAINT usuario_grupo_usuario FOREIGN KEY (usuario_grupo_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT usuario_grupo_dept FOREIGN KEY (usuario_grupo_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT usuario_grupo_pai FOREIGN KEY (usuario_grupo_pai) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS tema;

CREATE TABLE tema (
  tema_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  tema_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  tema_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  tema_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
  tema_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  tema_principal_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  tema_nome TEXT,
  tema_data DATETIME DEFAULT NULL,
  tema_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  tema_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  tema_cor VARCHAR(6) DEFAULT 'FFFFFF',
  tema_oque TEXT,
  tema_descricao MEDIUMTEXT,
  tema_onde TEXT,
  tema_quando TEXT,
  tema_como TEXT,
  tema_porque TEXT,
  tema_quanto TEXT,
  tema_quem TEXT,
  tema_controle TEXT,
  tema_melhorias TEXT,
  tema_metodo_aprendizado TEXT,
  tema_desde_quando TEXT,
  tema_ativo TINYINT(1) DEFAULT 1,
  tema_tipo VARCHAR(50) DEFAULT NULL,
  tema_tipo_pontuacao VARCHAR(40) DEFAULT NULL,
  tema_percentagem DECIMAL(20,5) UNSIGNED DEFAULT 0,
  tema_ponto_alvo DECIMAL(20,5) UNSIGNED DEFAULT 0,
  tema_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
  tema_aprovado TINYINT(1) DEFAULT 0,
  PRIMARY KEY (tema_id),
  KEY tema_cia (tema_cia),
  KEY tema_dept (tema_dept),
  KEY tema_usuario (tema_usuario),
  KEY tema_perspectiva (tema_perspectiva),
  KEY tema_principal_indicador (tema_principal_indicador),
  KEY tema_moeda (tema_moeda),
  CONSTRAINT tema_fk FOREIGN KEY (tema_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tema_fk2 FOREIGN KEY (tema_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT tema_fk3 FOREIGN KEY (tema_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tema_fk4 FOREIGN KEY (tema_principal_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT tema_dept FOREIGN KEY (tema_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT tema_moeda FOREIGN KEY (tema_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS evento_dept;

CREATE TABLE evento_dept (
  evento_dept_evento INTEGER(100) UNSIGNED NOT NULL,
  evento_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY USING BTREE (evento_dept_evento, evento_dept_dept),
   KEY evento_dept_evento (evento_dept_evento),
   KEY evento_dept_dept (evento_dept_dept),
  CONSTRAINT evento_dept_dept FOREIGN KEY (evento_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT evento_dept_evento FOREIGN KEY (evento_dept_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS tema_depts;

CREATE TABLE tema_depts (
  tema_id INTEGER(100) UNSIGNED NOT NULL,
  dept_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (tema_id, dept_id),
  KEY tema_id (tema_id),
  KEY dept_id (dept_id),
  CONSTRAINT tema_depts_fk FOREIGN KEY (tema_id) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tema_depts_fk1 FOREIGN KEY (dept_id) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS tema_usuarios;

CREATE TABLE tema_usuarios (
  tema_id INTEGER(100) UNSIGNED NOT NULL,
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (tema_id, usuario_id),
  KEY tema_id (tema_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT tema_usuarios_fk FOREIGN KEY (tema_id) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tema_usuarios_fk1 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS plano_gestao_tema;

CREATE TABLE plano_gestao_tema (
  pg_id INTEGER(100) UNSIGNED DEFAULT NULL,
  tema_id INTEGER(100) UNSIGNED DEFAULT NULL,
  tema_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  KEY pg_id (pg_id),
  KEY tema_id (tema_id),
  CONSTRAINT plano_gestao_tema_fk FOREIGN KEY (pg_id) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_gestao_tema_fk1 FOREIGN KEY (tema_id) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;




DROP TABLE IF EXISTS ata;

CREATE TABLE ata (
  ata_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  ata_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  ata_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  ata_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  ata_principal_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  ata_titulo VARCHAR(255) DEFAULT NULL,
  ata_numero VARCHAR(255) DEFAULT NULL,
  ata_data_inicio DATETIME DEFAULT NULL,
  ata_data_fim DATETIME DEFAULT NULL,
  ata_local TEXT,
  ata_relato MEDIUMTEXT,
  ata_proxima_data_inicio DATETIME DEFAULT NULL,
  ata_proxima_data_fim DATETIME DEFAULT NULL,
  ata_proxima_local TEXT,
  ata_moeda INTEGER(100) UNSIGNED DEFAULT 1,
  ata_cor VARCHAR(6) DEFAULT 'ffffff',
  ata_acesso INTEGER(100) UNSIGNED DEFAULT '0',
  ata_aprovado TINYINT(1) DEFAULT 0,
  ata_ativo TINYINT(1) DEFAULT 1,
  PRIMARY KEY (ata_id),
  KEY ata_responsavel (ata_responsavel),
  KEY ata_cia (ata_cia),
  KEY ata_dept (ata_dept),
  KEY ata_principal_indicador (ata_principal_indicador),
	KEY ata_moeda (ata_moeda),
  CONSTRAINT ata_responsavel FOREIGN KEY (ata_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT ata_cia FOREIGN KEY (ata_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT ata_dept FOREIGN KEY (ata_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT ata_principal_indicador FOREIGN KEY (ata_principal_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT ata_moeda FOREIGN KEY (ata_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS ata_dept;

CREATE TABLE ata_dept (
  ata_dept_ata INTEGER(100) UNSIGNED NOT NULL,
  ata_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (ata_dept_ata, ata_dept_dept),
  KEY ata_dept_ata (ata_dept_ata),
  KEY ata_dept_dept (ata_dept_dept),
  CONSTRAINT ata_dept_dept FOREIGN KEY (ata_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT ata_dept_ata FOREIGN KEY (ata_dept_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS ata_usuario;

CREATE TABLE ata_usuario (
  ata_usuario_ata INTEGER(100) UNSIGNED NOT NULL,
  ata_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
  KEY ata_usuario_ata (ata_usuario_ata),
  KEY ata_usuario_usuario (ata_usuario_usuario),
  CONSTRAINT ata_usuario_ata FOREIGN KEY (ata_usuario_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT ata_usuario_usuario FOREIGN KEY (ata_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS assinatura_atesta;

CREATE TABLE assinatura_atesta (
	assinatura_atesta_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  assinatura_atesta_nome VARCHAR (255),
  assinatura_atesta_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  assinatura_atesta_projeto TINYINT(1) DEFAULT 0,
	assinatura_atesta_tarefa TINYINT(1) DEFAULT 0,
	assinatura_atesta_perspectiva TINYINT(1) DEFAULT 0,
	assinatura_atesta_tema TINYINT(1) DEFAULT 0,
	assinatura_atesta_objetivo TINYINT(1) DEFAULT 0,
	assinatura_atesta_fator TINYINT(1) DEFAULT 0,
	assinatura_atesta_estrategia TINYINT(1) DEFAULT 0,
	assinatura_atesta_meta TINYINT(1) DEFAULT 0,
	assinatura_atesta_pratica TINYINT(1) DEFAULT 0,
	assinatura_atesta_indicador TINYINT(1) DEFAULT 0,
	assinatura_atesta_acao TINYINT(1) DEFAULT 0,
	assinatura_atesta_canvas TINYINT(1) DEFAULT 0,
	assinatura_atesta_risco TINYINT(1) DEFAULT 0,
	assinatura_atesta_risco_resposta TINYINT(1) DEFAULT 0,
	assinatura_atesta_calendario TINYINT(1) DEFAULT 0,
	assinatura_atesta_monitoramento TINYINT(1) DEFAULT 0,
	assinatura_atesta_ata TINYINT(1) DEFAULT 0,
	assinatura_atesta_mswot TINYINT(1) DEFAULT 0,
	assinatura_atesta_swot TINYINT(1) DEFAULT 0,
	assinatura_atesta_operativo TINYINT(1) DEFAULT 0,
	assinatura_atesta_instrumento TINYINT(1) DEFAULT 0,
	assinatura_atesta_recurso TINYINT(1) DEFAULT 0,
	assinatura_atesta_problema TINYINT(1) DEFAULT 0,
	assinatura_atesta_demanda TINYINT(1) DEFAULT 0,
	assinatura_atesta_programa TINYINT(1) DEFAULT 0,
	assinatura_atesta_licao TINYINT(1) DEFAULT 0,
	assinatura_atesta_evento TINYINT(1) DEFAULT 0,
	assinatura_atesta_link TINYINT(1) DEFAULT 0,
	assinatura_atesta_avaliacao TINYINT(1) DEFAULT 0,
	assinatura_atesta_tgn TINYINT(1) DEFAULT 0,
	assinatura_atesta_brainstorm TINYINT(1) DEFAULT 0,
	assinatura_atesta_gut TINYINT(1) DEFAULT 0,
	assinatura_atesta_causa_efeito TINYINT(1) DEFAULT 0,
	assinatura_atesta_arquivo TINYINT(1) DEFAULT 0,
	assinatura_atesta_forum TINYINT(1) DEFAULT 0,
	assinatura_atesta_checklist TINYINT(1) DEFAULT 0,
	assinatura_atesta_agenda  TINYINT(1) DEFAULT 0,
	assinatura_atesta_agrupamento TINYINT(1) DEFAULT 0,
	assinatura_atesta_patrocinador TINYINT(1) DEFAULT 0,
	assinatura_atesta_template TINYINT(1) DEFAULT 0,
	assinatura_atesta_painel TINYINT(1) DEFAULT 0,
	assinatura_atesta_painel_composicao TINYINT(1) DEFAULT 0,
	assinatura_atesta_painel_odometro TINYINT(1) DEFAULT 0,
	assinatura_atesta_tr TINYINT(1) DEFAULT 0,
	assinatura_atesta_me TINYINT(1) DEFAULT 0,
	assinatura_atesta_acao_item TINYINT(1) DEFAULT 0,
	assinatura_atesta_beneficio TINYINT(1) DEFAULT 0,
	assinatura_atesta_painel_slideshow TINYINT(1) DEFAULT 0,
	assinatura_atesta_projeto_viabilidade TINYINT(1) DEFAULT 0,
	assinatura_atesta_projeto_abertura TINYINT(1) DEFAULT 0,
	assinatura_atesta_plano_gestao TINYINT(1) DEFAULT 0,
	assinatura_atesta_aviso TINYINT(1) DEFAULT 0,
	assinatura_atesta_ssti TINYINT(1) DEFAULT 0,
	assinatura_atesta_laudo TINYINT(1) DEFAULT 0,
	assinatura_atesta_trelo TINYINT(1) DEFAULT 0,
	assinatura_atesta_trelo_cartao TINYINT(1) DEFAULT 0,
	assinatura_atesta_pdcl TINYINT(1) DEFAULT 0,
	assinatura_atesta_pdcl_item TINYINT(1) DEFAULT 0,
	assinatura_atesta_os TINYINT(1) DEFAULT 0,
	assinatura_atesta_modelo TINYINT(1) DEFAULT 0,
  PRIMARY KEY (assinatura_atesta_id)
)ENGINE=InnoDB;

DROP TABLE IF EXISTS assinatura_atesta_opcao;

CREATE TABLE assinatura_atesta_opcao (
	assinatura_atesta_opcao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	assinatura_atesta_opcao_atesta INTEGER(100) UNSIGNED DEFAULT NULL,
  assinatura_atesta_opcao_nome VARCHAR (255),
  assinatura_atesta_opcao_aprova TINYINT(1) DEFAULT 1,
  assinatura_atesta_opcao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (assinatura_atesta_opcao_id),
  KEY assinatura_atesta_opcao_atesta (assinatura_atesta_opcao_atesta),
  CONSTRAINT assinatura_atesta_opcao_atesta FOREIGN KEY (assinatura_atesta_opcao_atesta) REFERENCES assinatura_atesta (assinatura_atesta_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB;


DROP TABLE IF EXISTS ata_externo;

CREATE TABLE ata_externo (
	ata_externo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  ata_externo_ata INTEGER(100) UNSIGNED DEFAULT NULL,
  ata_externo_nome VARCHAR (255),
  ata_externo_campo2 VARCHAR (255),
  ata_externo_campo3 VARCHAR (255),
  ata_externo_campo4 VARCHAR (255),
	ata_externo_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  ata_externo_uuid varchar(36) DEFAULT NULL,
  PRIMARY KEY (ata_externo_id),
  KEY ata_externo_ata (ata_externo_ata),
  CONSTRAINT ata_externo_ata FOREIGN KEY (ata_externo_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS ata_config;

CREATE TABLE ata_config (
	ata_config_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	ata_config_exibe_funcao TINYINT DEFAULT 0,
	ata_config_exibe_tipo_parecer TINYINT DEFAULT 0,
	ata_config_exibe_linha2 TINYINT DEFAULT 0,
	ata_config_linha2_legenda VARCHAR(50)DEFAULT NULL,
	ata_config_exibe_linha3 TINYINT DEFAULT 0,
	ata_config_linha3_legenda VARCHAR(50)DEFAULT NULL,
	ata_config_exibe_linha4 TINYINT DEFAULT 0,
	ata_config_linha4_legenda VARCHAR(50)DEFAULT NULL,
	ata_config_numeracao_automatica TINYINT DEFAULT 0,
	ata_config_tipo_numeracao INTEGER(10) DEFAULT 0,
	PRIMARY KEY (ata_config_id)
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS ata_participante_historico;

CREATE TABLE ata_participante_historico (
	ata_participante_historico_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  ata_participante_historico_ata INTEGER(100) UNSIGNED DEFAULT NULL,
  ata_participante_historico_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  ata_participante_historico_aprova TINYINT(1) DEFAULT 0,
  ata_participante_historico_data DATETIME,
  ata_participante_historico_observacao MEDIUMTEXT,
  PRIMARY KEY (ata_participante_historico_id),
  KEY ata_participante_historico_ata (ata_participante_historico_ata),
  KEY ata_participante_historico_usuario (ata_participante_historico_usuario),
  CONSTRAINT ata_participante_historico_ata FOREIGN KEY (ata_participante_historico_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT ata_participante_historico_usuario FOREIGN KEY (ata_participante_historico_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB;

DROP TABLE IF EXISTS ata_acao;

CREATE TABLE ata_acao (
  ata_acao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  ata_acao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
  ata_acao_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
	ata_acao_inicio DATETIME DEFAULT NULL,
	ata_acao_fim DATETIME DEFAULT NULL,
	ata_acao_duracao DECIMAL(20,5) UNSIGNED DEFAULT 0,
	ata_acao_percentagem DECIMAL(20,5) UNSIGNED DEFAULT 0,
	ata_acao_status INTEGER(10) DEFAULT 0,
  ata_acao_texto MEDIUMTEXT,
  ata_acao_observacao MEDIUMTEXT,
  ata_acao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  ata_acao_tipo VARCHAR(20)  DEFAULT NULL,
  ata_acao_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (ata_acao_id),
  KEY ata_acao_ata (ata_acao_ata),
  KEY ata_acao_responsavel (ata_acao_responsavel),
  CONSTRAINT ata_acao_responsavel FOREIGN KEY (ata_acao_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT ata_acao_ata FOREIGN KEY (ata_acao_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS ata_acao_usuario;

CREATE TABLE ata_acao_usuario (
  ata_acao_usuario_acao INTEGER(100) UNSIGNED DEFAULT NULL,
  ata_acao_usuario_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  KEY ata_acao_usuario_acao (ata_acao_usuario_acao),
  KEY ata_acao_usuario_usuario (ata_acao_usuario_usuario),
  CONSTRAINT ata_acao_usuario_acao FOREIGN KEY (ata_acao_usuario_acao) REFERENCES ata_acao (ata_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT ata_acao_usuario_usuario FOREIGN KEY (ata_acao_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS ata_pauta;

CREATE TABLE ata_pauta (
  ata_pauta_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  ata_pauta_ata INTEGER(100) UNSIGNED DEFAULT NULL,
  ata_pauta_texto MEDIUMTEXT,
  ata_pauta_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  ata_pauta_tipo TINYINT(1) DEFAULT 0,
  ata_pauta_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (ata_pauta_id),
  KEY ata_pauta_ata (ata_pauta_ata),
  CONSTRAINT ata_pauta_ata FOREIGN KEY (ata_pauta_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS projeto_mudanca;

CREATE TABLE projeto_mudanca (
  projeto_mudanca_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  projeto_mudanca_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_mudanca_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_mudanca_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_mudanca_cliente INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_mudanca_autoridade INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_mudanca_numero INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_mudanca_justificativa MEDIUMTEXT,
  projeto_mudanca_parecer_tecnico MEDIUMTEXT,
  projeto_mudanca_solucoes MEDIUMTEXT,
  projeto_mudanca_impacto_cronograma MEDIUMTEXT,
  projeto_mudanca_impacto_custo MEDIUMTEXT,
  projeto_mudanca_novo_risco MEDIUMTEXT,
  projeto_mudanca_outros_impactos MEDIUMTEXT,
  projeto_mudanca_solucao MEDIUMTEXT,
  projeto_mudanca_parecer MEDIUMTEXT,
  projeto_mudanca_requisitante_aprovada TINYINT(1) UNSIGNED DEFAULT 0,
  projeto_mudanca_requisitante_reprovada TINYINT(1) UNSIGNED DEFAULT 0,
  projeto_mudanca_administracao_aprovada TINYINT(1) UNSIGNED DEFAULT 0,
  projeto_mudanca_administracao_reprovada TINYINT(1) UNSIGNED DEFAULT 0,
  projeto_mudanca_data DATETIME DEFAULT NULL,
  projeto_mudanca_data_aprovacao DATETIME DEFAULT NULL,
  projeto_mudanca_cor VARCHAR(6) DEFAULT 'ffffff',
  projeto_mudanca_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  PRIMARY KEY (projeto_mudanca_id),
  KEY projeto_mudanca_projeto (projeto_mudanca_projeto),
  KEY projeto_mudanca_tarefa (projeto_mudanca_tarefa),
  KEY projeto_mudanca_responsavel (projeto_mudanca_responsavel),
  KEY projeto_mudanca_autoridade (projeto_mudanca_autoridade),
  KEY projeto_mudanca_cliente (projeto_mudanca_cliente),
  CONSTRAINT projeto_mudanca_fk FOREIGN KEY (projeto_mudanca_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_mudanca_fk5 FOREIGN KEY (projeto_mudanca_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT projeto_mudanca_fk2 FOREIGN KEY (projeto_mudanca_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT projeto_mudanca_fk4 FOREIGN KEY (projeto_mudanca_autoridade) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT projeto_mudanca_fk3 FOREIGN KEY (projeto_mudanca_cliente) REFERENCES contatos (contato_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS projeto_mudanca_usuarios;

CREATE TABLE projeto_mudanca_usuarios (
  projeto_mudanca_id INTEGER(100) UNSIGNED DEFAULT NULL,
  usuario_id INTEGER(100) UNSIGNED DEFAULT NULL,
  KEY projeto_mudanca_id (projeto_mudanca_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT projeto_mudanca_usuarios_fk FOREIGN KEY (projeto_mudanca_id) REFERENCES projeto_mudanca (projeto_mudanca_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_mudanca_usuarios_fk1 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS projeto_recebimento;

CREATE TABLE projeto_recebimento (
  projeto_recebimento_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  projeto_recebimento_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_recebimento_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_recebimento_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_recebimento_cliente INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_recebimento_autoridade INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_recebimento_numero INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_recebimento_observacao MEDIUMTEXT,
  projeto_recebimento_provisorio TINYINT(1) UNSIGNED DEFAULT 0,
  projeto_recebimento_definitivo TINYINT(1) UNSIGNED DEFAULT 0,
  projeto_recebimento_data_prevista DATE DEFAULT NULL,
  projeto_recebimento_data_entrega DATE DEFAULT NULL,
  projeto_recebimento_data_aprovacao DATETIME DEFAULT NULL,
  projeto_recebimento_cor VARCHAR(6) DEFAULT 'ffffff',
  projeto_recebimento_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  PRIMARY KEY (projeto_recebimento_id),
  KEY projeto_recebimento_projeto (projeto_recebimento_projeto),
  KEY projeto_recebimento_tarefa (projeto_recebimento_tarefa),
  KEY projeto_recebimento_responsavel (projeto_recebimento_responsavel),
  KEY projeto_recebimento_autoridade (projeto_recebimento_autoridade),
  KEY projeto_recebimento_cliente (projeto_recebimento_cliente),
  CONSTRAINT projeto_recebimento_fk FOREIGN KEY (projeto_recebimento_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_recebimento_fk5 FOREIGN KEY (projeto_recebimento_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT projeto_recebimento_fk2 FOREIGN KEY (projeto_recebimento_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT projeto_recebimento_fk4 FOREIGN KEY (projeto_recebimento_autoridade) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT projeto_recebimento_fk3 FOREIGN KEY (projeto_recebimento_cliente) REFERENCES contatos (contato_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS projeto_recebimento_usuarios;

CREATE TABLE projeto_recebimento_usuarios (
  projeto_recebimento_id INTEGER(100) UNSIGNED DEFAULT NULL,
  usuario_id INTEGER(100) UNSIGNED DEFAULT NULL,
  KEY projeto_recebimento_id (projeto_recebimento_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT projeto_recebimento_usuarios_fk FOREIGN KEY (projeto_recebimento_id) REFERENCES projeto_recebimento (projeto_recebimento_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_recebimento_usuarios_fk1 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS projeto_recebimento_lista;

CREATE TABLE projeto_recebimento_lista (
  projeto_recebimento_lista_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  projeto_recebimento_lista_recebimento_id INTEGER(100) UNSIGNED NOT NULL,
  projeto_recebimento_lista_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_recebimento_lista_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_recebimento_lista_data DATETIME DEFAULT NULL,
  projeto_recebimento_lista_produto MEDIUMTEXT,
  PRIMARY KEY (projeto_recebimento_lista_id),
  KEY projeto_recebimento_lista_recebimento_id (projeto_recebimento_lista_recebimento_id),
  KEY projeto_recebimento_lista_responsavel (projeto_recebimento_lista_responsavel),
  CONSTRAINT projeto_recebimento_lista_recebimento_id_fk FOREIGN KEY (projeto_recebimento_lista_recebimento_id) REFERENCES projeto_recebimento (projeto_recebimento_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_recebimento_lista_responsavel_fk2 FOREIGN KEY (projeto_recebimento_lista_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
  )ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS projeto_encerramento;

CREATE TABLE projeto_encerramento (
  projeto_encerramento_projeto INTEGER(100) UNSIGNED NOT NULL,
  projeto_encerramento_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_encerramento_justificativa MEDIUMTEXT,
  projeto_encerramento_encerrado TINYINT(1) UNSIGNED DEFAULT 0,
  projeto_encerramento_encerrado_ressalvas TINYINT(1) UNSIGNED DEFAULT 0,
  projeto_encerramento_nao_encerrado TINYINT(1) UNSIGNED DEFAULT 0,
  projeto_encerramento_data DATETIME DEFAULT NULL,
  projeto_encerramento_cor VARCHAR(6) DEFAULT 'ffffff',
  projeto_encerramento_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  PRIMARY KEY (projeto_encerramento_projeto),
  KEY projeto_encerramento_responsavel (projeto_encerramento_responsavel),
  CONSTRAINT projeto_encerramento_fk FOREIGN KEY (projeto_encerramento_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_encerramento_fk2 FOREIGN KEY (projeto_encerramento_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS projeto_encerramento_usuarios;

CREATE TABLE projeto_encerramento_usuarios (
  projeto_encerramento_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  usuario_id INTEGER(100) UNSIGNED DEFAULT NULL,
  KEY projeto_encerramento_projeto (projeto_encerramento_projeto),
  KEY usuario_id (usuario_id),
  CONSTRAINT projeto_encerramento_usuarios_fk FOREIGN KEY (projeto_encerramento_projeto) REFERENCES projeto_encerramento (projeto_encerramento_projeto) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_encerramento_usuarios_fk1 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS licao;

CREATE TABLE licao (
  licao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  licao_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  licao_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  licao_responsavel INTEGER(100) UNSIGNED NULL,
  licao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  licao_nome TEXT,
  licao_ocorrencia MEDIUMTEXT,
  licao_tipo TINYINT(1) UNSIGNED DEFAULT 0,
  licao_categoria VARCHAR(255) DEFAULT NULL,
  licao_consequencia MEDIUMTEXT,
  licao_acao_tomada MEDIUMTEXT,
  licao_aprendizado MEDIUMTEXT,
  licao_data DATETIME DEFAULT NULL,
  licao_data_final DATE DEFAULT NULL,
  licao_status VARCHAR(50) DEFAULT NULL,
  licao_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
  licao_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  licao_cor VARCHAR(6) DEFAULT 'ffffff',
  licao_ativa TINYINT(1) DEFAULT 1,
  licao_aprovado TINYINT(1) DEFAULT 0,
  PRIMARY KEY (licao_id),
  KEY licao_cia (licao_cia),
  KEY licao_responsavel (licao_responsavel),
  KEY licao_projeto (licao_projeto),
  KEY licao_moeda (licao_moeda),
  CONSTRAINT licao_fk FOREIGN KEY (licao_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT licao_fk1 FOREIGN KEY (licao_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT licao_fk2 FOREIGN KEY (licao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT licao_moeda FOREIGN KEY (licao_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS licao_dept;

CREATE TABLE licao_dept (
  licao_dept_licao INTEGER(100) UNSIGNED NOT NULL,
  licao_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (licao_dept_licao, licao_dept_dept),
  KEY licao_dept_licao (licao_dept_licao),
  KEY licao_dept_dept (licao_dept_dept),
  CONSTRAINT licao_dept_dept FOREIGN KEY (licao_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT licao_dept_licao FOREIGN KEY (licao_dept_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS licao_usuario;

CREATE TABLE licao_usuario (
	licao_usuario_licao INTEGER(100) UNSIGNED NOT NULL,
	licao_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
	KEY licao_usuario_licao (licao_usuario_licao),
	KEY licao_usuario_usuario (licao_usuario_usuario),
	CONSTRAINT licao_usuario_licao FOREIGN KEY (licao_usuario_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT licao_usuario_usuario FOREIGN KEY (licao_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS avaliacao;

CREATE TABLE avaliacao (
  avaliacao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  avaliacao_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  avaliacao_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  avaliacao_responsavel INTEGER(100) UNSIGNED NULL,
  avaliacao_nome VARCHAR(255) DEFAULT NULL,
  avaliacao_data DATETIME DEFAULT NULL,
  avaliacao_descricao MEDIUMTEXT,
  avaliacao_inicio DATETIME,
  avaliacao_fim DATETIME,
  avaliacao_status VARCHAR(50) DEFAULT NULL,
  avaliacao_moeda INTEGER(100) UNSIGNED DEFAULT 1,
  avaliacao_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  avaliacao_cor VARCHAR(6) DEFAULT 'ffffff',
  avaliacao_ativa TINYINT(1) DEFAULT 1,
  avaliacao_aprovado TINYINT(1) DEFAULT 0,
  PRIMARY KEY (avaliacao_id),
  KEY avaliacao_cia (avaliacao_cia),
  KEY avaliacao_dept (avaliacao_dept),
  KEY avaliacao_responsavel (avaliacao_responsavel),
  KEY avaliacao_moeda (avaliacao_moeda),
  CONSTRAINT avaliacao_cia FOREIGN KEY (avaliacao_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT avaliacao_dept FOREIGN KEY (avaliacao_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT avaliacao_responsavel FOREIGN KEY (avaliacao_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT avaliacao_moeda FOREIGN KEY (avaliacao_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS avaliacao_usuarios;

CREATE TABLE avaliacao_usuarios (
  avaliacao_id INTEGER(100) UNSIGNED NOT NULL,
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  KEY avaliacao_id (avaliacao_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT avaliacao_usuarios_fk FOREIGN KEY (avaliacao_id) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT avaliacao_usuarios_fk1 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS avaliacao_dept;

CREATE TABLE avaliacao_dept (
  avaliacao_dept_avaliacao INTEGER(100) UNSIGNED NOT NULL,
  avaliacao_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (avaliacao_dept_avaliacao, avaliacao_dept_dept),
  KEY avaliacao_dept_avaliacao (avaliacao_dept_avaliacao),
  KEY avaliacao_dept_dept (avaliacao_dept_dept),
  CONSTRAINT avaliacao_dept_dept FOREIGN KEY (avaliacao_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT avaliacao_dept_avaliacao FOREIGN KEY (avaliacao_dept_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS avaliacao_indicador_lista;

CREATE TABLE avaliacao_indicador_lista (
  avaliacao_indicador_lista_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  avaliacao_indicador_lista_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
  avaliacao_indicador_lista_pratica_indicador_id INTEGER(100) UNSIGNED DEFAULT NULL,
  avaliacao_indicador_lista_pratica_indicador_valor_id INTEGER(100) UNSIGNED DEFAULT NULL,
  avaliacao_indicador_lista_checklist_dados_id INTEGER(100) UNSIGNED DEFAULT NULL,
  avaliacao_indicador_lista_checklist_campos LONGBLOB,
  avaliacao_indicador_lista_valor DECIMAL(20,5) DEFAULT 0,
  avaliacao_indicador_lista_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  avaliacao_indicador_lista_data DATETIME DEFAULT NULL,
  avaliacao_indicador_lista_observacao MEDIUMTEXT,
  PRIMARY KEY (avaliacao_indicador_lista_id),
  KEY avaliacao_indicador_lista_avaliacao (avaliacao_indicador_lista_avaliacao),
  KEY avaliacao_indicador_lista_usuario (avaliacao_indicador_lista_usuario),
  KEY avaliacao_indicador_lista_pratica_indicador_id (avaliacao_indicador_lista_pratica_indicador_id),
  KEY avaliacao_indicador_lista_pratica_indicador_valor_id (avaliacao_indicador_lista_pratica_indicador_valor_id),
  KEY avaliacao_indicador_lista_checklist_dados_id (avaliacao_indicador_lista_checklist_dados_id),
  CONSTRAINT avaliacao_indicador_lista_fk5 FOREIGN KEY (avaliacao_indicador_lista_pratica_indicador_valor_id) REFERENCES pratica_indicador_valor (pratica_indicador_valor_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT avaliacao_indicador_lista_fk6 FOREIGN KEY (avaliacao_indicador_lista_checklist_dados_id) REFERENCES checklist_dados (checklist_dados_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT avaliacao_indicador_lista_fk4 FOREIGN KEY (avaliacao_indicador_lista_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT avaliacao_indicador_lista_fk3 FOREIGN KEY (avaliacao_indicador_lista_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT avaliacao_indicador_lista_fk FOREIGN KEY (avaliacao_indicador_lista_pratica_indicador_id) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE
  )ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS projeto_risco;

CREATE TABLE projeto_risco (
 projeto_risco_projeto INTEGER(100) UNSIGNED NOT NULL,
 projeto_risco_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
 projeto_risco_descricao MEDIUMTEXT,
 projeto_risco_data DATETIME DEFAULT NULL,
 PRIMARY KEY (projeto_risco_projeto),
 KEY projeto_risco_usuario (projeto_risco_usuario),
 CONSTRAINT projeto_risco_fk FOREIGN KEY (projeto_risco_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
 CONSTRAINT projeto_risco_fk1 FOREIGN KEY (projeto_risco_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS projeto_risco_tipo;

CREATE TABLE projeto_risco_tipo (
 projeto_risco_tipo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
 projeto_risco_tipo_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
 projeto_risco_tipo_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
 projeto_risco_tipo_descricao MEDIUMTEXT,
 projeto_risco_tipo_categoria VARCHAR(255) DEFAULT NULL,
 projeto_risco_tipo_tipo VARCHAR(8) DEFAULT NULL,
 projeto_risco_tipo_consequencia MEDIUMTEXT,
 projeto_risco_tipo_probabilidade VARCHAR(5) DEFAULT NULL,
 projeto_risco_tipo_impacto VARCHAR(5) DEFAULT NULL,
 projeto_risco_tipo_severidade VARCHAR(5) DEFAULT NULL,
 projeto_risco_tipo_acao MEDIUMTEXT,
 projeto_risco_tipo_gatilho VARCHAR(255) DEFAULT NULL,
 projeto_risco_tipo_resposta MEDIUMTEXT,
 projeto_risco_tipo_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
 projeto_risco_tipo_status  VARCHAR(255) DEFAULT NULL,
 projeto_risco_tipo_data DATETIME DEFAULT NULL,
 PRIMARY KEY (projeto_risco_tipo_id),
 KEY projeto_risco_tipo_projeto (projeto_risco_tipo_projeto),
 KEY projeto_risco_tipo_usuario (projeto_risco_tipo_usuario),
 CONSTRAINT projeto_risco_tipo_fk FOREIGN KEY (projeto_risco_tipo_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
 CONSTRAINT projeto_risco_tipo_fk1 FOREIGN KEY (projeto_risco_tipo_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS projeto_comunicacao;

CREATE TABLE projeto_comunicacao (
  projeto_comunicacao_projeto INTEGER(100) UNSIGNED NOT NULL,
  projeto_comunicacao_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_comunicacao_descricao MEDIUMTEXT,
  projeto_comunicacao_data DATETIME DEFAULT NULL,
  PRIMARY KEY (projeto_comunicacao_projeto),
  KEY projeto_comunicacao_usuario (projeto_comunicacao_usuario),
  CONSTRAINT projeto_comunicacao_fk FOREIGN KEY (projeto_comunicacao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_comunicacao_fk1 FOREIGN KEY (projeto_comunicacao_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS projeto_comunicacao_evento;

CREATE TABLE projeto_comunicacao_evento (
  projeto_comunicacao_evento_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  projeto_comunicacao_evento_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_comunicacao_evento_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_comunicacao_evento_responsavel_id INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_comunicacao_evento_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
 	projeto_comunicacao_evento_evento VARCHAR(255) DEFAULT NULL,
  projeto_comunicacao_evento_objetivo MEDIUMTEXT,
  projeto_comunicacao_evento_responsavel MEDIUMTEXT,
  projeto_comunicacao_evento_publico MEDIUMTEXT,
  projeto_comunicacao_evento_canal MEDIUMTEXT,
  projeto_comunicacao_evento_periodicidade MEDIUMTEXT,
  projeto_comunicacao_evento_data DATETIME DEFAULT NULL,
  PRIMARY KEY (projeto_comunicacao_evento_id),
  KEY projeto_comunicacao_evento_projeto (projeto_comunicacao_evento_projeto),
  KEY projeto_comunicacao_evento_usuario (projeto_comunicacao_evento_usuario),
  KEY projeto_comunicacao_evento_responsavel_id (projeto_comunicacao_evento_responsavel_id),
  CONSTRAINT projeto_comunicacao_evento_fk FOREIGN KEY (projeto_comunicacao_evento_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_comunicacao_evento_fk1 FOREIGN KEY (projeto_comunicacao_evento_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT projeto_comunicacao_evento_fk2 FOREIGN KEY (projeto_comunicacao_evento_responsavel_id) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS projeto_comunicacao_evento_contatos;

CREATE TABLE projeto_comunicacao_evento_contatos (
  projeto_comunicacao_evento_id INTEGER(100) UNSIGNED NOT NULL,
  contato_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (projeto_comunicacao_evento_id, contato_id),
  KEY projeto_comunicacao_evento_id (projeto_comunicacao_evento_id),
  KEY contato_id (contato_id),
  CONSTRAINT projeto_comunicacao_evento_contatos_fk FOREIGN KEY (projeto_comunicacao_evento_id) REFERENCES projeto_comunicacao_evento (projeto_comunicacao_evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_comunicacao_evento_contatos_fk1 FOREIGN KEY (contato_id) REFERENCES contatos (contato_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS projeto_qualidade_entrega;

CREATE TABLE projeto_qualidade_entrega (
  projeto_qualidade_entrega_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  projeto_qualidade_entrega_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_qualidade_entrega_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_qualidade_entrega_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_qualidade_entrega_entrega VARCHAR(255) DEFAULT NULL,
  projeto_qualidade_entrega_criterio MEDIUMTEXT,
  projeto_qualidade_entrega_data DATETIME DEFAULT NULL,
  PRIMARY KEY (projeto_qualidade_entrega_id),
  KEY projeto_qualidade_entrega_projeto (projeto_qualidade_entrega_projeto),
  KEY projeto_qualidade_entrega_usuario (projeto_qualidade_entrega_usuario),
  CONSTRAINT projeto_qualidade_entrega_fk FOREIGN KEY (projeto_qualidade_entrega_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_qualidade_entrega_fk1 FOREIGN KEY (projeto_qualidade_entrega_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS projeto_qualidade;

CREATE TABLE projeto_qualidade (
  projeto_qualidade_projeto INTEGER(100) UNSIGNED NOT NULL,
  projeto_qualidade_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_qualidade_descricao MEDIUMTEXT,
  projeto_qualidade_data DATETIME DEFAULT NULL,
  PRIMARY KEY (projeto_qualidade_projeto),
  KEY projeto_qualidade_usuario (projeto_qualidade_usuario),
  CONSTRAINT projeto_qualidade_fk FOREIGN KEY (projeto_qualidade_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_qualidade_fk1 FOREIGN KEY (projeto_qualidade_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS artefatos_tipo;

CREATE TABLE artefatos_tipo (
  artefato_tipo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  artefato_tipo_nome VARCHAR(64) DEFAULT NULL,
  artefato_tipo_civil VARCHAR(20) DEFAULT NULL,
  artefato_tipo_arquivo VARCHAR(100) DEFAULT NULL,
  artefato_tipo_endereco VARCHAR(200) DEFAULT NULL,
  artefato_tipo_imagem VARCHAR(200) DEFAULT NULL,
  artefato_tipo_descricao MEDIUMTEXT,
  artefato_tipo_campos LONGBLOB,
  artefato_tipo_html MEDIUMTEXT,
  artefato_tipo_campos_bk LONGBLOB,
  artefato_tipo_html_bk MEDIUMTEXT,
  PRIMARY KEY (artefato_tipo_id)
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS demandas;

CREATE TABLE demandas (
  demanda_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  demanda_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  demanda_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  demanda_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  demanda_supervisor INTEGER(100) UNSIGNED DEFAULT NULL,
  demanda_autoridade INTEGER(100) UNSIGNED DEFAULT NULL,
  demanda_cliente INTEGER(100) UNSIGNED DEFAULT NULL,
  demanda_mensurador INTEGER(100) UNSIGNED DEFAULT NULL,
  demanda_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
  demanda_termo_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
  demanda_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  demanda_principal_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  demanda_nome VARCHAR(255) DEFAULT NULL,
  demanda_identificacao MEDIUMTEXT,
  demanda_justificativa MEDIUMTEXT,
  demanda_resultados MEDIUMTEXT,
  demanda_alinhamento MEDIUMTEXT,
  demanda_fonte_recurso MEDIUMTEXT,
  demanda_observacao MEDIUMTEXT,
  demanda_prazo MEDIUMTEXT,
  demanda_custos MEDIUMTEXT,
	demanda_descricao MEDIUMTEXT,
	demanda_objetivos MEDIUMTEXT,
	demanda_como MEDIUMTEXT,
	demanda_localizacao MEDIUMTEXT,
	demanda_beneficiario MEDIUMTEXT,
	demanda_objetivo MEDIUMTEXT,
	demanda_objetivo_especifico MEDIUMTEXT,
	demanda_escopo MEDIUMTEXT,
	demanda_nao_escopo MEDIUMTEXT,
	demanda_premissas MEDIUMTEXT,
	demanda_restricoes MEDIUMTEXT,
	demanda_orcamento MEDIUMTEXT,
	demanda_beneficio MEDIUMTEXT,
	demanda_produto MEDIUMTEXT,
	demanda_requisito MEDIUMTEXT,
  demanda_acesso INTEGER(11) DEFAULT 0,
  demanda_cor VARCHAR(6) DEFAULT 'FFFFFF',
  demanda_ativa TINYINT(1) DEFAULT 0,
  demanda_caracteristica_projeto TINYINT(1) DEFAULT 0,
  demanda_data DATETIME DEFAULT NULL,
  demanda_mensuracao_data DATETIME DEFAULT NULL,
  demanda_complexidade INTEGER(10) DEFAULT 0,
  demanda_custo INTEGER(10) DEFAULT 0,
  demanda_tempo INTEGER(10) DEFAULT 0,
  demanda_servidores INTEGER(10) DEFAULT 0,
  demanda_recurso_externo INTEGER(10) DEFAULT 0,
  demanda_interligacao INTEGER(10) DEFAULT 0,
  demanda_tamanho INTEGER(10) DEFAULT 0,
  demanda_codigo VARCHAR(255) DEFAULT NULL,
  demanda_setor VARCHAR(2) DEFAULT NULL,
	demanda_segmento VARCHAR(4) DEFAULT NULL,
	demanda_intervencao VARCHAR(6) DEFAULT NULL,
	demanda_tipo_intervencao VARCHAR(9) DEFAULT NULL,
	demanda_ano VARCHAR(4) DEFAULT NULL,
	demanda_sequencial INTEGER(100) DEFAULT NULL,
	demanda_cliente_data DATETIME DEFAULT NULL,
	demanda_cliente_aprovado TINYINT(1) DEFAULT 0,
	demanda_cliente_obs TEXT,
	demanda_cliente_ativo TINYINT(1) DEFAULT 0,
	demanda_supervisor_data DATETIME DEFAULT NULL,
	demanda_supervisor_aprovado TINYINT(1) DEFAULT 0,
	demanda_supervisor_obs TEXT,
	demanda_supervisor_ativo TINYINT(1) DEFAULT 0,
	demanda_autoridade_data DATETIME DEFAULT NULL,
	demanda_autoridade_aprovado TINYINT(1) DEFAULT 0,
	demanda_autoridade_obs TEXT,
	demanda_aprovado TINYINT(1) DEFAULT 0,
	demanda_autoridade_ativo TINYINT(1) DEFAULT 0,
	demanda_moeda INTEGER(100) UNSIGNED DEFAULT 1,
  PRIMARY KEY (demanda_id),
  KEY demanda_usuario (demanda_usuario),
  KEY demanda_supervisor (demanda_supervisor),
  KEY demanda_autoridade (demanda_autoridade),
  KEY demanda_cliente (demanda_cliente),
  KEY demanda_mensurador (demanda_mensurador),
  KEY demanda_cia (demanda_cia),
  KEY demanda_dept (demanda_dept),
  KEY demanda_viabilidade (demanda_viabilidade),
  KEY demanda_projeto (demanda_projeto),
  KEY demanda_termo_abertura (demanda_termo_abertura),
  KEY demanda_principal_indicador (demanda_principal_indicador),
  KEY demanda_moeda (demanda_moeda),
  CONSTRAINT demanda_cia FOREIGN KEY (demanda_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT demanda_dept FOREIGN KEY (demanda_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT demanda_usuario FOREIGN KEY (demanda_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT demanda_viabilidade FOREIGN KEY (demanda_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT demanda_projeto FOREIGN KEY (demanda_projeto) REFERENCES projetos (projeto_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT demanda_termo_abertura FOREIGN KEY (demanda_termo_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT demanda_mensurador FOREIGN KEY (demanda_mensurador) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT demanda_supervisor FOREIGN KEY (demanda_supervisor) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT demandas_autoridade FOREIGN KEY (demanda_autoridade) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT demandas_cliente FOREIGN KEY (demanda_cliente) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT demanda_principal_indicador FOREIGN KEY (demanda_principal_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT demanda_moeda FOREIGN KEY (demanda_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS demanda_contatos;

CREATE TABLE demanda_contatos (
  demanda_id INTEGER(100) UNSIGNED NOT NULL,
  contato_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (demanda_id, contato_id),
  KEY demanda_id (demanda_id),
  KEY contato_id (contato_id),
  CONSTRAINT demanda_contatos_fk1 FOREIGN KEY (contato_id) REFERENCES contatos (contato_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT demanda_contatos_fk FOREIGN KEY (demanda_id) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS demanda_usuarios;

CREATE TABLE demanda_usuarios (
  demanda_id INTEGER(100) UNSIGNED NOT NULL,
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (demanda_id, usuario_id),
  KEY demanda_id (demanda_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT demanda_usuarios_fk1 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT demanda_usuarios_fk FOREIGN KEY (demanda_id) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS demanda_depts;

CREATE TABLE demanda_depts (
  demanda_id INTEGER(100) UNSIGNED NOT NULL,
  dept_id INTEGER(100) UNSIGNED NOT NULL,
  KEY demanda_id (demanda_id),
  KEY dept_id (dept_id),
  CONSTRAINT demanda_depts_fk FOREIGN KEY (demanda_id) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT demanda_depts_fk1 FOREIGN KEY (dept_id) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS projeto_viabilidade;

CREATE TABLE projeto_viabilidade (
  projeto_viabilidade_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  projeto_viabilidade_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_viabilidade_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_viabilidade_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_viabilidade_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_viabilidade_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_viabilidade_nome VARCHAR(255),
  projeto_viabilidade_codigo VARCHAR(255),
 	projeto_viabilidade_setor VARCHAR(2) DEFAULT NULL,
	projeto_viabilidade_segmento VARCHAR(4) DEFAULT NULL,
	projeto_viabilidade_intervencao VARCHAR(6) DEFAULT NULL,
	projeto_viabilidade_tipo_intervencao VARCHAR(9) DEFAULT NULL,
	projeto_viabilidade_ano VARCHAR(4) DEFAULT NULL,
	projeto_viabilidade_sequencial INTEGER(100) DEFAULT NULL,
  projeto_viabilidade_necessidade MEDIUMTEXT,
  projeto_viabilidade_alinhamento MEDIUMTEXT,
  projeto_viabilidade_requisitos MEDIUMTEXT,
  projeto_viabilidade_solucoes MEDIUMTEXT,
  projeto_viabilidade_viabilidade_tecnica MEDIUMTEXT,
  projeto_viabilidade_financeira MEDIUMTEXT,
  projeto_viabilidade_institucional MEDIUMTEXT,
  projeto_viabilidade_solucao MEDIUMTEXT,
  projeto_viabilidade_continuidade MEDIUMTEXT,
  projeto_viabilidade_tempo MEDIUMTEXT,
  projeto_viabilidade_custo MEDIUMTEXT,
  projeto_viabilidade_observacao MEDIUMTEXT,
  projeto_viabilidade_acesso INTEGER(11) DEFAULT 0,
  projeto_viabilidade_cor VARCHAR(6) DEFAULT 'FFFFFF',
  projeto_viabilidade_moeda INTEGER(100) UNSIGNED DEFAULT 1,
  projeto_viabilidade_data DATETIME DEFAULT NULL,
  projeto_viabilidade_ativo TINYINT(1) DEFAULT 0,
  projeto_viabilidade_viavel TINYINT(1) DEFAULT 0,
  projeto_viabilidade_aprovado TINYINT(1) DEFAULT 0,
  PRIMARY KEY (projeto_viabilidade_id),
  KEY projeto_viabilidade_cia (projeto_viabilidade_cia),
  KEY projeto_viabilidade_dept (projeto_viabilidade_dept),
  KEY projeto_viabilidade_demanda (projeto_viabilidade_demanda),
  KEY projeto_viabilidade_projeto (projeto_viabilidade_projeto),
  KEY projeto_viabilidade_responsavel (projeto_viabilidade_responsavel),
  KEY projeto_viabilidade_moeda (projeto_viabilidade_moeda),
  CONSTRAINT projeto_viabilidade_cia FOREIGN KEY (projeto_viabilidade_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_viabilidade_dept FOREIGN KEY (projeto_viabilidade_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT projeto_viabilidade_demanda FOREIGN KEY (projeto_viabilidade_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_viabilidade_projeto FOREIGN KEY (projeto_viabilidade_projeto) REFERENCES projetos (projeto_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT projeto_viabilidade_responsavel FOREIGN KEY (projeto_viabilidade_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT projeto_viabilidade_moeda FOREIGN KEY (projeto_viabilidade_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS projeto_viabilidade_dept;

CREATE TABLE projeto_viabilidade_dept (
  projeto_viabilidade_dept_projeto_viabilidade INTEGER(100) UNSIGNED NOT NULL,
  projeto_viabilidade_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (projeto_viabilidade_dept_projeto_viabilidade, projeto_viabilidade_dept_dept),
  KEY projeto_viabilidade_dept_projeto_viabilidade (projeto_viabilidade_dept_projeto_viabilidade),
  KEY projeto_viabilidade_dept_dept (projeto_viabilidade_dept_dept),
  CONSTRAINT projeto_viabilidade_dept_dept FOREIGN KEY (projeto_viabilidade_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_viabilidade_dept_projeto_viabilidade FOREIGN KEY (projeto_viabilidade_dept_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS projeto_viabilidade_cia;

CREATE TABLE projeto_viabilidade_cia (
  projeto_viabilidade_cia_projeto_viabilidade INTEGER(100) UNSIGNED NOT NULL,
  projeto_viabilidade_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (projeto_viabilidade_cia_projeto_viabilidade, projeto_viabilidade_cia_cia),
  KEY projeto_viabilidade_cia_projeto_viabilidade (projeto_viabilidade_cia_projeto_viabilidade),
  KEY projeto_viabilidade_cia_cia (projeto_viabilidade_cia_cia),
  CONSTRAINT projeto_viabilidade_cia_cia FOREIGN KEY (projeto_viabilidade_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_viabilidade_cia_projeto_viabilidade FOREIGN KEY (projeto_viabilidade_cia_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS projeto_viabilidade_usuarios;

CREATE TABLE projeto_viabilidade_usuarios (
  projeto_viabilidade_id INTEGER(100) UNSIGNED NOT NULL,
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (projeto_viabilidade_id, usuario_id),
  KEY projeto_viabilidade_id (projeto_viabilidade_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT projeto_viabilidade_usuarios_fk1 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_viabilidade_usuarios_fk FOREIGN KEY (projeto_viabilidade_id) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS projeto_viabilidade_patrocinadores;

CREATE TABLE projeto_viabilidade_patrocinadores (
  projeto_viabilidade_id INTEGER(100) UNSIGNED NOT NULL,
  contato_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (projeto_viabilidade_id, contato_id),
  KEY projeto_viabilidade_id (projeto_viabilidade_id),
  KEY contato_id (contato_id),
  CONSTRAINT projeto_viabilidade_patrocinadores_fk1 FOREIGN KEY (contato_id) REFERENCES contatos (contato_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_viabilidade_patrocinadores_fk FOREIGN KEY (projeto_viabilidade_id) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS projeto_viabilidade_interessados;

CREATE TABLE projeto_viabilidade_interessados (
  projeto_viabilidade_id INTEGER(100) UNSIGNED NOT NULL,
  contato_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (projeto_viabilidade_id, contato_id),
  KEY projeto_viabilidade_id (projeto_viabilidade_id),
  KEY contato_id (contato_id),
  CONSTRAINT projeto_viabilidade_interessados_fk1 FOREIGN KEY (contato_id) REFERENCES contatos (contato_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_viabilidade_interessados_fk FOREIGN KEY (projeto_viabilidade_id) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS projeto_abertura;

CREATE TABLE projeto_abertura (
  projeto_abertura_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  projeto_abertura_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_abertura_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_abertura_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_abertura_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_abertura_nome VARCHAR(255) DEFAULT NULL,
  projeto_abertura_codigo VARCHAR(255) DEFAULT NULL,
  projeto_abertura_setor VARCHAR(2) DEFAULT NULL,
	projeto_abertura_segmento VARCHAR(4) DEFAULT NULL,
	projeto_abertura_intervencao VARCHAR(6) DEFAULT NULL,
	projeto_abertura_tipo_intervencao VARCHAR(9) DEFAULT NULL,
	projeto_abertura_ano VARCHAR(4) DEFAULT NULL,
	projeto_abertura_sequencial INTEGER(100) DEFAULT NULL,
 	projeto_abertura_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
 	projeto_abertura_autoridade INTEGER(100) UNSIGNED DEFAULT NULL,
 	projeto_abertura_gerente_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
 	projeto_abertura_acesso INTEGER(11) DEFAULT 0,
 	projeto_abertura_justificativa MEDIUMTEXT,
	projeto_abertura_objetivo MEDIUMTEXT,
	projeto_abertura_escopo MEDIUMTEXT,
	projeto_abertura_nao_escopo MEDIUMTEXT,
	projeto_abertura_tempo MEDIUMTEXT,
	projeto_abertura_custo MEDIUMTEXT,
	projeto_abertura_premissas MEDIUMTEXT,
	projeto_abertura_restricoes MEDIUMTEXT,
	projeto_abertura_riscos MEDIUMTEXT,
 	projeto_abertura_infraestrutura MEDIUMTEXT,
 	projeto_abertura_observacao MEDIUMTEXT,
	projeto_abertura_descricao MEDIUMTEXT,
	projeto_abertura_objetivos MEDIUMTEXT,
	projeto_abertura_como MEDIUMTEXT,
	projeto_abertura_localizacao MEDIUMTEXT,
	projeto_abertura_beneficiario MEDIUMTEXT,
	projeto_abertura_objetivo_especifico MEDIUMTEXT,
	projeto_abertura_orcamento MEDIUMTEXT,
	projeto_abertura_beneficio MEDIUMTEXT,
	projeto_abertura_produto MEDIUMTEXT,
	projeto_abertura_requisito MEDIUMTEXT,
 	projeto_abertura_aprovacao MEDIUMTEXT,
 	projeto_abertura_recusa MEDIUMTEXT,
 	projeto_abertura_moeda INTEGER(100) UNSIGNED DEFAULT 1,
  projeto_abertura_cor VARCHAR(6) DEFAULT 'FFFFFF',
  projeto_abertura_aprovado TINYINT(1) DEFAULT 0,
  projeto_abertura_data DATETIME DEFAULT NULL,
  projeto_abertura_ativo TINYINT(1) DEFAULT 1,
  PRIMARY KEY (projeto_abertura_id),
  KEY projeto_abertura_cia (projeto_abertura_cia),
  KEY projeto_abertura_dept (projeto_abertura_dept),
  KEY projeto_abertura_demanda (projeto_abertura_demanda),
  KEY projeto_abertura_projeto (projeto_abertura_projeto),
  KEY projeto_abertura_responsavel (projeto_abertura_responsavel),
  KEY projeto_abertura_moeda (projeto_abertura_moeda),
  CONSTRAINT projeto_abertura_cia FOREIGN KEY (projeto_abertura_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_abertura_dept FOREIGN KEY (projeto_abertura_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT projeto_abertura_demanda FOREIGN KEY (projeto_abertura_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_abertura_projeto FOREIGN KEY (projeto_abertura_projeto) REFERENCES projetos (projeto_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT projeto_abertura_responsavel FOREIGN KEY (projeto_abertura_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT projeto_abertura_gerente_projeto FOREIGN KEY (projeto_abertura_gerente_projeto) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT projeto_abertura_autoridade FOREIGN KEY (projeto_abertura_autoridade) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT projeto_abertura_moeda FOREIGN KEY (projeto_abertura_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS projeto_abertura_dept;

CREATE TABLE projeto_abertura_dept (
  projeto_abertura_dept_projeto_abertura INTEGER(100) UNSIGNED NOT NULL,
  projeto_abertura_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (projeto_abertura_dept_projeto_abertura, projeto_abertura_dept_dept),
  KEY projeto_abertura_dept_projeto_abertura (projeto_abertura_dept_projeto_abertura),
  KEY projeto_abertura_dept_dept (projeto_abertura_dept_dept),
  CONSTRAINT projeto_abertura_dept_dept FOREIGN KEY (projeto_abertura_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_abertura_dept_projeto_abertura FOREIGN KEY (projeto_abertura_dept_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS projeto_abertura_cia;

CREATE TABLE projeto_abertura_cia (
  projeto_abertura_cia_projeto_abertura INTEGER(100) UNSIGNED NOT NULL,
  projeto_abertura_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (projeto_abertura_cia_projeto_abertura, projeto_abertura_cia_cia),
  KEY projeto_abertura_cia_projeto_abertura (projeto_abertura_cia_projeto_abertura),
  KEY projeto_abertura_cia_cia (projeto_abertura_cia_cia),
  CONSTRAINT projeto_abertura_cia_cia FOREIGN KEY (projeto_abertura_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_abertura_cia_projeto_abertura FOREIGN KEY (projeto_abertura_cia_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS projeto_abertura_usuarios;

CREATE TABLE projeto_abertura_usuarios (
  projeto_abertura_id INTEGER(100) UNSIGNED NOT NULL,
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (projeto_abertura_id, usuario_id),
  KEY projeto_abertura_id (projeto_abertura_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT projeto_abertura_usuarios_fk1 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_abertura_usuarios_fk FOREIGN KEY (projeto_abertura_id) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS projeto_abertura_patrocinadores;

CREATE TABLE projeto_abertura_patrocinadores (
  projeto_abertura_id INTEGER(100) UNSIGNED NOT NULL,
  contato_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (projeto_abertura_id, contato_id),
  KEY projeto_abertura_id (projeto_abertura_id),
  KEY contato_id (contato_id),
  CONSTRAINT projeto_abertura_patrocinadores_fk1 FOREIGN KEY (contato_id) REFERENCES contatos (contato_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_abertura_patrocinadores_fk FOREIGN KEY (projeto_abertura_id) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS projeto_abertura_interessados;

CREATE TABLE projeto_abertura_interessados (
  projeto_abertura_id INTEGER(100) UNSIGNED NOT NULL,
  contato_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (projeto_abertura_id, contato_id),
  KEY projeto_abertura_id (projeto_abertura_id),
  KEY contato_id (contato_id),
  CONSTRAINT projeto_abertura_interessados_fk1 FOREIGN KEY (contato_id) REFERENCES contatos (contato_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_abertura_interessados_fk FOREIGN KEY (projeto_abertura_id) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS cias;

CREATE TABLE cias (
  cia_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  cia_superior INTEGER(100) UNSIGNED DEFAULT NULL,
  cia_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  cia_nome VARCHAR(100) DEFAULT NULL,
  cia_nome_completo VARCHAR(200) DEFAULT NULL,
  cia_codigo VARCHAR(50) DEFAULT NULL,
  cia_cnpj VARCHAR(18) DEFAULT NULL,
	cia_inscricao_estadual VARCHAR(25) DEFAULT NULL,
  cia_tel1 VARCHAR(15) DEFAULT NULL,
  cia_tel2 VARCHAR(15) DEFAULT NULL,
  cia_fax VARCHAR(15) DEFAULT NULL,
  cia_endereco1 VARCHAR(255) DEFAULT NULL,
  cia_endereco2 VARCHAR(255) DEFAULT NULL,
  cia_cidade INTEGER(100) DEFAULT NULL,
  cia_estado VARCHAR(30) DEFAULT NULL,
  cia_cep VARCHAR(9) DEFAULT NULL,
  cia_pais VARCHAR(30) DEFAULT NULL,
  cia_url VARCHAR(255) DEFAULT NULL,
  cia_descricao MEDIUMTEXT,
  cia_tipo INTEGER(3) DEFAULT 0,
  cia_email VARCHAR(60) DEFAULT NULL,
  cia_contatos VARCHAR(255) DEFAULT NULL,
  cia_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  cia_cabacalho TEXT,
  cia_ug VARCHAR(6) DEFAULT NULL,
  cia_ug2 VARCHAR(6) DEFAULT NULL,
  cia_nup VARCHAR(5) DEFAULT NULL,
  cia_qnt_nup INTEGER(6) UNSIGNED DEFAULT 0,
  cia_qnt_nr INTEGER(20) UNSIGNED DEFAULT 0,
  cia_prefixo VARCHAR(30) DEFAULT NULL,
  cia_sufixo VARCHAR(30) DEFAULT NULL,
  cia_logo VARCHAR(255) DEFAULT NULL,
  cia_ativo TINYINT(1) DEFAULT 1,
  PRIMARY KEY (cia_id),
  KEY cia_superior (cia_superior),
  KEY cia_responsavel (cia_responsavel),
  CONSTRAINT cias_fk FOREIGN KEY (cia_superior) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT cias_fk1 FOREIGN KEY (cia_responsavel) REFERENCES contatos (contato_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS cia_usuario;

CREATE TABLE cia_usuario (
  cia_usuario_cia INTEGER(100) UNSIGNED NOT NULL,
  cia_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (cia_usuario_cia, cia_usuario_usuario),
  KEY cia_usuario_cia (cia_usuario_cia),
  KEY cia_usuario_usuario (cia_usuario_usuario),
  CONSTRAINT cia_usuario_cia FOREIGN KEY (cia_usuario_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT cia_usuario_usuario FOREIGN KEY (cia_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB;


DROP TABLE IF EXISTS depts;

CREATE TABLE depts (
  dept_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  dept_superior INTEGER(100) UNSIGNED DEFAULT NULL,
  dept_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  dept_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  dept_nome VARCHAR(255) DEFAULT NULL,
  dept_codigo VARCHAR(50) DEFAULT NULL,
  dept_tel VARCHAR(15) DEFAULT NULL,
  dept_fax VARCHAR(15) DEFAULT NULL,
  dept_endereco1 VARCHAR(255) DEFAULT NULL,
  dept_endereco2 VARCHAR(255) DEFAULT NULL,
  dept_cidade VARCHAR(255) DEFAULT NULL,
  dept_estado VARCHAR(30) DEFAULT NULL,
  dept_cep VARCHAR(9) DEFAULT NULL,
  dept_url VARCHAR(255) DEFAULT NULL,
  dept_descricao MEDIUMTEXT,
  dept_pais VARCHAR(30) DEFAULT NULL,
  dept_email VARCHAR(60) DEFAULT NULL,
  dept_tipo INTEGER(3) UNSIGNED DEFAULT 0,
  dept_contatos VARCHAR(255) DEFAULT NULL,
  dept_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  dept_nup VARCHAR(5) DEFAULT NULL,
  dept_qnt_nr INTEGER(20) UNSIGNED DEFAULT 0,
  dept_prefixo VARCHAR(30) DEFAULT NULL,
  dept_sufixo VARCHAR(30) DEFAULT NULL,
  dept_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  dept_ativo TINYINT(1) DEFAULT 1,
  PRIMARY KEY (dept_id),
  KEY dept_superior (dept_superior),
  KEY dept_nome (dept_nome),
  KEY dept_cia (dept_cia),
  KEY dept_responsavel (dept_responsavel),
  CONSTRAINT depts_fk FOREIGN KEY (dept_superior) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT depts_fk1 FOREIGN KEY (dept_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT depts_fk2 FOREIGN KEY (dept_responsavel) REFERENCES contatos (contato_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS contatos;

CREATE TABLE contatos (
  contato_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  contato_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  contato_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  contato_dono INTEGER(100) UNSIGNED DEFAULT NULL,
  contato_posto_valor INTEGER(3) DEFAULT 0,
  contato_posto VARCHAR(30) DEFAULT NULL,
  contato_nomeguerra VARCHAR(100) DEFAULT NULL,
  contato_nomecompleto VARCHAR(255) DEFAULT NULL,
  contato_ordem VARCHAR(30) DEFAULT NULL,
  contato_arma VARCHAR(50) DEFAULT NULL,
  contato_nascimento DATE DEFAULT NULL,
  contato_funcao VARCHAR(255) DEFAULT NULL,
  contato_codigo VARCHAR(50) DEFAULT NULL,
  contato_tipo VARCHAR(20) DEFAULT NULL,
  contato_matricula VARCHAR(100) DEFAULT NULL,
  contato_identidade VARCHAR(25) DEFAULT NULL,
  contato_cpf VARCHAR(14) DEFAULT NULL,
  contato_cnpj VARCHAR(18) DEFAULT NULL,
  contato_email VARCHAR(60) DEFAULT NULL,
  contato_email2 VARCHAR(60) DEFAULT NULL,
  contato_url VARCHAR(255) DEFAULT NULL,
  contato_tel VARCHAR(15) DEFAULT NULL,
  contato_tel2 VARCHAR(15) DEFAULT NULL,
  contato_cel VARCHAR(14) DEFAULT NULL,
  contato_endereco1 VARCHAR(60) DEFAULT NULL,
  contato_endereco2 VARCHAR(60) DEFAULT NULL,
  contato_cidade VARCHAR(7) DEFAULT NULL,
  contato_estado VARCHAR(2) DEFAULT NULL,
  contato_cep VARCHAR(9) DEFAULT NULL,
  contato_pais VARCHAR(30) DEFAULT NULL,
  contato_notas MEDIUMTEXT,
  contato_skype VARCHAR(100) DEFAULT NULL,
	contato_religiao INTEGER(10) DEFAULT 0,
	contato_sangue varchar(3) DEFAULT NULL,
	contato_vivo INTEGER(1) DEFAULT 1,
	contato_natural_cidade VARCHAR(7) DEFAULT NULL,
	contato_natural_estado VARCHAR(2) DEFAULT NULL,
	contato_natural_pais VARCHAR(30) DEFAULT 'BR',
	contato_grau_instrucao INTEGER(10) DEFAULT 0,
	contato_formacao VARCHAR(100) DEFAULT NULL,
	contato_profissao VARCHAR(100) DEFAULT NULL,
	contato_ocupacao VARCHAR(100) DEFAULT NULL,
	contato_especialidade VARCHAR(100) DEFAULT NULL,
  contato_icone VARCHAR(20) DEFAULT 'obj/contato',
  contato_privado TINYINT(3) UNSIGNED DEFAULT 0,
  contato_chave_atualizacao VARCHAR(32) DEFAULT NULL,
  contato_ultima_atualizacao DATETIME DEFAULT NULL,
  contato_pedido_atualizacao DATETIME DEFAULT NULL,
  contato_hora_custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
  contato_foto VARCHAR(255) DEFAULT NULL,
  contato_ativo INTEGER(1) DEFAULT 1,
  PRIMARY KEY (contato_id),
  KEY idx_ordem (contato_ordem),
  KEY idx_co (contato_cia),
  KEY contato_posto (contato_posto),
  KEY contato_nomeguerra (contato_nomeguerra),
  KEY contato_chave_atualizacao (contato_chave_atualizacao),
  KEY contato_email (contato_email),
  KEY contato_privado (contato_privado),
  KEY contato_dept (contato_dept),
  KEY contato_dono (contato_dono),
  CONSTRAINT contatos_fk2 FOREIGN KEY (contato_dono) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT contatos_fk FOREIGN KEY (contato_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT contatos_fk1 FOREIGN KEY (contato_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS usuarios;

CREATE TABLE usuarios (
  usuario_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  usuario_contato INTEGER(100) UNSIGNED DEFAULT NULL,
  usuario_login VARCHAR(255) DEFAULT NULL,
  usuario_senha VARCHAR(32) DEFAULT NULL,
  usuario_grupo_dept TINYINT(1) DEFAULT 0,
  usuario_acesso_email TINYINT(3) DEFAULT 0,
  usuario_pode_oculta INTEGER(1) DEFAULT 1,
  usuario_rodape MEDIUMTEXT,
  usuario_chavepublica TEXT,
  usuario_especial INTEGER(1) DEFAULT 0,
  usuario_ativo INTEGER(1) DEFAULT 1,
  usuario_admin TINYINT(1) DEFAULT 0,
  usuario_observador TINYINT(1) DEFAULT 0,
  usuario_login2 VARCHAR(255) DEFAULT NULL,
  usuario_senha2 VARCHAR(32) DEFAULT NULL,
  usuario_assinatura_nome VARCHAR(255) DEFAULT NULL,
  usuario_assinatura_local VARCHAR(255) DEFAULT NULL,
  usuario_contas VARCHAR(255) DEFAULT NULL,
  usuario_frase varchar(255) DEFAULT NULL,
	usuario_resposta varchar(255) DEFAULT NULL,
  PRIMARY KEY (usuario_id),
  KEY idx_uid (usuario_login),
  KEY idx_senha (usuario_senha),
  KEY usuario_contato (usuario_contato),
  CONSTRAINT usuarios_fk FOREIGN KEY (usuario_contato) REFERENCES contatos (contato_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS agenda_tipo;

CREATE TABLE agenda_tipo (
  agenda_tipo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  usuario_id INTEGER(100) UNSIGNED,
  nome VARCHAR(20) DEFAULT NULL,
  cor VARCHAR(6) DEFAULT 'fff0b0',
  PRIMARY KEY (agenda_tipo_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT agenda_tipo_fk FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS agenda;

CREATE TABLE agenda (
  agenda_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  agenda_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  agenda_dono INTEGER(100) UNSIGNED DEFAULT NULL,
  agenda_recorrencia_pai INTEGER(100) UNSIGNED DEFAULT NULL,
  agenda_principal_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  agenda_tipo INTEGER(100) UNSIGNED DEFAULT NULL,
  agenda_titulo VARCHAR(255) DEFAULT NULL,
  agenda_inicio DATETIME DEFAULT NULL,
  agenda_fim DATETIME DEFAULT NULL,
  agenda_duracao DECIMAL(20,5) UNSIGNED DEFAULT NULL,
  agenda_descricao MEDIUMTEXT,
  agenda_oque TEXT,
	agenda_onde TEXT,
	agenda_quando TEXT,
	agenda_como TEXT,
	agenda_porque TEXT,
	agenda_quanto TEXT,
	agenda_quem TEXT,
  agenda_url VARCHAR(255) DEFAULT NULL,
  agenda_nr_recorrencias INTEGER(100) UNSIGNED DEFAULT NULL,
  agenda_recorrencias INTEGER(100) UNSIGNED DEFAULT NULL,
  agenda_lembrar INTEGER(100) UNSIGNED DEFAULT NULL,
  agenda_icone VARCHAR(20) DEFAULT 'obj/agenda',
  agenda_diautil TINYINT(3) DEFAULT 0,
  agenda_notificar TINYINT(3) DEFAULT 0,
  agenda_localizacao VARCHAR(255) DEFAULT NULL,
  agenda_moeda INTEGER(100) UNSIGNED DEFAULT 1,
  agenda_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  agenda_cor VARCHAR(6) DEFAULT 'fff0b0',
  agenda_ativo INTEGER(1) DEFAULT 1,
  agenda_uid VARCHAR(255) DEFAULT NULL,
  PRIMARY KEY (agenda_id),
  KEY agenda_inicio (agenda_inicio),
  KEY agenda_fim (agenda_fim),
  KEY agenda_dono (agenda_dono),
  KEY agenda_recorrencia_pai (agenda_recorrencia_pai),
  KEY agenda_recorrencias (agenda_recorrencias),
  KEY agenda_cia (agenda_cia),
  KEY agenda_principal_indicador (agenda_principal_indicador),
  KEY agenda_moeda (agenda_moeda),
  CONSTRAINT agenda_cia FOREIGN KEY (agenda_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT agenda_dono FOREIGN KEY (agenda_dono) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT agenda_recorrencia_pai FOREIGN KEY (agenda_recorrencia_pai) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT agenda_principal_indicador FOREIGN KEY (agenda_principal_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT agenda_moeda FOREIGN KEY (agenda_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT agenda_tipo FOREIGN KEY (agenda_tipo) REFERENCES agenda_tipo (agenda_tipo_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS agenda_dept;

CREATE TABLE agenda_dept (
  agenda_dept_agenda INTEGER(100) UNSIGNED NOT NULL,
  agenda_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (agenda_dept_agenda, agenda_dept_dept),
  KEY agenda_dept_agenda (agenda_dept_agenda),
  KEY agenda_dept_dept (agenda_dept_dept),
  CONSTRAINT agenda_dept_dept FOREIGN KEY (agenda_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT agenda_dept_agenda FOREIGN KEY (agenda_dept_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS agenda_usuarios;

CREATE TABLE agenda_usuarios (
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  agenda_id INTEGER(100) UNSIGNED NOT NULL,
  aceito TINYINT(3) DEFAULT 0,
  data DATETIME DEFAULT NULL,
  PRIMARY KEY (usuario_id, agenda_id),
  KEY uek2 (agenda_id, usuario_id),
  KEY usuario_id (usuario_id),
  KEY agenda_id (agenda_id),
  CONSTRAINT agenda_usuarios_fk1 FOREIGN KEY (agenda_id) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT agenda_usuarios_fk FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS alteracoes;

CREATE TABLE alteracoes (
  alteracao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  responsavel INTEGER(100) UNSIGNED,
  campo VARCHAR(20) DEFAULT NULL,
  chave INTEGER(100) UNSIGNED,
  data DATETIME DEFAULT NULL,
  vetor BLOB,
  diferente BLOB,
  PRIMARY KEY (alteracao_id),
  KEY responsavel (responsavel),
  CONSTRAINT alteracoes_fk FOREIGN KEY (responsavel) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS chaves_publicas;

CREATE TABLE chaves_publicas (
  chave_publica_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  chave_publica_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  chave_publica_chave TEXT,
  chave_publica_certificado TEXT,
  chave_publica_data DATETIME DEFAULT NULL,
  PRIMARY KEY (chave_publica_id),
  KEY idx_usu (chave_publica_usuario),
  CONSTRAINT chaves_publicas_fk FOREIGN KEY (chave_publica_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS msg;

CREATE TABLE msg (
  msg_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  de_id INTEGER(100) UNSIGNED DEFAULT NULL,
  msg_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  msg_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  msg_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
  msg_acao INTEGER(100) UNSIGNED DEFAULT NULL,
  msg_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
  msg_tema INTEGER(100) UNSIGNED DEFAULT NULL,
  msg_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
  msg_fator INTEGER(100) UNSIGNED DEFAULT NULL,
  msg_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
  msg_meta INTEGER(100) UNSIGNED DEFAULT NULL,
  msg_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  msg_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
  msg_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
  msg_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
  chave_publica INTEGER(100) UNSIGNED DEFAULT NULL,
  precedencia INTEGER(2) DEFAULT 0,
  class_sigilosa INTEGER(2) DEFAULT 0,
  referencia VARCHAR(255) DEFAULT NULL,
  texto MEDIUMTEXT,
  cripto INTEGER(2) DEFAULT 0,
  cm VARCHAR(5) DEFAULT NULL,
  data_envio DATETIME DEFAULT NULL,
  nome_de VARCHAR(50) DEFAULT NULL,
  funcao_de VARCHAR(50) DEFAULT NULL,
  assinatura TEXT,
  PRIMARY KEY (msg_id),
  KEY de_id (de_id),
  KEY chave_publica (chave_publica),
  KEY msg_projeto (msg_projeto),
  KEY msg_tarefa (msg_tarefa),
  KEY msg_pratica (msg_pratica),
  KEY msg_indicador (msg_indicador),
  KEY msg_acao (msg_acao),
  KEY msg_objetivo (msg_objetivo),
  KEY msg_fator (msg_fator),
  KEY msg_estrategia (msg_estrategia),
  KEY msg_meta (msg_meta),
  KEY msg_perspectiva (msg_perspectiva),
  KEY msg_tema (msg_tema),
  KEY msg_monitoramento (msg_monitoramento),
  KEY msg_operativo (msg_operativo),
  KEY msg_canvas (msg_canvas),
  CONSTRAINT de_id FOREIGN KEY (de_id) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT chave_publica FOREIGN KEY (chave_publica) REFERENCES chaves_publicas (chave_publica_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT msg_estrategia FOREIGN KEY (msg_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT msg_meta FOREIGN KEY (msg_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT msg_tema FOREIGN KEY (msg_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT msg_projeto FOREIGN KEY (msg_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT msg_tarefa FOREIGN KEY (msg_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT msg_pratica FOREIGN KEY (msg_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT msg_acao FOREIGN KEY (msg_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT msg_indicador FOREIGN KEY (msg_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT msg_objetivo FOREIGN KEY (msg_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT msg_fator FOREIGN KEY (msg_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT msg_monitoramento FOREIGN KEY (msg_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT msg_operativo FOREIGN KEY (msg_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT msg_perspectiva FOREIGN KEY (msg_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT msg_canvas FOREIGN KEY (msg_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS msg_tarefa_historico;

CREATE TABLE msg_tarefa_historico (
  msg_tarefa_historico_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  msg_usuario_id INTEGER(100) UNSIGNED NOT NULL,
  data DATETIME DEFAULT NULL,
  progresso INTEGER(2) DEFAULT 0,
  PRIMARY KEY (msg_tarefa_historico_id),
  KEY msg_usuario_id (msg_usuario_id),
  CONSTRAINT msg_tarefa_historico_fk FOREIGN KEY (msg_usuario_id) REFERENCES msg_usuario (msg_usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS anexo;

CREATE TABLE anexo (
	anexo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	anexo_msg INTEGER(100) UNSIGNED DEFAULT NULL,
	anexo_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
	anexo_modelo INTEGER(100) UNSIGNED DEFAULT NULL,
	anexo_chave_publica INTEGER(100) UNSIGNED DEFAULT NULL,
	anexo_nome VARCHAR(255) DEFAULT NULL,
	anexo_caminho VARCHAR(255) DEFAULT NULL,
	anexo_tipo_doc VARCHAR(80) DEFAULT NULL,
	anexo_doc_nr VARCHAR(10) DEFAULT NULL,
	anexo_nome_de VARCHAR(50) DEFAULT NULL,
	anexo_funcao_de VARCHAR(30) DEFAULT NULL,
	anexo_data_envio DATETIME DEFAULT NULL,
	anexo_assinatura TEXT,
	anexo_nome_fantasia VARCHAR(255) DEFAULT NULL,
	anexo_nome_real VARCHAR(255) DEFAULT NULL,
	anexo_local VARCHAR(255) DEFAULT NULL,
	anexo_tamanho INTEGER(100) UNSIGNED DEFAULT NULL,
	anexo_tipo VARCHAR(50) DEFAULT NULL,
	anexo_extensao VARCHAR(50) DEFAULT NULL,
	anexo_ordem INTEGER(11) DEFAULT 0,	
	PRIMARY KEY (anexo_id),
	KEY anexo_msg (anexo_msg),
	KEY anexo_usuario (anexo_usuario),
	KEY anexo_modelo (anexo_modelo),
	KEY anexo_chave_publica (anexo_chave_publica),
	CONSTRAINT anexo_chave_publica FOREIGN KEY (anexo_chave_publica) REFERENCES chaves_publicas (chave_publica_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT anexo_modelo FOREIGN KEY (anexo_modelo) REFERENCES modelos (modelo_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT anexo_msg FOREIGN KEY (anexo_msg) REFERENCES msg (msg_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT anexo_usuario FOREIGN KEY (anexo_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS anexo_leitura;

CREATE TABLE anexo_leitura (
  anexo_leitura_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  anexo_id INTEGER(100) UNSIGNED DEFAULT NULL,
  usuario_id INTEGER(100) UNSIGNED DEFAULT NULL,
  datahora_leitura DATETIME DEFAULT NULL,
  download SMALLINT(1) DEFAULT 0,
  PRIMARY KEY (anexo_leitura_id),
  KEY anexo_id (anexo_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT anexo_leitura_fk1 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT anexo_leitura_anexo FOREIGN KEY (anexo_id) REFERENCES anexo (anexo_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS anotacao;

CREATE TABLE anotacao (
  anotacao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  msg_id INTEGER(100) UNSIGNED DEFAULT NULL,
  msg_usuario_id INTEGER(100) UNSIGNED DEFAULT NULL,
  usuario_id INTEGER(100) UNSIGNED DEFAULT NULL,
  chave_publica INTEGER(100) UNSIGNED DEFAULT NULL,
  datahora DATETIME DEFAULT NULL,
  texto MEDIUMTEXT,
  tipo INTEGER(2) DEFAULT 0,
  nome_de VARCHAR(50) DEFAULT NULL,
  funcao_de VARCHAR(30) DEFAULT NULL,
  anotacao_usuarios INTEGER(1) DEFAULT 0,
  assinatura TEXT,
  PRIMARY KEY (anotacao_id),
  KEY msg_id (msg_id),
  KEY msg_usuario_id (msg_usuario_id),
  KEY usuario_id (usuario_id),
  KEY chave_publica (chave_publica),
  CONSTRAINT anotacao_fk FOREIGN KEY (msg_id) REFERENCES msg (msg_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT anotacao_fk1 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT anotacao_fk2 FOREIGN KEY (msg_usuario_id) REFERENCES msg_usuario (msg_usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT anotacao_fk3 FOREIGN KEY (chave_publica) REFERENCES chaves_publicas (chave_publica_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS anotacao_usuario;

CREATE TABLE anotacao_usuario (
  anotacao_usuario_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  anotacao_usuario_anotacao INTEGER(100) UNSIGNED DEFAULT NULL,
  anotacao_usuario_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (anotacao_usuario_id),
  KEY anotacao_usuario_anotacao (anotacao_usuario_anotacao),
  KEY anotacao_usuario_usuario (anotacao_usuario_usuario),
  CONSTRAINT anotacao_usuario_anotacao FOREIGN KEY (anotacao_usuario_anotacao) REFERENCES anotacao (anotacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT anotacao_usuario_usuario FOREIGN KEY (anotacao_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS perspectivas;

CREATE TABLE perspectivas (
  pg_perspectiva_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pg_perspectiva_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_perspectiva_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_perspectiva_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_perspectiva_principal_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_perspectiva_ativo TINYINT(1) DEFAULT 1,
  pg_perspectiva_nome VARCHAR(255) DEFAULT NULL,
  pg_perspectiva_cor VARCHAR(6) DEFAULT 'FFFFFF',
  pg_perspectiva_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_perspectiva_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  pg_perspectiva_oque TEXT,
  pg_perspectiva_descricao MEDIUMTEXT,
  pg_perspectiva_onde TEXT,
  pg_perspectiva_quando TEXT,
  pg_perspectiva_como TEXT,
  pg_perspectiva_porque TEXT,
  pg_perspectiva_quanto TEXT,
  pg_perspectiva_quem TEXT,
  pg_perspectiva_controle TEXT,
  pg_perspectiva_melhorias TEXT,
  pg_perspectiva_metodo_aprendizado TEXT,
  pg_perspectiva_desde_quando TEXT,
  pg_perspectiva_tipo VARCHAR(50) DEFAULT NULL,
	pg_perspectiva_tipo_pontuacao VARCHAR(40) DEFAULT NULL,
	pg_perspectiva_percentagem DECIMAL(20,5) UNSIGNED DEFAULT 0,
	pg_perspectiva_ponto_alvo DECIMAL(20,5) UNSIGNED DEFAULT 0,
	pg_perspectiva_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
	pg_perspectiva_aprovado TINYINT(1) DEFAULT 0,
  PRIMARY KEY (pg_perspectiva_id),
  KEY pg_perspectiva_cia (pg_perspectiva_cia),
  KEY pg_perspectiva_dept (pg_perspectiva_dept),
  KEY pg_perspectiva_usuario (pg_perspectiva_usuario),
  KEY pg_perspectiva_principal_indicador (pg_perspectiva_principal_indicador),
  KEY pg_perspectiva_moeda (pg_perspectiva_moeda),
  CONSTRAINT perspectivas_fk FOREIGN KEY (pg_perspectiva_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT perspectivas_fk1 FOREIGN KEY (pg_perspectiva_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT pg_perspectiva_dept FOREIGN KEY (pg_perspectiva_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT perspectivas_indicador FOREIGN KEY (pg_perspectiva_principal_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT pg_perspectiva_moeda FOREIGN KEY (pg_perspectiva_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE 
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS objetivo;

CREATE TABLE objetivo (
  objetivo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  objetivo_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  objetivo_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  objetivo_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
  objetivo_tema INTEGER(100) UNSIGNED DEFAULT NULL,
  objetivo_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  objetivo_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  objetivo_nome TEXT,
  objetivo_data DATETIME DEFAULT NULL,
  objetivo_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  objetivo_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  objetivo_cor VARCHAR(6) DEFAULT 'FFFFFF',
  objetivo_oque TEXT,
  objetivo_descricao MEDIUMTEXT,
  objetivo_onde TEXT,
  objetivo_quando TEXT,
  objetivo_como TEXT,
  objetivo_porque TEXT,
  objetivo_quanto TEXT,
  objetivo_quem TEXT,
  objetivo_controle TEXT,
  objetivo_melhorias TEXT,
  objetivo_metodo_aprendizado TEXT,
  objetivo_desde_quando TEXT,
  objetivo_ativo TINYINT(1) DEFAULT 1,
  objetivo_tipo VARCHAR(50) DEFAULT NULL,
  objetivo_percentagem DECIMAL(20,5) UNSIGNED DEFAULT 0,
	objetivo_tipo_pontuacao VARCHAR(40) DEFAULT NULL,
	objetivo_ponto_alvo DECIMAL(20,5) UNSIGNED DEFAULT 0,
	objetivo_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
	objetivo_aprovado TINYINT(1) DEFAULT 0,
  PRIMARY KEY (objetivo_id),
  KEY objetivo_cia (objetivo_cia),
  KEY objetivo_dept (objetivo_dept),
  KEY objetivo_usuario (objetivo_usuario),
  KEY objetivo_perspectiva (objetivo_perspectiva),
  KEY objetivo_tema (objetivo_tema),
  KEY objetivo_indicador (objetivo_indicador),
  KEY objetivo_moeda (objetivo_moeda),
  CONSTRAINT objetivo_cia FOREIGN KEY (objetivo_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT objetivo_usuario FOREIGN KEY (objetivo_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT objetivo_perspectiva FOREIGN KEY (objetivo_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT objetivo_tema FOREIGN KEY (objetivo_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT objetivo_indicador FOREIGN KEY (objetivo_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT objetivo_dept FOREIGN KEY (objetivo_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT objetivo_moeda FOREIGN KEY (objetivo_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS fator;

CREATE TABLE fator (
  fator_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  fator_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  fator_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  fator_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
  fator_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  fator_principal_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  fator_nome TEXT,
  fator_data DATETIME DEFAULT NULL,
  fator_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  fator_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  fator_cor VARCHAR(6) DEFAULT 'FFFFFF',
  fator_oque TEXT,
  fator_descricao MEDIUMTEXT,
  fator_onde TEXT,
  fator_quando TEXT,
  fator_como TEXT,
  fator_porque TEXT,
  fator_quanto TEXT,
  fator_quem TEXT,
  fator_controle TEXT,
  fator_melhorias TEXT,
  fator_metodo_aprendizado TEXT,
  fator_desde_quando TEXT,
  fator_ativo TINYINT(1) DEFAULT 1,
  fator_tipo VARCHAR(50) DEFAULT NULL,
  fator_percentagem DECIMAL(20,5) UNSIGNED DEFAULT 0,
  fator_tipo_pontuacao VARCHAR(40) DEFAULT NULL,
  fator_ponto_alvo DECIMAL(20,5) UNSIGNED DEFAULT 0,
  fator_moeda INTEGER(100) UNSIGNED DEFAULT 1,
  fator_aprovado TINYINT(1) DEFAULT 0,
  PRIMARY KEY (fator_id),
  KEY fator_cia (fator_cia),
  KEY fator_dept (fator_dept),
  KEY fator_usuario (fator_usuario),
  KEY fator_objetivo (fator_objetivo),
  KEY fator_principal_indicador (fator_principal_indicador),
  KEY fator_moeda (fator_moeda),
  CONSTRAINT fator_cia FOREIGN KEY (fator_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT fator_usuario FOREIGN KEY (fator_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT fator_objetivo FOREIGN KEY (fator_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT fator_principal_indicador FOREIGN KEY (fator_principal_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT fator_dept FOREIGN KEY (fator_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT fator_moeda FOREIGN KEY (fator_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS estrategias;

CREATE TABLE estrategias (
  pg_estrategia_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pg_estrategia_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_estrategia_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_estrategia_fator INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_estrategia_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_estrategia_principal_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_estrategia_nome TEXT,
  pg_estrategia_data DATETIME DEFAULT NULL,
  pg_estrategia_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_estrategia_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  pg_estrategia_cor VARCHAR(6) DEFAULT 'FFFFFF',
  pg_estrategia_oque MEDIUMTEXT,
  pg_estrategia_descricao MEDIUMTEXT,
  pg_estrategia_onde MEDIUMTEXT,
  pg_estrategia_quando MEDIUMTEXT,
  pg_estrategia_como MEDIUMTEXT,
  pg_estrategia_porque MEDIUMTEXT,
  pg_estrategia_quanto MEDIUMTEXT,
  pg_estrategia_quem MEDIUMTEXT,
  pg_estrategia_controle MEDIUMTEXT,
  pg_estrategia_melhorias MEDIUMTEXT,
  pg_estrategia_metodo_aprendizado MEDIUMTEXT,
  pg_estrategia_desde_quando MEDIUMTEXT,
  pg_estrategia_tipo VARCHAR(50) DEFAULT NULL,
  pg_estrategia_ano VARCHAR(4) DEFAULT NULL,
	pg_estrategia_codigo VARCHAR(50) DEFAULT NULL,
	pg_estrategia_inicio DATE DEFAULT NULL,
	pg_estrategia_fim DATE DEFAULT NULL,
	pg_estrategia_tipo_pontuacao VARCHAR(40) DEFAULT NULL,
	pg_estrategia_percentagem DECIMAL(20,5) UNSIGNED DEFAULT 0,
	pg_estrategia_ponto_alvo DECIMAL(20,5) UNSIGNED DEFAULT 0,
	pg_estrategia_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
	pg_estrategia_ativo TINYINT(1) DEFAULT 1,
	pg_estrategia_aprovado TINYINT(1) DEFAULT 0,
  PRIMARY KEY (pg_estrategia_id),
  KEY pg_estrategia_cia (pg_estrategia_cia),
  KEY pg_estrategia_dept (pg_estrategia_dept),
  KEY pg_estrategia_usuario (pg_estrategia_usuario),
  KEY pg_estrategia_fator (pg_estrategia_fator),
  KEY pg_estrategia_principal_indicador (pg_estrategia_principal_indicador),
  KEY pg_estrategia_moeda (pg_estrategia_moeda),
  CONSTRAINT estrategias_fk FOREIGN KEY (pg_estrategia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT estrategias_fk1 FOREIGN KEY (pg_estrategia_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT estrategias_fk2 FOREIGN KEY (pg_estrategia_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT estrategias_fk3 FOREIGN KEY (pg_estrategia_principal_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT pg_estrategia_dept FOREIGN KEY (pg_estrategia_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT pg_estrategia_moeda FOREIGN KEY (pg_estrategia_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS metas;

CREATE TABLE metas (
  pg_meta_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pg_meta_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_meta_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_meta_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_meta_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_meta_tema INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_meta_objetivo_estrategico INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_meta_fator INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_meta_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_meta_principal_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_meta_nome TEXT,
  pg_meta_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_meta_prazo DATE DEFAULT NULL,
  pg_meta_data DATETIME DEFAULT NULL,
  pg_meta_oque TEXT,
  pg_meta_descricao MEDIUMTEXT,
  pg_meta_onde TEXT,
  pg_meta_quando TEXT,
  pg_meta_como TEXT,
  pg_meta_porque TEXT,
  pg_meta_quanto TEXT,
  pg_meta_quem TEXT,
  pg_meta_controle TEXT,
  pg_meta_melhorias TEXT,
  pg_meta_metodo_aprendizado TEXT,
  pg_meta_desde_quando TEXT,
  pg_meta_cor VARCHAR(6) DEFAULT 'FFFFFF',
  pg_meta_ativo TINYINT(1) DEFAULT 1,
  pg_meta_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  pg_meta_tipo VARCHAR(50) DEFAULT NULL,
	pg_meta_tipo_pontuacao VARCHAR(40) DEFAULT NULL,
	pg_meta_percentagem DECIMAL(20,5) UNSIGNED DEFAULT 0,
	pg_meta_ponto_alvo DECIMAL(20,5) UNSIGNED DEFAULT 0,
	pg_meta_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
	pg_meta_aprovado TINYINT(1) DEFAULT 0,
  PRIMARY KEY (pg_meta_id),
  KEY pg_meta_cia (pg_meta_cia),
  KEY pg_meta_dept (pg_meta_dept),
  KEY pg_meta_responsavel (pg_meta_responsavel),
  KEY pg_meta_perspectiva (pg_meta_perspectiva),
  KEY pg_meta_tema (pg_meta_tema),
  KEY pg_meta_objetivo_estrategico (pg_meta_objetivo_estrategico),
  KEY pg_meta_fator (pg_meta_fator),
  KEY pg_meta_estrategia (pg_meta_estrategia),
 	KEY pg_meta_principal_indicador (pg_meta_principal_indicador),
 	KEY pg_meta_moeda (pg_meta_moeda),
  CONSTRAINT metas_fk FOREIGN KEY (pg_meta_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT metas_fk1 FOREIGN KEY (pg_meta_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT metas_fk2 FOREIGN KEY (pg_meta_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT metas_fk3 FOREIGN KEY (pg_meta_objetivo_estrategico) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT metas_fk4 FOREIGN KEY (pg_meta_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT metas_fk5 FOREIGN KEY (pg_meta_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT metas_fk6 FOREIGN KEY (pg_meta_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT metas_fk7 FOREIGN KEY (pg_meta_principal_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT pg_meta_dept FOREIGN KEY (pg_meta_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT pg_meta_moeda FOREIGN KEY (pg_meta_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS meta_meta;

CREATE TABLE meta_meta (
	meta_meta_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	meta_meta_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_meta_data_inicio DATE DEFAULT NULL,
	meta_meta_data_fim DATE DEFAULT NULL,
	meta_meta_valor_meta DECIMAL(20,5) DEFAULT 0,
	meta_meta_valor_meta_boa DECIMAL(20,5) DEFAULT 0,
	meta_meta_valor_meta_regular DECIMAL(20,5) DEFAULT 0,
	meta_meta_valor_meta_ruim DECIMAL(20,5) DEFAULT 0,
	meta_meta_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (meta_meta_id),
	KEY meta_meta_meta (meta_meta_meta),
	CONSTRAINT meta_meta_meta FOREIGN KEY (meta_meta_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS checklist_modelo;

CREATE TABLE checklist_modelo (
  checklist_modelo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  checklist_modelo_nome VARCHAR(255) DEFAULT NULL,
  PRIMARY KEY (checklist_modelo_id)
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS checklist;

CREATE TABLE checklist (
  checklist_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  checklist_superior INTEGER(100) UNSIGNED DEFAULT NULL,
  checklist_modelo INTEGER(100) UNSIGNED DEFAULT 1,
  checklist_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  checklist_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  checklist_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  checklist_principal_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  checklist_nome VARCHAR(255) DEFAULT NULL,
  checklist_descricao MEDIUMTEXT,
  checklist_moeda INTEGER(100) UNSIGNED DEFAULT 1,
  checklist_cor VARCHAR(6) DEFAULT 'FFFFFF',
  checklist_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  checklist_tipo VARCHAR(50) DEFAULT NULL,
  checklist_ativo TINYINT(1) DEFAULT 1,
  checklist_aprovado TINYINT(1) DEFAULT 0,
  PRIMARY KEY (checklist_id),
  KEY checklist_cia (checklist_cia),
  KEY checklist_dept (checklist_dept),
  KEY checklist_responsavel (checklist_responsavel),
  KEY checklist_modelo (checklist_modelo),
  KEY checklist_principal_indicador (checklist_principal_indicador),
  KEY checklist_moeda (checklist_moeda),
  CONSTRAINT checklist_cia FOREIGN KEY (checklist_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT checklist_dept FOREIGN KEY (checklist_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT checklist_responsavel FOREIGN KEY (checklist_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE SET NULL,
  CONSTRAINT checklist_modelo FOREIGN KEY (checklist_modelo) REFERENCES checklist_modelo (checklist_modelo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT checklist_principal_indicador FOREIGN KEY (checklist_principal_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT checklist_moeda FOREIGN KEY (checklist_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS praticas;

CREATE TABLE praticas (
  pratica_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pratica_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_principal_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_nome VARCHAR(255) DEFAULT NULL,
  pratica_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
  pratica_cor VARCHAR(6) DEFAULT 'FFFFFF',
  pratica_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  pratica_aprovado TINYINT(1) DEFAULT 0,
  pratica_ativa TINYINT(1) DEFAULT 1,
  PRIMARY KEY (pratica_id),
  KEY pratica_responsavel (pratica_responsavel),
  KEY pratica_cia (pratica_cia),
  KEY pratica_dept (pratica_dept),
  KEY pratica_principal_indicador (pratica_principal_indicador),
  KEY pratica_moeda (pratica_moeda),
  CONSTRAINT praticas_responsavel FOREIGN KEY (pratica_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT praticas_cia FOREIGN KEY (pratica_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT praticas_principal_indicador FOREIGN KEY (pratica_principal_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT pratica_dept FOREIGN KEY (pratica_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT pratica_moeda FOREIGN KEY (pratica_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE 
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS pratica_requisito;

CREATE TABLE pratica_requisito (
	pratica_id INTEGER(100) UNSIGNED NOT NULL,
	ano INTEGER(4) NOT NULL,
	pratica_oque MEDIUMTEXT,
	pratica_onde MEDIUMTEXT,
	pratica_quando MEDIUMTEXT,
	pratica_como MEDIUMTEXT,
	pratica_porque MEDIUMTEXT,
	pratica_quanto MEDIUMTEXT,
	pratica_quem MEDIUMTEXT,
	pratica_descricao MEDIUMTEXT,
	pratica_controlada TINYINT(1) DEFAULT 0,
  pratica_justificativa_controlada MEDIUMTEXT,
  pratica_proativa TINYINT(1) DEFAULT 0,
  pratica_justificativa_proativa MEDIUMTEXT,
  pratica_abrange_pertinentes TINYINT(1) DEFAULT 0,
  pratica_justificativa_abrangencia MEDIUMTEXT,
  pratica_continuada TINYINT(1) DEFAULT 0,
  pratica_justificativa_continuada MEDIUMTEXT,
  pratica_refinada TINYINT(1) DEFAULT 0,
  pratica_justificativa_refinada MEDIUMTEXT,
  pratica_coerente TINYINT(1) DEFAULT 0,
  pratica_justificativa_coerente MEDIUMTEXT,
  pratica_interrelacionada TINYINT(1) DEFAULT 0,
  pratica_justificativa_interrelacionada MEDIUMTEXT,
  pratica_cooperacao TINYINT(1) DEFAULT 0,
  pratica_justificativa_cooperacao MEDIUMTEXT,
  pratica_cooperacao_partes TINYINT(1) DEFAULT 0,
  pratica_justificativa_cooperacao_partes MEDIUMTEXT,
  pratica_arte TINYINT(1) DEFAULT 0,
  pratica_justificativa_arte MEDIUMTEXT,
  pratica_inovacao TINYINT(1) DEFAULT 0,
  pratica_justificativa_inovacao MEDIUMTEXT,
  pratica_melhoria_aprendizado TINYINT(1) DEFAULT 0,
  pratica_justificativa_melhoria_aprendizado MEDIUMTEXT,
  pratica_gerencial TINYINT(1) DEFAULT 0,
  pratica_justificativa_gerencial MEDIUMTEXT,
  pratica_agil TINYINT(1) DEFAULT 0,
  pratica_justificativa_agil MEDIUMTEXT,
	pratica_refinada_implantacao TINYINT(1) DEFAULT 0,
	pratica_justificativa_refinada_implantacao MEDIUMTEXT,
	pratica_incoerente TINYINT(1) DEFAULT 0,
	pratica_justificativa_incoerente MEDIUMTEXT,
  PRIMARY KEY (pratica_id, ano),
  KEY pratica_id (pratica_id),
	CONSTRAINT pratica_requisito_fk FOREIGN KEY (pratica_id) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS projetos;

CREATE TABLE projetos (
  projeto_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  projeto_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_criador INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_supervisor INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_autoridade INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_cliente INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_atualizador INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_superior INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_superior_original INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_tema INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_objetivo_estrategico INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_meta INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_fator INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_acao INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_nome VARCHAR(255) DEFAULT NULL,
  projeto_nome_curto VARCHAR(255) DEFAULT NULL,
  projeto_codigo VARCHAR(50) DEFAULT NULL,
  projeto_sequencial INTEGER(100) DEFAULT NULL,
  projeto_url VARCHAR(255) DEFAULT NULL,
  projeto_url_externa VARCHAR(255) DEFAULT NULL,
  projeto_data_inicio DATETIME DEFAULT NULL,
  projeto_data_fim DATETIME DEFAULT NULL,
  projeto_fim_atualizado DATETIME DEFAULT NULL,
  projeto_status INTEGER(100) UNSIGNED DEFAULT 0,
  projeto_fase INTEGER(10) UNSIGNED DEFAULT 0,
  projeto_percentagem DECIMAL(20,5) UNSIGNED DEFAULT 0,
  projeto_custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
  projeto_gasto DECIMAL(20,5) UNSIGNED DEFAULT 0,
  projeto_cor VARCHAR(6) DEFAULT 'eeeeee',
  projeto_descricao MEDIUMTEXT,
  projeto_objetivos MEDIUMTEXT,
  projeto_observacao MEDIUMTEXT,
  projeto_como MEDIUMTEXT,
  projeto_localizacao MEDIUMTEXT,
  projeto_beneficiario MEDIUMTEXT,
  projeto_meta_custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
  projeto_custo_atual DECIMAL(20,5) UNSIGNED DEFAULT 0,
  projeto_privativo TINYINT(3) UNSIGNED DEFAULT 0,
  projeto_prioridade TINYINT(4) DEFAULT 0,
  projeto_tipo SMALLINT(6) DEFAULT 0,
  projeto_data_chave DATETIME DEFAULT NULL,
  projeto_data_chave_pos TINYINT(1) DEFAULT 0,
  projeto_tarefa_chave INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_ativo INTEGER(1) DEFAULT 1,
  projeto_especial INTEGER(1) DEFAULT 0,
  projeto_criado DATETIME DEFAULT NULL,
  projeto_atualizado DATETIME DEFAULT NULL,
  projeto_data_fim_ajustada DATETIME DEFAULT NULL,
  projeto_status_comentario VARCHAR(255) DEFAULT NULL,
  projeto_subprioridade TINYINT(4) DEFAULT 0,
  projeto_data_fim_ajustada_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  projeto_endereco1 VARCHAR(100) DEFAULT NULL,
  projeto_endereco2 VARCHAR(100) DEFAULT NULL,
  projeto_cidade VARCHAR(7) DEFAULT NULL,
  projeto_estado VARCHAR(2) DEFAULT NULL,
  projeto_cep VARCHAR(9) DEFAULT NULL,
  projeto_pais VARCHAR(30) DEFAULT NULL,
  projeto_latitude VARCHAR(200) DEFAULT NULL,
  projeto_longitude VARCHAR(200) DEFAULT NULL,
  projeto_setor VARCHAR(2) DEFAULT NULL,
  projeto_segmento VARCHAR(4) DEFAULT NULL,
  projeto_intervencao VARCHAR(6) DEFAULT NULL,
  projeto_tipo_intervencao VARCHAR(9) DEFAULT NULL,
  projeto_ano VARCHAR(4) DEFAULT NULL,
  projeto_portfolio INTEGER(1) DEFAULT 0,
  projeto_plano_operativo INTEGER(1) DEFAULT 0,
  projeto_comunidade INTEGER(100) DEFAULT NULL,
	projeto_social INTEGER(100) DEFAULT NULL,
	projeto_social_acao INTEGER(100) DEFAULT NULL,
	projeto_principal_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_template INTEGER(1) DEFAULT 0,
	projeto_justificativa MEDIUMTEXT,
	projeto_objetivo MEDIUMTEXT,
	projeto_objetivo_especifico MEDIUMTEXT,
	projeto_escopo MEDIUMTEXT,
	projeto_nao_escopo MEDIUMTEXT,
	projeto_premissas MEDIUMTEXT,
	projeto_restricoes MEDIUMTEXT,
	projeto_orcamento MEDIUMTEXT,
	projeto_beneficio MEDIUMTEXT,
	projeto_produto MEDIUMTEXT,
	projeto_requisito MEDIUMTEXT,
	portfolio_externo VARCHAR(255),
	projeto_fonte VARCHAR(255) DEFAULT NULL,
	projeto_alerta TINYINT(1) DEFAULT 0,
	projeto_trava_data TINYINT(1) DEFAULT 0,
	projeto_fisico_registro TINYINT(1) DEFAULT 0,
	projeto_aprova_registro TINYINT(1) DEFAULT 0,
	projeto_moeda INTEGER(100) UNSIGNED DEFAULT 1,
	projeto_encerramento DATE DEFAULT NULL,
	projeto_programa_financeiro VARCHAR(255) DEFAULT NULL,
	projeto_convenio VARCHAR(255) DEFAULT NULL,	
	projeto_aprovado TINYINT(1) DEFAULT 0,
  PRIMARY KEY (projeto_id),
  KEY projeto_responsavel (projeto_responsavel),
  KEY projeto_supervisor (projeto_supervisor),
  KEY projeto_autoridade (projeto_autoridade),
  KEY projeto_cliente (projeto_cliente),
  KEY projeto_data_inicio (projeto_data_inicio),
  KEY projeto_data_fim (projeto_data_fim),
  KEY projeto_nome_curto (projeto_nome_curto),
  KEY projeto_cia (projeto_cia),
  KEY projeto_dept (projeto_dept),
  KEY projeto_nome (projeto_nome),
  KEY projeto_superior (projeto_superior),
  KEY projeto_status (projeto_status),
  KEY projeto_tipo (projeto_tipo),
  KEY projeto_superior_original (projeto_superior_original),
  KEY projeto_principal_indicador (projeto_principal_indicador),
  KEY projeto_moeda (projeto_moeda),
  CONSTRAINT projetos_fk FOREIGN KEY (projeto_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_dept FOREIGN KEY (projeto_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT projetos_fk1 FOREIGN KEY (projeto_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT projetos_fk2 FOREIGN KEY (projeto_principal_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT projetos_fk3 FOREIGN KEY (projeto_supervisor) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT projetos_fk4 FOREIGN KEY (projeto_autoridade) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT projetos_fk5 FOREIGN KEY (projeto_cliente) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT projeto_moeda FOREIGN KEY (projeto_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS projetos_artefatos;

CREATE TABLE projetos_artefatos (
  projeto_artefato_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  projeto_artefato_fase_ordem INTEGER(11) DEFAULT NULL,
  projeto_artefato_fase VARCHAR(50) DEFAULT NULL,
  projeto_artefato_area_ordem INTEGER(11) DEFAULT NULL,
  projeto_artefato_area VARCHAR(50) DEFAULT NULL,
  projeto_artefato_item_ordem INTEGER(11) DEFAULT NULL,
  projeto_artefato_informacao VARCHAR(255) DEFAULT NULL,
  projeto_artefato_documento VARCHAR(255) DEFAULT NULL,
  projeto_artefato_pequeno TINYINT(1) DEFAULT 0,
  projeto_artefato_medio TINYINT(1) DEFAULT 0,
  projeto_artefato_grande TINYINT(1) DEFAULT 0,
  PRIMARY KEY (projeto_artefato_id)
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS tarefas;

CREATE TABLE tarefas (
  tarefa_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  tarefa_superior INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_dono INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_criador INTEGER(100) UNSIGNED DEFAULT NULL,
	tarefa_comunidade INTEGER(100) DEFAULT NULL,
	tarefa_social INTEGER(100) DEFAULT NULL,
	tarefa_acao INTEGER(100) DEFAULT NULL,
	tarefa_principal_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_nome VARCHAR(255) DEFAULT NULL,
  tarefa_marco TINYINT(1) DEFAULT 0,
  tarefa_inicio DATETIME DEFAULT NULL,
  tarefa_inicio_calculado TINYINT(1) DEFAULT 0,
  tarefa_duracao DECIMAL(20,5) UNSIGNED DEFAULT 0,
  tarefa_duracao_tipo INTEGER(100) UNSIGNED DEFAULT 1,
  tarefa_horas_trabalhadas DECIMAL(20,5) UNSIGNED DEFAULT 0,
  tarefa_fim DATETIME DEFAULT NULL,
  tarefa_status INTEGER(100) DEFAULT 0,
  tarefa_prioridade TINYINT(4) DEFAULT 0,
  tarefa_percentagem DECIMAL(20,5) UNSIGNED DEFAULT 0,
  tarefa_percentagem_data DATETIME DEFAULT NULL,
  tarefa_custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
  tarefa_gasto DECIMAL(20,5) UNSIGNED DEFAULT 0,
  tarefa_descricao MEDIUMTEXT,
  tarefa_onde TEXT,
  tarefa_porque TEXT,
  tarefa_como TEXT,
  tarefa_customizado TEXT,
  tarefa_situacao_atual TEXT,
  tarefa_custo_almejado DECIMAL(20,5) UNSIGNED DEFAULT 0,
  tarefa_url_relacionada VARCHAR(255) DEFAULT NULL,
  tarefa_cliente_publicada TINYINT(1) DEFAULT 0,
  tarefa_dinamica TINYINT(1) DEFAULT 0,
  tarefa_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  tarefa_notificar INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_tipo VARCHAR(255) DEFAULT NULL,
  tarefa_atualizador INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_data_criada DATETIME DEFAULT NULL,
  tarefa_data_atualizada DATETIME DEFAULT NULL,
  tarefa_endereco1 VARCHAR(100) DEFAULT NULL,
  tarefa_endereco2 VARCHAR(100) DEFAULT NULL,
  tarefa_cidade VARCHAR(7) DEFAULT NULL,
  tarefa_estado VARCHAR(2) DEFAULT NULL,
  tarefa_cep VARCHAR(9) DEFAULT NULL,
  tarefa_pais VARCHAR(30) DEFAULT NULL,
  tarefa_latitude VARCHAR(200) DEFAULT NULL,
  tarefa_longitude VARCHAR(200) DEFAULT NULL,
  tarefa_emprego_obra INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_emprego_direto INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_emprego_indireto INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_populacao_atendida VARCHAR(100) DEFAULT NULL,
  tarefa_forma_implantacao VARCHAR(100) DEFAULT NULL,
  tarefa_adquirido DECIMAL(20,5) UNSIGNED DEFAULT 0,
  tarefa_previsto DECIMAL(20,5) UNSIGNED DEFAULT 0,
  tarefa_realizado DECIMAL(20,5) UNSIGNED DEFAULT 0,
	tarefa_codigo VARCHAR(50) DEFAULT NULL,
	tarefa_sequencial INTEGER(100) DEFAULT NULL,
	tarefa_setor VARCHAR(2) DEFAULT NULL,
	tarefa_segmento VARCHAR(4) DEFAULT NULL,
	tarefa_intervencao VARCHAR(6) DEFAULT NULL,
	tarefa_tipo_intervencao VARCHAR(9) DEFAULT NULL,
	tarefa_ano VARCHAR(4) DEFAULT NULL,
	tarefa_projetoex_id INT(100) UNSIGNED DEFAULT NULL,
	tarefa_tarefaex_id INT(100) UNSIGNED DEFAULT NULL,
	tarefa_desatualizada INT(1) DEFAULT 0,
	tarefa_unidade VARCHAR(50) DEFAULT NULL,
	tarefa_numeracao INTEGER(100) UNSIGNED DEFAULT NULL,
	tarefa_gerenciamento INTEGER(1) DEFAULT 0,
	tarefa_alerta TINYINT(1) DEFAULT 0,
	tarefa_manual TINYINT(1) NULL DEFAULT 0,
	tarefa_duracao_manual DECIMAL(20,5) UNSIGNED NULL DEFAULT 0,
	tarefa_inicio_manual DATETIME NULL DEFAULT NULL,
	tarefa_fim_manual DATETIME NULL DEFAULT NULL,
  PRIMARY KEY (tarefa_id),
  KEY idx_tarefa_superior (tarefa_superior),
  KEY idx_tarefa_projeto (tarefa_projeto),
  KEY idx_tarefa_dono (tarefa_dono),
  KEY idx_tarefa1 (tarefa_inicio),
  KEY idx_tarefa2 (tarefa_fim),
  KEY tarefa_prioridade (tarefa_prioridade),
  KEY tarefa_nome (tarefa_nome),
  KEY tarefa_status (tarefa_status),
  KEY tarefa_percentagem (tarefa_percentagem),
  KEY tarefa_criador (tarefa_criador),
  KEY tarefa_id (tarefa_id, tarefa_nome),
  KEY tarefa_cia (tarefa_cia),
  KEY tarefa_dept (tarefa_dept),
  KEY tarefa_principal_indicador (tarefa_principal_indicador),
  CONSTRAINT tarefas_fk FOREIGN KEY (tarefa_superior) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tarefas_fk1 FOREIGN KEY (tarefa_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tarefas_fk2 FOREIGN KEY (tarefa_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tarefas_fk3 FOREIGN KEY (tarefa_dono) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT tarefas_fk4 FOREIGN KEY (tarefa_criador) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT tarefas_fk5 FOREIGN KEY (tarefa_principal_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT tarefa_dept FOREIGN KEY (tarefa_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT tarefa_fk6 FOREIGN KEY (tarefa_projetoex_id ) REFERENCES projetos (projeto_id ) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tarefa_fk7 FOREIGN KEY (tarefa_tarefaex_id ) REFERENCES tarefas (tarefa_id ) ON DELETE CASCADE ON UPDATE CASCADE,
  INDEX tarefa_fk6_idx (tarefa_projetoex_id ASC),
  INDEX tarefa_fk7_idx (tarefa_tarefaex_id ASC)
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS pratica_indicador;

CREATE TABLE pratica_indicador (
  pratica_indicador_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pratica_indicador_superior INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_requisito INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_tema INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_objetivo_estrategico INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_acao INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_fator INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_meta INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_risco INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_trava_meta INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_trava_referencial INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_trava_data_meta INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_trava_acumulacao INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_trava_agrupar INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_nome VARCHAR(512) DEFAULT NULL,
  pratica_indicador_ativo TINYINT(1) DEFAULT 1,
  pratica_indicador_tipo VARCHAR(50) DEFAULT NULL,
  pratica_indicador_desde_quando DATE DEFAULT NULL,
  pratica_indicador_sentido INTEGER(4) DEFAULT 1,
  pratica_indicador_valor DECIMAL(20,5) DEFAULT 0,
  pratica_indicador_acesso INTEGER(4) DEFAULT 0,
  pratica_indicador_cor VARCHAR(6) DEFAULT 'FFFFFF',
  pratica_indicador_unidade VARCHAR(20) DEFAULT NULL,
  pratica_indicador_nome_curto VARCHAR(10) DEFAULT NULL,
  pratica_indicador_setor VARCHAR(2) DEFAULT NULL,
	pratica_indicador_segmento VARCHAR(4) DEFAULT NULL,
	pratica_indicador_intervencao VARCHAR(6) DEFAULT NULL,
	pratica_indicador_tipo_intervencao VARCHAR(9) DEFAULT NULL,
	pratica_indicador_ano VARCHAR(4) DEFAULT NULL,
	pratica_indicador_codigo VARCHAR(50) DEFAULT NULL,
	pratica_indicador_sequencial INTEGER(100) DEFAULT NULL,
  pratica_indicador_resultado TINYINT(1) DEFAULT 0,
  pratica_indicador_tipografico VARCHAR(20) DEFAULT 'linha',
  pratica_indicador_mostrar_valor TINYINT(1) DEFAULT 0,
  pratica_indicador_mostrar_titulo TINYINT(1) DEFAULT 0,
  pratica_indicador_media_movel TINYINT(1) DEFAULT 0,
  pratica_indicador_acumulacao VARCHAR(20) DEFAULT 'media_simples',
  pratica_indicador_agrupar VARCHAR(20) DEFAULT 'ano',
  pratica_indicador_periodo_anterior TINYINT(1) DEFAULT 1,
  pratica_indicador_max_min TINYINT(1) DEFAULT 0,
  pratica_indicador_nr_pontos INTEGER(11) DEFAULT '12',
  pratica_indicador_composicao TINYINT(1) DEFAULT 0,
  pratica_indicador_formula TINYINT(1) DEFAULT 0,
  pratica_indicador_formula_simples TINYINT(1) DEFAULT 0,
  pratica_indicador_formula_simples_variacao TINYINT(1) DEFAULT 0,
  pratica_indicador_externo TINYINT(1) DEFAULT 0,
  pratica_indicador_campo_projeto TINYINT(1) DEFAULT 0,
  pratica_indicador_parametro_projeto VARCHAR(100) DEFAULT NULL,
  pratica_indicador_campo_tarefa TINYINT(1) DEFAULT 0,
	pratica_indicador_parametro_tarefa VARCHAR(100)DEFAULT NULL,
	pratica_indicador_campo_acao TINYINT(1) DEFAULT 0,
	pratica_indicador_parametro_acao VARCHAR(100)DEFAULT NULL,
	pratica_indicador_checklist_valor TINYINT(1) DEFAULT 0,
  pratica_indicador_calculo TEXT,
  pratica_indicador_tolerancia DECIMAL(20,5) DEFAULT 0,
  pratica_indicador_alerta TINYINT(1) DEFAULT 0,
  pratica_indicador_moeda INTEGER(100) UNSIGNED DEFAULT 1,
  pratica_indicador_aprovado TINYINT(1) DEFAULT 0,
  pratica_indicador_sem_meta TINYINT(1) DEFAULT 0,
  PRIMARY KEY (pratica_indicador_id),
  KEY pratica_indicador_responsavel (pratica_indicador_responsavel),
  KEY pratica_indicador_superior (pratica_indicador_superior),
  KEY pratica_indicador_cia (pratica_indicador_cia),
  KEY pratica_indicador_dept (pratica_indicador_dept),
  KEY pratica_indicador_requisito (pratica_indicador_requisito),
  KEY pratica_indicador_perspectiva (pratica_indicador_perspectiva),
  KEY pratica_indicador_tema (pratica_indicador_tema),
  KEY pratica_indicador_objetivo_estrategico (pratica_indicador_objetivo_estrategico),
  KEY pratica_indicador_fator (pratica_indicador_fator),
  KEY pratica_indicador_estrategia (pratica_indicador_estrategia),
  KEY pratica_indicador_meta (pratica_indicador_meta),
  KEY pratica_indicador_projeto (pratica_indicador_projeto),
  KEY pratica_indicador_tarefa (pratica_indicador_tarefa),
  KEY pratica_indicador_pratica (pratica_indicador_pratica),
  KEY pratica_indicador_acao (pratica_indicador_acao),
  KEY pratica_indicador_acao_item (pratica_indicador_acao_item),
  KEY pratica_indicador_usuario (pratica_indicador_usuario),
  KEY pratica_indicador_canvas (pratica_indicador_canvas),
  KEY pratica_indicador_trava_meta (pratica_indicador_trava_meta),
  KEY pratica_indicador_trava_referencial (pratica_indicador_trava_referencial),
  KEY pratica_indicador_trava_data_meta (pratica_indicador_trava_data_meta),
  KEY pratica_indicador_trava_acumulacao (pratica_indicador_trava_acumulacao),
  KEY pratica_indicador_trava_agrupar (pratica_indicador_trava_agrupar),
  KEY pratica_indicador_checklist (pratica_indicador_checklist),
  KEY pratica_indicador_moeda (pratica_indicador_moeda),
  CONSTRAINT pratica_indicador_responsavel FOREIGN KEY (pratica_indicador_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT pratica_indicador_superior FOREIGN KEY (pratica_indicador_superior) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT pratica_indicador_cia FOREIGN KEY (pratica_indicador_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT pratica_indicador_dept FOREIGN KEY (pratica_indicador_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT pratica_indicador_requisito FOREIGN KEY (pratica_indicador_requisito) REFERENCES pratica_indicador_requisito (pratica_indicador_requisito_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT pratica_indicador_objetivo_estrategico FOREIGN KEY (pratica_indicador_objetivo_estrategico) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT pratica_indicador_fator FOREIGN KEY (pratica_indicador_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT pratica_indicador_estrategia FOREIGN KEY (pratica_indicador_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT pratica_indicador_meta FOREIGN KEY (pratica_indicador_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT pratica_indicador_projeto FOREIGN KEY (pratica_indicador_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT pratica_indicador_tarefa FOREIGN KEY (pratica_indicador_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT pratica_indicador_pratica FOREIGN KEY (pratica_indicador_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT pratica_indicador_acao FOREIGN KEY (pratica_indicador_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT pratica_indicador_usuario FOREIGN KEY (pratica_indicador_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT pratica_indicador_trava_meta FOREIGN KEY (pratica_indicador_trava_meta) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT pratica_indicador_trava_referencial FOREIGN KEY (pratica_indicador_trava_referencial) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT pratica_indicador_trava_data_meta FOREIGN KEY (pratica_indicador_trava_data_meta) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT pratica_indicador_trava_acumulacao FOREIGN KEY (pratica_indicador_trava_acumulacao) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT pratica_indicador_trava_agrupar FOREIGN KEY (pratica_indicador_trava_agrupar) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT pratica_indicador_checklist FOREIGN KEY (pratica_indicador_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT pratica_indicador_tema FOREIGN KEY (pratica_indicador_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_acao_item FOREIGN KEY (pratica_indicador_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_perspectiva FOREIGN KEY (pratica_indicador_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_canvas FOREIGN KEY (pratica_indicador_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pratica_indicador_moeda FOREIGN KEY (pratica_indicador_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS pratica_indicador_valor_simples;

CREATE TABLE pratica_indicador_valor_simples (
	pratica_indicador_valor_simples_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pratica_indicador_valor_simples_valor_id INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_valor_simples_formula_simples_id INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_valor_simples_valor DECIMAL(20,5) DEFAULT 0,
  PRIMARY KEY (pratica_indicador_valor_simples_id),
  KEY pratica_indicador_valor_simples_valor_id (pratica_indicador_valor_simples_valor_id),
  KEY pratica_indicador_valor_simples_formula_simples_id (pratica_indicador_valor_simples_formula_simples_id),
  CONSTRAINT pratica_indicador_valor_simples_formula_simples_id FOREIGN KEY (pratica_indicador_valor_simples_formula_simples_id) REFERENCES pratica_indicador_formula_simples (pratica_indicador_formula_simples_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT pratica_indicador_valor_simples_valor_id FOREIGN KEY (pratica_indicador_valor_simples_valor_id) REFERENCES pratica_indicador_valor (pratica_indicador_valor_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS pratica_indicador_meta;
CREATE TABLE pratica_indicador_meta (
	pratica_indicador_meta_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	pratica_indicador_meta_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	pratica_indicador_meta_data DATE DEFAULT NULL,
	pratica_indicador_meta_valor_referencial DECIMAL(20,5) DEFAULT 0,
	pratica_indicador_meta_valor_meta DECIMAL(20,5) DEFAULT 0,
	pratica_indicador_meta_valor_meta_boa DECIMAL(20,5) DEFAULT 0,
	pratica_indicador_meta_valor_meta_regular DECIMAL(20,5) DEFAULT 0,
	pratica_indicador_meta_valor_meta_ruim DECIMAL(20,5) DEFAULT 0,
	pratica_indicador_meta_data_meta DATE DEFAULT NULL,
	pratica_indicador_meta_proporcao tinyint(1) DEFAULT '0',
	uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (pratica_indicador_meta_id),
	KEY pratica_indicador_meta_indicador (pratica_indicador_meta_indicador),
	CONSTRAINT pratica_indicador_meta_fk1 FOREIGN KEY (pratica_indicador_meta_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE
	)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS pratica_indicador_requisito;

CREATE TABLE pratica_indicador_requisito (
  pratica_indicador_requisito_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pratica_indicador_requisito_indicador INTEGER(100) UNSIGNED NOT NULL,
  pratica_indicador_requisito_ano INTEGER(4) NOT NULL DEFAULT '0',
  pratica_indicador_requisito_quando MEDIUMTEXT,
  pratica_indicador_requisito_oque MEDIUMTEXT,
  pratica_indicador_requisito_como MEDIUMTEXT,
  pratica_indicador_requisito_onde MEDIUMTEXT,
  pratica_indicador_requisito_quanto MEDIUMTEXT,
  pratica_indicador_requisito_porque MEDIUMTEXT,
  pratica_indicador_requisito_quem MEDIUMTEXT,
  pratica_indicador_requisito_melhorias MEDIUMTEXT,
  pratica_indicador_requisito_referencial MEDIUMTEXT,
  pratica_indicador_requisito_relevante TINYINT(1) DEFAULT '0',
  pratica_indicador_requisito_justificativa_relevante MEDIUMTEXT,
  pratica_indicador_requisito_lider TINYINT(1) DEFAULT '0',
  pratica_indicador_requisito_justificativa_lider MEDIUMTEXT,
  pratica_indicador_requisito_excelencia TINYINT(1) DEFAULT '0',
  pratica_indicador_requisito_justificativa_excelencia MEDIUMTEXT,
  pratica_indicador_requisito_atendimento TINYINT(1) DEFAULT '0',
  pratica_indicador_requisito_justificativa_atendimento MEDIUMTEXT,
  pratica_indicador_requisito_estrategico TINYINT(1) DEFAULT '0',
  pratica_indicador_requisito_justificativa_estrategico MEDIUMTEXT,
  pratica_indicador_requisito_tendencia TINYINT(1) DEFAULT 0,
  pratica_indicador_requisito_justificativa_tendencia MEDIUMTEXT,
  pratica_indicador_requisito_favoravel TINYINT(1) DEFAULT 0,
  pratica_indicador_requisito_justificativa_favoravel MEDIUMTEXT,
  pratica_indicador_requisito_superior TINYINT(1) DEFAULT 0,
  pratica_indicador_requisito_justificativa_superior MEDIUMTEXT,
  pratica_indicador_requisito_descricao MEDIUMTEXT,
  PRIMARY KEY (pratica_indicador_requisito_id),
  KEY pratica_indicador_requisito_indicador (pratica_indicador_requisito_indicador),
  CONSTRAINT pratica_indicador_requisito_indicador FOREIGN KEY (pratica_indicador_requisito_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS plano_acao;

CREATE TABLE plano_acao (
  plano_acao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  plano_acao_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_nome VARCHAR(255) DEFAULT NULL,
  plano_acao_descricao MEDIUMTEXT,
  plano_acao_cor VARCHAR(6) DEFAULT 'FFFFFF',
  plano_acao_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  plano_acao_inicio DATETIME DEFAULT NULL,
	plano_acao_fim DATETIME DEFAULT NULL,
	plano_acao_duracao DECIMAL(20,5) UNSIGNED DEFAULT NULL,
	plano_acao_percentagem DECIMAL(20,5) UNSIGNED DEFAULT 0,
	plano_acao_calculo_porcentagem TINYINT(1) DEFAULT 0,
	plano_acao_data_obrigatorio TINYINT(1) DEFAULT 0,
	plano_acao_data_apenas TINYINT(1) DEFAULT 0,
	plano_acao_ano VARCHAR(4) DEFAULT NULL,
	plano_acao_codigo VARCHAR(50) DEFAULT NULL,
	plano_acao_setor VARCHAR(2) DEFAULT NULL,
	plano_acao_segmento VARCHAR(4) DEFAULT NULL,
	plano_acao_intervencao VARCHAR(6) DEFAULT NULL,
	plano_acao_tipo_intervencao VARCHAR(9) DEFAULT NULL,
	plano_acao_sequencial INTEGER(100) DEFAULT NULL,
	plano_acao_principal_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_aprovado TINYINT(1) DEFAULT 0,
	plano_acao_moeda INTEGER(100) UNSIGNED DEFAULT 1,
	plano_acao_ativo TINYINT(1) DEFAULT 1,
	plano_acao_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (plano_acao_id),
  KEY plano_acao_cia (plano_acao_cia),
  KEY plano_acao_dept (plano_acao_dept),
  KEY plano_acao_responsavel (plano_acao_responsavel),
  KEY plano_acao_projeto (plano_acao_projeto),
  KEY plano_acao_tarefa (plano_acao_tarefa),
  KEY plano_acao_pratica (plano_acao_pratica),
  KEY plano_acao_indicador (plano_acao_indicador),
  KEY plano_acao_perspectiva (plano_acao_perspectiva),
  KEY plano_acao_tema (plano_acao_tema),
  KEY plano_acao_objetivo (plano_acao_objetivo),
  KEY plano_acao_estrategia (plano_acao_estrategia),
  KEY plano_acao_meta (plano_acao_meta),
  KEY plano_acao_fator (plano_acao_fator),
  KEY plano_acao_canvas (plano_acao_canvas),
  KEY plano_acao_usuario (plano_acao_usuario),
  KEY plano_acao_principal_indicador (plano_acao_principal_indicador),
  KEY plano_acao_moeda (plano_acao_moeda),
  CONSTRAINT plano_acao_cia FOREIGN KEY (plano_acao_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_acao_dept FOREIGN KEY (plano_acao_dept) REFERENCES depts (dept_id) ON DELETE SET NULl ON UPDATE CASCADE,
  CONSTRAINT plano_acao_projeto FOREIGN KEY (plano_acao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_acao_tarefa FOREIGN KEY (plano_acao_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_acao_pratica FOREIGN KEY (plano_acao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_acao_indicador FOREIGN KEY (plano_acao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_acao_objetivo FOREIGN KEY (plano_acao_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_acao_estrategia FOREIGN KEY (plano_acao_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_acao_meta FOREIGN KEY (plano_acao_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_acao_fator FOREIGN KEY (plano_acao_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_acao_usuario FOREIGN KEY (plano_acao_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_acao_responsavel FOREIGN KEY (plano_acao_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT plano_acao_tema FOREIGN KEY (plano_acao_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_acao_principal_indicador FOREIGN KEY (plano_acao_principal_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT plano_acao_perspectiva FOREIGN KEY (plano_acao_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_acao_canvas FOREIGN KEY (plano_acao_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_acao_moeda FOREIGN KEY (plano_acao_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS plano_acao_cia;

CREATE TABLE plano_acao_cia (
  plano_acao_cia_plano_acao INTEGER(100) UNSIGNED NOT NULL,
  plano_acao_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (plano_acao_cia_plano_acao, plano_acao_cia_cia),
  KEY plano_acao_cia_plano_acao (plano_acao_cia_plano_acao),
  KEY plano_acao_cia_cia (plano_acao_cia_cia),
  CONSTRAINT plano_acao_cia_cia FOREIGN KEY (plano_acao_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_acao_cia_plano_acao FOREIGN KEY (plano_acao_cia_plano_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS plano_acao_contato;

CREATE TABLE plano_acao_contato (
  plano_acao_contato_acao INTEGER(100) UNSIGNED NOT NULL,
  plano_acao_contato_contato INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (plano_acao_contato_acao,plano_acao_contato_contato),
  KEY plano_acao_contato_acao (plano_acao_contato_acao),
  KEY plano_acao_contato_contato (plano_acao_contato_contato),
  CONSTRAINT plano_acao_contato_acao FOREIGN KEY (plano_acao_contato_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_acao_contato_contato FOREIGN KEY (plano_acao_contato_contato) REFERENCES contatos (contato_id) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB  CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS plano_acao_item_contato;

CREATE TABLE plano_acao_item_contato (
  plano_acao_item_contato_plano_acao_item INTEGER(100) UNSIGNED NOT NULL,
  plano_acao_item_contato_contato INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (plano_acao_item_contato_plano_acao_item, plano_acao_item_contato_contato),
  KEY plano_acao_item_contato_plano_acao_item (plano_acao_item_contato_plano_acao_item),
  KEY plano_acao_item_contato_contato (plano_acao_item_contato_contato),
  CONSTRAINT plano_acao_item_contato_contato FOREIGN KEY (plano_acao_item_contato_contato) REFERENCES contatos (contato_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_acao_item_contato_plano_acao_item FOREIGN KEY (plano_acao_item_contato_plano_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS arquivo_pasta;

CREATE TABLE arquivo_pasta (
  arquivo_pasta_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  arquivo_pasta_superior INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_pasta_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_pasta_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_pasta_dono INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_pasta_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_pasta_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_pasta_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  arquivo_pasta_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_pasta_acao INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_pasta_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_pasta_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_pasta_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_pasta_tema INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_pasta_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_pasta_fator INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_pasta_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_pasta_meta INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_pasta_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_pasta_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_pasta_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_pasta_ata INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_pasta_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_pasta_nome VARCHAR(255) DEFAULT NULL,
  arquivo_pasta_descricao MEDIUMTEXT,
  arquivo_pasta_cor VARCHAR(6) DEFAULT 'FFFFFF',
  arquivo_pasta_ativo TINYINT(1) DEFAULT 1,
  PRIMARY KEY (arquivo_pasta_id),
  KEY arquivo_pasta_superior (arquivo_pasta_superior),
  KEY arquivo_pasta_nome (arquivo_pasta_nome),
  KEY arquivo_pasta_cia (arquivo_pasta_cia),
  KEY arquivo_pasta_dept (arquivo_pasta_dept),
  KEY arquivo_pasta_dono (arquivo_pasta_dono),
  KEY arquivo_pasta_projeto (arquivo_pasta_projeto),
  KEY arquivo_pasta_tarefa (arquivo_pasta_tarefa),
  KEY arquivo_pasta_pratica (arquivo_pasta_pratica),
  KEY arquivo_pasta_acao (arquivo_pasta_acao),
  KEY arquivo_pasta_indicador (arquivo_pasta_indicador),
  KEY arquivo_pasta_usuario (arquivo_pasta_usuario),
  KEY arquivo_pasta_perspectiva (arquivo_pasta_perspectiva),
  KEY arquivo_pasta_tema (arquivo_pasta_tema),
  KEY arquivo_pasta_objetivo (arquivo_pasta_objetivo),
  KEY arquivo_pasta_fator (arquivo_pasta_fator),
  KEY arquivo_pasta_estrategia (arquivo_pasta_estrategia),
  KEY arquivo_pasta_meta (arquivo_pasta_meta),
  KEY arquivo_pasta_demanda (arquivo_pasta_demanda),
  KEY arquivo_pasta_instrumento (arquivo_pasta_instrumento),
  KEY arquivo_pasta_calendario (arquivo_pasta_calendario),
  KEY arquivo_pasta_ata (arquivo_pasta_ata),
  KEY arquivo_pasta_canvas (arquivo_pasta_canvas),
  CONSTRAINT arquivo_pasta_superior FOREIGN KEY (arquivo_pasta_superior) REFERENCES arquivo_pasta (arquivo_pasta_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT arquivo_pasta_cia FOREIGN KEY (arquivo_pasta_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT arquivo_pasta_dept FOREIGN KEY (arquivo_pasta_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT arquivo_pasta_dono FOREIGN KEY (arquivo_pasta_dono) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT arquivo_pasta_projeto FOREIGN KEY (arquivo_pasta_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT arquivo_pasta_tarefa FOREIGN KEY (arquivo_pasta_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT arquivo_pasta_pratica FOREIGN KEY (arquivo_pasta_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT arquivo_pasta_acao FOREIGN KEY (arquivo_pasta_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT arquivo_pasta_indicador FOREIGN KEY (arquivo_pasta_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT arquivo_pasta_usuario FOREIGN KEY (arquivo_pasta_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT arquivo_pasta_objetivo FOREIGN KEY (arquivo_pasta_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT arquivo_pasta_fator FOREIGN KEY (arquivo_pasta_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT arquivo_pasta_estrategia FOREIGN KEY (arquivo_pasta_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT arquivo_pasta_meta FOREIGN KEY (arquivo_pasta_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT arquivo_pasta_tema FOREIGN KEY (arquivo_pasta_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_demanda FOREIGN KEY (arquivo_pasta_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_calendario FOREIGN KEY (arquivo_pasta_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_ata FOREIGN KEY (arquivo_pasta_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_perspectiva FOREIGN KEY (arquivo_pasta_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_instrumento FOREIGN KEY (arquivo_pasta_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_pasta_canvas FOREIGN KEY (arquivo_pasta_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS arquivo_pasta_dept;

CREATE TABLE arquivo_pasta_dept (
  arquivo_pasta_dept_pasta INTEGER(100) UNSIGNED NOT NULL,
  arquivo_pasta_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (arquivo_pasta_dept_pasta, arquivo_pasta_dept_dept),
  KEY arquivo_pasta_dept_pasta (arquivo_pasta_dept_pasta),
  KEY arquivo_pasta_dept_dept (arquivo_pasta_dept_dept),
  CONSTRAINT arquivo_pasta_dept_dept FOREIGN KEY (arquivo_pasta_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT arquivo_pasta_dept_pasta FOREIGN KEY (arquivo_pasta_dept_pasta) REFERENCES arquivo_pasta (arquivo_pasta_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS arquivo_pasta_cia;

CREATE TABLE arquivo_pasta_cia (
  arquivo_pasta_cia_pasta INTEGER(100) UNSIGNED NOT NULL,
  arquivo_pasta_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (arquivo_pasta_cia_pasta, arquivo_pasta_cia_cia),
  KEY arquivo_pasta_cia_pasta (arquivo_pasta_cia_pasta),
  KEY arquivo_pasta_cia_cia (arquivo_pasta_cia_cia),
  CONSTRAINT arquivo_pasta_cia_cia FOREIGN KEY (arquivo_pasta_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT arquivo_pasta_cia_pasta FOREIGN KEY (arquivo_pasta_cia_pasta) REFERENCES arquivo_pasta (arquivo_pasta_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS arquivo_pasta_usuario;

CREATE TABLE arquivo_pasta_usuario (
  arquivo_pasta_usuario_pasta INTEGER(100) UNSIGNED NOT NULL,
  arquivo_pasta_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (arquivo_pasta_usuario_pasta, arquivo_pasta_usuario_usuario),
  KEY arquivo_pasta_usuario_pasta (arquivo_pasta_usuario_pasta),
  KEY arquivo_pasta_usuario_usuario (arquivo_pasta_usuario_usuario),
  CONSTRAINT arquivo_pasta_usuario_usuario FOREIGN KEY (arquivo_pasta_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT arquivo_pasta_usuario_pasta FOREIGN KEY (arquivo_pasta_usuario_pasta) REFERENCES arquivo_pasta (arquivo_pasta_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS arquivo;

CREATE TABLE arquivo (
  arquivo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  arquivo_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_dono INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_usuario_upload INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_pasta INTEGER(100) UNSIGNED DEFAULT NULL,
  chave_publica INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_acao INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_tema INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_fator INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_meta INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_ata INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_principal_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_versao_id INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_categoria INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_nome VARCHAR(255) DEFAULT NULL,
  arquivo_nome_real VARCHAR(255) DEFAULT NULL,
  arquivo_local VARCHAR (255) DEFAULT NULL,
  arquivo_descricao MEDIUMTEXT,
  arquivo_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  assinatura TEXT,
  arquivo_data DATETIME DEFAULT NULL,
  arquivo_tipo VARCHAR(100) DEFAULT NULL,
  arquivo_versao DECIMAL(20,5) UNSIGNED DEFAULT 0,
  arquivo_saida VARCHAR(16) DEFAULT NULL,
  arquivo_motivo_saida TEXT,
  arquivo_icone VARCHAR(20) DEFAULT 'obj/',
  arquivo_tamanho INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
  arquivo_cor VARCHAR(6) DEFAULT 'FFFFFF',
	arquivo_ativo TINYINT(1) DEFAULT 1,
	arquivo_aprovado TINYINT(1) DEFAULT 0,
  PRIMARY KEY (arquivo_id),
  KEY arquivo_dono (arquivo_dono),
  KEY arquivo_usuario_upload (arquivo_usuario_upload),
  KEY arquivo_tarefa (arquivo_tarefa),
  KEY arquivo_projeto (arquivo_projeto),
  KEY arquivo_versao_id (arquivo_versao_id),
  KEY arquivo_nome (arquivo_nome),
  KEY arquivo_pasta (arquivo_pasta),
  KEY arquivo_categoria (arquivo_categoria),
  KEY arquivo_saida (arquivo_saida),
  KEY arquivo_cia (arquivo_cia),
  KEY arquivo_dept (arquivo_dept),
  KEY arquivo_usuario (arquivo_usuario),
  KEY arquivo_pratica (arquivo_pratica),
  KEY arquivo_acao (arquivo_acao),
  KEY arquivo_indicador (arquivo_indicador),
  KEY arquivo_objetivo (arquivo_objetivo),
  KEY arquivo_fator (arquivo_fator),
  KEY arquivo_estrategia (arquivo_estrategia),
  KEY arquivo_meta (arquivo_meta),
  KEY arquivo_perspectiva (arquivo_perspectiva),
  KEY arquivo_tema (arquivo_tema),
  KEY arquivo_demanda (arquivo_demanda),
  KEY arquivo_instrumento (arquivo_instrumento),
  KEY arquivo_calendario (arquivo_calendario),
  KEY arquivo_canvas (arquivo_canvas),
  KEY arquivo_ata (arquivo_ata),
  KEY arquivo_principal_indicador (arquivo_principal_indicador),
  KEY arquivo_moeda (arquivo_moeda),
	CONSTRAINT arquivo_moeda FOREIGN KEY (arquivo_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT arquivo_usuario_upload FOREIGN KEY (arquivo_usuario_upload) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT arquivo_dono FOREIGN KEY (arquivo_dono) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT arquivo_cia FOREIGN KEY (arquivo_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT arquivo_dept FOREIGN KEY (arquivo_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT arquivo_usuario FOREIGN KEY (arquivo_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT arquivo_projeto FOREIGN KEY (arquivo_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT arquivo_tarefa FOREIGN KEY (arquivo_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT arquivo_pratica FOREIGN KEY (arquivo_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT arquivo_acao FOREIGN KEY (arquivo_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT arquivo_indicador FOREIGN KEY (arquivo_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT arquivo_objetivo FOREIGN KEY (arquivo_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT arquivo_fator FOREIGN KEY (arquivo_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
 	CONSTRAINT arquivo_estrategia FOREIGN KEY (arquivo_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT arquivo_meta FOREIGN KEY (arquivo_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT arquivo_tema FOREIGN KEY (arquivo_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_demanda FOREIGN KEY (arquivo_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_calendario FOREIGN KEY (arquivo_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_ata FOREIGN KEY (arquivo_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_perspectiva_fk FOREIGN KEY (arquivo_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_instrumento FOREIGN KEY (arquivo_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_canvas FOREIGN KEY (arquivo_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_principal_indicador FOREIGN KEY (arquivo_principal_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS arquivo_dept;

CREATE TABLE arquivo_dept (
  arquivo_dept_arquivo INTEGER(100) UNSIGNED NOT NULL,
  arquivo_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (arquivo_dept_arquivo, arquivo_dept_dept),
  KEY arquivo_dept_arquivo (arquivo_dept_arquivo),
  KEY arquivo_dept_dept (arquivo_dept_dept),
  CONSTRAINT arquivo_dept_dept FOREIGN KEY (arquivo_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT arquivo_dept_arquivo FOREIGN KEY (arquivo_dept_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS arquivo_usuario;

CREATE TABLE arquivo_usuario (
  arquivo_usuario_arquivo INTEGER(100) UNSIGNED NOT NULL,
  arquivo_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (arquivo_usuario_arquivo, arquivo_usuario_usuario),
  KEY arquivo_usuario_arquivo (arquivo_usuario_arquivo),
  KEY arquivo_usuario_usuario (arquivo_usuario_usuario),
  CONSTRAINT arquivo_usuario_usuario FOREIGN KEY (arquivo_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT arquivo_usuario_arquivo FOREIGN KEY (arquivo_usuario_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS arquivo_saida;

CREATE TABLE arquivo_saida (
	arquivo_saida_id	INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  arquivo_saida_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_saida_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_saida_data DATETIME,
  arquivo_saida_motivo MEDIUMTEXT,
  arquivo_saida_acao VARCHAR(50),
  arquivo_saida_versao DECIMAL(20,5) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (arquivo_saida_id),
  KEY arquivo_saida_arquivo (arquivo_saida_arquivo),
  KEY arquivo_saida_usuario (arquivo_saida_usuario),
  CONSTRAINT arquivo_saida_usuario FOREIGN KEY (arquivo_saida_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT arquivo_saida_arquivo FOREIGN KEY (arquivo_saida_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS arquivo_historico;

CREATE TABLE arquivo_historico (
	arquivo_historico_id	INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  arquivo_id INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_dono INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_usuario_upload INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_pasta INTEGER(100) UNSIGNED DEFAULT NULL,
  chave_publica INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_acao INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_tema INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_fator INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_meta INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_ata INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_principal_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_versao_id INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_categoria INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_nome VARCHAR(255) DEFAULT NULL,
  arquivo_nome_real VARCHAR(255) DEFAULT NULL,
  arquivo_local VARCHAR (255) DEFAULT NULL,
  arquivo_descricao MEDIUMTEXT,
  arquivo_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  assinatura TEXT,
  arquivo_data DATETIME DEFAULT NULL,
  arquivo_tipo VARCHAR(100) DEFAULT NULL,
  arquivo_versao DECIMAL(20,5) UNSIGNED DEFAULT 0,
  arquivo_saida VARCHAR(16) DEFAULT NULL,
  arquivo_motivo_saida TEXT,
  arquivo_icone VARCHAR(20) DEFAULT 'obj/',
  arquivo_tamanho INTEGER(100) UNSIGNED DEFAULT NULL,
  arquivo_cor VARCHAR(6) DEFAULT 'FFFFFF',
	arquivo_ativo TINYINT(1) DEFAULT 1,
	arquivo_moeda INTEGER(100) UNSIGNED DEFAULT 1,
	arquivo_aprovado TINYINT(1) DEFAULT 0,
  PRIMARY KEY (arquivo_historico_id),
  KEY arquivo_dono (arquivo_dono),
  KEY arquivo_usuario_upload (arquivo_usuario_upload),
  KEY arquivo_id (arquivo_id),
  KEY arquivo_tarefa (arquivo_tarefa),
  KEY arquivo_projeto (arquivo_projeto),
  KEY arquivo_versao_id (arquivo_versao_id),
  KEY arquivo_nome (arquivo_nome),
  KEY arquivo_pasta (arquivo_pasta),
  KEY arquivo_categoria (arquivo_categoria),
  KEY arquivo_saida (arquivo_saida),
  KEY arquivo_cia (arquivo_cia),
  KEY arquivo_dept (arquivo_dept),
  KEY arquivo_usuario (arquivo_usuario),
  KEY arquivo_pratica (arquivo_pratica),
  KEY arquivo_acao (arquivo_acao),
  KEY arquivo_indicador (arquivo_indicador),
  KEY arquivo_objetivo (arquivo_objetivo),
  KEY arquivo_fator (arquivo_fator),
  KEY arquivo_estrategia (arquivo_estrategia),
  KEY arquivo_meta (arquivo_meta),
  KEY arquivo_perspectiva (arquivo_perspectiva),
  KEY arquivo_tema (arquivo_tema),
  KEY arquivo_demanda (arquivo_demanda),
  KEY arquivo_instrumento (arquivo_instrumento),
  KEY arquivo_calendario (arquivo_calendario),
  KEY arquivo_ata (arquivo_ata),
  KEY arquivo_canvas (arquivo_canvas),
  KEY arquivo_principal_indicador (arquivo_principal_indicador),
  KEY arquivo_moeda (arquivo_moeda),
  CONSTRAINT arquivo_historico_usuario_upload FOREIGN KEY (arquivo_usuario_upload) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT arquivo_historico_dono FOREIGN KEY (arquivo_dono) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT arquivo_historico_arquivo FOREIGN KEY (arquivo_id) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT arquivo_historico_cia FOREIGN KEY (arquivo_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT arquivo_historico_dept FOREIGN KEY (arquivo_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT arquivo_historico_usuario FOREIGN KEY (arquivo_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT arquivo_historico_projeto FOREIGN KEY (arquivo_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT arquivo_historico_tarefa FOREIGN KEY (arquivo_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT arquivo_historico_pratica FOREIGN KEY (arquivo_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT arquivo_historico_acao FOREIGN KEY (arquivo_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT arquivo_historico_indicador FOREIGN KEY (arquivo_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT arquivo_historico_objetivo FOREIGN KEY (arquivo_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT arquivo_historico_fator FOREIGN KEY (arquivo_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
 	CONSTRAINT arquivo_historico_estrategia FOREIGN KEY (arquivo_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT arquivo_historico_meta FOREIGN KEY (arquivo_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT arquivo_historico_tema FOREIGN KEY (arquivo_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_historico_demanda FOREIGN KEY (arquivo_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_historico_calendario FOREIGN KEY (arquivo_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_historico_ata FOREIGN KEY (arquivo_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_historico_perspectiva_fk FOREIGN KEY (arquivo_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_historico_instrumento FOREIGN KEY (arquivo_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_historico_canvas FOREIGN KEY (arquivo_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT arquivo_historico_principal_indicador FOREIGN KEY (arquivo_principal_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT arquivo_historico_moeda FOREIGN KEY (arquivo_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline;

CREATE TABLE baseline (
  baseline_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  baseline_projeto_id INTEGER(100) UNSIGNED DEFAULT NULL,
  baseline_nome VARCHAR(255) DEFAULT NULL,
  baseline_data DATETIME DEFAULT NULL,
  baseline_descricao MEDIUMTEXT,
  PRIMARY KEY (baseline_id),
  KEY baseline_projeto_id (baseline_projeto_id),
  CONSTRAINT baseline_fk FOREIGN KEY (baseline_projeto_id) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_eventos;

CREATE TABLE baseline_eventos (
  baseline_id INTEGER(100) UNSIGNED NOT NULL,
  evento_id INTEGER(100) UNSIGNED NOT NULL,
  evento_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  evento_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  evento_dono INTEGER(100) UNSIGNED DEFAULT NULL,
  evento_recorrencia_pai INTEGER(100) UNSIGNED DEFAULT NULL,
  evento_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  evento_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  evento_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
  evento_acao INTEGER(100) UNSIGNED DEFAULT NULL,
  evento_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
  evento_tema INTEGER(100) UNSIGNED DEFAULT NULL,
  evento_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
  evento_fator INTEGER(100) UNSIGNED DEFAULT NULL,
  evento_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
  evento_meta INTEGER(100) UNSIGNED DEFAULT NULL,
  evento_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  evento_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
  evento_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
  evento_principal_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  evento_titulo VARCHAR(255) DEFAULT NULL,
  evento_inicio DATETIME DEFAULT NULL,
  evento_fim DATETIME DEFAULT NULL,
  evento_duracao DECIMAL(20,5) UNSIGNED DEFAULT NULL,
  evento_descricao MEDIUMTEXT,
  evento_oque TEXT,
	evento_onde TEXT,
	evento_quando TEXT,
	evento_como TEXT,
	evento_porque TEXT,
	evento_quanto TEXT,
	evento_quem TEXT,
  evento_url VARCHAR(255) DEFAULT NULL,
  evento_nr_recorrencias INTEGER(100) UNSIGNED DEFAULT NULL,
  evento_recorrencias INTEGER(100) UNSIGNED DEFAULT NULL,
  evento_lembrar INTEGER(100) UNSIGNED DEFAULT NULL,
  evento_icone VARCHAR(20) DEFAULT 'obj/evento',
  evento_tipo TINYINT(3) DEFAULT 0,
  evento_diautil TINYINT(3) DEFAULT 0,
  evento_notificar TINYINT(3) DEFAULT 0,
  evento_localizacao VARCHAR(255) DEFAULT NULL,
  evento_moeda INTEGER(100) UNSIGNED DEFAULT 1,
  evento_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  evento_cor VARCHAR(6) DEFAULT 'fff0b0',
  evento_aprovado TINYINT(1) DEFAULT 0,
  evento_ativo INTEGER(1) DEFAULT 1,
  evento_uid VARCHAR(255) DEFAULT NULL,
  PRIMARY KEY (baseline_id, evento_id),
  CONSTRAINT baseline_eventos_fk FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
	)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_municipio_lista;

CREATE TABLE baseline_municipio_lista (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	municipio_lista_id INTEGER(100) UNSIGNED NOT NULL,
	municipio_lista_municipio INTEGER(100) UNSIGNED DEFAULT NULL,
	municipio_lista_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	municipio_lista_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	municipio_lista_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	municipio_lista_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	municipio_lista_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	municipio_lista_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
	municipio_lista_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	municipio_lista_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	municipio_lista_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	municipio_lista_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	municipio_lista_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	municipio_lista_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	municipio_lista_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (baseline_id, municipio_lista_id),
	CONSTRAINT baseline_municipio_lista_fk13 FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_projeto_area;

CREATE TABLE baseline_projeto_area (
  baseline_id INTEGER(100) UNSIGNED NOT NULL,
  projeto_area_id INTEGER(100) UNSIGNED NOT NULL,
  projeto_area_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_area_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_area_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_area_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_area_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_area_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_area_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_area_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_area_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_area_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_area_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_area_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_area_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_area_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_area_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_area_nome VARCHAR(255) DEFAULT NULL,
  projeto_area_obs MEDIUMTEXT,
  projeto_area_cor VARCHAR(6) DEFAULT 'ffffff',
  projeto_area_espessura INTEGER(10) UNSIGNED DEFAULT '2',
  projeto_area_opacidade FLOAT DEFAULT '0.5',
  projeto_area_poligono TINYINT(1) DEFAULT 1,
  uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (baseline_id, projeto_area_id),
  CONSTRAINT baseline_projeto_area_fk FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS baseline_projeto_ponto;

CREATE TABLE baseline_projeto_ponto (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
  projeto_ponto_id INTEGER(100) UNSIGNED NOT NULL,
  projeto_area_id INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_ponto_latitude DECIMAL(10,6) DEFAULT NULL,
  projeto_ponto_longitude DECIMAL(10,6) DEFAULT NULL,
  PRIMARY KEY (baseline_id, projeto_ponto_id),
  CONSTRAINT baseline_projeto_ponto_fk FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_projeto_portfolio;

CREATE TABLE baseline_projeto_portfolio (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
  projeto_portfolio_pai INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_portfolio_filho INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_portfolio_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  uuid VARCHAR(36) DEFAULT NULL,
  CONSTRAINT baseline_projeto_portfolio_fk FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_projeto_contatos;

CREATE TABLE baseline_projeto_contatos (
  baseline_id INTEGER(100) UNSIGNED NOT NULL,
  projeto_contato_id INTEGER(100) UNSIGNED NOT NULL,
  projeto_id INTEGER(100) UNSIGNED DEFAULT NULL,
  contato_id INTEGER(100) UNSIGNED DEFAULT NULL,
  ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  envolvimento VARCHAR(255) DEFAULT NULL,
  perfil MEDIUMTEXT,
  uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (baseline_id, projeto_contato_id),
  CONSTRAINT baseline_projeto_contatos_fk FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_projeto_depts;

CREATE TABLE baseline_projeto_depts (
  baseline_id INTEGER(100) UNSIGNED NOT NULL,
  projeto_id INTEGER(100) UNSIGNED NOT NULL,
  departamento_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (baseline_id, projeto_id, departamento_id),
  CONSTRAINT baseline_projeto_depts_fk FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_projeto_integrantes;

CREATE TABLE baseline_projeto_integrantes (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
  projeto_integrantes_id INTEGER(100) UNSIGNED NOT NULL,
  projeto_id INTEGER(100) UNSIGNED DEFAULT NULL,
  contato_id INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_integrante_competencia VARCHAR(255) DEFAULT NULL,
  projeto_integrante_atributo MEDIUMTEXT,
  projeto_integrantes_situacao MEDIUMTEXT,
  projeto_integrantes_necessidade MEDIUMTEXT,
  ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (baseline_id, projeto_integrantes_id),
  CONSTRAINT baseline_projeto_integrantes_fk FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;




DROP TABLE IF EXISTS baseline_projetos;

CREATE TABLE baseline_projetos (
  baseline_id INTEGER(100) UNSIGNED NOT NULL,
  projeto_id INTEGER(100) UNSIGNED NOT NULL,
  projeto_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_criador INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_supervisor INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_autoridade INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_cliente INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_atualizador INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_superior INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_superior_original INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_tema INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_objetivo_estrategico INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_meta INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_fator INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_acao INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_nome VARCHAR(255) DEFAULT NULL,
  projeto_nome_curto VARCHAR(255) DEFAULT NULL,
  projeto_codigo VARCHAR(50) DEFAULT NULL,
  projeto_sequencial INTEGER(100) DEFAULT NULL,
  projeto_url VARCHAR(255) DEFAULT NULL,
  projeto_url_externa VARCHAR(255) DEFAULT NULL,
  projeto_data_inicio DATETIME DEFAULT NULL,
  projeto_data_fim DATETIME DEFAULT NULL,
  projeto_fim_atualizado DATETIME DEFAULT NULL,
  projeto_status INTEGER(100) UNSIGNED DEFAULT 0,
  projeto_fase INTEGER(10) UNSIGNED DEFAULT 0,
  projeto_percentagem DECIMAL(20,5) UNSIGNED DEFAULT 0,
  projeto_custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
  projeto_gasto DECIMAL(20,5) UNSIGNED DEFAULT 0,
  projeto_cor VARCHAR(6) DEFAULT 'eeeeee',
  projeto_descricao MEDIUMTEXT,
  projeto_objetivos MEDIUMTEXT,
  projeto_observacao MEDIUMTEXT,
  projeto_como MEDIUMTEXT,
  projeto_localizacao MEDIUMTEXT,
  projeto_beneficiario MEDIUMTEXT,
  projeto_meta_custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
  projeto_custo_atual DECIMAL(20,5) UNSIGNED DEFAULT 0,
  projeto_privativo TINYINT(3) UNSIGNED DEFAULT 0,
  projeto_prioridade TINYINT(4) DEFAULT 0,
  projeto_tipo SMALLINT(6) DEFAULT 0,
  projeto_data_chave DATETIME DEFAULT NULL,
  projeto_data_chave_pos TINYINT(1) DEFAULT 0,
  projeto_tarefa_chave INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_ativo INTEGER(1) DEFAULT 1,
  projeto_especial INTEGER(1) DEFAULT 0,
  projeto_criado DATETIME DEFAULT NULL,
  projeto_atualizado DATETIME DEFAULT NULL,
  projeto_data_fim_ajustada DATETIME DEFAULT NULL,
  projeto_status_comentario VARCHAR(255) DEFAULT NULL,
  projeto_subprioridade TINYINT(4) DEFAULT 0,
  projeto_data_fim_ajustada_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  projeto_endereco1 VARCHAR(100) DEFAULT NULL,
  projeto_endereco2 VARCHAR(100) DEFAULT NULL,
  projeto_cidade VARCHAR(7) DEFAULT NULL,
  projeto_estado VARCHAR(2) DEFAULT NULL,
  projeto_cep VARCHAR(9) DEFAULT NULL,
  projeto_pais VARCHAR(30) DEFAULT NULL,
  projeto_latitude VARCHAR(200) DEFAULT NULL,
  projeto_longitude VARCHAR(200) DEFAULT NULL,
  projeto_setor VARCHAR(2) DEFAULT NULL,
  projeto_segmento VARCHAR(4) DEFAULT NULL,
  projeto_intervencao VARCHAR(6) DEFAULT NULL,
  projeto_tipo_intervencao VARCHAR(9) DEFAULT NULL,
  projeto_ano VARCHAR(4) DEFAULT NULL,
  projeto_portfolio INTEGER(1) DEFAULT 0,
  projeto_plano_operativo INTEGER(1) DEFAULT 0,
  projeto_comunidade INTEGER(100) DEFAULT NULL,
	projeto_social INTEGER(100) DEFAULT NULL,
	projeto_social_acao INTEGER(100) DEFAULT NULL,
	projeto_principal_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_template INTEGER(1) DEFAULT 0,
	projeto_justificativa MEDIUMTEXT,
	projeto_objetivo MEDIUMTEXT,
	projeto_objetivo_especifico MEDIUMTEXT,
	projeto_escopo MEDIUMTEXT,
	projeto_nao_escopo MEDIUMTEXT,
	projeto_premissas MEDIUMTEXT,
	projeto_restricoes MEDIUMTEXT,
	projeto_orcamento MEDIUMTEXT,
	projeto_beneficio MEDIUMTEXT,
	projeto_produto MEDIUMTEXT,
	projeto_requisito MEDIUMTEXT,
	portfolio_externo VARCHAR(255),
	projeto_fonte VARCHAR(255) DEFAULT NULL,
	projeto_alerta TINYINT(1) DEFAULT 0,
	projeto_fisico_registro TINYINT(1) DEFAULT 0,
	projeto_trava_data TINYINT(1) DEFAULT 0,
	projeto_aprova_registro TINYINT(1) DEFAULT 0,
	projeto_moeda INTEGER(100) UNSIGNED DEFAULT 1,
	projeto_encerramento DATE DEFAULT NULL,
	projeto_programa_financeiro VARCHAR(255) DEFAULT NULL,
	projeto_convenio VARCHAR(255) DEFAULT NULL,	
	projeto_aprovado TINYINT(1) DEFAULT 0,
  PRIMARY KEY (baseline_id, projeto_id),
  KEY baseline_id (baseline_id),
  CONSTRAINT baseline_projetos_fk FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_recurso_tarefas;

CREATE TABLE baseline_recurso_tarefas (
  baseline_id INTEGER(100) UNSIGNED NOT NULL,
  recurso_tarefa_id INTEGER(100) UNSIGNED NOT NULL,
  recurso_id INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_id INTEGER(100) UNSIGNED DEFAULT NULL,
  percentual_alocado INTEGER(100) UNSIGNED DEFAULT '100',
  recurso_quantidade DECIMAL(20,5) UNSIGNED DEFAULT 0,
  recurso_tarefa_ordem INT(100) UNSIGNED DEFAULT NULL,
  recurso_tarefa_uuid varchar(36) DEFAULT NULL,
  PRIMARY KEY (baseline_id, recurso_tarefa_id),
  CONSTRAINT baseline_recurso_tarefas_fk FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_tarefa_contatos;

CREATE TABLE baseline_tarefa_contatos (
  baseline_id INTEGER(100) UNSIGNED NOT NULL,
  tarefa_id INTEGER(100) UNSIGNED NOT NULL,
  contato_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (baseline_id, tarefa_id, contato_id),
  CONSTRAINT baseline_tarefa_contatos_fk FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS baseline_tarefa_custos;

CREATE TABLE baseline_tarefa_custos (
  baseline_id INTEGER(100) UNSIGNED NOT NULL,
  tarefa_custos_id INTEGER(100) UNSIGNED NOT NULL,
  tarefa_custos_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_custos_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_custos_tr INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_custos_nome VARCHAR(255) DEFAULT NULL,
  tarefa_custos_codigo VARCHAR(255) DEFAULT NULL,
  tarefa_custos_fonte VARCHAR(255) DEFAULT NULL,
  tarefa_custos_regiao VARCHAR(255) DEFAULT NULL,
  tarefa_custos_tipo INTEGER(100) UNSIGNED DEFAULT 1,
  tarefa_custos_data DATETIME DEFAULT NULL,
  tarefa_custos_quantidade DECIMAL(20,5) UNSIGNED DEFAULT 0,
  tarefa_custos_custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
  tarefa_custos_bdi DECIMAL(20,5) UNSIGNED DEFAULT 0,
  tarefa_custos_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
	tarefa_custos_cotacao DECIMAL(6,5) UNSIGNED DEFAULT 1,
	tarefa_custos_data_moeda DATE DEFAULT NULL, 
  tarefa_custos_percentagem TINYINT(4) DEFAULT 0,
  tarefa_custos_descricao MEDIUMTEXT,
  tarefa_custos_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_custos_nd VARCHAR(11) DEFAULT NULL,
  tarefa_custos_categoria_economica VARCHAR(1) DEFAULT NULL,
  tarefa_custos_grupo_despesa VARCHAR(1) DEFAULT NULL,
  tarefa_custos_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  tarefa_custos_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	tarefa_custos_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
	tarefa_custos_data_limite DATE DEFAULT NULL,
	tarefa_custos_pi VARCHAR(100) DEFAULT NULL,
	tarefa_custos_ptres VARCHAR(100) DEFAULT NULL,
	tarefa_custos_aprovou INTEGER(100) UNSIGNED DEFAULT NULL,
	tarefa_custos_aprovado TINYINT(1) DEFAULT NULL,
	tarefa_custos_data_aprovado DATETIME DEFAULT NULL,
  PRIMARY KEY (baseline_id, tarefa_custos_id),
  CONSTRAINT baseline_tarefa_custos_fk FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_tarefa_dependencias;

CREATE TABLE baseline_tarefa_dependencias (
  baseline_id INTEGER(100) UNSIGNED NOT NULL,
  dependencias_tarefa_id INTEGER(100) UNSIGNED NOT NULL,
  dependencias_req_tarefa_id INTEGER(100) UNSIGNED NOT NULL,
  tipo_dependencia VARCHAR(3) DEFAULT 'TI',
  latencia INTEGER(100) DEFAULT 0,
  tipo_latencia VARCHAR(1) DEFAULT 'd',
  dependencia_forte  TINYINT(1) DEFAULT '0',
  PRIMARY KEY (baseline_id, dependencias_tarefa_id, dependencias_req_tarefa_id),
  CONSTRAINT baseline_tarefa_dependencias_fk FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_tarefa_depts;

CREATE TABLE baseline_tarefa_depts (
  baseline_id INTEGER(100) UNSIGNED NOT NULL,
  tarefa_id INTEGER(100) UNSIGNED NOT NULL,
  departamento_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (baseline_id, tarefa_id, departamento_id),
  CONSTRAINT baseline_tarefa_depts_fk FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_tarefa_designados;

CREATE TABLE baseline_tarefa_designados (
  baseline_id INTEGER(100) UNSIGNED NOT NULL,
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  tarefa_id INTEGER(100) UNSIGNED NOT NULL,
  usuario_admin TINYINT(4) DEFAULT 0,
  perc_designado DECIMAL(10,3) UNSIGNED DEFAULT 100,
  usuario_tarefa_prioridade TINYINT(4) DEFAULT 0,
  PRIMARY KEY (baseline_id, tarefa_id, usuario_id),
  CONSTRAINT baseline_tarefa_designados_fk FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_tarefa_gastos;

CREATE TABLE baseline_tarefa_gastos (
  baseline_id INTEGER(100) UNSIGNED NOT NULL,
  tarefa_gastos_id INTEGER(100) UNSIGNED NOT NULL,
  tarefa_gastos_nome VARCHAR(255) DEFAULT NULL,
  tarefa_gastos_codigo VARCHAR(255) DEFAULT NULL,
  tarefa_gastos_fonte VARCHAR(255) DEFAULT NULL,
  tarefa_gastos_regiao VARCHAR(255) DEFAULT NULL,
  tarefa_gastos_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_gastos_tipo INTEGER(100) UNSIGNED DEFAULT 1,
  tarefa_gastos_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_gastos_data DATETIME DEFAULT NULL,
  tarefa_gastos_quantidade DECIMAL(20,5) UNSIGNED DEFAULT 0,
  tarefa_gastos_custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
  tarefa_gastos_bdi DECIMAL(20,5) UNSIGNED DEFAULT 0,
	tarefa_gastos_moeda INTEGER(100) UNSIGNED DEFAULT 1,  
	tarefa_gastos_cotacao DECIMAL(6,5) UNSIGNED DEFAULT 1, 
	tarefa_gastos_data_moeda DATE DEFAULT NULL,
  tarefa_gastos_percentagem TINYINT(4) DEFAULT 0,
  tarefa_gastos_descricao MEDIUMTEXT,
  tarefa_gastos_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_gastos_nd VARCHAR(11) DEFAULT NULL,
  tarefa_gastos_categoria_economica VARCHAR(1) DEFAULT NULL,
  tarefa_gastos_grupo_despesa VARCHAR(1) DEFAULT NULL,
  tarefa_gastos_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  tarefa_gastos_data_recebido DATE DEFAULT NULL,
  tarefa_gastos_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	tarefa_gastos_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
	tarefa_gastos_empenhado DECIMAL(20,5) UNSIGNED DEFAULT 0,
	tarefa_gastos_entregue DECIMAL(20,5) UNSIGNED DEFAULT 0,
	tarefa_gastos_liquidado DECIMAL(20,5) UNSIGNED DEFAULT 0,
	tarefa_gastos_pago DECIMAL(20,5) UNSIGNED DEFAULT 0,
	tarefa_gastos_pi VARCHAR(100) DEFAULT NULL,
	tarefa_gastos_ptres VARCHAR(100) DEFAULT NULL,
	tarefa_gastos_aprovou INTEGER(100) UNSIGNED DEFAULT NULL,
	tarefa_gastos_aprovado TINYINT(1) DEFAULT NULL,
	tarefa_gastos_data_aprovado DATETIME DEFAULT NULL,
  PRIMARY KEY (baseline_id, tarefa_gastos_id),
  CONSTRAINT baseline_tarefa_gastos_fk FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_tarefas;

CREATE TABLE baseline_tarefas (
  baseline_id INTEGER(100) UNSIGNED NOT NULL,
  tarefa_id INTEGER(100) UNSIGNED NOT NULL,
  tarefa_nome VARCHAR(255) DEFAULT NULL,
  tarefa_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_superior INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_comunidade INTEGER(100) DEFAULT NULL,
	tarefa_social INTEGER(100) DEFAULT NULL,
	tarefa_acao INTEGER(100) DEFAULT NULL,
	tarefa_principal_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_marco TINYINT(1) DEFAULT 0,
  tarefa_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_dono INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_inicio DATETIME DEFAULT NULL,
  tarefa_inicio_calculado TINYINT(1) DEFAULT 0,
  tarefa_duracao DECIMAL(20,5) UNSIGNED DEFAULT 0,
  tarefa_duracao_tipo INTEGER(100) UNSIGNED DEFAULT 1,
  tarefa_horas_trabalhadas DECIMAL(20,5) UNSIGNED DEFAULT 0,
  tarefa_fim DATETIME DEFAULT NULL,
  tarefa_status INTEGER(100) DEFAULT 0,
  tarefa_prioridade TINYINT(4) DEFAULT 0,
  tarefa_percentagem DECIMAL(20,5) UNSIGNED DEFAULT 0,
  tarefa_percentagem_data DATETIME DEFAULT NULL,
  tarefa_custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
  tarefa_gasto DECIMAL(20,5) UNSIGNED DEFAULT 0,
  tarefa_descricao MEDIUMTEXT,
  tarefa_onde TEXT,
  tarefa_porque TEXT,
  tarefa_como TEXT,
  tarefa_situacao_atual TEXT,
  tarefa_custo_almejado DECIMAL(20,5) UNSIGNED DEFAULT 0,
  tarefa_url_relacionada VARCHAR(255) DEFAULT NULL,
  tarefa_criador INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_cliente_publicada TINYINT(1) DEFAULT 0,
  tarefa_dinamica TINYINT(1) DEFAULT 0,
  tarefa_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  tarefa_notificar INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_customizado TEXT,
  tarefa_tipo VARCHAR(255) DEFAULT NULL,
  tarefa_atualizador INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_data_criada DATETIME DEFAULT NULL,
  tarefa_data_atualizada DATETIME DEFAULT NULL,
  tarefa_endereco1 VARCHAR(100) DEFAULT NULL,
  tarefa_endereco2 VARCHAR(100) DEFAULT NULL,
  tarefa_cidade VARCHAR(7) DEFAULT NULL,
  tarefa_estado VARCHAR(2) DEFAULT NULL,
  tarefa_cep VARCHAR(9) DEFAULT NULL,
  tarefa_pais VARCHAR(30) DEFAULT NULL,
  tarefa_latitude VARCHAR(200) DEFAULT NULL,
  tarefa_longitude VARCHAR(200) DEFAULT NULL,
  tarefa_emprego_obra INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_emprego_direto INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_emprego_indireto INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_populacao_atendida VARCHAR(100) DEFAULT NULL,
  tarefa_forma_implantacao VARCHAR(100) DEFAULT NULL,
  tarefa_adquirido DECIMAL(20,5) UNSIGNED DEFAULT 0,
  tarefa_previsto DECIMAL(20,5) UNSIGNED DEFAULT 0,
  tarefa_realizado DECIMAL(20,5) UNSIGNED DEFAULT 0,
  tarefa_codigo VARCHAR(50) DEFAULT NULL,
  tarefa_sequencial INTEGER(100) DEFAULT NULL,
  tarefa_setor VARCHAR(2) DEFAULT NULL,
	tarefa_segmento VARCHAR(4) DEFAULT NULL,
	tarefa_intervencao VARCHAR(6) DEFAULT NULL,
	tarefa_tipo_intervencao VARCHAR(9) DEFAULT NULL,
	tarefa_ano VARCHAR(4) DEFAULT NULL,
  tarefa_projetoex_id INT(100) UNSIGNED DEFAULT NULL,
  tarefa_tarefaex_id INT(100) UNSIGNED DEFAULT NULL,
  tarefa_desatualizada INT(1) DEFAULT 0,
  tarefa_unidade VARCHAR(50) DEFAULT NULL,
  tarefa_numeracao INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_gerenciamento INTEGER(1) DEFAULT 0,
  tarefa_alerta TINYINT(1) DEFAULT 0,
  tarefa_manual TINYINT(1) NULL DEFAULT 0,
	tarefa_duracao_manual DECIMAL(20,5) UNSIGNED DEFAULT 0,
	tarefa_inicio_manual DATETIME NULL DEFAULT NULL,
	tarefa_fim_manual DATETIME NULL DEFAULT NULL,
  PRIMARY KEY (baseline_id, tarefa_id),
  CONSTRAINT baseline_tarefas_fk FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS brainstorm_depts;

CREATE TABLE brainstorm_depts (
  brainstorm_id INTEGER(100) UNSIGNED NOT NULL,
  dept_id INTEGER(100) UNSIGNED NOT NULL,
  KEY brainstorm_id (brainstorm_id),
  KEY dept_id (dept_id),
  CONSTRAINT brainstorm_depts_fk1 FOREIGN KEY (dept_id) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT brainstorm_depts_fk FOREIGN KEY (brainstorm_id) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS brainstorm_linha;

CREATE TABLE brainstorm_linha (
  brainstorm_linha_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  brainstorm_id INTEGER(100) UNSIGNED DEFAULT NULL,
  brainstorm_texto TEXT,
  brainstorm_g INTEGER(2) UNSIGNED DEFAULT NULL,
  brainstorm_u INTEGER(2) UNSIGNED DEFAULT NULL,
  brainstorm_t INTEGER(2) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (brainstorm_linha_id),
  KEY brainstorm_id (brainstorm_id),
  CONSTRAINT brainstorm_linha_fk FOREIGN KEY (brainstorm_id) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS brainstorm_usuarios;

CREATE TABLE brainstorm_usuarios (
  brainstorm_id INTEGER(100) UNSIGNED NOT NULL,
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  KEY brainstorm_id (brainstorm_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT brainstorm_usuarios_fk1 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT brainstorm_usuarios_fk FOREIGN KEY (brainstorm_id) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS calendario;

CREATE TABLE calendario (
  calendario_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  calendario_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  calendario_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  calendario_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  calendario_ativo TINYINT(1) DEFAULT 1,
  calendario_nome VARCHAR(255) DEFAULT NULL,
  calendario_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
  calendario_cor VARCHAR(6) DEFAULT 'FFFFFF',
  calendario_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  calendario_descricao TEXT,
  PRIMARY KEY (calendario_id),
  KEY calendario_cia (calendario_cia),
  KEY calendario_dept (calendario_dept),
  KEY calendario_usuario (calendario_usuario),
  KEY calendario_moeda (calendario_moeda),
  CONSTRAINT calendario_cia FOREIGN KEY (calendario_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT calendario_usuario FOREIGN KEY (calendario_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT calendario_dept FOREIGN KEY (calendario_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT calendario_moeda FOREIGN KEY (calendario_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS calendario_dept;

CREATE TABLE calendario_dept (
  calendario_dept_calendario INTEGER(100) UNSIGNED NOT NULL,
  calendario_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (calendario_dept_calendario, calendario_dept_dept),
  KEY calendario_dept_calendario (calendario_dept_calendario),
  KEY calendario_dept_dept (calendario_dept_dept),
  CONSTRAINT calendario_dept_dept FOREIGN KEY (calendario_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT calendario_dept_calendario FOREIGN KEY (calendario_dept_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS calendario_permissao;

CREATE TABLE calendario_permissao (
  calendario_id INTEGER(100) UNSIGNED NOT NULL,
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  KEY calendario_id (calendario_id),
  KEY usuario_id (usuario_id)
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS calendario_usuario;

CREATE TABLE calendario_usuario (
  calendario_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
  calendario_usuario_calendario INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (calendario_usuario_usuario, calendario_usuario_calendario),
  KEY calendario_usuario_usuario (calendario_usuario_usuario),
  KEY calendario_usuario_calendario (calendario_usuario_calendario),
  CONSTRAINT calendario_usuario_calendario FOREIGN KEY (calendario_usuario_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT calendario_usuario_usuario FOREIGN KEY (calendario_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS campo_customizado;

CREATE TABLE campo_customizado (
  campo_customizado_id INTEGER(100) UNSIGNED NOT NULL,
  campo_customizado_modulo VARCHAR(30) DEFAULT NULL,
  campo_customizado_pagina VARCHAR(30) DEFAULT NULL,
  campo_customizado_tipo_html VARCHAR(20) DEFAULT NULL,
  campo_customizado_tipo_dado VARCHAR(20) DEFAULT NULL,
  campo_customizado_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  campo_customizado_nome VARCHAR(100) DEFAULT NULL,
  campo_customizado_tags_extras VARCHAR(250) DEFAULT NULL,
  campo_customizado_descricao VARCHAR(250) DEFAULT NULL,
  campo_customizado_formula TEXT,
  campo_customizado_tab INTEGER(100) UNSIGNED DEFAULT NULL,
  campo_customizado_publicado TINYINT(1) DEFAULT 0,
  campo_customizado_descendente TINYINT(1) DEFAULT 0,
	campo_customizado_por_chave TINYINT(1) DEFAULT 0,
	campo_customizado_habilitado TINYINT(1) DEFAULT 1,
  PRIMARY KEY (campo_customizado_id)
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS campo_customizado_lista;

CREATE TABLE campo_customizado_lista (
	campo_customizado_lista_id INTEGER(100) NOT NULL AUTO_INCREMENT,
  campo_customizado_lista_campo INTEGER(100) UNSIGNED DEFAULT NULL,
  campo_customizado_lista_opcao VARCHAR(50) DEFAULT NULL,
  campo_customizado_lista_valor VARCHAR(250) DEFAULT NULL,
  campo_customizado_lista_cor VARCHAR(6) DEFAULT 'FFFFFF',
  campo_customizado_lista_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (campo_customizado_lista_id),
  KEY campo_customizado_lista_campo (campo_customizado_lista_campo),
  KEY campo_customizado_lista_opcao (campo_customizado_lista_opcao),
 	CONSTRAINT campo_customizado_lista_campo FOREIGN KEY (campo_customizado_lista_campo) REFERENCES campo_customizado (campo_customizado_id)  ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS campo_customizado_valor;

CREATE TABLE campo_customizado_valor (
  campo_customizado_valor_id INTEGER(100) UNSIGNED NOT NULL,
  campo_customizado_valor_objeto INTEGER(100) UNSIGNED DEFAULT NULL,
  campo_customizado_valor_campo INTEGER(100) UNSIGNED DEFAULT NULL,
  campo_customizado_valor_caractere TEXT,
  campo_customizado_valor_inteiro INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (campo_customizado_valor_id),
  KEY campo_customizado_valor_campo (campo_customizado_valor_campo),
  CONSTRAINT campo_customizado_valor_campo FOREIGN KEY (campo_customizado_valor_campo) REFERENCES campo_customizado (campo_customizado_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS causa_efeito;

CREATE TABLE causa_efeito (
  causa_efeito_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  causa_efeito_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  causa_efeito_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  causa_efeito_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  causa_efeito_principal_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  causa_efeito_nome VARCHAR(100) DEFAULT NULL,
  causa_efeito_objeto TEXT,
  causa_efeito_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  causa_efeito_datahora DATETIME DEFAULT NULL,
  causa_efeito_descricao TEXT,
	causa_efeito_data DATE DEFAULT NULL,
	causa_efeito_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
	causa_efeito_cor VARCHAR(6) DEFAULT 'FFFFFF',
	causa_efeito_ativo TINYINT(1) DEFAULT 1,
	causa_efeito_aprovado TINYINT(1) DEFAULT 0,
  PRIMARY KEY (causa_efeito_id),
  KEY causa_efeito_cia (causa_efeito_cia),
  KEY causa_efeito_responsavel (causa_efeito_responsavel),
  KEY causa_efeito_dept (causa_efeito_dept),
  KEY causa_efeito_principal_indicador (causa_efeito_principal_indicador),
  KEY causa_efeito_moeda (causa_efeito_moeda),
  CONSTRAINT causa_efeito_cia FOREIGN KEY (causa_efeito_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT causa_efeito_dept FOREIGN KEY (causa_efeito_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT causa_efeito_responsavel FOREIGN KEY (causa_efeito_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT causa_efeito_principal_indicador FOREIGN KEY (causa_efeito_principal_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT causa_efeito_moeda FOREIGN KEY (causa_efeito_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;




DROP TABLE IF EXISTS causa_efeito_depts;

CREATE TABLE causa_efeito_depts (
  causa_efeito_id INTEGER(100) UNSIGNED NOT NULL,
  dept_id INTEGER(100) UNSIGNED NOT NULL,
  KEY causa_efeito_id (causa_efeito_id),
  KEY dept_id (dept_id),
  CONSTRAINT causa_efeito_depts_fk FOREIGN KEY (causa_efeito_id) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT causa_efeito_depts_fk1 FOREIGN KEY (dept_id) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS causa_efeito_usuarios;

CREATE TABLE causa_efeito_usuarios (
  causa_efeito_id INTEGER(100) UNSIGNED NOT NULL,
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  KEY causa_efeito_id (causa_efeito_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT causa_efeito_usuarios_fk FOREIGN KEY (causa_efeito_id) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT causa_efeito_usuarios_fk1 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS checklist_campo;

CREATE TABLE checklist_campo (
  checklist_campo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  checklist_modelo_id INTEGER(100) UNSIGNED DEFAULT NULL,
  checklist_campo_nome VARCHAR(255) DEFAULT NULL,
  checklist_campo_campo VARCHAR(255) DEFAULT NULL,
  checklist_campo_posicao INTEGER(100) UNSIGNED DEFAULT NULL,
  checklist_campo_porcentagem DECIMAL(20,5) DEFAULT 0,
  checklist_campo_texto VARCHAR(255) DEFAULT NULL,
  PRIMARY KEY (checklist_campo_id),
  KEY checklist_modelo_id (checklist_modelo_id),
  CONSTRAINT checklist_campo_fk FOREIGN KEY (checklist_modelo_id) REFERENCES checklist_modelo (checklist_modelo_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS checklist_dados;

CREATE TABLE checklist_dados (
  checklist_dados_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pratica_indicador_valor_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  checklist_dados_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  checklist_dados_campos LONGBLOB,
  checklist_dados_nome_usuario VARCHAR(50) DEFAULT NULL,
  checklist_dados_funcao_usuario VARCHAR(50) DEFAULT NULL,
  checklist_dados_obs TEXT,
  pratica_indicador_valor_data DATETIME DEFAULT NULL,
  pratica_indicador_valor_valor DECIMAL(20,5) DEFAULT 0,
  checklist_dados_checklist_id INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (checklist_dados_id),
  KEY checklist_dados_checklist_id (checklist_dados_checklist_id),
  KEY checklist_dados_responsavel (checklist_dados_responsavel),
  KEY pratica_indicador_valor_indicador (pratica_indicador_valor_indicador),
  KEY pratica_indicador_valor_data (pratica_indicador_valor_data),
  CONSTRAINT checklist_dados_fk1 FOREIGN KEY (checklist_dados_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT checklist_dados_fk FOREIGN KEY (pratica_indicador_valor_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS checklist_depts;

CREATE TABLE checklist_depts (
  checklist_id INTEGER(100) UNSIGNED NOT NULL,
  dept_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (checklist_id, dept_id),
  KEY checklist_id (checklist_id),
  KEY dept_id (dept_id),
  CONSTRAINT checklist_depts_fk1 FOREIGN KEY (dept_id) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT checklist_depts_fk FOREIGN KEY (checklist_id) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS checklist_lista;

CREATE TABLE checklist_lista (
  checklist_lista_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  checklist_lista_checklist_id INTEGER(100) UNSIGNED,
  checklist_lista_ordem INTEGER(100) UNSIGNED,
  checklist_lista_descricao TEXT,
  checklist_lista_justificativa TEXT,
  checklist_lista_sim TINYINT(1) DEFAULT 0,
  checklist_lista_nao TINYINT(1) DEFAULT 0,
  checklist_lista_na TINYINT(1) DEFAULT 0,
  checklist_lista_peso DECIMAL(20,5) UNSIGNED DEFAULT 0,
  checklist_lista_data DATETIME DEFAULT NULL,
  checklist_lista_usuario INTEGER(100) UNSIGNED,
  checklist_lista_legenda TINYINT(1) DEFAULT 0,
  checklist_lista_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (checklist_lista_id),
  KEY checklist_lista_checklist_id (checklist_lista_checklist_id),
  CONSTRAINT checklist_lista_fk FOREIGN KEY (checklist_lista_checklist_id) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS checklist_usuarios;

CREATE TABLE checklist_usuarios (
  checklist_id INTEGER(100) UNSIGNED NOT NULL,
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (checklist_id, usuario_id),
  KEY checklist_id (checklist_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT checklist_usuarios_fk1 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT checklist_usuarios_fk FOREIGN KEY (checklist_id) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS cia_contatos;

CREATE TABLE cia_contatos (
  cia_contato_cia INTEGER(100) UNSIGNED NOT NULL,
  cia_contato_contato INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (cia_contato_cia, cia_contato_contato),
  KEY cia_contato_cia (cia_contato_cia),
  KEY cia_contato_contato (cia_contato_contato),
  CONSTRAINT cia_contatos_fk1 FOREIGN KEY (cia_contato_contato) REFERENCES contatos (contato_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT cia_contatos_fk FOREIGN KEY (cia_contato_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS config;

CREATE TABLE config (
  config_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  config_nome VARCHAR(255) DEFAULT NULL,
  config_valor VARCHAR(255) DEFAULT NULL,
  config_grupo VARCHAR(255) DEFAULT NULL,
  config_tipo VARCHAR(255) DEFAULT NULL,
  PRIMARY KEY (config_id)
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS config_lista;

CREATE TABLE config_lista (
  config_lista_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  config_nome VARCHAR(255) DEFAULT NULL,
  config_lista_nome VARCHAR(30) DEFAULT NULL,
  PRIMARY KEY (config_lista_id),
  KEY config_nome (config_nome)
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS dept_contatos;

CREATE TABLE dept_contatos (
  dept_contato_dept INTEGER(100) UNSIGNED NOT NULL,
  dept_contato_contato INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (dept_contato_dept, dept_contato_contato),
  KEY dept_contato_dept (dept_contato_dept),
  KEY dept_contato_contato (dept_contato_contato),
  CONSTRAINT dept_contatos_fk1 FOREIGN KEY (dept_contato_contato) REFERENCES contatos (contato_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT dept_contatos_fk FOREIGN KEY (dept_contato_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS despacho;

CREATE TABLE despacho (
  despacho_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  despacho_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  despacho_nome VARCHAR(255) DEFAULT NULL,
  despacho_texto TEXT,
  despacho_anotacao TINYINT(1) DEFAULT 0,
  despacho_despacho TINYINT(1) DEFAULT 0,
  despacho_resposta TINYINT(1) DEFAULT 0,
  despacho_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (despacho_id),
  KEY despacho_usuario (despacho_usuario),
  CONSTRAINT despacho_usuario FOREIGN KEY (despacho_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS estado;

CREATE TABLE estado (
  estado_sigla VARCHAR(2) NOT NULL,
  estado_nome VARCHAR(20) DEFAULT NULL,
  KEY estado_sigla (estado_sigla)
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS estado_coordenadas;
CREATE TABLE estado_coordenadas (
  estado_sigla VARCHAR(2) NOT NULL,
  coordenadas TEXT,
  KEY estado_sigla (estado_sigla),
  CONSTRAINT estados_coordenadas_fk FOREIGN KEY (estado_sigla) REFERENCES estado (estado_sigla) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS estrategias_depts;

CREATE TABLE estrategias_depts (
  pg_estrategia_id INTEGER(100) UNSIGNED NOT NULL,
  dept_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (pg_estrategia_id, dept_id),
  KEY pg_estrategia_id (pg_estrategia_id),
  KEY dept_id (dept_id),
  CONSTRAINT estrategias_depts_fk1 FOREIGN KEY (dept_id) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT estrategias_depts_fk FOREIGN KEY (pg_estrategia_id) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS estrategias_usuarios;

CREATE TABLE estrategias_usuarios (
  pg_estrategia_id INTEGER(100) UNSIGNED NOT NULL,
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (pg_estrategia_id, usuario_id),
  KEY pg_estrategia_id (pg_estrategia_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT estrategias_usuarios_fk1 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT estrategias_usuarios_fk FOREIGN KEY (pg_estrategia_id) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eventos;

CREATE TABLE eventos (
  evento_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  evento_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  evento_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  evento_dono INTEGER(100) UNSIGNED DEFAULT NULL,
  evento_recorrencia_pai INTEGER(100) UNSIGNED DEFAULT NULL,
  evento_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  evento_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  evento_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
  evento_acao INTEGER(100) UNSIGNED DEFAULT NULL,
  evento_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
  evento_tema INTEGER(100) UNSIGNED DEFAULT NULL,
  evento_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
  evento_fator INTEGER(100) UNSIGNED DEFAULT NULL,
  evento_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
  evento_meta INTEGER(100) UNSIGNED DEFAULT NULL,
  evento_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  evento_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
  evento_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
  evento_principal_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  evento_titulo VARCHAR(255) DEFAULT NULL,
  evento_inicio DATETIME DEFAULT NULL,
  evento_fim DATETIME DEFAULT NULL,
  evento_duracao DECIMAL(20,5) UNSIGNED DEFAULT NULL,
  evento_descricao MEDIUMTEXT,
  evento_oque TEXT,
	evento_onde TEXT,
	evento_quando TEXT,
	evento_como TEXT,
	evento_porque TEXT,
	evento_quanto TEXT,
	evento_quem TEXT,
  evento_url VARCHAR(255) DEFAULT NULL,
  evento_nr_recorrencias INTEGER(100) UNSIGNED DEFAULT NULL,
  evento_recorrencias INTEGER(100) UNSIGNED DEFAULT NULL,
  evento_lembrar INTEGER(100) UNSIGNED DEFAULT NULL,
  evento_icone VARCHAR(20) DEFAULT 'obj/evento',
  evento_tipo TINYINT(3) DEFAULT 0,
  evento_diautil TINYINT(3) DEFAULT 0,
  evento_notificar TINYINT(3) DEFAULT 0,
  evento_localizacao VARCHAR(255) DEFAULT NULL,
  evento_moeda INTEGER(100) UNSIGNED DEFAULT 1,
  evento_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  evento_cor VARCHAR(6) DEFAULT 'fff0b0',
  evento_aprovado TINYINT(1) DEFAULT 0,
  evento_ativo INTEGER(1) DEFAULT 1,
  evento_uid VARCHAR(255) DEFAULT NULL,
  PRIMARY KEY (evento_id),
  KEY evento_inicio (evento_inicio),
  KEY evento_fim (evento_fim),
  KEY evento_dono (evento_dono),
  KEY evento_recorrencia_pai (evento_recorrencia_pai),
  KEY evento_projeto (evento_projeto),
  KEY evento_tarefa (evento_tarefa),
  KEY evento_pratica (evento_pratica),
  KEY evento_indicador (evento_indicador),
  KEY evento_calendario (evento_calendario),
  KEY evento_recorrencias (evento_recorrencias),
  KEY evento_cia (evento_cia),
  KEY evento_dept (evento_dept),
  KEY evento_acao (evento_acao),
  KEY evento_objetivo (evento_objetivo),
  KEY evento_fator (evento_fator),
  KEY evento_estrategia (evento_estrategia),
  KEY evento_meta (evento_meta),
  KEY evento_perspectiva (evento_perspectiva),
  KEY evento_tema (evento_tema),
  KEY evento_principal_indicador (evento_principal_indicador),
  KEY evento_moeda (evento_moeda),
  CONSTRAINT evento_cia FOREIGN KEY (evento_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT evento_dono FOREIGN KEY (evento_dono) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT evento_estrategia FOREIGN KEY (evento_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT evento_meta FOREIGN KEY (evento_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT evento_tema FOREIGN KEY (evento_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT evento_recorrencia_pai FOREIGN KEY (evento_recorrencia_pai) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT evento_perspectiva FOREIGN KEY (evento_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT evento_calendario FOREIGN KEY (evento_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT evento_projeto FOREIGN KEY (evento_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT evento_tarefa FOREIGN KEY (evento_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT evento_pratica FOREIGN KEY (evento_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT evento_acao FOREIGN KEY (evento_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT evento_indicador FOREIGN KEY (evento_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT evento_objetivo FOREIGN KEY (evento_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT evento_fator FOREIGN KEY (evento_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT eventos_dept FOREIGN KEY (evento_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT evento_principal_indicador FOREIGN KEY (evento_principal_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT evento_moeda FOREIGN KEY (evento_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS evento_contatos;

CREATE TABLE evento_contatos (
  evento_id INTEGER(100) UNSIGNED NOT NULL,
  contato_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (evento_id, contato_id),
  KEY evento_id (evento_id),
  KEY contato_id (contato_id),
  CONSTRAINT evento_contatos_fk1 FOREIGN KEY (contato_id) REFERENCES contatos (contato_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT evento_contatos_fk FOREIGN KEY (evento_id) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS evento_recorrencia;

CREATE TABLE evento_recorrencia (
  recorrencia_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  recorrencia_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  recorrencia_id_origem INTEGER(100) UNSIGNED DEFAULT NULL,
  recorrencia_inicio INTEGER(100) UNSIGNED DEFAULT NULL,
  recorrencia_tipo VARCHAR(40) DEFAULT NULL,
  recorrencia_intervalo_repeticao INTEGER(100) UNSIGNED DEFAULT NULL,
  recorrencia_numero_repeticao INTEGER(100) UNSIGNED DEFAULT NULL,
  recorrencia_dados LONGBLOB,
  recorrencia_chamada_volta VARCHAR(127) DEFAULT NULL,
  recorrencia_modulo VARCHAR(40) DEFAULT NULL,
  recorrencia_tipo_modulo VARCHAR(20) DEFAULT NULL,
  PRIMARY KEY (recorrencia_id),
  KEY recorrencia_inicio (recorrencia_inicio),
  KEY recorrencia_modulo (recorrencia_modulo),
  KEY recorrencia_tipo (recorrencia_tipo),
  KEY recorrencia_id_origem (recorrencia_id_origem),
  KEY recorrencia_responsavel (recorrencia_responsavel),
  CONSTRAINT evento_recorrencia_fk FOREIGN KEY (recorrencia_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS evento_usuarios;

CREATE TABLE evento_usuarios (
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  evento_id INTEGER(100) UNSIGNED NOT NULL,
  aceito TINYINT(1) DEFAULT 0,
  data DATETIME DEFAULT NULL,
  duracao DECIMAL(20,5) UNSIGNED DEFAULT 0,
  percentual INTEGER(3) UNSIGNED DEFAULT 100,
  PRIMARY KEY (usuario_id, evento_id),
  KEY uek2 (evento_id, usuario_id),
  KEY usuario_id (usuario_id),
  KEY evento_id (evento_id),
  CONSTRAINT evento_usuarios_fk1 FOREIGN KEY (evento_id) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT evento_usuarios_fk FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS evento_participante;

CREATE TABLE evento_participante (
  evento_participante_usuario INTEGER(100) UNSIGNED NOT NULL,
  evento_participante_evento INTEGER(100) UNSIGNED NOT NULL,
  evento_participante_aceito TINYINT(1) DEFAULT 0,
  evento_participante_data DATETIME DEFAULT NULL,
  evento_participante_duracao DECIMAL(20,5) UNSIGNED DEFAULT 0,
  evento_participante_percentual INTEGER(3) UNSIGNED DEFAULT 100,
  PRIMARY KEY USING BTREE (evento_participante_usuario, evento_participante_evento),
   KEY evento_participante_usuario (evento_participante_usuario),
   KEY evento_participante_evento (evento_participante_evento),
  CONSTRAINT evento_participante_evento FOREIGN KEY (evento_participante_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT evento_participante_usuario FOREIGN KEY (evento_participante_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_evento_participante;

CREATE TABLE baseline_evento_participante (
  baseline_id INTEGER(100) UNSIGNED NOT NULL,
  evento_participante_usuario INTEGER(100) UNSIGNED NOT NULL,
  evento_participante_evento INTEGER(100) UNSIGNED NOT NULL,
  evento_participante_aceito TINYINT(1) DEFAULT 0,
  evento_participante_data DATETIME DEFAULT NULL,
  evento_participante_duracao DECIMAL(20,5) UNSIGNED DEFAULT 0,
  evento_participante_percentual INTEGER(3) UNSIGNED DEFAULT 100,
  PRIMARY KEY USING BTREE (baseline_id, evento_participante_usuario, evento_participante_evento),
  CONSTRAINT baseline_evento_participante FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS expediente;

CREATE TABLE expediente (
  expediente_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  cia_id INTEGER(100) UNSIGNED DEFAULT NULL,
  dept_id INTEGER(100) UNSIGNED DEFAULT NULL,
  usuario_id INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_id INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_id INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_id INTEGER(100) UNSIGNED DEFAULT NULL,
  data DATE DEFAULT NULL,
  inicio TIME DEFAULT '00:00:00',
  fim TIME DEFAULT '00:00:00',
  almoco_inicio TIME DEFAULT '00:00:00',
  almoco_fim TIME DEFAULT '00:00:00',
  PRIMARY KEY (expediente_id),
  KEY cia_id (cia_id),
  KEY usuario_id (usuario_id),
  KEY data (data),
  KEY dept_id (dept_id),
  KEY projeto_id (projeto_id),
  KEY tarefa_id (tarefa_id),
  KEY recurso_id (recurso_id),
  CONSTRAINT expediente_fk FOREIGN KEY (cia_id) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT expediente_fk1 FOREIGN KEY (dept_id) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT expediente_fk2 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT expediente_fk3 FOREIGN KEY (projeto_id) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT expediente_fk4 FOREIGN KEY (recurso_id) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT expediente_fk5 FOREIGN KEY (tarefa_id) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS fator_dept;

CREATE TABLE fator_dept (
  fator_dept_fator INTEGER(100) UNSIGNED NOT NULL,
  fator_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (fator_dept_fator, fator_dept_dept),
  KEY fator_dept_fator (fator_dept_fator),
  KEY fator_dept_dept (fator_dept_dept),
  CONSTRAINT fator_dept_dept FOREIGN KEY (fator_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT fator_dept_fator FOREIGN KEY (fator_dept_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS fator_usuario;

CREATE TABLE fator_usuario (
  fator_usuario_fator INTEGER(100) UNSIGNED NOT NULL,
  fator_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (fator_usuario_fator, fator_usuario_usuario),
  KEY fator_usuario_fator (fator_usuario_fator),
  KEY fator_usuario_usuario (fator_usuario_usuario),
  CONSTRAINT fator_usuario_fator FOREIGN KEY (fator_usuario_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT fator_usuario_usuario FOREIGN KEY (fator_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS favorito;

CREATE TABLE favorito (
  favorito_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  favorito_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  favorito_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  favorito_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  favorito_nome VARCHAR(255) DEFAULT NULL,
  favorito_protegido TINYINT(1) DEFAULT 0,
  favorito_projeto TINYINT(1) DEFAULT 0,
	favorito_tarefa TINYINT(1) DEFAULT 0,
	favorito_perspectiva TINYINT(1) DEFAULT 0,
	favorito_tema TINYINT(1) DEFAULT 0,
	favorito_objetivo TINYINT(1) DEFAULT 0,
	favorito_fator TINYINT(1) DEFAULT 0,
	favorito_estrategia TINYINT(1) DEFAULT 0,
	favorito_meta TINYINT(1) DEFAULT 0,
	favorito_pratica TINYINT(1) DEFAULT 0,
	favorito_indicador TINYINT(1) DEFAULT 0,
	favorito_acao TINYINT(1) DEFAULT 0,
	favorito_canvas TINYINT(1) DEFAULT 0,
	favorito_risco TINYINT(1) DEFAULT 0,
	favorito_risco_resposta TINYINT(1) DEFAULT 0,
	favorito_calendario TINYINT(1) DEFAULT 0,
	favorito_monitoramento TINYINT(1) DEFAULT 0,
	favorito_ata TINYINT(1) DEFAULT 0,
	favorito_mswot TINYINT(1) DEFAULT 0,
	favorito_swot TINYINT(1) DEFAULT 0,
	favorito_operativo TINYINT(1) DEFAULT 0,
	favorito_instrumento TINYINT(1) DEFAULT 0,
	favorito_recurso TINYINT(1) DEFAULT 0,
	favorito_problema TINYINT(1) DEFAULT 0,
	favorito_demanda TINYINT(1) DEFAULT 0,
	favorito_programa TINYINT(1) DEFAULT 0,
	favorito_licao TINYINT(1) DEFAULT 0,
	favorito_evento TINYINT(1) DEFAULT 0,
	favorito_link TINYINT(1) DEFAULT 0,
	favorito_avaliacao TINYINT(1) DEFAULT 0,
	favorito_tgn TINYINT(1) DEFAULT 0,
	favorito_brainstorm TINYINT(1) DEFAULT 0,
	favorito_gut TINYINT(1) DEFAULT 0,
	favorito_causa_efeito TINYINT(1) DEFAULT 0,
	favorito_arquivo TINYINT(1) DEFAULT 0,
	favorito_forum TINYINT(1) DEFAULT 0,
	favorito_checklist TINYINT(1) DEFAULT 0,
	favorito_agenda  TINYINT(1) DEFAULT 0,
	favorito_agrupamento TINYINT(1) DEFAULT 0,
	favorito_patrocinador TINYINT(1) DEFAULT 0,
	favorito_template TINYINT(1) DEFAULT 0,
	favorito_painel TINYINT(1) DEFAULT 0,
	favorito_painel_odometro TINYINT(1) DEFAULT 0,
	favorito_painel_composicao TINYINT(1) DEFAULT 0,
	favorito_tr TINYINT(1) DEFAULT 0,
	favorito_me TINYINT(1) DEFAULT 0,
	favorito_aviso TINYINT(1) DEFAULT 0,
	favorito_ssti TINYINT(1) DEFAULT 0,
	favorito_laudo TINYINT(1) DEFAULT 0,
	favorito_trelo TINYINT(1) DEFAULT 0,
	favorito_trelo_cartao TINYINT(1) DEFAULT 0,
	favorito_pdcl TINYINT(1) DEFAULT 0,
	favorito_pdcl_item TINYINT(1) DEFAULT 0,
	favorito_os TINYINT(1) DEFAULT 0,
	favorito_nc TINYINT(1) DEFAULT 0,
	favorito_ne TINYINT(1) DEFAULT 0,
	favorito_ns TINYINT(1) DEFAULT 0,
	favorito_ob TINYINT(1) DEFAULT 0,
	favorito_geral TINYINT(1) DEFAULT 0,
	favorito_acesso INTEGER(100) UNSIGNED DEFAULT 1,
	favorito_ativo TINYINT(1) DEFAULT 1,
  PRIMARY KEY (favorito_id),
  KEY favorito_cia (favorito_cia),
  KEY favorito_dept (favorito_dept),
  KEY favorito_usuario (favorito_usuario),
  CONSTRAINT favorito_cia FOREIGN KEY (favorito_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT favorito_dept FOREIGN KEY (favorito_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT favorito_usuario FOREIGN KEY (favorito_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS favorito_dept;

CREATE TABLE favorito_dept (
  favorito_dept_favorito INTEGER(100) UNSIGNED NOT NULL,
  favorito_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (favorito_dept_favorito, favorito_dept_dept),
  KEY favorito_dept_favorito (favorito_dept_favorito),
  KEY favorito_dept_dept (favorito_dept_dept),
  CONSTRAINT favorito_dept_dept FOREIGN KEY (favorito_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT favorito_dept_favorito FOREIGN KEY (favorito_dept_favorito) REFERENCES favorito (favorito_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS favorito_cia;

CREATE TABLE favorito_cia (
  favorito_cia_favorito INTEGER(100) UNSIGNED NOT NULL,
  favorito_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (favorito_cia_favorito, favorito_cia_cia),
  KEY favorito_cia_favorito (favorito_cia_favorito),
  KEY favorito_cia_cia (favorito_cia_cia),
  CONSTRAINT favorito_cia_cia FOREIGN KEY (favorito_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT favorito_cia_favorito FOREIGN KEY (favorito_cia_favorito) REFERENCES favorito (favorito_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS favorito_usuario;

CREATE TABLE favorito_usuario (
  favorito_usuario_favorito INTEGER(100) UNSIGNED NOT NULL,
  favorito_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
  KEY favorito_usuario_favorito (favorito_usuario_favorito),
  KEY favorito_usuario_usuario (favorito_usuario_usuario),
  CONSTRAINT favorito_usuario_favorito FOREIGN KEY (favorito_usuario_favorito) REFERENCES favorito (favorito_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT favorito_usuario_usuario FOREIGN KEY (favorito_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS favorito_lista;

CREATE TABLE favorito_lista (
  favorito_lista_favorito INTEGER(100) UNSIGNED NOT NULL,
  favorito_lista_campo INTEGER(100) UNSIGNED,
  KEY favorito_lista_favorito (favorito_lista_favorito),
  KEY favorito_lista_campo (favorito_lista_campo),
  CONSTRAINT favorito_lista_favorito FOREIGN KEY (favorito_lista_favorito) REFERENCES favorito (favorito_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS favorito_trava;

CREATE TABLE favorito_trava (
  favorito_trava_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  favorito_trava_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  favorito_trava_projeto TINYINT(1) DEFAULT 0,
	favorito_trava_tarefa TINYINT(1) DEFAULT 0,
	favorito_trava_perspectiva TINYINT(1) DEFAULT 0,
	favorito_trava_tema TINYINT(1) DEFAULT 0,
	favorito_trava_objetivo TINYINT(1) DEFAULT 0,
	favorito_trava_fator TINYINT(1) DEFAULT 0,
	favorito_trava_estrategia TINYINT(1) DEFAULT 0,
	favorito_trava_meta TINYINT(1) DEFAULT 0,
	favorito_trava_pratica TINYINT(1) DEFAULT 0,
	favorito_trava_indicador TINYINT(1) DEFAULT 0,
	favorito_trava_acao TINYINT(1) DEFAULT 0,
	favorito_trava_canvas TINYINT(1) DEFAULT 0,
	favorito_trava_risco TINYINT(1) DEFAULT 0,
	favorito_trava_risco_resposta TINYINT(1) DEFAULT 0,
	favorito_trava_calendario TINYINT(1) DEFAULT 0,
	favorito_trava_monitoramento TINYINT(1) DEFAULT 0,
	favorito_trava_ata TINYINT(1) DEFAULT 0,
	favorito_trava_mswot TINYINT(1) DEFAULT 0,
	favorito_trava_swot TINYINT(1) DEFAULT 0,
	favorito_trava_operativo TINYINT(1) DEFAULT 0,
	favorito_trava_instrumento TINYINT(1) DEFAULT 0,
	favorito_trava_recurso TINYINT(1) DEFAULT 0,
	favorito_trava_problema TINYINT(1) DEFAULT 0,
	favorito_trava_demanda TINYINT(1) DEFAULT 0,
	favorito_trava_programa TINYINT(1) DEFAULT 0,
	favorito_trava_licao TINYINT(1) DEFAULT 0,
	favorito_trava_evento TINYINT(1) DEFAULT 0,
	favorito_trava_link TINYINT(1) DEFAULT 0,
	favorito_trava_avaliacao TINYINT(1) DEFAULT 0,
	favorito_trava_tgn TINYINT(1) DEFAULT 0,
	favorito_trava_brainstorm TINYINT(1) DEFAULT 0,
	favorito_trava_gut TINYINT(1) DEFAULT 0,
	favorito_trava_causa_efeito TINYINT(1) DEFAULT 0,
	favorito_trava_arquivo TINYINT(1) DEFAULT 0,
	favorito_trava_forum TINYINT(1) DEFAULT 0,
	favorito_trava_checklist TINYINT(1) DEFAULT 0,
	favorito_trava_agenda  TINYINT(1) DEFAULT 0,
	favorito_trava_agrupamento TINYINT(1) DEFAULT 0,
	favorito_trava_patrocinador TINYINT(1) DEFAULT 0,
	favorito_trava_template TINYINT(1) DEFAULT 0,
	favorito_trava_painel TINYINT(1) DEFAULT 0,
	favorito_trava_painel_odometro TINYINT(1) DEFAULT 0,
	favorito_trava_painel_composicao TINYINT(1) DEFAULT 0,
	favorito_trava_tr TINYINT(1) DEFAULT 0,
	favorito_trava_me TINYINT(1) DEFAULT 0,
	favorito_plano_acao_item TINYINT(1) DEFAULT 0,
	favorito_beneficio TINYINT(1) DEFAULT 0,
	favorito_painel_slideshow TINYINT(1) DEFAULT 0,
	favorito_projeto_viabilidade TINYINT(1) DEFAULT 0,
	favorito_projeto_abertura TINYINT(1) DEFAULT 0,
	favorito_pg TINYINT(1) DEFAULT 0,
	favorito_trava_aviso TINYINT(1) DEFAULT 0,
	favorito_trava_ssti TINYINT(1) DEFAULT 0,
	favorito_trava_laudo TINYINT(1) DEFAULT 0,
	favorito_trava_ssti_estrategia TINYINT(1) DEFAULT 0,
	favorito_trava_ssti_processo TINYINT(1) DEFAULT 0,
	favorito_trava_ssti_coagd TINYINT(1) DEFAULT 0,
	favorito_trava_ssti_coges TINYINT(1) DEFAULT 0,
	favorito_trava_ssti_cport TINYINT(1) DEFAULT 0,
	favorito_trava_trelo TINYINT(1) DEFAULT 0,
	favorito_trava_trelo_cartao TINYINT(1) DEFAULT 0,
	favorito_trava_pdcl TINYINT(1) DEFAULT 0,
	favorito_trava_pdcl_item TINYINT(1) DEFAULT 0,
	favorito_trava_os TINYINT(1) DEFAULT 0,
	favorito_trava_nc TINYINT(1) DEFAULT 0,
	favorito_trava_ne TINYINT(1) DEFAULT 0,
	favorito_trava_ns TINYINT(1) DEFAULT 0,
	favorito_trava_ob TINYINT(1) DEFAULT 0,
	favorito_trava_campo TEXT,
  PRIMARY KEY (favorito_trava_id),
  KEY favorito_trava_usuario (favorito_trava_usuario),
  CONSTRAINT favorito_trava_usuario FOREIGN KEY (favorito_trava_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS foruns;

CREATE TABLE foruns (
  forum_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  forum_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  forum_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  forum_dono INTEGER(100) UNSIGNED DEFAULT NULL,
  forum_moderador INTEGER(100) UNSIGNED DEFAULT NULL,
  forum_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  forum_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  forum_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
  forum_acao INTEGER(100) UNSIGNED DEFAULT NULL,
  forum_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
  forum_tema INTEGER(100) UNSIGNED DEFAULT NULL,
  forum_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
  forum_fator INTEGER(100) UNSIGNED DEFAULT NULL,
  forum_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
  forum_meta INTEGER(100) UNSIGNED DEFAULT NULL,
  forum_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  forum_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
  forum_principal_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  forum_nome VARCHAR(255) DEFAULT NULL,
  forum_status TINYINT(4) DEFAULT '-1',
  forum_descricao MEDIUMTEXT,
  forum_data_criacao DATETIME DEFAULT NULL,
  forum_ultima_data DATETIME DEFAULT NULL,
  forum_ultimo_id INTEGER(100) UNSIGNED DEFAULT NULL,
  forum_contagem_msg INTEGER(100) UNSIGNED DEFAULT NULL,
  forum_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
  forum_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  forum_cor VARCHAR(6) DEFAULT 'FFFFFF',
	forum_ativo TINYINT(1) DEFAULT 1,
	forum_aprovado TINYINT(1) DEFAULT 0,
  PRIMARY KEY (forum_id),
  KEY forum_projeto (forum_projeto),
  KEY forum_tarefa (forum_tarefa),
  KEY forum_dono (forum_dono),
  KEY forum_status (forum_status),
  KEY forum_nome (forum_nome),
  KEY forum_cia (forum_cia),
  KEY forum_dept (forum_dept),
  KEY forum_pratica (forum_pratica),
  KEY forum_acao (forum_acao),
  KEY forum_indicador (forum_indicador),
  KEY forum_perspectiva (forum_perspectiva),
  KEY forum_tema (forum_tema),
  KEY forum_objetivo (forum_objetivo),
  KEY forum_fator (forum_fator),
  KEY forum_estrategia (forum_estrategia),
  KEY forum_meta (forum_meta),
  KEY forum_canvas (forum_canvas),
  KEY forum_moderador (forum_moderador),
  KEY forum_principal_indicador (forum_principal_indicador),
  KEY forum_moeda (forum_moeda),
  CONSTRAINT foruns_cia FOREIGN KEY (forum_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT forum_dept FOREIGN KEY (forum_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT foruns_dono FOREIGN KEY (forum_dono) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT foruns_estrategia FOREIGN KEY (forum_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT foruns_meta FOREIGN KEY (forum_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT foruns_tema FOREIGN KEY (forum_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT foruns_projeto FOREIGN KEY (forum_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT foruns_tarefa FOREIGN KEY (forum_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT foruns_pratica FOREIGN KEY (forum_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT foruns_acao FOREIGN KEY (forum_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT foruns_indicador FOREIGN KEY (forum_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT foruns_objetivo FOREIGN KEY (forum_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT foruns_fator FOREIGN KEY (forum_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT foruns_moderador FOREIGN KEY (forum_moderador) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT foruns_perspectiva FOREIGN KEY (forum_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT foruns_canvas FOREIGN KEY (forum_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT forum_principal_indicador FOREIGN KEY (forum_principal_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT forum_moeda FOREIGN KEY (forum_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS forum_dept;

CREATE TABLE forum_dept (
  forum_dept_forum INTEGER(100) UNSIGNED NOT NULL,
  forum_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (forum_dept_forum, forum_dept_dept),
  KEY forum_dept_forum (forum_dept_forum),
  KEY forum_dept_dept (forum_dept_dept),
  CONSTRAINT forum_dept_dept FOREIGN KEY (forum_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT forum_dept_forum FOREIGN KEY (forum_dept_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS forum_usuario;

CREATE TABLE forum_usuario (
  forum_usuario_forum INTEGER(100) UNSIGNED NOT NULL,
  forum_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (forum_usuario_forum, forum_usuario_usuario),
  KEY forum_usuario_forum (forum_usuario_forum),
  KEY forum_usuario_usuario (forum_usuario_usuario),
  CONSTRAINT forum_usuario_usuario FOREIGN KEY (forum_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT forum_usuario_forum FOREIGN KEY (forum_usuario_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS forum_acompanhar;

CREATE TABLE forum_acompanhar (
  acompanhar_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  acompanhar_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  acompanhar_forum INTEGER(100) UNSIGNED DEFAULT NULL,
  acompanhar_topico INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (acompanhar_id),
  KEY idx_fw1 (acompanhar_usuario, acompanhar_forum),
  KEY idx_fw2 (acompanhar_usuario, acompanhar_topico),
  KEY acompanhar_usuario (acompanhar_usuario),
  KEY acompanhar_forum (acompanhar_forum),
  CONSTRAINT forum_acompanhar_fk1 FOREIGN KEY (acompanhar_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT forum_acompanhar_fk FOREIGN KEY (acompanhar_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS forum_mensagens;

CREATE TABLE forum_mensagens (
  mensagem_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  mensagem_forum INTEGER(100) UNSIGNED DEFAULT NULL,
  mensagem_superior INTEGER(100) UNSIGNED DEFAULT NULL,
  mensagem_autor INTEGER(100) UNSIGNED DEFAULT NULL,
  mensagem_editor INTEGER(100) UNSIGNED DEFAULT NULL,
  mensagem_titulo VARCHAR(255) DEFAULT NULL,
  mensagem_data DATETIME DEFAULT NULL,
  mensagem_texto TEXT,
  mensagem_publicada TINYINT(1) DEFAULT 1,
  PRIMARY KEY (mensagem_id),
  KEY idx_msuperior (mensagem_superior),
  KEY idx_mdata (mensagem_data),
  KEY idx_mforum (mensagem_forum),
  KEY mensagem_autor (mensagem_autor),
  KEY mensagem_editor (mensagem_editor),
  CONSTRAINT forum_mensagens_fk3 FOREIGN KEY (mensagem_editor) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT forum_mensagens_fk FOREIGN KEY (mensagem_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT forum_mensagens_fk1 FOREIGN KEY (mensagem_superior) REFERENCES forum_mensagens (mensagem_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT forum_mensagens_fk2 FOREIGN KEY (mensagem_autor) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS forum_visitas;

CREATE TABLE forum_visitas (
  visita_usuario INTEGER(100) UNSIGNED NOT NULL,
  visita_forum INTEGER(100) UNSIGNED NOT NULL,
  visita_mensagem INTEGER(100) UNSIGNED NOT NULL,
  visita_data TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (visita_usuario, visita_forum, visita_mensagem),
  KEY visita_usuario (visita_usuario),
  KEY visita_forum (visita_forum),
  KEY visita_mensagem (visita_mensagem),
  CONSTRAINT forum_visitas_fk2 FOREIGN KEY (visita_mensagem) REFERENCES forum_mensagens (mensagem_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT forum_visitas_fk FOREIGN KEY (visita_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT forum_visitas_fk1 FOREIGN KEY (visita_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS grupo;

CREATE TABLE grupo (
  grupo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  grupo_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  grupo_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  grupo_descricao VARCHAR(255) DEFAULT NULL,
  grupo_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (grupo_id),
  KEY grupo_cia (grupo_cia),
  KEY grupo_usuario (grupo_usuario),
  CONSTRAINT grupo_cia FOREIGN KEY (grupo_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT grupo_usuario FOREIGN KEY (grupo_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS grupo_permissao;

CREATE TABLE grupo_permissao (
  grupo_permissao_grupo INTEGER(100) UNSIGNED NOT NULL,
  grupo_permissao_usuario INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (grupo_permissao_grupo, grupo_permissao_usuario),
  KEY grupo_permissao_grupo (grupo_permissao_grupo),
  KEY grupo_permissao_usuario (grupo_permissao_usuario),
  CONSTRAINT grupo_permissao_usuario FOREIGN KEY (grupo_permissao_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT grupo_permissao_grupo FOREIGN KEY (grupo_permissao_grupo) REFERENCES grupo (grupo_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS gut;

CREATE TABLE gut (
  gut_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  gut_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  gut_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  gut_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  gut_principal_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  gut_nome VARCHAR(100) DEFAULT NULL,
  gut_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  gut_datahora DATETIME DEFAULT NULL,
  gut_descricao TEXT,
	gut_data DATE DEFAULT NULL,
	gut_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
	gut_cor VARCHAR(6) DEFAULT 'FFFFFF',
	gut_ativo TINYINT(1) DEFAULT 1,
	gut_aprovado TINYINT(1) DEFAULT 0,
  PRIMARY KEY (gut_id),
  KEY gut_cia (gut_cia),
  KEY gut_dept (gut_dept),
  KEY gut_responsavel (gut_responsavel),
  KEY gut_principal_indicador (gut_principal_indicador),
  KEY gut_moeda (gut_moeda),
  CONSTRAINT gut_cia FOREIGN KEY (gut_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT gut_dept FOREIGN KEY (gut_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT gut_responsavel FOREIGN KEY (gut_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT gut_principal_indicador FOREIGN KEY (gut_principal_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT gut_moeda FOREIGN KEY (gut_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS gut_depts;

CREATE TABLE gut_depts (
  gut_id INTEGER(100) UNSIGNED NOT NULL,
  dept_id INTEGER(100) UNSIGNED NOT NULL,
  KEY gut_id (gut_id),
  KEY dept_id (dept_id),
  CONSTRAINT gut_depts_fk FOREIGN KEY (gut_id) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT gut_depts_fk1 FOREIGN KEY (dept_id) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS gut_linha;

CREATE TABLE gut_linha (
  gut_linha_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  gut_id INTEGER(100) UNSIGNED DEFAULT NULL,
  gut_texto TEXT,
  gut_g INTEGER(2) UNSIGNED DEFAULT NULL,
  gut_u INTEGER(2) UNSIGNED DEFAULT NULL,
  gut_t INTEGER(2) UNSIGNED DEFAULT NULL,
  ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (gut_linha_id),
  KEY gut_id (gut_id),
  CONSTRAINT gut_linha_gut FOREIGN KEY (gut_id) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS gut_usuarios;

CREATE TABLE gut_usuarios (
  gut_id INTEGER(100) UNSIGNED NOT NULL,
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  KEY gut_id (gut_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT gut_usuarios_fk FOREIGN KEY (gut_id) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT gut_usuarios_fk1 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS historico;

CREATE TABLE historico (
  historico_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  historico_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  historico_data DATETIME DEFAULT NULL,
  historico_acao VARCHAR(20) DEFAULT 'modificar',
  historico_item INTEGER(100) UNSIGNED,
  historico_tabela VARCHAR(20) DEFAULT NULL,
  historico_nome VARCHAR(255) DEFAULT NULL,
  PRIMARY KEY (historico_id),
  KEY index_historico_item (historico_item),
  KEY historico_tabela (historico_tabela),
  KEY historico_usuario (historico_usuario),
  CONSTRAINT historico_fk FOREIGN KEY (historico_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS instrumento;

CREATE TABLE instrumento (
  instrumento_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  instrumento_campo INTEGER(100) UNSIGNED DEFAULT 1,
  instrumento_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  instrumento_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  instrumento_supervisor INTEGER(100) UNSIGNED DEFAULT NULL,
  instrumento_autoridade INTEGER(100) UNSIGNED DEFAULT NULL,
  instrumento_cliente INTEGER(100) UNSIGNED DEFAULT NULL,
  instrumento_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  instrumento_principal_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  instrumento_fiscal INTEGER(100) unsigned DEFAULT NULL,
	instrumento_fiscal_substituto int(100) unsigned DEFAULT NULL,
  instrumento_numero VARCHAR(100) DEFAULT NULL,
  instrumento_nome VARCHAR(255) DEFAULT NULL,
  instrumento_ano VARCHAR(4) DEFAULT NULL,
  instrumento_licitacao INTEGER(4) UNSIGNED DEFAULT 0,
  instrumento_edital_nr VARCHAR(50) DEFAULT NULL,
  instrumento_processo VARCHAR(100) DEFAULT NULL,
  instrumento_objeto MEDIUMTEXT,
  instrumento_justificativa MEDIUMTEXT,
  instrumento_entidade VARCHAR(255) DEFAULT NULL,
  instrumento_entidade_cnpj VARCHAR(18) DEFAULT NULL,
	instrumento_entidade_codigo VARCHAR(255) DEFAULT NULL,
  instrumento_data_celebracao DATE DEFAULT NULL,
  instrumento_data_publicacao DATE DEFAULT NULL,
  instrumento_data_inicio DATE DEFAULT NULL,
  instrumento_data_termino DATE DEFAULT NULL,
	instrumento_garantia_contratual_modalidade VARCHAR(255) DEFAULT NULL,
	instrumento_garantia_contratual_percentual DECIMAL(20,10) DEFAULT 0,
	instrumento_garantia_contratual_vencimento DATE DEFAULT NULL,
  instrumento_valor DECIMAL(20,10) UNSIGNED DEFAULT 0,
  instrumento_valor_atual DECIMAL(20,10) UNSIGNED DEFAULT 0,
  instrumento_valor_contrapartida DECIMAL(20,10) UNSIGNED DEFAULT 0,
  instrumento_valor_repasse DECIMAL(20,10) UNSIGNED DEFAULT 0,
  instrumento_fim_contrato DATE DEFAULT NULL,
  instrumento_situacao INTEGER(4) UNSIGNED DEFAULT 0,
  instrumento_porcentagem INTEGER(2) DEFAULT 0,
  instrumento_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  instrumento_cor VARCHAR(6) DEFAULT 'ffffff',
  instrumento_depts VARCHAR(255) DEFAULT NULL,
  instrumento_contatos VARCHAR(255) DEFAULT NULL,
  instrumento_designados VARCHAR(255) DEFAULT NULL,
  instrumento_recursos VARCHAR(255) DEFAULT NULL,
	instrumento_prorrogavel TINYINT(1) DEFAULT 0,
	instrumento_prazo_prorrogacao INTEGER(10) DEFAULT NULL,
	instrumento_prazo_prorrogacao_tipo INTEGER(1) DEFAULT NULL,
	instrumento_acrescimo DECIMAL(20,10) UNSIGNED DEFAULT NULL,
	instrumento_supressao DECIMAL(20,10) UNSIGNED DEFAULT NULL,
	instrumento_local_entrega TEXT,
	instrumento_resultado_esperado TEXT,
	instrumento_situacao_atual TEXT,
	instrumento_vantagem_economica TEXT,
	instrumento_aprovado TINYINT(1) DEFAULT 0,
	instrumento_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
	instrumento_casa_significativa INTEGER UNSIGNED DEFAULT 2,
	instrumento_ativo TINYINT(1) DEFAULT 1,
  PRIMARY KEY (instrumento_id),
  KEY instrumento_campo (instrumento_campo),
  KEY instrumento_cia (instrumento_cia),
  KEY instrumento_numero (instrumento_numero),
  KEY instrumento_responsavel (instrumento_responsavel),
  KEY instrumento_supervisor (instrumento_supervisor),
  KEY instrumento_autoridade (instrumento_autoridade),
  KEY instrumento_cliente (instrumento_cliente),
  KEY instrumento_fiscal (instrumento_fiscal),
  KEY instrumento_fiscal_substituto (instrumento_fiscal_substituto),
  KEY instrumento_dept (instrumento_dept),
  KEY instrumento_principal_indicador (instrumento_principal_indicador),
  KEY instrumento_moeda (instrumento_moeda),
  CONSTRAINT instrumento_campo FOREIGN KEY (instrumento_campo) REFERENCES instrumento_campo (instrumento_campo_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT instrumento_responsavel FOREIGN KEY (instrumento_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT instrumento_cia FOREIGN KEY (instrumento_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT instrumento_dept FOREIGN KEY (instrumento_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT instrumento_supervisor FOREIGN KEY (instrumento_supervisor) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT instrumento_autoridade FOREIGN KEY (instrumento_autoridade) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT instrumento_cliente FOREIGN KEY (instrumento_cliente) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT instrumento_fiscal FOREIGN KEY (instrumento_fiscal) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT instrumento_fiscal_substituto FOREIGN KEY (instrumento_fiscal_substituto) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT instrumento_principal_indicador FOREIGN KEY (instrumento_principal_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT instrumento_moeda FOREIGN KEY (instrumento_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS instrumento_contatos;

CREATE TABLE instrumento_contatos (
  instrumento_id INTEGER(100) UNSIGNED NOT NULL,
  contato_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY instrumento_contatos (instrumento_id, contato_id),
  KEY instrumento_id (instrumento_id),
  KEY contato_id (contato_id),
  CONSTRAINT instrumento_contatos_fk1 FOREIGN KEY (contato_id) REFERENCES contatos (contato_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT instrumento_contatos_fk FOREIGN KEY (instrumento_id) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS instrumento_depts;

CREATE TABLE instrumento_depts (
  instrumento_id INTEGER(100) UNSIGNED NOT NULL,
  dept_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY instrumento_depts (instrumento_id, dept_id),
  KEY instrumento_id (instrumento_id),
  KEY dept_id (dept_id),
  CONSTRAINT instrumento_depts_fk1 FOREIGN KEY (dept_id) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT instrumento_depts_fk FOREIGN KEY (instrumento_id) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS instrumento_designados;

CREATE TABLE instrumento_designados (
  instrumento_id INTEGER(100) UNSIGNED NOT NULL,
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY instrumento_designados (instrumento_id, usuario_id),
  KEY instrumento_id (instrumento_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT instrumento_designados_fk1 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT instrumento_designados_fk FOREIGN KEY (instrumento_id) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS instrumento_financeiro;
	
CREATE TABLE instrumento_financeiro (
	instrumento_financeiro_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	instrumento_financeiro_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_financeiro_projeto TEXT,
	instrumento_financeiro_tarefa TEXT,
	instrumento_financeiro_fonte VARCHAR(255) DEFAULT NULL,
	instrumento_financeiro_regiao VARCHAR(255) DEFAULT NULL,
	instrumento_financeiro_classificacao VARCHAR(255) DEFAULT NULL,
	instrumento_financeiro_valor DECIMAL(20,5) UNSIGNED DEFAULT 0,
	instrumento_financeiro_ano INTEGER(4) UNSIGNED DEFAULT NULL,
	instrumento_financeiro_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_financeiro_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (instrumento_financeiro_id),
	KEY instrumento_financeiro_instrumento (instrumento_financeiro_instrumento),
	CONSTRAINT instrumento_financeiro_instrumento FOREIGN KEY (instrumento_financeiro_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS instrumento_avulso_custo;

CREATE TABLE instrumento_avulso_custo (
  instrumento_avulso_custo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  instrumento_avulso_custo_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
  instrumento_avulso_custo_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  instrumento_avulso_custo_nome VARCHAR(255) DEFAULT NULL,
  instrumento_avulso_custo_codigo VARCHAR(255) DEFAULT NULL,
  instrumento_avulso_custo_fonte VARCHAR(255) DEFAULT NULL,
  instrumento_avulso_custo_regiao VARCHAR(255) DEFAULT NULL,
  instrumento_avulso_custo_tipo INTEGER(100) UNSIGNED DEFAULT 1,
  instrumento_avulso_custo_data DATETIME DEFAULT NULL,
  instrumento_avulso_custo_quantidade DECIMAL(20,10) UNSIGNED DEFAULT 0,
  instrumento_avulso_custo_custo DECIMAL(20,10) UNSIGNED DEFAULT 0,
  instrumento_avulso_custo_custo_atual DECIMAL(20,10) UNSIGNED DEFAULT 0,
  instrumento_avulso_custo_bdi DECIMAL(20,10) UNSIGNED DEFAULT 0,
	instrumento_avulso_custo_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
	instrumento_avulso_custo_cotacao DECIMAL(20,10) UNSIGNED DEFAULT 1, 
	instrumento_avulso_custo_data_moeda DATE DEFAULT NULL,
  instrumento_avulso_custo_descricao MEDIUMTEXT,
  instrumento_avulso_custo_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  instrumento_avulso_custo_nd VARCHAR(11) DEFAULT NULL,
  instrumento_avulso_custo_categoria_economica VARCHAR(1) DEFAULT NULL,
  instrumento_avulso_custo_grupo_despesa VARCHAR(1) DEFAULT NULL,
  instrumento_avulso_custo_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
	instrumento_avulso_custo_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
	instrumento_avulso_custo_data_limite DATE DEFAULT NULL,
	instrumento_avulso_custo_pi VARCHAR(100) DEFAULT NULL,
	instrumento_avulso_custo_ptres VARCHAR(100) DEFAULT NULL,
	instrumento_avulso_custo_meses INTEGER(4) UNSIGNED DEFAULT NULL,	
	instrumento_avulso_custo_servico TINYINT(1) DEFAULT 0,
	instrumento_avulso_custo_acrescimo DECIMAL(20,10) DEFAULT 0,
	instrumento_avulso_custo_percentual TINYINT(1) DEFAULT 0,
	instrumento_avulso_custo_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (instrumento_avulso_custo_id),
  KEY instrumento_avulso_custo_instrumento (instrumento_avulso_custo_instrumento),
  KEY instrumento_avulso_custo_usuario_inicio (instrumento_avulso_custo_usuario),
  KEY instrumento_avulso_custo_ordem (instrumento_avulso_custo_ordem),
  KEY instrumento_avulso_custo_data_inicio (instrumento_avulso_custo_data),
  KEY instrumento_avulso_custo_nome (instrumento_avulso_custo_nome),
  KEY instrumento_avulso_custo_moeda (instrumento_avulso_custo_moeda),
  CONSTRAINT instrumento_avulso_custo_usuario FOREIGN KEY (instrumento_avulso_custo_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT instrumento_avulso_custo_instrumento FOREIGN KEY (instrumento_avulso_custo_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT instrumento_avulso_custo_moeda FOREIGN KEY (instrumento_avulso_custo_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS instrumento_custo;

CREATE TABLE instrumento_custo (
  instrumento_custo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  instrumento_custo_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
  instrumento_custo_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  instrumento_custo_tr INTEGER(100) UNSIGNED DEFAULT NULL,
  instrumento_custo_avulso INTEGER(100) UNSIGNED DEFAULT NULL,
  instrumento_custo_acao INTEGER(100) UNSIGNED DEFAULT NULL,
  instrumento_custo_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
  instrumento_custo_quantidade DECIMAL(20,10) UNSIGNED DEFAULT 0,
	instrumento_custo_aprovou INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_custo_aprovado TINYINT(1) DEFAULT NULL,
	instrumento_custo_data_aprovado DATETIME DEFAULT NULL,
	instrumento_custo_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	instrumento_custo_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (instrumento_custo_id),
  KEY instrumento_custo_instrumento (instrumento_custo_instrumento),
  KEY instrumento_custo_tarefa (instrumento_custo_tarefa),
  KEY instrumento_custo_tr (instrumento_custo_tr),
  KEY instrumento_custo_avulso (instrumento_custo_avulso),
  KEY instrumento_custo_acao (instrumento_custo_acao),
  KEY instrumento_custo_demanda (instrumento_custo_demanda),
  KEY instrumento_custo_aprovou (instrumento_custo_aprovou),
  CONSTRAINT instrumento_custo_instrumento FOREIGN KEY (instrumento_custo_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT instrumento_custo_tarefa FOREIGN KEY (instrumento_custo_tarefa) REFERENCES tarefa_custos (tarefa_custos_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT instrumento_custo_tr FOREIGN KEY (instrumento_custo_tr) REFERENCES tr_avulso_custo (tr_avulso_custo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT instrumento_custo_avulso FOREIGN KEY (instrumento_custo_avulso) REFERENCES instrumento_avulso_custo (instrumento_avulso_custo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_custo_acao FOREIGN KEY (instrumento_custo_acao) REFERENCES plano_acao_item_custos (plano_acao_item_custos_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT instrumento_custo_demanda FOREIGN KEY (instrumento_custo_demanda) REFERENCES demanda_custo (demanda_custo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT instrumento_custo_aprovou FOREIGN KEY (instrumento_custo_aprovou) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS instrumento_campo;

CREATE TABLE instrumento_campo (
  instrumento_campo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  instrumento_campo_nome VARCHAR(255) NOT NULL,
  instrumento_campo_ordem INTEGER(100) DEFAULT NULL,
  instrumento_identificacao TINYINT(1) DEFAULT 1,
  instrumento_identificacao_leg VARCHAR(50) DEFAULT 'NULL',
  instrumento_nome TINYINT(1) DEFAULT 1,
  instrumento_nome_leg VARCHAR(50) DEFAULT 'NULL',
  instrumento_entidade TINYINT(1) DEFAULT 1,
  instrumento_entidade_leg VARCHAR(50) DEFAULT NULL,
  instrumento_entidade_cnpj TINYINT(1) DEFAULT 1,
  instrumento_entidade_cnpj_leg VARCHAR(50) DEFAULT NULL,
  instrumento_entidade_codigo TINYINT(1) DEFAULT 1,
  instrumento_entidade_codigo_leg VARCHAR(50) DEFAULT NULL,
  instrumento_tipo TINYINT(1) DEFAULT 1,
  instrumento_tipo_leg VARCHAR(50) DEFAULT NULL,
  instrumento_numero TINYINT(1) DEFAULT 1,
  instrumento_numero_leg VARCHAR(50) DEFAULT NULL,
  instrumento_ano TINYINT(1) DEFAULT 1,
  instrumento_ano_leg VARCHAR(50) DEFAULT NULL,
  instrumento_prorrogavel TINYINT(1) DEFAULT 0,
  instrumento_prorrogavel_leg VARCHAR(50) DEFAULT 'NULL',
  instrumento_situacao TINYINT(1) DEFAULT 1,
  instrumento_situacao_leg VARCHAR(50) DEFAULT NULL,
  instrumento_valor TINYINT(1) DEFAULT 1,
  instrumento_valor_leg VARCHAR(50) DEFAULT NULL,
  instrumento_valor_atual TINYINT(1) DEFAULT 1,
  instrumento_valor_atual_leg VARCHAR(50) DEFAULT NULL,
  instrumento_valor_contrapartida TINYINT(1) DEFAULT 1,
  instrumento_valor_contrapartida_leg VARCHAR(50) DEFAULT NULL,
  instrumento_valor_repasse TINYINT(1) DEFAULT 1,
  instrumento_valor_repasse_leg VARCHAR(50) DEFAULT NULL,
  instrumento_fim_contrato TINYINT(1) DEFAULT 1,
  instrumento_fim_contrato_leg VARCHAR(50) DEFAULT NULL,
  instrumento_moeda TINYINT(1) DEFAULT 1,
  instrumento_moeda_leg VARCHAR(50) DEFAULT 'NULL',
  instrumento_demandante TINYINT(1) DEFAULT 1,
  instrumento_demandante_leg VARCHAR(50) DEFAULT 'NULL',
  instrumento_cia TINYINT(1) DEFAULT 1,
  instrumento_cias TINYINT(1) DEFAULT 1,
  instrumento_dept TINYINT(1) DEFAULT 1,
  instrumento_depts TINYINT(1) DEFAULT 1,
  instrumento_responsavel TINYINT(1) DEFAULT 1,
  instrumento_designados TINYINT(1) DEFAULT 1,
  instrumento_supervisor TINYINT(1) DEFAULT 1,
  instrumento_autoridade TINYINT(1) DEFAULT 1,
  instrumento_cliente TINYINT(1) DEFAULT 1,
  instrumento_fiscal TINYINT(1) DEFAULT 1,
  instrumento_fiscal_leg VARCHAR(50) DEFAULT NULL,
  instrumento_fiscal_substituto TINYINT(1) DEFAULT 1,
  instrumento_fiscal_substituto_leg VARCHAR(50) DEFAULT NULL,
  instrumento_adtivo TINYINT(1) DEFAULT 1,
  instrumento_adtivo_leg VARCHAR(50) DEFAULT 'NULL',
  instrumento_prazo_prorrogacao TINYINT(1) DEFAULT 1,
  instrumento_prazo_prorrogacao_leg VARCHAR(50) DEFAULT NULL,
  instrumento_acrescimo TINYINT(1) DEFAULT 1,
  instrumento_acrescimo_leg VARCHAR(50) DEFAULT NULL,
  instrumento_supressao TINYINT(1) DEFAULT 1,
  instrumento_supressao_leg VARCHAR(50) DEFAULT NULL,
  instrumento_detalhamento TINYINT(1) DEFAULT 1,
  instrumento_detalhamento_leg VARCHAR(50) DEFAULT 'NULL',
  instrumento_objeto TINYINT(1) DEFAULT 1,
  instrumento_objeto_leg VARCHAR(50) DEFAULT NULL,
  instrumento_justificativa TINYINT(1) DEFAULT 1,
  instrumento_justificativa_leg VARCHAR(50) DEFAULT NULL,
  instrumento_resultado_esperado TINYINT(1) DEFAULT 1,
  instrumento_resultado_esperado_leg VARCHAR(50) DEFAULT NULL,
  instrumento_situacao_atual TINYINT(1) DEFAULT 1,
  instrumento_situacao_atual_leg VARCHAR(50) DEFAULT NULL,
  instrumento_vantagem_economica TINYINT(1) DEFAULT 1,
  instrumento_vantagem_economica_leg VARCHAR(50) DEFAULT NULL,
  instrumento_datas TINYINT(1) DEFAULT 1,
  instrumento_datas_leg VARCHAR(50) DEFAULT 'NULL',
  instrumento_data_celebracao TINYINT(1) DEFAULT 1,
  instrumento_data_celebracao_leg VARCHAR(50) DEFAULT NULL,
  instrumento_data_inicio TINYINT(1) DEFAULT 1,
  instrumento_data_inicio_leg VARCHAR(50) DEFAULT NULL,
  instrumento_data_termino TINYINT(1) DEFAULT 1,
  instrumento_data_termino_leg VARCHAR(50) DEFAULT NULL,
  instrumento_data_publicacao TINYINT(1) DEFAULT 1,
  instrumento_data_publicacao_leg VARCHAR(50) DEFAULT NULL,
	instrumento_garantia_contratual TINYINT(1) DEFAULT 1,
	instrumento_garantia_contratual_leg VARCHAR(50) DEFAULT NULL,
	instrumento_garantia_contratual_modalidade TINYINT(1) DEFAULT 1,
	instrumento_garantia_contratual_modalidade_leg VARCHAR(50) DEFAULT NULL,
	instrumento_garantia_contratual_percentual TINYINT(1) DEFAULT 1,
	instrumento_garantia_contratual_vencimento TINYINT(1) DEFAULT 1,
  instrumento_protocolo TINYINT(1) DEFAULT 1,
  instrumento_protocolo_leg VARCHAR(50) DEFAULT 'NULL',
  instrumento_licitacao TINYINT(1) DEFAULT 1,
  instrumento_licitacao_leg VARCHAR(50) DEFAULT NULL,
  instrumento_edital_nr TINYINT(1) DEFAULT 1,
  instrumento_edital_nr_leg VARCHAR(50) DEFAULT NULL,
  instrumento_processo TINYINT(1) DEFAULT 1,
  instrumento_processo_leg VARCHAR(50) DEFAULT NULL,
  instrumento_dados TINYINT(1) DEFAULT 1,
  instrumento_dados_leg VARCHAR(50) DEFAULT 'NULL',
  instrumento_porcentagem TINYINT(1) DEFAULT 1,
  instrumento_porcentagem_leg VARCHAR(50) DEFAULT NULL,
  instrumento_cor TINYINT(1) DEFAULT 1,
  instrumento_cor_leg VARCHAR(50) DEFAULT NULL,
  instrumento_ativo TINYINT(1) DEFAULT 1,
  instrumento_ativo_leg VARCHAR(50) DEFAULT NULL,
  instrumento_acesso TINYINT(1) DEFAULT 1,
  instrumento_principal_indicador TINYINT(1) DEFAULT 1,
  instrumento_principal_indicador_leg VARCHAR(50) DEFAULT NULL,
  instrumento_aprovado TINYINT(1) DEFAULT 1,
  instrumento_aprovado_leg VARCHAR(50) DEFAULT NULL,
  instrumento_contatos TINYINT(1) DEFAULT 1,
  instrumento_recursos TINYINT(1) DEFAULT 1,
  instrumento_relacionados TINYINT(1) DEFAULT 1,
  instrumento_financeiro TINYINT(1) DEFAULT 1,
  instrumento_financeiro_leg VARCHAR(50) DEFAULT NULL,
  instrumento_financeiro_projeto_leg VARCHAR(50) DEFAULT NULL,
  instrumento_financeiro_tarefa TINYINT(1) DEFAULT 1,
  instrumento_financeiro_tarefa_leg VARCHAR(50) DEFAULT NULL,
  instrumento_financeiro_fonte TINYINT(1) DEFAULT 1,
  instrumento_financeiro_fonte_leg VARCHAR(50) DEFAULT NULL,
  instrumento_financeiro_regiao TINYINT(1) DEFAULT 1,
  instrumento_financeiro_regiao_leg VARCHAR(50) DEFAULT NULL,
  instrumento_financeiro_classificacao TINYINT(1) DEFAULT 1,
  instrumento_financeiro_classificacao_leg VARCHAR(50) DEFAULT NULL,
  instrumento_avulso_custo TINYINT(1) DEFAULT 1,
  instrumento_avulso_custo_leg VARCHAR(50) DEFAULT NULL,
  instrumento_avulso_custo_custo_atual TINYINT(1) DEFAULT 1,
  instrumento_avulso_custo_usuario TINYINT(1) DEFAULT 1,
  instrumento_avulso_custo_codigo TINYINT(1) DEFAULT 1,
  instrumento_avulso_custo_codigo_leg VARCHAR(50) DEFAULT NULL,
  instrumento_avulso_custo_fonte TINYINT(1) DEFAULT 1,
  instrumento_avulso_custo_fonte_leg VARCHAR(50) DEFAULT NULL,
  instrumento_avulso_custo_regiao TINYINT(1) DEFAULT 1,
  instrumento_avulso_custo_regiao_leg VARCHAR(50) DEFAULT NULL,
  instrumento_avulso_custo_tipo TINYINT(1) DEFAULT 1,
  instrumento_avulso_custo_tipo_leg VARCHAR(50) DEFAULT NULL,
  instrumento_avulso_custo_bdi TINYINT(1) DEFAULT 1,
  instrumento_avulso_custo_bdi_leg VARCHAR(50) DEFAULT NULL,
  instrumento_avulso_custo_moeda TINYINT(1) DEFAULT 1,
  instrumento_avulso_custo_nd TINYINT(1) DEFAULT 1,
  instrumento_avulso_custo_nd_leg VARCHAR(50) DEFAULT NULL,
  instrumento_avulso_custo_categoria_economica_leg VARCHAR(50) DEFAULT NULL,
  instrumento_avulso_custo_grupo_despesa_leg VARCHAR(50) DEFAULT NULL,
  instrumento_avulso_custo_modalidade_aplicacao_leg VARCHAR(50) DEFAULT NULL,
  instrumento_avulso_custo_data_limite TINYINT(1) DEFAULT 1,
  instrumento_avulso_custo_data_limite_leg VARCHAR(50) DEFAULT NULL,
  instrumento_avulso_custo_pi TINYINT(1) DEFAULT 1,
  instrumento_avulso_custo_pi_leg VARCHAR(50) DEFAULT NULL,
  instrumento_avulso_custo_ptres TINYINT(1) DEFAULT 1,
  instrumento_avulso_custo_ptres_leg VARCHAR(50) DEFAULT NULL,
  instrumento_avulso_custo_acrescimo TINYINT(1) DEFAULT 1,
  instrumento_avulso_custo_acrescimo_leg VARCHAR(50) DEFAULT NULL,
  instrumento_avulso_custo_acrescimo_leg2 VARCHAR(50) DEFAULT 'NULL',
  instrumento_avulso_custo_percentual TINYINT(1) DEFAULT 1,
  instrumento_avulso_custo_percentual_leg VARCHAR(50) DEFAULT NULL,
  instrumento_avulso_custo_exercicio TINYINT(1) DEFAULT 1,
  instrumento_avulso_custo_exercicio_leg VARCHAR(50) DEFAULT 'NULL',
  instrumento_local_entrega TINYINT(1) DEFAULT 1,
  instrumento_local_entrega_leg VARCHAR(50) DEFAULT NULL,
  PRIMARY KEY (instrumento_campo_id)
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS recursos;

CREATE TABLE recursos (
  recurso_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  recurso_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_principal_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_nome VARCHAR(255) DEFAULT NULL,
  recurso_chave VARCHAR(64) DEFAULT NULL,
  recurso_tipo INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_nota TEXT,
  recurso_max_alocacao INTEGER(100) UNSIGNED DEFAULT '100',
  recurso_nivel_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  recurso_unidade INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_quantidade DECIMAL(20,5) UNSIGNED DEFAULT 0,
  recurso_custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
  recurso_categoria_economica VARCHAR(1) DEFAULT NULL,
  recurso_grupo_despesa VARCHAR(1) DEFAULT NULL,
  recurso_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  recurso_nd VARCHAR(11) DEFAULT NULL,
  recurso_ev VARCHAR(20) DEFAULT NULL,
  recurso_esf VARCHAR(20) DEFAULT NULL,
  recurso_ptres VARCHAR(20) DEFAULT NULL,
  recurso_fonte VARCHAR(20) DEFAULT NULL,
  recurso_sb VARCHAR(20) DEFAULT NULL,
  recurso_ugr VARCHAR(20) DEFAULT NULL,
  recurso_pi VARCHAR(20) DEFAULT NULL,
  recurso_ano INTEGER(4) UNSIGNED DEFAULT NULL,
  recurso_resultado_primario VARCHAR(1) DEFAULT NULL,
  recurso_origem VARCHAR(1) DEFAULT NULL,
  recurso_contato INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_credito_adicional VARCHAR(1) DEFAULT NULL,
  recurso_movimentacao_orcamentaria VARCHAR(1) DEFAULT NULL,
  recurso_identificador_uso VARCHAR(2) DEFAULT NULL,
  recurso_esfera_orcamentaria VARCHAR(2) DEFAULT NULL,
  recurso_liberado DECIMAL(20,5) UNSIGNED DEFAULT 0,
  recurso_hora_custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
  recurso_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
  recurso_ativo TINYINT(1) DEFAULT 1,
  recurso_aprovado TINYINT(1) DEFAULT 0,
  recurso_cor VARCHAR(6) DEFAULT 'FFFFFF',
  PRIMARY KEY (recurso_id),
  KEY recurso_nome (recurso_nome),
  KEY recurso_tipo (recurso_tipo),
  KEY recurso_cia (recurso_cia),
  KEY recurso_dept (recurso_dept),
  KEY recurso_responsavel (recurso_responsavel),
	KEY recurso_principal_indicador (recurso_principal_indicador),
	KEY recurso_moeda (recurso_moeda),
  CONSTRAINT recurso_cia FOREIGN KEY (recurso_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT recurso_responsavel FOREIGN KEY (recurso_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT recurso_dept FOREIGN KEY (recurso_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT recurso_principal_indicador FOREIGN KEY (recurso_principal_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT recurso_moeda FOREIGN KEY (recurso_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS instrumento_recursos;

CREATE TABLE instrumento_recursos (
  instrumento_id INTEGER(100) UNSIGNED NOT NULL,
  recurso_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY instrumento_recursos (instrumento_id, recurso_id),
  KEY instrumento_id (instrumento_id),
  KEY recurso_id (recurso_id),
  CONSTRAINT instrumento_recursos_fk1 FOREIGN KEY (recurso_id) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT instrumento_recursos_fk FOREIGN KEY (instrumento_id) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS links;

CREATE TABLE links (
  link_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  link_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  link_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  link_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  link_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  link_dono INTEGER(100) UNSIGNED DEFAULT NULL,
  link_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
  link_acao INTEGER(100) UNSIGNED DEFAULT NULL,
  link_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  link_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
  link_tema INTEGER(100) UNSIGNED DEFAULT NULL,
  link_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
  link_fator INTEGER(100) UNSIGNED DEFAULT NULL,
  link_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
  link_meta INTEGER(100) UNSIGNED DEFAULT NULL,
  link_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
  link_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  link_principal_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  link_nome VARCHAR(255) DEFAULT NULL,
  link_url VARCHAR(255) DEFAULT NULL,
  link_descricao TEXT,
  link_data DATETIME DEFAULT NULL,
  link_categoria INTEGER(100) UNSIGNED DEFAULT NULL,
  link_icone VARCHAR(20) DEFAULT 'obj/',
  link_moeda INTEGER(100) UNSIGNED DEFAULT 1,
  link_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  link_ativo TINYINT(1) DEFAULT 1,
  link_aprovado TINYINT(1) DEFAULT 0,
  link_cor VARCHAR(6) DEFAULT 'FFFFFF',
  PRIMARY KEY (link_id),
  KEY idx_link_tarefa (link_tarefa),
  KEY idx_link_projeto (link_projeto),
  KEY link_nome (link_nome),
  KEY link_pratica (link_pratica),
  KEY link_acao (link_acao),
  KEY link_indicador (link_indicador),
  KEY link_perspectiva (link_perspectiva),
  KEY link_tema (link_tema),
  KEY link_objetivo (link_objetivo),
  KEY link_fator (link_fator),
  KEY link_estrategia (link_estrategia),
  KEY link_meta (link_meta),
  KEY link_cia (link_cia),
  KEY link_dept (link_dept),
  KEY link_dono (link_dono),
  KEY link_usuario (link_usuario),
  KEY link_canvas (link_canvas),
  KEY link_principal_indicador (link_principal_indicador),
  KEY link_moeda (link_moeda),
  CONSTRAINT link_usuario FOREIGN KEY (link_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT link_cia FOREIGN KEY (link_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT link_dept FOREIGN KEY (link_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT link_dono FOREIGN KEY (link_dono) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT link_estrategia FOREIGN KEY (link_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT link_meta FOREIGN KEY (link_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT link_tema FOREIGN KEY (link_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT link_projeto FOREIGN KEY (link_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT link_tarefa FOREIGN KEY (link_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT link_pratica FOREIGN KEY (link_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT link_acao FOREIGN KEY (link_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT link_indicador FOREIGN KEY (link_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT link_objetivo FOREIGN KEY (link_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT link_fator FOREIGN KEY (link_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT link_perspectiva FOREIGN KEY (link_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT link_canvas FOREIGN KEY (link_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT link_principal_indicador FOREIGN KEY (link_principal_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT link_moeda FOREIGN KEY (link_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS link_dept;

CREATE TABLE link_dept (
  link_dept_link INTEGER(100) UNSIGNED NOT NULL,
  link_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (link_dept_link, link_dept_dept),
  KEY link_dept_link (link_dept_link),
  KEY link_dept_dept (link_dept_dept),
  CONSTRAINT link_dept_dept FOREIGN KEY (link_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT link_dept_link FOREIGN KEY (link_dept_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS link_usuarios;

CREATE TABLE link_usuarios (
  link_id INTEGER(100) UNSIGNED NOT NULL,
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (link_id, usuario_id),
  KEY link_id (link_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT link_usuarios_fk1 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT link_usuarios_fk FOREIGN KEY (link_id) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS melhores_praticas;

CREATE TABLE melhores_praticas (
  pratica_id INTEGER(100) UNSIGNED NOT NULL,
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  justificativa TEXT,
  data DATE DEFAULT NULL,
  PRIMARY KEY (pratica_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT melhores_praticas_fk FOREIGN KEY (pratica_id) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT melhores_praticas_fk1 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS metas_depts;

CREATE TABLE metas_depts (
  pg_meta_id INTEGER(100) UNSIGNED NOT NULL,
  dept_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (pg_meta_id, dept_id),
  KEY pg_meta_id (pg_meta_id),
  KEY dept_id (dept_id),
  CONSTRAINT metas_depts_fk1 FOREIGN KEY (dept_id) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT metas_depts_fk FOREIGN KEY (pg_meta_id) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS metas_usuarios;

CREATE TABLE metas_usuarios (
  pg_meta_id INTEGER(100) UNSIGNED NOT NULL,
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (pg_meta_id, usuario_id),
  KEY pg_meta_id (pg_meta_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT metas_usuarios_fk1 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT metas_usuarios_fk FOREIGN KEY (pg_meta_id) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS modelos_dados;

CREATE TABLE modelos_dados (
  modelo_dados_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  modelo_dados_modelo INTEGER(100) UNSIGNED,
  modelos_dados_criador INTEGER(100) UNSIGNED DEFAULT NULL,
  modelos_dados_campos LONGBLOB,
  nome_usuario VARCHAR(50) DEFAULT NULL,
  funcao_usuario VARCHAR(50) DEFAULT NULL,
  modelo_dados_data DATETIME DEFAULT NULL,
  PRIMARY KEY (modelo_dados_id),
  KEY modelo_dados_modelo (modelo_dados_modelo),
  KEY modelos_dados_criador (modelos_dados_criador),
  KEY modelo_dados_data (modelo_dados_data),
  CONSTRAINT modelos_dados_fk FOREIGN KEY (modelo_dados_modelo) REFERENCES modelos (modelo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT modelos_dados_fk1 FOREIGN KEY (modelos_dados_criador) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS modelos_tipo;

CREATE TABLE modelos_tipo (
  modelo_tipo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  modelo_tipo_nome VARCHAR(64) DEFAULT NULL,
  modelo_tipo_campos LONGBLOB,
  descricao TEXT,
  imagem VARCHAR(200) DEFAULT NULL,
  organizacao INTEGER(11) DEFAULT 1,
  modelo_tipo_html MEDIUMTEXT,
  PRIMARY KEY (modelo_tipo_id)
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS modelo_cia;

CREATE TABLE modelo_cia (
  modelo_cia_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  modelo_cia_tipo INTEGER(100) UNSIGNED NOT NULL,
  modelo_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (modelo_cia_id),
  KEY modelo_cia_tipo (modelo_cia_tipo),
  KEY modelo_cia_cia (modelo_cia_cia),
  CONSTRAINT modelo_cia_tipo FOREIGN KEY (modelo_cia_tipo) REFERENCES modelos_tipo (modelo_tipo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT modelo_cia_cia FOREIGN KEY (modelo_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS modelos;

CREATE TABLE modelos (
  modelo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  modelo_tipo INTEGER(100) UNSIGNED NOT NULL,
  modelo_criador_original INTEGER(100) UNSIGNED DEFAULT NULL,
  modelo_autoridade_assinou INTEGER(100) UNSIGNED DEFAULT NULL,
  modelo_protocolista INTEGER(100) UNSIGNED DEFAULT NULL,
  modelo_chave_publica INTEGER(100) UNSIGNED DEFAULT NULL,
  modelo_versao_aprovada INTEGER(100) UNSIGNED,
  modelo_autoridade_aprovou INTEGER(100) UNSIGNED DEFAULT NULL,
  modelo_pode_alterar TINYINT(1) DEFAULT 0,
  modelo_data DATETIME DEFAULT NULL,
  modelo_assinatura TEXT,
  modelo_protocolo VARCHAR(50) DEFAULT NULL,
  modelo_data_protocolo DATETIME DEFAULT NULL,
  modelo_data_assinado DATETIME DEFAULT NULL,
  modelo_data_aprovado DATETIME DEFAULT NULL,
  modelo_assunto VARCHAR(255) DEFAULT NULL,
  modelo_numero VARCHAR(50) DEFAULT NULL,
  class_sigilosa INTEGER(11) DEFAULT 0,
  prioridade INTEGER(11) DEFAULT 0,
  modelo_criador_nome VARCHAR(50) DEFAULT NULL,
  modelo_criador_funcao VARCHAR(50) DEFAULT NULL,
  modelo_aprovou_nome VARCHAR(50) DEFAULT NULL,
  modelo_aprovou_funcao VARCHAR(50) DEFAULT NULL,
  modelo_assinatura_nome VARCHAR(50) DEFAULT NULL,
  modelo_assinatura_funcao VARCHAR(50) DEFAULT NULL,
  modelo_aprovado TINYINT(1) DEFAULT 0,
  PRIMARY KEY (modelo_id),
  KEY modelo_tipo (modelo_tipo),
  KEY modelo_criador_original (modelo_criador_original),
  KEY modelo_data (modelo_data),
  KEY modelo_versao_aprovada (modelo_versao_aprovada),
  KEY modelo_autoridade_assinou (modelo_autoridade_assinou),
  KEY modelo_chave_publica (modelo_chave_publica),
  KEY modelo_protocolista (modelo_protocolista),
  KEY modelo_autoridade_aprovou (modelo_autoridade_aprovou),
  CONSTRAINT modelos_fk6 FOREIGN KEY (modelo_autoridade_aprovou) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT modelos_fk FOREIGN KEY (modelo_tipo) REFERENCES modelos_tipo (modelo_tipo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT modelos_fk1 FOREIGN KEY (modelo_criador_original) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT modelos_fk2 FOREIGN KEY (modelo_versao_aprovada) REFERENCES modelos_dados (modelo_dados_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT modelos_fk3 FOREIGN KEY (modelo_autoridade_assinou) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT modelos_fk4 FOREIGN KEY (modelo_chave_publica) REFERENCES chaves_publicas (chave_publica_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT modelos_fk5 FOREIGN KEY (modelo_protocolista) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS modelo_anotacao;

CREATE TABLE modelo_anotacao (
  modelo_anotacao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  modelo_id INTEGER(100) UNSIGNED DEFAULT NULL,
  modelo_usuario_id INTEGER(100) UNSIGNED DEFAULT NULL,
  usuario_id INTEGER(100) UNSIGNED DEFAULT NULL,
  chave_publica INTEGER(100) UNSIGNED DEFAULT NULL,
  datahora DATETIME DEFAULT NULL,
  texto TEXT,
  tipo INTEGER(2) DEFAULT 0,
  nome_de VARCHAR(50) DEFAULT NULL,
  funcao_de VARCHAR(50) DEFAULT NULL,
  modelo_anotacao_usuarios INTEGER(1) DEFAULT 0,
  assinatura TEXT,
  PRIMARY KEY (modelo_anotacao_id),
  KEY modelo_id (modelo_id),
  KEY modelo_usuario_id (modelo_usuario_id),
  KEY usuario_id (usuario_id),
  KEY chave_publica (chave_publica),
  CONSTRAINT modelo_anotacao_fk2 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT modelo_anotacao_fk FOREIGN KEY (modelo_id) REFERENCES modelos (modelo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT modelo_anotacao_fk1 FOREIGN KEY (modelo_usuario_id) REFERENCES modelo_usuario (modelo_usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT modelo_anotacao_fk3 FOREIGN KEY (chave_publica) REFERENCES chaves_publicas (chave_publica_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS pasta;

CREATE TABLE pasta (
  pasta_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  usuario_id INTEGER(100) UNSIGNED,
  nome VARCHAR(20) DEFAULT NULL,
  pasta_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (pasta_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT pasta_fk FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS modelo_usuario;

CREATE TABLE modelo_usuario (
  modelo_usuario_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  de_id INTEGER(100) UNSIGNED DEFAULT NULL,
  para_id INTEGER(100) UNSIGNED DEFAULT NULL,
  modelo_id INTEGER(100) UNSIGNED DEFAULT NULL,
  pasta_id INTEGER(100) UNSIGNED DEFAULT NULL,
  modelo_anotacao_id INTEGER(100) UNSIGNED DEFAULT NULL,
  despacho_pasta_envio INTEGER(100) UNSIGNED DEFAULT NULL,
  despacho_pasta_receb INTEGER(100) UNSIGNED DEFAULT NULL,
  status INTEGER(2) DEFAULT 0,
  tipo INTEGER(2) DEFAULT 0,
  datahora DATETIME DEFAULT NULL,
  datahora_leitura DATETIME DEFAULT NULL,
  cm INTEGER(100) UNSIGNED DEFAULT NULL,
  meio VARCHAR(100) DEFAULT NULL,
  aviso_leitura TINYINT(1) DEFAULT 0,
  copia_oculta TINYINT(1) DEFAULT 0,
  nome_de VARCHAR(50) DEFAULT NULL,
  funcao_de VARCHAR(30) DEFAULT NULL,
  nome_para VARCHAR(50) DEFAULT NULL,
  funcao_para VARCHAR(30) DEFAULT NULL,
  cor VARCHAR(6) DEFAULT NULL,
  nota TEXT,
  resposta_despacho TEXT,
  data_retorno DATETIME DEFAULT NULL,
  data_limite DATETIME DEFAULT NULL,
  tarefa TINYINT(1) DEFAULT NULL,
  tarefa_progresso INTEGER(2) DEFAULT 0,
  tarefa_data DATE DEFAULT NULL,
  ignorar_de TINYINT(1) DEFAULT NULL,
  ignorar_para TINYINT(1) DEFAULT NULL,
  PRIMARY KEY (modelo_usuario_id),
  KEY de_id (de_id),
  KEY para_id (para_id),
  KEY modelo_id (modelo_id),
  KEY modelo_anotacao_id (modelo_anotacao_id),
  KEY despacho_pasta_envio (despacho_pasta_envio),
  KEY despacho_pasta_receb (despacho_pasta_receb),
  KEY pasta_id (pasta_id),
  CONSTRAINT modelo_usuario_fk6 FOREIGN KEY (pasta_id) REFERENCES pasta (pasta_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT modelo_usuario_fk FOREIGN KEY (de_id) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT modelo_usuario_fk1 FOREIGN KEY (para_id) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT modelo_usuario_fk2 FOREIGN KEY (modelo_id) REFERENCES modelos (modelo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT modelo_usuario_fk3 FOREIGN KEY (modelo_anotacao_id) REFERENCES modelo_anotacao (modelo_anotacao_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT modelo_usuario_fk4 FOREIGN KEY (despacho_pasta_envio) REFERENCES pasta (pasta_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT modelo_usuario_fk5 FOREIGN KEY (despacho_pasta_receb) REFERENCES pasta (pasta_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS modelo_anotacao_usuarios;

CREATE TABLE modelo_anotacao_usuarios (
  modelo_anotacao_usuarios_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  modelo_anotacao_id INTEGER(100) UNSIGNED NOT NULL,
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (modelo_anotacao_usuarios_id),
  KEY modelo_anotacao_id (modelo_anotacao_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT modelo_anotacao_usuarios_fk1 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT modelo_anotacao_usuarios_fk FOREIGN KEY (modelo_anotacao_id) REFERENCES modelo_anotacao (modelo_anotacao_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS modelo_leitura;

CREATE TABLE modelo_leitura (
  modelo_leitura_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  modelo_id INTEGER(100) UNSIGNED NOT NULL,
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  datahora_leitura DATETIME DEFAULT NULL,
  download SMALLINT(1) DEFAULT 0,
  PRIMARY KEY (modelo_leitura_id),
  KEY modelo_id (modelo_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT modelo_leitura_fk1 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT modelo_leitura_fk FOREIGN KEY (modelo_id) REFERENCES modelos (modelo_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS modelo_usuario_ext;

CREATE TABLE modelo_usuario_ext (
  modelo_usuario_ext_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  de_id INTEGER(100) UNSIGNED DEFAULT NULL,
  modelo_id INTEGER(100) UNSIGNED DEFAULT NULL,
  para VARCHAR(100) DEFAULT NULL,
  tipo INTEGER(2) DEFAULT 0,
  datahora DATETIME DEFAULT NULL,
  cm INTEGER(100) UNSIGNED DEFAULT NULL,
  meio VARCHAR(100) DEFAULT NULL,
  PRIMARY KEY (modelo_usuario_ext_id),
  KEY de_id (de_id),
  KEY modelo_id (modelo_id),
  CONSTRAINT modelo_usuario_ext_fk FOREIGN KEY (de_id) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT modelo_usuario_ext_fk1 FOREIGN KEY (modelo_id) REFERENCES modelos (modelo_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS modelo_anexo;

CREATE TABLE modelo_anexo (
	modelo_anexo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	modelo_anexo_modelo INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_anexo_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_anexo_chave_publica INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_anexo_nome VARCHAR(255) DEFAULT NULL,
	modelo_anexo_caminho VARCHAR(255) DEFAULT NULL,
	modelo_anexo_tipo_doc VARCHAR(80) DEFAULT NULL,
	modelo_anexo_doc_nr VARCHAR(10) DEFAULT NULL,
	modelo_anexo_nome_de VARCHAR(50) DEFAULT NULL,
	modelo_anexo_funcao_de VARCHAR(50) DEFAULT NULL,
	modelo_anexo_data_envio DATETIME DEFAULT NULL,
	modelo_anexo_assinatura TEXT,
	modelo_anexo_nome_fantasia VARCHAR(255) DEFAULT NULL,
	modelo_anexo_uuid VARCHAR(36) DEFAULT NULL,
	modelo_anexo_nome_real VARCHAR(255) DEFAULT NULL,
	modelo_anexo_local VARCHAR(255) DEFAULT NULL,
	modelo_anexo_tamanho INTEGER(100) UNSIGNED DEFAULT NULL,
	modelo_anexo_tipo VARCHAR(50) DEFAULT NULL,
	modelo_anexo_extensao VARCHAR(50) DEFAULT NULL,
	modelo_anexo_ordem INTEGER(11) DEFAULT 0,
	PRIMARY KEY (modelo_anexo_id),
	KEY modelo_anexo_modelo (modelo_anexo_modelo),
	KEY modelo_anexo_usuario (modelo_anexo_usuario),
	KEY modelo_anexo_chave_publica (modelo_anexo_chave_publica),
	CONSTRAINT modelo_anexo_chave_publica FOREIGN KEY (modelo_anexo_chave_publica) REFERENCES chaves_publicas (chave_publica_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT modelo_anexo_modelo FOREIGN KEY (modelo_anexo_modelo) REFERENCES modelos (modelo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT modelo_anexo_usuario FOREIGN KEY (modelo_anexo_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS modulos;

CREATE TABLE modulos (
  mod_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  mod_diretorio VARCHAR(64) NOT NULL,
  mod_nome VARCHAR(64) DEFAULT NULL,
  mod_versao VARCHAR(10) DEFAULT NULL,
  mod_classe_configurar VARCHAR(64) DEFAULT NULL,
  mod_tipo VARCHAR(64) DEFAULT NULL,
  mod_ativo INTEGER(1) UNSIGNED DEFAULT 0,
  mod_ui_nome VARCHAR(20) DEFAULT NULL,
  mod_ui_icone VARCHAR(64) DEFAULT NULL,
  mod_ui_ordem TINYINT(3) DEFAULT 0,
  mod_ui_ativo INTEGER(1) UNSIGNED DEFAULT 0,
  mod_descricao VARCHAR(255) DEFAULT NULL,
  mod_menu TEXT,
  permissoes_item_tabela VARCHAR(100) DEFAULT NULL,
  permissoes_item_campo VARCHAR(100) DEFAULT NULL,
  permissoes_item_legenda VARCHAR(100) DEFAULT NULL,
  mod_classe_principal VARCHAR(30) DEFAULT NULL,
  mod_texto_botao VARCHAR(255) DEFAULT NULL,
  sempre_ativo TINYINT(1) DEFAULT 0,
  PRIMARY KEY (mod_id, mod_diretorio),
  KEY mod_id (mod_id),
  KEY mod_diretorio (mod_diretorio),
  KEY mod_ui_ordem (mod_ui_ordem),
  KEY mod_ativo (mod_ativo),
  KEY permissoes_item_tabela (permissoes_item_tabela)
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS msg_cripto;

CREATE TABLE msg_cripto (
  msg_cripto_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  msg_cripto_de INTEGER(100) UNSIGNED DEFAULT NULL,
  msg_cripto_para INTEGER(100) UNSIGNED DEFAULT NULL,
  msg_cripto_msg INTEGER(100) UNSIGNED DEFAULT NULL,
  chave_publica INTEGER(100) UNSIGNED DEFAULT NULL,
  texto TEXT,
  chave_envelope TEXT,
  tipo_cripto INTEGER(2) DEFAULT 0,
  PRIMARY KEY (msg_cripto_id),
  KEY msg_cripto_msg (msg_cripto_msg),
  KEY msg_cripto_de (msg_cripto_de),
  KEY msg_cripto_para (msg_cripto_para),
  KEY chave_publica (chave_publica),
  CONSTRAINT msg_cripto_fk FOREIGN KEY (msg_cripto_de) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT msg_cripto_fk1 FOREIGN KEY (msg_cripto_para) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT msg_cripto_fk2 FOREIGN KEY (msg_cripto_msg) REFERENCES msg (msg_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT msg_cripto_fk3 FOREIGN KEY (chave_publica) REFERENCES chaves_publicas (chave_publica_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS msg_usuario;

CREATE TABLE msg_usuario (
  msg_usuario_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  de_id INTEGER(100) UNSIGNED DEFAULT NULL,
  para_id INTEGER(100) UNSIGNED DEFAULT NULL,
  msg_id INTEGER(100) UNSIGNED DEFAULT NULL,
  pasta_id INTEGER(100) UNSIGNED DEFAULT NULL,
  anotacao_id INTEGER(100) UNSIGNED DEFAULT NULL,
  msg_cripto_id INTEGER(100) UNSIGNED DEFAULT NULL,
  despacho_pasta_envio INTEGER(100) UNSIGNED DEFAULT NULL,
  despacho_pasta_receb INTEGER(100) UNSIGNED DEFAULT NULL,
  status INTEGER(2) DEFAULT 0,
  tipo INTEGER(2) DEFAULT 0,
  datahora DATETIME DEFAULT NULL,
  datahora_leitura DATETIME DEFAULT NULL,
  cm INTEGER(100) UNSIGNED DEFAULT NULL,
  meio VARCHAR(100) DEFAULT NULL,
  aviso_leitura TINYINT(1) DEFAULT 0,
  copia_oculta TINYINT(1) DEFAULT 0,
  nome_de VARCHAR(50) DEFAULT NULL,
  funcao_de VARCHAR(50) DEFAULT NULL,
  nome_para VARCHAR(50) DEFAULT NULL,
  funcao_para VARCHAR(50) DEFAULT NULL,
  cor VARCHAR(6) DEFAULT NULL,
  nota TEXT,
  resposta_despacho TEXT,
  data_retorno DATETIME DEFAULT NULL,
  data_limite DATETIME DEFAULT NULL,
  tarefa TINYINT(1) DEFAULT NULL,
	tarefa_progresso INTEGER(2) DEFAULT 0,
	tarefa_data DATE DEFAULT NULL,
	ignorar_de TINYINT(1) DEFAULT NULL,
	ignorar_para TINYINT(1) DEFAULT NULL,
  PRIMARY KEY (msg_usuario_id),
  KEY de_id (de_id),
  KEY para_id (para_id),
  KEY msg_id (msg_id),
  KEY pasta_id (pasta_id),
  KEY anotacao_id (anotacao_id),
  KEY msg_usuario_fk5 (msg_cripto_id),
  KEY despacho_pasta_envio (despacho_pasta_envio),
  KEY despacho_pasta_receb (despacho_pasta_receb),
  CONSTRAINT msg_usuario_fk FOREIGN KEY (de_id) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT msg_usuario_fk1 FOREIGN KEY (para_id) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT msg_usuario_fk2 FOREIGN KEY (msg_id) REFERENCES msg (msg_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT msg_usuario_fk3 FOREIGN KEY (pasta_id) REFERENCES pasta (pasta_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT msg_usuario_fk4 FOREIGN KEY (anotacao_id) REFERENCES anotacao (anotacao_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT msg_usuario_fk5 FOREIGN KEY (msg_cripto_id) REFERENCES msg_cripto (msg_cripto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT msg_usuario_fk6 FOREIGN KEY (despacho_pasta_envio) REFERENCES pasta (pasta_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT msg_usuario_fk7 FOREIGN KEY (despacho_pasta_receb) REFERENCES pasta (pasta_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS msg_usuario_ext;

CREATE TABLE msg_usuario_ext (
  msg_usuario_ext_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  de_id INTEGER(100) UNSIGNED DEFAULT NULL,
  msg_id INTEGER(100) UNSIGNED DEFAULT NULL,
  para VARCHAR(100) DEFAULT NULL,
  tipo INTEGER(2) DEFAULT 0,
  datahora DATETIME DEFAULT NULL,
  cm INTEGER(100) UNSIGNED DEFAULT NULL,
  meio VARCHAR(100) DEFAULT NULL,
  PRIMARY KEY (msg_usuario_ext_id),
  KEY de_id (de_id),
  KEY msg_id (msg_id),
  CONSTRAINT msg_usuario_ext_fk FOREIGN KEY (de_id) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT msg_usuario_ext_fk1 FOREIGN KEY (msg_id) REFERENCES msg (msg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS municipios;

CREATE TABLE municipios (
  municipio_id INTEGER(20) UNSIGNED NOT NULL,
  municipio_nome VARCHAR(50) DEFAULT NULL,
  estado_sigla VARCHAR(2) DEFAULT NULL,
  estado_cod INTEGER(2) DEFAULT NULL,
  mesorregiao_cod VARCHAR(2) DEFAULT NULL,
  mesorregiao VARCHAR(50) DEFAULT NULL,
  microrregiao_cod VARCHAR(2) DEFAULT NULL,
  microrregiao VARCHAR(50) DEFAULT NULL,
  PRIMARY KEY (municipio_id),
  KEY estado_sigla (estado_sigla)
) ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;




DROP TABLE IF EXISTS municipio_lista;

CREATE TABLE municipio_lista (
	municipio_lista_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	municipio_lista_municipio INTEGER(100) UNSIGNED DEFAULT NULL,
	municipio_lista_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	municipio_lista_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	municipio_lista_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	municipio_lista_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	municipio_lista_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	municipio_lista_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
	municipio_lista_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	municipio_lista_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	municipio_lista_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	municipio_lista_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	municipio_lista_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	municipio_lista_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	municipio_lista_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (municipio_lista_id),
	KEY municipio_lista_projeto (municipio_lista_projeto),
	KEY municipio_lista_tarefa (municipio_lista_tarefa),
	KEY municipio_lista_pratica (municipio_lista_pratica),
	KEY municipio_lista_indicador (municipio_lista_indicador),
	KEY municipio_lista_acao (municipio_lista_acao),
	KEY municipio_lista_tema (municipio_lista_tema),
	KEY municipio_lista_objetivo (municipio_lista_objetivo),
	KEY municipio_lista_fator (municipio_lista_fator),
	KEY municipio_lista_estrategia (municipio_lista_estrategia),
	KEY municipio_lista_meta (municipio_lista_meta),
	KEY municipio_lista_demanda (municipio_lista_demanda),
	KEY municipio_lista_calendario (municipio_lista_calendario),
	CONSTRAINT municipio_lista_fk1 FOREIGN KEY (municipio_lista_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT municipio_lista_fk2 FOREIGN KEY (municipio_lista_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT municipio_lista_fk3 FOREIGN KEY (municipio_lista_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT municipio_lista_fk4 FOREIGN KEY (municipio_lista_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT municipio_lista_fk5 FOREIGN KEY (municipio_lista_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT municipio_lista_fk6 FOREIGN KEY (municipio_lista_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT municipio_lista_fk7 FOREIGN KEY (municipio_lista_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT municipio_lista_fk8 FOREIGN KEY (municipio_lista_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT municipio_lista_fk9 FOREIGN KEY (municipio_lista_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT municipio_lista_fk10 FOREIGN KEY (municipio_lista_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT municipio_lista_fk11 FOREIGN KEY (municipio_lista_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT municipio_lista_fk12 FOREIGN KEY (municipio_lista_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS municipios_coordenadas;

CREATE TABLE municipios_coordenadas (
	municipio_coordenada_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  municipio_id INTEGER(20) UNSIGNED NOT NULL,
  coordenadas TEXT,
  PRIMARY KEY (municipio_coordenada_id),
  KEY municipio_id (municipio_id),
  CONSTRAINT municipio_coordenada_municipio FOREIGN KEY (municipio_id) REFERENCES municipios (municipio_id) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS objetivo_dept;

CREATE TABLE objetivo_dept (
  objetivo_dept_objetivo INTEGER(100) UNSIGNED NOT NULL,
  objetivo_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (objetivo_dept_objetivo, objetivo_dept_dept),
  KEY objetivo_dept_objetivo (objetivo_dept_objetivo),
  KEY objetivo_dept_dept (objetivo_dept_dept),
  CONSTRAINT objetivo_dept_dept FOREIGN KEY (objetivo_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT objetivo_dept_objetivo FOREIGN KEY (objetivo_dept_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS objetivo_usuario;

CREATE TABLE objetivo_usuario (
  objetivo_usuario_objetivo INTEGER(100) UNSIGNED NOT NULL,
  objetivo_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (objetivo_usuario_objetivo, objetivo_usuario_usuario),
  KEY objetivo_usuario_objetivo (objetivo_usuario_objetivo),
  KEY objetivo_usuario_usuario (objetivo_usuario_usuario),
  CONSTRAINT objetivo_usuario_usuario FOREIGN KEY (objetivo_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT objetivo_usuario_objetivo FOREIGN KEY (objetivo_usuario_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS parafazer_listas;

CREATE TABLE parafazer_listas (
  id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  usuario_id INTEGER(100) UNSIGNED DEFAULT NULL,
  nome VARCHAR(50) DEFAULT NULL,
  PRIMARY KEY (id),
  KEY usuario_id (usuario_id),
  CONSTRAINT parafazer_listas_fk FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS parafazer_chave;

CREATE TABLE parafazer_chave (
  id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  nome VARCHAR(50) DEFAULT NULL,
  cont_palavra_chave INTEGER(100) UNSIGNED DEFAULT NULL,
  lista_id INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (id),
  UNIQUE KEY listid_nmae (lista_id, nome),
  KEY lista_id (lista_id),
  CONSTRAINT parafazer_chave_fk FOREIGN KEY (lista_id) REFERENCES parafazer_listas (id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS parafazer_tarefa;

CREATE TABLE parafazer_tarefa (
  id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  lista_id INTEGER(100) UNSIGNED DEFAULT NULL,
  ow INTEGER(100) UNSIGNED DEFAULT NULL,
  d DATETIME,
  compl TINYINT(3) UNSIGNED DEFAULT 0,
  titulo VARCHAR(250) DEFAULT NULL,
  nota TEXT,
  prio TINYINT(4) DEFAULT 0,
  parafazer_chave VARCHAR(250) DEFAULT NULL,
  datafinal DATE DEFAULT NULL,
  PRIMARY KEY (id),
  KEY lista_id (lista_id),
  CONSTRAINT parafazer_tarefa_fk FOREIGN KEY (lista_id) REFERENCES parafazer_listas (id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS parafazer_chave_tarefa;

CREATE TABLE parafazer_chave_tarefa (
  palavra_chave_id INTEGER(100) UNSIGNED,
  tarefa_id INTEGER(100) UNSIGNED,
  KEY palavra_chave_id (palavra_chave_id),
  KEY tarefa_id (tarefa_id),
  CONSTRAINT parafazer_chave_tarefa_fk FOREIGN KEY (tarefa_id) REFERENCES parafazer_tarefa (id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS parafazer_usuarios;

CREATE TABLE parafazer_usuarios (
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  id INTEGER(100) UNSIGNED NOT NULL,
  aceito TINYINT(3) DEFAULT 0,
  data DATETIME DEFAULT NULL,
  PRIMARY KEY (usuario_id, id),
  KEY uek2 (id, usuario_id),
  KEY usuario_id (usuario_id),
  KEY id (id),
  CONSTRAINT parafazer_usuarios_fk1 FOREIGN KEY (id) REFERENCES parafazer_tarefa (id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT parafazer_usuarios_fk FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS perspectivas_depts;

CREATE TABLE perspectivas_depts (
  pg_perspectiva_id INTEGER(100) UNSIGNED NOT NULL,
  dept_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (pg_perspectiva_id, dept_id),
  KEY pg_perspectiva_id (pg_perspectiva_id),
  KEY dept_id (dept_id),
  CONSTRAINT perspectivas_depts_fk1 FOREIGN KEY (dept_id) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT perspectivas_depts_fk FOREIGN KEY (pg_perspectiva_id) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS perspectivas_usuarios;

CREATE TABLE perspectivas_usuarios (
  pg_perspectiva_id INTEGER(100) UNSIGNED NOT NULL,
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (pg_perspectiva_id, usuario_id),
  KEY pg_perspectiva_id (pg_perspectiva_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT perspectivas_usuarios_fk1 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT perspectivas_usuarios_fk FOREIGN KEY (pg_perspectiva_id) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS plano_acao_dept;
CREATE TABLE plano_acao_dept (
  plano_acao_dept_acao int(100) unsigned NOT NULL,
  plano_acao_dept_dept int(100) unsigned NOT NULL,
  PRIMARY KEY (plano_acao_dept_acao,plano_acao_dept_dept),
  KEY plano_acao_dept_acao (plano_acao_dept_acao),
  KEY plano_acao_dept_dept (plano_acao_dept_dept),
  CONSTRAINT plano_acao_dept_acao FOREIGN KEY (plano_acao_dept_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_acao_dept_dept FOREIGN KEY (plano_acao_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS plano_acao_item;

CREATE TABLE plano_acao_item (
  plano_acao_item_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  plano_acao_item_acao INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_item_uuid VARCHAR(36) DEFAULT NULL,
  plano_acao_item_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_item_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_item_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_item_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_item_nome VARCHAR(255) DEFAULT NULL,
  plano_acao_item_quando MEDIUMTEXT,
  plano_acao_item_oque MEDIUMTEXT,
  plano_acao_item_como MEDIUMTEXT,
  plano_acao_item_onde MEDIUMTEXT,
  plano_acao_item_quanto MEDIUMTEXT,
  plano_acao_item_porque MEDIUMTEXT,
  plano_acao_item_quem MEDIUMTEXT,
  plano_acao_item_inicio DATETIME DEFAULT NULL,
  plano_acao_item_fim DATETIME DEFAULT NULL,
  plano_acao_item_duracao DECIMAL(20,5) UNSIGNED DEFAULT NULL,
  plano_acao_item_status INTEGER(10) DEFAULT 0,
  plano_acao_item_observacao MEDIUMTEXT,
  plano_acao_item_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  plano_acao_item_principal_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_item_percentagem DECIMAL(20,5) UNSIGNED DEFAULT 0,
	plano_acao_item_peso DECIMAL(20,5) UNSIGNED DEFAULT 1,
	plano_acao_item_moeda INTEGER(100) UNSIGNED DEFAULT 1,
	plano_acao_item_cor VARCHAR(6) DEFAULT 'FFFFFF',
	plano_acao_item_aprovado TINYINT(1) DEFAULT 0,
	plano_acao_item_ativo TINYINT(1) DEFAULT 1,
	plano_acao_item_responsavel_exibe tinyint(1) DEFAULT 0,
	plano_acao_item_usuarios_exibe tinyint(1) DEFAULT 0,
  PRIMARY KEY (plano_acao_item_id),
  KEY plano_acao_item_acao (plano_acao_item_acao),
  KEY plano_acao_item_responsavel (plano_acao_item_responsavel),
  KEY plano_acao_item_cia (plano_acao_item_cia),
  KEY plano_acao_item_dept (plano_acao_item_dept),
	KEY plano_acao_item_principal_indicador (plano_acao_item_principal_indicador),
	KEY plano_acao_item_moeda (plano_acao_item_moeda),
  CONSTRAINT plano_acao_item_fk FOREIGN KEY (plano_acao_item_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_acao_item_fk1 FOREIGN KEY (plano_acao_item_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT plano_acao_item_fk2 FOREIGN KEY (plano_acao_item_principal_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT plano_acao_item_fk3 FOREIGN KEY (plano_acao_item_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_acao_item_dept FOREIGN KEY (plano_acao_item_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT plano_acao_item_moeda FOREIGN KEY (plano_acao_item_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS plano_acao_item_dept;

CREATE TABLE plano_acao_item_dept (
  plano_acao_item_dept_plano_acao_item INTEGER(100) UNSIGNED NOT NULL,
  plano_acao_item_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (plano_acao_item_dept_plano_acao_item, plano_acao_item_dept_dept),
  KEY plano_acao_item_dept_plano_acao_item USING BTREE (plano_acao_item_dept_plano_acao_item),
  KEY plano_acao_item_dept_dept USING BTREE (plano_acao_item_dept_dept),
  CONSTRAINT plano_acao_item_dept_dept FOREIGN KEY (plano_acao_item_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_acao_item_dept_plano_acao_item FOREIGN KEY (plano_acao_item_dept_plano_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS plano_acao_item_cia;

CREATE TABLE plano_acao_item_cia (
  plano_acao_item_cia_plano_acao_item INTEGER(100) UNSIGNED NOT NULL,
  plano_acao_item_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (plano_acao_item_cia_plano_acao_item, plano_acao_item_cia_cia),
  KEY plano_acao_item_cia_plano_acao_item (plano_acao_item_cia_plano_acao_item),
  KEY plano_acao_item_cia_cia (plano_acao_item_cia_cia),
  CONSTRAINT plano_acao_item_cia_cia FOREIGN KEY (plano_acao_item_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_acao_item_cia_plano_acao_item FOREIGN KEY (plano_acao_item_cia_plano_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS plano_acao_item_custos;

CREATE TABLE plano_acao_item_custos (
  plano_acao_item_custos_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  plano_acao_item_custos_plano_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_item_custos_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_item_custos_tr INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_item_custos_tipo INTEGER(100) UNSIGNED DEFAULT 1,
  plano_acao_item_custos_nome VARCHAR(255) DEFAULT NULL,
  plano_acao_item_custos_codigo VARCHAR(255) DEFAULT NULL,
  plano_acao_item_custos_fonte VARCHAR(255) DEFAULT NULL,
  plano_acao_item_custos_regiao VARCHAR(255) DEFAULT NULL,
  plano_acao_item_custos_data DATETIME DEFAULT NULL,
  plano_acao_item_custos_quantidade DECIMAL(20,5) UNSIGNED DEFAULT 0,
  plano_acao_item_custos_custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
  plano_acao_item_custos_percentagem TINYINT(4) DEFAULT 0,
  plano_acao_item_custos_descricao TEXT,
  plano_acao_item_custos_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_item_custos_nd VARCHAR(11) DEFAULT NULL,
  plano_acao_item_custos_categoria_economica VARCHAR(1) DEFAULT NULL,
  plano_acao_item_custos_grupo_despesa VARCHAR(1) DEFAULT NULL,
  plano_acao_item_custos_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  plano_acao_item_custos_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_custos_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
  plano_acao_item_custos_data_limite DATE DEFAULT NULL,
  plano_acao_item_custos_bdi  DECIMAL(20,5) UNSIGNED DEFAULT 0,
  plano_acao_item_custos_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
	plano_acao_item_custos_cotacao DECIMAL(6,5) UNSIGNED DEFAULT 1,
	plano_acao_item_custos_data_moeda DATE DEFAULT NULL,
  plano_acao_item_custos_uuid VARCHAR(36) DEFAULT NULL,
	plano_acao_item_custos_aprovou INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_custos_aprovado TINYINT(1) DEFAULT NULL,
	plano_acao_item_custos_data_aprovado DATETIME DEFAULT NULL,
  PRIMARY KEY (plano_acao_item_custos_id),
  KEY idxplano_acao_item_custos_plano_acao_item (plano_acao_item_custos_plano_acao_item),
  KEY idxplano_acao_item_custos_usuario_inicio (plano_acao_item_custos_usuario),
  KEY plano_acao_item_custos_tr (plano_acao_item_custos_tr),
  KEY idxplano_acao_item_custos_ordem (plano_acao_item_custos_ordem),
  KEY idxplano_acao_item_custos_data_inicio (plano_acao_item_custos_data),
  KEY idxplano_acao_item_custos_nome (plano_acao_item_custos_nome),
  KEY plano_acao_item_custos_aprovou (plano_acao_item_custos_aprovou),
  KEY plano_acao_item_custos_moeda (plano_acao_item_custos_moeda),
  CONSTRAINT plano_acao_item_custos_fk FOREIGN KEY (plano_acao_item_custos_plano_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_acao_item_custos_fk1 FOREIGN KEY (plano_acao_item_custos_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT plano_acao_item_custos_aprovou FOREIGN KEY (plano_acao_item_custos_aprovou) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT plano_acao_item_custos_tr FOREIGN KEY (plano_acao_item_custos_tr) REFERENCES tr (tr_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT plano_acao_item_custos_moeda FOREIGN KEY (plano_acao_item_custos_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS plano_acao_item_usuario;

CREATE TABLE plano_acao_item_usuario (
  plano_acao_item_usuario_item int(100) unsigned NOT NULL,
  plano_acao_item_usuario_usuario int(100) unsigned NOT NULL,
  KEY plano_acao_item_usuario_item (plano_acao_item_usuario_item),
  KEY plano_acao_item_usuario_usuario (plano_acao_item_usuario_usuario),
  CONSTRAINT plano_acao_item_usuario_item FOREIGN KEY (plano_acao_item_usuario_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_acao_item_usuario_usuario FOREIGN KEY (plano_acao_item_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS plano_acao_item_gastos;

CREATE TABLE plano_acao_item_gastos (
  plano_acao_item_gastos_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  plano_acao_item_gastos_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_item_gastos_plano_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_item_gastos_tipo INTEGER(100) UNSIGNED DEFAULT 1,
  plano_acao_item_gastos_nome VARCHAR(255) DEFAULT NULL,
  plano_acao_item_gastos_codigo VARCHAR(255) DEFAULT NULL,
  plano_acao_item_gastos_fonte VARCHAR(255) DEFAULT NULL,
  plano_acao_item_gastos_regiao VARCHAR(255) DEFAULT NULL,
  plano_acao_item_gastos_data DATETIME DEFAULT NULL,
  plano_acao_item_gastos_data_recebido DATETIME DEFAULT NULL,
  plano_acao_item_gastos_quantidade DECIMAL(20,5) UNSIGNED DEFAULT 0,
  plano_acao_item_gastos_custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
  plano_acao_item_gastos_percentagem TINYINT(4) DEFAULT 0,
  plano_acao_item_gastos_descricao TEXT,
  plano_acao_item_gastos_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_item_gastos_nd VARCHAR(11) DEFAULT NULL,
  plano_acao_item_gastos_categoria_economica VARCHAR(1) DEFAULT NULL,
  plano_acao_item_gastos_grupo_despesa VARCHAR(1) DEFAULT NULL,
  plano_acao_item_gastos_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  plano_acao_item_gastos_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gastos_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
  plano_acao_item_custos_data_recebido DATE DEFAULT NULL,
  plano_acao_item_gastos_empenhado DECIMAL(20,5) UNSIGNED DEFAULT 0,
	plano_acao_item_gastos_entregue DECIMAL(20,5) UNSIGNED DEFAULT 0,
	plano_acao_item_gastos_liquidado DECIMAL(20,5) UNSIGNED DEFAULT 0,
	plano_acao_item_gastos_pago DECIMAL(20,5) UNSIGNED DEFAULT 0,
  plano_acao_item_gastos_bdi  DECIMAL(20,5) UNSIGNED DEFAULT 0,
	plano_acao_item_gastos_moeda INTEGER(100) UNSIGNED DEFAULT 1,  
	plano_acao_item_gastos_cotacao DECIMAL(6,5) UNSIGNED DEFAULT 1, 
	plano_acao_item_gastos_data_moeda DATE DEFAULT NULL,  
  plano_acao_item_gastos_uuid VARCHAR(36) DEFAULT NULL,
	plano_acao_item_gastos_aprovou INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_acao_item_gastos_aprovado TINYINT(1) DEFAULT NULL,
	plano_acao_item_gastos_data_aprovado DATETIME DEFAULT NULL,
  PRIMARY KEY (plano_acao_item_gastos_id),
  KEY idxplano_acao_item_gastos_plano_acao_item (plano_acao_item_gastos_plano_acao_item),
  KEY idxplano_acao_item_gastos_usuario_inicio (plano_acao_item_gastos_usuario),
  KEY idxplano_acao_item_gastos_ordem (plano_acao_item_gastos_ordem),
  KEY idxplano_acao_item_gastos_data_inicio (plano_acao_item_gastos_data),
  KEY idxplano_acao_item_gastos_nome (plano_acao_item_gastos_nome),
  KEY plano_acao_item_gastos_aprovou (plano_acao_item_gastos_aprovou),
  KEY plano_acao_item_gastos_moeda (plano_acao_item_gastos_moeda),
  CONSTRAINT plano_acao_item_gastos_fk FOREIGN KEY (plano_acao_item_gastos_plano_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_acao_item_gastos_fk1 FOREIGN KEY (plano_acao_item_gastos_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT plano_acao_item_gastos_aprovou FOREIGN KEY (plano_acao_item_gastos_aprovou) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT plano_acao_item_gastos_moeda FOREIGN KEY (plano_acao_item_gastos_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS plano_acao_item_h_custos;

CREATE TABLE plano_acao_item_h_custos (
  h_custos_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  h_custos_plano_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
  h_custos_plano_acao_item_custos_id INTEGER(100) UNSIGNED DEFAULT NULL,
  h_custos_nome1 VARCHAR(255) DEFAULT NULL,
  h_custos_nome2 VARCHAR(255) DEFAULT NULL,
  h_custos_tipo1 INTEGER(100) UNSIGNED DEFAULT 1,
  h_custos_tipo2 INTEGER(100) UNSIGNED DEFAULT 1,
  h_custos_usuario1 INTEGER(100) UNSIGNED DEFAULT NULL,
  h_custos_usuario2 INTEGER(100) UNSIGNED DEFAULT NULL,
  h_custos_data1 DATETIME DEFAULT NULL,
  h_custos_data2 DATETIME DEFAULT NULL,
  h_custos_quantidade1 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_custos_quantidade2 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_custos_custo1 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_custos_custo2 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_custos_percentagem1 TINYINT(4) DEFAULT 0,
  h_custos_percentagem2 TINYINT(4) DEFAULT 0,
  h_custos_descricao1 TEXT,
  h_custos_descricao2 TEXT,
  h_custos_nd1 VARCHAR(20) DEFAULT NULL,
  h_custos_nd2 VARCHAR(20) DEFAULT NULL,
  h_custos_categoria_economica1 VARCHAR(1) DEFAULT NULL,
  h_custos_grupo_despesa1 VARCHAR(1) DEFAULT NULL,
  h_custos_modalidade_aplicacao1 VARCHAR(2) DEFAULT NULL,
  h_custos_categoria_economica2 VARCHAR(1) DEFAULT NULL,
  h_custos_grupo_despesa2 VARCHAR(1) DEFAULT NULL,
  h_custos_modalidade_aplicacao2 VARCHAR(2) DEFAULT NULL,
  h_custos_metodo1 INTEGER(100) UNSIGNED DEFAULT NULL,
	h_custos_metodo2 INTEGER(100) UNSIGNED DEFAULT NULL,
	h_custos_exercicio1 INTEGER(4) UNSIGNED DEFAULT NULL,
	h_custos_exercicio2 INTEGER(4) UNSIGNED DEFAULT NULL,
  h_custos_excluido TINYINT(1) DEFAULT 0,
  uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (h_custos_id),
  KEY h_custos_plano_acao_item_custos_id (h_custos_plano_acao_item_custos_id),
  CONSTRAINT plano_acao_item_h_custos_fk FOREIGN KEY (h_custos_plano_acao_item_custos_id) REFERENCES plano_acao_item_custos (plano_acao_item_custos_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS plano_acao_item_h_gastos;

CREATE TABLE plano_acao_item_h_gastos (
  h_gastos_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  h_gastos_plano_acao_item_gastos_id INTEGER(100) UNSIGNED DEFAULT NULL,
  h_gastos_plano_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
  h_gastos_nome1 VARCHAR(255) DEFAULT NULL,
  h_gastos_nome2 VARCHAR(255) DEFAULT NULL,
  h_gastos_tipo1 INTEGER(100) UNSIGNED DEFAULT 1,
  h_gastos_tipo2 INTEGER(100) UNSIGNED DEFAULT 1,
  h_gastos_usuario1 INTEGER(100) UNSIGNED DEFAULT NULL,
  h_gastos_usuario2 INTEGER(100) UNSIGNED DEFAULT NULL,
  h_gastos_data1 DATETIME DEFAULT NULL,
  h_gastos_data2 DATETIME DEFAULT NULL,
  h_gastos_quantidade1 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_gastos_quantidade2 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_gastos_custo1 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_gastos_custo2 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_gastos_percentagem1 TINYINT(4) DEFAULT 0,
  h_gastos_percentagem2 TINYINT(4) DEFAULT 0,
  h_gastos_descricao1 TEXT,
  h_gastos_descricao2 TEXT,
  h_gastos_nd1 VARCHAR(20) DEFAULT NULL,
  h_gastos_nd2 VARCHAR(20) DEFAULT NULL,
  h_gastos_categoria_economica1 VARCHAR(1) DEFAULT NULL,
  h_gastos_grupo_despesa1 VARCHAR(1) DEFAULT NULL,
  h_gastos_modalidade_aplicacao1 VARCHAR(2) DEFAULT NULL,
  h_gastos_categoria_economica2 VARCHAR(1) DEFAULT NULL,
  h_gastos_grupo_despesa2 VARCHAR(1) DEFAULT NULL,
  h_gastos_modalidade_aplicacao2 VARCHAR(2) DEFAULT NULL,
  h_gastos_metodo1 INTEGER(100) UNSIGNED DEFAULT NULL,
	h_gastos_metodo2 INTEGER(100) UNSIGNED DEFAULT NULL,
	h_gastos_exercicio1 INTEGER(4) UNSIGNED DEFAULT NULL,
	h_gastos_exercicio2 INTEGER(4) UNSIGNED DEFAULT NULL,
  h_gastos_excluido TINYINT(1) DEFAULT 0,
  uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (h_gastos_id),
  KEY h_gastos_plano_acao_item_gastos_id (h_gastos_plano_acao_item_gastos_id),
  CONSTRAINT plano_acao_item_h_gastos_fk FOREIGN KEY (h_gastos_plano_acao_item_gastos_id) REFERENCES plano_acao_item_gastos (plano_acao_item_gastos_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS plano_acao_usuario;

CREATE TABLE plano_acao_usuario (
  plano_acao_usuario_acao int(100) unsigned NOT NULL,
  plano_acao_usuario_usuario int(100) unsigned NOT NULL,
  PRIMARY KEY (plano_acao_usuario_acao,plano_acao_usuario_usuario),
  KEY plano_acao_usuario_acao (plano_acao_usuario_acao),
  KEY plano_acao_usuario_usuario (plano_acao_usuario_usuario),
  CONSTRAINT plano_acao_usuario_acao FOREIGN KEY (plano_acao_usuario_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_acao_usuario_usuario FOREIGN KEY (plano_acao_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS plano_gestao;

CREATE TABLE plano_gestao (
  pg_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pg_nome VARCHAR(250) DEFAULT NULL,
	pg_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_usuario_ultima_alteracao INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_descricao MEDIUMTEXT,
  pg_ano INTEGER(4) DEFAULT NULL,
  pg_inicio DATE DEFAULT NULL,
  pg_fim DATE DEFAULT NULL,
  pg_modelo INTEGER(11) DEFAULT NULL,
  pg_estrut_org TEXT,
  pg_fornecedores TEXT,
  pg_ultima_alteracao DATETIME DEFAULT NULL,
  pg_processos_apoio TEXT,
  pg_processos_finalistico TEXT,
  pg_produtos_servicos TEXT,
  pg_clientes TEXT,
  pg_posgraduados INTEGER(11) DEFAULT 0,
  pg_graduados INTEGER(11) DEFAULT 0,
  pg_nivelmedio INTEGER(11) DEFAULT 0,
  pg_nivelfundamental INTEGER(11) DEFAULT 0,
  pg_semescolaridade INTEGER(11) DEFAULT 0,
  pg_pessoalinterno TEXT,
  pg_programas_acoes TEXT,
  pg_premiacoes TEXT,
	pg_acesso INTEGER(100) UNSIGNED DEFAULT 0,
	pg_cor VARCHAR(6) DEFAULT 'FFFFFF',
	pg_ativo TINYINT(1) DEFAULT 1,
	pg_aprovado TINYINT(1) DEFAULT 0,
	pg_moeda INTEGER(100) UNSIGNED DEFAULT 1,
	pg_tipo_pontuacao VARCHAR(40) DEFAULT NULL,
	pg_percentagem DECIMAL(20,5) UNSIGNED DEFAULT 0,
	pg_ponto_alvo DECIMAL(20,5) UNSIGNED DEFAULT 0,	
  PRIMARY KEY (pg_id),
  KEY pg_cia (pg_cia),
  KEY pg_dept (pg_dept),
  KEY pg_usuario_ultima_alteracao (pg_usuario_ultima_alteracao),
  KEY pg_moeda (pg_moeda),
  CONSTRAINT plano_gestao_fk FOREIGN KEY (pg_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_gestao_fk1 FOREIGN KEY (pg_usuario_ultima_alteracao) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT plano_gestao_fk2 FOREIGN KEY (pg_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT pg_moeda FOREIGN KEY (pg_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS plano_gestao2;

CREATE TABLE plano_gestao2 (
  pg_id INTEGER(100) UNSIGNED NOT NULL,
  pg_missao TEXT,
  pg_missao_cor VARCHAR(6) DEFAULT 'c9deae',
  pg_missao_esc_superior TEXT,
  pg_visao_futuro TEXT,
  pg_visao_futuro_cor VARCHAR(6) DEFAULT 'c9deae',
  pg_visao_futuro_detalhada TEXT,
  pg_ponto_forte TEXT,
  pg_oportunidade_melhoria TEXT,
  pg_oportunidade TEXT,
  pg_ameaca TEXT,
  pg_principio TEXT,
  pg_diretriz_superior TEXT,
  pg_diretriz TEXT,
  pg_objetivo_estrategico TEXT,
  pg_fator_critico TEXT,
  pg_estrategia TEXT,
  pg_meta TEXT,
  PRIMARY KEY (pg_id),
  CONSTRAINT plano_gestao2_fk FOREIGN KEY (pg_id) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS plano_gestao_dept;

CREATE TABLE plano_gestao_dept (
  plano_gestao_dept_plano INTEGER(100) UNSIGNED NOT NULL,
  plano_gestao_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (plano_gestao_dept_plano, plano_gestao_dept_dept),
  KEY plano_gestao_dept_plano (plano_gestao_dept_plano),
  KEY plano_gestao_dept_dept (plano_gestao_dept_dept),
  CONSTRAINT plano_gestao_dept_dept FOREIGN KEY (plano_gestao_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_gestao_dept_plano FOREIGN KEY (plano_gestao_dept_plano) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS plano_gestao_cia;

CREATE TABLE plano_gestao_cia (
  plano_gestao_cia_plano INTEGER(100) UNSIGNED NOT NULL,
  plano_gestao_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (plano_gestao_cia_plano, plano_gestao_cia_cia),
  KEY plano_gestao_cia_plano (plano_gestao_cia_plano),
  KEY plano_gestao_cia_cia (plano_gestao_cia_cia),
  CONSTRAINT plano_gestao_cia_cia FOREIGN KEY (plano_gestao_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_gestao_cia_plano FOREIGN KEY (plano_gestao_cia_plano) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS plano_gestao_usuario;

CREATE TABLE plano_gestao_usuario (
  plano_gestao_usuario_plano INTEGER(100) UNSIGNED NOT NULL,
  plano_gestao_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (plano_gestao_usuario_plano, plano_gestao_usuario_usuario),
  KEY plano_gestao_usuario_plano (plano_gestao_usuario_plano),
  KEY plano_gestao_usuario_usuario (plano_gestao_usuario_usuario),
  CONSTRAINT plano_gestao_usuario_usuario FOREIGN KEY (plano_gestao_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_gestao_usuario_plano FOREIGN KEY (plano_gestao_usuario_plano) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS plano_gestao_ameacas;

CREATE TABLE plano_gestao_ameacas (
  pg_ameaca_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pg_ameaca_pg_id INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_ameaca_swot INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_ameaca_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_ameaca_nome TEXT,
  pg_ameaca_data DATETIME DEFAULT NULL,
  pg_ameaca_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (pg_ameaca_id),
  KEY pg_ameaca_pg_id (pg_ameaca_pg_id),
  KEY pg_ameaca_swot (pg_ameaca_swot),
  KEY pg_ameaca_usuario (pg_ameaca_usuario),
  CONSTRAINT plano_gestao_ameacas_fk FOREIGN KEY (pg_ameaca_pg_id) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_gestao_ameacas_fk1 FOREIGN KEY (pg_ameaca_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT pg_ameaca_swot FOREIGN KEY (pg_ameaca_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS plano_gestao_arquivo;

CREATE TABLE plano_gestao_arquivo (
  plano_gestao_arquivo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  plano_gestao_arquivo_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_gestao_arquivo_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_gestao_arquivo_campo VARCHAR(50) DEFAULT NULL,
  plano_gestao_arquivo_ordem INTEGER(11) DEFAULT 0,
  plano_gestao_arquivo_endereco VARCHAR(150) DEFAULT NULL,
  plano_gestao_arquivo_data DATETIME DEFAULT NULL,
  plano_gestao_arquivo_nome VARCHAR(150) DEFAULT NULL,
  plano_gestao_arquivo_nome_real VARCHAR(255) DEFAULT NULL,
  plano_gestao_arquivo_local VARCHAR(255) DEFAULT NULL,
  plano_gestao_arquivo_tipo VARCHAR(50) DEFAULT NULL,
  plano_gestao_arquivo_extensao VARCHAR(50) DEFAULT NULL,
  plano_gestao_arquivo_tamanho INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (plano_gestao_arquivo_id),
	KEY plano_gestao_arquivo_plano_gestao USING BTREE (plano_gestao_arquivo_plano_gestao),
	KEY plano_gestao_arquivo_usuario USING BTREE (plano_gestao_arquivo_usuario),
	CONSTRAINT plano_gestao_arquivo_plano_gestao FOREIGN KEY (plano_gestao_arquivo_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_gestao_arquivo_usuario FOREIGN KEY (plano_gestao_arquivo_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS plano_gestao_diretrizes;

CREATE TABLE plano_gestao_diretrizes (
  pg_diretriz_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pg_diretriz_pg_id INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_diretriz_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_diretriz_nome TEXT,
  pg_diretriz_data DATETIME DEFAULT NULL,
  pg_diretriz_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (pg_diretriz_id),
  KEY pg_diretriz_pg_id (pg_diretriz_pg_id),
  KEY pg_diretriz_usuario (pg_diretriz_usuario),
  CONSTRAINT plano_gestao_diretrizes_fk FOREIGN KEY (pg_diretriz_pg_id) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_gestao_diretrizes_fk1 FOREIGN KEY (pg_diretriz_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS plano_gestao_diretrizes_superiores;

CREATE TABLE plano_gestao_diretrizes_superiores (
  pg_diretriz_superior_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pg_diretriz_superior_pg_id INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_diretriz_superior_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_diretriz_superior_nome TEXT,
  pg_diretriz_superior_data DATETIME DEFAULT NULL,
  pg_diretriz_superior_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (pg_diretriz_superior_id),
  KEY pg_diretriz_superior_pg_id (pg_diretriz_superior_pg_id),
  KEY pg_diretriz_superior_usuario (pg_diretriz_superior_usuario),
  CONSTRAINT plano_gestao_diretrizes_superiores_fk FOREIGN KEY (pg_diretriz_superior_pg_id) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_gestao_diretrizes_superiores_fk1 FOREIGN KEY (pg_diretriz_superior_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS plano_gestao_estrategias;

CREATE TABLE plano_gestao_estrategias (
  pg_id INTEGER(100) UNSIGNED NOT NULL,
  pg_estrategia_id INTEGER(100) UNSIGNED NOT NULL,
  pg_estrategia_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  KEY pg_id (pg_id),
  KEY pg_estrategia_id (pg_estrategia_id),
  CONSTRAINT plano_gestao_estrategias_fk1 FOREIGN KEY (pg_estrategia_id) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_gestao_estrategias_fk FOREIGN KEY (pg_id) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS plano_gestao_fator;

CREATE TABLE plano_gestao_fator (
  plano_gestao_fator_plano_gestao INTEGER(100) UNSIGNED NOT NULL,
  plano_gestao_fator_fator INTEGER(100) UNSIGNED NOT NULL,
  plano_gestao_fator_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  KEY plano_gestao_fator_fator (plano_gestao_fator_fator),
  KEY plano_gestao_fator_plano_gestao (plano_gestao_fator_plano_gestao),
  CONSTRAINT plano_gestao_fator_fator FOREIGN KEY (plano_gestao_fator_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_gestao_fator_plano_gestao FOREIGN KEY (plano_gestao_fator_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS plano_gestao_fornecedores;

CREATE TABLE plano_gestao_fornecedores (
  pg_fornecedor_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pg_fornecedor_pg_id INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_fornecedor_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_fornecedor_nome VARCHAR(512) DEFAULT NULL,
  pg_fornecedor_insumo VARCHAR(200) DEFAULT NULL,
  pg_fornecedor_data DATETIME DEFAULT NULL,
  pg_fornecedor_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (pg_fornecedor_id),
  KEY pg_fornecedor_pg_id (pg_fornecedor_pg_id),
  KEY pg_fornecedor_usuario (pg_fornecedor_usuario),
  CONSTRAINT plano_gestao_fornecedores_fk FOREIGN KEY (pg_fornecedor_pg_id) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_gestao_fornecedores_fk1 FOREIGN KEY (pg_fornecedor_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS plano_gestao_metas;

CREATE TABLE plano_gestao_metas (
  pg_id INTEGER(100) UNSIGNED NOT NULL,
  pg_meta_id INTEGER(100) UNSIGNED NOT NULL,
  pg_meta_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  KEY pg_id (pg_id),
  KEY pg_meta_id (pg_meta_id),
  CONSTRAINT plano_gestao_metas_fk1 FOREIGN KEY (pg_meta_id) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_gestao_metas_fk FOREIGN KEY (pg_id) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS plano_gestao_objetivo;

CREATE TABLE plano_gestao_objetivo (
  plano_gestao_objetivo_plano_gestao INTEGER(100) UNSIGNED NOT NULL,
  plano_gestao_objetivo_objetivo INTEGER(100) UNSIGNED NOT NULL,
  plano_gestao_objetivo_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  KEY plano_gestao_objetivo_plano_gestao (plano_gestao_objetivo_plano_gestao),
  KEY plano_gestao_objetivo_objetivo (plano_gestao_objetivo_objetivo),
  CONSTRAINT plano_gestao_objetivo_objetivo FOREIGN KEY (plano_gestao_objetivo_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_gestao_objetivo_plano_gestao FOREIGN KEY (plano_gestao_objetivo_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS plano_gestao_oportunidade;

CREATE TABLE plano_gestao_oportunidade (
  pg_oportunidade_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pg_oportunidade_pg_id INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_oportunidade_swot INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_oportunidade_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_oportunidade_nome TEXT,
  pg_oportunidade_data DATETIME DEFAULT NULL,
  pg_oportunidade_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (pg_oportunidade_id),
  KEY pg_oportunidade_pg_id (pg_oportunidade_pg_id),
  KEY pg_oportunidade_swot (pg_oportunidade_swot),
  KEY pg_oportunidade_usuario (pg_oportunidade_usuario),
  CONSTRAINT plano_gestao_oportunidade_fk FOREIGN KEY (pg_oportunidade_pg_id) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_gestao_oportunidade_fk1 FOREIGN KEY (pg_oportunidade_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT pg_oportunidade_swot FOREIGN KEY (pg_oportunidade_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS plano_gestao_oportunidade_melhorias;

CREATE TABLE plano_gestao_oportunidade_melhorias (
  pg_oportunidade_melhoria_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pg_oportunidade_melhoria_pg_id INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_oportunidade_melhoria_swot INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_oportunidade_melhoria_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_oportunidade_melhoria_nome TEXT,
  pg_oportunidade_melhoria_data DATETIME DEFAULT NULL,
  pg_oportunidade_melhoria_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (pg_oportunidade_melhoria_id),
  KEY pg_oportunidade_melhoria_pg_id (pg_oportunidade_melhoria_pg_id),
  KEY pg_oportunidade_melhoria_swot (pg_oportunidade_melhoria_swot),
  KEY pg_oportunidade_melhoria_usuario (pg_oportunidade_melhoria_usuario),
  CONSTRAINT plano_gestao_oportunidade_melhorias_fk FOREIGN KEY (pg_oportunidade_melhoria_pg_id) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_gestao_oportunidade_melhorias_fk1 FOREIGN KEY (pg_oportunidade_melhoria_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT pg_oportunidade_melhoria_swot FOREIGN KEY (pg_oportunidade_melhoria_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS plano_gestao_perspectivas;

CREATE TABLE plano_gestao_perspectivas (
  pg_id INTEGER(100) UNSIGNED NOT NULL,
  pg_perspectiva_id INTEGER(100) UNSIGNED NOT NULL,
  pg_perspectiva_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  KEY pg_id (pg_id),
  KEY pg_perspectiva_id (pg_perspectiva_id),
  CONSTRAINT plano_gestao_perspectivas_fk1 FOREIGN KEY (pg_perspectiva_id) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_gestao_perspectivas_fk FOREIGN KEY (pg_id) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS plano_gestao_pessoal;

CREATE TABLE plano_gestao_pessoal (
  pg_pessoal_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pg_pessoal_pg_id INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_pessoal_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_pessoal_posto VARCHAR(50) DEFAULT NULL,
  pg_pessoal_previsto INTEGER(100) DEFAULT 0,
  pg_pessoal_existente INTEGER(100) DEFAULT 0,
  pg_pessoal_data DATETIME DEFAULT NULL,
  pg_pessoal_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (pg_pessoal_id),
  KEY pg_pessoal_pg_id (pg_pessoal_pg_id),
  KEY pg_pessoal_usuario (pg_pessoal_usuario),
  CONSTRAINT plano_gestao_pessoal_fk FOREIGN KEY (pg_pessoal_pg_id) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_gestao_pessoal_fk1 FOREIGN KEY (pg_pessoal_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS plano_gestao_pontosfortes;

CREATE TABLE plano_gestao_pontosfortes (
  pg_ponto_forte_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pg_ponto_forte_pg_id INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_ponto_forte_swot INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_ponto_forte_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_ponto_forte_nome TEXT,
  pg_ponto_forte_data DATETIME DEFAULT NULL,
  pg_ponto_forte_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (pg_ponto_forte_id),
  KEY pg_ponto_forte_pg_id (pg_ponto_forte_pg_id),
  KEY pg_ponto_forte_swot (pg_ponto_forte_swot),
  KEY pg_ponto_forte_usuario (pg_ponto_forte_usuario),
  CONSTRAINT plano_gestao_pontosfortes_fk FOREIGN KEY (pg_ponto_forte_pg_id) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_gestao_pontosfortes_fk1 FOREIGN KEY (pg_ponto_forte_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT pg_ponto_forte_swot FOREIGN KEY (pg_ponto_forte_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS pg_swot;

CREATE TABLE pg_swot (
  pg_swot_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pg_swot_pg INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_swot_swot INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_swot_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_swot_nome TEXT,
  pg_swot_tipo VARCHAR(1) DEFAULT NULL,
  pg_swot_data DATETIME DEFAULT NULL,
  pg_swot_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (pg_swot_id),
  KEY pg_swot_pg (pg_swot_pg),
  KEY pg_swot_swot (pg_swot_swot),
  KEY pg_swot_usuario (pg_swot_usuario),
  CONSTRAINT pg_swot_pg FOREIGN KEY (pg_swot_pg) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT pg_swot_usuario FOREIGN KEY (pg_swot_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT pg_swot_swot FOREIGN KEY (pg_swot_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS plano_gestao_premiacoes;

CREATE TABLE plano_gestao_premiacoes (
  pg_premiacao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pg_premiacao_pg_id INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_premiacao_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_premiacao_nome VARCHAR(80) DEFAULT NULL,
  pg_premiacao_ano INTEGER(4) DEFAULT NULL,
  pg_premiacao_data DATETIME DEFAULT NULL,
  pg_premiacao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (pg_premiacao_id),
  KEY pg_premiacao_pg_id (pg_premiacao_pg_id),
  KEY pg_premiacao_usuario (pg_premiacao_usuario),
  CONSTRAINT plano_gestao_premiacoes_fk FOREIGN KEY (pg_premiacao_pg_id) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_gestao_premiacoes_fk1 FOREIGN KEY (pg_premiacao_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS plano_gestao_principios;

CREATE TABLE plano_gestao_principios (
  pg_principio_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pg_principio_pg_id INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_principio_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  pg_principio_nome TEXT,
  pg_principio_data DATETIME DEFAULT NULL,
  pg_principio_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (pg_principio_id),
  KEY pg_principio_pg_id (pg_principio_pg_id),
  KEY pg_principio_usuario (pg_principio_usuario),
  CONSTRAINT plano_gestao_principios_fk FOREIGN KEY (pg_principio_pg_id) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_gestao_principios_fk1 FOREIGN KEY (pg_principio_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS pratica_modelo;

CREATE TABLE pratica_modelo (
  pratica_modelo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pratica_modelo_nome VARCHAR(100) DEFAULT NULL,
  pratica_modelo_pontos INTEGER(11) DEFAULT '1000',
  pratica_modelo_obs TEXT,
  pratica_modelo_tipo VARCHAR(50) DEFAULT 'fnq_2015',
  pratica_modelo_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (pratica_modelo_id)
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS pratica_criterio;

CREATE TABLE pratica_criterio (
  pratica_criterio_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pratica_criterio_modelo INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_criterio_numero INTEGER(11) DEFAULT NULL,
  pratica_criterio_nome VARCHAR(200) DEFAULT NULL,
  pratica_criterio_pontos INTEGER(11) DEFAULT NULL,
  pratica_criterio_obs TEXT,
  pratica_criterio_orientacao TEXT,
  pratica_criterio_resultado TINYINT(1) DEFAULT 0,
  PRIMARY KEY (pratica_criterio_id),
  KEY pratica_criterio_modelo (pratica_criterio_modelo),
  CONSTRAINT pratica_criterio_fk FOREIGN KEY (pratica_criterio_modelo) REFERENCES pratica_modelo (pratica_modelo_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS pratica_depts;

CREATE TABLE pratica_depts (
  pratica_id INTEGER(100) UNSIGNED NOT NULL,
  dept_id INTEGER(100) UNSIGNED NOT NULL,
  KEY pratica_id (pratica_id),
  KEY dept_id (dept_id),
  CONSTRAINT pratica_depts_fk1 FOREIGN KEY (dept_id) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT pratica_depts_fk FOREIGN KEY (pratica_id) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS pratica_indicador_composicao;

CREATE TABLE pratica_indicador_composicao (
	pratica_indicador_composicao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pratica_indicador_composicao_pai INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_composicao_filho INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_composicao_peso DECIMAL(20,5) UNSIGNED DEFAULT 0,
  pratica_indicador_composicao_ordem INTEGER(10) UNSIGNED DEFAULT NULL,
  pratica_indicador_composicao_uuid varchar(36) DEFAULT NULL,
  PRIMARY KEY (pratica_indicador_composicao_id),
  KEY pratica_indicador_composicao_pai (pratica_indicador_composicao_pai),
  KEY pratica_indicador_composicao_filho (pratica_indicador_composicao_filho),
  CONSTRAINT pratica_indicador_composicao_filho FOREIGN KEY (pratica_indicador_composicao_filho) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT pratica_indicador_composicao_pai FOREIGN KEY (pratica_indicador_composicao_pai) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS pratica_indicador_depts;

CREATE TABLE pratica_indicador_depts (
  pratica_indicador_id INTEGER(100) UNSIGNED NOT NULL,
  dept_id INTEGER(100) UNSIGNED NOT NULL,
  KEY pratica_indicador_id (pratica_indicador_id),
  KEY dept_id (dept_id),
  CONSTRAINT pratica_indicador_depts_fk1 FOREIGN KEY (dept_id) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT pratica_indicador_depts_fk FOREIGN KEY (pratica_indicador_id) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS pratica_indicador_formula;

CREATE TABLE pratica_indicador_formula (
	pratica_indicador_formula_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pratica_indicador_formula_pai INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_formula_filho INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_formula_rocado INTEGER(10) DEFAULT 0,
  pratica_indicador_formula_ordem INTEGER(10) DEFAULT NULL,
  pratica_indicador_formula_uuid varchar(36) DEFAULT NULL,
  PRIMARY KEY (pratica_indicador_formula_id),
  KEY pratica_indicador_formula_pai (pratica_indicador_formula_pai),
  KEY pratica_indicador_formula_filho (pratica_indicador_formula_filho),
  CONSTRAINT pratica_indicador_formula_pai FOREIGN KEY (pratica_indicador_formula_pai) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT pratica_indicador_formula_filho FOREIGN KEY (pratica_indicador_formula_filho) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS pratica_indicador_nos_marcadores;

CREATE TABLE pratica_indicador_nos_marcadores (
  pratica_indicador_id INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_marcador_id INTEGER(100) UNSIGNED NOT NULL,
  ano INTEGER(4) DEFAULT NULL,
  uuid VARCHAR(36) DEFAULT NULL,
  KEY pratica_indicador_id (pratica_indicador_id),
  KEY pratica_marcador_id (pratica_marcador_id),
  CONSTRAINT pratica_indicador_nos_marcadores_fk FOREIGN KEY (pratica_indicador_id) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT pratica_indicador_nos_marcadores_fk2 FOREIGN KEY (pratica_marcador_id) REFERENCES pratica_marcador (pratica_marcador_id) ON DELETE CASCADE ON UPDATE CASCADE
 )ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS pratica_indicador_usuarios;

CREATE TABLE pratica_indicador_usuarios (
  pratica_indicador_id INTEGER(100) UNSIGNED NOT NULL,
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  KEY pratica_indicador_id (pratica_indicador_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT pratica_indicador_usuarios_fk1 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT pratica_indicador_usuarios_fk FOREIGN KEY (pratica_indicador_id) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS pratica_indicador_valor;

CREATE TABLE pratica_indicador_valor (
  pratica_indicador_valor_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pratica_indicador_valor_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_valor_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_valor_data DATE DEFAULT NULL,
  pratica_indicador_valor_valor DECIMAL(20,5) DEFAULT 0,
  pratica_indicador_valor_vetor LONGBLOB,
  pratica_indicador_valor_obs TEXT,
  PRIMARY KEY (pratica_indicador_valor_id),
  KEY pratica_indicador_valor_indicador (pratica_indicador_valor_indicador),
  KEY pratica_indicador_valor_responsavel (pratica_indicador_valor_responsavel),
  CONSTRAINT pratica_indicador_valor_fk1 FOREIGN KEY (pratica_indicador_valor_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT pratica_indicador_valor_fk FOREIGN KEY (pratica_indicador_valor_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS pratica_indicador_prazo;

CREATE TABLE pratica_indicador_prazo (
  pratica_indicador_prazo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pratica_indicador_prazo_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_prazo_insercao_inicio DATE DEFAULT NULL,
  pratica_indicador_prazo_insercao_fim DATE DEFAULT NULL,
  pratica_indicador_prazo_valor_inicio DATE DEFAULT NULL,
  pratica_indicador_prazo_valor_fim DATE DEFAULT NULL,
  pratica_indicador_prazo_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (pratica_indicador_prazo_id),
  KEY pratica_indicador_prazo_indicador (pratica_indicador_prazo_indicador),
  CONSTRAINT pratica_indicador_prazo_indicador FOREIGN KEY (pratica_indicador_prazo_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS pratica_item;

CREATE TABLE pratica_item (
  pratica_item_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pratica_item_criterio INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_item_numero INTEGER(11) DEFAULT NULL,
  pratica_item_nome VARCHAR(200) DEFAULT NULL,
  pratica_item_pontos INTEGER(11) DEFAULT NULL,
  pratica_item_obs TEXT,
  pratica_item_orientacao TEXT,
  pratica_item_oculto TINYINT(1) DEFAULT 0,
  PRIMARY KEY (pratica_item_id),
  KEY pratica_item_criterio (pratica_item_criterio),
  CONSTRAINT pratica_item_fk FOREIGN KEY (pratica_item_criterio) REFERENCES pratica_criterio (pratica_criterio_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS pratica_marcador;

CREATE TABLE pratica_marcador (
  pratica_marcador_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pratica_marcador_item INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_marcador_letra VARCHAR(1) DEFAULT NULL,
  pratica_marcador_texto TEXT,
  pratica_marcador_extra TEXT,
  pratica_marcador_evidencia TEXT,
  pratica_marcador_orientacao TEXT,
  PRIMARY KEY (pratica_marcador_id),
  KEY pratica_marcador_item (pratica_marcador_item),
  CONSTRAINT pratica_marcador_fk FOREIGN KEY (pratica_marcador_item) REFERENCES pratica_item (pratica_item_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS pratica_maturidade;

CREATE TABLE pratica_maturidade (
  pratica_maturidade_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pratica_modelo_id INTEGER(100) UNSIGNED DEFAULT NULL,
  minimo INTEGER(11) DEFAULT NULL,
  maximo INTEGER(11) DEFAULT NULL,
  descricao TEXT,
  PRIMARY KEY (pratica_maturidade_id),
  KEY pratica_modelo_id (pratica_modelo_id),
  CONSTRAINT pratica_maturidade_fk FOREIGN KEY (pratica_modelo_id) REFERENCES pratica_modelo (pratica_modelo_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS pratica_mod_campo;

CREATE TABLE pratica_mod_campo (
  pratica_mod_campo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pratica_mod_campo_modelo INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_mod_campo_nome VARCHAR(40) DEFAULT NULL,
  PRIMARY KEY (pratica_mod_campo_id),
  KEY pratica_mod_campo_modelo (pratica_mod_campo_modelo),
  CONSTRAINT pratica_mod_campo_fk FOREIGN KEY (pratica_mod_campo_modelo) REFERENCES pratica_modelo (pratica_modelo_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS pratica_nos_marcadores;

CREATE TABLE pratica_nos_marcadores (
  pratica INTEGER(100) UNSIGNED DEFAULT NULL,
  marcador INTEGER(100) UNSIGNED NOT NULL,
  ano INTEGER(4) DEFAULT NULL,
  uuid VARCHAR(36) DEFAULT NULL,
  KEY pratica (pratica),
  KEY marcador (marcador),
  CONSTRAINT pratica_nos_marcadores_fk1 FOREIGN KEY (marcador) REFERENCES pratica_marcador (pratica_marcador_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT pratica_nos_marcadores_fk FOREIGN KEY (pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS pratica_regra;

CREATE TABLE pratica_regra (
  pratica_regra_id INTEGER(11) NOT NULL AUTO_INCREMENT,
  pratica_modelo_id INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_regra_campo VARCHAR(80) DEFAULT NULL,
  pratica_regra_percentagem INTEGER(11) DEFAULT NULL,
  pratica_regra_valor INTEGER(11) DEFAULT NULL,
  pratica_regra_preliminar TINYINT(1) DEFAULT 0,
  pratica_regra_resultado TINYINT(1) DEFAULT 0,
  pratica_regra_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  subitem INTEGER(11) DEFAULT NULL,
  PRIMARY KEY (pratica_regra_id),
  KEY pratica_modelo_id (pratica_modelo_id),
  CONSTRAINT pratica_regra_fk FOREIGN KEY (pratica_modelo_id) REFERENCES pratica_modelo (pratica_modelo_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS pratica_regra_campo;

CREATE TABLE pratica_regra_campo (
  pratica_regra_campo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pratica_regra_campo_modelo_id INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_regra_campo_nome VARCHAR(100) DEFAULT NULL,
  pratica_regra_campo_texto VARCHAR(100) DEFAULT NULL,
  pratica_regra_campo_descricao TEXT,
  pratica_regra_campo_resultado TINYINT(1) DEFAULT 0,
  PRIMARY KEY (pratica_regra_campo_id),
  KEY pratica_regra_campo_modelo_id (pratica_regra_campo_modelo_id),
  CONSTRAINT pratica_regra_campo_fk FOREIGN KEY (pratica_regra_campo_modelo_id) REFERENCES pratica_modelo (pratica_modelo_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS pratica_usuarios;

CREATE TABLE pratica_usuarios (
  pratica_id INTEGER(100) UNSIGNED NOT NULL,
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  KEY pratica_id (pratica_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT pratica_usuarios_fk1 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT pratica_usuarios_fk FOREIGN KEY (pratica_id) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS pratica_verbo;

CREATE TABLE pratica_verbo (
  pratica_verbo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pratica_verbo_marcador INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_verbo_texto TEXT,
  pratica_verbo_numero INTEGER(11) DEFAULT NULL,
  PRIMARY KEY (pratica_verbo_id),
  KEY pratica_verbo_marcador (pratica_verbo_marcador),
  CONSTRAINT pratica_verbo_fk FOREIGN KEY (pratica_verbo_marcador) REFERENCES pratica_marcador (pratica_marcador_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS pratica_nos_verbos;

CREATE TABLE pratica_nos_verbos (
  pratica INTEGER(100) UNSIGNED DEFAULT NULL,
  verbo INTEGER(100) UNSIGNED NOT NULL,
  ano INTEGER(4) DEFAULT NULL,
  uuid VARCHAR(36) DEFAULT NULL,
  KEY pratica (pratica),
  KEY verbo (verbo),
  CONSTRAINT pratica_nos_verbos_fk1 FOREIGN KEY (pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT pratica_nos_verbos_fk FOREIGN KEY (verbo) REFERENCES pratica_verbo (pratica_verbo_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS indicador_lacuna;

CREATE TABLE indicador_lacuna (
  indicador_lacuna_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  indicador_lacuna_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  indicador_lacuna_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  indicador_lacuna_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  indicador_lacuna_nome VARCHAR(512) DEFAULT NULL,
  indicador_lacuna_ativo TINYINT(1) DEFAULT 1,
  indicador_lacuna_acesso INTEGER(4) DEFAULT 0,
  indicador_lacuna_cor VARCHAR(6) DEFAULT 'FFFFFF',
  indicador_lacuna_resultado TINYINT(1) DEFAULT 0,
  indicador_lacuna_descricao TEXT,
  PRIMARY KEY (indicador_lacuna_id),
  KEY indicador_lacuna_responsavel (indicador_lacuna_responsavel),
  KEY indicador_lacuna_cia (indicador_lacuna_cia),
  KEY indicador_lacuna_dept (indicador_lacuna_dept),
  CONSTRAINT indicador_lacuna_responsavel FOREIGN KEY (indicador_lacuna_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT indicador_lacuna_cia FOREIGN KEY (indicador_lacuna_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT indicador_lacuna_dept FOREIGN KEY (indicador_lacuna_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS indicador_lacuna_nos_marcadores;

CREATE TABLE indicador_lacuna_nos_marcadores (
  indicador_lacuna_id INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_marcador_id INTEGER(100) UNSIGNED NOT NULL,
  ano INTEGER(4) DEFAULT NULL,
  uuid VARCHAR(36) DEFAULT NULL,
  KEY indicador_lacuna_id (indicador_lacuna_id),
  KEY pratica_marcador_id (pratica_marcador_id),
  CONSTRAINT indicador_lacuna_nos_marcadores_fk FOREIGN KEY (indicador_lacuna_id) REFERENCES indicador_lacuna (indicador_lacuna_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT indicador_lacuna_nos_marcadores_fk2 FOREIGN KEY (pratica_marcador_id) REFERENCES pratica_marcador (pratica_marcador_id) ON DELETE CASCADE ON UPDATE CASCADE
 )ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS indicador_lacuna_depts;

CREATE TABLE indicador_lacuna_depts (
  indicador_lacuna_id INTEGER(100) UNSIGNED NOT NULL,
  dept_id INTEGER(100) UNSIGNED NOT NULL,
  KEY indicador_lacuna_id (indicador_lacuna_id),
  KEY dept_id (dept_id),
  CONSTRAINT indicador_lacuna_depts_fk1 FOREIGN KEY (dept_id) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT indicador_lacuna_depts_fk FOREIGN KEY (indicador_lacuna_id) REFERENCES indicador_lacuna (indicador_lacuna_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS indicador_lacuna_cia;

CREATE TABLE indicador_lacuna_cia (
  indicador_lacuna_cia_indicador_lacuna INTEGER(100) UNSIGNED NOT NULL,
  indicador_lacuna_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (indicador_lacuna_cia_indicador_lacuna, indicador_lacuna_cia_cia),
  KEY indicador_lacuna_cia_indicador_lacuna (indicador_lacuna_cia_indicador_lacuna),
  KEY indicador_lacuna_cia_cia (indicador_lacuna_cia_cia),
  CONSTRAINT indicador_lacuna_cia_cia FOREIGN KEY (indicador_lacuna_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT indicador_lacuna_cia_indicador_lacuna FOREIGN KEY (indicador_lacuna_cia_indicador_lacuna) REFERENCES indicador_lacuna (indicador_lacuna_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS indicador_lacuna_usuarios;

CREATE TABLE indicador_lacuna_usuarios (
  indicador_lacuna_id INTEGER(100) UNSIGNED NOT NULL,
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  KEY indicador_lacuna_id (indicador_lacuna_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT indicador_lacuna_usuarios_fk1 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT indicador_lacuna_usuarios_fk FOREIGN KEY (indicador_lacuna_id) REFERENCES indicador_lacuna (indicador_lacuna_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS preferencia;

CREATE TABLE preferencia (
  preferencia_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  encaminhar INTEGER(100) DEFAULT NULL,
  favorito INT(100) UNSIGNED DEFAULT NULL,
  grupoid INTEGER(100) DEFAULT '-1',
  grupoid2 INTEGER(100) DEFAULT 0,
  emailtodos SMALLINT(1) DEFAULT 0,
  exibenomefuncao SMALLINT(1) DEFAULT 1,
 	nomefuncao SMALLINT(1) DEFAULT 1,
  selecionarpordpto SMALLINT(1) DEFAULT 0,
  tarefaemailreg SMALLINT(1) DEFAULT 0,
  tarefasexpandidas SMALLINT(1) DEFAULT 0,
  msg_extra SMALLINT(1) DEFAULT 0,
  msg_entrada SMALLINT(1) DEFAULT 1,
  om_usuario SMALLINT(1) DEFAULT 1,
  agrupar_msg SMALLINT(1) DEFAULT 0,
  padrao_ver_tab SMALLINT(1) DEFAULT 1,
  ver_subordinadas SMALLINT(1) DEFAULT 0,
  ver_dept_subordinados SMALLINT(1) DEFAULT 0,
  padrao_ver_m VARCHAR(50) DEFAULT NULL,
  padrao_ver_a VARCHAR(50) DEFAULT NULL,
  ui_estilo VARCHAR(20) DEFAULT 'rondon',
  filtroevento VARCHAR(20) DEFAULT 'todos_aceitos',
  localidade VARCHAR(6) DEFAULT 'pt',
  modelo_msg VARCHAR(30) DEFAULT 'exibe_msg_mod_email',
	informa_responsavel SMALLINT(1) DEFAULT 1,
	informa_designados SMALLINT(1) DEFAULT 1,
	informa_contatos SMALLINT(1) DEFAULT 1,
	informa_interessados SMALLINT(1) DEFAULT 1,
	informa_aberto SMALLINT(1) DEFAULT 0,
  PRIMARY KEY (preferencia_id)
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS preferencia_cor;

CREATE TABLE preferencia_cor (
  preferencia_cor_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  usuario_id INTEGER(100) UNSIGNED,
  modelo VARCHAR(60) DEFAULT NULL,
  cor_fundo VARCHAR(6) DEFAULT NULL,
  cor_menu VARCHAR(6) DEFAULT NULL,
  cor_msg VARCHAR(6) DEFAULT NULL,
  cor_anexo VARCHAR(6) DEFAULT NULL,
  cor_despacho VARCHAR(6) DEFAULT NULL,
  cor_resposta VARCHAR(6) DEFAULT NULL,
  cor_anotacao VARCHAR(6) DEFAULT NULL,
  cor_encamihamentos VARCHAR(6) DEFAULT NULL,
  cor_msg_nao_lida VARCHAR(6) DEFAULT NULL,
  cor_msg_realce VARCHAR(6) DEFAULT NULL,
  cor_referencia VARCHAR(6) DEFAULT NULL,
  cor_referenciado VARCHAR(6) DEFAULT NULL,
  PRIMARY KEY (preferencia_cor_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT preferencias_fk FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS preferencia_modulo;

CREATE TABLE preferencia_modulo (
  preferencia_modulo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  preferencia_modulo_modulo VARCHAR(50) DEFAULT NULL,
  preferencia_modulo_descricao VARCHAR(255) DEFAULT NULL,
  preferencia_modulo_arquivo VARCHAR(255) DEFAULT NULL,
  PRIMARY KEY (preferencia_modulo_id)
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS projeto_area;

CREATE TABLE projeto_area (
  projeto_area_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  projeto_area_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_area_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_area_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_area_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_area_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_area_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_area_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_area_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_area_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_area_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_area_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_area_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_area_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_area_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_area_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_area_nome VARCHAR(255) DEFAULT NULL,
  projeto_area_obs MEDIUMTEXT,
  projeto_area_cor VARCHAR(6) DEFAULT 'ffffff',
  projeto_area_espessura INTEGER(10) UNSIGNED DEFAULT '2',
  projeto_area_opacidade FLOAT DEFAULT '0.5',
  projeto_area_poligono TINYINT(1) DEFAULT 1,
  uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (projeto_area_id),
  KEY projeto_area_projeto (projeto_area_projeto),
  KEY projeto_area_tarefa (projeto_area_tarefa),
  KEY projeto_area_perspectiva (projeto_area_perspectiva),
	KEY projeto_area_tema (projeto_area_tema),
	KEY projeto_area_objetivo (projeto_area_objetivo),
	KEY projeto_area_fator (projeto_area_fator),
	KEY projeto_area_estrategia (projeto_area_estrategia),
	KEY projeto_area_meta (projeto_area_meta),
	KEY projeto_area_pratica (projeto_area_pratica),
	KEY projeto_area_acao (projeto_area_acao),
	KEY projeto_area_indicador (projeto_area_indicador),
	KEY projeto_area_demanda (projeto_area_demanda),
	KEY projeto_area_calendario (projeto_area_calendario),
	KEY projeto_area_ata (projeto_area_ata),
	KEY projeto_area_usuario (projeto_area_usuario),
	CONSTRAINT projeto_area_fk FOREIGN KEY (projeto_area_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_area_fk1 FOREIGN KEY (projeto_area_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_area_fk2 FOREIGN KEY (projeto_area_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_area_fk3 FOREIGN KEY (projeto_area_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_area_fk4 FOREIGN KEY (projeto_area_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_area_fk5 FOREIGN KEY (projeto_area_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_area_fk6 FOREIGN KEY (projeto_area_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_area_fk7 FOREIGN KEY (projeto_area_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_area_fk8 FOREIGN KEY (projeto_area_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_area_fk9 FOREIGN KEY (projeto_area_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_area_fk10 FOREIGN KEY (projeto_area_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_area_fk11 FOREIGN KEY (projeto_area_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_area_fk12 FOREIGN KEY (projeto_area_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_area_fk13 FOREIGN KEY (projeto_area_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_area_fk14 FOREIGN KEY (projeto_area_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS projeto_contatos;

CREATE TABLE projeto_contatos (
  projeto_contato_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  projeto_id INTEGER(100) UNSIGNED DEFAULT NULL,
  contato_id INTEGER(100) UNSIGNED DEFAULT NULL,
  ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  envolvimento VARCHAR(255) DEFAULT NULL,
  perfil MEDIUMTEXT,
  uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (projeto_contato_id),
  KEY projeto_id (projeto_id),
  KEY contato_id (contato_id),
  CONSTRAINT projeto_contatos_fk1 FOREIGN KEY (contato_id) REFERENCES contatos (contato_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_contatos_fk FOREIGN KEY (projeto_id) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS projeto_depts;

CREATE TABLE projeto_depts (
  projeto_id INTEGER(100) UNSIGNED NOT NULL,
  departamento_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (projeto_id, departamento_id),
  KEY projeto_id (projeto_id),
  KEY departamento_id (departamento_id),
  CONSTRAINT projeto_depts_fk1 FOREIGN KEY (departamento_id) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_depts_fk FOREIGN KEY (projeto_id) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS projeto_integrantes;

CREATE TABLE projeto_integrantes (
  projeto_integrantes_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  projeto_id INTEGER(100) UNSIGNED DEFAULT NULL,
  contato_id INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_integrante_competencia VARCHAR(255) DEFAULT NULL,
  projeto_integrante_atributo MEDIUMTEXT,
  projeto_integrantes_situacao MEDIUMTEXT,
  projeto_integrantes_necessidade MEDIUMTEXT,
  ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (projeto_integrantes_id),
  KEY projeto_id (projeto_id),
  KEY contato_id (contato_id),
  CONSTRAINT projeto_integrantes_fk FOREIGN KEY (projeto_id) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_integrantes_fk1 FOREIGN KEY (contato_id) REFERENCES contatos (contato_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS projeto_observado;

CREATE TABLE projeto_observado (
  projeto_observado_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  projeto_id INTEGER(100) UNSIGNED DEFAULT NULL,
  cia_de INTEGER(100) UNSIGNED DEFAULT NULL,
  cia_para INTEGER(100) UNSIGNED DEFAULT NULL,
  remetente INTEGER(100) UNSIGNED DEFAULT NULL,
  usuario_aprovou INTEGER(100) UNSIGNED DEFAULT NULL,
  data_envio DATETIME DEFAULT NULL,
  data_aprovacao DATETIME DEFAULT NULL,
  tipo INTEGER(100) UNSIGNED DEFAULT NULL,
  aprovado TINYINT(1) DEFAULT 0,
  obs_remetente MEDIUMTEXT,
  obs_destinatario MEDIUMTEXT,
  PRIMARY KEY (projeto_observado_id),
  KEY projeto_id (projeto_id),
  KEY cia_de (cia_de),
  KEY cia_para (cia_para),
  KEY remetente (remetente),
  KEY usuario_aprovou (usuario_aprovou),
  CONSTRAINT projeto_observado_fk FOREIGN KEY (projeto_id) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_observado_fk1 FOREIGN KEY (cia_de) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_observado_fk2 FOREIGN KEY (cia_para) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_observado_fk3 FOREIGN KEY (remetente) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT projeto_observado_fk4 FOREIGN KEY (usuario_aprovou) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS projeto_ponto;

CREATE TABLE projeto_ponto (
  projeto_ponto_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  projeto_area_id INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_ponto_latitude DECIMAL(10,6) DEFAULT NULL,
  projeto_ponto_longitude DECIMAL(10,6) DEFAULT NULL,
  PRIMARY KEY (projeto_ponto_id),
  KEY projeto_area_id (projeto_area_id),
  CONSTRAINT projeto_ponto_fk FOREIGN KEY (projeto_area_id) REFERENCES projeto_area (projeto_area_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS recurso_depts;

CREATE TABLE recurso_depts (
  recurso_id INTEGER(100) UNSIGNED NOT NULL,
  departamento_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (recurso_id, departamento_id),
  KEY recurso_id (recurso_id),
  CONSTRAINT recurso_depts_fk1 FOREIGN KEY (recurso_id) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT recurso_depts_fk FOREIGN KEY (recurso_id) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS recurso_tarefas;

CREATE TABLE recurso_tarefas (
	recurso_tarefa_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  recurso_id INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_id INTEGER(100) UNSIGNED DEFAULT NULL,
  percentual_alocado INTEGER(100) UNSIGNED DEFAULT '100',
  recurso_quantidade DECIMAL(20,5) UNSIGNED DEFAULT 0,
  recurso_tarefa_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_tarefa_uuid varchar(36) DEFAULT NULL,
  PRIMARY KEY (recurso_tarefa_id),
  KEY recurso_id (recurso_id),
  KEY tarefa_id_2 (tarefa_id),
  CONSTRAINT recurso_tarefas_fk1 FOREIGN KEY (tarefa_id) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT recurso_tarefas_fk FOREIGN KEY (recurso_id) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS recurso_usuarios;

CREATE TABLE recurso_usuarios (
  recurso_id INTEGER(100) UNSIGNED NOT NULL,
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (recurso_id, usuario_id),
  KEY recurso_id (recurso_id),
  KEY usuario_id (usuario_id, recurso_id),
  KEY usuario_id_2 (usuario_id),
  CONSTRAINT recurso_usuarios_fk1 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT recurso_usuarios_fk FOREIGN KEY (recurso_id) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS referencia;

CREATE TABLE referencia (
  referencia_msg_pai INTEGER(100) UNSIGNED DEFAULT NULL,
  referencia_doc_pai INTEGER(100) UNSIGNED DEFAULT NULL,
  referencia_msg_filho INTEGER(100) UNSIGNED DEFAULT NULL,
  referencia_doc_filho INTEGER(100) UNSIGNED DEFAULT NULL,
  referencia_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  referencia_data DATETIME DEFAULT NULL,
  referencia_nome_de VARCHAR(50) DEFAULT NULL,
  referencia_funcao_de VARCHAR(50) DEFAULT NULL,
  KEY referencia_msg_pai (referencia_msg_pai),
  KEY referencia_msg_filho (referencia_msg_filho),
  KEY referencia_doc_pai (referencia_doc_pai),
  KEY referencia_doc_filho (referencia_doc_filho),
  KEY referencia_responsavel (referencia_responsavel),
  CONSTRAINT referencia_fk4 FOREIGN KEY (referencia_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT referencia_fk FOREIGN KEY (referencia_msg_pai) REFERENCES msg (msg_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT referencia_fk1 FOREIGN KEY (referencia_msg_filho) REFERENCES msg (msg_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT referencia_fk2 FOREIGN KEY (referencia_doc_pai) REFERENCES modelos (modelo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT referencia_fk3 FOREIGN KEY (referencia_doc_filho) REFERENCES modelos (modelo_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS sessoes;

CREATE TABLE sessoes (
  sessao_id VARCHAR(100) DEFAULT NULL,
  sessao_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  sessao_data LONGBLOB,
  sessao_atualizada TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  sessao_criada DATETIME DEFAULT NULL,
  KEY sessao_id (sessao_id),
  KEY sessao_atualizada (sessao_atualizada),
  KEY sessao_criada (sessao_criada),
  KEY sessao_usuario (sessao_usuario)
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS sischaves;

CREATE TABLE sischaves (
  sischave_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  sischave_nome VARCHAR(48) DEFAULT NULL,
  sischave_legenda VARCHAR(255) DEFAULT NULL,
  sischave_tipo INTEGER(1) UNSIGNED DEFAULT 0,
  sischave_sep1 CHAR(2) DEFAULT '\n',
  sischave_sep2 CHAR(2) DEFAULT '|',
  PRIMARY KEY (sischave_id)
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS sisvalores;

CREATE TABLE sisvalores (
  sisvalor_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  sisvalor_titulo VARCHAR(48) DEFAULT NULL,
  sisvalor_valor TEXT,
  sisvalor_valor_id VARCHAR(255) DEFAULT 0,
  sisvalor_chave_id_pai VARCHAR(255) DEFAULT NULL,
  sisvalor_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  sisvalor_ativo TINYINT(1) DEFAULT 1,
  PRIMARY KEY (sisvalor_id),
  KEY sisvalor_valor_id (sisvalor_valor_id),
  KEY sisvalor_titulo (sisvalor_titulo),
  KEY sisvalor_chave_id_pai (sisvalor_chave_id_pai),
  KEY sisvalor_projeto (sisvalor_projeto),
  CONSTRAINT sisvalor_fk1 FOREIGN KEY (sisvalor_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS tarefa_contatos;

CREATE TABLE tarefa_contatos (
  tarefa_id INTEGER(100) UNSIGNED NOT NULL,
  contato_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (tarefa_id, contato_id),
  KEY tarefa_id (tarefa_id),
  KEY contato_id (contato_id),
  CONSTRAINT tarefa_contatos_fk1 FOREIGN KEY (contato_id) REFERENCES contatos (contato_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tarefa_contatos_fk FOREIGN KEY (tarefa_id) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS tarefa_custos;

CREATE TABLE tarefa_custos (
  tarefa_custos_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  tarefa_custos_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_custos_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_custos_tr INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_custos_nome VARCHAR(255) DEFAULT NULL,
  tarefa_custos_codigo VARCHAR(255) DEFAULT NULL,
  tarefa_custos_fonte VARCHAR(255) DEFAULT NULL,
  tarefa_custos_regiao VARCHAR(255) DEFAULT NULL,
  tarefa_custos_tipo INTEGER(100) UNSIGNED DEFAULT 1,
  tarefa_custos_data DATETIME DEFAULT NULL,
  tarefa_custos_quantidade DECIMAL(20,5) UNSIGNED DEFAULT 0,
  tarefa_custos_custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
  tarefa_custos_bdi DECIMAL(20,5) UNSIGNED DEFAULT 0,
  tarefa_custos_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
	tarefa_custos_cotacao DECIMAL(6,5) UNSIGNED DEFAULT 1,
	tarefa_custos_data_moeda DATE DEFAULT NULL, 
  tarefa_custos_percentagem TINYINT(4) DEFAULT 0,
  tarefa_custos_descricao MEDIUMTEXT,
  tarefa_custos_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_custos_nd VARCHAR(11) DEFAULT NULL,
  tarefa_custos_categoria_economica VARCHAR(1) DEFAULT NULL,
  tarefa_custos_grupo_despesa VARCHAR(1) DEFAULT NULL,
  tarefa_custos_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  tarefa_custos_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	tarefa_custos_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
	tarefa_custos_data_limite DATE DEFAULT NULL,
	tarefa_custos_pi VARCHAR(100) DEFAULT NULL,
	tarefa_custos_ptres VARCHAR(100) DEFAULT NULL,
	tarefa_custos_aprovou INTEGER(100) UNSIGNED DEFAULT NULL,
	tarefa_custos_aprovado TINYINT(1) DEFAULT NULL,
	tarefa_custos_data_aprovado DATETIME DEFAULT NULL,
  PRIMARY KEY (tarefa_custos_id),
  KEY tarefa_custos_tarefa (tarefa_custos_tarefa),
  KEY tarefa_custos_usuario (tarefa_custos_usuario),
  KEY tarefa_custos_tr (tarefa_custos_tr),
  KEY tarefa_custos_ordem (tarefa_custos_ordem),
  KEY tarefa_custos_data (tarefa_custos_data),
  KEY tarefa_custos_nome (tarefa_custos_nome),
  KEY tarefa_custos_aprovou (tarefa_custos_aprovou),
  KEY tarefa_custos_moeda (tarefa_custos_moeda),
  CONSTRAINT tarefa_custos_usuario FOREIGN KEY (tarefa_custos_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT tarefa_custos_tarefa FOREIGN KEY (tarefa_custos_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tarefa_custos_aprovou FOREIGN KEY (tarefa_custos_aprovou) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT tarefa_custos_tr FOREIGN KEY (tarefa_custos_tr) REFERENCES tr (tr_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT tarefa_custos_moeda FOREIGN KEY (tarefa_custos_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS tarefa_dependencias;

CREATE TABLE tarefa_dependencias (
  dependencias_tarefa_id INTEGER(100) UNSIGNED NOT NULL,
  dependencias_req_tarefa_id INTEGER(100) UNSIGNED NOT NULL,
  tipo_dependencia VARCHAR(3) DEFAULT 'TI',
  latencia INTEGER(100) DEFAULT 0,
  tipo_latencia VARCHAR(1) DEFAULT 'd',
  dependencia_forte  TINYINT(1) DEFAULT '0',
  PRIMARY KEY (dependencias_tarefa_id, dependencias_req_tarefa_id),
  KEY dependencias_tarefa_id (dependencias_tarefa_id),
  KEY dependencias_req_tarefa_id (dependencias_req_tarefa_id),
  CONSTRAINT tarefa_dependencias_fk1 FOREIGN KEY (dependencias_req_tarefa_id) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tarefa_dependencias_fk FOREIGN KEY (dependencias_tarefa_id) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS tarefa_depts;

CREATE TABLE tarefa_depts (
  tarefa_id INTEGER(100) UNSIGNED NOT NULL,
  departamento_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (tarefa_id, departamento_id),
  KEY tarefa_id (tarefa_id),
  KEY departamento_id (departamento_id),
  CONSTRAINT tarefa_depts_fk1 FOREIGN KEY (departamento_id) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tarefa_depts_fk FOREIGN KEY (tarefa_id) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS tarefa_designados;

CREATE TABLE tarefa_designados (
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  tarefa_id INTEGER(100) UNSIGNED NOT NULL,
  usuario_admin TINYINT(4) DEFAULT 0,
  perc_designado DECIMAL(10, 3) UNSIGNED DEFAULT 100,
  usuario_tarefa_prioridade TINYINT(4) DEFAULT 0,
  PRIMARY KEY (tarefa_id, usuario_id),
  KEY index_ut_to_tarefas (tarefa_id),
  KEY perc_designado (perc_designado),
  KEY usuario_id (usuario_id),
  CONSTRAINT tarefa_designados_fk1 FOREIGN KEY (tarefa_id) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tarefa_designados_fk FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS tarefa_gastos;

CREATE TABLE tarefa_gastos (
  tarefa_gastos_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  tarefa_gastos_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_gastos_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_gastos_nome VARCHAR(255) DEFAULT NULL,
  tarefa_gastos_codigo VARCHAR(255) DEFAULT NULL,
  tarefa_gastos_fonte VARCHAR(255) DEFAULT NULL,
  tarefa_gastos_regiao VARCHAR(255) DEFAULT NULL,
  tarefa_gastos_tipo INTEGER(100) UNSIGNED DEFAULT 1,
  tarefa_gastos_data DATETIME DEFAULT NULL,
  tarefa_gastos_quantidade DECIMAL(20,5) UNSIGNED DEFAULT 0,
  tarefa_gastos_custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
  tarefa_gastos_bdi DECIMAL(20,5) UNSIGNED DEFAULT 0,
	tarefa_gastos_moeda INTEGER(100) UNSIGNED DEFAULT 1,  
	tarefa_gastos_cotacao DECIMAL(6,5) UNSIGNED DEFAULT 1, 
	tarefa_gastos_data_moeda DATE DEFAULT NULL,
  tarefa_gastos_percentagem TINYINT(4) DEFAULT 0,
  tarefa_gastos_descricao MEDIUMTEXT,
  tarefa_gastos_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_gastos_nd VARCHAR(11) DEFAULT NULL,
  tarefa_gastos_categoria_economica VARCHAR(1) DEFAULT NULL,
  tarefa_gastos_grupo_despesa VARCHAR(1) DEFAULT NULL,
  tarefa_gastos_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  tarefa_gastos_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	tarefa_gastos_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
  tarefa_gastos_data_recebido DATE DEFAULT NULL,
  tarefa_gastos_empenhado DECIMAL(20,5) UNSIGNED DEFAULT 0,
	tarefa_gastos_entregue DECIMAL(20,5) UNSIGNED DEFAULT 0,
	tarefa_gastos_liquidado DECIMAL(20,5) UNSIGNED DEFAULT 0,
	tarefa_gastos_pago DECIMAL(20,5) UNSIGNED DEFAULT 0,
	tarefa_gastos_pi VARCHAR(100) DEFAULT NULL,
	tarefa_gastos_ptres VARCHAR(100) DEFAULT NULL,
	tarefa_gastos_aprovou INTEGER(100) UNSIGNED DEFAULT NULL,
	tarefa_gastos_aprovado TINYINT(1) DEFAULT NULL,
	tarefa_gastos_data_aprovado DATETIME DEFAULT NULL,
  PRIMARY KEY (tarefa_gastos_id),
  KEY idxtarefa_gastos_tarefa (tarefa_gastos_tarefa),
  KEY idxtarefa_gastos_usuario_inicio (tarefa_gastos_usuario),
  KEY idxtarefa_gastos_ordem (tarefa_gastos_ordem),
  KEY idxtarefa_gastos_data_inicio (tarefa_gastos_data),
  KEY idxtarefa_gastos_nome (tarefa_gastos_nome),
  KEY tarefa_gastos_aprovou (tarefa_gastos_aprovou),
  KEY tarefa_gastos_moeda (tarefa_gastos_moeda),
  CONSTRAINT tarefa_gastos_fk1 FOREIGN KEY (tarefa_gastos_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT tarefa_gastos_fk FOREIGN KEY (tarefa_gastos_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tarefa_gastos_aprovou FOREIGN KEY (tarefa_gastos_aprovou) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT tarefa_gastos_moeda FOREIGN KEY (tarefa_gastos_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS tarefa_h_custos;

CREATE TABLE tarefa_h_custos (
  h_custos_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  h_custos_tarefa_custos_id INTEGER(100) UNSIGNED DEFAULT NULL,
  h_custos_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  h_custos_nome1 VARCHAR(255) DEFAULT NULL,
  h_custos_nome2 VARCHAR(255) DEFAULT NULL,
  h_custos_codigo1 VARCHAR(255) DEFAULT NULL,
  h_custos_codigo2 VARCHAR(255) DEFAULT NULL,
  h_custos_fonte1 VARCHAR(255) DEFAULT NULL,
  h_custos_fonte2 VARCHAR(255) DEFAULT NULL,
  h_custos_regiao1 VARCHAR(255) DEFAULT NULL,
  h_custos_regiao2 VARCHAR(255) DEFAULT NULL,
  h_custos_tipo1 INTEGER(100) UNSIGNED DEFAULT 1,
  h_custos_tipo2 INTEGER(100) UNSIGNED DEFAULT 1,
  h_custos_usuario1 INTEGER(100) UNSIGNED DEFAULT NULL,
  h_custos_usuario2 INTEGER(100) UNSIGNED DEFAULT NULL,
  h_custos_data1 DATETIME DEFAULT NULL,
  h_custos_data2 DATETIME DEFAULT NULL,
  h_custos_quantidade1 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_custos_quantidade2 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_custos_custo1 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_custos_custo2 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_custos_percentagem1 TINYINT(4) DEFAULT 0,
  h_custos_percentagem2 TINYINT(4) DEFAULT 0,
  h_custos_descricao1 MEDIUMTEXT,
  h_custos_descricao2 MEDIUMTEXT,
  h_custos_nd1 VARCHAR(20) DEFAULT NULL,
  h_custos_nd2 VARCHAR(20) DEFAULT NULL,
  h_custos_excluido TINYINT(1) DEFAULT 0,
  h_custos_categoria_economica1 VARCHAR(1) DEFAULT NULL,
  h_custos_grupo_despesa1 VARCHAR(1) DEFAULT NULL,
  h_custos_modalidade_aplicacao1 VARCHAR(2) DEFAULT NULL,
  h_custos_categoria_economica2 VARCHAR(1) DEFAULT NULL,
  h_custos_grupo_despesa2 VARCHAR(1) DEFAULT NULL,
  h_custos_modalidade_aplicacao2 VARCHAR(2) DEFAULT NULL,
  h_custos_metodo1 INTEGER(100) UNSIGNED DEFAULT NULL,
	h_custos_metodo2 INTEGER(100) UNSIGNED DEFAULT NULL,
	h_custos_exercicio1 INTEGER(4) UNSIGNED DEFAULT NULL,
	h_custos_exercicio2 INTEGER(4) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (h_custos_id),
  KEY h_custos_tarefa_custos_id (h_custos_tarefa_custos_id),
  KEY h_custos_tarefa (h_custos_tarefa),
  CONSTRAINT tarefa_h_custos_fk1 FOREIGN KEY (h_custos_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tarefa_h_custos_fk FOREIGN KEY (h_custos_tarefa_custos_id) REFERENCES tarefa_custos (tarefa_custos_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS tarefa_h_gastos;

CREATE TABLE tarefa_h_gastos (
  h_gastos_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  h_gastos_tarefa_gastos_id INTEGER(100) UNSIGNED DEFAULT NULL,
  h_gastos_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  h_gastos_nome1 VARCHAR(255) DEFAULT NULL,
  h_gastos_nome2 VARCHAR(255) DEFAULT NULL,
  h_gastos_codigo1 VARCHAR(255) DEFAULT NULL,
  h_gastos_codigo2 VARCHAR(255) DEFAULT NULL,
  h_gastos_fonte1 VARCHAR(255) DEFAULT NULL,
  h_gastos_fonte2 VARCHAR(255) DEFAULT NULL,
  h_gastos_regiao1 VARCHAR(255) DEFAULT NULL,
  h_gastos_regiao2 VARCHAR(255) DEFAULT NULL,
  h_gastos_tipo1 INTEGER(100) UNSIGNED DEFAULT 1,
  h_gastos_tipo2 INTEGER(100) UNSIGNED DEFAULT 1,
  h_gastos_usuario1 INTEGER(100) UNSIGNED DEFAULT NULL,
  h_gastos_usuario2 INTEGER(100) UNSIGNED DEFAULT NULL,
  h_gastos_data1 DATETIME DEFAULT NULL,
  h_gastos_data2 DATETIME DEFAULT NULL,
  h_gastos_quantidade1 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_gastos_quantidade2 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_gastos_custo1 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_gastos_custo2 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_gastos_percentagem1 TINYINT(4) DEFAULT 0,
  h_gastos_percentagem2 TINYINT(4) DEFAULT 0,
  h_gastos_descricao1 TEXT,
  h_gastos_descricao2 TEXT,
  h_gastos_nd1 VARCHAR(20) DEFAULT NULL,
  h_gastos_nd2 VARCHAR(20) DEFAULT NULL,
  h_gastos_categoria_economica1 VARCHAR(1) DEFAULT NULL,
  h_gastos_grupo_despesa1 VARCHAR(1) DEFAULT NULL,
  h_gastos_modalidade_aplicacao1 VARCHAR(2) DEFAULT NULL,
  h_gastos_categoria_economica2 VARCHAR(1) DEFAULT NULL,
  h_gastos_grupo_despesa2 VARCHAR(1) DEFAULT NULL,
  h_gastos_modalidade_aplicacao2 VARCHAR(2) DEFAULT NULL,
  h_gastos_metodo1 INTEGER(100) UNSIGNED DEFAULT NULL,
	h_gastos_metodo2 INTEGER(100) UNSIGNED DEFAULT NULL,
	h_gastos_exercicio1 INTEGER(4) UNSIGNED DEFAULT NULL,
 	h_gastos_exercicio2 INTEGER(4) UNSIGNED DEFAULT NULL,
  h_gastos_excluido TINYINT(1) DEFAULT 0,
  PRIMARY KEY (h_gastos_id),
  KEY h_gastos_tarefa_gastos_id (h_gastos_tarefa_gastos_id),
  KEY h_gastos_tarefa (h_gastos_tarefa),
  CONSTRAINT tarefa_h_gastos_fk1 FOREIGN KEY (h_gastos_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tarefa_h_gastos_fk FOREIGN KEY (h_gastos_tarefa_gastos_id) REFERENCES tarefa_gastos (tarefa_gastos_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS tarefas_bloco;

CREATE TABLE tarefas_bloco (
  tarefas_bloco_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  tarefas_bloco_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefas_bloco_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefas_bloco_tarefas TEXT,
  tarefas_bloco_tipo VARCHAR(50) DEFAULT NULL,
  tarefas_bloco_acesso INTEGER(11) UNSIGNED DEFAULT 0,
  tarefas_bloco_nome VARCHAR(255) DEFAULT NULL,
  tarefas_bloco_detalhe MEDIUMTEXT,
  PRIMARY KEY (tarefas_bloco_id),
  KEY tarefas_bloco_cia (tarefas_bloco_cia),
  KEY tarefas_bloco_responsavel (tarefas_bloco_responsavel),
  CONSTRAINT tarefas_bloco_cia FOREIGN KEY (tarefas_bloco_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tarefas_bloco_responsavel FOREIGN KEY (tarefas_bloco_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS tarefas_bloco_integrantes;

CREATE TABLE tarefas_bloco_integrantes (
  tarefas_bloco_id INTEGER(100) UNSIGNED NOT NULL,
  tarefas_bloco_usuario INTEGER(100) UNSIGNED NOT NULL,
  KEY tarefas_bloco_id (tarefas_bloco_id),
  KEY tarefas_bloco_usuario (tarefas_bloco_usuario),
  CONSTRAINT tarefas_bloco_integrantes_fk1 FOREIGN KEY (tarefas_bloco_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tarefas_bloco_integrantes_fk FOREIGN KEY (tarefas_bloco_id) REFERENCES tarefas_bloco (tarefas_bloco_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS usuario_reg_acesso;

CREATE TABLE usuario_reg_acesso (
  usuario_reg_acesso_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  usuario_id INTEGER(100) UNSIGNED DEFAULT NULL,
  usuario_ip VARCHAR(15) DEFAULT NULL,
  entrou DATETIME DEFAULT NULL,
  saiu DATETIME DEFAULT NULL,
  ultima_atividade DATETIME DEFAULT NULL,
  PRIMARY KEY (usuario_reg_acesso_id),
  KEY ultima_atividade (ultima_atividade),
  KEY entrou (entrou),
  KEY saiu (saiu),
  KEY usuario_id (usuario_id),
  CONSTRAINT usuario_reg_acesso_fk FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS usuario_tarefa_marcada;

CREATE TABLE usuario_tarefa_marcada (
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  tarefa_id INTEGER(100) UNSIGNED NOT NULL,
  tarefa_marcada TINYINT(2) DEFAULT 1,
  PRIMARY KEY (usuario_id, tarefa_id),
  KEY tarefa_id (tarefa_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT usuario_tarefa_marcada_fk1 FOREIGN KEY (tarefa_id) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT usuario_tarefa_marcada_fk FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS grupo_usuario;

CREATE TABLE grupo_usuario (
  grupo_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
  grupo_usuario_grupo INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (grupo_usuario_usuario, grupo_usuario_grupo),
  KEY grupo_usuario_usuario (grupo_usuario_usuario),
  KEY grupo_usuario_grupo (grupo_usuario_grupo),
  CONSTRAINT grupo_usuario_grupo FOREIGN KEY (grupo_usuario_grupo) REFERENCES grupo (grupo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT grupo_usuario_usuario FOREIGN KEY (grupo_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS template;

CREATE TABLE template (
  template_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  template_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  template_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  template_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  template_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  template_nome VARCHAR(255) DEFAULT NULL,
  template_tipo VARCHAR(255) DEFAULT NULL,
  template_gerencial TINYINT(1) DEFAULT 0,
  template_descricao MEDIUMTEXT,
  template_cor VARCHAR(6) DEFAULT 'FFFFFF',
	template_acesso INTEGER(100) UNSIGNED DEFAULT 0,
	template_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
	template_ativo TINYINT(1) DEFAULT 1,
	template_aprovado TINYINT(1) DEFAULT 0,
  PRIMARY KEY (template_id),
  KEY template_cia (template_cia),
  KEY template_dept (template_dept),
  KEY (template_responsavel),
  KEY template_projeto (template_projeto),
  KEY template_moeda (template_moeda),
	CONSTRAINT template_fk1 FOREIGN KEY (template_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT template_fk2 FOREIGN KEY (template_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT template_dept FOREIGN KEY (template_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT template_fk3 FOREIGN KEY (template_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT template_moeda FOREIGN KEY (template_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE 
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS template_depts;

CREATE TABLE template_depts (
  template_id INTEGER(100) UNSIGNED NOT NULL,
  dept_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (template_id, dept_id),
  KEY template_id (template_id),
  KEY dept_id (dept_id),
  CONSTRAINT template_depts_fk1 FOREIGN KEY (template_id) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT template_depts_fk2 FOREIGN KEY (dept_id) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS template_usuarios;

CREATE TABLE template_usuarios (
  template_id INTEGER(100) UNSIGNED NOT NULL,
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (template_id, usuario_id),
  KEY template_id (template_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT template_usuarios_fk1 FOREIGN KEY (template_id) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT template_usuarios_fk2 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS versao;

CREATE TABLE versao (
  revisao_codigo INTEGER(100) UNSIGNED NOT NULL,
  versao_codigo VARCHAR(10) DEFAULT NULL,
  versao_bd INTEGER(100) UNSIGNED DEFAULT NULL,
  ultima_atualizacao_bd DATE DEFAULT NULL,
  ultima_atualizacao_codigo DATE DEFAULT NULL,
  PRIMARY KEY (revisao_codigo)
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS perfil;

CREATE TABLE perfil (
  perfil_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  perfil_nome VARCHAR(255) DEFAULT NULL,
  perfil_descricao VARCHAR(255) DEFAULT NULL,
  PRIMARY KEY (perfil_id)
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS perfil_acesso;

CREATE TABLE perfil_acesso (
  perfil_acesso_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  perfil_acesso_perfil INTEGER(100) UNSIGNED NOT NULL,
  perfil_acesso_modulo VARCHAR(50) DEFAULT NULL,
  perfil_acesso_objeto VARCHAR(50) DEFAULT NULL,
  perfil_acesso_acesso TINYINT(1) DEFAULT 0,
  perfil_acesso_editar TINYINT(1) DEFAULT 0,
  perfil_acesso_adicionar INTEGER(1) DEFAULT 0,
  perfil_acesso_excluir INTEGER(1) DEFAULT 0,
  perfil_acesso_aprovar INTEGER(1) DEFAULT 0,
  perfil_acesso_negar INTEGER(1) DEFAULT 0,
  PRIMARY KEY (perfil_acesso_id),
  KEY perfil_acesso_perfil (perfil_acesso_perfil),
  CONSTRAINT perfil_acesso_fk FOREIGN KEY (perfil_acesso_perfil) REFERENCES perfil (perfil_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS perfil_usuario;

CREATE TABLE perfil_usuario (
  perfil_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
  perfil_usuario_perfil INTEGER(100) UNSIGNED NOT NULL,
  KEY perfil_usuario_usuario (perfil_usuario_usuario),
  KEY perfil_usuario_perfil (perfil_usuario_perfil),
  CONSTRAINT perfil_usuario_fk1 FOREIGN KEY (perfil_usuario_perfil) REFERENCES perfil (perfil_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT perfil_usuario_fk FOREIGN KEY (perfil_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS perfil_submodulo;

CREATE TABLE perfil_submodulo (
  perfil_submodulo_id INTEGER(100) NOT NULL AUTO_INCREMENT,
  perfil_submodulo_modulo VARCHAR(50) DEFAULT NULL,
  perfil_submodulo_submodulo VARCHAR(50) DEFAULT NULL,
  perfil_submodulo_pai VARCHAR(50) DEFAULT NULL,
  perfil_submodulo_necessita_menu TINYINT(1) DEFAULT 1,
  perfil_submodulo_descricao VARCHAR(255) DEFAULT NULL,
  PRIMARY KEY (perfil_submodulo_id)
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS tr;

CREATE TABLE tr (
	tr_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	tr_cia INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_dept INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_principal_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_nome VARCHAR(255) DEFAULT NULL,
	tr_numero VARCHAR(255) DEFAULT NULL,
	tr_ano VARCHAR(255) DEFAULT NULL,
	tr_nome_projeto VARCHAR(255) DEFAULT NULL,
	tr_numero_convenio VARCHAR(255) DEFAULT NULL,
	tr_etapa VARCHAR(255) DEFAULT NULL,
	tr_acao VARCHAR(255) DEFAULT NULL,
	tr_siconv INTEGER(10) DEFAULT 0,
	tr_programa VARCHAR(255) DEFAULT NULL,
	tr_funcao VARCHAR(255) DEFAULT NULL,
	tr_un_orcamentaria VARCHAR(255) DEFAULT NULL,
	tr_subfuncao VARCHAR(255) DEFAULT NULL,
	tr_acao_orcamentaria VARCHAR(255) DEFAULT NULL,
	tr_medida VARCHAR(255) DEFAULT NULL,
	tr_tarefa VARCHAR(255) DEFAULT NULL,
	tr_cia_demandante INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_dept_demandante INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_fiscal_titular INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_fiscal_substituto INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_informacao_automatica TINYINT(1) DEFAULT 1,
	tr_planilha_automatica TINYINT(1) DEFAULT 1,
	tr_origem INTEGER(10) DEFAULT 0,
	tr_siag INTEGER(10) DEFAULT 0,
	tr_vistoria INTEGER(10) DEFAULT 0,
	tr_vistoria_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_vistoria_agendamnto INTEGER(10) DEFAULT 0,
	tr_vistoria_dias INTEGER(4) UNSIGNED DEFAULT 0,
	tr_metodologia_acompanhamento INTEGER(10) DEFAULT 0,
	tr_entrega_tipo INTEGER(10) DEFAULT 0,
	tr_emissao_fornecimento INTEGER(10) DEFAULT 0,
	tr_emissao_dias INTEGER(4) UNSIGNED DEFAULT 0,
	tr_entrega_produto INTEGER(10) DEFAULT 0,
	tr_entrega_dias INTEGER(4) UNSIGNED DEFAULT 0,
	tr_entrega_local INTEGER(10) DEFAULT 0,
	tr_entrega_horario VARCHAR(255) DEFAULT NULL,
	tr_entrega_endereco VARCHAR(255) DEFAULT NULL,
	tr_entrega_recebimento INTEGER(10) DEFAULT 0,
	tr_entrega_analise INTEGER(4) UNSIGNED DEFAULT 0,
	tr_entrega_correcao INTEGER(4) UNSIGNED DEFAULT 0,
	tr_vigencia INTEGER(10) DEFAULT 0,
	tr_vigencia_meses INTEGER(4) UNSIGNED DEFAULT 0,
	tr_pagamento INTEGER(10) DEFAULT 0,
	tr_pagamento_parcelas INTEGER(4) UNSIGNED DEFAULT 0,
	tr_garantia_prazo INTEGER(4) UNSIGNED DEFAULT 0,
	tr_garantia INTEGER(10) DEFAULT 0,
	tr_protocolo VARCHAR(255) DEFAULT NULL,
	tr_protocolo_data DATE DEFAULT null,
	tr_aprovado TINYINT(1) DEFAULT 0,
	tr_moeda INTEGER(100) UNSIGNED DEFAULT 1,
	tr_cor VARCHAR(6)  DEFAULT 'FFFFFF',
	tr_acesso INTEGER(100) UNSIGNED DEFAULT 0,
	tr_percentagem DECIMAL(20,5) UNSIGNED DEFAULT 0,
	tr_status INTEGER(10) DEFAULT 0,
	tr_ativo TINYINT(1) DEFAULT 1,
	tr_data DATE DEFAULT NULL,
	tr_modalidade VARCHAR(255) DEFAULT NULL,
	tr_fonte VARCHAR(255) DEFAULT NULL,
	tr_encerramento DATE DEFAULT NULL,
	tr_contrato_vigente VARCHAR(255) DEFAULT NULL,
	tr_contrato_encerramento DATE DEFAULT NULL,
	tr_contrato_ano INTEGER(4) DEFAULT NULL,
	tr_geo TINYINT(1) DEFAULT 0,
	tr_valor DECIMAL(20,5) UNSIGNED DEFAULT 0,
	tr_valor_atual DECIMAL(20,5) UNSIGNED DEFAULT 0,
	PRIMARY KEY (tr_id),
	KEY tr_cia (tr_cia),
	KEY tr_dept (tr_dept),
	KEY tr_responsavel (tr_responsavel),
	KEY tr_cia_demandante (tr_cia_demandante),
	KEY tr_dept_demandante (tr_dept_demandante),
	KEY tr_fiscal_titular (tr_fiscal_titular),
	KEY tr_fiscal_substituto (tr_fiscal_substituto),
	KEY tr_vistoria_usuario (tr_vistoria_usuario),
	KEY tr_principal_indicador (tr_principal_indicador),
	KEY tr_moeda (tr_moeda),
	CONSTRAINT tr_cia FOREIGN KEY (tr_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_dept FOREIGN KEY (tr_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT tr_responsavel FOREIGN KEY (tr_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT tr_cia_demandante FOREIGN KEY (tr_cia_demandante) REFERENCES cias (cia_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT tr_dept_demandante FOREIGN KEY (tr_dept_demandante) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT tr_fiscal_titular FOREIGN KEY (tr_fiscal_titular) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT tr_fiscal_substituto FOREIGN KEY (tr_fiscal_substituto) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT tr_vistoria_usuario FOREIGN KEY (tr_vistoria_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT tr_principal_indicador FOREIGN KEY (tr_principal_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT tr_moeda FOREIGN KEY (tr_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS tr_financeiro;
	
CREATE TABLE tr_financeiro (
	tr_financeiro_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	tr_financeiro_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_financeiro_projeto TEXT,
	tr_financeiro_fonte VARCHAR(255) DEFAULT NULL,
	tr_financeiro_regiao VARCHAR(255) DEFAULT NULL,
	tr_financeiro_classificacao VARCHAR(255) DEFAULT NULL,
	tr_financeiro_valor DECIMAL(20,5) UNSIGNED DEFAULT 0,
	tr_financeiro_ano INTEGER(4) UNSIGNED DEFAULT NULL,
	tr_financeiro_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_financeiro_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (tr_financeiro_id),
	KEY tr_financeiro_tr (tr_financeiro_tr),
	CONSTRAINT tr_financeiro_tr FOREIGN KEY (tr_financeiro_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS tarefa_cia;

CREATE TABLE tarefa_cia (
  tarefa_cia_tarefa INTEGER(100) UNSIGNED NOT NULL,
  tarefa_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (tarefa_cia_tarefa, tarefa_cia_cia),
  KEY tarefa_cia_tarefa (tarefa_cia_tarefa),
  KEY tarefa_cia_cia (tarefa_cia_cia),
  CONSTRAINT tarefa_cia_cia FOREIGN KEY (tarefa_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tarefa_cia_tarefa FOREIGN KEY (tarefa_cia_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_tarefa_cia;

CREATE TABLE baseline_tarefa_cia (
  baseline_id INTEGER(100) UNSIGNED NOT NULL,
  tarefa_cia_tarefa INTEGER(100) UNSIGNED NOT NULL,
  tarefa_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (baseline_id, tarefa_cia_tarefa, tarefa_cia_cia),
  CONSTRAINT baseline_tarefa_cia_fk FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS perspectiva_cia;

CREATE TABLE perspectiva_cia (
  perspectiva_cia_perspectiva INTEGER(100) UNSIGNED NOT NULL,
  perspectiva_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (perspectiva_cia_perspectiva, perspectiva_cia_cia),
  KEY perspectiva_cia_perspectiva (perspectiva_cia_perspectiva),
  KEY perspectiva_cia_cia (perspectiva_cia_cia),
  CONSTRAINT perspectiva_cia_cia FOREIGN KEY (perspectiva_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT perspectiva_cia_perspectiva FOREIGN KEY (perspectiva_cia_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS tema_cia;

CREATE TABLE tema_cia (
  tema_cia_tema INTEGER(100) UNSIGNED NOT NULL,
  tema_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (tema_cia_tema, tema_cia_cia),
  KEY tema_cia_tema (tema_cia_tema),
  KEY tema_cia_cia (tema_cia_cia),
  CONSTRAINT tema_cia_cia FOREIGN KEY (tema_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tema_cia_tema FOREIGN KEY (tema_cia_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS objetivo_cia;

CREATE TABLE objetivo_cia (
  objetivo_cia_objetivo INTEGER(100) UNSIGNED NOT NULL,
  objetivo_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (objetivo_cia_objetivo, objetivo_cia_cia),
  KEY objetivo_cia_objetivo (objetivo_cia_objetivo),
  KEY objetivo_cia_cia (objetivo_cia_cia),
  CONSTRAINT objetivo_cia_cia FOREIGN KEY (objetivo_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT objetivo_cia_objetivo FOREIGN KEY (objetivo_cia_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS fator_cia;

CREATE TABLE fator_cia (
  fator_cia_fator INTEGER(100) UNSIGNED NOT NULL,
  fator_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (fator_cia_fator, fator_cia_cia),
  KEY fator_cia_fator (fator_cia_fator),
  KEY fator_cia_cia (fator_cia_cia),
  CONSTRAINT fator_cia_cia FOREIGN KEY (fator_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT fator_cia_fator FOREIGN KEY (fator_cia_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS me;

CREATE TABLE me (
  me_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  me_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  me_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  me_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  me_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  me_nome VARCHAR(250) DEFAULT NULL,
  me_data DATETIME DEFAULT NULL,
  me_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  me_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  me_cor VARCHAR(6) DEFAULT 'FFFFFF',
  me_oque TEXT,
  me_descricao MEDIUMTEXT,
  me_onde TEXT,
  me_quando TEXT,
  me_como TEXT,
  me_porque TEXT,
  me_quanto TEXT,
  me_quem TEXT,
  me_controle TEXT,
  me_melhorias TEXT,
  me_metodo_aprendizado TEXT,
  me_desde_quando TEXT,
  me_ativo TINYINT(1) DEFAULT 1,
  me_tipo VARCHAR(50) DEFAULT NULL,
  me_percentagem DECIMAL(20,5) UNSIGNED DEFAULT 0,
	me_tipo_pontuacao VARCHAR(40) DEFAULT NULL,
	me_ponto_alvo DECIMAL(20,5) UNSIGNED DEFAULT 0,
	me_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
	me_aprovado TINYINT(1) DEFAULT 0,
  PRIMARY KEY (me_id),
  KEY me_cia (me_cia),
  KEY me_dept (me_dept),
  KEY me_usuario (me_usuario),
  KEY me_indicador (me_indicador),
  KEY me_moeda (me_moeda),
  CONSTRAINT me_cia FOREIGN KEY (me_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT me_usuario FOREIGN KEY (me_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT me_indicador FOREIGN KEY (me_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT me_dept FOREIGN KEY (me_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT me_moeda FOREIGN KEY (me_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS me_cia;

CREATE TABLE me_cia (
  me_cia_me INTEGER(100) UNSIGNED NOT NULL,
  me_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (me_cia_me, me_cia_cia),
  KEY me_cia_me (me_cia_me),
  KEY me_cia_cia (me_cia_cia),
  CONSTRAINT me_cia_cia FOREIGN KEY (me_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT me_cia_me FOREIGN KEY (me_cia_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS me_usuario;

CREATE TABLE me_usuario (
  me_usuario_me INTEGER(100) UNSIGNED NOT NULL,
  me_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (me_usuario_me, me_usuario_usuario),
  KEY me_usuario_me (me_usuario_me),
  KEY me_usuario_usuario (me_usuario_usuario),
  CONSTRAINT me_usuario_me FOREIGN KEY (me_usuario_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT me_usuario_usuario FOREIGN KEY (me_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB;

DROP TABLE IF EXISTS me_dept;

CREATE TABLE me_dept (
  me_dept_me INTEGER(100) UNSIGNED NOT NULL,
  me_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (me_dept_me, me_dept_dept),
  KEY me_dept_me (me_dept_me),
  KEY me_dept_dept (me_dept_dept),
  CONSTRAINT me_dept_me FOREIGN KEY (me_dept_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT me_dept_dept FOREIGN KEY (me_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS estrategia_cia;

CREATE TABLE estrategia_cia (
  estrategia_cia_estrategia INTEGER(100) UNSIGNED NOT NULL,
  estrategia_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (estrategia_cia_estrategia, estrategia_cia_cia),
  KEY estrategia_cia_estrategia (estrategia_cia_estrategia),
  KEY estrategia_cia_cia (estrategia_cia_cia),
  CONSTRAINT estrategia_cia_cia FOREIGN KEY (estrategia_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT estrategia_cia_estrategia FOREIGN KEY (estrategia_cia_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS meta_cia;

CREATE TABLE meta_cia (
  meta_cia_meta INTEGER(100) UNSIGNED NOT NULL,
  meta_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (meta_cia_meta, meta_cia_cia),
  KEY meta_cia_meta (meta_cia_meta),
  KEY meta_cia_cia (meta_cia_cia),
  CONSTRAINT meta_cia_cia FOREIGN KEY (meta_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT meta_cia_meta FOREIGN KEY (meta_cia_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS pratica_cia;

CREATE TABLE pratica_cia (
  pratica_cia_pratica INTEGER(100) UNSIGNED NOT NULL,
  pratica_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (pratica_cia_pratica, pratica_cia_cia),
  KEY pratica_cia_pratica (pratica_cia_pratica),
  KEY pratica_cia_cia (pratica_cia_cia),
  CONSTRAINT pratica_cia_cia FOREIGN KEY (pratica_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT pratica_cia_pratica FOREIGN KEY (pratica_cia_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS indicador_cia;

CREATE TABLE indicador_cia (
  indicador_cia_indicador INTEGER(100) UNSIGNED NOT NULL,
  indicador_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (indicador_cia_indicador, indicador_cia_cia),
  KEY indicador_cia_indicador (indicador_cia_indicador),
  KEY indicador_cia_cia (indicador_cia_cia),
  CONSTRAINT indicador_cia_cia FOREIGN KEY (indicador_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT indicador_cia_indicador FOREIGN KEY (indicador_cia_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS calendario_cia;

CREATE TABLE calendario_cia (
  calendario_cia_calendario INTEGER(100) UNSIGNED NOT NULL,
  calendario_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (calendario_cia_calendario, calendario_cia_cia),
  KEY calendario_cia_calendario (calendario_cia_calendario),
  KEY calendario_cia_cia (calendario_cia_cia),
  CONSTRAINT calendario_cia_cia FOREIGN KEY (calendario_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT calendario_cia_calendario FOREIGN KEY (calendario_cia_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS instrumento_cia;

CREATE TABLE instrumento_cia (
  instrumento_cia_instrumento INTEGER(100) UNSIGNED NOT NULL,
  instrumento_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (instrumento_cia_instrumento, instrumento_cia_cia),
  KEY instrumento_cia_instrumento (instrumento_cia_instrumento),
  KEY instrumento_cia_cia (instrumento_cia_cia),
  CONSTRAINT instrumento_cia_cia FOREIGN KEY (instrumento_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT instrumento_cia_instrumento FOREIGN KEY (instrumento_cia_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS recurso_cia;

CREATE TABLE recurso_cia (
  recurso_cia_recurso INTEGER(100) UNSIGNED NOT NULL,
  recurso_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (recurso_cia_recurso, recurso_cia_cia),
  KEY recurso_cia_recurso (recurso_cia_recurso),
  KEY recurso_cia_cia (recurso_cia_cia),
  CONSTRAINT recurso_cia_cia FOREIGN KEY (recurso_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT recurso_cia_recurso FOREIGN KEY (recurso_cia_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS demanda_cia;

CREATE TABLE demanda_cia (
  demanda_cia_demanda INTEGER(100) UNSIGNED NOT NULL,
  demanda_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (demanda_cia_demanda, demanda_cia_cia),
  KEY demanda_cia_demanda (demanda_cia_demanda),
  KEY demanda_cia_cia (demanda_cia_cia),
  CONSTRAINT demanda_cia_cia FOREIGN KEY (demanda_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT demanda_cia_demanda FOREIGN KEY (demanda_cia_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS licao_cia;

CREATE TABLE licao_cia (
  licao_cia_licao INTEGER(100) UNSIGNED NOT NULL,
  licao_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (licao_cia_licao, licao_cia_cia),
  KEY licao_cia_licao (licao_cia_licao),
  KEY licao_cia_cia (licao_cia_cia),
  CONSTRAINT licao_cia_cia FOREIGN KEY (licao_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT licao_cia_licao FOREIGN KEY (licao_cia_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS evento_cia;

CREATE TABLE evento_cia (
  evento_cia_evento INTEGER(100) UNSIGNED NOT NULL,
  evento_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (evento_cia_evento, evento_cia_cia),
  KEY evento_cia_evento (evento_cia_evento),
  KEY evento_cia_cia (evento_cia_cia),
  CONSTRAINT evento_cia_cia FOREIGN KEY (evento_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT evento_cia_evento FOREIGN KEY (evento_cia_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS evento_usuario;

CREATE TABLE evento_usuario (
  evento_usuario_evento INTEGER(100) UNSIGNED NOT NULL,
  evento_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (evento_usuario_evento, evento_usuario_usuario),
  KEY evento_usuario_evento (evento_usuario_evento),
  KEY evento_usuario_usuario (evento_usuario_usuario),
  CONSTRAINT evento_usuario_evento FOREIGN KEY (evento_usuario_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT evento_usuario_usuario FOREIGN KEY (evento_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB;


DROP TABLE IF EXISTS link_cia;

CREATE TABLE link_cia (
  link_cia_link INTEGER(100) UNSIGNED NOT NULL,
  link_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (link_cia_link, link_cia_cia),
  KEY link_cia_link (link_cia_link),
  KEY link_cia_cia (link_cia_cia),
  CONSTRAINT link_cia_cia FOREIGN KEY (link_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT link_cia_link FOREIGN KEY (link_cia_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS avaliacao_cia;

CREATE TABLE avaliacao_cia (
  avaliacao_cia_avaliacao INTEGER(100) UNSIGNED NOT NULL,
  avaliacao_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (avaliacao_cia_avaliacao, avaliacao_cia_cia),
  KEY avaliacao_cia_avaliacao (avaliacao_cia_avaliacao),
  KEY avaliacao_cia_cia (avaliacao_cia_cia),
  CONSTRAINT avaliacao_cia_cia FOREIGN KEY (avaliacao_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT avaliacao_cia_avaliacao FOREIGN KEY (avaliacao_cia_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS brainstorm_cia;

CREATE TABLE brainstorm_cia (
  brainstorm_cia_brainstorm INTEGER(100) UNSIGNED NOT NULL,
  brainstorm_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (brainstorm_cia_brainstorm, brainstorm_cia_cia),
  KEY brainstorm_cia_brainstorm (brainstorm_cia_brainstorm),
  KEY brainstorm_cia_cia (brainstorm_cia_cia),
  CONSTRAINT brainstorm_cia_cia FOREIGN KEY (brainstorm_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT brainstorm_cia_brainstorm FOREIGN KEY (brainstorm_cia_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS gut_cia;

CREATE TABLE gut_cia (
  gut_cia_gut INTEGER(100) UNSIGNED NOT NULL,
  gut_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (gut_cia_gut, gut_cia_cia),
  KEY gut_cia_gut (gut_cia_gut),
  KEY gut_cia_cia (gut_cia_cia),
  CONSTRAINT gut_cia_cia FOREIGN KEY (gut_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT gut_cia_gut FOREIGN KEY (gut_cia_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS causa_efeito_cia;

CREATE TABLE causa_efeito_cia (
  causa_efeito_cia_causa_efeito INTEGER(100) UNSIGNED NOT NULL,
  causa_efeito_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (causa_efeito_cia_causa_efeito, causa_efeito_cia_cia),
  KEY causa_efeito_cia_causa_efeito (causa_efeito_cia_causa_efeito),
  KEY causa_efeito_cia_cia (causa_efeito_cia_cia),
  CONSTRAINT causa_efeito_cia_cia FOREIGN KEY (causa_efeito_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT causa_efeito_cia_causa_efeito FOREIGN KEY (causa_efeito_cia_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS arquivo_cia;

CREATE TABLE arquivo_cia (
  arquivo_cia_arquivo INTEGER(100) UNSIGNED NOT NULL,
  arquivo_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (arquivo_cia_arquivo, arquivo_cia_cia),
  KEY arquivo_cia_arquivo (arquivo_cia_arquivo),
  KEY arquivo_cia_cia (arquivo_cia_cia),
  CONSTRAINT arquivo_cia_cia FOREIGN KEY (arquivo_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT arquivo_cia_arquivo FOREIGN KEY (arquivo_cia_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS forum_cia;

CREATE TABLE forum_cia (
  forum_cia_forum INTEGER(100) UNSIGNED NOT NULL,
  forum_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (forum_cia_forum, forum_cia_cia),
  KEY forum_cia_forum (forum_cia_forum),
  KEY forum_cia_cia (forum_cia_cia),
  CONSTRAINT forum_cia_cia FOREIGN KEY (forum_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT forum_cia_forum FOREIGN KEY (forum_cia_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS checklist_cia;

CREATE TABLE checklist_cia (
  checklist_cia_checklist INTEGER(100) UNSIGNED NOT NULL,
  checklist_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (checklist_cia_checklist, checklist_cia_cia),
  KEY checklist_cia_checklist (checklist_cia_checklist),
  KEY checklist_cia_cia (checklist_cia_cia),
  CONSTRAINT checklist_cia_cia FOREIGN KEY (checklist_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT checklist_cia_checklist FOREIGN KEY (checklist_cia_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS agenda_cia;

CREATE TABLE agenda_cia (
  agenda_cia_agenda INTEGER(100) UNSIGNED NOT NULL,
  agenda_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (agenda_cia_agenda, agenda_cia_cia),
  KEY agenda_cia_agenda (agenda_cia_agenda),
  KEY agenda_cia_cia (agenda_cia_cia),
  CONSTRAINT agenda_cia_cia FOREIGN KEY (agenda_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT agenda_cia_agenda FOREIGN KEY (agenda_cia_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS pratica_complemento;

CREATE TABLE pratica_complemento (
	pratica_complemento_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pratica_complemento_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_complemento_marcador INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_complemento_ano INTEGER(4) DEFAULT NULL,
  pratica_complemento_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (pratica_complemento_id),
  KEY pratica_complemento_pratica (pratica_complemento_pratica),
  KEY pratica_complemento_marcador (pratica_complemento_marcador),
  CONSTRAINT pratica_complemento_marcador FOREIGN KEY (pratica_complemento_marcador) REFERENCES pratica_marcador (pratica_marcador_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT pratica_complemento_pratica FOREIGN KEY (pratica_complemento_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS pratica_evidencia;

CREATE TABLE pratica_evidencia (
	pratica_evidencia_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pratica_evidencia_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_evidencia_marcador INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_evidencia_ano INTEGER(4) DEFAULT NULL,
  pratica_evidencia_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (pratica_evidencia_id),
  KEY pratica_evidencia_pratica (pratica_evidencia_pratica),
  KEY pratica_evidencia_marcador (pratica_evidencia_marcador),
  CONSTRAINT pratica_evidencia_marcador FOREIGN KEY (pratica_evidencia_marcador) REFERENCES pratica_marcador (pratica_marcador_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT pratica_evidencia_pratica FOREIGN KEY (pratica_evidencia_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS pratica_indicador_complemento;

CREATE TABLE pratica_indicador_complemento (
	pratica_indicador_complemento_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pratica_indicador_complemento_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_complemento_marcador INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_complemento_ano INTEGER(4) DEFAULT NULL,
  pratica_indicador_complemento_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (pratica_indicador_complemento_id),
  KEY pratica_indicador_complemento_indicador (pratica_indicador_complemento_indicador),
  KEY pratica_indicador_complemento_marcador (pratica_indicador_complemento_marcador),
  CONSTRAINT pratica_indicador_complemento_marcador FOREIGN KEY (pratica_indicador_complemento_marcador) REFERENCES pratica_marcador (pratica_marcador_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT pratica_indicador_complemento_indicador FOREIGN KEY (pratica_indicador_complemento_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS pratica_indicador_evidencia;

CREATE TABLE pratica_indicador_evidencia (
	pratica_indicador_evidencia_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pratica_indicador_evidencia_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_evidencia_marcador INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_evidencia_ano INTEGER(4) DEFAULT NULL,
  pratica_indicador_evidencia_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (pratica_indicador_evidencia_id),
  KEY pratica_indicador_evidencia_indicador (pratica_indicador_evidencia_indicador),
  KEY pratica_indicador_evidencia_marcador (pratica_indicador_evidencia_marcador),
  CONSTRAINT pratica_indicador_evidencia_marcador FOREIGN KEY (pratica_indicador_evidencia_marcador) REFERENCES pratica_marcador (pratica_marcador_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT pratica_indicador_evidencia_indicador FOREIGN KEY (pratica_indicador_evidencia_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS tema_perspectiva;

CREATE TABLE tema_perspectiva (
  tema_perspectiva_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  tema_perspectiva_tema INTEGER(100) UNSIGNED DEFAULT NULL,
  tema_perspectiva_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
  tema_perspectiva_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  tema_perspectiva_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (tema_perspectiva_id),
  KEY tema_perspectiva_tema (tema_perspectiva_tema),
  KEY tema_perspectiva_perspectiva (tema_perspectiva_perspectiva),
  CONSTRAINT tema_perspectiva_tema FOREIGN KEY (tema_perspectiva_tema) REFERENCES tema (tema_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT tema_perspectiva_perspectiva FOREIGN KEY (tema_perspectiva_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS objetivo_perspectiva;

CREATE TABLE objetivo_perspectiva (
  objetivo_perspectiva_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  objetivo_perspectiva_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
  objetivo_perspectiva_tema INTEGER(100) UNSIGNED DEFAULT NULL,
  objetivo_perspectiva_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
  objetivo_perspectiva_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  objetivo_perspectiva_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (objetivo_perspectiva_id),
  KEY objetivo_perspectiva_objetivo (objetivo_perspectiva_objetivo),
  KEY objetivo_perspectiva_tema (objetivo_perspectiva_tema),
  KEY objetivo_perspectiva_perspectiva (objetivo_perspectiva_perspectiva),
  CONSTRAINT objetivo_perspectiva_objetivo FOREIGN KEY (objetivo_perspectiva_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT objetivo_perspectiva_tema FOREIGN KEY (objetivo_perspectiva_tema) REFERENCES tema (tema_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT objetivo_perspectiva_perspectiva FOREIGN KEY (objetivo_perspectiva_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS fator_objetivo;

CREATE TABLE fator_objetivo (
  fator_objetivo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  fator_objetivo_fator INTEGER(100) UNSIGNED DEFAULT NULL,
  fator_objetivo_me INTEGER(100) UNSIGNED DEFAULT NULL,
  fator_objetivo_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
  fator_objetivo_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  fator_objetivo_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (fator_objetivo_id),
  KEY fator_objetivo_fator (fator_objetivo_fator),
  KEY fator_objetivo_me (fator_objetivo_me),
  KEY fator_objetivo_objetivo (fator_objetivo_objetivo),
  CONSTRAINT fator_objetivo_fator FOREIGN KEY (fator_objetivo_fator) REFERENCES fator (fator_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT fator_objetivo_me FOREIGN KEY (fator_objetivo_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT fator_objetivo_objetivo FOREIGN KEY (fator_objetivo_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS me_objetivo;

CREATE TABLE me_objetivo (
  me_objetivo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  me_objetivo_me INTEGER(100) UNSIGNED DEFAULT NULL,
  me_objetivo_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
  me_objetivo_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  me_objetivo_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (me_objetivo_id),
  KEY me_objetivo_me (me_objetivo_me),
  KEY me_objetivo_objetivo (me_objetivo_objetivo),
  CONSTRAINT me_objetivo_me FOREIGN KEY (me_objetivo_me) REFERENCES me (me_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT me_objetivo_objetivo FOREIGN KEY (me_objetivo_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS estrategia_fator;

CREATE TABLE estrategia_fator (
  estrategia_fator_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  estrategia_fator_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
  estrategia_fator_fator INTEGER(100) UNSIGNED DEFAULT NULL,
  estrategia_fator_me INTEGER(100) UNSIGNED DEFAULT NULL,
	estrategia_fator_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	estrategia_fator_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	estrategia_fator_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	estrategia_fator_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	estrategia_fator_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (estrategia_fator_id),
	KEY estrategia_fator_estrategia (estrategia_fator_estrategia),
	KEY estrategia_fator_fator (estrategia_fator_fator),
	KEY estrategia_fator_me (estrategia_fator_me),
	KEY estrategia_fator_objetivo (estrategia_fator_objetivo),
	KEY estrategia_fator_tema (estrategia_fator_tema),
	KEY estrategia_fator_perspectiva (estrategia_fator_perspectiva),
	CONSTRAINT estrategia_fator_estrategia FOREIGN KEY (estrategia_fator_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT estrategia_fator_fator FOREIGN KEY (estrategia_fator_fator) REFERENCES fator (fator_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT estrategia_fator_me FOREIGN KEY (estrategia_fator_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT estrategia_fator_objetivo FOREIGN KEY (estrategia_fator_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT estrategia_fator_tema FOREIGN KEY (estrategia_fator_tema) REFERENCES tema (tema_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT estrategia_fator_perspectiva FOREIGN KEY (estrategia_fator_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS plano_gestao_me;

CREATE TABLE plano_gestao_me (
	plano_gestao_me_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  plano_gestao_me_me INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_gestao_me_pg INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_gestao_me_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (plano_gestao_me_id),
  KEY plano_gestao_me_me (plano_gestao_me_me),
  KEY plano_gestao_me_pg (plano_gestao_me_pg),
  CONSTRAINT plano_gestao_me_me FOREIGN KEY (plano_gestao_me_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_gestao_me_pg FOREIGN KEY (plano_gestao_me_pg) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS instrumento_config;

CREATE TABLE instrumento_config (
	instrumento_config_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	instrumento_config_exibe_funcao TINYINT DEFAULT 0,
	instrumento_config_exibe_tipo_parecer TINYINT DEFAULT 0,
	instrumento_config_exibe_linha2 TINYINT DEFAULT 0,
	instrumento_config_linha2_legenda VARCHAR(50)DEFAULT NULL,
	instrumento_config_exibe_linha3 TINYINT DEFAULT 0,
	instrumento_config_linha3_legenda VARCHAR(50)DEFAULT NULL,
	instrumento_config_exibe_linha4 TINYINT DEFAULT 0,
	instrumento_config_linha4_legenda VARCHAR(50)DEFAULT NULL,
	PRIMARY KEY (instrumento_config_id)
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS tr_config;

CREATE TABLE tr_config (
	tr_config_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	tr_config_exibe_funcao TINYINT DEFAULT 0,
	tr_config_exibe_tipo_parecer TINYINT DEFAULT 0,
	tr_config_exibe_linha2 TINYINT DEFAULT 0,
	tr_config_linha2_legenda VARCHAR(50)DEFAULT NULL,
	tr_config_exibe_linha3 TINYINT DEFAULT 0,
	tr_config_linha3_legenda VARCHAR(50)DEFAULT NULL,
	tr_config_exibe_linha4 TINYINT DEFAULT 0,
	tr_config_linha4_legenda VARCHAR(50)DEFAULT NULL,
	PRIMARY KEY (tr_config_id)
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS demanda_config;

CREATE TABLE demanda_config (
	demanda_config_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	demanda_config_exibe_funcao TINYINT DEFAULT 0,
	demanda_config_exibe_tipo_parecer TINYINT DEFAULT 0,
	demanda_config_exibe_linha2 TINYINT DEFAULT 0,
	demanda_config_linha2_legenda VARCHAR(50)DEFAULT NULL,
	demanda_config_exibe_linha3 TINYINT DEFAULT 0,
	demanda_config_linha3_legenda VARCHAR(50)DEFAULT NULL,
	demanda_config_exibe_linha4 TINYINT DEFAULT 0,
	demanda_config_linha4_legenda VARCHAR(50)DEFAULT NULL,
	demanda_config_trava_edicao TINYINT DEFAULT 0,
	demanda_config_diretriz_iniciacao VARCHAR(100)DEFAULT NULL,
	demanda_config_ativo_diretriz_iniciacao TINYINT DEFAULT 1,
	demanda_config_estudo_viabilidade VARCHAR(100)DEFAULT NULL,
	demanda_config_ativo_estudo_viabilidade TINYINT DEFAULT 1,
	demanda_config_diretriz_implantacao VARCHAR(100)DEFAULT NULL,
	demanda_config_ativo_diretriz_implantacao TINYINT DEFAULT 1,
	demanda_config_declaracao_escopo VARCHAR(100)DEFAULT NULL,
	demanda_config_ativo_declaracao_escopo TINYINT DEFAULT 1,
	demanda_config_estrutura_analitica VARCHAR(100)DEFAULT NULL,
	demanda_config_ativo_estrutura_analitica TINYINT DEFAULT 1,
	demanda_config_dicionario_eap VARCHAR(100)DEFAULT NULL,
	demanda_config_ativo_dicionario_eap TINYINT DEFAULT 1,
	demanda_config_cronograma_fisico VARCHAR(100)DEFAULT NULL,
	demanda_config_ativo_cronograma_fisico TINYINT DEFAULT 1,
	demanda_config_plano_projeto VARCHAR(100)DEFAULT NULL,
	demanda_config_ativo_plano_projeto TINYINT DEFAULT 1,
	demanda_config_cronograma VARCHAR(100)DEFAULT NULL,
	demanda_config_ativo_cronograma TINYINT DEFAULT 1,
	demanda_config_planejamento_custo VARCHAR(100)DEFAULT NULL,
	demanda_config_ativo_planejamento_custo TINYINT DEFAULT 1,
	demanda_config_gerenciamento_humanos VARCHAR(100)DEFAULT NULL,
	demanda_config_ativo_gerenciamento_humanos TINYINT DEFAULT 1,
	demanda_config_gerenciamento_comunicacoes VARCHAR(100)DEFAULT NULL,
	demanda_config_ativo_gerenciamento_comunicacoes TINYINT DEFAULT 1,
	demanda_config_gerenciamento_partes VARCHAR(100)DEFAULT NULL,
	demanda_config_ativo_gerenciamento_partes TINYINT DEFAULT 1,
	demanda_config_gerenciamento_riscos VARCHAR(100)DEFAULT NULL,
	demanda_config_ativo_gerenciamento_riscos TINYINT DEFAULT 1,
	demanda_config_gerenciamento_qualidade VARCHAR(100)DEFAULT NULL,
	demanda_config_ativo_gerenciamento_qualidade TINYINT DEFAULT 1,
	demanda_config_gerenciamento_mudanca VARCHAR(100)DEFAULT NULL,
	demanda_config_ativo_gerenciamento_mudanca TINYINT DEFAULT 1,
	demanda_config_controle_mudanca VARCHAR(100)DEFAULT NULL,
	demanda_config_ativo_controle_mudanca TINYINT DEFAULT 1,
	demanda_config_aceite_produtos VARCHAR(100)DEFAULT NULL,
	demanda_config_ativo_aceite_produtos TINYINT DEFAULT 1,
	demanda_config_relatorio_situacao VARCHAR(100)DEFAULT NULL,
	demanda_config_ativo_relatorio_situacao TINYINT DEFAULT 1,
	demanda_config_termo_encerramento VARCHAR(100)DEFAULT NULL,
	demanda_config_ativo_termo_encerramento TINYINT DEFAULT 1,
	PRIMARY KEY (demanda_config_id)
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS mswot;

CREATE TABLE mswot (
  mswot_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  mswot_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  mswot_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  mswot_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  mswot_principal_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  mswot_nome VARCHAR(255),
  mswot_inicio DATE DEFAULT NULL,
  mswot_fim DATE DEFAULT NULL,
  mswot_percentagem DECIMAL(20,5) UNSIGNED DEFAULT 0,
  mswot_oque TEXT,
  mswot_descricao MEDIUMTEXT,
  mswot_onde TEXT,
  mswot_quando TEXT,
  mswot_como TEXT,
  mswot_porque TEXT,
  mswot_quanto TEXT,
  mswot_quem TEXT,
  mswot_controle TEXT,
  mswot_melhorias TEXT,
  mswot_metodo_aprendizado TEXT,
  mswot_desde_quando TEXT,
  mswot_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
  mswot_cor VARCHAR(6) DEFAULT 'FFFFFF',
  mswot_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  mswot_ativo TINYINT(1) DEFAULT 1,
  mswot_aprovado TINYINT(1) DEFAULT 0,
  PRIMARY KEY (mswot_id),
  KEY mswot_cia (mswot_cia),
  KEY mswot_dept (mswot_dept),
  KEY mswot_responsavel (mswot_responsavel),
 	KEY mswot_principal_indicador (mswot_principal_indicador),
 	KEY mswot_moeda (mswot_moeda),
  CONSTRAINT mswot_cia FOREIGN KEY (mswot_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT mswot_dept FOREIGN KEY (mswot_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT mswot_responsavel FOREIGN KEY (mswot_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT mswot_principal_indicador FOREIGN KEY (mswot_principal_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT mswot_moeda FOREIGN KEY (mswot_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS moeda;

CREATE TABLE moeda (
  moeda_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  moeda_nome VARCHAR(255) DEFAULT NULL,
  moeda_simbolo VARCHAR(5) DEFAULT NULL,
  moeda_ativo VARCHAR(5) DEFAULT NULL,
  PRIMARY KEY (moeda_id)
 )ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;
 
 
DROP TABLE IF EXISTS moeda_cotacao;

CREATE TABLE moeda_cotacao (
  moeda_cotacao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
 	moeda_cotacao_moeda INTEGER(100) UNSIGNED DEFAULT NULL,
 	moeda_cotacao_cotacao DECIMAL(6,5) UNSIGNED DEFAULT NULL,
  moeda_cotacao_data DATE DEFAULT NULL, 
  PRIMARY KEY (moeda_cotacao_id),
  KEY moeda_cotacao_moeda (moeda_cotacao_moeda),
  KEY moeda_cotacao_data (moeda_cotacao_data),
  CONSTRAINT moeda_cotacao_moeda FOREIGN KEY (moeda_cotacao_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
 )ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci; 




DROP TABLE IF EXISTS recurso_tarefa;

CREATE TABLE recurso_tarefa (
  recurso_tarefa_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  recurso_tarefa_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_tarefa_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_tarefa_evento INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_tarefa_insercao TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  recurso_tarefa_inicio DATETIME,
  recurso_tarefa_fim DATETIME,
  recurso_tarefa_duracao DECIMAL(20,5) UNSIGNED DEFAULT 0,
  recurso_tarefa_aprovou INTEGER(100)UNSIGNED DEFAULT NULL,
  recurso_tarefa_aprovado TINYINT(1) DEFAULT NULL,
  recurso_tarefa_data DATETIME DEFAULT NULL,
  recurso_tarefa_quantidade DECIMAL(20,5) UNSIGNED DEFAULT 0,
	recurso_tarefa_valor_hora DECIMAL(20,5) UNSIGNED DEFAULT 0,
	recurso_tarefa_custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
	recurso_tarefa_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
	recurso_tarefa_cotacao DECIMAL(6,5) UNSIGNED DEFAULT 1,
	recurso_tarefa_data_moeda DATE DEFAULT NULL,
	recurso_tarefa_codigo VARCHAR(255) DEFAULT NULL,
	recurso_tarefa_fonte VARCHAR(255) DEFAULT NULL,
	recurso_tarefa_regiao VARCHAR(255) DEFAULT NULL,
	recurso_tarefa_bdi DECIMAL(20,5) UNSIGNED DEFAULT 0,
	recurso_tarefa_nd VARCHAR(11) DEFAULT NULL,
  recurso_tarefa_categoria_economica VARCHAR(1) DEFAULT NULL,
  recurso_tarefa_grupo_despesa VARCHAR(1) DEFAULT NULL,
  recurso_tarefa_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  recurso_tarefa_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	recurso_tarefa_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
	recurso_tarefa_obs MEDIUMTEXT,
	recurso_tarefa_corrido TINYINT(1) NOT NULL DEFAULT 0,
  recurso_tarefa_percentual INTEGER UNSIGNED NULL DEFAULT 100,
  recurso_tarefa_ordem INT(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (recurso_tarefa_id),
  KEY recurso_tarefa_recurso (recurso_tarefa_recurso),
  KEY recurso_tarefa_tarefa (recurso_tarefa_tarefa),
  KEY recurso_tarefa_evento (recurso_tarefa_evento),
  KEY recurso_tarefa_aprovou (recurso_tarefa_aprovou),
  CONSTRAINT recurso_tarefa_tarefa FOREIGN KEY (recurso_tarefa_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT recurso_tarefa_recurso FOREIGN KEY (recurso_tarefa_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT recurso_tarefa_evento FOREIGN KEY (recurso_tarefa_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT recurso_tarefa_aprovou FOREIGN KEY (recurso_tarefa_aprovou) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS recurso_tarefa_custo;

CREATE TABLE recurso_tarefa_custo (
  recurso_tarefa_custo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  recurso_tarefa_custo_recurso_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_tarefa_custo_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_tarefa_custo_tipo INTEGER(100) UNSIGNED DEFAULT 1,
  recurso_tarefa_custo_nome VARCHAR(255) DEFAULT NULL,
  recurso_tarefa_custo_codigo VARCHAR(255) DEFAULT NULL,
	recurso_tarefa_custo_fonte VARCHAR(255) DEFAULT NULL,
	recurso_tarefa_custo_regiao VARCHAR(255) DEFAULT NULL,
	recurso_tarefa_custo_bdi DECIMAL(20,5) UNSIGNED DEFAULT 0,
	recurso_tarefa_custo_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
	recurso_tarefa_custo_cotacao DECIMAL(6,5) UNSIGNED DEFAULT 1,
	recurso_tarefa_custo_data_moeda DATE DEFAULT NULL, 	
  recurso_tarefa_custo_data DATETIME DEFAULT NULL,
  recurso_tarefa_custo_quantidade DECIMAL(20,5) UNSIGNED DEFAULT 0,
  recurso_tarefa_custo_valor DECIMAL(20,5) UNSIGNED DEFAULT 0,
  recurso_tarefa_custo_percentagem TINYINT(4) DEFAULT 0,
  recurso_tarefa_custo_descricao MEDIUMTEXT,
  recurso_tarefa_custo_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_tarefa_custo_nd VARCHAR(11) DEFAULT NULL,
  recurso_tarefa_custo_categoria_economica VARCHAR(1) DEFAULT NULL,
  recurso_tarefa_custo_grupo_despesa VARCHAR(1) DEFAULT NULL,
  recurso_tarefa_custo_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  recurso_tarefa_custo_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	recurso_tarefa_custo_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
  recurso_tarefa_custo_data_limite DATE DEFAULT NULL,
  PRIMARY KEY (recurso_tarefa_custo_id),
  KEY recurso_tarefa_custo_recurso_tarefa (recurso_tarefa_custo_recurso_tarefa),
  KEY recurso_tarefa_custo_usuario (recurso_tarefa_custo_usuario),
  KEY recurso_tarefa_custo_ordem (recurso_tarefa_custo_ordem),
  KEY recurso_tarefa_custo_data_inicio (recurso_tarefa_custo_data),
  KEY recurso_tarefa_custo_nome (recurso_tarefa_custo_nome),
  KEY recurso_tarefa_custo_moeda (recurso_tarefa_custo_moeda),
  CONSTRAINT recurso_tarefa_custo_recurso_tarefa FOREIGN KEY (recurso_tarefa_custo_recurso_tarefa) REFERENCES recurso_tarefa (recurso_tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT recurso_tarefa_custo_usuario FOREIGN KEY (recurso_tarefa_custo_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT recurso_tarefa_custo_moeda FOREIGN KEY (recurso_tarefa_custo_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_recurso_tarefa_custo;

CREATE TABLE baseline_recurso_tarefa_custo (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
  recurso_tarefa_custo_id INTEGER(100) UNSIGNED NOT NULL,
  recurso_tarefa_custo_recurso_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_tarefa_custo_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_tarefa_custo_tipo INTEGER(100) UNSIGNED DEFAULT 1,
  recurso_tarefa_custo_nome VARCHAR(255) DEFAULT NULL,
  recurso_tarefa_custo_codigo VARCHAR(255) DEFAULT NULL,
	recurso_tarefa_custo_fonte VARCHAR(255) DEFAULT NULL,
	recurso_tarefa_custo_regiao VARCHAR(255) DEFAULT NULL,
	recurso_tarefa_custo_bdi DECIMAL(20,5) UNSIGNED DEFAULT 0,
	recurso_tarefa_custo_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
	recurso_tarefa_custo_cotacao DECIMAL(6,5) UNSIGNED DEFAULT 1,
	recurso_tarefa_custo_data_moeda DATE DEFAULT NULL, 	
  recurso_tarefa_custo_data DATETIME DEFAULT NULL,
  recurso_tarefa_custo_quantidade DECIMAL(20,5) UNSIGNED DEFAULT 0,
  recurso_tarefa_custo_valor DECIMAL(20,5) UNSIGNED DEFAULT 0,
  recurso_tarefa_custo_percentagem TINYINT(4) DEFAULT 0,
  recurso_tarefa_custo_descricao MEDIUMTEXT,
  recurso_tarefa_custo_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_tarefa_custo_nd VARCHAR(11) DEFAULT NULL,
  recurso_tarefa_custo_categoria_economica VARCHAR(1) DEFAULT NULL,
  recurso_tarefa_custo_grupo_despesa VARCHAR(1) DEFAULT NULL,
  recurso_tarefa_custo_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  recurso_tarefa_custo_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	recurso_tarefa_custo_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
  recurso_tarefa_custo_data_limite DATE DEFAULT NULL,
  PRIMARY KEY (baseline_id, recurso_tarefa_custo_id),
  CONSTRAINT baseline_recurso_tarefa_custo FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS baseline_recurso_tarefa;

CREATE TABLE baseline_recurso_tarefa (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
  recurso_tarefa_id INTEGER(100) UNSIGNED NOT NULL,
  recurso_tarefa_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_tarefa_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_tarefa_evento INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_tarefa_insercao TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  recurso_tarefa_inicio DATETIME,
  recurso_tarefa_fim DATETIME,
  recurso_tarefa_duracao DECIMAL(20,5) UNSIGNED DEFAULT 0,
  recurso_tarefa_aprovou INTEGER(100)UNSIGNED DEFAULT NULL,
  recurso_tarefa_aprovado TINYINT(1) DEFAULT NULL,
  recurso_tarefa_data DATETIME,
  recurso_tarefa_quantidade DECIMAL(20,5) UNSIGNED DEFAULT 0,
	recurso_tarefa_valor_hora DECIMAL(20,5) UNSIGNED DEFAULT 0,
	recurso_tarefa_custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
	recurso_tarefa_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
	recurso_tarefa_cotacao DECIMAL(6,5) UNSIGNED DEFAULT 1,
	recurso_tarefa_data_moeda DATE DEFAULT NULL,
	recurso_tarefa_codigo VARCHAR(255) DEFAULT NULL,
	recurso_tarefa_fonte VARCHAR(255) DEFAULT NULL,
	recurso_tarefa_regiao VARCHAR(255) DEFAULT NULL,
	recurso_tarefa_bdi DECIMAL(20,5) UNSIGNED DEFAULT 0,
	recurso_tarefa_nd VARCHAR(11) DEFAULT NULL,
  recurso_tarefa_categoria_economica VARCHAR(1) DEFAULT NULL,
  recurso_tarefa_grupo_despesa VARCHAR(1) DEFAULT NULL,
  recurso_tarefa_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  recurso_tarefa_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	recurso_tarefa_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
	recurso_tarefa_obs MEDIUMTEXT,
	recurso_tarefa_corrido TINYINT(1) NOT NULL DEFAULT 0,
  recurso_tarefa_percentual INTEGER UNSIGNED NULL DEFAULT 100,
  recurso_tarefa_ordem INT(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (baseline_id, recurso_tarefa_id),
  CONSTRAINT baseline_recurso_tarefa FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS projeto_custo;

CREATE TABLE projeto_custo (
  projeto_custo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  projeto_custo_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_custo_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_custo_nome VARCHAR(255) DEFAULT NULL,
  projeto_custo_codigo VARCHAR(255) DEFAULT NULL,
  projeto_custo_fonte VARCHAR(255) DEFAULT NULL,
  projeto_custo_regiao VARCHAR(255) DEFAULT NULL,
  projeto_custo_tipo INTEGER(100) UNSIGNED DEFAULT 1,
  projeto_custo_data DATETIME DEFAULT NULL,
  projeto_custo_quantidade DECIMAL(20,5) UNSIGNED DEFAULT 0,
  projeto_custo_custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
  projeto_custo_bdi DECIMAL(20,5) UNSIGNED DEFAULT 0,
	projeto_custo_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
	projeto_custo_cotacao DECIMAL(6,5) UNSIGNED DEFAULT 1, 
	projeto_custo_data_moeda DATE DEFAULT NULL,
  projeto_custo_percentagem TINYINT(4) DEFAULT 0,
  projeto_custo_descricao MEDIUMTEXT,
  projeto_custo_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_custo_nd VARCHAR(11) DEFAULT NULL,
  projeto_custo_categoria_economica VARCHAR(1) DEFAULT NULL,
  projeto_custo_grupo_despesa VARCHAR(1) DEFAULT NULL,
  projeto_custo_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  projeto_custo_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_custo_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
	projeto_custo_data_limite DATE DEFAULT NULL,
	projeto_custo_pi VARCHAR(100) DEFAULT NULL,
	projeto_custo_aprovou INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_custo_aprovado TINYINT(1) DEFAULT NULL,
	projeto_custo_data_aprovado DATETIME DEFAULT NULL,
  PRIMARY KEY (projeto_custo_id),
  KEY projeto_custo_projeto (projeto_custo_projeto),
  KEY projeto_custo_usuario_inicio (projeto_custo_usuario),
  KEY projeto_custo_ordem (projeto_custo_ordem),
  KEY projeto_custo_data_inicio (projeto_custo_data),
  KEY projeto_custo_nome (projeto_custo_nome),
  KEY projeto_custo_aprovou (projeto_custo_aprovou),
  KEY projeto_custo_moeda (projeto_custo_moeda),
  CONSTRAINT projeto_custo_usuario FOREIGN KEY (projeto_custo_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT projeto_custo_projeto FOREIGN KEY (projeto_custo_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_custo_aprovou FOREIGN KEY (projeto_custo_aprovou) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT projeto_custo_moeda FOREIGN KEY (projeto_custo_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_projeto_custo;

CREATE TABLE baseline_projeto_custo (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
  projeto_custo_id INTEGER(100) UNSIGNED NOT NULL,
  projeto_custo_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_custo_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_custo_nome VARCHAR(255) DEFAULT NULL,
  projeto_custo_codigo VARCHAR(255) DEFAULT NULL,
  projeto_custo_fonte VARCHAR(255) DEFAULT NULL,
  projeto_custo_regiao VARCHAR(255) DEFAULT NULL,
  projeto_custo_tipo INTEGER(100) UNSIGNED DEFAULT 1,
  projeto_custo_data DATETIME DEFAULT NULL,
  projeto_custo_quantidade DECIMAL(20,5) UNSIGNED DEFAULT 0,
  projeto_custo_custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
  projeto_custo_bdi DECIMAL(20,5) UNSIGNED DEFAULT 0,
	projeto_custo_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
	projeto_custo_cotacao DECIMAL(6,5) UNSIGNED DEFAULT 1, 
	projeto_custo_data_moeda DATE DEFAULT NULL,
  projeto_custo_percentagem TINYINT(4) DEFAULT 0,
  projeto_custo_descricao MEDIUMTEXT,
  projeto_custo_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_custo_nd VARCHAR(11) DEFAULT NULL,
  projeto_custo_categoria_economica VARCHAR(1) DEFAULT NULL,
  projeto_custo_grupo_despesa VARCHAR(1) DEFAULT NULL,
  projeto_custo_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  projeto_custo_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_custo_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
	projeto_custo_data_limite DATE DEFAULT NULL,
	projeto_custo_pi VARCHAR(100) DEFAULT NULL,
	projeto_custo_aprovou INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_custo_aprovado TINYINT(1) DEFAULT NULL,
	projeto_custo_data_aprovado DATETIME DEFAULT NULL,
  PRIMARY KEY (baseline_id, projeto_custo_id),
  CONSTRAINT baseline_projeto_custo FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS beneficio;

CREATE TABLE beneficio (
  beneficio_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  beneficio_programa INTEGER(100) UNSIGNED DEFAULT NULL,
  beneficio_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  beneficio_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  beneficio_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  beneficio_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  beneficio_nome VARCHAR(250) DEFAULT NULL,
  beneficio_data DATETIME DEFAULT NULL,
  beneficio_inicio DATETIME DEFAULT NULL,
	beneficio_fim DATETIME DEFAULT NULL,
	beneficio_duracao DECIMAL(20,5) UNSIGNED DEFAULT 0,
  beneficio_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  beneficio_cor VARCHAR(6) DEFAULT 'FFFFFF',
  beneficio_descricao MEDIUMTEXT,
  beneficio_ativo TINYINT(1) DEFAULT 1,
  beneficio_percentagem DECIMAL(20,5) UNSIGNED DEFAULT 0,
  beneficio_meta DECIMAL(20,5) UNSIGNED DEFAULT 0,
  beneficio_peso DECIMAL(20,5) UNSIGNED DEFAULT 0,
  beneficio_moeda INTEGER(100) UNSIGNED DEFAULT 1,
  beneficio_aprovado TINYINT(1) DEFAULT 0,
  PRIMARY KEY (beneficio_id),
  KEY beneficio_programa (beneficio_programa),
  KEY beneficio_cia (beneficio_cia),
  KEY beneficio_dept (beneficio_dept),
  KEY beneficio_usuario (beneficio_usuario),
  KEY beneficio_indicador (beneficio_indicador),
  KEY beneficio_moeda (beneficio_moeda),
  CONSTRAINT beneficio_programa FOREIGN KEY (beneficio_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT beneficio_cia FOREIGN KEY (beneficio_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT beneficio_usuario FOREIGN KEY (beneficio_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT beneficio_indicador FOREIGN KEY (beneficio_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT beneficio_dept FOREIGN KEY (beneficio_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT beneficio_moeda FOREIGN KEY (beneficio_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS log;

CREATE TABLE log (
  log_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  log_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	log_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	log_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	log_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	log_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	log_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	log_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	log_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	log_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	log_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	log_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	log_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	log_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	log_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	log_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	log_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	log_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	log_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	log_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	log_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	log_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	log_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	log_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	log_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	log_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	log_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	log_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	log_link INTEGER(100) UNSIGNED DEFAULT NULL,
	log_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	log_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	log_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	log_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	log_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	log_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	log_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	log_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	log_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	log_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	log_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	log_template INTEGER(100) UNSIGNED DEFAULT NULL,
	log_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	log_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	log_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	log_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	log_me INTEGER(100) UNSIGNED DEFAULT NULL,
	log_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	log_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	log_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	log_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	log_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	log_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	log_ssti INTEGER(100) UNSIGNED DEFAULT NULL,
	log_laudo INTEGER(100) UNSIGNED DEFAULT NULL,
	log_trelo INTEGER(100) UNSIGNED DEFAULT NULL,
	log_trelo_cartao INTEGER(100) UNSIGNED DEFAULT NULL,
	log_pdcl INTEGER(100) UNSIGNED DEFAULT NULL,
	log_pdcl_item INTEGER(100) UNSIGNED DEFAULT NULL,
	log_os INTEGER(100) UNSIGNED DEFAULT NULL,
  log_criador INTEGER(100) UNSIGNED DEFAULT NULL,
  log_correcao	INTEGER(100) UNSIGNED DEFAULT NULL,
  log_tipo_problema INTEGER(10) DEFAULT 0,
  log_horas DECIMAL(20,5) UNSIGNED DEFAULT 0,
  log_descricao MEDIUMTEXT,
  log_corrigir TINYINT(1) DEFAULT 0,
  log_referencia INTEGER(11) DEFAULT NULL,
  log_nome TEXT,
  log_data DATETIME DEFAULT NULL,
  log_url_relacionada VARCHAR(250) DEFAULT NULL,
  log_custo decimal(20,5) UNSIGNED DEFAULT 0,
	log_nd varchar(11) DEFAULT NULL,
	log_categoria_economica varchar(1) DEFAULT NULL,
	log_grupo_despesa varchar(1) DEFAULT NULL,
	log_modalidade_aplicacao varchar(2) DEFAULT NULL,
	log_reg_mudanca_inicio datetime DEFAULT NULL,
	log_reg_mudanca_fim datetime DEFAULT NULL,
	log_reg_mudanca_duracao decimal(20,5) UNSIGNED DEFAULT NULL,
	log_reg_mudanca_percentagem decimal(20,5) UNSIGNED DEFAULT NULL,
	log_reg_mudanca_realizado decimal(20,5) UNSIGNED DEFAULT NULL,
	log_reg_mudanca_status INTEGER(100) UNSIGNED DEFAULT 0,
	log_reg_mudanca_fase INTEGER(10) UNSIGNED DEFAULT 0,
	log_tipo INTEGER(10) UNSIGNED DEFAULT 0,
	log_aprovou INTEGER(100) UNSIGNED DEFAULT NULL,
	log_aprovado tinyint(1) DEFAULT NULL,
	log_data_aprovado datetime DEFAULT NULL, 
  log_acesso INTEGER(100) DEFAULT 0,
  PRIMARY KEY (log_id),
  KEY log_criador (log_criador),
  KEY log_correcao (log_correcao),
  KEY log_aprovou (log_aprovou),
	KEY log_projeto (log_projeto),
	KEY log_tarefa (log_tarefa),
	KEY log_perspectiva (log_perspectiva),
	KEY log_tema (log_tema),
	KEY log_objetivo (log_objetivo),
	KEY log_estrategia (log_estrategia),
	KEY log_meta (log_meta),
	KEY log_fator (log_fator),
	KEY log_pratica (log_pratica),
	KEY log_indicador (log_indicador),
	KEY log_acao (log_acao),
	KEY log_canvas (log_canvas),
	KEY log_risco (log_risco),
	KEY log_risco_resposta (log_risco_resposta),
	KEY log_calendario (log_calendario),
	KEY log_monitoramento (log_monitoramento),
	KEY log_ata (log_ata),
	KEY log_mswot(log_mswot),
	KEY log_swot(log_swot),
	KEY log_operativo(log_operativo),
	KEY log_instrumento (log_instrumento),
	KEY log_recurso (log_recurso),
	KEY log_problema (log_problema),
	KEY log_demanda (log_demanda),
	KEY log_programa (log_programa),
	KEY log_licao (log_licao),
	KEY log_evento (log_evento),
	KEY log_link (log_link),
	KEY log_avaliacao (log_avaliacao),
	KEY log_tgn (log_tgn),
	KEY log_brainstorm (log_brainstorm),
	KEY log_gut (log_gut),
	KEY log_causa_efeito (log_causa_efeito),
	KEY log_arquivo (log_arquivo),
	KEY log_forum (log_forum),
	KEY log_checklist (log_checklist),
	KEY log_agenda (log_agenda),
	KEY log_agrupamento (log_agrupamento),
	KEY log_patrocinador (log_patrocinador),
	KEY log_template (log_template),
	KEY log_painel (log_painel),
	KEY log_painel_odometro (log_painel_odometro),
	KEY log_painel_composicao (log_painel_composicao),
	KEY log_tr (log_tr),
	KEY log_me (log_me),
	KEY log_acao_item (log_acao_item),
	KEY log_beneficio (log_beneficio),
	KEY log_painel_slideshow (log_painel_slideshow),
	KEY log_projeto_viabilidade (log_projeto_viabilidade),
	KEY log_projeto_abertura (log_projeto_abertura),
	KEY log_plano_gestao (log_plano_gestao),
	KEY log_ssti (log_ssti),
	KEY log_laudo (log_laudo),
	KEY log_trelo (log_trelo),
	KEY log_trelo_cartao (log_trelo_cartao),
	KEY log_pdcl (log_pdcl),
	KEY log_pdcl_item (log_pdcl_item),
	KEY log_os (log_os),
  CONSTRAINT log_projeto FOREIGN KEY (log_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_tarefa FOREIGN KEY (log_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_perspectiva FOREIGN KEY (log_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_tema FOREIGN KEY (log_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_objetivo FOREIGN KEY (log_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_fator FOREIGN KEY (log_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_estrategia FOREIGN KEY (log_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_meta FOREIGN KEY (log_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_pratica FOREIGN KEY (log_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_indicador FOREIGN KEY (log_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_acao FOREIGN KEY (log_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_canvas FOREIGN KEY (log_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_risco FOREIGN KEY (log_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_risco_resposta FOREIGN KEY (log_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_calendario FOREIGN KEY (log_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_monitoramento FOREIGN KEY (log_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_ata FOREIGN KEY (log_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_mswot FOREIGN KEY (log_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_swot FOREIGN KEY (log_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_operativo FOREIGN KEY (log_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_instrumento FOREIGN KEY (log_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_recurso FOREIGN KEY (log_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_problema FOREIGN KEY (log_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_demanda FOREIGN KEY (log_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_programa FOREIGN KEY (log_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_licao FOREIGN KEY (log_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_evento FOREIGN KEY (log_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_link FOREIGN KEY (log_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_avaliacao FOREIGN KEY (log_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_tgn FOREIGN KEY (log_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_brainstorm FOREIGN KEY (log_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_gut FOREIGN KEY (log_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_causa_efeito FOREIGN KEY (log_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_arquivo FOREIGN KEY (log_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_forum FOREIGN KEY (log_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_checklist FOREIGN KEY (log_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_agenda FOREIGN KEY (log_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_agrupamento FOREIGN KEY (log_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_patrocinador FOREIGN KEY (log_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_template FOREIGN KEY (log_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_painel FOREIGN KEY (log_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_painel_odometro FOREIGN KEY (log_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_painel_composicao FOREIGN KEY (log_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_tr FOREIGN KEY (log_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_me FOREIGN KEY (log_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_acao_item FOREIGN KEY (log_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_beneficio FOREIGN KEY (log_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_painel_slideshow FOREIGN KEY (log_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_projeto_viabilidade FOREIGN KEY (log_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_projeto_abertura FOREIGN KEY (log_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_plano_gestao FOREIGN KEY (log_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT log_ssti FOREIGN KEY (log_ssti) REFERENCES ssti (ssti_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT log_laudo FOREIGN KEY (log_laudo) REFERENCES laudo (laudo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT log_trelo FOREIGN KEY (log_trelo) REFERENCES trelo (trelo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT log_trelo_cartao FOREIGN KEY (log_trelo_cartao) REFERENCES trelo_cartao (trelo_cartao_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT log_pdcl FOREIGN KEY (log_pdcl) REFERENCES pdcl (pdcl_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT log_pdcl_item FOREIGN KEY (log_pdcl_item) REFERENCES pdcl_item (pdcl_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT log_os FOREIGN KEY (log_os) REFERENCES os (os_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT log_criador FOREIGN KEY (log_criador) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT log_correcao FOREIGN KEY (log_correcao) REFERENCES log (log_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT log_aprovou FOREIGN KEY (log_aprovou) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS log_arquivo;

CREATE TABLE log_arquivo (
  log_arquivo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  log_arquivo_log INTEGER(100) UNSIGNED DEFAULT NULL,
  log_arquivo_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  log_arquivo_ordem INTEGER(11) DEFAULT 0,
  log_arquivo_endereco VARCHAR(150) DEFAULT NULL,
  log_arquivo_data DATETIME DEFAULT NULL,
  log_arquivo_nome VARCHAR(255) DEFAULT NULL,
  log_arquivo_nome_real VARCHAR(255) DEFAULT NULL,
	log_arquivo_local VARCHAR (255) DEFAULT NULL,
  log_arquivo_tipo VARCHAR(50) DEFAULT NULL,
  log_arquivo_extensao VARCHAR(50) DEFAULT NULL,
  log_arquivo_tamanho INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (log_arquivo_id),
  KEY log_arquivo_log (log_arquivo_log),
  KEY log_arquivo_usuario (log_arquivo_usuario),
  CONSTRAINT log_arquivos_fk FOREIGN KEY (log_arquivo_log) REFERENCES log (log_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT log_arquivo_usuario FOREIGN KEY (log_arquivo_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_log_arquivo;

CREATE TABLE baseline_log_arquivo (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
  log_arquivo_id INTEGER(100) UNSIGNED NOT NULL,
  log_arquivo_log INTEGER(100) UNSIGNED DEFAULT NULL,
  log_arquivo_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  log_arquivo_ordem INTEGER(11) DEFAULT 0,
  log_arquivo_endereco VARCHAR(150) DEFAULT NULL,
  log_arquivo_data DATETIME DEFAULT NULL,
  log_arquivo_nome VARCHAR(255) DEFAULT NULL,
  log_arquivo_nome_real VARCHAR(255) DEFAULT NULL,
	log_arquivo_local VARCHAR (255) DEFAULT NULL,
  log_arquivo_tipo VARCHAR(50) DEFAULT NULL,
  log_arquivo_extensao VARCHAR(50) DEFAULT NULL,
  log_arquivo_tamanho INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (baseline_id, log_arquivo_id),
  CONSTRAINT baseline_log_arquivo FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_log;

CREATE TABLE baseline_log (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
  log_id INTEGER(100) UNSIGNED NOT NULL,
  log_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	log_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	log_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	log_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	log_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	log_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	log_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	log_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	log_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	log_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	log_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	log_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	log_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	log_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	log_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	log_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	log_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	log_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	log_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	log_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	log_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	log_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	log_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	log_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	log_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	log_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	log_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	log_link INTEGER(100) UNSIGNED DEFAULT NULL,
	log_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	log_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	log_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	log_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	log_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	log_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	log_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	log_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	log_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	log_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	log_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	log_template INTEGER(100) UNSIGNED DEFAULT NULL,
	log_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	log_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	log_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	log_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	log_me INTEGER(100) UNSIGNED DEFAULT NULL,
	log_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	log_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	log_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	log_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	log_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	log_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	log_ssti INTEGER(100) UNSIGNED DEFAULT NULL,
	log_laudo INTEGER(100) UNSIGNED DEFAULT NULL,
	log_trelo INTEGER(100) UNSIGNED DEFAULT NULL,
	log_trelo_cartao INTEGER(100) UNSIGNED DEFAULT NULL,
	log_pdcl INTEGER(100) UNSIGNED DEFAULT NULL,
	log_pdcl_item INTEGER(100) UNSIGNED DEFAULT NULL,
	log_os INTEGER(100) UNSIGNED DEFAULT NULL,
  log_criador INTEGER(100) UNSIGNED DEFAULT NULL,
  log_correcao	INTEGER(100) UNSIGNED DEFAULT NULL,
  log_tipo_problema INTEGER(10) DEFAULT 0,
  log_horas DECIMAL(20,5) UNSIGNED DEFAULT 0,
  log_descricao TEXT,
  log_corrigir TINYINT(1) DEFAULT 0,
  log_referencia INTEGER(11) DEFAULT NULL,
  log_nome VARCHAR(200) DEFAULT NULL,
  log_data DATETIME DEFAULT NULL,
  log_url_relacionada VARCHAR(250) DEFAULT NULL,
  log_custo decimal(20,5) UNSIGNED DEFAULT 0,
	log_nd varchar(11) DEFAULT NULL,
	log_categoria_economica varchar(1) DEFAULT NULL,
	log_grupo_despesa varchar(1) DEFAULT NULL,
	log_modalidade_aplicacao varchar(2) DEFAULT NULL,
	log_reg_mudanca_inicio datetime DEFAULT NULL,
	log_reg_mudanca_fim datetime DEFAULT NULL,
	log_reg_mudanca_duracao decimal(20,5) UNSIGNED DEFAULT NULL,
	log_reg_mudanca_percentagem decimal(20,5) UNSIGNED DEFAULT NULL,
	log_reg_mudanca_realizado decimal(20,5) UNSIGNED DEFAULT NULL,
	log_reg_mudanca_status INTEGER(100) UNSIGNED DEFAULT 0,
	log_reg_mudanca_fase INTEGER(10) UNSIGNED DEFAULT 0,
	log_tipo INTEGER(10) UNSIGNED DEFAULT 0,
	log_aprovou INTEGER(100) UNSIGNED DEFAULT NULL,
	log_aprovado tinyint(1) DEFAULT NULL,
	log_data_aprovado datetime DEFAULT NULL, 
  log_acesso INTEGER(100) DEFAULT 0,
  PRIMARY KEY (baseline_id, log_id),
  CONSTRAINT baseline_log FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS patrocinadores;

CREATE TABLE patrocinadores (
  patrocinador_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  patrocinador_nome TEXT,
  patrocinador_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  patrocinador_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  patrocinador_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  patrocinador_descricao MEDIUMTEXT,
  patrocinador_endereco1 VARCHAR(100) DEFAULT '',
  patrocinador_endereco2 VARCHAR(100) DEFAULT '',
  patrocinador_cidade VARCHAR(50) DEFAULT '',
  patrocinador_estado VARCHAR(30) DEFAULT '',
  patrocinador_cep VARCHAR(9) DEFAULT '',
  patrocinador_pais VARCHAR(30) NOT NULL DEFAULT '',
  patrocinador_cpf VARCHAR(14) DEFAULT NULL,
  patrocinador_cnpj VARCHAR(18) DEFAULT NULL,
  patrocinador_email VARCHAR(60) DEFAULT NULL,
  patrocinador_url VARCHAR(255) DEFAULT NULL,
  patrocinador_tel VARCHAR(20) DEFAULT NULL,
  patrocinador_tel2 VARCHAR(20) DEFAULT NULL,
  patrocinador_cel VARCHAR(20) DEFAULT NULL,
  patrocinador_cor VARCHAR(6) DEFAULT 'FFFFFF',
  patrocinador_ativo TINYINT(1) DEFAULT 1,
  patrocinador_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  patrocinador_tipo VARCHAR(50) DEFAULT NULL,
  patrocinador_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
  patrocinador_aprovado TINYINT(1) DEFAULT 0,
  PRIMARY KEY (patrocinador_id),
  KEY patrocinador_cia (patrocinador_cia),
  KEY patrocinador_dept (patrocinador_dept),
  KEY patrocinador_responsavel (patrocinador_responsavel),
  KEY patrocinador_moeda (patrocinador_moeda),
  CONSTRAINT patrocinador_cia FOREIGN KEY (patrocinador_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT patrocinador_responsavel FOREIGN KEY (patrocinador_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT patrocinador_dept FOREIGN KEY (patrocinador_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT patrocinador_moeda FOREIGN KEY (patrocinador_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE 
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS patrocinadores_depts;

CREATE TABLE patrocinadores_depts (
  patrocinador_id INTEGER(100) UNSIGNED NOT NULL,
  dept_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (patrocinador_id, dept_id),
  KEY patrocinador_id (patrocinador_id),
  KEY dept_id (dept_id)
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS patrocinadores_instrumentos;

CREATE TABLE patrocinadores_instrumentos (
  patrocinador_id INTEGER(100) UNSIGNED NOT NULL,
  instrumento_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (patrocinador_id, instrumento_id),
  KEY patrocinador_id (patrocinador_id),
  KEY instrumento_id (instrumento_id)
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS patrocinadores_usuarios;

CREATE TABLE patrocinadores_usuarios (
  patrocinador_id INTEGER(100) UNSIGNED NOT NULL,
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (patrocinador_id, usuario_id),
  KEY patrocinador_id (patrocinador_id),
  KEY usuario_id (usuario_id)
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS aviso;

CREATE TABLE aviso (
  aviso_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  aviso_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  aviso_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  aviso_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  aviso_nome VARCHAR(250) DEFAULT NULL,
  aviso_inicio DATE DEFAULT NULL,
  aviso_fim DATE DEFAULT NULL,
  aviso_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  aviso_cor VARCHAR(6) DEFAULT 'FFFFFF',
  aviso_descricao MEDIUMTEXT,
  aviso_ativo TINYINT(1) DEFAULT 1,
  aviso_repetitivo TINYINT(1) DEFAULT 0,
  aviso_aprovado TINYINT(1) DEFAULT 0,
  PRIMARY KEY (aviso_id),
  KEY aviso_cia (aviso_cia),
  KEY aviso_dept (aviso_dept),
  KEY aviso_usuario (aviso_usuario),
  CONSTRAINT aviso_cia FOREIGN KEY (aviso_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT aviso_dept FOREIGN KEY (aviso_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT aviso_usuario FOREIGN KEY (aviso_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS aviso_leitura;

CREATE TABLE aviso_leitura (
	aviso_leitura_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  aviso_leitura_aviso INTEGER(100) UNSIGNED NOT NULL,
  aviso_leitura_usuario INTEGER(100) UNSIGNED NOT NULL,
  aviso_leitura_data DATETIME DEFAULT NULL,
  PRIMARY KEY (aviso_leitura_id),
  KEY aviso_leitura_aviso (aviso_leitura_aviso),
  KEY aviso_leitura_usuario (aviso_leitura_usuario),
  CONSTRAINT aviso_leitura_aviso FOREIGN KEY (aviso_leitura_aviso) REFERENCES aviso (aviso_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT aviso_leitura_usuario FOREIGN KEY (aviso_leitura_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB;

DROP TABLE IF EXISTS aviso_usuario;

CREATE TABLE aviso_usuario (
  aviso_usuario_aviso INTEGER(100) UNSIGNED NOT NULL,
  aviso_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (aviso_usuario_aviso, aviso_usuario_usuario),
  KEY aviso_usuario_aviso (aviso_usuario_aviso),
  KEY aviso_usuario_usuario (aviso_usuario_usuario),
  CONSTRAINT aviso_usuario_aviso FOREIGN KEY (aviso_usuario_aviso) REFERENCES aviso (aviso_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT aviso_usuario_usuario FOREIGN KEY (aviso_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB;


DROP TABLE IF EXISTS aviso_cia;

CREATE TABLE aviso_cia (
  aviso_cia_aviso INTEGER(100) UNSIGNED NOT NULL,
  aviso_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (aviso_cia_aviso, aviso_cia_cia),
  KEY aviso_cia_aviso (aviso_cia_aviso),
  KEY aviso_cia_cia (aviso_cia_cia),
  CONSTRAINT aviso_cia_cia FOREIGN KEY (aviso_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT aviso_cia_aviso FOREIGN KEY (aviso_cia_aviso) REFERENCES aviso (aviso_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS aviso_dept;

CREATE TABLE aviso_dept (
  aviso_dept_aviso INTEGER(100) UNSIGNED NOT NULL,
  aviso_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (aviso_dept_aviso, aviso_dept_dept),
  KEY aviso_dept_aviso (aviso_dept_aviso),
  KEY aviso_dept_dept (aviso_dept_dept),
  CONSTRAINT aviso_dept_aviso FOREIGN KEY (aviso_dept_aviso) REFERENCES aviso (aviso_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT aviso_dept_dept FOREIGN KEY (aviso_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS aviso_para_cia;

CREATE TABLE aviso_para_cia (
  aviso_para_cia_aviso INTEGER(100) UNSIGNED NOT NULL,
  aviso_para_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (aviso_para_cia_aviso, aviso_para_cia_cia),
  KEY aviso_para_cia_aviso (aviso_para_cia_aviso),
  KEY aviso_para_cia_cia (aviso_para_cia_cia),
  CONSTRAINT aviso_para_cia_cia FOREIGN KEY (aviso_para_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT aviso_para_cia_aviso FOREIGN KEY (aviso_para_cia_aviso) REFERENCES aviso (aviso_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS aviso_para_dept;

CREATE TABLE aviso_para_dept (
  aviso_para_dept_aviso INTEGER(100) UNSIGNED NOT NULL,
  aviso_para_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (aviso_para_dept_aviso, aviso_para_dept_dept),
  KEY aviso_para_dept_aviso (aviso_para_dept_aviso),
  KEY aviso_para_dept_dept (aviso_para_dept_dept),
  CONSTRAINT aviso_para_dept_aviso FOREIGN KEY (aviso_para_dept_aviso) REFERENCES aviso (aviso_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT aviso_para_dept_dept FOREIGN KEY (aviso_para_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS tr_campo;

CREATE TABLE tr_campo (
  tr_campo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  tr_campo_tr INTEGER(100) UNSIGNED DEFAULT NULL,
  tr_campo_tipo VARCHAR(50) DEFAULT NULL,
 	tr_campo_texto MEDIUMTEXT,
  PRIMARY KEY (tr_campo_id),
  KEY tr_campo_tr (tr_campo_tr),
  CONSTRAINT tr_campo_tr FOREIGN KEY (tr_campo_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE
 )ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS tr_multiplo;

CREATE TABLE tr_multiplo (
  tr_multiplo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  tr_multiplo_tr INTEGER(100) UNSIGNED DEFAULT NULL,
  tr_multiplo_tipo VARCHAR(50) DEFAULT NULL,
 	tr_multiplo_valor INTEGER(10) UNSIGNED DEFAULT NULL,
 	tr_multiplo_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (tr_multiplo_id),
  KEY tr_multiplo_tr (tr_multiplo_tr),
  CONSTRAINT tr_multiplo_tr FOREIGN KEY (tr_multiplo_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE
 )ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS tr_usuario;

CREATE TABLE tr_usuario (
  tr_usuario_tr INTEGER(100) UNSIGNED NOT NULL,
  tr_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (tr_usuario_tr, tr_usuario_usuario),
  KEY tr_usuario_tr (tr_usuario_tr),
  KEY tr_usuario_usuario (tr_usuario_usuario),
  CONSTRAINT tr_usuario_tr FOREIGN KEY (tr_usuario_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tr_usuario_usuario FOREIGN KEY (tr_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB;

DROP TABLE IF EXISTS tr_dept;

CREATE TABLE tr_dept (
  tr_dept_tr INTEGER(100) UNSIGNED NOT NULL,
  tr_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (tr_dept_tr, tr_dept_dept),
  KEY tr_dept_tr (tr_dept_tr),
  KEY tr_dept_dept (tr_dept_dept),
  CONSTRAINT tr_dept_tr FOREIGN KEY (tr_dept_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tr_dept_dept FOREIGN KEY (tr_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS agrupamento_config;

CREATE TABLE agrupamento_config (
	agrupamento_config_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	agrupamento_config_cia INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_config_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  agrupamento_config_lista VARCHAR(255),
  agrupamento_config_detalhe VARCHAR(255),
  PRIMARY KEY (agrupamento_config_id),
  KEY agrupamento_config_cia (agrupamento_config_cia),
  KEY agrupamento_config_usuario (agrupamento_config_usuario),
  CONSTRAINT agrupamento_config_fk1 FOREIGN KEY (agrupamento_config_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT agrupamento_config_fk2 FOREIGN KEY (agrupamento_config_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB;




DROP TABLE IF EXISTS agrupamento_dept;

CREATE TABLE agrupamento_dept (
  agrupamento_dept_agrupamento INTEGER(100) UNSIGNED NOT NULL,
  agrupamento_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (agrupamento_dept_agrupamento, agrupamento_dept_dept),
  KEY agrupamento_dept_agrupamento (agrupamento_dept_agrupamento),
  KEY agrupamento_dept_dept (agrupamento_dept_dept),
  CONSTRAINT agrupamento_dept_dept FOREIGN KEY (agrupamento_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT agrupamento_dept_agrupamento FOREIGN KEY (agrupamento_dept_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB;


DROP TABLE IF EXISTS agrupamento_usuario;

CREATE TABLE agrupamento_usuario (
	agrupamento_usuario_agrupamento INTEGER(100) UNSIGNED NOT NULL,
	agrupamento_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
	PRIMARY KEY (agrupamento_usuario_agrupamento, agrupamento_usuario_usuario),
	KEY agrupamento_usuario_agrupamento (agrupamento_usuario_agrupamento),
	KEY agrupamento_usuario_usuario (agrupamento_usuario_usuario),
	CONSTRAINT agrupamento_usuario_agrupamento FOREIGN KEY (agrupamento_usuario_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_usuario_usuario FOREIGN KEY (agrupamento_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS agrupamento_projeto;

CREATE TABLE agrupamento_projeto (
	agrupamento_projeto_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  agrupamento_projeto_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
  agrupamento_projeto_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  agrupamento_projeto_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (agrupamento_projeto_id),
  KEY agrupamento_projeto_agrupamento (agrupamento_projeto_agrupamento),
  KEY agrupamento_projeto_projeto (agrupamento_projeto_projeto),
  CONSTRAINT agrupamento_projeto_fk FOREIGN KEY (agrupamento_projeto_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT agrupamento_projeto_fk1 FOREIGN KEY (agrupamento_projeto_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS swot_depts;

CREATE TABLE swot_depts (
  swot_id INTEGER(100) UNSIGNED NOT NULL,
  dept_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (swot_id, dept_id),
  KEY swot_id (swot_id),
  KEY dept_id (dept_id),
  CONSTRAINT swot_depts_fk1 FOREIGN KEY (dept_id) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT swot_depts_fk FOREIGN KEY (swot_id) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS swot_usuarios;

CREATE TABLE swot_usuarios (
  swot_id INTEGER(100) UNSIGNED NOT NULL,
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (swot_id, usuario_id),
  KEY swot_id (swot_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT swot_usuarios_fk1 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT swot_usuarios_fk FOREIGN KEY (swot_id) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS operativo_observacao;

CREATE TABLE operativo_observacao (
  operativo_observacao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  operativo_observacao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
  operativo_observacao_data DATETIME DEFAULT NULL,
  operativo_observacao_texto MEDIUMTEXT,
  operativo_observacao_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  operativo_observacao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (operativo_observacao_id),
  KEY operativo_observacao_operativo (operativo_observacao_operativo),
  KEY operativo_observacao_usuario (operativo_observacao_usuario),
  CONSTRAINT operativo_observacao_fk1 FOREIGN KEY (operativo_observacao_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT operativo_observacao_fk FOREIGN KEY (operativo_observacao_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB;

DROP TABLE IF EXISTS operativo_depts;

CREATE TABLE operativo_depts (
  operativo_id INTEGER(100) UNSIGNED NOT NULL,
  dept_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (operativo_id, dept_id),
  KEY operativo_id (operativo_id),
  KEY dept_id (dept_id),
  CONSTRAINT operativo_depts_fk1 FOREIGN KEY (dept_id) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT operativo_depts_fk FOREIGN KEY (operativo_id) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB;

DROP TABLE IF EXISTS operativo_usuarios;

CREATE TABLE operativo_usuarios (
  operativo_id INTEGER(100) UNSIGNED NOT NULL,
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (operativo_id, usuario_id),
  KEY operativo_id (operativo_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT operativo_usuarios_fk1 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT operativo_usuarios_fk FOREIGN KEY (operativo_id) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB;

DROP TABLE IF EXISTS problema_usuarios;

CREATE TABLE problema_usuarios (
  problema_id INTEGER(100) UNSIGNED NOT NULL,
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  KEY problema_id (problema_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT problema_usuarios_problema FOREIGN KEY (problema_id) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT problema_usuarios_usuario FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB;

DROP TABLE IF EXISTS problema_depts;

CREATE TABLE problema_depts (
  problema_id INTEGER(100) UNSIGNED NOT NULL,
  dept_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (problema_id, dept_id),
  KEY problema_id (problema_id),
  KEY dept_id (dept_id),
  CONSTRAINT problema_depts_fk FOREIGN KEY (problema_id) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT problema_depts_fk1 FOREIGN KEY (dept_id) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS meta_media;

CREATE TABLE meta_media (
	meta_media_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	meta_media_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_media_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_media_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_media_peso DECIMAL(20,5) DEFAULT 0,
	meta_media_ponto DECIMAL(20,5) DEFAULT 0,
	meta_media_tipo VARCHAR(40) DEFAULT NULL,
	meta_media_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	meta_media_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (meta_media_id),
	KEY meta_media_meta (meta_media_meta),
	KEY meta_media_projeto (meta_media_projeto),
	KEY meta_media_acao (meta_media_acao),
	CONSTRAINT meta_media_meta FOREIGN KEY (meta_media_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_media_projeto FOREIGN KEY (meta_media_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT meta_media_acao FOREIGN KEY (meta_media_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE
	)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS perspectiva_media;

CREATE TABLE perspectiva_media (
	perspectiva_media_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	perspectiva_media_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	perspectiva_media_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	perspectiva_media_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	perspectiva_media_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	perspectiva_media_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	perspectiva_media_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	perspectiva_media_peso DECIMAL(20,5) DEFAULT 0,
	perspectiva_media_ponto DECIMAL(20,5) DEFAULT 0,
	perspectiva_media_tipo VARCHAR(40) DEFAULT NULL,
	perspectiva_media_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	perspectiva_media_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (perspectiva_media_id),
	KEY perspectiva_media_perspectiva (perspectiva_media_perspectiva),
	KEY perspectiva_media_tema (perspectiva_media_tema),
	KEY perspectiva_media_objetivo (perspectiva_media_objetivo),
	KEY perspectiva_media_estrategia (perspectiva_media_estrategia),
	KEY perspectiva_media_projeto (perspectiva_media_projeto),
	KEY perspectiva_media_acao (perspectiva_media_acao),
	CONSTRAINT perspectiva_media_perspectiva FOREIGN KEY (perspectiva_media_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT perspectiva_media_tema FOREIGN KEY (perspectiva_media_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT perspectiva_media_objetivo FOREIGN KEY (perspectiva_media_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT perspectiva_media_estrategia FOREIGN KEY (perspectiva_media_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT perspectiva_media_projeto FOREIGN KEY (perspectiva_media_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT perspectiva_media_acao FOREIGN KEY (perspectiva_media_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE
	)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS tema_media;

CREATE TABLE tema_media (
	tema_media_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	tema_media_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	tema_media_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	tema_media_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	tema_media_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	tema_media_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	tema_media_peso DECIMAL(20,5) DEFAULT 0,
	tema_media_ponto DECIMAL(20,5) DEFAULT 0,
	tema_media_tipo VARCHAR(40) DEFAULT NULL,
	tema_media_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	tema_media_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (tema_media_id),
	KEY tema_media_tema (tema_media_tema),
	KEY tema_media_objetivo (tema_media_objetivo),
	KEY tema_media_estrategia (tema_media_estrategia),
	KEY tema_media_projeto (tema_media_projeto),
	KEY tema_media_acao (tema_media_acao),
	CONSTRAINT tema_media_tema FOREIGN KEY (tema_media_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tema_media_objetivo FOREIGN KEY (tema_media_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tema_media_estrategia FOREIGN KEY (tema_media_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tema_media_projeto FOREIGN KEY (tema_media_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tema_media_acao FOREIGN KEY (tema_media_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE
	)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS objetivo_media;

CREATE TABLE objetivo_media (
	objetivo_media_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	objetivo_media_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	objetivo_media_me INTEGER(100) UNSIGNED DEFAULT NULL,
	objetivo_media_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	objetivo_media_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	objetivo_media_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	objetivo_media_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	objetivo_media_peso DECIMAL(20,5) DEFAULT 0,
	objetivo_media_ponto DECIMAL(20,5) DEFAULT 0,
	objetivo_media_tipo VARCHAR(40) DEFAULT NULL,
	objetivo_media_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	objetivo_media_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (objetivo_media_id),
	KEY objetivo_media_objetivo (objetivo_media_objetivo),
	KEY objetivo_media_me (objetivo_media_me),
	KEY objetivo_media_fator (objetivo_media_fator),
	KEY objetivo_media_estrategia (objetivo_media_estrategia),
	KEY objetivo_media_projeto (objetivo_media_projeto),
	KEY objetivo_media_acao (objetivo_media_acao),
	CONSTRAINT objetivo_media_objetivo FOREIGN KEY (objetivo_media_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT objetivo_media_me FOREIGN KEY (objetivo_media_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT objetivo_media_fator FOREIGN KEY (objetivo_media_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT objetivo_media_estrategia FOREIGN KEY (objetivo_media_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT objetivo_media_projeto FOREIGN KEY (objetivo_media_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT objetivo_media_acao FOREIGN KEY (objetivo_media_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE
	)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS me_media;

CREATE TABLE me_media (
	me_media_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	me_media_me INTEGER(100) UNSIGNED DEFAULT NULL,
	me_media_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	me_media_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	me_media_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	me_media_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	me_media_peso DECIMAL(20,5) DEFAULT 0,
	me_media_ponto DECIMAL(20,5) DEFAULT 0,
	me_media_tipo VARCHAR(40) DEFAULT NULL,
	me_media_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	me_media_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (me_media_id),
	KEY me_media_me (me_media_me),
	KEY me_media_fator (me_media_fator),
	KEY me_media_estrategia (me_media_estrategia),
	KEY me_media_projeto (me_media_projeto),
	KEY me_media_acao (me_media_acao),
	CONSTRAINT me_media_me FOREIGN KEY (me_media_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT me_media_fator FOREIGN KEY (me_media_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT me_media_estrategia FOREIGN KEY (me_media_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT me_media_projeto FOREIGN KEY (me_media_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT me_media_acao FOREIGN KEY (me_media_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE
	)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS fator_media;

CREATE TABLE fator_media (
	fator_media_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	fator_media_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	fator_media_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	fator_media_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	fator_media_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	fator_media_peso DECIMAL(20,5) DEFAULT 0,
	fator_media_ponto DECIMAL(20,5) DEFAULT 0,
	fator_media_tipo VARCHAR(40) DEFAULT NULL,
	fator_media_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	fator_media_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (fator_media_id),
	KEY fator_media_fator (fator_media_fator),
	KEY fator_media_estrategia (fator_media_estrategia),
	KEY fator_media_projeto (fator_media_projeto),
	KEY fator_media_acao (fator_media_acao),
	CONSTRAINT fator_media_fator FOREIGN KEY (fator_media_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT fator_media_estrategia FOREIGN KEY (fator_media_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT fator_media_projeto FOREIGN KEY (fator_media_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT fator_media_acao FOREIGN KEY (fator_media_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE
	)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS plano_gestao_media;

CREATE TABLE plano_gestao_media (
	plano_gestao_media_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	plano_gestao_media_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_gestao_media_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_gestao_media_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_gestao_media_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_gestao_media_peso DECIMAL(20,5) DEFAULT 0,
	plano_gestao_media_ponto DECIMAL(20,5) DEFAULT 0,
	plano_gestao_media_tipo VARCHAR(40) DEFAULT NULL,
	plano_gestao_media_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	plano_gestao_media_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (plano_gestao_media_id),
	KEY plano_gestao_media_plano_gestao (plano_gestao_media_plano_gestao),
	KEY plano_gestao_media_perspectiva (plano_gestao_media_perspectiva),
	KEY plano_gestao_media_projeto (plano_gestao_media_projeto),
	KEY plano_gestao_media_acao (plano_gestao_media_acao),
	CONSTRAINT plano_gestao_media_plano_gestao FOREIGN KEY (plano_gestao_media_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_gestao_media_perspectiva FOREIGN KEY (plano_gestao_media_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_gestao_media_projeto FOREIGN KEY (plano_gestao_media_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_gestao_media_acao FOREIGN KEY (plano_gestao_media_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE
	)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS estrategia_media;

CREATE TABLE estrategia_media (
	estrategia_media_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	estrategia_media_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	estrategia_media_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	estrategia_media_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	estrategia_media_peso DECIMAL(20,5) DEFAULT 0,
	estrategia_media_ponto DECIMAL(20,5) DEFAULT 0,
	estrategia_media_tipo VARCHAR(40) DEFAULT NULL,
	estrategia_media_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	estrategia_media_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (estrategia_media_id),
	KEY estrategia_media_estrategia (estrategia_media_estrategia),
	KEY estrategia_media_projeto (estrategia_media_projeto),
	KEY estrategia_media_acao (estrategia_media_acao),
	CONSTRAINT estrategia_media_estrategia FOREIGN KEY (estrategia_media_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT estrategia_media_projeto FOREIGN KEY (estrategia_media_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT estrategia_media_acao FOREIGN KEY (estrategia_media_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE
	)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS risco_media;

CREATE TABLE risco_media (
	risco_media_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	risco_media_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_media_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_media_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_media_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_media_peso DECIMAL(20,5) DEFAULT 0,
	risco_media_ponto DECIMAL(20,5) DEFAULT 0,
	risco_media_tipo VARCHAR(40) DEFAULT NULL,
	risco_media_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_media_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (risco_media_id),
	KEY risco_media_risco (risco_media_risco),
	KEY risco_media_risco_resposta (risco_media_risco_resposta),
	KEY risco_media_projeto (risco_media_projeto),
	KEY risco_media_acao (risco_media_acao),
	CONSTRAINT risco_media_risco FOREIGN KEY (risco_media_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_media_risco_resposta FOREIGN KEY (risco_media_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_media_projeto FOREIGN KEY (risco_media_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_media_acao FOREIGN KEY (risco_media_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE
	)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS risco_resposta_media;

CREATE TABLE risco_resposta_media (
	risco_resposta_media_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	risco_resposta_media_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_media_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_media_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_media_peso DECIMAL(20,5) DEFAULT 0,
	risco_resposta_media_ponto DECIMAL(20,5) DEFAULT 0,
	risco_resposta_media_tipo VARCHAR(40) DEFAULT NULL,
	risco_resposta_media_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	risco_resposta_media_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (risco_resposta_media_id),
	KEY risco_resposta_media_risco_resposta (risco_resposta_media_risco_resposta),
	KEY risco_resposta_media_projeto (risco_resposta_media_projeto),
	KEY risco_resposta_media_acao (risco_resposta_media_acao),
	CONSTRAINT risco_resposta_media_risco_resposta FOREIGN KEY (risco_resposta_media_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_media_projeto FOREIGN KEY (risco_resposta_media_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT risco_resposta_media_acao FOREIGN KEY (risco_resposta_media_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE
	)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS tema_observador;

CREATE TABLE tema_observador (
  tema_observador_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  tema_observador_tema INTEGER(100) UNSIGNED DEFAULT NULL,
  tema_observador_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
  tema_observador_acao VARCHAR(30) DEFAULT 'fisico',
  tema_observador_metodo VARCHAR(255) DEFAULT NULL,
  tema_observador_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (tema_observador_id),
  KEY tema_observador_tema (tema_observador_tema),
  KEY tema_observador_perspectiva (tema_observador_perspectiva),
  CONSTRAINT tema_observador_tema FOREIGN KEY (tema_observador_tema) REFERENCES tema (tema_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT tema_observador_perspectiva FOREIGN KEY (tema_observador_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS perspectiva_observador;

CREATE TABLE perspectiva_observador (
  perspectiva_observador_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  perspectiva_observador_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
  perspectiva_observador_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
  perspectiva_observador_acao VARCHAR(30) DEFAULT 'fisico',
  perspectiva_observador_metodo VARCHAR(255) DEFAULT NULL,
  perspectiva_observador_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (perspectiva_observador_id),
  KEY perspectiva_observador_perspectiva (perspectiva_observador_perspectiva),
  KEY perspectiva_observador_plano_gestao (perspectiva_observador_plano_gestao),
  CONSTRAINT perspectiva_observador_perspectiva FOREIGN KEY (perspectiva_observador_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT perspectiva_observador_plano_gestao FOREIGN KEY (perspectiva_observador_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;	


DROP TABLE IF EXISTS objetivo_observador;

CREATE TABLE objetivo_observador (
  objetivo_observador_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  objetivo_observador_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
  objetivo_observador_tema INTEGER(100) UNSIGNED DEFAULT NULL,
  objetivo_observador_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
  objetivo_observador_acao VARCHAR(30) DEFAULT 'fisico',
  objetivo_observador_metodo VARCHAR(255) DEFAULT NULL,
  objetivo_observador_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (objetivo_observador_id),
  KEY objetivo_observador_objetivo (objetivo_observador_objetivo),
  KEY objetivo_observador_tema (objetivo_observador_tema),
  KEY objetivo_observador_perspectiva (objetivo_observador_perspectiva),
  CONSTRAINT objetivo_observador_objetivo FOREIGN KEY (objetivo_observador_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT objetivo_observador_tema FOREIGN KEY (objetivo_observador_tema) REFERENCES tema (tema_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT objetivo_observador_perspectiva FOREIGN KEY (objetivo_observador_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS fator_observador;

CREATE TABLE fator_observador (
  fator_observador_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  fator_observador_fator INTEGER(100) UNSIGNED DEFAULT NULL,
  fator_observador_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
  fator_observador_me INTEGER(100) UNSIGNED DEFAULT NULL,
  fator_observador_acao VARCHAR(30) DEFAULT 'fisico',
  fator_observador_metodo VARCHAR(255) DEFAULT NULL,
  fator_observador_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (fator_observador_id),
  KEY fator_observador_fator (fator_observador_fator),
  KEY fator_observador_objetivo (fator_observador_objetivo),
  KEY fator_observador_me (fator_observador_me),
  CONSTRAINT fator_observador_fator FOREIGN KEY (fator_observador_fator) REFERENCES fator (fator_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT fator_observador_objetivo FOREIGN KEY (fator_observador_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT fator_observador_me FOREIGN KEY (fator_observador_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS me_observador;

CREATE TABLE me_observador (
  me_observador_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  me_observador_me INTEGER(100) UNSIGNED DEFAULT NULL,
  me_observador_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
  me_observador_acao VARCHAR(30) DEFAULT 'fisico',
  me_observador_metodo VARCHAR(255) DEFAULT NULL,
  me_observador_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (me_observador_id),
  KEY me_observador_me (me_observador_me),
  KEY me_observador_objetivo (me_observador_objetivo),
  CONSTRAINT me_observador_me FOREIGN KEY (me_observador_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT me_observador_objetivo FOREIGN KEY (me_observador_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS estrategia_observador;

CREATE TABLE estrategia_observador (
  estrategia_observador_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  estrategia_observador_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
  estrategia_observador_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
  estrategia_observador_tema INTEGER(100) UNSIGNED DEFAULT NULL,
  estrategia_observador_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
  estrategia_observador_me INTEGER(100) UNSIGNED DEFAULT NULL,
  estrategia_observador_fator INTEGER(100) UNSIGNED DEFAULT NULL,
  estrategia_observador_acao VARCHAR(30) DEFAULT 'fisico',
  estrategia_observador_metodo VARCHAR(255) DEFAULT NULL,
  estrategia_observador_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (estrategia_observador_id),
  KEY estrategia_observador_estrategia (estrategia_observador_estrategia),
  KEY estrategia_observador_perspectiva (estrategia_observador_perspectiva),
  KEY estrategia_observador_tema (estrategia_observador_tema),
  KEY estrategia_observador_objetivo (estrategia_observador_objetivo),
  KEY estrategia_observador_me (estrategia_observador_me),
  KEY estrategia_observador_fator (estrategia_observador_fator),
  CONSTRAINT estrategia_observador_estrategia FOREIGN KEY (estrategia_observador_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT estrategia_observador_perspectiva FOREIGN KEY (estrategia_observador_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT estrategia_observador_tema FOREIGN KEY (estrategia_observador_tema) REFERENCES tema (tema_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT estrategia_observador_objetivo FOREIGN KEY (estrategia_observador_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT estrategia_observador_me FOREIGN KEY (estrategia_observador_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT estrategia_observador_fator FOREIGN KEY (estrategia_observador_fator) REFERENCES fator (fator_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS projeto_observador;

CREATE TABLE projeto_observador (
  projeto_observador_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  projeto_observador_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_observador_portfolio INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_observador_programa INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_observador_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_observador_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_observador_tema INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_observador_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_observador_me INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_observador_fator INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_observador_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_observador_meta INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_observador_risco INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_observador_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_observador_pdcl_item INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_observador_os INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_observador_acao VARCHAR(30) DEFAULT 'fisico',
  projeto_observador_metodo VARCHAR(255) DEFAULT NULL,
  projeto_observador_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (projeto_observador_id),
  KEY projeto_observador_projeto (projeto_observador_projeto),
	KEY projeto_observador_portfolio (projeto_observador_portfolio),
	KEY projeto_observador_programa (projeto_observador_programa),
	KEY projeto_observador_plano_gestao (projeto_observador_plano_gestao),
	KEY projeto_observador_perspectiva (projeto_observador_perspectiva),
	KEY projeto_observador_tema (projeto_observador_tema),
	KEY projeto_observador_objetivo (projeto_observador_objetivo),
	KEY projeto_observador_me (projeto_observador_me),
	KEY projeto_observador_fator (projeto_observador_fator),
	KEY projeto_observador_estrategia (projeto_observador_estrategia),
	KEY projeto_observador_meta (projeto_observador_meta),
	KEY projeto_observador_risco (projeto_observador_risco),
	KEY projeto_observador_risco_resposta (projeto_observador_risco_resposta),
	KEY projeto_observador_pdcl_item (projeto_observador_pdcl_item),
	KEY projeto_observador_os (projeto_observador_os),
	CONSTRAINT projeto_observador_projeto FOREIGN KEY (projeto_observador_projeto) REFERENCES projetos (projeto_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT projeto_observador_portfolio FOREIGN KEY (projeto_observador_portfolio) REFERENCES projetos (projeto_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT projeto_observador_programa FOREIGN KEY (projeto_observador_programa) REFERENCES programa (programa_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT projeto_observador_plano_gestao FOREIGN KEY (projeto_observador_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT projeto_observador_perspectiva FOREIGN KEY (projeto_observador_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT projeto_observador_tema FOREIGN KEY (projeto_observador_tema) REFERENCES tema (tema_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT projeto_observador_objetivo FOREIGN KEY (projeto_observador_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_observador_me FOREIGN KEY (projeto_observador_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_observador_fator FOREIGN KEY (projeto_observador_fator) REFERENCES fator (fator_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT projeto_observador_estrategia FOREIGN KEY (projeto_observador_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_observador_meta FOREIGN KEY (projeto_observador_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_observador_risco FOREIGN KEY (projeto_observador_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_observador_risco_resposta FOREIGN KEY (projeto_observador_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_observador_pdcl_item FOREIGN KEY (projeto_observador_pdcl_item) REFERENCES pdcl_item (pdcl_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_observador_os FOREIGN KEY (projeto_observador_os) REFERENCES os (os_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS plano_acao_observador;

CREATE TABLE plano_acao_observador (
  plano_acao_observador_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  plano_acao_observador_plano_acao INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_observador_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_observador_programa INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_observador_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_observador_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_observador_tema INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_observador_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_observador_me INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_observador_fator INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_observador_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_observador_meta INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_observador_risco INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_observador_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_observador_pdcl_item INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_observador_os INTEGER(100) UNSIGNED DEFAULT NULL,
  plano_acao_observador_acao VARCHAR(30) DEFAULT 'fisico',
  plano_acao_observador_metodo VARCHAR(255) DEFAULT NULL,
  plano_acao_observador_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (plano_acao_observador_id),
  KEY plano_acao_observador_plano_acao (plano_acao_observador_plano_acao),
  KEY plano_acao_observador_projeto (plano_acao_observador_projeto),
	KEY plano_acao_observador_programa (plano_acao_observador_programa),
	KEY plano_acao_observador_plano_gestao (plano_acao_observador_plano_gestao),
	KEY plano_acao_observador_perspectiva (plano_acao_observador_perspectiva),
	KEY plano_acao_observador_tema (plano_acao_observador_tema),
	KEY plano_acao_observador_objetivo (plano_acao_observador_objetivo),
	KEY plano_acao_observador_me (plano_acao_observador_me),
	KEY plano_acao_observador_fator (plano_acao_observador_fator),
	KEY plano_acao_observador_estrategia (plano_acao_observador_estrategia),
	KEY plano_acao_observador_meta (plano_acao_observador_meta),
	KEY plano_acao_observador_risco (plano_acao_observador_risco),
	KEY plano_acao_observador_risco_resposta (plano_acao_observador_risco_resposta),
	KEY plano_acao_observador_pdcl_item (plano_acao_observador_pdcl_item),
	KEY plano_acao_observador_os (plano_acao_observador_os),
	CONSTRAINT plano_acao_observador_projeto FOREIGN KEY (plano_acao_observador_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_observador_plano_acao FOREIGN KEY (plano_acao_observador_plano_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_observador_programa FOREIGN KEY (plano_acao_observador_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_observador_plano_gestao FOREIGN KEY (plano_acao_observador_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT plano_acao_observador_perspectiva FOREIGN KEY (plano_acao_observador_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_observador_tema FOREIGN KEY (plano_acao_observador_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_observador_objetivo FOREIGN KEY (plano_acao_observador_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_observador_me FOREIGN KEY (plano_acao_observador_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_observador_fator FOREIGN KEY (plano_acao_observador_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_acao_observador_estrategia FOREIGN KEY (plano_acao_observador_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT plano_acao_observador_meta FOREIGN KEY (plano_acao_observador_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_observador_risco FOREIGN KEY (plano_acao_observador_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_observador_risco_resposta FOREIGN KEY (plano_acao_observador_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_observador_pdcl_item FOREIGN KEY (plano_acao_observador_pdcl_item) REFERENCES pdcl_item (pdcl_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT plano_acao_observador_os FOREIGN KEY (plano_acao_observador_os) REFERENCES os (os_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS pratica_indicador_externo;

CREATE TABLE pratica_indicador_externo (
  pratica_indicador_externo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pratica_indicador_externo_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_externo_tipo VARCHAR(25) DEFAULT NULL,
  pratica_indicador_externo_tabela VARCHAR(100) DEFAULT NULL,
  pratica_indicador_externo_data VARCHAR(100) DEFAULT NULL,
  pratica_indicador_externo_valor VARCHAR(100) DEFAULT NULL,
  pratica_indicador_externo_chave VARCHAR(100) DEFAULT NULL,
  pratica_indicador_externo_chave_valor VARCHAR(100) DEFAULT NULL,
  pratica_indicador_externo_sql MEDIUMTEXT,
  pratica_indicador_externo_host VARCHAR(100) DEFAULT NULL,
  pratica_indicador_externo_porta VARCHAR(100) DEFAULT NULL,
  pratica_indicador_externo_timeout INTEGER(10) DEFAULT NULL,
  pratica_indicador_externo_usuario VARCHAR(100) DEFAULT NULL,
  pratica_indicador_externo_senha VARCHAR(100) DEFAULT NULL,
  pratica_indicador_externo_base VARCHAR(100) DEFAULT NULL,
  pratica_indicador_externo_charset VARCHAR(50) DEFAULT NULL,
  pratica_indicador_externo_modo VARCHAR(50) DEFAULT NULL,
  pratica_indicador_externo_string_conexao MEDIUMTEXT,
  pratica_indicador_externo_simples SMALLINT(1) DEFAULT 0,
  uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (pratica_indicador_externo_id),
  KEY pratica_indicador_externo_indicador (pratica_indicador_externo_indicador),
  CONSTRAINT pratica_indicador_externo_fk FOREIGN KEY (pratica_indicador_externo_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS meta_observador;

CREATE TABLE meta_observador (
  meta_observador_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  meta_observador_meta INTEGER(100) UNSIGNED DEFAULT NULL,
  meta_observador_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
  meta_observador_tema INTEGER(100) UNSIGNED DEFAULT NULL,
  meta_observador_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
  meta_observador_me INTEGER(100) UNSIGNED DEFAULT NULL,
  meta_observador_fator INTEGER(100) UNSIGNED DEFAULT NULL,
  meta_observador_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
  meta_observador_acao VARCHAR(30) DEFAULT 'fisico',
  meta_observador_metodo VARCHAR(255) DEFAULT NULL,
  meta_observador_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (meta_observador_id),
  KEY meta_observador_meta (meta_observador_meta),
  KEY meta_observador_perspectiva (meta_observador_perspectiva),
  KEY meta_observador_tema (meta_observador_tema),
  KEY meta_observador_objetivo (meta_observador_objetivo),
  KEY meta_observador_me (meta_observador_me),
  KEY meta_observador_fator (meta_observador_fator),
  KEY meta_observador_estrategia (meta_observador_estrategia),
  CONSTRAINT meta_observador_meta FOREIGN KEY (meta_observador_meta) REFERENCES metas (pg_meta_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT meta_observador_perspectiva FOREIGN KEY (meta_observador_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT meta_observador_tema FOREIGN KEY (meta_observador_tema) REFERENCES tema (tema_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT meta_observador_objetivo FOREIGN KEY (meta_observador_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT meta_observador_me FOREIGN KEY (meta_observador_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT meta_observador_fator FOREIGN KEY (meta_observador_fator) REFERENCES fator (fator_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT meta_observador_estrategia FOREIGN KEY (meta_observador_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS risco_resposta_observador;

CREATE TABLE risco_resposta_observador (
  risco_resposta_observador_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	risco_resposta_observador_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
  risco_resposta_observador_risco INTEGER(100) UNSIGNED DEFAULT NULL,
  risco_resposta_observador_acao VARCHAR(30) DEFAULT 'fisico',
  risco_resposta_observador_metodo VARCHAR(255) DEFAULT NULL,
  risco_resposta_observador_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (risco_resposta_observador_id),
 	KEY risco_resposta_observador_risco_resposta (risco_resposta_observador_risco_resposta),
 	KEY risco_resposta_observador_risco (risco_resposta_observador_risco),
	CONSTRAINT risco_resposta_observador_risco_resposta FOREIGN KEY (risco_resposta_observador_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT risco_resposta_observador_risco FOREIGN KEY (risco_resposta_observador_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS programa_dept;

CREATE TABLE programa_dept (
  programa_dept_programa INTEGER(100) UNSIGNED NOT NULL,
  programa_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (programa_dept_programa, programa_dept_dept),
  KEY programa_dept_programa (programa_dept_programa),
  KEY programa_dept_dept (programa_dept_dept),
  CONSTRAINT programa_dept_dept FOREIGN KEY (programa_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT programa_dept_programa FOREIGN KEY (programa_dept_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS programa_usuario;

CREATE TABLE programa_usuario (
  programa_usuario_programa INTEGER(100) UNSIGNED NOT NULL,
  programa_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (programa_usuario_programa, programa_usuario_usuario),
  KEY programa_usuario_usuario (programa_usuario_usuario),
  KEY programa_usuario_programa (programa_usuario_programa),
  CONSTRAINT programa_usuario_usuario FOREIGN KEY (programa_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT programa_usuario_programa FOREIGN KEY (programa_usuario_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS programa_stakeholder;

CREATE TABLE programa_stakeholder (
	programa_stakeholder_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	programa_stakeholder_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_stakeholder_contato INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_stakeholder_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_stakeholder_perfil INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_stakeholder_autoridade INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_stakeholder_interesse INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_stakeholder_influencia INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_stakeholder_impacto INTEGER(100) UNSIGNED DEFAULT NULL,
	programa_stakeholder_descricao MEDIUMTEXT,
	PRIMARY KEY (programa_stakeholder_id),
	KEY programa_stakeholder_programa (programa_stakeholder_programa),
	KEY programa_stakeholder_contato (programa_stakeholder_contato),
	CONSTRAINT programa_stakeholder_fk FOREIGN KEY (programa_stakeholder_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT programa_stakeholder_fk1 FOREIGN KEY (programa_stakeholder_contato) REFERENCES contatos (contato_id) ON DELETE CASCADE ON UPDATE CASCADE
	)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;




DROP TABLE IF EXISTS beneficio_dept;

CREATE TABLE beneficio_dept (
  beneficio_dept_beneficio INTEGER(100) UNSIGNED NOT NULL,
  beneficio_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (beneficio_dept_beneficio, beneficio_dept_dept),
  KEY beneficio_dept_beneficio (beneficio_dept_beneficio),
  KEY beneficio_dept_dept (beneficio_dept_dept),
  CONSTRAINT beneficio_dept_dept FOREIGN KEY (beneficio_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT beneficio_dept_beneficio FOREIGN KEY (beneficio_dept_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS beneficio_cia;

CREATE TABLE beneficio_cia (
  beneficio_cia_beneficio INTEGER(100) UNSIGNED NOT NULL,
  beneficio_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (beneficio_cia_beneficio, beneficio_cia_cia),
  KEY beneficio_cia_beneficio (beneficio_cia_beneficio),
  KEY beneficio_cia_cia (beneficio_cia_cia),
  CONSTRAINT beneficio_cia_cia FOREIGN KEY (beneficio_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT beneficio_cia_beneficio FOREIGN KEY (beneficio_cia_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS beneficio_usuario;

CREATE TABLE beneficio_usuario (
  beneficio_usuario_beneficio INTEGER(100) UNSIGNED NOT NULL,
  beneficio_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (beneficio_usuario_beneficio, beneficio_usuario_usuario),
  KEY beneficio_usuario_usuario (beneficio_usuario_usuario),
  KEY beneficio_usuario_beneficio (beneficio_usuario_beneficio),
  CONSTRAINT beneficio_usuario_usuario FOREIGN KEY (beneficio_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT beneficio_usuario_beneficio FOREIGN KEY (beneficio_usuario_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS beneficio_projeto;

CREATE TABLE beneficio_projeto (
	beneficio_projeto_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  beneficio_projeto_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
  beneficio_projeto_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  beneficio_projeto_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  beneficio_projeto_peso DECIMAL(20,5) UNSIGNED DEFAULT 0,
  uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (beneficio_projeto_id),
  KEY beneficio_projeto_beneficio (beneficio_projeto_beneficio),
  KEY beneficio_projeto_projeto (beneficio_projeto_projeto),
  CONSTRAINT beneficio_projeto_beneficio FOREIGN KEY (beneficio_projeto_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT beneficio_projeto_projeto FOREIGN KEY (beneficio_projeto_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS demanda_portfolio;

CREATE TABLE demanda_portfolio (
  demanda_portfolio_pai INTEGER(100) UNSIGNED DEFAULT NULL,
  demanda_portfolio_filho INTEGER(100) UNSIGNED DEFAULT NULL,
  demanda_portfolio_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  uuid VARCHAR(36) DEFAULT NULL,
  KEY demanda_portfolio_pai (demanda_portfolio_pai),
  KEY demanda_portfolio_filho (demanda_portfolio_filho),
  CONSTRAINT demanda_portfolio_fk FOREIGN KEY (demanda_portfolio_pai) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT demanda_portfolio_fk1 FOREIGN KEY (demanda_portfolio_filho) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS demanda_custo;

CREATE TABLE demanda_custo (
  demanda_custo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  demanda_custo_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
  demanda_custo_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  demanda_custo_tr INTEGER(100) UNSIGNED DEFAULT NULL,
  demanda_custo_nome VARCHAR(255) DEFAULT NULL,
  demanda_custo_codigo VARCHAR(255) DEFAULT NULL,
  demanda_custo_fonte VARCHAR(255) DEFAULT NULL,
  demanda_custo_regiao VARCHAR(255) DEFAULT NULL,
  demanda_custo_tipo INTEGER(100) UNSIGNED DEFAULT 1,
  demanda_custo_data DATETIME DEFAULT NULL,
  demanda_custo_quantidade DECIMAL(20,5) UNSIGNED DEFAULT 0,
  demanda_custo_custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
  demanda_custo_bdi DECIMAL(20,5) UNSIGNED DEFAULT 0,
	demanda_custo_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
	demanda_custo_cotacao DECIMAL(6,5) UNSIGNED DEFAULT 1, 
	demanda_custo_data_moeda DATE DEFAULT NULL,
  demanda_custo_percentagem TINYINT(4) DEFAULT 0,
  demanda_custo_descricao MEDIUMTEXT,
  demanda_custo_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  demanda_custo_nd VARCHAR(11) DEFAULT NULL,
  demanda_custo_categoria_economica VARCHAR(1) DEFAULT NULL,
  demanda_custo_grupo_despesa VARCHAR(1) DEFAULT NULL,
  demanda_custo_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  demanda_custo_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_custo_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
	demanda_custo_data_limite DATE DEFAULT NULL,
	demanda_custo_pi VARCHAR(100) DEFAULT NULL,
	demanda_custo_aprovou INTEGER(100) UNSIGNED DEFAULT NULL,
	demanda_custo_aprovado TINYINT(1) DEFAULT NULL,
	demanda_custo_data_aprovado DATETIME DEFAULT NULL,
  PRIMARY KEY (demanda_custo_id),
  KEY demanda_custo_demanda (demanda_custo_demanda),
  KEY demanda_custo_usuario_inicio (demanda_custo_usuario),
  KEY demanda_custo_tr (demanda_custo_tr),
  KEY demanda_custo_ordem (demanda_custo_ordem),
  KEY demanda_custo_data_inicio (demanda_custo_data),
  KEY demanda_custo_nome (demanda_custo_nome),
  KEY demanda_custo_aprovou (demanda_custo_aprovou),
  KEY demanda_custo_moeda (demanda_custo_moeda),
  CONSTRAINT demanda_custo_usuario FOREIGN KEY (demanda_custo_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT demanda_custo_tr FOREIGN KEY (demanda_custo_tr) REFERENCES tr (tr_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT demanda_custo_demanda FOREIGN KEY (demanda_custo_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT demanda_custo_aprovou FOREIGN KEY (demanda_custo_aprovou) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT demanda_custo_moeda FOREIGN KEY (demanda_custo_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS projeto_resumo;

CREATE TABLE projeto_resumo (
	projeto_resumo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	projeto_id INTEGER(100) UNSIGNED DEFAULT NULL,
	nome VARCHAR(255) DEFAULT NULL,
	organizacao VARCHAR(255) DEFAULT NULL,
	indicador VARCHAR(255) DEFAULT NULL,
	codigo VARCHAR(255) DEFAULT NULL,
	setor VARCHAR(255) DEFAULT NULL,
	segmento VARCHAR(255) DEFAULT NULL,
	intervencao VARCHAR(255) DEFAULT NULL,
	tipo_intervencao VARCHAR(255) DEFAULT NULL,
	categoria VARCHAR(255) DEFAULT NULL,
	oque MEDIUMTEXT,
	porque MEDIUMTEXT,
	como MEDIUMTEXT,
	onde MEDIUMTEXT,
	inicio DATETIME DEFAULT NULL,
	termino DATETIME DEFAULT NULL,
	termino_atualizado DATETIME DEFAULT NULL,
	gerente VARCHAR(255) DEFAULT NULL,
	supervisor VARCHAR(255) DEFAULT NULL,
	autoridade VARCHAR(255) DEFAULT NULL,
	cliente VARCHAR(255) DEFAULT NULL,
	url VARCHAR(255) DEFAULT NULL,
	www VARCHAR(255) DEFAULT NULL,
	custo_inicial DECIMAL(20,5) UNSIGNED DEFAULT 0,
	custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
	gasto DECIMAL(20,5) UNSIGNED DEFAULT 0,
	gasto_mo DECIMAL(20,5) UNSIGNED DEFAULT 0,
	estimado_mo DECIMAL(20,5) UNSIGNED DEFAULT 0,
	estimado_total_mo DECIMAL(20,5) UNSIGNED DEFAULT 0,
	estimado_recurso DECIMAL(20,5) UNSIGNED DEFAULT 0,
	estimado_total_recurso DECIMAL(20,5) UNSIGNED DEFAULT 0,
	gasto_extra DECIMAL(20,5) UNSIGNED DEFAULT 0,
	custo_previsto DECIMAL(20,5) UNSIGNED DEFAULT 0,
	vel_financeiro DECIMAL(20,5) UNSIGNED DEFAULT 0,
	financeiro_alocado DECIMAL(20,5) UNSIGNED DEFAULT 0,
	total_estimado_hoje DECIMAL(20,5) UNSIGNED DEFAULT 0,
	total_estimado_final DECIMAL(20,5) UNSIGNED DEFAULT 0,
	gasto_total DECIMAL(20,5) UNSIGNED DEFAULT 0,
	status VARCHAR(255) DEFAULT NULL,
	acesso VARCHAR(255) DEFAULT NULL,
	prioridade VARCHAR(255) DEFAULT NULL,
	progresso DECIMAL(20,5) UNSIGNED DEFAULT 0,
	fisico_previsto DECIMAL(20,5) UNSIGNED DEFAULT 0,
	vel_fisico DECIMAL(20,5) UNSIGNED DEFAULT 0,
	ativo VARCHAR(3) DEFAULT NULL,
	horas_trab DECIMAL(20,5) UNSIGNED DEFAULT 0,
	horas_registro DECIMAL(20,5) UNSIGNED DEFAULT 0,
	horas_projeto DECIMAL(20,5) UNSIGNED DEFAULT 0,
	homem_hora DECIMAL(20,5) UNSIGNED DEFAULT 0,
	endereco TEXT,
	latitude VARCHAR(255) DEFAULT NULL,
	observacao MEDIUMTEXT,
	municipio VARCHAR(255),
  PRIMARY KEY (projeto_resumo_id),
  KEY projeto_id (projeto_id),
  CONSTRAINT projeto_id FOREIGN KEY (projeto_id) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS canvas_config;

CREATE TABLE canvas_config (
  canvas_config_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  canvas_config_cor_porque VARCHAR(6) DEFAULT NULL,
  canvas_config_cor_oque VARCHAR(6) DEFAULT NULL,
  canvas_config_cor_quem VARCHAR(6) DEFAULT NULL,
  canvas_config_cor_como VARCHAR(6) DEFAULT NULL,
  canvas_config_cor_quanto VARCHAR(6) DEFAULT NULL,
  PRIMARY KEY (canvas_config_id)
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS canvas_fase;

CREATE TABLE canvas_fase (
	canvas_fase_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  canvas_fase_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_fase_inicio DATETIME DEFAULT NULL,
	canvas_fase_fim DATETIME DEFAULT NULL,
	canvas_fase_duracao DECIMAL(20,5) DEFAULT 0,
	canvas_fase_nr INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_fase_tipo VARCHAR(20) DEFAULT NULL,
	canvas_fase_categoria VARCHAR(20) DEFAULT NULL,
	canvas_fase_usuarios VARCHAR(20) DEFAULT 'todos',
	uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (canvas_fase_id),
  KEY canvas_fase_canvas (canvas_fase_canvas),
  CONSTRAINT canvas_fase_canvas FOREIGN KEY (canvas_fase_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS canvas_cia;

CREATE TABLE canvas_cia (
  canvas_cia_canvas INTEGER(100) UNSIGNED NOT NULL,
  canvas_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (canvas_cia_canvas, canvas_cia_cia),
  KEY canvas_cia_canvas (canvas_cia_canvas),
  KEY canvas_cia_cia (canvas_cia_cia),
  CONSTRAINT canvas_cia_cia FOREIGN KEY (canvas_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT canvas_cia_canvas FOREIGN KEY (canvas_cia_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS canvas_usuario;

CREATE TABLE canvas_usuario (
  canvas_usuario_canvas INTEGER(100) UNSIGNED NOT NULL,
  canvas_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (canvas_usuario_canvas, canvas_usuario_usuario),
  KEY canvas_usuario_canvas (canvas_usuario_canvas),
  KEY canvas_usuario_usuario (canvas_usuario_usuario),
  CONSTRAINT canvas_usuario_usuario FOREIGN KEY (canvas_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT canvas_usuario_canvas FOREIGN KEY (canvas_usuario_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS canvas_ideia;

CREATE TABLE canvas_ideia (
	canvas_ideia_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  canvas_ideia_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
  canvas_ideia_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  canvas_ideia_pai INTEGER(100) UNSIGNED DEFAULT NULL,
  canvas_ideia_categoria VARCHAR(20) DEFAULT NULL,
	canvas_ideia_data DATETIME DEFAULT NULL,
	canvas_ideia_texto MEDIUMTEXT,
	canvas_ideia_extra1 VARCHAR(30),
	canvas_ideia_extra2 VARCHAR(30),
	canvas_ideia_inativa TINYINT(1) DEFAULT 0,
  PRIMARY KEY (canvas_ideia_id),
  KEY canvas_ideia_canvas (canvas_ideia_canvas),
  KEY canvas_ideia_usuario (canvas_ideia_usuario),
  KEY canvas_ideia_pai (canvas_ideia_pai),
  CONSTRAINT canvas_ideia_usuario FOREIGN KEY (canvas_ideia_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT canvas_ideia_canvas FOREIGN KEY (canvas_ideia_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT canvas_ideia_pai FOREIGN KEY (canvas_ideia_pai) REFERENCES canvas_ideia (canvas_ideia_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS canvas_ideia_custo;

CREATE TABLE canvas_ideia_custo (
  canvas_ideia_custo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  canvas_ideia_custo_ideia INTEGER(100) UNSIGNED DEFAULT NULL,
  canvas_ideia_custo_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  canvas_ideia_custo_nome VARCHAR(255) DEFAULT NULL,
  canvas_ideia_custo_codigo VARCHAR(255) DEFAULT NULL,
  canvas_ideia_custo_fonte VARCHAR(255) DEFAULT NULL,
  canvas_ideia_custo_regiao VARCHAR(255) DEFAULT NULL,
  canvas_ideia_custo_tipo INTEGER(100) UNSIGNED DEFAULT 1,
  canvas_ideia_custo_data DATETIME DEFAULT NULL,
  canvas_ideia_custo_quantidade DECIMAL(20,5) UNSIGNED DEFAULT 0,
  canvas_ideia_custo_custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
  canvas_ideia_custo_bdi DECIMAL(20,5) UNSIGNED DEFAULT 0,
  canvas_ideia_custo_moeda INTEGER(100) UNSIGNED DEFAULT 1,
  canvas_ideia_custo_cotacao DECIMAL(6,5) UNSIGNED DEFAULT 1,
  canvas_ideia_custo_data_moeda DATE DEFAULT NULL,
  canvas_ideia_custo_percentagem TINYINT(4) DEFAULT 0,
  canvas_ideia_custo_descricao MEDIUMTEXT,
  canvas_ideia_custo_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  canvas_ideia_custo_nd VARCHAR(11) DEFAULT NULL,
  canvas_ideia_custo_categoria_economica VARCHAR(1) DEFAULT NULL,
  canvas_ideia_custo_grupo_despesa VARCHAR(1) DEFAULT NULL,
  canvas_ideia_custo_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  canvas_ideia_custo_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_ideia_custo_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
	canvas_ideia_custo_data_limite DATE DEFAULT NULL,
	canvas_ideia_custo_pi VARCHAR(100) DEFAULT NULL,
	canvas_ideia_custo_ptres VARCHAR(100) DEFAULT NULL,
	canvas_ideia_custo_aprovou INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_ideia_custo_aprovado TINYINT(1) DEFAULT NULL,
	canvas_ideia_custo_data_aprovado DATETIME DEFAULT NULL,
	canvas_ideia_custo_uuid varchar(36) DEFAULT NULL,
  PRIMARY KEY (canvas_ideia_custo_id),
  KEY canvas_ideia_custo_ideia (canvas_ideia_custo_ideia),
  KEY canvas_ideia_custo_usuario (canvas_ideia_custo_usuario),
  KEY canvas_ideia_custo_ordem (canvas_ideia_custo_ordem),
  KEY canvas_ideia_custo_data (canvas_ideia_custo_data),
  KEY canvas_ideia_custo_nome (canvas_ideia_custo_nome),
  KEY canvas_ideia_custo_aprovou (canvas_ideia_custo_aprovou),
  KEY canvas_ideia_custo_moeda (canvas_ideia_custo_moeda),
  CONSTRAINT canvas_ideia_custo_usuario FOREIGN KEY (canvas_ideia_custo_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT canvas_ideia_custo_ideia FOREIGN KEY (canvas_ideia_custo_ideia) REFERENCES canvas_ideia (canvas_ideia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT canvas_ideia_custo_aprovou FOREIGN KEY (canvas_ideia_custo_aprovou) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT canvas_ideia_custo_moeda FOREIGN KEY (canvas_ideia_custo_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS canvas_ponto;

CREATE TABLE canvas_ponto (
	canvas_ponto_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  canvas_ponto_ideia INTEGER(100) UNSIGNED DEFAULT NULL,
  canvas_ponto_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_ponto_data DATETIME DEFAULT NULL,
	canvas_ponto_ponto INTEGER(10) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (canvas_ponto_id),
  KEY canvas_ponto_ideia (canvas_ponto_ideia),
  KEY canvas_ponto_usuario (canvas_ponto_usuario),
  CONSTRAINT canvas_ponto_usuario FOREIGN KEY (canvas_ponto_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT canvas_ponto_ideia FOREIGN KEY (canvas_ponto_ideia) REFERENCES canvas_ideia (canvas_ideia_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS canvas_comentario;

CREATE TABLE canvas_comentario (
	canvas_comentario_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  canvas_comentario_ideia INTEGER(100) UNSIGNED DEFAULT NULL,
  canvas_comentario_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
	canvas_comentario_data DATETIME DEFAULT NULL,
	canvas_comentario_comentario MEDIUMTEXT,
  PRIMARY KEY (canvas_comentario_id),
  KEY canvas_comentario_ideia (canvas_comentario_ideia),
  KEY canvas_comentario_usuario (canvas_comentario_usuario),
  CONSTRAINT canvas_comentario_usuario FOREIGN KEY (canvas_comentario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT canvas_comentario_ideia FOREIGN KEY (canvas_comentario_ideia) REFERENCES canvas_ideia (canvas_ideia_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;




DROP TABLE IF EXISTS canvas_chat;

CREATE TABLE canvas_chat (
	canvas_chat_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  canvas_chat_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
  canvas_chat_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  canvas_chat_data DATETIME,
  canvas_chat_texto MEDIUMTEXT,
  canvas_chat_administrador TINYINT(1) DEFAULT 0,
  PRIMARY KEY (canvas_chat_id),
  KEY canvas_chat_canvas (canvas_chat_canvas),
  KEY canvas_chat_usuario (canvas_chat_usuario),
  CONSTRAINT canvas_chat_usuario FOREIGN KEY (canvas_chat_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT canvas_chat_canvas FOREIGN KEY (canvas_chat_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS canvas_fase_usuario;

CREATE TABLE canvas_fase_usuario (
  canvas_fase_usuario_fase INTEGER(100) UNSIGNED NOT NULL,
  canvas_fase_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (canvas_fase_usuario_fase, canvas_fase_usuario_usuario),
  KEY canvas_fase_usuario_fase (canvas_fase_usuario_fase),
  KEY canvas_fase_usuario_usuario (canvas_fase_usuario_usuario),
  CONSTRAINT canvas_fase_usuario_usuario FOREIGN KEY (canvas_fase_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT canvas_fase_usuario_fase FOREIGN KEY (canvas_fase_usuario_fase) REFERENCES canvas_fase (canvas_fase_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS tgn_fase;

CREATE TABLE tgn_fase (
	tgn_fase_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  tgn_fase_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_fase_inicio DATETIME DEFAULT NULL,
	tgn_fase_fim DATETIME DEFAULT NULL,
	tgn_fase_duracao DECIMAL(20,5) DEFAULT 0,
	tgn_fase_nr INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_fase_tipo VARCHAR(20) DEFAULT NULL,
	tgn_fase_usuarios VARCHAR(20) DEFAULT 'todos',
	uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (tgn_fase_id),
  KEY tgn_fase_tgn (tgn_fase_tgn),
  CONSTRAINT tgn_fase_tgn FOREIGN KEY (tgn_fase_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS tgn_fase_usuario;

CREATE TABLE tgn_fase_usuario (
  tgn_fase_usuario_fase INTEGER(100) UNSIGNED NOT NULL,
  tgn_fase_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (tgn_fase_usuario_fase, tgn_fase_usuario_usuario),
  KEY tgn_fase_usuario_fase (tgn_fase_usuario_fase),
  KEY tgn_fase_usuario_usuario (tgn_fase_usuario_usuario),
  CONSTRAINT tgn_fase_usuario_usuario FOREIGN KEY (tgn_fase_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tgn_fase_usuario_fase FOREIGN KEY (tgn_fase_usuario_fase) REFERENCES tgn_fase (tgn_fase_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS tgn_cia;

CREATE TABLE tgn_cia (
  tgn_cia_tgn INTEGER(100) UNSIGNED NOT NULL,
  tgn_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (tgn_cia_tgn, tgn_cia_cia),
  KEY tgn_cia_tgn (tgn_cia_tgn),
  KEY tgn_cia_cia (tgn_cia_cia),
  CONSTRAINT tgn_cia_cia FOREIGN KEY (tgn_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tgn_cia_tgn FOREIGN KEY (tgn_cia_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS tgn_dept;

CREATE TABLE tgn_dept (
  tgn_dept_tgn INTEGER(100) UNSIGNED NOT NULL,
  tgn_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (tgn_dept_tgn, tgn_dept_dept),
  KEY tgn_dept_tgn (tgn_dept_tgn),
  KEY tgn_dept_dept (tgn_dept_dept),
  CONSTRAINT tgn_dept_dept FOREIGN KEY (tgn_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tgn_dept_tgn FOREIGN KEY (tgn_dept_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS tgn_usuario;

CREATE TABLE tgn_usuario (
  tgn_usuario_tgn INTEGER(100) UNSIGNED NOT NULL,
  tgn_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (tgn_usuario_tgn, tgn_usuario_usuario),
  KEY tgn_usuario_tgn (tgn_usuario_tgn),
  KEY tgn_usuario_usuario (tgn_usuario_usuario),
  CONSTRAINT tgn_usuario_usuario FOREIGN KEY (tgn_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tgn_usuario_tgn FOREIGN KEY (tgn_usuario_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS tgn_ideia;

CREATE TABLE tgn_ideia (
	tgn_ideia_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  tgn_ideia_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
  tgn_ideia_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_ideia_data DATETIME DEFAULT NULL,
	tgn_ideia_texto MEDIUMTEXT,
	tgn_ideia_inativa TINYINT(1) DEFAULT 0,
  PRIMARY KEY (tgn_ideia_id),
  KEY tgn_ideia_tgn (tgn_ideia_tgn),
  KEY tgn_ideia_usuario (tgn_ideia_usuario),
  CONSTRAINT tgn_ideia_usuario FOREIGN KEY (tgn_ideia_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tgn_ideia_tgn FOREIGN KEY (tgn_ideia_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS tgn_ponto;

CREATE TABLE tgn_ponto (
	tgn_ponto_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  tgn_ponto_ideia INTEGER(100) UNSIGNED DEFAULT NULL,
  tgn_ponto_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_ponto_data DATETIME DEFAULT NULL,
	tgn_ponto_ponto INTEGER(10) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (tgn_ponto_id),
  KEY tgn_ponto_ideia (tgn_ponto_ideia),
  KEY tgn_ponto_usuario (tgn_ponto_usuario),
  CONSTRAINT tgn_ponto_usuario FOREIGN KEY (tgn_ponto_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tgn_ponto_ideia FOREIGN KEY (tgn_ponto_ideia) REFERENCES tgn_ideia (tgn_ideia_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS tgn_comentario;

CREATE TABLE tgn_comentario (
	tgn_comentario_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  tgn_comentario_ideia INTEGER(100) UNSIGNED DEFAULT NULL,
  tgn_comentario_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
	tgn_comentario_data DATETIME DEFAULT NULL,
	tgn_comentario_comentario TEXT,
  PRIMARY KEY (tgn_comentario_id),
  KEY tgn_comentario_ideia (tgn_comentario_ideia),
  KEY tgn_comentario_usuario (tgn_comentario_usuario),
  CONSTRAINT tgn_comentario_usuario FOREIGN KEY (tgn_comentario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tgn_comentario_ideia FOREIGN KEY (tgn_comentario_ideia) REFERENCES tgn_ideia (tgn_ideia_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS tgn_chat;

CREATE TABLE tgn_chat (
	tgn_chat_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  tgn_chat_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
  tgn_chat_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  tgn_chat_data DATETIME,
  tgn_chat_texto MEDIUMTEXT,
  tgn_chat_administrador TINYINT(1) DEFAULT 0,
  PRIMARY KEY (tgn_chat_id),
  KEY tgn_chat_tgn (tgn_chat_tgn),
  KEY tgn_chat_usuario (tgn_chat_usuario),
  CONSTRAINT tgn_chat_usuario FOREIGN KEY (tgn_chat_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tgn_chat_tgn FOREIGN KEY (tgn_chat_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS projeto_portfolio;

CREATE TABLE projeto_portfolio (
  projeto_portfolio_pai INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_portfolio_filho INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_portfolio_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  uuid VARCHAR(36) DEFAULT NULL,
  KEY projeto_portfolio_pai (projeto_portfolio_pai),
  KEY projeto_portfolio_filho (projeto_portfolio_filho),
  CONSTRAINT projeto_portfolio_fk FOREIGN KEY (projeto_portfolio_pai) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_portfolio_fk1 FOREIGN KEY (projeto_portfolio_filho) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS operativo_projeto;

CREATE TABLE operativo_projeto (
	operativo_projeto_id int(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  operativo_projeto_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
  operativo_projeto_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  operativo_projeto_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  operativo_projeto_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY operativo_projeto_id (operativo_projeto_id),
  KEY operativo_projeto_operativo (operativo_projeto_operativo),
  KEY operativo_projeto_projeto (operativo_projeto_projeto),
  CONSTRAINT operativo_projeto_operativo FOREIGN KEY (operativo_projeto_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT operativo_projeto_projeto FOREIGN KEY (operativo_projeto_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS risco_depts;

CREATE TABLE risco_depts (
  risco_id INTEGER(100) UNSIGNED NOT NULL,
  dept_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (risco_id, dept_id),
  KEY risco_id (risco_id),
  KEY dept_id (dept_id),
  CONSTRAINT risco_depts_fk1 FOREIGN KEY (dept_id) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT risco_depts_fk FOREIGN KEY (risco_id) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS risco_usuarios;

CREATE TABLE risco_usuarios (
  risco_id INTEGER(100) UNSIGNED NOT NULL,
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (risco_id, usuario_id),
  KEY risco_id (risco_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT risco_usuarios_fk1 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT risco_usuarios_fk FOREIGN KEY (risco_id) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS risco_matriz;

CREATE TABLE risco_matriz (
  risco_matriz_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  risco_matriz_probabilidade INTEGER(10) UNSIGNED DEFAULT NULL,
  risco_matriz_impacto INTEGER(1) UNSIGNED DEFAULT NULL,
  risco_matriz_gravidade INTEGER(1) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (risco_matriz_id)
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS risco_resposta_depts;

CREATE TABLE risco_resposta_depts (
  risco_resposta_id INTEGER(100) UNSIGNED NOT NULL,
  dept_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (risco_resposta_id, dept_id),
  KEY risco_resposta_id (risco_resposta_id),
  KEY dept_id (dept_id),
  CONSTRAINT risco_resposta_depts_fk1 FOREIGN KEY (dept_id) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT risco_resposta_depts_fk FOREIGN KEY (risco_resposta_id) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS risco_resposta_usuarios;

CREATE TABLE risco_resposta_usuarios (
  risco_resposta_id INTEGER(100) UNSIGNED NOT NULL,
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (risco_resposta_id, usuario_id),
  KEY risco_resposta_id (risco_resposta_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT risco_resposta_usuarios_fk1 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT risco_resposta_usuarios_fk FOREIGN KEY (risco_resposta_id) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS usuario_cha_mod;

CREATE TABLE usuario_cha_mod (
	usuario_cha_mod_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	usuario_cha_mod_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	usuario_cha_mod_nome VARCHAR(255) DEFAULT NULL,
	usuario_cha_mod_tipo VARCHAR(20) DEFAULT NULL,
	usuario_cha_mod_area VARCHAR(20) DEFAULT NULL,
	usuario_cha_mod_descricao MEDIUMTEXT,
	PRIMARY KEY (usuario_cha_mod_id)
	)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS usuario_cha_mod_opcao;

CREATE TABLE usuario_cha_mod_opcao (
	usuario_cha_mod_opcao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	usuario_cha_mod_opcao_modelo INTEGER(100) UNSIGNED DEFAULT NULL,
	usuario_cha_mod_opcao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	usuario_cha_mod_opcao_nome VARCHAR(255) DEFAULT NULL,
	usuario_cha_mod_opcao_valor INTEGER(100) DEFAULT NULL,
	PRIMARY KEY (usuario_cha_mod_opcao_id),
	KEY usuario_cha_mod_opcao_modelo (usuario_cha_mod_opcao_modelo),
	CONSTRAINT usuario_cha_mod_opcao_fk FOREIGN KEY (usuario_cha_mod_opcao_modelo) REFERENCES usuario_cha_mod (usuario_cha_mod_id) ON DELETE CASCADE ON UPDATE CASCADE
	)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS usuario_cha;

CREATE TABLE usuario_cha (
	usuario_cha_usuario INTEGER(100) UNSIGNED NOT NULL,
	usuario_cha_modelo INTEGER(100) UNSIGNED NOT NULL,
	usuario_cha_valor INTEGER(100) DEFAULT NULL,
	PRIMARY KEY (usuario_cha_usuario, usuario_cha_modelo),
	KEY usuario_cha_usuario (usuario_cha_usuario),
	KEY usuario_cha_modelo (usuario_cha_modelo),
	CONSTRAINT usuario_cha_fk1 FOREIGN KEY (usuario_cha_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT usuario_cha_fk2 FOREIGN KEY (usuario_cha_modelo) REFERENCES usuario_cha_mod (usuario_cha_mod_id) ON DELETE CASCADE ON UPDATE CASCADE
	)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS nd;

CREATE TABLE nd (
  nd_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  nd_pai INTEGER(100) UNSIGNED DEFAULT NULL,
  nd_codigo VARCHAR(20) DEFAULT NULL,
  nd_classe INTEGER(1) DEFAULT NULL,
  nd_grupo INTEGER(1) DEFAULT NULL,
  nd_subgrupo INTEGER(1) DEFAULT NULL,
  nd_elemento INTEGER(1) DEFAULT NULL,
  nd_subelemento INTEGER(1) DEFAULT NULL,
  nd_elemento_subelemento VARCHAR(3) DEFAULT NULL,
  nd_item VARCHAR(3) COLLATE latin1_swedish_ci DEFAULT NULL,
  nd_subitem VARCHAR(3) DEFAULT NULL,
  nd_item_subitem VARCHAR(6) DEFAULT NULL,
  nd_texto VARCHAR(80) DEFAULT NULL,
  nd_observacao VARCHAR(80) DEFAULT NULL,
  nd_inicio DATE DEFAULT NULL,
  PRIMARY KEY (nd_id),
  KEY nd_pai (nd_pai),
  CONSTRAINT nd_pai FOREIGN KEY (nd_pai) REFERENCES nd (nd_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET 'latin1' COLLATE 'latin1_swedish_ci';

DROP TABLE IF EXISTS ator;

CREATE TABLE ator (
  ator_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  ator_nome VARCHAR(255) DEFAULT NULL,
  ator_obs TEXT,
  ator_tipo VARCHAR(50) DEFAULT NULL,
	ator_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  ator_cor VARCHAR(6) DEFAULT 'FFFFFF',
  ator_ativo TINYINT(1) DEFAULT 1,
  PRIMARY KEY (ator_id)
)ENGINE=InnoDB  CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS ator_usuario;

CREATE TABLE ator_usuario (
  ator_usuario_ator INTEGER(100) UNSIGNED DEFAULT NULL,
  ator_usuario_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  ator_usuario_uuid VARCHAR(36) DEFAULT NULL,
  KEY ator_usuario_ator (ator_usuario_ator),
  KEY ator_usuario_usuario (ator_usuario_usuario),
  KEY ator_usuario_uuid (ator_usuario_uuid),
  CONSTRAINT ator_usuario_fk1 FOREIGN KEY (ator_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT ator_usuario_fk FOREIGN KEY (ator_usuario_ator) REFERENCES ator (ator_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS ator_cia;

CREATE TABLE ator_cia (
  ator_cia_ator INTEGER(100) UNSIGNED DEFAULT NULL,
  ator_cia_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  ator_cia_uuid VARCHAR(36) DEFAULT NULL,
  KEY ator_cia_ator (ator_cia_ator),
  KEY ator_cia_cia (ator_cia_cia),
  KEY ator_cia_uuid (ator_cia_uuid),
  CONSTRAINT ator_cia_fk FOREIGN KEY (ator_cia_ator) REFERENCES ator (ator_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT ator_cia_fk1 FOREIGN KEY (ator_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS ator_projeto;

CREATE TABLE ator_projeto (
  ator_projeto_ator INTEGER(100) UNSIGNED DEFAULT NULL,
  ator_projeto_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  ator_projeto_uuid VARCHAR(36) DEFAULT NULL,
  KEY ator_projeto_ator (ator_projeto_ator),
  KEY ator_projeto_projeto (ator_projeto_projeto),
  KEY ator_projeto_uuid (ator_projeto_uuid),
  CONSTRAINT ator_projeto_fk FOREIGN KEY (ator_projeto_ator) REFERENCES ator (ator_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT ator_projeto_fk1 FOREIGN KEY (ator_projeto_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS ator_acao;

CREATE TABLE ator_acao (
	ator_acao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  ator_acao_remetente INTEGER(100) UNSIGNED DEFAULT NULL,
  ator_acao_acao_remetente INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (ator_acao_id),
  KEY ator_acao_remetente (ator_acao_remetente),
  CONSTRAINT ator_acao_fk FOREIGN KEY (ator_acao_remetente) REFERENCES ator (ator_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS ator_acao_destinatario;

CREATE TABLE ator_acao_destinatario (
	ator_acao_destinatario_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  ator_acao_destinatario_acao INTEGER(100) UNSIGNED DEFAULT NULL,
  ator_acao_destinatario_ator INTEGER(100) UNSIGNED DEFAULT NULL,
  ator_acao_destinatario_verbo INTEGER(100) UNSIGNED DEFAULT NULL,
  ator_acao_destinatario_tipo_om VARCHAR(30) DEFAULT NULL,
  ator_acao_destinatario_tem_prazo TINYINT(1) DEFAULT 0,
  ator_acao_destinatario_tipo_prazo VARCHAR(30) DEFAULT NULL,
  PRIMARY KEY (ator_acao_destinatario_id),
  KEY ator_acao_destinatario_acao (ator_acao_destinatario_acao),
  KEY ator_acao_destinatario_ator (ator_acao_destinatario_ator),
  KEY ator_acao_destinatario_verbo (ator_acao_destinatario_verbo),
  CONSTRAINT ator_acao_destinatario_fk FOREIGN KEY (ator_acao_destinatario_acao) REFERENCES ator_acao (ator_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT ator_acao_destinatario_fk1 FOREIGN KEY (ator_acao_destinatario_ator) REFERENCES ator (ator_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT ator_acao_destinatario_fk2 FOREIGN KEY (ator_acao_destinatario_verbo) REFERENCES ator_acao_verbo (ator_acao_verbo_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS ator_acao_verbo;

CREATE TABLE ator_acao_verbo (
	ator_acao_verbo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  ator_acao_verbo_acao INTEGER(100) UNSIGNED DEFAULT NULL,
  ator_acao_verbo_texto TEXT,
  ator_acao_verbo_valor VARCHAR(255) DEFAULT NULL,
  PRIMARY KEY (ator_acao_verbo_id),
  KEY ator_acao_verbo_acao (ator_acao_verbo_acao),
  CONSTRAINT ator_acao_verbo_fk FOREIGN KEY (ator_acao_verbo_acao) REFERENCES ator_acao (ator_acao_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS ator_acao_dependencia;

CREATE TABLE ator_acao_dependencia (
	ator_acao_dependencia_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  ator_acao_dependencia_pai INTEGER(100) UNSIGNED DEFAULT NULL,
	ator_acao_dependencia_filho INTEGER(100) UNSIGNED DEFAULT NULL,
  ator_acao_no_grupo TEXT,
  ator_acao_fora_grupo TEXT,
  PRIMARY KEY (ator_acao_dependencia_id),
  KEY ator_acao_dependencia_pai (ator_acao_dependencia_pai),
  CONSTRAINT ator_acao_dependencia_fk FOREIGN KEY (ator_acao_dependencia_pai) REFERENCES ator_acao (ator_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT ator_acao_dependencia_fk1 FOREIGN KEY (ator_acao_dependencia_filho) REFERENCES ator_acao (ator_acao_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS ator_informar_acao;

CREATE TABLE ator_informar_acao (
	ator_informar_acao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  ator_informar_acao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
  ator_informar_acao_ator INTEGER(100) UNSIGNED DEFAULT NULL,
  ator_informar_acao_tipo_om VARCHAR(30) DEFAULT NULL,
  PRIMARY KEY (ator_informar_acao_id),
  KEY ator_informar_acao_acao (ator_informar_acao_acao),
  KEY ator_informar_acao_ator (ator_informar_acao_ator),
  CONSTRAINT ator_informar_acao_fk FOREIGN KEY (ator_informar_acao_acao) REFERENCES ator_acao (ator_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT ator_informar_acao_fk1 FOREIGN KEY (ator_informar_acao_ator) REFERENCES ator (ator_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS indicador_valor_arquivo;

CREATE TABLE indicador_valor_arquivo (
  indicador_valor_arquivo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  indicador_valor_arquivo_indicador_valor INTEGER(100) UNSIGNED DEFAULT NULL,
  indicador_valor_arquivo_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
  indicador_valor_arquivo_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  indicador_valor_arquivo_ordem INTEGER(11) DEFAULT 0,
  indicador_valor_arquivo_endereco VARCHAR(150) DEFAULT NULL,
  indicador_valor_arquivo_data DATETIME DEFAULT NULL,
  indicador_valor_arquivo_nome VARCHAR(150) DEFAULT NULL,
  indicador_valor_arquivo_nome_real VARCHAR(255) DEFAULT NULL,
	indicador_valor_arquivo_local VARCHAR (255) DEFAULT NULL,
	indicador_valor_arquivo_tamanho INTEGER(100) UNSIGNED DEFAULT NULL,
  indicador_valor_arquivo_tipo VARCHAR(50) DEFAULT NULL,
  indicador_valor_arquivo_extensao VARCHAR(50) DEFAULT NULL,
  PRIMARY KEY (indicador_valor_arquivo_id),
  KEY indicador_valor_arquivo_indicador_valor (indicador_valor_arquivo_indicador_valor),
  KEY indicador_valor_arquivo_checklist (indicador_valor_arquivo_checklist),
  KEY indicador_valor_arquivo_usuario (indicador_valor_arquivo_usuario),
  CONSTRAINT indicador_valor_arquivos_fk FOREIGN KEY (indicador_valor_arquivo_indicador_valor) REFERENCES pratica_indicador_valor (pratica_indicador_valor_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT indicador_valor_arquivo_checklist_fk1 FOREIGN KEY (indicador_valor_arquivo_checklist) REFERENCES checklist_dados (checklist_dados_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT indicador_valor_arquivo_usuario FOREIGN KEY (indicador_valor_arquivo_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS pi;

CREATE TABLE pi (
	pi_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	pi_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_link INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_template INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_me INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_ssti INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_laudo INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_trelo INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_trelo_cartao INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_pdcl INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_pdcl_item INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_os INTEGER(100) UNSIGNED DEFAULT NULL,
	pi_pi varchar(11) DEFAULT NULL,
  pi_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  pi_uuid varchar(36) DEFAULT NULL,
	PRIMARY KEY pi_id (pi_id),
	KEY pi_projeto (pi_projeto),
	KEY pi_tarefa (pi_tarefa),
	KEY pi_perspectiva (pi_perspectiva),
	KEY pi_tema (pi_tema),
	KEY pi_objetivo (pi_objetivo),
	KEY pi_estrategia (pi_estrategia),
	KEY pi_meta (pi_meta),
	KEY pi_fator (pi_fator),
	KEY pi_pratica (pi_pratica),
	KEY pi_indicador (pi_indicador),
	KEY pi_acao (pi_acao),
	KEY pi_canvas (pi_canvas),
	KEY pi_risco (pi_risco),
	KEY pi_risco_resposta (pi_risco_resposta),
	KEY pi_calendario (pi_calendario),
	KEY pi_monitoramento (pi_monitoramento),
	KEY pi_ata (pi_ata),
	KEY pi_mswot(pi_mswot),
	KEY pi_swot(pi_swot),
	KEY pi_operativo(pi_operativo),
	KEY pi_instrumento (pi_instrumento),
	KEY pi_recurso (pi_recurso),
	KEY pi_problema (pi_problema),
	KEY pi_demanda (pi_demanda),
	KEY pi_programa (pi_programa),
	KEY pi_licao (pi_licao),
	KEY pi_evento (pi_evento),
	KEY pi_link (pi_link),
	KEY pi_avaliacao (pi_avaliacao),
	KEY pi_tgn (pi_tgn),
	KEY pi_brainstorm (pi_brainstorm),
	KEY pi_gut (pi_gut),
	KEY pi_causa_efeito (pi_causa_efeito),
	KEY pi_arquivo (pi_arquivo),
	KEY pi_forum (pi_forum),
	KEY pi_checklist (pi_checklist),
	KEY pi_agenda (pi_agenda),
	KEY pi_agrupamento (pi_agrupamento),
	KEY pi_patrocinador (pi_patrocinador),
	KEY pi_template (pi_template),
	KEY pi_painel (pi_painel),
	KEY pi_painel_odometro (pi_painel_odometro),
	KEY pi_painel_composicao (pi_painel_composicao),
	KEY pi_tr (pi_tr),
	KEY pi_me (pi_me),
	KEY pi_acao_item (pi_acao_item),
	KEY pi_beneficio (pi_beneficio),
	KEY pi_painel_slideshow (pi_painel_slideshow),
	KEY pi_projeto_viabilidade (pi_projeto_viabilidade),
	KEY pi_projeto_abertura (pi_projeto_abertura),
	KEY pi_plano_gestao (pi_plano_gestao),
	KEY pi_ssti (pi_ssti),
	KEY pi_laudo (pi_laudo),
	KEY pi_trelo (pi_trelo),
	KEY pi_trelo_cartao (pi_trelo_cartao),
	KEY pi_pdcl (pi_pdcl),
	KEY pi_pdcl_item (pi_pdcl_item),
	KEY pi_os (pi_os),
	CONSTRAINT pi_projeto FOREIGN KEY (pi_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_tarefa FOREIGN KEY (pi_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_perspectiva FOREIGN KEY (pi_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_tema FOREIGN KEY (pi_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_objetivo FOREIGN KEY (pi_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_fator FOREIGN KEY (pi_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_estrategia FOREIGN KEY (pi_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_meta FOREIGN KEY (pi_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_pratica FOREIGN KEY (pi_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_indicador FOREIGN KEY (pi_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_acao FOREIGN KEY (pi_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_canvas FOREIGN KEY (pi_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_risco FOREIGN KEY (pi_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_risco_resposta FOREIGN KEY (pi_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_calendario FOREIGN KEY (pi_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_monitoramento FOREIGN KEY (pi_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_ata FOREIGN KEY (pi_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_mswot FOREIGN KEY (pi_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_swot FOREIGN KEY (pi_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_operativo FOREIGN KEY (pi_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_instrumento FOREIGN KEY (pi_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_recurso FOREIGN KEY (pi_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_problema FOREIGN KEY (pi_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_demanda FOREIGN KEY (pi_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_programa FOREIGN KEY (pi_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_licao FOREIGN KEY (pi_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_evento FOREIGN KEY (pi_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_link FOREIGN KEY (pi_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_avaliacao FOREIGN KEY (pi_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_tgn FOREIGN KEY (pi_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_brainstorm FOREIGN KEY (pi_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_gut FOREIGN KEY (pi_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_causa_efeito FOREIGN KEY (pi_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_arquivo FOREIGN KEY (pi_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_forum FOREIGN KEY (pi_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_checklist FOREIGN KEY (pi_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_agenda FOREIGN KEY (pi_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_agrupamento FOREIGN KEY (pi_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_patrocinador FOREIGN KEY (pi_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_template FOREIGN KEY (pi_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_painel FOREIGN KEY (pi_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_painel_odometro FOREIGN KEY (pi_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_painel_composicao FOREIGN KEY (pi_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_tr FOREIGN KEY (pi_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_me FOREIGN KEY (pi_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_acao_item FOREIGN KEY (pi_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_beneficio FOREIGN KEY (pi_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_painel_slideshow FOREIGN KEY (pi_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_projeto_viabilidade FOREIGN KEY (pi_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_projeto_abertura FOREIGN KEY (pi_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_plano_gestao FOREIGN KEY (pi_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT pi_ssti FOREIGN KEY (pi_ssti) REFERENCES ssti (ssti_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT pi_laudo FOREIGN KEY (pi_laudo) REFERENCES laudo (laudo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT pi_trelo FOREIGN KEY (pi_trelo) REFERENCES trelo (trelo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT pi_trelo_cartao FOREIGN KEY (pi_trelo_cartao) REFERENCES trelo_cartao (trelo_cartao_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT pi_pdcl FOREIGN KEY (pi_pdcl) REFERENCES pdcl (pdcl_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT pi_pdcl_item FOREIGN KEY (pi_pdcl_item) REFERENCES pdcl_item (pdcl_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT pi_os FOREIGN KEY (pi_os) REFERENCES os (os_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS ptres;

CREATE TABLE ptres (
	ptres_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	ptres_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_link INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_template INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_me INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_ssti INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_laudo INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_trelo INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_trelo_cartao INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_pdcl INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_pdcl_item INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_os INTEGER(100) UNSIGNED DEFAULT NULL,
	ptres_ptres varchar(11) DEFAULT NULL,
  ptres_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  ptres_uuid varchar(36) DEFAULT NULL,
	PRIMARY KEY ptres_id (ptres_id),
	KEY ptres_projeto (ptres_projeto),
	KEY ptres_tarefa (ptres_tarefa),
	KEY ptres_perspectiva (ptres_perspectiva),
	KEY ptres_tema (ptres_tema),
	KEY ptres_objetivo (ptres_objetivo),
	KEY ptres_estrategia (ptres_estrategia),
	KEY ptres_meta (ptres_meta),
	KEY ptres_fator (ptres_fator),
	KEY ptres_pratica (ptres_pratica),
	KEY ptres_indicador (ptres_indicador),
	KEY ptres_acao (ptres_acao),
	KEY ptres_canvas (ptres_canvas),
	KEY ptres_risco (ptres_risco),
	KEY ptres_risco_resposta (ptres_risco_resposta),
	KEY ptres_calendario (ptres_calendario),
	KEY ptres_monitoramento (ptres_monitoramento),
	KEY ptres_ata (ptres_ata),
	KEY ptres_mswot(ptres_mswot),
	KEY ptres_swot(ptres_swot),
	KEY ptres_operativo(ptres_operativo),
	KEY ptres_instrumento (ptres_instrumento),
	KEY ptres_recurso (ptres_recurso),
	KEY ptres_problema (ptres_problema),
	KEY ptres_demanda (ptres_demanda),
	KEY ptres_programa (ptres_programa),
	KEY ptres_licao (ptres_licao),
	KEY ptres_evento (ptres_evento),
	KEY ptres_link (ptres_link),
	KEY ptres_avaliacao (ptres_avaliacao),
	KEY ptres_tgn (ptres_tgn),
	KEY ptres_brainstorm (ptres_brainstorm),
	KEY ptres_gut (ptres_gut),
	KEY ptres_causa_efeito (ptres_causa_efeito),
	KEY ptres_arquivo (ptres_arquivo),
	KEY ptres_forum (ptres_forum),
	KEY ptres_checklist (ptres_checklist),
	KEY ptres_agenda (ptres_agenda),
	KEY ptres_agrupamento (ptres_agrupamento),
	KEY ptres_patrocinador (ptres_patrocinador),
	KEY ptres_template (ptres_template),
	KEY ptres_painel (ptres_painel),
	KEY ptres_painel_odometro (ptres_painel_odometro),
	KEY ptres_painel_composicao (ptres_painel_composicao),
	KEY ptres_tr (ptres_tr),
	KEY ptres_me (ptres_me),
	KEY ptres_acao_item (ptres_acao_item),
	KEY ptres_beneficio (ptres_beneficio),
	KEY ptres_painel_slideshow (ptres_painel_slideshow),
	KEY ptres_projeto_viabilidade (ptres_projeto_viabilidade),
	KEY ptres_projeto_abertura (ptres_projeto_abertura),
	KEY ptres_plano_gestao (ptres_plano_gestao),
	KEY ptres_ssti (ptres_ssti),
	KEY ptres_laudo (ptres_laudo),
	KEY ptres_trelo (ptres_trelo),
	KEY ptres_trelo_cartao (ptres_trelo_cartao),
	KEY ptres_pdcl (ptres_pdcl),
	KEY ptres_pdcl_item (ptres_pdcl_item),
	KEY ptres_os (ptres_os),
	CONSTRAINT ptres_projeto FOREIGN KEY (ptres_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_tarefa FOREIGN KEY (ptres_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_perspectiva FOREIGN KEY (ptres_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_tema FOREIGN KEY (ptres_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_objetivo FOREIGN KEY (ptres_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_fator FOREIGN KEY (ptres_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_estrategia FOREIGN KEY (ptres_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_meta FOREIGN KEY (ptres_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_pratica FOREIGN KEY (ptres_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_indicador FOREIGN KEY (ptres_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_acao FOREIGN KEY (ptres_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_canvas FOREIGN KEY (ptres_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_risco FOREIGN KEY (ptres_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_risco_resposta FOREIGN KEY (ptres_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_calendario FOREIGN KEY (ptres_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_monitoramento FOREIGN KEY (ptres_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_ata FOREIGN KEY (ptres_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_mswot FOREIGN KEY (ptres_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_swot FOREIGN KEY (ptres_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_operativo FOREIGN KEY (ptres_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_instrumento FOREIGN KEY (ptres_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_recurso FOREIGN KEY (ptres_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_problema FOREIGN KEY (ptres_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_demanda FOREIGN KEY (ptres_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_programa FOREIGN KEY (ptres_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_licao FOREIGN KEY (ptres_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_evento FOREIGN KEY (ptres_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_link FOREIGN KEY (ptres_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_avaliacao FOREIGN KEY (ptres_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_tgn FOREIGN KEY (ptres_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_brainstorm FOREIGN KEY (ptres_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_gut FOREIGN KEY (ptres_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_causa_efeito FOREIGN KEY (ptres_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_arquivo FOREIGN KEY (ptres_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_forum FOREIGN KEY (ptres_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_checklist FOREIGN KEY (ptres_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_agenda FOREIGN KEY (ptres_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_agrupamento FOREIGN KEY (ptres_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_patrocinador FOREIGN KEY (ptres_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_template FOREIGN KEY (ptres_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_painel FOREIGN KEY (ptres_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_painel_odometro FOREIGN KEY (ptres_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_painel_composicao FOREIGN KEY (ptres_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_tr FOREIGN KEY (ptres_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_me FOREIGN KEY (ptres_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_acao_item FOREIGN KEY (ptres_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_beneficio FOREIGN KEY (ptres_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_painel_slideshow FOREIGN KEY (ptres_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_projeto_viabilidade FOREIGN KEY (ptres_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_projeto_abertura FOREIGN KEY (ptres_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_plano_gestao FOREIGN KEY (ptres_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT ptres_ssti FOREIGN KEY (ptres_ssti) REFERENCES ssti (ssti_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT ptres_laudo FOREIGN KEY (ptres_laudo) REFERENCES laudo (laudo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT ptres_trelo FOREIGN KEY (ptres_trelo) REFERENCES trelo (trelo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT ptres_trelo_cartao FOREIGN KEY (ptres_trelo_cartao) REFERENCES trelo_cartao (trelo_cartao_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT ptres_pdcl FOREIGN KEY (ptres_pdcl) REFERENCES pdcl (pdcl_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT ptres_pdcl_item FOREIGN KEY (ptres_pdcl_item) REFERENCES pdcl_item (pdcl_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT ptres_os FOREIGN KEY (ptres_os) REFERENCES os (os_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS pratica_indicador_avaliacao;

CREATE TABLE pratica_indicador_avaliacao (
  pratica_indicador_avaliacao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pratica_indicador_avaliacao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_avaliacao_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_avaliacao_data DATE DEFAULT NULL,
  pratica_indicador_avaliacao_sucesso TINYINT(1) DEFAULT 0,
  pratica_indicador_avaliacao_causa VARCHAR(255) DEFAULT NULL,
  pratica_indicador_avaliacao_sanar MEDIUMTEXT,
  pratica_indicador_avaliacao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (pratica_indicador_avaliacao_id),
  KEY pratica_indicador_avaliacao_indicador (pratica_indicador_avaliacao_indicador),
  KEY pratica_indicador_avaliacao_responsavel (pratica_indicador_avaliacao_responsavel),
  CONSTRAINT pratica_indicador_avaliacao_fk FOREIGN KEY (pratica_indicador_avaliacao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT pratica_indicador_avaliacao_fk1 FOREIGN KEY (pratica_indicador_avaliacao_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_arquivo;

CREATE TABLE eb_arquivo (
  eb_arquivo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  eb_arquivo_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_arquivo_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_arquivo_artefato VARCHAR(30) DEFAULT NULL,
  eb_arquivo_ordem INTEGER(11) DEFAULT NULL,
  eb_arquivo_endereco VARCHAR(150) DEFAULT NULL,
  eb_arquivo_data DATETIME DEFAULT NULL,
  eb_arquivo_nome VARCHAR(150) DEFAULT NULL,
  eb_arquivo_tipo VARCHAR(50) DEFAULT NULL,
  eb_arquivo_extensao VARCHAR(50) DEFAULT NULL,
	eb_arquivo_nome_real VARCHAR(255) DEFAULT NULL,
	eb_arquivo_local VARCHAR(255) DEFAULT NULL,
	eb_arquivo_tamanho INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (eb_arquivo_id),
  KEY eb_arquivo_projeto (eb_arquivo_projeto),
  KEY eb_arquivo_usuario (eb_arquivo_usuario),
  CONSTRAINT eb_arquivo_fk FOREIGN KEY (eb_arquivo_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT eb_arquivo_usuario FOREIGN KEY (eb_arquivo_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_encerramento;

CREATE TABLE eb_encerramento (
	eb_encerramento_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_encerramento_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_encerramento_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_encerramento_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_encerramento_data_preparado DATE DEFAULT NULL,
	eb_encerramento_data_aprovado DATE DEFAULT NULL,
	eb_encerramento_data_revisado DATE DEFAULT NULL,
	eb_encerramento_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_encerramento_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_encerramento_baseline INTEGER(100) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (eb_encerramento_id),
	KEY eb_encerramento_projeto (eb_encerramento_projeto),
	KEY eb_encerramento_preparado_por (eb_encerramento_preparado_por),
	KEY eb_encerramento_aprovado_por (eb_encerramento_aprovado_por),
	KEY eb_encerramento_baseline (eb_encerramento_baseline),
	CONSTRAINT eb_encerramento_fk FOREIGN KEY (eb_encerramento_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT eb_encerramento_fk2 FOREIGN KEY (eb_encerramento_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT eb_encerramento_fk3 FOREIGN KEY (eb_encerramento_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT eb_encerramento_fk4 FOREIGN KEY (eb_encerramento_baseline) REFERENCES baseline (baseline_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_encerramento_campo;

CREATE TABLE eb_encerramento_campo (
	eb_encerramento_campo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_encerramento_campo_encerramento INTEGER(100) UNSIGNED NOT NULL,
	eb_encerramento_campo_texto TEXT,
	eb_encerramento_campo_titulo VARCHAR(50),
	PRIMARY KEY (eb_encerramento_campo_id),
	KEY eb_encerramento_campo_encerramento (eb_encerramento_campo_encerramento),
	CONSTRAINT eb_encerramento_campo_fk FOREIGN KEY (eb_encerramento_campo_encerramento) REFERENCES eb_encerramento (eb_encerramento_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_situacao;

CREATE TABLE eb_situacao (
	eb_situacao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_situacao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_situacao_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_situacao_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_situacao_data_preparado DATE DEFAULT NULL,
	eb_situacao_data_aprovado DATE DEFAULT NULL,
	eb_situacao_data_revisado DATE DEFAULT NULL,
	eb_situacao_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_situacao_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_situacao_baseline INTEGER(100) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (eb_situacao_id),
	KEY eb_situacao_projeto (eb_situacao_projeto),
	KEY eb_situacao_preparado_por (eb_situacao_preparado_por),
	KEY eb_situacao_aprovado_por (eb_situacao_aprovado_por),
	KEY eb_situacao_baseline (eb_situacao_baseline),
	CONSTRAINT eb_situacao_fk FOREIGN KEY (eb_situacao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT eb_situacao_fk2 FOREIGN KEY (eb_situacao_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT eb_situacao_fk3 FOREIGN KEY (eb_situacao_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT eb_situacao_fk4 FOREIGN KEY (eb_situacao_baseline) REFERENCES baseline (baseline_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_situacao_campo;

CREATE TABLE eb_situacao_campo (
	eb_situacao_campo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_situacao_campo_situacao INTEGER(100) UNSIGNED NOT NULL,
	eb_situacao_campo_texto TEXT,
	eb_situacao_campo_titulo VARCHAR(50),
	PRIMARY KEY (eb_situacao_campo_id),
	KEY eb_situacao_campo_situacao (eb_situacao_campo_situacao),
	CONSTRAINT eb_situacao_campo_fk FOREIGN KEY (eb_situacao_campo_situacao) REFERENCES eb_situacao (eb_situacao_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_aceite;

CREATE TABLE eb_aceite (
	eb_aceite_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_aceite_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_aceite_nr INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_aceite_data DATE DEFAULT NULL,
	eb_aceite_produto TEXT,
	eb_aceite_obs TEXT,
	eb_aceite_ok TINYINT(1) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (eb_aceite_id),
	KEY eb_aceite_projeto (eb_aceite_projeto),
	CONSTRAINT eb_aceite_fk FOREIGN KEY (eb_aceite_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_mudanca_controle;

CREATE TABLE eb_mudanca_controle (
	eb_mudanca_controle_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_mudanca_controle_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_data_preparado DATE DEFAULT NULL,
	eb_mudanca_controle_data_aprovado DATE DEFAULT NULL,
	eb_mudanca_controle_data_revisado DATE DEFAULT NULL,
	eb_mudanca_controle_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_nr_rcm INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_data_abertura DATE DEFAULT NULL,
	eb_mudanca_controle_subprojeto VARCHAR (255) DEFAULT NULL,
	eb_mudanca_controle_solicitante INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_baseline1 INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_baseline2 INTEGER(100) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (eb_mudanca_controle_id),
	KEY eb_mudanca_controle_projeto (eb_mudanca_controle_projeto),
	KEY eb_mudanca_controle_preparado_por (eb_mudanca_controle_preparado_por),
	KEY eb_mudanca_controle_aprovado_por (eb_mudanca_controle_aprovado_por),
	KEY eb_mudanca_controle_solicitante (eb_mudanca_controle_solicitante),
	KEY eb_mudanca_controle_baseline1 (eb_mudanca_controle_baseline1),
	KEY eb_mudanca_controle_baseline2 (eb_mudanca_controle_baseline2),
	CONSTRAINT eb_mudanca_controle_fk FOREIGN KEY (eb_mudanca_controle_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT eb_mudanca_controle_fk2 FOREIGN KEY (eb_mudanca_controle_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT eb_mudanca_controle_fk3 FOREIGN KEY (eb_mudanca_controle_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT eb_mudanca_controle_fk4 FOREIGN KEY (eb_mudanca_controle_baseline1) REFERENCES baseline (baseline_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT eb_mudanca_controle_fk5 FOREIGN KEY (eb_mudanca_controle_baseline2) REFERENCES baseline (baseline_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT eb_mudanca_controle_fk6 FOREIGN KEY (eb_mudanca_controle_solicitante) REFERENCES contatos (contato_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS eb_mudanca_controle_campo;

CREATE TABLE eb_mudanca_controle_campo (
	eb_mudanca_controle_campo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_mudanca_controle_campo_mudanca INTEGER(100) UNSIGNED NOT NULL,
	eb_mudanca_controle_campo_texto TEXT,
	eb_mudanca_controle_campo_titulo VARCHAR(50),
	PRIMARY KEY (eb_mudanca_controle_campo_id),
	KEY eb_mudanca_controle_campo_mudanca (eb_mudanca_controle_campo_mudanca),
	CONSTRAINT eb_mudanca_controle_campo_fk FOREIGN KEY (eb_mudanca_controle_campo_mudanca) REFERENCES eb_mudanca_controle (eb_mudanca_controle_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS eb_mudanca_controle_item;

CREATE TABLE eb_mudanca_controle_item (
	eb_mudanca_controle_item_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_mudanca_controle_item_mudanca_controle INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_item_contato INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_item_papel VARCHAR(255),
	eb_mudanca_controle_item_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_item_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (eb_mudanca_controle_item_id),
	KEY eb_mudanca_controle_item_mudanca_controle (eb_mudanca_controle_item_mudanca_controle),
	KEY eb_mudanca_controle_item_contato (eb_mudanca_controle_item_contato),
	CONSTRAINT eb_mudanca_controle_item_fk FOREIGN KEY (eb_mudanca_controle_item_mudanca_controle) REFERENCES eb_mudanca_controle (eb_mudanca_controle_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT eb_mudanca_controle_item_fk2 FOREIGN KEY (eb_mudanca_controle_item_contato) REFERENCES contatos (contato_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS eb_mudanca_controle_escopo;

CREATE TABLE eb_mudanca_controle_escopo (
	eb_mudanca_controle_escopo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_mudanca_controle_escopo_mudanca_controle INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_escopo_tipo INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_escopo_entrega TEXT,
	eb_mudanca_controle_escopo_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_escopo_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (eb_mudanca_controle_escopo_id),
	KEY eb_mudanca_controle_escopo_mudanca_controle (eb_mudanca_controle_escopo_mudanca_controle),
	CONSTRAINT eb_mudanca_controle_escopo_fk FOREIGN KEY (eb_mudanca_controle_escopo_mudanca_controle) REFERENCES eb_mudanca_controle (eb_mudanca_controle_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS eb_mudanca_controle_custo;

CREATE TABLE eb_mudanca_controle_custo (
	eb_mudanca_controle_custo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_mudanca_controle_custo_mudanca_controle INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_custo_produto TEXT,
	eb_mudanca_controle_custo_antes DECIMAL(20,5) UNSIGNED DEFAULT 0,
	eb_mudanca_controle_custo_depois DECIMAL(20,5) UNSIGNED DEFAULT 0,
	eb_mudanca_controle_custo_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_custo_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (eb_mudanca_controle_custo_id),
	KEY eb_mudanca_controle_custo_mudanca_controle (eb_mudanca_controle_custo_mudanca_controle),
	CONSTRAINT eb_mudanca_controle_custo_fk FOREIGN KEY (eb_mudanca_controle_custo_mudanca_controle) REFERENCES eb_mudanca_controle (eb_mudanca_controle_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_mudanca;

CREATE TABLE eb_mudanca (
	eb_mudanca_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_mudanca_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_data_preparado DATE DEFAULT NULL,
	eb_mudanca_data_aprovado DATE DEFAULT NULL,
	eb_mudanca_data_revisado DATE DEFAULT NULL,
	eb_mudanca_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_mudanca_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (eb_mudanca_id),
	KEY eb_mudanca_projeto (eb_mudanca_projeto),
	KEY eb_mudanca_preparado_por (eb_mudanca_preparado_por),
	KEY eb_mudanca_aprovado_por (eb_mudanca_aprovado_por),
	CONSTRAINT eb_mudanca_fk FOREIGN KEY (eb_mudanca_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT eb_mudanca_fk2 FOREIGN KEY (eb_mudanca_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT eb_mudanca_fk3 FOREIGN KEY (eb_mudanca_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_mudanca_campo;

CREATE TABLE eb_mudanca_campo (
	eb_mudanca_campo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_mudanca_campo_mudanca INTEGER(100) UNSIGNED NOT NULL,
	eb_mudanca_campo_texto TEXT,
	eb_mudanca_campo_titulo VARCHAR(50),
	PRIMARY KEY (eb_mudanca_campo_id),
	KEY eb_mudanca_campo_mudanca (eb_mudanca_campo_mudanca),
	CONSTRAINT eb_mudanca_campo_fk FOREIGN KEY (eb_mudanca_campo_mudanca) REFERENCES eb_mudanca (eb_mudanca_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_mudanca_item;

CREATE TABLE eb_mudanca_item (
	eb_mudanca_item_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_mudanca_item_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_item_contato INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_item_papel VARCHAR(255),
	eb_mudanca_item_responsabilidade TEXT,
	eb_mudanca_item_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (eb_mudanca_item_id),
	KEY eb_mudanca_item_projeto (eb_mudanca_item_projeto),
	KEY eb_mudanca_item_contato (eb_mudanca_item_contato),
	CONSTRAINT eb_mudanca_item_fk FOREIGN KEY (eb_mudanca_item_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT eb_mudanca_item_fk2 FOREIGN KEY (eb_mudanca_item_contato) REFERENCES contatos (contato_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_qualidade;

CREATE TABLE eb_qualidade (
	eb_qualidade_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_qualidade_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_qualidade_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_qualidade_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_qualidade_data_preparado DATE DEFAULT NULL,
	eb_qualidade_data_aprovado DATE DEFAULT NULL,
	eb_qualidade_data_revisado DATE DEFAULT NULL,
	eb_qualidade_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_qualidade_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_qualidade_requisito TEXT,
	PRIMARY KEY (eb_qualidade_id),
	KEY eb_qualidade_projeto (eb_qualidade_projeto),
	KEY eb_qualidade_preparado_por (eb_qualidade_preparado_por),
	KEY eb_qualidade_data_aprovado (eb_qualidade_data_aprovado),
	CONSTRAINT eb_qualidade_fk FOREIGN KEY (eb_qualidade_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT eb_qualidade_fk2 FOREIGN KEY (eb_qualidade_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT eb_qualidade_fk3 FOREIGN KEY (eb_qualidade_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_qualidade_item;

CREATE TABLE eb_qualidade_item (
	eb_qualidade_item_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_qualidade_item_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_qualidade_item_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_qualidade_item_contato INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_qualidade_item_requisito TEXT,
	eb_qualidade_item_meta TEXT,
	eb_qualidade_item_indicador TEXT,
	eb_qualidade_item_desempenho TEXT,
	eb_qualidade_item_acao TEXT,
	eb_qualidade_item_recurso TEXT,
	eb_qualidade_item_treinamento TEXT,
	eb_qualidade_item_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (eb_qualidade_item_id),
	KEY eb_qualidade_item_projeto (eb_qualidade_item_projeto),
	KEY eb_qualidade_item_tarefa (eb_qualidade_item_tarefa),
	KEY eb_qualidade_item_contato (eb_qualidade_item_contato),
	CONSTRAINT eb_qualidade_item_fk FOREIGN KEY (eb_qualidade_item_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT eb_qualidade_item_fk1 FOREIGN KEY (eb_qualidade_item_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT eb_qualidade_item_fk2 FOREIGN KEY (eb_qualidade_item_contato) REFERENCES contatos (contato_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_risco_item;

CREATE TABLE eb_risco_item (
  eb_risco_item_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  eb_risco_item_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_risco_item_contato INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_risco_item_usuario_inseriu INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_risco_item_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_risco_item_descricao VARCHAR(255) DEFAULT NULL,
  eb_risco_item_categoria VARCHAR(1) DEFAULT NULL,
  eb_risco_item_probabilidade1 VARCHAR(1) DEFAULT NULL,
  eb_risco_item_impacto1 VARCHAR(1) DEFAULT NULL,
  eb_risco_item_criticidade1 VARCHAR(1) DEFAULT NULL,
  eb_risco_item_estrategia VARCHAR(20) DEFAULT NULL,
  eb_risco_item_acao_proposta TEXT,
  eb_risco_item_probabilidade2 VARCHAR(1) DEFAULT NULL,
  eb_risco_item_impacto2 VARCHAR(1) DEFAULT NULL,
  eb_risco_item_criticidade2 VARCHAR(1) DEFAULT NULL,
  eb_risco_item_data DATE DEFAULT NULL,
  eb_risco_item_data_inseriu DATETIME DEFAULT NULL,
  PRIMARY KEY (eb_risco_item_id),
  KEY eb_risco_item_projeto (eb_risco_item_projeto),
  KEY eb_risco_item_usuario_inseriu (eb_risco_item_usuario_inseriu),
  KEY eb_risco_item_contato (eb_risco_item_contato),
  CONSTRAINT eb_risco_item_fk2 FOREIGN KEY (eb_risco_item_contato) REFERENCES contatos (contato_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT eb_risco_item_fk FOREIGN KEY (eb_risco_item_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT eb_risco_item_fk1 FOREIGN KEY (eb_risco_item_usuario_inseriu) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS eb_risco;

CREATE TABLE eb_risco (
	eb_risco_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_risco_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_risco_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_risco_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_risco_data_preparado DATE DEFAULT NULL,
	eb_risco_data_aprovado DATE DEFAULT NULL,
	eb_risco_data_revisado DATE DEFAULT NULL,
	eb_risco_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_risco_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (eb_risco_id),
	KEY eb_risco_projeto (eb_risco_projeto),
	KEY eb_risco_preparado_por (eb_risco_preparado_por),
	KEY eb_risco_aprovado_por (eb_risco_aprovado_por),
	CONSTRAINT eb_risco_fk FOREIGN KEY (eb_risco_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT eb_risco_fk2 FOREIGN KEY (eb_risco_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT eb_risco_fk3 FOREIGN KEY (eb_risco_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_interessado;

CREATE TABLE eb_interessado (
	eb_interessado_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_interessado_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_interessado_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_interessado_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_interessado_data_preparado DATE DEFAULT NULL,
	eb_interessado_data_aprovado DATE DEFAULT NULL,
	eb_interessado_data_revisado DATE DEFAULT NULL,
	eb_interessado_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_interessado_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (eb_interessado_id),
	KEY eb_interessado_projeto (eb_interessado_projeto),
	KEY eb_interessado_preparado_por (eb_interessado_preparado_por),
	KEY eb_interessado_aprovado_por (eb_interessado_aprovado_por),
	CONSTRAINT eb_interessado_fk FOREIGN KEY (eb_interessado_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT eb_interessado_fk2 FOREIGN KEY (eb_interessado_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT eb_interessado_fk3 FOREIGN KEY (eb_interessado_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_interessado_campo;

CREATE TABLE eb_interessado_campo (
	eb_interessado_campo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_interessado_campo_interessado INTEGER(100) UNSIGNED NOT NULL,
	eb_interessado_campo_texto TEXT,
	eb_interessado_campo_titulo VARCHAR(50),
	PRIMARY KEY (eb_interessado_campo_id),
	KEY eb_interessado_campo_interessado (eb_interessado_campo_interessado),
	CONSTRAINT eb_interessado_campo_fk FOREIGN KEY (eb_interessado_campo_interessado) REFERENCES eb_interessado (eb_interessado_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS eb_comunicacao;

CREATE TABLE eb_comunicacao (
	eb_comunicacao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_comunicacao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_comunicacao_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_comunicacao_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_comunicacao_data_preparado DATE DEFAULT NULL,
	eb_comunicacao_data_aprovado DATE DEFAULT NULL,
	eb_comunicacao_data_revisado DATE DEFAULT NULL,
	eb_comunicacao_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_comunicacao_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (eb_comunicacao_id),
	KEY eb_comunicacao_projeto (eb_comunicacao_projeto),
	KEY eb_comunicacao_preparado_por (eb_comunicacao_preparado_por),
	KEY eb_comunicacao_aprovado_por (eb_comunicacao_aprovado_por),
	CONSTRAINT eb_comunicacao_fk FOREIGN KEY (eb_comunicacao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT eb_comunicacao_fk2 FOREIGN KEY (eb_comunicacao_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT eb_comunicacao_fk3 FOREIGN KEY (eb_comunicacao_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_comunicacao_campo;

CREATE TABLE eb_comunicacao_campo (
	eb_comunicacao_campo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_comunicacao_campo_comunicacao INTEGER(100) UNSIGNED NOT NULL,
	eb_comunicacao_campo_texto TEXT,
	eb_comunicacao_campo_titulo VARCHAR(50),
	PRIMARY KEY (eb_comunicacao_campo_id),
	KEY eb_comunicacao_campo_comunicacao (eb_comunicacao_campo_comunicacao),
	CONSTRAINT eb_comunicacao_campo_fk FOREIGN KEY (eb_comunicacao_campo_comunicacao) REFERENCES eb_comunicacao (eb_comunicacao_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_humano;

CREATE TABLE eb_humano (
	eb_humano_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_humano_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_humano_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_humano_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_humano_data_preparado DATE DEFAULT NULL,
	eb_humano_data_aprovado DATE DEFAULT NULL,
	eb_humano_data_revisado DATE DEFAULT NULL,
	eb_humano_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_humano_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_humano_finalidade TEXT,
	eb_humano_organograma VARCHAR(255),
	eb_humano_avaliacao TEXT,
	PRIMARY KEY (eb_humano_id),
	KEY eb_humano_projeto (eb_humano_projeto),
	KEY eb_humano_preparado_por (eb_humano_preparado_por),
	KEY eb_humano_data_aprovado (eb_humano_data_aprovado),
	CONSTRAINT eb_humano_fk FOREIGN KEY (eb_humano_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT eb_humano_fk2 FOREIGN KEY (eb_humano_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT eb_humano_fk3 FOREIGN KEY (eb_humano_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_humano_matriz;

CREATE TABLE eb_humano_matriz (
	eb_humano_matriz_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_humano_matriz_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_humano_matriz_contato INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_humano_matriz_area VARCHAR(255),
	eb_humano_matriz_responsabilidade TEXT,
	eb_humano_matriz_escopo INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_humano_matriz_tempo INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_humano_matriz_custo INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_humano_matriz_qualidade INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_humano_matriz_rh INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_humano_matriz_comunicacao INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_humano_matriz_riscos INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_humano_matriz_contratos INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_humano_matriz_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (eb_humano_matriz_id),
	KEY eb_humano_matriz_projeto (eb_humano_matriz_projeto),
	KEY eb_humano_matriz_contato (eb_humano_matriz_contato),
	CONSTRAINT eb_humano_matriz_fk FOREIGN KEY (eb_humano_matriz_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT eb_humano_matriz_fk2 FOREIGN KEY (eb_humano_matriz_contato) REFERENCES contatos (contato_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS eb_plano_item;

CREATE TABLE eb_plano_item (
  eb_plano_item_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  eb_plano_item_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_plano_item_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_plano_item_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_plano_item_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_plano_item_nome VARCHAR(255) DEFAULT NULL,
  eb_plano_item_quando TEXT,
  eb_plano_item_oque TEXT,
  eb_plano_item_como TEXT,
  eb_plano_item_onde TEXT,
  eb_plano_item_quanto TEXT,
  eb_plano_item_porque TEXT,
  eb_plano_item_quem TEXT,
  eb_plano_item_inicio DATETIME DEFAULT NULL,
  eb_plano_item_fim DATETIME DEFAULT NULL,
  eb_plano_item_duracao DECIMAL(20,5) UNSIGNED DEFAULT NULL,
  eb_plano_item_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  eb_plano_item_principal_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (eb_plano_item_id),
  KEY eb_plano_item_projeto (eb_plano_item_projeto),
  KEY eb_plano_item_responsavel (eb_plano_item_responsavel),
  KEY eb_plano_item_cia (eb_plano_item_cia),
	KEY eb_plano_item_principal_indicador (eb_plano_item_principal_indicador),
  CONSTRAINT eb_plano_item_fk FOREIGN KEY (eb_plano_item_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT eb_plano_item_fk1 FOREIGN KEY (eb_plano_item_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT eb_plano_item_fk2 FOREIGN KEY (eb_plano_item_principal_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT eb_plano_item_fk3 FOREIGN KEY (eb_plano_item_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_plano_item_depts;

CREATE TABLE eb_plano_item_depts (
	eb_plano_item_depts_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  eb_plano_item_id INTEGER(100) UNSIGNED DEFAULT NULL,
  dept_id INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (eb_plano_item_depts_id),
  KEY eb_plano_item_id (eb_plano_item_id),
  KEY dept_id (dept_id),
  CONSTRAINT eb_plano_item_depts_fk1 FOREIGN KEY (dept_id) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT eb_plano_item_depts_fk FOREIGN KEY (eb_plano_item_id) REFERENCES eb_plano_item (eb_plano_item_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS eb_plano_item_custos;

CREATE TABLE eb_plano_item_custos (
  eb_plano_item_custos_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  eb_plano_item_custos_eb_plano_item INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_plano_item_custos_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_plano_item_custos_tipo INTEGER(100) UNSIGNED DEFAULT 1,
  eb_plano_item_custos_nome VARCHAR(255) DEFAULT NULL,
  eb_plano_item_custos_data DATETIME DEFAULT NULL,
  eb_plano_item_custos_quantidade DECIMAL(20,5) UNSIGNED DEFAULT 0,
  eb_plano_item_custos_custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
  eb_plano_item_custos_percentagem TINYINT(4) DEFAULT 0,
  eb_plano_item_custos_descricao TEXT,
  eb_plano_item_custos_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_plano_item_custos_nd VARCHAR(11) DEFAULT NULL,
  eb_plano_item_custos_categoria_economica VARCHAR(1) DEFAULT NULL,
  eb_plano_item_custos_grupo_despesa VARCHAR(1) DEFAULT NULL,
  eb_plano_item_custos_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  eb_plano_item_custos_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_plano_item_custos_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
  eb_plano_item_custos_data_limite DATE DEFAULT NULL,
  uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (eb_plano_item_custos_id),
  KEY idxeb_plano_item_custos_eb_plano_item (eb_plano_item_custos_eb_plano_item),
  KEY idxeb_plano_item_custos_usuario_inicio (eb_plano_item_custos_usuario),
  KEY idxeb_plano_item_custos_ordem (eb_plano_item_custos_ordem),
  KEY idxeb_plano_item_custos_data_inicio (eb_plano_item_custos_data),
  KEY idxeb_plano_item_custos_nome (eb_plano_item_custos_nome),
  CONSTRAINT eb_plano_item_custos_fk FOREIGN KEY (eb_plano_item_custos_eb_plano_item) REFERENCES eb_plano_item (eb_plano_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT eb_plano_item_custos_fk1 FOREIGN KEY (eb_plano_item_custos_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_plano_item_designados;

CREATE TABLE eb_plano_item_designados (
	eb_plano_item_designados_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  eb_plano_item_id INTEGER(100) UNSIGNED DEFAULT NULL,
  usuario_id INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (eb_plano_item_designados_id),
  KEY eb_plano_item_id (eb_plano_item_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT eb_plano_item_designados_fk1 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT eb_plano_item_designados_fk FOREIGN KEY (eb_plano_item_id) REFERENCES eb_plano_item (eb_plano_item_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_plano_item_gastos;

CREATE TABLE eb_plano_item_gastos (
  eb_plano_item_gastos_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  eb_plano_item_gastos_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_plano_item_gastos_eb_plano_item INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_plano_item_gastos_tipo INTEGER(100) UNSIGNED DEFAULT 1,
  eb_plano_item_gastos_nome VARCHAR(255) DEFAULT NULL,
  eb_plano_item_gastos_data DATETIME DEFAULT NULL,
  eb_plano_item_gastos_data_recebido DATETIME DEFAULT NULL,
  eb_plano_item_gastos_quantidade DECIMAL(20,5) UNSIGNED DEFAULT 0,
  eb_plano_item_gastos_custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
  eb_plano_item_gastos_percentagem TINYINT(4) DEFAULT 0,
  eb_plano_item_gastos_descricao TEXT,
  eb_plano_item_gastos_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_plano_item_gastos_nd VARCHAR(11) DEFAULT NULL,
  eb_plano_item_gastos_categoria_economica VARCHAR(1) DEFAULT NULL,
  eb_plano_item_gastos_grupo_despesa VARCHAR(1) DEFAULT NULL,
  eb_plano_item_gastos_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  eb_plano_item_gastos_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_plano_item_gastos_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
  eb_plano_item_custos_data_recebido DATE DEFAULT NULL,
  uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (eb_plano_item_gastos_id),
  KEY idxeb_plano_item_gastos_eb_plano_item (eb_plano_item_gastos_eb_plano_item),
  KEY idxeb_plano_item_gastos_usuario_inicio (eb_plano_item_gastos_usuario),
  KEY idxeb_plano_item_gastos_ordem (eb_plano_item_gastos_ordem),
  KEY idxeb_plano_item_gastos_data_inicio (eb_plano_item_gastos_data),
  KEY idxeb_plano_item_gastos_nome (eb_plano_item_gastos_nome),
  CONSTRAINT eb_plano_item_gastos_fk FOREIGN KEY (eb_plano_item_gastos_eb_plano_item) REFERENCES eb_plano_item (eb_plano_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT eb_plano_item_gastos_fk1 FOREIGN KEY (eb_plano_item_gastos_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_plano_item_h_custos;

CREATE TABLE eb_plano_item_h_custos (
  h_custos_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  h_custos_eb_plano_item INTEGER(100) UNSIGNED DEFAULT NULL,
  h_custos_eb_plano_item_custos_id INTEGER(100) UNSIGNED DEFAULT NULL,
  h_custos_nome1 VARCHAR(255) DEFAULT NULL,
  h_custos_nome2 VARCHAR(255) DEFAULT NULL,
  h_custos_tipo1 INTEGER(100) UNSIGNED DEFAULT 1,
  h_custos_tipo2 INTEGER(100) UNSIGNED DEFAULT 1,
  h_custos_usuario1 INTEGER(100) UNSIGNED DEFAULT NULL,
  h_custos_usuario2 INTEGER(100) UNSIGNED DEFAULT NULL,
  h_custos_data1 DATETIME DEFAULT NULL,
  h_custos_data2 DATETIME DEFAULT NULL,
  h_custos_quantidade1 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_custos_quantidade2 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_custos_custo1 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_custos_custo2 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_custos_percentagem1 TINYINT(4) DEFAULT 0,
  h_custos_percentagem2 TINYINT(4) DEFAULT 0,
  h_custos_descricao1 TEXT,
  h_custos_descricao2 TEXT,
  h_custos_nd1 VARCHAR(20) DEFAULT NULL,
  h_custos_nd2 VARCHAR(20) DEFAULT NULL,
  h_custos_categoria_economica1 VARCHAR(1) DEFAULT NULL,
  h_custos_grupo_despesa1 VARCHAR(1) DEFAULT NULL,
  h_custos_modalidade_aplicacao1 VARCHAR(2) DEFAULT NULL,
  h_custos_categoria_economica2 VARCHAR(1) DEFAULT NULL,
  h_custos_grupo_despesa2 VARCHAR(1) DEFAULT NULL,
  h_custos_modalidade_aplicacao2 VARCHAR(2) DEFAULT NULL,
  h_custos_metodo1 INTEGER(100) UNSIGNED DEFAULT NULL,
	h_custos_metodo2 INTEGER(100) UNSIGNED DEFAULT NULL,
	h_custos_exercicio1 INTEGER(4) UNSIGNED DEFAULT NULL,
	h_custos_exercicio2 INTEGER(4) UNSIGNED DEFAULT NULL,
  h_custos_excluido TINYINT(1) DEFAULT 0,
  uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (h_custos_id),
  KEY h_custos_eb_plano_item_custos_id (h_custos_eb_plano_item_custos_id),
  CONSTRAINT eb_plano_item_h_custos_fk FOREIGN KEY (h_custos_eb_plano_item_custos_id) REFERENCES eb_plano_item_custos (eb_plano_item_custos_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_plano_item_h_gastos;

CREATE TABLE eb_plano_item_h_gastos (
  h_gastos_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  h_gastos_eb_plano_item_gastos_id INTEGER(100) UNSIGNED DEFAULT NULL,
  h_gastos_eb_plano_item INTEGER(100) UNSIGNED DEFAULT NULL,
  h_gastos_nome1 VARCHAR(255) DEFAULT NULL,
  h_gastos_nome2 VARCHAR(255) DEFAULT NULL,
  h_gastos_tipo1 INTEGER(100) UNSIGNED DEFAULT 1,
  h_gastos_tipo2 INTEGER(100) UNSIGNED DEFAULT 1,
  h_gastos_usuario1 INTEGER(100) UNSIGNED DEFAULT NULL,
  h_gastos_usuario2 INTEGER(100) UNSIGNED DEFAULT NULL,
  h_gastos_data1 DATETIME DEFAULT NULL,
  h_gastos_data2 DATETIME DEFAULT NULL,
  h_gastos_quantidade1 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_gastos_quantidade2 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_gastos_custo1 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_gastos_custo2 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_gastos_percentagem1 TINYINT(4) DEFAULT 0,
  h_gastos_percentagem2 TINYINT(4) DEFAULT 0,
  h_gastos_descricao1 TEXT,
  h_gastos_descricao2 TEXT,
  h_gastos_nd1 VARCHAR(20) DEFAULT NULL,
  h_gastos_nd2 VARCHAR(20) DEFAULT NULL,
  h_gastos_categoria_economica1 VARCHAR(1) DEFAULT NULL,
  h_gastos_grupo_despesa1 VARCHAR(1) DEFAULT NULL,
  h_gastos_modalidade_aplicacao1 VARCHAR(2) DEFAULT NULL,
  h_gastos_categoria_economica2 VARCHAR(1) DEFAULT NULL,
  h_gastos_grupo_despesa2 VARCHAR(1) DEFAULT NULL,
  h_gastos_modalidade_aplicacao2 VARCHAR(2) DEFAULT NULL,
  h_gastos_metodo1 INTEGER(100) UNSIGNED DEFAULT NULL,
	h_gastos_metodo2 INTEGER(100) UNSIGNED DEFAULT NULL,
	h_gastos_exercicio1 INTEGER(4) UNSIGNED DEFAULT NULL,
	h_gastos_exercicio2 INTEGER(4) UNSIGNED DEFAULT NULL,
  h_gastos_excluido TINYINT(1) DEFAULT 0,
  uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (h_gastos_id),
  KEY h_gastos_eb_plano_item_gastos_id (h_gastos_eb_plano_item_gastos_id),
  CONSTRAINT eb_plano_item_h_gastos_fk FOREIGN KEY (h_gastos_eb_plano_item_gastos_id) REFERENCES eb_plano_item_gastos (eb_plano_item_gastos_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_plano;

CREATE TABLE eb_plano (
	eb_plano_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_plano_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_plano_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_plano_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_plano_data_preparado DATE DEFAULT NULL,
	eb_plano_data_aprovado DATE DEFAULT NULL,
	eb_plano_data_revisado DATE DEFAULT NULL,
	eb_plano_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_plano_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_plano_sintese TEXT,
	eb_plano_objetivo TEXT,
	eb_plano_info TEXT,
	eb_plano_anexo TEXT,
	PRIMARY KEY (eb_plano_id),
	KEY eb_plano_projeto (eb_plano_projeto),
	KEY eb_plano_preparado_por (eb_plano_preparado_por),
	KEY eb_plano_data_aprovado (eb_plano_data_aprovado),
	CONSTRAINT eb_plano_fk FOREIGN KEY (eb_plano_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT eb_plano_fk2 FOREIGN KEY (eb_plano_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT eb_plano_fk3 FOREIGN KEY (eb_plano_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS eb_escopo;

CREATE TABLE eb_escopo (
	eb_escopo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_escopo_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_escopo_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_escopo_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_escopo_data_preparado DATE DEFAULT NULL,
	eb_escopo_data_aprovado DATE DEFAULT NULL,
	eb_escopo_data_revisado DATE DEFAULT NULL,
	eb_escopo_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_escopo_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (eb_escopo_id),
	KEY eb_escopo_projeto (eb_escopo_projeto),
	KEY eb_escopo_preparado_por (eb_escopo_preparado_por),
	KEY eb_escopo_aprovado_por (eb_escopo_aprovado_por),
	CONSTRAINT eb_escopo_fk FOREIGN KEY (eb_escopo_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT eb_escopo_fk2 FOREIGN KEY (eb_escopo_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT eb_escopo_fk3 FOREIGN KEY (eb_escopo_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_escopo_campo;

CREATE TABLE eb_escopo_campo (
	eb_escopo_campo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_escopo_campo_escopo INTEGER(100) UNSIGNED NOT NULL,
	eb_escopo_campo_texto TEXT,
	eb_escopo_campo_titulo VARCHAR(50),
	PRIMARY KEY (eb_escopo_campo_id),
	KEY eb_escopo_campo_escopo (eb_escopo_campo_escopo),
	CONSTRAINT eb_escopo_campo_fk FOREIGN KEY (eb_escopo_campo_escopo) REFERENCES eb_escopo (eb_escopo_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_iniciacao;

CREATE TABLE eb_iniciacao (
	eb_iniciacao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_iniciacao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_iniciacao_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_iniciacao_data_aprovado DATE DEFAULT NULL,
	PRIMARY KEY (eb_iniciacao_id),
	KEY eb_iniciacao_projeto (eb_iniciacao_projeto),
	KEY eb_iniciacao_aprovado_por (eb_iniciacao_aprovado_por),
	CONSTRAINT eb_iniciacao_fk FOREIGN KEY (eb_iniciacao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT eb_iniciacao_fk1 FOREIGN KEY (eb_iniciacao_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_iniciacao_campo;

CREATE TABLE eb_iniciacao_campo (
	eb_iniciacao_campo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_iniciacao_campo_iniciacao INTEGER(100) UNSIGNED NOT NULL,
	eb_iniciacao_campo_texto TEXT,
	eb_iniciacao_campo_titulo VARCHAR(50),
	PRIMARY KEY (eb_iniciacao_campo_id),
	KEY eb_iniciacao_campo_iniciacao (eb_iniciacao_campo_iniciacao),
	CONSTRAINT eb_iniciacao_campo_fk FOREIGN KEY (eb_iniciacao_campo_iniciacao) REFERENCES eb_iniciacao (eb_iniciacao_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS eb_iniciacao_envolvido;

CREATE TABLE eb_iniciacao_envolvido (
  eb_iniciacao_envolvido_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  projeto_id INTEGER(100) UNSIGNED DEFAULT NULL,
  contato_id INTEGER(100) UNSIGNED DEFAULT NULL,
  ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (eb_iniciacao_envolvido_id),
  KEY projeto_id (projeto_id),
  KEY contato_id (contato_id),
  CONSTRAINT eb_iniciacao_envolvido_fk1 FOREIGN KEY (contato_id) REFERENCES contatos (contato_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT eb_iniciacao_envolvido_fk FOREIGN KEY (projeto_id) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_implantacao;

CREATE TABLE eb_implantacao (
	eb_implantacao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_implantacao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_implantacao_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_implantacao_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_implantacao_data_preparado DATE DEFAULT NULL,
	eb_implantacao_data_aprovado DATE DEFAULT NULL,
	eb_implantacao_data_revisado DATE DEFAULT NULL,
	eb_implantacao_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_implantacao_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (eb_implantacao_id),
	KEY eb_implantacao_projeto (eb_implantacao_projeto),
	KEY eb_implantacao_preparado_por (eb_implantacao_preparado_por),
	KEY eb_implantacao_aprovado_por (eb_implantacao_aprovado_por),
	CONSTRAINT eb_implantacao_fk FOREIGN KEY (eb_implantacao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT eb_implantacao_fk1 FOREIGN KEY (eb_implantacao_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT eb_implantacao_fk2 FOREIGN KEY (eb_implantacao_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_implantacao_campo;

CREATE TABLE eb_implantacao_campo (
	eb_implantacao_campo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_implantacao_campo_implantacao INTEGER(100) UNSIGNED NOT NULL,
	eb_implantacao_campo_texto TEXT,
	eb_implantacao_campo_titulo VARCHAR(50),
	PRIMARY KEY (eb_implantacao_campo_id),
	KEY eb_implantacao_campo_implantacao (eb_implantacao_campo_implantacao),
	CONSTRAINT eb_implantacao_campo_fk FOREIGN KEY (eb_implantacao_campo_implantacao) REFERENCES eb_implantacao (eb_implantacao_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_viabilidade;

CREATE TABLE eb_viabilidade (
	eb_viabilidade_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_viabilidade_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_viabilidade_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_viabilidade_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_viabilidade_data_preparado DATE DEFAULT NULL,
	eb_viabilidade_data_aprovado DATE DEFAULT NULL,
	eb_viabilidade_data_revisado DATE DEFAULT NULL,
	eb_viabilidade_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_viabilidade_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_viabilidade_planejamento_inicio DATE DEFAULT NULL,
	eb_viabilidade_planejamento_fim DATE DEFAULT NULL,
	eb_viabilidade_execucao_inicio DATE DEFAULT NULL,
	eb_viabilidade_execucao_fim DATE DEFAULT NULL,
	eb_viabilidade_recurso_inicio DATE DEFAULT NULL,
	eb_viabilidade_recurso_fim DATE DEFAULT NULL,
	eb_viabilidade_data_compensador DATE DEFAULT NULL,
	eb_viabilidade_implementacao_inicio DATE DEFAULT NULL,
	eb_viabilidade_implementacao_fim DATE DEFAULT NULL,
	PRIMARY KEY (eb_viabilidade_id),
	KEY eb_viabilidade_projeto (eb_viabilidade_projeto),
	KEY eb_viabilidade_preparado_por (eb_viabilidade_preparado_por),
	KEY eb_viabilidade_aprovado_por (eb_viabilidade_aprovado_por),
	CONSTRAINT eb_viabilidade_fk FOREIGN KEY (eb_viabilidade_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT eb_viabilidade_fk1 FOREIGN KEY (eb_viabilidade_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT eb_viabilidade_fk2 FOREIGN KEY (eb_viabilidade_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS eb_viabilidade_campo;

CREATE TABLE eb_viabilidade_campo (
	eb_viabilidade_campo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	eb_viabilidade_campo_viabilidade INTEGER(100) UNSIGNED NOT NULL,
	eb_viabilidade_campo_texto TEXT,
	eb_viabilidade_campo_titulo VARCHAR(50),
	PRIMARY KEY (eb_viabilidade_campo_id),
	KEY eb_viabilidade_campo_viabilidade (eb_viabilidade_campo_viabilidade),
	CONSTRAINT eb_viabilidade_campo_fk FOREIGN KEY (eb_viabilidade_campo_viabilidade) REFERENCES eb_viabilidade (eb_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS eb_viabilidade_envolvido;

CREATE TABLE eb_viabilidade_envolvido (
  eb_viabilidade_envolvido_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  projeto_id INTEGER(100) UNSIGNED DEFAULT NULL,
  contato_id INTEGER(100) UNSIGNED DEFAULT NULL,
  ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (eb_viabilidade_envolvido_id),
  KEY projeto_id (projeto_id),
  KEY contato_id (contato_id),
  CONSTRAINT eb_viabilidade_envolvido_fk1 FOREIGN KEY (contato_id) REFERENCES contatos (contato_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT eb_viabilidade_envolvido_fk FOREIGN KEY (projeto_id) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_arquivo;

CREATE TABLE baseline_eb_arquivo (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
  eb_arquivo_id INTEGER(100) UNSIGNED NOT NULL,
  eb_arquivo_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_arquivo_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_arquivo_artefato VARCHAR(30) DEFAULT NULL,
  eb_arquivo_ordem INTEGER(11) DEFAULT NULL,
  eb_arquivo_endereco VARCHAR(150) DEFAULT NULL,
  eb_arquivo_data DATETIME DEFAULT NULL,
  eb_arquivo_nome VARCHAR(150) DEFAULT NULL,
  eb_arquivo_tipo VARCHAR(50) DEFAULT NULL,
  eb_arquivo_extensao VARCHAR(50) DEFAULT NULL,
  eb_arquivo_nome_real VARCHAR(255) DEFAULT NULL,
	eb_arquivo_local VARCHAR(255) DEFAULT NULL,
	eb_arquivo_tamanho INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (baseline_id, eb_arquivo_id),
	KEY baseline_id (baseline_id),
  KEY eb_arquivo_projeto (eb_arquivo_projeto),
  KEY eb_arquivo_usuario (eb_arquivo_usuario),
	CONSTRAINT baseline_eb_arquivo_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_arquivo_projeto FOREIGN KEY (eb_arquivo_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_arquivo_usuario FOREIGN KEY (eb_arquivo_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_encerramento;

CREATE TABLE baseline_eb_encerramento (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_encerramento_id INTEGER(100) UNSIGNED NOT NULL,
	eb_encerramento_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_encerramento_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_encerramento_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_encerramento_data_preparado DATE DEFAULT NULL,
	eb_encerramento_data_aprovado DATE DEFAULT NULL,
	eb_encerramento_data_revisado DATE DEFAULT NULL,
	eb_encerramento_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_encerramento_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_encerramento_baseline INTEGER(100) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (baseline_id, eb_encerramento_id),
	KEY baseline_id (baseline_id),
	KEY eb_encerramento_projeto (eb_encerramento_projeto),
	KEY eb_encerramento_preparado_por (eb_encerramento_preparado_por),
	KEY eb_encerramento_aprovado_por (eb_encerramento_aprovado_por),
	KEY eb_encerramento_baseline (eb_encerramento_baseline),
	CONSTRAINT baseline_eb_encerramento_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_encerramento_projeto FOREIGN KEY (eb_encerramento_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_encerramento_preparado FOREIGN KEY (eb_encerramento_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_encerramento_aprovado FOREIGN KEY (eb_encerramento_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_encerramento_baseline2 FOREIGN KEY (eb_encerramento_baseline) REFERENCES baseline (baseline_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_situacao;

CREATE TABLE baseline_eb_situacao (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_situacao_id INTEGER(100) UNSIGNED NOT NULL,
	eb_situacao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_situacao_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_situacao_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_situacao_data_preparado DATE DEFAULT NULL,
	eb_situacao_data_aprovado DATE DEFAULT NULL,
	eb_situacao_data_revisado DATE DEFAULT NULL,
	eb_situacao_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_situacao_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_situacao_baseline INTEGER(100) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (baseline_id, eb_situacao_id),
	KEY baseline_id (baseline_id),
	KEY eb_situacao_projeto (eb_situacao_projeto),
	KEY eb_situacao_preparado_por (eb_situacao_preparado_por),
	KEY eb_situacao_aprovado_por (eb_situacao_aprovado_por),
	KEY eb_situacao_baseline (eb_situacao_baseline),
	CONSTRAINT baseline_eb_situacao_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_situacao_projeto FOREIGN KEY (eb_situacao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_situacao_preparado FOREIGN KEY (eb_situacao_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_situacao_aprovado FOREIGN KEY (eb_situacao_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_situacao_baseline2 FOREIGN KEY (eb_situacao_baseline) REFERENCES baseline (baseline_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_aceite;

CREATE TABLE baseline_eb_aceite (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_aceite_id INTEGER(100) UNSIGNED NOT NULL,
	eb_aceite_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_aceite_nr INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_aceite_data DATE DEFAULT NULL,
	eb_aceite_produto TEXT,
	eb_aceite_obs TEXT,
	eb_aceite_ok TINYINT(1) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (baseline_id, eb_aceite_id),
	KEY baseline_id (baseline_id),
	KEY eb_aceite_projeto (eb_aceite_projeto),
	CONSTRAINT baseline_eb_aceite_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_aceite_projeto FOREIGN KEY (eb_aceite_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_mudanca_controle;

CREATE TABLE baseline_eb_mudanca_controle (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_mudanca_controle_id INTEGER(100) UNSIGNED NOT NULL,
	eb_mudanca_controle_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_data_preparado DATE DEFAULT NULL,
	eb_mudanca_controle_data_aprovado DATE DEFAULT NULL,
	eb_mudanca_controle_data_revisado DATE DEFAULT NULL,
	eb_mudanca_controle_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_nr_rcm INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_data_abertura DATE DEFAULT NULL,
	eb_mudanca_controle_subprojeto VARCHAR (255) DEFAULT NULL,
	eb_mudanca_controle_solicitante INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_baseline1 INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_baseline2 INTEGER(100) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (baseline_id, eb_mudanca_controle_id),
	KEY baseline_id (baseline_id),
	KEY eb_mudanca_controle_projeto (eb_mudanca_controle_projeto),
	KEY eb_mudanca_controle_preparado_por (eb_mudanca_controle_preparado_por),
	KEY eb_mudanca_controle_aprovado_por (eb_mudanca_controle_aprovado_por),
	KEY eb_mudanca_controle_solicitante (eb_mudanca_controle_solicitante),
	KEY eb_mudanca_controle_baseline1 (eb_mudanca_controle_baseline1),
	KEY eb_mudanca_controle_baseline2 (eb_mudanca_controle_baseline2),
	CONSTRAINT baseline_eb_mudanca_controle_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_mudanca_controle_projeto FOREIGN KEY (eb_mudanca_controle_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_mudanca_controle_preparado FOREIGN KEY (eb_mudanca_controle_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_mudanca_controle_aprovado FOREIGN KEY (eb_mudanca_controle_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_mudanca_controle_baseline1 FOREIGN KEY (eb_mudanca_controle_baseline1) REFERENCES baseline (baseline_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_mudanca_controle_baseline2 FOREIGN KEY (eb_mudanca_controle_baseline2) REFERENCES baseline (baseline_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_mudanca_controle_solicitante FOREIGN KEY (eb_mudanca_controle_solicitante) REFERENCES contatos (contato_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_mudanca;

CREATE TABLE baseline_eb_mudanca (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_mudanca_id INTEGER(100) UNSIGNED NOT NULL,
	eb_mudanca_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_data_preparado DATE DEFAULT NULL,
	eb_mudanca_data_aprovado DATE DEFAULT NULL,
	eb_mudanca_data_revisado DATE DEFAULT NULL,
	eb_mudanca_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_mudanca_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (baseline_id, eb_mudanca_id),
	KEY baseline_id (baseline_id),
	KEY eb_mudanca_projeto (eb_mudanca_projeto),
	KEY eb_mudanca_preparado_por (eb_mudanca_preparado_por),
	KEY eb_mudanca_aprovado_por (eb_mudanca_aprovado_por),
	CONSTRAINT baseline_eb_mudanca_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_mudanca_projeto FOREIGN KEY (eb_mudanca_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_mudanca_preparado FOREIGN KEY (eb_mudanca_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_mudanca_aprovado FOREIGN KEY (eb_mudanca_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_mudanca_item;

CREATE TABLE baseline_eb_mudanca_item (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_mudanca_item_id INTEGER(100) UNSIGNED NOT NULL,
	eb_mudanca_item_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_item_contato INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_item_papel VARCHAR(255),
	eb_mudanca_item_responsabilidade TEXT,
	eb_mudanca_item_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (baseline_id, eb_mudanca_item_id),
	KEY baseline_id (baseline_id),
	KEY eb_mudanca_item_projeto (eb_mudanca_item_projeto),
	KEY eb_mudanca_item_contato (eb_mudanca_item_contato),
	CONSTRAINT baseline_eb_mudanca_item_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_mudanca_item_projeto FOREIGN KEY (eb_mudanca_item_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_mudanca_item_contato FOREIGN KEY (eb_mudanca_item_contato) REFERENCES contatos (contato_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_qualidade;

CREATE TABLE baseline_eb_qualidade (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_qualidade_id INTEGER(100) UNSIGNED NOT NULL,
	eb_qualidade_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_qualidade_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_qualidade_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_qualidade_data_preparado DATE DEFAULT NULL,
	eb_qualidade_data_aprovado DATE DEFAULT NULL,
	eb_qualidade_data_revisado DATE DEFAULT NULL,
	eb_qualidade_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_qualidade_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_qualidade_requisito TEXT,
	PRIMARY KEY (baseline_id, eb_qualidade_id),
	KEY baseline_id (baseline_id),
	KEY eb_qualidade_projeto (eb_qualidade_projeto),
	KEY eb_qualidade_preparado_por (eb_qualidade_preparado_por),
	KEY eb_qualidade_data_aprovado (eb_qualidade_data_aprovado),
	CONSTRAINT baseline_eb_qualidade_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_qualidade_projeto FOREIGN KEY (eb_qualidade_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_qualidade_preparado FOREIGN KEY (eb_qualidade_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_qualidade_aprovado FOREIGN KEY (eb_qualidade_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_qualidade_item;

CREATE TABLE baseline_eb_qualidade_item (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_qualidade_item_id INTEGER(100) UNSIGNED NOT NULL,
	eb_qualidade_item_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_qualidade_item_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_qualidade_item_contato INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_qualidade_item_requisito TEXT,
	eb_qualidade_item_meta TEXT,
	eb_qualidade_item_indicador TEXT,
	eb_qualidade_item_desempenho TEXT,
	eb_qualidade_item_acao TEXT,
	eb_qualidade_item_recurso TEXT,
	eb_qualidade_item_treinamento TEXT,
	eb_qualidade_item_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (baseline_id, eb_qualidade_item_id),
	KEY baseline_id (baseline_id),
	KEY eb_qualidade_item_projeto (eb_qualidade_item_projeto),
	KEY eb_qualidade_item_tarefa (eb_qualidade_item_tarefa),
	KEY eb_qualidade_item_contato (eb_qualidade_item_contato),
	CONSTRAINT baseline_eb_qualidade_item_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_qualidade_item_projeto FOREIGN KEY (eb_qualidade_item_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_qualidade_item_tarefa FOREIGN KEY (eb_qualidade_item_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_qualidade_item_contato FOREIGN KEY (eb_qualidade_item_contato) REFERENCES contatos (contato_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_risco_item;

CREATE TABLE baseline_eb_risco_item (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
  eb_risco_item_id INTEGER(100) UNSIGNED NOT NULL,
  eb_risco_item_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_risco_item_contato INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_risco_item_usuario_inseriu INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_risco_item_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_risco_item_descricao VARCHAR(255) DEFAULT NULL,
  eb_risco_item_categoria VARCHAR(1) DEFAULT NULL,
  eb_risco_item_probabilidade1 VARCHAR(1) DEFAULT NULL,
  eb_risco_item_impacto1 VARCHAR(1) DEFAULT NULL,
  eb_risco_item_criticidade1 VARCHAR(1) DEFAULT NULL,
  eb_risco_item_estrategia VARCHAR(20) DEFAULT NULL,
  eb_risco_item_acao_proposta TEXT,
  eb_risco_item_probabilidade2 VARCHAR(1) DEFAULT NULL,
  eb_risco_item_impacto2 VARCHAR(1) DEFAULT NULL,
  eb_risco_item_criticidade2 VARCHAR(1) DEFAULT NULL,
  eb_risco_item_data DATE DEFAULT NULL,
  eb_risco_item_data_inseriu DATETIME DEFAULT NULL,
  PRIMARY KEY (baseline_id, eb_risco_item_id),
	KEY baseline_id (baseline_id),
  KEY eb_risco_item_projeto (eb_risco_item_projeto),
  KEY eb_risco_item_usuario_inseriu (eb_risco_item_usuario_inseriu),
  KEY eb_risco_item_contato (eb_risco_item_contato),
	CONSTRAINT baseline_eb_risco_item_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_risco_item_contato FOREIGN KEY (eb_risco_item_contato) REFERENCES contatos (contato_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_risco_item_projeto FOREIGN KEY (eb_risco_item_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_risco_item_usuario FOREIGN KEY (eb_risco_item_usuario_inseriu) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_risco;

CREATE TABLE baseline_eb_risco (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_risco_id INTEGER(100) UNSIGNED NOT NULL,
	eb_risco_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_risco_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_risco_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_risco_data_preparado DATE DEFAULT NULL,
	eb_risco_data_aprovado DATE DEFAULT NULL,
	eb_risco_data_revisado DATE DEFAULT NULL,
	eb_risco_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_risco_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (baseline_id, eb_risco_id),
	KEY baseline_id (baseline_id),
	KEY eb_risco_projeto (eb_risco_projeto),
	KEY eb_risco_preparado_por (eb_risco_preparado_por),
	KEY eb_risco_aprovado_por (eb_risco_aprovado_por),
	CONSTRAINT baseline_eb_risco_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_risco_projeto FOREIGN KEY (eb_risco_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_risco_preparado FOREIGN KEY (eb_risco_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_risco_aprovado FOREIGN KEY (eb_risco_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_interessado;

CREATE TABLE baseline_eb_interessado (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_interessado_id INTEGER(100) UNSIGNED NOT NULL,
	eb_interessado_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_interessado_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_interessado_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_interessado_data_preparado DATE DEFAULT NULL,
	eb_interessado_data_aprovado DATE DEFAULT NULL,
	eb_interessado_data_revisado DATE DEFAULT NULL,
	eb_interessado_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_interessado_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (baseline_id, eb_interessado_id),
	KEY baseline_id (baseline_id),
	KEY eb_interessado_projeto (eb_interessado_projeto),
	KEY eb_interessado_preparado_por (eb_interessado_preparado_por),
	KEY eb_interessado_aprovado_por (eb_interessado_aprovado_por),
	CONSTRAINT baseline_eb_interessado_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_interessado_projeto FOREIGN KEY (eb_interessado_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_interessado_preparado FOREIGN KEY (eb_interessado_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_interessado_aprovado FOREIGN KEY (eb_interessado_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_comunicacao;

CREATE TABLE baseline_eb_comunicacao (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_comunicacao_id INTEGER(100) UNSIGNED NOT NULL,
	eb_comunicacao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_comunicacao_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_comunicacao_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_comunicacao_data_preparado DATE DEFAULT NULL,
	eb_comunicacao_data_aprovado DATE DEFAULT NULL,
	eb_comunicacao_data_revisado DATE DEFAULT NULL,
	eb_comunicacao_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_comunicacao_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (baseline_id, eb_comunicacao_id),
	KEY baseline_id (baseline_id),
	KEY eb_comunicacao_projeto (eb_comunicacao_projeto),
	KEY eb_comunicacao_preparado_por (eb_comunicacao_preparado_por),
	KEY eb_comunicacao_aprovado_por (eb_comunicacao_aprovado_por),
	CONSTRAINT baseline_eb_comunicacao_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_comunicacao_projeto FOREIGN KEY (eb_comunicacao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_comunicacao_preparado FOREIGN KEY (eb_comunicacao_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_comunicacao_aprovado FOREIGN KEY (eb_comunicacao_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_humano;

CREATE TABLE baseline_eb_humano (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_humano_id INTEGER(100) UNSIGNED NOT NULL,
	eb_humano_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_humano_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_humano_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_humano_data_preparado DATE DEFAULT NULL,
	eb_humano_data_aprovado DATE DEFAULT NULL,
	eb_humano_data_revisado DATE DEFAULT NULL,
	eb_humano_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_humano_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_humano_finalidade TEXT,
	eb_humano_organograma VARCHAR(255),
	eb_humano_avaliacao TEXT,
	PRIMARY KEY (baseline_id, eb_humano_id),
	KEY baseline_id (baseline_id),
	KEY eb_humano_projeto (eb_humano_projeto),
	KEY eb_humano_preparado_por (eb_humano_preparado_por),
	KEY eb_humano_data_aprovado (eb_humano_data_aprovado),
	CONSTRAINT baseline_eb_humano_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_humano_projeto FOREIGN KEY (eb_humano_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_humano_preparado FOREIGN KEY (eb_humano_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_humano_aprovado FOREIGN KEY (eb_humano_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_humano_matriz;

CREATE TABLE baseline_eb_humano_matriz (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_humano_matriz_id INTEGER(100) UNSIGNED NOT NULL,
	eb_humano_matriz_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_humano_matriz_contato INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_humano_matriz_area VARCHAR(255),
	eb_humano_matriz_responsabilidade TEXT,
	eb_humano_matriz_escopo INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_humano_matriz_tempo INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_humano_matriz_custo INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_humano_matriz_qualidade INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_humano_matriz_rh INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_humano_matriz_comunicacao INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_humano_matriz_riscos INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_humano_matriz_contratos INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_humano_matriz_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (baseline_id, eb_humano_matriz_id),
	KEY baseline_id (baseline_id),
	KEY eb_humano_matriz_projeto (eb_humano_matriz_projeto),
	KEY eb_humano_matriz_contato (eb_humano_matriz_contato),
	CONSTRAINT baseline_eb_humano_matriz_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_humano_matriz_projeto FOREIGN KEY (eb_humano_matriz_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_humano_matriz_contato FOREIGN KEY (eb_humano_matriz_contato) REFERENCES contatos (contato_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_plano_item;

CREATE TABLE baseline_eb_plano_item (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
  eb_plano_item_id INTEGER(100) UNSIGNED NOT NULL,
  eb_plano_item_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_plano_item_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_plano_item_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_plano_item_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_plano_item_nome VARCHAR(255) DEFAULT NULL,
  eb_plano_item_quando TEXT,
  eb_plano_item_oque TEXT,
  eb_plano_item_como TEXT,
  eb_plano_item_onde TEXT,
  eb_plano_item_quanto TEXT,
  eb_plano_item_porque TEXT,
  eb_plano_item_quem TEXT,
  eb_plano_item_inicio DATETIME DEFAULT NULL,
  eb_plano_item_fim DATETIME DEFAULT NULL,
  eb_plano_item_duracao DECIMAL(20,5) UNSIGNED DEFAULT NULL,
  eb_plano_item_acesso INTEGER(100) UNSIGNED DEFAULT 0,
  eb_plano_item_principal_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (baseline_id, eb_plano_item_id),
	KEY baseline_id (baseline_id),
  KEY eb_plano_item_projeto (eb_plano_item_projeto),
  KEY eb_plano_item_responsavel (eb_plano_item_responsavel),
  KEY eb_plano_item_cia (eb_plano_item_cia),
	KEY eb_plano_item_principal_indicador (eb_plano_item_principal_indicador),
	CONSTRAINT baseline_eb_plano_item_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_plano_item_projeto FOREIGN KEY (eb_plano_item_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_plano_item_responsavel FOREIGN KEY (eb_plano_item_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_plano_item_indicador FOREIGN KEY (eb_plano_item_principal_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_plano_item_cia FOREIGN KEY (eb_plano_item_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_eb_plano;

CREATE TABLE baseline_eb_plano (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_plano_id INTEGER(100) UNSIGNED NOT NULL,
	eb_plano_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_plano_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_plano_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_plano_data_preparado DATE DEFAULT NULL,
	eb_plano_data_aprovado DATE DEFAULT NULL,
	eb_plano_data_revisado DATE DEFAULT NULL,
	eb_plano_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_plano_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_plano_sintese TEXT,
	eb_plano_objetivo TEXT,
	eb_plano_info TEXT,
	eb_plano_anexo TEXT,
	PRIMARY KEY (baseline_id, eb_plano_id),
	KEY baseline_id (baseline_id),
	KEY eb_plano_projeto (eb_plano_projeto),
	KEY eb_plano_preparado_por (eb_plano_preparado_por),
	KEY eb_plano_data_aprovado (eb_plano_data_aprovado),
	CONSTRAINT baseline_eb_plano_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_plano_projeto FOREIGN KEY (eb_plano_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_plano_preparado FOREIGN KEY (eb_plano_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_plano_aprovado FOREIGN KEY (eb_plano_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_escopo;

CREATE TABLE baseline_eb_escopo (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_escopo_id INTEGER(100) UNSIGNED NOT NULL,
	eb_escopo_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_escopo_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_escopo_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_escopo_data_preparado DATE DEFAULT NULL,
	eb_escopo_data_aprovado DATE DEFAULT NULL,
	eb_escopo_data_revisado DATE DEFAULT NULL,
	eb_escopo_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_escopo_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (baseline_id, eb_escopo_id),
	KEY baseline_id (baseline_id),
	KEY eb_escopo_projeto (eb_escopo_projeto),
	KEY eb_escopo_preparado_por (eb_escopo_preparado_por),
	KEY eb_escopo_aprovado_por (eb_escopo_aprovado_por),
	CONSTRAINT baseline_eb_escopo_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_escopo_projeto FOREIGN KEY (eb_escopo_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_escopo_preparado FOREIGN KEY (eb_escopo_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_escopo_aprovado FOREIGN KEY (eb_escopo_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_iniciacao;

CREATE TABLE baseline_eb_iniciacao (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_iniciacao_id INTEGER(100) UNSIGNED NOT NULL,
	eb_iniciacao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_iniciacao_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_iniciacao_data_aprovado DATE DEFAULT NULL,
	PRIMARY KEY (baseline_id, eb_iniciacao_id),
	KEY baseline_id (baseline_id),
	KEY eb_iniciacao_projeto (eb_iniciacao_projeto),
	KEY eb_iniciacao_aprovado_por (eb_iniciacao_aprovado_por),
	CONSTRAINT baseline_eb_iniciacao_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_iniciacao_projeto FOREIGN KEY (eb_iniciacao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_iniciacao_aprovado FOREIGN KEY (eb_iniciacao_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS baseline_eb_iniciacao_envolvido;

CREATE TABLE baseline_eb_iniciacao_envolvido (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
  eb_iniciacao_envolvido_id INTEGER(100) UNSIGNED NOT NULL,
  projeto_id INTEGER(100) UNSIGNED DEFAULT NULL,
  contato_id INTEGER(100) UNSIGNED DEFAULT NULL,
  ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (baseline_id, eb_iniciacao_envolvido_id),
	KEY baseline_id (baseline_id),
  KEY projeto_id (projeto_id),
  KEY contato_id (contato_id),
	CONSTRAINT baseline_eb_iniciacao_envolvido_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_iniciacao_envolvido_contato FOREIGN KEY (contato_id) REFERENCES contatos (contato_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_iniciacao_envolvido_projeto FOREIGN KEY (projeto_id) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_implantacao;

CREATE TABLE baseline_eb_implantacao (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_implantacao_id INTEGER(100) UNSIGNED NOT NULL,
	eb_implantacao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_implantacao_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_implantacao_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_implantacao_data_preparado DATE DEFAULT NULL,
	eb_implantacao_data_aprovado DATE DEFAULT NULL,
	eb_implantacao_data_revisado DATE DEFAULT NULL,
	eb_implantacao_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_implantacao_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (baseline_id, eb_implantacao_id),
	KEY baseline_id (baseline_id),
	KEY eb_implantacao_projeto (eb_implantacao_projeto),
	KEY eb_implantacao_preparado_por (eb_implantacao_preparado_por),
	KEY eb_implantacao_aprovado_por (eb_implantacao_aprovado_por),
	CONSTRAINT baseline_eb_implantacao_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_implantacao_projeto FOREIGN KEY (eb_implantacao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_implantacao_preparado FOREIGN KEY (eb_implantacao_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_implantacao_aprovado FOREIGN KEY (eb_implantacao_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_viabilidade;

CREATE TABLE baseline_eb_viabilidade (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_viabilidade_id INTEGER(100) UNSIGNED NOT NULL,
	eb_viabilidade_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_viabilidade_preparado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_viabilidade_aprovado_por INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_viabilidade_data_preparado DATE DEFAULT NULL,
	eb_viabilidade_data_aprovado DATE DEFAULT NULL,
	eb_viabilidade_data_revisado DATE DEFAULT NULL,
	eb_viabilidade_folha_de INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_viabilidade_folha_ate INTEGER(10) UNSIGNED DEFAULT NULL,
	eb_viabilidade_planejamento_inicio DATE DEFAULT NULL,
	eb_viabilidade_planejamento_fim DATE DEFAULT NULL,
	eb_viabilidade_execucao_inicio DATE DEFAULT NULL,
	eb_viabilidade_execucao_fim DATE DEFAULT NULL,
	eb_viabilidade_recurso_inicio DATE DEFAULT NULL,
	eb_viabilidade_recurso_fim DATE DEFAULT NULL,
	eb_viabilidade_data_compensador DATE DEFAULT NULL,
	eb_viabilidade_implementacao_inicio DATE DEFAULT NULL,
	eb_viabilidade_implementacao_fim DATE DEFAULT NULL,
	PRIMARY KEY (baseline_id, eb_viabilidade_id),
	KEY baseline_id (baseline_id),
	KEY eb_viabilidade_projeto (eb_viabilidade_projeto),
	KEY eb_viabilidade_preparado_por (eb_viabilidade_preparado_por),
	KEY eb_viabilidade_aprovado_por (eb_viabilidade_aprovado_por),
	CONSTRAINT baseline_eb_viabilidade_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_viabilidade_projeto FOREIGN KEY (eb_viabilidade_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_viabilidade_preparado FOREIGN KEY (eb_viabilidade_preparado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_viabilidade_aprovado FOREIGN KEY (eb_viabilidade_aprovado_por) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_viabilidade_envolvido;

CREATE TABLE baseline_eb_viabilidade_envolvido (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
  eb_viabilidade_envolvido_id INTEGER(100) UNSIGNED NOT NULL,
  projeto_id INTEGER(100) UNSIGNED DEFAULT NULL,
  contato_id INTEGER(100) UNSIGNED DEFAULT NULL,
  ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (baseline_id, eb_viabilidade_envolvido_id),
	KEY baseline_id (baseline_id),
  KEY projeto_id (projeto_id),
  KEY contato_id (contato_id),
	CONSTRAINT baseline_eb_viabilidade_envolvido_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_viabilidade_envolvido_contato FOREIGN KEY (contato_id) REFERENCES contatos (contato_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_viabilidade_envolvido_projeto FOREIGN KEY (projeto_id) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_encerramento_campo;

CREATE TABLE baseline_eb_encerramento_campo (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_encerramento_campo_id INTEGER(100) UNSIGNED NOT NULL,
	eb_encerramento_campo_encerramento INTEGER(100) UNSIGNED NOT NULL,
	eb_encerramento_campo_texto TEXT,
	eb_encerramento_campo_titulo VARCHAR(50),
	PRIMARY KEY (baseline_id, eb_encerramento_campo_id),
	KEY baseline_id (baseline_id),
	KEY eb_encerramento_campo_id (eb_encerramento_campo_id),
	CONSTRAINT baseline_eb_encerramento_campo_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_encerramento_campo_encerramento FOREIGN KEY (eb_encerramento_campo_encerramento) REFERENCES eb_encerramento (eb_encerramento_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_situacao_campo;

CREATE TABLE baseline_eb_situacao_campo (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_situacao_campo_id INTEGER(100) UNSIGNED NOT NULL,
	eb_situacao_campo_situacao INTEGER(100) UNSIGNED NOT NULL,
	eb_situacao_campo_texto TEXT,
	eb_situacao_campo_titulo VARCHAR(50),
	PRIMARY KEY (baseline_id, eb_situacao_campo_id),
	KEY baseline_id (baseline_id),
	KEY eb_situacao_campo_id (eb_situacao_campo_id),
	KEY eb_situacao_campo_situacao (eb_situacao_campo_situacao),
	CONSTRAINT baseline_eb_situacao_campo_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_situacao_campo_situacao FOREIGN KEY (eb_situacao_campo_situacao) REFERENCES eb_situacao (eb_situacao_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_mudanca_controle_campo;

CREATE TABLE baseline_eb_mudanca_controle_campo (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_mudanca_controle_campo_id INTEGER(100) UNSIGNED NOT NULL,
	eb_mudanca_controle_campo_mudanca INTEGER(100) UNSIGNED NOT NULL,
	eb_mudanca_controle_campo_texto TEXT,
	eb_mudanca_controle_campo_titulo VARCHAR(50),
  PRIMARY KEY (baseline_id, eb_mudanca_controle_campo_id),
	KEY baseline_id (baseline_id),
	KEY eb_mudanca_controle_campo_id (eb_mudanca_controle_campo_id),
	CONSTRAINT baseline_eb_mudanca_controle_campo_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_mudanca_controle_campo_mudanca FOREIGN KEY (eb_mudanca_controle_campo_mudanca) REFERENCES eb_mudanca_controle (eb_mudanca_controle_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_mudanca_controle_item;

CREATE TABLE baseline_eb_mudanca_controle_item (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_mudanca_controle_item_id INTEGER(100) UNSIGNED NOT NULL,
	eb_mudanca_controle_item_mudanca_controle INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_item_contato INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_item_papel VARCHAR(255),
	eb_mudanca_controle_item_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_item_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (baseline_id, eb_mudanca_controle_item_id),
	KEY baseline_id (baseline_id),
	KEY eb_mudanca_controle_item_mudanca_controle (eb_mudanca_controle_item_mudanca_controle),
	KEY eb_mudanca_controle_item_contato (eb_mudanca_controle_item_contato),
	CONSTRAINT baseline_eb_mudanca_controle_item_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_mudanca_controle_item_controle FOREIGN KEY (eb_mudanca_controle_item_mudanca_controle) REFERENCES eb_mudanca_controle (eb_mudanca_controle_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_mudanca_controle_item_contato FOREIGN KEY (eb_mudanca_controle_item_contato) REFERENCES contatos (contato_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_mudanca_controle_escopo;

CREATE TABLE baseline_eb_mudanca_controle_escopo (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_mudanca_controle_escopo_id INTEGER(100) UNSIGNED NOT NULL,
	eb_mudanca_controle_escopo_mudanca_controle INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_escopo_tipo INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_escopo_entrega TEXT,
	eb_mudanca_controle_escopo_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_escopo_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (baseline_id, eb_mudanca_controle_escopo_id),
	KEY baseline_id (baseline_id),
	KEY eb_mudanca_controle_escopo_mudanca_controle (eb_mudanca_controle_escopo_mudanca_controle),
	CONSTRAINT baseline_eb_mudanca_controle_escopo_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_mudanca_controle_escopo_controle FOREIGN KEY (eb_mudanca_controle_escopo_mudanca_controle) REFERENCES eb_mudanca_controle (eb_mudanca_controle_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_mudanca_controle_custo;

CREATE TABLE baseline_eb_mudanca_controle_custo (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_mudanca_controle_custo_id INTEGER(100) UNSIGNED NOT NULL,
	eb_mudanca_controle_custo_mudanca_controle INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_custo_produto TEXT,
	eb_mudanca_controle_custo_antes DECIMAL(20,5) UNSIGNED DEFAULT 0,
	eb_mudanca_controle_custo_depois DECIMAL(20,5) UNSIGNED DEFAULT 0,
	eb_mudanca_controle_custo_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_mudanca_controle_custo_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (baseline_id, eb_mudanca_controle_custo_id),
	KEY baseline_id (baseline_id),
	KEY eb_mudanca_controle_custo_mudanca_controle (eb_mudanca_controle_custo_mudanca_controle),
	CONSTRAINT baseline_eb_mudanca_controle_custo_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_mudanca_controle_custo_controle FOREIGN KEY (eb_mudanca_controle_custo_mudanca_controle) REFERENCES eb_mudanca_controle (eb_mudanca_controle_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_mudanca_campo;

CREATE TABLE baseline_eb_mudanca_campo (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_mudanca_campo_id INTEGER(100) UNSIGNED NOT NULL,
	eb_mudanca_campo_mudanca INTEGER(100) UNSIGNED NOT NULL,
	eb_mudanca_campo_texto TEXT,
	eb_mudanca_campo_titulo VARCHAR(50),
	PRIMARY KEY (baseline_id, eb_mudanca_campo_id),
	KEY baseline_id (baseline_id),
	KEY eb_mudanca_campo_id (eb_mudanca_campo_id),
	KEY eb_mudanca_campo_mudanca (eb_mudanca_campo_mudanca),
	CONSTRAINT baseline_eb_mudanca_campo_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_mudanca_campo_mudanca FOREIGN KEY (eb_mudanca_campo_mudanca) REFERENCES eb_mudanca (eb_mudanca_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_interessado_campo;

CREATE TABLE baseline_eb_interessado_campo (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_interessado_campo_id INTEGER(100) UNSIGNED NOT NULL,
	eb_interessado_campo_interessado INTEGER(100) UNSIGNED NOT NULL,
	eb_interessado_campo_texto TEXT,
	eb_interessado_campo_titulo VARCHAR(50),
	PRIMARY KEY (baseline_id, eb_interessado_campo_id),
	KEY baseline_id (baseline_id),
	KEY eb_interessado_campo_id (eb_interessado_campo_id),
	KEY eb_interessado_campo_interessado (eb_interessado_campo_interessado),
	CONSTRAINT baseline_eb_interessado_campo_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_interessado_campo_interessado FOREIGN KEY (eb_interessado_campo_interessado) REFERENCES eb_interessado (eb_interessado_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_comunicacao_campo;

CREATE TABLE baseline_eb_comunicacao_campo (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_comunicacao_campo_id INTEGER(100) UNSIGNED NOT NULL,
	eb_comunicacao_campo_comunicacao INTEGER(100) UNSIGNED NOT NULL,
	eb_comunicacao_campo_texto TEXT,
	eb_comunicacao_campo_titulo VARCHAR(50),
	PRIMARY KEY (baseline_id, eb_comunicacao_campo_id),
	KEY baseline_id (baseline_id),
	KEY eb_comunicacao_campo_id (eb_comunicacao_campo_id),
	CONSTRAINT baseline_eb_comunicacao_campo_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_comunicacao_campo_comunicacao FOREIGN KEY (eb_comunicacao_campo_comunicacao) REFERENCES eb_comunicacao (eb_comunicacao_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_plano_item_depts;

CREATE TABLE baseline_eb_plano_item_depts (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_plano_item_depts_id INTEGER(100) UNSIGNED NOT NULL,
  eb_plano_item_id INTEGER(100) UNSIGNED DEFAULT NULL,
  dept_id INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (baseline_id, eb_plano_item_depts_id),
	KEY baseline_id (baseline_id),
  KEY eb_plano_item_id (eb_plano_item_id),
  KEY dept_id (dept_id),
	CONSTRAINT baseline_eb_plano_item_depts_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_plano_item_depts_dept FOREIGN KEY (dept_id) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_plano_item_depts_item FOREIGN KEY (eb_plano_item_id) REFERENCES eb_plano_item (eb_plano_item_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_plano_item_custos;

CREATE TABLE baseline_eb_plano_item_custos (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
  eb_plano_item_custos_id INTEGER(100) UNSIGNED NOT NULL,
  eb_plano_item_custos_eb_plano_item INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_plano_item_custos_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_plano_item_custos_tipo INTEGER(100) UNSIGNED DEFAULT 1,
  eb_plano_item_custos_nome VARCHAR(255) DEFAULT NULL,
  eb_plano_item_custos_data DATETIME DEFAULT NULL,
  eb_plano_item_custos_quantidade DECIMAL(20,5) UNSIGNED DEFAULT 0,
  eb_plano_item_custos_custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
  eb_plano_item_custos_percentagem TINYINT(4) DEFAULT 0,
  eb_plano_item_custos_descricao TEXT,
  eb_plano_item_custos_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_plano_item_custos_nd VARCHAR(11) DEFAULT NULL,
  eb_plano_item_custos_categoria_economica VARCHAR(1) DEFAULT NULL,
  eb_plano_item_custos_grupo_despesa VARCHAR(1) DEFAULT NULL,
  eb_plano_item_custos_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  eb_plano_item_custos_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_plano_item_custos_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
  eb_plano_item_custos_data_limite DATE DEFAULT NULL,
  uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (baseline_id, eb_plano_item_custos_id),
	KEY baseline_id (baseline_id),
  KEY idxeb_plano_item_custos_eb_plano_item (eb_plano_item_custos_eb_plano_item),
  KEY idxeb_plano_item_custos_usuario_inicio (eb_plano_item_custos_usuario),
  KEY idxeb_plano_item_custos_ordem (eb_plano_item_custos_ordem),
  KEY idxeb_plano_item_custos_data_inicio (eb_plano_item_custos_data),
  KEY idxeb_plano_item_custos_nome (eb_plano_item_custos_nome),
	CONSTRAINT baseline_eb_plano_item_custos_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_plano_item_custos_item FOREIGN KEY (eb_plano_item_custos_eb_plano_item) REFERENCES eb_plano_item (eb_plano_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_plano_item_custos_usuario FOREIGN KEY (eb_plano_item_custos_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_plano_item_designados;

CREATE TABLE baseline_eb_plano_item_designados (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_plano_item_designados_id INTEGER(100) UNSIGNED NOT NULL,
  eb_plano_item_id INTEGER(100) UNSIGNED DEFAULT NULL,
  usuario_id INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (baseline_id, eb_plano_item_designados_id),
	KEY baseline_id (baseline_id),
	KEY eb_plano_item_id (eb_plano_item_id),
  KEY usuario_id (usuario_id),
  KEY eb_plano_item_designados_id (eb_plano_item_designados_id),
	CONSTRAINT baseline_eb_plano_item_designados_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_plano_item_designados_usuario FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_plano_item_designados_item FOREIGN KEY (eb_plano_item_id) REFERENCES eb_plano_item (eb_plano_item_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_plano_item_gastos;

CREATE TABLE baseline_eb_plano_item_gastos (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
  eb_plano_item_gastos_id INTEGER(100) UNSIGNED NOT NULL,
  eb_plano_item_gastos_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_plano_item_gastos_eb_plano_item INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_plano_item_gastos_tipo INTEGER(100) UNSIGNED DEFAULT 1,
  eb_plano_item_gastos_nome VARCHAR(255) DEFAULT NULL,
  eb_plano_item_gastos_data DATETIME DEFAULT NULL,
  eb_plano_item_gastos_data_recebido DATETIME DEFAULT NULL,
  eb_plano_item_gastos_quantidade DECIMAL(20,5) UNSIGNED DEFAULT 0,
  eb_plano_item_gastos_custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
  eb_plano_item_gastos_percentagem TINYINT(4) DEFAULT 0,
  eb_plano_item_gastos_descricao TEXT,
  eb_plano_item_gastos_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  eb_plano_item_gastos_nd VARCHAR(11) DEFAULT NULL,
  eb_plano_item_gastos_categoria_economica VARCHAR(1) DEFAULT NULL,
  eb_plano_item_gastos_grupo_despesa VARCHAR(1) DEFAULT NULL,
  eb_plano_item_gastos_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  eb_plano_item_gastos_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	eb_plano_item_gastos_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
  eb_plano_item_custos_data_recebido DATE DEFAULT NULL,
  uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (baseline_id, eb_plano_item_gastos_id),
	KEY baseline_id (baseline_id),
  KEY idxeb_plano_item_gastos_eb_plano_item (eb_plano_item_gastos_eb_plano_item),
  KEY idxeb_plano_item_gastos_usuario_inicio (eb_plano_item_gastos_usuario),
  KEY idxeb_plano_item_gastos_ordem (eb_plano_item_gastos_ordem),
  KEY idxeb_plano_item_gastos_data_inicio (eb_plano_item_gastos_data),
  KEY idxeb_plano_item_gastos_nome (eb_plano_item_gastos_nome),
	CONSTRAINT baseline_eb_plano_item_gastos_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_plano_item_gastos_item FOREIGN KEY (eb_plano_item_gastos_eb_plano_item) REFERENCES eb_plano_item (eb_plano_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_plano_item_gastos_usuario FOREIGN KEY (eb_plano_item_gastos_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_plano_item_h_custos;

CREATE TABLE baseline_eb_plano_item_h_custos (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
  h_custos_id INTEGER(100) UNSIGNED NOT NULL,
  h_custos_eb_plano_item INTEGER(100) UNSIGNED DEFAULT NULL,
  h_custos_eb_plano_item_custos_id INTEGER(100) UNSIGNED DEFAULT NULL,
  h_custos_nome1 VARCHAR(255) DEFAULT NULL,
  h_custos_nome2 VARCHAR(255) DEFAULT NULL,
  h_custos_tipo1 INTEGER(100) UNSIGNED DEFAULT 1,
  h_custos_tipo2 INTEGER(100) UNSIGNED DEFAULT 1,
  h_custos_usuario1 INTEGER(100) UNSIGNED DEFAULT NULL,
  h_custos_usuario2 INTEGER(100) UNSIGNED DEFAULT NULL,
  h_custos_data1 DATETIME DEFAULT NULL,
  h_custos_data2 DATETIME DEFAULT NULL,
  h_custos_quantidade1 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_custos_quantidade2 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_custos_custo1 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_custos_custo2 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_custos_percentagem1 TINYINT(4) DEFAULT 0,
  h_custos_percentagem2 TINYINT(4) DEFAULT 0,
  h_custos_descricao1 TEXT,
  h_custos_descricao2 TEXT,
  h_custos_nd1 VARCHAR(20) DEFAULT NULL,
  h_custos_nd2 VARCHAR(20) DEFAULT NULL,
  h_custos_categoria_economica1 VARCHAR(1) DEFAULT NULL,
  h_custos_grupo_despesa1 VARCHAR(1) DEFAULT NULL,
  h_custos_modalidade_aplicacao1 VARCHAR(2) DEFAULT NULL,
  h_custos_categoria_economica2 VARCHAR(1) DEFAULT NULL,
  h_custos_grupo_despesa2 VARCHAR(1) DEFAULT NULL,
  h_custos_modalidade_aplicacao2 VARCHAR(2) DEFAULT NULL,
  h_custos_metodo1 INTEGER(100) UNSIGNED DEFAULT NULL,
	h_custos_metodo2 INTEGER(100) UNSIGNED DEFAULT NULL,
	h_custos_exercicio1 INTEGER(4) UNSIGNED DEFAULT NULL,
	h_custos_exercicio2 INTEGER(4) UNSIGNED DEFAULT NULL,
  h_custos_excluido TINYINT(1) DEFAULT 0,
  uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (baseline_id, h_custos_id),
	KEY baseline_id (baseline_id),
  KEY h_custos_eb_plano_item_custos_id (h_custos_eb_plano_item_custos_id),
	CONSTRAINT baseline_eb_plano_item_h_custos_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_plano_item_h_custos_custo FOREIGN KEY (h_custos_eb_plano_item_custos_id) REFERENCES eb_plano_item_custos (eb_plano_item_custos_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_plano_item_h_gastos;

CREATE TABLE baseline_eb_plano_item_h_gastos (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
  h_gastos_id INTEGER(100) UNSIGNED NOT NULL,
  h_gastos_eb_plano_item_gastos_id INTEGER(100) UNSIGNED DEFAULT NULL,
  h_gastos_eb_plano_item INTEGER(100) UNSIGNED DEFAULT NULL,
  h_gastos_nome1 VARCHAR(255) DEFAULT NULL,
  h_gastos_nome2 VARCHAR(255) DEFAULT NULL,
  h_gastos_tipo1 INTEGER(100) UNSIGNED DEFAULT 1,
  h_gastos_tipo2 INTEGER(100) UNSIGNED DEFAULT 1,
  h_gastos_usuario1 INTEGER(100) UNSIGNED DEFAULT NULL,
  h_gastos_usuario2 INTEGER(100) UNSIGNED DEFAULT NULL,
  h_gastos_data1 DATETIME DEFAULT NULL,
  h_gastos_data2 DATETIME DEFAULT NULL,
  h_gastos_quantidade1 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_gastos_quantidade2 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_gastos_custo1 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_gastos_custo2 DECIMAL(20,5) UNSIGNED DEFAULT 0,
  h_gastos_percentagem1 TINYINT(4) DEFAULT 0,
  h_gastos_percentagem2 TINYINT(4) DEFAULT 0,
  h_gastos_descricao1 TEXT,
  h_gastos_descricao2 TEXT,
  h_gastos_nd1 VARCHAR(20) DEFAULT NULL,
  h_gastos_nd2 VARCHAR(20) DEFAULT NULL,
  h_gastos_categoria_economica1 VARCHAR(1) DEFAULT NULL,
  h_gastos_grupo_despesa1 VARCHAR(1) DEFAULT NULL,
  h_gastos_modalidade_aplicacao1 VARCHAR(2) DEFAULT NULL,
  h_gastos_categoria_economica2 VARCHAR(1) DEFAULT NULL,
  h_gastos_grupo_despesa2 VARCHAR(1) DEFAULT NULL,
  h_gastos_modalidade_aplicacao2 VARCHAR(2) DEFAULT NULL,
  h_gastos_metodo1 INTEGER(100) UNSIGNED DEFAULT NULL,
	h_gastos_metodo2 INTEGER(100) UNSIGNED DEFAULT NULL,
	h_gastos_exercicio1 INTEGER(4) UNSIGNED DEFAULT NULL,
	h_gastos_exercicio2 INTEGER(4) UNSIGNED DEFAULT NULL,
  h_gastos_excluido TINYINT(1) DEFAULT 0,
  uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (baseline_id, h_gastos_id),
	KEY baseline_id (baseline_id),
  KEY h_gastos_eb_plano_item_gastos_id (h_gastos_eb_plano_item_gastos_id),
	CONSTRAINT baseline_eb_plano_item_h_gastos_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT baseline_eb_plano_item_h_gastos_gasto FOREIGN KEY (h_gastos_eb_plano_item_gastos_id) REFERENCES eb_plano_item_gastos (eb_plano_item_gastos_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_escopo_campo;

CREATE TABLE baseline_eb_escopo_campo (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_escopo_campo_id INTEGER(100) UNSIGNED NOT NULL,
	eb_escopo_campo_escopo INTEGER(100) UNSIGNED NOT NULL,
	eb_escopo_campo_texto TEXT,
	eb_escopo_campo_titulo VARCHAR(50),
  PRIMARY KEY (baseline_id, eb_escopo_campo_id),
	KEY baseline_id (baseline_id),
	KEY eb_escopo_campo_id (eb_escopo_campo_id),
	CONSTRAINT baseline_eb_escopo_campo_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_escopo_campo_escopo FOREIGN KEY (eb_escopo_campo_escopo) REFERENCES eb_escopo (eb_escopo_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_iniciacao_campo;

CREATE TABLE baseline_eb_iniciacao_campo (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_iniciacao_campo_id INTEGER(100) UNSIGNED NOT NULL,
	eb_iniciacao_campo_iniciacao INTEGER(100) UNSIGNED NOT NULL,
	eb_iniciacao_campo_texto TEXT,
	eb_iniciacao_campo_titulo VARCHAR(50),
	PRIMARY KEY (baseline_id, eb_iniciacao_campo_id),
	KEY baseline_id (baseline_id),
	KEY eb_iniciacao_campo_id (eb_iniciacao_campo_id),
	KEY eb_iniciacao_campo_iniciacao (eb_iniciacao_campo_iniciacao),
	CONSTRAINT baseline_eb_iniciacao_campo_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_iniciacao_campo_iniciacao FOREIGN KEY (eb_iniciacao_campo_iniciacao) REFERENCES eb_iniciacao (eb_iniciacao_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_implantacao_campo;

CREATE TABLE baseline_eb_implantacao_campo (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_implantacao_campo_id INTEGER(100) UNSIGNED NOT NULL,
	eb_implantacao_campo_implantacao INTEGER(100) UNSIGNED NOT NULL,
	eb_implantacao_campo_texto TEXT,
	eb_implantacao_campo_titulo VARCHAR(50),
	PRIMARY KEY (baseline_id, eb_implantacao_campo_id),
	KEY baseline_id (baseline_id),
	KEY eb_implantacao_campo_implantacao (eb_implantacao_campo_implantacao),
	CONSTRAINT baseline_eb_implantacao_campo_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_implantacao_campo_implantacao FOREIGN KEY (eb_implantacao_campo_implantacao) REFERENCES eb_implantacao (eb_implantacao_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_eb_viabilidade_campo;

CREATE TABLE baseline_eb_viabilidade_campo (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	eb_viabilidade_campo_id INTEGER(100) UNSIGNED NOT NULL,
	eb_viabilidade_campo_viabilidade INTEGER(100) UNSIGNED NOT NULL,
	eb_viabilidade_campo_texto TEXT,
	eb_viabilidade_campo_titulo VARCHAR(50),
	PRIMARY KEY (baseline_id, eb_viabilidade_campo_id),
	KEY baseline_id (baseline_id),
	KEY eb_viabilidade_campo_id (eb_viabilidade_campo_id),
	KEY eb_viabilidade_campo_viabilidade (eb_viabilidade_campo_viabilidade),
	CONSTRAINT baseline_eb_viabilidade_campo_baseline FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT baseline_eb_viabilidade_campo_viabilidade FOREIGN KEY (eb_viabilidade_campo_viabilidade) REFERENCES eb_viabilidade (eb_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS tarefa_entrega;

CREATE TABLE tarefa_entrega (
  tarefa_entrega_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  tarefa_entrega_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_entrega_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_entrega_previsto INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_entrega_realizado INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_entrega_nome VARCHAR(255) DEFAULT NULL,
  tarefa_entrega_descricao MEDIUMTEXT,
  tarefa_entrega_prazo DATE DEFAULT NULL,
  tarefa_entrega_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_entrega_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (tarefa_entrega_id),
  KEY tarefa_entrega_tarefa (tarefa_entrega_tarefa),
  KEY tarefa_entrega_responsavel (tarefa_entrega_responsavel),
	CONSTRAINT tarefa_entrega_responsavel FOREIGN KEY (tarefa_entrega_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT tarefa_entrega_fk FOREIGN KEY (tarefa_entrega_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_tarefa_entrega;

CREATE TABLE baseline_tarefa_entrega (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
  tarefa_entrega_id INTEGER(100) UNSIGNED NOT NULL,
  tarefa_entrega_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_entrega_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_entrega_previsto INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_entrega_realizado INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_entrega_nome VARCHAR(255) DEFAULT NULL,
  tarefa_entrega_descricao MEDIUMTEXT,
  tarefa_entrega_prazo DATE DEFAULT NULL,
  tarefa_entrega_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  tarefa_entrega_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (baseline_id, tarefa_entrega_id),
  CONSTRAINT baseline_tarefa_entrega_fk FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS priorizacao_modelo;

CREATE TABLE priorizacao_modelo (
	priorizacao_modelo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	priorizacao_modelo_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_modelo_nome VARCHAR(255) DEFAULT NULL,
	priorizacao_modelo_tipo VARCHAR(20) DEFAULT NULL,
	priorizacao_modelo_descricao MEDIUMTEXT,
	priorizacao_modelo_variacao INTEGER(10) DEFAULT 0,
	priorizacao_modelo_projeto TINYINT(1) DEFAULT 0,
  priorizacao_modelo_tarefa TINYINT(1) DEFAULT 0,
  priorizacao_modelo_perspectiva TINYINT(1) DEFAULT 0,
  priorizacao_modelo_tema TINYINT(1) DEFAULT 0,
  priorizacao_modelo_objetivo TINYINT(1) DEFAULT 0,
  priorizacao_modelo_fator TINYINT(1) DEFAULT 0,
  priorizacao_modelo_estrategia TINYINT(1) DEFAULT 0,
  priorizacao_modelo_meta TINYINT(1) DEFAULT 0,
  priorizacao_modelo_pratica TINYINT(1) DEFAULT 0,
  priorizacao_modelo_indicador TINYINT(1) DEFAULT 0,
  priorizacao_modelo_acao TINYINT(1) DEFAULT 0,
  priorizacao_modelo_canvas TINYINT(1) DEFAULT 0,
  priorizacao_modelo_risco TINYINT(1) DEFAULT 0,
  priorizacao_modelo_risco_resposta TINYINT(1) DEFAULT 0,
  priorizacao_modelo_calendario TINYINT(1) DEFAULT 0,
  priorizacao_modelo_monitoramento TINYINT(1) DEFAULT 0,
  priorizacao_modelo_ata TINYINT(1) DEFAULT 0,
  priorizacao_modelo_mswot TINYINT(1) DEFAULT 0,
  priorizacao_modelo_swot TINYINT(1) DEFAULT 0,
  priorizacao_modelo_operativo TINYINT(1) DEFAULT 0,
  priorizacao_modelo_instrumento TINYINT(1) DEFAULT 0,
  priorizacao_modelo_recurso TINYINT(1) DEFAULT 0,
  priorizacao_modelo_problema TINYINT(1) DEFAULT 0,
  priorizacao_modelo_demanda TINYINT(1) DEFAULT 0,
  priorizacao_modelo_programa TINYINT(1) DEFAULT 0,
  priorizacao_modelo_licao TINYINT(1) DEFAULT 0,
  priorizacao_modelo_evento TINYINT(1) DEFAULT 0,
  priorizacao_modelo_link TINYINT(1) DEFAULT 0,
  priorizacao_modelo_avaliacao TINYINT(1) DEFAULT 0,
  priorizacao_modelo_tgn TINYINT(1) DEFAULT 0,
  priorizacao_modelo_brainstorm TINYINT(1) DEFAULT 0,
  priorizacao_modelo_gut TINYINT(1) DEFAULT 0,
  priorizacao_modelo_causa_efeito TINYINT(1) DEFAULT 0,
  priorizacao_modelo_arquivo TINYINT(1) DEFAULT 0,
  priorizacao_modelo_forum TINYINT(1) DEFAULT 0,
  priorizacao_modelo_checklist TINYINT(1) DEFAULT 0,
  priorizacao_modelo_agenda TINYINT(1) DEFAULT 0,
  priorizacao_modelo_agrupamento TINYINT(1) DEFAULT 0,
  priorizacao_modelo_patrocinador TINYINT(1) DEFAULT 0,
  priorizacao_modelo_template TINYINT(1) DEFAULT 0,
  priorizacao_modelo_painel TINYINT(1) DEFAULT 0,
	priorizacao_modelo_painel_odometro TINYINT(1) DEFAULT 0,
	priorizacao_modelo_painel_composicao TINYINT(1) DEFAULT 0,
	priorizacao_modelo_tr TINYINT(1) DEFAULT 0,
	priorizacao_modelo_me TINYINT(1) DEFAULT 0,
	priorizacao_modelo_acao_item TINYINT(1) DEFAULT 0,
	priorizacao_modelo_beneficio TINYINT(1) DEFAULT 0,
	priorizacao_modelo_painel_slideshow TINYINT(1) DEFAULT 0,
	priorizacao_modelo_projeto_viabilidade TINYINT(1) DEFAULT 0,
	priorizacao_modelo_projeto_abertura TINYINT(1) DEFAULT 0,
	priorizacao_modelo_plano_gestao TINYINT(1) DEFAULT 0,
	priorizacao_modelo_ssti TINYINT(1) DEFAULT 0,
	priorizacao_modelo_laudo TINYINT(1) DEFAULT 0,
	priorizacao_modelo_trelo TINYINT(1) DEFAULT 0,
	priorizacao_modelo_trelo_cartao TINYINT(1) DEFAULT 0,
	priorizacao_modelo_pdcl TINYINT(1) DEFAULT 0,
	priorizacao_modelo_pdcl_item TINYINT(1) DEFAULT 0,
	priorizacao_modelo_os TINYINT(1) DEFAULT 0,
	PRIMARY KEY (priorizacao_modelo_id)
	)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS priorizacao_modelo_opcao;

CREATE TABLE priorizacao_modelo_opcao (
	priorizacao_modelo_opcao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	priorizacao_modelo_opcao_modelo INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_modelo_opcao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_modelo_opcao_nome VARCHAR(255) DEFAULT NULL,
	priorizacao_modelo_opcao_valor DECIMAL(20,2) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (priorizacao_modelo_opcao_id),
	KEY priorizacao_modelo_opcao_modelo (priorizacao_modelo_opcao_modelo),
	CONSTRAINT priorizacao_modelo_opcao_modelo FOREIGN KEY (priorizacao_modelo_opcao_modelo) REFERENCES priorizacao_modelo (priorizacao_modelo_id) ON DELETE CASCADE ON UPDATE CASCADE
	)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS priorizacao;

CREATE TABLE priorizacao (
	priorizacao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	priorizacao_modelo INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_ssti INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_laudo INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_trelo INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_trelo_cartao INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_pdcl INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_pdcl_item INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_os INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_valor DECIMAL(20,2) UNSIGNED DEFAULT NULL,
	priorizacao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY priorizacao_id (priorizacao_id),
	KEY priorizacao_modelo (priorizacao_modelo),
	KEY priorizacao_projeto (priorizacao_projeto),
	KEY priorizacao_tarefa (priorizacao_tarefa),
	KEY priorizacao_perspectiva (priorizacao_perspectiva),
	KEY priorizacao_tema (priorizacao_tema),
	KEY priorizacao_objetivo (priorizacao_objetivo),
	KEY priorizacao_estrategia (priorizacao_estrategia),
	KEY priorizacao_meta (priorizacao_meta),
	KEY priorizacao_fator (priorizacao_fator),
	KEY priorizacao_pratica (priorizacao_pratica),
	KEY priorizacao_indicador (priorizacao_indicador),
	KEY priorizacao_acao (priorizacao_acao),
	KEY priorizacao_canvas (priorizacao_canvas),
	KEY priorizacao_risco (priorizacao_risco),
	KEY priorizacao_risco_resposta (priorizacao_risco_resposta),
	KEY priorizacao_calendario (priorizacao_calendario),
	KEY priorizacao_monitoramento (priorizacao_monitoramento),
	KEY priorizacao_ata (priorizacao_ata),
	KEY priorizacao_mswot(priorizacao_mswot),
	KEY priorizacao_swot(priorizacao_swot),
	KEY priorizacao_operativo(priorizacao_operativo),
	KEY priorizacao_instrumento (priorizacao_instrumento),
	KEY priorizacao_recurso (priorizacao_recurso),
	KEY priorizacao_problema (priorizacao_problema),
	KEY priorizacao_demanda (priorizacao_demanda),
	KEY priorizacao_programa (priorizacao_programa),
	KEY priorizacao_licao (priorizacao_licao),
	KEY priorizacao_evento (priorizacao_evento),
	KEY priorizacao_link (priorizacao_link),
	KEY priorizacao_avaliacao (priorizacao_avaliacao),
	KEY priorizacao_tgn (priorizacao_tgn),
	KEY priorizacao_brainstorm (priorizacao_brainstorm),
	KEY priorizacao_gut (priorizacao_gut),
	KEY priorizacao_causa_efeito (priorizacao_causa_efeito),
	KEY priorizacao_arquivo (priorizacao_arquivo),
	KEY priorizacao_forum (priorizacao_forum),
	KEY priorizacao_checklist (priorizacao_checklist),
	KEY priorizacao_agenda (priorizacao_agenda),
	KEY priorizacao_agrupamento (priorizacao_agrupamento),
	KEY priorizacao_patrocinador (priorizacao_patrocinador),
	KEY priorizacao_template (priorizacao_template),
	KEY priorizacao_painel (priorizacao_painel),
	KEY priorizacao_painel_odometro (priorizacao_painel_odometro),
	KEY priorizacao_painel_composicao (priorizacao_painel_composicao),
	KEY priorizacao_tr (priorizacao_tr),
	KEY priorizacao_me (priorizacao_me),
	KEY priorizacao_acao_item (priorizacao_acao_item),
	KEY priorizacao_beneficio (priorizacao_beneficio),
	KEY priorizacao_painel_slideshow (priorizacao_painel_slideshow),
	KEY priorizacao_projeto_viabilidade (priorizacao_projeto_viabilidade),
	KEY priorizacao_projeto_abertura (priorizacao_projeto_abertura),
	KEY priorizacao_plano_gestao (priorizacao_plano_gestao),
	KEY priorizacao_ssti (priorizacao_ssti),
	KEY priorizacao_laudo (priorizacao_laudo),
	KEY priorizacao_trelo (priorizacao_trelo),
	KEY priorizacao_trelo_cartao (priorizacao_trelo_cartao),
	KEY priorizacao_pdcl (priorizacao_pdcl),
	KEY priorizacao_pdcl_item (priorizacao_pdcl_item),
	KEY priorizacao_os (priorizacao_os),
	CONSTRAINT priorizacao_modelo FOREIGN KEY (priorizacao_modelo) REFERENCES priorizacao_modelo (priorizacao_modelo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_projeto FOREIGN KEY (priorizacao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_tarefa FOREIGN KEY (priorizacao_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_perspectiva FOREIGN KEY (priorizacao_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_tema FOREIGN KEY (priorizacao_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_objetivo FOREIGN KEY (priorizacao_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_fator FOREIGN KEY (priorizacao_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_estrategia FOREIGN KEY (priorizacao_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_meta FOREIGN KEY (priorizacao_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_pratica FOREIGN KEY (priorizacao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_indicador FOREIGN KEY (priorizacao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_acao FOREIGN KEY (priorizacao_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_canvas FOREIGN KEY (priorizacao_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_risco FOREIGN KEY (priorizacao_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_risco_resposta FOREIGN KEY (priorizacao_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_calendario FOREIGN KEY (priorizacao_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_monitoramento FOREIGN KEY (priorizacao_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_ata FOREIGN KEY (priorizacao_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_mswot FOREIGN KEY (priorizacao_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_swot FOREIGN KEY (priorizacao_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_operativo FOREIGN KEY (priorizacao_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_instrumento FOREIGN KEY (priorizacao_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_recurso FOREIGN KEY (priorizacao_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_problema FOREIGN KEY (priorizacao_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_demanda FOREIGN KEY (priorizacao_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_programa FOREIGN KEY (priorizacao_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_licao FOREIGN KEY (priorizacao_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_evento FOREIGN KEY (priorizacao_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_link FOREIGN KEY (priorizacao_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_avaliacao FOREIGN KEY (priorizacao_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_tgn FOREIGN KEY (priorizacao_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_brainstorm FOREIGN KEY (priorizacao_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_gut FOREIGN KEY (priorizacao_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_causa_efeito FOREIGN KEY (priorizacao_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_arquivo FOREIGN KEY (priorizacao_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_forum FOREIGN KEY (priorizacao_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_checklist FOREIGN KEY (priorizacao_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_agenda FOREIGN KEY (priorizacao_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_agrupamento FOREIGN KEY (priorizacao_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_patrocinador FOREIGN KEY (priorizacao_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_template FOREIGN KEY (priorizacao_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_painel FOREIGN KEY (priorizacao_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_painel_odometro FOREIGN KEY (priorizacao_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_painel_composicao FOREIGN KEY (priorizacao_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_tr FOREIGN KEY (priorizacao_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_me FOREIGN KEY (priorizacao_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_acao_item FOREIGN KEY (priorizacao_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_beneficio FOREIGN KEY (priorizacao_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_painel_slideshow FOREIGN KEY (priorizacao_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_projeto_viabilidade FOREIGN KEY (priorizacao_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_projeto_abertura FOREIGN KEY (priorizacao_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_plano_gestao FOREIGN KEY (priorizacao_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT priorizacao_ssti FOREIGN KEY (priorizacao_ssti) REFERENCES ssti (ssti_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT priorizacao_laudo FOREIGN KEY (priorizacao_laudo) REFERENCES laudo (laudo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT priorizacao_trelo FOREIGN KEY (priorizacao_trelo) REFERENCES trelo (trelo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT priorizacao_trelo_cartao FOREIGN KEY (priorizacao_trelo_cartao) REFERENCES trelo_cartao (trelo_cartao_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT priorizacao_pdcl FOREIGN KEY (priorizacao_pdcl) REFERENCES pdcl (pdcl_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT priorizacao_pdcl_item FOREIGN KEY (priorizacao_pdcl_item) REFERENCES pdcl_item (pdcl_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT priorizacao_os FOREIGN KEY (priorizacao_os) REFERENCES os (os_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_priorizacao;

CREATE TABLE baseline_priorizacao (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	priorizacao_id INTEGER(100) UNSIGNED NOT NULL,
	priorizacao_modelo INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_ssti INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_laudo INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_trelo INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_trelo_cartao INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_pdcl INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_pdcl_item INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_os INTEGER(100) UNSIGNED DEFAULT NULL,
	priorizacao_valor DECIMAL(20,2) UNSIGNED DEFAULT NULL,
	priorizacao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (baseline_id, priorizacao_id),
  KEY baseline_id (baseline_id),
  CONSTRAINT baseline_priorizacao_fk FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS pratica_indicador_filtro;

CREATE TABLE pratica_indicador_filtro (
  pratica_indicador_filtro_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pratica_indicador_filtro_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_filtro_status INTEGER(100) DEFAULT NULL,
  pratica_indicador_filtro_prioridade TINYINT(4) DEFAULT NULL,
  pratica_indicador_filtro_tipo VARCHAR(255) DEFAULT NULL,
  pratica_indicador_filtro_setor VARCHAR(2) DEFAULT NULL,
  pratica_indicador_filtro_segmento VARCHAR(4) DEFAULT NULL,
  pratica_indicador_filtro_intervencao VARCHAR(6) DEFAULT NULL,
  pratica_indicador_filtro_tipo_intervencao VARCHAR(9) DEFAULT NULL,
 	pratica_indicador_filtro_comunidade INTEGER(100) DEFAULT NULL,
  pratica_indicador_filtro_social INTEGER(100) DEFAULT NULL,
  pratica_indicador_filtro_acao INTEGER(100) DEFAULT NULL,
  pratica_indicador_filtro_cidade VARCHAR(7) DEFAULT NULL,
  pratica_indicador_filtro_estado VARCHAR(2) DEFAULT NULL,
  pratica_indicador_filtro_texto VARCHAR(255) DEFAULT NULL,
  uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (pratica_indicador_filtro_id),
  KEY pratica_indicador_filtro_indicador (pratica_indicador_filtro_indicador),
  CONSTRAINT pratica_indicador_filtro_fk FOREIGN KEY (pratica_indicador_filtro_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS projeto_comunicacao_evento_calendario;
CREATE TABLE projeto_comunicacao_evento_calendario (
	projeto_comunicacao_evento_calendario_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  projeto_comunicacao_evento_id INTEGER(100) UNSIGNED DEFAULT NULL,
  evento_id INTEGER(100) UNSIGNED DEFAULT NULL,
  ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (projeto_comunicacao_evento_calendario_id),
  KEY projeto_comunicacao_evento_id (projeto_comunicacao_evento_id),
  KEY evento_id (evento_id),
  CONSTRAINT projeto_comunicacao_evento_calendario_fk FOREIGN KEY (projeto_comunicacao_evento_id) REFERENCES projeto_comunicacao_evento (projeto_comunicacao_evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_comunicacao_evento_calendario_fk1 FOREIGN KEY (evento_id) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS codigo;
CREATE TABLE codigo (
  codigo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  codigo_tipo VARCHAR(20) DEFAULT NULL,
  codigo_ativo TINYINT(1) DEFAULT 0,
  codigo_legenda TINYINT(1) DEFAULT 0,
  codigo_code39 TINYINT(1) DEFAULT 0,
  codigo_code93 TINYINT(1) DEFAULT 0,
  codigo_code128 TINYINT(1) DEFAULT 0,
  codigo_codabar TINYINT(1) DEFAULT 0,
  codigo_qr_codigo TINYINT(1) DEFAULT 0,
  codigo_qr_link TINYINT(1) DEFAULT 0,
  codigo_qr_telefone TINYINT(1) DEFAULT 0,
  codigo_qr_responsavel TINYINT(1) DEFAULT 0,
  codigo_qr_geo TINYINT(1) DEFAULT 0,
  codigo_datamatrix_codigo TINYINT(1) DEFAULT 0,
  codigo_pdf417_codigo TINYINT(1) DEFAULT 0,
  codigo_topo TINYINT(1) DEFAULT 0,
  PRIMARY KEY (codigo_id)
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS alerta_msg;
CREATE TABLE alerta_msg (
  alerta_msg_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  alerta_msg_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  alerta_msg_titulo VARCHAR(255) DEFAULT NULL,
  alerta_msg_texto MEDIUMTEXT,
  alerta_msg_link_interno TEXT,
  alerta_msg_link_externo TEXT,
  alerta_msg_data DATETIME DEFAULT NULL,
  alerta_msg_enviar_email TINYINT(1) DEFAULT 0,
  alerta_msg_enviar_msg TINYINT(1) DEFAULT 0,
  alerta_msg_enviar_sms TINYINT(4) DEFAULT 0,
  alerta_msg_instantaneo TINYINT(1) DEFAULT 0,
  alerta_msg_tipo VARCHAR(30) DEFAULT NULL,
  alerta_msg_obj INTEGER(100) UNSIGNED DEFAULT NULL,
  alerta_msg_intervalo INTEGER(100) DEFAULT 0,
  PRIMARY KEY (alerta_msg_id),
  KEY alerta_msg_usuario (alerta_msg_usuario),
  CONSTRAINT alerta_msg_fk FOREIGN KEY (alerta_msg_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS alerta;
CREATE TABLE alerta (
  alerta_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  alerta_campo VARCHAR(100) DEFAULT NULL,
  alerta_ativo TINYINT(1) DEFAULT 0,
  alerta_tem_valor TINYINT(1) DEFAULT 0,
  alerta_valor_min DECIMAL(20,5) DEFAULT 0,
  alerta_valor_max DECIMAL(20,5) DEFAULT 0,
  alerta_tem_dias TINYINT(1) DEFAULT 0,
  alerta_dias INTEGER(100) UNSIGNED DEFAULT NULL,
  alerta_email TINYINT(1) DEFAULT 0,
  alerta_msg TINYINT(1) DEFAULT 0,
  alerta_sms TINYINT(4) DEFAULT 0,
  alerta_instantaneo TINYINT(1) DEFAULT 0,
  alerta_legenda VARCHAR(255) DEFAULT NULL,
  alerta_grupo VARCHAR(40) DEFAULT NULL,
  alerta_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  alerta_responsavel TINYINT(1) DEFAULT 0,
  alerta_supervisor TINYINT(1) DEFAULT 0,
  alerta_designado TINYINT(1) DEFAULT 0,
  alerta_incluir VARCHAR(255) DEFAULT NULL,
  alerta_intervalo INTEGER(100) DEFAULT 1,
	alerta_texto MEDIUMTEXT,
  PRIMARY KEY (alerta_id)
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS pratica_indicador_formula_simples;
CREATE TABLE pratica_indicador_formula_simples (
  pratica_indicador_formula_simples_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pratica_indicador_formula_simples_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_indicador_formula_simples_nome VARCHAR(255) DEFAULT NULL,
  ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (pratica_indicador_formula_simples_id),
  KEY pratica_indicador_formula_simples_indicador (pratica_indicador_formula_simples_indicador),
  CONSTRAINT pratica_indicador_formula_simples_fk FOREIGN KEY (pratica_indicador_formula_simples_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS pratica_legislacao;
CREATE TABLE pratica_legislacao (
  pratica_legislacao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pratica_legislacao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_legislacao_ano INTEGER(4) DEFAULT NULL,
  pratica_legislacao_norma VARCHAR(255) DEFAULT NULL,
  pratica_legislacao_esfera INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_legislacao_detalhe MEDIUMTEXT,
  pratica_legislacao_impacto INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_legislacao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  pratica_legislacao_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (pratica_legislacao_id),
  KEY pratica_legislacao_pratica (pratica_legislacao_pratica),
  CONSTRAINT pratica_legislacao_fk FOREIGN KEY (pratica_legislacao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS monitoramento_deliberacao;

CREATE TABLE monitoramento_deliberacao (
	monitoramento_deliberacao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	monitoramento_deliberacao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_deliberacao_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_deliberacao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_deliberacao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_deliberacao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_deliberacao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_deliberacao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_deliberacao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_deliberacao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_deliberacao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_deliberacao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_deliberacao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_deliberacao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_deliberacao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	monitoramento_deliberacao_prazo DATE DEFAULT NULL,
	monitoramento_deliberacao_status INTEGER(100) UNSIGNED DEFAULT 0,
	monitoramento_deliberacao_agir MEDIUMTEXT,
	monitoramento_deliberacao_obs MEDIUMTEXT,
	monitoramento_deliberacao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	PRIMARY KEY (monitoramento_deliberacao_id),
	KEY monitoramento_deliberacao_monitoramento (monitoramento_deliberacao_monitoramento),
	KEY monitoramento_deliberacao_usuario (monitoramento_deliberacao_usuario),
	KEY monitoramento_deliberacao_perspectiva (monitoramento_deliberacao_perspectiva),
	KEY monitoramento_deliberacao_tema (monitoramento_deliberacao_tema),
	KEY monitoramento_deliberacao_objetivo (monitoramento_deliberacao_objetivo),
	KEY monitoramento_deliberacao_estrategia (monitoramento_deliberacao_estrategia),
	KEY monitoramento_deliberacao_meta (monitoramento_deliberacao_meta),
	KEY monitoramento_deliberacao_projeto (monitoramento_deliberacao_projeto),
	KEY monitoramento_deliberacao_tarefa (monitoramento_deliberacao_tarefa),
	KEY monitoramento_deliberacao_pratica (monitoramento_deliberacao_pratica),
	KEY monitoramento_deliberacao_indicador (monitoramento_deliberacao_indicador),
	KEY monitoramento_deliberacao_acao (monitoramento_deliberacao_acao),
	KEY monitoramento_deliberacao_fator (monitoramento_deliberacao_fator),
	KEY monitoramento_deliberacao_operativo (monitoramento_deliberacao_operativo),
	CONSTRAINT monitoramento_deliberacao_fk1 FOREIGN KEY (monitoramento_deliberacao_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_deliberacao_fk2 FOREIGN KEY (monitoramento_deliberacao_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT monitoramento_deliberacao_fk3 FOREIGN KEY (monitoramento_deliberacao_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT monitoramento_deliberacao_fk4 FOREIGN KEY (monitoramento_deliberacao_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_deliberacao_fk5 FOREIGN KEY (monitoramento_deliberacao_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_deliberacao_fk6 FOREIGN KEY (monitoramento_deliberacao_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_deliberacao_fk7 FOREIGN KEY (monitoramento_deliberacao_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_deliberacao_fk8 FOREIGN KEY (monitoramento_deliberacao_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_deliberacao_fk9 FOREIGN KEY (monitoramento_deliberacao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_deliberacao_fk10 FOREIGN KEY (monitoramento_deliberacao_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT monitoramento_deliberacao_fk11 FOREIGN KEY (monitoramento_deliberacao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_deliberacao_fk12 FOREIGN KEY (monitoramento_deliberacao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_deliberacao_fk13 FOREIGN KEY (monitoramento_deliberacao_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT monitoramento_deliberacao_fk14 FOREIGN KEY (monitoramento_deliberacao_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS monitoramento_depts;

CREATE TABLE monitoramento_depts (
  monitoramento_id INTEGER(100) UNSIGNED NOT NULL,
  dept_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (monitoramento_id, dept_id),
  KEY monitoramento_id (monitoramento_id),
  KEY dept_id (dept_id),
  CONSTRAINT monitoramento_depts_fk1 FOREIGN KEY (dept_id) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT monitoramento_depts_fk FOREIGN KEY (monitoramento_id) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS monitoramento_usuarios;

CREATE TABLE monitoramento_usuarios (
  monitoramento_id INTEGER(100) UNSIGNED NOT NULL,
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (monitoramento_id, usuario_id),
  KEY monitoramento_id (monitoramento_id),
  KEY usuario_id (usuario_id),
  CONSTRAINT monitoramento_usuarios_fk1 FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT monitoramento_usuarios_fk FOREIGN KEY (monitoramento_id) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS pagamento;

CREATE TABLE pagamento (
  pagamento_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  pagamento_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  pagamento_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  pagamento_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  pagamento_data DATE DEFAULT NULL,
  pagamento_valor DECIMAL(20,5) DEFAULT 0,
  pagamento_loa TINYINT(1) DEFAULT NULL,
  pagamento_rap TINYINT(1) DEFAULT NULL,
  pagamento_obs MEDIUMTEXT,
  PRIMARY KEY (pagamento_id),
  KEY pagamento_usuario (pagamento_usuario),
  KEY pagamento_projeto (pagamento_projeto),
  KEY pagamento_tarefa (pagamento_tarefa),
  CONSTRAINT pagamento_fk2 FOREIGN KEY (pagamento_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT pagamento_fk FOREIGN KEY (pagamento_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE SET NULL,
  CONSTRAINT pagamento_fk1 FOREIGN KEY (pagamento_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_pagamento;

CREATE TABLE baseline_pagamento (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
  pagamento_id INTEGER(100) UNSIGNED NOT NULL,
  pagamento_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  pagamento_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
  pagamento_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  pagamento_data DATE DEFAULT NULL,
  pagamento_valor DECIMAL(20,5) DEFAULT 0,
  pagamento_loa TINYINT(1) DEFAULT NULL,
  pagamento_rap TINYINT(1) DEFAULT NULL,
  pagamento_obs MEDIUMTEXT,
  PRIMARY KEY (baseline_id, pagamento_id),
  KEY baseline_id (baseline_id),
  CONSTRAINT baseline_pagamento_fk FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS usuario_externo;

CREATE TABLE usuario_externo (
  usuario_externo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  usuario_externo_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  usuario_externo_chave VARCHAR(100) DEFAULT NULL,
  usuario_externo_endereco TEXT,
  usuario_externo_geral TINYINT(1) DEFAULT 0,
  PRIMARY KEY (usuario_externo_id),
  KEY usuario_externo_usuario (usuario_externo_usuario),
  CONSTRAINT usuario_externo_fk FOREIGN KEY (usuario_externo_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS folha_ponto;

CREATE TABLE folha_ponto (
  folha_ponto_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  folha_ponto_usuario INTEGER(100)UNSIGNED DEFAULT NULL,
  folha_ponto_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  folha_ponto_evento INTEGER(100) UNSIGNED DEFAULT NULL,
  folha_ponto_insercao TIMESTAMP NOT NULL DEFAULT NOW(),
  folha_ponto_inicio DATETIME,
  folha_ponto_fim DATETIME,
  folha_ponto_duracao DECIMAL(20,5) UNSIGNED DEFAULT 0,
  folha_ponto_aprovou INTEGER(100) UNSIGNED DEFAULT NULL,
  folha_ponto_aprovado TINYINT(1) DEFAULT NULL,
  folha_ponto_data DATETIME,
	folha_ponto_valor_hora DECIMAL(20,5) UNSIGNED DEFAULT 0,
	folha_ponto_obs MEDIUMTEXT,
	folha_ponto_porcentagem INTEGER(100) UNSIGNED DEFAULT 100,
	folha_ponto_corrido TINYINT(1) NOT NULL DEFAULT 0,
	folha_ponto_empenhado DECIMAL(20,5) UNSIGNED DEFAULT 0,
	folha_ponto_liquidado DECIMAL(20,5) UNSIGNED DEFAULT 0,
	folha_ponto_pago DECIMAL(20,5) UNSIGNED DEFAULT 0,
  PRIMARY KEY (folha_ponto_id),
  KEY folha_ponto_usuario (folha_ponto_usuario),
  KEY folha_ponto_tarefa (folha_ponto_tarefa),
  KEY folha_ponto_evento (folha_ponto_evento),
  KEY folha_ponto_aprovou (folha_ponto_aprovou),
  CONSTRAINT folha_ponto_fk1 FOREIGN KEY (folha_ponto_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT folha_ponto_fk2 FOREIGN KEY (folha_ponto_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT folha_ponto_fk3 FOREIGN KEY (folha_ponto_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT folha_ponto_fk4 FOREIGN KEY (folha_ponto_aprovou) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS folha_ponto_gasto;

CREATE TABLE folha_ponto_gasto (
  folha_ponto_gasto_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  folha_ponto_gasto_folha INTEGER(100) UNSIGNED DEFAULT NULL,
  folha_ponto_gasto_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  folha_ponto_gasto_tipo INTEGER(100) UNSIGNED DEFAULT 1,
  folha_ponto_gasto_nome VARCHAR(255) DEFAULT NULL,
  folha_ponto_gasto_codigo VARCHAR(255) DEFAULT NULL,
	folha_ponto_gasto_fonte VARCHAR(255) DEFAULT NULL,
	folha_ponto_gasto_regiao VARCHAR(255) DEFAULT NULL,
	folha_ponto_gasto_bdi DECIMAL(20,5) UNSIGNED DEFAULT 0,
	folha_ponto_gasto_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
	folha_ponto_gasto_cotacao DECIMAL(6,5) UNSIGNED DEFAULT 1, 
	folha_ponto_gasto_data_moeda DATE DEFAULT NULL, 
  folha_ponto_gasto_data DATETIME DEFAULT NULL,
  folha_ponto_gasto_quantidade DECIMAL(20,5) UNSIGNED DEFAULT 0,
  folha_ponto_gasto_gasto DECIMAL(20,5) UNSIGNED DEFAULT 0,
  folha_ponto_gasto_percentagem TINYINT(4) DEFAULT 0,
  folha_ponto_gasto_descricao MEDIUMTEXT,
  folha_ponto_gasto_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  folha_ponto_gasto_nd VARCHAR(11) DEFAULT NULL,
  folha_ponto_gasto_categoria_economica VARCHAR(1) DEFAULT NULL,
  folha_ponto_gasto_grupo_despesa VARCHAR(1) DEFAULT NULL,
  folha_ponto_gasto_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  folha_ponto_gasto_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	folha_ponto_gasto_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
  folha_ponto_gasto_data_limite DATE DEFAULT NULL,
	folha_ponto_gasto_empenhado DECIMAL(20,5) UNSIGNED DEFAULT 0,
	folha_ponto_gasto_liquidado DECIMAL(20,5) UNSIGNED DEFAULT 0,
	folha_ponto_gasto_pago DECIMAL(20,5) UNSIGNED DEFAULT 0,
  PRIMARY KEY (folha_ponto_gasto_id),
  KEY folha_ponto_gasto_folha (folha_ponto_gasto_folha),
  KEY folha_ponto_gasto_usuario_inicio (folha_ponto_gasto_usuario),
  KEY folha_ponto_gasto_ordem (folha_ponto_gasto_ordem),
  KEY folha_ponto_gasto_data_inicio (folha_ponto_gasto_data),
  KEY folha_ponto_gasto_nome (folha_ponto_gasto_nome),
  KEY folha_ponto_gasto_moeda (folha_ponto_gasto_moeda),
  CONSTRAINT folha_ponto_gasto_fk FOREIGN KEY (folha_ponto_gasto_folha) REFERENCES folha_ponto (folha_ponto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT folha_ponto_gasto_fk1 FOREIGN KEY (folha_ponto_gasto_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT folha_ponto_gasto_moeda FOREIGN KEY (folha_ponto_gasto_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS folha_ponto_arquivo;

CREATE TABLE folha_ponto_arquivo (
  folha_ponto_arquivo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  folha_ponto_arquivo_ponto INTEGER(100) UNSIGNED DEFAULT NULL,
  folha_ponto_arquivo_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  folha_ponto_arquivo_endereco VARCHAR(150) DEFAULT NULL,
  folha_ponto_arquivo_data DATETIME DEFAULT NULL,
  folha_ponto_arquivo_nome VARCHAR(150) DEFAULT NULL,
  folha_ponto_arquivo_tipo VARCHAR(50) DEFAULT NULL,
  folha_ponto_arquivo_extensao VARCHAR(50) DEFAULT NULL,
  folha_ponto_arquivo_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  folha_ponto_arquivo_nome_real VARCHAR(255) DEFAULT NULL,
	folha_ponto_arquivo_local VARCHAR(255) DEFAULT NULL,
	folha_ponto_arquivo_tamanho INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (folha_ponto_arquivo_id),
  KEY folha_ponto_arquivo_ponto (folha_ponto_arquivo_ponto),
  KEY folha_ponto_arquivo_usuario (folha_ponto_arquivo_usuario),
  CONSTRAINT folha_ponto_arquivo_fk1 FOREIGN KEY (folha_ponto_arquivo_ponto) REFERENCES folha_ponto (folha_ponto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT folha_ponto_arquivo_fk2 FOREIGN KEY (folha_ponto_arquivo_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_folha_ponto;

CREATE TABLE baseline_folha_ponto (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
  folha_ponto_id INTEGER(100) UNSIGNED NOT NULL,
  folha_ponto_usuario INTEGER(100)UNSIGNED DEFAULT NULL,
  folha_ponto_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  folha_ponto_evento INTEGER(100) UNSIGNED DEFAULT NULL,
  folha_ponto_insercao TIMESTAMP NOT NULL DEFAULT NOW(),
  folha_ponto_inicio DATETIME,
  folha_ponto_fim DATETIME,
  folha_ponto_duracao DECIMAL(20,5) UNSIGNED DEFAULT 0,
  folha_ponto_aprovou INTEGER(100)UNSIGNED DEFAULT NULL,
  folha_ponto_aprovado TINYINT(1) DEFAULT NULL,
  folha_ponto_data DATETIME,
	folha_ponto_valor_hora DECIMAL(20,5) UNSIGNED DEFAULT 0,
	folha_ponto_obs MEDIUMTEXT,
	folha_ponto_porcentagem INTEGER(100) UNSIGNED DEFAULT 100,
	folha_ponto_corrido TINYINT(1) NOT NULL DEFAULT 0,
	folha_ponto_empenhado DECIMAL(20,5) UNSIGNED DEFAULT 0,
	folha_ponto_liquidado DECIMAL(20,5) UNSIGNED DEFAULT 0,
	folha_ponto_pago DECIMAL(20,5) UNSIGNED DEFAULT 0,
 	PRIMARY KEY (baseline_id, folha_ponto_id),
  KEY baseline_id (baseline_id),
  KEY folha_ponto_id (folha_ponto_id),
  CONSTRAINT baseline_folha_ponto_fk FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_folha_ponto_gasto;

CREATE TABLE baseline_folha_ponto_gasto (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
  folha_ponto_gasto_id INTEGER(100) UNSIGNED NOT NULL,
  folha_ponto_gasto_folha INTEGER(100) UNSIGNED DEFAULT NULL,
  folha_ponto_gasto_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  folha_ponto_gasto_tipo INTEGER(100) UNSIGNED DEFAULT 1,
  folha_ponto_gasto_nome VARCHAR(255) DEFAULT NULL,
  folha_ponto_gasto_codigo VARCHAR(255) DEFAULT NULL,
	folha_ponto_gasto_fonte VARCHAR(255) DEFAULT NULL,
	folha_ponto_gasto_regiao VARCHAR(255) DEFAULT NULL,
	folha_ponto_gasto_bdi DECIMAL(20,5) UNSIGNED DEFAULT 0,
	folha_ponto_gasto_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
	folha_ponto_gasto_cotacao DECIMAL(6,5) UNSIGNED DEFAULT 1, 
	folha_ponto_gasto_data_moeda DATE DEFAULT NULL, 
  folha_ponto_gasto_data DATETIME DEFAULT NULL,
  folha_ponto_gasto_quantidade DECIMAL(20,5) UNSIGNED DEFAULT 0,
  folha_ponto_gasto_gasto DECIMAL(20,5) UNSIGNED DEFAULT 0,
  folha_ponto_gasto_percentagem TINYINT(4) DEFAULT 0,
  folha_ponto_gasto_descricao MEDIUMTEXT,
  folha_ponto_gasto_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  folha_ponto_gasto_nd VARCHAR(11) DEFAULT NULL,
  folha_ponto_gasto_categoria_economica VARCHAR(1) DEFAULT NULL,
  folha_ponto_gasto_grupo_despesa VARCHAR(1) DEFAULT NULL,
  folha_ponto_gasto_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  folha_ponto_gasto_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	folha_ponto_gasto_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
  folha_ponto_gasto_data_limite DATE DEFAULT NULL,
	folha_ponto_gasto_empenhado DECIMAL(20,5) UNSIGNED DEFAULT 0,
	folha_ponto_gasto_liquidado DECIMAL(20,5) UNSIGNED DEFAULT 0,
	folha_ponto_gasto_pago DECIMAL(20,5) UNSIGNED DEFAULT 0,
 	PRIMARY KEY (baseline_id, folha_ponto_gasto_id),
  KEY baseline_id (baseline_id),
  KEY folha_ponto_gasto_id (folha_ponto_gasto_id),
  CONSTRAINT baseline_folha_ponto_gasto_fk FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_folha_ponto_arquivo;

CREATE TABLE baseline_folha_ponto_arquivo (
  baseline_id INTEGER(100) UNSIGNED NOT NULL,
  folha_ponto_arquivo_id INTEGER(100) UNSIGNED NOT NULL,
  folha_ponto_arquivo_ponto INTEGER(100) UNSIGNED DEFAULT NULL,
  folha_ponto_arquivo_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  folha_ponto_arquivo_endereco VARCHAR(150) DEFAULT NULL,
  folha_ponto_arquivo_data DATETIME DEFAULT NULL,
  folha_ponto_arquivo_nome VARCHAR(150) DEFAULT NULL,
  folha_ponto_arquivo_tipo VARCHAR(50) DEFAULT NULL,
  folha_ponto_arquivo_extensao VARCHAR(50) DEFAULT NULL,
  folha_ponto_arquivo_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  folha_ponto_arquivo_nome_real VARCHAR(255) DEFAULT NULL,
  folha_ponto_arquivo_local VARCHAR(255) DEFAULT NULL,
  folha_ponto_arquivo_tamanho INT(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (baseline_id, folha_ponto_arquivo_id),
  KEY baseline_id (baseline_id),
  KEY folha_ponto_arquivo_id (folha_ponto_arquivo_id),
  CONSTRAINT baseline_folha_ponto_arquivo_fk FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS recurso_ponto;

CREATE TABLE recurso_ponto (
  recurso_ponto_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  recurso_ponto_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_ponto_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_ponto_evento INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_ponto_insercao TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  recurso_ponto_inicio DATETIME,
  recurso_ponto_fim DATETIME,
  recurso_ponto_duracao DECIMAL(20,5) UNSIGNED DEFAULT 0,
  recurso_ponto_aprovou INTEGER(100)UNSIGNED DEFAULT NULL,
  recurso_ponto_aprovado TINYINT(1) DEFAULT NULL,
  recurso_ponto_data DATETIME,
  recurso_ponto_quantidade DECIMAL(20,5) UNSIGNED DEFAULT 0,
	recurso_ponto_valor_hora DECIMAL(20,5) UNSIGNED DEFAULT 0,
	recurso_ponto_empenhado DECIMAL(20,5) UNSIGNED DEFAULT 0,
	recurso_ponto_liquidado DECIMAL(20,5) UNSIGNED DEFAULT 0,
	recurso_ponto_pago DECIMAL(20,5) UNSIGNED DEFAULT 0,
  recurso_ponto_percentual INTEGER UNSIGNED NULL DEFAULT 100,
  recurso_ponto_custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
	recurso_ponto_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
	recurso_ponto_cotacao DECIMAL(6,5) UNSIGNED DEFAULT 1,
	recurso_ponto_data_moeda DATE DEFAULT NULL,
	recurso_ponto_codigo VARCHAR(255) DEFAULT NULL,
	recurso_ponto_fonte VARCHAR(255) DEFAULT NULL,
	recurso_ponto_regiao VARCHAR(255) DEFAULT NULL,
	recurso_ponto_bdi DECIMAL(20,5) UNSIGNED DEFAULT 0,
	recurso_ponto_nd VARCHAR(11) DEFAULT NULL,
  recurso_ponto_categoria_economica VARCHAR(1) DEFAULT NULL,
  recurso_ponto_grupo_despesa VARCHAR(1) DEFAULT NULL,
  recurso_ponto_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  recurso_ponto_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	recurso_ponto_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
	recurso_ponto_obs MEDIUMTEXT,
	recurso_ponto_corrido TINYINT(1) NOT NULL DEFAULT 0,
  recurso_ponto_ordem INT(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (recurso_ponto_id),
  KEY recurso_ponto_recurso (recurso_ponto_recurso),
  KEY recurso_ponto_tarefa (recurso_ponto_tarefa),
  KEY recurso_ponto_evento (recurso_ponto_evento),
  KEY recurso_ponto_aprovou (recurso_ponto_aprovou),
  CONSTRAINT recurso_ponto_fk1 FOREIGN KEY (recurso_ponto_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT recurso_ponto_fk2 FOREIGN KEY (recurso_ponto_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT recurso_ponto_fk3 FOREIGN KEY (recurso_ponto_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT recurso_ponto_fk4 FOREIGN KEY (recurso_ponto_aprovou) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS recurso_ponto_gasto;

CREATE TABLE recurso_ponto_gasto (
  recurso_ponto_gasto_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  recurso_ponto_gasto_ponto INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_ponto_gasto_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_ponto_gasto_tipo INTEGER(100) UNSIGNED DEFAULT 1,
  recurso_ponto_gasto_nome VARCHAR(255) DEFAULT NULL,
  recurso_ponto_gasto_codigo VARCHAR(255) DEFAULT NULL,
	recurso_ponto_gasto_fonte VARCHAR(255) DEFAULT NULL,
	recurso_ponto_gasto_regiao VARCHAR(255) DEFAULT NULL,
	recurso_ponto_gasto_bdi DECIMAL(20,5) UNSIGNED DEFAULT 0,
	recurso_ponto_gasto_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
	recurso_ponto_gasto_cotacao DECIMAL(6,5) UNSIGNED DEFAULT 1,
	recurso_ponto_gasto_data_moeda DATE DEFAULT NULL, 	
  recurso_ponto_gasto_data DATETIME DEFAULT NULL,
  recurso_ponto_gasto_quantidade DECIMAL(20,5) UNSIGNED DEFAULT 0,
  recurso_ponto_gasto_gasto DECIMAL(20,5) UNSIGNED DEFAULT 0,
  recurso_ponto_gasto_percentagem TINYINT(4) DEFAULT 0,
  recurso_ponto_gasto_descricao MEDIUMTEXT,
  recurso_ponto_gasto_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_ponto_gasto_nd VARCHAR(11) DEFAULT NULL,
  recurso_ponto_gasto_categoria_economica VARCHAR(1) DEFAULT NULL,
  recurso_ponto_gasto_grupo_despesa VARCHAR(1) DEFAULT NULL,
  recurso_ponto_gasto_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  recurso_ponto_gasto_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	recurso_ponto_gasto_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
  recurso_ponto_gasto_data_limite DATE DEFAULT NULL,
  recurso_ponto_gasto_empenhado DECIMAL(20,5) UNSIGNED DEFAULT 0,
	recurso_ponto_gasto_liquidado DECIMAL(20,5) UNSIGNED DEFAULT 0,
	recurso_ponto_gasto_pago DECIMAL(20,5) UNSIGNED DEFAULT 0,
  PRIMARY KEY (recurso_ponto_gasto_id),
  KEY recurso_ponto_gasto_ponto (recurso_ponto_gasto_ponto),
  KEY recurso_ponto_gasto_usuario (recurso_ponto_gasto_usuario),
  KEY recurso_ponto_gasto_ordem (recurso_ponto_gasto_ordem),
  KEY recurso_ponto_gasto_data_inicio (recurso_ponto_gasto_data),
  KEY recurso_ponto_gasto_nome (recurso_ponto_gasto_nome),
  KEY recurso_ponto_gasto_moeda (recurso_ponto_gasto_moeda),
  CONSTRAINT recurso_ponto_gasto_fk FOREIGN KEY (recurso_ponto_gasto_ponto) REFERENCES recurso_ponto (recurso_ponto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT recurso_ponto_gasto_fk1 FOREIGN KEY (recurso_ponto_gasto_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT recurso_ponto_gasto_moeda FOREIGN KEY (recurso_ponto_gasto_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS recurso_ponto_arquivo;

CREATE TABLE recurso_ponto_arquivo (
  recurso_ponto_arquivo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  recurso_ponto_arquivo_ponto INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_ponto_arquivo_endereco VARCHAR(150) DEFAULT NULL,
  recurso_ponto_arquivo_data DATETIME DEFAULT NULL,
  recurso_ponto_arquivo_nome VARCHAR(150) DEFAULT NULL,
  recurso_ponto_arquivo_tipo VARCHAR(50) DEFAULT NULL,
  recurso_ponto_arquivo_extensao VARCHAR(50) DEFAULT NULL,
  recurso_ponto_arquivo_nome_real VARCHAR(255) DEFAULT NULL,
	recurso_ponto_arquivo_local VARCHAR(255) DEFAULT NULL,
	recurso_ponto_arquivo_tamanho INTEGER(100) UNSIGNED DEFAULT NULL, 
  recurso_ponto_arquivo_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (recurso_ponto_arquivo_id),
  KEY recurso_ponto_arquivo_ponto (recurso_ponto_arquivo_ponto),
  CONSTRAINT recurso_ponto_arquivo_fk1 FOREIGN KEY (recurso_ponto_arquivo_ponto) REFERENCES recurso_ponto (recurso_ponto_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS baseline_recurso_ponto;

CREATE TABLE baseline_recurso_ponto (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
  recurso_ponto_id INTEGER(100) UNSIGNED NOT NULL,
  recurso_ponto_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_ponto_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_ponto_evento INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_ponto_insercao TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  recurso_ponto_inicio DATETIME,
  recurso_ponto_fim DATETIME,
  recurso_ponto_duracao DECIMAL(20,5) UNSIGNED DEFAULT 0,
  recurso_ponto_aprovou INTEGER(100)UNSIGNED DEFAULT NULL,
  recurso_ponto_aprovado TINYINT(1) DEFAULT NULL,
  recurso_ponto_data DATETIME,
  recurso_ponto_quantidade DECIMAL(20,5) UNSIGNED DEFAULT 0,
	recurso_ponto_valor_hora DECIMAL(20,5) UNSIGNED DEFAULT 0,
	recurso_ponto_empenhado DECIMAL(20,5) UNSIGNED DEFAULT 0,
	recurso_ponto_liquidado DECIMAL(20,5) UNSIGNED DEFAULT 0,
	recurso_ponto_pago DECIMAL(20,5) UNSIGNED DEFAULT 0,
  recurso_ponto_percentual INTEGER UNSIGNED NULL DEFAULT 100,
  recurso_ponto_custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
	recurso_ponto_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
	recurso_ponto_cotacao DECIMAL(6,5) UNSIGNED DEFAULT 1,
	recurso_ponto_data_moeda DATE DEFAULT NULL,
	recurso_ponto_codigo VARCHAR(255) DEFAULT NULL,
	recurso_ponto_fonte VARCHAR(255) DEFAULT NULL,
	recurso_ponto_regiao VARCHAR(255) DEFAULT NULL,
	recurso_ponto_bdi DECIMAL(20,5) UNSIGNED DEFAULT 0,
	recurso_ponto_nd VARCHAR(11) DEFAULT NULL,
  recurso_ponto_categoria_economica VARCHAR(1) DEFAULT NULL,
  recurso_ponto_grupo_despesa VARCHAR(1) DEFAULT NULL,
  recurso_ponto_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  recurso_ponto_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	recurso_ponto_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
	recurso_ponto_obs MEDIUMTEXT,
	recurso_ponto_corrido TINYINT(1) NOT NULL DEFAULT 0,
  recurso_ponto_ordem INT(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (baseline_id, recurso_ponto_id),
  KEY baseline_id (baseline_id),
  KEY recurso_ponto_id (recurso_ponto_id),
  CONSTRAINT baseline_recurso_ponto_fk FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_recurso_ponto_gasto;

CREATE TABLE baseline_recurso_ponto_gasto (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
  recurso_ponto_gasto_id INTEGER(100) UNSIGNED NOT NULL,
  recurso_ponto_gasto_ponto INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_ponto_gasto_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_ponto_gasto_tipo INTEGER(100) UNSIGNED DEFAULT 1,
  recurso_ponto_gasto_nome VARCHAR(255) DEFAULT NULL,
  recurso_ponto_gasto_codigo VARCHAR(255) DEFAULT NULL,
	recurso_ponto_gasto_fonte VARCHAR(255) DEFAULT NULL,
	recurso_ponto_gasto_regiao VARCHAR(255) DEFAULT NULL,
	recurso_ponto_gasto_bdi DECIMAL(20,5) UNSIGNED DEFAULT 0,
	recurso_ponto_gasto_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
	recurso_ponto_gasto_cotacao DECIMAL(6,5) UNSIGNED DEFAULT 1,
	recurso_ponto_gasto_data_moeda DATE DEFAULT NULL, 	
  recurso_ponto_gasto_data DATETIME DEFAULT NULL,
  recurso_ponto_gasto_quantidade DECIMAL(20,5) UNSIGNED DEFAULT 0,
  recurso_ponto_gasto_gasto DECIMAL(20,5) UNSIGNED DEFAULT 0,
  recurso_ponto_gasto_percentagem TINYINT(4) DEFAULT 0,
  recurso_ponto_gasto_descricao MEDIUMTEXT,
  recurso_ponto_gasto_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_ponto_gasto_nd VARCHAR(11) DEFAULT NULL,
  recurso_ponto_gasto_categoria_economica VARCHAR(1) DEFAULT NULL,
  recurso_ponto_gasto_grupo_despesa VARCHAR(1) DEFAULT NULL,
  recurso_ponto_gasto_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  recurso_ponto_gasto_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	recurso_ponto_gasto_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
  recurso_ponto_gasto_data_limite DATE DEFAULT NULL,
  recurso_ponto_gasto_empenhado DECIMAL(20,5) UNSIGNED DEFAULT 0,
	recurso_ponto_gasto_liquidado DECIMAL(20,5) UNSIGNED DEFAULT 0,
	recurso_ponto_gasto_pago DECIMAL(20,5) UNSIGNED DEFAULT 0,
  PRIMARY KEY (baseline_id, recurso_ponto_gasto_id),
  KEY baseline_id (baseline_id),
  KEY recurso_ponto_gasto_id (recurso_ponto_gasto_id),
  CONSTRAINT baseline_recurso_ponto_gasto_fk FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS baseline_recurso_ponto_arquivo;

CREATE TABLE baseline_recurso_ponto_arquivo (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
  recurso_ponto_arquivo_id INTEGER(100) UNSIGNED NOT NULL,
  recurso_ponto_arquivo_ponto INTEGER(100) UNSIGNED DEFAULT NULL,
  recurso_ponto_arquivo_endereco VARCHAR(150) DEFAULT NULL,
  recurso_ponto_arquivo_data DATETIME DEFAULT NULL,
  recurso_ponto_arquivo_nome VARCHAR(150) DEFAULT NULL,
  recurso_ponto_arquivo_tipo VARCHAR(50) DEFAULT NULL,
  recurso_ponto_arquivo_extensao VARCHAR(50) DEFAULT NULL,
	recurso_ponto_arquivo_nome_real VARCHAR(255) DEFAULT NULL,
	recurso_ponto_arquivo_local VARCHAR(255) DEFAULT NULL,
	recurso_ponto_arquivo_tamanho INTEGER(100) UNSIGNED DEFAULT NULL, 
  recurso_ponto_arquivo_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (baseline_id, recurso_ponto_arquivo_id),
  KEY baseline_id (baseline_id),
  KEY recurso_ponto_arquivo_id (recurso_ponto_arquivo_id),
  CONSTRAINT baseline_recurso_ponto_arquivo_fk FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS painel_odometro_dept;

CREATE TABLE painel_odometro_dept (
  painel_odometro_dept_painel_odometro INTEGER(100) UNSIGNED NOT NULL,
  painel_odometro_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (painel_odometro_dept_painel_odometro, painel_odometro_dept_dept),
  KEY painel_odometro_dept_painel_odometro (painel_odometro_dept_painel_odometro),
  KEY painel_odometro_dept_dept (painel_odometro_dept_dept),
  CONSTRAINT painel_odometro_dept_dept FOREIGN KEY (painel_odometro_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT painel_odometro_dept_painel_odometro FOREIGN KEY (painel_odometro_dept_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS painel_odometro_usuario;

CREATE TABLE painel_odometro_usuario (
  painel_odometro_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
  painel_odometro_usuario_painel_odometro INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (painel_odometro_usuario_usuario, painel_odometro_usuario_painel_odometro),
  KEY painel_odometro_usuario_usuario (painel_odometro_usuario_usuario),
  KEY painel_odometro_usuario_painel_odometro (painel_odometro_usuario_painel_odometro),
  CONSTRAINT painel_odometro_usuario_fk FOREIGN KEY (painel_odometro_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT painel_odometro_usuario_fk1 FOREIGN KEY (painel_odometro_usuario_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS painel_dept;

CREATE TABLE painel_dept (
  painel_dept_painel INTEGER(100) UNSIGNED NOT NULL,
  painel_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (painel_dept_painel, painel_dept_dept),
  KEY painel_dept_painel (painel_dept_painel),
  KEY painel_dept_dept (painel_dept_dept),
  CONSTRAINT painel_dept_dept FOREIGN KEY (painel_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT painel_dept_painel FOREIGN KEY (painel_dept_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS painel_usuario;

CREATE TABLE painel_usuario (
  painel_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
  painel_usuario_painel INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (painel_usuario_usuario, painel_usuario_painel),
  KEY painel_usuario_usuario (painel_usuario_usuario),
  KEY painel_usuario_painel (painel_usuario_painel),
  CONSTRAINT painel_usuario_fk FOREIGN KEY (painel_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT painel_usuario_fk1 FOREIGN KEY (painel_usuario_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS painel_indicador;

CREATE TABLE painel_indicador (
	painel_indicador_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  painel_indicador_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  painel_indicador_painel INTEGER(100) UNSIGNED DEFAULT NULL,
  painel_indicador_deslocar INTEGER(100) DEFAULT NULL,
  painel_indicador_tipo_deslocamento VARCHAR(1) DEFAULT NULL,
  painel_indicador_y_direita TINYINT(1) DEFAULT 0,
  painel_indicador_meta TINYINT(1) DEFAULT 0,
  painel_indicador_meta_faixas TINYINT(1) DEFAULT 0,
	painel_indicador_referencial TINYINT(1) DEFAULT 0,
	painel_indicador_pontuacao TINYINT(1) DEFAULT 0,
  painel_indicador_legenda VARCHAR(255) DEFAULT NULL,
  painel_indicador_unidade VARCHAR(15)  DEFAULT NULL,
  painel_indicador_unidade_esquerda TINYINT(1) DEFAULT 0,
  painel_indicador_cor VARCHAR(6)  DEFAULT NULL,
  painel_indicador_grafico VARCHAR(15)  DEFAULT 'linha',
  painel_indicador_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (painel_indicador_id),
  KEY painel_indicador_indicador (painel_indicador_indicador),
  KEY painel_indicador_painel (painel_indicador_painel),
  CONSTRAINT painel_indicador_fk FOREIGN KEY (painel_indicador_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT painel_indicador_fk1 FOREIGN KEY (painel_indicador_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS painel_slideshow_dept;

CREATE TABLE painel_slideshow_dept (
  painel_slideshow_dept_painel_slideshow INTEGER(100) UNSIGNED NOT NULL,
  painel_slideshow_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (painel_slideshow_dept_painel_slideshow, painel_slideshow_dept_dept),
  KEY painel_slideshow_dept_painel_slideshow (painel_slideshow_dept_painel_slideshow),
  KEY painel_slideshow_dept_dept (painel_slideshow_dept_dept),
  CONSTRAINT painel_slideshow_dept_dept FOREIGN KEY (painel_slideshow_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT painel_slideshow_dept_painel_slideshow FOREIGN KEY (painel_slideshow_dept_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS painel_slideshow_usuario;

CREATE TABLE painel_slideshow_usuario (
  painel_slideshow_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
  painel_slideshow_usuario_slideshow INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (painel_slideshow_usuario_usuario, painel_slideshow_usuario_slideshow),
  KEY painel_slideshow_usuario_usuario (painel_slideshow_usuario_usuario),
  KEY painel_slideshow_usuario_slideshow (painel_slideshow_usuario_slideshow),
  CONSTRAINT painel_slideshow_usuario_fk FOREIGN KEY (painel_slideshow_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT painel_slideshow_usuario_fk1 FOREIGN KEY (painel_slideshow_usuario_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS painel_slideshow_composicao;

CREATE TABLE painel_slideshow_composicao (
	painel_slideshow_composicao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  painel_slideshow_composicao_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
  painel_slideshow_composicao_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
  painel_slideshow_composicao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (painel_slideshow_composicao_id),
  KEY painel_slideshow_composicao_composicao (painel_slideshow_composicao_composicao),
  KEY painel_slideshow_composicao_slideshow (painel_slideshow_composicao_slideshow),
  CONSTRAINT painel_slideshow_composicao_fk FOREIGN KEY (painel_slideshow_composicao_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT painel_slideshow_composicao_fk1 FOREIGN KEY (painel_slideshow_composicao_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS painel_composicao_dept;

CREATE TABLE painel_composicao_dept (
  painel_composicao_dept_painel_composicao INTEGER(100) UNSIGNED NOT NULL,
  painel_composicao_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (painel_composicao_dept_painel_composicao, painel_composicao_dept_dept),
  KEY painel_composicao_dept_painel_composicao (painel_composicao_dept_painel_composicao),
  KEY painel_composicao_dept_dept (painel_composicao_dept_dept),
  CONSTRAINT painel_composicao_dept_dept FOREIGN KEY (painel_composicao_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT painel_composicao_dept_painel_composicao FOREIGN KEY (painel_composicao_dept_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS painel_composicao_usuario;

CREATE TABLE painel_composicao_usuario (
  painel_composicao_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
  painel_composicao_usuario_painel_composicao INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (painel_composicao_usuario_usuario, painel_composicao_usuario_painel_composicao),
  KEY painel_composicao_usuario_usuario (painel_composicao_usuario_usuario),
  KEY painel_composicao_usuario_painel_composicao (painel_composicao_usuario_painel_composicao),
  CONSTRAINT painel_composicao_usuario_fk FOREIGN KEY (painel_composicao_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT painel_composicao_usuario_fk1 FOREIGN KEY (painel_composicao_usuario_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS painel_composicao_painel;

CREATE TABLE painel_composicao_painel (
	painel_composicao_painel_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  painel_composicao_painel_painel INTEGER(100) UNSIGNED DEFAULT NULL,
  painel_composicao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
  painel_composicao_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
  painel_composicao_painel_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (painel_composicao_painel_id),
  KEY painel_composicao_painel_painel (painel_composicao_painel_painel),
  KEY painel_composicao_painel_composicao (painel_composicao_painel_composicao),
  KEY painel_composicao_odometro (painel_composicao_odometro),
  CONSTRAINT painel_composicao_painel_fk FOREIGN KEY (painel_composicao_painel_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT painel_composicao_painel_fk1 FOREIGN KEY (painel_composicao_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT painel_composicao_painel_fk2 FOREIGN KEY (painel_composicao_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS projeto_stakeholder;

CREATE TABLE projeto_stakeholder (
	projeto_stakeholder_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	projeto_stakeholder_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_stakeholder_contato INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_stakeholder_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_stakeholder_perfil INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_stakeholder_autoridade INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_stakeholder_interesse INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_stakeholder_influencia INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_stakeholder_impacto INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_stakeholder_descricao MEDIUMTEXT,
	projeto_stakeholder_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (projeto_stakeholder_id),
	KEY projeto_stakeholder_projeto (projeto_stakeholder_projeto),
	KEY projeto_stakeholder_contato (projeto_stakeholder_contato),
	CONSTRAINT projeto_stakeholder_fk FOREIGN KEY (projeto_stakeholder_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT projeto_stakeholder_fk1 FOREIGN KEY (projeto_stakeholder_contato) REFERENCES contatos (contato_id) ON DELETE CASCADE ON UPDATE CASCADE
	)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS baseline_projeto_stakeholder;

CREATE TABLE baseline_projeto_stakeholder (
	baseline_id INTEGER(100) UNSIGNED NOT NULL,
	projeto_stakeholder_id INTEGER(100) UNSIGNED NOT NULL,
	projeto_stakeholder_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_stakeholder_contato INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_stakeholder_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_stakeholder_perfil INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_stakeholder_autoridade INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_stakeholder_interesse INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_stakeholder_influencia INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_stakeholder_impacto INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_stakeholder_descricao MEDIUMTEXT,
	projeto_stakeholder_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY (baseline_id, projeto_stakeholder_id),
	CONSTRAINT baseline_projeto_stakeholder_fk FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
	)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS menu;

CREATE TABLE menu (
  menu_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  menu_usuario_id INTEGER(100) UNSIGNED DEFAULT NULL,
  menu_descricao varchar(255) DEFAULT NULL,
  PRIMARY KEY (menu_id),
  KEY menu_usuario_id (menu_usuario_id),
  CONSTRAINT menu_fk FOREIGN KEY (menu_usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS menu_item;

CREATE TABLE menu_item (
  menu_item_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  menu_item_chave VARCHAR(255) DEFAULT NULL,
  menu_item_superior_id INTEGER(100) UNSIGNED NOT NULL,
  menu_item_chave_pai VARCHAR(255) DEFAULT NULL,
  menu_item_titulo MEDIUMTEXT,
  menu_item_modulo VARCHAR(64) DEFAULT NULL,
  menu_item_parametros TEXT,
  menu_item_menu_id INTEGER(100) UNSIGNED DEFAULT NULL,
  menu_item_tipo VARCHAR(30) DEFAULT 'button',
  menu_item_acao TINYINT(4) NOT NULL DEFAULT 0,
  menu_item_tip MEDIUMTEXT,
  menu_item_smodulo VARCHAR(64) DEFAULT NULL,
  menu_item_permissao INTEGER(100) UNSIGNED DEFAULT 0,
  menu_item_icone MEDIUMTEXT,
  menu_item_icone_classe MEDIUMTEXT,
  menu_item_script TEXT,
  menu_item_index INTEGER(100) UNSIGNED DEFAULT 0,
  menu_item_permissao_extra MEDIUMTEXT,
  PRIMARY KEY (menu_item_id),
  KEY menu_item_menu_id (menu_item_menu_id),
  CONSTRAINT menu_item_fk FOREIGN KEY (menu_item_menu_id) REFERENCES menu (menu_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS grafico;
CREATE TABLE grafico (
  grafico_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  grafico_nome varchar(255) NOT NULL,
  grafico_area varchar(30) NOT NULL,
  grafico_usuario_id INTEGER(100) UNSIGNED DEFAULT NULL,
  grafico_tipo varchar(20) NOT NULL,
  grafico_raio varchar(30) DEFAULT NULL,
  grafico_tipo_label tinyint(4) DEFAULT 0,
  grafico_periodo tinyint(4) DEFAULT 0,
  grafico_mostrar_valores char(1) DEFAULT 0,
  PRIMARY KEY (grafico_id),
  KEY grafico_usuarios_fk_idx (grafico_usuario_id),
  CONSTRAINT grafico_usuarios_fk FOREIGN KEY (grafico_usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS grafico_campo;
CREATE TABLE grafico_campo (
  grafico_campo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  grafico_campo_grafico_id INTEGER(100) UNSIGNED NOT NULL,
  grafico_campo_tipo varchar(30) NOT NULL,
  grafico_campo_cor varchar(6) DEFAULT NULL,
  grafico_campo_texto varchar(255) DEFAULT NULL,
  PRIMARY KEY (grafico_campo_id),
  KEY grafico_campo_grafico_fk_idx (grafico_campo_grafico_id),
  CONSTRAINT grafico_campo_grafico_fk FOREIGN KEY (grafico_campo_grafico_id) REFERENCES grafico (grafico_id) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS evento_compartilhamento;
CREATE TABLE evento_compartilhamento (
  comp_id int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  comp_chave varchar(50) NOT NULL,
  comp_nome varchar(255) NOT NULL,
  comp_descricao varchar(255) DEFAULT NULL,
  comp_evento_acessos int(10) UNSIGNED DEFAULT '0',
  comp_evento_objetos int(10) UNSIGNED DEFAULT '0',
  comp_tarefa_acessos int(10) UNSIGNED DEFAULT '0',
  comp_tarefa_relacoes int(10) UNSIGNED DEFAULT '0',
  comp_ativo tinyint(1) DEFAULT '1',
  PRIMARY KEY (comp_id),
  UNIQUE KEY comp_chave_UNIQUE (comp_chave),
  KEY comp_evento_usuario_fk_idx (usuario_id),
  CONSTRAINT comp_evento_usuario_fk FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS tarefa_designado_periodos;
CREATE TABLE tarefa_designado_periodos (
  periodo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  tarefa_id INTEGER(100) UNSIGNED NOT NULL,
  inicio DATETIME NOT NULL,
  fim DATETIME NOT NULL,
  percentual DECIMAL(10,3) DEFAULT 100,
  PRIMARY KEY (periodo_id),
  KEY tarefa_designado_periodo_usuario_fk_idx (usuario_id),
  KEY tarefa_designado_periodo_tarefa_fk_idx (tarefa_id),
  CONSTRAINT tarefa_designado_periodo_tarefa_fk FOREIGN KEY (tarefa_id) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tarefa_designado_periodo_usuario_fk FOREIGN KEY (usuario_id) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS baseline_tarefa_designado_periodos;
CREATE TABLE baseline_tarefa_designado_periodos (
  baseline_id INTEGER(100) UNSIGNED NOT NULL,
  periodo_id INTEGER(100) UNSIGNED NOT NULL,
  usuario_id INTEGER(100) UNSIGNED NOT NULL,
  tarefa_id INTEGER(100) UNSIGNED NOT NULL,
  inicio DATETIME NOT NULL,
  fim DATETIME NOT NULL,
  percentual DECIMAL(10,3) DEFAULT 100,
  PRIMARY KEY (baseline_id, periodo_id),
  CONSTRAINT baseline_tarefa_designado_periodos_fk FOREIGN KEY (baseline_id) REFERENCES baseline (baseline_id) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;







DROP TABLE IF EXISTS custo_observacao;

CREATE TABLE custo_observacao (
  custo_observacao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  custo_observacao_custo INTEGER(100) UNSIGNED DEFAULT NULL,
  custo_observacao_gasto INTEGER(100) UNSIGNED DEFAULT NULL,
  custo_observacao_tarefa_custo	INTEGER(100) UNSIGNED DEFAULT NULL,
  custo_observacao_tarefa_gasto	INTEGER(100) UNSIGNED DEFAULT NULL,
  custo_observacao_log int(100) unsigned DEFAULT NULL,
  custo_observacao_demanda_custo INTEGER(100) UNSIGNED DEFAULT NULL,
  custo_observacao_plano_acao_item_custos INTEGER(100) UNSIGNED DEFAULT NULL,
  custo_observacao_plano_acao_item_gastos INTEGER(100) UNSIGNED DEFAULT NULL,
  custo_observacao_projeto_viabilidade_custo INTEGER(100) UNSIGNED DEFAULT NULL,
  custo_observacao_projeto_abertura_custo INTEGER(100) UNSIGNED DEFAULT NULL,
  custo_observacao_projeto_custo INTEGER(100) UNSIGNED DEFAULT NULL,
  custo_observacao_folha_ponto INTEGER(100) UNSIGNED DEFAULT NULL,
  custo_observacao_recurso_ponto INTEGER(100) UNSIGNED DEFAULT NULL,
  custo_observacao_recurso_tarefa	INTEGER(100) UNSIGNED DEFAULT NULL,
  custo_observacao_ssti_custo INTEGER(100) unsigned DEFAULT NULL,
  custo_observacao_laudo_custo INTEGER(100) unsigned DEFAULT NULL,
  custo_observacao_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  custo_observacao_data DATETIME DEFAULT NULL,
  custo_observacao_descricao MEDIUMTEXT,
  PRIMARY KEY (custo_observacao_id),
  KEY custo_observacao_custo (custo_observacao_custo),
  KEY custo_observacao_gasto (custo_observacao_gasto),
  KEY custo_observacao_tarefa_custo (custo_observacao_tarefa_custo),
  KEY custo_observacao_tarefa_gasto (custo_observacao_tarefa_gasto),
  KEY custo_observacao_log (custo_observacao_log),
  KEY custo_observacao_demanda_custo (custo_observacao_demanda_custo),
  KEY custo_observacao_plano_acao_item_custos (custo_observacao_plano_acao_item_custos),
  KEY custo_observacao_plano_acao_item_gastos (custo_observacao_plano_acao_item_gastos),
  KEY custo_observacao_projeto_viabilidade_custo (custo_observacao_projeto_viabilidade_custo),
  KEY custo_observacao_projeto_abertura_custo (custo_observacao_projeto_abertura_custo),
  KEY custo_observacao_projeto_custo (custo_observacao_projeto_custo),
  KEY custo_observacao_folha_ponto (custo_observacao_folha_ponto),
  KEY custo_observacao_recurso_ponto (custo_observacao_recurso_ponto),
  KEY custo_observacao_recurso_tarefa (custo_observacao_recurso_tarefa),
  KEY custo_observacao_ssti_custo (custo_observacao_ssti_custo),
  KEY custo_observacao_laudo_custo (custo_observacao_laudo_custo),
  KEY custo_observacao_usuario (custo_observacao_usuario),
  CONSTRAINT custo_observacao_custo FOREIGN KEY (custo_observacao_custo) REFERENCES tarefa_custos (tarefa_custos_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT custo_observacao_gasto FOREIGN KEY (custo_observacao_gasto) REFERENCES tarefa_gastos (tarefa_gastos_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT custo_observacao_tarefa_custo FOREIGN KEY (custo_observacao_tarefa_custo) REFERENCES tarefa_custos (tarefa_custos_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT custo_observacao_tarefa_gasto FOREIGN KEY (custo_observacao_tarefa_gasto) REFERENCES tarefa_gastos (tarefa_gastos_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT custo_observacao_demanda_custo FOREIGN KEY (custo_observacao_demanda_custo) REFERENCES demanda_custo (demanda_custo_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT custo_observacao_plano_acao_item_custos FOREIGN KEY (custo_observacao_plano_acao_item_custos) REFERENCES plano_acao_item_custos (plano_acao_item_custos_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT custo_observacao_plano_acao_item_gastos FOREIGN KEY (custo_observacao_plano_acao_item_gastos) REFERENCES plano_acao_item_gastos (plano_acao_item_gastos_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT custo_observacao_projeto_viabilidade_custo FOREIGN KEY (custo_observacao_projeto_viabilidade_custo) REFERENCES projeto_viabilidade_custo (projeto_viabilidade_custo_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT custo_observacao_projeto_abertura_custo FOREIGN KEY (custo_observacao_projeto_abertura_custo) REFERENCES projeto_abertura_custo (projeto_abertura_custo_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT custo_observacao_projeto_custo FOREIGN KEY (custo_observacao_projeto_custo) REFERENCES projeto_custo (projeto_custo_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT custo_observacao_log FOREIGN KEY (custo_observacao_log) REFERENCES log (log_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT custo_observacao_folha_ponto FOREIGN KEY (custo_observacao_folha_ponto) REFERENCES folha_ponto (folha_ponto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT custo_observacao_recurso_ponto FOREIGN KEY (custo_observacao_recurso_ponto) REFERENCES recurso_ponto (recurso_ponto_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT custo_observacao_recurso_tarefa FOREIGN KEY (custo_observacao_recurso_tarefa) REFERENCES recurso_tarefa (recurso_tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT custo_observacao_ssti_custo FOREIGN KEY (custo_observacao_ssti_custo) REFERENCES ssti_custo (ssti_custo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT custo_observacao_laudo_custo FOREIGN KEY (custo_observacao_laudo_custo) REFERENCES laudo_custo (laudo_custo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT custo_observacao_usuario FOREIGN KEY (custo_observacao_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;





DROP TABLE IF EXISTS assinatura;

CREATE TABLE assinatura (
	assinatura_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	assinatura_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_link INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_template INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_me INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_plano_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_aviso INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_ssti INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_laudo INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_trelo INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_trelo_cartao INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_pdcl INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_pdcl_item INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_os INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_modelo INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  assinatura_atesta INTEGER(100) UNSIGNED DEFAULT NULL,
  assinatura_atesta_opcao INTEGER(100) UNSIGNED DEFAULT NULL,
  assinatura_funcao VARCHAR (255),
  assinatura_data DATETIME,
  assinatura_aprova TINYINT(1) DEFAULT 0,
  assinatura_aprovou TINYINT(1) DEFAULT 0,
  assinatura_observacao MEDIUMTEXT,
  assinatura_nao_exclui TINYINT(1) DEFAULT 0,
  assinatura_extra VARCHAR(255) DEFAULT NULL,
  assinatura_bloqueado TINYINT(1) DEFAULT 0,
  assinatura_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  assinatura_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY assinatura_id (assinatura_id),
	KEY assinatura_projeto (assinatura_projeto),
	KEY assinatura_tarefa (assinatura_tarefa),
	KEY assinatura_perspectiva (assinatura_perspectiva),
	KEY assinatura_tema (assinatura_tema),
	KEY assinatura_objetivo (assinatura_objetivo),
	KEY assinatura_estrategia (assinatura_estrategia),
	KEY assinatura_meta (assinatura_meta),
	KEY assinatura_fator (assinatura_fator),
	KEY assinatura_pratica (assinatura_pratica),
	KEY assinatura_indicador (assinatura_indicador),
	KEY assinatura_acao (assinatura_acao),
	KEY assinatura_canvas (assinatura_canvas),
	KEY assinatura_risco (assinatura_risco),
	KEY assinatura_risco_resposta (assinatura_risco_resposta),
	KEY assinatura_calendario (assinatura_calendario),
	KEY assinatura_monitoramento (assinatura_monitoramento),
	KEY assinatura_ata (assinatura_ata),
	KEY assinatura_mswot(assinatura_mswot),
	KEY assinatura_swot(assinatura_swot),
	KEY assinatura_operativo(assinatura_operativo),
	KEY assinatura_instrumento (assinatura_instrumento),
	KEY assinatura_recurso (assinatura_recurso),
	KEY assinatura_problema (assinatura_problema),
	KEY assinatura_demanda (assinatura_demanda),
	KEY assinatura_programa (assinatura_programa),
	KEY assinatura_licao (assinatura_licao),
	KEY assinatura_evento (assinatura_evento),
	KEY assinatura_link (assinatura_link),
	KEY assinatura_avaliacao (assinatura_avaliacao),
	KEY assinatura_tgn (assinatura_tgn),
	KEY assinatura_brainstorm (assinatura_brainstorm),
	KEY assinatura_gut (assinatura_gut),
	KEY assinatura_causa_efeito (assinatura_causa_efeito),
	KEY assinatura_arquivo (assinatura_arquivo),
	KEY assinatura_forum (assinatura_forum),
	KEY assinatura_checklist (assinatura_checklist),
	KEY assinatura_agenda (assinatura_agenda),
	KEY assinatura_agrupamento (assinatura_agrupamento),
	KEY assinatura_patrocinador (assinatura_patrocinador),
	KEY assinatura_template (assinatura_template),
	KEY assinatura_painel (assinatura_painel),
	KEY assinatura_painel_odometro (assinatura_painel_odometro),
	KEY assinatura_painel_composicao (assinatura_painel_composicao),
	KEY assinatura_tr (assinatura_tr),
	KEY assinatura_me (assinatura_me),
	KEY assinatura_plano_acao_item (assinatura_plano_acao_item),
	KEY assinatura_beneficio (assinatura_beneficio),
	KEY assinatura_painel_slideshow (assinatura_painel_slideshow),
	KEY assinatura_viabilidade (assinatura_viabilidade),
	KEY assinatura_abertura (assinatura_abertura),
	KEY assinatura_plano_gestao (assinatura_plano_gestao),
	KEY assinatura_aviso (assinatura_aviso),
	KEY assinatura_ssti (assinatura_ssti),
	KEY assinatura_laudo (assinatura_laudo),
	KEY assinatura_trelo (assinatura_trelo),
	KEY assinatura_trelo_cartao (assinatura_trelo_cartao),
	KEY assinatura_pdcl (assinatura_pdcl),
	KEY assinatura_pdcl_item (assinatura_pdcl_item),
	KEY assinatura_os (assinatura_os),
	KEY assinatura_modelo (assinatura_modelo),
	KEY assinatura_usuario (assinatura_usuario),
  KEY assinatura_atesta (assinatura_atesta),
  KEY assinatura_atesta_opcao (assinatura_atesta_opcao),
	CONSTRAINT assinatura_projeto FOREIGN KEY (assinatura_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_tarefa FOREIGN KEY (assinatura_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_perspectiva FOREIGN KEY (assinatura_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_tema FOREIGN KEY (assinatura_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_objetivo FOREIGN KEY (assinatura_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_fator FOREIGN KEY (assinatura_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_estrategia FOREIGN KEY (assinatura_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_meta FOREIGN KEY (assinatura_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_pratica FOREIGN KEY (assinatura_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_indicador FOREIGN KEY (assinatura_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_acao FOREIGN KEY (assinatura_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_canvas FOREIGN KEY (assinatura_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_risco FOREIGN KEY (assinatura_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_risco_resposta FOREIGN KEY (assinatura_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_calendario FOREIGN KEY (assinatura_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_monitoramento FOREIGN KEY (assinatura_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_ata FOREIGN KEY (assinatura_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_mswot FOREIGN KEY (assinatura_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_swot FOREIGN KEY (assinatura_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_operativo FOREIGN KEY (assinatura_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_instrumento FOREIGN KEY (assinatura_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_recurso FOREIGN KEY (assinatura_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_problema FOREIGN KEY (assinatura_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_demanda FOREIGN KEY (assinatura_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_programa FOREIGN KEY (assinatura_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_licao FOREIGN KEY (assinatura_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_evento FOREIGN KEY (assinatura_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_link FOREIGN KEY (assinatura_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_avaliacao FOREIGN KEY (assinatura_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_tgn FOREIGN KEY (assinatura_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_brainstorm FOREIGN KEY (assinatura_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_gut FOREIGN KEY (assinatura_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_causa_efeito FOREIGN KEY (assinatura_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_arquivo FOREIGN KEY (assinatura_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_forum FOREIGN KEY (assinatura_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_checklist FOREIGN KEY (assinatura_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_agenda FOREIGN KEY (assinatura_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_agrupamento FOREIGN KEY (assinatura_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_patrocinador FOREIGN KEY (assinatura_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_template FOREIGN KEY (assinatura_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_painel FOREIGN KEY (assinatura_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_painel_odometro FOREIGN KEY (assinatura_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_painel_composicao FOREIGN KEY (assinatura_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_tr FOREIGN KEY (assinatura_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_me FOREIGN KEY (assinatura_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_plano_acao_item FOREIGN KEY (assinatura_plano_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_beneficio FOREIGN KEY (assinatura_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_painel_slideshow FOREIGN KEY (assinatura_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT assinatura_viabilidade FOREIGN KEY (assinatura_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT assinatura_abertura FOREIGN KEY (assinatura_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT assinatura_plano_gestao FOREIGN KEY (assinatura_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT assinatura_aviso FOREIGN KEY (assinatura_aviso) REFERENCES aviso (aviso_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT assinatura_ssti FOREIGN KEY (assinatura_ssti) REFERENCES ssti (ssti_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT assinatura_laudo FOREIGN KEY (assinatura_laudo) REFERENCES laudo (laudo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT assinatura_trelo FOREIGN KEY (assinatura_trelo) REFERENCES trelo (trelo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT assinatura_trelo_cartao FOREIGN KEY (assinatura_trelo_cartao) REFERENCES trelo_cartao (trelo_cartao_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT assinatura_pdcl FOREIGN KEY (assinatura_pdcl) REFERENCES pdcl (pdcl_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT assinatura_pdcl_item FOREIGN KEY (assinatura_pdcl_item) REFERENCES pdcl_item (pdcl_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT assinatura_os FOREIGN KEY (assinatura_os) REFERENCES os (os_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT assinatura_modelo FOREIGN KEY (assinatura_modelo) REFERENCES modelos (modelo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT assinatura_usuario FOREIGN KEY (assinatura_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT assinatura_atesta FOREIGN KEY (assinatura_atesta) REFERENCES assinatura_atesta (assinatura_atesta_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT assinatura_atesta_opcao FOREIGN KEY (assinatura_atesta_opcao) REFERENCES assinatura_atesta_opcao (assinatura_atesta_opcao_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS assinatura_historico;

CREATE TABLE assinatura_historico (
	assinatura_historico_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	assinatura_historico_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_link INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_template INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	assinatura_historico_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  assinatura_historico_atesta INTEGER(100) UNSIGNED DEFAULT NULL,
  assinatura_historico_atesta_opcao INTEGER(100) UNSIGNED DEFAULT NULL,
  assinatura_historico_funcao VARCHAR (255),
  assinatura_historico_data DATETIME,
  assinatura_historico_aprova TINYINT(1) DEFAULT 0,
  assinatura_historico_observacao MEDIUMTEXT,
	PRIMARY KEY assinatura_historico_id (assinatura_historico_id),
	KEY assinatura_historico_projeto (assinatura_historico_projeto),
	KEY assinatura_historico_tarefa (assinatura_historico_tarefa),
	KEY assinatura_historico_perspectiva (assinatura_historico_perspectiva),
	KEY assinatura_historico_tema (assinatura_historico_tema),
	KEY assinatura_historico_objetivo (assinatura_historico_objetivo),
	KEY assinatura_historico_estrategia (assinatura_historico_estrategia),
	KEY assinatura_historico_meta (assinatura_historico_meta),
	KEY assinatura_historico_fator (assinatura_historico_fator),
	KEY assinatura_historico_pratica (assinatura_historico_pratica),
	KEY assinatura_historico_indicador (assinatura_historico_indicador),
	KEY assinatura_historico_acao (assinatura_historico_acao),
	KEY assinatura_historico_canvas (assinatura_historico_canvas),
	KEY assinatura_historico_risco (assinatura_historico_risco),
	KEY assinatura_historico_risco_resposta (assinatura_historico_risco_resposta),
	KEY assinatura_historico_calendario (assinatura_historico_calendario),
	KEY assinatura_historico_monitoramento (assinatura_historico_monitoramento),
	KEY assinatura_historico_ata (assinatura_historico_ata),
	KEY assinatura_historico_mswot(assinatura_historico_mswot),
	KEY assinatura_historico_swot(assinatura_historico_swot),
	KEY assinatura_historico_operativo(assinatura_historico_operativo),
	KEY assinatura_historico_instrumento (assinatura_historico_instrumento),
	KEY assinatura_historico_recurso (assinatura_historico_recurso),
	KEY assinatura_historico_problema (assinatura_historico_problema),
	KEY assinatura_historico_demanda (assinatura_historico_demanda),
	KEY assinatura_historico_programa (assinatura_historico_programa),
	KEY assinatura_historico_licao (assinatura_historico_licao),
	KEY assinatura_historico_evento (assinatura_historico_evento),
	KEY assinatura_historico_link (assinatura_historico_link),
	KEY assinatura_historico_avaliacao (assinatura_historico_avaliacao),
	KEY assinatura_historico_tgn (assinatura_historico_tgn),
	KEY assinatura_historico_brainstorm (assinatura_historico_brainstorm),
	KEY assinatura_historico_gut (assinatura_historico_gut),
	KEY assinatura_historico_causa_efeito (assinatura_historico_causa_efeito),
	KEY assinatura_historico_arquivo (assinatura_historico_arquivo),
	KEY assinatura_historico_forum (assinatura_historico_forum),
	KEY assinatura_historico_checklist (assinatura_historico_checklist),
	KEY assinatura_historico_agenda (assinatura_historico_agenda),
	KEY assinatura_historico_agrupamento (assinatura_historico_agrupamento),
	KEY assinatura_historico_patrocinador (assinatura_historico_patrocinador),
	KEY assinatura_historico_template (assinatura_historico_template),
	KEY assinatura_historico_painel (assinatura_historico_painel),
	KEY assinatura_historico_painel_odometro (assinatura_historico_painel_odometro),
	KEY assinatura_historico_painel_composicao (assinatura_historico_painel_composicao),
	KEY assinatura_historico_tr (assinatura_historico_tr),
	KEY assinatura_historico_usuario (assinatura_historico_usuario),
  KEY assinatura_historico_atesta (assinatura_historico_atesta),
  KEY assinatura_historico_atesta_opcao (assinatura_historico_atesta_opcao),
	CONSTRAINT assinatura_historico_projeto FOREIGN KEY (assinatura_historico_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_tarefa FOREIGN KEY (assinatura_historico_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_perspectiva FOREIGN KEY (assinatura_historico_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_tema FOREIGN KEY (assinatura_historico_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_objetivo FOREIGN KEY (assinatura_historico_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_fator FOREIGN KEY (assinatura_historico_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_estrategia FOREIGN KEY (assinatura_historico_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_meta FOREIGN KEY (assinatura_historico_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_pratica FOREIGN KEY (assinatura_historico_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_indicador FOREIGN KEY (assinatura_historico_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_acao FOREIGN KEY (assinatura_historico_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_canvas FOREIGN KEY (assinatura_historico_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_risco FOREIGN KEY (assinatura_historico_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_risco_resposta FOREIGN KEY (assinatura_historico_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_calendario FOREIGN KEY (assinatura_historico_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_monitoramento FOREIGN KEY (assinatura_historico_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_ata FOREIGN KEY (assinatura_historico_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_mswot FOREIGN KEY (assinatura_historico_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_swot FOREIGN KEY (assinatura_historico_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_operativo FOREIGN KEY (assinatura_historico_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_instrumento FOREIGN KEY (assinatura_historico_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_recurso FOREIGN KEY (assinatura_historico_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_problema FOREIGN KEY (assinatura_historico_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_demanda FOREIGN KEY (assinatura_historico_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_programa FOREIGN KEY (assinatura_historico_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_licao FOREIGN KEY (assinatura_historico_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_evento FOREIGN KEY (assinatura_historico_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_link FOREIGN KEY (assinatura_historico_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_avaliacao FOREIGN KEY (assinatura_historico_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_tgn FOREIGN KEY (assinatura_historico_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_brainstorm FOREIGN KEY (assinatura_historico_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_gut FOREIGN KEY (assinatura_historico_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_causa_efeito FOREIGN KEY (assinatura_historico_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_arquivo FOREIGN KEY (assinatura_historico_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_forum FOREIGN KEY (assinatura_historico_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_checklist FOREIGN KEY (assinatura_historico_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_agenda FOREIGN KEY (assinatura_historico_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_agrupamento FOREIGN KEY (assinatura_historico_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_patrocinador FOREIGN KEY (assinatura_historico_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_template FOREIGN KEY (assinatura_historico_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_painel FOREIGN KEY (assinatura_historico_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_painel_odometro FOREIGN KEY (assinatura_historico_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_painel_composicao FOREIGN KEY (assinatura_historico_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT assinatura_historico_tr FOREIGN KEY (assinatura_historico_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT assinatura_historico_usuario FOREIGN KEY (assinatura_historico_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT assinatura_historico_atesta FOREIGN KEY (assinatura_historico_atesta) REFERENCES assinatura_atesta (assinatura_atesta_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT assinatura_historico_atesta_opcao FOREIGN KEY (assinatura_historico_atesta_opcao) REFERENCES assinatura_atesta_opcao (assinatura_atesta_opcao_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS patrocinador_cia;

CREATE TABLE patrocinador_cia (
  patrocinador_cia_patrocinador INTEGER(100) UNSIGNED NOT NULL,
  patrocinador_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (patrocinador_cia_patrocinador, patrocinador_cia_cia),
  KEY patrocinador_cia_patrocinador (patrocinador_cia_patrocinador),
  KEY patrocinador_cia_cia (patrocinador_cia_cia),
  CONSTRAINT patrocinador_cia_cia FOREIGN KEY (patrocinador_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT patrocinador_cia_patrocinador FOREIGN KEY (patrocinador_cia_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS canvas_cia;

CREATE TABLE canvas_cia (
  canvas_cia_canvas INTEGER(100) UNSIGNED NOT NULL,
  canvas_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (canvas_cia_canvas, canvas_cia_cia),
  KEY canvas_cia_canvas (canvas_cia_canvas),
  KEY canvas_cia_cia (canvas_cia_cia),
  CONSTRAINT canvas_cia_cia FOREIGN KEY (canvas_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT canvas_cia_canvas FOREIGN KEY (canvas_cia_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS risco_cia;

CREATE TABLE risco_cia (
  risco_cia_risco INTEGER(100) UNSIGNED NOT NULL,
  risco_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (risco_cia_risco, risco_cia_cia),
  KEY risco_cia_risco (risco_cia_risco),
  KEY risco_cia_cia (risco_cia_cia),
  CONSTRAINT risco_cia_cia FOREIGN KEY (risco_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT risco_cia_risco FOREIGN KEY (risco_cia_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS risco_resposta_cia;

CREATE TABLE risco_resposta_cia (
  risco_resposta_cia_risco_resposta INTEGER(100) UNSIGNED NOT NULL,
  risco_resposta_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (risco_resposta_cia_risco_resposta, risco_resposta_cia_cia),
  KEY risco_resposta_cia_risco_resposta (risco_resposta_cia_risco_resposta),
  KEY risco_resposta_cia_cia (risco_resposta_cia_cia),
  CONSTRAINT risco_resposta_cia_cia FOREIGN KEY (risco_resposta_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT risco_resposta_cia_risco_resposta FOREIGN KEY (risco_resposta_cia_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS monitoramento_cia;

CREATE TABLE monitoramento_cia (
  monitoramento_cia_monitoramento INTEGER(100) UNSIGNED NOT NULL,
  monitoramento_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (monitoramento_cia_monitoramento, monitoramento_cia_cia),
  KEY monitoramento_cia_monitoramento (monitoramento_cia_monitoramento),
  KEY monitoramento_cia_cia (monitoramento_cia_cia),
  CONSTRAINT monitoramento_cia_cia FOREIGN KEY (monitoramento_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT monitoramento_cia_monitoramento FOREIGN KEY (monitoramento_cia_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS ata_cia;

CREATE TABLE ata_cia (
  ata_cia_ata INTEGER(100) UNSIGNED NOT NULL,
  ata_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (ata_cia_ata, ata_cia_cia),
  KEY ata_cia_ata (ata_cia_ata),
  KEY ata_cia_cia (ata_cia_cia),
  CONSTRAINT ata_cia_cia FOREIGN KEY (ata_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT ata_cia_ata FOREIGN KEY (ata_cia_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS swot_cia;

CREATE TABLE swot_cia (
  swot_cia_swot INTEGER(100) UNSIGNED NOT NULL,
  swot_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (swot_cia_swot, swot_cia_cia),
  KEY swot_cia_swot (swot_cia_swot),
  KEY swot_cia_cia (swot_cia_cia),
  CONSTRAINT swot_cia_cia FOREIGN KEY (swot_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT swot_cia_swot FOREIGN KEY (swot_cia_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS operativo_cia;

CREATE TABLE operativo_cia (
  operativo_cia_operativo INTEGER(100) UNSIGNED NOT NULL,
  operativo_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (operativo_cia_operativo, operativo_cia_cia),
  KEY operativo_cia_operativo (operativo_cia_operativo),
  KEY operativo_cia_cia (operativo_cia_cia),
  CONSTRAINT operativo_cia_cia FOREIGN KEY (operativo_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT operativo_cia_operativo FOREIGN KEY (operativo_cia_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS problema_cia;

CREATE TABLE problema_cia (
  problema_cia_problema INTEGER(100) UNSIGNED NOT NULL,
  problema_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (problema_cia_problema, problema_cia_cia),
  KEY problema_cia_problema (problema_cia_problema),
  KEY problema_cia_cia (problema_cia_cia),
  CONSTRAINT problema_cia_cia FOREIGN KEY (problema_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT problema_cia_problema FOREIGN KEY (problema_cia_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS programa_cia;

CREATE TABLE programa_cia (
  programa_cia_programa INTEGER(100) UNSIGNED NOT NULL,
  programa_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (programa_cia_programa, programa_cia_cia),
  KEY programa_cia_programa (programa_cia_programa),
  KEY programa_cia_cia (programa_cia_cia),
  CONSTRAINT programa_cia_cia FOREIGN KEY (programa_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT programa_cia_programa FOREIGN KEY (programa_cia_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS tgn_cia;

CREATE TABLE tgn_cia (
  tgn_cia_tgn INTEGER(100) UNSIGNED NOT NULL,
  tgn_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (tgn_cia_tgn, tgn_cia_cia),
  KEY tgn_cia_tgn (tgn_cia_tgn),
  KEY tgn_cia_cia (tgn_cia_cia),
  CONSTRAINT tgn_cia_cia FOREIGN KEY (tgn_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tgn_cia_tgn FOREIGN KEY (tgn_cia_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS agrupamento_cia;

CREATE TABLE agrupamento_cia (
  agrupamento_cia_agrupamento INTEGER(100) UNSIGNED NOT NULL,
  agrupamento_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (agrupamento_cia_agrupamento, agrupamento_cia_cia),
  KEY agrupamento_cia_agrupamento (agrupamento_cia_agrupamento),
  KEY agrupamento_cia_cia (agrupamento_cia_cia),
  CONSTRAINT agrupamento_cia_cia FOREIGN KEY (agrupamento_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT agrupamento_cia_agrupamento FOREIGN KEY (agrupamento_cia_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS template_cia;

CREATE TABLE template_cia (
  template_cia_template INTEGER(100) UNSIGNED NOT NULL,
  template_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (template_cia_template, template_cia_cia),
  KEY template_cia_template (template_cia_template),
  KEY template_cia_cia (template_cia_cia),
  CONSTRAINT template_cia_cia FOREIGN KEY (template_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT template_cia_template FOREIGN KEY (template_cia_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS painel_cia;

CREATE TABLE painel_cia (
  painel_cia_painel INTEGER(100) UNSIGNED NOT NULL,
  painel_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (painel_cia_painel, painel_cia_cia),
  KEY painel_cia_painel (painel_cia_painel),
  KEY painel_cia_cia (painel_cia_cia),
  CONSTRAINT painel_cia_cia FOREIGN KEY (painel_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT painel_cia_painel FOREIGN KEY (painel_cia_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS painel_odometro_cia;

CREATE TABLE painel_odometro_cia (
  painel_odometro_cia_painel_odometro INTEGER(100) UNSIGNED NOT NULL,
  painel_odometro_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (painel_odometro_cia_painel_odometro, painel_odometro_cia_cia),
  KEY painel_odometro_cia_painel_odometro (painel_odometro_cia_painel_odometro),
  KEY painel_odometro_cia_cia (painel_odometro_cia_cia),
  CONSTRAINT painel_odometro_cia_cia FOREIGN KEY (painel_odometro_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT painel_odometro_cia_painel_odometro FOREIGN KEY (painel_odometro_cia_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS painel_composicao_cia;

CREATE TABLE painel_composicao_cia (
  painel_composicao_cia_painel_composicao INTEGER(100) UNSIGNED NOT NULL,
  painel_composicao_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (painel_composicao_cia_painel_composicao, painel_composicao_cia_cia),
  KEY painel_composicao_cia_painel_composicao (painel_composicao_cia_painel_composicao),
  KEY painel_composicao_cia_cia (painel_composicao_cia_cia),
  CONSTRAINT painel_composicao_cia_cia FOREIGN KEY (painel_composicao_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT painel_composicao_cia_painel_composicao FOREIGN KEY (painel_composicao_cia_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS painel_slideshow_cia;

CREATE TABLE painel_slideshow_cia (
  painel_slideshow_cia_painel_slideshow INTEGER(100) UNSIGNED NOT NULL,
  painel_slideshow_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (painel_slideshow_cia_painel_slideshow, painel_slideshow_cia_cia),
  KEY painel_slideshow_cia_painel_slideshow (painel_slideshow_cia_painel_slideshow),
  KEY painel_slideshow_cia_cia (painel_slideshow_cia_cia),
  CONSTRAINT painel_slideshow_cia_cia FOREIGN KEY (painel_slideshow_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT painel_slideshow_cia_painel_slideshow FOREIGN KEY (painel_slideshow_cia_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS tr_entrega;

CREATE TABLE tr_entrega (
	tr_entrega_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  tr_entrega_tr INTEGER(100) UNSIGNED DEFAULT NULL,
  tr_entrega_tipo INTEGER(10) DEFAULT 0,
  tr_entrega_obs VARCHAR(255) DEFAULT NULL,
  tr_entrega_uuid VARCHAR(36) DEFAULT NULL,
  tr_entrega_ordem INTEGER(100) unsigned DEFAULT NULL,
  PRIMARY KEY (tr_entrega_id),
  KEY tr_entrega_tr (tr_entrega_tr),
  CONSTRAINT tr_entrega_tr FOREIGN KEY (tr_entrega_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS tr_cia;

CREATE TABLE tr_cia (
  tr_cia_tr INTEGER(100) UNSIGNED NOT NULL,
  tr_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (tr_cia_tr, tr_cia_cia),
  KEY tr_cia_tr (tr_cia_tr),
  KEY tr_cia_cia (tr_cia_cia),
  CONSTRAINT tr_cia_cia FOREIGN KEY (tr_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tr_cia_tr FOREIGN KEY (tr_cia_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

ALTER TABLE preferencia ADD KEY favorito (favorito);
ALTER TABLE preferencia ADD CONSTRAINT favorito FOREIGN KEY (favorito) REFERENCES menu_item (menu_item_id) ON DELETE SET NULL ON UPDATE CASCADE;


DROP TABLE IF EXISTS mswot_dept;

CREATE TABLE mswot_dept (
  mswot_dept_mswot INTEGER(100) UNSIGNED NOT NULL,
  mswot_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (mswot_dept_mswot, mswot_dept_dept),
  KEY mswot_dept_mswot (mswot_dept_mswot),
  KEY mswot_dept_dept (mswot_dept_dept),
  CONSTRAINT mswot_dept_dept FOREIGN KEY (mswot_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT mswot_dept_mswot FOREIGN KEY (mswot_dept_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS mswot_usuario;

CREATE TABLE mswot_usuario (
  mswot_usuario_mswot INTEGER(100) UNSIGNED NOT NULL,
  mswot_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (mswot_usuario_mswot, mswot_usuario_usuario),
  KEY mswot_usuario_mswot (mswot_usuario_mswot),
  KEY mswot_usuario_usuario (mswot_usuario_usuario),
  CONSTRAINT mswot_usuario_usuario FOREIGN KEY (mswot_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT mswot_usuario_mswot FOREIGN KEY (mswot_usuario_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS mswot_swot;

CREATE TABLE mswot_swot (
	mswot_swot_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  mswot_swot_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
  mswot_swot_swot INTEGER(100) UNSIGNED NOT NULL,
  mswot_swot_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	mswot_swot_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (mswot_swot_id),
  KEY mswot_swot_mswot (mswot_swot_mswot),
  KEY mswot_swot_swot (mswot_swot_swot),
  CONSTRAINT mswot_swot_mswot FOREIGN KEY (mswot_swot_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT mswot_swot_swot FOREIGN KEY (mswot_swot_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS mswot_cia;

CREATE TABLE mswot_cia (
  mswot_cia_mswot INTEGER(100) UNSIGNED NOT NULL,
  mswot_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (mswot_cia_mswot, mswot_cia_cia),
  KEY mswot_cia_mswot (mswot_cia_mswot),
  KEY mswot_cia_cia (mswot_cia_cia),
  CONSTRAINT mswot_cia_cia FOREIGN KEY (mswot_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT mswot_cia_mswot FOREIGN KEY (mswot_cia_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;





DROP TABLE IF EXISTS tr_custo;

CREATE TABLE tr_custo (
  tr_custo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  tr_custo_tr INTEGER(100) UNSIGNED DEFAULT NULL,
  tr_custo_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
  tr_custo_avulso INTEGER(100) UNSIGNED DEFAULT NULL,
  tr_custo_acao INTEGER(100) UNSIGNED DEFAULT NULL,
  tr_custo_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
  tr_custo_quantidade DECIMAL(20,5) UNSIGNED DEFAULT 0,
	tr_custo_aprovou INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_custo_aprovado TINYINT(1) DEFAULT NULL,
	tr_custo_data_aprovado DATETIME DEFAULT NULL,
	tr_custo_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_custo_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (tr_custo_id),
  KEY tr_custo_tr (tr_custo_tr),
  KEY tr_custo_tarefa (tr_custo_tarefa),
  KEY tr_custo_avulso (tr_custo_avulso),
  KEY tr_custo_acao (tr_custo_acao),
  KEY tr_custo_demanda (tr_custo_demanda),
  KEY tr_custo_aprovou (tr_custo_aprovou),
  CONSTRAINT tr_custo_tr FOREIGN KEY (tr_custo_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tr_custo_tarefa FOREIGN KEY (tr_custo_tarefa) REFERENCES tarefa_custos (tarefa_custos_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tr_custo_avulso FOREIGN KEY (tr_custo_avulso) REFERENCES tr_avulso_custo (tr_avulso_custo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_custo_acao FOREIGN KEY (tr_custo_acao) REFERENCES plano_acao_item_custos (plano_acao_item_custos_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_custo_demanda FOREIGN KEY (tr_custo_demanda) REFERENCES demanda_custo (demanda_custo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tr_custo_aprovou FOREIGN KEY (tr_custo_aprovou) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS tr_avulso_custo;

CREATE TABLE tr_avulso_custo (
  tr_avulso_custo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  tr_avulso_custo_tr INTEGER(100) UNSIGNED DEFAULT NULL,
  tr_avulso_custo_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  tr_avulso_custo_nome VARCHAR(255) DEFAULT NULL,
  tr_avulso_custo_codigo VARCHAR(255) DEFAULT NULL,
  tr_avulso_custo_fonte VARCHAR(255) DEFAULT NULL,
  tr_avulso_custo_regiao VARCHAR(255) DEFAULT NULL,
  tr_avulso_custo_tipo INTEGER(100) UNSIGNED DEFAULT 1,
  tr_avulso_custo_data DATETIME DEFAULT NULL,
  tr_avulso_custo_quantidade DECIMAL(20,5) UNSIGNED DEFAULT 0,
  tr_avulso_custo_custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
  tr_avulso_custo_custo_atual DECIMAL(20,5) UNSIGNED DEFAULT 0,
  tr_avulso_custo_bdi DECIMAL(20,5) UNSIGNED DEFAULT 0,
	tr_avulso_custo_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
	tr_avulso_custo_cotacao DECIMAL(6,5) UNSIGNED DEFAULT 1, 
	tr_avulso_custo_data_moeda DATE DEFAULT NULL,
  tr_avulso_custo_percentagem TINYINT(4) DEFAULT 0,
  tr_avulso_custo_descricao MEDIUMTEXT,
  tr_avulso_custo_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  tr_avulso_custo_nd VARCHAR(11) DEFAULT NULL,
  tr_avulso_custo_categoria_economica VARCHAR(1) DEFAULT NULL,
  tr_avulso_custo_grupo_despesa VARCHAR(1) DEFAULT NULL,
  tr_avulso_custo_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  tr_avulso_custo_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_avulso_custo_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
	tr_avulso_custo_data_limite DATE DEFAULT NULL,
	tr_avulso_custo_pi VARCHAR(100) DEFAULT NULL,
	tr_avulso_custo_ptres VARCHAR(100) DEFAULT NULL,
	tr_avulso_custo_siag VARCHAR(100) DEFAULT NULL,
	tr_avulso_custo_meses INTEGER(4) UNSIGNED DEFAULT NULL,	
	tr_avulso_custo_servico TINYINT(1) DEFAULT 0,
	tr_avulso_custo_acrescimo DECIMAL(20,5) DEFAULT 0,
	tr_avulso_custo_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (tr_avulso_custo_id),
  KEY tr_avulso_custo_tr (tr_avulso_custo_tr),
  KEY tr_avulso_custo_usuario_inicio (tr_avulso_custo_usuario),
  KEY tr_avulso_custo_ordem (tr_avulso_custo_ordem),
  KEY tr_avulso_custo_data_inicio (tr_avulso_custo_data),
  KEY tr_avulso_custo_nome (tr_avulso_custo_nome),
  KEY tr_avulso_custo_moeda (tr_avulso_custo_moeda),
  CONSTRAINT tr_avulso_custo_usuario FOREIGN KEY (tr_avulso_custo_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT tr_avulso_custo_tr FOREIGN KEY (tr_avulso_custo_tr) REFERENCES tr (tr_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT tr_avulso_custo_moeda FOREIGN KEY (tr_avulso_custo_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS tr_fornecedor;

CREATE TABLE tr_fornecedor (
  tr_fornecedor_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  tr_fornecedor_tr INTEGER(100) UNSIGNED DEFAULT NULL,
  tr_fornecedor_lote INTEGER(10) DEFAULT NULL,
  tr_fornecedor_empresa VARCHAR(255) DEFAULT NULL,
  tr_fornecedor_cnpj VARCHAR(18) DEFAULT NULL,
  tr_fornecedor_vencimento_vigente DATE DEFAULT NULL,
  tr_fornecedor_nr_contrato VARCHAR(255) DEFAULT NULL,
  tr_fornecedor_valor DECIMAL(20,5) UNSIGNED DEFAULT 0,
  tr_fornecedor_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_fornecedor_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (tr_fornecedor_id),
  KEY tr_fornecedor_tr (tr_fornecedor_tr),
 CONSTRAINT tr_fornecedor_tr FOREIGN KEY (tr_fornecedor_tr) REFERENCES tr (tr_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS projeto_viabilidade_custo;

CREATE TABLE projeto_viabilidade_custo (
  projeto_viabilidade_custo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  projeto_viabilidade_custo_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_viabilidade_custo_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_viabilidade_custo_nome VARCHAR(255) DEFAULT NULL,
  projeto_viabilidade_custo_codigo VARCHAR(255) DEFAULT NULL,
  projeto_viabilidade_custo_fonte VARCHAR(255) DEFAULT NULL,
  projeto_viabilidade_custo_regiao VARCHAR(255) DEFAULT NULL,
  projeto_viabilidade_custo_tipo INTEGER(100) UNSIGNED DEFAULT 1,
  projeto_viabilidade_custo_data DATETIME DEFAULT NULL,
  projeto_viabilidade_custo_quantidade DECIMAL(20,5) UNSIGNED DEFAULT 0,
  projeto_viabilidade_custo_custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
  projeto_viabilidade_custo_bdi DECIMAL(20,5) UNSIGNED DEFAULT 0,
	projeto_viabilidade_custo_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
	projeto_viabilidade_custo_cotacao DECIMAL(6,5) UNSIGNED DEFAULT 1, 
	projeto_viabilidade_custo_data_moeda DATE DEFAULT NULL,
  projeto_viabilidade_custo_percentagem TINYINT(4) DEFAULT 0,
  projeto_viabilidade_custo_descricao MEDIUMTEXT,
  projeto_viabilidade_custo_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_viabilidade_custo_nd VARCHAR(11) DEFAULT NULL,
  projeto_viabilidade_custo_categoria_economica VARCHAR(1) DEFAULT NULL,
  projeto_viabilidade_custo_grupo_despesa VARCHAR(1) DEFAULT NULL,
  projeto_viabilidade_custo_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  projeto_viabilidade_custo_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_viabilidade_custo_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
	projeto_viabilidade_custo_data_limite DATE DEFAULT NULL,
	projeto_viabilidade_custo_pi VARCHAR(100) DEFAULT NULL,
	projeto_viabilidade_custo_aprovou INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_viabilidade_custo_aprovado TINYINT(1) DEFAULT NULL,
	projeto_viabilidade_custo_data_aprovado DATETIME DEFAULT NULL,
  PRIMARY KEY (projeto_viabilidade_custo_id),
  KEY projeto_viabilidade_custo_projeto_viabilidade (projeto_viabilidade_custo_projeto_viabilidade),
  KEY projeto_viabilidade_custo_usuario_inicio (projeto_viabilidade_custo_usuario),
  KEY projeto_viabilidade_custo_ordem (projeto_viabilidade_custo_ordem),
  KEY projeto_viabilidade_custo_data_inicio (projeto_viabilidade_custo_data),
  KEY projeto_viabilidade_custo_nome (projeto_viabilidade_custo_nome),
  KEY projeto_viabilidade_custo_aprovou (projeto_viabilidade_custo_aprovou),
  KEY projeto_viabilidade_custo_moeda (projeto_viabilidade_custo_moeda),
  CONSTRAINT projeto_viabilidade_custo_usuario FOREIGN KEY (projeto_viabilidade_custo_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT projeto_viabilidade_custo_projeto_viabilidade FOREIGN KEY (projeto_viabilidade_custo_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_viabilidade_custo_aprovou FOREIGN KEY (projeto_viabilidade_custo_aprovou) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT projeto_viabilidade_custo_moeda FOREIGN KEY (projeto_viabilidade_custo_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS projeto_abertura_custo;

CREATE TABLE projeto_abertura_custo (
  projeto_abertura_custo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  projeto_abertura_custo_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_abertura_custo_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_abertura_custo_nome VARCHAR(255) DEFAULT NULL,
  projeto_abertura_custo_codigo VARCHAR(255) DEFAULT NULL,
  projeto_abertura_custo_fonte VARCHAR(255) DEFAULT NULL,
  projeto_abertura_custo_regiao VARCHAR(255) DEFAULT NULL,
  projeto_abertura_custo_tipo INTEGER(100) UNSIGNED DEFAULT 1,
  projeto_abertura_custo_data DATETIME DEFAULT NULL,
  projeto_abertura_custo_quantidade DECIMAL(20,5) UNSIGNED DEFAULT 0,
  projeto_abertura_custo_custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
  projeto_abertura_custo_bdi DECIMAL(20,5) UNSIGNED DEFAULT 0,
	projeto_abertura_custo_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
	projeto_abertura_custo_cotacao DECIMAL(6,5) UNSIGNED DEFAULT 1, 
	projeto_abertura_custo_data_moeda DATE DEFAULT NULL,
  projeto_abertura_custo_percentagem TINYINT(4) DEFAULT 0,
  projeto_abertura_custo_descricao MEDIUMTEXT,
  projeto_abertura_custo_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  projeto_abertura_custo_nd VARCHAR(11) DEFAULT NULL,
  projeto_abertura_custo_categoria_economica VARCHAR(1) DEFAULT NULL,
  projeto_abertura_custo_grupo_despesa VARCHAR(1) DEFAULT NULL,
  projeto_abertura_custo_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  projeto_abertura_custo_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_abertura_custo_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
	projeto_abertura_custo_data_limite DATE DEFAULT NULL,
	projeto_abertura_custo_pi VARCHAR(100) DEFAULT NULL,
	projeto_abertura_custo_aprovou INTEGER(100) UNSIGNED DEFAULT NULL,
	projeto_abertura_custo_aprovado TINYINT(1) DEFAULT NULL,
	projeto_abertura_custo_data_aprovado DATETIME DEFAULT NULL,
  PRIMARY KEY (projeto_abertura_custo_id),
  KEY projeto_abertura_custo_projeto_abertura (projeto_abertura_custo_projeto_abertura),
  KEY projeto_abertura_custo_usuario_inicio (projeto_abertura_custo_usuario),
  KEY projeto_abertura_custo_ordem (projeto_abertura_custo_ordem),
  KEY projeto_abertura_custo_data_inicio (projeto_abertura_custo_data),
  KEY projeto_abertura_custo_nome (projeto_abertura_custo_nome),
  KEY projeto_abertura_custo_aprovou (projeto_abertura_custo_aprovou),
  KEY projeto_abertura_custo_moeda (projeto_abertura_custo_moeda),
  CONSTRAINT projeto_abertura_custo_usuario FOREIGN KEY (projeto_abertura_custo_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT projeto_abertura_custo_projeto_abertura FOREIGN KEY (projeto_abertura_custo_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT projeto_abertura_custo_aprovou FOREIGN KEY (projeto_abertura_custo_aprovou) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT projeto_abertura_custo_moeda FOREIGN KEY (projeto_abertura_custo_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS ssti;

CREATE TABLE ssti (
  ssti_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  ssti_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  ssti_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  ssti_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  ssti_principal_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  ssti_laudo INTEGER(100) UNSIGNED DEFAULT NULL,
  ssti_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
  ssti_processo INTEGER(100) UNSIGNED DEFAULT NULL,
  ssti_cancelada_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  ssti_paralisado_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  ssti_nome VARCHAR(255) DEFAULT NULL,
  ssti_numero VARCHAR(255) DEFAULT NULL,
  ssti_data DATETIME DEFAULT NULL,
 	ssti_descricao MEDIUMTEXT,
 	ssti_justificativa MEDIUMTEXT,
 	ssti_funcionamento MEDIUMTEXT,
 	ssti_demanda_legal TINYINT(1) DEFAULT 0,
 	ssti_data_atendimento DATE DEFAULT NULL,
 	ssti_data_publicacao DATE DEFAULT NULL,
 	ssti_multa TINYINT(1) DEFAULT 0,
 	ssti_multa_valor decimal(20,5) UNSIGNED DEFAULT 0,
 	ssti_multa_unidade INTEGER(10) UNSIGNED DEFAULT NULL,
 	ssti_outra_sancao TINYINT(1) DEFAULT 0,
 	ssti_nao_atendimento MEDIUMTEXT,
 	ssti_estimativa_lucro INTEGER(10) UNSIGNED DEFAULT NULL,
 	ssti_disponibilidade INTEGER(10) UNSIGNED DEFAULT NULL,
 	ssti_abrangencia VARCHAR(255) DEFAULT NULL,
	ssti_utilizacao MEDIUMTEXT,
	ssti_info_adicional MEDIUMTEXT,
  ssti_percentagem DECIMAL(20,5) UNSIGNED DEFAULT 0,
  ssti_status INTEGER(10) DEFAULT 0,
  ssti_paralisado_data DATE DEFAULT NULL,
  ssti_paralisado_justificativa VARCHAR(255) DEFAULT NULL,
  ssti_paralisado_motivo INTEGER(10) UNSIGNED DEFAULT NULL,
  ssti_cancelada_data DATE DEFAULT NULL,
  ssti_cancelada_justificativa VARCHAR(255) DEFAULT NULL,
  ssti_cancelada_motivo INTEGER(10) UNSIGNED DEFAULT NULL,
  ssti_classificacao INTEGER(10) UNSIGNED DEFAULT NULL,
  ssti_moeda INTEGER(100) UNSIGNED DEFAULT 1,
  ssti_cor VARCHAR(6) DEFAULT 'ffffff',
  ssti_acesso INTEGER(100) UNSIGNED DEFAULT '0',
  ssti_tem_objetivo TINYINT(1) DEFAULT 0,
  ssti_pdti TINYINT(1) DEFAULT 0,
  ssti_aprovado TINYINT(1) DEFAULT 0,
  ssti_externo TINYINT(1) DEFAULT 0,
  ssti_ativo TINYINT(1) DEFAULT 1,
  PRIMARY KEY (ssti_id),
  KEY ssti_cia (ssti_cia),
  KEY ssti_dept (ssti_dept),
	KEY ssti_responsavel (ssti_responsavel),
  KEY ssti_principal_indicador (ssti_principal_indicador),
  KEY ssti_laudo (ssti_laudo),
  KEY ssti_estrategia (ssti_estrategia),
  KEY ssti_processo (ssti_processo),
  KEY ssti_cancelada_usuario (ssti_cancelada_usuario),
  KEY ssti_paralisado_usuario (ssti_paralisado_usuario),
	KEY ssti_moeda (ssti_moeda),
  CONSTRAINT ssti_responsavel FOREIGN KEY (ssti_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT ssti_cia FOREIGN KEY (ssti_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT ssti_dept FOREIGN KEY (ssti_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT ssti_principal_indicador FOREIGN KEY (ssti_principal_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT ssti_laudo FOREIGN KEY (ssti_laudo) REFERENCES laudo (laudo_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT ssti_estrategia FOREIGN KEY (ssti_estrategia) REFERENCES ssti_estrategia (ssti_estrategia_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT ssti_processo FOREIGN KEY (ssti_processo) REFERENCES ssti_processo (ssti_processo_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT ssti_cancelada_usuario FOREIGN KEY (ssti_cancelada_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT ssti_paralisado_usuario FOREIGN KEY (ssti_paralisado_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT ssti_moeda FOREIGN KEY (ssti_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS ssti_estrategia;

CREATE TABLE ssti_estrategia (
  ssti_estrategia_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  ssti_estrategia_ssti INTEGER(100) UNSIGNED DEFAULT NULL,
  ssti_estrategia_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  ssti_estrategia_data DATETIME DEFAULT NULL,
  ssti_estrategia_conformidade_estrategia TINYINT(1) DEFAULT 0,
  ssti_estrategia_conformidade_demanda TINYINT(1) DEFAULT 0, 
  ssti_estrategia_observacao MEDIUMTEXT,
  ssti_estrategia_apto TINYINT(1) DEFAULT 0,
  PRIMARY KEY (ssti_estrategia_id),
  KEY ssti_estrategia_ssti (ssti_estrategia_ssti),
  KEY ssti_estrategia_usuario (ssti_estrategia_usuario),
  CONSTRAINT ssti_estrategia_ssti FOREIGN KEY (ssti_estrategia_ssti) REFERENCES ssti (ssti_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT ssti_estrategia_usuario FOREIGN KEY (ssti_estrategia_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS ssti_processo;

CREATE TABLE ssti_processo (
  ssti_processo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  ssti_processo_ssti INTEGER(100) UNSIGNED DEFAULT NULL,
  ssti_processo_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  ssti_processo_data DATETIME DEFAULT NULL,
  ssti_processo_solicitante_responsavel TINYINT(1) DEFAULT 0,
  ssti_processo_gestores_envolvidos TINYINT(1) DEFAULT 0, 
  ssti_processo_cria_processo TINYINT(1) DEFAULT 0, 
  ssti_processo_observacao MEDIUMTEXT,
  ssti_processo_apto TINYINT(1) DEFAULT 0, 
  PRIMARY KEY (ssti_processo_id),
  KEY ssti_processo_ssti (ssti_processo_ssti),
  KEY ssti_processo_usuario (ssti_processo_usuario),
  CONSTRAINT ssti_processo_ssti FOREIGN KEY (ssti_processo_ssti) REFERENCES ssti (ssti_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT ssti_processo_usuario FOREIGN KEY (ssti_processo_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS ssti_arquivo;

CREATE TABLE ssti_arquivo (
  ssti_arquivo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  ssti_arquivo_ssti INTEGER(100) UNSIGNED DEFAULT NULL,
  ssti_arquivo_laudo INTEGER(100) UNSIGNED DEFAULT NULL,
  ssti_arquivo_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  ssti_arquivo_ordem INTEGER(11) DEFAULT 0,
  ssti_arquivo_endereco VARCHAR(150) DEFAULT NULL,
  ssti_arquivo_data DATETIME DEFAULT NULL,
  ssti_arquivo_nome VARCHAR(150) DEFAULT NULL,
  ssti_arquivo_nome_real VARCHAR(255) DEFAULT NULL,
	ssti_arquivo_local VARCHAR (255) DEFAULT NULL,
	ssti_arquivo_tamanho INTEGER(100) UNSIGNED DEFAULT NULL,
  ssti_arquivo_tipo VARCHAR(50) DEFAULT NULL,
  ssti_arquivo_extensao VARCHAR(50) DEFAULT NULL,
  ssti_arquivo_status VARCHAR(20) DEFAULT NULL,
  PRIMARY KEY (ssti_arquivo_id),
  KEY ssti_arquivo_ssti (ssti_arquivo_ssti),
  KEY ssti_arquivo_laudo (ssti_arquivo_laudo),
  KEY ssti_arquivo_usuario (ssti_arquivo_usuario),
  CONSTRAINT ssti_arquivo_ssti FOREIGN KEY (ssti_arquivo_ssti) REFERENCES ssti (ssti_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT ssti_arquivo_laudo FOREIGN KEY (ssti_arquivo_laudo) REFERENCES laudo (laudo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT ssti_arquivo_usuario FOREIGN KEY (ssti_arquivo_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS ssti_custo;

CREATE TABLE ssti_custo (
  ssti_custo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  ssti_custo_ssti INTEGER(100) UNSIGNED DEFAULT NULL,
  ssti_custo_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  ssti_custo_tr INTEGER(100) UNSIGNED DEFAULT NULL,
  ssti_custo_nome VARCHAR(255) DEFAULT NULL,
  ssti_custo_codigo VARCHAR(255) DEFAULT NULL,
  ssti_custo_fonte VARCHAR(255) DEFAULT NULL,
  ssti_custo_regiao VARCHAR(255) DEFAULT NULL,
  ssti_custo_tipo INTEGER(100) UNSIGNED DEFAULT 1,
  ssti_custo_data DATETIME DEFAULT NULL,
  ssti_custo_quantidade DECIMAL(20,5) UNSIGNED DEFAULT 0,
  ssti_custo_custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
  ssti_custo_bdi DECIMAL(20,5) UNSIGNED DEFAULT 0,
	ssti_custo_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
	ssti_custo_cotacao DECIMAL(6,5) UNSIGNED DEFAULT 1, 
	ssti_custo_data_moeda DATE DEFAULT NULL,
  ssti_custo_percentagem TINYINT(4) DEFAULT 0,
  ssti_custo_descricao MEDIUMTEXT,
  ssti_custo_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  ssti_custo_nd VARCHAR(11) DEFAULT NULL,
  ssti_custo_categoria_economica VARCHAR(1) DEFAULT NULL,
  ssti_custo_grupo_despesa VARCHAR(1) DEFAULT NULL,
  ssti_custo_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  ssti_custo_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	ssti_custo_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
	ssti_custo_data_limite DATE DEFAULT NULL,
	ssti_custo_pi VARCHAR(100) DEFAULT NULL,
	ssti_custo_aprovou INTEGER(100) UNSIGNED DEFAULT NULL,
	ssti_custo_aprovado TINYINT(1) DEFAULT NULL,
	ssti_custo_data_aprovado DATETIME DEFAULT NULL,
  PRIMARY KEY (ssti_custo_id),
  KEY ssti_custo_ssti (ssti_custo_ssti),
  KEY ssti_custo_usuario_inicio (ssti_custo_usuario),
  KEY ssti_custo_tr (ssti_custo_tr),
  KEY ssti_custo_ordem (ssti_custo_ordem),
  KEY ssti_custo_data_inicio (ssti_custo_data),
  KEY ssti_custo_nome (ssti_custo_nome),
  KEY ssti_custo_aprovou (ssti_custo_aprovou),
  KEY ssti_custo_moeda (ssti_custo_moeda),
  CONSTRAINT ssti_custo_usuario FOREIGN KEY (ssti_custo_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT ssti_custo_tr FOREIGN KEY (ssti_custo_tr) REFERENCES tr (tr_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT ssti_custo_ssti FOREIGN KEY (ssti_custo_ssti) REFERENCES ssti (ssti_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT ssti_custo_aprovou FOREIGN KEY (ssti_custo_aprovou) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT ssti_custo_moeda FOREIGN KEY (ssti_custo_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS ssti_dept;

CREATE TABLE ssti_dept (
  ssti_dept_ssti INTEGER(100) UNSIGNED NOT NULL,
  ssti_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (ssti_dept_ssti, ssti_dept_dept),
  KEY ssti_dept_ssti (ssti_dept_ssti),
  KEY ssti_dept_dept (ssti_dept_dept),
  CONSTRAINT ssti_dept_dept FOREIGN KEY (ssti_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT ssti_dept_ssti FOREIGN KEY (ssti_dept_ssti) REFERENCES ssti (ssti_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS ssti_usuario;

CREATE TABLE ssti_usuario (
  ssti_usuario_ssti INTEGER(100) UNSIGNED NOT NULL,
  ssti_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
  KEY ssti_usuario_ssti (ssti_usuario_ssti),
  KEY ssti_usuario_usuario (ssti_usuario_usuario),
  CONSTRAINT ssti_usuario_ssti FOREIGN KEY (ssti_usuario_ssti) REFERENCES ssti (ssti_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT ssti_usuario_usuario FOREIGN KEY (ssti_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS ssti_patrocinador;

CREATE TABLE ssti_patrocinador (
  ssti_patrocinador_ssti INTEGER(100) UNSIGNED NOT NULL,
  ssti_patrocinador_usuario INTEGER(100) UNSIGNED NOT NULL,
  KEY ssti_patrocinador_ssti (ssti_patrocinador_ssti),
  KEY ssti_patrocinador_usuario (ssti_patrocinador_usuario),
  CONSTRAINT ssti_patrocinador_ssti FOREIGN KEY (ssti_patrocinador_ssti) REFERENCES ssti (ssti_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT ssti_patrocinador_usuario FOREIGN KEY (ssti_patrocinador_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS ssti_stackeholder;

CREATE TABLE ssti_stackeholder (
  ssti_stackeholder_ssti INTEGER(100) UNSIGNED NOT NULL,
  ssti_stackeholder_usuario INTEGER(100) UNSIGNED NOT NULL,
  KEY ssti_stackeholder_ssti (ssti_stackeholder_ssti),
  KEY ssti_stackeholder_usuario (ssti_stackeholder_usuario),
  CONSTRAINT ssti_stackeholder_ssti FOREIGN KEY (ssti_stackeholder_ssti) REFERENCES ssti (ssti_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT ssti_stackeholder_usuario FOREIGN KEY (ssti_stackeholder_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS ssti_cia;

CREATE TABLE ssti_cia (
  ssti_cia_ssti INTEGER(100) UNSIGNED NOT NULL,
  ssti_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (ssti_cia_ssti, ssti_cia_cia),
  KEY ssti_cia_ssti (ssti_cia_ssti),
  KEY ssti_cia_cia (ssti_cia_cia),
  CONSTRAINT ssti_cia_cia FOREIGN KEY (ssti_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT ssti_cia_ssti FOREIGN KEY (ssti_cia_ssti) REFERENCES ssti (ssti_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS ssti_config;

CREATE TABLE ssti_config (
	ssti_config_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	ssti_config_gerente INTEGER(100) UNSIGNED DEFAULT NULL,
	ssti_config_gerente_parecer INTEGER(100) UNSIGNED DEFAULT NULL,
	ssti_config_gerente_nome VARCHAR(255) DEFAULT NULL,
  ssti_config_gestor INTEGER(100) UNSIGNED DEFAULT NULL,
  ssti_config_gestor_parecer INTEGER(100) UNSIGNED DEFAULT NULL,
  ssti_config_gestor_nome VARCHAR(255) DEFAULT NULL,
 	ssti_config_seorp_secretario INTEGER(100) UNSIGNED DEFAULT NULL,
 	ssti_config_seorp_secretario_parecer INTEGER(100) UNSIGNED DEFAULT NULL,
 	ssti_config_seorp_secretario_nome VARCHAR(255) DEFAULT NULL,
  ssti_config_seorp_coordenador INTEGER(100) UNSIGNED DEFAULT NULL,
  ssti_config_seorp_coordenador_parecer INTEGER(100) UNSIGNED DEFAULT NULL,
  ssti_config_seorp_coordenador_nome VARCHAR(255) DEFAULT NULL,
  ssti_config_gereo_gerente INTEGER(100) UNSIGNED DEFAULT NULL,
  ssti_config_gereo_gerente_parecer INTEGER(100) UNSIGNED DEFAULT NULL,
  ssti_config_gereo_gerente_nome VARCHAR(255) DEFAULT NULL,
  ssti_config_gereo_coordenador INTEGER(100) UNSIGNED DEFAULT NULL,
  ssti_config_gereo_coordenador_parecer INTEGER(100) UNSIGNED DEFAULT NULL,
  ssti_config_gereo_coordenador_nome VARCHAR(255) DEFAULT NULL,
  ssti_config_coged_analista INTEGER(100) UNSIGNED DEFAULT NULL,
  ssti_config_coged_analista_parecer INTEGER(100) UNSIGNED DEFAULT NULL,
  ssti_config_coged_analista_nome VARCHAR(255) DEFAULT NULL,
  ssti_config_coged_coordenador INTEGER(100) UNSIGNED DEFAULT NULL,
  ssti_config_coged_coordenador_parecer INTEGER(100) UNSIGNED DEFAULT NULL,
  ssti_config_coged_coordenador_nome VARCHAR(255) DEFAULT NULL,
  PRIMARY KEY (ssti_config_id),
  KEY ssti_config_gerente (ssti_config_gerente),
  KEY ssti_config_gerente_parecer (ssti_config_gerente_parecer),
  KEY ssti_config_gestor (ssti_config_gestor),
  KEY ssti_config_gestor_parecer (ssti_config_gestor_parecer),
  KEY ssti_config_seorp_secretario (ssti_config_seorp_secretario),
  KEY ssti_config_seorp_secretario_parecer (ssti_config_seorp_secretario_parecer),
	KEY ssti_config_seorp_coordenador (ssti_config_seorp_coordenador),
	KEY ssti_config_seorp_coordenador_parecer (ssti_config_seorp_coordenador_parecer),
	KEY ssti_config_gereo_gerente (ssti_config_gereo_gerente),
	KEY ssti_config_gereo_gerente_parecer (ssti_config_gereo_gerente_parecer),
	KEY ssti_config_gereo_coordenador (ssti_config_gereo_coordenador),
	KEY ssti_config_gereo_coordenador_parecer (ssti_config_gereo_coordenador_parecer),
	KEY ssti_config_coged_analista (ssti_config_coged_analista),
  KEY ssti_config_coged_analista_parecer (ssti_config_coged_analista_parecer),
  KEY ssti_config_coged_coordenador (ssti_config_coged_coordenador),
  KEY ssti_config_coged_coordenador_parecer (ssti_config_coged_coordenador_parecer),
	CONSTRAINT ssti_config_gerente FOREIGN KEY (ssti_config_gerente) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT ssti_config_gerente_parecer FOREIGN KEY (ssti_config_gerente_parecer) REFERENCES assinatura_atesta (assinatura_atesta_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT ssti_config_gestor FOREIGN KEY (ssti_config_gestor) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT ssti_config_gestor_parecer FOREIGN KEY (ssti_config_gestor_parecer) REFERENCES assinatura_atesta (assinatura_atesta_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT ssti_config_seorp_secretario FOREIGN KEY (ssti_config_seorp_secretario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT ssti_config_seorp_secretario_parecer FOREIGN KEY (ssti_config_seorp_secretario_parecer) REFERENCES assinatura_atesta (assinatura_atesta_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT ssti_config_seorp_coordenador FOREIGN KEY (ssti_config_seorp_coordenador) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT ssti_config_seorp_coordenador_parecer FOREIGN KEY (ssti_config_seorp_coordenador_parecer) REFERENCES assinatura_atesta (assinatura_atesta_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT ssti_config_gereo_gerente FOREIGN KEY (ssti_config_gereo_gerente) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT ssti_config_gereo_gerente_parecer FOREIGN KEY (ssti_config_gereo_gerente_parecer) REFERENCES assinatura_atesta (assinatura_atesta_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT ssti_config_gereo_coordenador FOREIGN KEY (ssti_config_gereo_coordenador) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT ssti_config_gereo_coordenador_parecer FOREIGN KEY (ssti_config_gereo_coordenador_parecer) REFERENCES assinatura_atesta (assinatura_atesta_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT ssti_config_coged_analista FOREIGN KEY (ssti_config_coged_analista) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT ssti_config_coged_analista_parecer FOREIGN KEY (ssti_config_coged_analista_parecer) REFERENCES assinatura_atesta (assinatura_atesta_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT ssti_config_coged_coordenador FOREIGN KEY (ssti_config_coged_coordenador) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT ssti_config_coged_coordenador_parecer FOREIGN KEY (ssti_config_coged_coordenador_parecer) REFERENCES assinatura_atesta (assinatura_atesta_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS laudo;

CREATE TABLE laudo (
    laudo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
    laudo_cia INTEGER(100) UNSIGNED DEFAULT NULL,
    laudo_dept INTEGER(100) UNSIGNED DEFAULT NULL,
    laudo_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
    laudo_principal_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
    laudo_ssti INTEGER(100) UNSIGNED DEFAULT NULL,
    laudo_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
    laudo_ranking_dept INTEGER(100) UNSIGNED DEFAULT NULL,
    laudo_nome VARCHAR(255) DEFAULT NULL,
    laudo_numero VARCHAR(255) DEFAULT NULL,
    laudo_descricao MEDIUMTEXT,
    laudo_abrangencia MEDIUMTEXT,
    laudo_sistema_principal INTEGER (10) DEFAULT NULL,
    laudo_sistema_alternativo MEDIUMTEXT,
    laudo_equipe INTEGER (10) DEFAULT NULL,
    laudo_tipo_demanda INTEGER(10) DEFAULT 0,
    laudo_custo_desenvolvimento MEDIUMTEXT,
    laudo_tempo_desenvolvimento MEDIUMTEXT,
    laudo_ranking INTEGER(10) DEFAULT 0,
    laudo_ranking_data DATETIME,
    laudo_ranking_sugestao INTEGER(10) DEFAULT 0,
    laudo_ranking_sugestao_valor_aceito INTEGER(10) DEFAULT NULL,
    laudo_ranking_valor_aceito INTEGER(10) DEFAULT NULL,
    laudo_apontamento MEDIUMTEXT,
    laudo_percentagem DECIMAL(20,5) UNSIGNED DEFAULT 0,
    laudo_ponto_funcao DECIMAL(20,5) UNSIGNED DEFAULT 0,
    laudo_tempo_desenvolvimento_numerico decimal(20,5) UNSIGNED DEFAULT 0,
    laudo_tempo_desenvolvimento_escala VARCHAR(20) DEFAULT NULL,
    laudo_custo_total DECIMAL(20,5) UNSIGNED DEFAULT 0,
    laudo_status INTEGER(10) DEFAULT 0,
    laudo_comite VARCHAR(50) DEFAULT NULL,
    laudo_classificacao INTEGER(10) DEFAULT 0,
    laudo_moeda INTEGER(100) UNSIGNED DEFAULT 1,
    laudo_cor VARCHAR(6) DEFAULT 'ffffff',
    laudo_acesso INTEGER(100) UNSIGNED DEFAULT '0',
    laudo_aprovado TINYINT(1) DEFAULT 0,
    laudo_tem_objetivo TINYINT(1) DEFAULT 0,
    laudo_pontuacao DECIMAL(20,5) UNSIGNED DEFAULT 0,
    laudo_criacao DATETIME DEFAULT NULL,
    laudo_aprovado_data DATETIME DEFAULT NULL,
    laudo_paralisado_data DATE DEFAULT NULL,
    laudo_paralisado_motivo INTEGER(10) UNSIGNED DEFAULT NULL,
    laudo_externo TINYINT(1) DEFAULT 0,
    laudo_ativo TINYINT(1) DEFAULT 1,
    PRIMARY KEY (laudo_id),
    KEY laudo_cia (laudo_cia),
    KEY laudo_dept (laudo_dept),
    KEY laudo_responsavel (laudo_responsavel),
    KEY laudo_principal_indicador (laudo_principal_indicador),
    KEY laudo_ssti (laudo_ssti),
    KEY laudo_projeto (laudo_projeto),
    KEY laudo_ranking_dept (laudo_ranking_dept),
    KEY laudo_moeda (laudo_moeda),
    CONSTRAINT laudo_responsavel FOREIGN KEY (laudo_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
    CONSTRAINT laudo_cia FOREIGN KEY (laudo_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT laudo_dept FOREIGN KEY (laudo_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
    CONSTRAINT laudo_principal_indicador FOREIGN KEY (laudo_principal_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
    CONSTRAINT laudo_ssti FOREIGN KEY (laudo_ssti) REFERENCES ssti (ssti_id) ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT laudo_projeto FOREIGN KEY (laudo_projeto) REFERENCES projetos (projeto_id) ON DELETE SET NULL ON UPDATE CASCADE,
    CONSTRAINT laudo_ranking_dept FOREIGN KEY (laudo_ranking_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
    CONSTRAINT laudo_moeda FOREIGN KEY (laudo_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS laudo_paralisado;

CREATE TABLE laudo_paralisado (
  laudo_paralisado_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  laudo_paralisado_laudo INTEGER(100) UNSIGNED DEFAULT NULL,
  laudo_paralisado_usuario_inicio INTEGER(100) UNSIGNED DEFAULT NULL,
  laudo_paralisado_usuario_fim INTEGER(100) UNSIGNED DEFAULT NULL,
  laudo_paralisado_inicio DATETIME DEFAULT NULL,
  laudo_paralisado_fim DATETIME DEFAULT NULL,
  laudo_paralisado_motivo INTEGER(10) UNSIGNED DEFAULT NULL,
  laudo_paralisado_horas DECIMAL(20,5) UNSIGNED DEFAULT NULL,
  laudo_paralisado_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (laudo_paralisado_id),
  KEY laudo_paralisado_laudo (laudo_paralisado_laudo),
  KEY laudo_paralisado_usuario_inicio (laudo_paralisado_usuario_inicio),
  KEY laudo_paralisado_usuario_fim (laudo_paralisado_usuario_fim),
  CONSTRAINT laudo_paralisado_laudo FOREIGN KEY (laudo_paralisado_laudo) REFERENCES laudo (laudo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT laudo_paralisado_usuario_inicio FOREIGN KEY (laudo_paralisado_usuario_inicio) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT laudo_paralisado_usuario_fim FOREIGN KEY (laudo_paralisado_usuario_fim) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS laudo_stackeholder;

CREATE TABLE laudo_stackeholder (
  laudo_stackeholder_laudo INTEGER(100) UNSIGNED NOT NULL,
  laudo_stackeholder_usuario INTEGER(100) UNSIGNED NOT NULL,
  KEY laudo_stackeholder_laudo (laudo_stackeholder_laudo),
  KEY laudo_stackeholder_usuario (laudo_stackeholder_usuario),
  CONSTRAINT laudo_stackeholder_laudo FOREIGN KEY (laudo_stackeholder_laudo) REFERENCES laudo (laudo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT laudo_stackeholder_usuario FOREIGN KEY (laudo_stackeholder_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS laudo_custo;

CREATE TABLE laudo_custo (
  laudo_custo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  laudo_custo_laudo INTEGER(100) UNSIGNED DEFAULT NULL,
  laudo_custo_usuario INTEGER(100) UNSIGNED DEFAULT NULL,
  laudo_custo_tr INTEGER(100) UNSIGNED DEFAULT NULL,
  laudo_custo_nome VARCHAR(255) DEFAULT NULL,
  laudo_custo_codigo VARCHAR(255) DEFAULT NULL,
  laudo_custo_fonte VARCHAR(255) DEFAULT NULL,
  laudo_custo_regiao VARCHAR(255) DEFAULT NULL,
  laudo_custo_tipo INTEGER(100) UNSIGNED DEFAULT 1,
  laudo_custo_data DATETIME DEFAULT NULL,
  laudo_custo_quantidade DECIMAL(20,5) UNSIGNED DEFAULT 0,
  laudo_custo_custo DECIMAL(20,5) UNSIGNED DEFAULT 0,
  laudo_custo_bdi DECIMAL(20,5) UNSIGNED DEFAULT 0,
	laudo_custo_moeda INTEGER(100) UNSIGNED DEFAULT 1, 
	laudo_custo_cotacao DECIMAL(6,5) UNSIGNED DEFAULT 1, 
	laudo_custo_data_moeda DATE DEFAULT NULL,
  laudo_custo_percentagem TINYINT(4) DEFAULT 0,
  laudo_custo_descricao MEDIUMTEXT,
  laudo_custo_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
  laudo_custo_nd VARCHAR(11) DEFAULT NULL,
  laudo_custo_categoria_economica VARCHAR(1) DEFAULT NULL,
  laudo_custo_grupo_despesa VARCHAR(1) DEFAULT NULL,
  laudo_custo_modalidade_aplicacao VARCHAR(2) DEFAULT NULL,
  laudo_custo_metodo INTEGER(100) UNSIGNED DEFAULT NULL,
	laudo_custo_exercicio INTEGER(4) UNSIGNED DEFAULT NULL,
	laudo_custo_data_limite DATE DEFAULT NULL,
	laudo_custo_pi VARCHAR(100) DEFAULT NULL,
	laudo_custo_aprovou INTEGER(100) UNSIGNED DEFAULT NULL,
	laudo_custo_aprovado TINYINT(1) DEFAULT NULL,
	laudo_custo_data_aprovado DATETIME DEFAULT NULL,
	laudo_custo_uuid VARCHAR(36) DEFAULT NULL,
  PRIMARY KEY (laudo_custo_id),
  KEY laudo_custo_laudo (laudo_custo_laudo),
  KEY laudo_custo_usuario_inicio (laudo_custo_usuario),
  KEY laudo_custo_tr (laudo_custo_tr),
  KEY laudo_custo_ordem (laudo_custo_ordem),
  KEY laudo_custo_data_inicio (laudo_custo_data),
  KEY laudo_custo_nome (laudo_custo_nome),
  KEY laudo_custo_aprovou (laudo_custo_aprovou),
  KEY laudo_custo_moeda (laudo_custo_moeda),
  CONSTRAINT laudo_custo_usuario FOREIGN KEY (laudo_custo_usuario) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT laudo_custo_tr FOREIGN KEY (laudo_custo_tr) REFERENCES tr (tr_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT laudo_custo_laudo FOREIGN KEY (laudo_custo_laudo) REFERENCES laudo (laudo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT laudo_custo_aprovou FOREIGN KEY (laudo_custo_aprovou) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT laudo_custo_moeda FOREIGN KEY (laudo_custo_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS laudo_dept;

CREATE TABLE laudo_dept (
  laudo_dept_laudo INTEGER(100) UNSIGNED NOT NULL,
  laudo_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (laudo_dept_laudo, laudo_dept_dept),
  KEY laudo_dept_laudo (laudo_dept_laudo),
  KEY laudo_dept_dept (laudo_dept_dept),
  CONSTRAINT laudo_dept_dept FOREIGN KEY (laudo_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT laudo_dept_laudo FOREIGN KEY (laudo_dept_laudo) REFERENCES laudo (laudo_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS laudo_usuario;

CREATE TABLE laudo_usuario (
  laudo_usuario_laudo INTEGER(100) UNSIGNED NOT NULL,
  laudo_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
  KEY laudo_usuario_laudo (laudo_usuario_laudo),
  KEY laudo_usuario_usuario (laudo_usuario_usuario),
  CONSTRAINT laudo_usuario_laudo FOREIGN KEY (laudo_usuario_laudo) REFERENCES laudo (laudo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT laudo_usuario_usuario FOREIGN KEY (laudo_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS laudo_cia;

CREATE TABLE laudo_cia (
  laudo_cia_laudo INTEGER(100) UNSIGNED NOT NULL,
  laudo_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (laudo_cia_laudo, laudo_cia_cia),
  KEY laudo_cia_laudo (laudo_cia_laudo),
  KEY laudo_cia_cia (laudo_cia_cia),
  CONSTRAINT laudo_cia_cia FOREIGN KEY (laudo_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT laudo_cia_laudo FOREIGN KEY (laudo_cia_laudo) REFERENCES laudo (laudo_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;




DROP TABLE IF EXISTS trelo;

CREATE TABLE trelo (
  trelo_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  trelo_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  trelo_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  trelo_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  trelo_principal_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  trelo_nome VARCHAR(255) DEFAULT NULL,
 	trelo_descricao MEDIUMTEXT,
  trelo_percentagem decimal(20,5) UNSIGNED DEFAULT 0,
  trelo_status INTEGER(10) DEFAULT 0,
  trelo_moeda INTEGER(100) UNSIGNED DEFAULT 1,
  trelo_cor VARCHAR(6) DEFAULT 'ffffff',
  trelo_acesso INTEGER(100) UNSIGNED DEFAULT '0',
  trelo_aprovado TINYINT(1) DEFAULT 0,
  trelo_ativo TINYINT(1) DEFAULT 1,
  PRIMARY KEY (trelo_id),
  KEY trelo_cia (trelo_cia),
  KEY trelo_dept (trelo_dept),
	KEY trelo_responsavel (trelo_responsavel),
  KEY trelo_principal_indicador (trelo_principal_indicador),
	KEY trelo_moeda (trelo_moeda),
  CONSTRAINT trelo_responsavel FOREIGN KEY (trelo_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT trelo_cia FOREIGN KEY (trelo_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT trelo_dept FOREIGN KEY (trelo_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT trelo_principal_indicador FOREIGN KEY (trelo_principal_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT trelo_moeda FOREIGN KEY (trelo_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS trelo_dept;

CREATE TABLE trelo_dept (
  trelo_dept_trelo INTEGER(100) UNSIGNED NOT NULL,
  trelo_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (trelo_dept_trelo, trelo_dept_dept),
  KEY trelo_dept_trelo (trelo_dept_trelo),
  KEY trelo_dept_dept (trelo_dept_dept),
  CONSTRAINT trelo_dept_dept FOREIGN KEY (trelo_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT trelo_dept_trelo FOREIGN KEY (trelo_dept_trelo) REFERENCES trelo (trelo_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS trelo_usuario;

CREATE TABLE trelo_usuario (
  trelo_usuario_trelo INTEGER(100) UNSIGNED NOT NULL,
  trelo_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
  KEY trelo_usuario_trelo (trelo_usuario_trelo),
  KEY trelo_usuario_usuario (trelo_usuario_usuario),
  CONSTRAINT trelo_usuario_trelo FOREIGN KEY (trelo_usuario_trelo) REFERENCES trelo (trelo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT trelo_usuario_usuario FOREIGN KEY (trelo_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS trelo_cia;

CREATE TABLE trelo_cia (
  trelo_cia_trelo INTEGER(100) UNSIGNED NOT NULL,
  trelo_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (trelo_cia_trelo, trelo_cia_cia),
  KEY trelo_cia_trelo (trelo_cia_trelo),
  KEY trelo_cia_cia (trelo_cia_cia),
  CONSTRAINT trelo_cia_cia FOREIGN KEY (trelo_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT trelo_cia_trelo FOREIGN KEY (trelo_cia_trelo) REFERENCES trelo (trelo_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS trelo_cartao;

CREATE TABLE trelo_cartao (
  trelo_cartao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
  trelo_cartao_cia INTEGER(100) UNSIGNED DEFAULT NULL,
  trelo_cartao_dept INTEGER(100) UNSIGNED DEFAULT NULL,
  trelo_cartao_responsavel INTEGER(100) UNSIGNED DEFAULT NULL,
  trelo_cartao_principal_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
  trelo_cartao_nome VARCHAR(255) DEFAULT NULL,
 	trelo_cartao_descricao MEDIUMTEXT,
  trelo_cartao_percentagem decimal(20,5) UNSIGNED DEFAULT 0,
  trelo_cartao_status INTEGER(10) DEFAULT 0,
  trelo_cartao_moeda INTEGER(100) UNSIGNED DEFAULT 1,
  trelo_cartao_cor VARCHAR(6) DEFAULT 'ffffff',
  trelo_cartao_acesso INTEGER(100) UNSIGNED DEFAULT '0',
  trelo_cartao_aprovado TINYINT(1) DEFAULT 0,
  trelo_cartao_ativo TINYINT(1) DEFAULT 1,
  PRIMARY KEY (trelo_cartao_id),
  KEY trelo_cartao_cia (trelo_cartao_cia),
  KEY trelo_cartao_dept (trelo_cartao_dept),
	KEY trelo_cartao_responsavel (trelo_cartao_responsavel),
  KEY trelo_cartao_principal_indicador (trelo_cartao_principal_indicador),
	KEY trelo_cartao_moeda (trelo_cartao_moeda),
  CONSTRAINT trelo_cartao_responsavel FOREIGN KEY (trelo_cartao_responsavel) REFERENCES usuarios (usuario_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT trelo_cartao_cia FOREIGN KEY (trelo_cartao_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT trelo_cartao_dept FOREIGN KEY (trelo_cartao_dept) REFERENCES depts (dept_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT trelo_cartao_principal_indicador FOREIGN KEY (trelo_cartao_principal_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT trelo_cartao_moeda FOREIGN KEY (trelo_cartao_moeda) REFERENCES moeda (moeda_id) ON DELETE SET NULL ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS trelo_cartao_dept;

CREATE TABLE trelo_cartao_dept (
  trelo_cartao_dept_trelo_cartao INTEGER(100) UNSIGNED NOT NULL,
  trelo_cartao_dept_dept INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (trelo_cartao_dept_trelo_cartao, trelo_cartao_dept_dept),
  KEY trelo_cartao_dept_trelo_cartao (trelo_cartao_dept_trelo_cartao),
  KEY trelo_cartao_dept_dept (trelo_cartao_dept_dept),
  CONSTRAINT trelo_cartao_dept_dept FOREIGN KEY (trelo_cartao_dept_dept) REFERENCES depts (dept_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT trelo_cartao_dept_trelo_cartao FOREIGN KEY (trelo_cartao_dept_trelo_cartao) REFERENCES trelo_cartao (trelo_cartao_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS trelo_cartao_usuario;

CREATE TABLE trelo_cartao_usuario (
  trelo_cartao_usuario_trelo_cartao INTEGER(100) UNSIGNED NOT NULL,
  trelo_cartao_usuario_usuario INTEGER(100) UNSIGNED NOT NULL,
  KEY trelo_cartao_usuario_trelo_cartao (trelo_cartao_usuario_trelo_cartao),
  KEY trelo_cartao_usuario_usuario (trelo_cartao_usuario_usuario),
  CONSTRAINT trelo_cartao_usuario_trelo_cartao FOREIGN KEY (trelo_cartao_usuario_trelo_cartao) REFERENCES trelo_cartao (trelo_cartao_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT trelo_cartao_usuario_usuario FOREIGN KEY (trelo_cartao_usuario_usuario) REFERENCES usuarios (usuario_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS trelo_cartao_cia;

CREATE TABLE trelo_cartao_cia (
  trelo_cartao_cia_trelo_cartao INTEGER(100) UNSIGNED NOT NULL,
  trelo_cartao_cia_cia INTEGER(100) UNSIGNED NOT NULL,
  PRIMARY KEY (trelo_cartao_cia_trelo_cartao, trelo_cartao_cia_cia),
  KEY trelo_cartao_cia_trelo_cartao (trelo_cartao_cia_trelo_cartao),
  KEY trelo_cartao_cia_cia (trelo_cartao_cia_cia),
  CONSTRAINT trelo_cartao_cia_cia FOREIGN KEY (trelo_cartao_cia_cia) REFERENCES cias (cia_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT trelo_cartao_cia_trelo_cartao FOREIGN KEY (trelo_cartao_cia_trelo_cartao) REFERENCES trelo_cartao (trelo_cartao_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;



DROP TABLE IF EXISTS tr_gestao;

CREATE TABLE tr_gestao (
	tr_gestao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	tr_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_ssti INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_laudo INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_trelo INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_trelo_cartao INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_pdcl INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_pdcl_item INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_os INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	tr_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY tr_gestao_id (tr_gestao_id),
	KEY tr_gestao_tr (tr_gestao_tr),
	KEY tr_gestao_semelhante (tr_gestao_semelhante),
	KEY tr_gestao_projeto (tr_gestao_projeto),
	KEY tr_gestao_tarefa (tr_gestao_tarefa),
	KEY tr_gestao_perspectiva (tr_gestao_perspectiva),
	KEY tr_gestao_tema (tr_gestao_tema),
	KEY tr_gestao_objetivo (tr_gestao_objetivo),
	KEY tr_gestao_estrategia (tr_gestao_estrategia),
	KEY tr_gestao_meta (tr_gestao_meta),
	KEY tr_gestao_fator (tr_gestao_fator),
	KEY tr_gestao_pratica (tr_gestao_pratica),
	KEY tr_gestao_indicador (tr_gestao_indicador),
	KEY tr_gestao_acao (tr_gestao_acao),
	KEY tr_gestao_canvas (tr_gestao_canvas),
	KEY tr_gestao_risco (tr_gestao_risco),
	KEY tr_gestao_risco_resposta (tr_gestao_risco_resposta),
	KEY tr_gestao_calendario (tr_gestao_calendario),
	KEY tr_gestao_monitoramento (tr_gestao_monitoramento),
	KEY tr_gestao_ata (tr_gestao_ata),
	KEY tr_gestao_mswot(tr_gestao_mswot),
	KEY tr_gestao_swot(tr_gestao_swot),
	KEY tr_gestao_operativo(tr_gestao_operativo),
	KEY tr_gestao_instrumento (tr_gestao_instrumento),
	KEY tr_gestao_recurso (tr_gestao_recurso),
	KEY tr_gestao_problema (tr_gestao_problema),
	KEY tr_gestao_demanda (tr_gestao_demanda),
	KEY tr_gestao_programa (tr_gestao_programa),
	KEY tr_gestao_licao (tr_gestao_licao),
	KEY tr_gestao_evento (tr_gestao_evento),
	KEY tr_gestao_link (tr_gestao_link),
	KEY tr_gestao_avaliacao (tr_gestao_avaliacao),
	KEY tr_gestao_tgn (tr_gestao_tgn),
	KEY tr_gestao_brainstorm (tr_gestao_brainstorm),
	KEY tr_gestao_gut (tr_gestao_gut),
	KEY tr_gestao_causa_efeito (tr_gestao_causa_efeito),
	KEY tr_gestao_arquivo (tr_gestao_arquivo),
	KEY tr_gestao_forum (tr_gestao_forum),
	KEY tr_gestao_checklist (tr_gestao_checklist),
	KEY tr_gestao_agenda (tr_gestao_agenda),
	KEY tr_gestao_agrupamento (tr_gestao_agrupamento),
	KEY tr_gestao_patrocinador (tr_gestao_patrocinador),
	KEY tr_gestao_template (tr_gestao_template),
	KEY tr_gestao_painel (tr_gestao_painel),
	KEY tr_gestao_painel_composicao (tr_gestao_painel_composicao),
	KEY tr_gestao_painel_odometro (tr_gestao_painel_odometro),
	KEY tr_gestao_me (tr_gestao_me),
	KEY tr_gestao_acao_item (tr_gestao_acao_item),
	KEY tr_gestao_beneficio (tr_gestao_beneficio),
	KEY tr_gestao_painel_slideshow (tr_gestao_painel_slideshow),
	KEY tr_gestao_projeto_viabilidade (tr_gestao_projeto_viabilidade),
	KEY tr_gestao_projeto_abertura (tr_gestao_projeto_abertura),
	KEY tr_gestao_plano_gestao (tr_gestao_plano_gestao),
	KEY tr_gestao_ssti (tr_gestao_ssti),
	KEY tr_gestao_laudo (tr_gestao_laudo),
	KEY tr_gestao_trelo (tr_gestao_trelo),
	KEY tr_gestao_trelo_cartao (tr_gestao_trelo_cartao),
	KEY tr_gestao_pdcl (tr_gestao_pdcl),
	KEY tr_gestao_pdcl_item (tr_gestao_pdcl_item),
	KEY tr_gestao_os (tr_gestao_os),
	CONSTRAINT tr_gestao_tr FOREIGN KEY (tr_gestao_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_semelhante FOREIGN KEY (tr_gestao_semelhante) REFERENCES tr (tr_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_projeto FOREIGN KEY (tr_gestao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_tarefa FOREIGN KEY (tr_gestao_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_perspectiva FOREIGN KEY (tr_gestao_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_tema FOREIGN KEY (tr_gestao_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_objetivo FOREIGN KEY (tr_gestao_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_fator FOREIGN KEY (tr_gestao_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_estrategia FOREIGN KEY (tr_gestao_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_meta FOREIGN KEY (tr_gestao_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_pratica FOREIGN KEY (tr_gestao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_indicador FOREIGN KEY (tr_gestao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_acao FOREIGN KEY (tr_gestao_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_canvas FOREIGN KEY (tr_gestao_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_risco FOREIGN KEY (tr_gestao_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_risco_resposta FOREIGN KEY (tr_gestao_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_calendario FOREIGN KEY (tr_gestao_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_monitoramento FOREIGN KEY (tr_gestao_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_ata FOREIGN KEY (tr_gestao_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_mswot FOREIGN KEY (tr_gestao_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_swot FOREIGN KEY (tr_gestao_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_operativo FOREIGN KEY (tr_gestao_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_instrumento FOREIGN KEY (tr_gestao_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_recurso FOREIGN KEY (tr_gestao_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_problema FOREIGN KEY (tr_gestao_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_demanda FOREIGN KEY (tr_gestao_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_programa FOREIGN KEY (tr_gestao_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_licao FOREIGN KEY (tr_gestao_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_evento FOREIGN KEY (tr_gestao_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_link FOREIGN KEY (tr_gestao_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_avaliacao FOREIGN KEY (tr_gestao_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_tgn FOREIGN KEY (tr_gestao_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_brainstorm FOREIGN KEY (tr_gestao_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_gut FOREIGN KEY (tr_gestao_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_causa_efeito FOREIGN KEY (tr_gestao_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_arquivo FOREIGN KEY (tr_gestao_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_forum FOREIGN KEY (tr_gestao_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_checklist FOREIGN KEY (tr_gestao_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_agenda FOREIGN KEY (tr_gestao_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_agrupamento FOREIGN KEY (tr_gestao_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_patrocinador FOREIGN KEY (tr_gestao_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_template FOREIGN KEY (tr_gestao_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_painel FOREIGN KEY (tr_gestao_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_painel_odometro FOREIGN KEY (tr_gestao_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_painel_composicao FOREIGN KEY (tr_gestao_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_me FOREIGN KEY (tr_gestao_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_acao_item FOREIGN KEY (tr_gestao_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_beneficio FOREIGN KEY (tr_gestao_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_painel_slideshow FOREIGN KEY (tr_gestao_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_projeto_viabilidade FOREIGN KEY (tr_gestao_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_projeto_abertura FOREIGN KEY (tr_gestao_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_plano_gestao FOREIGN KEY (tr_gestao_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tr_gestao_ssti FOREIGN KEY (tr_gestao_ssti) REFERENCES ssti (ssti_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tr_gestao_laudo FOREIGN KEY (tr_gestao_laudo) REFERENCES laudo (laudo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tr_gestao_trelo FOREIGN KEY (tr_gestao_trelo) REFERENCES trelo (trelo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tr_gestao_trelo_cartao FOREIGN KEY (tr_gestao_trelo_cartao) REFERENCES trelo_cartao (trelo_cartao_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tr_gestao_pdcl FOREIGN KEY (tr_gestao_pdcl) REFERENCES pdcl (pdcl_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tr_gestao_pdcl_item FOREIGN KEY (tr_gestao_pdcl_item) REFERENCES pdcl_item (pdcl_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT tr_gestao_os FOREIGN KEY (tr_gestao_os) REFERENCES os (os_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS agrupamento_gestao;

CREATE TABLE agrupamento_gestao (
	agrupamento_gestao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	agrupamento_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_ssti INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_laudo INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_trelo INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_trelo_cartao INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_pdcl INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_pdcl_item INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_os INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	agrupamento_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY agrupamento_gestao_id (agrupamento_gestao_id),
	KEY agrupamento_gestao_agrupamento (agrupamento_gestao_agrupamento),
	KEY agrupamento_gestao_semelhante (agrupamento_gestao_semelhante),
	KEY agrupamento_gestao_projeto (agrupamento_gestao_projeto),
	KEY agrupamento_gestao_tarefa (agrupamento_gestao_tarefa),
	KEY agrupamento_gestao_perspectiva (agrupamento_gestao_perspectiva),
	KEY agrupamento_gestao_tema (agrupamento_gestao_tema),
	KEY agrupamento_gestao_objetivo (agrupamento_gestao_objetivo),
	KEY agrupamento_gestao_estrategia (agrupamento_gestao_estrategia),
	KEY agrupamento_gestao_meta (agrupamento_gestao_meta),
	KEY agrupamento_gestao_fator (agrupamento_gestao_fator),
	KEY agrupamento_gestao_pratica (agrupamento_gestao_pratica),
	KEY agrupamento_gestao_indicador (agrupamento_gestao_indicador),
	KEY agrupamento_gestao_acao (agrupamento_gestao_acao),
	KEY agrupamento_gestao_canvas (agrupamento_gestao_canvas),
	KEY agrupamento_gestao_risco (agrupamento_gestao_risco),
	KEY agrupamento_gestao_risco_resposta (agrupamento_gestao_risco_resposta),
	KEY agrupamento_gestao_calendario (agrupamento_gestao_calendario),
	KEY agrupamento_gestao_monitoramento (agrupamento_gestao_monitoramento),
	KEY agrupamento_gestao_ata (agrupamento_gestao_ata),
	KEY agrupamento_gestao_mswot(agrupamento_gestao_mswot),
	KEY agrupamento_gestao_swot(agrupamento_gestao_swot),
	KEY agrupamento_gestao_operativo(agrupamento_gestao_operativo),
	KEY agrupamento_gestao_instrumento (agrupamento_gestao_instrumento),
	KEY agrupamento_gestao_recurso (agrupamento_gestao_recurso),
	KEY agrupamento_gestao_problema (agrupamento_gestao_problema),
	KEY agrupamento_gestao_demanda (agrupamento_gestao_demanda),
	KEY agrupamento_gestao_programa (agrupamento_gestao_programa),
	KEY agrupamento_gestao_licao (agrupamento_gestao_licao),
	KEY agrupamento_gestao_evento (agrupamento_gestao_evento),
	KEY agrupamento_gestao_link (agrupamento_gestao_link),
	KEY agrupamento_gestao_avaliacao (agrupamento_gestao_avaliacao),
	KEY agrupamento_gestao_tgn (agrupamento_gestao_tgn),
	KEY agrupamento_gestao_brainstorm (agrupamento_gestao_brainstorm),
	KEY agrupamento_gestao_gut (agrupamento_gestao_gut),
	KEY agrupamento_gestao_causa_efeito (agrupamento_gestao_causa_efeito),
	KEY agrupamento_gestao_arquivo (agrupamento_gestao_arquivo),
	KEY agrupamento_gestao_forum (agrupamento_gestao_forum),
	KEY agrupamento_gestao_checklist (agrupamento_gestao_checklist),
	KEY agrupamento_gestao_agenda (agrupamento_gestao_agenda),
	KEY agrupamento_gestao_patrocinador (agrupamento_gestao_patrocinador),
	KEY agrupamento_gestao_template (agrupamento_gestao_template),
	KEY agrupamento_gestao_painel (agrupamento_gestao_painel),
	KEY agrupamento_gestao_painel_odometro (agrupamento_gestao_painel_odometro),
	KEY agrupamento_gestao_painel_composicao (agrupamento_gestao_painel_composicao),
	KEY agrupamento_gestao_tr (agrupamento_gestao_tr),
	KEY agrupamento_gestao_me (agrupamento_gestao_me),
	KEY agrupamento_gestao_acao_item (agrupamento_gestao_acao_item),
	KEY agrupamento_gestao_beneficio (agrupamento_gestao_beneficio),
	KEY agrupamento_gestao_painel_slideshow (agrupamento_gestao_painel_slideshow),
	KEY agrupamento_gestao_projeto_viabilidade (agrupamento_gestao_projeto_viabilidade),
	KEY agrupamento_gestao_projeto_abertura (agrupamento_gestao_projeto_abertura),
	KEY agrupamento_gestao_plano_gestao (agrupamento_gestao_plano_gestao),
	KEY agrupamento_gestao_ssti (agrupamento_gestao_ssti),
	KEY agrupamento_gestao_laudo (agrupamento_gestao_laudo),
	KEY agrupamento_gestao_trelo (agrupamento_gestao_trelo),
	KEY agrupamento_gestao_trelo_cartao (agrupamento_gestao_trelo_cartao),
	KEY agrupamento_gestao_pdcl (agrupamento_gestao_pdcl),
	KEY agrupamento_gestao_pdcl_item (agrupamento_gestao_pdcl_item),
	KEY agrupamento_gestao_os (agrupamento_gestao_os),
	CONSTRAINT agrupamento_gestao_agrupamento FOREIGN KEY (agrupamento_gestao_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_semelhante FOREIGN KEY (agrupamento_gestao_semelhante) REFERENCES agrupamento (agrupamento_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_projeto FOREIGN KEY (agrupamento_gestao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_tarefa FOREIGN KEY (agrupamento_gestao_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_perspectiva FOREIGN KEY (agrupamento_gestao_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_tema FOREIGN KEY (agrupamento_gestao_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_objetivo FOREIGN KEY (agrupamento_gestao_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_fator FOREIGN KEY (agrupamento_gestao_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_estrategia FOREIGN KEY (agrupamento_gestao_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_meta FOREIGN KEY (agrupamento_gestao_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_pratica FOREIGN KEY (agrupamento_gestao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_indicador FOREIGN KEY (agrupamento_gestao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_acao FOREIGN KEY (agrupamento_gestao_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_canvas FOREIGN KEY (agrupamento_gestao_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_risco FOREIGN KEY (agrupamento_gestao_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_risco_resposta FOREIGN KEY (agrupamento_gestao_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_calendario FOREIGN KEY (agrupamento_gestao_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_monitoramento FOREIGN KEY (agrupamento_gestao_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_ata FOREIGN KEY (agrupamento_gestao_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_mswot FOREIGN KEY (agrupamento_gestao_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_swot FOREIGN KEY (agrupamento_gestao_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_operativo FOREIGN KEY (agrupamento_gestao_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_instrumento FOREIGN KEY (agrupamento_gestao_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_recurso FOREIGN KEY (agrupamento_gestao_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_problema FOREIGN KEY (agrupamento_gestao_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_demanda FOREIGN KEY (agrupamento_gestao_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_programa FOREIGN KEY (agrupamento_gestao_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_licao FOREIGN KEY (agrupamento_gestao_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_evento FOREIGN KEY (agrupamento_gestao_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_link FOREIGN KEY (agrupamento_gestao_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_avaliacao FOREIGN KEY (agrupamento_gestao_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_tgn FOREIGN KEY (agrupamento_gestao_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_brainstorm FOREIGN KEY (agrupamento_gestao_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_gut FOREIGN KEY (agrupamento_gestao_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_causa_efeito FOREIGN KEY (agrupamento_gestao_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_arquivo FOREIGN KEY (agrupamento_gestao_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_forum FOREIGN KEY (agrupamento_gestao_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_checklist FOREIGN KEY (agrupamento_gestao_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_agenda FOREIGN KEY (agrupamento_gestao_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_patrocinador FOREIGN KEY (agrupamento_gestao_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_template FOREIGN KEY (agrupamento_gestao_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_painel FOREIGN KEY (agrupamento_gestao_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_painel_odometro FOREIGN KEY (agrupamento_gestao_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_painel_composicao FOREIGN KEY (agrupamento_gestao_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_tr FOREIGN KEY (agrupamento_gestao_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_me FOREIGN KEY (agrupamento_gestao_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_acao_item FOREIGN KEY (agrupamento_gestao_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_beneficio FOREIGN KEY (agrupamento_gestao_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_painel_slideshow FOREIGN KEY (agrupamento_gestao_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_projeto_viabilidade FOREIGN KEY (agrupamento_gestao_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_projeto_abertura FOREIGN KEY (agrupamento_gestao_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_plano_gestao FOREIGN KEY (agrupamento_gestao_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT agrupamento_gestao_ssti FOREIGN KEY (agrupamento_gestao_ssti) REFERENCES ssti (ssti_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT agrupamento_gestao_laudo FOREIGN KEY (agrupamento_gestao_laudo) REFERENCES laudo (laudo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT agrupamento_gestao_trelo FOREIGN KEY (agrupamento_gestao_trelo) REFERENCES trelo (trelo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT agrupamento_gestao_trelo_cartao FOREIGN KEY (agrupamento_gestao_trelo_cartao) REFERENCES trelo_cartao (trelo_cartao_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT agrupamento_gestao_pdcl FOREIGN KEY (agrupamento_gestao_pdcl) REFERENCES pdcl (pdcl_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT agrupamento_gestao_pdcl_item FOREIGN KEY (agrupamento_gestao_pdcl_item) REFERENCES pdcl_item (pdcl_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT agrupamento_gestao_os FOREIGN KEY (agrupamento_gestao_os) REFERENCES os (os_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;

DROP TABLE IF EXISTS problema_gestao;

CREATE TABLE problema_gestao (
	problema_gestao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	problema_gestao_problema INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_demanda INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_programa INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_licao INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_evento INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_link INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_avaliacao INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_tgn INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_brainstorm INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_gut INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_causa_efeito INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_arquivo INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_forum INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_checklist INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_agenda INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_agrupamento INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_patrocinador INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_template INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_painel INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_painel_odometro INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_painel_composicao INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_tr INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_me INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_acao_item INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_beneficio INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_painel_slideshow INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_projeto_viabilidade INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_projeto_abertura INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_plano_gestao INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_ssti INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_laudo INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_trelo INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_trelo_cartao INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_pdcl INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_pdcl_item INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_os INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_ordem INTEGER(100) UNSIGNED DEFAULT NULL,
	problema_gestao_uuid VARCHAR(36) DEFAULT NULL,
	PRIMARY KEY problema_gestao_id (problema_gestao_id),
	KEY problema_gestao_problema (problema_gestao_problema),
	KEY problema_gestao_semelhante (problema_gestao_semelhante),
	KEY problema_gestao_projeto (problema_gestao_projeto),
	KEY problema_gestao_tarefa (problema_gestao_tarefa),
	KEY problema_gestao_perspectiva (problema_gestao_perspectiva),
	KEY problema_gestao_tema (problema_gestao_tema),
	KEY problema_gestao_objetivo (problema_gestao_objetivo),
	KEY problema_gestao_estrategia (problema_gestao_estrategia),
	KEY problema_gestao_meta (problema_gestao_meta),
	KEY problema_gestao_fator (problema_gestao_fator),
	KEY problema_gestao_pratica (problema_gestao_pratica),
	KEY problema_gestao_indicador (problema_gestao_indicador),
	KEY problema_gestao_acao (problema_gestao_acao),
	KEY problema_gestao_canvas (problema_gestao_canvas),
	KEY problema_gestao_risco (problema_gestao_risco),
	KEY problema_gestao_risco_resposta (problema_gestao_risco_resposta),
	KEY problema_gestao_calendario (problema_gestao_calendario),
	KEY problema_gestao_monitoramento (problema_gestao_monitoramento),
	KEY problema_gestao_ata (problema_gestao_ata),
	KEY problema_gestao_instrumento (problema_gestao_instrumento),
	KEY problema_gestao_recurso (problema_gestao_recurso),
	KEY problema_gestao_demanda (problema_gestao_demanda),
	KEY problema_gestao_programa (problema_gestao_programa),
	KEY problema_gestao_licao (problema_gestao_licao),
	KEY problema_gestao_evento (problema_gestao_evento),
	KEY problema_gestao_link (problema_gestao_link),
	KEY problema_gestao_avaliacao (problema_gestao_avaliacao),
	KEY problema_gestao_tgn (problema_gestao_tgn),
	KEY problema_gestao_brainstorm (problema_gestao_brainstorm),
	KEY problema_gestao_gut (problema_gestao_gut),
	KEY problema_gestao_causa_efeito (problema_gestao_causa_efeito),
	KEY problema_gestao_arquivo (problema_gestao_arquivo),
	KEY problema_gestao_forum (problema_gestao_forum),
	KEY problema_gestao_checklist (problema_gestao_checklist),
	KEY problema_gestao_agenda (problema_gestao_agenda),
	KEY problema_gestao_operativo (problema_gestao_operativo),
	KEY problema_gestao_agrupamento (problema_gestao_agrupamento),
	KEY problema_gestao_patrocinador (problema_gestao_patrocinador),
	KEY problema_gestao_mswot (problema_gestao_mswot),
	KEY problema_gestao_swot (problema_gestao_swot),
	KEY problema_gestao_template (problema_gestao_template),
	KEY problema_gestao_painel (problema_gestao_painel),
	KEY problema_gestao_painel_odometro (problema_gestao_painel_odometro),
	KEY problema_gestao_painel_composicao (problema_gestao_painel_composicao),
	KEY problema_gestao_tr (problema_gestao_tr),
	KEY problema_gestao_me (problema_gestao_me),
	KEY problema_gestao_acao_item (problema_gestao_acao_item),
	KEY problema_gestao_beneficio (problema_gestao_beneficio),
	KEY problema_gestao_painel_slideshow (problema_gestao_painel_slideshow),
	KEY problema_gestao_projeto_viabilidade (problema_gestao_projeto_viabilidade),
	KEY problema_gestao_projeto_abertura (problema_gestao_projeto_abertura),
	KEY problema_gestao_plano_gestao (problema_gestao_plano_gestao),
	KEY problema_gestao_ssti (problema_gestao_ssti),
	KEY problema_gestao_laudo (problema_gestao_laudo),
	KEY problema_gestao_trelo (problema_gestao_trelo),
	KEY problema_gestao_trelo_cartao (problema_gestao_trelo_cartao),
	KEY problema_gestao_pdcl (problema_gestao_pdcl),
	KEY problema_gestao_pdcl_item (problema_gestao_pdcl_item),
	KEY problema_gestao_os (problema_gestao_os),
	CONSTRAINT problema_gestao_problema FOREIGN KEY (problema_gestao_problema) REFERENCES problema (problema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_semelhante FOREIGN KEY (problema_gestao_semelhante) REFERENCES problema (problema_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_projeto FOREIGN KEY (problema_gestao_projeto) REFERENCES projetos (projeto_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_tarefa FOREIGN KEY (problema_gestao_tarefa) REFERENCES tarefas (tarefa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_perspectiva FOREIGN KEY (problema_gestao_perspectiva) REFERENCES perspectivas (pg_perspectiva_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_tema FOREIGN KEY (problema_gestao_tema) REFERENCES tema (tema_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_objetivo FOREIGN KEY (problema_gestao_objetivo) REFERENCES objetivo (objetivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_fator FOREIGN KEY (problema_gestao_fator) REFERENCES fator (fator_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_estrategia FOREIGN KEY (problema_gestao_estrategia) REFERENCES estrategias (pg_estrategia_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_meta FOREIGN KEY (problema_gestao_meta) REFERENCES metas (pg_meta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_pratica FOREIGN KEY (problema_gestao_pratica) REFERENCES praticas (pratica_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_indicador FOREIGN KEY (problema_gestao_indicador) REFERENCES pratica_indicador (pratica_indicador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_acao FOREIGN KEY (problema_gestao_acao) REFERENCES plano_acao (plano_acao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_canvas FOREIGN KEY (problema_gestao_canvas) REFERENCES canvas (canvas_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_risco FOREIGN KEY (problema_gestao_risco) REFERENCES risco (risco_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_risco_resposta FOREIGN KEY (problema_gestao_risco_resposta) REFERENCES risco_resposta (risco_resposta_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_calendario FOREIGN KEY (problema_gestao_calendario) REFERENCES calendario (calendario_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_monitoramento FOREIGN KEY (problema_gestao_monitoramento) REFERENCES monitoramento (monitoramento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_ata FOREIGN KEY (problema_gestao_ata) REFERENCES ata (ata_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_instrumento FOREIGN KEY (problema_gestao_instrumento) REFERENCES instrumento (instrumento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_recurso FOREIGN KEY (problema_gestao_recurso) REFERENCES recursos (recurso_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_demanda FOREIGN KEY (problema_gestao_demanda) REFERENCES demandas (demanda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_programa FOREIGN KEY (problema_gestao_programa) REFERENCES programa (programa_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_licao FOREIGN KEY (problema_gestao_licao) REFERENCES licao (licao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_evento FOREIGN KEY (problema_gestao_evento) REFERENCES eventos (evento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_link FOREIGN KEY (problema_gestao_link) REFERENCES links (link_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_avaliacao FOREIGN KEY (problema_gestao_avaliacao) REFERENCES avaliacao (avaliacao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_tgn FOREIGN KEY (problema_gestao_tgn) REFERENCES tgn (tgn_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_brainstorm FOREIGN KEY (problema_gestao_brainstorm) REFERENCES brainstorm (brainstorm_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_gut FOREIGN KEY (problema_gestao_gut) REFERENCES gut (gut_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_causa_efeito FOREIGN KEY (problema_gestao_causa_efeito) REFERENCES causa_efeito (causa_efeito_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_arquivo FOREIGN KEY (problema_gestao_arquivo) REFERENCES arquivo (arquivo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_forum FOREIGN KEY (problema_gestao_forum) REFERENCES foruns (forum_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_checklist FOREIGN KEY (problema_gestao_checklist) REFERENCES checklist (checklist_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_agenda FOREIGN KEY (problema_gestao_agenda) REFERENCES agenda (agenda_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_operativo FOREIGN KEY (problema_gestao_operativo) REFERENCES operativo (operativo_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_agrupamento FOREIGN KEY (problema_gestao_agrupamento) REFERENCES agrupamento (agrupamento_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_patrocinador FOREIGN KEY (problema_gestao_patrocinador) REFERENCES patrocinadores (patrocinador_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_mswot FOREIGN KEY (problema_gestao_mswot) REFERENCES mswot (mswot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_swot FOREIGN KEY (problema_gestao_swot) REFERENCES swot (swot_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_template FOREIGN KEY (problema_gestao_template) REFERENCES template (template_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_painel FOREIGN KEY (problema_gestao_painel) REFERENCES painel (painel_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_painel_odometro FOREIGN KEY (problema_gestao_painel_odometro) REFERENCES painel_odometro (painel_odometro_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_painel_composicao FOREIGN KEY (problema_gestao_painel_composicao) REFERENCES painel_composicao (painel_composicao_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_tr FOREIGN KEY (problema_gestao_tr) REFERENCES tr (tr_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_me FOREIGN KEY (problema_gestao_me) REFERENCES me (me_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_acao_item FOREIGN KEY (problema_gestao_acao_item) REFERENCES plano_acao_item (plano_acao_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_beneficio FOREIGN KEY (problema_gestao_beneficio) REFERENCES beneficio (beneficio_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_painel_slideshow FOREIGN KEY (problema_gestao_painel_slideshow) REFERENCES painel_slideshow (painel_slideshow_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_projeto_viabilidade FOREIGN KEY (problema_gestao_projeto_viabilidade) REFERENCES projeto_viabilidade (projeto_viabilidade_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_projeto_abertura FOREIGN KEY (problema_gestao_projeto_abertura) REFERENCES projeto_abertura (projeto_abertura_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_plano_gestao FOREIGN KEY (problema_gestao_plano_gestao) REFERENCES plano_gestao (pg_id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT problema_gestao_ssti FOREIGN KEY (problema_gestao_ssti) REFERENCES ssti (ssti_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT problema_gestao_laudo FOREIGN KEY (problema_gestao_laudo) REFERENCES laudo (laudo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT problema_gestao_trelo FOREIGN KEY (problema_gestao_trelo) REFERENCES trelo (trelo_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT problema_gestao_trelo_cartao FOREIGN KEY (problema_gestao_trelo_cartao) REFERENCES trelo_cartao (trelo_cartao_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT problema_gestao_pdcl FOREIGN KEY (problema_gestao_pdcl) REFERENCES pdcl (pdcl_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT problema_gestao_pdcl_item FOREIGN KEY (problema_gestao_pdcl_item) REFERENCES pdcl_item (pdcl_item_id) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT problema_gestao_os FOREIGN KEY (problema_gestao_os) REFERENCES os (os_id) ON DELETE CASCADE ON UPDATE CASCADE
)ENGINE=InnoDB CHARACTER SET latin1 COLLATE latin1_swedish_ci;


DROP TABLE IF EXISTS msg_gestao;

CREATE TABLE msg_gestao (
	msg_gestao_id INTEGER(100) UNSIGNED NOT NULL AUTO_INCREMENT,
	msg_gestao_msg INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_semelhante INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_projeto INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_tarefa INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_perspectiva INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_tema INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_objetivo INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_fator INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_estrategia INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_meta INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_pratica INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_indicador INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_acao INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_canvas INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_risco INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_risco_resposta INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_calendario INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_monitoramento INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_ata INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_mswot INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_swot INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_operativo INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_instrumento INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_recurso INTEGER(100) UNSIGNED DEFAULT NULL,
	msg_gestao_problema INTEGER(