<?php 
/* Copyright [2011] -  Srgio Fernandes Reinert de Lima - INPI 11802-5
Este arquivo  parte do programa gpweb
O gpweb  um software livre; voc pode redistribu-lo e/ou modific-lo dentro dos termos da Licena Pblica Geral GNU como publicada pela Fundao do Software Livre (FSF); na verso 2 da Licena.
Este programa  distribudo na esperana que possa ser  til, mas SEM NENHUMA GARANTIA; sem uma garantia implcita de ADEQUAO a qualquer  MERCADO ou APLICAO EM PARTICULAR. Veja a Licena Pblica Geral GNU/GPL em portugus para maiores detalhes.
Voc deve ter recebido uma cpia da Licena Pblica Geral GNU, sob o ttulo "licena GPL 2.odt", junto com este programa, se no, acesse o Portal do Software Pblico Brasileiro no endereo www.softwarepublico.gov.br ou escreva para a Fundao do Software Livre(FSF) Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301, USA 
*/
require BASE_DIR.'/incluir/validar_autorizado.php';
if (!defined('BASE_DIR')) die('Voc no deveria acessar este arquivo diretamente.');

function getDespachoLinks($inicioPeriodo, $fimPeriodo, $links) {
	global $evento_filtro,$Aplic, $config;
	$despachos = CAgenda::getDespachoParaPeriodo($inicioPeriodo, $fimPeriodo);
	
	
	foreach ($despachos as $linha) {
		$inicio = new CData($linha['data_limite']);
		$fim = new CData($linha['data_limite']);
		$data = $inicio;
		$sql = new BDConsulta;
		$sql->adTabela('msg_usuario');
		$sql->adCampo(($config['militar'] < 10 ? 'concatenar_tres(contato_posto, \' \', contato_nomeguerra)' : 'contato_nomeguerra').' AS despacho_dono');
		$sql->esqUnir('usuarios', 'usuarios', 'usuarios.usuario_id = msg_usuario.de_id');
		$sql->esqUnir('contatos', 'contatos', 'usuarios.usuario_contato = contatos.contato_id');
		$sql->adOnde('msg_usuario.msg_usuario_id = '.$linha['msg_usuario_id']);
		$nome = $sql->Resultado();
		$sql->limpar();
		$cwd = explode(',', $GLOBALS['config']['cal_dias_uteis']);
		for ($i = 0, $i_cmp = $inicio->dataDiferenca($fim); $i <= $i_cmp; $i++) {
			$texto='<tr><td colspan=2>'.imagem('icones/msg10010.gif').' Despacho de '.$nome.'</td></tr>';
			$link['texto'] = '<tr><td colspan=2>'.link_despacho($linha['msg_usuario_id']).'</td></tr>';
			$link['texto_mini'] =$texto;
			$links[$data->format('%Y%m%d')][] = $link;
			$data = $data->getNextDay();
			}
		}
	return $links;
	}


function getMsg_TarefaLinks($inicioPeriodo, $fimPeriodo, $links) {
	global $evento_filtro,$Aplic, $config;
	$tarefas = CAgenda::getMsg_TarefaParaPeriodo($inicioPeriodo, $fimPeriodo);
	
	
	foreach ($tarefas as $linha) {
		$inicio = new CData($linha['tarefa_data']);
		$fim = new CData($linha['tarefa_data']);
		$data = $inicio;
		$sql = new BDConsulta;
		$sql->adTabela('msg_usuario');
		$sql->adCampo(($config['militar'] < 10 ? 'concatenar_tres(contato_posto, \' \', contato_nomeguerra)' : 'contato_nomeguerra').' AS despacho_dono');
		$sql->esqUnir('usuarios', 'usuarios', 'usuarios.usuario_id = msg_usuario.de_id');
		$sql->esqUnir('contatos', 'contatos', 'usuarios.usuario_contato = contatos.contato_id');
		$sql->adOnde('msg_usuario.msg_usuario_id = '.$linha['msg_usuario_id']);
		$nome = $sql->Resultado();
		$sql->limpar();
		$cwd = explode(',', $GLOBALS['config']['cal_dias_uteis']);
		for ($i = 0, $i_cmp = $inicio->dataDiferenca($fim); $i <= $i_cmp; $i++) {
			$texto='<tr><td colspan=2>'.imagem('icones/task_p.png').' Msg do tipo atividade de '.$nome.'</td></tr>';
			$link['texto'] = '<tr><td colspan=2>'.link_msg_tarefa($linha['msg_usuario_id']).'</td></tr>';
			$link['texto_mini'] =$texto;
			$links[$data->format('%Y%m%d')][] = $link;
			$data = $data->getNextDay();
			}
		}
	return $links;
	}


function getDespachoModeloLinks($inicioPeriodo, $fimPeriodo, $links) {
	global $evento_filtro,$Aplic, $config;
	$despachos = CAgenda::getDespachoModeloParaPeriodo($inicioPeriodo, $fimPeriodo);
	
	
	foreach ($despachos as $linha) {
		$inicio = new CData($linha['data_limite']);
		$fim = new CData($linha['data_limite']);
		$data = $inicio;
		$sql = new BDConsulta;
		$sql->adTabela('modelo_usuario');
		$sql->adCampo(($config['militar'] < 10 ? 'concatenar_tres(contato_posto, \' \', contato_nomeguerra)' : 'contato_nomeguerra').' AS despacho_dono');
		$sql->esqUnir('usuarios', 'usuarios', 'usuarios.usuario_id = modelo_usuario.de_id');
		$sql->esqUnir('contatos', 'contatos', 'usuarios.usuario_contato = contatos.contato_id');
		$sql->adOnde('modelo_usuario.modelo_usuario_id = '.$linha['modelo_usuario_id']);
		$nome = $sql->Resultado();
		$sql->limpar();
		$cwd = explode(',', $GLOBALS['config']['cal_dias_uteis']);
		for ($i = 0, $i_cmp = $inicio->dataDiferenca($fim); $i <= $i_cmp; $i++) {
			$texto='<tr><td colspan=2>'.imagem('icones/msg10010.gif').' Despacho de '.$nome.'</td></tr>';
			$link['texto'] = '<tr><td colspan=2>'.link_modelodespacho($linha['modelo_usuario_id']).'</td></tr>';
			$link['texto_mini'] =$texto;
			$links[$data->format('%Y%m%d')][] = $link;
			$data = $data->getNextDay();
			}
		}
	return $links;
	}

?>