<?php 
/*
Copyright [2011] -  Srgio Fernandes Reinert de Lima - INPI 11802-5
Este arquivo  parte do programa GP-Web
O GP-Web  um software livre; voc pode redistribu-lo e/ou modific-lo dentro dos termos da Licena Pblica Geral GNU como publicada pela Fundao do Software Livre (FSF); na verso 2 da Licena.
Este programa  distribudo na esperana que possa ser  til, mas SEM NENHUMA GARANTIA; sem uma garantia implcita de ADEQUAO a qualquer  MERCADO ou APLICAO EM PARTICULAR. Veja a Licena Pblica Geral GNU/GPL em portugus para maiores detalhes.
Voc deve ter recebido uma cpia da Licena Pblica Geral GNU, sob o ttulo "licena GPL 2.odt", junto com este programa, se no, acesse o Portal do Software Pblico Brasileiro no endereo www.softwarepublico.gov.br ou escreva para a Fundao do Software Livre(FSF) Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301, USA 
*/


if (!defined('BASE_DIR')) die('Voc no deveria acessar este arquivo diretamente.');
require_once (BASE_DIR.'/modulos/projetos/embasamento.class.php');
$projeto_id = intval(getParam($_REQUEST, 'projeto_id', 0));

$objProjeto = new CProjeto();
$objProjeto->load($projeto_id);
$podeAcessar=permiteAcessar($objProjeto->projeto_acesso,$objProjeto->projeto_id);

if (!$projeto_id) {
	$Aplic->setMsg('No foi passado um ID de '.$config['projeto'].' ao tentar ver o embasamento.', UI_MSG_ERRO);
	$Aplic->redirecionar('m=projetos&a=index'); 
	exit();
	}

if (!($podeEditar && permiteAcessar($objProjeto->projeto_acesso,$objProjeto->projeto_id))) {
	$Aplic->redirecionar('m=publico&a=acesso_negado'); 
	exit();
	}


$obj = new CEmbasamento();
$obj->load($projeto_id);
$sql = new BDConsulta();

$podeEditar=permiteEditar($objProjeto->projeto_acesso,$objProjeto->projeto_id);


if (!$dialogo) $Aplic->salvarPosicao();


$msg = '';
$botoesTitulo = new CBlocoTitulo('Embasamento d'.$config['genero_projeto'].' '.ucfirst($config['projeto']), 'anexo_projeto.png', $m, $m.'.'.$a);



if ($podeEditar) {
	$botoesTitulo->adicionaBotao('m=projetos&a=embasamento_editar&projeto_id='.$projeto_id, ($obj->projeto_embasamento_responsavel ? 'editar' : 'inserir'),'',($obj->projeto_embasamento_responsavel ? 'Editar' : 'Inserir').' Embasamento',($obj->projeto_embasamento_responsavel ? 'Editar' : 'Inserir').' os detalhes do embasamento.');
	if (!$obj->projeto_embasamento_responsavel) $botoesTitulo->adicionaBotaoExcluir('excluir', $podeExcluir, $msg,'Excluir','Excluir este embasamento.');
	}
	
$botoesTitulo->adicionaBotao('m=projetos&a=ver&projeto_id='.$projeto_id, $config['projeto'],'',ucfirst($config['projeto']),'Ver os detalhes deste '.$config['projeto'].'.');	
$botoesTitulo->adicionaCelula(dica('Imprimir o Embasamento', 'Clique neste cone '.imagem('imprimir_p.png').' para imprimir o embasamento.').'<a href="javascript: void(0);" onclick ="window.open(\'index.php?m=projetos&a=embasamento_imprimir&dialogo=1&projeto_id='.$projeto_id.'\', \'imprimir\',\'width=800, height=800, menubar=1, scrollbars=1\')">'.imagem('imprimir_p.png').'</a>'.dicaF());
$botoesTitulo->mostrar();



echo '<form name="env" method="post">';
echo '<input type="hidden" name="m" value="'.$m.'" />';
echo '<input type="hidden" name="a" value="'.$a.'" />';
echo '<input type="hidden" name="projeto_embasamento_projeto" value="'.$projeto_id.'" />';
echo '<input type="hidden" name="excluir" value="" />';
echo '<input type="hidden" name="aprovar" value="" />';
echo '<input type="hidden" name="fazerSQL" value="" />';
echo '<input type="hidden" name="dialogo" value="" />';
echo '</form>';

echo estiloTopoCaixa();
echo '<table id="tblObjetivos" cellpadding=0 cellspacing=1 width="100%" class="std">';
if ($obj->projeto_embasamento_justificativa) echo '<tr><td align="right">'.dica('Justificativa', 'Descrever de forma clara a justificativa contendo um breve histrico e as motivaes do projeto. .').'Justificativa:'.dicaF().'</td><td class="realce" width="100%" style="margin-bottom:0cm; margin-top:0cm;">'.$obj->projeto_embasamento_justificativa.'</td></tr>';
if ($obj->projeto_embasamento_objetivo) echo '<tr><td align="right">'.dica('Objetivo', 'Descrever qual o objetivo para a qual rgo est realizando o projeto, que pode ser: descrio concreta de que o projeto quer alcanar, uma posio estratgica a ser alcanada, um resultado a ser obtido, um produto a ser produzido ou um servio a ser realizado. Os objetivos devem ser especficos, mensurveis, realizveis, realsticos, e baseados no tempo.>.').'Objetivo:'.dicaF().'</td><td class="realce" width="100%" style="margin-bottom:0cm; margin-top:0cm;">'.$obj->projeto_embasamento_objetivo.'</td></tr>';
if ($obj->projeto_embasamento_escopo) echo '<tr><td align="right" style="white-space: nowrap">'.dica('Declarao de Escopo', 'Descrever a declarao do escopo, que inclui as principais entregas, fornece uma base documentada para futuras decises do projeto e para confirmar ou desenvolver um entendimento comum do escopo do projeto entre as partes interessadas.').'Declarao de Escopo:'.dicaF().'</td><td class="realce" width="100%" style="margin-bottom:0cm; margin-top:0cm;">'.$obj->projeto_embasamento_escopo.'</td></tr>';
if ($obj->projeto_embasamento_nao_escopo) echo '<tr><td align="right">'.dica('No escopo', 'Descrever de forma explcita o que est excludo do projeto, para evitar que uma parte interessada possa supor que um produto, servio ou resultado especfico  um produto do projeto.').'No escopo:'.dicaF().'</td><td class="realce" width="100%" style="margin-bottom:0cm; margin-top:0cm;">'.$obj->projeto_embasamento_nao_escopo.'</td></tr>';
if ($obj->projeto_embasamento_premissas) echo '<tr><td align="right">'.dica('Premissas', 'Descrever as premissas do projeto. As premissas so fatores que, para fins de planejamento, so considerados verdadeiros, reais ou certos sem prova ou demonstrao. As premissas afetam todos os aspectos do planejamento do projeto e fazem parte da elaborao progressiva do projeto. Frequentemente, as equipes do projeto identificam, documentam e validam as premissas durante o processo de planejamento. Geralmente, as premissas envolvem um grau de risco.').'Premissas:'.dicaF().'</td><td class="realce" width="100%" style="margin-bottom:0cm; margin-top:0cm;">'.$obj->projeto_embasamento_premissas.'</td></tr>';
if ($obj->projeto_embasamento_restricoes) echo '<tr><td align="right">'.dica('Restries', 'Descrever as restries do projeto. Uma restrio  uma limitao aplicvel, interna ou externa ao projeto, que afetar o desempenho do projeto ou de um processo. Por exemplo, uma restrio do cronograma  qualquer limitao ou condio colocada em relao ao cronograma do projeto que afeta o momento em que uma atividade do cronograma pode ser agendada e geralmente est na forma de datas impostas fixas.').'Restries:'.dicaF().'</td><td class="realce" width="100%" style="margin-bottom:0cm; margin-top:0cm;">'.$obj->projeto_embasamento_restricoes.'</td></tr>';
if ($obj->projeto_embasamento_orcamento) echo '<tr><td align="right">'.dica('Custos Estimado e Fonte de Recurso', 'Descrever a estimativa de custo do projeto e a fonte de recurso.').'Custos estimado e fonte de recurso:'.dicaF().'</td><td class="realce" width="100%" style="margin-bottom:0cm; margin-top:0cm;">'.$obj->projeto_embasamento_orcamento.'</td></tr>';

require_once ($Aplic->getClasseSistema('CampoCustomizados'));
$campos_customizados = new CampoCustomizados('projeto_embasamento', $obj->projeto_embasamento_projeto, 'ver');
if ($campos_customizados->count()) {
		echo '<tr><td colspan="2">';
		$campos_customizados->imprimirHTML();
		echo '</td></tr>';
		}		
				
if ($obj->projeto_embasamento_data) echo '<tr><td align="right" style="white-space: nowrap">'.dica('Data', 'A data em que o embasamento foi criado ou editado').'Data:'.dicaF().'</td><td class="realce" width="100%" style="margin-bottom:0cm; margin-top:0cm;">'.retorna_data($obj->projeto_embasamento_data).'</td></tr>';

if (!$obj->projeto_embasamento_responsavel) echo '<tr><td colspan=20 class="realce">Ainda no h dados cadastrados</td></tr>';

		
echo '</table></td></tr></table>';
echo estiloFundoCaixa();

?>
<script type="text/javascript">
	
function excluir() {
	if (confirm('Tem certeza que deseja excluir este embasamento?')) {
		var f = document.env;
		f.excluir.value=1;
		f.fazerSQL.value='fazer_sql_embasamento';
		f.a.value='vazio';
		f.dialogo.value=1;
		f.submit();
		}
	}
</script>