<?php
/* Copyright [2011] -  Srgio Fernandes Reinert de Lima - INPI 11802-5
Este arquivo  parte do programa gpweb
O gpweb  um software livre; voc pode redistribu-lo e/ou modific-lo dentro dos termos da Licena Pblica Geral GNU como publicada pela Fundao do Software Livre (FSF); na verso 2 da Licena.
Este programa  distribudo na esperana que possa ser  til, mas SEM NENHUMA GARANTIA; sem uma garantia implcita de ADEQUAO a qualquer  MERCADO ou APLICAO EM PARTICULAR. Veja a Licena Pblica Geral GNU/GPL em portugus para maiores detalhes.
Voc deve ter recebido uma cpia da Licena Pblica Geral GNU, sob o ttulo "licena GPL 2.odt", junto com este programa, se no, acesse o Portal do Software Pblico Brasileiro no endereo www.softwarepublico.gov.br ou escreva para a Fundao do Software Livre(FSF) Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301, USA 
*/
require BASE_DIR.'/incluir/validar_autorizado.php';
if (!defined('BASE_DIR')) die('Voc no deveria acessar este arquivo diretamente.');



class CMudanca extends CAplicObjeto {
	public $projeto_mudanca_id = null;
  public $projeto_mudanca_projeto = null;
  public $projeto_mudanca_tarefa = null;
  public $projeto_mudanca_responsavel = null;
  public $projeto_mudanca_cliente = null;
  public $projeto_mudanca_autoridade = null;
  public $projeto_mudanca_numero = null;
  public $projeto_mudanca_justificativa = null;
  public $projeto_mudanca_parecer_tecnico = null;
  public $projeto_mudanca_solucoes = null;
  public $projeto_mudanca_impacto_cronograma = null;
  public $projeto_mudanca_impacto_custo = null;
  public $projeto_mudanca_novo_risco = null;
  public $projeto_mudanca_outros_impactos = null;
  public $projeto_mudanca_solucao = null;
  public $projeto_mudanca_parecer = null;
  public $projeto_mudanca_requisitante_aprovada = null;
  public $projeto_mudanca_requisitante_reprovada  = null;
  public $projeto_mudanca_administracao_aprovada = null;
  public $projeto_mudanca_administracao_reprovada = null;
  public $projeto_mudanca_data = null;
  public $projeto_mudanca_data_aprovacao = null;
  public $projeto_mudanca_cor  = null;
  public $projeto_mudanca_acesso  = null;

	public function __construct() {
		parent::__construct('projeto_mudanca', 'projeto_mudanca_id');
		}

	public function excluir( $oid = NULL) {
		global $Aplic;
		if ($Aplic->getEstado('projeto_mudanca_id', null)==$this->projeto_mudanca_id) $Aplic->setEstado('projeto_mudanca_id', null);
		parent::excluir();
		return null;
		}


	public function armazenar( $atualizarNulos = false) {
		global $Aplic, $_REQUEST;
		$sql = new BDConsulta();
		if ($_REQUEST['projeto_mudanca_id']) {
			$ret = $sql->atualizarObjeto('projeto_mudanca', $this, 'projeto_mudanca_id');
			$sql->limpar();
			}
		else {
			$ret = $sql->inserirObjeto('projeto_mudanca', $this, 'projeto_mudanca_id');
			$sql->limpar();
			}
		require_once ($Aplic->getClasseSistema('CampoCustomizados'));
		$campos_customizados = new CampoCustomizados('projeto_mudanca', $this->projeto_mudanca_id, 'editar');
		$campos_customizados->join($_REQUEST);
		$campos_customizados->armazenar($this->projeto_mudanca_id);



		$projeto_mudanca_usuarios=getParam($_REQUEST, 'projeto_mudanca_usuarios', null);
		$projeto_mudanca_usuarios=explode(',', $projeto_mudanca_usuarios);
		$sql->setExcluir('projeto_mudanca_usuarios');
		$sql->adOnde('projeto_mudanca_id = '.$this->projeto_mudanca_id);
		$sql->exec();
		$sql->limpar();
		foreach($projeto_mudanca_usuarios as $chave => $usuario_id){
			if($usuario_id){
				$sql->adTabela('projeto_mudanca_usuarios');
				$sql->adInserir('projeto_mudanca_id', $this->projeto_mudanca_id);
				$sql->adInserir('usuario_id', $usuario_id);
				$sql->exec();
				$sql->limpar();
				}
			}



		if (!$ret) return get_class($this).'::armazenar falhou '.db_error();
		else return null;
		}


	public function check() {
		return null;
		}



	public function notificar( $post=array()){
		global $Aplic, $config, $localidade_tipo_caract;
		require_once ($Aplic->getClasseSistema('libmail'));
		$sql = new BDConsulta;

		$sql->adTabela('projetos');
		$sql->adCampo('projeto_nome');
		$sql->adOnde('projeto_id ='.$this->projeto_mudanca_projeto);
		$projeto_nome = $sql->Resultado();
		$sql->limpar();



		$usuarios =array();
		$usuarios1=array();
		$usuarios2=array();
		$usuarios3=array();
		$usuarios4=array();

		if (isset($post['projeto_mudanca_usuarios']) && $post['projeto_mudanca_usuarios'] && isset($post['email_designados']) && $post['email_designados']){
			$sql->adTabela('usuarios');
			$sql->esqUnir('contatos', 'contatos', 'contato_id = usuario_contato');
			$sql->adCampo('DISTINCT usuarios.usuario_id, '.($config['militar'] < 10 ? 'concatenar_tres(contato_posto, \' \', contato_nomeguerra)' : 'contato_nomeguerra').' AS nome_usuario, contato_email');
			$sql->adOnde('usuario_id IN ('.$post['projeto_mudanca_usuarios'].')');
			$usuarios1 = $sql->Lista();
			$sql->limpar();
			}
		if (isset($post['email_outro']) && $post['email_outro']){
			$sql->adTabela('usuarios');
			$sql->esqUnir('contatos', 'contatos', 'contato_id = usuario_contato');
			$sql->adCampo('DISTINCT usuarios.usuario_id, '.($config['militar'] < 10 ? 'concatenar_tres(contato_posto, \' \', contato_nomeguerra)' : 'contato_nomeguerra').' AS nome_usuario, contato_email');
			$sql->adOnde('contato_id IN ('.$post['email_outro'].')');
			$usuarios2=$sql->Lista();
			$sql->limpar();
			}

		if (isset($post['email_responsavel']) && $post['email_responsavel']){
			$sql->adTabela('usuarios');
			$sql->esqUnir('contatos', 'contatos', 'contato_id = usuario_contato');
			$sql->esqUnir('projeto_mudanca', 'projeto_mudanca', 'projeto_mudanca.projeto_mudanca_responsavel = usuarios.usuario_id');
			$sql->adCampo('DISTINCT usuarios.usuario_id, '.($config['militar'] < 10 ? 'concatenar_tres(contato_posto, \' \', contato_nomeguerra)' : 'contato_nomeguerra').' AS nome_usuario, contato_email');
			$sql->adOnde('projeto_mudanca_projeto='.$this->projeto_mudanca_projeto);
			$usuarios3=$sql->Lista();
			$sql->limpar();
			}

		if (isset($post['email_extras']) && $post['email_extras']){
			$extras=explode(',',$post['email_extras']);
			foreach($extras as $chave => $valor) $usuarios4[]=array('usuario_id' => 0, 'nome_usuario' =>'', 'contato_email'=> $valor);
			}



		$usuarios = array_merge((array)$usuarios1, (array)$usuarios2);
		$usuarios = array_merge((array)$usuarios, (array)$usuarios3);
		$usuarios = array_merge((array)$usuarios, (array)$usuarios4);


		$usado_usuario=array();
		$usado_email=array();

		if (isset($post['excluir']) && $post['excluir'])$tipo='excluido';
		elseif (isset($post['projeto_mudanca_projeto']) && $post['projeto_mudanca_projeto']) $tipo='atualizado';
		else $tipo='incluido';

		foreach($usuarios as $usuario){
			if (!isset($usado[$usuario['usuario_id']]) && !isset($usado[$usuario['contato_email']])){

				if ($usuario['usuario_id']) $usado[$usuario['usuario_id']]=1;
				if ($usuario['contato_email']) $usado[$usuario['contato_email']]=1;
				$email = new Mail;
				$email->De($config['email'], $Aplic->usuario_nome);

                if ($Aplic->usuario_email && $email->EmailValido($Aplic->usuario_email)){
                    $email->ResponderPara($Aplic->usuario_email);
                    }
                else if($Aplic->usuario_email2 && $email->EmailValido($Aplic->usuario_email2)){
                    $email->ResponderPara($Aplic->usuario_email2);
                    }

				if ($tipo == 'excluido') {
					$email->Assunto('Excluda solicitao de mudanas ', $localidade_tipo_caract);
					$titulo='Excluda solicitao de mudanas ';
					}
				elseif ($tipo=='atualizado') {
					$email->Assunto('Atualizada solicitao de mudanas ', $localidade_tipo_caract);
					$titulo='Atualizada solicitao de mudanas ';
					}
				else {
					$email->Assunto('Inserida solicitao de mudanas ', $localidade_tipo_caract);
					$titulo='Inserida solicitao de mudanas ';
					}
				if ($tipo=='atualizado') $corpo = 'Atualizada solicitao de mudanas : '.$projeto_nome.'<br>';
				elseif ($tipo=='excluido') $corpo = 'Excluda solicitao de mudanas : '.$projeto_nome.'<br>';
				else $corpo = 'Inserida solicitao de mudanas : '.$projeto_nome.'<br>';

				if ($tipo=='excluido') $corpo .= '<br><br><b>Responsvel pela excluso da solicitao de mudanas :</b> '.$Aplic->usuario_posto.' '.$Aplic->usuario_nomeguerra;
				elseif ($tipo=='atualizado') $corpo .= '<br><br><b>Responsvel pela edio da solicitao de mudanas :</b> '.$Aplic->usuario_posto.' '.$Aplic->usuario_nomeguerra;
				else $corpo .= '<br><br><b>Criador da solicitao de mudana do projeto:</b> '.$Aplic->usuario_posto.' '.$Aplic->usuario_nomeguerra;

				$corpo_interno=$corpo;
				$corpo_externo=$corpo;
				
				if ($tipo!='excluido') {
					$corpo_interno .= '<br><a href="javascript:void(0);" onclick="url_passar(0, \'m=projetos&a=mudanca_ver&projeto_mudanca_id='.$this->projeto_mudanca_id.'\');"><b>Clique para acessar a solicitao de mudanas</b></a>';
					if ($Aplic->profissional){
						require_once BASE_DIR.'/incluir/funcoes_principais_pro.php';
						$endereco=link_email_externo($usuario['usuario_id'], 'm=projetos&a=mudanca_ver&projeto_mudanca_id='.$this->projeto_mudanca_id);
						$corpo_externo.='<br><a href="'.$endereco.'"><b>Clique para acessar a solicitao de mudanas</b></a>';
						}
					}

				$email->Corpo($corpo_externo, isset($GLOBALS['locale_char_set']) ? $GLOBALS['locale_char_set'] : '');
				if ($usuario['usuario_id']!=$Aplic->usuario_id && $usuario['usuario_id']) {
					if ($usuario['usuario_id']) msg_email_interno('', $titulo, $corpo_interno,'',$usuario['usuario_id']);
					if ($email->EmailValido($usuario['contato_email']) && $config['email_ativo']) {
						$email->Para($usuario['contato_email'], true);
						$email->Enviar();
						}
					}
				}
			}
		}

	}

?>