<?php
/* Copyright [2011] -  Srgio Fernandes Reinert de Lima - INPI 11802-5
Este arquivo  parte do programa gpweb
O gpweb  um software livre; voc pode redistribu-lo e/ou modific-lo dentro dos termos da Licena Pblica Geral GNU como publicada pela Fundao do Software Livre (FSF); na verso 2 da Licena.
Este programa  distribudo na esperana que possa ser  til, mas SEM NENHUMA GARANTIA; sem uma garantia implcita de ADEQUAO a qualquer  MERCADO ou APLICAO EM PARTICULAR. Veja a Licena Pblica Geral GNU/GPL em portugus para maiores detalhes.
Voc deve ter recebido uma cpia da Licena Pblica Geral GNU, sob o ttulo "licena GPL 2.odt", junto com este programa, se no, acesse o Portal do Software Pblico Brasileiro no endereo www.softwarepublico.gov.br ou escreva para a Fundao do Software Livre(FSF) Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301, USA 
*/
require BASE_DIR.'/incluir/validar_autorizado.php';
if (!defined('BASE_DIR')) die('Voc no deveria acessar este arquivo diretamente.');

include_once $Aplic->getClasseBiblioteca('xajax/xajax_core/xajax.inc');
$xajax = new xajax();
$xajax->configure('defaultMode', 'synchronous');
//$xajax->setFlag('debug',true);
//$xajax->setFlag('outputEntities',true);

require_once $Aplic->getClasseSistema('Modelo');
require_once $Aplic->getClasseSistema('Template');


function alterar_html($modelo_id, $html){
    global $bd, $Aplic, $config;

    $html = previnirXSS(utf8_decode($html));
    if ($modelo_id){
        $sql = new BDConsulta();
        $sql->adTabela('modelos_tipo');
        $sql->adAtualizar('modelo_tipo_html', $html);
        $sql->adOnde('modelo_tipo_id='.$modelo_id);
        $sql->exec();
        $sql->limpar();

        $sql->adTabela('modelos_tipo');
        $sql->adCampo('modelo_tipo_campos, modelo_tipo_html');
        $sql->adOnde('modelo_tipo_id='.$modelo_id);
        $linha=$sql->linha();
        $sql->limpar();

        $campos = unserialize($linha['modelo_tipo_campos']);

        $modelo= new Modelo;
        $modelo->set_modelo_tipo($modelo_id);

        foreach((array)$campos['campo'] as $posicao => $campo){
            $modelo->set_campo($campo['tipo'], str_replace('\"','"',$campo['dados']), $posicao, $campo['extra'], $campo['larg_max'], $campo['outro_campo']);
            }

        $tpl = new Template($linha['modelo_tipo_html'],'',$config['militar']);
        $modelo->set_modelo($tpl);
        $modelo->edicao=true;

        for ($i=1; $i <= $modelo->quantidade(); $i++){
            $campo='campo_'.$i;
            $tpl->$campo = $modelo->get_campo($i);
            }

        $exibir = $tpl->exibir($modelo->edicao);

        $objResposta = new xajaxResponse();
        $objResposta->assign("campo_modelos","innerHTML", utf8_encode($exibir));
        $objResposta->script('aposSalvarHtml();');
        return $objResposta;
        }
    }
$xajax->registerFunction("alterar_html");

$xajax->processRequest();
?>