<?php
/*
Copyright (c) 2007-2011 The web2Project Development Team <w2p-developers@web2project.net>
Copyright (c) 2003-2007 The dotProject Development Team <core-developers@dotproject.net>
Copyright [2011] -  Srgio Fernandes Reinert de Lima - INPI 11802-5
Este arquivo  parte do programa gpweb
O gpweb  um software livre; voc pode redistribu-lo e/ou modific-lo dentro dos termos da Licena Pblica Geral GNU como publicada pela Fundao do Software Livre (FSF); na verso 2 da Licena.
Este programa  distribudo na esperana que possa ser  til, mas SEM NENHUMA GARANTIA; sem uma garantia implcita de ADEQUAO a qualquer  MERCADO ou APLICAO EM PARTICULAR. Veja a Licena Pblica Geral GNU/GPL em portugus para maiores detalhes.
Voc deve ter recebido uma cpia da Licena Pblica Geral GNU, sob o ttulo "licena GPL 2.odt", junto com este programa, se no, acesse o Portal do Software Pblico Brasileiro no endereo www.softwarepublico.gov.br ou escreva para a Fundao do Software Livre(FSF) Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301, USA
*/
require BASE_DIR.'/incluir/validar_autorizado.php';
if (!defined('BASE_DIR')) die('Voc no deveria acessar este arquivo diretamente.');

if (!$Aplic->usuario_super_admin) $Aplic->redirecionar('m=publico&a=acesso_negado');
$cmd=getParam($_REQUEST, 'cmd', '0');
$mod_id = intval(getParam($_REQUEST, 'mod_id', '0'));
$mod_diretorio=getParam($_REQUEST, 'mod_diretorio', '0');



$obj = new CModulo();
if ($mod_id) $obj->load($mod_id);
else $obj->mod_diretorio = $mod_diretorio;
$ok = include_once(BASE_DIR.'/modulos/'.$obj->mod_diretorio.'/setup.php');

if (!$ok) {
	if ($obj->mod_tipo != 'core') {
		$Aplic->setMsg('Mdulo de configurao de arquivo no foi encontrado', UI_MSG_ERRO);
		if ($cmd == 'remover') {
			$q = new BDConsulta;
			$q->setExcluir('modulos');
			$q->adOnde('mod_id = '.(int)$mod_id);
			$q->exec();
			$q->limpar();
			echo db_error();
			$Aplic->setMsg('Mdulo foi removido da lista de mdulos - verifique a base de dados por tabelas que necessitem serem excludas', UI_MSG_ERRO);
			}
		$Aplic->redirecionar('m=sistema&a=vermods');
		}
	}
	
$classeConfig = (isset($configuracao['mod_classe_configurar']) ? $configuracao['mod_classe_configurar'] : '');

if (!$classeConfig) {
	if ($obj->mod_tipo != 'core') {
		$Aplic->setMsg('Mdulo no tem uma classe de configuao vlida', UI_MSG_ERRO);
		$Aplic->redirecionar('m=sistema&a=vermods');
		}
	}
else $setup = new $classeConfig();

switch ($cmd) {
	case 'moverParaCima':
	case 'moverParaBaixo':
	case 'moverPrimeiro':
	case 'moverUltimo':
		$obj->mover($cmd);
		$Aplic->setMsg('Mdulo reordenado', UI_MSG_OK);
		break;
	case 'ativar':
		$obj->mod_ativo = 1 - $obj->mod_ativo;
		$obj->armazenar();
		$Aplic->setMsg('Estado do mdulo mudou', UI_MSG_OK);
		break;
	case 'ativarMenu':
		$obj->mod_ui_ativo = 1 - $obj->mod_ui_ativo;
		$obj->armazenar();
		$Aplic->setMsg('Menu de estado do mdulo mudou', UI_MSG_OK);
		break;
	case 'instalar':
		$Aplic->setMsg($setup->instalar());
		$obj->join($configuracao);
		$obj->instalar();
		$Aplic->setMsg('Mdulo instalado', UI_MSG_OK, true);
		break;
	case 'remover':
		$Aplic->setMsg($setup->remover());
		$obj->remover();
		$Aplic->setMsg('Mdulo removido', UI_MSG_ALERTA, true);
		break;
	case 'atualizar':
		$Aplic->setMsg($setup->atualizar($obj->mod_versao));
		$Aplic->setMsg('Atualizao efetuada', UI_MSG_OK, true);
		break;
	case 'exemplo':
		$Aplic->setMsg($setup->exemplo());
		$Aplic->setMsg('Exemplo carregado', UI_MSG_OK, true);
		break;	
	case 'configurar':
		if ($setup->configurar()){
			//fazer o que?
			} 
		else $Aplic->setMsg('Configurao do mdulo falhou', UI_MSG_ERRO);
		break;
	default:
		$Aplic->setMsg('Comando desconhecido', UI_MSG_ERRO);
		break;
	}
$Aplic->redirecionar('m=sistema&a=vermods');
?>