<?php
/*
Copyright (c) 2007-2011 The web2Project Development Team <w2p-developers@web2project.net>
Copyright (c) 2003-2007 The dotProject Development Team <core-developers@dotproject.net>
Copyright [2011] -  Srgio Fernandes Reinert de Lima - INPI 11802-5
Este arquivo  parte do programa gpweb
O gpweb  um software livre; voc pode redistribu-lo e/ou modific-lo dentro dos termos da Licena Pblica Geral GNU como publicada pela Fundao do Software Livre (FSF); na verso 2 da Licena.
Este programa  distribudo na esperana que possa ser  til, mas SEM NENHUMA GARANTIA; sem uma garantia implcita de ADEQUAO a qualquer  MERCADO ou APLICAO EM PARTICULAR. Veja a Licena Pblica Geral GNU/GPL em portugus para maiores detalhes.
Voc deve ter recebido uma cpia da Licena Pblica Geral GNU, sob o ttulo "licena GPL 2.odt", junto com este programa, se no, acesse o Portal do Software Pblico Brasileiro no endereo www.softwarepublico.gov.br ou escreva para a Fundao do Software Livre(FSF) Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301, USA
*/
require BASE_DIR.'/incluir/validar_autorizado.php';

/********************************************************************************************
		
gpweb\instalacao\ver_idx_checar.php		

Verifica as configuraes do servidor para a instalao e exibe os resultados
																																												
********************************************************************************************/
if (!defined('BASE_DIR')) die('No deveria acessar diretamente este arquivo!');

$falhaImg = '<img src="./estilo/rondon/imagens/icones/cancelar.png" width="16" height="16" align="middle" alt="Failed"/>';
$okImg = '<img src="./estilo/rondon/imagens/icones/ok.png" width="16" height="16" align="middle" alt="OK"/>';
$larguraTabela = '95%';
$dirCfg = './incluir';
$arquivoCfg = './config.php';
$dirArquivos = './arquivos';
$dirLocalidade = './localidades/pt';
$dirTmp = './arquivos/temp';


$dirCfg = isset($dirCfg) ? $dirCfg : BASE_DIR.'/incluir';
$arquivoCfg = isset($arquivoCfg) ? $arquivoCfg : BASE_DIR.'/config.php';
$dirArquivos = isset($dirArquivos) ? $dirArquivos : BASE_DIR.'/arquivos';
$dirLocalidade = isset($dirLocalidade) ? $dirLocalidade : BASE_DIR.'/localidades/pt';
$dirTmp = isset($dirTmp) ? $dirTmp : BASE_DIR.'/arquivos/temp';
$larguraTabela = isset($larguraTabela) ? $larguraTabela :'100%';
$chmod = 0777;

	
	
$botoesTitulo = new CBlocoTitulo('Instalao do '.$config['gpweb'].'', 'administracao.png', $m, $m.'.'.$a);
$botoesTitulo->adicionaBotao('m=sistema&a=index', 'sistema','','Administrao do Sistema','Voltar  tela de Administrao do Sistema.');
$botoesTitulo->mostrar();	
	
echo estiloTopoCaixa();
echo '<table cellspacing=0 cellpadding="6" border=0 class="std" width="100%" align="center">';
echo '<tr><td class="title" colspan="2">Checagem dos Requisitos</td></tr>';
echo '<tr><td  width="300"><li>PHP &gt;= 5.2</li></td><td align="left">'.(version_compare(phpversion(), '5.2', '<') ? '<b class="error">'.$falhaImg.' ('.phpversion().'): o '.$config['gpweb'].' poder no funcionar. Por favor faa uma atualizao!</b>' : '<b class="ok">'.$okImg.'</b><span > ('.phpversion().')</span>').'</td></tr>';
echo '<tr><td ><li>API do Servidor</li></td><td align="left">'.((php_sapi_name() != 'cgi') ? '<b class="ok">'.$okImg.'</b><span > ('.php_sapi_name().')</span>' : '<b class="error">'.$falhaImg.' modo CGI  provvel de ter problemas</b>').'</td></tr>';
echo '<tr><td ><li>Suporte GD (para o grfico GANTT)</li></td><td align="left">'.(extension_loaded('gd') ? '<b class="ok">'.$okImg.'</b>' : '<b class="error">'.$falhaImg.'</b> A funcionalidade do grfico GANTT Chart poder no funcionar corretamente, pois a biblioteca GD no foi ativada no PHP').'</td></tr>';
echo '<tr><td ><li>Suporte a compresso Zlib</li></td><td align="left">'.(extension_loaded('zlib') ? '<b class="ok">'.$okImg.'</b>' : '<b class="error">'.$falhaImg.'</b> Alguns mdulos No-essenciais como Backup podero ter operao restrita.').'</td></tr>';
$maxUploadArquivo = min(getTamanhoIni(ini_get('upload_max_filesize')), getTamanhoIni(ini_get('post_max_size')));
$limite_memoria = getTamanhoIni(ini_get('memory_limit'));
if ($limite_memoria > 0 && $limite_memoria < $maxUploadArquivo) $maxUploadArquivo = $limite_memoria;
if ($maxUploadArquivo > 1048576) $maxUploadArquivo = (int)($maxUploadArquivo / 1048576).'M';
else if ($maxUploadArquivo > 1024) $maxUploadArquivo = (int)($maxUploadArquivo / 1024).'K';
echo '<tr><td ><li>Upload de arquivos</li></td><td align="left">'.(ini_get('file_uploads') ? '<b class="ok">'.$okImg.'</b><span > (Tamanho mximo de upload: '. $maxUploadArquivo .')</span>' : '<b class="error">'.$falhaImg.'</b><span class="warning"> a funcionalidade de Upload no estar disponvel</span>').'</td></tr>';
echo '<tr><td ><li>Caminho para salvar a Sesso permite escrita?</li></td><td align="left">';
$caminhoSalvoSessao = ini_get('session.save_path');
if (! $caminhoSalvoSessao) echo "<b class='error'>$falhaImg Fatal:</b> <span class='item'>session.save_path</span> <b class='error'> no est configurado</b>";
else if (is_dir($caminhoSalvoSessao) && is_writable($caminhoSalvoSessao)) echo "<b class='ok'>$okImg</b> <span class='item'>($caminhoSalvoSessao)</span>";
else echo "<b class='error'>$falhaImg Fatal:</b> <span class='item'>$caminhoSalvoSessao</span><b class='error'> no existente ou no permite escrita</b>";
echo '</td></tr>';
echo '<tr><td class="title" colspan="2"><br />Conectores para Banco de Dados</td></tr>';
echo '<tr><td  colspan="2"><p>O prximo teste  para verificar o suporte de banco de dados compilado com o PHP.  utilizado a camada de abstrao de banco de dados ADODB para utilizao com mltiplos bancos de dados.<p>No momento apenas MySQL  completamente suportado, portanto precisa estar seguro de que esteja disponvel.</td></tr>';

$bdOk = false;
$bdInfo = '';

if(extension_loaded('mysqli')){
    $bdOk = true;
    $bdInfo = @mysqli_get_server_info(mysqli_init());
}
else if(extension_loaded('mysql')){
    $bdOk = true;
    $bdInfo = @mysql_get_server_info();
}

echo '<tr><td ><li>MySQL</li></td><td align="left">'.($bdOk ? '<b class="ok">'.$okImg.'</b><span > '.$bdInfo.'</span>' : '<span class="warning">'.$falhaImg.' No disponvel</span>').'</td></tr>';

echo '<tr><td ><li>LDAP</li></td><td align="left">'.(function_exists( 'ldap_connect' ) ? '<b class="ok">'.$okImg.'</b>' : '<span class="warning">'.$falhaImg.' No disponvel</span>').'</td></tr>';


echo '<tr><td class="title" colspan="2"><br />Escrita em Pastas e Arquivos</td></tr>';
echo '<tr><td  colspan="2">Se a mensagem \'Permitida escrita\' aparecer depois de um arquivo/diretrio, ento h permisses de escrita para todos os usurios.</td></tr>';
$mensagemOk='';

if ( (file_exists( $arquivoCfg ) && !is_writable( $arquivoCfg )) || (!file_exists( $arquivoCfg ) && !(is_writable( $dirCfg ))) ) {
	@chmod( $arquivoCfg, $chmod );
	@chmod( $dirCfg, $chmod );
	$arquivoModo = @fileperms($arquivoCfg);
	if ($arquivoModo & 2) $mensagemOk='<span class="ok">Permitida escrita</span>';
	}
echo '<tr><td >./config.php permite escrita?</td><td align="left">'.(( is_writable( $arquivoCfg ) || is_writable( $dirCfg ))  ? '<b class="ok">'.$okImg.'</b>Permitida escrita' : '<b class="error">'.$falhaImg.'</b><span class="warning"> O processo de configurao ainda pode continuar. O arquivo de configurao ser mostrado no fim, basta copiar e fazer o upload do mesmo.</span>').'</td></tr>';
$mensagemOk="";
if (!is_writable( $dirArquivos )) @chmod( $dirArquivos, $chmod );
$arquivoModo = @fileperms($dirArquivos);
if ($arquivoModo & 2) $mensagemOk='<span class="ok">Permitida escrita</span>';
echo '<tr><td >./arquivos  permite escrita?</td><td align="left">'.(is_writable( $dirArquivos ) ? '<b class="ok">'.$okImg.'</b>'.$mensagemOk : '<b class="error">'.$falhaImg.'</b><span class="warning">O Upload de arquivos ser desabilitado</span>').'</td></tr>';
$mensagemOk="";
if (!is_writable( $dirTmp )) @chmod( $dirTmp, $chmod );
$arquivoModo = @fileperms($dirTmp);
if ($arquivoModo & 2) $mensagemOk='<span class="ok">Permitida escrita</span>';
echo '<tr><td >./arquivos/temp permite escrita?</td><td align="left">'.(is_writable( $dirTmp ) ? '<b class="ok">'.$okImg.'</b>'.$mensagemOk : '<b class="error">'.$falhaImg.'</b><span class="warning"> a gerao de relatrios PDF ser desabilitada</span>').'</td></tr>';
$mensagemOk="";
if (!is_writable( $dirLocalidade )) @chmod( $dirLocalidade, $chmod );
$arquivoModo = @fileperms($dirLocalidade);
if ($arquivoModo & 2) $mensagemOk='<span class="ok">Permitida escrita</span>';

echo '<tr><td class="title" colspan="2"><br/>Assinatura Digital e Criptografia</td></tr>';
echo '<tr><td>Open SSL instalado no PHP?</td><td align="left">'.(function_exists('openssl_sign') ? '<b class="ok">'.$okImg.'</b>' : '<b class="error">'.$falhaImg.'</b><span class="warning">Instale ou habilite a biblioteca Open SSL no PHP.</span>').'</td></tr>';
//echo '<tr><td class="title" colspan="2"><br/>Envio de e-mail em segundo plano</td></tr>';
//echo '<tr><td>Curl instalado?</td><td align="left">'.(function_exists("curl_init") ? '<b class="ok">'.$okImg.'</b>' : '<b class="error">'.$falhaImg.'</b><span class="warning">Instale ou habilite a biblioteca Curl no PHP.</span>').'</td></tr>';
echo '<tr><td class="title" colspan="2"><br/>Configuraes Recomendadas do PHP</td></tr>';
echo '<tr><td >Modo Seguro desativado?</td><td align="left">'.(!ini_get('safe_mode') ? '<b class="ok">'.$okImg.'</b>' : '<b class="error">'.$falhaImg.'</b><span class="warning">A utilizao do modo seguro est depreciada</span>').'</td></tr>';
echo '<tr><td >Registros Globais desativados?</td><td align="left">'.(!ini_get('register_globals') ? '<b class="ok">'.$okImg.'</b>' : '<b class="error">'.$falhaImg.'</b><span class="warning"> H riscos na segurana deixando ativado.</span>').'</td></tr>';
echo '<tr><td >Incio automtico das Sesses desativado?</td><td align="left">'.(!ini_get('session.auto_start') ? '<b class="ok">'.$okImg.'</b>' : '<b class="error">'.$falhaImg.'</b><span class="warning">Utilize esta configurao apenas se stiver experimentando uma <i>Tela Branca da Morte.</i></span>').'</td></tr>';
echo '<tr><td >Uso de Cookies pelas Sesses ativado?</td><td align="left">'.(ini_get('session.use_cookies') ? '<b class="ok">'.$okImg.'</b>' : '<b class="error">'.$falhaImg.'</b><span class="warning"> Tente deixar atvado se experimentar problemas ao logar.</span>').'</td></tr>';
echo '<tr><td >Uso de Trans Sid pelas Sesses desativado?</td><td align="left">'.((!ini_get('session.use_trans_sid')) ? '<b class="ok">'.$okImg.'</b>' : '<b class="error">'.$falhaImg.'</b><span class="warning"> H problemas de segurana quando deixado ativado.</span>').'</td></tr>';
echo '<tr><td >Magic Quotes desabilitadas?</td><td align="left">'.((!@get_magic_quotes_gpc()) ? '<b class="ok">'.$okImg.'</b>' : '<b class="error">'.$falhaImg.'</b><span class="warning"> Uso de magic quotes no PHP.ini  desaconselhado.</span>').'</td></tr>';
echo '<tr><td class="title" colspan="2"><br/>Outras Recomendaes</td></tr>';
echo '<tr><td >Sistema operacional  software livre?</td><td align="left">'.((strtoupper(substr(PHP_OS, 0, 3)) != 'WIN') ? '<b class="ok">'.$okImg.'</b><span > ('.php_uname().')</span>' : '<b class="error">'.$falhaImg.'</b><span class="warning">Aparentemente voc est utilizando um sistema operacional proprietrio. Considere instalar um sistema operacional Linux.</span>').'</td></tr>';
echo '<tr><td >Servidor Web suportado?</td><td align="left">'.((stristr(previnirXSS($_SERVER['SERVER_SOFTWARE']), 'apache') != false) ? '<b class="ok">'.$okImg.'</b><span > ('.previnirXSS($_SERVER['SERVER_SOFTWARE']).')</span>' : '<b class="error">'.$falhaImg.'</b><span class="warning">Aparentemente voc est utilizando um Servidor Web no suportado pelo aplicativo.  Somente o servidor Apache  100% suportado pelo '.$config['gpweb'].'.</span>').'</td></tr>';
echo '<tr><td >Navegador Web padro?</td><td align="left">'.((stristr(previnirXSS($_SERVER['HTTP_USER_AGENT']), 'msie') == false) ? '<b class="ok">'.$okImg.'</b><span > ('.previnirXSS($_SERVER['HTTP_USER_AGENT']).')</span>' : '<b class="error">'.$falhaImg.'</b><span class="warning">Aparentemente voc est utilizando o Internet Explorer.  Este navegador  conhecido por inmeros problemas de segurana e no utiliza padres internacionais para visualizao de pginas. Considere a ideia de utilizar o navegador Firefox.</span>').'</td></tr>';
echo '</table>';
echo estiloFundoCaixa();



function getTamanhoIni($val) {
	 $val = trim($val);
	 if (strlen($val <= 1)) return $val;
	 $ultimo = $val{strlen($val)-1};
	 switch($ultimo) {
	   case 'k':
	   case 'K':
	     return (int) $val * 1024;
	     break;
	   case 'm':
	   case 'M':
	     return (int) $val * 1048576;
	     break;
	   default:
	     return $val;
	 	}
	}
?>
