<?php
/* Copyright [2011] -  Srgio Fernandes Reinert de Lima - INPI 11802-5
Este arquivo  parte do programa gpweb
O gpweb  um software livre; voc pode redistribu-lo e/ou modific-lo dentro dos termos da Licena Pblica Geral GNU como publicada pela Fundao do Software Livre (FSF); na verso 2 da Licena.
Este programa  distribudo na esperana que possa ser  til, mas SEM NENHUMA GARANTIA; sem uma garantia implcita de ADEQUAO a qualquer  MERCADO ou APLICAO EM PARTICULAR. Veja a Licena Pblica Geral GNU/GPL em portugus para maiores detalhes.
Voc deve ter recebido uma cpia da Licena Pblica Geral GNU, sob o ttulo "licena GPL 2.odt", junto com este programa, se no, acesse o Portal do Software Pblico Brasileiro no endereo www.softwarepublico.gov.br ou escreva para a Fundao do Software Livre(FSF) Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301, USA 
*/
require BASE_DIR.'/incluir/validar_autorizado.php';

if (!defined('BASE_DIR')) die('Voc no deveria acessar este arquivo diretamente.');

include_once $Aplic->getClasseBiblioteca('xajax/xajax_core/xajax.inc');
$xajax = new xajax();
$xajax->configure('defaultMode', 'synchronous');

function atualizar_praticas($cia_id=0){
	$sql = new BDConsulta;
	$sql->adTabela('praticas');
	$sql->adOnde('pratica_cia='.(int)$cia_id);
	$sql->adOrdem('pratica_nome ASC');
	$linhas=$sql->Lista();
	$sql->limpar();	
	$vetor=array();
	foreach($linhas as $linha) $vetor[$linha['pratica_id']]=utf8_encode($linha['pratica_nome']);
	$saida=selecionaVetor($vetor, 'ListaPraticas[]', 'class=texto size=12 style="width:100%;" multiple', '0');
	$objResposta = new xajaxResponse();
	$objResposta->assign('combo_praticas',"innerHTML", $saida);
	return $objResposta;
	}



function atualizar_indicadores($cia_id=0){
	$sql = new BDConsulta;
	$sql->adTabela('pratica_indicador');
	$sql->adOnde('pratica_indicador_cia='.(int)$cia_id);
	$sql->adOrdem('pratica_indicador_nome ASC');
	$linhas=$sql->Lista();
	$sql->limpar();	
	$vetor=array();
	foreach($linhas as $linha) $vetor[$linha['pratica_indicador_id']]=utf8_encode($linha['pratica_indicador_nome']);
	$saida=selecionaVetor($vetor, 'ListaIndicadores[]', 'class=texto size=12 style="width:100%;" multiple', '0');
	$objResposta = new xajaxResponse();
	$objResposta->assign('combo_indicadores',"innerHTML", $saida);
	return $objResposta;
	}




function selecionar_om_ajax($cia_id=1, $campo, $posicao, $script,  $vazio='', $acesso=0, $externo=0 ){
	$saida=selecionar_om_para_ajax($cia_id, $campo, $script,  $vazio, $acesso, $externo);
	$objResposta = new xajaxResponse();
	$objResposta->assign($posicao,"innerHTML", $saida);
	return $objResposta;
	}
	
function exibir_combo($posicao, $tabela, $chave='', $campo='', $onde='', $ordem='', $script='', $campo_id='', $campoatual='', $campobranco=true, $tabela2='', $uniao2='', $tabela3='', $uniao3=''){
	global $localidade_tipo_caract;

	$sql = new BDConsulta;
	$sql->adTabela($tabela);
	$onde=html_entity_decode($onde, ENT_COMPAT, $localidade_tipo_caract);
	if ($tabela2) $sql->esqUnir($tabela2, $tabela2, $uniao2);
	if ($tabela3) $sql->esqUnir($tabela3, $tabela3, $uniao3);
	if ($chave) $sql->adCampo($chave);
	if ($campo) $sql->adCampo($campo);
	if ($onde) $sql->adOnde($onde);
	if ($ordem) $sql->adOrdem($ordem);
	$saida=$sql->comando_sql();
	$linhas=$sql->Lista();
	$sql->limpar();
	$vetor=array();
	$chave=explode('.',$chave); 
	$chave = array_pop($chave);
	if ($campobranco) $vetor[]='';
	foreach($linhas as $linha)$vetor[$linha[$chave]]=utf8_encode($linha[$campo]);
	$saida=selecionaVetor($vetor, $campo_id, $script, $campoatual);
	$objResposta = new xajaxResponse();
	$objResposta->assign($posicao,"innerHTML", $saida);
	return $objResposta;
	}

$xajax->registerFunction("atualizar_praticas");	
$xajax->registerFunction("atualizar_indicadores");	

	
$xajax->registerFunction("selecionar_om_ajax");	


$xajax->processRequest();

?>