<?php
/*
Copyright (c) 2007-2011 The web2Project Development Team <w2p-developers@web2project.net>
Copyright (c) 2003-2007 The dotProject Development Team <core-developers@dotproject.net>
Copyright [2011] -  Srgio Fernandes Reinert de Lima - INPI 11802-5
Este arquivo  parte do programa gpweb
O gpweb  um software livre; voc pode redistribu-lo e/ou modific-lo dentro dos termos da Licena Pblica Geral GNU como publicada pela Fundao do Software Livre (FSF); na verso 2 da Licena.
Este programa  distribudo na esperana que possa ser  til, mas SEM NENHUMA GARANTIA; sem uma garantia implcita de ADEQUAO a qualquer  MERCADO ou APLICAO EM PARTICULAR. Veja a Licena Pblica Geral GNU/GPL em portugus para maiores detalhes.
Voc deve ter recebido uma cpia da Licena Pblica Geral GNU, sob o ttulo "licena GPL 2.odt", junto com este programa, se no, acesse o Portal do Software Pblico Brasileiro no endereo www.softwarepublico.gov.br ou escreva para a Fundao do Software Livre(FSF) Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301, USA
*/
require BASE_DIR.'/incluir/validar_autorizado.php';
if (!defined('BASE_DIR')) die('Voc no deveria acessar este arquivo diretamente.');

include_once ($Aplic->getClasseSistema('aplic'));

/*********************************************************************************************
Classe CSisValor para manipulao dos valores das constantes do Sistema
		
gpweb\modulos\sistema\sischaves\sischaves.class.php																																		
																																												
********************************************************************************************/
class CSisValor extends CAplicObjeto {
	public $sisvalor_id = null;
	public $sisvalor_titulo = null;
	public $sisvalor_valor = null;
	public $sisvalor_valor_id = null;
	public $sisvalor_chave_id_pai = null;
	
	public function __construct( $titulo = null, $valor = null) {
		parent::__construct('sisvalores', 'sisvalor_id');
		$this->sisvalor_titulo = $titulo;
		$this->sisvalor_valor = $valor;
		}
	
	public function check() {
		if (!$this->sisvalor_titulo) return 'Nome da Chave no pode ser vazio';
		return null;
		}

	public function armazenar( $atualizarNulos = false) {
		$this->arrumarTodos();
		$msg = $this->check();
		if ($msg) return get_class($this).'::checagem para armazenar falhou - '.$msg;
		$valores = formatarSisValor($this->sisvalor_valor);
		

		$sql = new BDConsulta;
		if ($this->sisvalor_titulo) {
			$sql->setExcluir('sisvalores');
			$sql->adOnde('sisvalor_projeto IS NULL');
			$sql->adOnde('sisvalor_titulo = \''.$this->sisvalor_titulo.'\'');
			if (!$sql->exec()) {
				$sql->limpar();
				return get_class($this).'::armazenar falhou: '.db_error();
				}
			}
		foreach ($valores as $chave => $valor) {
			$sql->adTabela('sisvalores');
			$sql->adInserir('sisvalor_titulo', $this->sisvalor_titulo);
			$sql->adInserir('sisvalor_valor_id', $chave);
			$sql->adInserir('sisvalor_valor', $valor[0]);
			if ($valor[1]) $sql->adInserir('sisvalor_chave_id_pai', $valor[1]);
			if (!$sql->exec()) {
				$sql->limpar();
				return get_class($this).'::armazenar falhou: '.db_error();
				}
			$sql->limpar();
			}
		return null;
		}
	public function excluir( $oid = NULL) {
		$sql = new BDConsulta;
		if ($this->sisvalor_titulo) {
			$sql->setExcluir('sisvalores');
			$sql->adOnde('sisvalor_projeto IS NULL');
			$sql->adOnde('sisvalor_titulo = \''.$this->sisvalor_titulo.'\'');
			if (!$sql->exec()) {
				$sql->limpar();
				return get_class($this).'::excluir falhou <br />'.db_error();
				}
			}
		return null;
		}
	}
	
function formatarSisValor($texto) {
	$sql = new BDConsulta;

	$sep1 = ''; 
	$sep2 = '|'; 
	$sep1 = "\n";
	
	$temp = explode($sep1, $texto);
	$vetor = array();
	foreach ($temp as $item) {
		if ($item) {
			$sep2 = empty($sep2) ? "\n" : $sep2;
			$temp2 = explode($sep2, $item);
			if (isset($temp2[1])) $vetor[trim($temp2[0])] = array(trim($temp2[1]), (isset($temp2[2]) ? trim($temp2[2]) : ''));
			else $vetor[trim($temp2[0])] = trim($temp2[0]);
			}
		}
	return $vetor;
	}
?>