<?php
/* Copyright [2011] -  Srgio Fernandes Reinert de Lima - INPI 11802-5
Este arquivo  parte do programa gpweb
O gpweb  um software livre; voc pode redistribu-lo e/ou modific-lo dentro dos termos da Licena Pblica Geral GNU como publicada pela Fundao do Software Livre (FSF); na verso 2 da Licena.
Este programa  distribudo na esperana que possa ser  til, mas SEM NENHUMA GARANTIA; sem uma garantia implcita de ADEQUAO a qualquer  MERCADO ou APLICAO EM PARTICULAR. Veja a Licena Pblica Geral GNU/GPL em portugus para maiores detalhes.
Voc deve ter recebido uma cpia da Licena Pblica Geral GNU, sob o ttulo "licena GPL 2.odt", junto com este programa, se no, acesse o Portal do Software Pblico Brasileiro no endereo www.softwarepublico.gov.br ou escreva para a Fundao do Software Livre(FSF) Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301, USA 
*/
require BASE_DIR.'/incluir/validar_autorizado.php';
if (!defined('BASE_DIR')) die('Voc no deveria acessar este arquivo diretamente.');

global $config;

include_once BASE_DIR.'/modulos/tarefas/funcoes.php';

$sql = new BDConsulta;
$del = intval(getParam($_REQUEST, 'del', 0));
$tarefa_id=getParam($_REQUEST, 'tarefa_id', null);
$log_id=getParam($_REQUEST, 'log_id', null);
$projeto_id=getParam($_REQUEST, 'projeto_id', null);
$dialogo=getParam($_REQUEST, 'dialogo', 0);
$log_tarefa=getParam($_REQUEST, 'log_tarefa', 0);


if (!$tarefa_id && $log_tarefa) $tarefa_id=$log_tarefa;

if (!$projeto_id) {
	$sql->adTabela('tarefas');
  $sql->adCampo('tarefa_projeto');
  $sql->adOnde('tarefa_id='.(int)$tarefa_id);
  $projeto_id=$sql->resultado();
  $sql->limpar();
	}


if ($Aplic->profissional){
	$sql->adTabela('projetos');
  $sql->adCampo('projeto_aprova_registro');
  $sql->adOnde('projeto_id='.(int)$projeto_id);
  $aprova_registro=$sql->resultado();
  $sql->limpar();
	}
else $aprova_registro=false;




$cache = null;
if($Aplic->profissional){
    require_once BASE_DIR.'/modulos/projetos/tarefa_cache.class_pro.php';
    $cache = CTarefaCache::getInstance();
    }

$obj = new CTarefaLog();
if ($log_id) $obj->_mensagem = 'atualizado';
else $obj->_mensagem = 'adicionado';

if (!$obj->join($_REQUEST)) {
	$Aplic->setMsg($obj->getErro(), UI_MSG_ERRO);
	$Aplic->redirecionar('m=tarefas&a=ver&tab=0&projeto_id='.(int)$projeto_id.'&tarefa_id='.(int)$tarefa_id);
	}

$Aplic->setMsg('Registro de ocorrncia d'.$config['genero_tarefa'].' '.$config['tarefa']);

$nova_percentagem = null;
$nova_data_inicio = null;
$nova_data_fim = null;
$nova_duracao = null;
$novo_numero_dias  = null;
$novo_status = null;

if ($del){
	$obj->load($log_id);
	if (($msg = $obj->excluir()))	$Aplic->setMsg($msg, UI_MSG_ERRO);
	else $Aplic->setMsg('excludo', UI_MSG_ALERTA, true);
	$Aplic->redirecionar('m='.($tarefa_id ? 'tarefas&tab=0' : 'projetos&tab=3').'&a=ver&projeto_id='.$projeto_id.'&tarefa_id='.$tarefa_id);
	}

if (($msg = $obj->armazenar())) $Aplic->setMsg($msg, UI_MSG_ERRO);
else {
	$obj->notificar($_REQUEST);
	
	$Aplic->setMsg($log_id ? 'atualizado' : 'adicionado', UI_MSG_OK, true);

	if (!$aprova_registro && ($_REQUEST['tarefa_percentagem_antiga']!=$_REQUEST['tarefa_percentagem'])){
    if($cache){
      $nova_percentagem = (float)getParam($_REQUEST, 'tarefa_percentagem', null);
      $cache->mudarPercentualTarefa($tarefa_id, $nova_percentagem);
      }
    else{
      $sql->adTabela('tarefas');
      $sql->adAtualizar('tarefa_percentagem', (int)getParam($_REQUEST, 'tarefa_percentagem', null));
      $sql->adAtualizar('tarefa_percentagem_data', date('Y-m-d H:i:s'));
      $sql->adOnde('tarefa_id='.(int)$tarefa_id);
      $sql->exec();
      $sql->limpar();
      }
      
		$sql->adTabela('log');
		$sql->adAtualizar('log_reg_mudanca_percentagem', $_REQUEST['tarefa_percentagem']);
		$sql->adOnde('log_id='.(int)$obj->log_id);
		$sql->exec();
		$sql->limpar();
		}
	else if ($_REQUEST['tarefa_percentagem_antiga']!=$_REQUEST['tarefa_percentagem']){
		$sql->adTabela('log');
		$sql->adAtualizar('log_reg_mudanca_percentagem', $_REQUEST['tarefa_percentagem']);
		$sql->adOnde('log_id='.(int)$obj->log_id);
		$sql->exec();
		$sql->limpar();
		}



	if ($_REQUEST['tarefa_realizado_antigo']!=$_REQUEST['tarefa_realizado']){
   
		$sql->adTabela('log');
		$sql->adAtualizar('log_reg_mudanca_realizado', getParam($_REQUEST, 'tarefa_realizado', null));
		$sql->adOnde('log_id='.(int)$obj->log_id);
		$sql->exec();
		$sql->limpar();
		
		if (!$aprova_registro){
	    $sql->adTabela('tarefas');
	    $sql->adAtualizar('tarefa_realizado', getParam($_REQUEST, 'tarefa_realizado', null));
	    $sql->adOnde('tarefa_id='.(int)$tarefa_id);
	    $sql->exec();
	    $sql->limpar();
			}
		}


	if ($_REQUEST['tarefa_status_antigo']!=$_REQUEST['tarefa_status']){
    $novo_status=getParam($_REQUEST, 'tarefa_status', null);
		
		$sql->adTabela('log');
		$sql->adAtualizar('log_reg_mudanca_status', $novo_status);
		$sql->adOnde('log_id='.(int)$obj->log_id);
		$sql->exec();
		$sql->limpar();
		
		if (!$aprova_registro){
			$sql->adTabela('tarefas');
			$sql->adAtualizar('tarefa_status', $novo_status);
			$sql->adOnde('tarefa_id='.(int)$tarefa_id);
			$sql->exec();
			$sql->limpar();
			}
		}



	$novo_fim=getParam($_REQUEST, 'oculto_data_fim', null).' '.getParam($_REQUEST, 'hora_fim', null).':'.getParam($_REQUEST, 'minuto_fim', null).':00';
	$novo_inicio=getParam($_REQUEST, 'oculto_data_inicio', null).' '.getParam($_REQUEST, 'inicio_hora', null).':'.getParam($_REQUEST, 'inicio_minutos', null).':00';

	if(($_REQUEST['tarefa_fim_antiga']!=$novo_fim) || ($_REQUEST['tarefa_inicio_antiga']!=$novo_inicio) || ($_REQUEST['tarefa_duracao']!=$_REQUEST['tarefa_duracao_antiga'])){
    $sql->adTabela('log');
		$sql->adAtualizar('log_reg_mudanca_inicio', $novo_inicio);
		$sql->adAtualizar('log_reg_mudanca_fim', $novo_fim);
		$sql->adAtualizar('log_reg_mudanca_duracao', (float)$_REQUEST['tarefa_duracao']);
		$sql->adOnde('log_id='.(int)$obj->log_id);
		$sql->exec();
		$sql->limpar();
    
    if (!$aprova_registro){
	    if($cache){
	      $nova_data_inicio = retorna_data($novo_inicio);
	      $nova_data_fim = retorna_data($novo_fim);
	      $nova_duracao = (float)getParam($_REQUEST, 'tarefa_duracao', null);
	      $dataInicial = strtotime(substr($novo_inicio,0,10));
	      $dataFinal = strtotime(substr($novo_fim,0,10));
	      $dias = ($dataFinal-$dataInicial);
	      if($dias > 0) $dias /= 86400;
	      $novo_numero_dias = round($dias,2);
	      $duracao = ($_REQUEST['tarefa_duracao']!=$_REQUEST['tarefa_duracao_antiga'] ? $nova_duracao : false);
	      if($duracao !== false){
	        $duracao *= (int)$config['horas_trab_diario'];
	        }
	      $cache->mudarDatasTarefa($tarefa_id, $novo_inicio, $novo_fim, $duracao);
	      }
	    else{
	      $sql->adTabela('tarefas');
	      $sql->adAtualizar('tarefa_dinamica', 0);
	      $sql->adAtualizar('tarefa_duracao_manual', getParam($_REQUEST, 'tarefa_duracao', null));
	      $sql->adAtualizar('tarefa_inicio_manual', $novo_inicio);
	      $sql->adAtualizar('tarefa_fim_manual', $novo_fim);
	      $sql->adAtualizar('tarefa_duracao', getParam($_REQUEST, 'tarefa_duracao', null));
	      $sql->adAtualizar('tarefa_inicio', $novo_inicio);
	      $sql->adAtualizar('tarefa_fim', $novo_fim);
	      $sql->adAtualizar('tarefa_marco', ($_REQUEST['tarefa_duracao'] > 0 ? 0 : 1));
	      $sql->adOnde('tarefa_id = '.(int)$tarefa_id);
	      $sql->exec();
	      $sql->limpar();
	      verifica_dependencias($tarefa_id);
	      //calcular_superior($tarefa_id);
	      }
			}
		}
		
  if($cache && $cache->flushToSession(false)){
    $cache->salvarCache($projeto_id);
    }

	//checar anexo

	$base_dir=($config['dir_arquivo'] ? $config['dir_arquivo'] : BASE_DIR);



	if(isset($_FILES['arquivo']['name'])){

		foreach($_FILES['arquivo']['name'] as $chave => $linha){
			if (file_exists($_FILES['arquivo']['tmp_name'][$chave]) && !empty($_FILES['arquivo']['tmp_name'][$chave])){
			  $pasta='log';
			  $tipo=strtolower(pathinfo($_FILES['arquivo']['name'][$chave], PATHINFO_EXTENSION));
			  $permitido=getSisValor('downloadPermitido');
			  $proibido=getSisValor('downloadProibido');
			  $verificar_malicioso=explode('.',$_FILES['arquivo']['name'][$chave]);
			 	$malicioso=false;
			 	foreach($verificar_malicioso as $extensao) {
			 		if (in_array(strtolower($extensao), $proibido)) {
			 			$malicioso=$extensao;
			 			break;
			 			}
			 		}
			 	if ($malicioso) {
			  	$Aplic->setMsg('Extenso '.$malicioso.' no  permitida!', UI_MSG_ERRO);
			  	}
			  elseif (!in_array($tipo, $permitido)) {
			  	$Aplic->setMsg('Extenso '.$tipo.' no  permitida! Precisa ser '.implode(', ',$permitido).'. Para incluir nova extenso o administrador precisa ir em Menu=>Sistema=>Valores de campos do sistema=>downloadPermitido', UI_MSG_ERRO);
			  	}
			  else {
					$sql = new BDConsulta;
					$sql->adTabela('log_arquivo');
					$sql->adCampo('count(log_arquivo_id) AS soma');
					$sql->adOnde('log_arquivo_log ='.$obj->log_id);
					$soma_total = 1+(int)$sql->Resultado();
					$sql->limpar();
					$dia=date('d');
					$mes=date('m');
					$ano=date('Y');
					if (!is_dir($base_dir)){
						$res = mkdir($base_dir, 0777);
						if (!$res) {
							$Aplic->setMsg('No foi possvel criar a pasta para receber o arquivo - mude as permisses na raiz de '.$base_dir, UI_MSG_ALERTA);
							return false;
							}
						}
					if (!is_dir($base_dir.'/arquivos')){
						$res = mkdir($base_dir.'/arquivos', 0777);
						if (!$res) {
							$Aplic->setMsg('No foi possvel criar a pasta para receber o arquivo - mude as permisses em '.$base_dir, UI_MSG_ALERTA);
							return false;
							}
						}
				 	if (!is_dir($base_dir.'/arquivos/'.$ano)){
						$res = mkdir($base_dir.'/arquivos/'.$ano, 0777);
						if (!$res) {
							$Aplic->setMsg('No foi possvel criar a pasta do ano para receber o arquivo - mude as permisses em '.$base_dir.'\arquivos', UI_MSG_ALERTA);
							return false;
							}
						}
					if (!is_dir($base_dir.'/arquivos/'.$ano.'/'.$mes)){
						$res = mkdir($base_dir.'/arquivos/'.$ano.'/'.$mes, 0777);
						if (!$res) {
							$Aplic->setMsg('No foi possvel criar a pasta do ms para receber o arquivo - mude as permisses em '.$base_dir.'\arquivos\\'.$ano, UI_MSG_ALERTA);
							return false;
							}
						}
					if (!is_dir($base_dir.'/arquivos/'.$ano.'/'.$mes.'/'.$dia)){
						$res = mkdir($base_dir.'/arquivos/'.$ano.'/'.$mes.'/'.$dia, 0777);
						if (!$res) {
							$Aplic->setMsg('No foi possvel criar a pasta do dia para receber o arquivo - mude as permisses em '.$base_dir.'\arquivos\\'.$ano.'\\'.$mes, UI_MSG_ALERTA);
							return false;
							}
						}
					$log_arquivo_nome_real = md5(uniqid(rand(), true));
				 	$caminho_completo = $base_dir.'/arquivos/'.$ano.'/'.$mes.'/'.$dia.'/'.$log_arquivo_nome_real;
					 move_uploaded_file($_FILES['arquivo']['tmp_name'][$chave], $caminho_completo);
				  if (file_exists($caminho_completo)) {
				  	$tipo=explode('/',$_FILES['arquivo']['type'][$chave]);
				  	$sql->adTabela('log_arquivo');
						$sql->adInserir('log_arquivo_log', $obj->log_id);
						$sql->adInserir('log_arquivo_nome', $_FILES['arquivo']['name'][$chave]);
						$sql->adInserir('log_arquivo_usuario', $Aplic->usuario_id);
						$sql->adInserir('log_arquivo_data', date('Y-m-d H:i:s'));
						$sql->adInserir('log_arquivo_ordem', $soma_total);
						$sql->adInserir('log_arquivo_tipo', $tipo[0]);
						$sql->adInserir('log_arquivo_extensao', $tipo[1]);
						$sql->adInserir('log_arquivo_nome_real', $log_arquivo_nome_real);
						$sql->adInserir('log_arquivo_local', $ano.'/'.$mes.'/'.$dia.'/');
						$sql->adInserir('log_arquivo_tamanho', $_FILES['arquivo']['size'][$chave]);
						if (!$sql->exec()) $Aplic->setMsg('No foi possvel inserir o anexos na tabela log_arquivo!', UI_MSG_ERRO);
						$sql->limpar();
				  	}
				  }
				}
			}
		}
		
	//sempre checar percentagem        
	calcular_superior($tarefa_id);                    
  atualizar_percentagem($projeto_id); 
	}

if ($dialogo){
	echo '<script type="text/javascript">';
    echo 'var resultado = {';
      echo 'id:'.$tarefa_id.',';
      echo 'inicio:'.($nova_data_inicio != null ? "\"".$nova_data_inicio."\"" : 'null').',';
      echo 'fim:'.($nova_data_fim != null ? "\"".$nova_data_fim."\"" : 'null').',';
      echo 'duracao:'.($nova_duracao != null ? $nova_duracao : 'null').',';
      echo 'dias:'.($novo_numero_dias != null ? $novo_numero_dias : 'null').',';
      echo 'percentagem:'.($nova_percentagem != null ? $nova_percentagem : 'null').',';
      echo 'status:'.($novo_status != null ? $novo_status : 'null');
    echo '};';
	echo 'if(window.parent && window.parent.gpwebApp && window.parent.gpwebApp._popupCallback) window.parent.gpwebApp._popupCallback(resultado);';
	echo 'else self.close();';
	echo '</script>';
	}
else $Aplic->redirecionar('m=tarefas&a=ver&tab=0&projeto_id='.$projeto_id.'&tarefa_id='.$tarefa_id);
exit();
?>